/* @(#) Copyright (c), 1987, 2006 Insightful Corp.  All rights reserved. */
/* @(#) $RCSfile: S_engine.h,v $: $Revision: #101 $, $Date: 2007/09/18 $  */

#ifndef S_S_H
#define S_S_H 1
/* NOTE: This file (S.h) is a "private-to-S" file.  It will include
         further .h files that are "public" header files (e.g. S+API or
         its users could include them).  In order to distinguish between
         the environments and workaround possible namespace collisions,
         the #define 'S_COMPATIBILITY' was invented.  It should be
         defined to get the old private names for various things. */
#define S_COMPATIBILITY 10

#if defined(lint) && defined(SUNOS5) && defined(S_LINT64)
/* Solaris's sys/types.h allows one to override size_t,ssize_t */
#define _SIZE_T
typedef unsigned long size_t ;
#define _SSIZE_T
typedef long  ssize_t;
#endif

#define SPLUS 1
#include <S_ansi.h>
#include "cdefs.h"

/* by default, S code is compiled according to Posix standards.  Some */
/* code is known to require extensions.  The corresponding code must */
/* set S_POSIX_EXTENSIONS before including S.h */
#ifndef S_POSIX_EXTENSIONS
/* ask for strict Posix compliance.  
 * AIX complains about redefining _POSIX_SOURCE, so undef first.
 */
#ifdef _POSIX_SOURCE
#undef _POSIX_SOURCE
#endif
#define _POSIX_SOURCE 1
#endif

#include <stddef.h>
#include <sys/types.h>
#if !defined(SPLUSDEVICE) && !defined(WINDOWS_CONFLICT)
#include <unistd.h>
#endif

#if (defined(SUNOS)) /* Get declarations for ecvt ( */
#include <floatingpoint.h>
#else
#include <stdlib.h>
/*
 * Some OS's, e.g. AIX 4.3, define abs in stdlib.h.  Need to undef.  -sea.
 */
#ifdef abs
#undef abs
#endif
#endif /* ) */

#define SBRK(p)	((char *)sbrk(p))
#define CURRENT_SBRK	SBRK(0)

#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <setjmp.h>
#include <math.h>
#include <ctype.h>
#include <signal.h>

#include "machine.h"	/* machine arithmetic constants */
#include "system.h"	/* operating system, compiler stuff */
#if defined(USE_NEWIO) /*(*/
#include "s_newio.h"
#include "newredef.h"
#endif /*)*/
#if defined(WIN32) /*(*/
#include "dos/dosredef.h"
#endif /*)*/

#include "S_struct.h"
#include "S_tokens.h"
#include "S_define.h"
#include "S_eval.h"  /* or eval.h ??? */
#include "S_spec.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifdef SPLUS
/*
 * Decide on how various systems are to handle fork()/vfork(). Since there may
 * be cases where vfork can't be used (even on systems that support it), setup
 * defines S_VFORK and S_FORK that can be used where their counterparts can.
 * If a system doesn't support vfork(), set S_VFORK to fork.
 */
#define S_fork fork
#if defined(Berkeley) || defined(HPPA) /*(*/
/* SAB 08/29/91 NOTE: This is NOT complete - Berkeley & HPUX are the ones I */
/*                    know of that support vfork.                           */
#define S_vfork vfork
#else /*)(*/
/* MJS 12/06/00: use fork on HP because vfork in engine breaks java         */
/*               graphics redisplay                                         */
#define S_vfork S_fork
#endif /*)*/

/* Time codes. See c_support.c:S_convert_date. */
#define EPOCH_INT_T	1
	/* seconds since midnight 1/1/70 GMT */
/* add other integer codes here, up to 9 */

#define ASC_STR_T	10
	/* asctime() format without the \n, "Sun Sep 16 01:03:52 1973" */
#define ABBREV_STR_T	11
	/* "73.09.16   1:03" */
	/* "73.09.16  11:03" */
/* add other string codes here, then change MAX_TIME_CODE */

#define MIN_TIME_CODE	EPOCH_INT_T
#define MAX_TIME_CODE	ABBREV_STR_T

/* ensure s_object's nalloc does not exceed maximum length for its mode */
#define LIMIT_MAXALLOC(n,m) {if((n)>max_length(m)) n=max_length(m);}
#endif

/*
 * Automatic casting of sizes to int or unsigned int,
 * for the C libraries.  These should be redefined
 * or even written as functions if an int is smaller
 * than a long, and if vector lengths might be longer
 * than what can be held in an int; for example, if
 * ints are 16 bits and longs are 32 bits.
 */
#define Memcpy(p,q,n)	memcpy((char *)(p),(char *)(q),(size_t)((n)*sizeof(*(p))))
/* Memcpy for non-overlapping memory areas; Memmove if overlap is */
/* possible */
#define Memmove(p,q,n)  memmove((char *)(p),(char *)(q),(size_t)((n)*sizeof(*(p))))
#define Memset(p,c,n)   memset((void *)(p), c, ((n)*sizeof(*p)))
#define Memcmp(p,q,n)   memcmp((void *)(p),(void *)(q),(size_t)((n)*sizeof(*(p))))
#define Qsort(p,n,c)	qsort((char *)(p),(int)(n),sizeof(*(p)),c)
#define Fread(p,n,f)	((f) ? fread((char *)(p),sizeof(*(p)),(int)(n),f) : \
	(Recover("System error: null file for reading",NULL_ENTRY,S_evaluator),0))
#define Fwrite(p,n,f)	((f) ? fwrite((char *)(p),sizeof(*(p)),(int)(n),f) : \
	(Recover("System error: null file for writing",NULL_ENTRY,		 S_evaluator),0))


/* macro to identify modes for which ref. counts can be inserted into */
/* the value pointer (should always also be accompanied by a test for */
/* mapped objects, which do reference counting differently) */
#define REF_COUNT_MODE(t) (((t) <= S_MODE_MAX_ATOMIC && ref_count_modes[t]) || (t)==S_MODE_STRUCTURE ||\
			   ((t) >= S_FIRST_TOKEN && t <= S_LAST_TOKEN && !(S_token_info[t-S_FIRST_TOKEN]&2)))

/* error code for S_debug, long jumps */
#define SIGSERROR 1000

/* extended alpha list */
#define ISALPHA(p) (isalpha((int)(unsigned char)(p)) || (p)=='.')

/* a fixed maximum, used for coding things like UNKNOWN, for SHIFT_FRAME in
   moving data, and as a check against runaway database allocation */
#define MAX_DB		200000

/* For overriding standard library attachments */
#define STDLIB_OVERRIDE "SV4_SEARCH_PATH"

/* Platform specific value of the path separator */
#ifdef WIN32
#define S_SLASH  '\\'
#else
#define S_SLASH  '/'
#endif

#define REPLACE(obj) s_copy_if_needed(obj, get_current_evaluator())
#define PROTECT(obj) (obj = s_protect_object(obj, S_evaluator))


/* This definition allows the S object of class name to be used as an */
/* s_name object.  It MUST be true that the two structs agree in the */
/* first four slots (the name class uses nalloc as a probe). Otherwise */
/* the cast below would need to do some actual conversion. */
#define AS_NAME(p) (p->mode == NAME ? (s_name *)(p) : \
  (Recover("internal error: invalid cast to name", p, S_evaluator), (s_name *)0))

/* In the other direction, creating a new name in make_name always */
/* makes a corresponding S object, which alc_name will return */
#define AS_NAME_OBJECT(p) (s_object *)(p)

/* to set a name member of an s_object, we try to always use the text */
/* member of a valid s_name object.  It would be nice to be able to */
/* assume that all names DO have this form, but there is a lot of old */
/* code around that doesn't conform.  The following definition should */
/* at least be used in all new or revised code to set name members */
#define SET_NAME_TEXT(object, p) ((object)->name = (char *)make_name(p, S_evaluator)->text)
#define SET_NAME(object, p) ((object)->name = (char *)(p->text))
#define S_NAME_DEBUG 1

#define DOT_DATA (char *)(Data_name->text)
#define DOT_DIM (char *)(Dim_name->text)
#define DOT_DIMNAMES (char *)(Dimnames_name->text)
#define DOT_NAMES (char *)(Names_name->text)
#define DOT_TSP (char *)(Tsp_name->text)
#define DOT_LABEL (char *)(Label_name->text)
#define DOT_DOT_DOT (char *)(Dots_name->text)

#define CLASS_AS_CHAR(cl) (cl->vec ? cl->vec : make_class_as_char(cl, S_evaluator))
#define CLASS_REF_FLAG 02  /* dangerous to unset */

/* it might seem more natural for HAS_SLOTS to use cl->nslots, but this is */
/* deliberately left >0 by unsetClasses, so that a change in the number of */
/* slots during a session can be detected and warned about */

#define HAS_MODE_CLASS(p) ((p)->Class == tok_classes[(p)->mode] ? \
 S_TRUE : (tok_classes[(p)->mode] ? S_FALSE : ((p)->Class == token_class((p)->mode, S_evaluator))))

#define CLASS_FROM_INDEX(i) ((i) > 0 ? Classes_structs[i-1] : (s_class *)NULL)

#define LOAD_PROC(name) {SYMBOL(name), (void *)name}
#define LOAD_F_PROC(name) {FSYMBOL(name), (void *)F77_SUB(name)}


/* some general definitions for pointers to s_object's */

#define IS_VOID(p)	((p)==NULL_ENTRY||(p)==S_void||(p)->mode==MISSING)
/* THE_SAME tests for identical object references.  The requirement of equal
   length may be stronger than needed, but in those cases just testing
   equal value pointers should be enough */
#define THE_SAME(x, y)	((x)==(y) || \
	((x) && (y) && (x)->value.name == (y)->value.name && (x)->length == (y)->length))
#define IDENTICAL(x, y) (s_identical_objects(x, y) == blt_in_TRUE)

#define NA_STRING		s_na_string

#define Child1(p)		(*((p)->value.tree))
#define Child2(p)		(*((p)->value.tree+1))
#define Child3(p)		(*((p)->value.tree+2))

/* defines for function definitions */
#define n_formal_args(p) ((p)->length-1)
#define function_body(p) ((p)->value.tree[(p)->length-1])

/* defines for function calls */
#define ARGS(ent)		(((ent)->value.tree)+1)
#define NARGS(ent)		((ent)->length-1)
#define Arg1(p)			(*((p)->value.tree+1))
#define Arg2(p)			(*((p)->value.tree+2))
#define ARG(p, n)		(*((p)->value.tree+(n)))
#define data_mode(p)		((atomic_type(p->mode))?p->mode : Data_mode(p, S_evaluator))
#define data_length(p)		((atomic_type(p->mode))?p->length : Data_length(p,S_evaluator))


/* cases for rec_check */
#define REC_INIT		0
#define REC_ADD			1
#define REC_DELETE		2
#define REC_CHECK		3


#define EXTRA_FRAMES    	2L
#define OLD_S_FRAME		-1L
#define META0                   -1L
/* some codes used by which_frame and its callers */
#define NO_FRAME		-MAX_DB-4L
#define UNKNOWN_FRAME		-MAX_DB-5L
#define COMP_FRAME		-MAX_DB-6L
/* some numbers used by the evaluation code in moving value
   (pop_frame, move_value, cleanup_value) */
#define MIN_FRAME		-MAX_DB-2L
#define SHIFT_FRAME		2*(dbStorageAllocated + max_frames + MAX_DB +2)
   /* a number big enough so shifting a storage frame number back this
      much produces something < MIN_FRAME */

/* for lint: force c to be used/meaningful */
#ifdef	lint
extern void NONEXISTENT(void *);
#define	UNUSED(c)	NONEXISTENT((char *)(long)c)
#define MEANINGFUL(c)	c = 0; UNUSED(c)
#else
#define	UNUSED(c)
#define MEANINGFUL(c)
#endif

/* #if !defined(NO_ELAN_LICENSE) && !defined(NO_FLEX_LICENSE) */
#if !defined(NO_ELAN_LICENSE) || !defined(NO_FLEX_LICENSE)

#define WARNINGOUTPUT    0
#define RECOVEROUTPUT    1
#define STDERROUTPUT     2
#endif

/* how to put a C routine on the end-of-session action list */
#define ON_QUIT(f) add_exit(f, PERM_FRAME, S_evaluator)

/* macros for accessing, setting attributes from C */
/* STANDARD_CLASS is the equivalent of testing for a NULL class */
/* attribute in Version 3 of S */
#define STANDARD_CLASS(x) ((x)->Class == token_class( (x)->mode, S_evaluator))
/* make sure class gets reset when mode does */
#define SET_MODE(p, m) ((p)->mode = m, (p)->Class = token_class(m,S_evaluator))
#define GET_EL(x,i,mode) (x->value.mode)[i]

/* some coercion to builtin vector types */
#define AS_STRING(x) s_any_to_string(x);

/* scalar values */
#define STRING_VALUE(x) string_value(x, S_evaluator)

#define LOOKUP_SLOT(cl,n) ((int)name_lookup(n, (cl)->slots_table, (int *)0))
#define SLOT_REF(p, i) ((p)->value.tree[i])

/* hide use of name field in header.  Someday this will have to guess */
/* at the object name somehow. */
#define OBJECT_NAME(p) ((p)->name)


/* The use of VECTOR_DATA with Version 3 structure is a bit dicey. */
/* The fundamental assumption is that pointers (at least to mulit-byte */
/* data types) are scaled compatibly.  Generally, alignment is not a */
/* problem since the allocation mechanism uses malloc, which is */
/* guaranteed to allocate in alignable addresses */
#define VECTOR_DATA(p) ((p)->value.tree)
#define OBJECT_DATA(p) ((p)->value.tree)


/* codes used in how_found: read_data returns which_db*MAX_HOW_READ + how*/
enum how_read {FROM_DB_FILE, FROM_MEMORY_TABLE, FROM_OBJECTS_TABLE,
  MAX_HOW_READ};

/* formats for constructing various meta-data names.  Must agree with the */
/* corresponding functions, classMetaName(), methodsName() */
#define METHOD_META_NAME_FORMAT "M#%s"
#define CLASS_META_NAME_FORMAT "C#%s"
#define CLASS_VERSION_NAME_FORMAT "V#%s"

/* This definition must be consistent with the `slots' slot in the */
/* class definition for class "methodsGeneric" */
enum methodSlots {SIGNATURES_SLOT, DEFINITIONS_SLOT, TESTMETHODS_SLOT,
	TESTSEMANTIC_SLOT, TESTDEFINITIONS_SLOT, DEFAULT_SLOT, GENERIC_SLOT,
	GENERICDEF_SLOT, GROUP_SLOT, VALUECLASS_SLOT};
#define N_METHOD_SLOTS VALUECLASS_SLOT+1

/* the slots in the signature slot of the above methods definition */
enum signatureSlots {SIG_ARGS_SLOT, SIG_CLASSES_SLOT, SIG_SIGNAMES_SLOT , SIG_ARG_NAMES_SLOT};

/* the slots in a semantic state object, as used to store the individual */
/* methods definitions */

/* The slots in a semanticMethod object.  Down to NOTES, inherited */
/* from a semanticState object.  **Must** be kept consistent with */
/* class definitions for these classes */
enum semanticSlots {M_BODY_SLOT, M_CURRENT_SLOT, M_GLOBAL_SLOT,
	M_ASSERTIONS_SLOT, M_ASSIGNMENTS_SLOT,
	M_KNOWN_SLOT, M_EXTERNAL_SLOT, M_RETURN_SLOT, M_NEEDSFRAME_SLOT,
	M_AMBIGUOUS_SLOT, M_VALUECLASS_SLOT, M_NOTES_SLOT,
	M_SIGNATURE_SLOT, M_DEFINITION_SLOT, M_GENERIC_SLOT,
		      M_GROUP_SLOT, M_NAME_SLOT, M_COMPILED_SLOT};
#define N_M_SLOTS M_COMPILED_SLOT+1

/* the slots in a class representation object */

#define N_C_SLOTS 8
enum classSlots {C_SLOTS_SLOT, C_CONTAINS_SLOT, C_VIRTUAL_SLOT, C_DECLARATION_SLOT,
	C_PROTOTYPE_SLOT, C_VALIDITY_SLOT, C_ACCESS_SLOT, C_SLOT_NAMES_SLOT };

/* the slots in some standard classes */
enum tsSlots {TS_DATA_SLOT, TS_TSP_SLOT = 1};
enum categorySlots {CATEGORY_DATA_SLOT, CATEGORY_LEVELS_SLOT=1};

/*
 * Bill Dunlap's fix to convert floating point -0 to 0.  It should be
 * used when printing floating point numbers so you don't get "-0".
 */
#define FIX_TYPED_ZERO(d, type) ((d)==(type)0. ? (type)0. : (d))
#define FIX_ZERO(d) FIX_TYPED_ZERO(d, double)

#define CHECK_OBJ(obj, msg) do_check_obj(obj, msg, S_evaluator)
 
#define sanity(p,c) Sanity(p,c,S_evaluator)

#ifdef __cplusplus
}
#endif
#include "S_extern.h"
#endif
