/* @(#) Copyright (c), 1987, 2006 Insightful Corp.  All rights reserved. */
/* @(#) $RCSfile: S_extern.h,v $: $Revision: #179 $, $Date: 2008/07/24 $  */
/***
   NAME     S_extern.h
   PURPOSE  This file contains extern function declarations which were
            in the old S.h.  The first of these functions are required 
            to use the public macros which are defined in S_define.h or
            they are functions which are mentioned in Splus manuals or 
            books by Chambers or Venables and Ripley.
 
***/
#ifndef S_EXTERN_H
#define S_EXTERN_H 1

#include "S_struct.h"
#include "S_eval.h"
#include "compiler.h"
#include "libext.h"
S_begin_extern_c

/* get_structure_size: register the size of any C typedef so that 
 * that type of data can be stored in a "raw" S object.  */
LibExtern void S_STDCALL store_structure_size(char *what, size_t size, s_evaluator *S_evaluator);
LibExtern size_t S_STDCALL get_structure_size(char *what, s_evaluator *S_evaluator);

/* call_S: call an S function from C */
LibExtern void * S_STDCALL call_S(s_object *func, long nargs, char **arguments, 
   char **modes, long *lengths, char **names, long nres, char **values);

/* seed_in: read seed from .Random.seed if seed_data is NULL */
LibExtern void S_STDCALL seed_in(long *seed_data, s_evaluator *S_evaluator);
/* seed_out: write seed out to .Random.seed dataset */
LibExtern void S_STDCALL seed_out(long *seed_data, s_evaluator *S_evaluator);
/* setseed: like S function set.seed() */
LibExtern void S_STDCALL setseed(long *seed);
/* norm_rand: generate one standard normal random number */
LibExtern RETURN_DOUBLE S_STDCALL norm_rand(s_evaluator *S_evaluator);
/* unif_rand: generate one uniform random number */
LibExtern RETURN_DOUBLE S_STDCALL unif_rand(s_evaluator *S_evaluator);
/* S_log1p(x) := log(x+1).  log1p is in libm on all unix, but not on Windows yet */
LibExtern RETURN_DOUBLE S_STDCALL S_log1p(double x);
/* S_expm1(x) := exp(x)-1.  expm1 is in libm on all unix, but not on Windows yet */
LibExtern RETURN_DOUBLE S_STDCALL S_expm1(double x);
/* log(exp(logx)+exp(logy)) without unnecessary over- or underflow */
LibExtern RETURN_DOUBLE S_STDCALL S_logspace_add(double logx, double logy);
/* log(exp(logx)-exp(logy)) without unnecessary over- or underflow */
LibExtern RETURN_DOUBLE S_STDCALL S_logspace_subtract(double logx, double logy);

LibExtern RETURN_DOUBLE S_STDCALL S_fmin2(double x, double y);
LibExtern RETURN_DOUBLE S_STDCALL S_fmax2(double x, double y);
LibExtern long S_STDCALL S_imin2(long x, long y);
LibExtern long S_STDCALL S_imax2(long x, long y);

LibExtern void S_STDCALL S_echo_string(char *s);

/**** Functions and global variables which are used **** 
 ****        in macros found in S_define.h          ****/

/* standard classes */
LibExtern s_class
  *s_numeric_class, *s_integer_class, *s_list_class, *s_logical_class,
  *s_single_class,  *s_complex_class, *s_character_class, *s_raw_class,
  *s_function_class, *s_name_class, *s_matrix_class, *s_array_class,
  *s_category_class,  *s_named_class, *s_vector_class, *s_virtual_class,
  *s_ANY_class, *s_parse_class, *s_parseTest_class, *s_NULL_class, *s_expression_class,
  *s_class_rep_class, *s_methodsGeneric_class, *s_replace_class,
  *s_semanticMethod_class, *s_methodRef_class, *s_structure_class,
  *s_ts_class, *s_quit_class, *s_string_class, *s_regularExpression_class;

LibExtern s_object *S_void;

LibExtern float sPosInf, sNegInf, sNaN, sNA;
LibExtern double dPosInf, dNegInf, dNaN, dNA;
LibExtern long S_logical_NA, S_integer_NA ;
LibExtern char *S_character_NA ; /* not really used: for R compatibility */

/* Functions to use instead of malloc, calloc, realloc and free */
LibExtern void * S_STDCALL S_ok_calloc(size_t n, size_t size, s_evaluator *S_evaluator);
LibExtern void * S_STDCALL S_ok_malloc(size_t n, s_evaluator *S_evaluator);
LibExtern void   S_STDCALL S_ok_free(void *s, s_evaluator *S_evaluator);
LibExtern void * S_STDCALL S_ok_realloc(void *s, size_t n, s_evaluator *S_evaluator);

/* Allocate storage in current evaluation frame */
LibExtern void * S_STDCALL S_alloc(long n, size_t size, s_evaluator *S_evaluator);
LibExtern void * S_STDCALL S_alloc_no_s_evaluator(long n, size_t size); /* for R-compat */
LibExtern void * S_STDCALL S_malloc(size_t size, s_evaluator *S_evaluator);
LibExtern void * S_STDCALL S_realloc(void *p, long New, long old, size_t size, s_evaluator *S_evaluator);
LibExtern long   S_STDCALL free_block(void *p, s_evaluator *S_evaluator);
/* Init or turn on/off local heap */
LibExtern long S_STDCALL s_localHeap_init(long bOn);
LibExtern void * S_STDCALL S_alloc_values(int mode, long length, s_evaluator *S_evaluator);
LibExtern void * S_STDCALL S_alloc_values_u(int mode, long length, s_evaluator *S_evaluator);
LibExtern void * S_STDCALL S_realloc_values(void *p, long New, int mode, long length, s_evaluator *S_evaluator);
LibExtern void * S_STDCALL S_realloc_values_u(void *p, long New, int mode, long length, s_evaluator *S_evaluator);
LibExtern void   S_STDCALL realloc_char(char **return_string, char *new_value, long new_length, s_evaluator *S_evaluator);

LibExtern void S_STDCALL free_header(s_object *v, s_evaluator *S_evaluator);
LibExtern int S_STDCALL is_valid_header(s_object *p, s_evaluator *S_evaluator);

#if defined(lint) && defined(SUNOS5)
/* Solaris's note.h allows alignment assertions about malloc-like functions */
#include <note.h>
NOTE(ALIGNMENT(S_ok_calloc,8))
NOTE(ALIGNMENT(S_ok_malloc,8))
NOTE(ALIGNMENT(S_ok_realloc,8))
NOTE(ALIGNMENT(S_alloc,8))
NOTE(ALIGNMENT(S_malloc,8))
NOTE(ALIGNMENT(S_realloc,8))
NOTE(ALIGNMENT(S_alloc_values,8))
NOTE(ALIGNMENT(S_alloc_values_u,8))
NOTE(ALIGNMENT(S_realloc_values,8))
NOTE(ALIGNMENT(S_realloc_values_u,8))
#endif

LibExtern s_object * S_STDCALL copy_data(s_object *ent, s_object *frame,  s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL s_protect_object(s_object *obj, s_evaluator *S_evaluator);

LibExtern s_class * S_STDCALL make_class_and_rep(const char *what, s_evaluator *S_evaluator);
LibExtern int S_STDCALL find_class_rep(s_class * cl, s_evaluator *S_evaluator);

LibExtern int S_STDCALL get_slot_offset(s_class *cl, char *what, s_evaluator *S_evaluator);
LibExtern int S_STDCALL find_slot_position(s_object *object, s_object *slot, s_evaluator *S_evaluator);

/* functions used by macros ERROR, WARNING, RECOVER, PRINT_IT,... */
LibExtern void S_STDCALL Recover(char *message, s_object *ent, s_evaluator *S_evaluator);
LibExtern void S_STDCALL Warning(char *message, s_object *ent, s_evaluator *S_evaluator);
LibExtern void S_STDCALL S_terminate(char *msg);
LibExtern long S_STDCALL print_message(char *msg, long pos, S_FILE *file, s_evaluator *S_evaluator);
LibExtern long S_STDCALL print_err_message(char *msg, long pos, FILE *file_ptr, s_evaluator *S_evaluator);
LibExtern int S_STDCALL audit_print_buf(void);
LibExtern void S_STDCALL ok_flush(S_FILE *f, s_evaluator *S_evaluator);

LibExtern int S_STDCALL stack_probe_ok(void);
LibExtern void S_STDCALL stack_probe_do_stop(char* str);
LibExtern void S_STDCALL stack_probe_check(char* str);

LibExtern void S_STDCALL S_n_problems(long *n_errors, long *n_warnings);
LibExtern void S_STDCALL S_report_problem_summary(FILE *f);
LibExtern long S_STDCALL S_incr_n_session_errors(void);

LibExtern s_object * S_STDCALL xact_comp(s_object *data, char *name, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL set_dim(s_object *data, s_object *dim);
LibExtern s_object * S_STDCALL set_dimnames(s_object *data, s_object *dimnames);
LibExtern s_object * S_STDCALL get_dimnames_el(s_object *x, long i,  s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL set_levels(s_object *data, s_object *levels, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL get_names(s_object *data);
LibExtern s_object * S_STDCALL set_names(s_object *data, s_object *namesa);

LibExtern void S_STDCALL s_set_class_to_class(s_object *dataset, s_class *c, s_evaluator *S_evaluator);
LibExtern void S_STDCALL set_length2(s_object *data, long l,  s_evaluator *S_evaluator);
LibExtern long S_STDCALL get_length2(s_object *obj, s_evaluator *S_evaluator);
LibExtern void S_STDCALL s_set_element(s_object *object, int where, s_object *value, s_evaluator *S_evaluator);

LibExtern s_object * S_STDCALL ASlist(s_object *object);
LibExtern s_object * S_STDCALL coevec(s_object *actual, int dmode, int do_check, int precious, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL alcvec(int mode, long length, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL new_S_object(s_class *Class, s_evaluator *S_evaluator);

LibExtern int S_STDCALL S_char_to_lgl(char *c, long *l);
LibExtern int S_STDCALL logical_value(s_object *ent, s_object *from, s_evaluator *S_evaluator);
LibExtern long S_STDCALL long_value(s_object *ent, s_object *from, s_evaluator *S_evaluator);
LibExtern RETURN_DOUBLE S_STDCALL double_value(s_object *ent, s_evaluator *S_evaluator);
LibExtern float S_STDCALL real_value(s_object *ent, s_evaluator *S_evaluator);
LibExtern char * S_STDCALL string_value(s_object *ent, s_evaluator *S_evaluator);

LibExtern long S_STDCALL S_get_logical_scalar(s_object *ent, const char *name, int call_error, int call_warning, int na_ok, s_evaluator *S_evaluator);
LibExtern long S_STDCALL S_get_integer_scalar(s_object *ent, const char *name, int call_error, int call_warning, int na_ok, s_evaluator *S_evalautor) ;
LibExtern RETURN_DOUBLE S_STDCALL S_get_numeric_scalar(s_object *ent, const char *name, int call_error, int call_warning, int na_ok, s_evaluator *S_evalautor) ;
LibExtern char** S_STDCALL S_get_string_scalar(s_object *ent, const char *name, int call_error, int call_warning, int na_ok, s_evaluator *S_evalautor) ;

LibExtern s_object * S_STDCALL x_data_slot(s_object *ent, long *n_p, s_evaluator *S_evaluator);

LibExtern void S_STDCALL s_set_element(s_object *object, int where, s_object *value, s_evaluator *S_evaluator);

LibExtern s_boolean S_STDCALL s_check_data(s_object *x, enum s_mode_types which, s_evaluator *S_evaluator);

LibExtern s_object * S_STDCALL Eval_in_frame(s_object *expr, int frame, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL set_in_frame(long nframe, s_object *value, s_name *name, s_evaluator *S_evaluator);
LibExtern s_boolean S_STDCALL S_remove_from_frame(long nframe, s_name *name, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL get_data(s_name *this_name,  s_evaluator *S_evaluator);

LibExtern s_name * S_STDCALL make_name(const char *name, s_evaluator *S_evaluator);

LibExtern int S_STDCALL isObjectIndex(s_object *object, int classIndex, s_class *from, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL as_class(s_object *object, s_class *to, s_boolean check);

LibExtern char * S_STDCALL c_s_cpy(const char *name, s_evaluator *S_evaluator);
 
/*************** S-PLUS private functions and variables ********************/

typedef s_boolean (*s_cmp_fun)(s_index i, s_index j, s_evaluator *S_evaluator);
typedef struct s_object_struct *(*s_vfun_ptr)();
 
#if defined(S_COMPATIBILITY) /* ( */
typedef s_boolean (*cmp_fun)(s_index, s_index, s_evaluator*);
typedef struct s_object_struct *(*vfun_ptr)();
#if S_COMPATIBILITY >= 10  /*(*/
#define s_cmp_fun cmp_fun
#define s_vfun_ptr vfun_ptr
#endif /* ) */
#endif /* ) S_COMPATIBILITY */

/***   these are required by S+SDK object library   ***/
/* called by S functions */
LibExtern s_object * S_STDCALL s_get_classes_def (void); /* called by getClasses */
LibExtern s_object * S_STDCALL checkIsObject(s_object *, s_object *); /* called by inherits */

LibExtern char * S_STDCALL old_token_name (int mode, s_evaluator *S_evaluator);
LibExtern int S_STDCALL old_mode_lookup (char *name, s_evaluator *S_evaluator);
LibExtern int S_STDCALL token_class_mode (s_class *cl, s_evaluator *S_evaluator);
LibExtern long S_STDCALL test_sign (char *, int);

LibExtern char * S_STDCALL token_name (int, s_evaluator *);
LibExtern int S_STDCALL mode_lookup (char *, s_evaluator *);
LibExtern int S_STDCALL mode_size(int mode);
LibExtern long S_STDCALL min_length(int mode);
LibExtern long S_STDCALL max_length(int mode);
LibExtern void S_STDCALL zero_numsize(struct numsize *ns, int n);
LibExtern int S_STDCALL numstat(double x, int ndigit, struct numsize *stat);
LibExtern void S_STDCALL prnum(double x, int field, struct numsize *stat, char *s);

LibExtern s_class ** tok_classes;

/* standard name definitions */
LibExtern s_name *Data_name, *Dim_name, *Dimnames_name, *Tsp_name,
  *Names_name, *Label_name, *Dots_name, *Empty_name;

LibExtern int S_STDCALL name_eq(const char *s1, const char *s2, s_evaluator *S_evaluator);
LibExtern void S_STDCALL make_formats (void);
LibExtern void S_STDCALL set_full_precision (long *);
LibExtern void S_STDCALL gt(char *x, long *S, long d[], long *K, long pi[]);
LibExtern s_class * S_STDCALL make_s_class(const char *name, const int index, s_evaluator *S_evaluator);
LibExtern s_class * S_STDCALL get_s_class(const char *name, s_evaluator *S_evaluator);

LibExtern s_object * S_STDCALL New_vector( s_evaluator *S_evaluator);
LibExtern void S_STDCALL try_to_free(s_object *object, int recursive, int local_frame, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL alc_name(const char *name, s_evaluator *S_evaluator);
/* YB: Confict with the GUI: scl/c_supprt.cpp, temp commenting out*/
#if !defined(WIN32)
LibExtern void S_STDCALL nprime(long *nn);
#endif
LibExtern unsigned long S_STDCALL charmash(const char *p);
LibExtern long S_STDCALL x_which_comp(char *name, s_object *data, s_evaluator *S_evaluator);

LibExtern s_object *blt_in_MISSING, *blt_in_NA, *blt_in_NaN, *blt_in_TRUE, *blt_in_FALSE;
LibExtern s_object *blt_in_NULL, *blt_in_Inf , *blt_in_1,*blt_in_empty, *blt_in_Dots;
 
LibExtern s_class * S_STDCALL token_class(int mode, s_evaluator *S_evaluator);
LibExtern s_index S_STDCALL name_lookup(s_name *what, s_name_table *table, int *enter_here);
LibExtern s_index S_STDCALL text_lookup(const char *name, int *probe, s_name_table *table,
   int *enter_here, s_evaluator *S_evaluator);
 
#ifdef str_utilsDEFINE
#define vextern LibExport
#else
#define vextern LibExtern
#endif /* str_utilsDEFINE */
 
vextern char *Integer_format, *Single_format, *Double_format, *Complex_format;

#undef vextern

/********* Private S stuff **********/
#if !defined(SapiObjLIBRARY)  /* || !defined(S_GUI_BUILD) or something??? */

extern s_class *s_common_class;
extern s_class *s_internal_symbol_class;
extern s_class *s_attached_class, *s_database_class;

extern s_boolean ref_count_modes[];
extern s_boolean booting_S; /* see data.c */

/* called by S functions */
/* extern s_object *S_masked(s_object *call, s_object *arglist,s_evaluator *S_evaluator);
extern s_object *S_names_in_dir(s_object *ent, s_object *arglist); */
LibExtern s_object * S_STDCALL do_default_pgm(s_object *con_obj); /* called by standardReader */
LibExtern s_object * S_STDCALL s_get_object_class(s_object *names_obj, s_object *where_obj,
   s_object *meta_obj);
LibExtern s_object * S_STDCALL s_ref_count(s_object *x);
LibExtern s_object * S_STDCALL s_c_frame_names(s_object *frame_obj, s_object *meta_obj);
LibExtern s_object * S_STDCALL s_unset_generics(s_object *what, s_object *where);
LibExtern s_object * S_STDCALL reset_generic(s_object *names);  /* called by resetGeneric */
LibExtern s_object * S_STDCALL s_set_indent(s_object *indents); /* called by setIndent */
LibExtern const char* S_STDCALL true_file_name(const char *name, long db, int action, s_evaluator *S_evaluator);
LibExtern long S_STDCALL search_pos_lookup(long j, s_evaluator *S_evaluator);

/* Structure for holding command line options and arguments */
typedef struct _CommandLineArgs {
  char *reload_path;
  char *S_init_file;
  char **argv;
  int argc;
} CommandLineArgs;
extern CommandLineArgs CmdArgs;

LibExtern void S_STDCALL name_table_clear(s_name_table *t);
LibExtern long name_table_entries(s_name_table *t);
LibExtern long S_STDCALL S_db_count(long lDB, s_db_purposes dbPurpose);
LibExtern s_db_purposes S_STDCALL S_db_purpose(long index);

/* tname structures for storing strings during an S task, specifically */
/* between an eval_init and an eval_clear */
/* If name's and tname's are to be used together, the classes must */
/* agree in the first three members and tname_class must distinguish */
/* the two cases */
LibExtern void S_STDCALL clear_tnames(void);
LibExtern void S_STDCALL init_tnames(void);
LibExtern void S_STDCALL tname_enter(s_tname *what, s_name_table *table, int pos, s_index value);

extern char *s_na_string; /* owned by stringClass.c */
extern s_object *S_ptree;
extern s_object *cons_frame, *alias_frame, *loop_variable_frame;
extern s_object *C_wrapup;
extern s_object *frame0, *meta0, *deflt_class;
extern long n_database, n_db_alloc;
extern char *shome, *user_home;
extern char load_time[];
extern char *sbrk0;

extern long Integer_length, Single_length, Double_length, Complex_length;
extern int db_level;
extern int s_verbose ;
extern int last_signal, doing_list, runit_pid, mainpid, S_lex_debug;
extern int Initialized, sinkpipe, in_old_S;
extern int S_init_completed;
extern int S_allocation;
extern int in_deparse;

/* MemCheckFile stuff */
extern FILE *MemCheckFile;
extern char *MemSbrk;

extern void set_client_signal(int sig);

LibExtern void S_STDCALL abb_names(char **names, long *nnames, long *minlen, long *use_class_p, long *unique_p);

LibExtern s_object * S_STDCALL s_any_to_string(s_object *object);

LibExtern s_object * S_STDCALL S_attribute(s_object *data, s_object *which_attr, s_object *replacement);
extern RETURN_DOUBLE binary_search(double which, double *table, long n);
LibExtern void S_STDCALL binning(double *x, long *nx, double *brks, long *nbrks);
LibExtern void S_STDCALL cleanup_call_S(void *ptr);
#include "S_sig.h"
/*
 * Type of value returned by a signal handler is void by
 * default.  This can be overridden by typedef'ing it in
 * system.h for the particular machine, and then #define'ing
 * S_SIG_DEFINED.  Also, type of the signal handler itself.
 */

extern S_sig catchall(int i);
extern void clock_init(void);

LibExtern void S_STDCALL S_control_floating_point(long *cw, long *mask);
LibExtern int S_STDCALL S_init_floating_point(void) ;

LibExtern int S_STDCALL cmpx_cmp(s_complex *i, s_complex *j);
LibExtern s_object * S_STDCALL  cmpx_op(s_object *e1, char *op, s_object *e2);
LibExtern void S_STDCALL color_fill(double hue[], double lightness[], double saturation[]);
LibExtern void S_STDCALL comp_init(void);
LibExtern void S_STDCALL cx_conj(s_complex z[], long *n);
LibExtern s_boolean S_STDCALL S_do_search(char* objname, int DBpos);
LibExtern s_object * S_STDCALL  db_read_default(s_object *call, s_object *arglist);
LibExtern s_object * S_STDCALL  db_write_default(s_object *call, s_object *arglist);
LibExtern s_object * S_STDCALL  Default_pgm(s_object *ent, s_object *arglist);

extern void F77_SUB(cseedi)(long *i);
extern void F77_SUB(cseedo)(long *i);
extern void F77_SUB(fabort)(void);
extern long F77_SUB(getds)(long *Sname, long *pos);
extern void F77_SUB(putds)(long *Sname, long *entry, long *pos);
extern void F77_SUB(qcopy)(long *from, long *to, long *length, long *mode);
extern void F77_SUB(zejecz)(void);
LibExtern void S_STDCALL zejecz_c(void);
#ifdef WIN32
	extern int F77_SUB(zerrpz)(F_CHARTYPE code, long, F_CHARTYPE msg);
#else
	extern void F77_SUB(zerrpz)(F_CHARTYPE code, F_CHARTYPE msg);
#endif
LibExtern void S_STDCALL zflshz_c(void);
extern void F77_SUB(zflshz)(void);
extern void F77_SUB(zhookz)(long *type, float *x, long *n, float *y, long *m);
LibExtern void S_STDCALL zinitz_c(void);
extern void F77_SUB(zinitz)(void);
extern void F77_SUB(zintrz)(void);
extern void F77_SUB(zlengz)(F_CHARTYPE text, float *inches);
LibExtern void S_STDCALL zlinez_c(long *ix, long *iy);
extern void F77_SUB(zlinez)(long *ix, long *iy);
LibExtern void S_STDCALL zlinsz_c(float *x, float *y, long *n);
extern void F77_SUB(zlinsz)(float *x, float *y, long *n);
LibExtern void S_STDCALL zpntsz_c(float *x, float *y, long *n);
extern void F77_SUB(zpntsz)(float *x, float *y, long *n);
LibExtern void S_STDCALL zpolyz_c(float *x, float *y, long *n);
extern void F77_SUB(zpolyz)(float *x, float *y, long *n);
LibExtern void S_STDCALL zptchz_c(char *ich, float *crot);
extern void F77_SUB(zptchz)(F_CHARTYPE ich, float *crot);
LibExtern void S_STDCALL zrdpnz_c(float *x, float *y, long *n, long *nmax);
extern void F77_SUB(zrdpnz)(float *x, float *y, long *n, long *nmax);
LibExtern void S_STDCALL zseekz_c(long *ix, long *iy);
extern void F77_SUB(zseekz)(long *ix, long *iy);
LibExtern void S_STDCALL zsegsz_c(float *x, float *y, float *x2, float *y2, long *n);
extern void F77_SUB(zsegsz)(float *x, float *y, float *x2, float *y2, long *n);
extern void F77_SUB(zwrapz)(void);

     /*
      * BEGIN ----- The Fortran prototypes. The ones used by newgraph library
      * that were not defined in $SHOME/include/S_externs.h mjb 06.27.06
      */

     LibExtern void S_STDCALL F77_NAME(devvaxiszdone) (long *iside);
     extern long S_STDCALL F77_NAME(devvaxisz) (
						                long *iside,
						                float *xllab,
					                      float *xlline,
						                float *u,
						                float *ulabs,
						                long *labs,
						                long *nl,
						                long *lena,
					                      long *iwhich);
     LibExtern void S_STDCALL F77_NAME(bxstat) (float *sorted, long *n, long *nout, float *p, float *statv, float *conf, float *c);
     LibExtern void S_STDCALL F77_NAME(narang) (float *z, long *nz, float *zn, float *zx);
     LibExtern void S_STDCALL F77_NAME(scaler) (float *x, float *y, float *z, long *nob, long *ncolumns, float *inches, float *x1, float *x2, float *y1, float *y2, long *nsc);
     LibExtern void S_STDCALL F77_NAME(transf) (float *x, float *y, float *z, long *nob, long *ncolumns, float *inches, long *nsc);
     LibExtern void S_STDCALL F77_NAME(conver) (float *x, float *y, float *z, long *nob, long *ncolumns, float *x1, float *x2, float *y1, float *y2, float *inches, long *nsc);
     LibExtern void S_STDCALL F77_NAME(circs) (float *x, float *y, float *z, long *nob);
     LibExtern void S_STDCALL F77_NAME(rects) (float *x, float *y, float *w, float *h, long *nob);
     LibExtern void S_STDCALL F77_NAME(strs) (float *x, float *y, float *z, long *nob, long *ncolumns);
     LibExtern void S_STDCALL F77_NAME(therms) (float *x, float *y, float *z, long *nob, long *ncolumns, float *inches);
     LibExtern void S_STDCALL F77_NAME(boxes) (float *x, float *y, float *z, long *nob, long *ncolumns, float *inches);
     LibExtern void S_STDCALL F77_NAME(rever) (float *ang, long *nbx);
     LibExtern void S_STDCALL F77_NAME(rangem) (float *h, long *n, long *ndiv, long *nbar, float *al, float *au);
     LibExtern void S_STDCALL F77_NAME(rangev) (float *s, long *n, float *min, float *max);
     LibExtern void S_STDCALL F77_NAME(rangec) (float *s, long *n, float *min, float *max);
     LibExtern void S_STDCALL F77_NAME(bardrw) (float *height, long *ndiv, long *nbar, float *sp, float *w, float *amn, float *amx, float *avw, long *inside, long *horiz);
     LibExtern void S_STDCALL F77_NAME(bhtchz) (float *height, long *ndiv, long *nbar, float *center, float *w, long *horiz, long *nbx, float *fill, float *ang, float *den);
     LibExtern void S_STDCALL F77_NAME(barset) (float *height, long *ndiv, long *nbar, long *npset, float *space, long *nspace, float *width, long *nwidth, float *sp, float *w, float *bmn, float *bmx, float *amn, float *amx, float *avw, float *xverg, float *center, long *blocks);

     LibExtern void S_STDCALL ztextz_c(float *x, float *y, char *text, long *n, float *adj);
#if defined(NOEXTRAS)
     LibExtern void S_STDCALL F77_NAME(ztextz) (float *x, float *y, F_CHARTYPE text, long implicit_text_len, long *n, float *adj);
#else
     LibExtern void S_STDCALL F77_NAME(ztextz) (float *x, float *y, F_CHARTYPE text, long *n, float *adj, long implicit_text_len);
#endif

     LibExtern void S_STDCALL F77_NAME(lclipz) (float *xi, float *yi, float *bx, float *by, float *x, float *y, long *jint);
     LibExtern void S_STDCALL F77_NAME(zmtouz) (long *iside, float *line, float *z);
     LibExtern void S_STDCALL F77_NAME(legnpz) (float *z, float *coord, F_CHARTYPE text, float *adj);
     LibExtern void S_STDCALL F77_NAME(zpowrz) (float *u1, float *aa, long *ka);
     LibExtern void S_STDCALL F77_NAME(setaxz) (long *iside, float *xllab, float *xlline, long *leng, float *adj, float *srt);
     LibExtern void S_STDCALL F77_NAME(tsaxpz) (long *iside, float *xllab, float *xlline, float *y1, float *y2, long *nl, float *period, long *leng, long *isw);
     LibExtern void S_STDCALL F77_NAME(vaxisz) (long *iside, float *xllab, float *xlline, float *, float *, long *is, long *n, long *leng, long *isw);
     LibExtern void S_STDCALL F77_NAME(saxisz) (long *, long *, long *);
     LibExtern void S_STDCALL F77_NAME(taxisz) (long *, long *, long *);
     LibExtern void S_STDCALL F77_NAME(laxisz) (long *, long *, long *);
#if defined(NOEXTRAS)
     LibExtern void S_STDCALL F77_NAME(logaxz) (long *iside, F_CHARTYPE istyle, long implicit_istyle_length, float *min, float *max, long *n, long *isw);
     LibExtern void S_STDCALL F77_NAME(stdaxz) (long *iside, F_CHARTYPE istyle, long implicit_istyle_length, float *min, float *max, long *n, long *isw);
     LibExtern void S_STDCALL F77_NAME(timaxz) (long *iside, F_CHARTYPE istyle, long implicit_istyle_length, float *min, float *max, long *n, long *isw);
#else
     LibExtern void S_STDCALL F77_NAME(logaxz) (long *iside, F_CHARTYPE istyle, float *min, float *max, long *n, long *isw, long implicit_istyle_length);
     LibExtern void S_STDCALL F77_NAME(stdaxz) (long *iside, F_CHARTYPE istyle, float *min, float *max, long *n, long *isw, long implicit_istyle_length);
     LibExtern void S_STDCALL F77_NAME(timaxz) (long *iside, F_CHARTYPE istyle, float *min, float *max, long *n, long *isw, long implicit_istyle_length);
#endif
     LibExtern void S_STDCALL F77_NAME(naxy2) (float *x, float *y, long *n, float *xmin, float *xmax, float *ymin, float *ymax, long *logx, long *logy);
     LibExtern void S_STDCALL F77_NAME(uscale) (float *x, long *n, float *y);
     LibExtern void S_STDCALL F77_NAME(typlot) (float *x, float *y, long *n, F_CHARTYPE type);
     LibExtern void S_STDCALL F77_NAME(rsetmf) (void);
     LibExtern void S_STDCALL F77_NAME(setmf) (long *narg, float *aratio, long *max, long *m, long *k, long *byrow);
     LibExtern void S_STDCALL F77_NAME(spcexz) (float *cex);	/* SPcex */
     LibExtern void S_STDCALL F77_NAME(gnarcz) (float *cx, float *cy, float *rd, float *ang1, float *ang2, float *xx, float *yy, long *nseg);
     LibExtern void S_STDCALL F77_NAME(dmarkz) (float *x, float *y, long *n, long *value);
     LibExtern void S_STDCALL F77_NAME(zobdsz) (F_CHARTYPE msg, float *x, float *y);
     LibExtern void S_STDCALL F77_NAME(pointz) (float *x, float *y, long *nseg);
     LibExtern void S_STDCALL F77_NAME(hdlinz) (float *x, float *y, long *nseg);
     LibExtern void S_STDCALL F77_NAME(linesz) (float *x, float *y, long *nseg);
     LibExtern void S_STDCALL F77_NAME(segmtz) (float *x, float *y, float *x2, float *y2, long *n);
     LibExtern void S_STDCALL F77_NAME(hatch) (float *x, float *y, long *nseg, float *val, float *slope_angle);
     LibExtern void S_STDCALL F77_NAME(textz) (float *t1, float *t2, F_CHARTYPE text);
     LibExtern void S_STDCALL F77_NAME(mtextz) (long *t1, float *t2, F_CHARTYPE text);
     LibExtern void S_STDCALL F77_NAME(gtextz) (long *iside, float *xline, float *coord, F_CHARTYPE text);
     LibExtern void S_STDCALL F77_NAME(intz) (float *x, float *y, long *index);
     LibExtern void S_STDCALL F77_NAME(realz) (float *x, float *y, float *avalue);
     LibExtern void S_STDCALL F77_NAME(beginz) (void);
     LibExtern void S_STDCALL F77_NAME(spcsiz) (float *v1);
     LibExtern void S_STDCALL F77_NAME(logtrn) (float *v1, long *n);
     LibExtern void S_STDCALL F77_NAME(zarowz) (float *x, float *y, float *x2, float *y2, float *w, long *open, long *rel);
     LibExtern void S_STDCALL F77_NAME(stars) (float *x, long *n, long *full, long *scale, long *radius, F_CHARTYPE type, F_CHARTYPE labels, long *nlavel, F_CHARTYPE head, long *max, long *byrow, long *m, long *k);
     LibExtern void S_STDCALL F77_NAME(spomoz) (long *value);
     
     LibExtern void S_STDCALL F77_NAME(zuintz) (float *umina, float *umaxa, long *npa, float *dist);
     LibExtern void S_STDCALL F77_NAME(zutomz) (float *pos, long *side, float *line);
#ifdef S_DECLARE_F77_SORT
     LibExtern void S_STDCALL F77_NAME(sort) (float *p, long *n);
#endif
     LibExtern void S_STDCALL F77_NAME(sortpr) (float *p, long *n, float *labels);
     LibExtern void S_STDCALL F77_NAME(sortp) (float *p, long *n, long *labels);
     LibExtern void S_STDCALL F77_NAME(boxz) (void);
     LibExtern void S_STDCALL F77_NAME(usabdy) (float *x, float *y, long *n, long *iseg);
     LibExtern void S_STDCALL F77_NAME(rdtfmt) (float *u, long *nl, long *leng, long *wid, long *dec);
     LibExtern void S_STDCALL F77_NAME(zzcsmz) (long *);
     LibExtern void S_STDCALL F77_NAME(zzpltz) (void);
     LibExtern void S_STDCALL F77_NAME(zzfigz) (void);
     LibExtern void S_STDCALL F77_NAME(quomiz) (float *v1, float *v2, float *v3, float *v4);
     LibExtern void S_STDCALL F77_NAME(spomiz) (float *v1, float *v2, float *v3, float *v4);
     LibExtern void S_STDCALL F77_NAME(spomaz) (float *v1, float *v2, float *v3, float *v4);
     LibExtern void S_STDCALL F77_NAME(quomaz) (float *v1, float *v2, float *v3, float *v4);
     LibExtern void S_STDCALL F77_NAME(mfrowz) (float *v1, float *v2);
     LibExtern void S_STDCALL F77_NAME(mfcolz) (float *v1, float *v2);

     /*
      * END ---- The Fortran prototypes. The ones used by newgraph library
      * that were not defined in $SHOME/include/S_externs.h mjb 06.27.06
      */

/* #if !defined(NO_ELAN_LICENSE) && !defined(NO_FLEX_LICENSE) */
#if !defined(NO_ELAN_LICENSE) || !defined(NO_FLEX_LICENSE)

extern void S_message_box (char* message, char* title, int buttons, int output_code);
#endif

LibExtern int GetInputBytes(char *s, int n, char *whence);
LibExtern int SendOutBytes(const char *buf, long nbytes, char *type);
LibExtern long S_is_license_managed_version(void);
LibExtern void removeAllMap(const char* pszFileName);
LibExtern int S_isyes(char *str);

LibExtern s_object * S_STDCALL fnd_data(s_object *ent);
LibExtern s_object * S_STDCALL S_get_attrs(s_object *Temp);
LibExtern void S_STDCALL get_audit_file(char **p);
LibExtern s_object * S_STDCALL get_dim(s_object *data);
LibExtern s_object * S_STDCALL get_dimnames(s_object *data);
LibExtern void S_STDCALL get_last_message(char **buf);
LibExtern s_object * S_STDCALL get_local(char *this_name, long hint);
LibExtern s_object * S_STDCALL get_S_entry(s_object *ent);
LibExtern s_object * S_STDCALL get_token(s_object *ent, s_object *arglist);
extern void gr_signalled(void);
LibExtern int  S_STDCALL has_names(s_object *data);
LibExtern void S_STDCALL hlsrgb(double h, double l, double s, float *r, float *g, float *b);
LibExtern void S_STDCALL ichar(char **strings, long *nstr, long *codes);
LibExtern s_object * S_STDCALL image_scale(s_object *call, s_object *arglist);
#if defined(LINUX)
/* LibExtern RETURN_DOUBLE S_STDCALL lgamma(double x); don't redeclare this on Linux, in math.h */
#else
LibExtern RETURN_DOUBLE S_STDCALL lgamma(double x);
#endif
/* log(abs(gamma(x))) */
LibExtern RETURN_DOUBLE S_STDCALL S_lgamma(double x) ;
/* The next is for when gamma(x)<0: it also sets *sign=-1 if gamma(x)<0. */
LibExtern RETURN_DOUBLE S_STDCALL S_lgamma_sign(double x, long *sign) ; 

LibExtern void S_STDCALL make_fields(long *columns, long *ncolumns, char **infile, char **outfile, char **sep_p, long *blank_p);

LibExtern void S_STDCALL verify_object(s_object *object, char **msg);
LibExtern void S_STDCALL verify_object_or_unclass(s_object *object, s_verify_level level);
LibExtern void S_STDCALL malloc_resetp(void);
LibExtern void S_STDCALL memcat(char **s);
LibExtern void S_STDCALL mem_size(long *n);
LibExtern void S_STDCALL S_max_mem_size(long *n);

LibExtern void S_STDCALL open_for_rescale(char *filename, long *dims);
LibExtern int  S_STDCALL op_action(char *op_name, long length);
LibExtern void S_STDCALL polygon_matrix(float *x, long *nx, float *y, long *ny, float *color);
LibExtern void S_STDCALL pop_brk(void);

LibExtern s_object * S_STDCALL S_ctime_time(void);
LibExtern RETURN_DOUBLE S_STDCALL proc_time(void);
LibExtern void S_STDCALL rgbhls(double r, double g, double b, float *h, float *l, float *s);
LibExtern void S_STDCALL send_self(long *sig);
LibExtern s_object * S_STDCALL  getDefaultMethod(s_object *index);
LibExtern void S_STDCALL set_indent(char **strings, long *nstrings);
LibExtern int S_STDCALL set_repl_alloc(s_object *object);
LibExtern s_object * S_STDCALL  Sfun(s_object *call, s_object *sfun_ptr, s_object *frame);
LibExtern void S_STDCALL stamp_audit(char **string);
LibExtern char * S_STDCALL s_strerror(int n) ;


LibExtern void S_STDCALL S_dump(char **path_arg, char **names, long *n_arg, long *pos, long
*meta, long *old_style_p);
LibExtern void S_STDCALL True_file_name(char **name_p, long *db_p, long *write_p);
LibExtern void S_STDCALL S_file_mod_time(char **name, long *pos, long *meta,long *time);
LibExtern int S_STDCALL is_directory(char *name);
LibExtern int S_STDCALL S_is_symlink(char *name);
LibExtern int S_STDCALL is_file(char *name);
LibExtern int S_STDCALL is_absolute_path(char *path);
LibExtern char * S_STDCALL pathel(char *s);
LibExtern const char * S_STDCALL S_basename(char *input, char *extension);
LibExtern char * S_STDCALL S_internal_realpath(const char *path);
LibExtern char * S_STDCALL S_internal_realpath_ex(const char *path, const char *style);

LibExtern void S_STDCALL call_ask(void);
/* below are also in graphics.h */
LibExtern s_object * S_STDCALL  S_cur_pic(s_object *ent, s_object *arglist);
LibExtern s_object * S_STDCALL  S_gr_disp(s_object *ent, s_object *arglist);
LibExtern s_object * S_STDCALL  S_gr_set(s_object *ent, s_object *arglist);
LibExtern s_object * S_STDCALL  S_gr_things(s_object *ent, s_object *arglist);

/* In eval.c.  Used by the Java graphics device */
LibExtern long S_STDCALL S_get_top_level_counter(void);
LibExtern void S_STDCALL S_increment_top_level_counter(void);

/* Define the erf and erfc functions from random.c. */
/*#if defined(WIN32) || defined(LINUX) */
#if defined(WIN32) /*(*/
#define erf_is_not_in_math_library
double erf(double x);
double erfc(double x);
#elif defined(LINUX) /*(*/
/*
double erf(double x);
double erfc(double x);
*/
#else /*)(*/
extern double erf(double x) ;
extern double erfc(double x);
#endif /*)*/

#ifdef SPLUS
/* stucture for old-style hash tables */
typedef struct s_x_h_struct {
    char *name;
    long index;
    struct s_x_h_struct *next;
} s_x_h;

/* YB: Confict with the GUI: scl/c_supprt.cpp, temp commenting out*/
#if !defined(WIN32)
LibExtern int S_STDCALL do_hash(char *name,s_x_h **h_ptr,long *probe_p, s_x_h** hash_table,
  long hash_length, char **name_p);
LibExtern int S_STDCALL S_hash(char *name, int mode, long *index, long *pos, 
   s_x_h **hash_table, long hash_length);
LibExtern int S_STDCALL S_hash_ex(char *name, int mode, long *index, long *pos, 
   s_x_h **hash_table, long hash_length, s_object *x, s_object *list);
LibExtern void S_STDCALL hash_enter(char *name, int mode, long index, long pos, 
   s_x_h **hash_table, long hash_length);
LibExtern void S_STDCALL hash_enter_ex(char *name, int mode, long index, long pos, 
   s_x_h **hash_table, long hash_length, s_object *x, s_object *list);
#endif
#endif
#if defined(DOS386) /*(*/
LibExtern void S_STDCALL fixup_SHOMEenv(char *shome);
#endif /*)*/
LibExtern void S_STDCALL S_init(int argc, char *argv[]); 
LibExtern int S_STDCALL S_putenv(char *string);
LibExtern void S_STDCALL S_rd_line(char **strings, long *nitem); 
LibExtern void S_STDCALL S_restore(char **path_arg, long *print_a, long *db_pos);
LibExtern void S_STDCALL S_sink(char **file, long *pipe, long *append);
LibExtern void S_STDCALL testing_nlist(long *answer);
LibExtern long S_STDCALL unlex_len(char *s);
LibExtern s_object * S_STDCALL  version2_to_Internal(s_object *call, s_object *other_name);
LibExtern long S_STDCALL which_comp(char *name, s_object *ent);
LibExtern char * S_STDCALL whoami(void);

extern s_class *make_valid_ts(s_object *obj, s_object *tsp);
extern s_class *make_valid_category(s_object *obj, s_object *levels);


LibExtern s_object * S_STDCALL  do_AT_GETS(s_object *object, s_object *slot, s_object *value);
LibExtern s_index S_STDCALL index_lookup(s_index what, s_index_table *t, int *enter_here);

LibExtern s_index S_STDCALL index_lookup_f(s_index what, s_index_table *t, int *enter_here,
			      s_cmp_fun f,  s_evaluator *S_evaluator);
LibExtern s_index S_STDCALL Index_lookup(s_index what, s_index_table *t, int *enter_here, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  NO_NAME(s_object *v, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  S_STDCALL s_header_for_object(s_object *p, long *frame_p, s_evaluator *S_evaluator);


LibExtern s_object * S_STDCALL  assign_obj(s_name *name, s_object *object, s_object *old, int perm, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  cur_call(long nframe, s_evaluator *S_evaluator);
extern char * cur_fun_name(long nframe, int deparse,  s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  S_do_options_expression(char *name, s_evaluator *S_evaluator);
LibExtern void S_STDCALL do_stop(int error, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  eval(s_object *ent, s_evaluator *S_evaluator);
LibExtern long S_STDCALL make_frame(s_object *val, s_evaluator *S_evaluator);
LibExtern void S_STDCALL new_frame(s_object *frame, s_object *call, s_name_table *ftable, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  parent_data(long gen,  s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  pop_frame(s_object *val, s_evaluator *S_evaluator);
LibExtern void S_STDCALL set_frame(long New, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  S_amatch(s_object *ent, s_object *arglist, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  S_assign(s_object *ent, s_object *arglist,  s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  S_c_fun_args(s_object *call, s_object *def);
LibExtern s_object * S_STDCALL  S_c_use_method(s_object *fname);
LibExtern s_object * S_STDCALL  S_debug(s_object *ent, s_object *arglist, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  S_dummy(s_object *ent, s_object *arglist, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  S_method(s_object *ent, s_object *arglist, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  S_switch(s_object *ent, s_object *arglist, s_evaluator *S_evaluator);
LibExtern void S_STDCALL warn_message(s_evaluator *S_evaluator);
LibExtern s_boolean S_STDCALL   warn_title(int warn_count, s_boolean errors, char *ret_title);
LibExtern s_object * S_STDCALL  warn_format(s_object *warn_list, FILE *file_ptr, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL function_and_body(s_object *obj, s_object **body,
	s_object **semantic, s_name_table **f_names, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  S_c_frame_method(s_object *fname, s_object *frame, s_object *call);

LibExtern s_object * S_STDCALL  S_colon(s_object *ent, s_object *arglist, s_evaluator *);
LibExtern s_object * S_STDCALL  S_list(s_object *ent, s_object *arglist, s_evaluator *);
LibExtern s_object * S_STDCALL  S_unlist(s_object *ent, s_object *arglist, s_evaluator *);
LibExtern s_object * S_STDCALL  As_vector(s_object *ent, s_object *arglist, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  Is_vector(s_object *ent, s_object *arglist, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  S_cat(s_object *ent, s_object *arglist, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  S_parse(s_object *ent, s_object *arglist, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  S_put(s_object *ent, s_object *arglist, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  S_paste(s_object *ent, s_object *arglist, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  S_match(s_object *ent, s_object *arglist, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  S_new_vector(s_object *ent, s_object *arglist, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  S_obj_size(s_object *ent, s_object *arglist, s_evaluator *S_evaluator);
LibExtern long       S_STDCALL  obj_size(s_object *ent) ;
LibExtern s_object * S_STDCALL  S_deparse(s_object *ent, s_object *arglist, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  S_dictionary(s_object *ent, s_object *arglist, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  S_dtype(s_object *ent, s_object *arglist, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  S_system(s_object *ent, s_object *arglist, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  S_interface(s_object *ent, s_object *arglist, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  S_rcbind(s_object *ent, s_object *arglist, s_evaluator *S_evaluator);
/* This never seems to be used either in the S functions or in the C tables. */
LibExtern s_object * S_STDCALL  S_unprotect(s_object *ent, s_object *arglist, s_evaluator *S_evaluator);

/* Random number generation routines */
LibExtern s_object * S_STDCALL  S_pfuns(s_object *ent, s_object *arglist, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  S_dfuns(s_object *ent, s_object *arglist, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  S_qfuns(s_object *ent, s_object *arglist, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  S_rfuns(s_object *ent, s_object *arglist, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  S_sample(s_object *ent, s_object *arglist, s_evaluator *S_evaluator);

/* comp_util routines for doing the math operators, etc. */
LibExtern s_object * S_STDCALL  S_do_op(s_object *ent, s_object *arglist, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  do_math(s_object *ent, s_object *arglist, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  do_summary(s_object *ent, s_object *arglist, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  S_na_funs(s_object *ent, s_object *arglist, s_evaluator *S_evaluator);


LibExtern s_object * S_STDCALL  S_element(s_object *call, s_object *arglist, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  S_el_named(s_object *call, s_object *arglist, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  S_dynload(s_object *ent, s_object *arglist, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  S_extract(s_object *ent, s_object *arglist, s_evaluator *S_evaluator);


LibExtern s_object * S_STDCALL  S_class(s_object *ent, s_object *arglist, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  S_replace(s_object *ent, s_object *arglist, s_evaluator *S_evaluator);
LibExtern void S_STDCALL command_prompt(char *prompt_text, FILE *prompt_file);
LibExtern void S_STDCALL set_history_prompt(void);
LibExtern s_object * S_STDCALL  S_scan(s_object *ent, s_object *arglist, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  S_sort_list(s_object *ent, s_object *arglist, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  S_split_atomic(s_object *ent, s_object *arglist, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  S_storage(s_object *ent, s_object *arglist, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  S_sync(s_object *ent, s_object *arglist, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  S_get(s_object *ent, s_object *arglist, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  S_rep(s_object *ent, s_object *arglist, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  S_database(s_object *call, s_object *arglist,  s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  S_version(s_object *ent, s_object *arglist, s_evaluator *S_evaluator);

LibExtern void S_STDCALL set_dollar(s_object *data, s_object *comp, s_object *repl_val, s_evaluator *S_evaluator);

LibExtern void S_STDCALL del_comp(s_object *data, long which, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  set_attr(s_object *data, char *name, s_object *replacement, s_evaluator *S_evaluator);

LibExtern void S_STDCALL set_mode2(s_object *data, int m, char *mode_string, s_evaluator *S_evaluator);
LibExtern void S_STDCALL s_set_comp(s_object *data, char *name, s_object *value,  s_evaluator *S_evaluator);

LibExtern s_class * S_STDCALL make_valid_array(s_object *obj, int coerce, s_object *dim,
				 s_object *dimnames, s_evaluator *S_evaluator);

LibExtern void S_STDCALL set_class(s_object *dataset, s_object *repl_val, s_evaluator *S_evaluator);

/* Should be in classes.h but needs eval.h */
LibExtern void S_STDCALL add_contained_paths(s_class *cl, s_object *contains, s_object *frame, s_evaluator *S_evaluator);

LibExtern void S_STDCALL stderr_flush(s_evaluator *S_evaluator);
LibExtern void S_STDCALL stdout_flush(s_evaluator *S_evaluator);


LibExtern void S_STDCALL set_ref_count(s_object *obj, int count, s_evaluator *S_evaluator);
LibExtern void S_STDCALL incr_ref_count(s_object *obj, s_boolean recursive, s_object *frame, s_evaluator *S_evaluator);
LibExtern s_index_table * S_STDCALL index_table_alloc(long length, double open_ratio, long frame, s_evaluator *S_evaluator);

LibExtern void S_STDCALL index_table_free(s_index_table *t, s_evaluator *S_evaluator);
LibExtern s_name_table * S_STDCALL frame_table(int frame, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  append_data(s_object *current, long which, long nnew, char *newdata, s_evaluator *S_evaluator);
LibExtern int S_STDCALL bad_header(s_object *p, char *msg, s_evaluator *S_evaluator);
LibExtern int S_STDCALL check_this_arena(char *message, long i, s_evaluator *S_evaluator);
LibExtern void S_STDCALL clear_alloc(long i, s_evaluator *S_evaluator);
LibExtern long S_STDCALL menu(char **names, long nnames, char *title, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  S_menu(s_object *ent, s_object *arglist, s_evaluator *S_evaluator);
LibExtern long S_STDCALL set_alloc(long n, s_evaluator *S_evaluator);
LibExtern void S_STDCALL set_perm_ref(s_object *obj, s_object *frame, s_evaluator *S_evaluator);

LibExtern void S_STDCALL decr_ref_count(s_object *obj, s_boolean recursive, s_object *frame, s_evaluator *S_evaluator);
LibExtern void S_STDCALL decr_in_frame(s_object *this_data, s_boolean recursive, s_object *frame, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL s_copy_for_replace(s_object *dataset, s_object *repl_val, s_evaluator *S_evaluator);
LibExtern void S_STDCALL index_enter(s_index what, s_index_table *t, int pos,s_index value, s_evaluator *S_evaluator);
LibExtern void S_STDCALL index_unhash(s_index what, s_index_table *t, s_evaluator *S_evaluator);
LibExtern void S_STDCALL Index_unhash(s_index what, s_index_table *t, s_evaluator *S_evaluator);
LibExtern void S_STDCALL Index_enter(s_index what, s_index_table *t, int pos, s_index value, s_evaluator *S_evaluator);
LibExtern void S_STDCALL index_table_walk(s_index_table *t, long *pos_p, s_index *key_p, s_index *value_p);
LibExtern long S_STDCALL next_db_frame(s_evaluator *S_evaluator);

/* the s_name_table's associated with the frames themselves */
LibExtern s_object * S_STDCALL frame_lookup(s_name *what, int frame, s_evaluator *S_evaluator);

LibExtern void S_STDCALL check_frame(long nframe, char *msg, s_evaluator *S_evaluator);
LibExtern char * S_STDCALL check_obj(s_object *v, s_evaluator *S_evaluator);

LibExtern s_boolean S_STDCALL check_data_overflow(int mode, long length1, long length2, long length3, s_boolean do_recover);
LibExtern s_object * S_STDCALL  find_data(s_name *this_name, s_boolean readit, s_boolean local, s_evaluator *S_evaluator);

/* from db.c */
	
LibExtern int S_STDCALL s_cached_objects_init(void);
LibExtern int S_STDCALL s_unhashed_init(void);
LibExtern int S_STDCALL s_unhashed_add(s_object* ps_object);
LibExtern int S_STDCALL s_unhashed_removeAll(void);
LibExtern s_boolean S_STDCALL S_is_temp_db(long pos, s_evaluator *S_evaluator);
LibExtern void S_STDCALL data_wrap(s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  db_objects(s_object *ent, s_object *arglist);
LibExtern int S_STDCALL data_clear(int error, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL read_data(const char *name, s_boolean hash_now, int read_it,
     int into_frame, int where, s_db_purposes meta, int *how_found, 
     s_evaluator *S_evaluator, const s_boolean lock);
LibExtern s_object * S_STDCALL read_data_ex(const char *name, s_boolean hash_now, int read_it,
     int into_frame, int where, s_db_purposes meta, int *how_found, 
     s_evaluator *S_evaluator, const s_boolean lock, const s_boolean look_in_asgn_table);
LibExtern s_object * S_STDCALL db_put_data(const char *name, long db, s_object *ent,  s_evaluator *S_evaluator);
LibExtern void S_STDCALL dir_synchronize(int pos, s_evaluator* S_evaluator);
LibExtern void S_STDCALL do_rm(s_name *name, long which, s_boolean warned, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL db_table_lookup(s_name *name, long which_db, s_evaluator *S_evaluator);
LibExtern void S_STDCALL detach_data_frame(s_evaluator *S_evaluator);
LibExtern int S_STDCALL s_database_position_from_storage_frame(int storage, s_evaluator *S_evaluator);
#if defined(USE_NOTIFICATION) /*(*/
/* Gets, and possibly sets, the state of "are notifications enabled for this */
/* evaluator?". */
LibExtern int S_STDCALL SNotifyState(int set_state, s_evaluator *S_evaluator);
#define SGetNotifyState(x) SNotifyState(-1,x)
#endif /*)*/

LibExtern void S_STDCALL flush_data(int error, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  S_sh_dp(s_object *ent, s_evaluator *S_evaluator);
LibExtern long S_STDCALL which_frame(s_object *frame, int eval_only, s_evaluator *S_evaluator);

LibExtern s_object * S_STDCALL  find_comp(s_object *ent, char *name, s_evaluator *S_evaluator);

LibExtern s_object * S_STDCALL  S_remove(s_object *ent, s_object *arglist, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  class_fun(char *group_name, char *call_name, s_object *call, s_object *arglist, s_object *object, s_object **call_ptr,  s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  class_op(char *group_name, char *call_name, s_object *call, s_object *arglist, s_object **call_ptr, int use_first_method, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  get_next_method(char *call_name, s_object *object, s_object *old_call, s_object *next_call, s_evaluator *S_evaluator);

LibExtern int S_STDCALL meta_db_position(int j, s_evaluator *S_evaluator);
LibExtern int S_STDCALL path_strings_eq(char *string1, char *string2, long as_path);
LibExtern char * S_STDCALL find_method(char *fname, char *group_name, s_object **p_class_attr,
          int *p_by_group, char **mname_p, s_evaluator *S_evaluator);

LibExtern s_class * S_STDCALL s_modernize_class(s_object *ent, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  make_old(s_object *object, s_evaluator *S_evaluator);


#ifndef S_C_ERROR_HANDLER_T_DEFINED
typedef void (*s_c_error_handler_t)(s_evaluator *S_evaluator);
#endif
LibExtern void S_STDCALL add_error(s_c_error_handler_t fun, s_evaluator *S_evaluator);
LibExtern void S_STDCALL add_exit(s_c_error_handler_t fun, long frame, s_evaluator *S_evaluator);
LibExtern void S_STDCALL del_error(s_c_error_handler_t fun,  s_evaluator *S_evaluator);
LibExtern s_boolean S_STDCALL has_error(s_c_error_handler_t fun,  s_evaluator *S_evaluator);

LibExtern void S_STDCALL do_old_classes(s_object *obj, s_evaluator *S_evaluator);
LibExtern void S_STDCALL put_data(const char *name, long pos, s_object *ent, s_evaluator *S_evaluator);

LibExtern s_object * S_STDCALL make_class_as_char(s_class *cl, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL method_def_signature(s_class **argClass, int nargs, s_object
			**argValues, mtable *table, s_boolean complete, s_evaluator *S_evaluator);
LibExtern s_index S_STDCALL locate_method_signature(s_class **argClass, int nargs, 
          s_object **argValues, mtable **table, s_index *index, s_evaluator *S_evaluator);
LibExtern mtable * S_STDCALL get_generic(s_name *name, s_evaluator *S_evaluator);

LibExtern void S_STDCALL mtable_walk(mtable *generic, int *classes, int nclasses, long *pos_p, s_index *value_p) ;

LibExtern void S_STDCALL add_reverse_path(s_class *cl, s_class *to_class, int which_virtual, s_evaluator *S_evaluator);


LibExtern s_object * S_STDCALL method_body_signature(s_class **argClass, int nargs,
   s_object **argValues, mtable *methods, s_name_table **m_names_p, s_evaluator *S_evaluator);

LibExtern void S_STDCALL replace_dots(s_object *call, long *which, s_object *arglist, s_evaluator *S_evaluator);

LibExtern s_object * S_STDCALL  s_internal_symbol(s_object *from, enum s_interface_type language, s_evaluator *S_evaluator);
LibExtern s_entry_point * S_STDCALL s_get_entry_point(s_name *name, enum s_interface_type type, s_evaluator *S_evaluator);
LibExtern int S_STDCALL add_interface_info_to_entry_point(s_entry_point *ep, s_evaluator *S_evaluator);
LibExtern void S_STDCALL s_trace_entry_point(char **name, char **language, long *ep_trace); /* called from .C */
LibExtern long S_STDCALL s_trace_dot_call(long *new_trace_flag); /* call from .C */
LibExtern long S_STDCALL s_trace_dot_internal(long *new_trace_flag); /* call from .C */
LibExtern void S_STDCALL s_clear_entry_points(void) ;

/* From classes.h */
LibExtern void S_STDCALL init_coerce(s_evaluator *S_evaluator);
LibExtern void S_STDCALL insert_slot_names(s_object *data, s_class *cl, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL promote_contained_replacement(s_object *obj, s_object *value);
LibExtern void S_STDCALL unset_paths(s_class *from, s_class_path *p, s_evaluator *S_evaluator);
LibExtern s_boolean S_STDCALL isClassIndex(int i, int j, s_boolean maybe, s_index *p, s_evaluator *S_evaluator);
LibExtern void S_STDCALL unset_class_rep(s_class *cl, s_evaluator *S_evaluator);
LibExtern void S_STDCALL token_classes_init(s_evaluator *S_evaluator);

LibExtern s_class * S_STDCALL get_class_slots(char *Class, s_boolean optional, s_evaluator *S_evaluator, ...);

LibExtern char * S_STDCALL Sanity(s_object *p, char *comment, s_evaluator *S_evaluator);

LibExtern void S_STDCALL check_globals(s_evaluator *S_evaluator);

LibExtern void S_STDCALL DP(s_object *ent);
LibExtern s_object * S_STDCALL  deparse(s_object *ent, FILE *file, s_evaluator *S_evaluator);

LibExtern char * S_STDCALL  sgets(FILE *f, long width, s_evaluator *S_evaluator);
LibExtern char * S_STDCALL  short_dp(s_object *ent, int length, s_evaluator *S_evaluator);
LibExtern long S_STDCALL print_message2(char *msg, long pos, S_FILE *file, long
	pwidth, long indent, s_evaluator *S_evaluator);
LibExtern char * S_STDCALL  do_unlex(char *string, s_evaluator *S_evaluator);
LibExtern void S_STDCALL names_unlex(char **names, long *nn);

LibExtern void *dyn_open(const char *fname);
LibExtern s_boolean dyn_close(void *handle);
LibExtern s_fun_ptr S_STDCALL get_entry(char *name, s_evaluator *S_evaluator);
LibExtern int S_STDCALL is_ui_app(char *type);
LibExtern int S_STDCALL is_console_app(int for_input);
LibExtern char * S_STDCALL which_ui_app(void);
LibExtern char * S_STDCALL get_app_name(s_boolean get_exe_name);
LibExtern void S_STDCALL interactive(long *log, s_evaluator *S_evaluator);
LibExtern void S_STDCALL set_interactive_states(char **states, long *length_states);
LibExtern void S_STDCALL do_l_hash(s_symbol_address *list);
LibExtern char * S_STDCALL c_symbol(char *name, s_evaluator *S_evaluator);
LibExtern char * S_STDCALL ftn_symbol(char *name, s_evaluator *S_evaluator);
LibExtern char * S_STDCALL Sp_c_symbol(char* , const char*, s_evaluator*);
LibExtern char * S_STDCALL Sp_ftn_symbol(char* , const char*, s_evaluator*);
LibExtern void S_STDCALL S_c_symbol(char **name, char **symbol);
LibExtern void S_STDCALL S_ftn_symbol(char **name, char **symbol);
LibExtern void S_STDCALL init_library(void *handle, char *name,  s_evaluator *S_evaluator);

LibExtern void S_STDCALL S_get_entry(char **symbol, long *address);

LibExtern s_object * S_STDCALL  do_return(s_object *ent, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  do_assign(int which, s_object *assign_to, s_object *expr, s_evaluator *S_evaluator);

LibExtern s_object * S_STDCALL  alc1(int mode, s_object *vector1, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  alc2(int mode, s_object *vector1, s_object *vector2, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  alc3(int mode, s_object *vector1, s_object *vector2, s_object *vector3, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  alcchar(char *name, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  alcf(char *name, s_object *vector1, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  alctss(s_object *data, double start, double end, double nper, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  alcuny(char *name, s_object *vector1, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  alcvec_u(int mode, long length, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  coestr(s_object *ent, s_evaluator *S_evaluator);
LibExtern int S_STDCALL alloc_ptr(char **ptr, s_object **save1, s_object **save2, long bytes[],
	  s_evaluator *S_evaluator);
LibExtern int S_STDCALL coerce_to(int m1, int m2, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  coeves(s_object *ent, int dmode, int do_check, int precious, s_object **Dataptr, s_evaluator *S_evaluator);
LibExtern char * S_STDCALL  coe_name(s_object *ent, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  coedata(s_object *ent, int dmode, int do_check, int precious, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  append_el(s_object *current, long which, s_object *New, s_evaluator *S_evaluator);
LibExtern void S_STDCALL delete_el(s_object *ent, long which, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  do_fcall(s_object *ent, s_object *name, s_evaluator *S_evaluator);
LibExtern void S_STDCALL clean_list(s_object *arglist, s_evaluator *S_evaluator);
LibExtern void S_STDCALL s_copy_if_needed(s_object *dataset, s_boolean ref_case, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL s_old_coerce(s_object *data, int mode, s_evaluator *S_evaluator);

LibExtern char * S_STDCALL  encd1(char *format, double  d1, s_evaluator *S_evaluator);
LibExtern char * S_STDCALL  enci1(char *format, long i1, s_evaluator *S_evaluator);
LibExtern char * S_STDCALL  enci2(char *format, long i1, long i2, s_evaluator *S_evaluator);
LibExtern char * S_STDCALL  encr1(char *format, double r1, s_evaluator *S_evaluator);
LibExtern char * S_STDCALL  encs1(char *format, char *string, s_evaluator *S_evaluator);
LibExtern char * S_STDCALL  encs2(char *format, char *string1, char *string2, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  enc_data(s_object *ent, s_evaluator *S_evaluator);
LibExtern void S_STDCALL s_copy_check(s_object *dataset, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL move_data(s_object *obj, long from_frame, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL copy_lev(s_object *ent, int lev, s_object *frame, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL copy_with_slots(s_object *object, long n, s_evaluator *S_evaluator);
LibExtern void S_STDCALL copy_strings(char **cto, char **cfrom, long length, s_evaluator *S_evaluator);
LibExtern void S_STDCALL S_copy_strings(s_object* ps_object_to, s_object* ps_object_from, s_evaluator *S_evaluator);
LibExtern void S_STDCALL S_remove_strings(char* pchStrings, s_evaluator *S_evaluator);

LibExtern void S_STDCALL set_precious(s_object *ent, s_object *frame, s_evaluator *S_evaluator);
LibExtern int S_STDCALL Data_mode(s_object *ent, s_evaluator *S_evaluator);
LibExtern long S_STDCALL Data_length(s_object *ent, s_evaluator *S_evaluator);
LibExtern void S_STDCALL rec_check(s_object *ent, char *msg, s_evaluator *S_evaluator);
LibExtern char * S_STDCALL collapse_char(s_object *char_vector, int crlf_sep);
LibExtern char * S_STDCALL  ch_collapse(s_object *ent,  s_evaluator *S_evaluator);
LibExtern int S_STDCALL s_has_nas(s_object *ent, s_evaluator *S_evaluator);
LibExtern void S_STDCALL no_nas_allowed(s_object *ent, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  ADD_ARG(s_object *call, s_object *arg, char *name, s_evaluator *S_evaluator);
LibExtern void S_STDCALL make_names(char **strings, long *nstrings);


LibExtern s_object * S_STDCALL  CALL_0(char *n, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  CALL_0_F(s_object *n, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  CALL_1(char *n, s_object *a1, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  CALL_1_F(s_object *n, s_object *a1, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  CALL_2(char *n, s_object *a1, s_object *a2, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  CALL_2_F(s_object *n, s_object *a1, s_object *a2, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  CALL_3(char *n, s_object *a1, s_object *a2, s_object *a3, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  CALL_3_F(s_object *n, s_object *a1, s_object *a2, s_object *a3, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  CALL_4(char *n, s_object *a1, s_object *a2, s_object *a3, s_object *a4, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  CALL_4_F(s_object *n, s_object *a1, s_object *a2, s_object *a3, s_object *a4, s_evaluator *S_evaluator);

LibExtern s_object * S_STDCALL  STRING_VECTOR(char *what,  s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  NUMERIC_VECTOR(double what,  s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  S_INTEGER_VECTOR(long what,  s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  S_LOGICAL_VECTOR(long what,  s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  S_COMPLEX_VECTOR(s_complex what,  s_evaluator *S_evaluator);

LibExtern void S_STDCALL token_classes_reset(s_evaluator *S_evaluator);

LibExtern void S_STDCALL prmatrix(s_object **X, char **Rowlab, char **Collab, long *Quote, long *Right);
LibExtern void S_STDCALL p_match(char **x, char **table, long *lengths, long *Matched);
LibExtern void S_STDCALL window_size(int *line_limit, int *page_limit, s_evaluator *S_evaluator);
LibExtern int  S_STDCALL is_auto_pagesize(s_object *pagesize_option, s_boolean check_attr);
LibExtern void S_STDCALL prts(s_object **X, long *Quote);

LibExtern s_name * S_STDCALL make_name_p(const char *name, int probe, s_evaluator *S_evaluator);
LibExtern s_index S_STDCALL Name_lookup(s_name *what, s_name_table *table, int *enter_here, s_evaluator *S_evaluator); /* Locking version of name lookup */

LibExtern s_object * S_STDCALL name_table_strings(s_name_table *t, s_boolean ordered, s_evaluator *S_evaluator);
LibExtern void S_STDCALL name_table_walk(s_name_table *t, long *pos_p, s_name **name_p,
		     s_index *value_p, s_evaluator *S_evaluator);
LibExtern s_name * S_STDCALL name_table_next(s_name_table *t, long *pos_p);
LibExtern void S_STDCALL name_table_free(s_name_table *t, s_evaluator *S_evaluator);
LibExtern void S_STDCALL name_enter(s_name *what, s_name_table *table, int pos, s_index value, s_evaluator *S_evaluator);
LibExtern void S_STDCALL Name_enter(s_name *what, s_name_table *t, int pos, s_index value, s_evaluator *S_evaluator);
LibExtern s_name_table * S_STDCALL name_table_alloc(long length, double open_ratio, long frame, s_evaluator *S_evaluator);
LibExtern void S_STDCALL name_unhash(s_name *what, s_name_table *t, s_evaluator *S_evaluator);

LibExtern s_object * S_STDCALL  get_dollar(s_object *data, s_object *comp, s_evaluator *S_evaluator);

LibExtern int S_STDCALL expr_cmp(s_object **ep1, s_object **ep2, s_evaluator *S_evaluator);
LibExtern void S_STDCALL na_fill(s_object *ent, long offset, s_evaluator *S_evaluator);
LibExtern void S_STDCALL cx_mat_mul(s_complex *X, s_complex *Y, s_complex *Z, long *RX, long *CY, long *N);
LibExtern void S_STDCALL cx_arg(s_complex z[], long *n, double arg[]);
LibExtern void S_STDCALL cx_im(s_complex z[], long *n, double im[]);
LibExtern void S_STDCALL cx_re(s_complex z[], long *n, double re[]);
LibExtern void S_STDCALL cx_mod(s_complex z[], long *n, double mod[]);
LibExtern void S_STDCALL cx_mean_sweep(s_complex *Z, long *R, long *C);

LibExtern s_object * S_STDCALL  do_na_out(s_object *arg, s_evaluator *S_evaluator);
LibExtern void S_STDCALL qscan(long *from, long length, int mode, s_evaluator *S_evaluator);

LibExtern s_object * S_STDCALL  cons_object(const char *name, s_evaluator *S_evaluator);
LibExtern int S_STDCALL compact_frame0(int first, s_evaluator *S_evaluator);
LibExtern int S_STDCALL db_hash(long nd, char *name, s_object **object_p, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL  metaGet0(const char *name, s_evaluator *S_evaluator);
LibExtern void S_STDCALL numeric_field(char **data, long *nitems, double *numbers, long *flag);

LibExtern int S_STDCALL get_ref_count(s_object *obj, s_evaluator *S_evaluator);
LibExtern s_boolean S_STDCALL multiple_ref_count(s_object *obj, s_evaluator *S_evaluator);

LibExtern void S_STDCALL do_x(char *name, char **values, long nargs, s_evaluator *S_evaluator);

LibExtern s_object * S_STDCALL do_call(s_vfun_ptr pfun, char *name, s_object **values, long nargs, s_evaluator *S_evaluator);

LibExtern void S_STDCALL S_dos_string_to_unix(char *s);
LibExtern char * S_STDCALL  S_strdup(const char *s1, s_evaluator *S_evaluator);
LibExtern int S_STDCALL S_stricmp(const char *s1, const char *s2);
LibExtern int S_STDCALL S_strnicmp(const char *s1, const char *s2, size_t len);
LibExtern char * S_STDCALL  bad_value(s_object *p, s_evaluator *S_evaluator);

LibExtern int S_STDCALL good_table_length(s_name **s, int n, int max_size, int *found, s_evaluator *S_evaluator);
LibExtern int S_STDCALL good_index_table_length(s_index *s, int n, int max_size, int *found, s_evaluator *S_evaluator);

LibExtern void S_STDCALL Slexinit(s_evaluator *S_evaluator);
LibExtern int S_STDCALL S_newflex_lex(s_evaluator *S_evaluator);
LibExtern int S_STDCALL S_newflex_get_token_list(int cont, int parse_line, s_evaluator *S_evaluator);
LibExtern void S_STDCALL S_newflex_lexinit(s_evaluator *S_evaluator);
#ifdef YYDEBUG
LibExtern void S_STDCALL S_newflex_yyerror(char *arg, char *string);
#else
LibExtern void S_STDCALL S_newflex_yyerror(char *string, s_evaluator *S_evaluator);
#endif
LibExtern void S_STDCALL S_newflex_prompt_for_lex(s_connection *con, s_evaluator *S_evaluator);
LibExtern void S_STDCALL S_newflex_do_after_each_reduction(s_object *parse, s_evaluator *S_evaluator);
LibExtern void S_STDCALL S_newflex_expand_tokensCleanup(void);


LibExtern s_object * S_STDCALL  S_clock(s_object *ent, s_object *arglist, s_evaluator *S_evaluator);
LibExtern void S_STDCALL color_spec(char **spec, long *tabsize, s_evaluator *S_evaluator);

LibExtern void S_STDCALL fft(s_complex z[], long *ntot, long *n, long *nspan, long *isn);
LibExtern void S_STDCALL fft2(s_complex z[], long ntot, long n, long nspan, long isn, s_evaluator *S_evaluator);

LibExtern void S_STDCALL do_C_stop(long frame, s_evaluator *S_evaluator);

LibExtern int S_STDCALL version2_init(s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL call_S_Version2(s_object *call, s_object *arglist, s_evaluator *S_evaluator);
LibExtern long S_STDCALL S_char_ptr_to_fortran_interface_long(const char* str);
LibExtern const char* S_STDCALL S_fortran_interface_long_to_char_ptr(long flong);
LibExtern char* S_STDCALL S_get_fortran_common_encbfc(void);
LibExtern long* S_STDCALL S_get_fortran_common_encbfl(void);
LibExtern void S_STDCALL S_encode_axis_num(double x, char* buf, long buflen,
                  long width, long nd, long type,
                  long post_process, long exp_val);

LibExtern int S_STDCALL in_bucket(s_object *p, long nframe, s_evaluator *S_evaluator);

LibExtern int S_STDCALL init_interface(s_evaluator *S_evaluator);

LibExtern s_object * S_STDCALL s_pratom(s_object *x, s_object *doprint_obj, s_object *quote_obj);
LibExtern s_object * S_STDCALL  do_AT(s_object *object, s_object *slot);
LibExtern s_object * S_STDCALL  do_AT_Internal(s_object *ent, s_object *arglist, s_evaluator *S_evaluator);

LibExtern s_object * S_STDCALL new_object(s_object *Class);
LibExtern void S_STDCALL dump_and_reload(void);

LibExtern void S_STDCALL DNAME_TABLE(s_name_table *t);

LibExtern long S_STDCALL get_storage_frame(s_object *obj, s_evaluator *S_evaluator);

/* table of struct sizes */
extern s_name_table *struct_size_table;

LibExtern void S_STDCALL init_struct_table(s_evaluator *S_evaluator);


LibExtern void S_STDCALL init_o_names(long n, s_evaluator *S_evaluator);
LibExtern void S_STDCALL init_replace(s_evaluator *S_evaluator);
LibExtern void S_STDCALL eval_close(int error, s_evaluator *S_evaluator);
LibExtern void S_STDCALL S_boot_restore(s_evaluator *S_evaluator);
LibExtern void S_STDCALL token_tables_init(s_evaluator *S_evaluator);
LibExtern void S_STDCALL check_name_table(s_name_table *t, s_evaluator *S_evaluator);
LibExtern void S_STDCALL check_all_db(s_evaluator *S_evaluator);
LibExtern void S_STDCALL eval_init(s_evaluator *S_evaluator);
LibExtern void S_STDCALL s_move_block(char *p, s_evaluator *S_evaluator);
LibExtern void S_STDCALL get_string_slots(s_object *object,
		      s_object **offsets,
		      s_object **text,
		      s_object **string_table,
		      s_object **levels_table);
LibExtern void S_STDCALL mem_exceeded(s_evaluator *S_evaluator);

LibExtern s_name * S_STDCALL as_s_name(const char *name, s_evaluator *S_evaluator);
LibExtern void S_STDCALL do_first(CommandLineArgs *args, s_evaluator *S_evaluator), setup_standard_events(void);

#ifdef S_LEVEL_THREADS
LibExtern void S_STDCALL notify_memory_exceeded(s_evaluator *S_evaluator);
#endif

LibExtern s_object * S_STDCALL index_table_summary(s_index_table *t, s_evaluator *S_evaluator);

LibExtern int S_STDCALL S_lex(s_evaluator *S_evaluator);


/* Extra prototypes required for the files employed only in the non-threaded version */
LibExtern void S_STDCALL clear_events(void);
LibExtern void S_STDCALL set_search(s_evaluator *S_evaluator);
LibExtern int S_STDCALL input_waiting(int this_fd, long wait, s_evaluator *S_evaluator);
LibExtern int S_STDCALL do_reader_task(s_object *reader, s_connection *con, s_object *con_obj, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL s_c_sink(s_object *con, s_object *what_obj);
LibExtern s_object * S_STDCALL s_c_sink_ex(s_object *con, s_object *what_obj, s_object *s_open_mode);
LibExtern s_object * S_STDCALL s_c_sink_ex2(s_object *con, s_object *what_obj, const char *open_mode);
LibExtern s_object * S_STDCALL doAsObject(s_object *object, s_object *Class_name, s_object *coerce_obj);
LibExtern s_object * S_STDCALL s_identical_objects(s_object *o1, s_object *o2);

/* Moved from GET_MESSAGE because s_evaluator wasn't defined at that point */
LibExtern void S_STDCALL init_temp_file(s_evaluator *);
LibExtern FILE * S_STDCALL s_make_temp_file(s_evaluator *); 
LibExtern void S_STDCALL do_unlink_tempfiles(s_evaluator *S_evaluator);

/* Function for processing command line arguments and storing the results 
   in the global (read-only) CommandLineArgs structure (CmdArgs) above. */
LibExtern int S_STDCALL process_command_line(CommandLineArgs *args, char **argv, int argc, s_evaluator *S_evaluator);

LibExtern S_void_fun_t * S_STDCALL S_SetWhileEvaluatingCallback(S_void_fun_t *callback);
LibExtern void S_STDCALL S_InitEvaluatingCallback(void);
LibExtern void S_STDCALL S_EvaluatingCallback(void);
LibExtern int S_STDCALL SetCallbackFrequency(int new_freq);
LibExtern void S_STDCALL CallWhileEvaluatingCallback(void);

LibExtern int S_STDCALL SGUI_isinstartupcode(int which);
LibExtern int S_STDCALL SGUI_isinmainmenu(enum mainmenu_type which);
#endif /* !SapiObjLIBRARY */

LibExtern FILE* S_STDCALL S_open_logfile(void);
LibExtern void S_STDCALL S_close_logfile(void);
LibExtern void S_STDCALL S_write_log_line(const char *label, const char *string);
LibExtern void S_STDCALL S_log_cat(char **type, char **string);
LibExtern void S_STDCALL S_set_parse_file_name(const char *filename);
LibExtern void S_STDCALL S_eval_time(double *cpu_sec, double *elapsed_sec);
LibExtern void S_STDCALL S_log_eval_time(long task_id, const char *note);
LibExtern long S_STDCALL S_file_size(char *name);

#ifdef WIN32
LibExtern char* S_STDCALL S_Win_GetUserName(void);
LibExtern char* S_STDCALL S_Win_GetComputerName(void);
#endif
LibExtern char* S_STDCALL S_internal_gethostname(void);
LibExtern void S_STDCALL S_getcwd(char **dir);
LibExtern void S_STDCALL S_log_start(void);
LibExtern void S_STDCALL S_platform(char **s);

LibExtern void S_STDCALL S_set_no_restart_warning(long *flag);
LibExtern void S_STDCALL S_casefold(char **strings, long *nstrings, long *toupper);
LibExtern void S_STDCALL S_grep2(char **pattern_p, char **text, long *n_p, long *start, long *length, long *ignore_case, long *extnded, long *fixed);
LibExtern void S_STDCALL S_grep3(char **pattern_p, char **text, long *n_p, long *start, long *length, long *ignore_case, long *extnded, long *fixed);
LibExtern void S_STDCALL S_grep_fixed(char **pattern_p, char **text, long *n_p, long *start, long *length, long *ignore_case);
LibExtern void S_STDCALL S_regex_replace(char **pattern_p, char **replacement_p, char **text, long *n_p, long *global, long *ignore_case, long *extnded, long *fixed);
LibExtern int S_STDCALL S_get_which_parser(void) ;
LibExtern int S_STDCALL s_portable_chdir(char *dir, char **error) ;

/* Define S_USING_PSL before including this file if you
 * want declarations for Fortran functions in src/psl
 */
#ifdef S_USING_PSL /* ( */
LibExtern void S_STDCALL F77_SUB(sortp8)(double *x,long *length,long *indexx) ;
LibExtern void S_STDCALL F77_SUB(sortl8)(double *x,long *length,long *indexx) ;
LibExtern void S_STDCALL F77_SUB(sortr8)(double *x,long *length) ;
#if 0 /* these are in psl.a, but not now in executable */
extern void S_STDCALL F77_SUB(sorti)(long *x,long *length) ;
extern void S_STDCALL F77_SUB(sortpi)(long *x,long *length,long *indexx) ;
#endif
#endif /* S_USING_PSL ) */

LibExtern void S_STDCALL F77_NAME(s_ftn_sort_integer)(long *values, long *n);
LibExtern void S_STDCALL S_sort_integer(long *values, long n);
LibExtern void S_STDCALL F77_NAME(s_ftn_sort_double)(double *values, long *n);
LibExtern void S_STDCALL S_sort_double(double *values, long n);
LibExtern void S_STDCALL F77_NAME(s_ftn_sort_float)(float *values, long *n);
LibExtern void S_STDCALL S_sort_float(float *values, long n);
LibExtern void S_STDCALL F77_NAME(s_ftn_order_integer)(long *values, long *indx, long *n);
LibExtern void S_STDCALL S_order_integer(long *values, long *indx, long n);
LibExtern void S_STDCALL F77_NAME(s_ftn_order_double)(double *values, long *indx, long *n);
LibExtern void S_STDCALL S_order_double(double *values, long *indx, long n);
LibExtern void S_STDCALL F77_NAME(s_ftn_order_float)(float *values, long *indx, long *n);
LibExtern void S_STDCALL S_order_float(float *values, long *indx, long n);

LibExtern void S_STDCALL S_permute_float(float *values, long *indx, long n);
LibExtern void S_STDCALL S_permute_double(double *values, long *indx, long n);
LibExtern void S_STDCALL S_permute_integer(long *values, long *indx, long n);
LibExtern void S_STDCALL F77_SUB(s_ftn_permute_float)(float *values, long *indx, long *n);
LibExtern void S_STDCALL F77_SUB(s_ftn_permute_double)(double *values, long *indx, long *n);
LibExtern void S_STDCALL F77_SUB(s_ftn_permute_integer)(long *values, long *indx, long *n);

LibExtern void S_STDCALL S_order_general_ev(void *values, long *iorder, long n, long *partial, long npartial, size_t elsize, int (S_CDECL *fc)(const void*,const void*), s_evaluator *S_evaluator);
LibExtern void S_STDCALL S_order_general(void *values, long *iorder, long n, long *partial, long npartial, size_t elsize, int (S_CDECL *fc)(const void*,const void*));

/* following few functions are to support C code written for R API.
 * The one with an index use a stable sort where R does not.
 * Using S_order_* functions will generally use less space.
 */
LibExtern void S_STDCALL S_rsort_with_index(double *v, long *indx, long n) ;
LibExtern void S_STDCALL S_isort_with_index(long *iv, long *indx, long n) ;
/* I don't like using simple names like qsort[34], but R does and Fortran
 * doesn't have macros
 */
LibExtern void S_STDCALL F77_SUB(qsort4)(double *v, long *indx, long *ii, long *jj) ; /* R's qsort4 */
LibExtern void S_STDCALL F77_SUB(qsort3)(double *v, long *ii, long *jj) ; /* R's qsort3 */


/* The printflike1 comment tells Solaris lint the following
 * function is like printf with the format in the 1st position
 * so it can compare the format and the types of the ... arguments.
 */
/*PRINTFLIKE1*/
LibExtern void S_CDECL S_error(const char *format, ...);
/*PRINTFLIKE1*/
LibExtern void S_CDECL S_warning(const char *format, ...);
/*PRINTFLIKE1*/
LibExtern void S_CDECL S_show_message(const char *format, ...);
/*PRINTFLIKE2*/
LibExtern void S_CDECL S_error_ev(s_evaluator *S_evaluator, const char *format, ...);
/*PRINTFLIKE2*/
LibExtern void S_CDECL S_warning_ev(s_evaluator *S_evaluator, const char *format, ...);
/*PRINTFLIKE2*/
LibExtern void S_CDECL S_show_message_ev(s_evaluator *S_evaluator, const char *format, ...);

/* Now all the non-static functions from random.c */
LibExtern RETURN_DOUBLE S_STDCALL S_pbeta(double q, double a, double b);
LibExtern RETURN_DOUBLE S_STDCALL S_pbeta_ex(double q, double a, double b, int lowertail, int logp);
LibExtern RETURN_DOUBLE S_STDCALL S_pbinom(double q, double n, double prob);
LibExtern RETURN_DOUBLE S_STDCALL S_pcauchy(double q);
LibExtern RETURN_DOUBLE S_STDCALL S_pchisq(double q, double df);
LibExtern RETURN_DOUBLE S_STDCALL S_pexp(double q);
LibExtern RETURN_DOUBLE S_STDCALL S_pf(double q, double df1, double df2);
LibExtern RETURN_DOUBLE S_STDCALL S_pgamma(double q, double s);
LibExtern RETURN_DOUBLE S_STDCALL S_pgeom(double q, double prob);
LibExtern RETURN_DOUBLE S_STDCALL S_plnorm(double q, double m, double s);
LibExtern RETURN_DOUBLE S_STDCALL S_plogis(double q);
LibExtern RETURN_DOUBLE S_STDCALL S_pnbinom(double q, double n, double prob);
LibExtern RETURN_DOUBLE S_STDCALL S_pnorm(double q);
LibExtern RETURN_DOUBLE S_STDCALL S_pnorm_ex(double q, double mu, double sigma, int lower_tail, int log_p);
LibExtern RETURN_DOUBLE S_STDCALL S_ppois(double q, double lambda);
LibExtern RETURN_DOUBLE S_STDCALL S_pstab(double q, double index, double skewness, s_evaluator *S_evaluator);
LibExtern RETURN_DOUBLE S_STDCALL S_pt(double q, double df);
LibExtern RETURN_DOUBLE S_STDCALL S_punif(double q);
LibExtern RETURN_DOUBLE S_STDCALL S_pweibull(double q, double s);

LibExtern RETURN_DOUBLE S_STDCALL S_qbeta(double p, double a, double b);
LibExtern RETURN_DOUBLE S_STDCALL S_qbinom(double p, double n, double prob);
LibExtern RETURN_DOUBLE S_STDCALL S_qcauchy(double p);
LibExtern RETURN_DOUBLE S_STDCALL S_qchisq(double p, double df);
LibExtern RETURN_DOUBLE S_STDCALL S_qexp(double p);
LibExtern RETURN_DOUBLE S_STDCALL S_qf(double p, double df1, double df2);
LibExtern RETURN_DOUBLE S_STDCALL S_qgamma(double p, double s);
LibExtern RETURN_DOUBLE S_STDCALL S_qgeom(double p, double prob);
LibExtern RETURN_DOUBLE S_STDCALL S_qlnorm(double p, double m, double s);
LibExtern RETURN_DOUBLE S_STDCALL S_qlogis(double p);
LibExtern RETURN_DOUBLE S_STDCALL S_qnbinom(double p, double n, double prob);
LibExtern RETURN_DOUBLE S_STDCALL S_qnorm(double p);
LibExtern RETURN_DOUBLE S_STDCALL S_qpois(double p, double lambda);
LibExtern RETURN_DOUBLE S_STDCALL S_qstab(double p, double index, double skewness, s_evaluator *S_evaluator);
LibExtern RETURN_DOUBLE S_STDCALL S_qt(double p, double df);
LibExtern RETURN_DOUBLE S_STDCALL S_qunif(double p);
LibExtern RETURN_DOUBLE S_STDCALL S_qweibull(double p, double s);

LibExtern RETURN_DOUBLE S_STDCALL S_dbeta(double x, double a, double b);
LibExtern RETURN_DOUBLE S_STDCALL S_dbinom(double x, double n, double prob);
LibExtern RETURN_DOUBLE S_STDCALL S_dcauchy(double x);
LibExtern RETURN_DOUBLE S_STDCALL S_dchisq(double x, double df);
LibExtern RETURN_DOUBLE S_STDCALL S_dexp(double x);
LibExtern RETURN_DOUBLE S_STDCALL S_df(double x, double df1, double df2);
LibExtern RETURN_DOUBLE S_STDCALL S_dgamma(double x, double s);
LibExtern RETURN_DOUBLE S_STDCALL S_dgeom(double x, double prob);
LibExtern RETURN_DOUBLE S_STDCALL S_dlnorm(double x, double m, double s);
LibExtern RETURN_DOUBLE S_STDCALL S_dlogis(double x);
LibExtern RETURN_DOUBLE S_STDCALL S_dnbinom(double x, double n, double prob);
LibExtern RETURN_DOUBLE S_STDCALL S_dnorm(double x);
LibExtern RETURN_DOUBLE S_STDCALL S_dpois(double x, double lambda);
LibExtern RETURN_DOUBLE S_STDCALL S_dstab(double x, double index, double skewness, s_evaluator *S_evaluator);
LibExtern RETURN_DOUBLE S_STDCALL S_dt(double x, double df);
LibExtern RETURN_DOUBLE S_STDCALL S_dunif(double x);
LibExtern RETURN_DOUBLE S_STDCALL S_dweibull(double x, double s);

LibExtern RETURN_DOUBLE S_STDCALL S_dbeta_log(double x, double a, double b);
LibExtern RETURN_DOUBLE S_STDCALL S_dbinom_log(double x, double n, double prob);
LibExtern RETURN_DOUBLE S_STDCALL S_dcauchy_log(double x);
LibExtern RETURN_DOUBLE S_STDCALL S_dchisq_log(double x, double df);
LibExtern RETURN_DOUBLE S_STDCALL S_dexp_log(double x);
LibExtern RETURN_DOUBLE S_STDCALL S_df_log(double x, double df1, double df2);
LibExtern RETURN_DOUBLE S_STDCALL S_dgamma_log(double x, double s);
LibExtern RETURN_DOUBLE S_STDCALL S_dgeom_log(double x, double prob);
LibExtern RETURN_DOUBLE S_STDCALL S_dlnorm_log(double x, double m, double s);
LibExtern RETURN_DOUBLE S_STDCALL S_dlogis_log(double x);
LibExtern RETURN_DOUBLE S_STDCALL S_dnbinom_log(double x, double n, double prob);
LibExtern RETURN_DOUBLE S_STDCALL S_dnorm_log(double x);
LibExtern RETURN_DOUBLE S_STDCALL S_dpois_log(double x, double lambda);
LibExtern RETURN_DOUBLE S_STDCALL S_dstab_log(double x, double index, double skewness, s_evaluator *S_evaluator);
LibExtern RETURN_DOUBLE S_STDCALL S_dt_log(double x, double df);
LibExtern RETURN_DOUBLE S_STDCALL S_dunif_log(double x);
LibExtern RETURN_DOUBLE S_STDCALL S_dweibull_log(double x, double s);

LibExtern RETURN_DOUBLE S_STDCALL S_rbeta(double a, double b);
LibExtern RETURN_DOUBLE S_STDCALL S_rbinom(double n, double prob);
LibExtern RETURN_DOUBLE S_STDCALL S_rcauchy(void);
LibExtern RETURN_DOUBLE S_STDCALL S_rchisq(double df);
LibExtern RETURN_DOUBLE S_STDCALL S_rexp(void);
LibExtern RETURN_DOUBLE S_STDCALL S_rf(double df1, double df2);
LibExtern RETURN_DOUBLE S_STDCALL S_rgamma(double s);
LibExtern RETURN_DOUBLE S_STDCALL S_rgeom(double prob);
LibExtern RETURN_DOUBLE S_STDCALL S_rlnorm(double m, double s);
LibExtern RETURN_DOUBLE S_STDCALL S_rlogis(void);
LibExtern RETURN_DOUBLE S_STDCALL S_rnbinom(double n, double prob);
LibExtern RETURN_DOUBLE S_STDCALL S_rnorm(void);
LibExtern RETURN_DOUBLE S_STDCALL S_rpois(double lambda);
LibExtern RETURN_DOUBLE S_STDCALL S_rstab(double index, double skewness);
LibExtern RETURN_DOUBLE S_STDCALL S_rt(double df);
LibExtern RETURN_DOUBLE S_STDCALL S_runif(void);
LibExtern RETURN_DOUBLE S_STDCALL S_rweibull(double s);

LibExtern RETURN_DOUBLE S_STDCALL F77_NAME(d1mach)(long *i) ; /* in slocal/stat/src/d1mach.c */
LibExtern RETURN_DOUBLE S_STDCALL S_c_d1mach(long i) ;

/* new entries for R-compatible macros in R.h, Rinternals.h, etc */
LibExtern s_object* S_STDCALL S_RCOMPAT_getAttrib(s_object* x, const char* nm, s_evaluator *S_evaluator);
LibExtern s_object* S_STDCALL S_RCOMPAT_setAttrib(s_object* x, const char* nm, s_object* val, s_evaluator *S_evaluator);
LibExtern s_object* S_STDCALL S_RCOMPAT_mkString(const char* str, s_evaluator *S_evaluator);
LibExtern s_object * S_STDCALL S_allocMatrix(int mode, long nrow, long ncol, s_evaluator *S_evaluator) ;
LibExtern s_object* S_STDCALL S_allocArray(int mode, s_object *s_dims, s_evaluator *S_evaluator) ;

LibExtern long S_STDCALL S_n_devices(void) ;

LibExtern RETURN_DOUBLE S_STDCALL F77_NAME(splusamosdgamln)(double *z, long *ierr);
LibExtern RETURN_DOUBLE S_STDCALL F77_NAME(splusamoszabs)(double *zr, double *zi);
LibExtern void S_STDCALL F77_NAME(splusamoszacai)(double *zr, double *zi, double *fnu, long *kode, long *mr, long *n, double *yr, double *yi, long *nz, double *rl, double *tol, double *elim, double *alim);
LibExtern void S_STDCALL F77_NAME(splusamoszacon)(double *zr, double *zi, double *fnu, long *kode, long *mr, long *n, double *yr, double *yi, long *nz, double *rl, double *fnul, double *tol, double *elim, double *alim);
LibExtern void S_STDCALL F77_NAME(splusamoszairy)(double *zr, double *zi, long *id, long *kode, double *air, double *aii, long *nz, long *ierr);
LibExtern void S_STDCALL F77_NAME(splusamoszasyi)(double *zr, double *zi, double *fnu, long *kode, long *n, double *yr, double *yi, long *nz, double *rl, double *tol, double *elim, double *alim);
LibExtern void S_STDCALL F77_NAME(splusamoszbesh)(double *zr, double *zi, double *fnu, long *kode, long *m, long *n, double *cyr, double *cyi, long *nz, long *ierr);
LibExtern void S_STDCALL F77_NAME(splusamoszbesi)(double *zr, double *zi, double *fnu, long *kode, long *n, double *cyr, double *cyi, long *nz, long *ierr);
LibExtern void S_STDCALL F77_NAME(splusamoszbesj)(double *zr, double *zi, double *fnu, long *kode, long *n, double *cyr, double *cyi, long *nz, long *ierr);
LibExtern void S_STDCALL F77_NAME(splusamoszbesk)(double *zr, double *zi, double *fnu, long *kode, long *n, double *cyr, double *cyi, long *nz, long *ierr);
LibExtern void S_STDCALL F77_NAME(splusamoszbesy)(double *zr, double *zi, double *fnu, long *kode, long *n, double *cyr, double *cyi, long *nz, double *cwrkr, double *cwrki, long *ierr);
LibExtern void S_STDCALL F77_NAME(splusamoszbinu)(double *zr, double *zi, double *fnu, long *kode, long *n, double *cyr, double *cyi, long *nz, double *rl, double *fnul, double *tol, double *elim, double *alim);
LibExtern void S_STDCALL F77_NAME(splusamoszbknu)(double *zr, double *zi, double *fnu, long *kode, long *n, double *yr, double *yi, long *nz, double *tol, double *elim, double *alim);
LibExtern void S_STDCALL F77_NAME(splusamoszbuni)(double *zr, double *zi, double *fnu, long *kode, long *n, double *yr, double *yi, long *nz, long *nui, long *nlast, double *fnul, double *tol, double *elim, double *alim);
LibExtern void S_STDCALL F77_NAME(splusamoszbunk)(double *zr, double *zi, double *fnu, long *kode, long *mr, long *n, double *yr, double *yi, long *nz, double *tol, double *elim, double *alim);
LibExtern void S_STDCALL F77_NAME(splusamoszdiv)(double *ar, double *ai, double *br, double *bi, double *cr, double *ci);
LibExtern void S_STDCALL F77_NAME(splusamoszexp)(double *ar, double *ai, double *br, double *bi);
LibExtern void S_STDCALL F77_NAME(splusamoszkscl)(double *zrr, double *zri, double *fnu, long *n, double *yr, double *yi, long *nz, double *rzr, double *rzi, double *ascle, double *tol, double *elim);
LibExtern void S_STDCALL F77_NAME(splusamoszlog)(double *ar, double *ai, double *br, double *bi, long *ierr);
LibExtern void S_STDCALL F77_NAME(splusamoszmlri)(double *zr, double *zi, double *fnu, long *kode, long *n, double *yr, double *yi, long *nz, double *tol);
LibExtern void S_STDCALL F77_NAME(splusamoszmlt)(double *ar, double *ai, double *br, double *bi, double *cr, double *ci);
LibExtern void S_STDCALL F77_NAME(splusamoszrati)(double *zr, double *zi, double *fnu, long *n, double *cyr, double *cyi, double *tol);
LibExtern void S_STDCALL F77_NAME(splusamoszs1s2)(double *zrr, double *zri, double *s1r, double *s1i, double *s2r, double *s2i, long *nz, double *ascle, double *alim, long *iuf);
LibExtern void S_STDCALL F77_NAME(splusamoszseri)(double *zr, double *zi, double *fnu, long *kode, long *n, double *yr, double *yi, long *nz, double *tol, double *elim, double *alim);
LibExtern void S_STDCALL F77_NAME(splusamoszshch)(double *zr, double *zi, double *cshr, double *cshi, double *cchr, double *cchi);
LibExtern void S_STDCALL F77_NAME(splusamoszsqrt)(double *ar, double *ai, double *br, double *bi);
LibExtern void S_STDCALL F77_NAME(splusamoszuchk)(double *yr, double *yi, long *nz, double *ascle, double *tol);
LibExtern void S_STDCALL F77_NAME(splusamoszunhj)(double *zr, double *zi, double *fnu, long *ipmtr, double *tol, double *phir, double *phii, double *argr, double *argi, double *zeta1r, double *zeta1i, double *zeta2r, double *zeta2i, double *asumr, double *asumi, double *bsumr, double *bsumi);
LibExtern void S_STDCALL F77_NAME(splusamoszuni1)(double *zr, double *zi, double *fnu, long *kode, long *n, double *yr, double *yi, long *nz, long *nlast, double *fnul, double *tol, double *elim, double *alim);
LibExtern void S_STDCALL F77_NAME(splusamoszuni2)(double *zr, double *zi, double *fnu, long *kode, long *n, double *yr, double *yi, long *nz, long *nlast, double *fnul, double *tol, double *elim, double *alim);
LibExtern void S_STDCALL F77_NAME(splusamoszunik)(double *zrr, double *zri, double *fnu, long *ikflg, long *ipmtr, double *tol, long *init, double *phir, double *phii, double *zeta1r, double *zeta1i, double *zeta2r, double *zeta2i, double *sumr, double *sumi, double *cwrkr, double *cwrki);
LibExtern void S_STDCALL F77_NAME(splusamoszunk1)(double *zr, double *zi, double *fnu, long *kode, long *mr, long *n, double *yr, double *yi, long *nz, double *tol, double *elim, double *alim);
LibExtern void S_STDCALL F77_NAME(splusamoszunk2)(double *zr, double *zi, double *fnu, long *kode, long *mr, long *n, double *yr, double *yi, long *nz, double *tol, double *elim, double *alim);
LibExtern void S_STDCALL F77_NAME(splusamoszuoik)(double *zr, double *zi, double *fnu, long *kode, long *ikflg, long *n, double *yr, double *yi, long *nuf, double *tol, double *elim, double *alim);
LibExtern void S_STDCALL F77_NAME(splusamoszwrsk)(double *zrr, double *zri, double *fnu, long *kode, long *n, double *yr, double *yi, long *nz, double *cwr, double *cwi, double *tol, double *elim, double *alim);

LibExtern void S_STDCALL S_getRNGstate(void);
LibExtern void S_STDCALL S_putRNGstate(void);

S_end_extern_c
#include "unlibext.h"
#endif /* S_EXTERN_H */
