/* @(#) Copyright (c), 1987, 2006 Insightful Corp.  All rights reserved. */
/* @(#) $RCSfile$: $Revision: #6 $, $Date: 2006/06/26 $  */
/***
   NAME S_handle
   PURPOSE
     Externs/etc for S_handle.c.
   NOTES
     A 'handle' is an opaque identifier for a chunk of data.  The value of
     the handle may be stored in an S-PLUS object, so some form of
     validity checking is needed to try to ensure that a handle is valid
     for the current S-PLUS session.  It does this by basing the handle
     values on the time() value the first time a handle is allocated.
***/
#ifndef S_handleINCLUDED
#define S_handleINCLUDED 1

/* Pre-requisite includes go here. */
#include <S_ansi.h>

#ifdef S_handleDEFINE
#define INIT(x) = x
#define vextern
#else
#define INIT(x)
#define vextern extern
#endif /* S_handleDEFINE */

typedef long S_handle;

extern S_handle Shandle_new PARAMS((void));
extern void Shandle_free PARAMS((S_handle handle));
extern void *Shandle_getdata PARAMS((S_handle handle));
extern void Shandle_setdata PARAMS((S_handle handle, void *handle_data));
extern char *Shandle_gettype PARAMS((S_handle handle));
extern void Shandle_settype PARAMS((S_handle handle, char *handle_type));
extern int Shandle_valid PARAMS((S_handle handle));
extern int Shandle_inuse PARAMS((S_handle handle));

/* .C-callable interfaces to above */

/* .C('S_handle_new', handle=integer(1))$handle */
extern void S_handle_new PARAMS((long *handle));

/* .C('S_handle_free', as.integer(handle)) */
extern void S_handle_free PARAMS((long *handle));

/* S_handle_[sg]etdata are of questionable use from S...really ought to */
/* implement S_handle_[sg]etvec() to set/get an S (vector *) associated */
/* with the data.  But for my immediate purposes, I don't need */
/* that. -Scott 951120 */

/* .C('S_handle_getdata',
   as.integer(handle), handle_data=integer(1))$handle_data */
extern void S_handle_getdata PARAMS((long *handle, long *handle_data));

/* .C('S_handle_setdata', as.integer(handle), as.integer(handle_data)) */
extern void S_handle_setdata PARAMS((long *handle, long *handle_data));

/* .C('S_handle_gettype',
   as.integer(handle), handle_type=character(1))$handle_type */
extern void S_handle_gettype PARAMS((long *handle, char **handle_type));

/* .C('S_handle_settype', as.integer(handle), as.character(handle_type)) */
extern void S_handle_settype PARAMS((long *handle, char **handle_type));

/* .C('S_handle_valid', as.integer(handle), valid=integer(1))$valid == 1 */
extern void S_handle_valid PARAMS((long *handle, long *valid));

/* .C('S_handle_inuse', as.integer(handle), inuse=integer(1))$inuse == 1 */
extern void S_handle_inuse PARAMS((long *handle, long *inuse));

#undef INIT
#undef vextern

/* Sub-includes go here. */
#endif /* S_handleINCLUDED */
