/* @(#) Copyright (c), 1987, 2006 Insightful Corp.  All rights reserved. */
/* @(#) $RCSfile: S_types.h,v $: $Revision: #22 $, $Date: 2007/09/26 $  */
/***
   NAME   S_types
   PURPOSE
     Some _basic_ data type declarations, suitable for public use.
   NOTES
     
***/
#ifndef S_typesINCLUDED
#define S_typesINCLUDED 1

/* S7_CHANGE */
#if defined(_AIX) 
#include <math.h>
#endif


/* Pre-requisite includes go here. */
#include <libext.h>
S_begin_extern_c

/* structures for basic data types */
typedef struct s_complex_struct {
    double re, im;
} S_complex;   /* need S_complex for SDK backward compatibility */
typedef struct s_complex_struct s_complex;

/* No #define S_TRUE or #define S_FALSE because they are enum values */
#undef S_FALSE
#undef S_TRUE
#undef S_MAYBE
enum s_boolean_enum {S_FALSE, S_TRUE, S_MAYBE};
typedef enum s_boolean_enum s_boolean;

#ifndef HAVE_SINT_TYPEDEF
typedef long Sint ; /* C type for S language "integer", is int in R */
#define HAVE_SINT_TYPEDEF
#endif

#ifndef RPC_FILE  /* these shouldn't go through RPC */
typedef void (*s_void_fun) ();
typedef long (*s_fun_ptr) ();
typedef void (S_void_fun_t)();
#endif

#if defined(S_COMPATIBILITY) /* ( */

#undef TRUE
#undef FALSE
#undef MAYBE
#define FALSE S_FALSE
#define TRUE S_TRUE
#define MAYBE S_MAYBE
#if !defined(TXSCL) /*(*/
typedef enum s_boolean_enum boolean;
#endif /*)*/
#undef complex
typedef struct s_complex_struct complex;
typedef void (*void_fun) ();
typedef long (*fun_ptr) ();

#if S_COMPATIBILITY >= 10  /*(*/

#if !defined(TXSCL) /*(*/
#define s_boolean boolean
#endif /*)*/
/* some compilers <math.h> do '#define complex _complex' when not strict
   ANSI in order to use _complex in strict ANSI mode. */
#define s_complex complex
#define s_void_fun void_fun
#define s_fun_ptr fun_ptr

#endif /* ) */
#endif /* ) S_COMPATIBILITY */

 
#ifndef NULL
#define NULL 0
#endif
#define NULL_STRING (char *)NULL

/* some general definitions for pointers to s_object's */
#define NULL_ENTRY              ((s_object *)NULL)
#define NULL_ENTRYP             ((s_object **)NULL)
 
#undef PI
#define PI      3.1415926535897932384626433832795028841971693993751
#define DEG2RD  0.01745329251994329576923690768488612713442871888541

/* This is an odd place for math constants, but I'll continue
 * the tradition.  The new M_* names are SVID & X/Open names,
 * based on what I see in Solaris /usr/include/math.h (and R's
 * include/Rmath.h).  Values are checked with 'bc -l',scale=31
 * on Solaris.
 */

#ifndef M_E
#define M_E             2.718281828459045235360287471353 /* e=exp(1) */
#endif

#ifndef M_LOG2E
#define M_LOG2E         1.442695040888963407359924681002 /* log2(e)==1/log(2) */
#endif

#ifndef M_LOG10E
#define M_LOG10E        0.434294481903251827651128918917 /* log10(e)==1/log(10) */
#endif

#ifndef M_LN2
#define M_LN2           0.693147180559945309417232121458 /* log(2) */
#endif

#ifndef M_LN10
#define M_LN10          2.302585092994045684017991454684 /* log(10) */
#endif

#ifndef M_PI
#define M_PI            PI
#endif

#ifndef M_PI_2
#define M_PI_2          1.570796326794896619231321691640 /* pi/2 */
#endif

#ifndef M_PI_4
#define M_PI_4          0.785398163397448309615660845820 /* pi/4 */
#endif

#ifndef M_1_PI
#define M_1_PI          0.318309886183790671537767526745 /* 1/pi */
#endif

#ifndef M_2_PI
#define M_2_PI          0.636619772367581343075535053490 /* 2/pi */
#endif

#ifndef M_2_SQRTPI
#define M_2_SQRTPI      1.128379167095512573896158903122 /* 2/sqrt(pi) */
#endif

#ifndef M_SQRT2
#define M_SQRT2         1.414213562373095048801688724210 /* sqrt(2) */
#endif

#ifndef M_SQRT1_2
#define M_SQRT1_2       0.707106781186547524400844362105 /* 1/sqrt(2) */
#endif

/* we add some more more M_constants that R adds */

#ifndef M_SQRT_3
#define M_SQRT_3        1.732050807568877293527446341506 /* sqrt(3) */
#endif

#ifndef M_SQRT_32
#define M_SQRT_32       5.656854249492380195206754896838 /* sqrt(32) */
#endif

#ifndef M_LOG10_2
#define M_LOG10_2       0.301029995663981195213738894724 /* log10(2) */
#endif

#ifndef M_SQRT_PI
#define M_SQRT_PI       1.772453850905516027298167483341 /* sqrt(pi) */
#endif

#ifndef M_1_SQRT_2PI
#define M_1_SQRT_2PI    0.398942280401432677939946059934 /* 1/sqrt(2pi) */
#endif

#ifndef M_SQRT_2dPI
#define M_SQRT_2dPI     0.797884560802865355879892119869 /* sqrt(2/pi) */
#endif

#ifndef M_LN_SQRT_PI
#define M_LN_SQRT_PI    0.572364942924700087071713675677 /* log(sqrt(pi)) */
#endif

#ifndef M_LN_SQRT_2PI
#define M_LN_SQRT_2PI   0.918938533204672741780329736406 /* log(sqrt(2*pi)) */
#endif

#ifndef M_LN_SQRT_PId2
#define M_LN_SQRT_PId2  0.225791352644727432363097614947 /* log(sqrt(pi/2)) */
#endif

#ifndef S_DONT_DEFINE_LOGICAL_CONSTANTS /* ( */
#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif
#endif /* ) !S_DONT_DEFINE_LOGICAL_CONSTANTS */

S_end_extern_c
#include <unlibext.h>
#endif /* S_typesINCLUDED */
