#ifndef USRPROTOTYPES_H
#define USRPROTOTYPES_H


#include "device.h"

static vector *
USRmrks(device *dev, float *xx, float *yy, long n, s_evaluator *S_evaluator);

static vector *
USRtext(device *dev, float *x, float *y, F_CHARTYPE bufa, long *n, float *pos, s_evaluator *S_evaluator);

static vector *
USRpoly(device *dev, float *x, float *y, long *n, s_evaluator *S_evaluator);

static vector *
USRsegs(device *dev, float *x1, float *y1, float *x2, float *y2, long *n, s_evaluator *S_evaluator);

static vector *
USRlins(device *dev, float *x, float *y, long *n, s_evaluator *S_evaluator);

static vector*
USRamodes(device *dev,int which, s_evaluator *S_evaluator);

static
USRcheck(device *dev, s_evaluator *S_evaluator);

static void
USRsignalled(device *dev, s_evaluator *S_evaluator);

static void
USRwrap(device *dev, s_evaluator *S_evaluator);

static void
USRclear(device *dev, int which, s_evaluator *S_evaluator);

static void
USRflush(device *dev, s_evaluator *S_evaluator);

static vector *
USRmenu(device *dev, vector *ent, vector *arglist, s_evaluator *S_evaluator);

static vector*
USRhook(device *dev, long *type, float *x, long *n, float *y, long *m, s_evaluator *S_evaluator);


static void
USRamReset(device *dev, s_evaluator *S_evaluator);


static void
USRimage(device *dev, float *xy, char *filename, s_evaluator *S_evaluator);

static void
USRprocessEvents(device *dev, void *ev, s_evaluator *S_evaluator);


static long
USRgetFileDescriptor(device *dev, s_evaluator *S_evaluator);


static vector *
USRinput(device *dev, float x[], float y[], long *n, long *nmax, s_evaluator *S_evaluator);


#endif
