/* @(#) Copyright (c), 1987, 2001 Insightful Corp.  All rights reserved. */
/* @(#)$RCSfile: compiler.h,v $ version $Revision: #6 $ created $Date: 2001/08/28 $ */

#ifndef _S_COMPILER_H_ /*(*/
#define _S_COMPILER_H_

#if defined(_MSC_VER) && defined(SV3_BUILD) /*(*/

typedef union {
	int		return_scalar;
	float	return_float;
} convert_float;

typedef union {
	struct { int eax; int edx; }	return_scalar;
	double							return_double;
} convert_double;

#define RETURN_FLOAT	convert_float
#define RETURN_DOUBLE	convert_double

#define S_FLOATVAL(x)	((x).return_float)
#define S_DOUBLEVAL(x)	((x).return_double)

#else /*)(*/

#define RETURN_FLOAT	float
#define RETURN_DOUBLE	double

#define S_FLOATVAL(x)	(x)
#define S_DOUBLEVAL(x)	(x)

#endif /*)*/

#endif /*) _S_COMPILER_H_ */
