/* %Z%%Q% */

#ifndef _S_DISPLIST_H_ /*(*/
#define _S_DISPLIST_H_

#include <sccs.h>
/*SCCS_ID_C(0016,%Z%$RCSfile: displist.h,v $ $Revision: #14 $ last edit $Date: 2006/07/31 $ StatSci)*/

typedef struct _DisplayLinesData {
	float *x, *y ;
	long n ;
} DisplayLinesData ;
typedef struct _DisplayPolygonData {
	float *x, *y ;
	long n ;
} DisplayPolygonData ;
typedef struct _DisplayPointsData {
	float *x, *y ;
	long n ;
} DisplayPointsData ;
typedef struct _DisplaySegmentsData {
	float *x1, *y1, *x2, *y2 ;
	long n ;
} DisplaySegmentsData ;
typedef struct _DisplayTextData {
	float x, y ;
	char *string ;
	long length ;
	float pos ;
} DisplayTextData ;
typedef struct _DisplayParData {
	float *list ;
	long npar ;
} DisplayParData ;
#ifdef NODEF /* ( */
typedef struct _DisplayBrushData {
	float *x;
	long int *nobs, *nvar, *hist, *spin;
	long int *ncolchar, *nrowchar;
	long int *icollab; char *tcollab;
	long int *irowlab; char *trowlab;
	long int *init_highlight, *labeled;
	long int *nhighlighted, *highlighted;
	long int *state;
	/* SpinPlot *spinplot ; */
} DisplayBrushData ;
typedef struct _DisplaySpinData {
	float *x;
	long int *nobs, *nvar, *ncolchar;
	long int *icollab; char *tcollab;
	long int *highlighted;
	long int *type;
	long int *state;
	/* SpinPlot *spinplot ; */
} DisplaySpinData ;
#endif /* ) NOTDEF */
typedef struct _DisplayImageData {
	float *x, *y, *z ;
	long nx, ny, nz ;
	float zmin, zmax, zmiss ;
} DisplayImageData ;
typedef struct _DisplayImageRgbaData {
	float *x, *y, *z ;
	long nx, ny, nz ;
	float zmin, zmax, zmiss ;
        long *r, *g, *b, *a;
        long ncolors;
} DisplayImageRgbaData ;
typedef struct _DisplayListEntry {
	int type ;
#define DISPLAY_LINES		1
#define DISPLAY_POLYGON		2
#define DISPLAY_POINTS		3
#define DISPLAY_SEGMENTS	4
#define DISPLAY_TEXT		5
#define DISPLAY_DIFFPAR		6
#define DISPLAY_INITPAR		7
#ifdef NOTDEF /* ( */
#define DISPLAY_BRUSH		8
#define DISPLAY_SPIN		9
#endif /* ) NOTDEF */
#define DISPLAY_IMAGE		10
#define DISPLAY_IMAGE_RGBA	11
	union {
		DisplayLinesData lines_data ;
		DisplayPolygonData polygon_data ;
		DisplayPointsData points_data ;
		DisplaySegmentsData segments_data ;
		DisplayTextData text_data ;
		DisplayParData diffpar_data ;
		DisplayParData initpar_data ;
#ifdef NOTDEF /* ( */
		DisplayBrushData brush_data ;
		DisplaySpinData spin_data ;
#endif /* ) NOTDEF */
		DisplayImageData image_data ;
		DisplayImageRgbaData image_rgba_data ;
	} u ;
	struct _DisplayListEntry *next ;
} DisplayListEntry ;

typedef struct _DisplayListHead {
	DisplayListEntry *head ;/* pointer to first entry in displaylist */
	DisplayListEntry *tail ;/* pointer to last entry in displaylist */
#ifndef NPARAMS
#define NPARAMS 200
#endif
	float bgrp[NPARAMS] ; /* local copy of am array, for saveam */
	/*
	 * the following two are for S_copy_displaylist.
	 * bgrp_orig will track all the diff's in the original
	 * displaylist, bgrp_copy will track all the diff's in
	 * the displaylist of the copy.  Each time a diff comes in
	 * to be copied, both will be updated.  Then they will
	 * be compared and bgrp_copy will be updated to track shape
	 * and scale changes in bgrp_orig (and a synthetic diff
	 * will be put into the copied displaylist).  When copy is
	 * done, one can copy bgrp_copy into bgrp (or bgrp might
	 * be replaced by bgrp_copy).
	 */
	/*
	 * resized will be true iff bgrp_orig & bgrp_copy differ in
	 * such a way that new scaling parameters need to be computed
	 */
	int resized ;
	float bgrp_orig[NPARAMS] ;
	float bgrp_copy[NPARAMS] ;
} DisplayListHead ;

extern void disp_zpntsz(float *x, float *y, long *n) ;
extern void disp_zpolyz(float *x, float *y, long *n) ;
extern void disp_zlinsz(float *x, float *y, long *n) ;
extern void disp_ztextz(float *x, float *y, char *text, long *n, float *adj) ;
extern void disp_zimagz(float *fx, float *fy, float *fz, long *nx, long *ny, long *nz, float *zmin, float *zmax, float *zmiss) ;
extern void disp_zimagz_rgba(float *fx, float *fy, float *fz, long *nx, long *ny, long *nz, float *zmin, float *zmax, float *zmiss, long *r, long *g, long *b, long *a, long *ncolors) ;
extern void disp_zsegsz(float *x0, float *y0, float *x1, float *y1, long *n) ;
extern void disp_saveam(void) ;
extern void disp_zinitz(float *amlist, long *n) ;
extern void disp_zejecz(void) ;
extern void disp_zwrapz(void) ;

extern DisplayListHead *disp_alloc_head(void) ;
extern DisplayListHead *disp_free_head(DisplayListHead *head) ;

extern void S_copy_displaylist(long *which) ;
extern void S_draw_displaylist(void);
extern void S_dump_displaylist(long *level) ;
extern void S_init_displaylist(void) ;
extern void S_inhibit_displaylist(void) ;

#endif /* !_S_DISPLIST_H_ )*/
