#ifndef S_EVENT_H
#define S_EVENT_H 1
#ifdef __cplusplus
extern "C"
{
#endif

#include <time.h>
#include <sys/time.h> /* neededed for Linux ?? */

#include <sys/times.h>

/* the following includes go beyond the Posix standard.  Some or all */
/* of them are empirically necessary to do selects and/or socket i/o */
#include <limits.h>

/* this should be defined in sys/times.h.  But if it isn't for some */
/* reason, define it here. The sysconf definition is Posix */
#ifndef CLK_TCK
#define CLK_TCK  sysconf(_SC_CLK_TCK)
#endif

/* the return value of times() is std System V (and Posix?) but for */
/* back-compatibility with, e.g., SunOS4, we put a define here to be edited*/
/* The SunOS4 definition is (times(b), (time_t)(time(0)) * CLK_TCK) */
#define TIMES(b) (times(b))

#ifndef S_LEVEL_THREADS
  /* the s_thread structure is temporary, pending true C-level
     threads.  It contains just enough information to support readers,
     waitThreads (aka monitors) and plain evaluation threads, with
     priorities but not synchronization primitives */
  enum s_thread_type {S_THREAD, S_READER, S_WAIT_THREAD,
		      N_THREAD_TYPES};

  struct s_thread_struct {
    enum s_thread_type Type; /* make it self-defining */
    struct s_evaluator_struct *Eval; /* the thread's evaluator */
    s_index Index; /* for readers/monitors, the index to arrays of par's */
    s_index Tag; /* unique tag to identify this thread */
    double priority;
  };
  typedef struct s_thread_struct s_thread;
#endif /* ndef S_LEVEL_THREADS */

  typedef long s_monitor_id;
#define NOT_A_MONITOR -1
#define NOT_A_READER -1
/* the structure of a single monitor */
struct s_monitor_struct {
  time_t time;
  s_object *call;
  s_object *interval;
  s_object *quit;
  s_monitor_id id;
};

typedef struct s_monitor_struct s_monitor;

/* the structure of a single reader */
/* Currently, the readers are driven from file descriptors and so are */
/* represented only as connections. (contrast monitors) */
typedef struct s_connection_struct s_reader;

/* the S event (task or subtask) structure */
struct s_event_struct {
  s_reader *reader;
  s_monitor *monitor;
  s_index taskid;
  struct s_event_struct *parent; /* if subtask*/
};

typedef struct s_event_struct s_event;

extern s_event *current_event;
extern void next_event(void);
extern time_t get_monitor_time(double from_now);
extern int check_time(time_t when);
extern int check_monitor(void);

#ifdef __cplusplus
}
#endif
#endif
