/* %Z%%Q% */
/* %Z%$RCSfile: guilink.h,v $ version $Revision: #22 $ created $Date: 2001/08/28 $ */

#ifndef _S_GUILINK_H_ /*(*/
#define _S_GUILINK_H_

/* Libraries may communicate using various communication mechanisms */
/* ORDINARY_LINK means 2 halves of driver are in same module, compiled
 * by same compiler, communicating by unadorned function calls
 */
#define ORDINARY_LINK 0
#define USING_EZRPC 1
#define UNIX_SHARED_MEMORY 2
/* DLL can link at build time or run time */
#define DLL_BUILD_TIME_LINK 3
#define DLL_RUN_TIME_LINK 4

#ifndef TRANSPORT /*(*/
#ifdef WIN32
#define TRANSPORT DLL_RUN_TIME_LINK
#else
#define TRANSPORT ORDINARY_LINK
#endif
#endif /*)*/

/* Name of the notification command for the IPC layer to call notification call on 
the GUI side through the IPC layer */
#define GUI_NOTIF_COMMAND_NAME  "notif_command"
#define TYPE_AND_POS "type_and_pos"
#define DB_NAME_AND_NAME "db_name_and_name"
#define METAINFO_OBJ    "metainfo_obj"
#define S_ABOVE         "S_above"
#define S_BELOW         "S_below"
#define S_AXUM_notify   S_notification


/* Name of the function of the GUI side to execute the parser commands sent from S+ */ 
#define GUI_PARSER_execute TxParserCommand
/* Name of the IPC command  for the parser command */
#define GUI_PARSER_COMMAND_NAME "gui_parser_command"


#if TRANSPORT==DLL_RUN_TIME_LINK || TRANSPORT==DLL_BUILD_TIME_LINK /*(*/
#if defined(txgedLIBRARY)  /*(*/
#define GuiExtern extern "C" LibExport  /* the IMPORTER is in the same module/DLL */
#else /*)(*/
#define GuiExtern LibImport   /* the IMPORTER is in different module/DLL */
#endif  /*)*/

#if TRANSPORT==DLL_RUN_TIME_LINK && !defined(txgedLIBRARY) /*(*/
#include <windows.h>
#include "S_ansi.h"
#include "S.h"

#ifdef guilinkDEFINE /*(*/
/* guilinkDEFINE ==> included by EXPORTING .c file */
#define INIT(x) = x
#define vextern
#else /*) guilinkDEFINE (*/
/* !guilinkDEFINE ==> included by IMPORTER of symbols */
#define INIT(x)
#define vextern extern
#endif /* ) guilinkDEFINE */

#define S_AXUM_CONNECTIONS	1	 /* number of distinct DLLs */
/* Each number below is the DLL # (within TX_DLL_NAMES) that 
   the functionality is currently in */
#define S_AXUM_2NDMSGLOOPLINK	0
#define S_AXUM_CMDWNDLINK	0
#define S_AXUM_MENUOBJLINK	0
#define S_AXUM_DYNDLGLINK	0
#define S_AXUM_EXECUTELINK	0 
#define S_AXUM_GRAPHLINK	0
#define S_AXUM_NOTIFYLINK	0
#define S_AXUM_OLELINK      0
#define OK_S_AXUM_LINK(id)	(is_ui_app("s+gui") && (id)>=0 && (id)<S_AXUM_CONNECTIONS)

#if defined(S_AXUM_DYNDLGLINK) /*(*/
#define DYNDLG_ARGDLGPROC	1
#define DYNDLG_SDLGPROC		2
#endif /*)*/

/* Assume DLL is in same dir as exe, or at least on the path. */
#define TX_DLL_NAMES {"spscl.dll" /* ,"second.dll" */}
vextern char *pAxumDllNames[S_AXUM_CONNECTIONS] INIT(TX_DLL_NAMES);
void LoadAxumDll(int iConnectionID);
void UnloadAxumDll(int iConnectionID);
vextern HINSTANCE hAxumDll[S_AXUM_CONNECTIONS] INIT({NULL});

#define SETUP_S_AXUM_CONNECTION(id) \
	LoadAxumDll(id)

#define PROTOTYPE_S_AXUM_CALL(type, function, args) \
	typedef type (__stdcall *CPP_CAT(_PFN_,function)) PARAMS(args); \
	CPP_CAT(_PFN_,function) CPP_CAT(pfn_,function)=NULL

#define AXUM_FUN_NAME(function, argslength) "_" QUOTE(function@argslength)

#define CALL_S_AXUM(id, upon_error, function, argslength, args) \
((!OK_S_AXUM_LINK(id) ||\
		CPP_CAT(pfn_,function)==NULL &&\
(CPP_CAT(pfn_,function)=(CPP_CAT(_PFN_,function))GetProcAddress(hAxumDll[id],AXUM_FUN_NAME(function,argslength)))==NULL) ?\
		PROBLEM "S_AXUM error finding function '%s' in library '%s'", AXUM_FUN_NAME(function,argslength), pAxumDllNames[id]\
		upon_error(NULL_ENTRY) , (*CPP_CAT(pfn_,function)) args  :\
	(*CPP_CAT(pfn_,function)) args)

#if 0
#define CALL_S_AXUM(id, upon_error, function, argslength, args) \
	if (!OK_S_AXUM_LINK(id) ||\
		CPP_CAT(pfn_,function)==NULL &&\
		(CPP_CAT(pfn_,function)=(CPP_CAT(_PFN_,function))GetProcAddress(hAxumDll[id],AXUM_FUN_NAME(function,argslength)))==NULL)\
		PROBLEM "S_AXUM error finding function '%s' in library '%s'", AXUM_FUN_NAME(function,argslength), pAxumDllNames[id]\
		upon_error(NULL_ENTRY);\
	else (*CPP_CAT(pfn_,function)) args
#endif

#define SHUTDOWN_S_AXUM_CONNECTION(id) \
	UnloadAxumDll(id)

#undef INIT
#undef vextern
#else /*)(*/
/*TRANSPORT==DLL_BUILD_TIME_LINK || module exporting functionality */
#define SETUP_S_AXUM_CONNECTION(id)

#define PROTOTYPE_S_AXUM_CALL(type, function, args) \
	GuiExtern type __stdcall function  PARAMS(args)

#define CALL_S_AXUM(id, upon_error, function, argslength, args) function args

#define SHUTDOWN_S_AXUM_CONNECTION(id)

#endif /*)*/ /* DLL_RUN_TIME_LINK */


#elif TRANSPORT==USING_EZRPC /*)(*/
/*TRANSPORT==EZRPC*/
#define SETUP_S_AXUM_CONNECTION(id)	???
#define PROTOTYPE_S_AXUM_CALL(type, function, args)	??? rpc_stub type CPP_CAT(rpc,function args)
#define CALL_S_AXUM(id, upon_error, function, argslength, args)	CPP_CAT(rpc,function) args
#define SHUTDOWN_S_AXUM_CONNECTION(id) ???

#elif TRANSPORT==ORDINARY_LINK	/*)(*/

#define SETUP_S_AXUM_CONNECTION(id)
#define PROTOTYPE_S_AXUM_CALL(type, function, args) type function PARAMS(args)
#define CALL_S_AXUM(id, upon_error, function, argslength, args) \
	PROBLEM "function %s not available", QUOTE(function) upon_error(NULL_ENTRY)
#define SHUTDOWN_S_AXUM_CONNECTION(id)

#else /*)(*/ /********** TRANSPORT not defined! **************/
/* leave things undefined to force compiler to set TRANSPORT */
#endif /*)*/ /********** TRANSPORT **************/

#endif /*)*/
