#ifndef STRING_CLASS_H

#define STRING_CLASS_H 1
#ifdef __cplusplus
extern "C" {
#endif

extern s_class *s_string_class;
extern void init_string_class(s_evaluator *S_evaluator);
extern void get_string_slots(s_object *object,
		      s_object **offsets,
		      s_object **text,
		      s_object **string_table,
		      s_object **levels_table);
extern void set_string_slots(s_object *object,
		      s_object *offsets,
		      s_object *text,
		      s_object *string_table,
		      s_object *levels_table, s_evaluator *S_evaluator);
extern long count_string_offsets(s_object *offsets, s_evaluator *S_evaluator);
extern s_object *new_string_object(s_object *offsets,
				   s_object *text,
				   s_object *string_table,
				   s_object *levels);
extern s_object *s_string_to_character(s_object *string_object);
extern s_object *s_character_to_string(s_object *data, s_object *make_table,
				s_object *s_make_levels, s_object *na_string_obj);
extern s_object *s_match_strings(s_object *dataset, s_object *new_strings,
			  s_boolean insert);
extern s_object *string_table_alloc(long length, double open_ratio, long frame, s_evaluator *S_evaluator);
extern s_index char_string_lookup(const char *name, long *probe_p, s_object *string_table,
		      s_object *text_buffer, long *enter_here, s_evaluator *S_evaluator);
extern s_object *char_string_enter(s_object *string_table, s_object *text_buffer, char *name, long probe,
		       long pos, s_index offset1, s_evaluator *S_evaluator);
extern s_object *set_string_levels(s_object *object, s_object *levels);
extern s_object *get_string_levels(s_object *object);
extern s_object *do_subset_string(s_object *offsets, s_object *data);
extern s_object *get_levels(s_object *obj);
extern s_object *s_levels_index(s_object *object, s_object *make_factor);
extern s_object *subset_string(s_object *data, s_object *subset,
			       s_object *replacement);
extern s_object *s_maybe_levels_index(s_object *object, s_object *make_factor,
		     s_boolean force, s_evaluator *S_evaluator);


/* some defines for hash tables as S objects.  These are not dependent
   on string issues and should eventually migrate, along with
   corresponding utilities s_table_alloc, s_table_expand */
enum s_table_slots  {HLEN_SLOT, TLEN_SLOT, NENTRY_SLOT, OPEN_R_SLOT,
		     TDELTA_SLOT, UNHASHED_CTR_SLOT, ENTRY_WIDTH_SLOT,
		     EXTRA_HEADER_SLOT, S_HEADER_LENGTH}; 
/* open_ratios are stored as integers == float * TABLE_DELTA */
#define TABLE_DELTA 4.
/* although the values in the entry are stored as longs, they are
   notionally indexes.  If the particular table class allows
   unhashing, the unhashing operation stores this pattern in the first
   element of the entry.  */
#define S_UNHASHED_MARKER -1
extern s_object *s_table_alloc(long length, double open_ratio, long frame,
			       int width, int extra_headers, s_evaluator *S_evaluator);
/* the string table class:  an integer vector, with the first
   STRING_HEADER_LENGTH elements used for pseudo-slots */

enum string_table_slots {PROBE_CODE_SLOT = S_HEADER_LENGTH,
			 STRING_HEADER_LENGTH};
/* the string_table structure allows for future expansion of string
   hashing algorithms.  To do so, expand this enum */
enum s_string_probe_codes {DEFAULT_PROBE_CODE};
/* and extend the following to choose the suitable hash function */
#define STRING_HASH(s, code) charmash((char *)s)

/* the levels table class. Really a vanilla index table, but needing
   to extract & update the levels table slot in a string object */
#define LEVELS_WIDTH 2
#define LEVELS_HEADER_LENGTH S_HEADER_LENGTH

enum s_levels_type {NO_LEVELS, OFFSET_LEVELS, TEXT_LEVELS,
		      POSITION_LEVELS, CHAR_LEVELS, STRING_LEVELS, N_LEVELS_TYPES};

extern s_object *levels_table_alloc(long length, double open_ratio, long frame, s_evaluator *S_evaluator);
extern s_object *levels_enter(s_object *levels_table, long pos,
			      s_index what, s_index value, s_evaluator *S_evaluator);
extern s_index levels_lookup(s_index what, s_object*levels_table, long
			     *enter_here, s_evaluator *S_evaluator);
extern s_boolean levels_table_expand(s_object *levels_table, s_evaluator *S_evaluator);

extern s_object *string_to_factor(s_object *x);

extern s_object *do_standard_levels(s_object *object, s_evaluator *S_evaluator);

#ifdef __cplusplus
}
#endif
#endif
