<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output method="xml" standalone="yes" indent="yes"/>
	<xsl:template name="transformRoot" match="/">
		<xsl:element name="S-PLUS">
			<xsl:call-template name="transformNode"/>
		</xsl:element>
	</xsl:template>
	<xsl:template name="transformNode">
		<xsl:element name="List">
			<xsl:attribute name="length"><xsl:value-of select="(count(@*) !=0) + count(*) + (string-length(text()) !=0)"/></xsl:attribute>
			<xsl:attribute name="name"><xsl:value-of select="local-name()"/></xsl:attribute>
			<xsl:element name="Components">
				<!-- Add attributes element -->
				<xsl:call-template name="addAttrsComponent"/>
				<!-- Add child nodes -->
				<xsl:for-each select="*">
					<xsl:element name="Component">
						<xsl:call-template name="transformNode"/>
					</xsl:element>
				</xsl:for-each>
				<!-- Add text  -->
				<xsl:call-template name="addTextComponent"/>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<xsl:template name="addAttrsComponent">
		<xsl:param name="attrCount">
			<xsl:value-of select="count(@*)"/>
		</xsl:param>
		<xsl:if test="$attrCount !=0">
			<xsl:element name="Component">
				<xsl:element name="Generic">
					<xsl:attribute name="class">named</xsl:attribute>
					<xsl:attribute name="name">xmlAttrs</xsl:attribute>
					<xsl:element name="Attrs">
						<xsl:attribute name="length">1</xsl:attribute>
						<xsl:element name="Attr">
							<xsl:attribute name="name">.Names</xsl:attribute>
							<xsl:element name="Vector">
								<xsl:attribute name="length"><xsl:value-of select="$attrCount"/></xsl:attribute>
								<xsl:attribute name="type">character</xsl:attribute>
								<xsl:attribute name="name">.Names</xsl:attribute>
								<xsl:element name="Items">
									<xsl:for-each select="@*">
										<xsl:element name="Item">
											<xsl:value-of select="local-name()"/>
										</xsl:element>
									</xsl:for-each>
								</xsl:element>
							</xsl:element>
						</xsl:element>
					</xsl:element>
					<xsl:element name="Vector">
						<xsl:attribute name="length"><xsl:value-of select="$attrCount"/></xsl:attribute>
						<xsl:attribute name="type">character</xsl:attribute>
						<xsl:element name="Items">
							<xsl:for-each select="@*">
								<xsl:element name="Item">
									<xsl:value-of select="."/>
								</xsl:element>
							</xsl:for-each>
						</xsl:element>
					</xsl:element>
				</xsl:element>
			</xsl:element>
		</xsl:if>
	</xsl:template>
	<xsl:template name="addTextComponent">
		<xsl:variable name="textValue">
			<xsl:value-of select="text()"/>
		</xsl:variable>
		<xsl:if test="string-length($textValue) != 0">
			<xsl:element name="Component">
				<xsl:element name="Vector">
					<xsl:attribute name="length">1</xsl:attribute>
					<xsl:attribute name="type">character</xsl:attribute>
					<xsl:attribute name="name">xmlText</xsl:attribute>
					<xsl:element name="Items">
						<xsl:element name="Item">
							<xsl:value-of select="$textValue"/>
						</xsl:element>
					</xsl:element>
				</xsl:element>
			</xsl:element>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>
