<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:decimal-format name="blankNaN" NaN=" "/>

	<!-- XSL style sheet for SurvivalModel element -->
	<xsl:attribute-set name="title">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">20pt</xsl:attribute>
		<xsl:attribute name="line-height">24pt</xsl:attribute>
		<xsl:attribute name="space-after">10pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="bold-emph">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">16pt</xsl:attribute>
		<xsl:attribute name="line-height">20pt</xsl:attribute>
		<xsl:attribute name="space-after">2pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="small-cap">
		<xsl:attribute name="font-variant">small-caps</xsl:attribute>
		<xsl:attribute name="font-size">14pt</xsl:attribute>
		<xsl:attribute name="line-height">18pt</xsl:attribute>
		<xsl:attribute name="space-after">2pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="body">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="line-height">14pt</xsl:attribute>
		<xsl:attribute name="space-after">2pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="bold-body">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="line-height">14pt</xsl:attribute>
		<xsl:attribute name="space-after">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="header">
		<xsl:attribute name="text-align">right</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="border-after-color">#82C0FF</xsl:attribute>
		<xsl:attribute name="border-after-style">double</xsl:attribute>
		<xsl:attribute name="border-after-width">2pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="cell">
		<xsl:attribute name="text-align">right</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="row-header">
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="left">
		<xsl:attribute name="border-start-color">#82C0FF</xsl:attribute>
		<xsl:attribute name="border-start-style">double</xsl:attribute>
		<xsl:attribute name="border-start-width">2pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="right">
		<xsl:attribute name="border-end-color">#82C0FF</xsl:attribute>
		<xsl:attribute name="border-end-style">double</xsl:attribute>
		<xsl:attribute name="border-start-width">2pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="top">
		<xsl:attribute name="border-before-color">#82C0FF</xsl:attribute>
		<xsl:attribute name="border-before-style">double</xsl:attribute>
		<xsl:attribute name="border-before-width">2pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="bottom">
		<xsl:attribute name="border-after-color">#82C0FF</xsl:attribute>
		<xsl:attribute name="border-after-style">double</xsl:attribute>
		<xsl:attribute name="border-after-width">2pt</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="table-atts">
		<xsl:attribute name="border-before-color">#82C0FF</xsl:attribute>
		<xsl:attribute name="border-before-style">double</xsl:attribute>
		<xsl:attribute name="border-before-width">6pt</xsl:attribute>
		<xsl:attribute name="border-start-color">#82C0FF</xsl:attribute>
		<xsl:attribute name="border-start-style">double</xsl:attribute>
		<xsl:attribute name="border-start-width">3pt</xsl:attribute>
		<xsl:attribute name="border-after-color">#82C0FF</xsl:attribute>
		<xsl:attribute name="border-after-style">double</xsl:attribute>
		<xsl:attribute name="border-after-width">3pt</xsl:attribute>
		<xsl:attribute name="border-end-color">#82C0FF</xsl:attribute>
		<xsl:attribute name="border-end-style">double</xsl:attribute>
		<xsl:attribute name="border-end-width">3pt</xsl:attribute>
	</xsl:attribute-set>
	

	<xsl:template match="/">
		<fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format">
			<fo:layout-master-set>
				<fo:simple-page-master master-name="page">
					<fo:region-body region-name="body" margin-top="0.5in" margin-bottom="0.5in" margin-left="0.5in" margin-right="0.5in" />
				</fo:simple-page-master>
			</fo:layout-master-set>
			
			<fo:page-sequence master-reference="page">
				<fo:flow flow-name="body">
					<fo:block>
						<xsl:apply-templates />
					</fo:block>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>

	<xsl:template match="XML">
		<xsl:apply-templates select="IMML"/>
	</xsl:template>

	<xsl:template match="IMML">
		<fo:block xsl:use-attribute-sets="title"><xsl:value-of select="DisplayOptions/@title"/></fo:block>

		<xsl:apply-templates select="SurvivalModel"/>
	</xsl:template>

	<xsl:template match="SurvivalModel">
		<fo:block xsl:use-attribute-sets="small-cap">
			<xsl:text>Survival response: </xsl:text>
			<xsl:apply-templates select="SurvResponse"/>
		</fo:block>
		
		<xsl:apply-templates select="Coefficients"/>
		<xsl:apply-templates select="SurvModelStats/LikelihoodRatio"/>
		<xsl:apply-templates select="SurvivalDist"/>
	</xsl:template>

	<xsl:template match="SurvResponse">
		<xsl:text>event=</xsl:text>
		<xsl:value-of select="@event"/>
		<xsl:if test="@start">
			<xsl:text>, start time=</xsl:text>
			<xsl:value-of select="@start"/>
		</xsl:if>
		<xsl:text>, time of failure=</xsl:text>
		<xsl:value-of select="@stop"/>
	</xsl:template>

	<xsl:template match="Coefficients">
		<fo:table xsl:use-attribute-sets="table-atts" table-layout="fixed">
			<xsl:element name="fo:table-column">
				<xsl:attribute name="column-number">1</xsl:attribute>
				<xsl:attribute name="column-width">
					<xsl:call-template name="CoefNameWidth">
						<xsl:with-param name="element" select="." />
						<xsl:with-param name="TotalNum" select="count(./Coef)" />
					</xsl:call-template>pt
				</xsl:attribute>
			</xsl:element>
			<fo:table-column column-number="2" column-width="80pt" />
			<fo:table-column column-number="3" column-width="80pt" />
			<fo:table-column column-number="4" column-width="80pt" />
			<fo:table-column column-number="5" column-width="80pt" />
			<fo:table-column column-number="6" column-width="80pt" />
	
			<fo:table-header>
				<fo:table-row background-color="#82C0FF">
					<fo:table-cell number-columns-spanned="6" xsl:use-attribute-sets="row-header left right top bottom"><fo:block>Coefficient Estimates</fo:block></fo:table-cell>
				</fo:table-row>
				<fo:table-row background-color="#CCE6FF">
					<fo:table-cell xsl:use-attribute-sets="row-header left right top bottom"><fo:block>Variable</fo:block></fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="header left right top bottom"><fo:block>Estimate</fo:block></fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="header left right top bottom"><fo:block>EXP(Estimate)</fo:block></fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="header left right top bottom"><fo:block>Std.Err.</fo:block></fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="header left right top bottom"><fo:block>z-Statistic</fo:block></fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="header left right top bottom"><fo:block>Pr(z)</fo:block></fo:table-cell>
				</fo:table-row>
			</fo:table-header>
	
			<fo:table-body>
				<xsl:apply-templates select="Coef"/>
			</fo:table-body>
		</fo:table>
	</xsl:template>

	<xsl:template name="CoefNameWidth">
		<xsl:param name="element" select="''" />
		<xsl:param name="CurrentNum" select="0" />
		<xsl:param name="TotalNum" select="0" />
		<xsl:param name="minWidth" select="50" />
		<xsl:param name="maxWidth" select="0" />

		<xsl:variable name="this" select="$element/Coef[$CurrentNum]/@name" />
		<xsl:variable name="thisWidth" select="string-length($this) * 7" />

		<xsl:choose>
			<xsl:when test="$TotalNum = $CurrentNum">
				<xsl:choose>
					<xsl:when test="$thisWidth &gt; $maxWidth">
						<xsl:choose>
							<xsl:when test="$minWidth &gt; $thisWidth"><xsl:value-of select="$minWidth"/></xsl:when>
							<xsl:otherwise><xsl:value-of select="$thisWidth"/></xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="$minWidth &gt; $maxWidth"><xsl:value-of select="$minWidth"/></xsl:when>
							<xsl:otherwise><xsl:value-of select="$maxWidth"/></xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="$thisWidth &gt; $maxWidth">
						<xsl:call-template name="CoefNameWidth">
							<xsl:with-param name="element" select="$element" />
							<xsl:with-param name="CurrentNum" select="$CurrentNum + 1" />
							<xsl:with-param name="TotalNum" select="$TotalNum" />
							<xsl:with-param name="maxWidth" select="$thisWidth"/>
							<xsl:with-param name="minWidth" select="$minWidth"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="CoefNameWidth">
							<xsl:with-param name="element" select="$element" />
							<xsl:with-param name="CurrentNum" select="$CurrentNum + 1" />
							<xsl:with-param name="TotalNum" select="$TotalNum" />
							<xsl:with-param name="maxWidth" select="$maxWidth"/>
							<xsl:with-param name="minWidth" select="$minWidth"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="Coef">
		<xsl:variable name="decimalPattern" select="../../../DisplayOptions/@decimalPattern"/>
		<xsl:variable name="scientificPattern" select="../../../DisplayOptions/@scientificPattern"/>

		<xsl:element name="fo:table-row">
			<xsl:attribute name="background-color"><xsl:choose><xsl:when test="position() mod 2 = 1">#FFFFFF</xsl:when><xsl:otherwise>#EEEEEE</xsl:otherwise></xsl:choose></xsl:attribute>
			
			<fo:table-cell xsl:use-attribute-sets="row-header top bottom left right"><fo:block>
				<xsl:value-of select="@name"/>
			</fo:block></fo:table-cell >

			<fo:table-cell xsl:use-attribute-sets="cell top bottom left right"><fo:block>
				<xsl:call-template name="roundNumber">
					<xsl:with-param name="string" select="@value"/>
					<xsl:with-param name="NaNstring" select="'NaN'"/>
					<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
					<xsl:with-param name="scientificPattern" select="$scientificPattern"/>
				</xsl:call-template>
			</fo:block></fo:table-cell >

			<fo:table-cell xsl:use-attribute-sets="cell top bottom left right"><fo:block>
				<xsl:call-template name="roundNumber">
					<xsl:with-param name="string" select="@expCoef"/>
					<xsl:with-param name="NaNstring" select="'NaN'"/>
					<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
					<xsl:with-param name="scientificPattern" select="$scientificPattern"/>
				</xsl:call-template>
			</fo:block></fo:table-cell >

			<fo:table-cell xsl:use-attribute-sets="cell top bottom left right"><fo:block>
				<xsl:call-template name="roundNumber">
					<xsl:with-param name="string" select="@stdErr"/>
					<xsl:with-param name="NaNstring" select="'NaN'"/>
					<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
					<xsl:with-param name="scientificPattern" select="$scientificPattern"/>
				</xsl:call-template>
			</fo:block></fo:table-cell >

			<fo:table-cell xsl:use-attribute-sets="cell top bottom left right"><fo:block>
				<xsl:call-template name="roundNumber">
					<xsl:with-param name="string" select="@z"/>
					<xsl:with-param name="NaNstring" select="'NaN'"/>
					<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
					<xsl:with-param name="scientificPattern" select="$scientificPattern"/>
				</xsl:call-template>
			</fo:block></fo:table-cell >

			<fo:table-cell xsl:use-attribute-sets="cell top bottom left right"><fo:block>
				<xsl:call-template name="roundNumber">
					<xsl:with-param name="string" select="@Pr"/>
					<xsl:with-param name="NaNstring" select="'NaN'"/>
					<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
					<xsl:with-param name="scientificPattern" select="$scientificPattern"/>
				</xsl:call-template>
			</fo:block></fo:table-cell >
		</xsl:element>
	</xsl:template>

	<xsl:template match="SurvModelStats/LikelihoodRatio">
		<xsl:variable name="decimalPattern" select="../../../DisplayOptions/@decimalPattern"/>
		<xsl:variable name="scientificPattern" select="../../../DisplayOptions/@scientificPattern"/>

		<fo:block space-before="5pt">
			<xsl:text>Number of observations = </xsl:text>
			<xsl:value-of select="@N"/>
		</fo:block>
		
		<fo:block space-before="5pt">
			<xsl:text>Likelihood ratio test = </xsl:text>
			<xsl:call-template name="roundNumber">
				<xsl:with-param name="string" select="@value"/>
				<xsl:with-param name="NaNstring" select="'NaN'"/>
				<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
				<xsl:with-param name="scientificPattern" select="$scientificPattern"/>
			</xsl:call-template>
			<xsl:text> on </xsl:text>
			<xsl:value-of select="@df"/>
			<xsl:text> degrees of freedom, probability = </xsl:text>
			<xsl:call-template name="roundNumber">
				<xsl:with-param name="string" select="@Pr"/>
				<xsl:with-param name="NaNstring" select="'NaN'"/>
				<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
				<xsl:with-param name="scientificPattern" select="$scientificPattern"/>
			</xsl:call-template>
		</fo:block>
	</xsl:template>

	<xsl:template match="SurvivalDist">
		<fo:table xsl:use-attribute-sets="table-atts" table-layout="fixed">
			<fo:table-column column-number="1" column-width="100pt" />
			<fo:table-column column-number="2" column-width="100pt" />
			<fo:table-column column-number="3" column-width="100pt" />
			<fo:table-column column-number="4" column-width="100pt" />
			<fo:table-column column-number="5" column-width="100pt" />
	
			<fo:table-header>
				<fo:table-row background-color="#82C0FF">
					<fo:table-cell number-columns-spanned="5" xsl:use-attribute-sets="row-header left right top bottom"><fo:block>Survival Distribution Estimates</fo:block></fo:table-cell>
				</fo:table-row>
				<fo:table-row background-color="#CCE6FF">
					<fo:table-cell xsl:use-attribute-sets="header left right top bottom"><fo:block>Time</fo:block></fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="header left right top bottom"><fo:block>Failures</fo:block></fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="header left right top bottom"><fo:block>Risk Set</fo:block></fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="header left right top bottom"><fo:block>Survival</fo:block></fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="header left right top bottom"><fo:block>Std. Error</fo:block></fo:table-cell>
				</fo:table-row>
			</fo:table-header>
	
			<fo:table-body>
				<xsl:apply-templates select="FailPoint"/>
			</fo:table-body>
		</fo:table>
	</xsl:template>

	<xsl:template match="FailPoint">
		<xsl:variable name="decimalPattern" select="../../../DisplayOptions/@decimalPattern"/>
		<xsl:variable name="scientificPattern" select="../../../DisplayOptions/@scientificPattern"/>

		<xsl:element name="fo:table-row">
			<xsl:attribute name="background-color"><xsl:choose><xsl:when test="position() mod 2 = 1">#FFFFFF</xsl:when><xsl:otherwise>#EEEEEE</xsl:otherwise></xsl:choose></xsl:attribute>

			<fo:table-cell xsl:use-attribute-sets="cell top bottom left right"><fo:block>
				<xsl:call-template name="roundNumber">
					<xsl:with-param name="string" select="@time"/>
					<xsl:with-param name="NaNstring" select="'NaN'"/>
					<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
					<xsl:with-param name="scientificPattern" select="$scientificPattern"/>
				</xsl:call-template>
			</fo:block></fo:table-cell >

			<fo:table-cell xsl:use-attribute-sets="cell top bottom left right"><fo:block>
				<xsl:call-template name="roundNumber">
					<xsl:with-param name="string" select="@failures"/>
					<xsl:with-param name="NaNstring" select="'NaN'"/>
					<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
					<xsl:with-param name="scientificPattern" select="$scientificPattern"/>
				</xsl:call-template>
			</fo:block></fo:table-cell >

			<fo:table-cell xsl:use-attribute-sets="cell top bottom left right"><fo:block>
				<xsl:call-template name="roundNumber">
					<xsl:with-param name="string" select="@riskSet"/>
					<xsl:with-param name="NaNstring" select="'NaN'"/>
					<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
					<xsl:with-param name="scientificPattern" select="$scientificPattern"/>
				</xsl:call-template>
			</fo:block></fo:table-cell >

			<fo:table-cell xsl:use-attribute-sets="cell top bottom left right"><fo:block>
				<xsl:call-template name="roundNumber">
					<xsl:with-param name="string" select="@survival"/>
					<xsl:with-param name="NaNstring" select="'NaN'"/>
					<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
					<xsl:with-param name="scientificPattern" select="$scientificPattern"/>
				</xsl:call-template>
			</fo:block></fo:table-cell >

			<fo:table-cell xsl:use-attribute-sets="cell top bottom left right"><fo:block>
				<xsl:call-template name="roundNumber">
					<xsl:with-param name="string" select="@stdErr"/>
					<xsl:with-param name="NaNstring" select="'NaN'"/>
					<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
					<xsl:with-param name="scientificPattern" select="$scientificPattern"/>
				</xsl:call-template>
			</fo:block></fo:table-cell >
		</xsl:element>
	</xsl:template>

	<xsl:template name="roundNumber">
		<xsl:param name="string" select="''"/>
		<xsl:param name="NaNstring" select="''"/>
		<xsl:param name="decimalPattern" select="''"/>
		<xsl:param name="scientificPattern" select="''"/>
		<xsl:variable name="lowerCasePattern" select="'e'"/>
		<xsl:variable name="upperCasePattern" select="'E'"/>
		<xsl:choose>
			<xsl:when test="$string = 'NaN'">
				<xsl:value-of select="$NaNstring"/>
			</xsl:when>
			<xsl:when test="string-length($string) = 0">
				<xsl:value-of select="$NaNstring"/>
			</xsl:when>
			<xsl:when test="contains($string, $lowerCasePattern)">
				<xsl:call-template name="outputRoundedScientific">
					<xsl:with-param name="valueString" select="substring-before($string, $lowerCasePattern)"/>
					<xsl:with-param name="exponentString" select="substring-after($string, $lowerCasePattern)"/>
					<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="contains($string, $upperCasePattern)">
				<xsl:call-template name="outputRoundedScientific">
					<xsl:with-param name="valueString" select="substring-before($string, $upperCasePattern)"/>
					<xsl:with-param name="exponentString" select="substring-after($string, $upperCasePattern)"/>
					<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="format-number($string, $decimalPattern) != format-number(0, $decimalPattern)">
						<xsl:value-of select="format-number($string, $decimalPattern)"/>
					</xsl:when>
					<xsl:when test="$string = 0">
						<xsl:value-of select="format-number($string, $decimalPattern)"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="format-number($string, $scientificPattern)"/>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:text/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="outputRoundedScientific">
		<xsl:param name="valueString" select="''"/>
		<xsl:param name="exponentString" select="''"/>
		<xsl:param name="decimalPattern" select="''"/>
		<xsl:value-of select="format-number($valueString, $decimalPattern)"/>E<xsl:value-of select="format-number($exponentString, '#0')"/>
	</xsl:template>
</xsl:stylesheet>
