/* @(#) Copyright (c) 2002, 2006 Insightful, Inc.  All rights reserved. */

/*  SplusEngine.java  */

package ejbsplus;

import java.rmi.RemoteException;
import javax.ejb.EJBObject;
import javax.ejb.CreateException;
import com.insightful.splus.SplusDataResult;
import ejbsplus.SplusEngineException;

/** 
* This is an interface for interacting with S-PLUS from an EJB container
*/ 
public interface SplusEngine extends EJBObject {

	/**
	* This method send an expression to S-PLUS.
	*
	* @param  expr   S-PLUS expression to evaluate.
	*/
	public SplusDataResult eval(String expr, SplusEngineClient client)
				throws RemoteException, SplusEngineException;
}

