/* @(#) Copyright (c) 2002, 2006 Insightful, Inc.  All rights reserved. */

/*  SplusEngineEJB.java  */

package ejbsplus;

import java.rmi.RemoteException;
import javax.ejb.*;
import com.insightful.splus.*;
import ejbsplus.SplusEngineException;

/** 
* This class is an EJB for interacting with S-PLUS
*/ 
public class SplusEngineEJB implements SessionBean {

	private String shome = null;
	private SplusSession session = null;
	private SplusEngineClient client = null;

	// S-PLUS login information
	private String m_host = null;
	private String m_username = null;
	private String m_password = null;
	private int m_rmiPort = 1099;	// FIXME: RMI port is hard-coded
	private String m_workingDirectory = "";
	private String m_xDisplay = "";
	private String m_prompt = "";
	private String m_script = "";


	// EJB required methods

	private SessionContext context;

	public void setSessionContext(SessionContext newcontext) {
		context = newcontext;
	}

	public void ejbPassivate() { hangup(); }

	public void ejbActivate() {}

	public void ejbCreate() throws RemoteException, CreateException, SplusEngineException {
		// must have SHOME or we can't do anything
		try {
			shome = System.getProperty("splus.shome", "");
		} catch (Exception ex) {
			//  FIXME: need handling of security exceptions.
			ex.printStackTrace();
			throw new SplusEngineException(
				"Bad security when getting \"splus.shome\"!");
		}
		if (shome.length() == 0)
			throw new SplusEngineException(
			  "Property \"splus.shome\" must be set on server!");

		// FIXME: should validate SHOME path.

		// This property will be needed for Splus client command
		System.setProperty("splus.client.mode", "true");
		// don't connect yet - wait for first query.
	}

	public void ejbRemove() { hangup(); }


	// private utility methods

	private void connect() throws SplusEngineException {

		if (session != null)
			return;
		if (m_username == null) {  // else connect vars already set
		    try {
			String [] login = client.getLoginData();
			m_host = login[0];
			m_username = login[1];
			m_password = login[2];
			// accept presets for all other parameters.

		    } catch (Exception ex) {
			ex.printStackTrace();
			throw new SplusEngineException(ex.getMessage());
		    }
		}
		//  Assume we have a cancelled login if any info is missing
		if (	m_host == null || m_host.length() == 0 ||
			m_username == null || m_username.length() == 0 ||
			m_password == null || m_password.length() == 0) {
		    throw new SplusEngineException("Login cancelled");
		}
		try {
			// m_host may be of the form hostname:1099
			// parse out RMI port from m_host if necessary
			int split = m_host.indexOf(":");
			if (split > -1) {
				m_rmiPort = Integer.decode(
					     m_host.substring(
					      split+1)).intValue();
				m_host = m_host.substring(0, split);
			}
			SplusLogin login = new SplusLogin();
			session = login.newSession( 	m_host, 
							m_username, 
							m_password,
							m_rmiPort, 
							m_workingDirectory,
							m_xDisplay,
							m_prompt,
							m_script,
							new String[0]);  
		} catch (Exception ex) {
			throw new SplusEngineException(ex.getMessage());
		}
		try {
			//  FIXME: This is a hack.  Use of ClientObjectFactory
			//  has not been defined in EJB case.
			session.setClientObjectFactory(
					new ClientObjectFactoryImpl());
		} catch (Exception ex) {
			throw new SplusEngineException(ex.getMessage());
		}
	}

	private void hangup() {
		if (session != null) {
			try { 
				session.sessionExit(false);
			} catch (Exception ex) {}
			session = null;
		}
	}

	private void reconnect() throws SplusEngineException { 
		hangup();
		connect(); 
	}

	private SplusSession getSession() throws SplusEngineException {
		if (session == null) connect();
		return session;
	}

	// public interface methods

	/**
	* This method send an expression to S-PLUS.
	*
	* @param  expr   S-PLUS expression to evaluate.
	*/
	public SplusDataResult eval(String expr, SplusEngineClient user)
				throws RemoteException, SplusEngineException {
		client = user;	// who to query for login parameters
		SplusDataResult answer = null;
		try {
			//  FIXME: For this test, get all query data.
			//  Streamline this in a production environment.
			answer = getSession().evalDataQuery(expr, true,
					true, true, true, true, 2, true, true);
		} catch (Exception ex) {
			if (ex.getMessage().equals("Login cancelled"))
				System.out.println("S-PLUS login cancelled");
			else
				ex.printStackTrace();
		}
		return answer;
	}
}
