/**
 * AddConnectionServlet allows an administrator to
 *   add an S-PLUS connection to a Web application
 *   running an SpConnectionManager object.
 *
 * author Gary Nelson, gnelson@insightful.com
 * version 24 April 2001
 */

import java.io.*;
import java.util.*;
import java.rmi.RemoteException;
import javax.servlet.*;         // comes with Tomcat
import javax.servlet.http.*;    // comes with Tomcat


public class AddConnectionServlet extends HttpServlet
{
	/* S-PLUS connection manager for this Web site */
	protected SpConnectionManager m_mgr = null;

	/* Initialize the servlet. */
	public void init()
	throws ServletException
	{
		// Get a connections manager for S+AS 2.0.
		m_mgr = SpConnectionManager.getManager(
			getServletContext());
	}

	/* Shut down the servlet. */
	public void destroy() {
		m_mgr.release();
	}

	/* Respond to a GET request. */
	protected void doGet(HttpServletRequest req,
		HttpServletResponse resp)
	throws ServletException, IOException
	{
		// Get the friendly name for the connection.
		String strFriendlyName = req.getParameter("FriendlyName");
		if (strFriendlyName == null) {
			strFriendlyName = "";
		}

		// Create a connection.
		SpConnection con = new SpConnection(strFriendlyName);

		// Set the logon parameters.
		con.setHost(req.getParameter("Host"));
		con.setUsername(req.getParameter("Username"));
		con.setPassword(req.getParameter("Password"));
		con.setRMIPort(req.getParameter("RMIPort"));
		con.setWorkingDirectory(req.getParameter("WorkingDirectory"));
		con.setXDisplay(req.getParameter("XDisplay"));
		con.setPrompt(req.getParameter("Prompt"));
		con.setScript(req.getParameter("Script"));

		// Connect.
		if (con.connect()) {
			m_mgr.addNewConnection(con);
			sendConfirmationPage(resp, strFriendlyName);
		}
		else {
			sendErrorPage(resp, con.getLastError());
		}
	}

	/* Respond to a POST request. */
	protected void doPost(HttpServletRequest req,
		HttpServletResponse resp)
	throws ServletException, IOException
	{
		doGet(req, resp);
	}

	/* Send an HTML page with error information. */
	protected void sendErrorPage(HttpServletResponse resp,
		String strError)
	throws IOException
	{
		// Using a sting buffer allows us to report
		//   the length of the page.
		StringBuffer buf = new StringBuffer();
		buf.append("<HTML>\n");
		buf.append("<HEAD>\n");
		buf.append("<TITLE>Error</TITLE>\n");
		buf.append("</HEAD>\n");
		buf.append("<BODY>\n");

		buf.append("<H1>Error Adding Connection</H1>\n");
		buf.append("<BLOCKQUOTE><PRE>\n" + strError +
			"\n</PRE></BLOCKQUOTE>\n");

		buf.append("<P>\n");
		buf.append("Use your browser's Back button ");
		buf.append("to go back to the last good page.\n");

		buf.append("</BODY>\n");
		buf.append("</HTML>");

		// Pass the response to the client.
		resp.setContentType("text/html");
		resp.setContentLength(buf.length());
		resp.getOutputStream().print(buf.toString());
	}

	/* Send an HTML page to load the Graphlet. */
	protected void sendConfirmationPage(HttpServletResponse resp,
		String strFriendlyName)
	throws IOException
	{
		// Using a sting buffer allows us to report
		//   the length of the page.
		StringBuffer buf = new StringBuffer();
		buf.append("<HTML>\n");
		buf.append("<HEAD>\n");
		buf.append("<TITLE>Connection Added</TITLE>\n");
		buf.append("</HEAD>\n");
		buf.append("<BODY>\n");

		buf.append("<H1>New Connection</H1>\n");
		buf.append("<BLOCKQUOTE>\n" + 
			"Connection \"" + strFriendlyName +
			"\" successfully added.\n" +
			"</BLOCKQUOTE>\n");

		buf.append("</BODY>\n");
		buf.append("</HTML>");

		// Pass the response to the client.
		resp.setContentType("text/html");
		resp.setContentLength(buf.length());
		resp.getOutputStream().print(buf.toString());
	}
}
