# library(maps)

## Set the color scheme.

#	java.colorscheme.user.1 <- java.colorscheme.user.1
#	java.colorscheme.user.1$palette <- rbind(c(0, 0, 0),
#		matrix(c(rep(round(seq(255, 0, length = 15)), 2), rep(255, 15)),
#		ncol = 3))
#	java.colorscheme.user.1$image <-
#		matrix(c(255:0, 255:0, rep(255, 256)), ncol = 3)


java.graph(file = "StateSelect.spj",
	colorscheme=java.colorscheme.user.1)

#########################################
## Scatter Plot, income vs. education
#########################################

plot(state.x77[ , "HS Grad"], state.x77[ , "Income"],
	main="Income vs. Education",
	xlab = "High School Graduation Rate (percent)",
	ylab = "Per Capita Income (dollars)")

java.identify(
	x1 = state.x77[ , "HS Grad"],
	y1 = state.x77[ , "Income"],
	labels = state.name,
	actions = paste("<select tag=\"", state.abb, "\" />", sep = ""))
java.set.page.title("Income vs. Education")


#########################################
## Scatter Plot, longevity vs. education
#########################################

plot(state.x77[ , "HS Grad"], state.x77[ , "Life Exp"],
	main="Longevity vs. Education",
	xlab = "High School Graduation Rate (percent)",
	ylab = "Life Expetancy (years)")

java.identify(
	x1 = state.x77[ , "HS Grad"],
	y1 = state.x77[ , "Life Exp"],
	labels = state.name,
	actions = paste("<select tag=\"", state.abb, "\" />", sep = ""))
java.set.page.title("Longevity vs. Education")

#########################################
## Population map (1975)
#########################################

## For each state, find the corresponding region(s) in the map.
lowerCase(state.name)
chStateNames <- lowerCase(state.name)
chMapNames <- map(namesonly = T, plot = F)
nIndex <- regexpr(":", paste(chMapNames, ":", sep = ""))
chMapNames <- substring(chMapNames, 1, nIndex - 1)
nStateToMap <- match(chMapNames, chStateNames)

## Determine a color to shade each state.
nMaxPopulation <- max(state.x77[ , "Population"])
nColor <- 2 + ((15 * state.x77[nStateToMap , "Population"]) %/%
	nMaxPopulation)
nColor[nColor > 16] <- 16

map("state", fill = T, col = nColor)
map("state", add = T)
title("1975 Population")

## Draw a legend.
image.legend(c(0, nMaxPopulation),
	x = c(-104, -125), y = c(22.3, 26.3),
	nint = 15, sub = "thousands of people")

## Draw a point at the center of each state.
points(state.center)

java.identify(
	x1 = state.center$x, y1 = state.center$y,
	labels = paste(state.name, "\n",
		state.x77[state.name, "Population"]),
	actions = paste("<select tag=\"", state.abb, "\" />", sep = ""))
java.set.page.title("Population Map")

dev.off()

# rm(java.colorscheme.user.1)
