import com.insightful.splus.*;

public class RandomNormalExample {

  public static void main(String [] args){

    try {
      String expression = "rnorm(100)";

      // Get just the result output back
      SplusDataResult result =
        SplusUserApp.eval(expression + "\n",
          false, true, false, false, false);
 
      // Get the double values.  We know the S-PLUS function
      // rnorm() returns doubles.  If it did not, the 
      // try/catch mechanism would catch the
      // SplusBadDataException.

      double [] randomValues = result.getDoubleData();
 
      System.out.println("Generated " + 
        randomValues.length + 
        " random normal values.");
      System.out.println("First value: " + randomValues[0]);
      System.out.println("Last value: " + 
        randomValues[randomValues.length - 1]);
    }
    catch (Exception e){
      System.out.println(e);
    }
 
    System.exit(0);
  }
}
