/*
	Connect/C++ : Copyright (c) 2001, 2006 Insightful Corp.
	All rights reserved.
	Version 6.0: 2001
*/

#include "spobject.h"
#include "spalcfrm.h"
#include "S_y_tab.h"

CSPallocFrame::CSPallocFrame()
: m_bSetFlag(FALSE)
{	
	if( !S_evaluator->_eval_open )
	{
		m_lPrevFrame = ::set_alloc(PERM_FRAME, S_evaluator);
		m_bSetFlag = TRUE;
	}
}

CSPallocFrame::CSPallocFrame(long lAllocFrame)
{	
	m_lPrevFrame = ::set_alloc(lAllocFrame, S_evaluator);
	m_bSetFlag = TRUE;
}

CSPallocFrame::~CSPallocFrame()
{
	//reset only if the constructor set it.
	if(m_bSetFlag)
		::set_alloc(m_lPrevFrame, S_evaluator);
}

//Allocate a vector-liked object with len and mode
s_object* CSPallocFrame::alcvec(int mode, long len)
{
	s_object* ps_object = ::alcvec(mode, len, S_evaluator);
	if(m_bSetFlag)
		::set_perm_ref(ps_object,::get_frame_pointer(PERM_FRAME, S_evaluator), S_evaluator);
	ps_object->Type = S_REF_TYPE; //Always be ref. counting object
	return ps_object;
}

//Set the reference count to be permanent if needed.
s_object* CSPallocFrame::SetPermRefIfNeeded(s_object* ps_object)
{
	s_object* ps_new_object = ps_object;
	if(m_bSetFlag)
		::set_perm_ref(ps_new_object,::get_frame_pointer(PERM_FRAME, S_evaluator), S_evaluator);
	return ps_new_object;		
}
