/*
	Connect/C++ : Copyright (c) 2001, 2006 Insightful Corp.
	All rights reserved.
	Version 6.0: 2001

	spdefs.h  included by all .h files
*/
#ifndef __SCONNECT_DEFS_H_INCLUDED__
#define __SCONNECT_DEFS_H_INCLUDED__

#include "local_os.h"
#include "assert.h"

#undef SCONNECT_LIB_EXTERN
#undef SCONNECT_DLLAPI
#undef SCONNECT_C_DLLAPI
#if defined(WIN32) 
	#if defined(_S_CONNECT)
		#define SCONNECT_LIB_EXTERN __declspec(dllexport) 
	#elif defined(WIN32)
		#define SCONNECT_LIB_EXTERN __declspec(dllimport)
	#endif  
	#define SCONNECT_DLLAPI( returnType )  SCONNECT_LIB_EXTERN  returnType __stdcall
	#define SCONNECT_C_DLLAPI( returnType )  SCONNECT_LIB_EXTERN  returnType __cdecl
#else
	#define SCONNECT_LIB_EXTERN /* extern */  /* must be null on Linux */
	#define SCONNECT_DLLAPI( returnType )  SCONNECT_LIB_EXTERN  returnType
	#define SCONNECT_C_DLLAPI( returnType )  SCONNECT_LIB_EXTERN  returnType
#endif


#if !defined(BOOL)
#define BOOL int
#endif

#if !defined(TRUE)
#define TRUE 1
#endif

#if !defined(FALSE)
#define FALSE 0
#endif

// Macros for notification messages
#define S_MSG_MODIFY 1
#define S_MSG_REMOVE 2
#define S_MSG_ATTACH 3
#define S_MSG_DETACH 4
#define S_MSG_TEXTOUT 5
#define S_MSG_PREMODIFY 6

//S_BINOP_MULTIPLY et al are the same as SHOME/library/main/infix.h : MUL_OP, ADD_OP, SUB_OP and DIV_OP
//which are the same as the last argument of the default binary operation:
//For example .Internal(e1 + e2, "S_do_op", T, 5)
const long S_BINOP_MULTIPLY=4;
const long S_BINOP_PLUS=5;
const long S_BINOP_MINUS=6;
const long S_BINOP_DIVIDE=7;
const long SPL_WORKING_DATABASE=1;
#ifndef S_MODE_MISSING
#define S_MODE_MISSING 299
#endif

#define S_CONNECT_MAXARGS			  512

#define S_CONNECT_EVENTLOOP			(1 << 0)
#define S_CONNECT_READSTDOUT		(1 << 1)
#define S_CONNECT_READSTDERR		(1 << 2)
#define S_CONNECT_READSTDFILES	(S_CONNECT_READSTDOUT|S_CONNECT_READSTDERR)
#define S_CONNECT_SELFDOFIRST		(1 << 3)
#define S_CONNECT_DEFAULTGUI		(S_CONNECT_READSTDFILES|S_CONNECT_SELFDOFIRST)
#define S_CONNECT_DEFAULTCONSOLE 0
#define S_CONNECT_DEFAULTAUTO		(1 << 31)

#endif //__SCONNECT_DEFS_H_INCLUDED__

