/*
	Connect/C++ : Copyright (c) 2001, 2006 Insightful Corp.
	All rights reserved.
	Version 6.0: 2001
*/

#ifdef WIN32

#include <vector>
#include <cstdlib>

#include "windows.h"
#include "oleauto.h"

#include "spmatrix.h"
#include "spvector.h"
#include "spvariant.h"
#include "sconnect_gen.h"
#include "sconnect_com.h"

using namespace std;
typedef vector<long> LONGVECTOR;

BOOL CSPmatrix::GetAsVariant(void *pvVariant, BOOL bMissingsAsErrors, BOOL bValidate)
{
	BOOL bSuccess = FALSE;
#ifndef WIN32
	return bSuccess;
#endif // !WIN32

	if(bValidate && !IsValid())
		SCONNECT_ThrowException(SCONNECT_INVALID_SOBJECT);
	if( !pvVariant )
		return bSuccess;

	LPVARIANT lpReturnVariant = (LPVARIANT)pvVariant;
	memset( lpReturnVariant, 0, sizeof(VARIANT) );

	long nCols = ncol();

	int lastColLength = 0;
	int nColsToGetVariant = 0;
	LONGVECTOR arrayColsToGetVariant;
	for ( long iCol=0; iCol<nCols; iCol++ )
	{
		try
		{
			CSPvector colVec = GetAt(iCol);
			if ( !colVec.IsValid() )
				throw(NULL);
			long nColLength = colVec.GetLength(FALSE);
			if ( nColLength <= 0 )
				throw(NULL);
			if ( lastColLength == 0 )
				lastColLength = nColLength;
			if ( nColLength != lastColLength )
				throw(NULL);
			arrayColsToGetVariant.push_back(iCol) ;
		}
		catch(...)
		{
		}
	}
	nColsToGetVariant = arrayColsToGetVariant.size();
	if ( nColsToGetVariant <= 0 )
		return bSuccess;

	// Allocate and init safearray
	SAFEARRAYBOUND aDim[2]; 
	aDim[0].lLbound = 1; 
	aDim[0].cElements = lastColLength;
	aDim[1].lLbound = 1; 
	aDim[1].cElements = nCols;
	SAFEARRAY *psaDataArray = SafeArrayCreate(VT_VARIANT, 2, aDim);
	if ( !psaDataArray )
		return bSuccess;
	void *pvData = NULL;
	HRESULT hr = SafeArrayAccessData (psaDataArray, &pvData);
	if ( hr != S_OK || !pvData )
	{
		SafeArrayDestroy( psaDataArray );
		return bSuccess;
	}

	for ( long i=0; i<nColsToGetVariant; i++ )
	{
		long iCol = arrayColsToGetVariant[i];

		s_object *ps_object = GetAt(iCol);
		if ( SPL_NotThere( ps_object ) )
			continue;

		CSPvector *pVec = dynamic_cast<CSPvector*>(SCONNECT_GenerateFromSObject( ps_object, 1 ));
		if ( !pVec )
			continue;
		VARIANT varColumn;
		BOOL bGotColumnVariant = pVec->GetAsVariant( &varColumn, bMissingsAsErrors, FALSE );
		if ( pVec )
			delete pVec;
		if ( !bGotColumnVariant )
			continue;

		VARTYPE vtColumnData = varColumn.vt;
		if ( IsValidVariantType( vtColumnData ) )
		{
			if ( vtColumnData & VT_ARRAY )
			{
				SAFEARRAY *pColumnDataArray = varColumn.parray;
				if ( pColumnDataArray )
				{
					void *pvColumnData = NULL;
					hr = SafeArrayAccessData (pColumnDataArray, &pvColumnData);
					if ( hr == S_OK && pvColumnData )
					{
						int nColDataBytes = lastColLength * SafeArrayGetElemsize(pColumnDataArray);
					
						VARIANT *pTargetVariantArray = (VARIANT *)((char *)pvData + (i * nColDataBytes));
						VARIANT *pSourceVariantArray = (VARIANT *)pvColumnData;
						for ( int j=0; j<lastColLength; j++ )
						{
							TxCopyVariant( &(pTargetVariantArray[j]), &(pSourceVariantArray[j]) );
						}
						SafeArrayUnaccessData (pColumnDataArray);
					}
				}
			}
			else
			{
				VARIANT *pTargetVariantArray = (VARIANT *)((char *)pvData);
				TxCopyVariant( &(pTargetVariantArray[i]), &varColumn );
			}
		}
	}

	// Release the ref on the safearray
	SafeArrayUnaccessData (psaDataArray);

	lpReturnVariant->vt = VT_ARRAY | VT_VARIANT;
	lpReturnVariant->parray = psaDataArray;
	bSuccess = TRUE;

	return bSuccess;
}

BOOL CSPmatrix::SetAsVariant(void *pvVariant, BOOL bValidate)
{
	BOOL bSuccess = FALSE;
#ifndef WIN32
	return bSuccess;
#endif // !WIN32
	if(bValidate && !IsValid())
		SCONNECT_ThrowException(SCONNECT_INVALID_SOBJECT);
	if( !pvVariant )
		return bSuccess;

	s_object *ps_object = SCONNECT_GenerateSObjectFromVariant( pvVariant );
	if ( !SPL_NotThere( ps_object ) )
	{
		try
		{
			s_object *ps_use_object = NULL;
			if ( !IS(ps_object, s_matrix_class) )
			{
				CSPcall call1("as.data.frame");
				call1.SetArg(ps_object, 1);
				s_object *ps_ds_object = call1.Eval();
				CSPcall call2("as.matrix");
				call2.SetArg(ps_ds_object, 1);
				ps_use_object = call2.Eval();
			}
			if ( !ps_use_object )
				throw(NULL);
			ReAttachAndAssign( ps_use_object );	
		}
		catch(...)
		{
		}
	}

	return bSuccess;
}

#endif // WIN32
