// spstruct.h: interface for the CSPstructure class.
//
/*
	Connect/C++ : Copyright (c) 2001, 2006 Insightful Corp.
	All rights reserved.
	Version 6.0: 2001

	spstruct.h
*/

#if !defined(__SCONNECT_SPSTRUCT_H_INCLUDED__)
#define __SCONNECT_SPSTRUCT_H_INCLUDED__

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "spobject.h"

class SCONNECT_LIB_EXTERN CSPstructure : public CSPobject  
{
public:
	CSPstructure();
	explicit CSPstructure(s_object* ps_object):CSPobject(ps_object){};
	explicit CSPstructure(const char* pszExpression):CSPobject(pszExpression){};
	virtual ~CSPstructure();

	//////////////////////////////////////////////////////
	// Attributes
	//////////////////////////////////////////////////////
public:

  //Return TRUE if the object is a valid dataframe class
	virtual BOOL IsValid(void) const;
	virtual s_object* GetData(BOOL bValidate=TRUE) const;
	virtual BOOL SetData(s_object* ps_data, BOOL bValidate=TRUE);
	virtual s_object* GetAttribute(const char* pszAttr, BOOL bValidate=TRUE);
	virtual BOOL SetAttribute(const char* pszAttr, s_object* ps_attr, BOOL bValidate=TRUE);
	virtual BOOL RemoveAttribute(const char* pszAttr, BOOL bValidate);
	virtual s_object*	GetElementAt(const char* pszElement, BOOL bValidate=TRUE);
	virtual BOOL SetElementAt(const char* pszElement, s_object* ps_object, BOOL bValidate=TRUE);
	virtual s_object*	GetElementAt(long index, BOOL bValidate=TRUE);
	virtual BOOL SetElementAt(long index, s_object* ps_object, BOOL bValidate=TRUE);
};

#endif // !defined(__SCONNECT_SPSTRUCT_H_INCLUDED__)

