
# @(#)x11.make version 3.34 created 02/19/97
# @(#)Copyright (c), 1987, 2006 Insightful Corp.  All rights reserved.
#
#define HAVE_X11 1
#ifdef HAVE_X11
# To load against debuggable MIT X11 libraries, create the Smakefile like this:
#     % rm smake
#     % env CPP_FLAGS=-DDebugX11Libs Splus MAKE smake
#     % ...
# This should cause the MIT X11 'libg' directory to get prepended to the
# library search path for the load. Because this is going to end up
# preferring the MIT libs, we also prepend the MIT X11 'include' directory
# to the include path. It also forces "static" loads instead of shared
# library loads, since we only have debuggable .a files.
#
# Also, the MIT X11R5 build process will create debuggable libraries like
# "libX11_d.a" and install them into the standard .../lib directory. In
# order for this stuff to work, those files need to be renamed...for
# example,
#     % mv lib/libX11_d.a libg/libX11.a
#

#ifdef DebugX11Libs
OPTIMIZE_FLAG = -g
STRIP = -g

#define XLIB_REF(x) -l/**/x
#define XLIB_REF_S(x) -l/**/x
#else
#
# For the time being, at least, don't strip out symbol tables.
STRIP =
#if defined(SUNOS_REV) && SUNOS_REV >= 500

#ifdef OW_STATIC
#define XLIB_REF(x) $(OPENWINHOME)/lib/lib/**/x.a
#endif
#endif

#ifndef XLIB_REF
#define XLIB_REF(x) -l/**/x
#endif
#if defined(IRIX)
#define XLIB_REF_S(x) -l/**/x/**/_s
#else
#define XLIB_REF_S XLIB_REF
#endif
#endif


#ifdef ForceX11Rel
#define UsedX11Version ForceX11Rel
#define SplusX11Version ForceX11Rel
#else

#define UsedX11Version DefaultX11Rel
#endif

#if SUNOS_REV >= 500
NO_PROTO=-U_NO_PROTO
#else
NO_PROTO=-D_NO_PROTO
#endif
#if defined(LINUX)
#undef SUNOS
OPENWINHOME = /usr/openwin
OPENWIN2HOME = /usr/openwin
#define OSX11Version 6
#define MotifXincdir  /usr/include/X11R6
#define MotifXlibdir  /usr/include/X11R6/lib
#endif
#if defined(SUNOS) /*(*/
#if SUNOS_REV < 530
#define OSX11Version 4
#define MotifXincdir  /sw/commercial/ICS/usr/include
#define MotifXlibdir  /sw/commercial/ICS/usr/lib
#else
#define OSX11Version 5
#define MotifXincdir /opt/SUNWmotif/include
#define MotifXlibdir /opt/SUNWmotif/lib
#endif

#if (defined(SUNOS4) && defined(SPARC)) /*(*/
OPENWINHOME = /usr/openwin
OPENWIN2HOME = /usr/openwin2

#else /*)(*/
OPENWINHOME = /usr/openwin
#endif /*)*/

#define OSXincdir $(OPENWINHOME)/include
#define OSXlibdir $(OPENWINHOME)/lib

#if SUNOS_REV >= 500 /*(*/
#define ExtraOLXlibs -lolgx -lX11 
#define ExtraXlibs -Bdynamic -lsocket -lnsl -ldl -L/usr/ccs/lib -lgen -lw -lintl

#define XCFlags $(NO_PROTO)

#
# Do the "stripping" of the executable with the strip(1) command instead
# of the ld '-s' switch. Running an executable produced with '-s' switch
# and using OpenWindows v3.1 shared libraries generates an Xt error:
#   Error: Unresolved inheritance operation
# Using the 'strip' command afterwards works fine.
STRIP =
#define StripCmd strip
STRIPCMD = strip

#else /*)(*/

#define PostLibs -Bstatic

#define ExtraOLXlibs

#if UsedX11Version >= 5

#define ExtraXlibs -Bdynamic -ldl 
#endif
#endif /*)*/
#endif /*)*/

#if defined(HPUX) /*(*/
#if HPUX_REV < 900 /*(*/
#define OSX11Version 4
#define OSXincdir /usr/include/X11R4
#define MotifXincdir /usr/include/Motif1.1
#define OSXlibdir /usr/lib/X11R4
#define MotifXlibdir /usr/lib/Motif1.1
#else /*)(*/
#define OSX11Version 5
#define OSXincdir /usr/include/X11R5
#define MotifXincdir /usr/include/Motif1.2
#define OSXlibdir /usr/lib/X11R5
#define MotifXlibdir /usr/lib/Motif1.2
#endif /*)*/
#define DashL -Wl,-L,

#define XCFlags -Wp,-H200000 $(NO_PROTO) -DSYSV

#if HPUX_REV >= 800 /*(*/

#define XLdFlags $(LDFLAGS_DYN)
#endif /*)*/

#if OSX11Version == UsedX11Version    /* Use vendor's X11 libs */
#define XLibraries XLIB_REF(Xmu) XLIB_REF(Xt) XLIB_REF(Xhp11) XLIB_REF(Xext) XLIB_REF(X11)
#endif

#if HPUX_REV < 900 && UsedX11Version == 4

#define HPWidgetsLibrary XLIB_REF(Xw)
#else
#define HPWidgetsLibrary 
#endif

#endif /*)*/

#if defined(IRIS4D) /*(*/
#if IRIX_REV < 500
#define OSX11Version 4
#else

#define OSX11Version 5
#endif

#if OSX11Version == UsedX11Version   /* Using vendor's libs */
#define XLibraries XLIB_REF(Xmu) XLIB_REF_S(Xt) XLIB_REF_S(Xext) XLIB_REF(X11)
#define MotifLibrary XLIB_REF_S(Xm)
#endif


#define ExtraXlibs -lbsd -lPW
#endif /*)*/

#if defined(IBMRS6000) /*(*/
#if AIX_REV >= 324
#define OSX11Version 5
#if UsedX11Version == OSX11Version
#define XCFlags $(NO_PROTO) -DSYSV -DXM_1_1_BC
#define NO_MIT_X11
#define MotifLibrary  XLIB_REF(Xm)
#endif
#elif AIX_REV < 320
#define OSX11Version 3
#else
#define OSX11Version 4
#endif
#endif /*)*/

#if defined(NEXTM) /*(*/
#define OSX11Version 0    /* No X11 with OS. */
#endif /*)*/

#if defined(OSF1_DECALPHA) /*(*/
#define OSX11Version 5
X_F77LDFLAGS=-nofor_main
#endif /*)*/

#if defined(CONVEX) /*(*/
# I think CONVEX "currently" ships X11R5, but I don't know what
# incantations might be necessary to compile X11 progs there. So don't
# guess here.
#endif /*)*/

#if defined(UNIX386) /*(*/
#define OSX11Version 6
#endif /*)*/
#ifndef OSX11Version
# !!!!! You will probably have problems.
# !!!!! The file $INC/x11.make does not have a machine dependent section
# !!!!! for this platform. Each machine dependent platform section should
# !!!!! do a '#define OSX11/**/Version' to something. Please go change
# !!!!! x11.make to explicitly configure the X11 availability for this
# !!!!! platform. Assuming no X11 shipped with OS and that we/you have
# !!!!! built the MIT X11 distribution into /usr/local/X11/R/**/UsedX11Version
#define OSX11Version 0
#endif

X11_DATA = $${SHOME}/splus/lib/X11

#ifndef SplusX11Version
#define SplusX11Version UsedX11Version
#endif
XVERSION = SplusX11Version
XVERSION_FLAG = -DSPLUS_XVERSION=$(XVERSION)

#ifndef DashL
#define DashL -L
#endif

#ifndef OSXincdir
#define OSXincdir /usr/include
#endif
#ifndef OSXlibdir
#if SGI_BUILD_TYPE=="mips3"
   #define OSXlibdir /usr/lib32
#else
   #define OSXlibdir /usr/lib
#endif
#endif
#ifndef MITXincdir
#define MITXincdir /sw/x11r$(XVERSION)/include
#endif
#ifndef MITXlibdir
#define MITXlibdir /sw/x11r$(XVERSION)/lib
#endif
#ifndef MotifXincdir
# Motif includes are in one of the other already searched directories.
MOTIFINC =
#else
MOTIFINC = -I/**/MotifXincdir
#endif
#ifndef MotifXlibdir
# Motif libs are in one of the other already searched directories.
MOTIFLIBDIR =
#else
MOTIFLIBDIR = DashL/**/MotifXlibdir
#endif

#ifndef UseOSX11
#if DebugX11Libs || (OSX11Version != SplusX11Version)
#define UseOSX11 0
#else
#define UseOSX11 1
#endif
#endif

OSXINCDIR  = OSXincdir
OSXLIBDIR  = OSXlibdir
MITXINCDIR = MITXincdir
MITXLIBDIR = MITXlibdir
#ifdef NO_MIT_X11  /*(*/
XINCLUDE = -I$(OSXINCDIR) $(MOTIFINC)
XLIBSDIR = DashL/**/$(OSXLIBDIR) $(MOTIFLIBDIR)
#else /*)(*/
#ifdef DebugX11Libs /*(*/
XINCLUDE = -I$(MITXINCDIR)g -I$(MITXINCDIR) $(MOTIFINC) -I$(OSXINCDIR)
XLIBSDIR = DashL/**/$(MITXLIBDIR)g DashL/**/$(MITXLIBDIR) \
           $(MOTIFLIBDIR) DashL/**/$(OSXLIBDIR)
#else /*)(*/
#if UseOSX11
XINCLUDE = -I$(OSXINCDIR) -I$(MITXINCDIR) $(MOTIFINC)
XLIBSDIR = DashL/**/$(OSXLIBDIR) DashL/**/$(MITXLIBDIR) $(MOTIFLIBDIR)
#else
XINCLUDE = -I$(MITXINCDIR) -I$(OSXINCDIR) $(MOTIFINC)
XLIBSDIR = DashL/**/$(MITXLIBDIR) DashL/**/$(OSXLIBDIR) $(MOTIFLIBDIR)
#endif
#endif /*)*/
#endif /* ) NO_MIT_X11 */

#ifdef DebugX11Libs
#undef XLdFlags
#define XLdFlags $(LDFLAGS)
#endif

#ifndef XLdFlags
#define XLdFlags $(LDFLAGS)
#endif
XLDOPTS  = XLdFlags
XLDFLAGS = $(XLDOPTS) $(XLIBSDIR)

#ifdef HAVE_OPENLOOK2
OL2XINCLUDE = -I$(OPENWIN2HOME)/include
OL2XLIBSDIR = -L$(OPENWIN2HOME)/lib
OL2XLDFLAGS = $(LDFLAGS) $(OL2XLIBSDIR)
#endif

#ifdef HAVE_OPENLOOK
OLXINCLUDE = -I$(OPENWINHOME)/include
OLXLIBSDIR = -L$(OPENWINHOME)/lib
OLXLDFLAGS = $(LDFLAGS) $(OLXLIBSDIR)
#endif

#ifndef XCFlags
#ifdef Berkeley
#define XCFlags $(NO_PROTO)
#else
#define XCFlags $(NO_PROTO) -DSYSV
#endif
#endif
X_CFLAGS = XCFlags $(XVERSION_FLAG)

#ifndef ExtraXlibs
#define ExtraXlibs
#endif

#if defined(USE_F2C)
#define ExtraSysLibs -lf2c -lm $(SYS_DEP_LIBS)
#else
#if defined(IRIS4D)
#define ExtraSysLibs -lm $(SYS_DEP_LIBS)
#endif
#if (defined(IBMRS6000) && (AIX_REV >= 324))
#define ExtraSysLibs  -lm $(SYS_DEP_LIBS) -lc
#endif
#endif

#ifndef ExtraSysLibs
#define ExtraSysLibs -lm $(SYS_DEP_LIBS) -lc
#endif

#ifndef PostLibs
#define PostLibs
#endif



#ifndef XLibraries
#define XLibraries XLIB_REF(Xmu) XLIB_REF(Xt) XLIB_REF(Xext) XLIB_REF(X11)
#endif
COMMONXLIBS = $L/needX11R$(XVERSION).z $L/libXS11.a $L/sutils.a \
        XLibraries ExtraXlibs ExtraSysLibs PostLibs
#ifdef HAVE_OPENLOOK2
# Need StringDefs.o from R5 libXt.a
OL2XLIBS = $L/needX11R4.z $L/libXS11.a $L/sutils.a \
        -Bstatic XLibraries -Bdynamic \
        /usr/local/X11/R5/lib/libXt.a ExtraSysLibs PostLibs
#endif
#ifdef HAVE_OPENLOOK
OLXVERSION = `awk < $(OPENWINHOME)/include/X11/Intrinsic.h ' \
$$1 ~ /^.define$$/ && $$2 == "XtSpecificationRelease" {print $$3} \
$$1 ~ /^\#/ && $$2 == "define" && $$3 == "XtSpecificationRelease" {print $$4} \
'`
OLXLIBS = $L/needX11R$(OLXVERSION).z $L/libXS11OW.a $L/sutils.a \
        XLibraries ExtraOLXlibs ExtraXlibs ExtraSysLibs PostLibs
#endif

#ifdef LINUX
#define MotifLibrary /usr/X11R6/lib/libXm.a
#endif

#ifndef MotifLibrary
#define MotifLibrary XLIB_REF(Xm)
#endif
MOTIFLIB = MotifLibrary 

#ifndef AthenaLibrary
#define AthenaLibrary XLIB_REF(Xaw)
#endif
ATHENALIB = AthenaLibrary 

#ifndef OpenLookLibrary

#define OpenLookLibrary $(OPENWINHOME)/lib/libXol.a
#endif
OPENLOOKLIB = OpenLookLibrary

#ifndef OpenLook2Library
#define OpenLook2Library $(OPENWIN2HOME)/lib/libXol.a
#endif
OPENLOOK2LIB = OpenLook2Library

#ifndef HPWidgetsLibrary
#define HPWidgetsLibrary XLIB_REF(Xw)
#endif
HPWIDGETSLIB = HPWidgetsLibrary

#if defined(SUNOS)
PREFIX_ENV = LD_LIBRARY_PATH=
#endif

#ifndef StripCmd
# /bin/sh no-op command
STRIPCMD = -@:
#endif
#endif /* ifdef HAVE_X11 */
#
# ===End of x11.make===
