#ifndef S_RMATH_H /* ( */
#define S_RMATH_H
/* Rmath.h emulation for use with Splus */
/* Map some of R's macros and declarations to Splus equivalents */

#include <S.h>
#include <math.h>

/* We use the following 3 line idiom when R and
 * Splus have the same function but Splus's has
 * an extra argument (S_evaluator). The def. of
 * unif_rand look circular, but it seems to work.
 */

#define S_unif_rand unif_rand
#undef unif_rand
#define unif_rand() S_unif_rand(S_evaluator)

#define S_norm_rand norm_rand
#undef norm_rand
#define norm_rand() S_norm_rand(S_evaluator)

/* Not all platforms have log1p or expm1 in standard math library,
   so we always remap those calls to S_ versions.  R redefines them
   on some platforms and not on others.
*/
#undef log1p
#define log1p(x) S_log1p(x)
#undef expm1
#define expm1(x) S_expm1(x)

#define imax2(x,y) S_imax2(x,y)
#define imin2(x,y) S_imin2(x,y)
#define fmax2(x,y) S_fmax2(x,y)
#define fmin2(x,y) S_fmin2(x,y)

#undef lgammafn
#define Rf_lgammafn S_lgamma
#ifndef R_NO_REMAP /*(*/
#define lgammafn Rf_lgammafn
#endif /* R_NO_REMAP ) */

#undef pnorm
#define pnorm S_pnorm_ex

#endif /* ) S_RMATH_H */
