/* @(#) Copyright (c), 1987, 2006 Insightful Corp.  All rights reserved. */
/* @(#) $RCSfile: S_lic.h,v $: $Revision: #45 $, $Date: 2008/10/04 $  */
#ifndef _S_LIC_H
#define _S_LIC_H

#ifndef NO_LICENSE_CHECKING_AT_ALL /* ( */

#include "S_ansi.h"

#ifdef _S_LIC_G
#define vextern
#define INIT(x) = (x)
#else
#define vextern extern
#define INIT(x)
#endif

#define BUG31592FIX 1
#define MAX_FEATURE_LEN 30
#define MAX_SUBFEATURE_LEN 15

/* Feature "names". With Elan License Manager and numeric-only keys, these can
   be numbers from 00 to 99. Do NOT change the assignments unless you want the
   new one to be treated as a different product. */

/* 00 through 09 are reserved for major versions of S-PLUS */
#define FEATURE_NAME_SPLUS 0

/* Add-on modules begin at 10 */
#define FEATURE_MIN_MODULE 10   /* Used in $QPE/data.c */
#define FEATURE_NAME_DOX 10
#define FEATURE_NAME_WAVELETS 11
#define FEATURE_NAME_SPATIALSTATS 12
#define FEATURE_NAME_DATACONNECT 13
#define FEATURE_NAME_GARCH 14
#define FEATURE_NAME_SEQSTAT 15
#define FEATURE_NAME_NUOPT 16
#define FEATURE_NAME_MISSINGDATA 17
#define FEATURE_NAME_ARCVIEW 18 /* Not an Splus module, nor an S+Runtime module,
				   but # is reserved anyway */
/* DO NOT define feature numbers greater than 39 !! */
/* If any changes are made to the above, also change FEATURE_NAME defines
   for S+RUNTIME and Insightful Analytic Server below. */

/* If this is the feature number found in a module's "big file" header, then */
/* we don't need to checkout a license for this module. */
#define FEATURE_MODULE_NO_CHECKOUT 255

/* Environment variables to control various things */
#define NOQUEUE_ENVAR "SLIC_NOQUEUE"
#define NOSHARE_ENVAR "SLIC_NOSHARE"
#define NOAUTOSTART_ENVAR "SLIC_NOAUTOSTART"
#define KEYDIR_ENVAR "SLIC_KEYDIR"
#define EXPIRE_WARN_ENVAR "SLIC_EXPIRE_WARN"

/* If license is within "EXPIRE_WARN" days of expiring, spit out a warning. */
#define DEFAULT_EXPIRE_WARN 90

/* Algorithm for the "random" sequence number on each message...ripped off from
 * $QPE/random.c's runif() generator.
 */

typedef struct slic_ranparms {
    unsigned int congrval;
    unsigned int tausval;
} SLIC_RANPARMS;

static unsigned int
SLIC_POW32(b,n)
unsigned int b, n;
{
    unsigned int p, a;
    for(a=1, p=b; n>0; n >>= 1, p *= p) if (n&1) a *= p;
    return a;
}
static void
SLIC_SETSEED(x,ranparms)
unsigned int x;
SLIC_RANPARMS *ranparms;
{
    unsigned int sl_i;
    sl_i = SLIC_POW32((unsigned int)2,(unsigned int)20);
    ranparms->congrval = ((unsigned int) 1803752341) *
           SLIC_POW32((unsigned int)69069,
                      (unsigned int) (sl_i*x));
    ranparms->tausval = (unsigned int)3697165728;
}
static unsigned int
SLIC_NEXTSEQ(ranparms)
SLIC_RANPARMS *ranparms;
{
    unsigned int t;
    int zero_countdown = 3;
    do {
        /* Force a seed if one never got set. */
        if (zero_countdown == 0) SLIC_SETSEED(137,ranparms);

        ranparms->congrval *= 69069;
        ranparms->tausval ^= ranparms->tausval >> 15;
        ranparms->tausval ^= ranparms->tausval << 17;
        t = (ranparms->tausval ^ ranparms->congrval) >> 1;
        zero_countdown--;
    } while (t == 0);
    return t;
}

/** Elan License Manager feature codes for S+RUNTIME **/
/** (a special version of S-PLUS for use with S+SDK) **/
#define FEATURE_NAME_SPLUS_RUNTIME 1
#define S_SDK_MOD_ADJUST 45
/* (this should be 30 instead of 45, but would mess up database to change) */
/* FEATURE_NAME_XXX_RT = FEATURE_NAME_XXX + 45 */
#define FEATURE_NAME_DOX_RT 55
#define FEATURE_NAME_WAVELETS_RT 56
#define FEATURE_NAME_SPATIALSTATS_RT 57
#define FEATURE_NAME_DATACONNECT_RT 58
#define FEATURE_NAME_GARCH_RT 59
#define FEATURE_NAME_SEQSTAT_RT 60
#define FEATURE_NAME_NUOPT_RT 61
#define FEATURE_NAME_MISSINGDATA_RT 62
#define FEATURE_NAME_ARCVIEW_RT 63

/** Elan License Manager feature codes for Insightful Analytic Server **/
#define FEATURE_NAME_SPLUS_SERVER 2
#define S_SERVER_MOD_ADJUST 0 
/* FEATURE_NAME_XXX_SERVER = FEATURE_NAME_XXX + 60 */
#define FEATURE_NAME_DOX_SERVER 70
#define FEATURE_NAME_WAVELETS_SERVER 71
#define FEATURE_NAME_SPATIALSTATS_SERVER 72
#define FEATURE_NAME_DATACONNECT_SERVER 73
#define FEATURE_NAME_GARCH_SERVER 74
#define FEATURE_NAME_SEQSTAT_SERVER 75
#define FEATURE_NAME_NUOPT_SERVER 76
#define FEATURE_NAME_MISSINGDATA_SERVER 77
#define FEATURE_NAME_ARCVIEW_SERVER 78

/* Slmclient opcodes. (NOTE: Send across comm channel as 'int'). */
enum slmc_opcode {
    /* Requests */
    SLMC_SEED, SLMC_NEEDLIC, SLMC_QLIC, SLMC_RETLIC, SLMC_GETSN,

    /* Responses */
    SLMC_OK, SLMC_FAILURE, SLMC_QUEUED, SLMC_OK_RETURNBUF,
	 SLMC_NEEDLIC2, SLMC_RETLIC2, SLMC_EXPIREDAYS, SLMC_EXPIREDAYSMSG, SLMC_FROMMINER, SLMC_CLIENTSERVER

};

/* key directory is relative to $SHOME. NOTE: trailing slash. Feature name */
/* will be appended to this string. */
#define SLMC_KEYDIR "adm/lic/keys/"

#define BEAT 60
#define FEATURE_STRING_SPLUS  "00"
#define NO_CONSTRAINTS      NULL
#define NO_OVERSOFT         NULL
#define NO_TOKENS           0
#define NO_SPECIAL_OPTION   0L

extern char *eval_ck (/* int feature, SLIC_RANPARMS *ranparms */);
extern char *add_ck (/* int feature */);
extern char *del_ck (/* int feature */);
extern char *add_ck_sub (/* int feature, char *subName */);
extern char *del_ck_sub (/* int feature, char *subName */);

extern char* S_license_feature_name(int feature_num);

#ifndef NO_FLEX_LICENSE
#define FLEX_LICENSE_HEADERS
#include "s_flexlm.h"
#undef FLEX_LICENSE_HEADERS
#endif /* ! NO_FLEX_LICENSE */

extern char * S_license_validate( /* int bIsClientServer */ );
LibExport void * S_isFeatureLicensed( /* void *psFeatureCode */ );
LibExport int S_isFeatureLicensed_S_base( /* char *pszMessage, int cbMessage, char *pszFeatureCode, int bCheckOutLicense, int argc, char *argv[] */ );
LibExport int S_isFeatureLicensed_S_base_returncode( /* char *pszMessage, int cbMessage, char *pszFeatureCode, int bCheckOutLicense */ );

#undef vextern
#undef INIT

#endif /* NO_LICENSE_CHECKING_AT_ALL ) */
#endif
