/* @(#) Copyright (c), 1987, 2006 Insightful Corp.  All rights reserved. */
/* @(#) $RCSfile$: $Revision: #9 $, $Date: 2006/06/26 $  */

#ifndef _S_PROCESS_H
#define _S_PROCESS_H

#ifdef _S_PROCESS_G
#define vextern
#define INIT(x) = (x)
#else
#define vextern extern
#define INIT(x)
#endif

/* .C ('S_process_start', as.character(cmd), as.character("rwrrw..."),
                          status=integer(1), handle=integer(1)) */
extern void S_process_start (/* char **cmd, char **extra_channels,
                                long *status, long *proc_handle */);

/* .C ('S_process_send', as.integer(process$handle), as.character(cmd), */
/*     as.integer(ack), as.integer(wait)) */
extern void S_process_send (/* long *proc_handle, char **message,
                               long *ack, long *waitflag */);
extern void S_process_bsend (/* long *proc_handle, char **message,
                                long *msglen, long *ack, long *waitflag,
                                long *binaryflag */);

/* .C ('S_process_flush', as.integer(process$handle)) */
extern void S_process_flush (/* long *proc_handle */);

/* .C ('S_process_receive', as.integer(process$handle), message=character(1)) */
extern void S_process_receive (/* long *proc_handle, char **message */);
extern void S_process_breceive (/* long *proc_handle, char **message,
                                   long *message_len */);

/* .C ('S_process_deallocate', as.integer(process$handle)) */
extern void S_process_deallocate (/* long *proc_handle */);

/* .C ('S_process_status', as.integer(process$handle), integer(1)) */
extern void S_process_status (/* long *proc_handle, long *status */);

/* .C ('S_process_onpipe', as.integer(process$handle), list(expression),
       as.integer(clear)) */
extern void S_process_onpipe (/* long *proc_handle, void **onpipe_expr,
                                 long *clear */);

extern void S_process_onpipe_cb (/* long *proc_handle,
                                    void (*onpipe_expr)() */);

/* .C ('S_process_errmsg', as.integer(status), msg=character(1)) */
extern void S_process_errmsg (/* long *status, char **msg */);

/* .C ('S_process_debug', as.integer(debug)) */
extern void S_process_debug (/* long *debug */);

/* .C ('S_process_getparms', as.integer(process$handle), parms=integer(3)) */
extern void S_process_getparms (/* long *proc_handle, long *parms */);

#undef vextern
#undef INIT
#endif
