/* @(#) Copyright (c), 1987, 2006 Insightful Corp.  All rights reserved. */
/* @(#) $RCSfile: S_rpc.h,v $: $Revision: #5 $, $Date: 2006/06/26 $  */
/***
   NAME   S_rpchelp
   PURPOSE
     Provide some helper macros & typedefs to allow for EZ-RPC inclusion
     of some of the .h files in here.
   NOTES
     
***/
#ifndef S_rpchelpINCLUDED
#define S_rpchelpINCLUDED 1


#if defined(RPC) && !defined(RPC_FILE)
#define RPC_FILE
#endif

/* NOTE: These types are needed to help the RPC data passing
   mechanisms know that the (char *) being passed is really a
   zero-terminated character string (as opposed to a raw binary
   buffer). */
typedef char string8;
typedef char binary;

/* For inclusion into EZ-RPC .rpc files (really .ppc files which get cpp'd into .rpc files) */
#if defined(RPC_FILE) /*(*/
#define RPCMOD(x) [x]
#define RPCPROTO(num) {} = num
#define RPCFUNC(num,attr) {attr} = num
#define EXTERN
#undef _NO_PROTO
#undef S_NoPrototypes
#define S_UsePrototypes

#else   /*)(*/
#define RPCMOD(x)
#define RPCPROTO(num)
#define RPCFUNC(num,attr)
#define EXTERN extern
#endif /* ) RPC_FILE */
#endif /* S_rpchelpINCLUDED */
