/* @(#) Copyright (c), 1987, 2006 Insightful Corp.  All rights reserved. */
/* @(#) $RCSfile: S_tokens.h,v $: $Revision: #17 $, $Date: 2007/06/12 $  */
/***
   NAME S_tokens.h
   PURPOSE
     Split of part of S.h that deals with token types of input. Note that
     this file is "public" (e.g. included via S+SDK public header files),
     so many tokens have the prefix S_ added to them.  To get the previous
     unprefixed token names, define S_COMPATIBILITY.
   NOTES
     -Need to include a y_tab.h file for some of this to be useful.
***/
#ifndef S_tokensINCLUDED
#define S_tokensINCLUDED 1

/* Pre-requisite includes go here. */
#include <S_ansi.h>
#include <S_types.h>

S_begin_extern_c
/*
 * The atomic type definitions assume that yacc does not
 * generate these values as token types.  See y_tab.h
 */

#define S_MODE_NULL 0   /* added this (like S verion 4) -- mclark */
#define S_NULL_MODE S_MODE_NULL
#define S_MODE_LGL 1
#define S_MODE_INT 2
#define S_MODE_REAL 3
#define S_MODE_DOUBLE 4
#define S_MODE_CHAR 5
#define S_MODE_LIST 6
#define S_MODE_COMPLEX 7
#define S_MODE_RAW 9
#define S_MODE_ANY 11
#define S_MODE_STRUCTURE 21
#define S_MODE_MAX_ATOMIC 20

/*
 * macro to identify an atomic type: this depends slightly on
 * the implementation of yacc; viz, that yacc generates token
 * types in increasing numerical value
 */

#define S_atomic_type(t) ((t) <= S_MODE_MAX_ATOMIC ? S_atomic_types[t] : S_FALSE)

/*
 * markers for the range of token types:
 * must have y.tab.h included to use;
 * just not ENTRY_TYPE
 */
#define S_FIRST_TOKEN		S_MODE_NAME
#define S_LAST_TOKEN		S_MODE_OROP
/* two TYPE's for the Type field of headers:  just need to be
   different from ENTRY_TYPE */
#define S_REF_TYPE		S_MODE_LARROW
#define S_FREED_TYPE		S_MODE_UNKNOWN
#define S_LANGUAGE_TYPE(mode)	(mode>=S_FIRST_TOKEN &&\
				 mode<=S_LAST_TOKEN &&\
				(S_token_info[mode-S_FIRST_TOKEN]&1))
#define S_NOT_RECURSIVE(mode)	(mode<S_FIRST_TOKEN\
				?(mode!=S_MODE_LIST && mode!=S_MODE_STRUCTURE)\
				:(mode<=S_LAST_TOKEN && (S_token_info[mode-S_FIRST_TOKEN]&2)))
#define HEADER_TYPE(obj)	(obj->Type == ENTRY_TYPE || obj->Type == REF_TYPE)
#define S_MODE_EXPRESSION S_MODE_PARSE

#include "libext.h"
/* Initialization taken from $QPE/pars_util.c */
/* codes for token types: defined as
 (LANGUAGE_TYPE +2 * NOT_RECURSIVE + 4*SPECIAL_STRUCTURE + 8 * !VALID_AS_MODE)  */
/* NBB: This list MUST be in the same order as the token list in lang.y */
#ifdef pars_utilDEFINE
LibExport int S_token_info[] = {
1 | 2 | 0,	/* NAME */
1 | 2 | 0 | 8,	/* STRING */
1 | 2 | 0 | 8,	/* LITERAL */
1 | 0 | 4 | 8,	/* COMPILED */
1 | 0 | 0,	/* LPAR */
1 | 2 | 0,	/* RPAR */
1 | 0 | 0,	/* LBRACK */
1 | 2 | 0 | 8,	/* RBRACK */
1 | 0 | 0,	/* LBRACE */
1 | 2 | 0 | 8,	/* RBRACE */
1 | 2 | 0 | 8,	/* COMMA */
1 | 2 | 0 | 8,	/* NOT */
1 | 2 | 0 | 8,	/* COLON */
1 | 2 | 0 | 8,	/* ADDOP */
1 | 2 | 0 | 8,	/* MULOP */
1 | 2 | 0 | 8,	/* LIST_SEP */
1 | 2 | 0 | 8,	/* UARROW */
1 | 2 | 0 | 8,	/* UMINUS */
1 | 2 | 0 | 8,	/* DOLLAR */
1 | 2 | 0 | 8,	/* LOGOP */
1 | 2 | 0 | 8,	/* ANDOR */
1 | 0 | 4 | 8,	/* EQUAL */
1 | 0 | 4 | 8,	/* LARROW */
1 | 2 | 0 | 8,	/* RARROW */
1 | 2 | 0 | 8,	/* SPOP */
1 | 2 | 0 | 8,	/* TBLANK */
1 | 0 | 4,	/* REPEAT */
1 | 0 | 4,	/* IF */
1 | 0 | 4,	/* ELSE */
1 | 2 | 0,	/* BREAK */
1 | 2 | 0,	/* SEMI */
1 | 2 | 0,	/* NEXT */
1 | 0 | 4,	/* WHILE */
1 | 0 | 4,	/* FOR */
1 | 2 | 0 | 8,	/* IN */
1 | 0 | 4,	/* C_CALL */
1 | 0 | 4,	/* RETURN */
1 | 0 | 4,	/* ARGUMENT */
1 | 2 | 0,	/* SYSTEM */
1 | 2 | 0,	/* END_OF_FILE */
1 | 0 | 0,	/* PARSE */
1 | 0 | 0,	/* SYS_FUN */
0 | 2 | 0,	/* MISSING */
1 | 0 | 4,	/* FUN_CALL */
0 | 0 | 4,	/* FUN_DEF */
1 | 2 | 0,	/* QUESTION */
1 | 2 | 0,	/* UNBALANCED */
1 | 0 | 4,	/* DOUBLE_LBRACK */
0 | 2 | 0,	/* UNKNOWN */
1 | 2 | 0 | 8,	/* DOUBLE_RBRACK */
1 | 2 | 0,	/* QUIT */
1 | 2 | 0,	/* CONTINUE */
1 | 0 | 0,	/* COMMENT_EXPR */
1 | 2 | 0 | 8,	/* ENTRY_TYPE */
1 | 0 | 4,	/* FLEX_CALL */
1 | 0 | 4,	/* DBLEARROW */
0 | 0 | 0,	/* GRAPHICS */
1 | 0 | 0,	/* COMMENT_EXPR */
1 | 0 | 4,	/* INTERNAL */
1 | 0 | 4,	/* S_FUN_CALL */
1 | 0 | 4,	/* S_DATA */
1 | 0 | 0 | 8,	/* SIMILAR */
1 | 0 | 0,	/* COMMENT */
1 | 0 | 4 | 8,	/* LEFT_COMMENT */
1 | 0 | 4,	/* FRAME */
1 | 0 | 4 | 8,	/* LVALUE */
1 | 2 | 0 | 8,  /* DOUBLE_COLON */
1 | 2 | 0 | 8,  /* TRIPLE_COLON */
1 | 2 | 0 | 8,	/* ANDOP */
1 | 2 | 0 | 8,	/* OROP */
-1};
#else
LibExtern int S_token_info[];
#endif /* pars_utilDEFINE */

/* Initialization taken from $QPE/c_support.c */
#ifdef c_supportDEFINE
/*
 * the vector defining the atomic types. This has to be
 * consistent with the choice of modes:
     NULL,   LGL,   INT,  REAL,DOUBLE,  CHAR,   LIST,COMPLX,  -----,   RAW*/
LibExport int S_atomic_types[S_MODE_MAX_ATOMIC+1] = 
  {S_TRUE,S_TRUE,S_TRUE,S_TRUE,S_TRUE,S_TRUE,S_FALSE,S_TRUE,S_FALSE,S_TRUE};
#else
LibExtern int S_atomic_types[];
#endif /* c_supportDEFINE */
#include "unlibext.h"

#if defined(S_COMPATIBILITY) /* ( */
#define NULL_MODE S_MODE_NULL
#define LGL       S_MODE_LGL
#define INT       S_MODE_INT
#define REAL      S_MODE_REAL
#define DOUBLE    S_MODE_DOUBLE
#define CHAR      S_MODE_CHAR
#define LIST      S_MODE_LIST
#define COMPLEX   S_MODE_COMPLEX
#define RAW       S_MODE_RAW
#define ANY       S_MODE_ANY
#define STRUCTURE S_MODE_STRUCTURE
#define MAX_ATOMIC S_MODE_MAX_ATOMIC

#ifndef atomic_type    /*(*/
#define atomic_type(t) S_atomic_type(t)
#endif /* ) atomic_type */

#define FIRST_TOKEN S_FIRST_TOKEN
#define REF_TYPE    S_REF_TYPE
#define LAST_TOKEN  S_LAST_TOKEN
#define FREED_TYPE  S_FREED_TYPE

#define LANGUAGE_TYPE(mode) S_LANGUAGE_TYPE(mode)
#define NOT_RECURSIVE(mode) S_NOT_RECURSIVE(mode)

#define EXPRESSION S_MODE_EXPRESSION
#endif /* ) S_COMPATIBILITY */

S_end_extern_c
#endif /* S_tokensINCLUDED */
