#ifndef S_DYNLINK_H
#define S_DYNLINK_H 1
#include "local_os.h"
#include <unistd.h>

/****** following defines implement the system-dependent aspects  of */
/****** dynamic loading. */
/* Unix (System V) version: is there an IFDEF ??*/
#ifdef HPUX
#include "hpdlfcn.h"
#else
#include <dlfcn.h>
#endif
#define DIRECTORY_CHARACTER '/'

/*
//YB: WIN32 likes the extention to be .dll better than .so
*/
#ifdef WIN32
#define STD_LIB_FILE "S.dll"
#else
#define STD_LIB_FILE "S.so"
#endif

typedef void * HINSTANCE;

extern HINSTANCE Unix_lib_open(const char *path, s_evaluator *S_evaluator);
#define LIB_OPEN(p) Unix_lib_open(p, S_evaluator)
#define LIB_SYM(h, n) dlsym(h, n)
#define LIB_CLOSE(p)  dlclose(p)
#define DYN_OPEN(p) dlopen(p, S_RTLD_MODE)

/* older op systems (SunOS4, Irix 5.x x < 3) don't have this as an */
/* option.  make it a nullity */
#ifndef RTLD_GLOBAL
#define RTLD_GLOBAL 0
#endif

/* Mostly for Windows */
#if !defined(RTLD_NOWARN)
#define RTLD_NOWARN 0
#endif

#define S_RTLD_MODE RTLD_LAZY | RTLD_GLOBAL | RTLD_NOWARN

/*** end of Unix System V version */

/*** Windows version (in theory anyway) */
/* #define DIRECTORY_CHARACTER '\\'     */
/* #define STD_LIB_FILE "S.DLL"         */
/* #define LIB_OPEN(n) LoadLibrary(p)   */
/* #define LIB_SYM(h, n) GetProcAddress(h, n)  */
/* #define LIB_CLOSE(h) FreeLibrary(h)         */
/*** end of Windows version */

struct s_dl_lib_struct {
  HINSTANCE handle;
  char *path;
  s_name_table *load_table;
  struct s_dl_lib_struct *prev;
};

typedef struct s_dl_lib_struct s_dl_lib;

/* some entries related to load tables and dynamic loading */
extern s_name_table *load_table;
extern void *do_dl_search(char *name, s_evaluator *S_evaluator);
extern void *do_dl_get(char *name, int i, s_evaluator *S_evaluator);
extern void *dl_get_entry(s_dl_lib *handle, char *name, s_evaluator *S_evaluator);
extern void dl_close_library(s_dl_lib *lib_p, s_evaluator *S_evaluator);
extern s_dl_lib *dl_open_S_library(const char *directory, char *initialize, s_evaluator *S_evaluator);
extern void dl_unhash(s_name_table  *t);
extern char *NO_DLOPEN, *NO_DL_INITIALIZE;

#endif
