
#include "eval.h"


#ifdef S_DEBUG_API_HOOKS

/*********************************************************/
/*                                                       */
/*              EXTERN PROTOTYPES                        */
/*                                                       */
/*********************************************************/
extern vector *append_el(vector *current, long which, vector *new, s_evaluator *S_evaluator);

extern long s_do_debugging_work;
extern long s_is_evaluating_args;


/* define a function pointer type for the debug control functions */
typedef void (*S_DO_DEBUG_FUNCTION)(long, char*, long*, s_object*);

/* define a function pointer type to handle the output from each debug fxn */
typedef int (*S_HANDLE_DEBUG_CONTROL)(s_object*, char*);

/* define a function pointer type to handle the output from each debug fxn */
typedef void (*S_HANDLE_DEBUG_OUTPUT)(long, long, s_object*, s_object*);

#define S_DB_CMD_NONE		-1
#define S_DB_CMD_STEP		0
#define S_DB_CMD_STEP_IN	1
#define S_DB_CMD_STEP_OUT	2
#define S_DB_CMD_CONTINUE	3
#define S_DB_CMD_QUIT		4
#define S_DB_CMD_OBJECTS	5
#define S_DB_CMD_WHERE		6
#define S_DB_CMD_EVAL		7
#define S_DB_CMD_HELP		8
#define S_DB_CMD_UP			9
#define S_DB_CMD_DOWN		10
#define S_DB_CMD_MARK		11
#define S_DB_CMD_UNMARK		12


/* function used to pause during debugging */
void s_do_debug_pause(long current_frame, s_object *eval);

/* functin used to handle a possible breakpoint */
void s_handle_check_breakpoint(int line, s_object *sobject);

/* use to wait for a specific cmd */
void s_debug_wait_for(int wait);
/* use to wait while a specific cmd */
void s_debug_wait_while(int wait);


/*********************************************************/
/*                                                       */
/*           EXTERNAL INTERFACE FUNCTIONS                */
/*                                                       */
/*********************************************************/

/* set breakpoints from text and from a file */
void s_set_breakpoint_from_text(char **text, long *lines, long *nlines);
void s_set_breakpoint_from_file(char **filename, long *lines, long *nlines);

#ifdef S_DEBUG_WITH_LINE_NUMBERS
/* add breakpoint to a given function, at a given "address" */
void s_add_breakpoint(char **fxn_name, char **outer_fxn_name, long *breakpoint_address, long *address_length);

/* remove breakpoint to a given function, at a given "address" */
void s_remove_breakpoint(char **fxn_name, long *breakpoint_address, long *address_length);

/* get the address of this s_object relative to the current function */
s_object* s_get_current_address(long current_frame, s_object *eval);

/* determine if the given function is a nested function and return the top-level function name */
char* s_get_outer_function(int call_stack_pos, s_object *eval);
#endif /*S_DEBUG_WITH_LINE_NUMBERS*/

/* add breakpoint to a given function, at a given "address" */
void s_add_remove_error_warning_breakpoint(long add, long error);

/* we need a function for pausing on warning and error */
void s_do_debug_error_warning_pause(s_object *eval, long error);

/* set and reset debug mode */
void s_set_debug_mode();
void s_reset_debug_mode();

/* set command line versus event driven */
void s_set_debug_from_command_line();

/* functions used for debug control */
void s_debug_start();
void s_debug_end();
void s_debug_step_in();
void s_debug_step();
void s_debug_step_out();
void s_debug_pause();
void s_debug_continue();
void s_debug_quit();
void s_debug_objects();
void s_debug_where();
void s_debug_eval(char **eval_text);

/* get debug capability...access with .Call */
long* s_is_debug_mode(long *ret);

/* set/reset frame to stop at */
void s_set_frame_to_stop(long *fr);
void s_reset_frame_to_stop();

/* clear the line numbers for access during the parse*/
void s_reset_breakpoints();

/* use to set non command line control */
void s_use_event_control(long val);

/* use to set a different output handler */
int s_set_output_handler_by_name(char *output_fun);
int s_set_output_handler_by_ptr(S_HANDLE_DEBUG_OUTPUT *output_fun);

#endif /*S_DEBUG_API_HOOKS*/





