/* @(#) Copyright (c), 1987, 2006 Insightful Corp.  All rights reserved. */
/* @(#) $RCSfile$: $Revision: #6 $, $Date: 2006/06/26 $  */

#ifndef _PCOMMAND_H
#define _PCOMMAND_H

#ifdef _PCOMMAND_G
#define vextern
#define INIT(x) = (x)
#else
#define vextern extern
#define INIT(x)
#endif

typedef struct _pcommand {
    char *cmd;
    int   cmdlen;
    int (*cmd_callback)(/* char *cmd, char *argstring, char *client_data */);
    struct _pcommand *next;
} pcommand;

vextern pcommand *process_commands INIT((pcommand *)0);

extern pcommand *S_process_findcmd (/* char *cmd */);
extern int S_process_addcmd (/* char *cmd, int (*callback)(char *cmd, char *argstring) */);
extern int S_process_delcmd (/* char *cmd */);
extern int S_process_callcmd (/* char *cmd, char *argstring */);

extern int S_process_tokenize (/* char *argstring, int *argc, char ***argv */);
extern void S_process_tokenize_free (/* int argc, char **argv */);

/* Filter 'in' to make suitable for use as an X11 resource file name. */
extern void S_process_xize_name (/* char *in, char **out */);

/* Try to find 'str' in the array 'strings' & return the index. Return -1 on nomatch. */
extern int  S_process_match (/* char *str, char **strings, int nstrings */);

#undef vextern
#undef INIT
#endif
