<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<!--define the color types used by the tables -->
	<xsl:variable name="g_tableBG" select="'#82C0FF'" />
	<xsl:variable name="g_headerBG" select="'#CCE6FF'" />
	<xsl:variable name="g_rowBG_1" select="'#EEEEEE'" />
	<xsl:variable name="g_rowBG_2" select="'#FFFFFF'" />
	<!--define the default rounding patterns -->
	<xsl:variable name="g_defaultPattern" select="'#,##0.00'" />
	<xsl:variable name="g_defaultScientific" select="'0.00E0'" />

	<xsl:attribute-set name="title">
		<xsl:attribute name="color">#000000</xsl:attribute>
		<xsl:attribute name="size">6</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="subtitle">
		<xsl:attribute name="color">#000000</xsl:attribute>
		<xsl:attribute name="size">5</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="table-content">
		<xsl:attribute name="color">#000000</xsl:attribute>
		<xsl:attribute name="size">3</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="row-header">
		<xsl:attribute name="color">#000000</xsl:attribute>
		<xsl:attribute name="size">3</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="column-header">
		<xsl:attribute name="color">#000000</xsl:attribute>
		<xsl:attribute name="size">3</xsl:attribute>
	</xsl:attribute-set>

	<xsl:template match="S-PLUS">
		<html>
			<title></title>
			<body>
				<xsl:if test="boolean(./Header/Annotation)">
					<h1><xsl:value-of select="./Header/Annotation/text()"/></h1>
				</xsl:if>
				
				<xsl:call-template name="GroupingInfo">
					<xsl:with-param name="element" select="./Generic/List/Components/Component/MultiDimensionalArray" />
					<xsl:with-param name="dimensionColumnNames" select="./Generic/List/Components/Component[2]/Vector" />
					<xsl:with-param name="maxColumnsPerTable" select="./Generic/List/Components/Component[3]/Vector/Items/Item/text()" />
				</xsl:call-template>
				<xsl:call-template name="GroupingInfo">
					<xsl:with-param name="element" select="./Generic/List/Components/Component/Matrix" />
					<xsl:with-param name="dimensionColumnNames" select="./Generic/List/Components/Component[2]/Vector" />
					<xsl:with-param name="maxColumnsPerTable" select="./Generic/List/Components/Component[3]/Vector/Items/Item/text()" />
				</xsl:call-template>
				<xsl:call-template name="ColumnInfo">
					<xsl:with-param name="splusElement" select="."/>
					<xsl:with-param name="element" select="./Generic/List/Components/Component"/>
					<xsl:with-param name="dimensionColumnNames" select="./Generic/List/Components/Component[2]/Vector" />
					<xsl:with-param name="maxColumnsPerTable" select="./Generic/List/Components/Component[3]/Vector/Items/Item/text()" />
				</xsl:call-template>
			</body>
		</html>
	</xsl:template>

	<xsl:template name="GroupingInfo">
		<xsl:param name="element" select="''" />
		<xsl:param name="dimensionColumnNames" select="''" />
		<xsl:param name="maxColumnsPerTable" select="''" />


		<xsl:if test="name($element) = 'Matrix'">
			<xsl:call-template name="Matrix">
				<xsl:with-param name="element" select="$element" />
				<xsl:with-param name="title" select="'Grouping Description'" />
				<xsl:with-param name="dimensionColumnNames" select="$dimensionColumnNames"/>
				<xsl:with-param name="maxColumnsPerTable" select="$maxColumnsPerTable" />
			</xsl:call-template>
		</xsl:if>
		<xsl:if test="name($element) = 'MultiDimensionalArray'">
			<xsl:call-template name="MultiDimensionalArray">
				<xsl:with-param name="element" select="$element" />
				<xsl:with-param name="title" select="'Grouping Description'" />
				<xsl:with-param name="dimensionColumnNames" select="$dimensionColumnNames"/>
				<xsl:with-param name="maxColumnsPerTable" select="$maxColumnsPerTable" />
			</xsl:call-template>
		</xsl:if>
	</xsl:template>

	<xsl:template name="ColumnInfo">
		<xsl:param name="splusElement" select="''" />
		<xsl:param name="element" select="''" />
		<xsl:param name="dimensionColumnNames" select="''" />
		<xsl:param name="maxColumnsPerTable" select="''" />

		<div>
			<h2><font xsl:use-attribute-sets="title">Column Summary</font></h2>
			<xsl:choose>
				<xsl:when test="boolean($splusElement/Generic/List/Components/Component/Matrix)">
					<!-- EXACTLY 2 GROUPING VARS -->
					<xsl:call-template name="MatrixColumnInfo">
						<xsl:with-param name="splusElement" select="$splusElement" />
						<xsl:with-param name="element" select="$element" />
						<xsl:with-param name="dimensionColumnNames" select="$dimensionColumnNames"/>
						<xsl:with-param name="maxColumnsPerTable" select="$maxColumnsPerTable"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="boolean($splusElement/Generic/List/Components/Component/MultiDimensionalArray)">
					<!-- ANY OTHER NUM GROUPING  VARS (EXCEPT 2) -->
					<xsl:call-template name="ArrayColumnInfo">
						<xsl:with-param name="splusElement" select="$splusElement" />
						<xsl:with-param name="element" select="$element" />
						<xsl:with-param name="dimensionColumnNames" select="$dimensionColumnNames"/>
						<xsl:with-param name="maxColumnsPerTable" select="$maxColumnsPerTable"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<!-- NO GROUPING -->
					<xsl:call-template name="NoGroupColumnInfo">
						<xsl:with-param name="splusElement" select="$splusElement" />
						<xsl:with-param name="element" select="$element" />
						<xsl:with-param name="dimensionColumnNames" select="$dimensionColumnNames"/>
						<xsl:with-param name="maxColumnsPerTable" select="$maxColumnsPerTable"/>
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
		</div>
	</xsl:template>

	<xsl:template name="ArrayColumnInfo">
		<xsl:param name="splusElement" select="''" />
		<xsl:param name="element" select="''" />
		<xsl:param name="dimensionColumnNames" select="''" />
		<xsl:param name="maxColumnsPerTable" select="''" />

		<xsl:variable name="decimalPattern">
			<xsl:choose>
				<xsl:when test="not(boolean($splusElement/DisplayOptions/@decimalPattern))"><xsl:value-of select="$g_defaultPattern"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="$splusElement/DisplayOptions/@decimalPattern"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="scientificPattern">
			<xsl:choose>
				<xsl:when test="not(boolean($splusElement/DisplayOptions/@scientificPattern))"><xsl:value-of select="$g_defaultScientific"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="$splusElement/DisplayOptions/@scientificPattern"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<xsl:variable name="splusGrouping" select="$splusElement/Generic/List/Components/Component" />
		<xsl:variable name="dominantLevels" select="$splusGrouping/MultiDimensionalArray/Attrs/Attr[@name = '.Dimnames']/List/Components/Component[1]/Vector/Items/Item" />
		<xsl:variable name="otherLevels" select="$splusGrouping/MultiDimensionalArray/Attrs/Attr[@name = '.Dimnames']/List/Components/Component[position() != 1]/Vector/Items/Item" />
		<xsl:variable name="numLevels" select="count($dominantLevels)" />

		<xsl:variable name="columnNames" select="$element/Generic/List/Components/Component/Generic/Attrs/Attr[@name = '.Names']"/>
		<xsl:variable name="listChildren" select="$element/Generic/List/Components/Component/*" />

		<xsl:for-each select="$listChildren[position() mod $numLevels = 0]" >
			<xsl:variable name="tableNum" select="position() - 1" />
			<xsl:variable name="columnNameSet" select="$columnNames[last()]/Vector/Items/Item" />
			<xsl:variable name="startPosition" select="$tableNum * $numLevels"/>
			<xsl:variable name="endPosition" select="$startPosition + $numLevels" />

			<xsl:if test="count($listChildren[position() &gt; $startPosition and position() &lt;= $endPosition][name() != 'Vector']) > 0">
				<div>
					<xsl:if test="count($otherLevels/../..) &gt; 0">
						<h3><font xsl:use-attribute-sets="subtitle">
							<xsl:call-template name="ArrayGetTableTitle">
								<xsl:with-param name="tableNum" select="$tableNum"/>
								<xsl:with-param name="numOtherDim" select="count($otherLevels/../..)" />
								<xsl:with-param name="levelDims" select="$otherLevels/.." />
								<xsl:with-param name="dimensionColumnNames" select="$dimensionColumnNames" />
								<xsl:with-param name="ignoreFirstNDims" select="1"/>
							</xsl:call-template>
						</font></h3>
					</xsl:if>

					<xsl:call-template name="CreateTable">
						<xsl:with-param name="columnNameSet" select="$columnNameSet" />
						<xsl:with-param name="columnNames" select="$columnNames" />
						<xsl:with-param name="dominantLevels" select="$dominantLevels" />
						<xsl:with-param name="otherLevels" select="$otherLevels" />
						<xsl:with-param name="dimensionColumnNames" select="$dimensionColumnNames"/>
						<xsl:with-param name="tableNum" select="$tableNum" />
						<xsl:with-param name="element" select="$element[last()]" />
						<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
						<xsl:with-param name="scientificPattern" select="$scientificPattern"/>
						<xsl:with-param name="maxColumnsPerTable" select="$maxColumnsPerTable"/>
					</xsl:call-template>
				</div>

				<h2 />
			</xsl:if>

		</xsl:for-each>
	</xsl:template>

	<xsl:template name="MatrixColumnInfo">
		<xsl:param name="splusElement" select="''" />
		<xsl:param name="element" select="''" />
		<xsl:param name="dimensionColumnNames" select="''" />
		<xsl:param name="maxColumnsPerTable" select="''" />

		<xsl:variable name="decimalPattern">
			<xsl:choose>
				<xsl:when test="not(boolean($splusElement/DisplayOptions/@decimalPattern))"><xsl:value-of select="$g_defaultPattern"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="$splusElement/DisplayOptions/@decimalPattern"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="scientificPattern">
			<xsl:choose>
				<xsl:when test="not(boolean($splusElement/DisplayOptions/@scientificPattern))"><xsl:value-of select="$g_defaultScientific"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="$splusElement/DisplayOptions/@scientificPattern"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<xsl:variable name="columnNames" select="$element/Generic/List/Components/Component/Generic/Attrs/Attr[@name = '.Names']"/>
		<xsl:variable name="splusGrouping" select="$splusElement/Generic/List/Components/Component" />

		<xsl:variable name="dominantLevels" select="$splusGrouping/Matrix/RowNames/Items/Item" />
		<xsl:variable name="otherLevels" select="$splusGrouping/Matrix/Columns/Column" />
		<xsl:variable name="numLevels" select="count($dominantLevels)" />

		<xsl:for-each select="$splusGrouping/Matrix/Columns/Column">
			<xsl:variable name="tableNum" select="position() - 1" />
			<xsl:variable name="columnNameSet" select="$columnNames[last()]/Vector/Items/Item" />

			<div>
				<h3><font xsl:use-attribute-sets="subtitle">
					<xsl:call-template name="MatrixGetTableTitle">
						<xsl:with-param name="levelDims" select="$otherLevels" />
						<xsl:with-param name="tableNum" select="$tableNum"/>
						<xsl:with-param name="dimensionColumnNames" select="$dimensionColumnNames"/>
					</xsl:call-template>
				</font></h3>

				<xsl:call-template name="CreateTable">
					<xsl:with-param name="columnNameSet" select="$columnNameSet" />
					<xsl:with-param name="columnNames" select="$columnNames" />
					<xsl:with-param name="dominantLevels" select="$dominantLevels" />
					<xsl:with-param name="otherLevels" select="$otherLevels" />
					<xsl:with-param name="dimensionColumnNames" select="$dimensionColumnNames"/>
					<xsl:with-param name="tableNum" select="$tableNum" />
					<xsl:with-param name="element" select="$element" />
					<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
					<xsl:with-param name="scientificPattern" select="$scientificPattern"/>
					<xsl:with-param name="maxColumnsPerTable" select="$maxColumnsPerTable"/>
				</xsl:call-template>

			</div>

			<h2 />

		</xsl:for-each>
	</xsl:template>

	<xsl:template name="NoGroupColumnInfo">
		<xsl:param name="splusElement" select="''" />
		<xsl:param name="element" select="''" />
		<xsl:param name="dimensionColumnNames" select="''" />
		<xsl:param name="maxColumnsPerTable" select="''" />

		<xsl:variable name="decimalPattern">
			<xsl:choose>
				<xsl:when test="not(boolean($splusElement/DisplayOptions/@decimalPattern))"><xsl:value-of select="$g_defaultPattern"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="$splusElement/DisplayOptions/@decimalPattern"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="scientificPattern">
			<xsl:choose>
				<xsl:when test="not(boolean($splusElement/DisplayOptions/@scientificPattern))"><xsl:value-of select="$g_defaultScientific"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="$splusElement/DisplayOptions/@scientificPattern"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<xsl:variable name="dominantLevels" select="$splusElement/Generic/Components/Component/Matrix" />
		<xsl:variable name="otherLevels" select="$splusElement/Generic/Components/Component/Matrix" />
		<xsl:variable name="columnNames" select="$element/Generic/Attrs/Attr[@name = '.Names']"/>
		<xsl:variable name="numLevels" select="count($dominantLevels)" />

		<xsl:variable name="tableNum" select="position() - 1" />
		<xsl:variable name="columnNameSet" select="$columnNames[last()]/Vector/Items/Item" />

		<div>
			<xsl:call-template name="CreateTable">
				<xsl:with-param name="columnNameSet" select="$columnNameSet" />
				<xsl:with-param name="columnNames" select="$columnNames" />
				<xsl:with-param name="dominantLevels" select="$dominantLevels" />
				<xsl:with-param name="otherLevels" select="$otherLevels" />
				<xsl:with-param name="tableNum" select="0" />
				<xsl:with-param name="element" select="$element" />
				<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
				<xsl:with-param name="scientificPattern" select="$scientificPattern"/>
				<xsl:with-param name="maxColumnsPerTable" select="$maxColumnsPerTable"/>
			</xsl:call-template>
		</div>
	</xsl:template>

	<xsl:template name="CreateTable">
		<xsl:param name="columnNameSet" select="''" />
		<xsl:param name="columnNames" select="''" />
		<xsl:param name="dimensionColumnNames" select="''" />
		<xsl:param name="dominantLevels" select="''" />
		<xsl:param name="otherLevels" select="''" />
		<xsl:param name="tableNum" select="''" />
		<xsl:param name="element" select="''" />
		<xsl:param name="decimalPattern" select="''" />
		<xsl:param name="scientificPattern" select="''" />
		<xsl:param name="currentLevelNum" select="1" />
		<xsl:param name="maxColumnsPerTable" select="''" />

		<!--
			in order to break the tables up to fit onto a page
			we need to store the start and end levels so we
			can iterativly cover all the levels.
		-->
		<xsl:variable name="domLevelCount" select="count($dominantLevels)" />
		<xsl:variable name="startLevel">
			<xsl:choose><xsl:when test="$maxColumnsPerTable &gt; 0"><xsl:value-of select="$currentLevelNum"/></xsl:when><xsl:otherwise>1</xsl:otherwise></xsl:choose>
		</xsl:variable>
		<xsl:variable name="endLevel">
			<xsl:choose>
				<xsl:when test="$maxColumnsPerTable &gt; 0"><xsl:value-of select="$currentLevelNum + $maxColumnsPerTable"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="$domLevelCount + 1"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="dominantLevelsSubset" select="$dominantLevels[position() &gt;= $startLevel and position() &lt; $endLevel]" />
		<xsl:variable name="totalDominantLevelCount" select="count($dominantLevels)" />

		<xsl:variable name="testChildren" select="$element/Generic/List/Components/Component/*" />
		<xsl:variable name="testStartPosition" select="$tableNum * $totalDominantLevelCount+ $startLevel"/>
		<xsl:variable name="testEndPosition" select="$testStartPosition + count($dominantLevelsSubset)" />

		<xsl:if test="($totalDominantLevelCount = 0) or (count($testChildren[position() &gt;= $testStartPosition and position() &lt; $testEndPosition][name() != 'Vector']) > 0)">
			<table border="0" cellspacing="0" cellpadding="3">
				<tr>
					<td bgcolor="{$g_tableBG}" >
						<table cellspacing="1" cellpadding="5" border="0" width="100%">
							<xsl:if test="count($dominantLevelsSubset) != 0">
								  <tr>
								  	<th bgcolor="{$g_tableBG}"></th>
								  	<th bgcolor="{$g_tableBG}"></th>
								  	<xsl:element name="th">
								  		<xsl:attribute name="bgcolor"><xsl:value-of select="$g_headerBG" /></xsl:attribute>
								  		<xsl:attribute name="colspan"><xsl:value-of select="count($dominantLevelsSubset)"/></xsl:attribute>
								  		<font xsl:use-attribute-sets="column-header"><xsl:value-of select="$dimensionColumnNames/Items/Item[1]"/></font>
								  	</xsl:element>
								</tr>
							</xsl:if>

							  <tr>
							  	<th bgcolor="{$g_tableBG}"></th>
							  	<th bgcolor="{$g_tableBG}"></th>
								<xsl:if test="count($dominantLevelsSubset) = 0"><th bgcolor="{$g_headerBG}">
									<font xsl:use-attribute-sets="column-header">Statistic</font>
								</th></xsl:if>
								<xsl:for-each select="$dominantLevelsSubset"><th bgcolor="{$g_headerBG}">
									<font xsl:use-attribute-sets="column-header"><xsl:value-of select="./text()"/></font>
								</th></xsl:for-each>
							</tr>

							<!-- add statistics for the "rows" described by the column/level combination -->
							<xsl:for-each select="$columnNameSet">
								<xsl:variable name="columnNum" select="position() - 1"/>

								<xsl:call-template name="ColumnInfoRowsPerColumnAndLevel">
									<xsl:with-param name="element" select="$element"/>
									<xsl:with-param name="levels" select="$dominantLevelsSubset"/>
									<xsl:with-param name="numLevels" select="$totalDominantLevelCount" />
									<xsl:with-param name="columnNum" select="$columnNum"/>
									<xsl:with-param name="tableNum" select="$tableNum" />
									<xsl:with-param name="columnName" select="./text()" />
									<xsl:with-param name="decimalPattern" select="$decimalPattern" />
									<xsl:with-param name="scientificPattern" select="$scientificPattern" />
									<xsl:with-param name="startLevel" select="$startLevel" />
								</xsl:call-template>
							</xsl:for-each>
						</table>
					</td>
				</tr>
			</table>

			<br/>
		</xsl:if>

		<xsl:if test="$maxColumnsPerTable &gt; 0 and $endLevel &lt;= $domLevelCount">
			<xsl:call-template name="CreateTable">
				<xsl:with-param name="columnNameSet" select="$columnNameSet" />
				<xsl:with-param name="columnNames" select="$columnNames" />
				<xsl:with-param name="dimensionColumnNames" select="$dimensionColumnNames" />
				<xsl:with-param name="dominantLevels" select="$dominantLevels" />
				<xsl:with-param name="otherLevels" select="$otherLevels" />
				<xsl:with-param name="tableNum" select="$tableNum" />
				<xsl:with-param name="element" select="$element" />
				<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
				<xsl:with-param name="scientificPattern" select="$scientificPattern"/>
				<xsl:with-param name="currentLevelNum" select="$endLevel" />
				<xsl:with-param name="maxColumnsPerTable" select="$maxColumnsPerTable"/>
			</xsl:call-template>
		</xsl:if>

	</xsl:template>

	<xsl:template name="MatrixGetTableTitle">
		<xsl:param name="tableNum" select="''"/>
		<xsl:param name="levelDims" select="''" />
		<xsl:param name="dimensionColumnNames" select="''" />

		<xsl:variable name="modulus" select="count($levelDims)" />
		<xsl:variable name="curDimVal" select="$tableNum mod $modulus" />
		<xsl:variable name="curDimName" select="$levelDims[$curDimVal + 1]/@name" />

		<xsl:variable name="dimensionalOutput">
			<xsl:value-of select="$dimensionColumnNames/Items/Item[2]"/><xsl:text> = </xsl:text><xsl:value-of select="$curDimName"/>
		</xsl:variable>

		<xsl:value-of select="$dimensionalOutput"/><br/>

	</xsl:template>

	<xsl:template name="ArrayGetTableTitle">
		<xsl:param name="tableNum" select="''"/>
		<xsl:param name="levelDims" select="''" />
		<xsl:param name="numOtherDim" select="0" />
		<xsl:param name="curDim" select="1" />
		<xsl:param name="dimensionColumnNames" select="''" />
		<xsl:param name="ignoreFirstNDims" select="1"/>
		<xsl:param name="dividor" select="1" />
		<xsl:param name="label" select="'(,'" />

		<xsl:variable name="modulus" select="count($levelDims[$curDim]/Item)" />
		<xsl:variable name="curDimVal" select="(floor($tableNum div $dividor)) mod $modulus" />
		<xsl:variable name="curDimName" select="$levelDims[$curDim]/Item[$curDimVal + 1]/text()" />
		<xsl:variable name="dimensionalOutput">
			<xsl:value-of select="$dimensionColumnNames/Items/Item[$curDim + $ignoreFirstNDims]"/><xsl:text> = </xsl:text><xsl:value-of select="$curDimName"/>
		</xsl:variable>

		<xsl:value-of select="$dimensionalOutput"/><br/>

		<xsl:if test="$curDim != $numOtherDim">
			<xsl:call-template name="ArrayGetTableTitle">
				<xsl:with-param name="tableNum" select="$tableNum"/>
				<xsl:with-param name="numOtherDim" select="$numOtherDim" />
				<xsl:with-param name="levelDims" select="$levelDims" />
				<xsl:with-param name="dividor" select="$dividor * $modulus" />
				<xsl:with-param name="curDim" select="$curDim + 1" />
				<xsl:with-param name="label" select="concat($label, $curDimName, '[', $dimensionColumnNames/Items/Item[$curDim + $ignoreFirstNDims], ']', ', ')" />
				<xsl:with-param name="dimensionColumnNames" select="$dimensionColumnNames" />
				<xsl:with-param name="ignoreFirstNDims" select="$ignoreFirstNDims"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>

	<xsl:template name="ColumnInfoRowsPerColumnAndLevel">
		<xsl:param name="element" select="''" />
		<xsl:param name="columnName" select="''" />
		<xsl:param name="columnNum" select="''" />
		<xsl:param name="tableNum" select="'0'" />
		<xsl:param name="levels" select="''" />
		<xsl:param name="numLevels" select="0" />
		<xsl:param name="decimalPattern" select="''" />
		<xsl:param name="scientificPattern" select="''" />
		<xsl:param name="startLevel" select="0" />

		<xsl:variable name="noLevelChildren" select="$element/Generic" />
		<xsl:variable name="levelChildren" select="$element/Generic/List/Components/Component/*" />
		<xsl:variable name="rowChildren" select="$noLevelChildren[position() &lt;= (last() * number($numLevels = 0))]  | $levelChildren[position() &lt;= (last() * number($numLevels != 0))]"/>
		<xsl:variable name="rowStartPos">
			<xsl:choose>
				<xsl:when test="$numLevels = 0"><xsl:value-of select="$tableNum + 1"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="($tableNum * $numLevels) + 1"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<xsl:call-template name="GetNumericInfoRows">
			<xsl:with-param name="levels" select="$levels" />
			<xsl:with-param name="numLevels" select="$numLevels" />
			<xsl:with-param name="element" select="$rowChildren" />
			<xsl:with-param name="startPos" select="$rowStartPos" />
			<xsl:with-param name="columnNum" select="$columnNum + 1" />
			<xsl:with-param name="columnName" select="$columnName" />
			<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
			<xsl:with-param name="scientificPattern" select="$scientificPattern"/>
			<xsl:with-param name="startLevel" select="$startLevel"/>
		</xsl:call-template>
		<xsl:call-template name="GetCategoryInfoRows">
			<xsl:with-param name="levels" select="$levels" />
			<xsl:with-param name="numLevels" select="$numLevels" />
			<xsl:with-param name="element" select="$rowChildren" />
			<xsl:with-param name="startPos" select="$rowStartPos" />
			<xsl:with-param name="columnNum" select="$columnNum + 1" />
			<xsl:with-param name="columnName" select="$columnName" />
			<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
			<xsl:with-param name="scientificPattern" select="$scientificPattern"/>
			<xsl:with-param name="startLevel" select="$startLevel"/>
		</xsl:call-template>
	</xsl:template>

	<xsl:template name="GetNumericInfoRows">
		<xsl:param name="levels" select="''" />
		<xsl:param name="numLevels" select="0" />
		<xsl:param name="element" select="''" />
		<xsl:param name="startPos" select="0" />
		<xsl:param name="columnNum" select="1" />
		<xsl:param name="columnName" select="''" />
		<xsl:param name="decimalPattern" select="''" />
		<xsl:param name="scientificPattern" select="''" />
		<xsl:param name="startLevel" select="1" />

		<xsl:variable name="adjustedLevelCount">
			<xsl:choose>
				<xsl:when test="$numLevels = 0">1</xsl:when>
				<xsl:otherwise><xsl:value-of select="$numLevels"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="possibleData" select="$element[$startPos]/List/Components/Component/*" />
		<xsl:variable name="firstList" select="$element[position() &gt;= $startPos and position() &lt; ($startPos + $adjustedLevelCount)]/List" />
		<xsl:variable name="data" select="$possibleData[$columnNum]/List/Components/Component/Vector"  />
		<xsl:variable name="itemCount" select="count($data)" />

		<xsl:if test="count($firstList[1]/Components/Component[$columnNum]/Generic/List/Components/Component/MultiDimensionalArray) = 0">
			<xsl:variable name="rowNames" select="$firstList[1]/Components/Component[$columnNum]/Generic/Attrs/Attr[last()]/Vector/Items/Item" />
			<xsl:variable name="numRowNames" select="count($rowNames)" />
			<xsl:for-each select="$rowNames">
				<xsl:variable name="dataItem" select="position()" />
				<xsl:variable name="rowName" select="./text()" />

				<xsl:element name="tr">
					<xsl:attribute name="bgcolor"><xsl:choose>
							<xsl:when test="$dataItem mod 2 = 1"><xsl:value-of select="$g_rowBG_1" /></xsl:when>
							<xsl:otherwise><xsl:value-of select="$g_rowBG_2" /></xsl:otherwise>
					</xsl:choose></xsl:attribute>

					<xsl:if test="$dataItem = 1">
						<xsl:element name="th">
							<xsl:attribute name="bgcolor"><xsl:value-of select="$g_headerBG" /></xsl:attribute>
							<xsl:attribute name="rowspan"><xsl:value-of select="$numRowNames"/></xsl:attribute>
							<font xsl:use-attribute-sets="row-header"><xsl:value-of select="$columnName"/></font>
						</xsl:element>
					</xsl:if>
					<th bgcolor="{$g_headerBG}">
						<font xsl:use-attribute-sets="row-header"><xsl:value-of select="$rowName"/></font>
					</th>

					<xsl:if test="$numLevels = 0">
						<td align="right">
							<xsl:call-template name="OutputNumericItem">
								<xsl:with-param name="element" select="$element" />
								<xsl:with-param name="startPos" select="$startPos" />
								<xsl:with-param name="columnNum" select="$columnNum" />
								<xsl:with-param name="dataItem" select="$dataItem" />
								<xsl:with-param name="rowName" select="$rowName" />
								<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
								<xsl:with-param name="scientificPattern" select="$scientificPattern"/>
							</xsl:call-template>
						</td>
					</xsl:if>
					<xsl:for-each select="$levels">
						<xsl:variable name="levelNum" select="position()" />

						<td align="right">
							<xsl:call-template name="OutputNumericItem">
								<xsl:with-param name="element" select="$element" />
								<xsl:with-param name="startPos" select="($startLevel - 1) + $startPos + $levelNum - 1" />
								<xsl:with-param name="columnNum" select="$columnNum" />
								<xsl:with-param name="dataItem" select="$dataItem" />
								<xsl:with-param name="rowName" select="$rowName" />
								<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
								<xsl:with-param name="scientificPattern" select="$scientificPattern"/>
							</xsl:call-template>
						</td>
					</xsl:for-each>
				</xsl:element>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>

	<xsl:template name="OutputNumericItem">
		<xsl:param name="element" select="''" />
		<xsl:param name="startPos" select="''" />
		<xsl:param name="columnNum" select="''" />
		<xsl:param name="dataItem" select="''" />
		<xsl:param name="rowName" select="''" />
		<xsl:param name="decimalPattern" select="''" />
		<xsl:param name="scientificPattern" select="''" />

		<font xsl:use-attribute-sets="table-content">
			<xsl:choose>
				<xsl:when test="name($element[$startPos]) = 'Null'"><xsl:text> </xsl:text></xsl:when>
				<xsl:otherwise>
					<xsl:variable name="nonListItems" select="$element[$startPos]/List/Components/Component[$columnNum]/Generic/List/Components/Component[$dataItem]/Vector/Items/Item" />
					<xsl:variable name="listItems" select="$element[$startPos]/List/Components/Component[$columnNum]/Generic/List/Components/Component[$dataItem]/Generic/Vector/Items/Item" />
					<xsl:variable name="items" select="$nonListItems[position() &lt;= (last() * number(boolean($nonListItems)))] | $listItems[position() &lt;= (last() * number(boolean($listItems)))]" />

					<xsl:choose>
						<xsl:when test="$rowName = 'missing'">
							<xsl:call-template name="OutputCountAndPercent">
								<xsl:with-param name="count" select="$items[1]/text()" />
								<xsl:with-param name="percent" select="$items[2]/text()" />
								<xsl:with-param name="decimalPattern" select="$decimalPattern" />
								<xsl:with-param name="scientificPattern" select="$scientificPattern" />
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<xsl:if test="count($items) &gt; 1">(</xsl:if>
							<xsl:for-each select="$items">
								<xsl:call-template name="roundNumber">
									<xsl:with-param name="string" select="./text()"/>
									<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
									<xsl:with-param name="scientificPattern" select="$scientificPattern"/>
								</xsl:call-template>
								<xsl:if test="position() != last()"><xsl:text>, </xsl:text></xsl:if>
							</xsl:for-each>
							<xsl:if test="count($items) &gt; 1">)</xsl:if>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
		</font>
	</xsl:template>

	<xsl:template name="GetCategoryInfoRows">
		<xsl:param name="levels" select="''" />
		<xsl:param name="numLevels" select="0" />
		<xsl:param name="element" select="''" />
		<xsl:param name="startPos" select="0" />
		<xsl:param name="columnNum" select="1" />
		<xsl:param name="columnName" select="''" />
		<xsl:param name="decimalPattern" select="''" />
		<xsl:param name="scientificPattern" select="''" />
		<xsl:param name="startLevel" select="1" />


		<xsl:variable name="adjustedLevelCount">
			<xsl:choose>
				<xsl:when test="$numLevels = 0">1</xsl:when>
				<xsl:otherwise><xsl:value-of select="$numLevels"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<xsl:variable name="firstArray"  select="$element[position() &gt;= $startPos and position() &lt; ($startPos + $adjustedLevelCount)]/List/Components/Component[$columnNum]/Generic/List/Components/Component/MultiDimensionalArray"/>
		<xsl:variable name="data" select="$element[$startPos]/List/Components/Component/Generic/List/Components/Component[$columnNum]/MultiDimensionalArray"  />
		<xsl:variable name="loopData" select="$firstArray[1]/Attrs/Attr[@name = '.Dimnames']/List/Components/Component/Vector/Items/Item" />
		<xsl:variable name="loopCount" select="count($loopData)" />
		<xsl:variable name="itemCount" select="count($data)" />

		<xsl:for-each select="$loopData">
			<xsl:variable name="levelPos" select="position()" />
			<xsl:variable name="levelName" select="./text()" />

			<xsl:element name="tr">
				<xsl:attribute name="bgcolor"><xsl:choose>
						<xsl:when test="$levelPos mod 2 = 1"><xsl:value-of select="$g_rowBG_1" /></xsl:when>
						<xsl:otherwise><xsl:value-of select="$g_rowBG_2" /></xsl:otherwise>
				</xsl:choose></xsl:attribute>

				<xsl:if test="$levelPos= 1">
					<xsl:element name="th">
						<xsl:attribute name="bgcolor"><xsl:value-of select="$g_headerBG" /></xsl:attribute>
						<xsl:attribute name="rowspan"><xsl:value-of select="$loopCount"/></xsl:attribute>
						<font xsl:use-attribute-sets="row-header"><xsl:value-of select="$columnName"/></font>
					</xsl:element>
				</xsl:if>
				<th bgcolor="{$g_headerBG}"><font xsl:use-attribute-sets="row-header">
					<xsl:value-of select="$levelName"/>
				</font></th>

				<xsl:if test="$numLevels = 0">
					<xsl:variable name="mdarrays" select="$element[$startPos]/List/Components/Component[$columnNum]/Generic/List/Components/Component/MultiDimensionalArray" />

					<td align="right">
						<xsl:call-template name="OutputCountAndPercent">
							<xsl:with-param name="count" select="$mdarrays[1]/Vector/Items/Item[$levelPos]/text()" />
							<xsl:with-param name="percent" select="$mdarrays[2]/Vector/Items/Item[$levelPos]/text()" />
							<xsl:with-param name="decimalPattern" select="$decimalPattern" />
							<xsl:with-param name="scientificPattern" select="$scientificPattern" />
						</xsl:call-template>
					</td>
				</xsl:if>
				<xsl:for-each select="$levels">
					<xsl:variable name="domLevelNum" select="position()" />
					<xsl:variable name="mdarrays" select="$element[($startLevel - 1) + $startPos + $domLevelNum - 1]/List/Components/Component[$columnNum]/Generic/List/Components/Component/MultiDimensionalArray" />

					<td align="right">
						<xsl:call-template name="OutputCountAndPercent">
							<xsl:with-param name="count" select="$mdarrays[1]/Vector/Items/Item[$levelPos]/text()" />
							<xsl:with-param name="percent" select="$mdarrays[2]/Vector/Items/Item[$levelPos]/text()" />
							<xsl:with-param name="decimalPattern" select="$decimalPattern" />
							<xsl:with-param name="scientificPattern" select="$scientificPattern" />
						</xsl:call-template>
					</td>
				</xsl:for-each>
			</xsl:element>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="OutputCountAndPercent">
		<xsl:param name="count" select="''" />
		<xsl:param name="percent" select="''" />
		<xsl:param name="decimalPattern" select="''" />
		<xsl:param name="scientificPattern" select="''" />

		<font xsl:use-attribute-sets="table-content">
			<xsl:value-of select="$count"/>
			<xsl:if test="boolean($percent)">
				(<xsl:call-template name="roundNumber">
					<xsl:with-param name="string" select="$percent"/>
					<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
					<xsl:with-param name="scientificPattern" select="$scientificPattern"/>
				</xsl:call-template>%)
			</xsl:if>
		</font>
	</xsl:template>

	<xsl:template name="ColumnNameWidth">
		<xsl:param name="element" select="''"/>
		<xsl:param name="CurrentNum" select="1"/>
		<xsl:param name="TotalNum" select="0"/>
		<xsl:param name="minWidth" select="50"/>
		<xsl:param name="maxWidth" select="0"/>

		<xsl:variable name="this" select="$element[$CurrentNum]/@name"/>
		<xsl:variable name="thisWidth" select="string-length($this) * 8"/>

		<xsl:choose>
			<xsl:when test="$TotalNum = 0 or $TotalNum = $CurrentNum">
				<!-- final case....return actual max -->
				<xsl:choose>
					<xsl:when test="$thisWidth &gt; $maxWidth">
						<xsl:choose>
							<xsl:when test="$minWidth &gt; $thisWidth"><xsl:value-of select="$minWidth"/></xsl:when>
							<xsl:otherwise>	<xsl:value-of select="$thisWidth"/></xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="$minWidth &gt; $maxWidth">	<xsl:value-of select="$minWidth"/>	</xsl:when>
							<xsl:otherwise>	<xsl:value-of select="$maxWidth"/></xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<!--iterate further -->
				<xsl:choose>
					<xsl:when test="$thisWidth &gt; $maxWidth">
						<xsl:call-template name="ColumnNameWidth">
							<xsl:with-param name="element" select="$element"/>
							<xsl:with-param name="CurrentNum" select="$CurrentNum + 1"/>
							<xsl:with-param name="TotalNum" select="$TotalNum"/>
							<xsl:with-param name="maxWidth" select="$thisWidth"/>
							<xsl:with-param name="minWidth" select="$minWidth"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="ColumnNameWidth">
							<xsl:with-param name="element" select="$element"/>
							<xsl:with-param name="CurrentNum" select="$CurrentNum + 1"/>
							<xsl:with-param name="TotalNum" select="$TotalNum"/>
							<xsl:with-param name="maxWidth" select="$maxWidth"/>
							<xsl:with-param name="minWidth" select="$minWidth"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<!--	HANDLE ALL MATRIX & ARRAY HERE -->
<!--   borrow code from splus.objects.fo.xsl     -->
<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<!--	HANDLE DATAFRAME OR MATRIX OBJECTS HERE -->
<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
	<xsl:template name="Matrix">
		<xsl:param name="element" select="''"/>
		<xsl:param name="dimensionColumnNames" select="''" />
		<xsl:param name="maxColumnsPerTable" select="''" />
		<xsl:param name="title" select="''"/>

		<div>
			<!-- display title -->
			<h2><font xsl:use-attribute-sets="title"><xsl:value-of select="$title"/></font></h2>
			<!-- display the dimensions -->
			<h3><font xsl:use-attribute-sets="subtitle">
				<xsl:text>Number of Categories:</xsl:text><br/>
				<div style="margin-left:30px;">
					<xsl:value-of select="$dimensionColumnNames/Items/Item[1]"/><xsl:text> : </xsl:text><xsl:value-of select="count($element/RowNames/Items/Item)"/><xsl:text> categories</xsl:text><br/>
					<xsl:value-of select="$dimensionColumnNames/Items/Item[2]"/><xsl:text> : </xsl:text><xsl:value-of select="count($element/Columns/Column)"/><xsl:text> categories</xsl:text><br/>
				</div>
			</font></h3>
			<h2 />
			
			<xsl:call-template name="MatrixTable">
				<xsl:with-param name="element" select="$element" />
				<xsl:with-param name="title" select="'Grouping Description'" />
				<xsl:with-param name="dimensionColumnNames" select="$dimensionColumnNames"/>
				<xsl:with-param name="maxColumnsPerTable" select="$maxColumnsPerTable" />
			</xsl:call-template>

		</div>
	</xsl:template>
		
	<xsl:template name="MatrixTable">
		<xsl:param name="element" select="''"/>
		<xsl:param name="dimensionColumnNames" select="''" />
		<xsl:param name="maxColumnsPerTable" select="''" />
		<xsl:param name="startLevel" select="1" />
		<xsl:param name="title" select="''"/>
		
		<xsl:variable name="allColumns" select="$element/Columns/Column" />
		<xsl:variable name="numColumns" select="count($allColumns)" />
		<xsl:variable name="endLevel">
			<xsl:choose>
				<xsl:when test="$maxColumnsPerTable &gt; 0"><xsl:value-of select="$startLevel + $maxColumnsPerTable" /></xsl:when>
				<xsl:otherwise><xsl:value-of select="$numColumns + 1" /></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="limitedColumns" select="$allColumns[position() &gt;= $startLevel and position() &lt; $endLevel]" />

		<!-- create table for display of data frame or of matrix -->
		<table border="0" cellspacing="0" cellpadding="3">
			<tr>
				<td bgcolor="{$g_tableBG}" >
					<table cellspacing="1" cellpadding="5" border="0" width="100%">
						<tr>
						  	<th bgcolor="{$g_tableBG}"></th>
						  	<th bgcolor="{$g_tableBG}"></th>
						  	<xsl:element name="th">
						  		<xsl:attribute name="bgcolor"><xsl:value-of select="$g_headerBG" /></xsl:attribute>
						  		<xsl:attribute name="colspan"><xsl:value-of select="count($limitedColumns)"/></xsl:attribute>
						  		<font xsl:use-attribute-sets="column-header"><xsl:value-of select="$dimensionColumnNames/Items/Item[2]"/></font>
						  	</xsl:element>
						  </tr>
						  <tr>
						  	<th bgcolor="{$g_tableBG}"></th>
						  	<th bgcolor="{$g_tableBG}"></th>
							<xsl:for-each select="$limitedColumns">
								<th bgcolor="{$g_headerBG}"><font xsl:use-attribute-sets="column-header">
									<xsl:value-of select="@name"/>
								</font></th>
							</xsl:for-each>
						</tr>

						<xsl:for-each select="$element/RowNames/Items/Item">
							<xsl:element name="tr">
								<xsl:variable name="position" select="position()"/>

								<xsl:attribute name="bgcolor">
									<xsl:choose>
										<xsl:when test="position() mod 2 = 0"><xsl:value-of select="$g_rowBG_2" /></xsl:when>
										<xsl:otherwise><xsl:value-of select="$g_rowBG_1" /></xsl:otherwise>
									</xsl:choose>
								</xsl:attribute>

								<xsl:if test="$position = 1">
								  	<xsl:element name="th">
								  		<xsl:attribute name="bgcolor"><xsl:value-of select="$g_headerBG" /></xsl:attribute>
								  		<xsl:attribute name="rowspan"><xsl:value-of select="count($element/RowNames/Items/Item)"/></xsl:attribute>
								  		<font xsl:use-attribute-sets="row-header"><xsl:value-of select="$dimensionColumnNames/Items/Item[1]"/></font>
								  	</xsl:element>
								</xsl:if>

								<!-- first item is row header that contains row name -->
								<th bgcolor="{$g_headerBG}"><font xsl:use-attribute-sets="row-header">
									<xsl:value-of select="./text()"/>
								</font></th>

								<!-- add actual data...watch for factors and missng values -->
								<font xsl:use-attribute-sets="table-content">
									<xsl:for-each select="$limitedColumns">
										<xsl:variable name="value" select="./Items/Item[$position]/text()"/>
										<xsl:variable name="innerElement" select="."/>

										<td align="right"><xsl:choose>
											<!-- factor -->
											<xsl:when test="count($innerElement/Attrs/Attr[@name = 'levels']) = 0"><xsl:value-of select="$value"/></xsl:when>
											<!-- missing factor -->
											<xsl:when test="$value = 'NA'"><xsl:text/></xsl:when>
											<!-- non-factor value -->
											<xsl:otherwise>	<xsl:value-of select="$innerElement/Attrs/Attr[@name='levels']/Vector/Items/Item[$value]/text()"/>	</xsl:otherwise>
										</xsl:choose></td>
									</xsl:for-each>
								</font>
							</xsl:element>
						</xsl:for-each>
					</table>
				</td>
			</tr>
		</table>

		<xsl:if test="$maxColumnsPerTable &gt; 0 and $endLevel &lt;= $numColumns">
			<br/>
			
			<xsl:call-template name="MatrixTable">
				<xsl:with-param name="element" select="$element" />
				<xsl:with-param name="title" select="'Grouping Description'" />
				<xsl:with-param name="dimensionColumnNames" select="$dimensionColumnNames"/>
				<xsl:with-param name="maxColumnsPerTable" select="$maxColumnsPerTable" />
				<xsl:with-param name="startLevel" select="$endLevel" />
			</xsl:call-template>
		</xsl:if>

	</xsl:template>

<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<!--	HANDLE MULTIDIMENSIONALARRAY OBJECTS HERE -->
<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
	<xsl:template name="MultiDimensionalArray">
		<xsl:param name="element" select="''"/>
		<xsl:param name="indent" select="'0'" />
		<xsl:param name="dimensionColumnNames" select="''" />
		<xsl:param name="title" select="''"/>
		<xsl:param name="maxColumnsPerTable" select="''" />

		<xsl:variable name="dimensionNodes" select="$element/Attrs/Attr[@name='.Dim']/Vector/Items/Item"/>
		<xsl:variable name="dimensionNameNodes" select="$element/Attrs/Attr[@name='.Dimnames']/List/Components/Component/Vector"/>
		<xsl:variable name="curDimNum" select="count($dimensionNodes)"/>
		<xsl:variable name="cellsPerTable" select="$dimensionNodes[1]/text() * $dimensionNodes[2]/text()"/>
		<xsl:variable name="numTables" select="floor(count($element/Vector/Items/Item) div ($cellsPerTable))"/>

		<!-- label the array -->
		<h2><font xsl:use-attribute-sets="title"><xsl:value-of select="$title"/></font></h2>
		<!-- display the dimensions -->
		<h3><font xsl:use-attribute-sets="subtitle">
			<xsl:text>Number of Categories:</xsl:text><br/>
			<div style="margin-left:30px;">
				<xsl:for-each select="$dimensionNodes">
					<xsl:variable name="dimNum" select="position()" />
					<xsl:value-of select="$dimensionColumnNames/Items/Item[$dimNum]/text()"/><xsl:text> : </xsl:text><xsl:value-of select="./text()"/><xsl:text> categories</xsl:text><br/>
				</xsl:for-each>
			</div>
		</font></h3>
		<h2 />

		<!--
			call function that iterates over all possible dimension combinations
			creating a two dimensional (use the first two dimensions)
			representation of the array.  for example, a 5x4x3x2 array would
			be represented by 3*2 tables with the dimensions: 5 rows and
			4 columns.
		-->
		<xsl:call-template name="CreateArrayTables">
			<xsl:with-param name="dimNodes" select="$dimensionNodes"/>
			<xsl:with-param name="dimNameNodes" select="$dimensionNameNodes"/>
			<xsl:with-param name="dimensionColumnNames" select="$dimensionColumnNames"/>
			<xsl:with-param name="numDims" select="$curDimNum"/>
			<xsl:with-param name="curDimNum" select="$curDimNum"/>
			<xsl:with-param name="curDimMax" select="$dimensionNodes[$curDimNum]/text()"/>
			<xsl:with-param name="numTables" select="$numTables"/>
			<xsl:with-param name="data" select="$element/Vector/Items"/>
			<xsl:with-param name="indent" select="$indent"/>
			<xsl:with-param name="maxColumnsPerTable" select="$maxColumnsPerTable" />
		</xsl:call-template>
	</xsl:template>

	<!-- recursively build tables that represent array -->
	<xsl:template name="CreateArrayTables">
		<xsl:param name="dimNodes" select="''"/>
		<xsl:param name="dimNameNodes" select="''"/>
		<xsl:param name="dimensionColumnNames" select="''"/>
		<xsl:param name="numDims" select="'2'"/>
		<xsl:param name="curDimNum" select="'1'"/>
		<xsl:param name="curDimMax" select="'1'"/>
		<xsl:param name="curDimVal" select="1"/>
		<xsl:param name="label" select="''"/>
		<xsl:param name="numTables" select="'0'"/>
		<xsl:param name="tableNum" select="'0'"/>
		<xsl:param name="tableDividor" select="'1'"/>
		<xsl:param name="data" select="''"/>
		<xsl:param name="indent" select="''"/>
		<xsl:param name="maxColumnsPerTable" select="''" />

		<xsl:variable name="tableSize" select="($dimNodes[1]/text() * $dimNodes[2]/text())"/>
		<xsl:variable name="startIndex" select="($tableNum * $tableSize)"/>
		<xsl:variable name="endIndex" select="$startIndex + $tableSize"/>

		<xsl:choose>
			<xsl:when test="$curDimNum = 1">
				<!--
					there's only 1 dimension in the array.
				-->
				<div>
					<xsl:call-template name="Create1DArrayTable">
						<xsl:with-param name="dimNodes" select="$dimNodes"/>
						<xsl:with-param name="dimNameNodes" select="$dimNameNodes"/>
						<xsl:with-param name="dimensionColumnNames" select="$dimensionColumnNames"/>
						<xsl:with-param name="zeroBasedTableNum" select="0"/>
						<xsl:with-param name="numDims" select="1"/>
						<xsl:with-param name="numRows" select="$dimNodes[1]/text()"/>
						<xsl:with-param name="numCols" select="1"/>
						<xsl:with-param name="indent" select="$indent + .5"/>
						<xsl:with-param name="data" select="$data"/>
					</xsl:call-template>
				</div>

				<h2 />

			</xsl:when>
			<xsl:when test="$curDimNum = 2">

				<!-- filter out any tables of ALL 0's -->
				<xsl:if test="count($data/Item[position() &gt; $startIndex and position() &lt;= $endIndex][./text() != 0]) > 0">

				<!--
					we have evaluated all but 2 dimensions.  these dimensions will
					be used as row and column dimensions in the table.  use
					recursively constructed label describing the dimensional
					position of this particular table.
				-->
				<xsl:variable name="tableLabel" select="concat('( , ', $label, ')')"/>
				<div>
					<b><xsl:call-template name="ArrayGetTableTitle">
						<xsl:with-param name="tableNum" select="$tableNum"/>
						<xsl:with-param name="numOtherDim" select="count($dimNameNodes) - 2" />
						<xsl:with-param name="levelDims" select="$dimNameNodes[position() &gt; 2]/Items" />
						<xsl:with-param name="dimensionColumnNames" select="$dimensionColumnNames" />
						<xsl:with-param name="ignoreFirstNDims" select="2"/>
					</xsl:call-template></b>

					<xsl:call-template name="CreateArrayTable">
						<xsl:with-param name="dimNodes" select="$dimNodes"/>
						<xsl:with-param name="dimNameNodes" select="$dimNameNodes"/>
						<xsl:with-param name="dimensionColumnNames" select="$dimensionColumnNames"/>
						<xsl:with-param name="zeroBasedTableNum" select="$tableNum"/>
						<xsl:with-param name="numDims" select="$numDims"/>
						<xsl:with-param name="numRows" select="$dimNodes[1]/text()"/>
						<xsl:with-param name="numCols" select="$dimNodes[2]/text()"/>
						<xsl:with-param name="indent" select="$indent + .5"/>
						<xsl:with-param name="data" select="$data"/>
						<xsl:with-param name="maxColumnsPerTable" select="$maxColumnsPerTable" />
					</xsl:call-template>
				</div>

				</xsl:if>

			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="newLabel">
					<xsl:choose>
						<xsl:when test="boolean($dimNameNodes and $dimNameNodes[$curDimNum]/Items/Item[$curDimVal])">
							<xsl:value-of select="concat(', ', $dimNameNodes[$curDimNum]/Items/Item[$curDimVal],'[', $dimensionColumnNames/Items/Item[$curDimNum], ']', $label)"/>
						</xsl:when>
						<xsl:otherwise><xsl:value-of select="concat(', ', $curDimVal, '[', $dimensionColumnNames/Items/Item[$curDimNum], ']', $label)"/></xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<!--
					still need to evaluate another level of dimensions.  we started looking
					at the final dimension, so, the next level is evaluated by subtracting
					1 from the $curDimNum.
				-->
				<xsl:call-template name="CreateArrayTables">
					<xsl:with-param name="dimNodes" select="$dimNodes"/>
					<xsl:with-param name="dimNameNodes" select="$dimNameNodes"/>
					<xsl:with-param name="dimensionColumnNames" select="$dimensionColumnNames"/>
					<xsl:with-param name="numDims" select="$numDims"/>
					<xsl:with-param name="curDimNum" select="$curDimNum - 1"/>
					<xsl:with-param name="curDimMax" select="$dimNodes[$curDimNum - 1]/text()"/>
					<xsl:with-param name="label" select="$newLabel"/>
					<xsl:with-param name="numTables" select="$numTables"/>
					<xsl:with-param name="tableNum" select="$tableNum + (($curDimVal - 1)*(floor($numTables div ($tableDividor * $curDimMax))))"/>
					<xsl:with-param name="tableDividor" select="$tableDividor * $curDimMax"/>
					<xsl:with-param name="data" select="$data"/>
					<xsl:with-param name="indent" select="$indent"/>
					<xsl:with-param name="maxColumnsPerTable" select="$maxColumnsPerTable" />
				</xsl:call-template>
				<xsl:if test="$curDimVal &lt; $curDimMax">
					<!--
						need to evaluate this dimension's peers.  to do so, add one to
						$curDimVal.  this allows us to display 2,3...n within a dimension.
					-->
					<xsl:call-template name="CreateArrayTables">
						<xsl:with-param name="dimNodes" select="$dimNodes"/>
						<xsl:with-param name="dimNameNodes" select="$dimNameNodes"/>
						<xsl:with-param name="dimensionColumnNames" select="$dimensionColumnNames"/>
						<xsl:with-param name="numDims" select="$numDims"/>
						<xsl:with-param name="curDimNum" select="$curDimNum"/>
						<xsl:with-param name="curDimMax" select="$curDimMax"/>
						<xsl:with-param name="curDimVal" select="$curDimVal + 1"/>
						<xsl:with-param name="label" select="$label"/>
						<xsl:with-param name="numTables" select="$numTables"/>
						<xsl:with-param name="tableNum" select="$tableNum"/>
						<xsl:with-param name="tableDividor" select="$tableDividor"/>
						<xsl:with-param name="data" select="$data"/>
						<xsl:with-param name="indent" select="$indent"/>
						<xsl:with-param name="maxColumnsPerTable" select="$maxColumnsPerTable" />
					</xsl:call-template>
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- CREATE ACTUAL TABLE -->
	<xsl:template name="CreateArrayTable">
		<xsl:param name="dimNodes" select="''"/>
		<xsl:param name="dimNameNodes" select="''"/>
		<xsl:param name="dimensionColumnNames" select="''" />
		<xsl:param name="zeroBasedTableNum" select="0"/>
		<xsl:param name="numDims" select="0"/>
		<xsl:param name="curDim" select="3"/>
		<xsl:param name="dividor" select="1"/>
		<xsl:param name="numRows" select="0"/>
		<xsl:param name="numCols" select="0"/>
		<xsl:param name="startPos" select="0"/>
		<xsl:param name="indent" select="0"/>
		<xsl:param name="data" select="''"/>
		<xsl:param name="maxColumnsPerTable" select="''" />
		<xsl:param name="startLevel" select="1" />

		<xsl:variable name="tableSize" select="($numRows * $numCols)"/>
		<xsl:variable name="startIndex" select="($zeroBasedTableNum* $tableSize)"/>
		<xsl:variable name="endIndex" select="$startIndex + $tableSize"/>

		<xsl:variable name="allColumns" select="$data/Item[position() &lt;= $numCols]" />
		<xsl:variable name="numColumns" select="count($allColumns)" />
		<xsl:variable name="endLevel">
			<xsl:choose>
				<xsl:when test="$maxColumnsPerTable &gt; 0"><xsl:value-of select="$startLevel + $maxColumnsPerTable" /></xsl:when>
				<xsl:otherwise><xsl:value-of select="$numColumns + 1" /></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="limitedColumns" select="$allColumns[position() &gt;= $startLevel and position() &lt; $endLevel]" />

		<table border="0" cellspacing="0" cellpadding="3">
			<tr>
				<td bgcolor="{$g_tableBG}" >
					<table cellspacing="1" cellpadding="5" border="0" width="100%">
						  <tr>
						  	<th bgcolor="{$g_tableBG}"></th>
						  	<th bgcolor="{$g_tableBG}"></th>
						  	<xsl:element name="th">
						  		<xsl:attribute name="bgcolor"><xsl:value-of select="$g_headerBG" /></xsl:attribute>
						  		<xsl:attribute name="colspan"><xsl:value-of select="count($limitedColumns)"/></xsl:attribute>
						  		<font xsl:use-attribute-sets="column-header"><xsl:value-of select="$dimensionColumnNames/Items/Item[2]"/></font>
						  	</xsl:element>
						</tr>
						  <tr>
						  	<th bgcolor="{$g_tableBG}"></th>
						  	<th bgcolor="{$g_tableBG}"></th>
							<xsl:for-each select="$limitedColumns">
								<xsl:variable name="colPos" select="position() + $startLevel - 1" />
								<th bgcolor="{$g_headerBG}"><font xsl:use-attribute-sets="column-header">
									<xsl:choose>
										<xsl:when test="boolean($dimNameNodes)"><xsl:value-of select="$dimNameNodes[2]/Items/Item[$colPos]/text()"/></xsl:when>
										<xsl:otherwise><xsl:value-of select="$colPos"/></xsl:otherwise>
									</xsl:choose>
								</font></th>
							</xsl:for-each>
						</tr>

						<xsl:for-each select="$data/Item[position() &lt;= $numRows]">
							<xsl:variable name="rowStartPos" select="((position()-1) * $numCols) + $startIndex"/>
							<xsl:variable name="rowEndPos" select="$rowStartPos + $numCols"/>
							<xsl:variable name="rowData" select="$data/Item[position() &gt; $startIndex and position() &lt;= $endIndex]"/>
							<xsl:variable name="rowPosition" select="position() - 1"/>

							<xsl:element name="tr">
								<xsl:attribute name="bgcolor">
									<xsl:choose>
										<xsl:when test="$rowPosition mod 2 = 0"><xsl:value-of select="$g_rowBG_2" /></xsl:when>
										<xsl:otherwise><xsl:value-of select="$g_rowBG_1" /></xsl:otherwise>
									</xsl:choose>
								</xsl:attribute>

								<xsl:if test="$rowPosition = 0">
								  	<xsl:element name="th">
								  		<xsl:attribute name="bgcolor"><xsl:value-of select="$g_headerBG" /></xsl:attribute>
								  		<xsl:attribute name="rowspan"><xsl:value-of select="count($data/Item[position() &lt;= $numRows])"/></xsl:attribute>
								  		<font xsl:use-attribute-sets="row-header"><xsl:value-of select="$dimensionColumnNames/Items/Item[1]"/></font>
								  	</xsl:element>
								</xsl:if>

								<!-- create row labels -->
								<xsl:variable name="rowPos" select="position()" />
								<th bgcolor="{$g_headerBG}"><font xsl:use-attribute-sets="row-header">
									<xsl:choose>
											<xsl:when test="boolean($dimNameNodes)"><xsl:value-of select="$dimNameNodes[1]/Items/Item[$rowPos]/text()"/></xsl:when>
											<xsl:otherwise><xsl:value-of select="$rowPos"/></xsl:otherwise>
									</xsl:choose>
								</font></th>

								<!-- display actual data in row-major depite being stored in column-major-->
								<xsl:for-each select="$rowData[(position() - 1) mod $numRows = $rowPosition]">
									<xsl:variable name="columnNumber" select="position()" />
									<xsl:if test="$columnNumber &gt;= $startLevel and $columnNumber &lt; $endLevel">
										<font xsl:use-attribute-sets="table-content">
											<td align="right"><xsl:value-of select="./text()"/></td>
										</font>
									</xsl:if>
								</xsl:for-each>
							</xsl:element>
						</xsl:for-each>
					</table>
				</td>
			</tr>
		</table>

		<h2 />

		<xsl:if test="$maxColumnsPerTable &gt; 0 and $endLevel &lt;= $numColumns">
			<xsl:call-template name="CreateArrayTable">
				<xsl:with-param name="dimNodes" select="$dimNodes"/>
				<xsl:with-param name="dimNameNodes" select="$dimNameNodes"/>
				<xsl:with-param name="dimensionColumnNames" select="$dimensionColumnNames"/>
				<xsl:with-param name="zeroBasedTableNum" select="$zeroBasedTableNum"/>
				<xsl:with-param name="numDims" select="$numDims"/>
				<xsl:with-param name="numRows" select="$numRows"/>
				<xsl:with-param name="numCols" select="$numCols"/>
				<xsl:with-param name="indent" select="$indent"/>
				<xsl:with-param name="data" select="$data"/>
				<xsl:with-param name="maxColumnsPerTable" select="$maxColumnsPerTable" />
				<xsl:with-param name="startLevel" select="$endLevel" />
			</xsl:call-template>
		</xsl:if>

	</xsl:template>

	<!-- CREATE ACTUAL ONE DIMENSIONAL TABLE -->
	<xsl:template name="Create1DArrayTable">
		<xsl:param name="dimNodes" select="''"/>
		<xsl:param name="dimNameNodes" select="''"/>
		<xsl:param name="dimensionColumnNames" select="''" />
		<xsl:param name="zeroBasedTableNum" select="0"/>
		<xsl:param name="numDims" select="0"/>
		<xsl:param name="curDim" select="3"/>
		<xsl:param name="dividor" select="1"/>
		<xsl:param name="numRows" select="0"/>
		<xsl:param name="numCols" select="0"/>
		<xsl:param name="startPos" select="0"/>
		<xsl:param name="indent" select="0"/>
		<xsl:param name="data" select="''"/>

		<xsl:variable name="tableSize" select="($numRows * $numCols)"/>
		<xsl:variable name="startIndex" select="($zeroBasedTableNum* $tableSize)"/>
		<xsl:variable name="endIndex" select="$startIndex + $tableSize"/>

		<table border="0" cellspacing="0" cellpadding="3">
			<tr>
				<td bgcolor="{$g_tableBG}" >
					<table cellspacing="1" cellpadding="5" border="0" width="100%">
						  <tr>
						  	<th bgcolor="{$g_tableBG}"></th>
						  	<th bgcolor="{$g_tableBG}"></th>
							<th bgcolor="{$g_headerBG}"><font xsl:use-attribute-sets="column-header">Value</font></th>
						</tr>
						<xsl:for-each select="$data/Item">
							<xsl:variable name="rowPosition" select="position() - 1"/>

							<xsl:element name="tr">
								<xsl:attribute name="bgcolor">
									<xsl:choose>
										<xsl:when test="$rowPosition mod 2 = 0"><xsl:value-of select="$g_rowBG_2" /></xsl:when>
										<xsl:otherwise><xsl:value-of select="$g_rowBG_1" /></xsl:otherwise>
									</xsl:choose>
								</xsl:attribute>

								<!-- create dimension label -->
								<xsl:if test="$rowPosition = 0">
								  	<xsl:element name="th">
								  		<xsl:attribute name="bgcolor"><xsl:value-of select="$g_headerBG" /></xsl:attribute>
								  		<xsl:attribute name="rowspan"><xsl:value-of select="count($data/Item)"/></xsl:attribute>
								  		<font xsl:use-attribute-sets="row-header"><xsl:value-of select="$dimensionColumnNames/Items/Item[1]"/></font>
								  	</xsl:element>
								</xsl:if>


								<!-- create row labels -->
								<th bgcolor="{$g_headerBG}"><font xsl:use-attribute-sets="row-header">
									<xsl:choose>
										<xsl:when test="boolean($dimNameNodes)"><xsl:value-of select="$dimNameNodes[1]/Items/Item[$rowPosition+1]/text()"/></xsl:when>
										<xsl:otherwise><xsl:value-of select="$rowPosition+1"/></xsl:otherwise>
									</xsl:choose>
								</font></th>

								<!-- display actual data in row-major depite being stored in column-major-->
								<td align="right"><font xsl:use-attribute-sets="table-content"><xsl:value-of select="./text()"/></font></td>
							</xsl:element>
						</xsl:for-each>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>

	<!-- RETURN STRING WIDTH w/ MIN SETTING -->
	<xsl:template name="GetWidth">
		<xsl:param name="string" select="''"/>
		<xsl:param name="minWidth" select="50"/>

		<xsl:variable name="length" select="string-length($string) * 7"/>

		<xsl:choose>
			<xsl:when test="$length &lt; $minWidth">	<xsl:value-of select="$minWidth"/></xsl:when>
			<xsl:otherwise>	<xsl:value-of select="$length"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- EVALUATE MAX WIDTH IN AN ITEM LIST -->
	<xsl:template name="ItemTextWidth">
		<xsl:param name="element" select="''"/>
		<xsl:param name="CurrentNum" select="1"/>
		<xsl:param name="TotalNum" select="0"/>
		<xsl:param name="minWidth" select="50"/>
		<xsl:param name="maxWidth" select="0"/>

		<xsl:variable name="this" select="$element/Item[$CurrentNum]/text()"/>
		<xsl:variable name="thisWidth" select="string-length($this) * 8"/>

		<xsl:choose>
			<xsl:when test="$TotalNum &lt;= $CurrentNum">
				<!-- final case....return actual max -->
				<xsl:choose>
					<xsl:when test="$thisWidth &gt; $maxWidth">
						<xsl:choose>
							<xsl:when test="$minWidth &gt; $thisWidth"><xsl:value-of select="$minWidth"/></xsl:when>
							<xsl:otherwise>	<xsl:value-of select="$thisWidth"/></xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="$minWidth &gt; $maxWidth">	<xsl:value-of select="$minWidth"/>	</xsl:when>
							<xsl:otherwise>	<xsl:value-of select="$maxWidth"/></xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<!--iterate further -->
				<xsl:choose>
					<xsl:when test="$thisWidth &gt; $maxWidth">
						<xsl:call-template name="ItemTextWidth">
							<xsl:with-param name="element" select="$element"/>
							<xsl:with-param name="CurrentNum" select="$CurrentNum + 1"/>
							<xsl:with-param name="TotalNum" select="$TotalNum"/>
							<xsl:with-param name="maxWidth" select="$thisWidth"/>
							<xsl:with-param name="minWidth" select="$minWidth"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="ItemTextWidth">
							<xsl:with-param name="element" select="$element"/>
							<xsl:with-param name="CurrentNum" select="$CurrentNum + 1"/>
							<xsl:with-param name="TotalNum" select="$TotalNum"/>
							<xsl:with-param name="maxWidth" select="$maxWidth"/>
							<xsl:with-param name="minWidth" select="$minWidth"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- EVALUATE MAX TEXT VAL IN NODESET -->
	<xsl:template name="TextNodeWidth">
		<xsl:param name="element" select="''"/>
		<xsl:param name="CurrentNum" select="1"/>
		<xsl:param name="TotalNum" select="0"/>
		<xsl:param name="minWidth" select="50"/>
		<xsl:param name="maxWidth" select="0"/>
		<xsl:param name="numCols" select="0"/>
		<xsl:param name="colNum" select="0"/>

		<xsl:variable name="this" select="$element[$CurrentNum]/text()"/>
		<xsl:variable name="thisWidth" select="string-length($this) * 8"/>

		<xsl:choose>
			<xsl:when test="$TotalNum = $CurrentNum">
				<!-- return final max value  -->
				<xsl:choose>
					<xsl:when test="$thisWidth &gt; $maxWidth">
						<xsl:choose>
							<xsl:when test="$minWidth &gt; $thisWidth">	<xsl:value-of select="$minWidth"/>	</xsl:when>
							<xsl:otherwise>	<xsl:value-of select="$thisWidth"/></xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="$minWidth &gt; $maxWidth">	<xsl:value-of select="$minWidth"/>	</xsl:when>
							<xsl:otherwise>	<xsl:value-of select="$maxWidth"/></xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="($CurrentNum mod $numCols) != $colNum">
				<!-- this value isn't important...iterate on without changing values -->
				<xsl:call-template name="TextNodeWidth">
					<xsl:with-param name="element" select="$element"/>
					<xsl:with-param name="CurrentNum" select="$CurrentNum + 1"/>
					<xsl:with-param name="TotalNum" select="$TotalNum"/>
					<xsl:with-param name="maxWidth" select="$maxWidth"/>
					<xsl:with-param name="minWidth" select="$minWidth"/>
					<xsl:with-param name="numCols" select="$numCols"/>
					<xsl:with-param name="colNum" select="$colNum"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<!--iterate further...change max as needed -->
				<xsl:choose>
					<xsl:when test="$thisWidth &gt; $maxWidth">
						<xsl:call-template name="TextNodeWidth">
							<xsl:with-param name="element" select="$element"/>
							<xsl:with-param name="CurrentNum" select="$CurrentNum + 1"/>
							<xsl:with-param name="TotalNum" select="$TotalNum"/>
							<xsl:with-param name="maxWidth" select="$thisWidth"/>
							<xsl:with-param name="minWidth" select="$minWidth"/>
							<xsl:with-param name="numCols" select="$numCols"/>
							<xsl:with-param name="colNum" select="$colNum"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="TextNodeWidth">
							<xsl:with-param name="element" select="$element"/>
							<xsl:with-param name="CurrentNum" select="$CurrentNum + 1"/>
							<xsl:with-param name="TotalNum" select="$TotalNum"/>
							<xsl:with-param name="maxWidth" select="$maxWidth"/>
							<xsl:with-param name="minWidth" select="$minWidth"/>
							<xsl:with-param name="numCols" select="$numCols"/>
							<xsl:with-param name="colNum" select="$colNum"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="roundNumber">
		<xsl:param name="string" select="''"/>
		<xsl:param name="decimalPattern"><xsl:value-of select="$g_defaultPattern"/></xsl:param>
		<xsl:param name="scientificPattern"><xsl:value-of select="$g_defaultScientific"/></xsl:param>

		<xsl:variable name="lowerCasePattern" select="'e'"/>
		<xsl:variable name="upperCasePattern" select="'E'"/>

		<xsl:choose>
			<xsl:when test="contains($string, $lowerCasePattern)">
				<xsl:call-template name="outputRoundedScientific">
					<xsl:with-param name="valueString" select="substring-before($string, $lowerCasePattern)"/>
					<xsl:with-param name="exponentString" select="substring-after($string, $lowerCasePattern)"/>
					<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="contains($string, $upperCasePattern)">
				<xsl:call-template name="outputRoundedScientific">
					<xsl:with-param name="valueString" select="substring-before($string, $upperCasePattern)"/>
					<xsl:with-param name="exponentString" select="substring-after($string, $upperCasePattern)"/>
					<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="format-number($string, $decimalPattern) != format-number(0, $decimalPattern)">
						<xsl:value-of select="format-number($string, $decimalPattern)"/>
					</xsl:when>
					<xsl:when test="$string = 0">
						<xsl:value-of select="format-number($string, $decimalPattern)"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="format-number($string, $scientificPattern)"/>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:text>  </xsl:text>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="outputRoundedScientific">
		<xsl:param name="valueString" select="''"/>
		<xsl:param name="exponentString" select="''"/>
		<xsl:param name="decimalPattern"><xsl:value-of select="$g_defaultPattern"/></xsl:param>

		<xsl:value-of select="format-number($valueString, $decimalPattern)"/>E<xsl:value-of select="format-number($exponentString, '#0')"/>
	</xsl:template>
</xsl:stylesheet>
