<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<!--define the color types used by the tables -->
	<xsl:variable name="g_tableBG" select="'#82C0FF'" />
	<xsl:variable name="g_headerBG" select="'#CCE6FF'" />
	<xsl:variable name="g_rowBG_1" select="'#EEEEEE'" />
	<xsl:variable name="g_rowBG_2" select="'#FFFFFF'" />
	<!--define the default rounding patterns -->
	<xsl:variable name="g_defaultPattern" select="'#,##0.00'" />
	<xsl:variable name="g_defaultScientific" select="'0.00E0'" />

	<xsl:attribute-set name="title">
		<xsl:attribute name="color">#000000</xsl:attribute>
		<xsl:attribute name="size">6</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="subtitle">
		<xsl:attribute name="color">#000000</xsl:attribute>
		<xsl:attribute name="size">5</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="table-content">
		<xsl:attribute name="color">#000000</xsl:attribute>
		<xsl:attribute name="size">3</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="row-header">
		<xsl:attribute name="color">#000000</xsl:attribute>
		<xsl:attribute name="size">3</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="column-header">
		<xsl:attribute name="color">#000000</xsl:attribute>
		<xsl:attribute name="size">3</xsl:attribute>
	</xsl:attribute-set>

	<xsl:template match="S-PLUS">
		<html>
			<title><xsl:value-of select="DisplayOptions/@title"/></title>

			<body>
				<h2><font xsl:use-attribute-sets="title"><xsl:value-of select="DisplayOptions/@title"/></font></h2>

				<xsl:call-template name="SPLUSObjects">
					<xsl:with-param name="element" select="."/>
					<xsl:with-param name="decimalPattern" select="./DisplayOptions/@decimalPattern"/>
					<xsl:with-param name="scientificPattern" select="./DisplayOptions/@scientificPattern"/>
				</xsl:call-template>
			</body>
		</html>
	</xsl:template>

<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<!--	HANDLE ALL SPLUS OBJECTS HERE -->
<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
	<xsl:template name="SPLUSObjects">
		<xsl:param name="element" select="''"/>
		<xsl:param name="indent" select="0"/>
		<xsl:param name="decimalPattern" select="''"/>
		<xsl:param name="scientificPattern" select="''"/>

		<xsl:for-each select="$element/*">
			<xsl:choose>
				<!-- if this is a part of a list, we need to display the list position -->
				<xsl:when test="name($element) = 'Components'">
					<h2><font xsl:use-attribute-sets="subtitle">
						<xsl:text>Item </xsl:text>	<xsl:value-of select="position()"/>
					</font></h2>
					<xsl:call-template name="SPLUSObject">
						<xsl:with-param name="element" select="./*[1]"/>
						<xsl:with-param name="indent" select="$indent"/>
						<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
						<xsl:with-param name="scientificPattern" select="$scientificPattern"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="SPLUSObject">
						<xsl:with-param name="element" select="."/>
						<xsl:with-param name="indent" select="$indent"/>
						<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
						<xsl:with-param name="scientificPattern" select="$scientificPattern"/>
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>
	</xsl:template>

<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<!--	HANDLE EACH SPLUS OBJECTS HERE -->
<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
	<xsl:template name="SPLUSObject">
		<xsl:param name="element" select="''"/>
		<xsl:param name="indent" select="0"/>
		<xsl:param name="decimalPattern" select="''"/>
		<xsl:param name="scientificPattern" select="''"/>


		<xsl:variable name="elementName" select="name($element)"/>

		<!-- handle all SPLUS objects with appropriate functions -->
		<div>
			<xsl:choose>
				<xsl:when test="$elementName = 'DataFrame'">
					<xsl:call-template name="DataFrame">
						<xsl:with-param name="element" select="$element"/>
						<xsl:with-param name="title" select="'Data Frame'"/>
						<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
						<xsl:with-param name="scientificPattern" select="$scientificPattern"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$elementName = 'Matrix'">
					<xsl:call-template name="DataFrame">
						<xsl:with-param name="element" select="$element"/>
						<xsl:with-param name="title" select="'Matrix'"/>
						<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
						<xsl:with-param name="scientificPattern" select="$scientificPattern"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$elementName = 'List'">
					<xsl:call-template name="List">
						<xsl:with-param name="element" select="$element"/>
						<xsl:with-param name="indent" select="$indent"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$elementName = 'Vector'">
					<xsl:call-template name="Vector">
						<xsl:with-param name="element" select="$element"/>
						<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
						<xsl:with-param name="scientificPattern" select="$scientificPattern"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$elementName = 'MultiDimensionalArray'">
					<xsl:call-template name="MultiDimensionalArray">
						<xsl:with-param name="element" select="$element"/>
						<xsl:with-param name="indent" select="$indent"/>
						<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
						<xsl:with-param name="scientificPattern" select="$scientificPattern"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$elementName = 'NameObject'">
					<xsl:call-template name="LanguageObject">
						<xsl:with-param name="element" select="$element"/>
						<xsl:with-param name="indent" select="$indent"/>
						<xsl:with-param name="name" select="'Name'"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$elementName = 'ExpressionObject'">
					<xsl:call-template name="LanguageObject">
						<xsl:with-param name="element" select="$element"/>
						<xsl:with-param name="indent" select="$indent"/>
						<xsl:with-param name="name" select="'Expression'"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$elementName = 'CallObject'">
					<xsl:call-template name="LanguageObject">
						<xsl:with-param name="element" select="$element"/>
						<xsl:with-param name="indent" select="$indent"/>
						<xsl:with-param name="name" select="'Call'"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$elementName = 'Function'">
					<xsl:call-template name="LanguageObject">
						<xsl:with-param name="element" select="$element"/>
						<xsl:with-param name="indent" select="$indent"/>
						<xsl:with-param name="name" select="'Function'"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$elementName = 'Null'">
					<div><h2><font xsl:use-attribute-sets="title">Null</font></h2></div>
					<h3> </h3>
				</xsl:when>
			</xsl:choose>
		</div>
	</xsl:template>

<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<!--	HANDLE LANGUAGE OBJECTS HERE -->
<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
	<xsl:template name="LanguageObject">
		<xsl:param name="element" select="''"/>
		<xsl:param name="indent" select="0"/>
		<xsl:param name="name" select="0"/>

		<div>
			<h2><font xsl:use-attribute-sets="title"><xsl:value-of select="$name"/></font></h2>
			<blockquote><pre><code><xsl:value-of select="$element/text()"/></code></pre></blockquote>
		</div>

		<h3> </h3>
	</xsl:template>

<!-- ~~~~~~~~~~~~~~~~~~~~~~~~ -->
<!--	HANDLE LIST OBJECTS HERE -->
<!-- ~~~~~~~~~~~~~~~~~~~~~~~~ -->
	<xsl:template name="List">
		<xsl:param name="element" select="''"/>
		<xsl:param name="indent" select="0"/>

		<div>
			<h2><font xsl:use-attribute-sets="title">List</font></h2>
			<xsl:call-template name="SPLUSObjects">
				<xsl:with-param name="element" select="$element/Components"/>
<!--
				<xsl:with-param name="indent" select="$indent + .5" />
-->
			</xsl:call-template>
		</div>

		<h3> </h3>

	</xsl:template>

<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<!--	HANDLE VECTOR OBJECTS HERE -->
<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
	<xsl:template name="Vector">
		<xsl:param name="element" select="''"/>
		<xsl:param name="decimalPattern" select="''"/>
		<xsl:param name="scientificPattern" select="''"/>


		<div>
			<h2><font xsl:use-attribute-sets="title">Vector</font></h2>
			<div>
				<table cellSpacing="0" cellPadding="3" border="0">
					<tbody>
						<tr>
							<td bgcolor="{$g_tableBG}">
								<table cellSpacing="1" cellPadding="5" border="0">
									<th bgcolor="{$g_headerBG}"><font xsl:use-attribute-sets="column-header"><xsl:text> Index </xsl:text></font></th>
									<th bgcolor="{$g_headerBG}"><font xsl:use-attribute-sets="column-header"><xsl:text> Value </xsl:text></font></th>

									<xsl:for-each select="$element/Items/Item">
										<xsl:element name="tr">
											<xsl:attribute name="bgcolor">
												<xsl:choose>
													<xsl:when test="position() mod 2 = 0"><xsl:value-of select="$g_rowBG_1"/></xsl:when>
													<xsl:otherwise><xsl:value-of select="$g_rowBG_2"/></xsl:otherwise>
												</xsl:choose>
											</xsl:attribute>

											<td align="right" bgcolor="{$g_headerBG}"><font xsl:use-attribute-sets="row-header"><xsl:value-of select="position()"/></font></td>
											<td align="right"><font xsl:use-attribute-sets="table-content">
												<xsl:choose>
													<xsl:when test="$element/@type = 'numeric'">
														<xsl:call-template name="roundNumber">
															<xsl:with-param name="string" select="./text()"/>
															<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
															<xsl:with-param name="scientificPattern" select="$scientificPattern"/>
														</xsl:call-template>
													</xsl:when>
													<xsl:otherwise><xsl:value-of select="./text()"/></xsl:otherwise>
												</xsl:choose>
											</font></td>
										</xsl:element>
									</xsl:for-each>
								</table>
							</td>
						</tr>
					</tbody>
				</table>
			</div>
		</div>

		<h3></h3>

	</xsl:template>

<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<!--	HANDLE DATAFRAME OR MATRIX OBJECTS HERE -->
<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
	<xsl:template name="DataFrame">
		<xsl:param name="element" select="''"/>
		<xsl:param name="title" select="''"/>
		<xsl:param name="decimalPattern" select="''"/>
		<xsl:param name="scientificPattern" select="''"/>


		<div>
			<!-- display title -->
			<h2><font xsl:use-attribute-sets="title"><xsl:value-of select="$title"/></font></h2>
			<!-- display dimensions: row and column count -->
			<h2><font xsl:use-attribute-sets="subtitle">
				<b>Number of Rows: </b>
				<xsl:text> </xsl:text><xsl:value-of select="$element/@numRows"/>
			</font></h2>
			<h2><font xsl:use-attribute-sets="subtitle">
				<b>Number of Columns: </b>
				<xsl:text> </xsl:text><xsl:value-of select="$element/@numCols"/>
			</font></h2>

			<!-- create table for display of data frame or of matrix -->
			<table border="0" cellspacing="0" cellpadding="3">
				<tr>
					<td bgcolor="{$g_tableBG}" >
						<table cellspacing="1" cellpadding="5" border="0" width="100%">
							<tr>
							  	<th bgcolor="{$g_tableBG}"></th>
							  	<xsl:element name="th">
							  		<xsl:attribute name="bgcolor"><xsl:value-of select="$g_headerBG"/></xsl:attribute>
							  		<xsl:attribute name="colspan"><xsl:value-of select="count($element/Columns/Column)"/></xsl:attribute>
							  		<font xsl:use-attribute-sets="column-header">Columns</font>
							  	</xsl:element>
							  </tr>
							  <tr>
							  	<th bgcolor="{$g_tableBG}"></th>
								<xsl:for-each select="$element/Columns/Column">
									<xsl:variable name="position" select="position()"/>
									<th bgcolor="{$g_headerBG}"><font xsl:use-attribute-sets="column-header">
										<xsl:choose>
											<xsl:when test="@name"><xsl:value-of select="@name"/></xsl:when>
											<xsl:otherwise><xsl:value-of select="$position"/></xsl:otherwise>
										</xsl:choose>
									</font></th>
								</xsl:for-each>
							</tr>

							<xsl:for-each select="$element/Columns/Column[1]/Items/Item">
								<xsl:element name="tr">
									<xsl:variable name="position" select="position()"/>

									<xsl:attribute name="bgcolor">
										<xsl:choose>
											<xsl:when test="position() mod 2 = 0"><xsl:value-of select="$g_rowBG_1"/></xsl:when>
											<xsl:otherwise><xsl:value-of select="$g_rowBG_2"/></xsl:otherwise>
										</xsl:choose>
									</xsl:attribute>

									<!-- first item is row header that contains row name -->
									<th bgcolor="{$g_headerBG}"><font xsl:use-attribute-sets="row-header">
										<xsl:choose>
											<xsl:when test="$element/RowNames"><xsl:value-of select="$element/RowNames/Items/Item[$position]/text()"/></xsl:when>
											<xsl:otherwise><xsl:value-of select="$position"/></xsl:otherwise>
										</xsl:choose> 
									</font></th>
									<!-- add actual data...watch for factors and missng values -->
									<xsl:for-each select="$element/Columns/Column">
										<xsl:variable name="colType" select="./@type"/>
										<xsl:variable name="value" select="./Items/Item[$position]/text()"/>
										<xsl:variable name="innerElement" select="."/>
										<xsl:variable name="levels" select="$innerElement/Attrs/Attr[@name = '.Label']" />

										<td align="right"><font xsl:use-attribute-sets="table-content"><xsl:choose>
											<!-- character value -->
											<xsl:when test="$colType= 'character'"><xsl:value-of select="$value"/></xsl:when>
											<xsl:when test="$colType = 'factor' or $colType = 'ordered'"><xsl:value-of select="$levels/Vector/Items/Item[position() = $value]/text()"/></xsl:when>
											<!-- non-factor value -->
											<xsl:when test="count($levels) = 0">
												<xsl:call-template name="roundNumber">
													<xsl:with-param name="string" select="$value"/>
													<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
													<xsl:with-param name="scientificPattern" select="$scientificPattern"/>
												</xsl:call-template>
											</xsl:when>
											<!-- missing factor -->
											<xsl:when test="$value = 'NA'"><xsl:text/></xsl:when>
										</xsl:choose></font></td>
									</xsl:for-each>
								</xsl:element>
							</xsl:for-each>
						</table>
					</td>
				</tr>
			</table>
		</div>

		<h3></h3>

	</xsl:template>

<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<!--	HANDLE MULTIDIMENSIONALARRAY OBJECTS HERE -->
<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
	<xsl:template name="MultiDimensionalArray">
		<xsl:param name="element" select="''"/>
		<xsl:param name="indent" select="0"/>
		<xsl:param name="decimalPattern" select="''"/>
		<xsl:param name="scientificPattern" select="''"/>


 		<xsl:variable name="dimensionNodes" select="$element/Attrs/Attr[@name='.Dim']/Vector/Items/Item"/>
 		<xsl:variable name="dimensionNameNodes" select="$element/Attrs/Attr[@name='.Dimnames']/List/Components/Component/Vector"/>
		<xsl:variable name="curDimNum" select="count($dimensionNodes)"/>
		<xsl:variable name="cellsPerTable" select="$dimensionNodes[1]/text() * $dimensionNodes[2]/text()"/>
		<xsl:variable name="numTables" select="floor(count($element/Vector/Items/Item) div ($cellsPerTable))"/>

		<!-- label the array -->
		<h2><font xsl:use-attribute-sets="title">Array</font></h2>
		<!-- display the dimensions -->
		<h3><font xsl:use-attribute-sets="subtitle">
			<xsl:text>Dimensions: (</xsl:text>
			<xsl:for-each select="$dimensionNodes">
				<xsl:value-of select="./text()"/>
				<xsl:if test="position() != last()"><xsl:text>,</xsl:text></xsl:if>
			</xsl:for-each>
			<xsl:text>)</xsl:text>
		</font></h3>
		<h2 />

		<!--
			call function that iterates over all possible dimension combinations
			creating a two dimensional (use the first two dimensions)
			representation of the array.  for example, a 5x4x3x2 array would
			be represented by 3*2 tables with the dimensions: 5 rows and
			4 columns.
		-->
		<xsl:call-template name="CreateArrayTables">
			<xsl:with-param name="dimNodes" select="$dimensionNodes"/>
			<xsl:with-param name="dimNameNodes" select="$dimensionNameNodes"/>
			<xsl:with-param name="numDims" select="$curDimNum"/>
			<xsl:with-param name="curDimNum" select="$curDimNum"/>
			<xsl:with-param name="curDimMax" select="$dimensionNodes[$curDimNum]/text()"/>
			<xsl:with-param name="numTables" select="$numTables"/>
			<xsl:with-param name="data" select="$element/Vector/Items"/>
			<xsl:with-param name="indent" select="$indent"/>
			<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
			<xsl:with-param name="scientificPattern" select="$scientificPattern"/>
		</xsl:call-template>
	</xsl:template>

	<!-- recursively build tables that represent array -->
	<xsl:template name="CreateArrayTables">
		<xsl:param name="dimNodes" select="''"/>
		<xsl:param name="dimNameNodes" select="''"/>
		<xsl:param name="numDims" select="'2'"/>
		<xsl:param name="curDimNum" select="'1'"/>
		<xsl:param name="curDimMax" select="'1'"/>
		<xsl:param name="curDimVal" select="1"/>
		<xsl:param name="label" select="''"/>
		<xsl:param name="numTables" select="'0'"/>
		<xsl:param name="tableNum" select="'0'"/>
		<xsl:param name="tableDividor" select="'1'"/>
		<xsl:param name="data" select="''"/>
		<xsl:param name="indent" select="''"/>
		<xsl:param name="decimalPattern" select="''"/>
		<xsl:param name="scientificPattern" select="''"/>


		<xsl:choose>
			<xsl:when test="$curDimNum = 1">
				<!--
					there's only 1 dimension in the array.
				-->
				<div>
					<xsl:call-template name="Create1DArrayTable">
						<xsl:with-param name="dimNodes" select="$dimNodes"/>
						<xsl:with-param name="dimNameNodes" select="$dimNameNodes"/>
						<xsl:with-param name="zeroBasedTableNum" select="0"/>
						<xsl:with-param name="numDims" select="1"/>
						<xsl:with-param name="numRows" select="$dimNodes[1]/text()"/>
						<xsl:with-param name="numCols" select="1"/>
						<xsl:with-param name="indent" select="$indent + .5"/>
						<xsl:with-param name="data" select="$data"/>
						<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
						<xsl:with-param name="scientificPattern" select="$scientificPattern"/>
					</xsl:call-template>
				</div>

				<h2 />

			</xsl:when>
			<xsl:when test="$curDimNum = 2">
				<!--
					we have evaluated all but 2 dimensions.  these dimensions will
					be used as row and column dimensions in the table.  use
					recursively constructed label describing the dimensional
					position of this particular table.
				-->
				<xsl:variable name="tableLabel" select="concat('( , ', $label, ')')"/>
				<div>
					<b>	<xsl:value-of select="$tableLabel"/></b>

					<xsl:call-template name="CreateArrayTable">
						<xsl:with-param name="dimNodes" select="$dimNodes"/>
						<xsl:with-param name="dimNameNodes" select="$dimNameNodes"/>
						<xsl:with-param name="zeroBasedTableNum" select="$tableNum"/>
						<xsl:with-param name="numDims" select="$numDims"/>
						<xsl:with-param name="numRows" select="$dimNodes[1]/text()"/>
						<xsl:with-param name="numCols" select="$dimNodes[2]/text()"/>
						<xsl:with-param name="indent" select="$indent + .5"/>
						<xsl:with-param name="data" select="$data"/>
						<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
						<xsl:with-param name="scientificPattern" select="$scientificPattern"/>
					</xsl:call-template>
				</div>
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="newLabel">
					<xsl:choose>
						<xsl:when test="boolean($dimNameNodes and $dimNameNodes[$curDimNum]/Items/Item[$curDimVal])"><xsl:value-of select="concat(',', $dimNameNodes[$curDimNum]/Items/Item[$curDimVal], $label)"/></xsl:when>
						<xsl:otherwise><xsl:value-of select="concat(',', $curDimVal, $label)"/></xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<!--
					still need to evaluate another level of dimensions.  we started looking
					at the final dimension, so, the next level is evaluated by subtracting
					1 from the $curDimNum.
				-->
				<xsl:call-template name="CreateArrayTables">
					<xsl:with-param name="dimNodes" select="$dimNodes"/>
					<xsl:with-param name="dimNameNodes" select="$dimNameNodes"/>
					<xsl:with-param name="numDims" select="$numDims"/>
					<xsl:with-param name="curDimNum" select="$curDimNum - 1"/>
					<xsl:with-param name="curDimMax" select="$dimNodes[$curDimNum - 1]/text()"/>
					<xsl:with-param name="label" select="$newLabel"/>
					<xsl:with-param name="numTables" select="$numTables"/>
					<xsl:with-param name="tableNum" select="$tableNum + (($curDimVal - 1)*(floor($numTables div ($tableDividor * $curDimMax))))"/>
					<xsl:with-param name="tableDividor" select="$tableDividor * $curDimMax"/>
					<xsl:with-param name="data" select="$data"/>
					<xsl:with-param name="indent" select="$indent"/>
					<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
					<xsl:with-param name="scientificPattern" select="$scientificPattern"/>
				</xsl:call-template>
				<xsl:if test="$curDimVal &lt; $curDimMax">
					<!--
						need to evaluate this dimension's peers.  to do so, add one to
						$curDimVal.  this allows us to display 2,3...n within a dimension.
					-->
					<xsl:call-template name="CreateArrayTables">
						<xsl:with-param name="dimNodes" select="$dimNodes"/>
						<xsl:with-param name="dimNameNodes" select="$dimNameNodes"/>
						<xsl:with-param name="numDims" select="$numDims"/>
						<xsl:with-param name="curDimNum" select="$curDimNum"/>
						<xsl:with-param name="curDimMax" select="$curDimMax"/>
						<xsl:with-param name="curDimVal" select="$curDimVal + 1"/>
						<xsl:with-param name="label" select="$label"/>
						<xsl:with-param name="numTables" select="$numTables"/>
						<xsl:with-param name="tableNum" select="$tableNum"/>
						<xsl:with-param name="tableDividor" select="$tableDividor"/>
						<xsl:with-param name="data" select="$data"/>
						<xsl:with-param name="indent" select="$indent"/>
						<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
						<xsl:with-param name="scientificPattern" select="$scientificPattern"/>
					</xsl:call-template>
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- CREATE ACTUAL TABLE -->
	<xsl:template name="CreateArrayTable">
		<xsl:param name="dimNodes" select="''"/>
		<xsl:param name="dimNameNodes" select="''"/>
		<xsl:param name="zeroBasedTableNum" select="0"/>
		<xsl:param name="numDims" select="0"/>
		<xsl:param name="curDim" select="3"/>
		<xsl:param name="dividor" select="1"/>
		<xsl:param name="numRows" select="0"/>
		<xsl:param name="numCols" select="0"/>
		<xsl:param name="startPos" select="0"/>
		<xsl:param name="indent" select="0"/>
		<xsl:param name="data" select="''"/>
		<xsl:param name="decimalPattern" select="''"/>
		<xsl:param name="scientificPattern" select="''"/>


		<xsl:variable name="tableSize" select="($numRows * $numCols)"/>
		<xsl:variable name="startIndex" select="($zeroBasedTableNum* $tableSize)"/>
		<xsl:variable name="endIndex" select="$startIndex + $tableSize"/>

		<table border="0" cellspacing="0" cellpadding="3">
			<tr>
				<td bgcolor="{$g_tableBG}" >
					<table cellspacing="1" cellpadding="5" border="0" width="100%">
						  <tr>
						  	<th bgcolor="{$g_tableBG}"></th>
							<xsl:for-each select="$data/Item[position() &lt;= $numCols]">
								<xsl:variable name="colPos" select="position()" />
								<th bgcolor="{$g_headerBG}"><font xsl:use-attribute-sets="column-header">
									<xsl:text>[,</xsl:text>
									<xsl:choose>
										<xsl:when test="boolean($dimNameNodes)"><xsl:value-of select="$dimNameNodes[2]/Items/Item[$colPos]/text()"/></xsl:when>
										<xsl:otherwise><xsl:value-of select="$colPos"/></xsl:otherwise>
									</xsl:choose>
									<xsl:text>]</xsl:text>
								</font></th>
							</xsl:for-each>
						</tr>

						<xsl:for-each select="$data/Item[position() &lt;= $numRows]">
							<xsl:variable name="rowStartPos" select="((position()-1) * $numCols) + $startIndex"/>
							<xsl:variable name="rowEndPos" select="$rowStartPos + $numCols"/>
							<xsl:variable name="rowData" select="$data/Item[position() &gt; $startIndex and position() &lt;= $endIndex]"/>
							<xsl:variable name="rowPosition" select="position() - 1"/>

							<xsl:element name="tr">
								<xsl:attribute name="bgcolor">
									<xsl:choose>
										<xsl:when test="$rowPosition mod 2 = 0"><xsl:value-of select="$g_rowBG_1"/></xsl:when>
										<xsl:otherwise><xsl:value-of select="$g_rowBG_2"/></xsl:otherwise>
									</xsl:choose>
								</xsl:attribute>

								<!-- create row labels -->
								<xsl:variable name="rowPos" select="position()" />
								<th bgcolor="{$g_headerBG}"><font xsl:use-attribute-sets="row-header">
									<xsl:text>[</xsl:text>
									<xsl:choose>
											<xsl:when test="boolean($dimNameNodes)"><xsl:value-of select="$dimNameNodes[1]/Items/Item[$rowPos]/text()"/></xsl:when>
											<xsl:otherwise><xsl:value-of select="$rowPos"/></xsl:otherwise>
									</xsl:choose>
									<xsl:text>,]</xsl:text>
								</font></th>

								<!-- display actual data in row-major depite being stored in column-major-->
								<xsl:for-each select="$rowData[(position() - 1) mod $numRows = $rowPosition]">
									<td align="right"><font xsl:use-attribute-sets="table-content">
										<xsl:call-template name="roundNumber">
											<xsl:with-param name="string" select="./text()"/>
											<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
											<xsl:with-param name="scientificPattern" select="$scientificPattern"/>
										</xsl:call-template>
									</font></td>
								</xsl:for-each>
							</xsl:element>
						</xsl:for-each>
					</table>
				</td>
			</tr>
		</table>

		<h2 />

	</xsl:template>

	<!-- CREATE ACTUAL ONE DIMENSIONAL TABLE -->
	<xsl:template name="Create1DArrayTable">
		<xsl:param name="dimNodes" select="''"/>
		<xsl:param name="dimNameNodes" select="''"/>
		<xsl:param name="zeroBasedTableNum" select="0"/>
		<xsl:param name="numDims" select="0"/>
		<xsl:param name="curDim" select="3"/>
		<xsl:param name="dividor" select="1"/>
		<xsl:param name="numRows" select="0"/>
		<xsl:param name="numCols" select="0"/>
		<xsl:param name="startPos" select="0"/>
		<xsl:param name="indent" select="0"/>
		<xsl:param name="data" select="''"/>
		<xsl:param name="decimalPattern" select="''"/>
		<xsl:param name="scientificPattern" select="''"/>


		<xsl:variable name="tableSize" select="($numRows * $numCols)"/>
		<xsl:variable name="startIndex" select="($zeroBasedTableNum* $tableSize)"/>
		<xsl:variable name="endIndex" select="$startIndex + $tableSize"/>

		<table border="0" cellspacing="0" cellpadding="3">
			<tr>
				<td bgcolor="{$g_tableBG}" >
					<table cellspacing="1" cellpadding="5" border="0" width="100%">
						  <tr>
						  	<th bgcolor="{$g_tableBG}"></th>
							<th bgcolor="{$g_headerBG}"><font xsl:use-attribute-sets="column-header">
								Value
							</font></th>
						</tr>
						<xsl:for-each select="$data/Item">
							<xsl:variable name="rowPosition" select="position() - 1"/>

							<xsl:element name="tr">
								<xsl:attribute name="bgcolor">
									<xsl:choose>
										<xsl:when test="$rowPosition mod 2 = 0"><xsl:value-of select="$g_rowBG_1"/></xsl:when>
										<xsl:otherwise><xsl:value-of select="$g_rowBG_2"/></xsl:otherwise>
									</xsl:choose>
								</xsl:attribute>

								<!-- create row labels -->
								<th bgcolor="{$g_headerBG}"><font xsl:use-attribute-sets="row-header">
									<xsl:text>[</xsl:text><xsl:value-of select="$rowPosition+1"/><xsl:text>]</xsl:text>
								</font></th>

								<!-- display actual data in row-major depite being stored in column-major-->
								<td align="right"><font xsl:use-attribute-sets="table-content">
									<xsl:call-template name="roundNumber">
										<xsl:with-param name="string" select="./text()"/>
										<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
										<xsl:with-param name="scientificPattern" select="$scientificPattern"/>
									</xsl:call-template>
								</font></td>
							</xsl:element>
						</xsl:for-each>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>

	<!-- RETURN STRING WIDTH w/ MIN SETTING -->
	<xsl:template name="GetWidth">
		<xsl:param name="string" select="''"/>
		<xsl:param name="minWidth" select="50"/>

		<xsl:variable name="length" select="string-length($string) * 7"/>

		<xsl:choose>
			<xsl:when test="$length &lt; $minWidth">	<xsl:value-of select="$minWidth"/></xsl:when>
			<xsl:otherwise>	<xsl:value-of select="$length"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- EVALUATE MAX WIDTH IN AN ITEM LIST -->
	<xsl:template name="ItemTextWidth">
		<xsl:param name="element" select="''"/>
		<xsl:param name="CurrentNum" select="0"/>
		<xsl:param name="TotalNum" select="0"/>
		<xsl:param name="minWidth" select="50"/>
		<xsl:param name="maxWidth" select="0"/>

		<xsl:variable name="this" select="$element/Item[$CurrentNum]/text()"/>
		<xsl:variable name="thisWidth" select="string-length($this) * 8"/>

		<xsl:choose>
			<xsl:when test="$TotalNum = $CurrentNum">
				<!-- final case....return actual max -->
				<xsl:choose>
					<xsl:when test="$thisWidth &gt; $maxWidth">
						<xsl:choose>
							<xsl:when test="$minWidth &gt; $thisWidth"><xsl:value-of select="$minWidth"/></xsl:when>
							<xsl:otherwise>	<xsl:value-of select="$thisWidth"/></xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="$minWidth &gt; $maxWidth">	<xsl:value-of select="$minWidth"/>	</xsl:when>
							<xsl:otherwise>	<xsl:value-of select="$maxWidth"/></xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<!--iterate further -->
				<xsl:choose>
					<xsl:when test="$thisWidth &gt; $maxWidth">
						<xsl:call-template name="ItemTextWidth">
							<xsl:with-param name="element" select="$element"/>
							<xsl:with-param name="CurrentNum" select="$CurrentNum + 1"/>
							<xsl:with-param name="TotalNum" select="$TotalNum"/>
							<xsl:with-param name="maxWidth" select="$thisWidth"/>
							<xsl:with-param name="minWidth" select="$minWidth"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="ItemTextWidth">
							<xsl:with-param name="element" select="$element"/>
							<xsl:with-param name="CurrentNum" select="$CurrentNum + 1"/>
							<xsl:with-param name="TotalNum" select="$TotalNum"/>
							<xsl:with-param name="maxWidth" select="$maxWidth"/>
							<xsl:with-param name="minWidth" select="$minWidth"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- EVALUATE MAX TEXT VAL IN NODESET -->
	<xsl:template name="TextNodeWidth">
		<xsl:param name="element" select="''"/>
		<xsl:param name="CurrentNum" select="1"/>
		<xsl:param name="TotalNum" select="0"/>
		<xsl:param name="minWidth" select="50"/>
		<xsl:param name="maxWidth" select="0"/>
		<xsl:param name="numCols" select="0"/>
		<xsl:param name="colNum" select="0"/>

		<xsl:variable name="this" select="$element[$CurrentNum]/text()"/>
		<xsl:variable name="thisWidth" select="string-length($this) * 8"/>

		<xsl:choose>
			<xsl:when test="$TotalNum = $CurrentNum">
				<!-- return final max value  -->
				<xsl:choose>
					<xsl:when test="$thisWidth &gt; $maxWidth">
						<xsl:choose>
							<xsl:when test="$minWidth &gt; $thisWidth">	<xsl:value-of select="$minWidth"/>	</xsl:when>
							<xsl:otherwise>	<xsl:value-of select="$thisWidth"/></xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="$minWidth &gt; $maxWidth">	<xsl:value-of select="$minWidth"/>	</xsl:when>
							<xsl:otherwise>	<xsl:value-of select="$maxWidth"/></xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="($CurrentNum mod $numCols) != $colNum">
				<!-- this value isn't important...iterate on without changing values -->
				<xsl:call-template name="TextNodeWidth">
					<xsl:with-param name="element" select="$element"/>
					<xsl:with-param name="CurrentNum" select="$CurrentNum + 1"/>
					<xsl:with-param name="TotalNum" select="$TotalNum"/>
					<xsl:with-param name="maxWidth" select="$maxWidth"/>
					<xsl:with-param name="minWidth" select="$minWidth"/>
					<xsl:with-param name="numCols" select="$numCols"/>
					<xsl:with-param name="colNum" select="$colNum"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<!--iterate further...change max as needed -->
				<xsl:choose>
					<xsl:when test="$thisWidth &gt; $maxWidth">
						<xsl:call-template name="TextNodeWidth">
							<xsl:with-param name="element" select="$element"/>
							<xsl:with-param name="CurrentNum" select="$CurrentNum + 1"/>
							<xsl:with-param name="TotalNum" select="$TotalNum"/>
							<xsl:with-param name="maxWidth" select="$thisWidth"/>
							<xsl:with-param name="minWidth" select="$minWidth"/>
							<xsl:with-param name="numCols" select="$numCols"/>
							<xsl:with-param name="colNum" select="$colNum"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="TextNodeWidth">
							<xsl:with-param name="element" select="$element"/>
							<xsl:with-param name="CurrentNum" select="$CurrentNum + 1"/>
							<xsl:with-param name="TotalNum" select="$TotalNum"/>
							<xsl:with-param name="maxWidth" select="$maxWidth"/>
							<xsl:with-param name="minWidth" select="$minWidth"/>
							<xsl:with-param name="numCols" select="$numCols"/>
							<xsl:with-param name="colNum" select="$colNum"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="roundNumber">
		<xsl:param name="string" select="''"/>
		<xsl:param name="decimalPattern" select="''"/>
		<xsl:param name="scientificPattern" select="''"/>

		<xsl:variable name="useDecPattern"><xsl:choose>
			<xsl:when test="boolean($decimalPattern)"><xsl:value-of select="$decimalPattern"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$g_defaultPattern"/></xsl:otherwise>
		</xsl:choose></xsl:variable>
		<xsl:variable name="useSciPattern"><xsl:choose>
			<xsl:when test="boolean($scientificPattern)"><xsl:value-of select="$scientificPattern"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$g_defaultScientific"/></xsl:otherwise>
		</xsl:choose></xsl:variable>

		<xsl:variable name="lowerCasePattern" select="'e'"/>
		<xsl:variable name="upperCasePattern" select="'E'"/>

		<xsl:choose>
			<xsl:when test="contains($string, $lowerCasePattern)">
				<xsl:call-template name="outputRoundedScientific">
					<xsl:with-param name="valueString" select="substring-before($string, $lowerCasePattern)"/>
					<xsl:with-param name="exponentString" select="substring-after($string, $lowerCasePattern)"/>
					<xsl:with-param name="decimalPattern" select="$useDecPattern"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="contains($string, $upperCasePattern)">
				<xsl:call-template name="outputRoundedScientific">
					<xsl:with-param name="valueString" select="substring-before($string, $upperCasePattern)"/>
					<xsl:with-param name="exponentString" select="substring-after($string, $upperCasePattern)"/>
					<xsl:with-param name="decimalPattern" select="$useDecPattern"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="format-number($string, $useDecPattern) != format-number(0, $useDecPattern)">
						<xsl:value-of select="format-number($string, $useDecPattern)"/>
					</xsl:when>
					<xsl:when test="$string = 0">
						<xsl:value-of select="format-number($string, $useDecPattern)"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="format-number($string, $useSciPattern)"/>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:text>  </xsl:text>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="outputRoundedScientific">
		<xsl:param name="valueString" select="''"/>
		<xsl:param name="exponentString" select="''"/>
		<xsl:param name="decimalPattern" select="''"/>

		<xsl:value-of select="format-number($valueString, $decimalPattern)"/>E<xsl:value-of select="format-number($exponentString, '#0')"/>
	</xsl:template>
</xsl:stylesheet>
