<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:decimal-format name="blankNaN" NaN=" "/>
	
	<!-- XSL style sheet for GeneralRegressionModel element -->
	<xsl:attribute-set name="title">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">20pt</xsl:attribute>
		<xsl:attribute name="line-height">24pt</xsl:attribute>
		<xsl:attribute name="space-after">10pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="bold-emph">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">16pt</xsl:attribute>
		<xsl:attribute name="line-height">20pt</xsl:attribute>
		<xsl:attribute name="space-after">2pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="small-cap">
		<xsl:attribute name="font-variant">small-caps</xsl:attribute>
		<xsl:attribute name="font-size">14pt</xsl:attribute>
		<xsl:attribute name="line-height">18pt</xsl:attribute>
		<xsl:attribute name="space-after">2pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="body">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="line-height">14pt</xsl:attribute>
		<xsl:attribute name="space-after">2pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="bold-body">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="line-height">14pt</xsl:attribute>
		<xsl:attribute name="space-after">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="header">
		<xsl:attribute name="text-align">right</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="border-after-color">#82C0FF</xsl:attribute>
		<xsl:attribute name="border-after-style">double</xsl:attribute>
		<xsl:attribute name="border-after-width">2pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="cell">
		<xsl:attribute name="text-align">right</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="row-header">
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="left">
		<xsl:attribute name="border-start-color">#82C0FF</xsl:attribute>
		<xsl:attribute name="border-start-style">double</xsl:attribute>
		<xsl:attribute name="border-start-width">2pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="right">
		<xsl:attribute name="border-end-color">#82C0FF</xsl:attribute>
		<xsl:attribute name="border-end-style">double</xsl:attribute>
		<xsl:attribute name="border-start-width">2pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="top">
		<xsl:attribute name="border-before-color">#82C0FF</xsl:attribute>
		<xsl:attribute name="border-before-style">double</xsl:attribute>
		<xsl:attribute name="border-before-width">2pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="bottom">
		<xsl:attribute name="border-after-color">#82C0FF</xsl:attribute>
		<xsl:attribute name="border-after-style">double</xsl:attribute>
		<xsl:attribute name="border-after-width">2pt</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="table-atts">
		<xsl:attribute name="border-before-color">#82C0FF</xsl:attribute>
		<xsl:attribute name="border-before-style">double</xsl:attribute>
		<xsl:attribute name="border-before-width">6pt</xsl:attribute>
		<xsl:attribute name="border-start-color">#82C0FF</xsl:attribute>
		<xsl:attribute name="border-start-style">double</xsl:attribute>
		<xsl:attribute name="border-start-width">3pt</xsl:attribute>
		<xsl:attribute name="border-after-color">#82C0FF</xsl:attribute>
		<xsl:attribute name="border-after-style">double</xsl:attribute>
		<xsl:attribute name="border-after-width">3pt</xsl:attribute>
		<xsl:attribute name="border-end-color">#82C0FF</xsl:attribute>
		<xsl:attribute name="border-end-style">double</xsl:attribute>
		<xsl:attribute name="border-end-width">3pt</xsl:attribute>
	</xsl:attribute-set>
	

	<xsl:template match="/">
		<fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format">
			<fo:layout-master-set>
				<fo:simple-page-master master-name="page" page-width="11in" page-height="8.5in">
					<fo:region-body region-name="body" margin-top="0.5in" margin-bottom="0.5in" margin-left="0.5in" margin-right="0.5in" />
				</fo:simple-page-master>
			</fo:layout-master-set>
			
			<fo:page-sequence master-reference="page">
				<fo:flow flow-name="body">
					<fo:block>
						<xsl:apply-templates />
					</fo:block>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	
	<xsl:template match="XML">
		<xsl:apply-templates select="IMML"/>
	</xsl:template>
	
	<xsl:template match="IMML">
		<fo:block xsl:use-attribute-sets="title"><xsl:value-of select="DisplayOptions/@title"/></fo:block>

		<xsl:apply-templates select="GeneralRegressionModel"/>
	</xsl:template>
	
	<xsl:template match="GeneralRegressionModel">
		<xsl:choose>
			<xsl:when test="@modelType='multinomialLogistic'">
				<fo:block xsl:use-attribute-sets="small-cap">
					<xsl:text>Dependent variable: </xsl:text><xsl:value-of select="@targetVariableName"/>
				</fo:block>
			</xsl:when>
			<xsl:otherwise>
				<fo:block xsl:use-attribute-sets="small-cap">
					<xsl:text>Dependent variable: </xsl:text>
					<xsl:value-of select="@targetVariableName"/>
				</fo:block>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="ParamMatrix">
		<fo:table xsl:use-attribute-sets="table-atts"  space-after="5pt" table-layout="fixed">
			<xsl:element name="fo:table-column">
				<xsl:attribute name="column-number">1</xsl:attribute>
				<xsl:attribute name="column-width">
					<xsl:call-template name="PCellParamNameWidth">
						<xsl:with-param name="element" select="." />
						<xsl:with-param name="TotalNum" select="count(./PCell)" />
					</xsl:call-template>pt
				</xsl:attribute>
			</xsl:element>
			<fo:table-column column-number="2" column-width="100pt"/>
			<fo:table-column column-number="3" column-width="100pt"/>
			<fo:table-column column-number="4" column-width="100pt"/>
			<fo:table-column column-number="5" column-width="100pt"/>
	
			<fo:table-header>
				<fo:table-row background-color="#82C0FF">
					<fo:table-cell number-columns-spanned="5" xsl:use-attribute-sets="row-header left right top bottom"><fo:block>Coefficient Estimates</fo:block></fo:table-cell>
				</fo:table-row>
				<fo:table-row background-color="#CCE6FF">
					<fo:table-cell xsl:use-attribute-sets="row-header left right top bottom"><fo:block>Variable</fo:block></fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="header left right top bottom"><fo:block>Estimate</fo:block></fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="header left right top bottom"><fo:block>Std.Err.</fo:block></fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="header left right top bottom"><fo:block>t-Statistic</fo:block></fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="header left right top bottom"><fo:block>Pr(|t|)</fo:block></fo:table-cell>
				</fo:table-row>
			</fo:table-header>
	
			<fo:table-body>
				<xsl:apply-templates select="PCell"/>
			</fo:table-body>
		</fo:table>
	</xsl:template>

	<xsl:template match="PCell">
		<xsl:variable name="decimalPattern" select="../../../DisplayOptions/@decimalPattern"/>
		<xsl:variable name="scientificPattern" select="../../../DisplayOptions/@scientificPattern"/>

		<xsl:element name="fo:table-row">
			<xsl:attribute name="background-color">
				<xsl:choose>
					<xsl:when test="position() mod 2 = 1">#FFFFFF</xsl:when>
					<xsl:otherwise>#EEEEEE</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>

			<fo:table-cell xsl:use-attribute-sets="row-header left right top bottom"><fo:block>
				<xsl:value-of select="@parameterName"/>
			</fo:block></fo:table-cell>

			<fo:table-cell xsl:use-attribute-sets="cell left right top bottom"><fo:block>
				<xsl:call-template name="roundNumber">
						<xsl:with-param name="string" select="@beta" />
						<xsl:with-param name="NaNstring" select="'NaN'" />
						<xsl:with-param name="decimalPattern" select="$decimalPattern" />
						<xsl:with-param name="scientificPattern" select="$scientificPattern" />
				</xsl:call-template>
			</fo:block></fo:table-cell>

			<fo:table-cell xsl:use-attribute-sets="cell left right top bottom"><fo:block>
				<xsl:call-template name="roundNumber">
						<xsl:with-param name="string" select="@stdErr" />
						<xsl:with-param name="NaNstring" select="'NaN'" />
						<xsl:with-param name="decimalPattern" select="$decimalPattern" />
						<xsl:with-param name="scientificPattern" select="$scientificPattern" />
				</xsl:call-template>
			</fo:block></fo:table-cell>

			<fo:table-cell xsl:use-attribute-sets="cell left right top bottom"><fo:block>
				<xsl:call-template name="roundNumber">
						<xsl:with-param name="string" select="@t" />
						<xsl:with-param name="NaNstring" select="'NaN'" />
						<xsl:with-param name="decimalPattern" select="$decimalPattern" />
						<xsl:with-param name="scientificPattern" select="$scientificPattern" />
				</xsl:call-template>
			</fo:block></fo:table-cell>

			<fo:table-cell xsl:use-attribute-sets="cell left right top bottom"><fo:block>
				<xsl:call-template name="roundNumber">
						<xsl:with-param name="string" select="@Pr" />
						<xsl:with-param name="NaNstring" select="'NaN'" />
						<xsl:with-param name="decimalPattern" select="$decimalPattern" />
						<xsl:with-param name="scientificPattern" select="$scientificPattern" />
				</xsl:call-template>
			</fo:block></fo:table-cell>
		</xsl:element>
	</xsl:template>

	<xsl:template match="CoefCorr">
		<xsl:variable name="decimalPattern" select="../../../DisplayOptions/@decimalPattern"/>
		<xsl:variable name="scientificPattern" select="../../../DisplayOptions/@scientificPattern"/>

		<fo:table xsl:use-attribute-sets="table-atts"  space-after="5pt" table-layout="fixed">
			<xsl:element name="fo:table-column">
				<xsl:attribute name="column-number">1</xsl:attribute>
				<xsl:attribute name="column-width">
					<xsl:call-template name="CorrCellCoeffWidth">
						<xsl:with-param name="element" select="." />
						<xsl:with-param name="TotalNum" select="count(./CorrCell)" />
					</xsl:call-template>pt
				</xsl:attribute>
			</xsl:element>
			<fo:table-column column-number="2" xsl:use-attribute-sets="left right" column-width="100pt"/>
	
			<fo:table-header>
				<fo:table-row background-color="#82C0FF">
					<fo:table-cell number-columns-spanned="2" xsl:use-attribute-sets="row-header left right top bottom"><fo:block>Correlated Coefficients</fo:block></fo:table-cell>
				</fo:table-row>
				<fo:table-row background-color="#CCE6FF">
					<fo:table-cell xsl:use-attribute-sets="row-header left right top bottom"><fo:block>Coefficients</fo:block></fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="header left right top bottom"><fo:block>Correlation</fo:block></fo:table-cell>
				</fo:table-row>
			</fo:table-header>
	
			<fo:table-body>
				<xsl:apply-templates select="CorrCell"/>
			</fo:table-body>
		</fo:table>

		<fo:block>
			<xsl:text>Threshold correlation: </xsl:text>
			<xsl:call-template name="roundNumber">
					<xsl:with-param name="string" select="@threshold" />
					<xsl:with-param name="NaNstring" select="'NaN'" />
					<xsl:with-param name="decimalPattern" select="$decimalPattern" />
					<xsl:with-param name="scientificPattern" select="$scientificPattern" />
			</xsl:call-template>
		</fo:block>
	</xsl:template>

	<xsl:template match="CorrCell">
		<xsl:variable name="decimalPattern" select="../../../DisplayOptions/@decimalPattern"/>
		<xsl:variable name="scientificPattern" select="../../../DisplayOptions/@scientificPattern"/>

		<xsl:element name="fo:table-row">
			<xsl:attribute name="background-color">
				<xsl:choose>
					<xsl:when test="position() mod 2 = 1">#FFFFFF</xsl:when>
					<xsl:otherwise>#EEEEEE</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>

			<fo:table-cell xsl:use-attribute-sets="row-header left right top bottom"><fo:block>
				<xsl:value-of select="@coef"/>
			</fo:block></fo:table-cell>

			<fo:table-cell xsl:use-attribute-sets="cell left right top bottom"><fo:block>
				<xsl:call-template name="roundNumber">
						<xsl:with-param name="string" select="@value" />
						<xsl:with-param name="NaNstring" select="'NaN'" />
						<xsl:with-param name="decimalPattern" select="$decimalPattern" />
						<xsl:with-param name="scientificPattern" select="$scientificPattern" />
				</xsl:call-template>
			</fo:block></fo:table-cell>
		</xsl:element>
	</xsl:template>

	<xsl:template match="GeneralRegressionModel[@modelType='multinomialLogistic']/DevMatrix">
		<fo:table xsl:use-attribute-sets="table-atts" space-after="5pt" table-layout="fixed">
			<fo:table-column column-number="1" xsl:use-attribute-sets="left right" column-width="100pt"/>
			<fo:table-column column-number="2" xsl:use-attribute-sets="left right" column-width="100pt"/>
			<fo:table-column column-number="3" xsl:use-attribute-sets="left right" column-width="100pt"/>
	
			<fo:table-header>
				<fo:table-row background-color="#82C0FF">
					<fo:table-cell number-columns-spanned="3" xsl:use-attribute-sets="row-header left right top bottom"><fo:block>Analysis of Deviance</fo:block></fo:table-cell>
				</fo:table-row>
				<fo:table-row background-color="#CCE6FF">
					<fo:table-cell xsl:use-attribute-sets="row-header left right top bottom"><fo:block>Source</fo:block></fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="header left right top bottom"><fo:block>DF</fo:block></fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="header left right top bottom"><fo:block>Deviance</fo:block></fo:table-cell>
				</fo:table-row>
			</fo:table-header>
	
			<fo:table-body>
				<xsl:apply-templates select="DevCell"/>
			</fo:table-body>
		</fo:table>
	</xsl:template>

	<xsl:template match="GeneralRegressionModel[@modelType='generalLinear']/DevMatrix">
		<xsl:variable name="decimalPattern" select="../../DisplayOptions/@decimalPattern"/>
		<xsl:variable name="scientificPattern" select="../../DisplayOptions/@scientificPattern"/>

		<fo:table xsl:use-attribute-sets="table-atts"  space-after="5pt" table-layout="fixed">
			<xsl:element name="fo:table-column">
				<xsl:attribute name="column-number">1</xsl:attribute>
				<xsl:attribute name="column-width">
					<xsl:call-template name="DevCellSourceWidth">
						<xsl:with-param name="element" select="." />
						<xsl:with-param name="TotalNum" select="count(./DevCell)" />
					</xsl:call-template>pt
				</xsl:attribute>
			</xsl:element>
			<fo:table-column column-number="2" xsl:use-attribute-sets="left right" column-width="100pt"/>
			<fo:table-column column-number="3" xsl:use-attribute-sets="left right" column-width="100pt"/>
			<fo:table-column column-number="4" xsl:use-attribute-sets="left right" column-width="100pt"/>
			<fo:table-column column-number="5" xsl:use-attribute-sets="left right" column-width="100pt"/>
			<fo:table-column column-number="6" xsl:use-attribute-sets="left right" column-width="100pt"/>
	
			<fo:table-header>
				<fo:table-row background-color="#82C0FF">
					<fo:table-cell number-columns-spanned="6" xsl:use-attribute-sets="row-header left right top bottom"><fo:block>Analysis of Variance</fo:block></fo:table-cell>
				</fo:table-row>
				<fo:table-row background-color="#CCE6FF">
					<fo:table-cell xsl:use-attribute-sets="row-header left right top bottom"><fo:block>Source</fo:block></fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="header left right top bottom"><fo:block>DF</fo:block></fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="header left right top bottom"><fo:block>Sum of Squares</fo:block></fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="header left right top bottom"><fo:block>Mean Square</fo:block></fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="header left right top bottom"><fo:block>F</fo:block></fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="header left right top bottom"><fo:block>Pr(F)</fo:block></fo:table-cell>
				</fo:table-row>
			</fo:table-header>
	
			<fo:table-body>
				<xsl:apply-templates select="DevCell"/>
			</fo:table-body>
		</fo:table>

		<fo:block>
			<xsl:text>Multiple R-Squared: </xsl:text>
			<xsl:call-template name="roundNumber">
					<xsl:with-param name="string" select="@R2" />
					<xsl:with-param name="NaNstring" select="'NaN'" />
					<xsl:with-param name="decimalPattern" select="$decimalPattern" />
					<xsl:with-param name="scientificPattern" select="$scientificPattern" />
			</xsl:call-template>
		</fo:block>
	</xsl:template>

	<xsl:template match="GeneralRegressionModel[@modelType='generalLinear']/DevMatrix/DevCell">
		<xsl:variable name="decimalPattern" select="../../../DisplayOptions/@decimalPattern"/>
		<xsl:variable name="scientificPattern" select="../../../DisplayOptions/@scientificPattern"/>

		<xsl:element name="fo:table-row">
			<xsl:attribute name="background-color">
				<xsl:choose>
					<xsl:when test="position() mod 2 = 1">#FFFFFF</xsl:when>
					<xsl:otherwise>#EEEEEE</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>

			<fo:table-cell xsl:use-attribute-sets="row-header left right top bottom"><fo:block>
				<xsl:value-of select="@source"/>
			</fo:block></fo:table-cell>

			<fo:table-cell xsl:use-attribute-sets="cell left right top bottom"><fo:block>
				<xsl:number value="@df" grouping-size="3"/>
			</fo:block></fo:table-cell>

			<fo:table-cell xsl:use-attribute-sets="cell left right top bottom"><fo:block>
				<xsl:call-template name="roundNumber">
						<xsl:with-param name="string" select="@dev" />
						<xsl:with-param name="NaNstring" select="' '" />
						<xsl:with-param name="decimalPattern" select="$decimalPattern" />
						<xsl:with-param name="scientificPattern" select="$scientificPattern" />
				</xsl:call-template>
			</fo:block></fo:table-cell>

			<fo:table-cell xsl:use-attribute-sets="cell left right top bottom"><fo:block>
				<xsl:call-template name="roundNumber">
						<xsl:with-param name="string" select="@scaledDev" />
						<xsl:with-param name="NaNstring" select="' '" />
						<xsl:with-param name="decimalPattern" select="$decimalPattern" />
						<xsl:with-param name="scientificPattern" select="$scientificPattern" />
				</xsl:call-template>
			</fo:block></fo:table-cell>

			<fo:table-cell xsl:use-attribute-sets="cell left right top bottom"><fo:block>
				<xsl:call-template name="roundNumber">
						<xsl:with-param name="string" select="@stat" />
						<xsl:with-param name="NaNstring" select="' '" />
						<xsl:with-param name="decimalPattern" select="$decimalPattern" />
						<xsl:with-param name="scientificPattern" select="$scientificPattern" />
				</xsl:call-template>
			</fo:block></fo:table-cell>

			<fo:table-cell xsl:use-attribute-sets="cell left right top bottom"><fo:block>
				<xsl:call-template name="roundNumber">
						<xsl:with-param name="string" select="@Pr" />
						<xsl:with-param name="NaNstring" select="' '" />
						<xsl:with-param name="decimalPattern" select="$decimalPattern" />
						<xsl:with-param name="scientificPattern" select="$scientificPattern" />
				</xsl:call-template>
			</fo:block></fo:table-cell>
		</xsl:element>
	</xsl:template>

	<xsl:template match="GeneralRegressionModel[@modelType='multinomialLogistic']/DevMatrix/DevCell">
		<xsl:variable name="decimalPattern" select="../../../DisplayOptions/@decimalPattern"/>
		<xsl:variable name="scientificPattern" select="../../../DisplayOptions/@scientificPattern"/>

		<xsl:element name="fo:table-row">
			<xsl:attribute name="background-color">
				<xsl:choose>
					<xsl:when test="position() mod 2 = 1">#FFFFFF</xsl:when>
					<xsl:otherwise>#EEEEEE</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>

			<fo:table-cell xsl:use-attribute-sets="row-header left right top bottom"><fo:block>
				<xsl:value-of select="@source"/>
			</fo:block></fo:table-cell>

			<fo:table-cell xsl:use-attribute-sets="cell left right top bottom"><fo:block>
				<xsl:number value="@df" grouping-size="3"/>
			</fo:block></fo:table-cell>

			<fo:table-cell xsl:use-attribute-sets="cell left right top bottom"><fo:block>
				<xsl:call-template name="roundNumber">
						<xsl:with-param name="string" select="@dev" />
						<xsl:with-param name="NaNstring" select="'NaN'" />
						<xsl:with-param name="decimalPattern" select="$decimalPattern" />
						<xsl:with-param name="scientificPattern" select="$scientificPattern" />
				</xsl:call-template>
			</fo:block></fo:table-cell>
		</xsl:element>
	</xsl:template>

	<xsl:template match="GeneralRegressionModel[@modelType='multinomialLogistic']/Importance">
		<fo:table xsl:use-attribute-sets="table-atts"  space-after="5pt" table-layout="fixed">
			<xsl:element name="fo:table-column">
				<xsl:attribute name="column-number">1</xsl:attribute>
				<xsl:attribute name="column-width">
					<xsl:call-template name="EffectNameWidth">
						<xsl:with-param name="element" select="." />
						<xsl:with-param name="TotalNum" select="count(./Effect)" />
					</xsl:call-template>pt
				</xsl:attribute>
			</xsl:element>
			<fo:table-column column-number="2" xsl:use-attribute-sets="left right" column-width="100pt"/>
			<fo:table-column column-number="3" xsl:use-attribute-sets="left right" column-width="100pt"/>
			<fo:table-column column-number="4" xsl:use-attribute-sets="left right" column-width="100pt"/>
	
			<fo:table-header>
				<fo:table-row background-color="#82C0FF">
					<fo:table-cell number-columns-spanned="4" xsl:use-attribute-sets="row-header left right top bottom"><fo:block>Term Importance</fo:block></fo:table-cell>
				</fo:table-row>
				<fo:table-row background-color="#CCE6FF">
					<fo:table-cell xsl:use-attribute-sets="row-header left right top bottom"><fo:block>Source</fo:block></fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="header left right top bottom"><fo:block>Wald Statistic</fo:block></fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="header left right top bottom"><fo:block>DF</fo:block></fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="header left right top bottom"><fo:block>Pr</fo:block></fo:table-cell>
				</fo:table-row>
			</fo:table-header>
	
			<fo:table-body>
				<xsl:apply-templates select="Effect"/>
			</fo:table-body>
		</fo:table>
	</xsl:template>

	<xsl:template match="GeneralRegressionModel[@modelType='generalLinear']/Importance">
		<xsl:variable name="decimalPattern" select="../../DisplayOptions/@decimalPattern"/>
		<xsl:variable name="scientificPattern" select="../../DisplayOptions/@scientificPattern"/>

		<fo:table xsl:use-attribute-sets="table-atts"  space-after="5pt" table-layout="fixed">
			<xsl:element name="fo:table-column">
				<xsl:attribute name="column-number">1</xsl:attribute>
				<xsl:attribute name="column-width">
					<xsl:call-template name="EffectNameWidth">
						<xsl:with-param name="element" select="." />
						<xsl:with-param name="TotalNum" select="count(./Effect)" />
					</xsl:call-template>pt
				</xsl:attribute>
			</xsl:element>
			<fo:table-column column-number="2" xsl:use-attribute-sets="left right" column-width="100pt"/>
			<fo:table-column column-number="3" xsl:use-attribute-sets="left right" column-width="100pt"/>
			<fo:table-column column-number="4" xsl:use-attribute-sets="left right" column-width="100pt"/>
	
			<fo:table-header>
				<fo:table-row background-color="#82C0FF">
					<fo:table-cell number-columns-spanned="4" xsl:use-attribute-sets="row-header left right top bottom"><fo:block>Term Importance</fo:block></fo:table-cell>
				</fo:table-row>
				<fo:table-row background-color="#CCE6FF">
					<fo:table-cell xsl:use-attribute-sets="row-header left right top bottom"><fo:block>Source</fo:block></fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="header left right top bottom"><fo:block>Sum of Squares</fo:block></fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="header left right top bottom"><fo:block>F</fo:block></fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="header left right top bottom"><fo:block>Pr(F)</fo:block></fo:table-cell>
				</fo:table-row>
			</fo:table-header>
	
			<fo:table-body>
				<xsl:apply-templates select="Effect"/>
			</fo:table-body>
		</fo:table>
	</xsl:template>

	<xsl:template match="GeneralRegressionModel[@modelType='generalLinear']/Importance/Effect">
		<xsl:variable name="decimalPattern" select="../../../DisplayOptions/@decimalPattern"/>
		<xsl:variable name="scientificPattern" select="../../../DisplayOptions/@scientificPattern"/>

		<xsl:element name="fo:table-row">
			<xsl:attribute name="background-color">
				<xsl:choose>
					<xsl:when test="position() mod 2 = 1">#FFFFFF</xsl:when>
					<xsl:otherwise>#EEEEEE</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>

			<fo:table-cell xsl:use-attribute-sets="row-header left right top bottom"><fo:block>
				<xsl:value-of select="@name"/>
			</fo:block></fo:table-cell>

			<fo:table-cell xsl:use-attribute-sets="cell left right top bottom"><fo:block>
				<xsl:call-template name="roundNumber">
						<xsl:with-param name="string" select="@value" />
						<xsl:with-param name="NaNstring" select="'NaN'" />
						<xsl:with-param name="decimalPattern" select="$decimalPattern" />
						<xsl:with-param name="scientificPattern" select="$scientificPattern" />
				</xsl:call-template>
			</fo:block></fo:table-cell>

			<fo:table-cell xsl:use-attribute-sets="cell left right top bottom"><fo:block>
				<xsl:call-template name="roundNumber">
						<xsl:with-param name="string" select="@stat" />
						<xsl:with-param name="NaNstring" select="'NaN'" />
						<xsl:with-param name="decimalPattern" select="$decimalPattern" />
						<xsl:with-param name="scientificPattern" select="$scientificPattern" />
				</xsl:call-template>
			</fo:block></fo:table-cell>

			<fo:table-cell xsl:use-attribute-sets="cell left right top bottom"><fo:block>
				<xsl:call-template name="roundNumber">
						<xsl:with-param name="string" select="@Pr" />
						<xsl:with-param name="NaNstring" select="'NaN'" />
						<xsl:with-param name="decimalPattern" select="$decimalPattern" />
						<xsl:with-param name="scientificPattern" select="$scientificPattern" />
				</xsl:call-template>
			</fo:block></fo:table-cell>
		</xsl:element>
	</xsl:template>

	<xsl:template match="GeneralRegressionModel[@modelType='multinomialLogistic']/Importance/Effect">
		<xsl:variable name="decimalPattern" select="../../../DisplayOptions/@decimalPattern"/>
		<xsl:variable name="scientificPattern" select="../../../DisplayOptions/@scientificPattern"/>

		<xsl:element name="fo:table-row">
			<xsl:attribute name="background-color">
				<xsl:choose>
					<xsl:when test="position() mod 2 = 1">#FFFFFF</xsl:when>
					<xsl:otherwise>#EEEEEE</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>

			<fo:table-cell xsl:use-attribute-sets="row-header left right top bottom"><fo:block>
				<xsl:value-of select="@name"/>
			</fo:block></fo:table-cell>

			<fo:table-cell xsl:use-attribute-sets="cell left right top bottom"><fo:block>
				<xsl:call-template name="roundNumber">
						<xsl:with-param name="string" select="@value" />
						<xsl:with-param name="NaNstring" select="'NaN'" />
						<xsl:with-param name="decimalPattern" select="$decimalPattern" />
						<xsl:with-param name="scientificPattern" select="$scientificPattern" />
				</xsl:call-template>
			</fo:block></fo:table-cell>

			<fo:table-cell xsl:use-attribute-sets="cell left right top bottom"><fo:block>
				<xsl:number value="@df" grouping-size="3"/>
			</fo:block></fo:table-cell>

			<fo:table-cell xsl:use-attribute-sets="cell left right top bottom"><fo:block>
				<xsl:call-template name="roundNumber">
						<xsl:with-param name="string" select="@Pr" />
						<xsl:with-param name="NaNstring" select="'NaN'" />
						<xsl:with-param name="decimalPattern" select="$decimalPattern" />
						<xsl:with-param name="scientificPattern" select="$scientificPattern" />
				</xsl:call-template>
			</fo:block></fo:table-cell>
		</xsl:element>
	</xsl:template>

	<xsl:template name="PCellParamNameWidth">
		<xsl:param name="element" select="''" />
		<xsl:param name="CurrentNum" select="0" />
		<xsl:param name="TotalNum" select="0" />
		<xsl:param name="maxWidth" select="0" />

		<xsl:variable name="this" select="$element/PCell[$CurrentNum]/@parameterName" />
		<xsl:variable name="thisWidth" select="string-length($this) * 6" />
		
<!--		
	<xsl:value-of select="name($element)" /><xsl:text>::</xsl:text>
	<xsl:value-of select="name($element/PCell[$CurrentNum])" />
	<xsl:text>~</xsl:text><xsl:value-of select="$this" />
	<xsl:text>(</xsl:text><xsl:value-of select="$thisWidth" /><xsl:text>)/xsl:text>
-->

		<xsl:choose>
			<xsl:when test="$TotalNum = $CurrentNum">
				<xsl:choose>
					<xsl:when test="$thisWidth &gt; $maxWidth"><xsl:value-of select="$thisWidth"/></xsl:when>
					<xsl:otherwise><xsl:value-of select="$maxWidth"/></xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="$thisWidth &gt; $maxWidth">
						<xsl:call-template name="PCellParamNameWidth">
							<xsl:with-param name="element" select="$element" />
							<xsl:with-param name="CurrentNum" select="$CurrentNum + 1" />
							<xsl:with-param name="TotalNum" select="$TotalNum" />
							<xsl:with-param name="maxWidth" select="$thisWidth"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="PCellParamNameWidth">
							<xsl:with-param name="element" select="$element" />
							<xsl:with-param name="CurrentNum" select="$CurrentNum + 1" />
							<xsl:with-param name="TotalNum" select="$TotalNum" />
							<xsl:with-param name="maxWidth" select="$maxWidth"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="CorrCellCoeffWidth">
		<xsl:param name="element" select="''" />
		<xsl:param name="CurrentNum" select="0" />
		<xsl:param name="TotalNum" select="0" />
		<xsl:param name="maxWidth" select="0" />

		<xsl:variable name="this" select="$element/CorrCell[$CurrentNum]/@coef" />
		<xsl:variable name="thisWidth" select="string-length($this) * 6" />
		
		<xsl:choose>
			<xsl:when test="$TotalNum = $CurrentNum">
				<xsl:choose>
					<xsl:when test="$thisWidth &gt; $maxWidth"><xsl:value-of select="$thisWidth"/></xsl:when>
					<xsl:otherwise><xsl:value-of select="$maxWidth"/></xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="$thisWidth &gt; $maxWidth">
						<xsl:call-template name="CorrCellCoeffWidth">
							<xsl:with-param name="element" select="$element" />
							<xsl:with-param name="CurrentNum" select="$CurrentNum + 1" />
							<xsl:with-param name="TotalNum" select="$TotalNum" />
							<xsl:with-param name="maxWidth" select="$thisWidth"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="CorrCellCoeffWidth">
							<xsl:with-param name="element" select="$element" />
							<xsl:with-param name="CurrentNum" select="$CurrentNum + 1" />
							<xsl:with-param name="TotalNum" select="$TotalNum" />
							<xsl:with-param name="maxWidth" select="$maxWidth"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="DevCellSourceWidth">
		<xsl:param name="element" select="''" />
		<xsl:param name="CurrentNum" select="0" />
		<xsl:param name="TotalNum" select="0" />
		<xsl:param name="maxWidth" select="0" />

		<xsl:variable name="this" select="$element/DevCell[$CurrentNum]/@source" />
		<xsl:variable name="thisWidth" select="string-length($this) * 6" />
		
		<xsl:choose>
			<xsl:when test="$TotalNum = $CurrentNum">
				<xsl:choose>
					<xsl:when test="$thisWidth &gt; $maxWidth"><xsl:value-of select="$thisWidth"/></xsl:when>
					<xsl:otherwise><xsl:value-of select="$maxWidth"/></xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="$thisWidth &gt; $maxWidth">
						<xsl:call-template name="DevCellSourceWidth">
							<xsl:with-param name="element" select="$element" />
							<xsl:with-param name="CurrentNum" select="$CurrentNum + 1" />
							<xsl:with-param name="TotalNum" select="$TotalNum" />
							<xsl:with-param name="maxWidth" select="$thisWidth"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="DevCellSourceWidth">
							<xsl:with-param name="element" select="$element" />
							<xsl:with-param name="CurrentNum" select="$CurrentNum + 1" />
							<xsl:with-param name="TotalNum" select="$TotalNum" />
							<xsl:with-param name="maxWidth" select="$maxWidth"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="EffectNameWidth">
		<xsl:param name="element" select="''" />
		<xsl:param name="CurrentNum" select="0" />
		<xsl:param name="TotalNum" select="0" />
		<xsl:param name="maxWidth" select="0" />

		<xsl:variable name="this" select="$element/Effect[$CurrentNum]/@name" />
		<xsl:variable name="thisWidth" select="string-length($this) * 6" />
		
		<xsl:choose>
			<xsl:when test="$TotalNum = $CurrentNum">
				<xsl:choose>
					<xsl:when test="$thisWidth &gt; $maxWidth"><xsl:value-of select="$thisWidth"/></xsl:when>
					<xsl:otherwise><xsl:value-of select="$maxWidth"/></xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="$thisWidth &gt; $maxWidth">
						<xsl:call-template name="EffectNameWidth">
							<xsl:with-param name="element" select="$element" />
							<xsl:with-param name="CurrentNum" select="$CurrentNum + 1" />
							<xsl:with-param name="TotalNum" select="$TotalNum" />
							<xsl:with-param name="maxWidth" select="$thisWidth"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="EffectNameWidth">
							<xsl:with-param name="element" select="$element" />
							<xsl:with-param name="CurrentNum" select="$CurrentNum + 1" />
							<xsl:with-param name="TotalNum" select="$TotalNum" />
							<xsl:with-param name="maxWidth" select="$maxWidth"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="roundNumber">
		<xsl:param name="string" select="''" />
		<xsl:param name="NaNstring" select="''" />
		<xsl:param name="decimalPattern" select="''" />
		<xsl:param name="scientificPattern" select="''" />

	   	<xsl:variable name="lowerCasePattern" select="'e'" />
	   	<xsl:variable name="upperCasePattern" select="'E'" />

		<xsl:choose>
			<xsl:when test="not(boolean($decimalPattern))">
				<xsl:value-of select="$string"/>
			</xsl:when>
  			  <xsl:when test="$string = 'NaN'">
			  	    <xsl:value-of select="$NaNstring"/>
			  </xsl:when>
  			  <xsl:when test="string-length($string) = 0">
			  	    <xsl:value-of select="$NaNstring"/>
			  </xsl:when>
		      <xsl:when test="contains($string, $lowerCasePattern)">
			    <xsl:call-template name="outputRoundedScientific">
			        <xsl:with-param name="valueString" select="substring-before($string, $lowerCasePattern)" />
			        <xsl:with-param name="exponentString" select="substring-after($string, $lowerCasePattern)" />
		     		<xsl:with-param name="decimalPattern" select="$decimalPattern" />
			    </xsl:call-template>
 			  </xsl:when>
		      <xsl:when test="contains($string, $upperCasePattern)">
			    <xsl:call-template name="outputRoundedScientific">
			        <xsl:with-param name="valueString" select="substring-before($string, $upperCasePattern)" />
			        <xsl:with-param name="exponentString" select="substring-after($string, $upperCasePattern)" />
		     		<xsl:with-param name="decimalPattern" select="$decimalPattern" />
			    </xsl:call-template>
 			  </xsl:when>
		      <xsl:otherwise>
		      	 <xsl:choose>
					<xsl:when test="format-number($string, $decimalPattern) != format-number(0, $decimalPattern)">
						<xsl:value-of select="format-number($string, $decimalPattern)"/>
					</xsl:when>
					<xsl:when test="$string = 0">
						<xsl:value-of select="format-number($string, $decimalPattern)"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="format-number($string, $scientificPattern)"/>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:text>  </xsl:text>
		      </xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="outputRoundedScientific">
		<xsl:param name="valueString" select="''" />
		<xsl:param name="exponentString" select="''" />
		<xsl:param name="decimalPattern" select="''" />
		<xsl:value-of select="format-number($valueString, $decimalPattern)" />E<xsl:value-of select="format-number($exponentString, '#0')"/>
	</xsl:template>

</xsl:stylesheet>
