<?xml version='1.0' encoding='UTF-8' ?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">

<!-- XSL style sheet for NeuralNetwork element -->
	<xsl:attribute-set name="title">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">20pt</xsl:attribute>
		<xsl:attribute name="line-height">24pt</xsl:attribute>
		<xsl:attribute name="space-after">10pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="bold-emph">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">16pt</xsl:attribute>
		<xsl:attribute name="line-height">20pt</xsl:attribute>
		<xsl:attribute name="space-after">2pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="small-cap">
		<xsl:attribute name="font-variant">small-caps</xsl:attribute>
		<xsl:attribute name="font-size">14pt</xsl:attribute>
		<xsl:attribute name="line-height">18pt</xsl:attribute>
		<xsl:attribute name="space-after">2pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="body">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="line-height">14pt</xsl:attribute>
		<xsl:attribute name="space-after">2pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="bold-body">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="line-height">14pt</xsl:attribute>
		<xsl:attribute name="space-after">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="header">
		<xsl:attribute name="text-align">right</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="border-after-color">#82C0FF</xsl:attribute>
		<xsl:attribute name="border-after-style">double</xsl:attribute>
		<xsl:attribute name="border-after-width">2pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="cell">
		<xsl:attribute name="text-align">right</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="row-header">
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="left">
		<xsl:attribute name="border-start-color">#82C0FF</xsl:attribute>
		<xsl:attribute name="border-start-style">double</xsl:attribute>
		<xsl:attribute name="border-start-width">2pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="right">
		<xsl:attribute name="border-end-color">#82C0FF</xsl:attribute>
		<xsl:attribute name="border-end-style">double</xsl:attribute>
		<xsl:attribute name="border-start-width">2pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="top">
		<xsl:attribute name="border-before-color">#82C0FF</xsl:attribute>
		<xsl:attribute name="border-before-style">double</xsl:attribute>
		<xsl:attribute name="border-before-width">2pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="bottom">
		<xsl:attribute name="border-after-color">#82C0FF</xsl:attribute>
		<xsl:attribute name="border-after-style">double</xsl:attribute>
		<xsl:attribute name="border-after-width">2pt</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="table-atts">
		<xsl:attribute name="border-before-color">#82C0FF</xsl:attribute>
		<xsl:attribute name="border-before-style">double</xsl:attribute>
		<xsl:attribute name="border-before-width">6pt</xsl:attribute>
		<xsl:attribute name="border-start-color">#82C0FF</xsl:attribute>
		<xsl:attribute name="border-start-style">double</xsl:attribute>
		<xsl:attribute name="border-start-width">3pt</xsl:attribute>
		<xsl:attribute name="border-after-color">#82C0FF</xsl:attribute>
		<xsl:attribute name="border-after-style">double</xsl:attribute>
		<xsl:attribute name="border-after-width">3pt</xsl:attribute>
		<xsl:attribute name="border-end-color">#82C0FF</xsl:attribute>
		<xsl:attribute name="border-end-style">double</xsl:attribute>
		<xsl:attribute name="border-end-width">3pt</xsl:attribute>
	</xsl:attribute-set>
	

	<xsl:template match="/">
		<fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format">
			<fo:layout-master-set>
				<fo:simple-page-master master-name="page">
					<fo:region-body region-name="body" margin-top="0.5in" margin-bottom="0.5in" margin-left="0.5in" margin-right="0.5in" />
				</fo:simple-page-master>
			</fo:layout-master-set>
			
			<fo:page-sequence master-reference="page">
				<fo:flow flow-name="body">
					<fo:block>
						<xsl:apply-templates />
					</fo:block>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>

	<xsl:template match="XML">
		<xsl:apply-templates select="IMML"/>
	</xsl:template>

	<xsl:template match="IMML">
		<fo:block xsl:use-attribute-sets="title"><xsl:value-of select="DisplayOptions/@title"/></fo:block>

		<xsl:apply-templates select="NeuralNetwork"/>
	</xsl:template>

	<xsl:template match="NeuralNetwork">
  		<xsl:choose>
			<xsl:when test="@modelType='classification'">
				<fo:block xsl:use-attribute-sets="small-cap">
					<xsl:text>Dependent variable: </xsl:text><xsl:value-of select="@targetVariableName"/>
				</fo:block>
			</xsl:when>
			<xsl:otherwise>
				<fo:block xsl:use-attribute-sets="bold-emph">Regression Neural Network</fo:block>
				<fo:block xsl:use-attribute-sets="small-cap">
					<xsl:text>Dependent variable: </xsl:text><xsl:value-of select="@targetVariableName"/>
				</fo:block>
			</xsl:otherwise>
		</xsl:choose>

		<xsl:apply-templates select="DevMatrix"/>
		<xsl:apply-templates select="NeuralInputs"/>
		<xsl:apply-templates select="NeuralOutputs"/>
		
		<fo:block xsl:use-attribute-sets="bold-emph"><xsl:text>Bias node = 0</xsl:text></fo:block>
		<xsl:apply-templates select="NeuralLayer"/>
	</xsl:template>

	<xsl:template match="NeuralNetwork[@modelType='classification']/DevMatrix">
		<xsl:variable name="decimalPattern" select="../../DisplayOptions/@decimalPattern"/>
		<xsl:variable name="scientificPattern" select="../../DisplayOptions/@scientificPattern"/>

		<fo:table xsl:use-attribute-sets="table-atts"  space-after="5pt" table-layout="fixed">
			<xsl:element name="fo:table-column">
				<xsl:attribute name="column-number">1</xsl:attribute>
				<xsl:attribute name="column-width">
					<xsl:call-template name="DevCellSourceWidth">
						<xsl:with-param name="element" select="." />
						<xsl:with-param name="TotalNum" select="count(./DevCell)" />
					</xsl:call-template>pt
				</xsl:attribute>
			</xsl:element>
			<fo:table-column column-number="2" column-width="100pt"/>
	
			<fo:table-header>
				<fo:table-row background-color="#82C0FF">
					<fo:table-cell number-columns-spanned="2" xsl:use-attribute-sets="row-header left right top bottom"><fo:block>Analysis of Deviance</fo:block></fo:table-cell>
				</fo:table-row>
				<fo:table-row background-color="#CCE6FF">
					<fo:table-cell xsl:use-attribute-sets="row-header left right top bottom"><fo:block>Source</fo:block></fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="header left right top bottom"><fo:block>Deviance</fo:block></fo:table-cell>
				</fo:table-row>
			</fo:table-header>
	
			<fo:table-body>
				<xsl:apply-templates select="DevCell"/>
			</fo:table-body>
		</fo:table>

		<fo:block xsl:use-attribute-sets="small-cap">
			<xsl:text>Accuracy: </xsl:text>
			<xsl:call-template name="roundNumber">
					<xsl:with-param name="string" select="@accuracy" />
					<xsl:with-param name="decimalPattern" select="$decimalPattern" />
					<xsl:with-param name="scientificPattern" select="$scientificPattern" />
			</xsl:call-template>
		</fo:block>
	</xsl:template>

	<xsl:template match="NeuralNetwork[@modelType='regression']/DevMatrix">
		<xsl:variable name="decimalPattern" select="../../DisplayOptions/@decimalPattern"/>
		<xsl:variable name="scientificPattern" select="../../DisplayOptions/@scientificPattern"/>

		<fo:table xsl:use-attribute-sets="table-atts"  space-after="5pt" table-layout="fixed">
			<xsl:element name="fo:table-column">
				<xsl:attribute name="column-number">1</xsl:attribute>
				<xsl:attribute name="column-width">
					<xsl:call-template name="DevCellSourceWidth">
						<xsl:with-param name="element" select="." />
						<xsl:with-param name="TotalNum" select="count(./DevCell)" />
					</xsl:call-template>pt
				</xsl:attribute>
			</xsl:element>
			<fo:table-column column-number="2" column-width="100pt"/>
	
			<fo:table-header>
				<fo:table-row background-color="#82C0FF">
					<fo:table-cell number-columns-spanned="2" xsl:use-attribute-sets="row-header left right top bottom"><fo:block>Analysis of Variance</fo:block></fo:table-cell>
				</fo:table-row>
				<fo:table-row background-color="#CCE6FF">
					<fo:table-cell xsl:use-attribute-sets="row-header left right top bottom"><fo:block>Source</fo:block></fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="header left right top bottom"><fo:block>Sum of Squares</fo:block></fo:table-cell>
				</fo:table-row>
			</fo:table-header>
	
			<fo:table-body>
				<xsl:apply-templates select="DevCell"/>
			</fo:table-body>
		</fo:table>

		<fo:block xsl:use-attribute-sets="small-cap">
			<xsl:text>Accuracy: </xsl:text>
			<xsl:call-template name="roundNumber">
					<xsl:with-param name="string" select="@accuracy" />
					<xsl:with-param name="decimalPattern" select="$decimalPattern" />
					<xsl:with-param name="scientificPattern" select="$scientificPattern" />
			</xsl:call-template>
		</fo:block>
  	</xsl:template>

	<xsl:template match="DevCell">
		<xsl:variable name="decimalPattern" select="../../../DisplayOptions/@decimalPattern"/>
		<xsl:variable name="scientificPattern" select="../../../DisplayOptions/@scientificPattern"/>

		<xsl:element name="fo:table-row">
			<xsl:attribute name="background-color">
				<xsl:choose>
					<xsl:when test="position() mod 2 = 1">#FFFFFF</xsl:when>
					<xsl:otherwise>#EEEEEE</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>

			<fo:table-cell xsl:use-attribute-sets="row-header left right top bottom"><fo:block>
				<xsl:value-of select="@source"/>
			</fo:block></fo:table-cell>

			<fo:table-cell xsl:use-attribute-sets="cell left right top bottom"><fo:block>
				<xsl:call-template name="roundNumber">
						<xsl:with-param name="string" select="@dev" />
						<xsl:with-param name="decimalPattern" select="$decimalPattern" />
						<xsl:with-param name="scientificPattern" select="$scientificPattern" />
				</xsl:call-template>
			</fo:block></fo:table-cell>
		</xsl:element>
	</xsl:template>

	<xsl:template name="DevCellSourceWidth">
		<xsl:param name="element" select="''" />
		<xsl:param name="CurrentNum" select="0" />
		<xsl:param name="TotalNum" select="0" />
		<xsl:param name="minWidth" select="50" />
		<xsl:param name="maxWidth" select="0" />

		<xsl:variable name="this" select="$element/DevCell[$CurrentNum]/@source" />
		<xsl:variable name="thisWidth" select="string-length($this) * 6" />

		<xsl:choose>
			<xsl:when test="$TotalNum = $CurrentNum">
				<xsl:choose>
					<xsl:when test="$thisWidth &gt; $maxWidth">
						<xsl:choose>
							<xsl:when test="$minWidth &gt; $thisWidth"><xsl:value-of select="$minWidth"/></xsl:when>
							<xsl:otherwise><xsl:value-of select="$thisWidth"/></xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="$minWidth &gt; $maxWidth"><xsl:value-of select="$minWidth"/></xsl:when>
							<xsl:otherwise><xsl:value-of select="$maxWidth"/></xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="$thisWidth &gt; $maxWidth">
						<xsl:call-template name="DevCellSourceWidth">
							<xsl:with-param name="element" select="$element" />
							<xsl:with-param name="CurrentNum" select="$CurrentNum + 1" />
							<xsl:with-param name="TotalNum" select="$TotalNum" />
							<xsl:with-param name="maxWidth" select="$thisWidth"/>
							<xsl:with-param name="minWidth" select="$minWidth"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="DevCellSourceWidth">
							<xsl:with-param name="element" select="$element" />
							<xsl:with-param name="CurrentNum" select="$CurrentNum + 1" />
							<xsl:with-param name="TotalNum" select="$TotalNum" />
							<xsl:with-param name="maxWidth" select="$maxWidth"/>
							<xsl:with-param name="minWidth" select="$minWidth"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="NeuralInputs">
		<fo:table xsl:use-attribute-sets="table-atts"  space-after="5pt" table-layout="fixed">
			<fo:table-column column-number="1" column-width="60pt" />
			<xsl:element name="fo:table-column">
				<xsl:attribute name="column-number">2</xsl:attribute>
				<xsl:attribute name="column-width">
					<xsl:call-template name="InputVarWidth">
						<xsl:with-param name="element" select="." />
						<xsl:with-param name="TotalNum" select="count(./NeuralInput)" />
					</xsl:call-template>pt
				</xsl:attribute>
			</xsl:element>
	
			<fo:table-header>
				<fo:table-row background-color="#82C0FF">
					<fo:table-cell number-columns-spanned="2" xsl:use-attribute-sets="row-header left right top bottom"><fo:block>Neural Inputs</fo:block></fo:table-cell>
				</fo:table-row>
				<fo:table-row background-color="#CCE6FF">
					<fo:table-cell xsl:use-attribute-sets="row-header left right top bottom"><fo:block>Id </fo:block></fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="row-header left right top bottom"><fo:block>Variable </fo:block></fo:table-cell>
				</fo:table-row>
			</fo:table-header>
	
			<fo:table-body>
				<xsl:for-each select="NeuralInput">
					<xsl:element name="fo:table-row">
						<xsl:attribute name="background-color">
							<xsl:choose>
								<xsl:when test="position() mod 2 = 1">#FFFFFF</xsl:when>
								<xsl:otherwise>#EEEEEE</xsl:otherwise>
							</xsl:choose>
						</xsl:attribute>
			
						<fo:table-cell xsl:use-attribute-sets="row-header left right top bottom"><fo:block>
							<xsl:value-of select="@id"/>
						</fo:block></fo:table-cell>

						<xsl:variable name="var" select="NormContinuous/@field"/>
						<xsl:choose>
							<xsl:when test="NormContinuous">
								<fo:table-cell xsl:use-attribute-sets="cell left right top bottom" text-align="left"><fo:block>
									<xsl:value-of select="$var"/>
								</fo:block></fo:table-cell>
							</xsl:when>
							<xsl:otherwise>
								<fo:table-cell xsl:use-attribute-sets="cell left right top bottom" text-align="left"><fo:block>
									<xsl:value-of select="NormDiscrete/@field"/>
									<xsl:text>(</xsl:text>
									<xsl:value-of select="NormDiscrete/@value"/>
									<xsl:text>)</xsl:text>
								</fo:block></fo:table-cell>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:element>
				</xsl:for-each>
			</fo:table-body>
		</fo:table>
	</xsl:template>

	<xsl:template name="InputVarWidth">
		<xsl:param name="element" select="''" />
		<xsl:param name="CurrentNum" select="0" />
		<xsl:param name="TotalNum" select="0" />
		<xsl:param name="minWidth" select="50" />
		<xsl:param name="maxWidth" select="0" />
		
		<xsl:variable name="contWidth" select="string-length($element/NeuralInput[$CurrentNum]/NormContinuous/@field) * 6" />
		<xsl:variable name="discWidth" select="string-length($element/NeuralInput[$CurrentNum]/NormDiscrete/@field) * 6 + $element/NeuralInput[$CurrentNum]/NormDiscrete/@value * 6 + 2 * 6" />

		<xsl:choose>
			<xsl:when test="boolean($contWidth)">
				<xsl:variable name="thisWidth" select="$contWidth" />
				<xsl:choose>
					<xsl:when test="$TotalNum = $CurrentNum">
						<xsl:choose>
							<xsl:when test="$thisWidth &gt; $maxWidth">
								<xsl:choose>
									<xsl:when test="$minWidth &gt; $thisWidth"><xsl:value-of select="$minWidth"/></xsl:when>
									<xsl:otherwise><xsl:value-of select="$thisWidth"/></xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="$minWidth &gt; $maxWidth"><xsl:value-of select="$minWidth"/></xsl:when>
									<xsl:otherwise><xsl:value-of select="$maxWidth"/></xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="$thisWidth &gt; $maxWidth">
								<xsl:call-template name="InputVarWidth">
									<xsl:with-param name="element" select="$element" />
									<xsl:with-param name="CurrentNum" select="$CurrentNum + 1" />
									<xsl:with-param name="TotalNum" select="$TotalNum" />
									<xsl:with-param name="maxWidth" select="$thisWidth"/>
									<xsl:with-param name="minWidth" select="$minWidth"/>
								</xsl:call-template>
							</xsl:when>
							<xsl:otherwise>
								<xsl:call-template name="InputVarWidth">
									<xsl:with-param name="element" select="$element" />
									<xsl:with-param name="CurrentNum" select="$CurrentNum + 1" />
									<xsl:with-param name="TotalNum" select="$TotalNum" />
									<xsl:with-param name="maxWidth" select="$maxWidth"/>
									<xsl:with-param name="minWidth" select="$minWidth"/>
								</xsl:call-template>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when >
			<xsl:otherwise>
				<xsl:variable name="thisWidth" select="$discWidth" />
				<xsl:choose>
					<xsl:when test="$TotalNum = $CurrentNum">
						<xsl:choose>
							<xsl:when test="$thisWidth &gt; $maxWidth">
								<xsl:choose>
									<xsl:when test="$minWidth &gt; $thisWidth"><xsl:value-of select="$minWidth"/></xsl:when>
									<xsl:otherwise><xsl:value-of select="$thisWidth"/></xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="$minWidth &gt; $maxWidth"><xsl:value-of select="$minWidth"/></xsl:when>
									<xsl:otherwise><xsl:value-of select="$maxWidth"/></xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="$thisWidth &gt; $maxWidth">
								<xsl:call-template name="InputVarWidth">
									<xsl:with-param name="element" select="$element" />
									<xsl:with-param name="CurrentNum" select="$CurrentNum + 1" />
									<xsl:with-param name="TotalNum" select="$TotalNum" />
									<xsl:with-param name="maxWidth" select="$thisWidth"/>
									<xsl:with-param name="minWidth" select="$minWidth"/>
								</xsl:call-template>
							</xsl:when>
							<xsl:otherwise>
								<xsl:call-template name="InputVarWidth">
									<xsl:with-param name="element" select="$element" />
									<xsl:with-param name="CurrentNum" select="$CurrentNum + 1" />
									<xsl:with-param name="TotalNum" select="$TotalNum" />
									<xsl:with-param name="maxWidth" select="$maxWidth"/>
									<xsl:with-param name="minWidth" select="$minWidth"/>
								</xsl:call-template>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="NeuralOutputs">
		<fo:table xsl:use-attribute-sets="table-atts"  space-after="5pt" table-layout="fixed">
			<fo:table-column column-number="1" column-width="60pt" />
			<xsl:element name="fo:table-column">
				<xsl:attribute name="column-width">
					<xsl:call-template name="OutputVarWidth">
						<xsl:with-param name="element" select="." />
						<xsl:with-param name="TotalNum" select="count(./NeuralOutput)" />
					</xsl:call-template>pt
				</xsl:attribute>
			</xsl:element>
	
			<fo:table-header>
				<fo:table-row background-color="#82C0FF">
					<fo:table-cell number-columns-spanned="2" xsl:use-attribute-sets="row-header left right top bottom"><fo:block>Neural Inputs</fo:block></fo:table-cell>
				</fo:table-row>
				<fo:table-row background-color="#CCE6FF">
					<fo:table-cell xsl:use-attribute-sets="row-header left right top bottom"><fo:block>Id </fo:block></fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="row-header left right top bottom"><fo:block>Variable </fo:block></fo:table-cell>
				</fo:table-row>
			</fo:table-header>
	
			<fo:table-body>
				<xsl:for-each select="NeuralOutput">
					<xsl:element name="fo:table-row">
						<xsl:attribute name="background-color">
							<xsl:choose>
								<xsl:when test="position() mod 2 = 1">#FFFFFF</xsl:when>
								<xsl:otherwise>#EEEEEE</xsl:otherwise>
							</xsl:choose>
						</xsl:attribute>
			
						<fo:table-cell xsl:use-attribute-sets="row-header left right top bottom"><fo:block>
							<xsl:value-of select="@id"/>
						</fo:block></fo:table-cell>

						<xsl:variable name="var" select="NormContinuous/@field"/>
						<xsl:choose>
							<xsl:when test="NormContinuous">
								<fo:table-cell xsl:use-attribute-sets="cell left right top bottom" text-align="left"><fo:block>
									<xsl:value-of select="$var"/>
								</fo:block></fo:table-cell>
							</xsl:when>
							<xsl:otherwise>
								<fo:table-cell xsl:use-attribute-sets="cell left right top bottom" text-align="left"><fo:block>
									<xsl:value-of select="NormDiscrete/@field"/>
									<xsl:text>(</xsl:text>
									<xsl:value-of select="NormDiscrete/@value"/>
									<xsl:text>)</xsl:text>
								</fo:block></fo:table-cell>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:element>
				</xsl:for-each>
			</fo:table-body>
		</fo:table>
	</xsl:template>

	<xsl:template name="OutputVarWidth">
		<xsl:param name="element" select="''" />
		<xsl:param name="CurrentNum" select="0" />
		<xsl:param name="TotalNum" select="0" />
		<xsl:param name="minWidth" select="50" />
		<xsl:param name="maxWidth" select="0" />
		
		<xsl:variable name="contWidth" select="string-length($element/NeuralOutput[$CurrentNum]/NormContinuous/@field) * 6" />
		<xsl:variable name="discWidth" select="string-length($element/NeuralOutput[$CurrentNum]/NormDiscrete/@field) * 6 + $element/NeuralOutput[$CurrentNum]/NormDiscrete/@value * 6 + 2 * 6" />

		<xsl:choose>
			<xsl:when test="boolean($contWidth)">
				<xsl:variable name="thisWidth" select="$contWidth" />
				<xsl:choose>
					<xsl:when test="$TotalNum = $CurrentNum">
						<xsl:choose>
							<xsl:when test="$thisWidth &gt; $maxWidth">
								<xsl:choose>
									<xsl:when test="$minWidth &gt; $thisWidth"><xsl:value-of select="$minWidth"/></xsl:when>
									<xsl:otherwise><xsl:value-of select="$thisWidth"/></xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="$minWidth &gt; $maxWidth"><xsl:value-of select="$minWidth"/></xsl:when>
									<xsl:otherwise><xsl:value-of select="$maxWidth"/></xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="$thisWidth &gt; $maxWidth">
								<xsl:call-template name="OutputVarWidth">
									<xsl:with-param name="element" select="$element" />
									<xsl:with-param name="CurrentNum" select="$CurrentNum + 1" />
									<xsl:with-param name="TotalNum" select="$TotalNum" />
									<xsl:with-param name="maxWidth" select="$thisWidth"/>
									<xsl:with-param name="minWidth" select="$minWidth"/>
								</xsl:call-template>
							</xsl:when>
							<xsl:otherwise>
								<xsl:call-template name="OutputVarWidth">
									<xsl:with-param name="element" select="$element" />
									<xsl:with-param name="CurrentNum" select="$CurrentNum + 1" />
									<xsl:with-param name="TotalNum" select="$TotalNum" />
									<xsl:with-param name="maxWidth" select="$maxWidth"/>
									<xsl:with-param name="minWidth" select="$minWidth"/>
								</xsl:call-template>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when >
			<xsl:otherwise>
				<xsl:variable name="thisWidth" select="$discWidth" />
				<xsl:choose>
					<xsl:when test="$TotalNum = $CurrentNum">
						<xsl:choose>
							<xsl:when test="$thisWidth &gt; $maxWidth">
								<xsl:choose>
									<xsl:when test="$minWidth &gt; $thisWidth"><xsl:value-of select="$minWidth"/></xsl:when>
									<xsl:otherwise><xsl:value-of select="$thisWidth"/></xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="$minWidth &gt; $maxWidth"><xsl:value-of select="$minWidth"/></xsl:when>
									<xsl:otherwise><xsl:value-of select="$maxWidth"/></xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="$thisWidth &gt; $maxWidth">
								<xsl:call-template name="OutputVarWidth">
									<xsl:with-param name="element" select="$element" />
									<xsl:with-param name="CurrentNum" select="$CurrentNum + 1" />
									<xsl:with-param name="TotalNum" select="$TotalNum" />
									<xsl:with-param name="maxWidth" select="$thisWidth"/>
									<xsl:with-param name="minWidth" select="$minWidth"/>
								</xsl:call-template>
							</xsl:when>
							<xsl:otherwise>
								<xsl:call-template name="OutputVarWidth">
									<xsl:with-param name="element" select="$element" />
									<xsl:with-param name="CurrentNum" select="$CurrentNum + 1" />
									<xsl:with-param name="TotalNum" select="$TotalNum" />
									<xsl:with-param name="maxWidth" select="$maxWidth"/>
									<xsl:with-param name="minWidth" select="$minWidth"/>
								</xsl:call-template>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- This table shows the NOT-LAST neuron hidden layer(s) -->
	<xsl:template match="NeuralLayer[not(position()=last())]">
		<xsl:variable name="decimalPattern" select="../../DisplayOptions/@decimalPattern"/>
		<xsl:variable name="scientificPattern" select="../../DisplayOptions/@scientificPattern"/>

		<fo:table xsl:use-attribute-sets="table-atts"  space-after="5pt" table-layout="fixed">
			<fo:table-column column-number="1" column-width="100pt" />
			<fo:table-column column-number="2" column-width="100pt"/>
			<fo:table-column column-number="3" column-width="100pt" />
			<fo:table-column column-number="4" column-width="100pt" />

			<fo:table-header>
				<fo:table-row background-color="#CCE6FF">
					<fo:table-cell number-columns-spanned="4" xsl:use-attribute-sets="row-header left right top bottom"><fo:block>
						<xsl:text>Hidden Layer #</xsl:text><xsl:value-of select="position()"/>
					</fo:block></fo:table-cell>
				</fo:table-row>
				<fo:table-row background-color="#CCE6FF" >
					<fo:table-cell column-number="1" display-align="after" xsl:use-attribute-sets="header left right top"><fo:block><xsl:text>Hidden Layer: </xsl:text></fo:block></fo:table-cell>
					<fo:table-cell column-number="2" display-align="after" xsl:use-attribute-sets="header left right top"><fo:block><xsl:text></xsl:text></fo:block></fo:table-cell>
					<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="header left right top bottom"><fo:block>Neuron Connection Weights</fo:block></fo:table-cell>
				</fo:table-row>
				<fo:table-row background-color="#CCE6FF">
					<fo:table-cell column-number="1" display-align="after" xsl:use-attribute-sets="header left right bottom"><fo:block><xsl:text>Neuron ID </xsl:text></fo:block></fo:table-cell>
					<fo:table-cell column-number="2" display-align="after" xsl:use-attribute-sets="header left right bottom"><fo:block><xsl:text>Bias </xsl:text></fo:block></fo:table-cell>
					<fo:table-cell column-number="3" xsl:use-attribute-sets="header left right top bottom"><fo:block>From </fo:block></fo:table-cell>
					<fo:table-cell column-number="4" xsl:use-attribute-sets="header left right top bottom"><fo:block>Weight</fo:block></fo:table-cell>
				</fo:table-row>
			</fo:table-header>
	
			<fo:table-body>
				<xsl:for-each select="Neuron">
					<xsl:element name="fo:table-row">
						<xsl:attribute name="background-color">
							<xsl:choose>
								<xsl:when test="position() mod 2 = 1">#FFFFFF</xsl:when>
								<xsl:otherwise>#EEEEEE</xsl:otherwise>
							</xsl:choose>
						</xsl:attribute>
			
						<fo:table-cell xsl:use-attribute-sets="cell left right top bottom"><fo:block>
							<xsl:value-of select="@id"/>
						</fo:block></fo:table-cell>

						<fo:table-cell xsl:use-attribute-sets="cell left right top bottom"><fo:block>
							<xsl:call-template name="roundNumber">
									<xsl:with-param name="string" select="Con[@from='0']/@weight" />
									<xsl:with-param name="decimalPattern" select="$decimalPattern" />
									<xsl:with-param name="scientificPattern" select="$scientificPattern" />
							</xsl:call-template>
						</fo:block></fo:table-cell>

						<fo:table-cell xsl:use-attribute-sets="cell left right top bottom"><fo:block>
							<fo:list-block>
								<xsl:for-each select="Con[@from!='0']">
									<fo:list-item>
										<fo:list-item-label><fo:block></fo:block></fo:list-item-label>
										<fo:list-item-body><fo:block><xsl:value-of select="@from" /></fo:block></fo:list-item-body>
									</fo:list-item>
								</xsl:for-each>
							</fo:list-block>
						</fo:block></fo:table-cell>

						<fo:table-cell xsl:use-attribute-sets="cell left right top bottom"><fo:block>
							<fo:list-block>
								<xsl:for-each select="Con[@from!='0']">
									<fo:list-item>
										<fo:list-item-label><fo:block></fo:block></fo:list-item-label>
										<fo:list-item-body><fo:block>
											<xsl:call-template name="roundNumber">
													<xsl:with-param name="string" select="@weight" />
													<xsl:with-param name="decimalPattern" select="$decimalPattern" />
													<xsl:with-param name="scientificPattern" select="$scientificPattern" />
											</xsl:call-template>
										</fo:block></fo:list-item-body>
									</fo:list-item>
								</xsl:for-each>
							</fo:list-block>
						</fo:block></fo:table-cell>

				  	</xsl:element>
				</xsl:for-each>
			</fo:table-body>
		</fo:table>
	</xsl:template>

	<!-- This table shows the LAST neuron hidden layer(s) -->
	<xsl:template match="NeuralLayer[last()]">
		<xsl:variable name="decimalPattern" select="../../DisplayOptions/@decimalPattern"/>
		<xsl:variable name="scientificPattern" select="../../DisplayOptions/@scientificPattern"/>

		<fo:table xsl:use-attribute-sets="table-atts"  space-after="5pt" table-layout="fixed">
			<fo:table-column column-number="1" column-width="100pt" />
			<fo:table-column column-number="2" column-width="100pt"/>
			<fo:table-column column-number="3" column-width="100pt" />
			<fo:table-column column-number="4" column-width="100pt" />

			<fo:table-header>
				<fo:table-row background-color="#CCE6FF">
					<fo:table-cell number-columns-spanned="4" xsl:use-attribute-sets="row-header left right top bottom"><fo:block><xsl:text>Output Layer</xsl:text></fo:block></fo:table-cell>
				</fo:table-row>
				<fo:table-row background-color="#CCE6FF">
					<fo:table-cell column-number="1" xsl:use-attribute-sets="header left right top"><fo:block><xsl:text>Output Layer: </xsl:text></fo:block></fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="header left right top"><fo:block><xsl:text></xsl:text></fo:block></fo:table-cell>
					<fo:table-cell number-columns-spanned="2" text-align="center" xsl:use-attribute-sets="header left right top bottom"><fo:block>Neuron Connection Weights</fo:block></fo:table-cell>
				</fo:table-row>
				<fo:table-row background-color="#CCE6FF">
					<fo:table-cell column-number="1" xsl:use-attribute-sets="header left right bottom"><fo:block><xsl:text>Neuron ID </xsl:text></fo:block></fo:table-cell>
					<fo:table-cell column-number="2" xsl:use-attribute-sets="header left right bottom"><fo:block><xsl:text>Bias </xsl:text></fo:block></fo:table-cell>
					<fo:table-cell column-number="3" xsl:use-attribute-sets="header left right top bottom"><fo:block>From </fo:block></fo:table-cell>
					<fo:table-cell column-number="4" xsl:use-attribute-sets="header left right top bottom"><fo:block>Weight</fo:block></fo:table-cell>
				</fo:table-row>
			</fo:table-header>
	
			<fo:table-body>
				<xsl:for-each select="Neuron">
					<xsl:element name="fo:table-row">
						<xsl:attribute name="background-color">
							<xsl:choose>
								<xsl:when test="position() mod 2 = 1">#FFFFFF</xsl:when>
								<xsl:otherwise>#EEEEEE</xsl:otherwise>
							</xsl:choose>
						</xsl:attribute>
			
						<fo:table-cell xsl:use-attribute-sets="cell left right top bottom"><fo:block>
							<xsl:value-of select="@id"/>
						</fo:block></fo:table-cell>

						<fo:table-cell xsl:use-attribute-sets="cell left right top bottom"><fo:block>
							<xsl:call-template name="roundNumber">
									<xsl:with-param name="string" select="Con[@from='0']/@weight" />
									<xsl:with-param name="decimalPattern" select="$decimalPattern" />
									<xsl:with-param name="scientificPattern" select="$scientificPattern" />
							</xsl:call-template>
						</fo:block></fo:table-cell>

						<fo:table-cell xsl:use-attribute-sets="cell left right top bottom"><fo:block>
							<fo:list-block>
								<xsl:for-each select="Con[@from!='0']">
									<fo:list-item>
										<fo:list-item-label><fo:block></fo:block></fo:list-item-label>
										<fo:list-item-body><fo:block><xsl:value-of select="@from" /></fo:block></fo:list-item-body>
									</fo:list-item>
								</xsl:for-each>
							</fo:list-block>
						</fo:block></fo:table-cell>

						<fo:table-cell xsl:use-attribute-sets="cell left right top bottom"><fo:block>
							<fo:list-block>
								<xsl:for-each select="Con[@from!='0']">
									<fo:list-item>
										<fo:list-item-label><fo:block></fo:block></fo:list-item-label>
										<fo:list-item-body><fo:block>
											<xsl:call-template name="roundNumber">
													<xsl:with-param name="string" select="@weight" />
													<xsl:with-param name="decimalPattern" select="$decimalPattern" />
													<xsl:with-param name="scientificPattern" select="$scientificPattern" />
											</xsl:call-template>
										</fo:block></fo:list-item-body>
									</fo:list-item>
								</xsl:for-each>
							</fo:list-block>
						</fo:block></fo:table-cell>

				  	</xsl:element>
				</xsl:for-each>
			</fo:table-body>
		</fo:table>
	</xsl:template>


	<xsl:template name="roundNumber">
		<xsl:param name="string" select="''" />
		<xsl:param name="decimalPattern" select="''" />
		<xsl:param name="scientificPattern" select="''" />

	   	<xsl:variable name="lowerCasePattern" select="'e'" />
	   	<xsl:variable name="upperCasePattern" select="'E'" />

		<xsl:choose>
		      <xsl:when test="not(boolean($decimalPattern))">
		      		<xsl:value-of select="$string" />
		      </xsl:when>
		      <xsl:when test="contains($string, $lowerCasePattern)">
			    <xsl:call-template name="outputRoundedScientific">
			        <xsl:with-param name="valueString" select="substring-before($string, $lowerCasePattern)" />
			        <xsl:with-param name="exponentString" select="substring-after($string, $lowerCasePattern)" />
		     		<xsl:with-param name="decimalPattern" select="$decimalPattern" />
			    </xsl:call-template>
 			  </xsl:when>
		      <xsl:when test="contains($string, $upperCasePattern)">
			    <xsl:call-template name="outputRoundedScientific">
			        <xsl:with-param name="valueString" select="substring-before($string, $upperCasePattern)" />
			        <xsl:with-param name="exponentString" select="substring-after($string, $upperCasePattern)" />
		     		<xsl:with-param name="decimalPattern" select="$decimalPattern" />
			    </xsl:call-template>
 			  </xsl:when>
		      <xsl:otherwise>
		      	 <xsl:choose>
				<xsl:when test="format-number($string, $decimalPattern) != format-number(0, $decimalPattern)">
					<xsl:value-of select="format-number($string, $decimalPattern)"/>
				</xsl:when>
				<xsl:when test="$string = 0">
					<xsl:value-of select="format-number($string, $decimalPattern)"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="format-number($string, $scientificPattern)"/>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:text>  </xsl:text>
		      </xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="outputRoundedScientific">
		<xsl:param name="valueString" select="''" />
		<xsl:param name="exponentString" select="''" />
		<xsl:param name="decimalPattern" select="''" />
		<xsl:value-of select="format-number($valueString, $decimalPattern)" />E<xsl:value-of select="format-number($exponentString, '#0')"/>
	</xsl:template>

</xsl:stylesheet>
