<?xml version='1.0' encoding='UTF-8' ?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- XSL style sheet for cluster element -->

	<xsl:template match="XML">
		<xsl:apply-templates select="IMML"/>
	</xsl:template>

	<xsl:template match="IMML">
		<html>
			<title>
				<xsl:value-of select="DisplayOptions/@title"/>
			</title>
			<style type="text/css">
				<xsl:value-of select="CSSText/text()"/>
			</style>
			<body>
				<h2 class="title"><xsl:value-of select="DisplayOptions/@title"/></h2>
				<xsl:apply-templates select="ClusteringModel"/>
			</body>
		</html>
	</xsl:template>

<!-- cluster center -->
	<xsl:template match="ClusteringModel">
		<xsl:variable name="decimalPattern" select="../DisplayOptions/@decimalPattern"/>
		<xsl:variable name="scientificPattern" select="../DisplayOptions/@scientificPattern"/>

		<H2 class="subtitle">Clustering with K-Means</H2>

		<div>
			<table cellSpacing="0" cellPadding="3" border="0">
				<tbody>
					<tr>
						<td class="tableBG">
							<H3 class="tableHead">Locations of Scaled Centers</H3>
							<table class="content" cellSpacing="1" cellPadding="5" border="0">
								<TR class="blueBG">
									<TH>Center</TH>
									<xsl:for-each select="ClusteringField">
										<TH style="text-align:right">
											<xsl:value-of select="@field"/>
										</TH>
									</xsl:for-each>
								</TR>

								<xsl:for-each select="Cluster">
									<xsl:element name="tr">
										<xsl:attribute name="class">
											<xsl:choose>
												<xsl:when test="position() mod 2 = 0">whiteBG</xsl:when>
												<xsl:otherwise>greyBG</xsl:otherwise>
											</xsl:choose>
										</xsl:attribute>

										<TH style="text-align:right">
											<xsl:value-of select="@number"/>
										</TH>
										<!-- cell -->
										<xsl:for-each select="Center/CenterField">
											<TD style="text-align:right" nowrap="true">
												<xsl:call-template name="roundNumber">
														<xsl:with-param name="string" select="@data" />
														<xsl:with-param name="decimalPattern" select="$decimalPattern" />
														<xsl:with-param name="scientificPattern" select="$scientificPattern" />
												</xsl:call-template>
											</TD>
										</xsl:for-each>
									</xsl:element>
								</xsl:for-each>
							</table>
						</td>
					</tr>
				</tbody>
			</table>
		</div>

		<H3> </H3>

		<!-- Input Scaling Factor-->
		<div>
			<table cellSpacing="0" cellPadding="3" border="0">
				<tbody>
					<tr>
						<td class="tableBG">
							<H3 class="tableHead">Column Scaling Factor</H3>
							<table class="content" cellSpacing="1" cellPadding="5" border="0">
								<TR class="blueBG">
									<xsl:for-each select="ClusteringField">
										<TH style="text-align:right">
											<xsl:value-of select="@field"/>
										</TH>
									</xsl:for-each>
								</TR>
								<xsl:for-each select="InputScaling">
									<xsl:element name="tr">
										<xsl:attribute name="class">
											<xsl:choose>
												<xsl:when test="position() mod 2 = 0">whiteBG</xsl:when>
												<xsl:otherwise>greyBG</xsl:otherwise>
											</xsl:choose>
										</xsl:attribute>

										<!-- cell -->
										<xsl:for-each select="InputScalingField">
											<TD style="text-align:right" nowrap="true">
												<xsl:call-template name="roundNumber">
														<xsl:with-param name="string" select="@data" />
														<xsl:with-param name="decimalPattern" select="$decimalPattern" />
														<xsl:with-param name="scientificPattern" select="$scientificPattern" />
												</xsl:call-template>
											</TD>
										</xsl:for-each>
									</xsl:element>
								</xsl:for-each>
							</table>
						</td>
					</tr>
				</tbody>
			</table>
		</div>

		<H3> </H3>

		<!-- cluster size, withinSS/Size and withinSS-->
		<div>
			<table cellSpacing="0" cellPadding="3" border="0">
				<tbody>
					<tr>
						<td class="tableBG">
							<H3 class="tableHead">Cluster size and within cluster sum of squares (Sum Squares)</H3>
							<table class="content" cellSpacing="1" cellPadding="5" border="0">
								<TR class="blueBG">
									<TH>Center</TH>
									<TH style="text-align:right">Size(%)</TH>
									<TH style="text-align:right">Size(N)</TH>
									<TH style="text-align:right">Sum Squares</TH>
									<TH style="text-align:right">Sum Squares / Size</TH>
								</TR>
								<xsl:for-each select="Cluster">
									<xsl:element name="tr">
										<xsl:attribute name="class">
											<xsl:choose>
												<xsl:when test="position() mod 2 = 0">whiteBG</xsl:when>
												<xsl:otherwise>greyBG</xsl:otherwise>
											</xsl:choose>
										</xsl:attribute>

										<TH style="text-align:right">
											<xsl:value-of select="@number"/>
										</TH>
										<TD style="text-align:right">
											<xsl:value-of select="format-number(@sizeInPercent, $decimalPattern)"/>
										</TD>
										<TD style="text-align:right">
											<xsl:number value="@size" grouping-size="3"/>
										</TD>
										<TD style="text-align:right" nowrap="true">
											<xsl:call-template name="roundNumber">
													<xsl:with-param name="string" select="@withinSS" />
													<xsl:with-param name="decimalPattern" select="$decimalPattern" />
													<xsl:with-param name="scientificPattern" select="$scientificPattern" />
											</xsl:call-template>
										</TD>
										<TD style="text-align:right" nowrap="true">
											<xsl:call-template name="roundNumber">
													<xsl:with-param name="string" select="@withinSSOverSize" />
													<xsl:with-param name="decimalPattern" select="$decimalPattern" />
													<xsl:with-param name="scientificPattern" select="$scientificPattern" />
											</xsl:call-template>
										</TD>
									</xsl:element>
								</xsl:for-each>
								<TR class="blueBG">
									<TH>Total</TH>
									<TD style="text-align:right" nowrap="true">
										<xsl:value-of select="format-number(100.00, $decimalPattern)"/>
									</TD>
									<xsl:for-each select="Total">
										<TD style="text-align:right">
											<xsl:number value="@size" grouping-size="3"/>
										</TD>
										<TD style="text-align:right" nowrap="true">
											<xsl:call-template name="roundNumber">
													<xsl:with-param name="string" select="@sumSq" />
													<xsl:with-param name="decimalPattern" select="$decimalPattern" />
													<xsl:with-param name="scientificPattern" select="$scientificPattern" />
											</xsl:call-template>
										</TD>
										<TD style="text-align:right" nowrap="true">
											<xsl:call-template name="roundNumber">
													<xsl:with-param name="string" select="@sumSqOverSize" />
													<xsl:with-param name="decimalPattern" select="$decimalPattern" />
													<xsl:with-param name="scientificPattern" select="$scientificPattern" />
											</xsl:call-template>
										</TD>
									</xsl:for-each>
								</TR>
							</table>
						</td>
					</tr>
				</tbody>
			</table>
		</div>

	</xsl:template>

	<xsl:template name="roundNumber">
		<xsl:param name="string" select="''" />
		<xsl:param name="decimalPattern" select="''" />
		<xsl:param name="scientificPattern" select="''" />

	   	<xsl:variable name="lowerCasePattern" select="'e'" />
	   	<xsl:variable name="upperCasePattern" select="'E'" />

		<xsl:choose>
		      <xsl:when test="contains($string, $lowerCasePattern)">
			    <xsl:call-template name="outputRoundedScientific">
			        <xsl:with-param name="valueString" select="substring-before($string, $lowerCasePattern)" />
			        <xsl:with-param name="exponentString" select="substring-after($string, $lowerCasePattern)" />
		     		<xsl:with-param name="decimalPattern" select="$decimalPattern" />
			    </xsl:call-template>
 			  </xsl:when>
		      <xsl:when test="contains($string, $upperCasePattern)">
			    <xsl:call-template name="outputRoundedScientific">
			        <xsl:with-param name="valueString" select="substring-before($string, $upperCasePattern)" />
			        <xsl:with-param name="exponentString" select="substring-after($string, $upperCasePattern)" />
		     		<xsl:with-param name="decimalPattern" select="$decimalPattern" />
			    </xsl:call-template>
 			  </xsl:when>
		      <xsl:otherwise>
		      	 <xsl:choose>
				<xsl:when test="format-number($string, $decimalPattern) != format-number(0, $decimalPattern)">
					<xsl:value-of select="format-number($string, $decimalPattern)"/>
				</xsl:when>
				<xsl:when test="$string = 0">
					<xsl:value-of select="format-number($string, $decimalPattern)"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="format-number($string, $scientificPattern)"/>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:text>  </xsl:text>
		      </xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="outputRoundedScientific">
		<xsl:param name="valueString" select="''" />
		<xsl:param name="exponentString" select="''" />
		<xsl:param name="decimalPattern" select="''" />
		<xsl:value-of select="format-number($valueString, $decimalPattern)" />E<xsl:value-of select="format-number($exponentString, '#0')"/>
	</xsl:template>

</xsl:stylesheet>
