#!/bin/sh

# Copyright (c) 2002, 2006 Insightful, Inc.  All rights reserved.

#
#  Build script for sample S-PLUS EJB model.  This might be better 
#  accomplished using makefiles or ant scripts, but for simplicity and
#  clarity, a single shell script is presented here.
#

if [ -z "$JAVA_HOME" ]
then
	echo "The JAVA_HOME environmental variable must be set"
	exit 1
fi

if [ -z "$JBOSS_HOME" ]
then
	echo "The JBOSS_HOME environmental variable must be set"
	exit 1
fi

if [ "x$SHOME" = "x" ]
then
	echo "The SHOME environmental variable must be set"
	exit 1
fi

CLASSPATH=.:"$SHOME"/java/Splus.jar:"$JBOSS_HOME"/lib/ext/jboss-j2ee.jar
export CLASSPATH

echo "Building SplusEngineException.java"
"$JAVA_HOME"/bin/javac ejbsplus/SplusEngineException.java

echo "Building SplusEngineClient.java"
"$JAVA_HOME"/bin/javac ejbsplus/SplusEngineClient.java

echo "Building SplusEngine.java"
"$JAVA_HOME"/bin/javac ejbsplus/SplusEngine.java

echo "Building SplusEngineHome.java"
"$JAVA_HOME"/bin/javac ejbsplus/SplusEngineHome.java

echo "Building SplusEngineEJB.java"
"$JAVA_HOME"/bin/javac ejbsplus/SplusEngineEJB.java

echo "Creating SplusEngine.jar"
"$JAVA_HOME"/bin/jar cvf SplusEngine.jar META-INF/ ejbsplus/*.class

echo "Deploying SplusEngine.jar to $JBOSS_HOME/deploy"
cp SplusEngine.jar $JBOSS_HOME/deploy
