package com.insightful.splus.statdlg;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import com.insightful.controls.*;
import com.insightful.splus.SplusDataSetComboBox;
import com.insightful.splus.SplusDataColumnComboBox;
import com.insightful.splus.SplusSubsetField;
import com.insightful.splus.SplusDataColumnListBox;
import com.insightful.splus.SplusWideFormulaField;

public class LinearRegressionDialog extends SplusDialog {

    // Any controls referenced by listeners must be defined here.
    // Be sure not to declare their class in the constructor.

    SplusDataSetComboBox dataSet;
    SplusDataColumnComboBox dependentColumn, weightsColumn;
    SplusDataColumnListBox independentColumnList;
    SplusWideFormulaField formulaField;
    SplusButton formulaButton;

    SplusCheckBox longOutput, correlationMatrix,
	plotPartialResid, includeFitPartialResid, 
	rugplotPartialResid, scalePartialResid;

    public LinearRegressionDialog() {
	super("Linear Regression");

	// A two page dialog with two columns.
	// The first page has a wide group along the bottom which spans
	// both columns.  

	// Controls and groups get added to the columns
	
	JTabbedPane tabbedPane = new JTabbedPane();

	/* Information needed to construct function call */
	SplusFunctionInfo funcInfo = new SplusFunctionInfo("menuLm");
	setFunctionInfo(funcInfo);


	/* Model Page */

	JPanel modelPage = new JPanel();
	tabbedPane.addTab("Model", modelPage);
	Box modelTopPanel = new Box(BoxLayout.X_AXIS);
	Box modelBottomPanel = new Box(BoxLayout.X_AXIS);
	Box modelTopLeftColumn = new Box(BoxLayout.Y_AXIS);
	Box modelTopRightColumn = new Box(BoxLayout.Y_AXIS);
	modelTopPanel.add(modelTopLeftColumn);
	modelTopPanel.add(modelTopRightColumn);

	modelPage.setLayout(new BoxLayout(modelPage, BoxLayout.Y_AXIS));
	modelPage.add(modelTopPanel);
	modelPage.add(modelBottomPanel);

	// Data group

	SplusGroupPanel dataGroup = new SplusGroupPanel("Data");
	modelTopLeftColumn.add(dataGroup);

	dataSet = new SplusDataSetComboBox();
	dataGroup.add(dataSet);
	funcInfo.add(dataSet, "data");

	weightsColumn = new 
	    SplusDataColumnComboBox("Weights", 'W', dataSet);
	weightsColumn.setValue("");
	dataGroup.add(weightsColumn);
	funcInfo.add(weightsColumn, "weights", true);

	SplusSubsetField subsetRows = new SplusSubsetField();
	dataGroup.add(subsetRows);
	funcInfo.add(subsetRows, "subset");

	SplusCheckBox omitMissing = new 
	    SplusCheckBox("Omit Rows with Missing Values", 'M');
	omitMissing.setValue("T");
	dataGroup.add(omitMissing);
	funcInfo.add(omitMissing, "na.omit.p");

	// Right column

	// Spacer for right column

	modelTopRightColumn.add(new SplusBoxFiller(8));

	// Save Model Object group

	SplusGroupPanel saveModelGroup = new
	    SplusGroupPanel("Save Model Object");
	modelTopRightColumn.add(saveModelGroup);
	
	SplusTextField saveAsField = new
	    SplusTextField("Save As", 'S');
	saveModelGroup.add(saveAsField);
	funcInfo.setResultControl(saveAsField);

	// Variables group

	// Dependent and Independent columns are used to build formula

	SplusGroupPanel variablesGroup = new SplusGroupPanel("Variables");
	modelBottomPanel.add(variablesGroup);

	dependentColumn = new SplusDataColumnComboBox("Dependent", 'E',
						      dataSet);
	dependentColumn.setValue("");
	variablesGroup.add(dependentColumn);
	funcInfo.add(dependentColumn, "");

	independentColumnList = new 
	    SplusDataColumnListBox("Independent", 'I', dataSet);
	independentColumnList.setPrepend(new String [] {"<ALL>"});
	variablesGroup.add(independentColumnList);
	funcInfo.add(independentColumnList, "");

	formulaField = new SplusWideFormulaField();
	variablesGroup.add(formulaField);
	funcInfo.add(formulaField, "formula");

	// Add listeners to Dependent and Independent to build formula

	dependentColumn.addActionListener(new ActionListener(){
		public void actionPerformed(ActionEvent ae){
		    formulaField.setDependentValue(dependentColumn.getValue());
		}
	    });

	independentColumnList.addListSelectionListener(new 
	    ListSelectionListener() {
		public void valueChanged(ListSelectionEvent e){
		    formulaField.setIndependentValue(independentColumnList.getValue());
		}
	    });

	// Have button disable relevant fields and launch formula builder.

	formulaButton = new SplusButton("Create Formula", 'C');

	formulaButton.addActionListener(new ActionListener(){
		public void actionPerformed(ActionEvent ae){
		    (new RegressionFormulaDialog(formulaField, 
			 dataSet, RegressionFormulaDialog.TYPE_LM)).show();
		}
	    });

	// Put button in a box for layout

	Box formulaButtonBox = new Box(BoxLayout.X_AXIS);
	formulaButtonBox.add(Box.createHorizontalStrut(5));
	formulaButtonBox.add(formulaButton);
	formulaButtonBox.add(Box.createHorizontalGlue());

	variablesGroup.add(Box.createVerticalStrut(5));
	variablesGroup.add(formulaButtonBox);
	variablesGroup.add(Box.createVerticalStrut(5));

	// bottom spacer
	modelPage.add(new SplusWideBoxFiller(10));


	/* Results page */

	JPanel resultsPage = new JPanel();
	tabbedPane.addTab("Results", resultsPage);
	Box resultsColumnOne = new Box(BoxLayout.Y_AXIS);
	Box resultsColumnTwo = new Box(BoxLayout.Y_AXIS);

	resultsPage.setLayout(new BoxLayout(resultsPage, BoxLayout.X_AXIS));
	resultsPage.add(resultsColumnOne);
	resultsPage.add(resultsColumnTwo);

	// Printed Results group

	SplusGroupPanel printedResultsGroup = 
	    new SplusGroupPanel("Printed Results");
	resultsColumnOne.add(printedResultsGroup);

	SplusCheckBox shortOutput = new SplusCheckBox("Short Output", 'S');
	printedResultsGroup.add(shortOutput);
	funcInfo.add(shortOutput, "print.short.p");

	longOutput = new SplusCheckBox("Long Output", 'L');
	longOutput.setValue("T");
	printedResultsGroup.add(longOutput);
	funcInfo.add(longOutput, "print.long.p");

	SplusCheckBox anovaTable = new SplusCheckBox("ANOVA Table", 'A');
	printedResultsGroup.add(anovaTable);
	funcInfo.add(anovaTable, "print.anova.p");

	correlationMatrix = new
	    SplusCheckBox("Correlation Matrix of Estimates", 'C');
	printedResultsGroup.add(correlationMatrix);
	funcInfo.add(correlationMatrix, "print.correlation.p");

	// Disable correlationMatrix if no Long Output

	longOutput.addActionListener(new ActionListener(){
		public void actionPerformed(ActionEvent ae){
		    correlationMatrix.setEnabled(longOutput.getValue().equals("T"));
		}
	    });

	// spacer 

	resultsColumnOne.add(new SplusBoxFiller());

	// Saved Results group

	SplusGroupPanel savedResultsGroup = new
	    SplusGroupPanel("Saved Results");
	resultsColumnTwo.add(savedResultsGroup);

	SplusDataSetComboBox saveResultsIn = new
	    SplusDataSetComboBox("Save In", 'I');
	saveResultsIn.setValue("");
	savedResultsGroup.add(saveResultsIn);
	funcInfo.add(saveResultsIn, "save.name", true);

	SplusCheckBox saveFittedValues = new
	    SplusCheckBox("Fitted Values", 'F');
	savedResultsGroup.add(saveFittedValues);
	funcInfo.add(saveFittedValues, "save.fit.p");

	SplusCheckBox saveResiduals = new
	    SplusCheckBox("Residuals", 'R');
	savedResultsGroup.add(saveResiduals);
	funcInfo.add(saveResiduals, "save.resid.p");

	// spacer 

	resultsColumnTwo.add(new SplusBoxFiller());


	/* Plot page */

	JPanel plotPage = new JPanel();
	tabbedPane.addTab("Plot", plotPage);
	Box plotColumnOne = new Box(BoxLayout.Y_AXIS);
	Box plotColumnTwo = new Box(BoxLayout.Y_AXIS);

	plotPage.setLayout(new BoxLayout(plotPage, BoxLayout.X_AXIS));
	plotPage.add(plotColumnOne);
	plotPage.add(plotColumnTwo);

	// Which Plots group

	SplusGroupPanel whichPlotsGroup = 
	    new SplusGroupPanel("Plots");
	plotColumnOne.add(whichPlotsGroup);
	
	SplusCheckBox plotResidVsFit = new 
	    SplusCheckBox("Residuals vs Fit", 'R');
	whichPlotsGroup.add(plotResidVsFit);
	funcInfo.add(plotResidVsFit, "plotResidVsFit.p");

	SplusCheckBox plotSqrtAbsResid = new
	    SplusCheckBox("Sqrt Abs Residuals vs Fit", 'Q');
	whichPlotsGroup.add(plotSqrtAbsResid);
	funcInfo.add(plotSqrtAbsResid, "plotSqrtAbsResid.p");

	SplusCheckBox plotResponseVsFit = new
	    SplusCheckBox("Response vs Fit", 'P');
	whichPlotsGroup.add(plotResponseVsFit);
	funcInfo.add(plotResponseVsFit, "plotResponseVsFit.p");

	SplusCheckBox plotQQ = new
	    SplusCheckBox("Residuals Normal QQ", 'Q');
	whichPlotsGroup.add(plotQQ);
	funcInfo.add(plotQQ, "plotQQ.p");

	SplusCheckBox plotRFSpread = new
	    SplusCheckBox("Residual-Fit Spread", 'S');
	whichPlotsGroup.add(plotRFSpread);
	funcInfo.add(plotRFSpread, "plotRFSpread.p");

	SplusCheckBox plotCooks = new
	    SplusCheckBox("Cook's Distance", 'C');
	whichPlotsGroup.add(plotCooks);
	funcInfo.add(plotCooks, "plotCooks.p");

	plotPartialResid = new SplusCheckBox("Partial Residuals", 'P');
	whichPlotsGroup.add(plotPartialResid);
	funcInfo.add(plotPartialResid, "plotPartialResid.p");

	// spacer 

	plotColumnOne.add(new SplusBoxFiller());


	// Options group

	SplusGroupPanel plotOptionsGroup = new SplusGroupPanel("Options");
	plotColumnTwo.add(plotOptionsGroup);
	
	SplusCheckBox optionIncludeSmooth = new 
	    SplusCheckBox("Include Smooth", 'M');
	optionIncludeSmooth.setValue("T");
	plotOptionsGroup.add(optionIncludeSmooth);
	funcInfo.add(optionIncludeSmooth, "smooths.p");

	SplusCheckBox optionIncludeRugplot = new
	    SplusCheckBox("Include Rugplot", 'G');
	plotOptionsGroup.add(optionIncludeRugplot);
	funcInfo.add(optionIncludeRugplot, "rugplot.p");

	SplusTextField optionNumberId = new
	    SplusTextField("Number of Extreme Points to Identify:", 'X');
	optionNumberId.setValue("3");
	plotOptionsGroup.add(optionNumberId);
	funcInfo.add(optionNumberId, "id.n");

	// Partial Residual Plot Options group

	SplusGroupPanel partialResidualOptionsGroup = new
	    SplusGroupPanel("Partial Residual Plot Options");
	plotColumnTwo.add(partialResidualOptionsGroup);

	includeFitPartialResid = new SplusCheckBox("Include Partial Fit", 'F');
	includeFitPartialResid.setEnabled(false);
	partialResidualOptionsGroup.add(includeFitPartialResid);
	funcInfo.add(includeFitPartialResid, "plotPartialFit.p");

	rugplotPartialResid = new SplusCheckBox("Include Rugplot", 'T');
	rugplotPartialResid.setEnabled(false);
	partialResidualOptionsGroup.add(rugplotPartialResid);
	funcInfo.add(rugplotPartialResid, "rugplotPartialResid.p");

	scalePartialResid = new SplusCheckBox("Common Y-axis Scale");
	scalePartialResid.setValue("T");
	scalePartialResid.setEnabled(false);
	partialResidualOptionsGroup.add(scalePartialResid);
	funcInfo.add(scalePartialResid, "scalePartialResid.p");

	// Enable options only when plotPartialResid

	plotPartialResid.addActionListener( new ActionListener(){
		public void actionPerformed(ActionEvent ae){
		    boolean enableState = plotPartialResid.getValue().equals("T");
		    includeFitPartialResid.setEnabled(enableState);
		    rugplotPartialResid.setEnabled(enableState);
		    scalePartialResid.setEnabled(enableState);
		}
	    });


	// spacer 

	plotColumnTwo.add(new SplusBoxFiller());


	/* Predict page */

	JPanel predictPage = new JPanel();
	tabbedPane.addTab("Predict", predictPage);
	Box predictColumnOne = new Box(BoxLayout.Y_AXIS);
	Box predictColumnTwo = new Box(BoxLayout.Y_AXIS);

	predictPage.setLayout(new BoxLayout(predictPage, BoxLayout.X_AXIS));
	predictPage.add(predictColumnOne);
	predictPage.add(predictColumnTwo);

	// New data field has no group

	SplusGroupPanel predictNewDataGroup = new SplusGroupPanel("");
	predictColumnOne.add(predictNewDataGroup);

	SplusDataSetComboBox predictNewData = new
	    SplusDataSetComboBox("New Data", 'N');
	predictNewData.setValue("");
	predictNewDataGroup.add(predictNewData);
	funcInfo.add(predictNewData, "newdata");
	
	// Save group

	SplusGroupPanel predictSaveGroup = new 
	    SplusGroupPanel("Save");
	predictColumnOne.add(predictSaveGroup);

	SplusDataSetComboBox predictSaveIn = new
	    SplusDataSetComboBox("Save In", 'I');
	predictSaveIn.setValue("");
	predictSaveGroup.add(predictSaveIn);
	funcInfo.add(predictSaveIn, "predobj.name", true);
	
	SplusCheckBox predictSavePredictions = new
	    SplusCheckBox("Predictions", 'P');
	predictSaveGroup.add(predictSavePredictions);
	funcInfo.add(predictSavePredictions, "predict.p");

	SplusCheckBox predictSaveConfInt = new
	    SplusCheckBox("Confidence Intervals", 'C');
	predictSaveGroup.add(predictSaveConfInt);
	funcInfo.add(predictSaveConfInt, "ci.p");

	SplusCheckBox predictSaveStdError = new
	    SplusCheckBox("Standard Errors", 'S');
	predictSaveGroup.add(predictSaveStdError);
	funcInfo.add(predictSaveStdError, "se.p");

	// spacer 

	predictColumnOne.add(new SplusBoxFiller());


	// Options group

	SplusGroupPanel predictOptionsGroup = new
	    SplusGroupPanel("Options");
	predictColumnTwo.add(predictOptionsGroup);
	
	SplusTextField predictConfLevel = new
	    SplusTextField("Confidence Level", 'L');
	predictConfLevel.setValue("0.95");
	predictOptionsGroup.add(predictConfLevel);
	funcInfo.add(predictConfLevel, "conf.level");

	// spacer 

	predictColumnTwo.add(new SplusBoxFiller());

	// add center panel

	setCenterPanel(tabbedPane);

    }

  // Redefine isComplete() to check for required arguments.

  public boolean isComplete() {
    return (warnIfEmpty(dataSet) && warnIfEmpty(formulaField));
  }

}

