### Name: rtfWriteOutTableText
### Title: rtfWriteOutTableText
### Aliases: rtfWriteOutTableText
### Keywords: rtf table

### ** Examples

library(rtftools)

rtfFile <- "mytest.rtf"

cat(file=rtfFile, rtfInit(bLandscape=T), append=F)

# create sample data.frame
mydf <- data.frame(myCol1=format(rnorm(20), digits=3, justify="n"), 
                        myCol2=format(rnorm(20), digits=3, justify="n"), 
                        myCol3=format(rnorm(20), digits=3, justify="n"), 
                        myCol4=format(rnorm(20), digits=3, justify="n"), stringsAsFactors=F)

tableInit <- rtfTableInit(ncol(mydf), colwidth=rep(1000, ncol(mydf)), fontsize=10)

rtfWriteOutTableText(mydf, rtfFile, tableInit, "Table ", titl="Test splitting of table across pages",
    dimnames(mydf)[[2]], sortCol="myCol1", summStartRow=0,
    maxColumnsPage=3, maxRowsPage=10, 
    tableHeader=NULL, 
    cellBorder=rep(list(rep(SOLIDCELLBORDER,4)), tableInit$numCols))
 
rtfClose(rtfFile)



