/*
	Connect/C++ : Copyright (c) 2001, 2006 Insightful Corp.
	All rights reserved.
	Version 6.0: 2001
*/

#include "sconnect_gen.h"
#include "sconnect.h"

CSPobject * SCONNECT_GenerateFromSObject( s_object *ps_object, int bFactorsAsStrings )
{
	CSPobject * spObject = NULL;
	if ( SPL_NotThere( ps_object ) )
		return spObject;

	try
	{
		CSPevaluator sEvaluator;

		if ( IS(ps_object, s_matrix_class) )
		{
			switch(GET_DATA(ps_object)->mode)
			{
				case S_MODE_LGL:
				{
					spObject = (CSPobject *)(new CSPlogicalMatrix(ps_object));
					break;
				}
				case S_MODE_INT:
				{
					spObject = (CSPobject *)(new CSPintegerMatrix(ps_object));
					break;
				}
				case S_MODE_REAL:
				{
					spObject = (CSPobject *)(new CSPsingleMatrix(ps_object));
					break;
				}
				case S_MODE_DOUBLE:
				{
					spObject = (CSPobject *)(new CSPnumericMatrix(ps_object));
					break;
				}
				case S_MODE_CHAR:
				{
					spObject = (CSPobject *)(new CSPcharacterMatrix(ps_object));
					break;
				}
				case S_MODE_COMPLEX:
				{
					spObject = (CSPobject *)(new CSPcomplexMatrix(ps_object));
					break;
				}
				case S_MODE_RAW:
				{
					spObject = (CSPobject *)(new CSPrawMatrix(ps_object));
					break;
				}
				default:
				{
					throw SCONNECT_INVALID_SOBJECT;
					break;
				}
			}
		}
#ifdef WIN32
		else if ( IS(ps_object, MAKE_CLASS("OLEClient")) )
		{
			spObject = (CSPobject *)(new CSPoleclient( ps_object ));
		}
#endif
		else if ( IS_CHARACTER(ps_object) )
		{
			spObject = (CSPobject *)(new CSPcharacter( ps_object ));
		}
		else if ( IS_INTEGER(ps_object) )
		{
			spObject = (CSPobject *)(new CSPinteger( ps_object ));
		}
		else if ( IS_LOGICAL(ps_object) )
		{
			spObject = (CSPobject *)(new CSPlogical( ps_object ));
		}
		else if ( IS_NUMERIC(ps_object) )
		{
			spObject = (CSPobject *)(new CSPnumeric( ps_object ));
		}

		else if ( IS(ps_object, MAKE_CLASS("factor")) && bFactorsAsStrings != 0 )
		{
			spObject = (CSPobject *)(new CSPcharacter( ps_object ));
		}

		else if ( IS_LIST(ps_object) )
		{
			spObject = (CSPobject *)(new CSPlist( ps_object ));
		}
		else
		{
			spObject = (CSPobject *)(new CSPvector( ps_object ));
		}
	}
	catch(...)
	{
		throw; //Re-throw
	}
	return spObject;
}

