/*
	Connect/C++ : Copyright (c) 2001, 2006 Insightful Corp.
	All rights reserved.
	Version 6.0: 2001

	splog.h: interface for the CSPlogical class.
*/

#if !defined(__SCONNECT_SPLOG_H_INCLUDED__)
#define __SCONNECT_SPLOG_H_INCLUDED__

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "spvector.h"

class SCONNECT_LIB_EXTERN CSPlogical : public TSPvector<long, S_MODE_LGL> 
{
//////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////
public:
	//Default constructor
	CSPlogical();
	//Copy constructor: copy appropriate data members
	CSPlogical(const CSPlogical& sObject);
	//Construct from object of a base class
	CSPlogical(const CSPobject& sObject);
	//Construct from a valid S-expression
	explicit CSPlogical(const char* pszExpression);
	//Construct frmo an S object pointer  
	explicit CSPlogical(s_object* ps_object, BOOL bTryToFreeOnDetach=FALSE);
	//Assign from the same class
	CSPlogical& operator=(const CSPlogical& sObject);
	//Assign from the base class
	CSPlogical& operator=(const CSPobject& sObject);
	//Assign from an S object
	CSPlogical& operator=(s_object* ps_object);
	//The destructor
	virtual ~CSPlogical();

	//Construct a 'logical' vector 
	explicit CSPlogical(long lLength);
	explicit CSPlogical(int  nLength);
	explicit CSPlogical(long* plValues, long lLength=1);
	CSPlogical(long* plValues, int  nLength);
	explicit CSPlogical(int*  pnValues, long lLength=1);
	CSPlogical(int*  pnValues, int  nLength);

//////////////////////////////////////////////////////
// Attributes
//////////////////////////////////////////////////////
public:

	//Direct access to elements of character vector (ZERO-BASED INDEX). Use it carefully!
	void SetAtDirect(long lIndex, long lElement, BOOL bValidate=TRUE);
	void SetAtDirect(long* plValues, long lStartIndex, long lEndIndex, BOOL bValidate=TRUE);
	void SetAtDirect(int* pnValues, long lStartIndex, long lEndIndex, BOOL bValidate=TRUE);

#ifdef WIN32
	#include "splog_com.h"
#endif

};

#endif // !defined(__SCONNECT_SPLOG_H_INCLUDED__)
