/*
	Connect/C++ : Copyright (c) 2001, 2006 Insightful Corp.
	All rights reserved.
	Version 6.0: 2001
 
	spnamed.cxx: implementation of the CSPnamed class wrapping S-PLUS object of class "named".
*/

#include "S_y_tab.h"
#include "string.h"
#include "spnamed.h"
#include "sconnect.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

//Default constructor
CSPnamed::CSPnamed()
: CSPstructure()
{
}
//Copy constructor 
CSPnamed::CSPnamed(const CSPnamed& sObject)
: CSPstructure()
{
	Attach(&sObject, sObject.GetTryToFreeOnDetach());
}
//Construct from a base class object
CSPnamed::CSPnamed(const CSPobject& sObject)
: CSPstructure()
{	
	Attach(&sObject, sObject.GetTryToFreeOnDetach());
}
//Construct from a valid S-expression
CSPnamed::CSPnamed(const char* pszExpression)
: CSPstructure()
{
	CSPevaluator sEvaluator;
	s_object* ps_value = sEvaluator.Eval(pszExpression);
	Attach(sEvaluator.CloneIfNeeded(ps_value), TRUE);
}
//Construct from an S object 
CSPnamed::CSPnamed(s_object* ps_object, BOOL bTryToFreeOnDetach)
: CSPstructure()
{
	Attach(ps_object, bTryToFreeOnDetach);
}

//Assigment operator
CSPnamed& CSPnamed::operator=(const CSPnamed& sObject)
{
	Attach(&sObject, sObject.GetTryToFreeOnDetach());
	return *this;
}
//Assigment from the base class
CSPnamed& CSPnamed::operator=(const CSPobject& sObject)
{
	Attach(&sObject, sObject.GetTryToFreeOnDetach());
	return *this;
}
//Assigment operator
CSPnamed& CSPnamed::operator=(s_object* ps_object)
{
	Attach(ps_object, FALSE);
	return *this;
}

CSPnamed::CSPnamed(long lLength)
: CSPstructure()
{
	s_object* ps_object = new_S_object(s_named_class, S_evaluator);
	SET_LENGTH(ps_object, lLength);
	Attach(ps_object, TRUE);
}

CSPnamed::CSPnamed(int nLength)
: CSPstructure()
{
	s_object* ps_object = new_S_object(s_named_class, S_evaluator);
	SET_LENGTH(ps_object, (long)nLength);
	Attach(ps_object, TRUE);
}

CSPnamed::~CSPnamed()
{
}

//////////////////////////////////////////////////////
// Attributes
//////////////////////////////////////////////////////

//Return TRUE if the object is a valid 'numeric' class
BOOL CSPnamed::IsValid(void) const
{
	if(CSPstructure::IsValid()) 
		return IS(GetPtr(), s_named_class);
	return FALSE;
}

//Validate the evaluator
void CSPnamed::Validate(void) const
{
	if(!IsValid())
		SCONNECT_ThrowException("Invalid 'named' object\n");
}

long CSPnamed::GetLength(BOOL bValidate) const
{
	if(bValidate)
		Validate();
	return (long) GET_DATA(GetPtr())->length;
}

int CSPnamed::GetDataMode(BOOL bValidate) const
{
	if(bValidate)
		Validate();
	return (int) GET_DATA(GetPtr())->mode;
}

//Set/re-set length of numeric vector
void CSPnamed::SetLength(long lLength, BOOL bValidate)
{
	if ( GetPtr()==NULL || GET_DATA(GetPtr()) == NULL )
		ReAttachAndAssign(new_S_object(s_named_class, S_evaluator));
	if(bValidate)
		Validate();
	CSPevaluator sEvaluator;
	s_object* ps_object = sEvaluator.CopyForWrite(GetPtr());
	SET_LENGTH(ps_object, lLength);
	ReAttachAndAssign(ps_object);
}

BOOL CSPnamed::SetNames(s_object *ps_names, BOOL bValidate)
{
	if(bValidate)
		Validate();
	CSPevaluator sEvaluator;
	s_object* ps_object = sEvaluator.CopyForWrite(GetPtr());
	
	CSPcharacter schNames(ps_names);
	LIST_POINTER(ps_object)[1]	= schNames.Clone(); //Don't try to share this child, it does not worth saving mem.
	ReAttachAndAssign(ps_object);
	return TRUE;
}

s_object* CSPnamed::GetNames(BOOL bValidate) const
{
	if(bValidate)
		Validate();

	return GET_NAMES( GetPtr() );
}

void CSPnamed::Attach(s_object *ps_object, BOOL bTryToFreeOnDetach)
{
	BaseCoerceAttach(ps_object, s_named_class, bTryToFreeOnDetach);
}

