# Standard Perl modules:
use Getopt::Long ;

# Splus Perl modules:
use Splus::Vars ;
use Splus::SplusUtils ;

use strict;

my $opt_library ;
my $opt_help ;
my $opt_global ;
my @knownoptions = ("library|l:s", "help|h", 'global!') ;
GetOptions (@knownoptions) || usage() ;

if($opt_help) {
    usage() ;
    exit() ;
}

if(! $ARGV[0]) {
    die "Error in REMOVE: No package name supplied";
}

foreach my $pkg (@ARGV) {
    my $only_first = 1 ;
    my @dirs = find_package($pkg, $opt_library, $only_first, $opt_global) ;
    if (@dirs) {
       my $dir=@dirs[0];
       File::Path::rmtree("$dir",0,1) ;
       warn "Cannot remove $dir (permission problem?)" if -d $dir ;
    } else {
       warn "Cannot find package called $pkg, please supply -l libraryDir argument where libraryDir contains the package";
    }
}

sub usage() {
    print "Usage: Splus CMD REMOVE [options] pkg1 pkg2\n" ;
    print "\nRemove installed Spotfire S+ package\n" ;
    print "\nOptions:\n" ;
    print "-h,--help     # print this help message\n" ;
    print "-l,--library  # location to remove package from, default is\n";
    print "              #  first entry in \$S_LIBS or depends on --global\n" ;
    print "   --global   # If \$S_LIBS not defined, default library is\n";
    print "              # \$SHOME/local/library.\n" ;
    print "   --noglobal # If \$S_LIBS not defined, default library is in\n";
    print "              # ", get_default_user_library(), "\n" ;
    @_ && die join(", ", @_) ;
    exit() ;
}
