/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.util;

import amazon.fws.clicommando.exceptions.ConfigurationErrorException;
import amazon.fws.clicommando.exceptions.InternalErrorException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtils {
    public static final String lm = "   ";
    private static int numCols = 80;

    public static int getNumCols() {
        return numCols;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().equals("");
    }

    public static boolean isEmpty(Collection<String> str) {
        return str == null || str.size() <= 0;
    }

    public static boolean isEmpty(Map<String, String> str) {
        return str == null || str.size() <= 0;
    }

    public static boolean notEmpty(String str) {
        return !StringUtils.isEmpty(str);
    }

    public static boolean notEmpty(Collection<String> str) {
        return !StringUtils.isEmpty(str);
    }

    public static boolean notEmpty(Map<String, String> str) {
        return !StringUtils.isEmpty(str);
    }

    public static void validateAtLeastOneNotEmpty(String ... options) throws IllegalArgumentException {
        if (options == null || options.length == 0) {
            throw new ConfigurationErrorException("No arguments defined for validate several arguments");
        }
        for (String str : options) {
            if (!StringUtils.notEmpty(str)) continue;
            return;
        }
        throw new ConfigurationErrorException("All " + options.length + " arguments are empty");
    }

    public static String fixedLength(String input, int maxSize) {
        StringBuilder ret = new StringBuilder();
        String newInput = StringUtils.stripWSControlChars(input);
        int n = maxSize - newInput.length();
        if (n < 0) {
            if (maxSize < 7) {
                ret.append(newInput.substring(0, maxSize));
            } else if (maxSize < 12) {
                ret.append(newInput.substring(0, maxSize - 3) + "...");
            } else {
                int endIndex;
                int len = maxSize - 3;
                len = endIndex = len / 2;
                ret.append(newInput.substring(0, endIndex) + "...");
                endIndex = newInput.length();
                len = maxSize - len - 3;
                int startIndex = endIndex - len;
                ret.append(newInput.substring(startIndex, endIndex));
            }
        } else if (n == 0) {
            ret.append(newInput);
        } else {
            ret.append(String.format("%1$-" + maxSize + "s", newInput));
        }
        return ret.toString();
    }

    public static boolean toBoolean(String value) {
        boolean retVal = Boolean.parseBoolean(value);
        if (!retVal && !"false".equalsIgnoreCase(value)) {
            throw new ConfigurationErrorException(value + "does not translate to boolean");
        }
        return retVal;
    }

    public static Integer toInteger(String value) {
        Integer retVal;
        try {
            retVal = Integer.parseInt(value);
        }
        catch (Exception e) {
            throw new ConfigurationErrorException(value + "does not translate to an Integer");
        }
        return retVal;
    }

    public static String formatTextColumn(String input) {
        return StringUtils.formatTextColumn(input, lm);
    }

    public static String formatTextColumn(String input, String leftMargin) {
        return StringUtils.formatTextColumn(input.split(" "), leftMargin);
    }

    public static String formatTextColumn(String input, String leftMargin, boolean stripWS) {
        if (stripWS) {
            input = input.replace("\t", " ").replace("\n", " ").trim();
        }
        return StringUtils.formatTextColumn(input.split(" "), leftMargin);
    }

    public static String formatTextColumn(String[] words, String leftMargin) {
        StringBuilder ret = new StringBuilder();
        for (String w : words) {
            if (leftMargin.length() + w.length() <= numCols) continue;
            numCols = leftMargin.length() + w.length() + 1;
        }
        String row = leftMargin;
        int reprocessCnt = 0;
        for (int i = 0; i < words.length; ++i) {
            if (row.length() + words[i].length() < numCols) {
                row = row + " " + words[i];
                reprocessCnt = 0;
                continue;
            }
            if (reprocessCnt > 1) {
                throw new InternalErrorException("Would have gotten into infinite loop processing a string into " + numCols + "char column with margin: '" + leftMargin + "': String: \n" + Arrays.toString(words));
            }
            ret.append(row + "\n");
            row = leftMargin;
            --i;
            ++reprocessCnt;
        }
        ret.append(row);
        return ret.toString();
    }

    public static String[] removeEmptyEntries(String[] values) {
        if (values == null) {
            return null;
        }
        int count = 0;
        for (String v : values) {
            if (!StringUtils.notEmpty(v)) continue;
            ++count;
        }
        if (count == 0) {
            return new String[0];
        }
        String[] retArray = new String[count];
        count = 0;
        for (String v : values) {
            if (!StringUtils.notEmpty(v)) continue;
            retArray[count++] = v;
        }
        return retArray;
    }

    public static String stripWSControlChars(String textContent) {
        return textContent.replace("\t", "").replace("\n", " ").replace("\r", "").trim();
    }

    public static String printMap(Map map) {
        StringBuilder sb = new StringBuilder();
        if (map == null) {
            return null;
        }
        int count = 0;
        for (Object key : map.keySet()) {
            sb.append("Entry " + count + ": " + key + " - " + map.get(key) + "\n");
            ++count;
        }
        return sb.toString();
    }

    public static String xmlToString(Document document) {
        try {
            Document doc = document;
            DOMSource domSource = new DOMSource(doc);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, result);
            return writer.toString();
        }
        catch (TransformerException ex) {
            return null;
        }
    }

    public static InputStream getInputStream(String str) {
        return str == null ? null : new ByteArrayInputStream(str.getBytes());
    }

    public static String substring(String text, String leftMarker, String rightMarker) {
        String retVal = null;
        if (text != null) {
            int leftMarkerSize;
            int right;
            int left = leftMarker == null ? 0 : text.indexOf(leftMarker);
            int n = right = rightMarker == null ? text.length() : text.indexOf(rightMarker);
            if (left < 0 || right < 0) {
                return null;
            }
            int n2 = leftMarkerSize = leftMarker == null ? 0 : leftMarker.length();
            if ((left += leftMarkerSize) > right) {
                return null;
            }
            retVal = text.substring(left, right);
        }
        return retVal;
    }
}

