// Coordinates: -3.177437, 35.574687
// Map Width: 120km

RMS.LoadLibrary("rmgen");
RMS.LoadLibrary("rmgen2");

InitMap();

log("Initializing tile classes...");
setBiome(6);
initMapSettings();
initTileClasses(["eden", "highlands"]);

log("Initializing environment...");

setSunColor(0.733, 0.746, 0.574);

setWaterHeight(18);
setWaterTint(0.576, 0.541, 0.322);
setWaterColor(0.521, 0.475, 0.322);
setWaterWaviness(8);
setWaterMurkiness(0.87);
setWaterType("lake");

setTerrainAmbientColor(0.521, 0.475, 0.322);

setSunRotation(-1 * PI);
setSunElevation(PI / 6.25);

setFogFactor(0);
setFogThickness(0);
setFogColor(0.69, 0.616, 0.541);

setPPEffect("hdr");
setPPContrast(0.67);
setPPSaturation(0.42);
setPPBloom(0.23);

log("Initializing biome...");
g_Terrains.mainTerrain = "savanna_riparian_bank";
g_Terrains.forestFloor1 = "savanna_dirt_rocks_b";
g_Terrains.forestFloor2 = "savanna_dirt_rocks_c";
g_Terrains.tier1Terrain = "savanna_dirt_rocks_a";
g_Terrains.tier2Terrain = "savanna_grass_a";
g_Terrains.tier3Terrain = "savanna_grass_b";
g_Terrains.tier4Terrain = "savanna_forest_floor_a";
g_Terrains.roadWild = "savanna_riparian_dry";
g_Terrains.road = "road2";
g_Gaia.mainHuntableAnimal = "gaia/fauna_giraffe";
g_Gaia.secondaryHuntableAnimal = "gaia/fauna_zebra";
g_Gaia.metalLarge = "gaia/geology_metal_savanna_slabs";
g_Gaia.metalSmall = "gaia/geology_metal_tropic";
g_Gaia.fish = "gaia/fauna_fish_tilapia";
g_Gaia.tree1 = "gaia/flora_tree_baobab";
g_Gaia.tree2 = "gaia/flora_tree_baobab";
g_Gaia.tree3 = "gaia/flora_tree_baobab";
g_Gaia.tree4 = "gaia/flora_tree_baobab";
g_Gaia.tree5 = "gaia/flora_tree_baobab";
g_Decoratives.grass = "actor|props/flora/grass_savanna.xml";
g_Decoratives.grassShort = "actor|props/flora/grass_soft_dry_tuft_a.xml";
g_Decoratives.rockLarge = "actor|geology/stone_savanna_med.xml";
g_Decoratives.rockMedium = "actor|geology/stone_savanna_med.xml";
g_Decoratives.bushMedium = "actor|props/flora/bush_desert_dry_a.xml";
g_Decoratives.bushSmall = "actor|props/flora/bush_dry_a.xml";
initBiome();
RMS.SetProgress(5);

log("Resetting terrain...");
resetTerrain(g_Terrains.mainTerrain, g_TileClasses.land, 1);
RMS.SetProgress(10);

log("Copying heightmap...");
var scale = paintHeightmap(getHeightMap(), getTileMap(), getTilePallet(), (tile, x, y) => {

	if (tile.indexOf("grass1") >= 0 || tile.indexOf("savanna_wash") >= 0)
		addToClass(x, y, g_TileClasses.mountain);

	if (tile.indexOf("new_savanna") >= 0)
		addToClass(x, y, g_TileClasses.eden);
	else if (tile.indexOf("savanna_shrubs") >= 0 || tile.indexOf("savanna_grass") >= 0 || tile.indexOf("peat_temp") >= 0 || tile.indexOf("grass_field") >= 0 || tile.indexOf("grass b") >= 0)
		addToClass(x, y, g_TileClasses.highlands);
});
RMS.SetProgress(30);

log("Paint tile classes...");
paintTileClassBasedOnHeight(-100, -1, 3, g_TileClasses.water);
RMS.SetProgress(40);

log("Placing players...");
//Coordinate system of the heightmap
var singleBases = [
	[75, 275],
	[35, 210],
	[150, 285],
	[100, 35],
	[200, 35],
	[260, 110],
	[230,260],
	[45,135]
];

var strongholdBases = [
	[80, 250],
	[205, 65]
];
randomPlayerPlacementAt(singleBases, strongholdBases, scale, 0.06);
RMS.SetProgress(50);

log("Render lowlands...");
addElements([
	{
		"func": addLayeredPatches,
		"avoid": [
			g_TileClasses.dirt, 5,
			g_TileClasses.forest, 2,
			g_TileClasses.mountain, 2,
			g_TileClasses.player, 12,
			g_TileClasses.water, 3,
			g_TileClasses.eden, 2,
			g_TileClasses.highlands, 2
		],
		"sizes": ["normal"],
		"mixes": ["normal"],
		"amounts": ["many"]
	},
	{
		"func": addDecoration,
		"avoid": [
			g_TileClasses.forest, 2,
			g_TileClasses.mountain, 2,
			g_TileClasses.player, 12,
			g_TileClasses.water, 3,
			g_TileClasses.eden, 2,
			g_TileClasses.highlands, 2
		],
		"sizes": ["normal"],
		"mixes": ["normal"],
		"amounts": ["many"]
	}
]);

addElements(shuffleArray([
	{
		"func": addSmallMetal,
		"avoid": [
			g_TileClasses.berries, 5,
			g_TileClasses.forest, 3,
			g_TileClasses.mountain, 6,
			g_TileClasses.player, 30,
			g_TileClasses.rock, 20,
			g_TileClasses.metal, 10,
			g_TileClasses.water, 3,
			g_TileClasses.eden, 2,
			g_TileClasses.highlands, 2

		],
		"sizes": ["normal"],
		"mixes": ["same"],
		"amounts": ["few"]
	},
	{
		"func": addStone,
		"avoid": [
			g_TileClasses.berries, 5,
			g_TileClasses.forest, 3,
			g_TileClasses.mountain, 6,
			g_TileClasses.player, 30,
			g_TileClasses.rock, 20,
			g_TileClasses.metal, 10,
			g_TileClasses.water, 3,
			g_TileClasses.eden, 2,
			g_TileClasses.highlands, 2
		],
		"sizes": ["normal"],
		"mixes": ["same"],
		"amounts": ["scarce"]
	},
	{
		"func": addForests,
		"avoid": [
			g_TileClasses.berries, 5,
			g_TileClasses.forest, 8,
			g_TileClasses.metal, 3,
			g_TileClasses.mountain, 6,
			g_TileClasses.player, 20,
			g_TileClasses.rock, 3,
			g_TileClasses.water, 2,
			g_TileClasses.eden, 2,
			g_TileClasses.highlands, 2
		],
		"sizes": ["normal"],
		"mixes": ["similar"],
		"amounts": ["tons"]
	}
]));

addElements(shuffleArray([
	{
		"func": addAnimals,
		"avoid": [
			g_TileClasses.animals, 20,
			g_TileClasses.forest, 2,
			g_TileClasses.metal, 2,
			g_TileClasses.mountain, 6,
			g_TileClasses.player, 20,
			g_TileClasses.rock, 2,
			g_TileClasses.water, 3,
			g_TileClasses.eden, 2,
			g_TileClasses.highlands, 2
		],
		"sizes": ["big"],
		"mixes": ["similar"],
		"amounts": ["tons"]
	},
	{
		"func": addAnimals,
		"avoid": [
			g_TileClasses.animals, 20,
			g_TileClasses.forest, 2,
			g_TileClasses.metal, 2,
			g_TileClasses.mountain, 6,
			g_TileClasses.player, 20,
			g_TileClasses.rock, 2,
			g_TileClasses.water, 3,
			g_TileClasses.eden, 2,
			g_TileClasses.highlands, 2
		],
		"sizes": ["normal"],
		"mixes": ["unique"],
		"amounts": ["tons"]
	},
	{
		"func": addFish,
		"avoid": [
			g_TileClasses.fish, 12,
			g_TileClasses.player, 8
		],
		"stay": [g_TileClasses.water, 4],
		"sizes": ["normal"],
		"mixes": ["same"],
		"amounts": ["tons"]
	},
	{
		"func": addStragglerTrees,
		"avoid": [
			g_TileClasses.berries, 5,
			g_TileClasses.forest, 4,
			g_TileClasses.metal, 2,
			g_TileClasses.mountain, 6,
			g_TileClasses.player, 12,
			g_TileClasses.rock, 2,
			g_TileClasses.water, 5,
			g_TileClasses.eden, 2,
			g_TileClasses.highlands, 2
		],
		"sizes": ["big"],
		"mixes": ["same"],
		"amounts": ["many"]
	}
]));
RMS.SetProgress(60);

g_Gaia.mainHuntableAnimal = "gaia/fauna_lioness";
g_Gaia.secondaryHuntableAnimal =  "gaia/fauna_lion";
g_Terrains.mainTerrain = "savanna_grass_a_wetseason";
g_Terrains.forestFloor1 = "savanna_grass_a";
g_Terrains.forestFloor2 = "savanna_grass_b";
g_Terrains.tier1Terrain = "savanna_grass_a_wetseason";
g_Terrains.tier2Terrain = "savanna_grass_b_wetseason";
g_Terrains.tier3Terrain = "savanna_shrubs_a_wetseason";
g_Terrains.tier4Terrain = "savanna_shrubs_b";

log("Render highlands...");
addElements([
	{
		"func": addLayeredPatches,
		"avoid": [
			g_TileClasses.forest, 2,
			g_TileClasses.mountain, 2,
			g_TileClasses.player, 12,
			g_TileClasses.water, 3
		],
		"stay": [g_TileClasses.highlands, 2],
		"sizes": ["normal"],
		"mixes": ["normal"],
		"amounts": ["many"]
	},
	{
		"func": addDecoration,
		"avoid": [
			g_TileClasses.forest, 2,
			g_TileClasses.mountain, 2,
			g_TileClasses.player, 12,
			g_TileClasses.water, 3
		],
		"stay": [g_TileClasses.highlands, 2],
		"sizes": ["normal"],
		"mixes": ["normal"],
		"amounts": ["many"]
	}
]);

addElements(shuffleArray([
	{
		"func": addSmallMetal,
		"avoid": [
			g_TileClasses.berries, 5,
			g_TileClasses.forest, 3,
			g_TileClasses.mountain, 3,
			g_TileClasses.player, 30,
			g_TileClasses.rock, 10,
			g_TileClasses.metal, 20,
			g_TileClasses.water, 3
		],
		"stay": [g_TileClasses.highlands, 2],
		"sizes": ["normal"],
		"mixes": ["same"],
		"amounts": ["many"]
	},
	{
		"func": addStone,
		"avoid": [
			g_TileClasses.berries, 5,
			g_TileClasses.forest, 3,
			g_TileClasses.mountain, 3,
			g_TileClasses.player, 30,
			g_TileClasses.rock, 20,
			g_TileClasses.metal, 10,
			g_TileClasses.water, 3
		],
		"stay": [g_TileClasses.highlands, 2],
		"sizes": ["normal"],
		"mixes": ["same"],
		"amounts": ["many"]
	},
	{
		"func": addForests,
		"avoid": [
			g_TileClasses.berries, 5,
			g_TileClasses.forest, 8,
			g_TileClasses.metal, 3,
			g_TileClasses.mountain, 3,
			g_TileClasses.player, 20,
			g_TileClasses.rock, 3,
			g_TileClasses.water, 2
		],
		"stay": [g_TileClasses.highlands, 2],
		"sizes": ["huge"],
		"mixes": ["similar"],
		"amounts": ["tons"]
	}
]));

addElements(shuffleArray([
	{
		"func": addAnimals,
		"avoid": [
			g_TileClasses.animals, 20,
			g_TileClasses.forest, 2,
			g_TileClasses.metal, 2,
			g_TileClasses.mountain, 3,
			g_TileClasses.player, 20,
			g_TileClasses.rock, 2,
			g_TileClasses.water, 3
		],
		"stay": [g_TileClasses.highlands, 2],
		"sizes": ["huge"],
		"mixes": ["same"],
		"amounts": ["tons"]
	},
	{
		"func": addStragglerTrees,
		"avoid": [
			g_TileClasses.berries, 5,
			g_TileClasses.forest, 2,
			g_TileClasses.metal, 2,
			g_TileClasses.mountain, 3,
			g_TileClasses.player, 12,
			g_TileClasses.rock, 2,
			g_TileClasses.water, 5
		],
		"stay": [g_TileClasses.highlands, 2],
		"sizes": ["huge"],
		"mixes": ["same"],
		"amounts": ["tons"]
	}
]));
RMS.SetProgress(70);

g_Gaia.mainHuntableAnimal = "gaia/fauna_rhino";
g_Gaia.secondaryHuntableAnimal =  "gaia/fauna_elephant_african_bush";
initBiome();

log("Render eden...");
addElements([
	{
		"func": addLayeredPatches,
		"avoid": [
			g_TileClasses.dirt, 5,
			g_TileClasses.forest, 2,
			g_TileClasses.mountain, 2,
			g_TileClasses.player, 12,
			g_TileClasses.water, 3
		],
		"stay": [g_TileClasses.eden, 2],
		"sizes": ["normal"],
		"mixes": ["normal"],
		"amounts": ["many"]
	},
	{
		"func": addDecoration,
		"avoid": [
			g_TileClasses.forest, 2,
			g_TileClasses.mountain, 2,
			g_TileClasses.player, 12,
			g_TileClasses.water, 3
		],
		"stay": [g_TileClasses.eden, 2],
		"sizes": ["normal"],
		"mixes": ["normal"],
		"amounts": ["many"]
	}
]);

addElements(shuffleArray([
	{
		"func": addMetal,
		"avoid": [
			g_TileClasses.berries, 5,
			g_TileClasses.forest, 3,
			g_TileClasses.mountain, 2,
			g_TileClasses.player, 20,
			g_TileClasses.rock, 3,
			g_TileClasses.metal, 3,
			g_TileClasses.water, 3
		],
		"stay": [g_TileClasses.eden, 2],
		"sizes": ["normal"],
		"mixes": ["same"],
		"amounts": ["tons"]
	},
	{
		"func": addMetal,
		"avoid": [
			g_TileClasses.berries, 5,
			g_TileClasses.forest, 3,
			g_TileClasses.mountain, 2,
			g_TileClasses.player, 20,
			g_TileClasses.rock, 3,
			g_TileClasses.metal, 3,
			g_TileClasses.water, 3
		],
		"stay": [g_TileClasses.eden, 2],
		"sizes": ["normal"],
		"mixes": ["same"],
		"amounts": ["tons"]
	},
	{
		"func": addSmallMetal,
		"avoid": [
			g_TileClasses.berries, 5,
			g_TileClasses.forest, 3,
			g_TileClasses.mountain, 2,
			g_TileClasses.player, 20,
			g_TileClasses.rock, 3,
			g_TileClasses.metal, 3,
			g_TileClasses.water, 3
		],
		"stay": [g_TileClasses.eden, 2],
		"sizes": ["normal"],
		"mixes": ["same"],
		"amounts": ["tons"]
	},
	{
		"func": addStone,
		"avoid": [
			g_TileClasses.berries, 5,
			g_TileClasses.forest, 3,
			g_TileClasses.mountain, 2,
			g_TileClasses.player, 30,
			g_TileClasses.rock, 3,
			g_TileClasses.metal, 3,
			g_TileClasses.water, 3
		],
		"stay": [g_TileClasses.eden, 2],
		"sizes": ["normal"],
		"mixes": ["same"],
		"amounts": ["few"]
	},
	{
		"func": addForests,
		"avoid": [
			g_TileClasses.berries, 5,
			g_TileClasses.forest, 8,
			g_TileClasses.metal, 3,
			g_TileClasses.mountain, 8,
			g_TileClasses.player, 20,
			g_TileClasses.rock, 3,
			g_TileClasses.water, 2
		],
		"stay": [g_TileClasses.eden, 2],
		"sizes": ["huge"],
		"mixes": ["similar"],
		"amounts": ["scarce"]
	}
]));

addElements(shuffleArray([
	{
		"func": addAnimals,
		"avoid": [
			g_TileClasses.animals, 2,
			g_TileClasses.forest, 2,
			g_TileClasses.metal, 2,
			g_TileClasses.mountain, 3,
			g_TileClasses.player, 20,
			g_TileClasses.rock, 2,
			g_TileClasses.water, 3
		],
		"stay": [g_TileClasses.eden, 2],
		"sizes": ["normal"],
		"mixes": ["same"],
		"amounts": ["many"]
	},
	{
		"func": addStragglerTrees,
		"avoid": [
			g_TileClasses.berries, 5,
			g_TileClasses.forest, 2,
			g_TileClasses.metal, 2,
			g_TileClasses.mountain, 8,
			g_TileClasses.player, 12,
			g_TileClasses.rock, 2,
			g_TileClasses.water, 5
		],
		"stay": [g_TileClasses.eden, 2],
		"sizes": ["huge"],
		"mixes": ["same"],
		"amounts": ["scarce"]
	}
]));
RMS.SetProgress(80);

ExportMap();

// MapTiles - Do Not Edit Below This Line
function getHeightMap()
{
	return [2.61,2.61,1.26,-0.02,-1.61,-4.43,-4.43,-5.93,-6.78,-7.16,-6.75,-6.75,-6.25,-5.63,-4.78,-4.41,-4.41,-4.64,-5.38,-6.25,-7.25,-7.25,-7.25,-7.88,-8.39,-8.50,-8.50,-8.16,-7.50,-8.28,-9.75,-9.75,-10,-10,-9.50,-7.65,-7.65,-6.75,-5.99,-4.86,-1.91,-1.91,-1.25,-0.75,-0.13,1.82,1.82,2.46,2.50,2.62,2.98,2.98,2.98,2.87,2.76,2.71,2.71,2.76,2.87,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,4,5.98,10,17,17,19,20,20,20.98,20.96,21.13,21.54,21.70,21.95,22.23,22.51,22.77,23.03,23.26,23.47,23.64,23.79,23.96,24.09,24.21,24.34,24.45,24.50,24.62,24.75,24.89,25.07,25.25,25.42,25.62,25.82,26.04,26.38,26.90,27,27,27,27.98,27.98,27.98,27.98,27.98,27.98,29,29,29,30,30,30.98,30.98,30.98,30.98,30.98,30.98,30.98,32,32,32,32.98,32.98,34,35,35.98,36.96,37.10,36.86,35.15,34.20,34,34.23,34.99,35.75,36.02,36.03,35.98,35.98,36.12,36.89,36.99,37,37,37,37,37,37,37,37,37,37,37,35.98,35.98,35.98,35,35,35,35.98,35,35,35,34,34,34,32,32,32,32.98,34,32,32,32,32,32,32,32,32,30.98,30.98,30.98,30.98,30,30,30,30,30,30,30,29,29,29,29,29,29,27.98,27.98,27.98,27.98,27.97,27.97,27.97,27.97,27.97,27.97,27.97,27.92,27.78,27.53,27.25,27.07,26.99,27,27,27,26.99,26.99,26.99,26.98,26.91,26.87,26.52,26.25,25.99,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25,25,25,25,25,25,25,25,25,25,25,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,27,27,27,27,27,27,27,27,27,27,27,27.98,27.98,27.98,27.98,27.97,27.97,27.97,27.97,27.99,28.12,28.84,28.98,29,29,29,29,29.14,29.86,29.98,30,29.99,29.96,2.12,2.12,0.62,-0.90,-2.66,-5.88,-5.88,-7.37,-8.25,-8.63,-7.93,-7.93,-7.38,-6.75,-5.91,-5.50,-5.50,-5.49,-6.11,-6.88,-8.11,-8.11,-8.38,-8.93,-9.24,-9.75,-9.75,-9.13,-8.75,-9.64,-11,-11,-11,-11,-10,-8.87,-8.87,-8.12,-7,-5.67,-3.50,-3.50,-2.90,-2.37,-1.63,0.70,0.70,1.23,1.51,1.82,2.50,2.50,2.75,2.62,2.50,2.35,2.35,2.39,2.57,2.75,2.98,2.98,2.98,2.98,2.98,2.98,2.98,3.49,4.99,8.99,16,16,18,18.50,18.99,20.45,20.54,20.87,21.37,21.51,21.78,22.10,22.38,22.66,22.92,23.16,23.37,23.57,23.73,23.87,24.01,24.14,24.27,24.34,24.46,24.58,24.72,24.87,25.03,25.22,25.40,25.61,25.79,26.03,26.33,26.61,26.84,27,27,27.49,27.98,27.98,27.98,27.98,27.98,28.49,28.49,29,29.50,30,30.98,30.98,30.98,30.98,30.98,31.49,31.49,32,32,32,33.49,33.49,34.50,35,36.01,37.37,37.48,37.28,35.65,34.24,34.01,34.27,34.99,35.79,36.21,36.14,35.99,35.99,36.16,36.85,36.99,37,37,37,37,37,37,37,37,37,36.49,36.49,35.98,35.98,35.49,34.50,34.50,34.50,35.49,35,34.50,34.50,34,33.49,33.49,32,32,32.03,32.64,33.20,31.87,31.49,31.64,31.83,32,32,31.83,31.49,31.01,30.98,30.49,30.49,30,30,30,30,30,30,29.50,29,29,29,29,29,29,27.98,27.98,27.98,27.96,27.91,27.88,27.87,27.86,27.86,27.86,27.86,27.83,27.66,27.45,27.23,27.11,27.12,27.10,27.08,27.03,27,27,26.99,26.98,26.82,26.63,26.33,26.13,25.99,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.49,25,25,25,25,25,25,25,25,25,25,25,25.49,25.49,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,27,27,27,27,27,27,27,27,27,27,27,27.98,27.98,27.98,27.97,27.97,27.97,27.97,27.97,28.03,28.32,28.62,28.90,28.97,28.99,29,29.07,29.34,29.78,29.98,30,29.99,29.95,1.62,1.62,0,-1.79,-3.75,-7.25,-7.25,-8.75,-9.66,-10,-9.13,-9.13,-8.50,-7.88,-7.05,-6.53,-6.53,-6.25,-6.75,-7.50,-8.88,-8.88,-9.50,-10,-10,-11,-11,-10,-10,-11,-12,-12,-12,-12,-12,-10,-10,-9.39,-8,-6.53,-5,-5,-4.54,-3.89,-3.14,-0.41,-0.43,-0.11,0.50,0.87,1.96,1.97,2.50,2.26,2.20,2,2,2.07,2.23,2.50,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,4,7.98,15,15,17,17,17.92,19.52,19.86,20.34,20.99,21.16,21.48,21.82,22.13,22.42,22.72,22.97,23.20,23.39,23.58,23.74,23.89,24.03,24.11,24.23,24.36,24.50,24.64,24.82,24.99,25.16,25.36,25.54,25.75,25.99,26.23,26.47,26.66,26.83,27,27,27.97,27.97,27.97,27.95,27.90,28.07,28.08,28.88,29.11,29.89,30.88,30.89,30.95,30.98,30.98,32,32,32,32,32,34,34,35,35.02,36.08,37.83,37.78,37.75,35.98,34.28,34.12,34.32,34.99,35.90,36.67,36.27,36.21,36.10,36.21,36.79,36.99,37,37,37,37,37,37,36.99,36.98,36.89,36.07,36.04,35.90,35.95,35,34,34,34,35,35,34,34,34,32.98,32.98,32,32,32.04,32.21,32.41,31.60,31.14,31.29,31.48,31.63,31.63,31.49,31.25,31.02,30.82,30,30,30,30,30,30,30,30,29,29,29,29,29,29,29,27.98,27.98,27.97,27.91,27.86,27.75,27.66,27.63,27.63,27.63,27.63,27.59,27.47,27.32,27.22,27.24,27.25,27.25,27.21,27.12,27.03,27,26.98,26.98,26.70,26.40,26.10,26.03,25.99,25.98,25.98,25.97,25.97,25.97,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,27,27,27,27,27,27,27,27,27,27,27,27.98,27.98,27.98,27.97,27.97,27.97,27.97,27.98,28.03,28.29,28.61,28.87,28.95,28.98,29,29.08,29.35,29.64,29.91,30,29.99,29.90,0.51,0.51,-1.53,-3.75,-5.68,-9.63,-9.63,-11,-12,-12,-11,-11,-10,-9.89,-9.39,-8.75,-8.75,-8.25,-8.04,-8.65,-10,-10,-11,-12,-12,-12,-12,-12,-12,-12,-15,-15,-15,-15,-15,-12,-12,-11,-10,-9.13,-8.03,-8.03,-7.52,-6.75,-5.77,-4.93,-4.79,-4.40,-3.50,-2.30,-1.25,-0.89,-0.28,0.83,1.35,1.21,1.25,1.26,1.46,1.73,2.61,2.61,2.98,2.98,2.98,2.98,2.98,2.98,2.98,5,10.98,10.98,12,12.01,13.14,18.08,18.79,19.46,20.35,20.62,21,21.37,21.74,22.07,22.37,22.64,22.89,23.13,23.35,23.52,23.71,23.77,23.91,24.07,24.23,24.37,24.53,24.72,24.89,25.09,25.28,25.49,25.70,25.89,26.12,26.33,26.50,26.63,26.75,26.99,27,27.02,27.08,27.11,27.84,27.83,27.88,28.14,28.83,29.16,29.96,30.12,30.87,30.97,31.97,32,32,32.98,32.98,32.98,35,35,35,35.89,36.12,37.77,37.96,37.71,36.21,34.89,34.25,34.36,35,35.98,36.63,36.75,36.66,36.27,36.25,36.76,37.20,37.13,37.10,37.03,37.01,37.01,37.01,37,36.87,36.85,36.12,35.97,35.86,35.10,34.92,34.01,34,34,34,34,32.98,32.98,32.98,32.98,32,32.11,32,31.87,31.75,31.33,30.99,30.65,30.75,30.86,30.98,30.98,30.86,30.75,30.64,30.58,29.99,30,30,30,30,30,30,29,29,29,29,29,29,29,27.98,27.98,27.97,27.92,27.89,27.66,27.50,27.37,27.32,27.32,27.32,27.32,27.27,27.22,27.16,27.22,27.29,27.37,27.38,27.33,27.17,27.04,26.96,26.95,26.85,26.52,26.21,25.99,25.99,25.97,25.97,25.97,25.97,25.86,25.75,25.65,25.64,25.77,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25,25,25,25,25,25.98,25.98,25.98,25.98,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,27,27,27,27,27,27,27,27,27,27,27,27.98,27.98,27.97,27.97,27.97,27.97,27.97,27.98,28.04,28.25,28.51,28.76,28.89,28.97,29,29.10,29.35,29.63,29.90,29.98,29.98,29.88,-0.61,-0.61,-2.88,-5.14,-7.29,-11,-11,-12,-13,-13,-13,-13,-12,-11,-11,-10,-10,-10,-10,-10,-12,-12,-12,-12,-13,-13,-13,-15,-15,-15,-16,-16,-16,-16,-16,-15,-15,-13,-12,-12,-10,-10,-9.75,-8.93,-9,-9.13,-8.91,-8.38,-7.38,-6.12,-4.38,-4,-3.30,-2.26,-1,-0.05,0.46,0.50,0.84,1.09,1.87,1.87,2.50,2.98,2.98,2.98,2.98,2.98,2.98,2.98,5.98,5.98,7.98,8.03,11.53,16.67,17.12,18.23,19.40,19.88,20.37,20.77,21.16,21.53,21.88,22.22,22.50,22.76,23.01,23.25,23.36,23.52,23.71,23.87,24.04,24.23,24.40,24.60,24.77,24.98,25.17,25.38,25.59,25.78,25.98,26.15,26.29,26.41,26.50,26.57,26.60,26.60,26.64,26.85,27.07,27.25,27.23,27.75,28.12,28.76,29.78,29.79,30,30.85,31.08,32.92,32.98,32.98,32.98,34,35,35,35.03,35.87,36.84,37.75,37.71,37.66,36.29,35.34,34.37,34.37,35.12,35.99,36.63,36.97,36.87,36.66,36.27,36.99,37.75,37.76,37.20,37.15,37.14,37.16,37.17,37.10,36.78,36.17,36.10,35.86,35.79,35.14,34.87,34.09,34.03,34,34,34,32.98,32.98,32.98,32,32.02,31.83,31.75,31.58,31.25,30.82,30.50,30.33,30.21,30.09,30,30,30,30,29.98,29.65,29.33,28.99,29,29,29,29,29,29,29,29,29,29,29,27.98,27.98,27.98,27.75,27.65,27.59,27.47,27.27,27.14,27.10,27.10,27.10,27.10,27.08,27.04,27.08,27.16,27.27,27.37,27.38,27.33,27.15,26.99,26.83,26.71,26.53,26.29,26.10,25.99,25.98,25.97,25.87,25.75,25.64,25.53,25.42,25.34,25.33,25.29,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,27,27,27,27,27,27,27,27,27,27,27.98,27.98,27.98,27.97,27.97,27.97,27.97,27.97,27.98,28.03,28.17,28.40,28.66,28.87,28.95,29,29.11,29.35,29.62,29.88,29.97,29.95,29.87,-2.05,-2.05,-4.63,-7.05,-9.53,-12,-12,-15,-16,-16,-16,-16,-15,-13,-12,-13,-13,-13,-15,-15,-15,-15,-13,-15,-15,-15,-15,-15,-15,-16,-18,-18,-18,-20,-20,-17,-17,-16,-16,-15,-13,-13,-12,-12,-13,-13,-13,-12,-11,-10,-7.63,-6.66,-5.68,-4.50,-2.93,-1.30,-0.38,-0.25,-0.24,-0.41,0.32,0.32,0.89,1.72,2.60,2.98,2.98,2.98,2.98,2.98,2.98,2.98,4.03,6.09,8.86,12.72,15.21,16.72,18.20,19.02,19.59,20,20.45,20.86,21.25,21.62,21.99,22.29,22.61,22.78,23,23.22,23.45,23.64,23.86,24.04,24.25,24.45,24.63,24.85,25.04,25.25,25.46,25.63,25.79,25.96,26.08,26.15,26.22,26.24,26.23,26.20,26.27,26.41,26.60,26.75,26.98,27.20,27.26,28.23,28.79,29.13,29.22,29.17,30.14,31.89,32.03,32,32.98,34,35,35,35.07,35.91,36.79,37.24,37.28,37.13,36.63,35.72,35.12,34.97,35.35,36.04,36.64,36.98,36.98,36.87,36.87,37.21,37.70,37.75,37.71,37.75,37.77,37.75,37.75,37.24,36.75,36.23,35.99,35.75,35.22,35.12,34.88,34.87,34.90,34.96,35,34,32.98,32.98,32.92,32.33,31.87,31.62,31.45,31.22,30.90,30.49,30.22,29.97,29.76,29.54,29.38,29.35,29.34,29.34,29.32,29,28.60,28.32,28.13,27.98,27.98,27.98,27.98,27.98,27.98,27.98,27.98,27.99,28,28,27.92,27.03,27.36,27.34,27.27,27.21,27.10,27.01,26.98,26.98,26.99,26.99,26.99,26.99,27.01,27.10,27.14,27.22,27.23,27.15,27,26.83,26.61,26.42,26.17,26.03,25.92,25.97,25.98,25.97,25.75,25.53,25.34,25.23,25.12,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,27,27,27,27.98,27.98,27.98,27.98,27.98,27.98,27.98,27.98,27.98,27.98,27.97,27.97,27.97,27.97,27.97,27.99,28.03,28.15,28.35,28.54,28.75,28.88,29,29.15,29.37,29.62,29.88,29.96,29.92,29.72,-2.25,-2.25,-4.86,-7.30,-9.77,-13,-13,-15,-16,-16,-16,-16,-15,-13,-12,-13,-13,-14,-15,-15,-15,-15,-14,-15,-15,-15,-15,-15,-15,-15,-18,-18,-19,-20,-20,-18,-18,-17,-17,-16,-14,-14,-12,-13,-14,-14,-14,-13,-12,-10,-9.52,-8.17,-7.27,-6,-4,-2.38,-1.13,-0.88,-0.79,-0.52,0,0,0.59,1.37,2.25,2.87,2.87,2.98,2.98,2.98,2.98,2.98,3.54,5.12,7.99,10.75,13.20,15,16.67,18.22,18.61,19.09,19.52,19.99,20.46,20.89,21.33,21.73,22.10,22.33,22.60,22.87,23.13,23.38,23.62,23.84,24.04,24.25,24.47,24.67,24.88,25.10,25.27,25.46,25.61,25.73,25.83,25.88,25.92,25.92,25.90,25.85,25.97,26.12,26.28,26.48,26.67,26.87,27.20,27.67,28.17,28.49,28.70,29.04,29.70,31.85,31.97,32.02,32.49,33.49,34.50,34.50,35.10,35.83,36.63,37.22,37.33,37.14,36.64,36.14,35.65,35.50,35.66,36.16,36.65,36.99,37,37,37,37.29,37.62,37.83,37.90,37.96,37.98,37.97,37.78,37.46,36.85,36.26,35.99,35.71,35.25,35.04,35,34.98,34.98,34.98,34.98,34,32.98,32.98,32.78,32.38,31.87,31.45,31.15,30.96,30.72,30.39,30.14,29.89,29.64,29.33,29.10,29.01,29.01,29.01,28.99,28.65,28.33,27.97,27.97,27.97,27.98,27.98,27.98,27.98,27.98,27.97,27.97,27.97,27.97,27.97,27.89,27.08,27.07,27.08,27.04,27,26.92,26.88,26.87,26.87,26.87,26.87,26.87,26.87,26.87,26.90,26.91,26.96,26.95,26.87,26.75,26.58,26.36,26.13,25.87,25.79,25.79,25.97,25.97,25.97,25.63,25.34,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,24.50,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25.75,25.98,25.98,25.98,25.98,25.98,25.98,26.32,26.76,27,27,27.98,27.98,27.98,27.98,27.98,27.98,27.98,27.98,27.98,27.97,27.97,27.97,27.97,27.97,27.97,27.98,28.01,28.12,28.26,28.48,28.66,28.85,29,29.16,29.37,29.62,29.86,29.98,29.96,29.52,-2.41,-2.41,-5,-7.55,-10,-13,-13,-15,-16,-17,-16,-16,-15,-13,-12,-13,-13,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-18,-18,-20,-20,-20,-20,-20,-18,-18,-17,-15,-15,-13,-14,-15,-15,-14,-14,-13,-11,-10,-9.15,-8,-6.65,-4.88,-3.13,-1.78,-1.50,-1.25,-0.92,-0.52,-0.30,0.25,1,2,2.75,2.75,2.98,2.98,2.98,2.98,2.98,3.07,4.14,6.67,9.09,11.26,13,14.82,16.70,17.59,17.97,18.41,18.95,19.49,20.01,20.53,21.03,21.50,21.79,22.13,22.48,22.79,23.10,23.36,23.60,23.84,24.04,24.27,24.50,24.71,24.89,25.09,25.25,25.37,25.50,25.58,25.62,25.65,25.66,25.65,25.60,25.77,26,26.20,26.38,26.60,26.82,27.03,27.35,27.64,27.92,28.23,28.73,29.23,31.82,31.87,31.91,32,32.98,34,34,34.88,35.82,36.21,37.70,37.65,37.25,36.65,36.37,36.11,36.16,36.24,36.40,36.99,37.29,37.22,37.12,37.01,37.36,37.63,37.87,38,38.13,38.24,38.26,38.12,37.76,37.13,36.28,36.09,35.75,35.28,35.14,35.02,35,35,34.99,34.92,34,33.20,33.21,32.97,32.53,32,31.47,31.12,30.89,30.65,30.37,30.12,29.87,29.62,29.35,29.12,29.01,29,28.98,28.86,28.52,28.21,27.98,27.97,27.97,27.98,27.98,27.98,27.98,27.96,27.92,27.91,27.89,27.88,27.88,27.87,27.10,26.99,26.92,26.87,26.82,26.74,26.66,26.64,26.64,26.64,26.64,26.64,26.64,26.64,26.64,26.62,26.63,26.62,26.57,26.46,26.28,26.09,25.86,25.57,25.50,25.50,25.63,25.64,25.63,25.42,25.22,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,24,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25.26,25.62,25.98,25.98,25.98,25.98,25.98,25.98,26.32,26.62,26.99,27,27.98,27.98,27.98,27.98,27.98,27.98,27.98,27.98,27.98,27.97,27.97,27.97,27.97,27.97,27.97,27.97,28,28.09,28.23,28.41,28.62,28.83,29,29.17,29.38,29.62,29.85,30,30.09,29.38,-2.77,-2.77,-5.25,-7.90,-10,-13,-13,-15,-17,-17,-16,-16,-15,-13,-12,-13,-13,-15,-15,-15,-15,-15,-15,-15,-13,-13,-13,-13,-13,-15,-18,-18,-20,-20,-20,-20,-20,-20,-20,-20,-15,-15,-15,-16,-16,-16,-15,-15,-14,-12,-11,-9.77,-8.88,-7.51,-6,-4.40,-3.25,-2.50,-2.13,-1.75,-1.38,-0.93,-0.41,0.25,1.26,2.50,2.50,2.75,2.98,2.98,2.98,2.98,3.09,3.14,5.34,7.27,9.01,10.66,12.45,14.45,16.32,16.52,17.13,17.72,18.35,19,19.62,20.25,20.83,21.23,21.64,22.07,22.42,22.76,23.07,23.34,23.59,23.83,24.04,24.27,24.49,24.67,24.86,25,25.13,25.25,25.33,25.37,25.41,25.46,25.47,25.46,25.74,26.02,26.28,26.51,26.73,26.90,27.04,27.21,27.32,27.35,27.83,28.26,29.25,30.12,30.16,31,31,32,34,34,34.11,34.99,36.09,37.70,37.64,37.09,36.61,36.38,36.58,36.87,37.11,37.42,37.64,37.75,37.57,37.34,37.15,37.41,37.73,37.99,38.17,38.36,38.71,38.67,38.66,38.07,37.63,36.78,36.25,35.91,35.67,35.28,35.16,35.02,35,34.98,34.89,34.21,33.76,33.52,33.21,32.74,32.16,31.62,31.25,31,30.75,30.45,30.15,29.88,29.62,29.35,29.13,29.02,29,28.98,28.75,28.41,28.10,27.98,27.97,27.97,27.98,27.98,27.98,27.01,27.10,27.26,27.38,27.40,27.41,27.39,27.24,27.04,26.87,26.79,26.73,26.62,26.49,26.37,26.33,26.32,26.32,26.32,26.32,26.32,26.32,26.32,26.35,26.35,26.33,26.26,26.15,26,25.79,25.57,25.32,25.23,25.23,25.32,25.33,25.32,25.22,25.11,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,24,24,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25.33,25.62,25.96,25.98,25.98,25.99,26,26,26.37,26.64,26.97,27.21,27.98,27.98,27.98,27.98,27.98,27.98,27.98,27.98,27.98,27.97,27.97,27.96,27.96,27.96,27.96,27.97,27.99,28.04,28.20,28.37,28.61,28.82,29,29.21,29.41,29.66,29.89,30.11,30.25,30.25,-2.99,-2.99,-5.50,-7.75,-10,-12,-12,-15,-16,-17,-15,-15,-15,-12,-12,-13,-13,-15,-15,-15,-15,-15,-13,-12,-12,-12,-12,-12,-12,-15,-17,-17,-18,-20,-20,-20,-20,-18,-20,-20,-16,-16,-16,-17,-18,-17,-16,-16,-15,-13,-12,-10,-9.88,-8.61,-7.13,-5.68,-4.52,-3.75,-3.25,-2.75,-2.25,-1.75,-1.13,-0.41,0.50,1.96,1.96,2.37,2.86,2.98,2.98,2.98,3,3.14,4.32,5.60,6.87,8.09,9.73,11.72,13.62,15.28,15.60,16.33,17.04,17.83,18.61,19.37,20.08,20.61,21.12,21.62,22.03,22.41,22.75,23.04,23.33,23.58,23.82,24.03,24.25,24.45,24.61,24.75,24.88,24.99,25.08,25.14,25.22,25.27,25.35,25.37,25.75,26.16,26.52,26.82,27.03,27.17,27.28,27.34,27.37,27.37,27.35,28.25,29.02,29.75,30.11,30.12,31,32,32.98,32.98,33.88,34.17,35.23,36.72,36.66,36.62,36,36.32,36.75,37.42,38.57,38.85,38.86,38.39,38.20,37.87,37.42,37.45,38,38.25,38.40,38.62,38.78,38.87,38.65,38.16,37.62,37.11,36.34,36.32,36.32,35.98,35.28,35.15,35.03,35,34.74,34.40,34.10,33.86,33.45,32.98,32.46,31.89,31.53,31.25,30.92,30.59,30.25,29.92,29.62,29.36,29.13,29.02,28.99,28.97,28.65,28.33,27.98,27.98,27.97,27.97,27.98,27,27,27.12,27.02,27.04,27.08,27.10,27.10,27.03,26.95,26.78,26.67,26.61,26.52,26.41,26.27,26.15,26.11,26.09,26.09,26.09,26.09,26.09,26.09,26.09,26.12,26.12,26.09,26.01,25.89,25.74,25.53,25.29,25.12,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,24.99,24.98,24.96,24.95,24.89,24.89,24.95,24.98,25,25,25,25,24,24,24,24,25,25,25,25,25,25,25,25,25,25,25,25,25,25.11,25.39,25.73,25.88,25.98,25.98,26,26.09,26.25,26.50,26.75,26.95,27.12,27.20,27,27.98,27.98,27.98,27.98,27.98,27.98,27.98,27.97,27.96,27.96,27.96,27.96,27.96,27.96,27.98,28.03,28.16,28.37,28.60,28.82,29.02,29.24,29.48,29.73,29.99,30.22,30.41,30.14,-2.66,-2.66,-5.24,-7.38,-9.18,-11,-11,-12,-13,-13,-12,-12,-11,-10,-11,-12,-12,-13,-13,-12,-12,-12,-12,-12,-11,-10,-10,-11,-12,-13,-15,-15,-16,-18,-18,-16,-16,-15,-17,-17,-17,-17,-17,-17,-18,-18,-17,-16,-15,-14,-12,-11,-10,-9.65,-8.29,-7,-5.93,-5.13,-4.50,-3.87,-3.15,-2.50,-1.79,-1.05,-0.51,0.75,0.75,1.25,1.87,2.70,2.98,2.98,2.98,3,3.62,4.25,4.91,5.74,7.04,9.02,11,12.73,14.14,14.74,15.62,16.53,17.50,18.42,19.32,19.98,20.60,21.15,21.63,22.04,22.41,22.75,23.03,23.29,23.54,23.77,23.99,24.17,24.35,24.50,24.62,24.73,24.83,24.91,25,25.12,25.25,25.47,25.79,26.29,26.75,27.12,27.37,27.50,27.60,27.66,27.75,27.79,27.99,28.29,29,29.75,29.87,30.14,30.88,30.98,32,32,33.03,33.84,34.23,35.11,35.32,35.36,35.35,35.39,37.54,37.98,38.91,40.53,40.53,39.14,38.64,38.62,38.12,38.11,38.52,38.54,38.71,38.78,38.86,38.77,38.63,38.09,37.37,37.37,37.60,37.62,37.63,36.66,35.89,35.26,35.15,35.04,34.86,34.52,34.22,33.96,33.62,33.23,32.75,32.28,31.90,31.54,31.17,30.75,30.34,29.98,29.64,29.37,29.14,29.02,28.99,28.95,28.62,28.27,27.98,27.97,27.96,27.97,27.98,27,27.01,27,27,26.99,26.99,26.99,26.99,26.90,26.75,26.52,26.47,26.37,26.29,26.23,26.12,26.02,25.99,25.97,25.97,25.97,25.97,25.97,25.97,25.98,25.98,25.97,25.91,25.83,25.66,25.50,25.33,25.15,25.04,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,24.97,24.87,24.85,24.75,24.75,24.75,24.75,24.75,25,24,24,24,24,24,24,24,25,25,25,25,25,25,25,25,25,25,25,25,25,25.22,25.50,25.76,25.89,25.98,25.98,26,26.20,26.46,26.64,26.87,26.96,27,27,27,27.98,27.98,27.98,27.98,27.98,27.98,27.98,27.97,27.96,27.95,27.95,27.95,27.95,27.95,27.97,28.02,28.15,28.36,28.60,28.83,29.04,29.28,29.53,29.82,30.09,30.33,30.50,30.07,-2.50,-2.50,-5,-7.36,-9.15,-11,-11,-11,-12,-12,-11,-11,-10,-10,-11,-12,-12,-13,-13,-12,-12,-12,-12,-12,-11,-10,-10,-10,-11,-13,-15,-15,-15,-17,-18,-16,-16,-15,-16,-16,-17,-17,-16,-16,-17,-18,-17,-16,-15,-14,-13,-12,-11,-10,-9.38,-8.24,-7.25,-6.50,-5.75,-4.99,-4.13,-3.27,-2.42,-1.63,-0.67,0.12,0.37,0.86,1.50,2.35,2.98,2.98,2.97,2.98,3.24,3.50,3.78,4.25,5.20,6.75,8.64,10.29,11.78,13.11,14.02,15.15,16.35,17.50,18.57,19.36,20.07,20.67,21.22,21.66,22.08,22.41,22.74,23,23.26,23.50,23.71,23.89,24.08,24.22,24.35,24.47,24.58,24.70,24.83,24.98,25.16,25.41,25.83,26.36,26.86,27.27,27.54,27.72,27.85,28.02,28.23,28.36,28.45,28.63,28.99,29.33,29.65,30,30.48,30.98,31.49,31.49,32.48,33.34,33.99,34.33,34.65,34.67,34.67,34.88,37.08,37.90,39.13,40.54,40.13,39.40,38.99,38.79,38.48,38.42,38.59,38.83,38.96,38.98,38.84,38.63,38.35,38,37.73,37.64,37.75,37.84,37.62,37.07,36.34,35.76,35.37,35.16,34.98,34.63,34.32,34,33.77,33.48,33.10,32.65,32.25,31.86,31.40,30.89,30.41,30,29.65,29.37,29.14,29.03,28.98,28.89,28.59,28.25,27.98,27.97,27.96,27.96,27.98,27.25,27.02,26.99,26.99,26.99,26.99,26.98,26.98,26.87,26.67,26.38,26.27,26.20,26.12,26.09,26.02,25.99,25.96,25.92,25.90,25.87,25.87,25.86,25.86,25.87,25.83,25.82,25.75,25.63,25.47,25.29,25.15,25.07,25.01,25,25,25,25,25,25,25,25,25,25,24.99,25,24.99,25,24.98,24.96,24.88,24.87,24.87,24.84,24.75,24.62,24.50,24.49,24.49,24.49,24.49,24.50,24,24,24,24,24,24,24,25,25,25,25,25,25,25,25,25,25,25,25,25,25.26,25.61,25.87,25.96,25.98,25.99,26.10,26.26,26.61,26.85,26.95,26.97,26.99,26.99,27,27.98,27.98,27.98,27.98,27.98,27.98,27.98,27.96,27.95,27.92,27.91,27.90,27.90,27.90,27.95,28.01,28.14,28.35,28.60,28.84,29.09,29.34,29.62,29.89,30.17,30.41,30.54,30.02,-2.25,-2.25,-4.86,-7.25,-9.13,-11,-11,-11,-11,-11,-10,-10,-10,-10,-11,-12,-12,-13,-13,-12,-12,-12,-12,-12,-11,-10,-10,-10,-11,-12,-15,-15,-15,-16,-17,-16,-16,-15,-15,-16,-17,-17,-16,-16,-17,-17,-16,-16,-15,-14,-14,-13,-12,-11,-10,-9.38,-8.63,-7.87,-7,-6.13,-5.25,-4.29,-3.38,-2.42,-1.54,-0.86,-0.24,0.48,1.12,2,2.98,2.98,2.92,2.96,3.03,3.14,3.34,3.62,4.28,5.37,6.77,8.17,9.57,10.90,12.32,13.70,15.20,16.62,17.91,18.73,19.50,20.17,20.76,21.25,21.70,22.08,22.39,22.71,22.97,23.21,23.41,23.61,23.77,23.95,24.09,24.22,24.35,24.48,24.63,24.83,25.04,25.33,25.75,26.27,26.78,27.23,27.52,27.72,27.89,28.21,28.58,28.73,28.78,28.87,28.99,29.12,29.23,29.83,30.11,30.98,30.98,30.98,31.92,32.84,33.79,33.75,33.98,34.66,34.12,34.37,36.61,37.33,38.59,40.57,39.79,39.37,39,38.91,38.61,38.41,38.70,39.01,39.23,39.28,39.04,38.34,38.36,38.12,37.95,37.87,37.87,37.78,37.62,37.12,36.67,36.11,35.73,35.32,35.03,34.67,34.35,34.07,33.91,33.67,33.37,32.98,32.53,32.09,31.57,30.99,30.48,30.02,29.66,29.37,29.15,29.03,28.97,28.87,28.54,28.24,27.98,27.97,27.96,27.90,27.79,27.35,27.03,26.99,26.99,26.98,26.98,26.98,26.97,26.85,26.62,26.32,26.20,26.09,26.02,26,25.97,25.95,25.90,25.86,25.77,25.71,25.65,25.63,25.63,25.64,25.61,25.60,25.53,25.45,25.29,25.15,25.07,25.01,25,25,25,25,25,25,25,25,25,25,25,24.99,24.99,24.97,24.98,24.89,24.85,24.74,24.64,24.62,24.61,24.50,24.36,24.25,24.22,24.22,24.22,24.20,24,24,24,24,24,24,24,24,25,25,25,25,25,25,25,25,25,25,25,25,25,25.33,25.62,25.87,25.98,25.99,26,26.20,26.45,26.74,26.87,26.99,26.99,26.99,26.99,27,27.98,27.98,27.98,27.98,27.98,27.98,27.98,27.95,27.91,27.88,27.86,27.83,27.83,27.85,27.88,27.99,28.13,28.35,28.60,28.85,29.11,29.38,29.70,30,30.28,30.51,30.62,30.02,-1.89,-1.89,-4.55,-7.04,-9.13,-11,-11,-10,-10,-10,-9.50,-9.50,-9.55,-9.89,-11,-12,-12,-13,-13,-13,-13,-13,-12,-12,-11,-10,-10,-10,-10,-11,-13,-13,-15,-15,-15,-15,-15,-15,-15,-15,-16,-16,-15,-15,-15,-15,-15,-14,-14,-14,-14,-13,-13,-12,-11,-10,-9.89,-9.04,-8.18,-7.26,-6.30,-5.37,-4.38,-3.38,-2.50,-1.67,-1,-0.36,0.34,1.21,2.75,2.75,2.90,2.89,2.89,2.96,3.09,3.34,3.76,4.46,5.37,6.41,7.54,8.79,10.24,11.91,13.85,15.88,17.22,18,18.87,19.62,20.26,20.82,21.27,21.70,22.04,22.37,22.63,22.88,23.12,23.32,23.50,23.65,23.83,23.97,24.12,24.27,24.46,24.66,24.90,25.20,25.61,26.12,26.61,27.01,27.33,27.54,27.78,28.21,28.59,28.86,28.90,28.96,29.01,29.07,29.16,29.16,29.88,30,30.98,30.98,31.01,31.88,32.15,32.75,33.10,33.22,33.29,34.33,35.60,36.36,37.38,38.61,39.62,39.09,38.99,38.97,38.71,38.39,38.82,39.17,39.60,39.63,39.65,38.98,38.62,38.36,38.22,38.10,37.95,37.73,37.36,37.11,36.70,36.26,35.83,35.63,35.32,34.95,34.59,34.28,34.09,33.83,33.50,33.12,32.67,32.17,31.62,31.02,30.50,30.03,29.67,29.37,29.15,29.03,28.97,28.85,28.52,28.22,27.98,27.96,27.96,27.87,27.65,27.36,27.08,27,26.98,26.98,26.98,26.97,26.92,26.82,26.60,26.33,26.15,26.04,25.99,25.96,25.91,25.87,25.82,25.72,25.59,25.45,25.36,25.33,25.33,25.33,25.36,25.35,25.32,25.24,25.13,25.07,25,24.99,24.99,25,25,25,25,25,25,25,24.99,24.99,24.99,25,24.95,24.87,24.87,24.75,24.62,24.46,24.36,24.33,24.25,24.23,24.12,24.08,24.01,24.01,24.01,24,24,24,24,24,24,24,24,24,25,25,25,25,25,25,25,25,25,25,25,25,25,25.33,25.62,25.87,25.98,26,26.12,26.36,26.62,26.87,27,27.10,27.10,27.10,27.07,27.01,27.98,27.98,27.98,27.98,27.98,27.98,27.98,27.89,27.85,27.77,27.73,27.67,27.67,27.73,27.79,27.92,28.11,28.34,28.60,28.86,29.12,29.42,29.76,30.12,30.40,30.62,30.67,30.03,-1.75,-1.75,-4.55,-6.99,-8.75,-10,-10,-10,-10,-9.88,-9.55,-9.55,-10,-10,-11,-12,-12,-13,-13,-15,-15,-15,-15,-12,-12,-10,-10,-9.79,-9.90,-10,-12,-12,-13,-15,-15,-15,-15,-15,-13,-13,-15,-15,-15,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-11,-10,-10,-9.30,-8.38,-7.38,-6.38,-5.36,-4.36,-3.38,-2.55,-1.86,-1.13,-0.41,0.36,2,2,2.58,2.87,2.72,2.78,2.91,3.11,3.37,3.78,4.36,5.01,5.83,6.83,8.21,9.95,12.01,14.32,15.98,17.12,18.15,19,19.72,20.32,20.83,21.27,21.66,22,22.32,22.58,22.82,23.01,23.22,23.39,23.58,23.74,23.90,24.10,24.29,24.52,24.76,25.02,25.41,25.86,26.33,26.74,27.04,27.28,27.51,27.91,28.59,28.70,28.84,28.98,29.12,29.25,29.23,29.16,29.10,29,30,30,30.97,31.04,31.12,31.79,32.11,32.26,32.77,33.29,34.65,34.87,35.61,36.62,37.63,38.65,38.75,38.87,38.78,38.79,38.92,39.28,39.63,39.84,39.65,39.26,38.87,38.72,38.62,38.35,38.08,37.75,37.36,37.12,36.78,36.25,36.22,36.23,36.01,35.58,35,34.52,34.21,33.87,33.52,33.13,32.70,32.21,31.62,31.04,30.50,30.04,29.71,29.39,29.17,29.07,28.97,28.84,28.53,28.22,27.98,27.97,27.95,27.86,27.67,27.36,27.13,27,26.99,26.98,26.97,26.96,26.90,26.78,26.59,26.34,26.15,26.04,25.98,25.92,25.87,25.78,25.66,25.52,25.37,25.23,25.13,25.11,25.11,25.11,25.11,25.12,25.12,25.08,25,24.96,24.95,24.96,24.99,24.99,24.99,24.99,24.99,24.99,24.99,24.99,24.99,24.87,24.76,24.65,24.84,24.62,24.62,24.50,24.36,24.22,24.12,24.11,24.09,24.07,24,24,24,24,24,24,24,24,24,24,22.98,22.98,22.98,24,24,25,25,25,25,25,25,25,25,25,25,25,25,25.33,25.62,25.87,25.98,26,26.22,26.50,26.85,27.11,27.22,27.25,27.25,27.25,27.25,27.07,27,27.98,27.98,27.98,27.98,27.98,27.98,27.83,27.70,27.60,27.51,27.48,27.49,27.54,27.67,27.85,28.07,28.33,28.60,28.86,29.13,29.47,29.86,30.24,30.53,30.72,30.71,30.11,-1.91,-1.91,-4.63,-7,-8.88,-11,-11,-11,-12,-11,-10,-10,-10,-10,-11,-12,-12,-13,-15,-16,-20,-20,-20,-18,-16,-12,-12,-10,-10,-11,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-11,-10,-9.93,-10,-10,-12,-13,-13,-13,-13,-13,-13,-12,-11,-11,-10,-9.39,-8.39,-7.38,-6.29,-5.27,-4.37,-3.50,-2.74,-2,-1.26,-0.43,0.14,0.14,0.97,1.75,2.41,2.63,2.82,2.92,3.10,3.34,3.65,4.04,4.53,5.25,6.35,7.91,10.10,12.61,14.63,16.12,17.35,18.28,19.10,19.75,20.34,20.84,21.26,21.63,21.97,22.25,22.50,22.74,22.96,23.14,23.35,23.53,23.74,23.95,24.16,24.40,24.64,24.88,25.23,25.57,26.02,26.45,26.77,27.02,27.25,27.40,28,28.36,28.66,28.91,29.23,29.75,29.78,29.85,29.90,30,30,30,30.98,30.98,31.08,31.12,31.16,31.87,32.26,32.99,33.27,33.28,33.29,34.33,35.32,37.66,38.26,38.75,38.89,38.91,39.01,39.33,39.70,39.87,39.66,39.32,39.01,38.91,38.79,38.62,38.20,37.87,37.63,37.32,37.01,36.79,36.76,36.86,37,36.16,35.37,34.72,34.26,33.87,33.46,33.02,32.60,32.12,31.60,31.04,30.51,30.09,29.75,29.46,29.23,29.09,28.99,28.86,28.60,28.27,28.03,27.98,27.95,27.85,27.67,27.37,27.15,27.02,26.99,26.98,26.97,26.95,26.88,26.75,26.57,26.35,26.14,26.04,25.98,25.90,25.82,25.70,25.52,25.36,25.21,25.09,25.01,25,25,25,25,25,25,24.97,24.89,24.83,24.79,24.78,24.82,24.82,24.82,24.82,24.82,24.82,24.82,24.82,24.82,24.65,24.45,24.22,24,24.33,24.26,24.24,24.12,24.01,24,24,24,24,24,24,24,24,24,24,24,24,24,24,22.98,22.98,22.98,24,24,24,24,24,24,24,25,25,25,25,25,25,25,25.33,25.62,25.87,25.98,26.08,26.25,26.62,26.99,27.25,27.37,27.38,27.38,27.38,27.39,27.87,27,27,27,27.98,27.98,27.98,27.98,27.71,27.50,27.37,27.29,27.26,27.28,27.37,27.53,27.76,28.02,28.32,28.60,28.86,29.14,29.50,29.91,30.34,30.63,30.78,30.73,30.22,-1.88,-1.88,-4.64,-7.11,-9,-11,-11,-11,-12,-11,-10,-10,-10,-10,-10,-12,-12,-13,-15,-17,-20,-20,-20,-19,-16,-13,-13,-11,-11,-11,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-11,-10,-10,-10,-10,-11,-12,-13,-14,-14,-14,-14,-13,-12,-12,-11,-10,-9.38,-8.36,-7.27,-6.25,-5.28,-4.41,-3.63,-2.88,-2.14,-1.40,-0.75,-0.25,0.50,1.24,2.01,2.72,2.72,2.77,2.87,3.02,3.22,3.48,3.79,4.27,5.10,6.39,8.42,10.98,13.34,15.23,16.50,17.57,18.45,19.17,19.83,20.37,20.85,21.25,21.62,21.92,22.22,22.47,22.71,22.92,23.14,23.37,23.60,23.84,24.08,24.33,24.58,24.79,25.09,25.29,25.75,26.15,26.51,26.78,27.02,27.35,27.71,28.12,28.49,28.84,29.27,29.75,30.11,30.36,30.46,30.49,30.49,30.49,30.98,30.98,30.98,30.98,31.12,31.79,32.22,32.74,32.98,33,33.25,34,35.27,37.71,38.22,38.77,38.91,38.99,39.07,39.25,39.75,39.89,39.67,39.33,39.03,38.98,38.91,38.63,38.29,37.98,37.77,37.60,37.33,37.12,37,37.25,37.21,36.57,35.57,34.75,34.27,33.82,33.35,32.88,32.48,32.07,31.60,31.09,30.59,30.17,29.86,29.58,29.33,29.14,29.01,28.89,28.73,28.41,28.14,27.98,27.92,27.83,27.64,27.38,27.17,27.04,27,26.98,26.97,26.92,26.87,26.74,26.57,26.36,26.16,26.03,25.97,25.87,25.75,25.61,25.41,25.25,25.12,25.03,25,25,25,25,25,25,25,24.90,24.75,24.58,24.48,24.48,24.50,24.50,24.49,24.49,24.49,24.49,24.50,24.50,24.50,24.33,24.15,24,24,24,24.08,24.07,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24.50,24,22.98,22.98,22.98,24,24,24,24,24,24,24,24.50,24.50,25,25,25,25,25,25.25,25.61,25.85,25.96,26.08,26.25,26.62,26.98,27.23,27.33,27.37,27.37,27.37,27.37,27.38,27,27,27,27.98,27.98,27.98,27.98,27.54,27.27,27.16,27.12,27.11,27.14,27.25,27.45,27.70,27.99,28.28,28.59,28.86,29.14,29.50,29.96,30.38,30.70,30.82,30.75,30.35,-1.75,-1.75,-4.64,-7.14,-9.13,-11,-11,-12,-12,-12,-11,-11,-11,-10,-10,-12,-12,-13,-15,-18,-20,-20,-20,-20,-17,-15,-15,-13,-12,-11,-12,-12,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-11,-10,-11,-11,-11,-12,-12,-13,-14,-14,-14,-14,-14,-13,-12,-12,-11,-10,-9.25,-8.24,-7.24,-6.25,-5.41,-4.63,-3.88,-3.13,-2.38,-1.63,-0.88,-0.13,0.62,1.67,2.63,2.62,2.58,2.67,2.78,2.92,3.12,3.39,3.83,4.46,5.59,7.35,9.73,12.17,14.27,15.71,16.87,17.78,18.59,19.27,19.88,20.40,20.87,21.25,21.61,21.91,22.21,22.47,22.73,22.98,23.23,23.49,23.75,24.02,24.29,24.51,24.79,25.03,25.17,25.59,25.99,26.32,26.62,26.92,27.29,27.66,28,28.38,28.74,29.25,29.77,30.16,30.87,30.95,30.98,30.98,30.98,30.98,30.98,30.98,31.01,31.08,31.86,32.15,32.77,33.20,33.21,33.21,34.12,35.23,37.75,37.98,38.84,38.85,39.11,39.20,39.20,39.76,39.92,39.71,39.32,39.08,39.01,38.96,38.65,38.32,38.02,37.92,37.83,37.71,37.23,37.04,37.24,37.15,36.50,35.59,34.75,34.33,33.82,33.28,32.82,32.40,32.04,31.65,31.20,30.74,30.37,30.04,29.75,29.47,29.24,29.09,28.99,28.88,28.54,28.25,27.98,27.92,27.83,27.63,27.39,27.21,27.07,27,26.98,26.96,26.91,26.86,26.73,26.54,26.36,26.17,26.03,25.96,25.85,25.72,25.53,25.35,25.17,25.08,25,25,25,25,25,25,25,24.98,24.96,24.64,24.34,24.16,24.15,24.15,24.15,24.15,24.15,24.15,24.15,24.15,24.15,24.15,24.11,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,25,24,22.98,22.98,22.98,24,24,24,24,24,24,24,24,24,25,25,25,25,25,25.24,25.50,25.75,25.87,26,26.22,26.50,26.75,26.99,27.07,27.09,27.10,27.12,27.12,27.01,27,27,27,27.98,27.98,27.98,27.98,27.12,27.12,27.04,27.01,27.01,27.07,27.16,27.37,27.63,27.96,28.26,28.57,28.85,29.12,29.50,29.96,30.39,30.70,30.77,30.65,30.49,-1.63,-1.63,-4.50,-6.91,-9.03,-10,-11,-11,-12,-12,-12,-11,-11,-10,-10,-12,-12,-15,-17,-20,-20,-20,-20,-20,-20,-16,-16,-15,-13,-12,-12,-12,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-12,-12,-13,-14,-15,-15,-15,-15,-14,-14,-13,-12,-11,-11,-10,-9.13,-8.13,-7.25,-6.41,-5.63,-4.88,-4.13,-3.38,-2.62,-1.80,-1.03,-0.25,0.75,2.08,2.02,2.46,2.41,2.57,2.70,2.87,3.12,3.50,4.09,5.03,6.59,8.72,11.15,13.35,15.23,16.21,17.13,17.98,18.73,19.38,19.97,20.47,20.90,21.28,21.63,21.96,22.25,22.52,22.82,23.11,23.40,23.72,24.01,24.29,24.62,24.89,25.12,25.25,25.60,25.97,26.28,26.57,26.96,27.36,27.73,28.02,28.37,28.71,29.23,29.82,30.12,30.89,30.98,30.98,30.98,30.98,30.98,32,32,32,31.97,31.99,32.11,32.98,33.85,33.84,33.82,34.17,35.15,36.85,37.13,38.09,38.91,39.10,39.87,39.87,40,40.09,39.78,39.28,39.25,39.14,39,38.77,38.28,38.24,38.12,38.08,37.75,37.21,37.03,37.12,36.97,36.33,35.57,34.87,34.47,34.03,33.50,32.99,32.58,32.21,31.83,31.38,30.98,30.62,30.29,30,29.71,29.41,29.22,29.10,29,28.66,28.35,28.01,27.99,27.87,27.64,27.42,27.23,27.10,27.01,26.98,26.96,26.91,26.85,26.72,26.54,26.36,26.17,26.04,25.95,25.85,25.67,25.50,25.33,25.15,25.07,25,25,24.99,24.99,24.99,24.98,24.98,24.97,24.87,25,24.03,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,23.97,23.95,23.87,23.87,23.87,23.87,23.87,23.87,23.96,23.98,24,24,24,24,24,24,24,24,22.98,22.98,22.98,24,24,24,24,24,24,24,24,24,24,24,25,25,25,25.12,25.35,25.58,25.75,25.87,26,26.22,26.45,26.61,26.64,26.70,26.62,26.62,26.88,26.96,27,27,27,27,27,27,27,27.07,27,26.99,26.98,26.98,27.01,27.12,27.33,27.59,27.89,28.22,28.50,28.77,29.07,29.41,29.87,30.33,30.67,30.62,30.47,29.71,-1.16,-1.16,-4.05,-6.75,-8.62,-10,-11,-12,-12,-13,-13,-12,-12,-11,-10,-12,-12,-15,-18,-20,-20,-20,-20,-20,-20,-17,-17,-16,-15,-13,-12,-12,-12,-13,-12,-12,-12,-12,-12,-12,-12,-12,-11,-12,-12,-12,-12,-12,-13,-14,-16,-15,-15,-15,-15,-15,-14,-13,-13,-12,-11,-10,-9.92,-9.04,-8.25,-7.41,-6.64,-5.99,-5.25,-4.50,-3.75,-2.99,-2.15,-1.30,-0.39,0.37,1.16,1.65,2.25,2.29,2.41,2.63,2.88,3.23,3.74,4.54,5.87,7.74,10.03,12.57,14.58,15.62,16.50,17.37,18.14,18.87,19.50,20.07,20.54,20.98,21.36,21.71,22.02,22.35,22.66,23,23.34,23.70,24.04,24.41,24.77,25.09,25.33,25.45,25.82,26.15,26.48,26.79,27.14,27.57,27.98,28.26,28.38,28.78,29.26,29.83,30.10,30.95,30.98,30.98,30.98,30.98,32,32,32,32,32,32,32.92,33.03,33.89,34.10,34.11,34.11,35.11,36.89,37.07,37.99,38.99,39.01,39.90,40.12,40.79,40.21,40.12,39.87,39.73,39.27,39.28,39.11,38.87,38.73,38.23,38.21,38.78,37.16,37.02,37,36.86,36.34,35.77,35.25,34.96,34.50,33.96,33.38,32.91,32.50,32.08,31.64,31.24,30.88,30.59,30.28,29.99,29.66,29.42,29.25,29.11,28.82,28.39,28.25,28.15,27.97,27.72,27.49,27.27,27.12,27.03,26.99,26.96,26.90,26.84,26.72,26.54,26.37,26.20,26.04,25.92,25.82,25.67,25.49,25.32,25.15,25.07,25,25,24.99,24.98,24.98,24.97,24.87,24.96,25,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,23.74,23.61,23.62,23.62,23.62,23.64,23.75,23.87,23.96,24,24,24,24,24,24,24,24,22.98,22.98,22.98,24,24,24,24,24,24,24,24,24,24,24,24,25,25,25,25.12,25.35,25.50,25.62,25.71,25.83,25.99,26.12,26.23,26.25,26.25,26.07,26,26,25.98,27,27,27,27,27,27,26.92,26.88,26.95,26.91,26.91,26.97,27.08,27.25,27.51,27.82,28.12,28.38,28.64,28.91,29.26,29.67,30.09,30.37,30.34,30.03,29.88,0,0,-2.93,-5.75,-8.25,-10,-11,-12,-13,-13,-13,-13,-12,-11,-11,-11,-12,-16,-20,-20,-20,-20,-20,-18,-17,-16,-16,-15,-15,-13,-11,-11,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-12,-12,-12,-12,-12,-12,-13,-15,-15,-15,-16,-16,-15,-15,-14,-14,-13,-13,-12,-11,-10,-9.92,-9.16,-8.42,-7.75,-7.04,-6.38,-5.63,-4.88,-4.13,-3.29,-2.50,-1.63,-0.88,-0.24,-0.13,0.78,1.76,2.17,2.42,2.62,2.88,3.26,3.87,4.87,6.50,8.72,11.37,13.87,14.86,15.92,16.74,17.57,18.34,19.03,19.65,20.21,20.66,21.09,21.47,21.83,22.16,22.51,22.88,23.26,23.67,24.12,24.57,24.99,25.34,25.60,25.84,26.12,26.47,26.78,27.12,27.48,27.89,28.46,28.59,28.76,28.95,29.25,29.87,30.03,30.98,30.98,30.98,32,32,32,32,32,32.98,32.98,32.98,34,34,34,34,35,35,35,37,37,37.98,39,39,40.92,40.88,40.85,40.82,40.77,40.17,39.87,39.79,39.75,39.75,39.24,38.87,38.77,38.79,37.99,37.12,37.01,36.98,36.85,36.50,36.13,35.83,35.59,35.17,34.58,33.89,33.35,32.85,32.37,31.91,31.50,31.15,30.87,30.60,30.28,29.99,29.73,29.50,29.25,28.98,28.77,28.64,28.37,28.11,27.83,27.57,27.36,27.20,27.09,27.01,26.97,26.91,26.84,26.72,26.54,26.37,26.20,26.04,25.91,25.79,25.65,25.49,25.29,25.13,25.03,25,25,25,24.99,24.89,25,25,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,22.98,23.14,23.25,23.32,23.32,23.35,23.50,23.75,23.97,24,24,24,24,24,24,24,22.98,22.98,22.98,24,24,24,24,24,24,24,24,24,24,24,24,24,25,25,25,25,25.12,25.24,25.25,25.34,25.37,25.50,25.71,25.85,25.95,25.98,26,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,26,26.90,26.85,26.76,26.79,26.88,27.01,27.20,27.42,27.72,27.99,28.24,28.48,28.74,29.07,29.40,29.73,29.91,29.92,29.85,28.90,0.37,0.37,-2.43,-5.25,-7.88,-10,-11,-12,-13,-14,-14,-14,-13,-12,-11,-11,-12,-15,-19,-19,-18,-18,-18,-17,-16,-15,-15,-14,-14,-12,-10,-10,-11,-12,-12,-12,-12,-12,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-13,-15,-15,-15,-15,-16,-16,-15,-15,-14,-14,-13,-12,-12,-11,-10,-10,-9.43,-8.78,-8.13,-7.50,-6.76,-6.02,-5.26,-4.50,-3.63,-2.79,-2,-1.30,-0.62,0.25,1.32,2.01,2.21,2.39,2.66,3.03,3.54,4.35,5.54,7.26,9.98,12.57,14.08,15.12,16.10,16.98,17.78,18.59,19.27,19.87,20.38,20.84,21.24,21.62,21.99,22.37,22.75,23.20,23.63,24.14,24.67,25.20,25.62,25.90,26.16,26.46,26.79,27.12,27.42,27.78,28.22,28.60,28.95,29.09,29.15,29.22,29.89,30,30.49,30.98,30.98,32,32,32.49,32.49,32.50,32.89,33,33.49,33.96,34,34.47,34.50,35,35,35,37,37,37.98,38.49,39,40.98,40.96,40.96,40.92,40.83,40.16,40.01,40.12,40.27,40.27,39.20,39,38.95,38.85,37.98,37.09,37,36.99,36.97,36.85,36.65,36.45,36.23,35.82,35.11,34.37,33.66,33.11,32.62,32.16,31.76,31.45,31.16,30.88,30.60,30.28,30,29.76,29.45,29.15,29,28.85,28.60,28.25,27.97,27.67,27.47,27.27,27.13,27.04,26.99,26.91,26.84,26.72,26.54,26.37,26.20,26.03,25.90,25.77,25.63,25.48,25.29,25.14,25.04,25,25,25,24.99,24.87,24.50,24.50,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,23.49,23.49,23.49,22.98,22.98,22.98,22.98,22.98,22.98,22.98,24,24,24,24,24,24,24,24,24,22.98,22.98,22.98,24,24,24,24,24,24,24,24,24,24,24,24,24,24.50,24.50,25,25,25,25.01,25.08,25.09,25.10,25.10,25.37,25.37,25.57,25.88,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,26.41,26.46,26.47,26.59,26.75,26.96,27.11,27.34,27.60,27.86,28.08,28.27,28.51,28.78,29.08,29.28,29.41,29.46,29.38,28.92,0.75,0.75,-2,-4.88,-7.75,-10,-12,-13,-13,-14,-14,-14,-13,-12,-12,-11,-12,-14,-18,-18,-17,-17,-17,-16,-15,-15,-15,-13,-13,-12,-10,-10,-11,-12,-12,-12,-12,-12,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-13,-15,-15,-15,-16,-16,-16,-15,-15,-14,-14,-13,-13,-12,-12,-11,-10,-10,-9.86,-9.25,-8.63,-7.90,-7.16,-6.40,-5.63,-4.76,-3.90,-3.05,-2.25,-1.36,-0.37,0.75,1.90,1.90,2.12,2.40,2.77,3.22,3.84,4.74,6.04,8.57,11.24,13.40,14.02,15.08,16.21,17.26,18.21,18.99,19.62,20.15,20.62,21.02,21.41,21.82,22.21,22.60,23.02,23.51,24.09,24.73,25.39,25.97,26.28,26.35,26.79,27.13,27.45,27.74,28.09,28.47,28.84,29.17,29.62,29.28,29.14,29.95,30,30,30.98,30.98,32,32,32.89,32.87,32.97,33.12,33.12,33.85,34,34.11,34.88,35,35,35,35,37,37,37.98,37.98,39,40.98,40.98,41,41.03,40.87,40.12,40.13,40.14,40.83,40.83,39.14,39.01,38.99,38.89,38.03,37.01,37,37,37.21,37.26,37.21,37.01,36.73,36.34,35.48,34.62,33.74,33.28,32.85,32.45,32.08,31.76,31.49,31.22,30.89,30.59,30.26,30.01,29.96,29,29,28.88,28.71,28.42,28.13,27.85,27.60,27.37,27.21,27.09,27,26.92,26.84,26.72,26.54,26.37,26.20,26.02,25.88,25.75,25.62,25.46,25.28,25.14,25.03,24.99,25,24.99,24.99,24.86,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,24,24,24,24,24,24,24,24,24,22.98,22.98,22.98,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,25,25,25,25,25,25,25,25.01,25.07,25.01,25,25.96,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,26,26.07,26.11,26.14,26.75,26.83,27.03,27.22,27.48,27.74,27.97,28.12,28.28,28.47,28.62,28.75,28.83,28.87,28.90,28.98,1.21,1.21,-1.50,-4.41,-7.43,-10,-11,-13,-13,-14,-14,-14,-13,-12,-12,-11,-11,-13,-16,-17,-16,-16,-15,-15,-15,-13,-13,-12,-12,-11,-10,-10,-12,-12,-12,-12,-12,-12,-12,-11,-10,-10,-11,-12,-12,-13,-13,-13,-15,-15,-17,-17,-17,-17,-16,-16,-15,-15,-14,-14,-13,-13,-12,-12,-11,-11,-10,-10,-9.66,-9,-8.29,-7.53,-6.75,-5.88,-5,-4.05,-3.13,-2.13,-1.03,0.12,1.12,1.48,1.75,2.12,2.50,2.90,3.38,4.03,4.98,7.10,9.28,11.57,12.41,13.74,15.15,16.47,17.58,18.49,19.21,19.78,20.28,20.74,21.14,21.54,21.96,22.36,22.78,23.27,23.87,24.58,25.51,26.32,26.75,26.85,27.22,27.52,27.74,28.04,28.41,28.87,29.24,29.53,29.72,29.76,29.86,29.98,30.10,30.22,30.40,31.13,31.96,32.01,32.87,32.86,33.13,33.75,33.75,33.87,34.21,34.83,35.83,35.87,35.89,35.96,35.98,37,37,37.98,37.98,39,42,42,42,40.98,40.95,40.90,40.89,40.88,40.87,40.87,39.09,39.08,39.07,38.97,37.98,37.98,37.98,37.98,37.97,37.88,37.75,37.50,37.20,36.82,35.79,34.86,33.86,33.46,33.07,32.72,32.47,32.12,31.88,31.58,31.22,30.87,30.70,30,30,30,29,28.99,28.87,28.62,28.33,28,27.72,27.48,27.26,27.12,27.01,26.92,26.85,26.72,26.54,26.37,26.17,26.01,25.87,25.73,25.59,25.41,25.26,25.12,25.01,24.95,24.90,24.96,24.86,24.85,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,24,24,24,24,24,24,24,22.98,22.98,22.98,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,25,25,25,25,25,25,25,25,25,25,25,25,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.99,26,26.11,26.12,26.79,26.97,27.08,27.24,27.74,27.83,27.99,28.08,28.15,28.16,28.12,28.11,28.07,28.01,27.98,1.59,1.59,-0.88,-3.92,-7.01,-9.75,-11,-12,-13,-14,-14,-14,-13,-13,-12,-11,-11,-11,-15,-15,-16,-16,-15,-15,-15,-12,-12,-12,-12,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-11,-9.29,-9.29,-10,-11,-12,-13,-13,-13,-15,-15,-17,-17,-18,-18,-18,-16,-16,-15,-15,-14,-14,-13,-13,-13,-12,-12,-11,-11,-10,-10,-9.39,-8.64,-7.86,-6.93,-6,-5.01,-4,-2.92,-1.77,-0.63,0.40,0.88,1.33,1.78,2.25,2.65,3.07,3.51,4.12,5.63,7.25,8.75,10.16,12.11,13.96,15.61,16.92,17.96,18.75,19.39,19.92,20.39,20.84,21.25,21.64,22.04,22.48,22.96,23.53,24.27,24.98,25.12,26.20,27.72,27.64,27.73,28,28.33,28.85,29.32,29.64,29.92,30.12,30.23,30.28,30.35,30.38,30.41,30.66,31.15,31.67,32.12,32.12,32.75,33.22,33.74,34.08,34.23,34.25,35.21,35.85,36.12,36.08,36,35.99,37,37,37.98,37.98,39,40.98,40.98,40.98,40.98,40.98,40.98,40.98,40.98,40.98,40.98,40,40,39,39,39,37.98,37.98,37.98,39,38.97,38.26,37.85,37.62,37.25,36.21,35.07,34.25,33.98,33.64,33.34,33.09,32.76,32.50,32.10,31.75,31.26,31,30.98,30,30,29,29.25,29.10,28.83,28.51,28.16,27.85,27.54,27.34,27.15,27.03,26.95,26.85,26.72,26.54,26.37,26.16,26,25.85,25.70,25.53,25.38,25.24,25.10,24.98,24.88,24.78,24.70,24.66,24.15,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,24,24,24,24,24,24,22.98,22.98,22.98,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,25,25,25,25,25,25,25,25,25,25,25,25.22,25.39,25.62,25.62,25.75,25.87,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,26,26.09,26.85,26.83,26.83,27,27.20,27.77,27.77,27.79,27.87,27.98,27.99,27.99,27.99,27.98,27.98,2.62,2.62,-0.18,-3.42,-6.55,-9.26,-11,-12,-13,-14,-14,-14,-13,-13,-12,-11,-10,-9.77,-11,-12,-15,-15,-15,-13,-13,-12,-12,-11,-11,-9.63,-11,-11,-12,-13,-13,-12,-12,-12,-12,-12,-10,-10,-9.18,-9.63,-11,-13,-13,-15,-15,-15,-16,-16,-18,-18,-19,-16,-16,-15,-15,-14,-14,-14,-14,-13,-13,-13,-12,-12,-11,-11,-10,-9.65,-8.86,-7.91,-6.93,-5.90,-4.86,-3.68,-2.52,-1.38,-0.38,0.27,0.88,1.48,2.01,2.50,2.87,3.20,3.62,4.40,5.29,6.39,7.78,10.25,12.79,14.79,16.32,17.41,18.28,18.98,19.53,20.03,20.49,20.89,21.29,21.71,22.12,22.58,23.10,23.74,24.95,25.12,25.84,26.22,27.25,27.75,28.12,28.57,29.08,29.61,30,30.35,30.59,30.73,30.82,30.85,30.87,30.95,31.10,31.41,31.78,32.12,32.47,32.75,33.25,33.86,34.26,34.70,34.87,35.25,36.75,36.76,36.85,36.88,37.12,37.50,38.10,38.39,39,39.62,40.21,40.39,40.82,40.98,40.98,42,42,42,40.98,40.98,40,40,40,40,40,40,40,40,40,40,38,38.09,37.96,37.60,36.60,35.61,34.85,34.62,34.29,33.96,33.67,33.36,33.01,32.54,32.14,31.97,32,30.98,30.98,30.98,30,29.54,29.37,29.09,28.70,28.32,27.95,27.62,27.37,27.20,27.07,26.96,26.85,26.71,26.53,26.36,26.15,25.98,25.82,25.64,25.50,25.35,25.20,25.07,24.95,24.83,24.66,24.39,24.29,24.14,24.02,24,24,24,24,24,24,24,24,24,24,24,24,24,24,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,25,25,25,25,25,25,25,25,25,25.11,25.22,25.25,25.37,25.49,25.64,25.88,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,26.03,26.07,26.09,26.11,26.85,27.03,27.14,27.14,27.12,27.87,27.88,27.90,27.96,27.98,27.98,27.98,2.74,2.74,0.13,-3,-6.13,-8.76,-10,-11,-12,-13,-14,-14,-13,-13,-12,-11,-10,-10,-10,-12,-15,-15,-15,-13,-13,-12,-12,-11,-10,-9.43,-11,-11,-12,-13,-13,-13,-13,-13,-12,-12,-10,-10,-10,-10,-11,-13,-13,-15,-15,-15,-16,-16,-18,-18,-19,-16,-16,-15,-15,-15,-14,-14,-14,-14,-14,-13,-13,-13,-12,-12,-11,-10,-9.77,-8.88,-7.88,-6.76,-5.63,-4.43,-3.25,-2.05,-1.03,-0.22,0.48,1.16,1.84,2.37,2.75,3.01,3.28,3.65,4,4.77,6.23,8.89,12,14.17,15.84,16.98,17.83,18.53,19.14,19.65,20.11,20.52,20.91,21.33,21.73,22.15,22.64,23.04,24.97,25.11,25.50,26.13,26.97,27.64,28.03,28.50,29.08,29.71,30.23,30.67,31.01,31.25,31.39,31.47,31.50,31.53,31.64,31.83,32.08,32.36,32.67,33.12,33.62,34.13,34.61,34.84,35.14,35.75,36.73,36.95,37,37.14,37.62,38.12,38.60,38.95,39.39,39.89,40.35,40.62,40.84,41.12,41.49,42,42,42,41.49,40.98,40.49,40.49,40.49,40.49,40.49,40.49,40.49,40,40,40,38.49,38.48,38.07,38.22,37.12,35.99,35.47,35.25,34.91,34.47,34.12,33.79,33.46,32.98,32.48,32,32,31.49,30.98,30.98,30,29.87,29.63,29.28,28.87,28.42,28.02,27.67,27.40,27.21,27.08,26.96,26.85,26.71,26.53,26.35,26.14,25.96,25.77,25.62,25.46,25.29,25.14,25,24.90,24.77,24.60,24.37,24.15,24.07,24.01,24,24,24,24,24,24,24,24,24,24,24,24,23.49,23.49,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,23.49,22.98,22.98,22.98,23.49,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,25,25,25,25,25,25,25,25,25,25,25.07,25.09,25.11,25.25,25.50,25.75,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.99,26,26.03,26.49,26.90,27,27.01,27.07,27.41,27.47,27.49,27.49,27.98,27.98,27.98,2.86,2.86,0.57,-2.43,-5.54,-8.25,-9.86,-11,-12,-13,-13,-13,-13,-13,-13,-12,-12,-11,-11,-12,-15,-15,-15,-13,-12,-12,-12,-11,-9.29,-9.25,-11,-11,-12,-13,-13,-13,-13,-13,-12,-12,-11,-11,-11,-11,-11,-13,-13,-15,-15,-15,-16,-16,-17,-18,-18,-17,-17,-16,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-13,-12,-12,-11,-10,-9.65,-8.63,-7.50,-6.38,-5.13,-3.89,-2.67,-1.63,-0.68,0.10,0.88,1.64,2.27,2.70,2.91,3.09,3.28,3.66,4.37,5.75,8.24,11.22,14.07,15.82,16.51,17.37,18.13,18.76,19.28,19.73,20.12,20.53,20.92,21.33,21.75,22.15,23.09,24.92,25.07,25.12,26,26.85,27.51,27.88,28.36,28.95,29.62,30.28,30.88,31.39,31.78,32.03,32.16,32.22,32.25,32.28,32.38,32.53,32.77,33.10,33.53,34.04,34.62,34.87,35.09,35.34,36.01,36.71,36.99,37.12,37.47,37.98,38.46,38.85,39.25,39.75,40.24,40.63,40.96,41.20,41.46,41.71,42,42,42,42,40.98,40.98,40.98,40.98,40.98,40.98,40.98,40.98,40,40,40,39,39,37.98,38.98,37.92,36.02,36.03,35.89,35.08,34.92,34.04,34.03,33.98,32.98,32.98,32,32,32,30.98,30.98,30,30.15,29.89,29.49,29,28.50,28.10,27.74,27.45,27.24,27.09,26.97,26.86,26.72,26.53,26.35,26.13,25.95,25.75,25.59,25.41,25.25,25.12,24.98,24.88,24.75,24.57,24.34,24.13,24.02,24,24,24,24,24,24,24,24,24,24,24,24,24,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.97,22.97,22.97,22.97,22.97,22.97,22.97,22.97,23,23.14,23.78,23.02,22.98,22.98,22.98,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,25,25,25,25,25,25,25,25,25,25,25,25,25,25.12,25.36,25.62,25.95,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,27,27,27,27,27,27,27,27,27.98,27.98,27.98,2.98,2.98,1.21,-1.78,-4.77,-7.13,-9,-10,-11,-12,-13,-13,-13,-13,-13,-13,-13,-12,-12,-13,-15,-15,-15,-13,-12,-11,-11,-9.89,-8.79,-9.52,-12,-12,-12,-13,-15,-15,-15,-13,-13,-12,-12,-12,-12,-12,-12,-13,-13,-15,-15,-15,-17,-17,-18,-18,-18,-17,-17,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-13,-12,-12,-11,-10,-9.28,-8.15,-7,-5.75,-4.50,-3.29,-2.13,-1.13,-0.29,0.61,1.48,2.20,2.63,2.87,3,3.14,3.45,4.04,5.21,7.39,10.29,13.59,15.11,15.99,17,17.86,18.49,18.99,19.37,19.73,20.12,20.66,20.87,21.21,22.10,23.11,24.92,24.97,25.09,25.98,26.78,27.28,27.64,28.08,28.71,29.46,30.25,31.02,31.77,32.38,32.77,32.92,32.96,32.97,33,33.08,33.17,33.36,33.63,34.03,34.51,35.02,35.32,35.36,35.83,36.32,36.76,37.12,37.39,37.85,38.33,38.75,39.12,39.51,40.10,40.62,41.12,41.38,41.62,41.83,41.87,42,42,42,42,42,42,42,42.98,42.98,42.98,40.98,40.98,40.98,40.98,40,40,40,40,40,39,37,37,35.98,35.98,35.98,35,35,34,34,32.98,32,32,32,32,30.98,30.98,30.47,30.13,29.64,29.11,28.59,28.12,27.78,27.50,27.27,27.12,26.99,26.86,26.72,26.53,26.34,26.12,25.92,25.75,25.57,25.39,25.24,25.09,24.97,24.87,24.74,24.54,24.34,24.12,24.02,24,24,24,24.02,25,24,24,24,24,24,24,24,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.97,22.97,22.96,22.96,22.96,22.96,22.96,22.96,22.96,23,23.07,23,22.88,22.77,22.97,22.98,22.98,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,25,25,25,25,25,25,25,25,25,25,25,25,25,25.08,25.23,25.47,25.70,25.85,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,27,27,27,27,27,27,27,27,27,27,2.98,2.98,1.87,-1,-3.63,-6.03,-8.02,-9.63,-10,-11,-12,-13,-13,-13,-13,-14,-14,-14,-14,-14,-15,-15,-15,-13,-12,-10,-10,-9.90,-10,-10,-12,-12,-12,-13,-15,-15,-15,-15,-13,-13,-12,-12,-12,-13,-13,-15,-15,-15,-16,-16,-18,-18,-20,-20,-18,-16,-16,-15,-15,-15,-15,-16,-16,-16,-16,-16,-16,-15,-14,-14,-13,-12,-11,-10,-9.90,-8.75,-7.54,-6.29,-5.04,-3.87,-2.66,-1.63,-0.64,0.28,1.29,2.12,2.62,2.85,2.96,3.08,3.28,3.75,4.59,6.15,8.77,11.86,13.21,14.50,15.98,17.10,17.91,18.52,19,19.37,19.99,20.33,20.28,21,21.79,22.83,23.90,24,24.97,25.87,26.62,27.17,27.27,27.75,28.42,29.26,30.17,31.12,32.12,33.03,33.57,33.65,33.64,33.64,33.72,33.78,33.87,34.02,34.25,34.61,35.01,35.42,35.75,36.11,36.34,36.95,37.22,37.50,37.86,38.25,38.72,39.12,39.50,39.99,40.50,41.12,41.64,42,42.20,42.26,42.45,42.46,42,42,42.98,42.98,42.98,42.98,44,44,42.98,42,42,42,40.98,40.98,42,42,40.98,40,40,37.98,37.98,37,37,35.98,35,35,35,34,34,32.98,32.98,32,32,32,30.98,30.79,30.35,29.78,29.20,28.65,28.21,27.85,27.58,27.35,27.15,27,26.87,26.71,26.52,26.34,26.12,25.91,25.74,25.54,25.37,25.22,25.08,24.96,24.86,24.73,24.53,24.34,24.13,24.02,23.99,23.99,24,24.04,24.99,25,25,24,24,24,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.97,22.97,22.96,22.96,22.96,22.96,22.96,22.96,22.96,22.96,22.97,22.89,22.76,22.58,22.37,22.25,22.96,22.98,22.98,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25.11,25.25,25.39,25.64,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,27,27,27,27,27,27,27,27,27,27,2.98,2.98,2.61,0.14,-2.63,-5,-7,-8.65,-10,-11,-12,-12,-13,-13,-14,-14,-14,-15,-15,-16,-16,-16,-17,-16,-15,-12,-12,-12,-11,-11,-11,-11,-12,-12,-13,-13,-13,-15,-15,-13,-15,-15,-15,-15,-16,-17,-17,-17,-17,-18,-20,-20,-20,-20,-20,-17,-17,-15,-15,-15,-16,-16,-17,-17,-17,-17,-16,-16,-15,-14,-14,-13,-12,-11,-10,-9.25,-8.02,-6.77,-5.51,-4.28,-3.13,-2,-0.99,-0.04,1.20,2.07,2.63,2.83,2.91,3.01,3.16,3.50,4.10,5.16,6.95,9.12,10.74,12.79,14.63,16.25,17.41,18.20,18.62,19.21,19.77,20.63,20.66,20.25,21.20,22.14,22.11,22,22.98,24,25.42,26.32,26.83,27.36,28.12,29.04,30.08,31.15,32.35,33.52,34.16,34.23,34.22,34.21,34.29,34.42,34.54,34.71,34.90,35.20,35.53,35.91,36.34,36.76,37.62,37.63,37.76,38,38.26,38.71,39.12,39.62,40,40.46,40.99,41.63,42.25,42.63,42.84,42.87,43,43.37,44,44,44,44,45,45,45,45,44,44,44,42.98,42.98,42.98,42,42,42,42,40.98,39,39,37.98,37.98,37,35.98,35.98,35.98,35,35,34,34,32.98,32,32,30.98,30.97,30.47,29.88,29.28,28.74,28.29,27.96,27.65,27.40,27.22,27.03,26.88,26.72,26.52,26.34,26.12,25.91,25.74,25.54,25.37,25.22,25.07,24.96,24.85,24.71,24.52,24.34,24.13,24.02,23.99,23.99,24,24.09,24.01,24,24,24,24,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.97,22.97,22.96,22.96,22.96,22.96,22.96,22.96,22.96,22.96,22.96,22.92,22.82,22.62,22.39,22.16,22.49,22.75,22.96,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,24,24,24,24,24,24,24,24,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25.09,25.22,25.50,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,27,27,27,27,27,27,27,2.98,2.98,2.61,1,-1.67,-4,-6,-7.68,-9.14,-10,-11,-12,-13,-13,-14,-15,-15,-15,-16,-17,-17,-18,-18,-17,-15,-12,-12,-12,-11,-11,-10,-10,-11,-12,-13,-14,-14,-15,-15,-14,-15,-15,-15,-15,-16,-18,-18,-18,-18,-19,-20,-20,-20,-20,-20,-17,-17,-15,-15,-15,-17,-17,-18,-18,-18,-17,-17,-16,-16,-15,-14,-13,-12,-11,-10,-9.63,-8.38,-7.13,-5.88,-4.63,-3.43,-2.28,-1.17,-0.13,1,2.33,2.66,2.83,2.91,3,3.10,3.34,3.74,4.49,5.89,7.29,9.12,11,13.27,15.39,17.26,18.13,18.50,19,19.62,20.14,20.29,20.26,21.01,21.84,22.37,22.49,23.49,24.50,25.24,25.84,26.40,26.98,27.83,28.76,29.85,31,32.27,33.61,34.37,34.50,34.52,34.58,34.73,34.91,35.13,35.34,35.54,35.78,36.08,36.40,36.82,37.46,38.12,38.37,38.46,38.58,38.75,39.12,39.59,40.08,40.49,40.85,41.37,42.12,42.87,43.34,43.48,43.50,43.62,43.82,44,44,44.50,44.50,45,45,45,45,44.50,44.50,44.50,43.49,43.49,43.49,42.49,42.49,42.49,42,40.98,39,39,38.49,38.49,37.49,36.49,36.49,35.98,35.49,35,34,34,32.98,32.49,32,30.98,30.97,30.61,29.98,29.36,28.84,28.42,28.09,27.77,27.50,27.27,27.08,26.89,26.72,26.52,26.34,26.12,25.91,25.74,25.54,25.37,25.21,25.04,24.92,24.83,24.66,24.50,24.33,24.13,24.02,23.99,23.97,23.97,23.97,23.98,24,24,23.96,23.49,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.97,22.97,22.96,22.96,22.96,22.96,22.96,22.96,22.96,22.96,22.96,22.96,22.90,22.75,22.52,22.37,22.40,22.59,22.79,22.91,22.97,22.98,22.98,22.98,22.98,22.98,22.98,22.98,23.49,24,24,24,24,24,24,24,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25.12,25.37,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,27,27,27,27,27,27,27,2.98,2.98,2.61,1.37,-0.93,-3.13,-5.01,-6.75,-8.25,-9.63,-10,-11,-12,-13,-14,-15,-15,-16,-17,-17,-18,-18,-18,-18,-16,-12,-12,-12,-12,-12,-10,-10,-11,-12,-12,-15,-15,-15,-15,-15,-15,-15,-16,-16,-17,-18,-18,-20,-20,-20,-20,-20,-20,-20,-20,-17,-17,-15,-15,-15,-17,-18,-19,-19,-18,-18,-17,-17,-16,-15,-14,-13,-13,-12,-10,-9.76,-8.54,-7.38,-6.13,-4.88,-3.67,-2.50,-1.37,-0.13,0.98,2.61,2.72,2.84,2.92,2.98,3.04,3.23,3.59,4.22,5.27,6.41,7.91,9.66,12.03,14.61,17.57,18.01,18.37,18.79,19.37,19.87,20.14,20.36,21.11,21.90,22.75,23.09,24.09,25.07,25.62,26.02,26.35,26.86,27.59,28.58,29.62,30.75,32,33.14,34,34.41,34.62,34.76,35,35.28,35.61,35.89,36.15,36.39,36.64,36.89,37.23,37.77,38.65,38.87,39,39.12,39.25,39.50,39.89,40.37,40.75,41.12,41.71,42.50,43.37,44,44.10,44.12,44.21,44.25,44,44,45,45,45,45,45,45,45,45,45,44,44,44,42.98,42.98,42.98,42,40.98,39,39,39,39,37.98,37,37,35.98,35.98,35,34,34,32.98,32.98,32,30.98,30.98,30.64,30.03,29.50,29,28.59,28.23,27.89,27.62,27.36,27.12,26.90,26.72,26.52,26.33,26.12,25.91,25.74,25.53,25.37,25.20,25.03,24.90,24.77,24.62,24.47,24.28,24.12,24.02,23.98,23.95,23.90,23.87,23.88,23.97,23.85,23.64,23.13,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.97,22.97,22.96,22.96,22.96,22.96,22.96,22.96,22.96,22.96,22.96,22.96,22.96,22.87,22.67,22.47,22.38,22.53,22.75,22.88,22.92,22.97,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,24,24,24,24,24,24,24,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25.11,25.37,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,27,27,27,27,27,27,27,2.98,2.98,2.70,1.70,-0.37,-2.25,-4.13,-5.78,-7.38,-8.78,-10,-11,-12,-13,-14,-15,-16,-16,-17,-18,-18,-19,-19,-19,-17,-12,-12,-12,-12,-12,-10,-10,-10,-12,-12,-15,-15,-15,-16,-16,-17,-17,-17,-17,-18,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-17,-17,-15,-15,-15,-17,-18,-19,-19,-19,-18,-18,-17,-16,-15,-14,-14,-13,-12,-10,-9.79,-8.63,-7.39,-6.25,-5,-3.80,-2.63,-1.49,-0.13,0.87,2.64,2.64,2.91,2.95,2.98,3.01,3.14,3.46,3.99,4.87,5.82,6.75,8.62,10.47,14,17.57,17.70,18.26,18.88,19.45,19.88,20.25,20.40,21.28,22.12,22.87,23.13,24.85,26.87,26.46,26.67,26.87,27.24,27.79,28.66,29.57,30.59,31.71,32.76,33.63,34.21,34.57,34.84,35.15,35.57,36,36.40,36.75,37.02,37.28,37.50,37.37,38.14,38.75,39.25,39.75,39.70,39.75,39.87,40.25,40.72,41.09,41.49,42,43,43.95,44.50,44.71,44.75,44.84,44.89,45,45,45,45,45.98,45.98,45.98,45,45,45,45,45,45,44,42.98,42.98,42.98,42,40.98,40,40,40,39,39,37,37,37,35.98,35.98,34,34,34,32.98,32,30.98,30.91,30.60,30.12,29.62,29.13,28.72,28.35,28,27.71,27.42,27.16,26.95,26.73,26.51,26.33,26.12,25.91,25.73,25.53,25.36,25.17,25.01,24.87,24.74,24.58,24.40,24.25,24.11,24.01,23.97,23.90,23.84,23.75,23.70,23.62,23.50,23.32,23.12,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.97,22.96,22.96,22.96,22.96,22.96,22.96,22.96,22.96,22.96,22.95,22.91,22.88,22.82,22.58,22.38,22.39,22.61,22.86,22.95,22.96,22.97,22.97,22.98,22.98,22.98,22.98,22.98,22.98,22.98,24,24,24,24,24,24,24,24,24,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25.09,25.37,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,27,27,27,27,27,27,27,2.98,2.98,2.82,1.84,0.25,-1.50,-3.25,-4.89,-6.49,-7.92,-9.37,-10,-11,-13,-14,-15,-16,-16,-17,-18,-19,-19,-19,-19,-19,-14,-13,-12,-12,-11,-10,-10,-10,-11,-12,-15,-15,-16,-17,-17,-18,-18,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-17,-17,-16,-15,-15,-17,-17,-19,-19,-19,-19,-18,-17,-16,-15,-14,-13,-13,-11,-10,-9.66,-8.50,-7.27,-6.13,-5,-3.86,-2.66,-1.53,-0.36,0.87,2.75,2.75,2.98,2.98,2.98,2.98,3,3.23,3.71,4.33,5.60,6.37,7.47,10.34,13.24,16.50,16.88,17.78,19.52,19.65,20.25,20.48,21.15,21.38,22.45,23.54,24.35,25.36,26.72,27.26,27.58,27.87,28.21,28.62,29.22,29.89,30.73,31.63,32.57,33.38,34.02,34.49,34.88,35.29,35.79,36.35,36.87,37.29,37.67,38,38.24,38.37,38.32,39.27,39.95,40.12,40.25,40.25,40.37,40.62,41.09,41.49,41.98,42.62,43.57,44.49,45.12,45.25,45.33,45.49,45.73,45.98,45.98,45.98,45.98,45.98,45.98,45.98,45.98,45.98,45.98,45.98,45.97,45.02,44.88,44.11,43.87,43.11,42.12,41.87,41.07,40.99,40.97,40,39,37.98,37.98,37,37,35.98,35,35,34,32.98,32.98,31.45,31.12,30.71,30.24,29.75,29.26,28.85,28.47,28.12,27.78,27.49,27.22,26.97,26.74,26.51,26.32,26.12,25.90,25.73,25.52,25.35,25.15,25,24.84,24.67,24.51,24.36,24.20,24.09,24,23.95,23.86,23.75,23.62,23.47,23.32,23.22,23.12,23.01,22.98,22.97,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.97,22.96,22.96,22.96,22.96,22.96,22.96,22.96,22.96,22.96,22.91,22.86,22.75,22.60,22.40,22.32,22.37,22.62,22.85,22.96,22.96,22.97,22.97,22.98,22.98,22.98,22.98,22.98,22.98,22.98,24,24,24,24,24,24,24,24,24,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25.07,25.25,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,27,27,27,27,27,27,27,2.98,2.98,2.98,2.48,0.75,-0.87,-2.49,-4.02,-5.54,-7.02,-8.50,-9.88,-11,-12,-13,-14,-15,-16,-17,-18,-19,-19,-19,-19,-19,-15,-14,-12,-11,-10,-10,-10,-10,-11,-12,-15,-15,-16,-17,-18,-18,-18,-18,-18,-20,-20,-20,-20,-20,-20,-18,-18,-20,-18,-18,-16,-16,-16,-15,-15,-16,-16,-18,-20,-20,-19,-18,-17,-16,-15,-14,-13,-12,-11,-10,-9.38,-8.24,-7.01,-5.88,-4.76,-3.74,-2.63,-1.52,-0.18,1.21,2.95,2.95,2.98,2.98,2.98,2.98,3,3.21,3.73,4.39,5.39,6.52,7.99,10.07,12.51,14.48,15.98,16.86,18.39,19.54,21.48,21.49,21.78,22.41,23.29,24.41,25.15,26.11,27.24,27.99,28.54,28.97,29.34,29.71,30.12,30.62,31.21,31.89,32.64,33.37,34.01,34.53,35.01,35.52,36.11,36.74,37.35,37.87,38.33,38.70,39,39.27,39.70,40.16,40.60,40.79,40.87,40.95,41.07,41.25,41.61,42,42.50,43.24,44.12,45.10,45.62,45.87,45.88,46.11,46.50,47,47,47.98,47.98,47.98,47.98,47.98,47.98,47.98,47,46.88,46.83,46.75,45.71,45.10,44.65,44,43.72,42.75,42.12,41.87,41.88,40.90,40,39,39,39,37.98,37,35.98,35.98,35,34,32.84,32.11,31.40,30.89,30.39,29.89,29.41,28.99,28.59,28.22,27.87,27.54,27.25,27,26.75,26.52,26.32,26.11,25.90,25.72,25.52,25.35,25.14,24.98,24.82,24.63,24.47,24.28,24.15,24.07,23.99,23.91,23.82,23.65,23.49,23.27,23.08,23.03,23,22.98,22.96,22.97,22.97,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.97,22.95,22.96,22.96,22.96,22.96,22.96,22.96,22.96,22.96,22.88,22.75,22.52,22.35,22.20,22.21,22.35,22.62,22.85,22.96,22.96,22.97,22.97,22.98,22.98,22.98,22.98,22.98,22.98,22.98,24,24,24,24,24,24,24,24,24,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25.12,25,25,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,27,27,27,27,27,27,2.98,2.98,2.98,2.62,1.21,-0.26,-1.75,-3.18,-4.63,-6.11,-7.50,-8.90,-10,-11,-12,-13,-14,-15,-16,-17,-18,-19,-19,-19,-18,-15,-14,-12,-11,-10,-10,-10,-10,-11,-12,-15,-15,-16,-17,-18,-18,-18,-18,-18,-18,-18,-18,-19,-19,-18,-17,-17,-18,-17,-16,-16,-16,-16,-15,-15,-16,-16,-18,-19,-20,-18,-17,-16,-16,-15,-14,-13,-12,-11,-10,-8.92,-7.75,-6.63,-5.50,-4.42,-3.50,-2.50,-1.43,-0.03,1.36,2.97,2.97,2.98,2.98,2.98,2.98,3,3.20,3.76,4.57,5.42,6.60,8.04,9.89,11.89,13.71,15.20,16.54,17.92,19.61,21.35,21.85,22.36,23.07,24,24.95,25.88,26.79,27.89,28.73,29.45,30.01,30.48,30.87,31.22,31.57,31.99,32.49,33.08,33.70,34.26,34.82,35.35,35.91,36.57,37.25,37.91,38.58,39.08,39.48,39.82,40.17,40.62,41.10,41.41,41.57,41.61,41.64,41.77,41.99,42.27,42.59,43.09,43.76,44.73,45.63,46.35,46.45,46.50,46.62,46.82,47,47.49,47.98,47.98,48.49,48.49,48.49,47.98,47.90,47.62,47.45,47.23,46.75,46.24,45.72,45.24,44.82,44.27,43.62,42.77,42.35,41.97,41.37,40.48,39.50,39.50,39,38.49,37.49,35.98,35.98,35,34.08,33.21,32.38,31.73,31.13,30.60,30.08,29.59,29.13,28.73,28.34,27.97,27.62,27.32,27.02,26.76,26.53,26.33,26.11,25.90,25.73,25.52,25.35,25.14,24.97,24.77,24.61,24.41,24.25,24.12,24.03,23.98,23.89,23.77,23.60,23.39,23.15,23,22.96,22.96,22.96,22.96,22.96,22.97,22.97,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.96,22.91,22.88,22.90,22.91,22.92,22.95,22.95,22.96,22.96,22.96,22.86,22.66,22.37,22.15,22.07,22.14,22.36,22.65,22.87,22.96,22.96,22.97,22.97,22.98,22.98,22.98,22.98,22.98,22.98,22.98,23.49,24,24,24,24,24,24,24,24,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,27,27,27,27,27,27,2.98,2.98,2.98,2.76,1.58,0.25,-1.02,-2.37,-3.65,-5.03,-6.50,-7.88,-9.25,-10,-11,-12,-14,-15,-16,-17,-18,-18,-18,-19,-18,-16,-14,-12,-11,-10,-10,-10,-11,-12,-12,-15,-15,-16,-17,-18,-18,-18,-17,-17,-17,-17,-17,-18,-18,-17,-16,-16,-16,-16,-15,-16,-16,-16,-15,-15,-16,-16,-17,-18,-20,-18,-17,-16,-15,-14,-13,-12,-11,-10,-9.49,-8.29,-7.15,-6.03,-5,-4,-3.11,-2.15,-1.38,0.12,1.50,2.98,2.98,2.98,2.98,2.98,2.98,3.09,3.25,3.90,4.61,5.45,6.53,7.95,9.64,11.60,13.26,14.75,16.07,17.52,19.21,21.20,21.74,22.50,23.42,24.62,25.72,26.67,27.60,28.58,29.41,30.22,30.90,31.49,31.95,32.32,32.62,32.95,33.33,33.77,34.29,34.83,35.36,35.91,36.52,37.22,37.95,38.74,39.39,39.97,40.37,40.73,41.09,41.54,42,42.35,42.49,42.47,42.50,42.64,42.87,43.12,43.42,43.64,44.35,45.36,46.25,46.82,47.10,47.20,47.25,47,47,47.98,47.98,47.98,49,49,49,48,48.12,48.24,48.01,47.62,47.12,46.50,46.34,45.99,45.51,45.09,44.50,43.37,42.88,42.25,41.84,41.02,40.01,40,39,39,37.98,35.98,35.98,35.09,34.42,33.57,32.75,32.03,31.40,30.84,30.28,29.77,29.32,28.87,28.47,28.08,27.72,27.37,27.08,26.79,26.57,26.34,26.12,25.90,25.73,25.52,25.35,25.14,24.97,24.76,24.59,24.38,24.23,24.11,24.02,23.97,23.88,23.75,23.57,23.35,23.12,23,22.96,22.96,22.96,22.96,22.96,22.95,22.96,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.96,22.90,22.87,22.72,22.75,22.78,22.84,22.87,22.89,22.91,22.92,22.95,22.92,22.79,22.54,22.23,22.02,22,22.17,22.45,22.72,22.88,22.96,22.96,22.97,22.97,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,24,24,24,24,24,24,24,24,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,27,27,27,27,27,27,2.98,2.98,2.98,2.98,2.09,0.87,-0.26,-1.38,-2.63,-3.93,-5.36,-6.68,-8.03,-9.38,-10,-11,-12,-14,-15,-16,-17,-17,-18,-18,-17,-15,-14,-13,-12,-10,-10,-10,-11,-12,-12,-15,-15,-15,-16,-17,-17,-17,-16,-16,-16,-15,-15,-15,-15,-15,-13,-13,-13,-15,-15,-15,-15,-15,-15,-16,-16,-16,-17,-17,-17,-17,-16,-15,-15,-14,-13,-12,-10,-9.79,-8.64,-7.53,-6.41,-5.37,-4.28,-3.37,-2.52,-1.88,-0.80,0.50,1.73,2.98,2.98,2.98,2.98,2.98,3,3.09,3.63,4.08,4.65,5.41,6.40,7.67,9.25,11.13,13.54,14.21,15.46,16.91,18.54,20.07,21.15,22.32,23.36,24.92,27.24,27.42,28.23,29.17,30.04,30.91,31.67,32.36,32.90,33.36,33.71,34,34.33,34.71,35.13,35.62,36.13,36.71,37.34,38.03,38.86,39.62,40.37,41,41.48,41.82,42.14,42.59,43.07,43.46,43.66,43.74,43.76,43.88,44.09,44.29,44.59,44.75,45.22,46.22,46.99,47.50,47.85,48,48,47.98,47.98,47.98,49,49,49,49,49.01,49.12,49.12,49.08,48.85,48.34,47.58,47.37,47.24,47,46.63,46.08,45.12,44.32,43.52,43.01,42.25,41.85,41.07,40.97,40,39,39,37,37,36,35.02,34.09,33.20,32.40,31.74,31.12,30.52,30,29.50,29.03,28.61,28.17,27.79,27.45,27.12,26.85,26.59,26.35,26.12,25.91,25.73,25.52,25.35,25.14,24.96,24.76,24.58,24.37,24.22,24.10,24.01,23.97,23.87,23.75,23.53,23.33,23.11,22.99,22.96,22.96,22.96,22.96,22.96,22.91,22.82,22.97,22,22,22,22,22,22.03,22.09,22.12,22.15,22.45,22.51,22.59,22.64,22.72,22.76,22.83,22.87,22.88,22.87,22.71,22.39,22.04,21.90,22.01,22.32,22.60,22.82,22.91,22.96,22.96,22.97,22.97,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,24,24,24,24,24,24,24,24,24,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,27,27,27,27,27,27,2.98,2.98,2.98,2.98,2.82,1.32,0.62,-0.38,-1.50,-2.77,-4.13,-5.43,-6.75,-8.01,-9.25,-10,-11,-12,-14,-15,-15,-16,-17,-17,-16,-15,-14,-13,-12,-11,-10,-10,-10,-11,-12,-13,-13,-13,-15,-15,-15,-15,-15,-15,-15,-13,-13,-13,-12,-12,-12,-12,-12,-12,-13,-15,-15,-15,-16,-16,-17,-17,-17,-17,-17,-17,-16,-15,-14,-13,-12,-11,-10,-8.91,-7.77,-6.65,-5.61,-4.52,-3.51,-2.50,-1.75,-1.41,-0.38,0.87,2.12,2.98,2.98,2.98,2.98,2.98,4,3.87,3.89,4.24,4.71,5.36,6.22,7.33,8.73,10.47,12.29,13.39,14.63,16.10,17.65,19.07,20.15,21.25,22.65,24.78,27.20,27.76,28.54,29.58,30.67,31.50,32.34,33.08,33.74,34.29,34.75,35.09,35.37,35.72,36.11,36.57,37.07,37.62,38.25,38.98,39.75,40.54,41.37,42.13,42.66,43,43.34,43.74,44.24,44.72,45.08,45.27,45.40,45.53,45.75,46.03,46.35,46.74,46.91,47.75,48.14,48.49,49,49,49,49,49,49,50,50,50,50,50.09,50.21,50.34,50.25,49.97,49.45,48.62,48.63,48.64,48.58,48.12,47.36,46.24,44.60,44.50,44.15,43.27,42.99,42.12,42.02,40.98,40.98,40,37.98,37.98,36.86,35.74,34.67,33.71,32.85,32.09,31.41,30.78,30.23,29.70,29.21,28.74,28.29,27.88,27.51,27.17,26.87,26.61,26.37,26.13,25.92,25.73,25.52,25.35,25.14,24.97,24.76,24.58,24.37,24.22,24.10,24.01,23.97,23.87,23.74,23.53,23.29,23.08,22.98,22.96,22.96,22.96,22.96,22.96,22.88,22.70,22.02,22,22,22,22,21.99,22,22,22,22.01,22.14,22.25,22.28,22.36,22.45,22.53,22.63,22.73,22.77,22.75,22.52,22.15,21.82,21.73,22.02,22.42,22.74,22.89,22.95,22.96,22.96,22.97,22.97,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,24,24,24,24,24,24,24,24,24,24,25,25,24.98,24.96,25,25,25,25,25,25,25,25,25,25,25,25,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,27,27,27,27,27,27,2.98,2.98,2.98,2.98,2.98,2.35,1.73,0.62,-0.42,-1.63,-2.88,-4.13,-5.38,-6.61,-7.76,-9,-10,-11,-12,-13,-14,-15,-15,-15,-15,-14,-14,-13,-12,-12,-12,-12,-11,-10,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-15,-15,-15,-16,-16,-17,-17,-17,-18,-18,-17,-16,-16,-15,-13,-12,-11,-10,-9.18,-8,-6.88,-5.75,-4.67,-3.68,-2.75,-1.67,-0.17,-0.14,0.98,2.12,2.86,2.98,2.98,2.98,2.98,4,4,3.99,4.09,4.32,4.72,5.26,6,6.95,8.12,9.59,10.97,12.29,13.62,15.09,16.66,18.07,19.07,19.60,21.65,23.74,27.16,27.62,28.53,29.65,30.91,31.87,32.76,33.61,34.39,35.12,35.65,36.02,36.36,36.67,37.04,37.50,38,38.54,39.15,39.84,40.60,41.41,42.28,43.13,43.75,44.11,44.45,44.85,45.37,45.96,46.48,46.84,46.98,47.15,47.40,47.78,48.03,48.45,49.51,49.89,49.95,49.97,50.96,50.98,50.98,50.98,50.98,50.98,52,52,52,51.96,51.87,51.72,51.61,51.49,51.38,50.72,50.34,50.23,50.22,50.20,50.22,48.60,47.39,46.59,46.38,45.47,44.85,44.73,43.85,43.88,44,42.98,40.98,39,39,37.61,36.39,35.25,34.21,33.26,32.46,31.73,31.04,30.46,29.88,29.37,28.87,28.40,27.99,27.60,27.25,26.91,26.63,26.38,26.14,25.92,25.74,25.52,25.35,25.14,24.97,24.76,24.58,24.37,24.22,24.10,24.01,23.97,23.88,23.75,23.53,23.27,23.07,22.97,22.96,22.96,22.96,22.96,22.96,22.87,22.58,22.02,22,22,22,21.99,21.99,21.98,21.98,21.98,22,22,21.99,21.98,22,22.08,22.21,22.36,22.50,22.59,22.53,22.32,21.96,21.60,21.62,22.08,22.52,22.83,22.95,22.96,22.96,22.96,22.97,22.97,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,24,24,24,24,24,24,24,24,24,24,24,24,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,27,27,27,27,27,27,27,2.98,2.98,2.98,2.98,2.98,2.51,2.51,1.62,0.63,-0.43,-1.63,-2.78,-3.91,-5.03,-6.18,-7.38,-8.54,-9.75,-10,-11,-12,-13,-14,-14,-14,-14,-13,-13,-12,-12,-12,-12,-11,-10,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-15,-15,-15,-16,-16,-17,-17,-18,-18,-18,-17,-16,-15,-14,-13,-12,-10,-9.50,-8.25,-7.02,-5.88,-4.76,-3.75,-2.87,-1.99,-0.92,0.26,0.26,1.35,2.37,2.88,2.98,2.98,2.98,3.49,4,4,4,4.11,4.35,4.70,5.20,5.83,6.60,7.54,8.75,9.96,11.16,12.47,13.90,15.54,17.12,18.07,19.02,20.86,23.21,26.20,27.28,28.37,29.52,30.77,32.01,32.96,33.88,34.79,35.63,36.32,36.76,37.13,37.50,37.89,38.35,38.85,39.39,39.97,40.62,41.37,42.15,43,43.85,44.49,44.90,45.32,45.75,46.28,46.89,47.53,47.99,48.22,48.46,48.78,49.13,49.50,49.86,50.23,50.47,50.49,50.59,50.98,51.37,51.49,51.50,51.50,51.50,52.48,52.49,53,52.97,52.85,52.62,52.50,52.47,52.25,51.95,51.62,51.48,51.37,51.12,50.52,49.63,48.59,47.76,47.12,46.52,45.96,45.25,44.65,44.37,44,42.98,41.49,39.50,39.50,38.20,36.91,35.74,34.63,33.65,32.78,32,31.32,30.66,30.08,29.51,29,28.52,28.09,27.66,27.29,26.98,26.66,26.40,26.15,25.95,25.74,25.53,25.35,25.14,24.96,24.75,24.58,24.37,24.21,24.09,24.01,23.98,23.89,23.77,23.59,23.27,23.07,22.97,22.96,22.96,22.96,22.96,22.96,22.87,22.57,22.03,22,22,22,21.99,21.98,21.98,21.98,21.98,21.97,21.88,21.76,21.67,21.64,21.71,21.84,22.01,22.22,22.33,22.27,22.08,21.79,21.65,21.79,22.17,22.61,22.87,22.96,22.96,22.96,22.96,22.97,22.97,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,24,24,24,24,24,24,24,24,24,24,24,24,24.50,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,27,27,27,27,27,27,27,2.98,2.98,2.98,2.98,2.98,2.75,2.75,2.26,1.61,0.57,-0.50,-1.50,-2.39,-3.38,-4.50,-5.63,-6.75,-7.93,-9.11,-10,-11,-12,-12,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-15,-16,-16,-16,-17,-17,-18,-18,-18,-18,-17,-16,-15,-14,-12,-11,-9.88,-8.50,-7.24,-6,-4.80,-3.75,-2.76,-2,-1.24,-0.38,0.75,0.75,1.72,2.64,2.98,2.98,2.98,2.98,4,4,4,4,4.12,4.35,4.62,5.13,5.67,6.34,7.11,8.09,9.08,10.13,11.27,12.53,14.16,16.22,17,18.48,20.52,22.67,25.37,27.16,28.33,29.45,30.65,31.86,32.98,33.98,34.96,35.87,36.63,37.23,37.71,38.14,38.61,39.08,39.59,40.13,40.71,41.34,42.02,42.77,43.57,44.32,44.97,45.48,45.92,46.40,46.97,47.58,48.14,48.62,49.03,49.46,49.87,50.27,50.62,50.90,51.12,51.22,51.12,51.12,51.13,51.87,52.15,52.14,52.12,52.12,52.87,53,54,53.99,53.84,53.34,53.47,53.39,53.33,53.01,52.75,52.50,52.33,51.97,51.37,50.50,49.50,48.63,47.97,47.39,46.88,46.07,45.20,44.87,44,42.98,42,40,40,38.59,37.35,36.12,35,34,33.10,32.28,31.54,30.87,30.25,29.66,29.13,28.63,28.17,27.75,27.37,27.01,26.71,26.42,26.17,25.96,25.74,25.53,25.35,25.14,24.96,24.75,24.57,24.37,24.21,24.09,24.01,23.98,23.91,23.85,23.62,23.28,23.08,22.96,22.96,22.96,22.96,22.96,22.96,22.87,22.57,22.03,22,22,21.99,21.99,21.98,21.98,21.98,21.97,21.95,21.75,21.58,21.45,21.37,21.38,21.51,21.72,21.91,22.03,22,21.85,21.70,21.74,21.97,22.35,22.70,22.88,22.96,22.96,22.96,22.96,22.97,22.97,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,24,24,24,24,24,24,24,24,24,24,24,24,24,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,27,27,27,27,27,27,27,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.75,2.36,1.84,0.12,-0.12,-0.75,-1.63,-2.64,-3.76,-4.90,-6.02,-7.17,-8.38,-9.51,-10,-11,-12,-12,-12,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-15,-15,-15,-16,-17,-17,-18,-18,-19,-18,-17,-16,-14,-13,-11,-10,-8.79,-7.38,-6.11,-4.88,-3.67,-2.63,-1.75,-1.02,-0.49,0.34,1.50,1.50,2.46,2.98,2.98,2.98,2.98,4,4,4,4,4,4.13,4.37,4.71,5.12,5.58,6.11,6.73,7.51,8.35,9.21,10.12,11.15,12.12,14.61,15.51,17.49,20.39,23.42,26.25,27.58,28.58,29.63,30.74,31.83,32.87,33.95,35,35.95,36.76,37.49,38.10,38.65,39.17,39.72,40.25,40.79,41.37,41.98,42.62,43.32,44.01,44.72,45.35,45.90,46.41,46.95,47.50,48.08,48.62,49.14,49.67,50.25,50.82,51.33,51.70,51.97,52.12,52.15,52,52,52.25,52.73,53.21,53.75,53.75,53.13,53.85,54.10,55,55.12,55.12,54.95,54.50,54.74,54.60,54.33,54,53.74,53.47,53.01,52.38,51.58,50.50,49.71,48.89,48.46,47.96,47.61,45.20,44.87,44,42.98,42,40,40,39,37.73,36.50,35.36,34.32,33.37,32.54,31.77,31.08,30.41,29.82,29.26,28.75,28.27,27.85,27.45,27.08,26.75,26.46,26.21,25.97,25.75,25.53,25.35,25.14,24.96,24.75,24.57,24.37,24.21,24.09,24.01,23.99,23.98,23.87,23.64,23.29,23.08,22.96,22.96,22.96,22.96,22.96,22.96,22.87,22.57,22.03,22,22,21.99,21.98,21.97,21.96,21.95,21.91,21.82,21.59,21.37,21.24,21.15,21.17,21.28,21.48,21.66,21.76,21.74,21.63,21.61,21.76,22.10,22.47,22.75,22.90,22.96,22.96,22.96,22.97,22.97,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,24,24,24,24,24,24,24,24,24,24,24,24,24,24,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,27,27,27,27,27,27,27,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.86,2.50,1.47,1.47,0.57,0.12,-0.79,-1.88,-2.99,-4,-5.13,-6.38,-7.62,-8.75,-9.78,-10,-11,-12,-12,-13,-13,-13,-13,-12,-12,-12,-12,-13,-13,-15,-15,-15,-15,-15,-15,-13,-13,-12,-12,-13,-13,-13,-13,-13,-13,-13,-14,-14,-15,-15,-16,-17,-17,-18,-18,-18,-16,-15,-13,-12,-10,-9.25,-7.67,-6.25,-4.91,-3.66,-2.51,-1.49,-0.55,0.12,0.62,0.99,2.37,2.37,2.98,2.98,2.98,4,4,4,4,4,4,4.07,4.13,4.50,4.82,5.14,5.57,6,6.50,7.14,7.77,8.40,9.11,9.87,10.95,15.37,15.83,17.40,20.52,23.61,28.23,28.04,28.97,30,31.07,32.09,33.03,34.03,35.02,36.04,36.90,37.70,38.40,39.09,39.73,40.32,40.88,41.45,42,42.58,43.17,43.83,44.48,45.12,45.75,46.34,46.88,47.45,48,48.59,49.12,49.66,50.28,50.99,51.70,52.32,52.77,53.04,53.22,53.27,53.24,53.25,53.25,53.97,54.26,54.73,54.84,54.23,55.20,56.12,56.87,57.13,57.20,56.35,56.48,56.58,56.37,55.74,55.76,55.40,54.84,54.47,53.88,52.83,52.12,50.75,50.39,49.59,49.14,48.62,46.14,45.86,44,42.98,42,40.98,40.98,39.39,38.13,36.89,35.73,34.64,33.66,32.83,32.01,31.27,30.60,29.98,29.39,28.87,28.38,27.92,27.50,27.12,26.78,26.50,26.23,25.98,25.75,25.53,25.35,25.14,24.96,24.75,24.57,24.37,24.20,24.08,24,24,24,23.87,23.64,23.29,23.08,22.96,22.96,22.96,22.96,22.96,22.96,22.87,22.57,22.03,22,22,21.99,21.98,21.96,21.85,21.74,21.65,21.63,21.35,21.20,21.08,21.04,21.07,21.14,21.28,21.45,21.51,21.49,21.46,21.50,21.75,22.11,22.48,22.75,22.89,22.96,22.96,22.97,22.97,22.97,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,25,25,25,25,25,25,25,25,25,25,25,25,25,25.98,25.98,25.96,25.98,25.98,25.98,25.98,25.98,25.98,26,26,27,27,27,27,27,27,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.87,2.50,1.07,-0.17,-1.14,-2.13,-3.24,-4.41,-5.74,-7,-8.26,-9.50,-10,-11,-12,-13,-13,-13,-13,-13,-13,-13,-13,-15,-15,-16,-16,-16,-16,-16,-15,-15,-15,-13,-13,-13,-13,-13,-13,-13,-14,-14,-14,-14,-15,-15,-16,-16,-17,-17,-17,-16,-15,-14,-12,-11,-9.75,-8.13,-6.54,-5.13,-3.87,-2.54,-1.38,-0.38,0.50,1.25,2.33,2.84,2.98,2.98,2.98,2.98,4,4,4,4,4,4,4,4,4.89,4.75,4.96,5.24,5.61,5.99,6.38,6.88,7.36,7.82,8.26,8.90,9.71,13.52,14.38,18.54,21.50,24.20,27.26,28.37,29.32,30.42,31.54,32.61,33.53,34.45,35.34,36.23,37.08,37.89,38.72,39.51,40.27,40.96,41.53,42.09,42.62,43.16,43.75,44.36,44.97,45.59,46.20,46.76,47.36,47.95,48.53,49.12,49.66,50.24,50.88,51.64,52.45,53.15,53.72,54.08,54.28,54.38,54.70,54.65,54.76,55.62,55.62,55.77,56,56.72,56.75,57.75,59.85,59.76,59.76,59.62,59.50,58.50,58.34,58.25,58.21,57.14,56.50,56.13,55.37,55.13,54.21,52.88,52.27,51.39,50.50,48.65,47.15,46.87,45,44,42.98,40.98,40.98,39.87,38.59,37.34,36.12,35,33.99,33.11,32.26,31.50,30.78,30.14,29.57,29,28.50,28.02,27.60,27.21,26.85,26.53,26.25,26,25.76,25.54,25.35,25.14,24.97,24.76,24.57,24.36,24.15,24.03,24,24,24,23.87,23.64,23.29,23.08,22.96,22.96,22.96,22.96,22.96,22.96,22.87,22.61,22.02,22,22,21.99,21.98,21.95,21.74,21.28,21.33,21.24,21.12,21.01,21,21,21,21.04,21.14,21.24,21.27,21.27,21.29,21.45,21.72,22.03,22.37,22.64,22.85,22.92,22.97,22.97,22.97,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,25,25,25,25,25,25,25,25,25,25,25,25,25.01,25.89,25.98,25.98,25.98,25.98,25.98,25.98,25.98,26,26.96,26.99,27,27,27,27,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.95,2.74,2,1.10,0.24,-0.64,-1.63,-2.78,-4.11,-5.43,-6.88,-8.38,-9.75,-11,-12,-13,-13,-14,-14,-14,-14,-14,-14,-15,-15,-16,-16,-16,-15,-15,-15,-15,-15,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-15,-15,-15,-16,-16,-16,-16,-15,-14,-13,-11,-10,-8.67,-7.13,-5.54,-4.13,-2.89,-1.63,-0.42,0.50,1.32,1.96,2.62,2.87,3.49,3.49,3.49,3.49,4,4,4,4,4,4,4.50,4.50,4.97,4.99,5.12,5.37,5.65,6,6.35,6.74,7.10,7.39,7.79,8.45,9.41,13.13,13.89,17.25,20.62,24.03,27.37,28.34,29.47,30.74,32,33.16,34.14,35.02,35.85,36.64,37.45,38.24,39.09,39.96,40.79,41.57,42.20,42.73,43.25,43.79,44.37,44.95,45.52,46.12,46.70,47.25,47.84,48.45,49.08,49.66,50.24,50.82,51.48,52.25,53.09,53.86,54.49,54.91,55.21,55.37,55.49,55.50,55.82,56.13,56.60,56.82,57.12,57.35,57.75,58.72,60.27,60.59,60.75,60.83,60.52,60.25,59.89,59.71,59.25,58.51,57.87,57.25,56.77,56.12,55.32,54.46,53.58,52.62,51.15,49.25,47.12,46.88,45.49,44.50,43.49,41.49,41.49,40.33,39.10,37.79,36.53,35.37,34.32,33.40,32.53,31.75,31.01,30.36,29.74,29.16,28.63,28.14,27.70,27.28,26.91,26.60,26.29,26.03,25.78,25.57,25.36,25.15,24.97,24.77,24.58,24.36,24.14,24.03,24,24,24,23.87,23.64,23.29,23.08,22.96,22.96,22.96,22.96,22.96,22.95,22.85,22.73,22.02,22,22,21.99,21.98,21.95,21.73,21.28,21.07,21.01,21,20.99,20.98,20.98,20.98,21,21.03,21.09,21.11,21.12,21.20,21.38,21.65,21.96,22.23,22.50,22.74,22.90,22.96,22.97,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,25,25,25,25,25,25,25,25,25,25,25,25,25.08,25.87,25.97,25.98,25.98,25.98,25.98,25.98,25.98,26.07,26.89,26.99,26.99,27,27,27,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.62,1.99,1.26,0.61,-0.36,-1.40,-2.65,-4.04,-5.63,-7.30,-8.92,-10,-11,-12,-13,-14,-14,-14,-14,-14,-14,-15,-15,-16,-16,-16,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-14,-14,-15,-15,-15,-15,-15,-15,-15,-15,-14,-13,-11,-10,-9.13,-7.63,-6.13,-4.64,-3.30,-2.13,-0.93,0.23,1.10,1.85,2.37,2.87,2.98,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5.12,5.75,5.83,6,6.32,6.67,7.01,7.28,7.35,8.28,9.28,12.62,13.40,16.01,19.45,23.38,27.35,28.09,29.37,30.87,32.37,33.65,34.72,35.62,36.42,37.22,37.99,38.76,39.61,40.49,41.37,42.15,42.84,43.37,43.91,44.48,45.03,45.61,46.20,46.75,47.29,47.83,48.37,48.98,49.61,50.24,50.83,51.41,52.09,52.86,53.71,54.50,55.17,55.70,56.07,56.32,56.35,56.36,56.36,57.07,57.37,57.77,58,58.25,58.25,59.25,60.75,61.22,61.82,62.01,61.85,61.49,61.37,61.07,60.51,59.77,58.75,58.50,57.96,57.25,56.50,55.63,54.98,53.87,52.35,50.10,47.12,46.95,45.98,45,44,42,42,40.96,39.65,38.27,36.98,35.76,34.70,33.75,32.87,32.04,31.28,30.60,29.95,29.36,28.79,28.28,27.83,27.39,27.01,26.66,26.37,26.09,25.83,25.59,25.37,25.15,24.98,24.77,24.58,24.36,24.14,24.03,24,24,24,23.87,23.64,23.32,23.09,22.97,22.96,22.96,22.96,22.95,22.91,22.83,22.54,22.22,22,22,21.99,21.98,21.95,21.73,21.28,21.01,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.99,21,21,21.01,21.12,21.35,21.62,21.87,22.09,22.27,22.61,22.83,22.97,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,25,25,25,25,25,25,25,25,25,25,25,25,25.10,25.86,25.97,25.98,25.98,25.98,25.98,25.98,25.98,26.10,26.87,26.99,26.99,26.99,27,27,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.50,2,1.37,0.50,-0.54,-1.80,-3.25,-4.79,-6.50,-8.25,-9.88,-11,-12,-13,-14,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-12,-11,-10,-9.16,-7.88,-6.52,-5.13,-3.76,-2.54,-1.43,-0.38,0.64,1.50,2.21,2.62,2.98,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5.89,5.96,6.10,6.12,6.87,7.21,7.25,7.84,8.21,9.25,10.86,11.41,14.51,17.75,21.59,26.36,27.32,28.98,30.87,32.62,34.01,35.15,36.11,36.97,37.79,38.62,39.42,40.26,41.13,42.02,42.86,43.52,44.08,44.64,45.20,45.75,46.35,46.91,47.49,48,48.50,49,49.58,50.20,50.85,51.47,52.10,52.77,53.58,54.41,55.24,55.92,56.51,57,57.38,57.60,57.70,57.83,58.13,58.60,58.87,59,59.25,59.83,60.87,61.76,62.22,63.75,63.15,63.27,63.27,63.02,62.72,62.12,61.37,60.71,60.09,59.50,58.63,57.97,57.37,56.75,55.64,54,51.77,48.07,47.97,47,45.98,45,42.98,42.98,41.90,40.21,38.79,37.45,36.23,35.12,34.16,33.25,32.39,31.61,30.87,30.21,29.58,29,28.47,27.98,27.52,27.12,26.76,26.45,26.14,25.87,25.62,25.38,25.16,24.99,24.78,24.59,24.36,24.14,24.02,24,24,23.99,23.87,23.65,23.34,23.10,22.97,22.96,22.96,22.96,22.95,22.89,22.78,22.59,22.25,22,22,21.99,21.98,21.95,21.73,21.28,21.01,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.97,20.97,20.95,20.95,21.03,21.29,21.61,21.85,21.99,22.11,22.04,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,25,25,25,25,25,25,25,25,25,25,25,25.12,25.84,25.97,25.98,25.98,25.98,25.98,25.98,26.09,26.12,26.87,27,27,26.99,27,27,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.59,2.09,1.32,0.23,-1.11,-2.50,-4.13,-5.86,-7.61,-9.28,-10,-12,-13,-14,-15,-16,-16,-16,-16,-15,-15,-15,-15,-15,-16,-16,-16,-16,-16,-16,-15,-15,-15,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-12,-12,-12,-11,-10,-9.79,-8.75,-7.63,-6.51,-5.36,-4.11,-2.88,-1.78,-0.78,0.20,1.34,2.22,2.32,2.86,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5.98,5.98,5.98,7,7,7.95,8.08,8.12,8.82,9.26,10.61,11.41,13.38,15.57,18.59,24.37,25.70,28.17,30.76,32.87,34.35,35.54,36.52,37.42,38.35,39.26,40.13,41,41.88,42.79,43.63,44.33,44.87,45.41,45.98,46.53,47.12,47.72,48.27,48.79,49.27,49.75,50.26,50.87,51.51,52.16,52.84,53.54,54.37,55.23,56.04,56.78,57.45,58.08,58.71,59.22,59.37,59.38,59.38,60.27,60.37,60.37,60.37,61.32,62.26,63.97,64.15,65.21,65.12,65.25,65.36,65.45,64.50,64.21,63.50,62.62,62.39,61.62,60.62,59.57,59.50,59.32,58.25,56.23,53.87,49.01,49,47.98,47,45.98,44,44,42,40.87,39.28,37.97,36.74,35.62,34.63,33.70,32.79,31.98,31.21,30.49,29.84,29.23,28.66,28.15,27.70,27.26,26.88,26.54,26.23,25.92,25.65,25.41,25.21,25,24.82,24.60,24.35,24.13,24.02,24,24,23.98,23.87,23.66,23.37,23.12,22.99,22.96,22.96,22.96,22.95,22.89,22.82,22.61,22.32,22,21.99,21.99,21.98,21.92,21.74,21.26,21.01,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.97,20.92,20.84,20.86,21.10,21.78,21.85,21.90,22,22,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,23.13,23.62,23.87,24,24,24,24,24,24,24,24,24,24,24,24,24,24,25,25,25,25,25,25,25,25,25,25,25,25.12,25.82,25.97,25.98,26.09,26.13,26.13,26.12,26.12,26.98,27.10,27.11,27,26.99,26.99,27,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.95,2.51,1.87,0.86,-0.50,-1.92,-3.51,-5.25,-7,-8.75,-10,-11,-13,-14,-15,-16,-17,-17,-18,-17,-18,-17,-17,-18,-18,-17,-17,-16,-16,-16,-16,-15,-15,-14,-14,-13,-13,-13,-12,-12,-12,-11,-11,-10,-10,-10,-9.50,-8.75,-7.88,-6.91,-6.04,-5.13,-4.13,-3.04,-2,-1.12,-0.24,0.73,1.87,3.97,3.97,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5.98,5.98,5.98,5.98,7,7,7.98,9,8.95,8.88,9.07,9.25,10.62,11.39,12.49,13.51,15.59,21.38,22.62,27.14,30.83,33.04,34.75,35.95,36.92,37.86,38.86,39.89,40.86,41.76,42.67,43.61,44.48,45.15,45.72,46.24,46.76,47.34,47.90,48.50,49.09,49.62,50.10,50.57,51.07,51.62,52.25,52.89,53.58,54.33,55.15,56.04,56.90,57.70,58.46,59.22,60.04,61.60,61.59,61.59,61.60,62.57,62.57,62.58,63.62,63.63,64.87,67.73,67.75,67.82,67.87,68.84,68.74,68.62,67.52,66.50,65.57,65.40,65.39,64.46,62.58,62,62.51,62.62,61.74,59.85,56.95,52.98,52.98,52,50.98,50,45.98,45.98,44,41.01,39.85,38.50,37.28,36.17,35.17,34.20,33.26,32.38,31.58,30.83,30.12,29.49,28.89,28.37,27.87,27.45,27.03,26.66,26.34,26.01,25.73,25.47,25.25,25.04,24.85,24.61,24.34,24.12,24.01,24,24,23.97,23.87,23.64,23.37,23.13,23,22.96,22.96,22.96,22.95,22.90,22.84,22.62,22.32,22.08,21.99,21.98,21.97,21.88,21.75,21.25,21.01,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.95,20.87,20.65,20.27,20.87,21.16,21.11,21.03,22,22,22,22,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.97,23.09,23.38,23.75,24,24,24,24,24,24,24,24,24,24,24,24,24,24,25,25,25,25,25,25,25,25,25,25,25.02,25.12,25.77,25.97,26,26.14,26.77,27.75,27.75,27.76,27.77,27.83,27.12,27,26.99,26.99,27,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.96,2.48,1.50,0.09,-1.38,-2.91,-4.63,-6.39,-8.24,-9.89,-11,-12,-14,-15,-16,-17,-18,-19,-19,-19,-18,-18,-18,-18,-18,-17,-17,-16,-16,-16,-15,-14,-14,-13,-12,-12,-12,-11,-11,-10,-10,-9.74,-9.11,-8.50,-8,-7.49,-6.88,-6.13,-5.36,-4.63,-3.88,-3,-2.12,-1.25,-0.43,0.34,1.13,2,3.98,3.98,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5.49,5.98,5.98,6.49,6.62,7.11,7.66,8.26,8.83,9.22,9.47,9.75,10.26,10.92,11.75,12.40,13.49,15.04,20.41,21.59,25.99,30.12,33.12,35.14,36.46,37.35,38.29,39.37,40.49,41.52,42.50,43.45,44.38,45.25,45.98,46.57,47.08,47.61,48.13,48.70,49.26,49.86,50.41,50.92,51.41,51.89,52.40,52.98,53.59,54.24,55,55.87,56.78,57.71,58.57,59.41,60.32,61.29,62.11,62.62,62.84,63.13,63.48,63.77,64.26,64.77,65.48,66.26,68.24,68.62,68.87,69,69.87,69.95,69.75,69.14,68.08,67.27,66.87,66.50,65.37,64.14,63.37,64.14,64.24,63.37,61.45,58,54.48,54.48,53.50,52.49,51,46.98,46.98,44.50,41.98,40.36,39.07,37.87,36.78,35.77,34.75,33.77,32.85,31.99,31.17,30.46,29.77,29.15,28.60,28.10,27.62,27.21,26.82,26.47,26.13,25.84,25.57,25.33,25.12,24.90,24.62,24.33,24.08,24,24,24,23.96,23.85,23.62,23.37,23.13,23,22.96,22.96,22.96,22.96,22.92,22.86,22.62,22.32,22.09,21.98,21.98,21.97,21.84,21.49,21.16,21,20.98,20.98,20.98,20.98,20.98,20.98,20.96,20.95,20.89,20.75,20.48,20.25,20.75,20.96,21,21.01,21.49,22,22,22,22.49,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.97,22.98,23,23.35,23.63,23.89,24,24,24,24,24,24,24,24,24,24,24,24,24,24.50,25,25,25,25,25,25,25,25,25,25.12,25.49,25.77,25.98,26.12,26.49,27.21,28.25,28.62,28.82,28.82,28.33,27.12,26.99,26.99,26.99,27,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.62,1.73,0.37,-1.01,-2.52,-4.16,-5.91,-7.66,-9.38,-10,-12,-14,-15,-16,-17,-18,-19,-19,-19,-19,-18,-18,-18,-18,-17,-17,-16,-16,-15,-14,-13,-13,-12,-11,-11,-10,-10,-9.68,-9.25,-8.66,-7.88,-7.13,-6.50,-6,-5.55,-5.13,-4.55,-3.93,-3.38,-2.75,-2,-1.17,-0.49,0.14,0.75,1.51,2.36,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5.98,5.98,5.98,6.73,7.14,7.58,8.08,8.62,9.12,9.59,9.99,10.39,10.88,11.50,12.20,13,13.96,14.50,19.46,20.54,24.45,29.46,33.20,35.97,36.85,37.71,38.75,39.88,41.09,42.20,43.22,44.17,45.13,46.01,46.76,47.39,47.95,48.46,48.98,49.50,50.03,50.62,51.22,51.76,52.27,52.75,53.24,53.73,54.25,54.87,55.60,56.47,57.41,58.38,59.34,60.33,61.32,62.35,63.25,63.37,64.25,64.38,64.37,65.09,65.37,66.25,67.01,67.25,68.87,69.14,70.10,70,71,71.07,71.11,70.82,69.23,68.25,68.25,67.87,66.25,65.25,64.24,66.12,66.08,65,62.98,59,55.98,55.98,55,54,52,47.98,47.98,45,42.98,40.98,39.33,38.50,37.48,36.42,35.37,34.34,33.34,32.40,31.57,30.78,30.09,29.45,28.85,28.32,27.84,27.38,26.99,26.62,26.27,25.98,25.70,25.45,25.22,25,24.76,24,24.01,24,24,24,23.97,23.85,23.62,23.35,23.12,23,22.96,22.96,22.96,22.96,22.96,22.86,22.62,22.32,22.09,21.98,21.99,21.97,21.87,21.15,21.07,20.99,20.98,20.98,20.98,20.98,20.98,20.98,20.95,20.84,20.71,20.67,20.26,20.23,20.78,20.95,20.98,20.98,20.98,22,22,22,22,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.97,22.97,22.96,23,23.25,23.61,23.87,23.98,24,24,24,24,24,24,24,24,24,24,24,24,24,25,25,25,25,25,25,25,25,25.11,25.12,25.77,25.89,26.09,26.15,26.83,27.21,28.76,29.21,29.82,29.82,28.83,27.12,26.99,26.99,26.99,27,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,1.96,0.71,-0.68,-2.13,-3.75,-5.49,-7.18,-8.88,-10,-12,-13,-15,-16,-17,-18,-18,-18,-19,-19,-18,-18,-17,-17,-16,-16,-15,-14,-14,-13,-12,-11,-10,-9.80,-9.25,-8.99,-8.29,-7.61,-7.15,-6.63,-5.75,-4.99,-4.38,-4,-3.68,-3.38,-3,-2.63,-2.13,-1.63,-1,-0.25,0.46,0.75,1.62,2.34,3.75,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5.98,5.98,5.98,7,6.89,7.20,7.61,8.03,8.52,9.03,9.58,10.07,10.53,11,11.51,12.11,12.82,13.62,14.62,16.16,17.75,18.48,22.50,27.16,31.76,36.38,36.89,37.89,39.14,40.47,41.75,42.90,43.97,44.96,45.92,46.84,47.61,48.25,48.84,49.29,49.89,50.37,50.88,51.46,52.03,52.62,53.15,53.64,54.11,54.52,54.98,55.50,56.16,57.01,58,59,59.97,61,62.50,63.32,65.61,65.60,65.75,66.60,66.36,66.62,67.12,67.88,68.87,69.99,70.75,71.12,72.08,72.98,72.98,74,73.96,72.09,71.09,71.87,70.85,70.86,67.87,66.07,67.90,70,70,69,65,62,60,60,57.98,57,55,50,50,47,44,42,40.12,39.16,38.25,37.16,36.03,34.90,33.84,32.85,31.96,31.13,30.38,29.72,29.11,28.54,28.04,27.60,27.20,26.82,26.48,26.15,25.87,25.61,25.35,25.12,24.96,24,24,24,24,24,23.98,23.96,23.62,23.32,23.11,22.99,22.96,22.96,22.96,22.96,22.96,22.86,22.62,22.32,22.09,21.98,21.99,21.98,21.90,21.12,21,20.98,20.98,20.98,20.98,20.98,20.98,20.96,20.91,20.72,20.27,20.25,20.16,20.20,20.83,20.95,20.98,20.98,20.98,20.98,22,22,22,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.97,22.96,22.96,23,23.22,23.50,23.75,23.89,23.98,24,24,24,24,24,24,24,24,24,24,24,24,24,25,25,25,25,25,25,25.09,25.12,25.83,25.98,26.13,26.14,26.76,27.21,28.15,30.75,30.87,31.77,30.15,29.83,27.12,26.99,26.99,26.99,27,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.50,0.83,-0.38,-1.63,-3.26,-5,-6.75,-8.30,-9.86,-11,-12,-14,-15,-16,-17,-17,-17,-17,-17,-17,-16,-15,-15,-15,-14,-13,-12,-12,-11,-10,-9.37,-8.40,-7.64,-7.01,-6.42,-5.75,-5.03,-4.17,-3.64,-2.91,-2.38,-2.02,-1.88,-1.75,-1.55,-1.25,-0.92,-0.51,-0.14,0.33,0.62,1.64,1.70,2.25,2.75,4,4,4,4,5,5,5,5,5,5.98,5.98,5.98,5.98,5.98,5.98,5.98,5.98,5.98,7,7.16,7.48,7.74,8.11,8.53,9.01,9.53,10.07,10.60,11.10,11.61,12.14,12.75,13.46,14.33,15.41,16.73,18.09,19.38,21.38,25.40,29.40,35.57,36.42,37.84,39.41,41.11,42.60,43.84,44.77,45.77,46.83,47.76,48.57,49.17,49.76,50.42,51,51.39,51.85,52.35,52.90,53.48,54.01,54.53,55,55.38,55.75,56.17,56.76,57.57,58.54,59.54,60.50,61.39,62.57,64.25,66.63,66.71,67.25,67.85,68.35,68.33,68.32,69.97,71.25,72.23,73.98,74.12,75.01,75.98,75.98,75,75,74,72.98,72.98,70.98,70.98,69,67,70,72,72,70.98,67.98,65.98,62,62,60.98,59,55.98,50.98,50.98,47.98,45,42.98,40.12,40.23,39.22,38.01,36.73,35.48,34.32,33.25,32.32,31.46,30.67,29.99,29.36,28.78,28.27,27.82,27.40,27.02,26.67,26.36,26.07,25.79,25.59,25.14,25,24,24,24,24,24,24,24,23.62,23.26,23.08,22.96,22.96,22.96,22.96,22.96,22.96,22.86,22.62,22.32,22.09,21.98,21.99,22,21.96,21.09,20.99,20.98,20.98,20.98,20.98,20.98,20.98,20.95,20.83,20.72,20.24,20.08,20.15,20.14,20.87,20.96,20.98,20.98,20.98,20.98,22,22,22,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.97,22.97,22.96,22.96,23,23.12,23.35,23.61,23.84,23.96,24,24,24,24,24,24,24,24,24,24,24,24,24,25,25,25,25,25,25,25.09,25.85,25.98,26.12,26.82,27.20,27.21,28.15,29.21,31.76,31.76,31.77,29.82,28.83,27.12,26.99,26.99,26.99,27,2.98,2.98,2.98,2.98,2.98,2.98,2.98,4,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,1.12,0.01,-1.13,-2.79,-4.51,-6.18,-7.74,-9.13,-10,-11,-13,-14,-14,-15,-15,-15,-15,-15,-15,-14,-13,-13,-12,-12,-11,-10,-10,-9.13,-8.13,-7.02,-6.12,-5.38,-4.75,-3.93,-3.24,-2.52,-1.63,-1.17,-0.63,-0.36,-0.17,-0.16,-0.13,-0.02,0.37,1.12,1.12,1.50,1.84,2.26,2.98,2.98,4,4,4,5,5,5,5,5,5.98,5.98,5.98,5.98,5.98,5.98,5.98,5.98,5.98,5.98,7,7,7.47,7.64,7.90,8.23,8.61,9.03,9.51,10.03,10.58,11.11,11.63,12.16,12.74,13.36,14.09,14.98,16.03,17.29,18.70,20.28,22.25,25.13,28.38,34.59,35.40,37.65,39.53,41.49,44.47,44.77,45.60,46.60,47.75,49.12,49.62,50.21,50.77,51.46,52.58,52.59,52.73,53.26,53.73,54.25,54.82,55.35,55.84,56.23,56.54,56.88,57.36,58.04,59.02,60.36,60.87,61.62,62.37,64.25,66.70,67.22,67.99,69.63,70.62,70.63,70.70,71.72,73.75,75.75,78.85,78.88,79.99,80,80,77,77,75,72.98,72,67.98,67.98,65.98,65.98,67,72.98,72.98,72.98,72,69,62,62,60,57.98,55.98,50.98,50.98,49,45.98,44,42.12,41.37,40.14,38.98,37.38,36,34.75,33.62,32.63,31.75,30.96,30.24,29.60,29.01,28.50,28.02,27.62,27.25,26.87,26.52,26.23,25.98,25.79,25.98,25,24,24,24,24,24,24,24,23.62,23.26,23.08,22.96,22.96,22.96,22.96,22.96,22.96,22.86,22.62,22.32,22.09,21.98,21.99,22,22,21.01,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.95,20.75,20.21,20.12,20.03,20.12,20.88,20.92,20.98,20.98,20.98,20.98,20.98,20.98,20.98,22,22,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.97,22.97,22.96,22.96,22.98,23,23.20,23.45,23.74,23.87,24,24,24,24,24,24,24,24,24,24,24,24,24,25,25,25,25,25,25,25.09,25.86,26.12,26.87,27.77,28.01,28.77,28.99,29.76,30.21,30.20,29.20,28.12,27.90,27.12,26.99,26.99,26.99,27,2.98,2.98,2.98,2.98,2.98,2.98,2.98,4,3.49,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,1.12,0.62,-0.63,-2.28,-4,-5.63,-7.13,-8.38,-9.63,-10,-11,-12,-13,-13,-14,-14,-13,-13,-13,-12,-11,-11,-10,-10,-9.64,-8.80,-7.92,-7.01,-6,-5,-4.13,-3.49,-2.88,-2,-1.29,-0.75,0.21,0.50,0.89,1,1,0.96,0.97,1,1.13,1.73,1.73,2,2.35,2.62,3.49,3.49,4,4,4,5,5,5,5,5,5.98,5.98,5.98,5.98,6.49,6.49,6.49,6.49,6.49,6.49,7.49,7.61,7.78,8.07,8.35,8.67,9.08,9.52,10.01,10.53,11.08,11.60,12.12,12.65,13.24,13.88,14.63,15.51,16.58,17.79,19.21,20.78,22.51,25.09,28.38,34.09,34.89,37.59,39.53,41.48,44.95,45.72,46.50,47.52,48.66,49.67,50.51,51.09,51.65,52.25,52.74,53.12,53.48,53.90,54.40,54.92,55.48,56.04,56.60,57.03,57.36,57.59,57.86,58.37,59.33,60.63,61.15,61.82,62.75,64.23,66.74,67.25,68.25,69.75,71.20,71.74,72.11,72.72,74.20,76.48,78.87,79,80,80,80,76,76,73.50,71.49,69.99,67.49,67.49,65.98,65.98,66.49,71.98,71.98,72.49,71.49,68,61,61,58.99,56.98,54.99,50.98,50.98,49,45.98,44,42.15,41.50,40.60,39.49,37.96,36.38,35.04,33.89,32.88,31.99,31.17,30.46,29.79,29.22,28.70,28.23,27.82,27.42,27.07,26.66,26.34,26.08,25.97,25.98,25,24,24,24,24,24,24,24,23.62,23.26,23.08,22.96,22.96,22.96,22.96,22.96,22.96,22.86,22.62,22.32,22.09,21.98,21.99,22,22,20.98,20.98,20.97,20.97,20.97,20.97,20.97,20.97,20.92,20.82,20.14,20.02,20.01,20.07,20.96,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,22,22,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.97,22.97,22.96,22.96,22.96,22.98,23.11,23.35,23.63,23.87,24,24,24,24,24,24,24,24,24,24,24,24,24,25,25,25,25,25,25,25.08,25.87,26.48,27.12,28.32,28.64,29.27,29.62,29.77,29.63,29.27,28.62,27.98,27.49,27.12,27,26.99,26.99,27,2.98,2.98,2.98,2.98,2.98,2.98,2.98,4,4,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,1.37,1.37,-0.05,-1.75,-3.41,-5.01,-6.39,-7.63,-8.75,-9.77,-10,-11,-12,-12,-12,-12,-12,-11,-11,-10,-10,-9.54,-9.01,-8.43,-7.74,-6.89,-6.12,-5.25,-4.38,-3.50,-2.67,-2.03,-1.50,-0.79,-0.18,0.37,0.86,1.21,1.45,1.58,1.60,1.57,1.60,1.57,1.72,2.25,2.25,2.50,2.84,2.98,4,4,4,4,4,5,5,5,5,5,5.98,5.98,5.98,5.98,7,7,7,7,7,7,7.98,8,8.24,8.49,8.78,9.13,9.54,10.01,10.50,11.02,11.54,12.04,12.53,13.08,13.65,14.32,15.08,15.96,17,18.21,19.58,21.12,22.86,24.89,28.37,33.61,34.38,37.61,39.53,41.49,45.42,46,47.17,48.25,49.39,50.38,51.15,51.76,52.29,52.74,53,53.29,53.73,54.25,54.89,55.52,56.01,56.58,57.25,57.89,58.26,58.33,58.26,58.26,59.25,60.74,61.12,61.85,62.88,64.15,66.75,67.23,68.23,69.87,71.75,72.75,72.75,73.13,74.12,76.87,78.96,79,80,80,80,75,75,72,70,67.98,67,67,65.98,65.98,65.98,70.98,70.98,72,70.98,67,60,60,57.98,55.98,54,50.98,50.98,49,45.98,44,42.13,41.66,40.53,39.36,37.95,36.51,35.23,34.07,33.03,32.13,31.34,30.62,29.97,29.37,28.85,28.37,27.96,27.58,27.16,26.76,26.37,26.12,26,25.67,25.10,24.03,24,24,24,24,24,24,23.63,23.33,23.07,22.96,22.96,22.96,22.96,22.96,22.96,22.86,22.62,22.32,22.09,21.98,21.99,22,22,20.98,20.98,20.98,20.92,20.90,20.88,20.97,20.97,20.87,20.87,20.09,20,20.03,20,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,22,22,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.97,22.97,22.96,22.96,22.96,22.96,23.08,23.26,23.62,23.87,24,24,24,24,24,24,24,24,24,24,24,24,24,25,25,25,25,25,25,25.02,26,26.87,27.12,28.84,29.14,29.83,29.87,29.82,29.10,28.83,28.12,27.82,27.12,27.02,27,26.99,26.99,27,2.98,2.98,2.98,2.98,2.98,4,4,4,4,4,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.12,2.12,0.61,-1,-2.78,-4.41,-5.67,-6.66,-7.67,-8.68,-9.61,-10,-10,-10,-10,-10,-10,-10,-9.79,-9.13,-8.40,-7.75,-7.18,-6.63,-5.90,-5.16,-4.49,-3.75,-3,-2.26,-1.63,-1,-0.49,0.12,0.64,1.13,1.60,1.86,2,2.12,2.13,2.13,2.25,2.37,2.62,2.95,2.95,2.98,2.98,2.98,4,4,4,4,5,5,5,5,5,5.98,5.98,5.98,5.98,7,7,7,7,7,7,7,7.98,8.51,8.74,8.98,9.27,9.63,10.04,10.50,11,11.51,12,12.48,12.92,13.42,14,14.65,15.40,16.28,17.33,18.50,19.87,21.40,23.12,24.37,27.37,31.62,32.37,35.77,38.70,41.47,44.48,45.61,47.26,48.75,50.01,51.15,51.51,52.12,52.89,53,53.12,53.34,53.76,54.51,54.90,55.57,55.88,56.59,57.57,58.62,59.72,59.72,59.24,59.25,59.99,60.75,61.11,61.07,62.87,64.87,66.85,67.14,68.82,69.85,71.02,72.77,72.83,72.85,73.88,74.97,75.98,75.98,77,79,79,74,74,70.98,69,67.98,65.98,65.98,65.98,65,65,67,67,69,67.98,64,60,60,59,57,55,50.98,50.98,47.98,45.98,44,42.12,41.73,40.26,39.08,37.70,36.37,35.16,34.09,33.11,32.22,31.41,30.72,30.07,29.48,28.95,28.48,28.07,27.66,27.25,26.83,26.42,26.14,25.97,25.62,25.20,24.76,24.85,24,24,24,24,24,23.75,23.36,23.01,22.96,22.96,22.96,22.96,22.96,22.95,22.84,22.60,22.25,22.08,21.99,21.99,22,22,20.98,20.98,20.98,20,20,20.98,20.98,20.98,20.98,20,20,20,20,20.98,20.98,22,22,22,22,22,22,20.98,20.98,22,22,22,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.97,22.97,22.96,22.96,22.96,22.96,23.07,23.25,23.59,23.82,23.96,23.98,24,24,24,24,24,24,24,24,24,24,24,25,25,25,25,25,25.98,25.90,26.02,27.10,28.11,29.86,29.87,30.10,30.77,29.14,28.12,28.10,27.83,27.12,27.11,27,27,26.99,27,27,2.98,2.98,2.98,2.98,2.98,4,4,4,4,4,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.86,2.86,1.70,0.01,-1.41,-3.61,-4.38,-5.37,-6.30,-7.27,-8.12,-8.63,-9,-9.18,-9.13,-8.91,-8.63,-8.30,-7.87,-7.25,-6.50,-5.88,-5.50,-4.90,-4.25,-3.63,-3,-2.38,-1.75,-1.13,-0.54,-0.02,0.47,0.95,1.49,2,2.26,2.62,2.74,2.74,2.76,2.76,2.87,2.98,2.98,2.98,2.98,2.98,4,4,4,4,4,5,5,5,5,5,5.98,5.98,5.98,5.98,7,7,7,7.98,7.98,7.98,7.98,7.98,9,9.14,9.34,9.57,9.85,10.20,10.60,11.02,11.50,11.99,12.45,12.87,13.28,13.75,14.28,14.92,15.67,16.57,17.59,18.76,20.12,21.71,23.46,25.63,27.35,31.12,31.32,34.33,38.37,41.39,44.50,45.50,47.10,49.36,50.32,51.12,51.24,51.83,52.83,52.88,52.92,53.20,53.60,54.09,54.63,54.86,55.29,56.03,57.61,58.65,60.75,60.75,59.75,59.76,59.99,61.87,61.89,62,62,64.01,67.87,67.87,68.87,69.87,69.87,70.87,70.87,70.90,70.99,72,74,74,75,75.98,75.98,72.98,72.98,70.98,70,69,67,67,67,65.98,65,64,64,64,64,62,60.98,60.98,60,59,57,50.98,50.98,47.98,45.98,44,41.08,40.85,39.97,38.67,37.35,36.11,35,34,33.10,32.23,31.45,30.75,30.12,29.52,29,28.53,28.13,27.75,27.33,26.87,26.42,26.12,25.95,25.63,25.28,24.98,24.64,24.21,24,24,24,24,24,23.25,23,22.96,22.96,22.96,22.96,22.95,22.87,22.75,22.50,22.23,22,21.99,22,22,22,20.98,20,20,20,20,20,20.98,20.98,20,20,20,20.98,20.98,20.98,22,22,22.98,22.98,24,24,22.98,20.98,20.98,22,22,22,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.97,22.97,22.96,22.96,22.96,22.96,23,23.20,23.46,23.64,23.87,23.96,24,24,24,24,24,24,24,24,24,24,24,25,25,25,25,25,25.98,26,27.01,28.02,29.10,29.98,30.12,30.84,29.85,28.85,27.99,27.84,27.12,27.11,27,27,26.99,26.99,27,27,2.98,2.98,2.98,2.98,2.98,4,4,5.98,5,5,4,4,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.37,0.83,-1.54,-2.68,-3.74,-4.75,-5.75,-6.50,-7.03,-7.30,-7.50,-7.50,-7.38,-7.05,-6.38,-5.87,-5.63,-4.75,-4.38,-4,-3.38,-2.77,-2.16,-1.65,-1.13,-0.63,-0.11,0.45,0.87,1.34,1.71,2.13,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,4,4,4,4,4,4,5,5,5,5,5.98,5.98,5.98,5.98,7,7,7,7,7,7.98,7.98,7.98,9,9,9,9,10,10,9.87,10,10.21,10.48,10.79,11.16,11.58,12,12.45,12.86,13.23,13.61,14.01,14.52,15.15,15.90,16.77,17.79,19,20.37,21.98,23.86,26,29.67,34.67,34.70,36.71,38.62,40.40,44.54,45.46,46.73,48.12,49.21,49.86,50.38,50.86,51.16,51.99,52.50,52.88,53.23,53.62,53.99,54.27,54.26,55.23,56.23,57.22,58.11,58.12,58.97,59.09,59.09,60,60,60.98,62,62,64,64,65,65,65,65.98,65.98,67,69,70,72.98,72.98,75,75.98,75.98,75,75,74,72.98,72,72,72,70,67.98,65.98,60.98,60.98,59,57.98,57,57,57,57,57,55.98,52.98,52.98,50,47,44,41.07,40.78,39.66,38.35,36.99,35.78,34.76,33.92,33.09,32.25,31.48,30.79,30.15,29.57,29.02,28.57,28.16,27.79,27.37,26.87,26.41,26.12,25.91,25.64,25.33,24.99,24.63,24.32,24,24,24,24,24,22.98,23,22.97,22.96,22.96,22.89,22.87,22.75,22.59,22.35,22.12,22,22,22,22,22,20.98,20,20,20,20,20,20,20,20,20,20,20.98,20.98,22,22,22.98,25,25,24,22.98,22.98,20.98,20.98,22,22,22,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.97,22.97,22.97,22.96,22.96,22.96,23,23.08,23.25,23.50,23.75,23.87,24,24,24,24,24,24,24,24,24,24,24,25,25,25,25,25,27,27,27.96,28.96,30.87,30.87,30.87,29.98,29.12,28.11,27.12,27.12,27.11,27,27,26.99,26.99,27,27,27,2.98,2.98,2.98,2.98,2.98,4,4,5.49,5,5,4,4,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.64,1.64,-0.63,-1.38,-2.13,-3.13,-4.13,-4.88,-5.42,-5.75,-5.99,-6,-5.92,-5.75,-5.40,-5,-4.50,-3.86,-3.29,-2.88,-2.25,-1.63,-1,-0.50,0,0.46,0.87,1.34,1.75,2,2.37,2.72,2.98,2.98,2.98,2.98,2.98,2.98,2.98,3.49,4,4,4,4,4.50,4.50,5,5.49,5.49,5.49,5.98,6.49,6.49,6.49,7,7.49,7.49,7.49,7.49,7.98,8.49,8.49,9,9,9,9.50,10,10.49,10.53,10.66,10.89,11.15,11.46,11.77,12.12,12.50,12.87,13.23,13.54,13.87,14.25,14.75,15.36,16.10,16.98,18,19.21,20.60,22.22,24.09,26.25,30.26,35.22,35.75,37.27,38.98,40.85,44.11,44.88,46.15,47.28,48.11,48.72,49.26,49.74,50.34,51.14,51.96,52.51,52.78,53.10,53.49,53.84,54.25,54.86,55.63,56.52,57.49,57.49,58,58.49,58.49,59.50,59.50,60.49,61.49,61.49,63,63,63.99,63.99,64.50,65.49,65.49,67,68.49,70,73.49,73.49,75.49,76.98,77.49,76.49,76.49,75.50,74.48,73.50,73,73,71,68.99,66.98,61.98,61.98,59.99,58.49,57,55.50,55.50,54.99,55.50,54.99,52.98,52.98,50,47,44,41.07,40.84,39.49,38.12,36.74,35.64,34.72,33.91,33.11,32.28,31.53,30.84,30.17,29.59,29.03,28.58,28.20,27.84,27.39,26.88,26.40,26.10,25.89,25.64,25.33,24.99,24.65,24.33,24,24,24,24,24,22.98,22.98,22.97,22.97,22.97,22.95,22.75,22.59,22.33,22.12,22,22,22,22,22,22,20.98,20,20,20,20,20,20,20,20,20,20.49,20.98,20.98,22,22.49,22.98,24.50,24.50,23.49,22.49,22.49,20.98,20.98,21.49,22,22,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.97,22.97,22.97,22.97,22.96,22.96,22.98,23,23.12,23.37,23.64,23.87,24,24,24,24,24,24,24,24,24,24,24.50,25,25,25,25,25.49,27,27,27.98,29.48,30.90,30.97,30.87,29.59,28.49,27.58,27.09,27,27,27,26.99,26.99,27,27,27,27,2.98,2.98,2.98,2.98,2.98,4,4,5,5,5,4,4,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.25,-0.16,-0.27,-0.92,-1.88,-2.80,-3.63,-4.04,-4.38,-4.55,-4.68,-4.79,-4.88,-4.63,-4.13,-3.77,-2.88,-2.67,-1.88,-1.18,-0.50,0.10,0.62,1,1.38,1.76,2.12,2.36,2.50,2.76,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,4,4,4,4,4,5,5,5,5.98,5.98,5.98,5.98,7,7,7,7,7.98,7.98,7.98,7.98,7.98,9,9,9,9,9,10,10,10.98,11.11,11.37,11.62,11.88,12.14,12.41,12.72,13,13.32,13.59,13.86,14.12,14.48,14.92,15.51,16.25,17.13,18.17,19.38,20.78,22.38,24.22,26.20,30.23,35.75,36.20,37.76,39.25,41.26,43.67,44.33,45.64,46.70,47.21,47.75,48.37,48.92,49.50,50.37,51.75,51.90,52.22,52.50,52.96,53.72,53.97,54.82,55.10,55.90,57,57,57,57.98,57.98,59,59,60,60.98,60.98,62,62,62.98,62.98,64,65,65,67,67.98,70,74,74,75.98,77.98,79,77.98,77.98,77,75.98,75,74,74,72,70,67.98,62.98,62.98,60.98,59,57,54,54,52.98,54,54,52.98,52.98,50,47,44,41.03,40.85,39.16,38,36.70,35.39,34.72,34,33.21,32.37,31.59,30.86,30.20,29.59,29.02,28.57,28.20,27.85,27.40,26.89,26.40,26.11,25.88,25.64,25.33,24.99,24.65,24.33,24.01,24,24,24,24,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22,22,22,22,22,22,22,22,22,20.98,20,20,20,20,20,20,20,20,20,20.98,20.98,20.98,22,22.98,22.98,24,24,22.98,22,22,20.98,20.98,20.98,22,22,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.97,22.97,22.97,22.97,22.97,22.96,22.96,22.96,23.07,23.25,23.61,23.87,23.98,24,24,24,24,24,24,24,24,24,25,25,25,25,25,25.98,27,27,27.98,30,30.98,30.96,30.90,28.99,27.90,27.02,27.01,26.99,26.99,26.99,27,27,27,27,27,27,2.98,2.98,2.98,2.98,2.98,4,4,4,5,5,4,4,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,1.39,1.39,0.34,-0.53,-1.43,-2.25,-2.61,-2.80,-3.12,-3.18,-3.25,-3.14,-3,-2.77,-2.25,-1.25,-1.25,-0.75,-0.14,0.37,1.59,1.59,2.07,2.37,2.61,2.95,2.95,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,4,4,4,4,5,5,5,5,5.98,5.98,5.98,5.98,7,7,7.98,7.98,7.98,7.98,9,9,9,9,9,10,10,10,10,10,10.98,10.98,10.98,11.83,12.21,12.46,12.66,12.88,13.11,13.34,13.54,13.76,13.98,14.16,14.39,14.71,15.12,15.67,16.38,17.26,18.33,19.54,20.96,22.54,24.28,26.13,29.15,36.84,36.84,37.83,39.84,41.14,42.75,43.21,44.78,45.76,46.28,47.17,47.88,48.42,49,49.12,50.57,51.20,51.47,51.72,52.22,52.73,53.17,53.84,54.10,54.99,55.98,55.98,55.98,55.98,57,57.98,57.98,59,60,60,60.98,60.98,62,62.98,64,65.98,65.98,67,67.98,70.98,75,75,77.98,80.98,82,82,82,80,79,77.98,75.98,75.98,74,70.98,69,64,64,62,59,55.98,52,52,52,52,52,52,52,49,45.98,44,41.02,40.87,39.15,37.98,36.75,35.37,34.78,34.21,33.40,32.47,31.62,30.87,30.20,29.59,29.02,28.54,28.17,27.84,27.40,26.88,26.39,26.11,25.87,25.63,25.32,24.99,24.64,24.33,24.02,23.98,24,24,24,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22,22,22,22,22,22,22,22,20.98,20.98,20,20,20,20,20,20,20,20,20.98,20.98,20.98,20.98,22,22.98,24,22.98,22.98,22,22,20.98,20.98,20.98,20.98,22,22,22,22,22.98,22.98,22.98,22.98,22.98,22.98,22.97,22.97,22.97,22.97,22.97,22.97,22.97,23,23.13,23.50,23.75,23.98,24,24,24,24,24,24,24,24,25,25,25,25,25,25.98,25.98,27.98,27.98,29,30,30.98,29,29,27.98,27,27,27,27,27,27,27,27,27,27,27,27,2.98,2.98,2.98,2.98,2.98,2.98,2.98,4,5,5,4,4,4,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.62,2.62,1.85,1,0.49,-0.43,-0.41,-0.88,-1.13,-1.38,-1.29,-1.38,-1.25,-1,-0.77,0.45,0.45,0.87,1.25,1.73,2.62,2.62,2.87,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,4,4,5,5,5,5.98,5.98,5.98,5.98,7,7,7,7.98,7.98,9,9,9,9,10,10,10,10,10,10.98,12,12,12,12,12,12,12,12.92,13.16,13.36,13.52,13.70,13.86,14,14.14,14.27,14.40,14.53,14.72,14.97,15.34,15.85,16.51,17.37,18.42,19.66,21.10,22.70,24.42,26.08,28.09,34.88,35.17,37.73,38.97,40.64,42.62,43.17,44.24,45.25,46.26,47.34,47.76,48.49,48.96,49.50,50.03,50.50,50.75,50.88,51.24,51.88,52.16,52.87,53.02,54,55,55,55,55.98,55.98,57,57,57.98,59,59,60.98,60.98,62,62.98,64,67,67,67.98,70,70.98,75.98,75.98,79,82,85,85.98,85.98,84,82,80.98,77.98,77.98,75,72.98,70,65,65,62,59,55.98,52,52,52,52,50.98,50,50,47.98,45.98,44,41,40.88,39.13,38.15,36.90,35.36,35.03,34.48,33.54,32.53,31.64,30.87,30.20,29.59,29.02,28.54,28.16,27.83,27.39,26.88,26.39,26.11,25.87,25.63,25.32,24.99,24.64,24.33,24.02,23.87,23.76,24,24,22.98,22.98,22.98,22.98,22.98,22.98,22,22,22,22,22,22,22,22,20.98,20.98,20.98,20,20,20,20,19,20,20,20.98,20.98,20.98,20.98,20.98,21.99,22,22.01,22.01,21.98,21.98,20.99,20.99,20.98,20.98,20.98,22,22,22,22,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.97,22.97,22.97,22.97,22.97,22.97,22.99,23.01,23.01,23.95,23.97,24,24,24,24,24,24,24,25,25,25,25,25,25.98,25.98,25.98,27.98,27.98,29,30,29,27.98,27.98,27,27,27,27,27,27,27,27,27,27,27,27,27,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,4,4,5,5,4,4,4,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.75,2.21,2.21,2.10,2,2,2,2,2.12,2.37,2.59,2.82,2.82,2.87,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,4,4,4,5,5,5,5.98,5.98,5.98,5.98,7,7.98,7.98,7.98,9,9,9,9,9,10,10.98,10.98,10.98,10.98,12,12,12.98,12.98,12.98,12.98,14,15,15,15,15,15,15,14.16,14.24,14.33,14.42,14.52,14.62,14.73,14.79,14.87,14.91,14.99,15.11,15.28,15.60,16.03,16.66,17.49,18.51,19.75,21.17,22.78,24.59,26.62,29.50,33.33,34.75,36.70,38.36,39.50,41.61,42.38,43.98,45.64,46.92,48.62,48.67,48.96,49.36,49.72,50,50.15,50.25,50.33,50.22,51.82,52.10,52.09,52.96,52.98,54,54,54,55,55,55.98,55.98,57,57.98,59,60.98,60.98,62,62.98,65,67.98,67.98,70.98,72.98,74,79,79,82.98,87,89,90.98,90.98,87,82,80,77,77,74,70.98,67.98,62,62,62,60.98,60,54,54,52.98,52.98,52.98,50.98,50.98,50,47,44,40.98,40.90,39.88,38.85,37.11,36,35.50,34.53,33.63,32.60,31.66,30.87,30.20,29.59,29.02,28.54,28.16,27.82,27.38,26.87,26.39,26.10,25.87,25.63,25.29,24.97,24.63,24.32,24,23.75,23.50,23.10,23.07,23,22.98,22.98,22.98,22,22,22,22,22,22,22,22,20.98,20.98,20.98,20.98,20,20,20,19,19,19.20,19.62,20.11,20.37,20.62,20.87,20.89,21.10,21.25,21.27,21.35,21.35,21.35,21.23,21.07,20.76,20.29,20.17,20.92,20.98,22,22,22,22,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.97,22.97,22.97,22.97,22.97,22.97,22.97,23,23,22.98,24,24,24,24,24,25,25,25,25,25,25.90,25.89,26,26.95,27.01,28.97,28.99,29,27.98,27,27,27,27,27,27,27,27,27,27,27,25.98,25.98,27,27,27,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,3.49,4,5,5,4.50,4.50,4,3.49,3.49,3.49,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.87,2.51,2.51,2.39,2.37,2.37,2.45,2.45,2.51,2.63,2.75,2.87,2.87,2.95,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,3.49,4,4.50,4.50,5,5,5,5.98,5.98,6.49,6.49,7,7.98,7.98,8.49,9.50,9.50,9.50,9.50,9.50,10.49,11.49,11.49,11.49,11.98,12.49,12.49,13.49,13.49,13.49,13.49,14.50,15.49,15.49,15.49,15.49,15.49,15.49,15.33,15.26,15.32,15.36,15.40,15.46,15.49,15.50,15.50,15.50,15.51,15.57,15.70,15.92,16.29,16.87,17.62,18.62,19.85,21.25,22.84,24.65,26.76,29.76,32.90,34.62,36.25,37.88,39.62,41.42,42.41,43.78,45.52,47.47,49.26,49.42,49.54,49.86,50.02,50.12,50.07,50.07,50.20,50.65,51.86,51.99,52.02,52.98,52.98,54,54,54,54.50,55,55.98,55.98,57,57.98,59,60.98,60.98,62,63.49,65,67.98,67.98,70.49,72.49,74.50,79.50,79.50,83.49,88,89.50,90.98,90.98,86.49,81.49,78.99,75.50,75.50,72.49,69.48,66.98,61,61,59.99,59.48,58.99,54,54,52.49,51.98,51.98,50.49,50.49,49.50,46.49,44,40.98,40.96,39.92,38.83,37.23,35.86,35.17,34.51,33.62,32.59,31.65,30.87,30.17,29.58,29.02,28.54,28.15,27.82,27.38,26.87,26.39,26.10,25.87,25.62,25.26,24.90,24.58,24.25,23.95,23.62,23.33,22.98,22.97,22.97,22.87,22.49,22.49,22,22,22,22,22,22,22,22,20.98,20.98,20.98,20.98,20,20,20,19,19,19.33,19.62,20,20.12,20.34,20.61,20.77,20.91,21,21.01,21.01,21.01,21.01,21.01,20.95,20.62,20.36,20.35,20.67,21.13,22,22,22,22,22.49,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,24,24,24,24,24,25,24.99,25,25,25.12,25.85,26.12,26.50,27,27.60,29.37,29.45,28.96,27.98,27,27,27,27,27,27,27,27,27,27,26.49,25.98,25.98,27,27,27,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,4,5,5,5,5,4,4,4,4,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.87,2.87,2.75,2.75,2.75,2.87,2.87,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,4,4,5,5,5,5,5,5.98,5.98,7,7,7,7.98,7.98,9,9.97,9.95,10.01,10.09,10.09,11.02,11.95,12,12,12.98,12.98,12.98,14,14,14,14,15,15.98,15.98,15.98,15.98,15.98,15.98,16.11,16.37,16.32,16.29,16.33,16.33,16.32,16.27,16.23,16.15,16.11,16.10,16.15,16.34,16.64,17.14,17.86,18.82,19.98,21.32,22.79,24.40,26.72,29.50,32.71,34.23,35.87,37.62,39.50,41.25,42.35,43.34,45.33,47.83,49.82,49.91,50.10,50.22,50.75,50.21,50.20,50.17,50.14,51.04,51.91,51.99,52,52.98,52.98,54,54,54,54,55,55.98,55.98,57,57.98,59,60.98,60.98,62,64,65,67.98,67.98,70,72,75,80,80,84,89,90,90.98,90.98,85.98,80.98,77.98,74,74,70.98,67.98,65.98,60,60,57.98,57.98,57.98,54,54,52,50.98,50.98,50,50,49,45.98,44,40.98,40.98,39.96,38.79,37.12,35.37,34.95,34.46,33.53,32.49,31.54,30.78,30.12,29.53,29,28.51,28.13,27.78,27.37,26.87,26.39,26.08,25.84,25.54,25.14,24.75,24.41,24.12,23.82,23.50,23.23,22.98,22.96,22.96,22.84,22.07,22,22,22,22,22,22,22,22,22,20.98,20.98,20.98,20.98,20,20,20,19.33,19,19.34,19.62,19.89,20.04,20.14,20.40,20.62,20.77,20.87,20.88,20.89,20.91,20.92,20.91,20.83,20.50,20.25,20.25,20.57,21.17,21.77,22,22,22,22,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,24,24,24,24,24,24.98,24.98,25,25.01,25.20,25.87,26.20,26.83,27.21,28.13,29.84,29.87,28.88,27.98,27,27,27,27,27,27,27,27,27,27,25.98,25.98,25.98,27,27,27,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,4,5,5,5,5.98,5,4,4,4,4,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,4,4,4,4,4,5,5,5,5.98,5.98,7,7,7,7.98,7.98,9,9,9.01,9.87,10.14,10.75,11,11.20,12,12.77,12.99,13,14,14,14,15,15,15,15.98,15.98,17,17,17,17.98,17.98,17.98,17.98,17.40,17.29,17.33,17.28,17.25,17.20,17.11,17,16.87,16.75,16.70,16.71,16.83,17.09,17.52,18.21,19.10,20.22,21.38,22.77,24.27,26.62,29.12,31.52,33.64,35.46,37.32,39.37,41.14,42.37,43.29,45.25,47.10,49.87,50.13,50.83,51.10,51.11,51.11,51,51,51.08,51.02,51.98,52,52,52.98,52.98,54,54,54,54,55,55.98,55.98,57,57.98,59,62,62,62.98,64,65.98,69,69,70.98,72.98,75,80.98,80.98,84,89,90.98,92,92,87,82,79,74,74,70.98,69,67,59,59,55.98,55,55,52.98,52.98,50,49,49,49,49,47.98,45,42.98,40.98,40.98,40,38.83,36.98,35.35,34.65,34.04,33.45,32.12,31.26,30.58,29.99,29.45,28.91,28.46,28.07,27.71,27.29,26.82,26.35,26,25.71,25.37,24.88,24.46,24.12,23.84,23.59,23.33,23.11,22.97,22.95,22.85,22.75,22.12,22,22,22,22,22,22,22,22,22,20.98,20.98,20.98,20.98,20,20,19.76,19.49,19.14,19.36,19.62,19.87,19.99,20.12,20.25,20.45,20.60,20.70,20.74,20.75,20.79,20.86,20.82,20.60,20.35,20.14,20.14,20.47,21,21.59,21.87,22,22,22,22,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,24,24,24,24,24,24.88,24.97,25,25.07,25.24,26.74,26.84,27.23,27.76,28.23,29.75,29.82,28.95,27.99,27.01,27,27,27,27,27,27,27,27,25.98,25.98,25.98,25.98,27,27,27,4,4,2.98,2.98,2.98,2.98,2.98,2.98,2.98,4,5,5,5.98,5,5,4,4,4,4,4,4,4,4,4,4,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,4,4,4,4,4,4,5,5,5,5,5.98,5.98,5.98,7,7,7.98,7.98,9,9,9,9.87,10.15,11.08,11.72,12.08,12.27,13.15,13.84,14.14,14.38,14.97,15.37,15.72,16.01,16.27,16.52,17.09,17,17.98,17.98,19,19,19,19,19,17.98,18.47,18.41,18.32,18.24,18.12,17.99,17.79,17.62,17.46,17.35,17.32,17.38,17.61,18.02,18.65,19.53,20.66,21.75,22.32,24.49,26.61,28.86,31,33.09,34.96,36.87,38.89,41.89,42.46,43.62,44.76,47.02,50.91,51.03,51.91,51.98,51.99,51.99,51.99,51.99,51.98,52,52,52,52.98,52.98,54,54,54,54,55,55,55.98,55.98,57,57.98,59,62.98,62.98,64,65,65.98,70,70,72,74,75.98,82,82,85,87.98,90.98,92,92,89,84,80,75,75,72.98,70,67,57.98,57.98,55.98,52.98,52,50,50,49,47,45.98,45.98,45.98,45.98,44,42.98,40.98,40.98,40,38.87,36.75,34.84,34.61,33.52,32.47,31.34,30.67,30.13,29.70,29.24,28.76,28.32,27.90,27.52,27.12,26.65,26.22,25.83,25.46,24.99,24.49,24.02,23.71,23.46,23.25,23.08,22.91,22.85,22.74,22.70,22.24,22.11,22,22,22,22,22,22,22,22,22,20.98,20.98,20.98,20.98,20.98,20,20,19.63,19.33,19.37,19.62,19.86,19.96,20.03,20.14,20.26,20.37,20.47,20.50,20.52,20.57,20.57,20.50,20.35,20.15,20.04,20.03,20.37,20.78,21.39,21.75,21.99,22,22,22,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,24,24,24.09,24.85,24.96,25,25.22,25.27,26.70,27.32,27.85,28.26,28.96,29.73,29.75,28.90,27.99,27.09,27,27,27,27,27,27,27,25.98,25.98,25.98,25.98,25.98,27,27,27,4,4,4,2.98,2.98,2.98,2.98,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,4,4,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5.98,7,7,7,7,7.98,7.98,7.98,9,9,10,10,10.09,10.76,11.12,11.77,12.62,13,13.62,14.63,14.87,15.33,15.83,16.25,16.65,17.02,17.33,17.58,17.88,18.37,19.61,20,20,20.98,20.98,20.98,20.98,20.98,20,20,19.47,19.33,19.21,19.07,18.86,18.62,18.37,18.15,18.01,17.96,18,18.20,18.58,19.20,20.03,21.21,22.75,23.25,24.85,26.77,28.76,30.75,32.62,34.48,36.34,38.27,40.12,41.57,42.46,44.24,45.98,52,52,52.98,52.98,52.98,52.98,52.98,52.98,52.98,52.98,54,54,54,54,54,55,55,55,55,55,55.98,55.98,57,57.98,59,62.98,62.98,65,67,67.98,70.98,70.98,72.98,75,77.98,84,84,87.98,90,92,94,94,90.98,87,84,75.98,75.98,72.98,69,65.98,62,62,59,55.98,52.98,49,49,47,45,44,42,42,40.98,40.98,39,35.98,35.98,35,35.12,34.20,33.23,32.91,31.98,30.42,30.17,29.71,29.38,29.15,28.88,28.50,28.09,27.62,27.20,26.76,26.35,25.91,25.50,25.02,24.51,24,23.54,23.23,23,22.86,22.74,22.63,22.62,22.34,22.23,22.11,22,21.99,22,22,22,22,22,22,22,22,20.98,20.98,20.98,20.98,20.96,20.88,20.37,19.87,19.50,19.47,19.64,19.79,19.90,19.99,20.04,20.12,20.20,20.24,20.26,20.27,20.28,20.27,20.23,20.13,20.04,20,20.04,20.28,20.64,21.22,21.62,21.97,21.99,21.99,22.10,22.10,22.09,22.89,22.96,22.97,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,24,24,24.12,24.82,24.96,25.02,25.32,26.22,27.62,28,28.62,28.82,29.25,29.71,29.73,28.89,28,27.12,27,27,27,27,27,25.98,25.98,25.98,25.98,25.98,25.98,25.98,27,27,27,4,4,4,3.49,3.49,3.49,3.49,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5.49,6,5.49,4,4,3.49,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,3.49,4,4,4,4,4,4,4,4.50,4.50,5,5,5,5,5,5,5.49,5.98,7,7,7,7,7.98,8.49,8.49,9,9.50,10,10.49,10.62,11.25,11.75,12.46,13.12,13.75,14.32,14.97,15.75,16.37,16.97,17.40,17.90,18.25,18.50,18.71,19.01,19.58,20.11,20.48,20.49,21.49,21.49,21.49,21.49,21.49,20.49,20.49,20.49,20.25,20.12,19.97,19.70,19.37,19.08,18.85,18.70,18.62,18.64,18.78,19.12,19.70,20.57,21.50,23.25,23.83,25.46,27.15,28.98,30.74,32.40,34.11,35.85,37.62,39.35,40.75,41.90,43.59,45.49,51,51,52.49,52.98,52.98,53.49,53.49,53.49,53.49,53.49,54,54,54,54,54,55,55,55,55.49,55.49,55.98,55.98,57,57.98,59,62.98,62.98,65,66.49,67.98,70.98,70.98,72.98,75,77.98,83.49,83.49,87.49,90,91.49,93.49,93.49,91.49,88,84.99,77.49,77.49,73.99,69.99,67.49,63,63,59.50,56.49,53.49,49,49,47.49,45.49,44,41.49,41.49,39.99,39.48,37.49,34.48,34.48,33.99,33.49,32.86,32.23,31.64,30.63,29.37,28.87,28.50,28.27,28.23,28.34,28.12,27.57,27.15,26.74,26.33,25.87,25.45,25,24.51,23.98,23.48,23.04,22.73,22.51,22.38,22.28,22.23,22.13,22.07,21.99,21.97,21.96,21.97,21.98,21.99,21.99,21.99,22,22,22,21.49,20.98,20.98,20.98,20.98,20.98,20.87,20.50,20,19.62,19.48,19.61,19.75,19.87,19.95,20,20.02,20.07,20.09,20.10,20.10,20.10,20.09,20.07,20.02,20,20,20.04,20.23,20.57,21.12,21.61,21.92,21.98,21.99,21.99,22,22.13,22.85,22.96,22.98,22.98,22.97,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,23.98,24,24.14,24.75,24.96,25.09,25.34,26.35,28.12,28.60,28.87,29.15,29.50,29.75,29.71,28.87,27.99,27.13,27,27,27,27,26.49,25.98,25.98,25.98,25.98,25.98,25.98,25.98,27,27,27,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5.98,7,5.98,4,4,4,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,2.98,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5.98,5.98,7,7,7,7,7.98,9,9,9,10,10,10.98,11.12,11.74,12.26,13,13.71,14.33,14.82,15.62,16.51,17.32,17.90,18.46,18.88,19.27,19.62,19.88,20.25,20.62,20.97,21.12,20.98,21.83,22.12,22.21,22.12,21.87,21.50,21.22,21.15,20.98,21.07,20.84,20.50,20.04,19.73,19.46,19.35,19.29,19.32,19.38,19.60,20.09,20.99,22.24,23.59,24.52,26.25,27.87,29.26,31.12,32.62,33.70,35.57,37.23,38.98,40.21,41.36,42.95,45,50,50,52,52.98,52.98,54,54,54,54,54,54,54,54,54,54,55,55,55,55.98,55.98,55.98,55.98,57,57.98,59,62.98,62.98,65,65.98,67.98,70.98,70.98,72.98,75,77.98,82.98,82.98,87,90,90.98,92.98,92.98,92,89,85.98,79,79,75,70.98,69,64,64,60,57,54,49,49,47.98,45.98,44,40.98,40.98,39,37.98,35.98,32.98,32.98,32.98,32.11,31.83,30.97,30.65,29.63,28.34,27.58,27.12,26.97,27,27.16,27.12,26.73,26.37,26,25.60,25.15,24.72,24.27,23.83,23.35,22.87,22.49,22.21,22,21.88,21.79,21.75,21.71,21.67,21.70,21.75,21.85,21.88,21.91,21.95,21.96,21.97,21.98,22,22,20.98,20.98,20.98,20.98,20.98,20.98,20.87,20.59,20.09,19.62,19.38,19.50,19.63,19.77,19.88,19.96,19.99,20,20,20.01,20.01,20,20,20,20,20,20,20.02,20.13,20.48,21.01,21.59,21.90,21.97,21.98,21.98,22,22.20,22.78,22.96,23.10,23.08,23.03,22.99,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,23.97,24,24.15,24.75,24.98,25.15,25.36,26.36,28.61,29.12,29.34,29.37,29.86,30.07,29.74,28.87,27.87,27.15,27,26.99,27,27,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,27,27,27,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4.75,4.96,5.01,5.33,5.75,6.25,5.59,4.46,4.23,4,4,4,4,4,4,4,3.98,3.96,3.89,3.88,4,4.08,4.07,4,4.98,5,5,5,5,5,5.98,5.98,5.98,5.98,5.98,5.98,7,7,7,7,7.98,7.98,9,9,10,10,10.98,12,11.87,12.25,12.84,13.36,14.58,14.88,15.62,16.40,17.47,18.27,18.97,19.50,20.01,20.48,20.85,21.14,21.50,21.84,22.12,22.21,22.40,22.75,23.10,23.12,23.09,22.76,22.45,22.09,22.02,22,22,22,20.98,20.98,20,20,20,20,20,20,20,20.13,21.37,23,24.40,25.87,27.37,28.99,30.50,32,33.37,34.59,35.75,36.89,38.51,39.58,40.76,42.22,44,47,47,50,52,54,55,55,55,55,55,55,55,55,55,55,55,55,55.98,55.98,55.98,55.98,55.98,57,57,57.98,62,62,64,65.98,67.98,70.98,70.98,72.98,75,77,82,82,85,87.98,89,92,92,90.98,87.98,85,77.98,77.98,75.98,74,70.98,62.98,62.98,60,57.98,55,49,49,47,45.98,44,40,40,37.98,35.98,34,32,32,30.98,30.87,30.12,29.22,28.99,28.24,27.22,26.28,25.72,25.59,25.64,25.75,25.71,25.52,25.25,24.95,24.57,24.13,23.75,23.37,22.99,22.60,22.21,21.87,21.63,21.50,21.37,21.28,21.24,21.22,21.24,21.28,21.37,21.48,21.52,21.58,21.60,21.60,21.61,21.62,21.76,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.87,20.50,20.01,19.60,19.34,19.36,19.51,19.66,19.82,19.90,19.97,19.99,19.99,20,20,20,20,20,20,20,20,20.01,20.11,20.41,20.90,21.50,21.84,21.91,21.97,21.98,22.01,22.25,22.74,22.96,23.15,23.85,23.97,23.97,23.99,24,22.98,22.98,22.98,22.98,22.98,22.98,22.98,23.96,23.87,24.21,24.73,25,25.32,25.95,27.35,29.60,29.71,29.90,30.12,30.24,30.61,30.62,28.72,27.25,27.12,27,26.95,27,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,27,27,27,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4.26,4.62,4.87,5.08,5.25,5.51,5.62,5.37,4.99,4.62,4.36,4,4,4,4,4,4.08,4.12,4.12,4.14,4.14,4.14,4.12,4.87,5.09,5.07,5,5,5.98,5.98,5.98,5.98,5.98,7,7,7,7,7,7.98,7.98,7.98,7.98,9,10,10,10.98,10.98,10.98,12.26,12.71,13.25,13.84,14.50,15.21,15.87,16.60,17.49,18.50,19.35,20.02,20.70,21.25,21.75,22.20,22.57,22.87,23.25,23.58,23.83,24.07,24.37,24.50,24.50,24.35,24.12,23.86,23.63,23.50,23.37,23.25,22.98,22,22,20.98,20.98,20.98,20.98,20.98,20.98,21.02,21.32,22.70,23.96,25.58,27.08,28.62,30.25,31.97,33.32,34.58,35.62,36.75,37.76,39.25,39.58,40.26,41.14,44,45.98,45.98,47.98,50,52,55.98,55.98,55.98,55.98,55.98,55.98,55.98,55.98,55.98,55.98,55.98,55.98,55.98,55.98,55.98,57,57,57,57,57.98,60.98,60.98,62.98,65.98,67.98,70.98,70.98,72,74,75.98,80,80,82.98,85.98,87,90,90,89,85,82,75.98,75.98,75,74,70.98,60.98,60.98,57,55.98,54,49,49,47,45,42.98,40.98,40.98,37.98,35,32.98,30.98,30.98,30,29.96,29,28.14,27.82,27.25,26.26,25.35,24.52,24.53,24.60,24.54,24.48,24.29,24.04,23.75,23.39,23.03,22.70,22.37,22.08,21.77,21.49,21.25,21.10,20.97,20.86,20.77,20.73,20.70,20.72,20.77,20.87,20.96,21.01,21.04,21.04,21.03,21.01,21,20.88,20.76,20.98,20.98,20.98,20.98,20.98,20.87,20.87,20.37,20,19.62,19.35,19.26,19.40,19.54,19.72,19.86,19.92,19.98,19.99,20,20,20,20,20,20,20,20,20,20.11,20.34,20.75,21.24,21.63,21.79,21.96,21.98,22.01,22.23,22.71,22.86,23.21,24.79,24.85,24.88,24.95,24,22.98,22.98,22.98,22.98,22.98,22.98,22.98,23,23.85,24.21,24.73,25,25.35,26.26,27.37,29.60,30.37,30.75,30.87,30.74,30.37,29.62,28.26,27.25,26.89,26.86,26.95,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,25.98,27,27,27.98,7,7,7,7,7,5.98,5.98,5,4,4,4,4,4,4,4,4,4,4.33,4.62,4.87,5.01,5.14,5.37,5.47,5.37,5.23,5.01,4.87,4.82,5,5,4.97,4.87,4.84,4.76,4.75,4.75,4.74,4.75,5.11,5.75,5.82,5.87,5.87,5.95,5.98,5.98,7,7,7.98,7.98,7.98,7.98,9,9,10,10,10,10,10,10.98,10.98,12,12.98,12.85,13.26,13.75,14.24,14.82,15.48,16.12,16.84,17.62,18.59,19.60,20.45,21.20,21.87,22.52,23.12,23.62,24.01,24.37,24.75,25.14,25.48,25.77,26.09,26.15,26.09,25.83,25.61,25.37,25.20,24.95,24.63,24.50,25,24,24,24,24,24,24,24,22.98,22.85,23.46,24.26,25.50,26.86,28.35,29.87,31.57,33.35,35.77,36.10,37.12,38.25,39.52,41.25,41.40,41.83,42.83,42.98,47,47,49,50,52,55,55,57,59,59,59,59,59,59,59,59,59,57.98,57.98,57.98,57.98,57.98,57.98,59,60,62,62,64,65,65.98,70,70,70.98,72,72.98,75.98,75.98,77.98,80,82,84,84,82.98,80,77,70.98,70.98,70,69,65,60,60,55.98,52.98,49,47.98,47.98,47,44,42,37.98,37.98,35.98,32.98,32,30,30,29,29,28.07,27.12,27.21,26.75,26,25.09,24.35,24.01,23.85,23.64,23.46,23.23,22.98,22.66,22.34,22,21.72,21.46,21.23,21,20.79,20.70,20.58,20.46,20.36,20.26,20.22,20.16,20.17,20.24,20.32,20.39,20.47,20.50,20.51,20.50,20.46,20.39,20.37,20.36,20.16,20,20,20,20,20.07,20.10,20.13,19.99,19.73,19.47,19.26,19.32,19.42,19.61,19.76,19.89,19.97,19.99,19.99,20,20,20,20,20,20,20,20,20.08,20.24,20.59,20.99,21.37,21.63,21.87,21.97,22,22.13,22.29,22.76,23.24,24.76,25,25.84,25.88,24.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,23,23.85,24.21,24.73,25,25.35,26.36,28.37,31.60,31.60,31.60,31.60,31.61,30.37,29.62,28.26,27.25,26.75,26.12,26,25.98,25.98,25,25.98,25.98,25.98,25.98,25.98,27,27,27,27,27.98,7.49,7.49,7.49,8,8,5.98,5.98,5,4,4,4,4,4,4,4,4,4.07,4.33,4.63,4.88,5.12,5.25,5.50,5.61,5.62,5.50,5.47,5.37,5.37,5.32,5.10,5.01,5,5,4.96,4.89,4.95,5,5.22,5.62,6.23,6.38,6.46,6.49,6.49,6.49,6.49,7,7.49,7.98,8.49,8.49,8.49,9,9.50,10,10,10.49,10.49,11,11.49,11.49,12.49,13.26,13.95,14.25,14.64,15.12,15.73,16.38,17.10,17.77,18.62,19.62,20.62,21.52,22.37,23.12,23.87,24.51,25.12,25.57,25.89,26.26,26.72,27.09,27.46,27.72,27.77,27.50,27.13,26.89,26.75,26.62,26.20,25.77,25.57,25.49,24.50,24.50,24.50,24.50,24.50,24.50,24.50,23.99,24.27,24.91,25.85,26.96,28.24,29.65,31.20,32.85,34.61,36.27,37.40,38.46,39.62,40.95,42.32,42.72,43.01,43.48,43.99,46.49,46.49,48,49.50,51.49,55.49,55.49,57,58.49,59,59.50,59.50,59.50,59.50,59.50,59.50,59.50,58.99,58.99,58.49,58.49,58.49,58.49,59.50,60,62.49,62.49,64.50,66,66.98,70,70,70.98,71.49,72.49,74.48,74.48,76.49,78.99,80.50,82,82,80.99,78.99,76,69.48,69.48,67.99,67,63.99,58.99,58.99,55.49,52.49,48.49,46.98,46.98,46,43.49,41,36.98,36.98,34.99,32.98,31.49,30,30,29,29,28,27.11,26.99,26.76,25.95,25,24.26,23.79,23.42,23.12,22.83,22.53,22.24,21.92,21.62,21.34,21.07,20.82,20.61,20.39,20.25,20.17,20.08,19.98,19.88,19.78,19.73,19.66,19.66,19.71,19.77,19.87,19.96,20.02,20.09,20.12,20.12,20.09,20.07,20.03,20.01,20,20,20,20,20,20,20,19.99,19.84,19.60,19.28,19.24,19.32,19.48,19.66,19.84,19.92,19.98,19.99,19.99,19.99,19.99,19.99,19.99,19.99,19.99,20,20.03,20.16,20.41,20.76,21.14,21.48,21.77,21.95,22,22.03,22.33,22.67,23.26,24.24,24.73,25.32,25.37,24.45,22.99,22.98,22.98,22.98,22.98,22.98,22.98,23,23.86,24.20,24.74,25,25.34,26.35,28.37,31.60,31.87,31.98,32.09,32.10,29.87,29.12,28.12,27.21,26.51,26.11,26,25.98,25.49,25,25.98,25.98,25.98,25.98,25.98,27,27,27,27,27.98,7.98,7.98,7.98,9,9,5.98,5.98,5,4,4,4,4,4,4,4,4,4.09,4.33,4.70,4.99,5.26,5.58,5.87,6.07,6.09,5.98,5.87,5.83,5.75,5.60,5.14,5.25,5.25,5.22,5.12,5.12,5.12,5.25,5.37,6.11,6.70,6.97,6.87,6.85,6.89,7,7,7,7.98,7.98,9,9,9,9,10,10,10,10.98,10.98,12,12,12,12.98,14.07,14.70,15.11,15.50,15.98,16.62,17.36,18.11,18.77,19.63,20.62,21.74,22.71,23.60,24.40,25.24,25.98,26.62,27.11,27.49,27.83,28.22,28.70,29.01,29.23,29.12,28.87,28.46,28.14,27.97,27.73,27.35,26.87,26.46,25.98,25,25,25,25,25,25,25.01,25.04,25.46,26.46,27.35,28.37,29.60,30.97,32.47,34.09,35.77,37.25,38.51,39.58,40.75,41.98,43.46,43.62,44,44,45,45.98,45.98,47,49,50.98,55.98,55.98,57,57.98,59,60,60,60,60,60,60,60,60,60,59,59,59,59,60,60,62.98,62.98,65,67,67.98,70,70,70.98,70.98,72,72.98,72.98,75,77.98,79,80,80,79,77.98,75,67.98,67.98,65.98,65,62.98,57.98,57.98,55,52,47.98,45.98,45.98,45,42.98,40,35.98,35.98,34,32.98,30.98,30,30,29,29,27.98,27.01,26.98,26.85,25.95,24.92,24.12,23.50,23.07,22.70,22.36,22.02,21.72,21.41,21.13,20.85,20.58,20.29,20.10,19.89,19.82,19.73,19.62,19.52,19.42,19.34,19.25,19.21,19.17,19.20,19.25,19.35,19.48,19.62,19.75,19.85,19.90,19.92,19.96,19.97,19.98,19.99,20,20,20,20,20,20,19.98,19.86,19.62,19.25,19.12,19.14,19.33,19.53,19.74,19.87,19.92,19.97,19.99,19.99,19.99,19.99,19.98,19.98,19.97,19.97,20,20.12,20.36,20.67,21.02,21.37,21.70,21.92,21.98,22.02,22.24,22.63,23.23,23.75,24.24,24.79,24.86,23.96,23,22.98,22.98,22.98,22.98,22.98,22.98,23,23.87,24.20,24.74,25.11,25.34,26.34,28.36,31.61,32.01,32.25,32.20,32.60,29.37,28.64,27.75,26.97,26.14,26.07,25.95,25.98,25,25,25.98,25.98,25.98,25.98,25.98,27,27,27,27,27.98,7.98,7.98,7.98,9,9,5.98,5.98,5,4,4,4,4,4,4,4,4.07,4.11,4.37,4.75,5.11,5.57,6,6.50,6.75,6.75,6.59,6.37,6.25,6.12,5.95,5.75,5.70,5.62,5.50,5.46,5.38,5.39,5.50,5.82,6.37,7.62,7.63,7.12,7,7.11,7.87,7.98,7.98,7.98,9,10,10,10,10,10.98,10.98,10.98,12,12,12,12.98,12.98,14,14.75,15.40,16,16.50,17.10,17.76,18.50,19.25,20,20.83,21.77,22.97,23.99,24.89,25.77,26.62,27.46,28.13,28.72,29.12,29.51,29.88,30.37,30.71,30.82,30.64,30.27,29.85,29.46,29.25,29,28.61,28.12,27.62,27,25.98,25.98,27,27,27,26,26.03,26.89,27.42,28.10,28.90,29.92,31.04,32.37,33.77,35.34,36.92,39,39.50,40.53,41.60,42.85,43.73,44.12,44.87,45.98,45.98,45.98,45.98,47,47.98,50.98,55,55,55.98,57,57.98,57.98,57.98,59,59,60,60.98,60.98,60.98,60.98,60.98,60.98,60.98,60.98,60,60.98,65,65,67.98,69,70,70.98,70.98,70.98,70,70,70.98,70.98,72,72.98,75,75.98,75.98,74,74,72.98,65,65,62,60,60.98,55,55,50.98,49,45.98,42.98,42.98,42,40,37.98,34,34,32.98,32,30.98,30,30,29,29,27.98,27,26.98,26.87,25.84,24.79,23.87,23.22,22.71,22.28,21.91,21.58,21.25,20.98,20.72,20.46,20.17,19.95,19.71,19.50,19.42,19.33,19.22,19.11,19,18.89,18.82,18.75,18.71,18.70,18.72,18.78,18.92,19.12,19.35,19.53,19.70,19.76,19.82,19.85,19.90,19.97,20,20,20,20,20,20,19.98,19.76,19.50,19.11,18.90,18.90,19.08,19.33,19.58,19.73,19.84,19.87,19.90,19.91,19.91,19.90,19.88,19.87,19.86,19.85,19.88,20.02,20.27,20.61,20.96,21.29,21.63,21.91,21.97,22,22.13,22.36,22.86,23.71,23.74,23.85,23.84,23.88,23,22.98,22.98,22.98,22.98,22.98,22.98,23,23.88,24.13,24.75,25.22,25.75,26.32,28.34,31.62,32.24,32.60,32.60,30.75,28.32,28,27.25,26.75,26.11,25.87,25.97,25,25,25,25.98,25.98,25.98,25.98,25.98,27,27,27,27,27.98,7.98,7.98,7.98,7.98,7,5.98,5.98,5,4,4,4,4,4,4,4,4.33,4.37,4.50,4.87,5.21,5.75,6.34,7,7.62,7.49,7.24,6.99,6.75,6.51,6.37,6.24,6.14,6.10,5.98,5.85,5.75,5.75,5.87,6.12,6.46,7,7.33,7.25,7.22,7.12,7.98,8,8,8.88,9.09,10,10.09,10.89,11,12,12,12,12.98,12.98,12.98,14,14,14.95,15.61,16.25,16.89,17.57,18.15,18.87,19.62,20.39,21.22,22.12,23.20,24.38,25.39,26.36,27.25,28.11,28.96,29.72,30.37,30.88,31.37,31.88,32.25,32.50,32.57,32.36,31.97,31.50,31.12,30.83,30.50,30.09,29.64,29.12,28.62,27.26,27.12,27.96,27.98,28,28.07,28.17,28.72,29.17,29.76,30.57,31.57,32.63,33.78,35.13,36.59,38.11,39.37,40.47,41.27,42.65,43.20,44.82,45.13,46.09,45.98,47,47,47,47.98,49,50.98,52.98,52.98,55,55.98,57,57,57,57.98,57.98,59,59,59,59,59,59,60,60,60.98,60.98,62,67,67,70,70.98,70.98,72,72,70.98,70,69,69,69,70,70.98,72,72.98,72.98,72,70.98,69,62.98,62.98,59,57,57,52.98,52.98,50,47,45,40.98,40.98,40,37.98,35.98,34,34,32.98,32,30.98,30,30,29,29,27.98,27,26.98,26.75,25.62,24.61,23.67,22.95,22.37,21.92,21.53,21.20,20.87,20.62,20.36,20.12,19.87,19.64,19.42,19.25,19.11,18.98,18.85,18.73,18.61,18.50,18.39,18.33,18.25,18.20,18.15,18.20,18.32,18.52,18.79,19.09,19.32,19.47,19.57,19.62,19.64,19.65,20,20,20,20,19.97,19.89,19.87,19.87,19.14,18.75,18.54,18.57,18.78,19.04,19.28,19.47,19.57,19.62,19.63,19.64,19.64,19.64,19.64,19.63,19.62,19.63,19.70,19.86,20.14,20.53,20.90,21.22,21.60,21.83,21.96,22,22.01,22.14,22.34,22.76,22.98,22.99,22.99,22.87,22.95,22.98,22.98,22.98,22.98,22.98,22.98,23,23.95,24.12,24.77,25.22,26.01,27.02,28.32,31.63,31.75,33.62,32.62,30.10,28.26,27.72,26.85,26.13,25.85,25.07,25,25,25,25,25.98,25.98,25.98,25.98,25.98,27,27,27,27.98,27.98,7.98,7.98,7,7,5.98,5.98,5.98,5,5,5,5,5,5,5,5,4.62,4.70,4.75,5,5.25,5.84,6.50,7.32,8,7.99,7.75,7.50,7.25,7,6.84,6.70,6.62,6.50,6.38,6.25,6.13,6.12,6.23,6.38,6.74,7.09,7.34,7.70,7.75,8,8.87,8.88,9.01,9.87,10.09,10.85,11.11,11.87,12.87,12.90,14,14,14,15,15,15.98,15.64,15.87,16.40,17.07,17.75,18.40,19.12,19.87,20.70,21.50,22.37,23.37,24.52,25.87,26.87,27.73,28.60,29.47,30.27,31.10,31.82,32.45,33.11,33.76,34.12,34.33,34.23,33.87,33.50,33.12,32.73,32.37,31.96,31.50,31.08,30.82,29.50,28.47,28.75,29.77,29.87,29.92,30.75,30.62,30.52,30.71,31.28,32.12,33.12,34.33,35.24,36.42,37.78,39.15,40.40,41.36,42.36,43.64,44.87,46.78,46.88,47.85,48.89,48.88,49.87,49.88,50.87,51.97,52,54,54,55,55,55.98,55.98,55.98,55.98,55.98,55.98,57,57,57,57.98,57.98,60,60,60.98,60.98,62.98,70.98,70.98,74,75,75,74,74,70.98,69,67.98,67,67,67,67,67,67.98,67.98,65.98,65,64,60.98,60.98,59,57,54,49,49,47,44,42,37.98,37.98,37,35.98,34,32,32,32,32.98,32,30,30,30,29,29,27.01,26.75,26.16,25.33,24.35,23.42,22.65,22.08,21.61,21.22,20.87,20.58,20.33,20.11,19.87,19.63,19.40,19.20,18.99,18.83,18.66,18.51,18.37,18.24,18.12,18.01,17.92,17.84,17.75,17.65,17.63,17.72,17.90,18.20,18.51,18.82,19.03,19.20,19.27,19.32,19.33,19,19,19,19,19,19,19.01,19.08,18.95,18.08,18.25,18.27,18.46,18.75,19.01,19.17,19.26,19.29,19.32,19.33,19.33,19.33,19.34,19.34,19.35,19.37,19.41,19.61,19.96,20.37,20.75,21.08,21.37,21.74,21.92,21.98,22,22.01,22.12,22.25,22.27,22.23,22.17,22.12,22.02,22,22,22.98,22.98,22.98,22.98,22.98,23,24.09,24.86,25.20,26.20,27.71,28.25,29.76,30.32,31.65,31.70,29.27,27.25,26.87,26.13,25.83,25.09,25,25,25,25,25,25.98,25.98,25.98,25.98,25.98,27,27,27.98,29,30,7.98,7.98,7,7,5.98,5.98,5.98,5,5,5,5,5,5,5,5,4.88,4.87,4.89,5.09,5.34,5.85,6.50,7.25,7.89,8.10,8,7.86,7.62,7.47,7.25,7.12,6.99,6.88,6.82,6.62,6.50,6.50,6.51,6.73,7,7.32,7.62,7.85,8.12,8.47,8.82,9.12,9.50,10,10.62,11.32,11.62,12.48,13.37,13.58,14.48,14.50,14.50,15.49,16,16.48,16.51,16.75,17.23,17.87,18.51,19.25,20,20.83,21.64,22.52,23.48,24.50,25.73,27.12,28.01,28.98,29.87,30.75,31.62,32.47,33.22,33.97,34.71,35.45,35.74,35.87,35.72,35.46,35.09,34.70,34.26,33.87,33.38,32.87,32.33,31.50,30.51,29.62,29.87,30.24,30.45,30.59,30.95,31.27,31.52,31.95,32.61,33.52,34.54,35.53,36.51,37.62,38.87,40.24,41.50,42.34,43.32,44.42,45.75,47.77,48.12,48.62,49.37,50.20,50.75,51.36,51.88,52.51,53.12,54.50,54.50,55.49,55.49,55.98,55.98,55.98,55.98,55.98,55.98,57,57,57,57.98,57.98,60,60,60.98,61.49,62.98,70.49,70.49,74,75.49,76,74,74,70.98,69,67.98,67,67,66.49,66.49,66,66.49,66.49,64.99,63.99,63,60.49,60.49,58.49,56.49,53.49,48,48,46,43.49,41.49,37.49,37.49,36.49,35.49,34,32,32,31.49,31.98,31.49,30,30,30,29,28.99,27.20,26.57,25.84,24.89,23.98,23.13,22.41,21.85,21.37,20.99,20.64,20.37,20.12,19.87,19.64,19.41,19.20,18.97,18.75,18.58,18.39,18.23,18.08,17.91,17.78,17.66,17.58,17.47,17.36,17.25,17.17,17.21,17.35,17.60,17.92,18.26,18.58,18.78,18.90,18.97,18.99,19,19,19,19,19,19,19,19,18.95,18.51,18.35,18.17,18.17,18.50,18.79,19,19.04,19.04,19.04,19.04,19.04,19.04,19.08,19.10,19.11,19.12,19.16,19.35,19.71,20.14,20.54,20.88,21.27,21.64,21.92,21.98,21.98,22,22,22.01,22.01,22.01,22,22,21.99,22,22,22.49,22.49,22.98,22.98,22.98,22.99,24.01,25.37,25.62,26.50,27.36,28.24,29.74,30.25,31.73,30.73,28.84,26.72,26.34,25.96,25.49,25,25,25,25,25,25,25.49,25.49,25.98,25.98,25.98,27,27,27.98,29,30.49,7.98,7.98,7,7,5.98,5.98,5.98,5,5,5,5,5,5,5,5,5,5,5.01,5.12,5.37,5.85,6.39,7.12,7.63,7.99,8.07,8,7.95,7.76,7.62,7.37,7.35,7.25,7.14,7,6.87,6.83,6.87,7,7.25,7.61,7.96,8.24,8.52,8.87,9.25,9.60,9.96,10.45,11.09,11.72,12.20,12.89,13.86,14.12,14.95,15,15,15.98,17,17.13,17.33,17.58,18.09,18.62,19.33,20.07,20.86,21.70,22.58,23.50,24.47,25.50,26.75,27.98,29.08,30.11,31.09,32,32.95,33.83,34.62,35.45,36.22,36.84,37.25,37.27,37.22,36.96,36.61,36.22,35.84,35.37,34.87,34.24,33.48,32.52,31.50,30.71,30.75,31.02,31.16,31.11,31.34,32.04,32.52,32.75,33.85,34.85,35.87,36.85,37.75,38.53,39.91,41.37,42.62,43.35,44.34,45.32,46.25,48.77,49.16,49.25,50.34,51.38,52.12,52.49,53.11,53.36,54.25,54.88,55,55.98,55.98,55.98,55.98,55.98,55.98,55.98,55.98,57,57,57,57.98,57.98,60,60,60.98,62,62.98,70,70,74,75.98,77,74,74,70.98,69,67.98,67,67,65.98,65.98,65,65,65,64,62.98,62,60,60,57.98,55.98,52.98,47,47,45,42.98,40.98,37,37,35.98,35,34,32,32,30.98,30.98,30.98,30,30,30,29,28.91,27.13,26.21,25.27,24.38,23.57,22.82,22.15,21.62,21.15,20.77,20.46,20.16,19.90,19.66,19.45,19.22,18.99,18.75,18.54,18.35,18.15,17.97,17.79,17.63,17.49,17.37,17.25,17.12,17,16.88,16.79,16.77,16.87,17.09,17.39,17.76,18.11,18.36,18.51,18.59,18.62,19,19,19,19,19,19,19,19,19,19,19,18.13,17.95,18.25,18.66,18.95,18.99,19,19,19,19,19,19,19,19.01,19.02,19.07,19.22,19.50,19.91,20.36,20.75,21.25,21.63,21.91,21.97,21.98,21.98,21.98,21.98,21.98,21.98,21.98,21.98,21.99,22,22,22,22,22.98,22.98,22.98,22.98,24,25.90,26.07,26.86,27.13,28.13,29.77,30.21,31.76,30.11,28.82,26.12,25.99,25.87,25,25,25,25,25,25,25,25,25,25.98,25.98,25.98,27,27,27.98,29,30.98,7,7,7,7,5.98,5.98,5.98,5,5,5,5,5,5,5,5,5.14,5.12,5.12,5.24,5.46,5.85,6.37,6.97,7.49,7.86,8.07,8.12,8.13,8.12,8,7.83,7.75,7.72,7.62,7.39,7.25,7.12,7.24,7.39,7.50,8.09,8.45,8.75,9.10,9.47,9.85,10.15,10.50,10.99,11.61,12.23,12.83,13.14,13.87,14.12,14.88,15,15.98,17,17.98,18.12,18.25,18.50,18.87,19.38,20.09,20.85,21.62,22.50,23.45,24.37,25.37,26.50,27.72,28.95,30.12,31.24,32.27,33.33,34.27,35.24,36.07,36.87,37.63,38.21,38.61,38.75,38.73,38.50,38.13,37.75,37.38,36.98,36.38,35.71,34.85,33.75,32.62,31.72,31.76,32.02,32.09,32.14,32.39,33.17,33.71,34.35,35.12,36.16,37.27,38.25,39.11,39.96,41.11,42.28,44.67,45.33,46.24,47.12,48.23,49.79,50.16,51.25,52.23,53.15,53.87,54.35,54.51,55.11,55.35,55.83,55.98,57,57,57,57,57,57,57,57,57.98,57.98,57.98,57.98,59,60.98,60.98,62,62.98,64,69,69,72.98,75.98,77,72.98,72.98,70,67.98,67,65.98,65.98,65.98,65,64,62.98,62.98,62.98,62,60,57.98,57.98,57,55,52,45.98,45.98,44,42.97,39.96,37.09,36.87,35.12,34.12,32.99,31.08,31.07,30.90,30,29,29,29,29,27.96,26.87,26.12,25.32,24.60,23.86,23.13,22.46,21.87,21.36,20.92,20.58,20.26,19.99,19.73,19.48,19.25,19.01,18.78,18.58,18.36,18.14,17.95,17.75,17.57,17.38,17.23,17.09,16.96,16.83,16.70,16.57,16.47,16.41,16.48,16.64,16.92,17.27,17.62,17.88,18.08,18.16,18.24,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,19,19,19,17.98,17.22,18.09,18.62,18.97,18.97,18.97,18.96,18.96,18.98,18.99,18.99,18.99,18.99,19,19.02,19.13,19.37,19.77,20.26,20.66,21.15,21.60,21.82,21.91,21.95,21.95,21.96,21.97,21.98,21.98,21.98,21.98,21.99,22,22,22,22,22,22,22.98,22.98,24,25.97,26,26.95,27.09,27.12,28.86,29.12,30.83,29.86,27.86,26.07,25.89,25,25,25,25,25,25,25,25,25,25,25,25.98,25.98,27,27,27.98,30,32,7,7,7,5.98,5.98,5.98,5.98,5,5,5,5,5,5.98,5.98,5.98,5.25,5.26,5.25,5.36,5.50,5.87,6.35,6.87,7.37,7.75,8.10,8.25,8.37,8.45,8.37,8.36,8.25,8.24,8.12,7.99,7.62,7.62,7.60,8,8.35,8.62,8.98,9.27,9.63,10.08,10.49,10.87,11.23,11.64,12.21,12.75,13.34,13.76,14.14,14.87,15.09,15,15.98,17,19,19.22,19.12,19.27,19.62,20.12,20.83,21.61,22.40,23.33,24.25,25.25,26.33,27.46,28.70,29.96,31.20,32.37,33.50,34.60,35.62,36.61,37.48,38.32,39.10,39.62,40.01,40.25,40.25,40.08,39.75,39.39,39,38.64,38.12,37.37,36.47,35.25,33.75,32.71,33.20,33.33,33.27,33.13,34.13,34.51,35.32,35.67,36.67,37.72,38.66,40.25,40.53,41.29,42.33,44.29,47.67,48.25,48.22,49.21,50.15,52.12,52.16,53.34,54.49,55.57,56.33,56.60,56.57,57.12,57.38,57.21,57,57.98,57.98,57.98,57.98,57.98,57.98,57.98,57.98,57.98,57.98,59,59,59,62,62,64,65.98,65.98,70,70,72.98,77,77,72,72,70,67.98,65.98,65,65,65,64,64,62,62,60.98,60,59,57,57,55,52.98,50.98,45,45,42.99,41.07,39.87,37.12,36.83,35.15,34.11,32.76,31.12,30.83,30.12,29.09,28.97,27,27,27,26,25.58,24.95,24.53,23.98,23.37,22.75,22.13,21.60,21.12,20.73,20.39,20.09,19.79,19.53,19.28,19.04,18.83,18.61,18.38,18.16,17.96,17.75,17.53,17.36,17.16,17,16.84,16.67,16.53,16.38,16.25,16.15,16.11,16.12,16.25,16.49,16.78,17.11,17.37,17.54,17.63,17.65,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17,17.76,18.61,18.62,18.64,18.66,18.75,18.87,18.97,18.99,18.99,18.98,18.98,18.98,19,19.11,19.34,19.67,20.17,20.61,20.98,21.32,21.62,21.63,21.64,21.74,21.85,21.96,21.98,21.98,21.98,21.98,21.99,22,22,22,22,22,22,22.98,22.98,24,25.98,25.98,26.98,26.97,26.99,27.89,28,28.95,27.90,26.97,25,25,25,24,24,25,25,25,25,25,25,25,25,25.98,25.98,27,27,27.98,30,32.98,7,7,5.98,5.98,5.98,5.98,5.98,5,5,5,5,5,5.98,5.98,5.96,5.73,5.51,5.50,5.50,5.62,5.95,6.35,6.87,7.36,7.76,8.14,8.47,8.63,8.76,8.87,8.87,8.87,8.84,8.75,8.62,8.57,8.49,8.58,8.75,9,9.25,9.50,9.85,10.22,10.62,11.02,11.48,11.87,12.33,12.82,13.27,13.74,14.14,14.83,15.12,15.87,15.98,17,17.98,17.98,19.36,19.82,19.97,20.35,20.87,21.57,22.36,23.21,24.12,25.10,26.12,27.21,28.37,29.63,30.97,32.25,33.50,34.71,35.85,36.95,37.97,38.87,39.73,40.50,41,41.37,41.62,41.63,41.51,41.27,40.98,40.62,40.26,40.15,39.12,38.02,37.24,35.34,34.36,34.50,35.62,35.70,35.78,35.72,36.49,37.36,37.48,38.29,39.51,41.32,43.39,43.50,44.65,46.66,47.89,51.70,51.73,53.75,54.77,55.78,56.87,56.79,57.62,57.49,58.39,59.37,59.37,59.37,59.48,59.60,59.75,60,60,60,60,60,60,60,60,60,59,59,59,60,60,62.98,62.98,65,67.98,70.98,74,74,75.98,77.98,77,72,72,70,67.98,65.98,62.98,62.98,62.98,62.98,62.98,62,61.99,60.02,59.09,57.87,53.10,53.11,51.10,50.11,48.88,44.02,43.95,41.08,40.10,38.13,36.20,35.87,35.25,34.75,32.86,31.21,30.75,29.98,29.10,27.87,26,25.98,25,25.21,24.73,24.45,24,23.53,23.01,22.46,21.88,21.37,20.92,20.58,20.24,19.91,19.63,19.37,19.12,18.87,18.63,18.41,18.21,17.99,17.76,17.57,17.36,17.15,16.98,16.79,16.62,16.46,16.27,16.12,15.98,15.87,15.82,15.83,15.90,16.09,16.34,16.61,16.85,17,17.09,17.12,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17.98,18.27,18.29,18.33,18.51,18.75,18.98,18.98,18.98,18.97,18.96,18.95,18.96,19.04,19.25,19.66,19.99,20.35,20.76,21.09,21.23,21.32,21.32,21.29,21.71,21.88,21.97,21.98,21.98,21.99,21.99,22,22,22,22,22,22,22.98,22.98,24,25.98,25.98,25.98,25.98,25.98,25.98,25.98,27,25.98,25,24,24,24,24,24,24,24,25,25,25,25,25,25,25.98,25.98,27,27,27.98,30.98,34,7,7,6.49,5.98,5.98,5.98,5.98,5,5,5,5.49,5.49,5.98,5.98,5.95,5.87,5.87,5.73,5.73,5.82,6,6.46,6.87,7.37,7.86,8.25,8.62,8.95,9.14,9.35,9.45,9.49,9.49,9.47,9.39,9.37,9.37,9.45,9.52,9.71,9.87,10.12,10.39,10.77,11.24,11.65,12.11,12.48,12.87,13.33,13.75,14.13,14.50,15,15.62,16.37,16.49,17.49,17.98,18.49,19.49,20.10,20.50,21,21.59,22.27,23.12,24,24.90,25.88,26.96,28.02,29.26,30.60,31.97,33.33,34.62,35.87,37.11,38.25,39.32,40.25,41.12,41.87,42.48,42.87,43.12,43.21,43.12,42.87,42.58,42.25,41.86,41.20,40.35,39.38,38.37,36.48,34.49,34.85,36.66,36.86,36.95,37.12,37.57,38.09,38.76,39.66,41.11,42.82,44.45,45.37,46.50,48.01,49.79,52.70,53.27,54.78,56.26,57.45,58.37,58.62,58.95,59.45,60,60.50,60.86,60.95,60.96,60.96,60.99,61,60.49,60.49,60.49,60.49,60.49,60.49,60.49,60,59.50,59.50,59.50,60,60.49,62.98,62.98,65,67.49,70.98,75.50,75.50,77.49,78.99,77.49,72.49,72.49,70.49,68.49,66.49,62.49,62.49,62.49,62.49,62.98,62.01,61.88,59.62,58.48,57.27,52.65,52.26,50.49,48.65,47.85,43.13,42.82,40.65,39.33,37.83,36.24,35.70,35.12,34.33,33.20,31.25,30.72,29.99,28.99,27.83,26.08,25.95,25.50,25.01,24.66,24.24,23.79,23.36,22.84,22.27,21.74,21.25,20.79,20.45,20.10,19.77,19.49,19.22,18.96,18.71,18.47,18.25,18.01,17.79,17.59,17.37,17.17,16.99,16.79,16.62,16.42,16.25,16.07,15.88,15.73,15.62,15.54,15.53,15.60,15.73,15.91,16.14,16.36,16.50,16.54,16.52,16.49,16.49,16.49,16.49,16.49,16.49,16.49,16.49,16.49,16.49,16.49,16.49,17,17,17.98,17.97,17.97,17.97,18.26,18.60,18.87,18.87,18.87,18.86,18.84,18.83,18.84,18.90,19.11,19.34,19.67,20.15,20.63,20.95,21,21.01,21.02,21.17,21.49,21.78,21.96,21.98,21.98,21.99,22,22,22,22,22,22,22,22.98,22.98,24,25.49,25.49,25.49,25.49,25.49,25.49,25.49,26,25.49,25,24,24,24,24,24,24,24,24.50,25,25,25,25,25,25.98,25.98,27,27,28.49,30.98,34,7,7,7,5.98,5.98,5.98,5.98,5,5,5,5.98,5.98,5.98,5.98,5.98,5.99,5.97,5.89,5.88,6,6.22,6.50,6.97,7.45,7.89,8.37,8.76,9.14,9.50,9.82,10,10.12,10.14,10.22,10.23,10.23,10.25,10.32,10.37,10.47,10.61,10.77,11.11,11.50,12,12.49,12.89,13.26,13.51,13.87,14.26,14.70,14.98,15.12,16.10,16.95,17,17.98,17.98,19,19.62,20.33,21,21.62,22.33,23.10,23.95,24.84,25.75,26.75,27.77,28.87,30.15,31.52,33,34.39,35.77,37.12,38.37,39.59,40.71,41.73,42.62,43.46,44.11,44.58,44.87,44.98,44.89,44.72,44.37,43.90,43.40,42.62,41.49,40.50,39.61,37.63,34.26,34.12,37.78,38.02,38.15,38.20,38.32,39.27,39.50,40.53,42.34,44.32,45.78,46.32,48.27,49.34,51.29,53.70,54.27,56.23,58,59.17,60.08,60.10,60.24,61.14,61.46,62.01,62.36,62.46,62.39,62.25,62.12,62,60.98,60.98,60.98,60.98,60.98,60.98,60.98,60,60,60,60,60,60.98,62.98,62.98,65,67,70.98,77,77,79,80,77.98,72.98,72.98,70.98,69,67,62,62,62,62,62.89,61.87,61.85,59.20,57.75,56.75,52.25,51.75,49.75,47.24,46.75,42.25,41.70,40.32,39.07,37.71,36.25,35.63,35.12,34.34,33.63,31.27,30.99,30.25,29.25,27.99,26.12,26.07,25.79,25.37,24.89,24.39,23.91,23.37,22.83,22.25,21.70,21.17,20.73,20.36,19.99,19.65,19.37,19.08,18.79,18.54,18.29,18.08,17.86,17.62,17.40,17.21,17,16.82,16.62,16.46,16.26,16.08,15.88,15.70,15.52,15.39,15.33,15.29,15.35,15.45,15.59,15.76,15.92,16.04,16.12,16.01,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,17,17,17.98,17.98,17.98,17.98,17.98,18.62,18.62,18.62,18.62,18.63,18.62,18.62,18.62,18.66,18.82,19.02,19.26,19.96,20.67,20.83,20.95,20.98,20.99,21.07,21.21,21.79,21.96,21.98,21.98,21.99,22,22,22,22,22,22,22,22.98,22.98,24,25,25,25,24.96,24.92,24.90,24.88,24.88,24.88,24.88,24.09,24,24,24,24,24,24,24,25,25,25,25,25,25.98,25.98,27,27,29,30.98,34,7,7,7,7,5.98,5.98,5.96,5.89,5.88,5.87,5.98,6,6,6,6,6,6.09,6.10,6.12,6.12,6.38,6.72,7.11,7.50,8,8.49,8.89,9.37,9.83,10.23,10.50,10.73,10.87,10.99,11.08,11.09,11.21,11.24,11.24,11.25,11.37,11.61,11.96,12.40,13,13.51,13.99,14.32,14.47,14.63,14.98,15.48,15.84,16.10,17,17.96,17.98,17.98,19,19,20.01,20.74,21.62,22.37,23.12,23.90,24.75,25.71,26.64,27.65,28.75,29.90,31.22,32.62,34.09,35.61,37,38.38,39.73,41,42.15,43.25,44.25,45.14,45.95,46.50,46.88,47.12,47.12,46.98,46.59,46,45.37,44.48,43.15,42.11,42,40,35.98,35,38.90,38.97,39.82,39.83,40.25,41.01,41.27,41.28,44.04,45.34,48.65,49.25,50.33,51.99,53.28,56.70,57.26,58.96,60.22,61.15,62.85,63.02,63.01,63.24,63.33,63.90,64.12,64.12,64.09,63.82,63.07,62.98,62.98,62.98,62.98,62,62,62,62,60.98,60.98,60.98,60.98,60.98,62,64,64,65.98,67.98,70.98,79,79,80.98,80.98,79,75,75,74,70.98,67.98,62.98,62.98,60.98,61.96,61.87,60.13,59.76,57.87,56.20,54.72,52.27,51.70,48.84,46.25,44.65,41.35,40.95,40.13,39.07,37.72,36.32,35.75,35.34,34.64,33.62,32.35,31.63,30.86,29.75,28.75,27.15,26.87,26.29,25.87,25.33,24.75,24.15,23.57,22.95,22.32,21.72,21.16,20.70,20.28,19.90,19.57,19.25,18.96,18.66,18.39,18.14,17.90,17.67,17.46,17.24,17.02,16.84,16.64,16.48,16.29,16.12,15.92,15.74,15.53,15.37,15.24,15.15,15.13,15.15,15.23,15.33,15.46,15.57,15.63,15.77,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,17,17,17,17.98,17.98,17.75,17.87,18.10,18.21,18.32,18.32,18.27,18.24,18.20,18.26,18.42,18.71,19.12,19.74,20.25,20.72,20.91,20.95,20.97,21,21.15,21.85,21.87,21.92,21.99,22,22,22,20.98,20.98,22,22,22,22,22.98,22.98,24,24.01,24.07,24.11,24.12,24.14,24.16,24.16,24.16,24.16,24.09,23.98,23.97,23.98,23.99,24,24,24,24,25,25,25,25,25.98,25.98,27.98,27.98,29,30.98,34,7,7,7,7,7,6,6.24,6.25,6.26,6.26,6.26,6.26,6.25,6.26,6.26,6.32,6.26,6.34,6.37,6.50,6.71,6.97,7.26,7.70,8.12,8.59,9.01,9.51,10.09,10.60,11,11.26,11.49,11.71,11.99,12.12,12.26,12.15,12.10,12.10,12.20,12.40,12.86,13.45,14.11,14.75,15.21,15.49,15.64,15.95,16.38,16.70,17.12,17.09,18,19,19,19,20,20,21,21.71,22.45,23.20,23.99,24.75,25.62,26.52,27.50,28.58,29.65,30.87,32.23,33.63,35.15,36.73,38.25,39.70,41.10,42.48,43.75,44.96,46,47,47.96,48.73,49.25,49.60,49.72,49.62,49.27,48.87,48.39,47.96,46.12,44.02,44,42,39,37.98,39.07,39.12,40.82,41.12,42.24,44.26,44.28,45.29,46.29,48.29,50.63,51.32,53.29,54.33,57.29,60.67,61.25,62.24,63.17,65.15,66.10,66.03,65.98,65.09,66.12,66.15,66.20,66.15,66.12,66.07,65,65,65,65,65,64,64,62.98,62.98,62,62,62,62,62,62.98,65.98,65.98,67.98,70.98,72.98,77.98,77.98,80,80.98,80,75.98,75.98,74,70.98,67.98,62.98,62.98,62,61.07,60.83,58.15,57.73,56.25,54.32,52.62,50.34,49.62,47.62,45.62,43.60,41.38,40.77,40.21,39.38,38.25,36.36,36.36,35.97,35.20,34.21,33.36,32.74,31.85,30.27,29.23,28.20,27.83,27.13,26.41,25.77,25.13,24.49,23.82,23.12,22.45,21.78,21.21,20.70,20.26,19.87,19.50,19.15,18.85,18.54,18.26,18,17.75,17.51,17.28,17.07,16.86,16.65,16.49,16.33,16.15,15.99,15.79,15.60,15.40,15.25,15.13,15.07,15.03,15.04,15.09,15.14,15.22,15.27,15.32,15.17,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,17,17,17,16.98,16.98,16.98,17.09,17.20,17.26,17.38,17.50,17.64,17.67,17.73,18,18.33,18.71,19.16,19.78,20.75,20.75,20.77,20.85,20.97,21.09,21.08,21.03,21.99,22,20.98,20.98,20.98,20.98,20.98,20.98,22,22,22,22,22.98,23.01,23.07,23.87,23.83,23.79,23.77,23.75,23.75,23.75,23.75,23.77,23.79,23.83,23.87,23.90,23.98,24,24,24,24,25,25,25,25.98,25.98,27.98,27.98,29,30.98,34,7,7,7,7.98,7.95,7.01,6.75,6.63,6.62,6.62,6.62,6.61,6.60,6.60,6.60,6.59,6.60,6.62,6.71,6.84,7,7.25,7.50,7.87,8.25,8.64,9.12,9.70,10.26,10.89,11.45,11.75,11.98,12.24,12.70,13.87,13.15,13,12.84,12.76,12.87,13.14,13.63,14.37,15.24,16,16.48,16.72,16.95,17.27,18.12,18.59,19.95,19.98,20,20.98,20.98,20.98,20.98,22,22.98,22.76,23.32,24,24.76,25.52,26.38,27.34,28.35,29.39,30.59,31.84,33.21,34.70,36.25,37.87,39.47,41,42.46,43.87,45.37,46.62,47.73,48.87,50,50.95,51.62,52,52.40,52.35,52.12,51.75,51.50,52,52.87,50,50,47,47,45.98,42.04,41.89,40.14,41.15,44.77,50.73,50.71,53.71,54.70,53.67,53.66,54.33,58.67,62.66,63.71,67.71,67.73,69.77,70.78,70.83,70.87,70.91,70.98,70.98,70.98,70.98,70.98,70,70,69,67.98,67.98,67.98,67.98,67,65.98,65.98,65.98,65,65,64,64,64,65,67,70.98,70.98,75,75.98,75.98,72,72,72,74,75,70.98,70.98,69,67,65.98,65,65,62.89,60.12,59.14,57.24,56.75,55.33,53.33,51.62,48.35,48,46.35,44.37,43.22,41.48,41,40.49,39.86,39.50,37.97,37.59,36.60,35.62,34.63,33.98,33.62,33.62,31.25,29.76,29.01,28.83,27.75,26.95,26.22,25.50,24.79,24.08,23.33,22.59,21.87,21.25,20.71,20.25,19.84,19.45,19.10,18.75,18.45,18.13,17.87,17.61,17.37,17.12,16.89,16.67,16.49,16.34,16.17,16.02,15.86,15.66,15.49,15.29,15.16,15.08,15.01,15,15,15.01,15.03,15.08,15.09,15,15.03,15,15,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,16.32,16.32,16.32,16.38,16.50,16.62,16.82,16.98,17.21,17.23,17.37,17.58,17.86,18.17,18.51,19.11,19.15,20.10,20.13,20.85,20.87,20.91,20.99,20.99,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,22,22,22.03,22.87,22.97,23.14,23.20,23.22,23.24,23.25,23.25,23.25,23.25,23.24,23.22,23.20,23.16,23.85,23.88,23.96,24,24,24,24,24,25,25.98,25.98,29,29,30.98,32.98,35,7,7,7,7.96,7.75,7.50,7.24,7.09,7,6.95,6.87,6.87,6.87,6.87,6.86,6.86,6.86,6.87,6.99,7.12,7.25,7.49,7.73,8,8.36,8.75,9.23,9.75,10.46,11.24,11.87,12.22,12.25,12.59,13.12,13.87,13.75,13.57,13.33,13.24,13.34,13.62,14.20,15,16,16.87,17.37,17.64,17.95,18.37,19.08,19.49,20,20.49,20.49,21.49,21.49,21.49,21.49,22.49,23.49,23.49,24.20,24.75,25.47,26.25,27.12,28.02,29.09,30.24,31.46,32.75,34.13,35.72,37.37,39.02,40.72,42.33,43.83,45.32,46.84,48.25,49.35,50.59,51.82,52.84,53.58,53.98,54.39,54.50,54.40,54.22,54.25,54.33,54.48,50.49,50.49,48,48.99,47.49,44.01,43.89,41.62,41.14,45.21,51.74,52.24,55.23,56.71,55.92,55.28,55.28,59.78,64.17,66.25,68.73,69.23,70.78,71.79,71.96,71.97,71.97,71.98,72.49,71.98,71.49,71.49,71,70.49,69.50,68.49,68.49,68.49,67.98,67.49,66.49,66.49,65.98,65.49,65.49,64.50,64.50,64.50,65.49,67.49,71.98,71.98,75,75.49,74.99,70.50,70.50,70.50,72,72.50,69.99,69.99,67.49,66,64.99,64.50,64.50,62.37,60.12,58.85,57.75,57.14,55.15,53.14,51.11,48.37,47.58,46.13,44.63,43.23,42,41.37,40.87,40.27,39.48,38.46,37.62,36.97,35.98,34.99,34.32,33.76,33.12,31.76,30.33,29.25,28.82,28.12,27.32,26.53,25.78,25.04,24.27,23.50,22.72,21.97,21.29,20.73,20.25,19.82,19.40,19.02,18.67,18.35,18.02,17.75,17.48,17.23,16.99,16.75,16.53,16.35,16.20,16.07,15.90,15.74,15.54,15.37,15.22,15.11,15.03,15,15,15,15,15,15,15,15,15,15,15,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,16.12,16.32,16.62,16.83,16.99,17.13,17.37,17.70,18.08,18.51,19.10,19.89,20.09,20.40,20.52,20.97,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,21.49,21.98,22.09,22.34,22.64,22.82,22.97,22.99,23,23,23,23,23,23,23,23.02,23.21,23.46,23.75,23.86,23.88,23.95,24,24.13,24.50,25.10,25.77,26.87,28.38,29.32,31.51,33.99,36,7,7,7,7.73,7.83,7.71,7.51,7.38,7.33,7.24,7.14,7.12,7.12,7.11,7.11,7.10,7.11,7.12,7.21,7.35,7.47,7.62,7.84,8.09,8.37,8.75,9.23,9.75,10.48,11.25,11.95,12.25,12.39,12.73,13.35,13.87,14,13.72,13.38,13.33,13.40,13.75,14.33,15.14,16.21,17.15,17.85,18.25,18.59,18.99,19.96,20,20,20.98,20.98,22,22,22,22,22.98,24,24,25,25,26.14,26.99,27.77,28.73,29.83,31.01,32.33,33.64,35.12,36.74,38.48,40.25,41.99,43.63,45.21,46.72,48.15,49.62,50.82,52.07,53.33,54.25,54.90,55.47,55.85,56.11,56.23,56.32,56.38,56.48,55.98,50.98,50.98,49,50.98,49,45.98,45.91,43.08,41.12,45.17,52.75,53.22,56.75,58.73,58.10,56.25,56.25,61.25,65.71,68.23,69.91,70.22,72.17,73.11,73.08,73.02,72.98,72.98,74,72.98,72,72,72,70.98,70,69,69,69,67.98,67.98,67,67,65.98,65.98,65.98,65,65,65,66,68.02,72.87,73.10,74.87,74.87,73.87,69.08,68.95,68.99,70,70,69,69,65.98,65,64,64,64,61.87,60.15,58.83,57.96,57.62,55.14,53.02,50.61,48.37,47.52,46.13,44.87,43.64,42.57,41.89,41.37,40.62,39.75,38.48,37.99,37.27,36.22,35,34.12,33.61,32.85,31.87,30.65,29.25,29,28.41,27.58,26.75,25.97,25.20,24.40,23.62,22.82,22.03,21.36,20.75,20.26,19.79,19.37,18.99,18.62,18.26,17.95,17.63,17.37,17.12,16.87,16.62,16.40,16.24,16.10,15.96,15.79,15.62,15.45,15.27,15.14,15.07,15.01,15,15,15,15,15,15,15,15,15,15,15,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,16,16.11,16.35,16.58,16.82,16.98,17.12,17.36,17.70,18,19,20,20,20,20,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,21.87,21.89,22.11,22.33,22.53,22.70,22.82,22.87,22.89,22.91,22.95,22.95,22.96,22.96,22.99,23.10,23.28,23.50,23.65,23.77,23.87,24.01,24.25,24.63,25.22,26,27.20,28.49,29.98,32.50,35.22,37,7,7,7,7.51,7.82,7.75,7.73,7.62,7.59,7.50,7.45,7.37,7.36,7.35,7.34,7.33,7.26,7.32,7.36,7.46,7.50,7.62,7.84,8.01,8.33,8.63,9.11,9.62,10.33,11.10,11.76,12.14,12.39,12.74,13.32,14.73,14.15,13.46,13,12.90,13.07,13.37,13.90,14.75,15.87,16.96,17.86,18.50,19.11,19,20,20,20.98,20.98,22,22,22,22.98,22.98,22.98,25,25,25.98,25.98,27,27.83,28.57,29.45,30.62,31.90,33.25,34.62,36.12,37.76,39.61,41.48,43.25,45,46.62,48.14,49.62,50.90,52.13,53.37,54.51,55.50,56.24,56.83,57.33,57.75,58,58.35,58.62,58.75,59,52.98,52.98,52,52.98,52,50,49.98,47.07,44.12,44.14,52.78,53.17,56.83,61.75,61.75,58.23,58.23,63.76,68.75,71.17,72.76,73.15,74.85,75.12,75.07,75.01,75,75,75.98,75.98,74,74,72.98,72,70.98,70,70,69,69,69,67,67,67,67,65.98,65.98,65.99,66.08,67.12,69.12,73.77,74.14,75.73,74.75,70.96,67.21,66.82,66.11,65.02,65.98,65.98,65.98,64,62.98,62,62,62,60.86,59.77,58.75,57.27,56.63,55.15,52.98,50.57,47.39,47.02,46.36,45.37,44.22,43.27,42.50,41.96,41.14,40.13,39.25,38.60,37.63,36.59,35.24,33.37,33.37,32.85,31.96,30.87,30.10,29.82,28.70,27.75,26.86,26.01,25.24,24.47,23.70,22.88,22.12,21.40,20.79,20.27,19.79,19.36,18.96,18.57,18.20,17.86,17.54,17.26,17,16.75,16.50,16.28,16.14,16.01,15.87,15.73,15.51,15.33,15.15,15.07,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.99,16,16.12,16.33,16.50,16.71,16.87,17.07,17.34,17.88,18,19,19,19,20,20,20.98,20.98,20,20,20,20,20,20.98,20.98,20.98,20.98,20.99,21.13,21.36,21.62,21.83,22.02,22.24,22.42,22.59,22.70,22.75,22.77,22.78,22.82,22.84,22.89,22.92,23,23.14,23.33,23.50,23.66,23.86,24.07,24.36,24.75,25.37,26.23,27.49,28.96,31,33.74,37.36,39.71,7,7,7,7.37,7.62,7.74,7.75,7.75,7.75,7.74,7.64,7.62,7.59,7.51,7.50,7.50,7.47,7.39,7.45,7.48,7.50,7.59,7.73,7.87,8.12,8.46,8.84,9.35,10,10.75,11.48,12,12.33,12.60,12.87,13.63,13.38,12.38,12,12.02,12.25,12.62,13.15,13.98,15,16.02,17.11,18.35,20,20,20.98,20.98,20.98,22,22,22.98,22.98,22.98,22.98,24,25.98,25.98,27,27,27.98,28.86,29.63,30.50,31.62,32.89,34.25,35.63,37.14,38.87,40.75,42.65,44.51,46.37,48,49.72,51.17,52.45,53.46,54.54,55.71,56.62,57.40,58.10,58.75,59.46,59.99,60.51,61.12,61.70,60.98,55,55,55,55.98,55,54,54,52.02,47.09,44.12,49.85,50.16,56.82,63.78,65.75,61.20,61.20,66.20,72.76,75.17,76.14,76.12,77.12,78.07,78,77.98,77.98,77,77,77.98,75,75,74,72.98,72,70,70,70,69,69,67.98,67.98,67.98,67,67,66.95,66.87,67,67.83,69.25,73.71,74.10,74.64,73.63,69.64,64.27,63.75,63.12,62.82,62.87,62.97,62.98,62,60.98,60,59,59,58.87,57.75,57.73,56.70,56.62,55.60,52.75,50.39,47.39,47.39,47.34,46.36,45.21,43.50,43.38,42.75,41.87,40.83,39.50,38.99,38.26,37.08,35.58,34.34,33.62,32.87,32.09,31.12,30.23,29.83,28.89,27.86,26.89,26.02,25.24,24.50,23.75,22.97,22.20,21.48,20.85,20.32,19.79,19.35,18.91,18.50,18.13,17.78,17.48,17.17,16.90,16.65,16.41,16.22,16.07,15.98,15.85,15.64,15.42,15.24,15.10,15.02,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.99,16,16.12,16.25,16.37,16.58,16.75,17,17.09,17.87,17.95,17.98,17.98,19,19,19,19,19,19,20,20,20,20,20,20.98,20.96,20.95,21.01,21.16,21.36,21.53,21.72,21.89,22.11,22.32,22.46,22.53,22.58,22.59,22.60,22.62,22.70,22.77,22.89,23.03,23.21,23.39,23.62,23.85,24.09,24.40,24.87,25.58,26.52,27.97,29.74,32.08,35,38.15,41.37,7,7,7,7.24,7.39,7.59,7.71,7.76,7.87,7.87,7.85,7.75,7.74,7.64,7.62,7.60,7.50,7.49,7.47,7.37,7.37,7.45,7.50,7.70,7.87,8.12,8.47,8.88,9.58,10.36,11.20,11.87,12.12,12.32,12.39,11.34,11.32,10.63,10.83,10.98,11.25,11.70,12.14,12.87,13.87,14.85,15.62,17,19,20.98,22,22,22,22.98,22.98,22.98,22.98,24,24,25,27,27,27.98,29,29,30.15,30.74,31.61,32.63,33.95,35.26,36.70,38.22,39.95,41.86,43.84,45.73,47.51,49.15,51.02,53.63,53.75,54.74,55.60,56.66,57.77,58.53,59.32,60.11,61,61.89,62.36,63.60,65,64,62,62,62,62.98,62.98,62,62,62,57.95,52.90,48.08,48.11,55.14,61.84,66.82,67.78,67.83,72.78,80.82,82.83,81.87,81.89,82.90,82.95,82,82,82,80.98,80.98,80,77,77,75.98,75,72.98,72,72,70.98,70,70,69,69,67.98,67.98,67.95,67.11,67,67.23,68.08,69.34,73.62,73.59,72.62,70.39,66.37,61.37,61.34,60.32,59.24,58.12,57.09,57,57,57,57,55.98,55.98,55.12,55.20,55.25,54.27,54.34,53.35,52.37,51.59,50.52,50.52,48.58,47.57,46.50,45.15,44.45,43.57,42.61,41.47,40.40,39.62,38.70,37.59,35.98,34.37,33.82,33.12,32.27,31.74,30.22,29.85,28.92,27.95,26.96,26.02,25.29,24.59,23.84,23.07,22.27,21.57,20.90,20.35,19.83,19.34,18.87,18.48,18.10,17.75,17.41,17.12,16.83,16.57,16.33,16.14,16.02,15.99,15.83,15.61,15.37,15.15,15.04,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.99,16,16.08,16.12,16.25,16.47,16.73,17,17.09,17.01,17,17,17,17,17.98,17.98,17.98,17.98,17.98,19,19,19,19,20.01,20.71,20.76,20.89,21.01,21.14,21.27,21.40,21.58,21.78,22.01,22.20,22.28,22.34,22.35,22.37,22.40,22.50,22.61,22.75,22.95,23.12,23.35,23.60,23.88,24.22,24.64,25.25,26.01,27,28.50,30.51,33.02,35.95,39.10,42,7,7,7,7.12,7.25,7.37,7.57,7.73,7.86,7.87,7.87,7.84,7.75,7.71,7.62,7.60,7.50,7.46,7.37,7.25,7.23,7.25,7.33,7.45,7.59,7.75,8,8.38,9,9.87,10.75,11.57,11.75,11.76,11.58,10.37,9.89,9.72,9.73,10,10.37,10.85,11.25,11.96,12.84,13.70,13.99,16,18.49,20.49,22,22,22.49,22.98,22.98,23.49,23.49,24,24.50,25,27,27,27.98,29,29.50,30.87,31.73,32.52,33.61,34.88,36.25,37.64,39.20,40.90,42.86,44.85,46.74,48.45,50.13,52.10,54.17,54.71,55.46,56.45,57.58,58.67,59.51,60.25,61.16,62.22,62.96,63.62,64.46,65.49,64.99,63.50,63.50,63.50,64.48,64.99,63.99,63.99,63.99,60.48,54.46,48.02,48.07,53.98,59.87,64.86,69.35,69.61,74.61,81.86,84.37,84.08,84.03,84.46,83.99,83.50,83,83,81.98,81.98,80.49,77.49,77.49,76.49,75,73.49,72,72,70.98,70.49,70,69,69,68.49,67.99,67.87,67.12,67.08,67.27,68.12,69.37,73,72.89,71.87,69.01,65.37,61.07,60.15,59.37,58.40,57.50,56.63,56.39,56,56,56,55.49,55.49,54.61,54.50,54.25,53.75,53.37,53,52.62,52.08,51.37,50.52,49.59,48.38,47.12,45.99,45.07,44.27,43.25,42.12,40.90,40.12,39.12,37.77,36.32,34.85,34.13,33.38,32.59,31.75,30.15,29.87,29.03,28.11,27.12,26.21,25.49,24.75,24,23.21,22.39,21.65,20.99,20.39,19.85,19.34,18.87,18.46,18.07,17.71,17.37,17.04,16.75,16.47,16.24,16.09,16,15.97,15.84,15.61,15.28,15.09,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.99,16,16.09,16.24,16.51,16.87,16.99,16.99,16.99,17,17,17,17.98,17.98,17.98,17.98,17.98,18.49,18.49,18.49,19,19.62,20.15,20.51,20.74,20.87,21,21.09,21.17,21.33,21.52,21.75,21.96,22.07,22.12,22.13,22.15,22.23,22.33,22.47,22.64,22.85,23.07,23.32,23.61,23.95,24.34,24.87,25.57,26.48,27.72,29.37,31.33,33.87,36.75,39.72,42.07,7,7,7,7,7.12,7.24,7.37,7.58,7.73,7.82,7.76,7.74,7.62,7.59,7.50,7.49,7.39,7.36,7.25,7.12,7,7,7.12,7.22,7.26,7.38,7.62,7.96,8.49,9.35,10.14,10.96,11.26,11.07,10.51,9.37,9.22,9,8.99,9.23,9.86,10,10.98,10.98,12,12.98,12.98,15,17.98,20,22,22,22.98,22.98,22.98,24,24,24,25,25,27,27,27.98,29,30,31.65,32.51,33.26,34.47,35.76,37.14,38.60,40.12,41.85,43.75,45.73,47.51,49.15,50.88,52.82,54.63,55.25,56.15,57.15,58.25,59.72,60.26,60.91,61.77,62.92,63.86,64.14,65.11,66.01,65.98,65,65,65,65.98,67,65.98,65.98,65.98,62.98,55.98,47.98,48,52.91,57.90,63.07,70.88,71.07,75.99,82.90,85.91,86,85.98,85.98,85,85,84,84,82.98,82.98,80.98,77.98,77.98,77,75,74,72,72,70.98,70.98,70,69,69,69,68,67.85,67.20,67.11,67.35,68.21,69.52,72.35,72.32,71.25,68.25,65.25,60.71,59.50,58.62,57.74,56.85,56.14,55.86,55,55,55,55,55,54.09,53.85,53.75,53.25,53.10,53.09,52.96,52.60,51.37,50.60,49.85,48.77,47.60,46.38,45.50,44.84,43.87,42.64,41.37,40.62,39.34,38.12,36.70,35.33,34.49,33.75,32.82,31.75,30.76,30.02,29.35,28.47,27.50,26.57,25.78,25.02,24.24,23.39,22.54,21.77,21.10,20.47,19.89,19.37,18.87,18.42,18.04,17.70,17.35,17,16.67,16.38,16.16,16.03,15.98,15.90,15.75,15.50,15.24,15.07,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,16,16.08,16.26,16.86,16.87,16.99,16.99,17,17,17,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,18.91,19.25,19.76,20.20,20.50,20.71,20.83,20.90,21.01,21.15,21.35,21.53,21.72,21.85,21.92,21.98,22.01,22.09,22.21,22.37,22.57,22.78,23.02,23.29,23.63,24.02,24.46,25.07,25.87,26.89,28.26,30.08,32.23,34.62,37.39,40.24,42.13,7,7,7,7,7.01,7.12,7.24,7.37,7.50,7.59,7.60,7.50,7.46,7.37,7.36,7.34,7.25,7.24,7.12,7,7,7,7,7.01,7.10,7.14,7.33,7.59,8,8.75,9.62,10.37,10.61,10.35,9.38,9,8.62,8.33,8.25,8.87,9.85,10,10,10.98,10.98,12.98,12.98,14,15.98,19,22.98,22.98,22.98,22.98,22.98,24,24,25,25,25.98,27.98,27.98,29,30,30.98,32.98,33.36,34.09,35.26,36.62,38.08,39.49,41,42.70,44.62,46.50,48.35,49.75,51.36,53.26,55.62,55.91,56.70,57.65,58.89,60.64,60.78,61.27,62.27,63.25,65.75,65.76,66.85,67.87,68,67.98,67.98,67.98,70,70.98,70,70,70.98,67,59,49,49,50,55,60.98,70,70,75,82.98,87.98,90,90,89,87.98,87,85.98,85.98,85.98,82.98,82,79,79,77,75.98,75,72.98,72.98,72,70.98,70,69,69,69,68.02,67.83,67.24,67.12,67.45,68.15,69.59,71.25,71.22,69.50,67,63.60,59.76,58.86,58,57.10,56.13,55.37,54.86,54.02,54,54,54,54,53,52.98,52.86,52.75,52.75,52.97,53.62,52.61,51.35,50.63,50.08,49.20,48,46.34,45.98,45.35,44.60,43.62,41.26,40.75,39.84,38.71,37.14,35.60,34.88,34.02,33,32,31.15,30.48,29.96,29.08,28.08,27.04,26.16,25.35,24.50,23.62,22.75,21.96,21.25,20.60,19.98,19.41,18.90,18.46,18.03,17.67,17.34,16.99,16.63,16.34,16.12,16,15.90,15.78,15.59,15.35,15.13,15.02,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,16,16.12,16.12,16.87,16.87,16.99,17,17,17,17.98,17.98,17.98,17.98,17.98,17.98,17.98,18,18.23,18.86,19.32,19.74,20.08,20.34,20.54,20.67,20.83,20.97,21.14,21.35,21.51,21.64,21.75,21.82,21.88,21.99,22.12,22.29,22.50,22.75,23,23.33,23.71,24.14,24.60,25.26,26.21,27.37,28.87,30.75,33,35.45,38,40.52,42.77,7,7,7,7,7,7.01,7.12,7.21,7.25,7.35,7.35,7.26,7.25,7.22,7.20,7.13,7.12,7.12,7.07,7,7,7,7,7,7,7,7.11,7.25,7.50,8.12,9.62,9.60,10.51,9.58,8.73,8.25,8,8,8.12,8.21,8.86,9,10,10,10.98,12,12,12.98,15,17,22.98,22.98,22.98,22.98,22.98,25,25,25,25.98,25.98,27.98,27.98,29,30,30.98,34,34,34.87,36.12,37.58,39,40.40,41.77,43.47,45.37,47.62,48.86,50.13,51.61,53.34,55.66,56.11,56.66,57.62,58.74,60.62,60.62,61.64,62.64,63.70,65.71,66.21,67.78,69.86,70.89,70.98,70.98,72,74,75,75.98,75.98,75,69,60,50,50,49,52.98,59,65.98,65.98,72,80.98,87,92.98,92.98,92.98,90.98,90,87.98,87.98,85.98,84,82.98,80,80,77.98,75.98,75,72.98,72.98,72,70.98,70,69,69,69,68.09,67.77,67.25,67.12,67.37,68,69,70.14,70.11,68.32,66,62.95,58.86,58.59,57.73,56.64,55.59,54.47,54.33,53.87,53,52.98,52.98,52.98,52,51.98,51.97,51.98,52.09,52.70,52.63,52.62,51.32,50.99,50.34,49.64,48.65,47.25,46.71,45.75,44.87,43.72,42.48,41.25,40.25,39,37.71,36.45,35.36,34.36,33.25,32.22,31.51,31.12,30.75,30.11,28.63,27.50,26.50,25.62,24.77,23.87,23,22.20,21.47,20.77,20.12,19.50,18.98,18.50,18.08,17.67,17.35,16.99,16.62,16.29,16.09,15.96,15.83,15.62,15.37,15.16,15.04,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15.88,15.88,15.87,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,16.09,16.11,16.87,16.89,17,17,17,17,17,17.98,17.98,17.98,17.98,17.98,18,18.14,18.41,18.79,19.20,19.57,19.89,20.17,20.40,20.59,20.75,20.92,21.12,21.29,21.42,21.53,21.62,21.73,21.87,22.02,22.24,22.47,22.73,23,23.37,23.78,24.28,24.87,25.62,26.61,27.88,29.52,31.52,33.83,36.24,38.62,40.90,41.58,7,7,7,7,7,7,7,7.08,7.12,7.12,7.12,7.12,7.11,7.09,7.08,7.07,7.07,7,7,7,7,7,7,7,7,7,7,7.10,7.20,7.33,8.12,8.37,8.37,8.37,8,7.37,7.36,7.75,7.98,8.12,8.11,7.98,9,9,10,10.98,10.98,10.98,12.98,15,17,17,17.98,20,20.98,24,24,25,25.98,27,27.98,27.98,30,30.98,32,34,34,35.98,37,37.98,40.71,41.15,42.37,44.01,46.08,48.02,49.09,50.14,51.63,53.16,55.63,55.62,56.09,56.86,57.90,58.77,59.38,60.37,61.34,62.34,65.66,65.99,67.23,69.84,71.88,76.96,77,79,80,82,79,79,72,65,59,50.98,50.98,50.98,52.98,55,60,60,65,70.98,77,89,89,94,95.98,95,90.98,90.98,89,87,85,82,82,80,77.98,77,74,74,72,70.98,70,69,69,69,68.10,67.75,67.27,67.12,67.26,67.71,68.33,68.75,68.50,67.38,65.50,62.88,60.02,58.75,57.82,56.75,55.62,54.51,54.02,53.84,52.89,52,50.98,50.98,50.98,51,51.09,51.12,51.15,51.22,51.25,51.74,51.70,51.70,50.70,50.08,49.73,47.24,46.82,46.14,45.37,44.12,42.88,41.74,40.60,39.38,38.21,37,35.84,34.70,33.58,32.37,31.86,31.50,31.20,30.50,29.12,27.75,26.72,25.84,24.98,24.11,23.25,22.42,21.71,20.99,20.26,19.60,19.01,18.54,18.11,17.71,17.35,17.04,16.62,16.28,16.01,15.92,15.73,15.46,15.14,15.02,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15.12,15.12,15.12,15.82,15.95,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,16.09,16.08,16,17,17,17,17,17,17,17,17.98,17.98,17.98,17.98,18.03,18.14,18.37,18.73,19.12,19.50,19.84,20.11,20.33,20.51,20.72,20.89,21.07,21.21,21.32,21.41,21.54,21.73,21.92,22.16,22.41,22.71,23.02,23.41,23.89,24.47,25.12,26,27.12,28.57,30.34,32.45,34.75,37.12,39.38,41.45,42.23,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7.22,7.37,7.58,7.61,7.57,7.37,7.25,7.34,7.64,7.89,7.99,7.99,7.98,9,9,10,10.49,10.49,10.98,12.49,13.99,16,16,16.49,17.99,18.99,22.49,22.49,23.50,24.99,26,27.49,27.49,29.45,30.60,32.09,33.83,34.14,35.34,36.60,38,40.98,40.98,42.98,44.50,46.03,48.86,49.10,49.75,50.85,52.29,54.12,54.58,55,55.72,56.65,57.59,58.36,59.16,60.32,61.91,64.07,64.87,66.36,68.61,71.25,76.34,76.57,78.48,80.49,81.49,77,77,70.50,63.50,58,51.98,51.98,53.48,54.99,56,60.49,60.49,65,70.49,74.99,86.50,86.50,92,94.99,95.49,91.98,91.98,89.50,88,86,82,82,80.49,78.49,77,74,74,72,70.98,70,69,69,68.49,68.10,67.75,67.35,67.10,67.12,67.37,67.71,67.87,67.61,66.75,65.37,63.27,60.64,59.33,58.25,57.12,55.87,54.64,53.95,53.25,52.47,51.49,50.98,50.98,50.49,50.49,50.49,50.50,50.50,50.64,50.99,51.27,51.46,51.25,50.77,50.25,49.74,47.73,47.25,46.46,45.61,44.40,43.23,42.07,40.89,39.75,38.60,37.38,36.23,35.02,33.87,32.86,32.12,31.74,31.22,30.37,29,27.75,26.77,25.91,25.11,24.26,23.40,22.62,21.88,21.14,20.37,19.65,19.08,18.61,18.14,17.71,17.33,17.07,16.63,16.28,15.98,15.98,15.64,15.29,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15.01,15.23,15.75,15.95,16,16,16,16,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,16,16.49,17,17,17,17,17,17,17.49,17.98,17.98,17.97,17.98,18.02,18.17,18.41,18.77,19.14,19.50,19.83,20.08,20.27,20.48,20.65,20.82,20.92,21.04,21.20,21.37,21.58,21.83,22.10,22.38,22.71,23.04,23.50,24.02,24.65,25.39,26.47,27.75,29.37,31.25,33.48,35.85,38.23,40.46,42.37,42.96,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7.07,7.12,7.14,7.22,7.14,7.12,7.12,7.25,7.73,7.87,7.96,7.98,8.32,8.64,9.33,9.72,10.11,10.39,10.98,11.91,13.01,15,15,15,15.98,17,20.98,20.98,22,24,25,26.87,27.24,28.64,29.75,31.61,33.62,33.64,34.75,35.75,37.83,40.87,40.98,42.98,45,46.07,48.84,48.78,49.01,49.74,51,52.61,53.08,53.64,54.40,55.42,56.57,57.37,58.22,59.45,61,62.48,63.46,65.20,67.34,70.34,75.74,75.90,77.87,80.89,80.95,75,75,69,62,57,52.98,52.98,55.98,57,57,60.98,60.98,65,70,72.98,84,84,90,94,95.98,92.98,92.98,90,89,87,82,82,80.98,79,77,74,74,72,70.98,70,69,69,67.98,67.87,67.75,67.21,66.98,66.98,67.11,67.25,67.25,67.01,66.40,65.39,63.73,61.25,59.98,58.76,57.62,56.24,54.75,53.86,53,52.12,50.98,50.98,50.98,50,50,50,50.01,50.09,50.12,50.83,50.97,51.12,50.97,50.75,50.15,49.75,48.21,47.50,46.65,45.74,44.62,43.47,42.34,41.25,40.12,38.90,37.75,36.58,35.37,34.24,33.13,32.35,31.70,31,30,28.82,27.63,26.63,25.91,25.12,24.26,23.45,22.70,21.99,21.27,20.40,19.65,19.08,18.62,18.24,17.70,17.15,17,17,15.98,15.98,15.98,15.98,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15.25,15.70,15.89,16.09,16.21,16.14,16.12,16.07,16,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,16,15.98,17,17,17,17,17,17,17,17.98,17.98,17.91,17.96,17.98,18.08,18.25,18.53,18.88,19.25,19.58,19.84,20.04,20.24,20.39,20.53,20.66,20.79,20.97,21.16,21.41,21.71,22.01,22.35,22.70,23.09,23.58,24.16,24.87,25.75,26.96,28.45,30.25,32.37,34.65,37.12,39.50,41.75,43.83,43.86,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7.01,7,7,7.01,7.25,7.63,7.88,7.96,7.98,8.32,8.64,9.33,9.65,10,10.33,10.75,11.41,12.32,13.09,12.98,14,15,15.98,17.98,17.98,20,21.88,23.12,25.71,26.12,27.21,28.62,30.08,31.27,32.37,33.26,34.45,35.86,39.50,39.98,42,44,45.09,47.82,47.75,47.76,48.28,49.36,50.67,51.38,52.36,53.26,54.37,55.49,56.46,57.38,58.57,60.08,61.42,62.53,63.48,65.89,68.37,72.65,73.16,76.14,79.87,79.89,72.04,72,67.98,62,57,55,55,59,60.98,62,62,62,65,69,70,80,80,85.98,90.98,94,94,94,90.98,89,87,82.98,82.98,80.98,79,77,74,74,72,70.98,70,69,69,67.98,67.87,67.14,66.88,66.72,66.73,66.77,66.86,66.85,66.63,66.23,65.50,64.62,62.26,60.65,59.36,58.01,56.97,54.86,53.85,52.90,52,51,50.02,50.01,50,50,50,50,50,50.02,50.09,50.87,50.86,50.83,50.15,49.99,49.77,48.14,47.50,46.84,45.87,44.75,43.63,42.58,41.50,40.45,39.33,38.14,37,35.84,34.62,33.57,32.60,31.72,30.96,29.96,28.73,27.62,26.62,25.88,25.07,24.15,23.37,22.65,21.97,21.27,20.39,19.42,19.03,18.70,18.15,17.92,17,17,15.98,15.98,15.98,15.98,15.98,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15.24,15.62,15.75,16.09,16.72,16.75,16.76,16.86,16.95,17,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,17,17,17,17,17,17,17,17,17.91,17.78,17.88,18,18.15,18.38,18.71,19.03,19.35,19.60,19.82,19.99,20.14,20.28,20.41,20.58,20.75,21,21.27,21.60,21.92,22.29,22.70,23.12,23.65,24.32,25.08,26.12,27.47,29.12,31.12,33.45,35.90,38.49,40.89,43.12,45.38,46.87,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7.33,7.63,7.91,7.97,7.98,8.32,8.64,9.33,9.65,10,10.33,10.64,11.09,11.58,12.54,12.87,13.02,14.07,15.09,16.90,17.09,18.11,19.90,21.25,23.22,24.65,26.09,27.37,28.70,29.87,30.98,32,33.12,34.82,36.49,37.50,39,40.98,43.09,44.82,45.23,46.25,47.33,48.34,49.61,50.40,51.35,52.42,53.47,54.75,55.59,56.82,58,59.25,60.41,61.49,62.66,64.20,66.45,70.61,71.23,73.88,76.82,77.83,69.11,69.04,65.98,60.98,59,55.98,55.98,60,64,67,65.98,65.98,69,70.98,70.98,77,77,80.98,85.98,90,92.98,92.98,90.98,89,87,82.98,82.98,80.98,79,77,74,74,72,70.98,70,67.98,67.98,67.98,67.08,66.85,66.37,66.37,66.37,66.46,66.50,66.50,66.37,66.09,65.57,64.62,63,61.37,59.87,58.37,56.70,54.88,53.88,53,52.15,51.09,50.09,50,50,50,50,50,50,50,50,50,50,50.07,50.10,49.87,49.12,48.12,47.52,46.96,46.02,44.95,43.84,42.75,41.75,40.76,39.75,38.62,37.51,36.37,35.13,33.99,32.88,31.89,31.08,30.01,28.85,27.71,26.62,25.87,24.98,23.87,23.11,22.75,21.87,21.12,20.87,19,19,19,17.98,17.98,17,17,15.98,15.98,15.98,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15.12,15.25,15.34,15.87,16.70,16.82,16.88,16.97,16.98,17,17,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,17,17,17,17,17,17,17,17,17.04,17.62,17.78,17.95,18.09,18.28,18.54,18.85,19.13,19.37,19.58,19.75,19.90,20.07,20.22,20.37,20.59,20.84,21.13,21.49,21.86,22.25,22.70,23.14,23.74,24.40,25.33,26.49,27.97,29.76,31.97,34.46,37.12,39.87,42.37,44.23,46.13,48.08,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7.01,7.33,7.64,7.95,7.97,7.98,8.32,8.64,9.26,9.61,9.92,10.33,10.64,10.99,11.40,11.88,12.51,12.90,13.11,14.13,15.83,16.12,17.25,18.33,19.73,21.96,23.65,25.04,26.37,27.62,28.85,29.98,31.11,32.33,33.82,35.25,36.58,37.33,37.98,40.11,43.82,44.23,45.73,46.70,47.36,48.73,49.40,50.85,52.09,53.33,54.42,55.48,56.41,57.47,58.54,59.62,60.64,61.59,62.54,63.49,67.57,68.25,71.24,74.76,75.77,71.12,70.87,67.95,65,62.98,60.98,60.98,60.98,64,67.98,72.98,72.98,75.98,77.98,79,80.98,80.98,82.98,87,89,89,89,87.98,87,85.98,82,82,80,77.98,75.98,72.98,72.98,70.98,70,69,67.98,67.98,67,66,66.11,66.08,65.97,66,66.09,66.13,66.22,66.15,66,65.62,64.75,63.50,61.99,60.37,58.64,56.87,54.96,54.11,53.25,52.38,51.83,50.11,50,50,50,50,50,50,50,50,50,50,50.07,50.01,49.85,49,48.13,47.62,47.10,46.24,45.11,44,42.97,42,41.12,40.13,39.11,38,36.84,35.61,34.37,33.24,32.14,31.12,30.02,28.96,27.87,26.86,25.87,24.87,23.83,22.72,22.25,21.75,21.12,20.87,20,20,19,17.98,17.98,17,17,15.98,15.98,15.98,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15.01,15.13,15.35,16.20,16.72,16.95,16.99,16.99,17,17,17,17,15.98,15.98,16,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,17,17,17,17,17,17,17,17,17.03,17.45,17.71,17.88,18.02,18.20,18.40,18.66,18.92,19.15,19.35,19.51,19.70,19.87,20.03,20.23,20.42,20.71,21.02,21.38,21.78,22.23,22.70,23.20,23.78,24.51,25.50,26.76,28.37,30.33,32.62,35.25,38.12,41.12,43.39,44.86,45.70,44.46,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7.33,7.64,7.97,7.98,7.98,8.32,8.64,9.15,9.50,9.83,10.32,10.63,11,11.29,11.70,12.27,12.70,13.32,14.17,15.77,16.16,17.10,18.21,19.71,21.26,22.92,24.40,25.70,26.95,28.15,29.37,30.62,31.90,33.32,34.65,35.89,37,37.98,40.11,44.34,44.73,45.48,46.36,47.36,48.61,49.40,50.64,51.99,53.26,54.37,55.29,56.10,57,58,59,59.99,60.97,62.08,63.50,67.03,67.82,70.66,73.72,75.75,72.66,72.36,69.39,66,64.48,61.98,61.98,61.98,63.49,66.49,71.98,71.98,74.99,77.49,79.99,83.48,83.48,85.48,88.50,89.99,88.49,88.49,86.98,86,84.99,81,81,79.50,77.49,75.49,72.49,72.49,70.98,70,69,67.49,67.49,66.49,65.99,65.87,65.65,65.51,65.52,65.65,65.84,65.99,66.10,66.09,65.83,65.13,64.02,62.58,60.87,59.11,57.25,55.48,54.40,53.62,52.87,52.25,50.12,50,50,50,50,50,50,50,50,50,50,50.11,50.34,49.83,49,48.20,47.63,47.12,46.39,45.24,44.12,43.12,42.25,41.37,40.49,39.47,38.37,37.20,35.97,34.72,33.50,32.37,31.27,30.15,29.10,28.02,27,26,24.97,23.82,22.87,22.14,21.71,21.24,20.87,20,20,19,18.49,17.98,17,17,15.98,15.98,15.98,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15.07,15.36,16,16.70,16.89,16.99,17,17,17,17,17,16.49,16.49,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,17,17,17,17,17,17,17,17,17.02,17.36,17.62,17.83,17.97,18.11,18.28,18.51,18.75,18.97,19.15,19.34,19.51,19.72,19.89,20.10,20.33,20.60,20.92,21.32,21.74,22.20,22.67,23.23,23.87,24.73,25.75,27.11,28.73,30.64,32.98,35.74,38.86,41.83,44,44.58,44.07,41.75,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7.33,7.64,7.98,7.98,7.98,8.32,8.64,9.04,9.37,9.72,10.29,10.63,11,11.29,11.71,12.25,12.71,13.38,14.26,15.75,16.21,17.08,18.22,19.57,21.03,22.53,23.99,25.34,26.62,27.85,29.12,30.40,31.75,33.12,34.47,35.74,36.88,38.01,40.09,44.84,44.78,45.26,46.21,47.35,48.62,49.38,50.72,51.90,53.10,54.34,54.99,55.75,56.62,57.62,58.62,59.59,60.54,61.58,63.51,66.52,67.36,69.67,72.66,75.72,74.23,73.83,71.09,67.02,65.98,62.98,62.98,62.98,62.98,65,70.98,70.98,74,77,80.98,85.98,85.98,87.98,90,90.98,87.98,87.98,85.98,85,84,80,80,79,77,75,72,72,70.98,70,69,67,67,65.98,65.98,65.95,65.14,64.98,65.07,65.25,65.50,65.84,66.12,66.26,66.25,65.75,64.74,63.25,61.50,59.63,57.76,55.87,54.88,54,53.25,52.71,50.13,50.12,50.12,50,50,50,50,50,50,50.01,50.10,50.12,50.82,50.15,49.22,48.21,47.75,47.23,46.39,45.37,44.26,43.36,42.50,41.62,40.74,39.72,38.62,37.45,36.24,35,33.82,32.65,31.59,30.48,29.37,28.36,27.35,26.33,25.23,24.12,23.12,22.37,21.75,21.20,20.61,20,20,19,19,17.98,17,17,15.98,15.98,15.98,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15.25,15.76,16.70,16.86,17.10,17.12,17,17,17,17,17,17,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,17,17,17,17,17,17,17,17,17.01,17.27,17.53,17.75,17.90,18.02,18.17,18.37,18.59,18.78,18.98,19.14,19.35,19.54,19.75,19.98,20.22,20.50,20.86,21.25,21.70,22.15,22.67,23.23,23.89,24.76,25.87,27.21,28.77,30.71,32.90,35.52,38.72,41.98,43.70,43.35,42.13,39.12,7.98,7.98,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7.02,7.02,7.35,7.64,7.98,7.98,7.98,8.32,8.64,9,9.33,9.66,10.29,10.64,11.01,11.35,11.74,12.29,12.75,13.42,14.39,15.71,16.25,17.10,18.22,19.52,20.95,22.37,23.79,25.16,26.50,27.76,29.09,30.40,31.75,33.12,34.48,35.75,37.02,38.10,40.10,43.86,44.21,45.25,46.26,47.33,49.63,49.98,50.72,51.73,52.79,53.78,54.66,55.48,56.37,57.39,58.37,59.28,60.16,61.32,62.53,65.51,66.36,68.34,70.92,73.72,75.73,75.77,73.87,71.04,69,65.98,65.98,65,65,65,69,69,70.98,75.98,80,90,90,90.98,90.98,90.98,87,87,85,82.98,82,77.98,77.98,77,75.98,75,72,72,70,69,67.98,65.98,65.98,65.98,65,65,64.12,64.37,64.50,64.83,65.24,65.72,66.23,66.64,66.87,66.75,65.62,64.11,62.25,60.27,58.33,56.61,55.35,54.39,53.58,52.64,51.13,50.77,50.12,50,50,50,50,50,50,50.07,50.87,50.96,51.83,50.85,49.82,48.22,48.12,47.60,46.74,45.64,44.62,43.65,42.82,41.88,40.95,39.87,38.77,37.62,36.48,35.27,34.13,33.07,32,30.96,29.87,28.84,27.84,26.76,25.63,24.50,23.50,22.63,21.88,21.20,20.36,19.24,19,19,19,17.98,17,17,15.98,15.98,15.98,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15.01,15.20,15.50,16.22,16.86,17.37,17.86,17.98,17,17,17,17,17,17,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,17,17,17,17,17,17,17,17,17,17.15,17.45,17.66,17.85,17.97,18.09,18.24,18.40,18.60,18.77,18.97,19.15,19.37,19.60,19.84,20.11,20.41,20.78,21.21,21.64,22.13,22.65,23.22,23.89,24.75,25.86,27.12,28.64,30.45,32.47,34.75,37.49,40.85,41.98,41.34,39.75,36.52,7.98,7.98,7.98,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7.03,7.10,7.16,7.47,7.73,7.98,7.98,7.98,8.32,8.64,9,9.33,9.66,10.29,10.65,11.10,11.52,12,12.60,13.03,13.71,14.53,15.67,16.26,17.12,18.26,19.59,20.97,22.37,23.77,25.15,26.50,27.85,29.15,30.51,31.87,33.25,34.60,35.90,37.25,38.83,40.12,43.88,44.15,45.75,46.73,47.84,49.65,49.91,50.58,51.50,52.51,53.52,54.47,55.33,56.24,57.20,58.27,58.96,59.75,60.66,62.13,64.53,64.88,66.62,68.65,71.16,74.50,74.52,75.35,74.36,73.04,69.58,69.54,69.48,68.35,67.24,72.03,72,72.98,75.98,82,92,92,92,90,89,85.98,85.98,84,82,80,75.98,75.98,75,74,72.98,70.98,70.98,69,67.98,67,65.98,65.98,65,65,64,63.96,63.75,63.96,64.34,64.87,65.62,66.38,67.15,67.82,67.86,66.86,65.13,63.20,60.97,58.76,56.77,55.70,54.75,53.87,52.75,51.14,51,50.14,50.12,50.12,50,50,50,50,50.08,50.87,50.97,51.82,51.75,50.96,49.25,49,48.33,47.36,46.24,45.12,44.12,43.21,42.23,41.21,40.12,39,37.87,36.75,35.62,34.58,33.51,32.51,31.51,30.50,29.48,28.40,27.35,26.15,25,23.89,23,22.14,21.34,20.38,19.50,19.09,19,17.98,17.98,17,17,15.98,15.98,15.98,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15.11,15.26,15.87,16.98,17.23,17.57,17.98,17.98,17,17,17,17,17,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,17,17,17,17,17,17,17,17,17,17.10,17.34,17.58,17.77,17.90,18,18.12,18.25,18.39,18.57,18.75,18.96,19.17,19.41,19.67,19.99,20.35,20.74,21.15,21.62,22.11,22.62,23.23,23.90,24.75,25.76,26.98,28.35,29.87,31.60,33.49,35.37,37,37.87,37.87,36.02,33.73,7.98,7.98,7.98,7.98,7.98,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7.11,7.23,7.38,7.63,7.83,7.98,7.98,7.98,8.32,8.64,9,9.32,9.67,10.28,10.67,11.21,11.75,12.29,12.91,13.40,14.04,14.76,15.65,16.28,17.17,18.37,19.70,21.08,22.47,23.86,25.23,26.60,27.96,29.32,30.65,32.02,33.37,34.75,36.11,37.50,38.99,40.39,43.91,44.13,45.78,46.76,47.26,48.70,49.33,50.32,51.27,52.36,53.40,54.36,55.26,56,56.90,57.76,58.52,59.25,60.04,60.50,62.14,62.39,63.36,65.53,67.73,72.12,73.50,74.51,76.01,77.08,79.10,79.12,78.20,76.28,75.85,80.58,80.78,82.98,82.98,84,90,90,90,89,85.98,82.98,82.98,82,80,77.98,74,74,72.98,72,70.98,69,69,67.98,67,65.98,65,65,64,64,62.98,62.98,63.15,63.34,63.50,64.62,65.57,66.59,67.71,69,69.96,67.95,66.98,64.07,61.62,59.24,56.74,55.96,55.11,54.15,53.12,52.20,51.77,51.10,50.82,50.12,50.08,50,50,50,50.08,50.12,50.13,51.13,52.75,53.75,51.23,50.47,49.26,48.12,46.97,45.77,44.73,43.70,42.62,41.50,40.37,39.25,38.20,37.10,36.08,35.08,34.12,33.20,32.24,31.22,30.12,29.02,27.90,26.75,25.50,24.37,23.37,22.50,21.62,20.75,20,19.51,18.87,18.09,17.87,17.02,16.99,15.98,15.98,15.98,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15.01,15.12,15.60,16.07,16.62,17.12,17.62,17.98,17.98,17.98,17,17,17,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,17,17,17,17,17,17,17,17,17.03,17.15,17.51,17.66,17.83,17.91,18.01,18.11,18.22,18.35,18.52,18.75,18.99,19.25,19.54,19.88,20.26,20.67,21.12,21.58,22.04,22.58,23.14,23.85,24.62,25.58,26.62,27.86,29.14,30.52,31.95,33.20,34,34.27,33.75,32.38,29.95,7.98,7.98,7.98,7.98,7.98,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7.07,7.10,7.12,7.12,7.12,7.25,7.39,7.62,7.82,7.92,7.98,7.98,7.98,8.32,8.64,9,9.32,9.67,10.28,10.70,11.28,11.91,12.59,13.23,13.77,14.41,15.07,15.66,16.32,17.26,18.50,19.87,21.24,22.61,23.99,25.36,26.74,28.10,29.45,30.84,32.15,33.50,34.86,36.22,37.62,39.13,40.96,43.07,43.59,44.84,45.78,46.23,48.73,49.28,50.09,51.11,52.26,53.38,54.14,54.82,55.60,56.50,57.35,58.04,58.64,59.35,60.24,61.04,61.79,62.77,64.50,67.02,70.34,72.12,73.87,75.92,78.47,79.97,80.49,80.01,79.46,79.86,82.76,83.98,85.22,85.48,85.99,88.99,88.99,88.99,88,84.99,81.98,81.98,81,79.50,77.98,73.49,73.49,72.49,71.49,70.49,68.49,68.49,67.49,66.49,65.49,64.50,64.50,64,63.49,62.98,62.98,63,63.11,63.37,64.37,65.46,66.62,68.12,69.73,70.62,68.76,67.09,64.71,62.14,59.62,57.14,56.35,55.57,54.62,53.62,52.70,52.26,51.62,51,50.50,50.12,50,50,50,50,50,50.12,51.13,52.46,53.75,51.74,51.23,50.21,48.98,47.73,46.50,45.37,44.26,43.15,41.99,40.76,39.64,38.62,37.58,36.60,35.62,34.76,33.96,33.01,32,30.86,29.63,28.50,27.33,26.01,24.82,23.75,22.86,21.98,21.11,20.34,19.62,18.99,18.13,17.82,17.12,16.88,16,15.98,15.98,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15.12,15.25,15.46,15.87,16.50,17.12,17.62,17.98,17.98,17,17,17,16.49,16.49,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,17,17,17,17,17,17,17,17,17,17.12,17.28,17.50,17.67,17.85,17.95,18,18.08,18.17,18.35,18.58,18.84,19.12,19.45,19.82,20.22,20.64,21.09,21.52,22,22.49,23.02,23.65,24.39,25.25,26.22,27.25,28.37,29.49,30.50,31.36,31.72,31.33,30.88,30.59,29.75,7.98,7.98,7.98,7.98,7.98,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7.07,7.12,7.24,7.32,7.36,7.37,7.52,7.67,7.86,7.97,8,7.98,7.98,7.98,8.32,8.64,9,9.29,9.67,10.27,10.71,11.32,11.95,12.63,13.27,13.90,14.59,15.29,15.91,16.34,17.36,18.72,20.04,21.39,22.75,24.13,25.50,26.87,28.23,29.58,30.89,32.24,33.50,34.84,36.14,37.52,39,40.61,42.24,43.11,43.99,44.85,45.17,48.76,49.25,49.96,50.88,51.99,53.42,53.63,54.17,54.89,55.83,57.36,57.38,57.88,58.64,59.57,60.53,60.78,61.72,63.38,65.79,68.60,70.67,72.77,75.17,78,80.58,80.62,80.82,81.25,83.10,85,86.61,87.41,87.72,87.98,87.98,87.98,87.98,87,84,80.98,80.98,80,79,77.98,72.98,72.98,72,70.98,70,67.98,67.98,67,65.98,65,64,64,64,62.98,62.98,62.98,62.87,62.87,63.24,64.20,65.47,66.51,68.37,70.34,71.26,68.73,67.22,65.12,62.59,60.11,57.62,56.95,56.20,55.34,54.25,53.15,52.87,52.15,51.12,50.96,50.12,50.10,50.02,50,50.07,50,50.12,51.07,52.21,53.75,52.24,51.83,51.01,49.85,48.50,47.24,46.10,45.01,43.87,42.62,41.37,40.24,39.24,38.23,37.25,36.35,35.57,34.83,33.96,32.87,31.64,30.25,29.23,28,26.64,25.33,24.23,23.25,22.37,21.49,20.62,19.86,19.11,18.23,17.75,17.20,16.84,16.09,15.99,15.98,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15.10,15.21,15.45,15.96,16.48,17.09,17.98,17.98,17,17,17,17,17,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,17,17,17,17,17,17,17,17,17,17.04,17.14,17.21,17.54,17.74,17.88,17.97,18,18.08,18.22,18.45,18.73,19.02,19.37,19.75,20.17,20.62,21.03,21.47,21.90,22.37,22.87,23.48,24.12,24.87,25.74,26.62,27.59,28.50,29.37,30,30.25,30.11,30.13,29.76,29.62,7.98,7.98,7.98,7.98,7.98,7.98,7.98,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7.12,7.25,7.39,7.60,7.73,7.82,7.92,8.08,8.22,8.27,8.29,8.29,8.32,8.32,8.53,8.76,9,9.29,9.67,10.27,10.71,11.32,11.95,12.63,13.32,13.98,14.65,15.48,16.63,16.97,17.77,18.91,20.23,21.57,22.92,24.32,25.67,27.02,28.36,29.66,31,32.25,33.50,34.75,36,37.35,38.72,40.12,41.40,42.50,43.01,44.10,45.13,48.84,48.91,49.67,50.58,51.40,52.47,52.84,53.25,53.95,54.86,55.65,56.32,56.88,57.64,58.57,58.79,59.29,60.17,61.87,64.33,66.87,69.21,71.21,73.77,76.49,78.37,79.38,80.28,81.62,84,87.82,88,89.22,88.50,88.82,87,87,85,85,82.98,79,79,77.98,77,75.98,72,72,70.98,70,69,67,67,65.98,65.98,65,64,64,64,62.98,62.98,62.98,62.89,62.12,62.74,63.32,65.57,66.09,67.46,69.40,70.36,68.62,68.34,65.35,62.98,60.60,58.50,57.83,57.25,56.32,55.25,54.21,54,53.13,52.13,51.85,51.10,51,51,50.98,50.01,50.10,50.12,51,51.99,52.75,53.21,52.87,52.02,50.77,49.37,47.99,46.98,46.08,44.87,43.50,42.12,41,40.12,39.12,38.12,37.23,36.47,35.75,34.95,33.87,32.61,31.25,30.20,28.98,27.62,26.12,24.87,24,23,22.08,21.12,20.25,19.27,18.71,17.88,17.25,16.76,16.12,16.09,15.95,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15.08,15.14,15.48,15.75,16.34,17,17,17.98,17,17,17,17,15.98,15.97,15.97,15.97,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,17,17,17,17,17,17,17,17,17.02,17.12,17.21,17.66,17.88,17.96,17.97,18.01,18.12,18.37,18.66,19,19.32,19.71,20.14,20.59,21,21.39,21.82,22.25,22.72,23.24,23.84,24.50,25.25,26.01,26.86,27.70,28.50,29.25,29.75,29.37,30.62,31.36,31.97,9,9,7.98,7.98,7.98,7.98,7.98,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7.07,7.14,7.37,7.62,7.87,8.12,8.25,8.37,8.53,8.66,8.77,8.83,8.88,8.95,8.99,9.10,9.22,9.33,9.52,9.79,10.28,10.71,11.33,11.97,12.65,13.35,14.02,14.76,15.63,16.63,17.27,18.02,19.10,20.36,21.71,23.09,24.48,25.85,27.16,28.48,29.75,31.01,32.25,33.39,34.60,35.75,37,38.25,39.60,40.83,41.85,42.98,43.97,45.89,47.87,47.92,48.75,49.67,50.27,51.54,51.62,52.07,52.74,53.60,54.50,54.99,55.53,56.16,56.58,56.96,57.38,58.36,59.79,62.59,66.21,67.38,69.21,71.40,73.74,75.54,77.07,78.25,79.97,82.35,85.62,85.82,87,86.28,86.60,84.96,85,84,82,80.98,77,77,75.98,75,75,72,72,70,69,67.98,65.98,65.98,65.98,65,65,64,64,62.98,62.98,62.98,62,62,61.97,61.85,62.21,64.71,64.62,65.52,66.70,67.45,67.52,67.38,65.48,63.50,61.45,59.45,59.37,58.34,58.25,57.22,56.14,56,55.15,54.13,53.12,52.11,52.09,52.02,52,51,51.02,50.99,51.12,51.12,52.97,54.75,54.75,53,51.87,50.59,48.49,48.40,47.51,46.37,44.87,42.50,42.47,41.37,40.37,39.21,38.23,37.45,36.75,36.02,34.85,33.61,32.37,31.25,30.08,28.65,27.25,25.97,24.77,23.75,22.74,21.76,20.87,20.10,19.33,18.27,17.26,17.12,16.75,16.12,15.87,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15.07,15.12,15.12,15.35,15.98,15.98,15.98,15.98,15.98,17,16.99,15.92,15.89,15.87,15.96,15.97,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,17,17,17,17,17,17,17,16.99,17,17.01,17.16,17.76,17.89,17.96,17.97,17.99,18.08,18.26,18.73,18.99,19.25,19.65,20.12,20.54,20.95,21.33,21.71,22.11,22.50,23,23.51,24.12,24.77,25.50,26.25,27.07,28,29.15,30.22,31.13,32.37,33.96,35,9,9,9,9,7.98,7.98,7.98,7.98,7,7.08,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7.09,7.23,7.48,7.75,8.12,8.45,8.64,8.78,8.98,9.14,9.34,9.47,9.59,9.62,9.65,9.65,9.65,9.65,9.79,10.01,10.39,10.75,11.35,12.03,12.79,13.50,14.17,14.92,15.76,16.63,17.33,18.10,19.16,20.46,21.83,23.23,24.62,25.98,27.27,28.53,29.75,31,32.13,33.25,34.34,35.39,36.57,37.77,39.10,40.35,41.45,42,42.98,44,45.92,46.03,47.15,48.22,48.27,49.87,50.38,50.40,51.39,52.41,53.14,53.37,54.22,54.40,55.02,54.97,55.25,56.48,58.21,60.78,63.50,65.62,67.25,69.10,70.92,73.09,74.75,75.98,77.54,79.48,80.97,81.34,81.12,81.85,80.58,79.24,79,77.98,77,75.98,74,74,72.98,72,72,69,69,67.98,67,65.98,65,65,65,64,64,62.98,62.98,62.98,62.98,62,62,62,61,60.90,60.12,61.87,62.25,63.25,64.26,65.35,66.14,66.09,65.51,64.58,63.58,61.87,61.62,61.70,60.75,60.75,58.77,58.82,57.77,56.85,54.86,53.87,53.89,53.96,52.98,52.97,51.96,51.87,51.10,51.95,53.12,54.82,54.76,53.63,52.75,52.50,50.87,50.47,49.48,48.48,46.49,44.88,44.57,43.60,41.62,40.33,39.25,38.37,37.62,36.85,35.71,34.47,33.35,32.25,31.23,29.75,28.33,26.97,25.73,24.58,23.50,22.50,21.62,20.75,19.97,19.60,18.22,17.65,17.12,16.77,15.98,15.02,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14.99,14.99,14.98,14.87,14.75,14.62,14,14,14,14,14,14.01,14.07,15.10,15.12,15.83,15.88,15.96,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,16,15.98,15.98,17,17,17,17,17,17,16.99,17,17.12,17.82,17.91,17.96,17.97,17.97,18.02,18.23,18.75,18.99,19.22,19.62,20.08,20.50,20.87,21.24,21.60,21.96,22.34,22.75,23.25,23.82,24.39,25.09,25.76,26.61,27.62,29.35,31.48,32.62,34.76,35.89,37,9.50,9.50,9,9,8.49,7.98,7.98,7.98,7.49,7.21,7.12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7.12,7.25,7.50,7.87,8.25,8.62,8.88,9.09,9.33,9.53,9.76,9.92,10.04,10.07,10.04,10.01,10,10,10.13,10.33,10.61,10.86,11.39,12.20,13.02,13.77,14.41,15.16,15.96,16.66,17.35,18.12,19.21,20.50,21.89,23.33,24.72,26.04,27.34,28.54,29.72,30.88,31.97,32.98,33.97,34.98,36.08,37.26,38.62,39.90,41.07,42,42.49,43.49,45.98,45.98,46.97,47.48,48.14,49.16,49.60,50.09,50.73,51.49,52.12,52.73,53.17,53.62,53.88,54.17,54.70,55.64,57.17,59.67,62.08,64.09,65.57,67.12,69.29,71.24,72.97,74,75.35,76.83,77.97,78.65,79,79.10,78.78,78.33,78,76.98,76,74.99,73.49,73.49,72.49,71.49,71,68.49,68.49,67.49,66.49,65.49,64.50,64.50,64.50,64,63.49,62.98,62.98,62.98,62.49,62,61.49,61.49,60.98,60.40,59.10,60.85,61.20,62,63,64.14,65.15,65.37,65.13,64.62,63.87,63.21,62.71,62.25,61.64,61.27,60.14,59.82,58.84,57.12,55.61,54.60,54.45,53.99,53.49,53.49,52,51.90,51.59,52.12,53.12,54.34,54.33,53.75,53.22,52.58,52.12,51.50,50.57,49.12,47.40,45.95,45.08,44.11,42.65,41.25,40.12,39.21,38.37,37.45,36.35,35.24,34.13,33.12,32.09,30.65,29.25,27.90,26.63,25.49,24.37,23.35,22.37,21.49,20.62,19.52,18.37,17.85,17.48,16.98,16.33,15.58,15.49,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14.99,14.99,14.98,14.96,14.90,14.83,14.70,14.51,14.28,14.11,14,14,14,14,14,14.11,14.50,15,15.45,15.76,15.90,15.95,15.96,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,16.49,17,17,17,17,17,17,17,17.09,17.86,17.92,17.97,17.97,17.97,18,18.17,18.79,18.99,19.16,19.59,20.03,20.46,20.82,21.13,21.48,21.77,22.12,22.52,23,23.51,24.12,24.76,25.50,26.37,27.48,29.64,32.13,33.50,34.62,35.89,36.49,10,10,9,9,9,7.98,7.98,7.98,7.98,7.38,7.23,7.11,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7.12,7.32,7.57,7.87,8.26,8.63,9.01,9.25,9.51,9.76,10.03,10.24,10.34,10.32,10.29,10.29,10.33,10.33,10.46,10.62,10.84,10.99,11.46,12.32,13.26,14.09,14.70,15.38,16.20,16.87,17.36,18.21,19.24,20.53,21.96,23.37,24.75,26.08,27.32,28.48,29.59,30.71,31.65,32.62,33.50,34.50,35.59,36.76,38.10,39.37,40.57,41.49,42.25,42.98,45.98,45.98,47,47.02,47.62,48.37,49,49.60,50.22,50.83,51.41,51.97,52.41,52.88,53.04,53.45,54.12,55.15,56.62,58.87,61.11,63.22,64.51,65.97,67.98,69.78,71.37,72.52,73.89,75.24,76.25,76.90,77.27,77.48,77.37,77.15,77,75.98,75,74,72.98,72.98,72,70.98,70,67.98,67.98,67,65.98,65,64,64,64,64,62.98,62.98,62.98,62.98,62,62,60.98,60.98,60.98,60,58,59.87,60.12,60.83,61.83,62.75,64.75,64.74,64.73,64.73,64,63.75,63.77,62.96,62.14,61.84,61.12,60.83,59.86,57.12,55.87,54.90,54.96,54,54,54,52,51.98,51.90,52.02,52.87,53.86,53.85,53.75,53.26,52.87,52.58,52.51,51.57,49.82,48.01,46.37,45.60,44.62,43.26,41.97,40.85,39.87,38.99,38.01,36.96,35.87,34.86,33.83,32.71,31.47,30.12,28.86,27.62,26.48,25.37,24.27,23.27,22.34,21.25,20.08,18.45,18.26,17.89,17.25,16.82,16.09,15.98,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14.99,14.97,14.95,14.89,14.83,14.70,14.52,14.34,14.15,14.04,14,14,14,14,14.01,14.08,14.16,14.78,15.02,15.73,15.72,15.83,15.90,15.92,15.95,15.96,15.98,15.98,15.98,15.98,15.98,15.98,15.99,15.98,17,17,17,17,17,17,17,17.02,17.90,17.95,17.97,17.97,17.97,18,18.12,18.85,18.99,19.12,19.54,20.01,20.41,20.75,21.02,21.35,21.62,21.97,22.35,22.75,23.27,23.88,24.61,25.37,26.33,27.47,29.71,32.62,33.62,34.20,35.89,35.98,10,10,10,9,9,7.98,7.98,7.98,7.98,7.58,7.37,7.23,7.12,7.07,7,7,7,7,7,7,7,7,7,7,7,7,7.12,7.25,7.50,7.87,8.25,8.62,9,9.32,9.59,9.87,10.16,10.42,10.59,10.62,10.62,10.62,10.64,10.64,10.75,10.85,10.99,11.14,11.57,12.47,13.38,14.25,14.87,15.54,16.36,17.63,17.75,18.29,19.24,20.52,21.98,23.40,24.75,26.02,27.23,28.35,29.39,30.38,31.32,32.14,33,33.98,35.01,36.23,37.46,38.65,39.85,40.88,41.95,43.26,45,45,45.98,46.25,46.82,47.49,48.25,48.87,49.49,50.04,50.57,51.04,51.52,51.64,52.07,52.67,53.53,54.65,56.12,58.17,60.37,62.24,63.34,64.71,66.61,68.35,69.87,71.02,72.37,73.58,74.48,75.10,75.48,75.72,75.73,75.70,75.98,74,72.98,72.98,70.98,70.98,70.98,70,69,67,67,65.98,65,65,64,64,64,62.98,62.98,62.98,62.98,62,62,60.98,60.98,60.98,60.98,59,55.98,58.99,58.95,58.89,59.11,60.12,62.85,62.77,63.82,63.83,63.83,63.85,63.86,63.85,63.07,62.83,61.86,61.86,59.87,56.87,54.89,52.89,52.97,52,52,50.98,50,49.95,50.79,51.75,52.29,52.90,53.25,53.77,53.75,53.09,52.33,52.01,51.62,50.61,48.62,46.33,45.87,44.97,43.74,42.51,41.45,40.48,39.57,38.58,37.52,36.50,35.48,34.40,33.34,32.13,30.95,29.75,28.62,27.59,26.50,25.48,24.46,23.38,22.25,20.90,19.50,19.11,18.71,18.23,17.75,16.10,15.98,15.98,15.98,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14.99,14.98,14.95,14.90,14.84,14.73,14.58,14.38,14.22,14.09,14.01,14,14,14,14,14,14.03,14.12,14.24,14.25,14.98,15.28,15.67,15.67,15.71,15.82,15.90,15.91,15.92,15.92,15.92,15.95,15.96,15.98,15.98,17,17,17,17,17,17,17,17,17.98,17.97,17.97,17.97,17.97,17.99,18.07,18.90,19,19.04,19.51,20,20.37,20.63,20.90,21.20,21.48,21.75,22.12,22.58,23.11,23.75,24.50,25.37,26.39,27.65,29.89,31.97,33.71,34.83,35.89,35.98,10.98,10.98,10,10,9,7.98,7.98,7.98,7.98,7.74,7.51,7.37,7.25,7.13,7.09,7,7,7,7,7,7,7,7,7,7,7,7.10,7.25,7.48,7.75,8.12,8.51,8.89,9.25,9.57,9.88,10.22,10.51,10.73,10.84,10.88,10.92,10.98,11.09,11.20,11.32,11.35,11.57,11.98,12.75,13.51,14.33,14.97,15.63,16.28,17.65,17.96,18.28,19.17,20.52,22,23.46,24.71,25.91,27.10,28.15,29.16,30.02,30.87,31.65,32.50,33.45,34.47,35.61,36.82,38,39.12,40.25,41.45,42.59,43.70,44,44.75,45.01,45.73,46.49,47.24,47.96,48.59,49.11,49.51,49.83,49.99,50.16,50.92,51.88,52.96,54.17,55.61,57.57,59.39,60.97,61.91,63.25,65.03,66.74,68.27,69.50,70.79,71.87,72.64,73.13,73.38,73.62,73.67,73.71,74,72.98,72,70.98,70,70,70,69,67.98,65.98,65.98,65.98,65,64,64,64,62.98,62.98,62.98,62.98,62.98,62,60.98,60.98,60.87,60.87,60.82,57.75,55.45,56.36,56.36,57.10,56.23,55,59,58.98,60.89,60.88,60.87,63.87,63.87,63.87,63.87,62.86,60.87,60.87,56.87,53.90,50.89,48,47.98,47,47,45.98,46.92,46.82,48.74,50.66,51.65,52.60,52.62,53.70,53.76,53.75,52.25,52.02,51.25,50.15,48.75,47.33,46.64,45.33,44.35,43.10,42,41,40.12,39.13,38.12,37.11,36.08,35,33.97,32.84,31.71,30.62,29.63,28.77,27.85,26.87,25.82,24.76,23.61,22.25,20.50,20.45,20.10,19.25,18.14,17.12,17,15.98,15.98,15.98,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14.99,14.98,14.97,14.91,14.86,14.75,14.62,14.45,14.25,14.12,14.02,14,14,14,14,14,14,14.01,14.04,14.04,14.26,14.70,14.76,14.88,15,15.17,15.65,15.66,15.70,15.72,15.75,15.76,15.82,15.87,15.91,15.97,15.98,15.98,17,17,17,17,17,17,17.98,17.98,17.98,17.98,17.98,17.98,17.98,19,19,19.08,19.51,19.90,20.25,20.51,20.76,21,21.26,21.59,21.90,22.37,22.89,23.62,24.46,25.45,26.61,28.09,30.12,32.61,33.70,34.87,35.89,37,12,12,12,10.98,10,9,9,9,7.98,7.88,7.73,7.59,7.46,7.26,7.13,7.08,7,7,7,7,7,7,7,7,7,7,7.07,7.14,7.37,7.63,8,8.37,8.75,9.12,9.50,9.83,10.17,10.51,10.77,10.91,10.98,10.98,11.02,11.25,11.49,11.65,11.74,12.03,12.49,13.16,13.77,14.46,15.03,15.70,16.26,17.67,17.97,18.26,19.12,20.26,22.37,23.49,24.58,25.74,26.98,28,28.84,29.62,30.37,31.20,32,32.87,33.85,34.97,36.14,37.35,38.50,39.63,40.83,41.84,42.25,42.10,43.25,43.72,44.62,45.46,46.25,47.01,47.63,48.12,48.41,48.54,48.60,48.57,49.90,51.16,52.42,53.77,55.29,57.01,58.64,59.99,60.89,62.17,63.91,65.57,67.09,68.26,69.51,70.50,71.13,71.52,71.73,71.95,71.90,71.54,70.98,70,70,69,67.98,67.98,67.98,67,67,65,65,64,64,62.98,62.98,62.98,62.98,62,62,60.97,60.97,60.72,60.50,59.95,58.12,58.12,56.50,56.39,55.62,50.36,50.36,49.62,47.35,45.98,50,50,50.99,50.01,52.02,57.08,57.09,57.10,57.10,58.08,57.09,56.89,53.98,48,45,40.98,40.98,40,40,40,40.16,40.26,41.30,43.35,46.36,49.63,50.33,51.24,52.78,53.87,53.12,52.76,51.20,50.15,49,48.12,47.70,46.73,44.98,43.62,42.47,41.47,40.70,39.76,38.75,37.72,36.65,35.62,34.60,33.50,32.40,31.46,30.59,29.85,29.50,28.07,27.15,26.23,25.25,23.70,22.75,22.50,21.70,20.73,19.77,18.10,17.98,17.98,17,17,17,17,15.98,15.98,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14.99,14.98,14.96,14.89,14.79,14.66,14.50,14.33,14.15,14.07,14,14,14,14,14,14,14,14,14,14.04,14.12,14.25,14.34,14.34,14.34,14.34,14.89,15.15,15.26,15.27,15.25,15.23,15.17,15.12,15.09,15.01,15.98,15.98,15.98,15.98,17,17,17,17,17,17.98,17.98,17.98,17.98,17.98,17.98,19,19,19.25,19.50,19.85,20.12,20.37,20.62,20.87,21.11,21.37,21.73,22.13,22.74,23.48,24.37,25.48,26.75,28.37,30.33,32.50,33.62,34.08,35,35.98,12.49,12.49,12,10.98,10.49,9.50,9.50,9,8.49,7.98,7.87,7.75,7.62,7.46,7.25,7.12,7,7,7,7,7,7,7,7,7,7,7,7.12,7.25,7.51,7.87,8.25,8.62,9,9.37,9.75,10.11,10.45,10.74,10.89,10.98,10.98,11.13,11.49,11.83,11.99,12.14,12.47,13,13.62,14.15,14.66,15.14,15.73,16.25,17.71,17.97,18.25,19.08,20.24,22.75,23.42,24.32,25.39,26.62,27.62,28.46,29.12,29.87,30.72,31.50,32.33,33.24,34.35,35.58,36.82,37.99,39.12,40.20,41,41.35,41.77,42.37,43.09,43.90,44.64,45.52,46.24,46.89,47.27,47.47,47.52,47.40,47.49,49.22,50.64,52.02,53.47,54.99,56.66,58.14,59.37,60.29,61.50,63.10,64.62,66.09,67.28,68.62,69.52,70.07,70.25,70.39,70.62,70.50,70.32,69.99,69.50,69.50,68.49,67.98,67.98,67.49,66.49,66.49,64.50,64.50,64,63.49,62.98,62.49,62.49,62.49,62,61.49,60.47,60.47,60.11,59.64,58.98,57.13,57.13,56.25,54.58,53.70,48.71,48.71,47.26,45.73,44.48,47.50,47.50,47.99,47.99,50,55.46,55.45,55.01,55.01,55.90,55.52,55.46,52.47,46.98,43.50,40.49,40.49,39.50,39.50,39.50,39.51,39.74,40.36,41.89,44.41,48.10,48.87,50.15,51.77,53.45,53.47,53.35,51.63,50.50,49.34,48.22,47.74,46.76,45.60,44.26,42.48,41.75,41.23,40.40,39.37,38.34,37.32,36.32,35.25,34.15,33.12,32.12,31.33,30.61,29.75,28.87,27.87,26.90,25.90,24.98,24.14,23.50,22.84,21.71,20.25,18.73,18.37,17.99,17.51,17.45,17,17,16.49,16.49,15.49,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14.99,14.99,14.97,14.92,14.86,14.74,14.57,14.37,14.22,14.09,14.01,14,14,14,14,14,14,14,14,14,14,14.03,14.03,14.03,14.04,14.08,14.21,14.39,14.66,14.86,14.98,15,15.01,15.02,15.01,15.01,15.02,15.49,15.49,15.98,15.98,16.49,17,17,17,17,17.98,17.98,17.98,17.98,17.98,17.98,19,19,19.22,19.47,19.74,20,20.25,20.48,20.70,20.89,21.15,21.50,21.96,22.51,23.27,24.25,25.38,26.76,28.45,30.34,32.08,33.34,34.02,34.99,35.98,12.98,12.98,12,10.98,10.98,10,10,9,9,7.98,8.10,7.96,7.82,7.62,7.37,7.20,7.08,7,7,7,7,7,7,7,7,7,7,7.09,7.23,7.47,7.75,8.12,8.50,8.88,9.25,9.64,10,10.37,10.67,10.87,10.98,11.09,11.37,11.71,12.03,12.22,12.48,12.82,13.34,13.97,14.67,14.88,15.21,15.75,16.21,17.75,17.97,18.21,19.04,20.21,22.78,23.03,23.87,24.90,26.01,27.70,27.90,28.58,29.38,30.25,30.98,31.73,32.59,33.65,34.96,36.23,37.47,38.52,39.50,40.25,40.58,41.22,41.87,42.71,43.52,44.40,45.23,45.96,46.41,46.62,46.71,46.74,46.91,47.37,48.89,50.35,51.75,53.16,54.76,56.53,58.04,59.21,60.11,61.25,62.78,64.24,65.53,66.59,67.76,68.60,69.03,69.21,69.45,69.66,69.54,69.29,69,69,69,67.98,67.98,67.98,67,65.98,65.98,64,64,64,62.98,62.98,62,62,62,61.73,60.64,59.88,59.21,58.60,57.86,57.25,56.47,55.99,55.87,52.75,51.75,47.01,47.01,44.96,44.11,42.98,45,45,45,45.98,47.98,54,54,52.98,52.98,54,54,54,50.98,45.98,42,40,40,39,39,39,38.82,38.92,39.34,40.35,42.42,46.58,46.82,48.68,50.76,52.98,53.97,53.88,52.12,50.89,49.84,48.12,47.98,47.12,45.98,44.85,42.12,42.12,41.71,40.87,39.98,38.98,38,37.07,36,34.87,33.75,32.75,31.87,31.08,30.21,29.25,28.35,27.46,26.62,25.87,25.21,24.50,23.82,22.50,21,19.25,18.87,18.12,18.12,17.87,17.07,17,17,17,15.98,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14.99,14.99,14.97,14.90,14.82,14.64,14.46,14.26,14.12,14.03,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14.01,14.07,14.16,14.35,14.66,14.73,14.84,14.92,14.96,14.97,14.99,15.03,15,15,15.98,15.98,16.14,16.64,16.96,17,17.25,17.61,17.89,17.96,17.97,17.98,17.98,19,19,19.12,19.37,19.62,19.87,20.11,20.32,20.50,20.74,20.99,21.32,21.75,22.33,23.09,24.01,25.22,26.62,28.25,29.98,31.61,32.82,33.97,35,35.98,14,14,14,12,10.98,10.98,10.98,10,9,9,8.14,8.23,8.09,7.86,7.59,7.34,7.12,7.10,7.11,7.10,7.07,7,7,7,7,7,7,7.01,7.14,7.37,7.72,8.08,8.48,8.87,9.25,9.64,10,10.34,10.64,10.86,10.98,11.20,11.53,11.87,12.22,12.51,12.87,13.21,13.76,14.12,14.88,14.99,15.15,15.79,16.15,17.77,17.97,18.15,19.03,20.15,21.86,22.11,23.07,24.03,25,27,27,27.88,28.87,29.70,30.35,31,31.83,32.90,34.15,35.49,36.59,37.57,38.47,39.26,39.87,40.61,41.37,42.27,43.25,44.13,45.10,45.74,46.22,46.12,46,46.12,46.62,47.48,48.83,50.16,51.51,52.96,54.57,56.38,57.87,59,59.82,60.90,62.37,63.70,64.84,65.73,66.72,67.47,67.87,68.04,68.24,68.40,68.35,68.17,67.98,67.98,67.98,67.98,67,67,65.98,65.98,65,64,64,62.98,62.98,62.98,62,62,60.98,60.57,59.62,58.62,57.73,56.85,55.87,55,54.75,54.87,54.73,51.34,47.25,43.62,43.62,42.71,41.85,40.98,40.98,40.98,40.98,42,45,49,49,49,49,50,50,50,47,44,40.98,37.98,37.98,37.98,37.98,37.98,37.93,37.96,38.13,38.38,39.42,42.58,43.35,45.82,48.14,50.98,54,53.99,52.90,51.02,50.10,49.12,48.87,47.86,46.08,44.89,43,42.97,42.09,41.52,40.50,39.63,38.85,38,36.98,35.73,34.37,33.37,32.40,31.50,30.52,29.62,28.75,27.96,27.25,26.62,26.01,25.60,24.72,23.25,21.72,20.45,19.75,19.12,18.76,18.12,18.09,18,17.98,17.98,17.98,15.98,15.99,15.99,15.35,15.12,15,15,15,15,15,15,15,15,15,15,15,15,15,14.99,14.99,14.96,14.88,14.75,14.54,14.34,14.15,14.07,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14.03,14.14,14.25,14.29,14.72,14.75,14.78,14.86,14.97,15,15,15,15,15.33,15.85,16.25,16.72,16.85,17.12,17.49,17.76,17.88,17.97,17.99,17.98,19,19,19.10,19.27,19.50,19.75,19.97,20.13,20.36,20.57,20.77,21.12,21.50,22.10,22.84,23.75,24.87,26.25,27.87,29.50,30.95,32.11,32.99,34,35,14,14,14,12.98,12,12,12,10.98,10,9,9,8.75,8.51,8.13,7.84,7.57,7.37,7.33,7.25,7.25,7.14,7.11,7.01,7,7,7,7,7,7.12,7.37,7.63,8,8.39,8.87,9.35,9.72,10,10.33,10.62,10.98,10.98,10.98,12,12,12,12.97,12.99,13.98,14.01,14.96,14.90,15,15.12,15.84,16.12,17.83,17.83,18.12,19.02,20.11,21.90,21.98,22.96,24,25,25.98,25.98,27,27.98,28.60,29.34,30.11,31,32.12,33.37,34.62,35.61,36.50,37.37,38.37,39.22,40.01,40.87,41.83,42.75,43.63,44.35,44.82,45.02,45.14,45.33,45.86,46.62,47.63,48.82,50.07,51.34,52.70,54.23,55.96,57.38,58.50,59.36,60.42,61.75,62.89,63.75,64.41,65.02,65.77,66.25,66.63,66.77,66.86,66.85,66.75,67,67,67,67,65.98,65.98,65,65,64,62.98,62.98,62.98,62,62,61,61,60.84,59.13,58.10,56.96,55.89,54.75,53.61,52.34,51.37,50.62,50.75,47.25,45.09,41.75,41.75,40.76,40,39,39,39,39,40,40.98,44,44,44,45,47,47,47,44,40.98,39,37,37,37,37,37,36.84,36.74,36.71,37.11,38.28,40.61,40.97,42.72,44.84,47.98,52,52,52.98,52,50.98,49,49,47.98,47,45.98,44,44,42.98,42.11,41.12,40.24,40,39.35,38.34,37,35.26,34.14,33.08,32,31,30.02,29.22,28.50,27.86,27.25,26.71,26.21,25.25,23.87,22.49,20.85,20.49,20.10,19.24,19.22,19.13,19.11,19,19,19,17.99,17.96,17.14,16.47,15.87,15.71,15.63,15.59,15.45,15.25,15.12,15,15.01,15,15,15,15,15,14.99,14.99,14.96,14.86,14.67,14.46,14.24,14.10,14.01,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14.01,14.04,14.14,14.25,14.25,14.21,14.83,14.87,14.96,15,15,14.87,15.12,15.37,15.75,16.12,16.48,16.86,17.26,17.63,17.87,17.97,18,18.26,19,19,19.01,19.15,19.37,19.62,19.83,20,20.20,20.37,20.62,20.90,21.35,21.87,22.58,23.45,24.50,25.86,27.46,29.21,30.62,31,32,32.98,35,15,15,14,14,14,12.98,12.98,12,10.98,10.98,10,10,9.01,8.58,8.13,7.87,7.71,7.62,7.58,7.48,7.36,7.23,7.12,7,7,7,7,7,7.12,7.37,7.62,8,8.37,8.87,9.46,9.76,10,10.33,10.62,10.98,10.98,10.98,12,12,12.97,12.92,13.04,13.90,14.10,14.88,14.90,15,15.13,15.84,16.11,16.89,17.09,18.07,19,20.04,20.96,20.98,22,22.98,24,25,25,25.98,25.98,27.50,28.33,29.23,30.14,31.47,32.77,34,34.87,35.51,36.47,37.72,38.65,39.59,40.39,41.32,42.15,42.87,43.37,43.62,43.87,44.25,44.87,45.60,46.49,47.60,48.73,49.84,51.03,52.33,53.75,55.32,56.66,57.82,58.75,59.78,60.89,61.84,62.50,63.07,63.52,64.32,64.89,65.41,65.49,65.49,65.39,65.03,65,64,64,65,64,64,64,64,62.98,62,62,62,61.21,61.36,59.73,59.73,58.72,57.72,56.36,55.13,53.95,52.65,51.26,49.64,46.85,46.74,44.75,43,41.12,38.59,38.59,37.75,37.12,37,37,37,35.98,35.98,35.98,35.98,35.98,37,37,37.98,39,39,37.98,37,35.98,35,35,35,35,35,35.08,35.18,35.26,35.30,36.29,37.30,37.26,38.16,40.08,42,47,47,47.98,50,50.98,50.98,50.98,50,49,47,45,45,44,43.01,42.83,41.77,41.73,40.63,40.23,38.75,36.65,35.12,33.86,32.70,31.62,30.63,29.84,29.12,28.50,27.87,27.25,26.49,25.59,24.39,23.20,22.12,21.36,20.98,20.70,20.74,20.75,20.83,20.87,20.98,20.98,19.99,19.75,18.46,17.59,16.88,16.59,16.49,16.26,16,15.62,15.38,15.21,15.12,15.10,15.01,15,15,15,14.99,14.99,14.95,14.84,14.62,14.38,14.16,14.03,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14.01,14.02,14.04,14.13,14.15,14.11,14.03,14,14.21,14.62,14.82,15,15.24,15.61,16,16.50,17.10,17.59,17.87,17.97,18,18.25,18.75,19,18.90,19.09,19.26,19.49,19.64,19.86,20,20.23,20.47,20.75,21.14,21.70,22.35,23.12,24.12,25.35,26.98,28.95,31.37,32,32.98,32.98,34,15.49,15.49,14.50,14.50,14,12.98,12.98,12,11.49,10.98,10,10,9.50,8.98,8.47,8.12,7.95,7.89,7.85,7.71,7.51,7.37,7.20,7.08,7,7,7,7,7.12,7.35,7.62,7.98,8.35,8.76,9.50,9.83,10,10.33,10.62,10.98,10.98,10.98,11.99,12.03,12.89,12.98,13.11,13.86,14.14,14.48,14.84,15,15.13,15.85,16.08,16.91,17.03,17.99,19,20,20.98,20.98,22,22.98,24,25,25,25.49,25.98,26.75,27.50,28.57,29.60,31.09,32.50,33.73,34.59,35.27,36.12,37.40,38.60,39.34,40.12,40.87,41.60,42.09,42.37,42.58,42.64,43.62,44.46,45.26,46.24,47.25,48.38,49.42,50.59,51.83,53.16,54.57,55.87,57.03,58.09,59.08,60,60.78,61.36,61.87,62.32,63.15,63.87,64.48,64.54,64.54,64.51,64.50,64.50,63.49,63.49,63.99,63.49,63.49,63.49,63.49,62.49,61.49,61.49,61.49,61.10,60.75,59.01,59.01,57.73,56.22,54.73,53.37,52,50.64,49.14,47.40,45.75,44.50,43.25,41.76,40.26,37.95,37.95,37.13,36.57,36.49,36.49,36.49,35.49,35.49,35.49,35.49,35.49,36,36,36.49,37,37,36.49,36,35.49,34.50,34.50,34.50,34.50,34.50,34.50,34.53,34.66,35.07,35.71,36.28,36.65,37.57,38.99,40.50,44.99,44.99,46.49,48.50,49.48,50.98,50.98,50.49,49,47.49,45.49,45.49,44.50,43.50,43.36,42.65,42.25,41.75,40.90,39.40,37.75,36.12,34.75,33.50,32.39,31.45,30.61,29.87,29.22,28.50,27.75,26.88,25.96,24.87,23.85,22.95,22.22,21.82,21.63,21.74,21.75,21.88,21.96,21.98,21.48,20.50,20.12,19.45,18.61,17.98,17.62,17.37,17.11,16.73,16.25,15.87,15.51,15.37,15.20,15.12,15.07,15,15,14.99,14.99,14.95,14.84,14.61,14.35,14.12,14.01,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14.01,14.01,14.01,14,14,14.12,14.33,14.50,14.62,14.87,15.14,15.60,16.25,16.96,17.50,17.87,17.97,18,18.12,18.34,18.49,18.74,18.96,19.13,19.37,19.50,19.71,19.87,20.09,20.33,20.62,21,21.50,22.12,22.87,23.74,24.87,26.37,28.65,31.40,32,32.98,32.98,34,15.98,15.98,15,15,14,12.98,12.98,12,12,10.98,10,10,10,9,9,7.98,7.98,7.98,7.96,7.87,7.75,7.61,7.37,7.14,7.01,7,7,7,7.12,7.34,7.62,7.89,8.25,8.62,9.12,9.50,9.75,10.10,10.62,10.98,10.98,10.99,11.95,12.09,12.85,12.98,13.14,13.79,13.92,14.21,14.78,14.99,15.20,15.79,16.12,16.87,17.09,18,18.99,20,20.98,20.98,22,22.98,24,25,25,25,25.98,25.98,27.61,28.37,29.36,30.75,32.38,33.75,34.50,35.12,36.01,37.35,38.87,39.25,39.86,40.51,41,41.15,41.37,41.71,42.35,43.20,44.09,44.89,45.75,46.75,47.82,48.87,49.99,51.21,52.53,53.91,55.25,56.40,57.41,58.29,59.11,59.82,60.42,61.01,61.63,62.50,63.24,63.87,64.04,64.07,64,64,64,62.98,62.98,62.98,62.98,62.98,62.98,62.98,62,60.98,60.98,60.98,61,60.21,58.37,58.37,56.63,54.87,53.23,51.74,50.25,48.82,47.26,45.73,44.27,43,41.83,40.71,39.50,37.26,37.26,36.61,36,35.98,35.98,35.98,35,35,35,35,35,35,35,35,35,35,35,35,35,34,34,34,34,34,34,34,34,35,35,35.98,35.98,37,37.98,39,42.98,42.98,45,47,47.98,50.98,50.98,50.98,49,47.98,45.98,45.98,45,44,43.88,43.12,43.01,42.59,41.72,40.24,38.62,37.08,35.70,34.47,33.35,32.36,31.49,30.73,30,29.24,28.37,27.40,26.33,25.35,24.32,23.37,22.75,22.33,22.63,22.25,22.75,22.88,22.96,22.98,21.99,21,20.45,19.96,19.37,18.84,18.37,18.08,17.75,17.37,16.96,16.50,16.12,15.76,15.50,15.25,15.21,15.10,15.01,14.99,14.99,14.96,14.85,14.63,14.36,14.13,14.01,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14.07,14.12,14.24,14.36,14.58,14.87,15.37,16.08,16.86,17.50,17.86,17.97,17.99,18,18.10,17.98,18.51,18.75,19,19.15,19.37,19.51,19.73,19.90,20.15,20.49,20.87,21.37,21.95,22.61,23.37,24.26,25.75,28.27,31.51,32,32.98,32.98,34,15.98,15.98,15.98,15,15,12.98,12.98,12,12,12,10.98,10.98,10,10,9,7.98,7.98,7.98,7.97,7.96,7.87,7.75,7.61,7.37,7.21,7.11,7.11,7.10,7.12,7.37,7.62,7.87,8.12,8.32,8.75,9.11,9.37,9.87,10,10.98,10.98,11.02,11.89,12.12,12.79,12.99,13.12,13.21,13.76,14.25,14.75,14.99,15.23,15.75,16.16,16.83,17.12,18,18.99,20,20.98,20.98,22,22.98,24,25,25,25,25,25.98,27.98,28,28.90,30.27,32,33.21,34.11,34.72,35.75,37.07,38.87,38.87,39.50,40,40.12,40.07,40.25,40.77,41.73,42.84,43.64,44.35,45.21,46.12,47.12,48.14,49.25,50.50,51.86,53.27,54.64,55.77,56.67,57.39,58.09,58.74,59.42,60.13,60.87,61.76,62.48,63.14,63.74,64,62.98,62.98,62.98,62,62,62,62,62,62,62,60.98,60,60,60,60,59,57.12,57.12,55.47,53.58,51.82,50.13,48.59,47.08,45.52,44.08,42.70,41.45,40.27,39.21,38,36.25,36.25,35.71,35,35,35,35,35,35,35,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,35,35,35,35.98,37,37,40,40,42,42.98,44,49,49,50,50,49,47,47,45.98,45,44.96,44.11,44.13,43.62,42.59,41.12,39.52,38,36.72,35.50,34.37,33.36,32.46,31.62,30.86,30.01,29.12,28.10,26.97,25.95,24.75,23.95,23.48,23.33,23.63,23.72,23.75,23.76,23.87,24,22.96,21,21,20.60,20.12,19.62,19.14,18.70,18.50,18.22,17.84,17.37,16.95,16.50,16.10,15.75,15.50,15.10,15.01,15.02,15.03,15.03,15,14.78,14.49,14.22,14.07,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14.08,14.12,14.26,14.60,15.12,15.87,16.75,17.39,17.86,17.97,17.97,17.98,17.99,17.98,18.25,18.57,18.77,19,19.20,19.37,19.58,19.75,20,20.33,20.73,21.23,21.75,22.33,22.96,23.76,25.22,27.64,30.65,30.98,32,32.98,34,17,17,15.98,15.98,15,12.98,12.98,12.98,12,12,10.98,10.98,10.98,10,10,9,9,7.98,7.98,8,8,7.87,7.75,7.62,7.46,7.36,7.33,7.33,7.37,7.50,7.74,7.88,7.98,7.98,7.98,9,9,10,10,10.98,10.98,11.07,11.87,12.10,12.76,13.09,13.23,13.24,13.76,14.27,14.72,14.99,15.25,15.73,16.21,16.78,17.16,18,18.90,19.97,20.98,20.98,22,22.98,22.98,24,24,24,25,25.98,27,27,28,29.96,30.88,32.87,32.87,33.90,34.96,36.98,37.88,37.95,38.51,39,38.86,38.62,38.76,39.71,40.86,41.89,42.85,43.70,44.52,45.46,46.37,47.38,48.47,49.63,51.10,52.53,53.92,55,55.76,56.33,56.88,57.51,58.25,59.01,59.87,60.72,61.53,62,62.88,62.89,62.89,62.01,61.98,62,60.98,60.98,60.98,60.98,60.98,60.98,60.98,60,60,60,59,58.48,56.12,55.87,54.12,52.39,50.63,48.97,47.34,45.75,44.23,42.73,41.25,39.77,38.59,37.71,36.73,35.48,35.48,35.14,35,35,35,35,35,35,35,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,35,35,35,35.98,35.98,37.98,37.98,39,40,42,45.98,45.98,49,50,50,47.98,47.98,47,47,45.98,46,45.87,44.98,43.76,42.13,40.57,39.11,37.77,36.60,35.45,34.37,33.45,32.61,31.76,30.95,30,29,27.87,26.75,25.51,24.75,24.39,24.33,24.26,24.25,24.24,24.20,24.11,24,23,22,22,21.62,21.12,20.59,20.07,19.62,19.38,19.22,18.87,18.50,18,17.49,17,16.50,16.20,15.87,15.08,15.37,15.59,15.47,15.27,15.07,14.75,14.39,14.20,14.09,14.04,14.03,14.03,14.03,14.03,14.02,14,14,14,14,14,14,14.01,14.01,14.02,14.02,14.03,14.03,14.02,14.02,14.01,14,14,14,14,14,14,14,14,14,14,14,14,14.11,14.34,14.87,15.62,16.50,17.34,17.86,17.97,17.97,17.97,17.97,17.98,18.02,18.35,18.60,18.84,19.01,19.22,19.37,19.62,19.87,20.23,20.62,21.09,21.58,22.09,22.63,23.37,24.60,26.45,30.87,30.98,30.98,32,34,17,17,15.98,15.98,15,14,14,12.98,12.98,12,12,12,10.98,10.98,10.98,10,10,9,9,9,8,7.96,7.88,7.83,7.73,7.63,7.62,7.62,7.64,7.75,7.86,7.98,7.98,7.98,7.98,9,9,10,10,10.97,10.91,11.10,11.14,11.84,12.23,13.74,13.72,13.71,13.87,14.29,14.70,14.99,15.26,15.70,16.24,16.76,17.21,17.92,18.87,19.07,20.97,20.98,22,22,22.98,24,24,24,25,25,26.65,27,27.64,28.57,29.85,30.98,31.58,32.32,32.98,34,36,36.12,37.46,37.87,37.62,37.15,37.37,38.50,39.83,41.07,42.08,42.98,43.87,44.75,45.65,46.62,47.71,48.87,50.25,51.71,53.03,54.03,54.67,55.12,55.62,56.26,57.04,57.87,58.67,59.63,60.15,60.12,61.12,61.12,61.11,61.10,61.08,60.88,60,60,60,60,60,60,60,59,59,59,57.98,57.25,54.51,54.23,53.01,51.25,49.49,47.74,46.02,44.45,42.89,41.45,39.95,38.35,37.01,35.45,35,35,35,35,35,35,35,35,35,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,35,35,35,35.98,35.98,37,37.98,40,45,45,47,49,50.98,50,50,50,49,49,47.98,47.90,46.20,44.86,43.14,41.59,40.14,38.87,37.64,36.50,35.37,34.40,33.57,32.75,31.97,31,30,28.97,27.64,26.39,25.72,25.49,25.62,25.63,25.72,25.75,25.76,25.87,25,24.98,23.97,23.33,22.75,22.12,21.51,20.99,20.59,20.39,20.32,20,19.62,19.01,18.50,17.87,17.37,17,16.76,16.86,16.71,16.42,15.92,15.70,15.45,15.12,14.76,14.45,14.26,14.21,14.20,14.20,14.20,14.17,14.12,14.07,14.01,14,14,14,14.03,14.09,14.13,14.20,14.21,14.21,14.21,14.21,14.20,14.13,14.07,14,14,14,14,14,14,14,14,14,14,14,14,14.22,14.62,15.46,16.33,17.12,17.70,17.88,17.97,17.97,17.97,17.97,17.98,18.12,18.39,18.71,18.90,19.10,19.25,19.48,19.75,20.12,20.49,20.90,21.37,21.87,22.37,23.07,24.11,25.23,27.98,27.98,29,30.98,34,17,17,15.98,15.98,15.49,14,14,13.49,12.98,12.49,12,12,11.49,10.98,10.98,10,10,9.50,9.50,9,7.98,7.98,7.96,7.95,7.89,7.89,7.89,7.95,7.96,7.97,7.98,7.98,7.98,7.98,7.98,9,9,9.50,10,10.48,10.87,10.99,11.15,11.51,12.25,13.21,13.61,13.77,13.98,14.29,14.66,14.99,15.17,15.52,16.14,16.74,17.23,17.83,18.48,19.10,20.95,20.98,22,22,22.98,23.49,23.49,24,24.50,25.26,25.99,26.65,27.25,27.96,29.13,30.22,31.02,31.73,32.50,33.49,35.95,36.02,36.74,36.97,36.63,36.12,36.37,37.50,39,40.35,41.37,42.26,43.13,44,44.90,45.87,46.87,48,49.37,50.85,52.22,53.12,53.62,53.75,54.27,54.99,55.88,56.63,57.73,58.83,58.99,59.15,60.26,60.62,60.75,60.62,60.48,60.36,59.59,59.50,59.50,59.50,59.50,59.50,59.50,59,59,58.49,57.98,57.01,54.24,53.63,52.09,50.21,48.26,46.46,44.75,43.12,41.62,40.23,38.75,37.23,35.90,35.22,35,35,35,35,35,35,35,35,34.50,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34.50,35,35,35.98,35.98,36.49,37.49,40,45.49,45.49,47,48.49,50.49,51,51,50.49,49.99,49.50,47.98,47.98,47.09,45.83,44.01,42.50,41.12,39.87,38.70,37.48,36.36,35.37,34.50,33.75,32.89,32,31,30,28.57,27.25,26.57,26.45,26.48,26.39,26.25,26.09,25.83,25.46,25,25.99,24.50,24.12,23.74,23.08,22.47,21.89,21.57,21.37,21.25,21,20.62,20,19.37,18.75,18.21,17.76,17.50,17.49,17.33,16.87,16.45,16.11,15.85,15.54,15.20,14.85,14.60,14.51,14.50,14.50,14.50,14.45,14.36,14.23,14.04,14.03,14.04,14.04,14.07,14.21,14.35,14.50,14.50,14.50,14.50,14.50,14.50,14.35,14.15,14.01,14,14,14,14,14,14,14,14,14,14,14,14.11,14.61,15.26,16.22,17.08,17.62,17.87,17.97,17.99,17.99,17.98,17.97,17.98,18.25,18.62,18.87,19,19.13,19.37,19.70,20,20.37,20.82,21.25,21.73,22.14,22.75,23.70,25,27.98,27.98,28.49,30.49,33.49,17,17,15.98,15.98,15.98,14,14,14,12.98,12.98,12,12,12,10.98,10.98,10,10,10,10,9,7.98,7.98,7.98,7.98,7.98,7.98,7.98,7.98,7.98,7.98,7.98,7.98,7.98,7.98,7.98,9,9,9,10,10.07,10.86,10.96,11.03,11.22,12.09,12.75,13.27,13.65,13.87,14.29,14.65,14.98,15.09,15.32,16.04,16.73,17.24,17.75,18.13,19.12,20.90,20.98,22,22,22.98,22.98,22.98,24,24.27,25.08,25.75,26.37,26.97,27.75,28.74,29.82,30.64,31.37,32.25,33.38,35.82,35.87,36.73,36.49,35.74,35.50,36,37.12,38.60,39.76,40.75,41.60,42.38,43.25,44.12,45,45.99,47.09,48.37,49.77,51.10,51.98,52.50,52.88,53.46,54.21,54.98,55.75,56.62,57.75,57.87,58.23,59.75,59.90,60.74,59.98,59.77,59.83,59.12,59.10,59.01,59,59,59,59,59,59,57.98,57.98,56.86,53.87,53.25,51.25,49.12,47,45.11,43.37,41.77,40.38,39.10,37.75,36.45,35.50,35,35,35,35,35,35,35,35,35,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,35,35,35.98,35.98,35.98,37,40,45.98,45.98,47,47.98,50,52,52,50.98,50.98,50,47.98,47.98,47.47,46.34,44.83,43.25,41.97,40.75,39.62,38.35,37.14,36.22,35.37,34.62,33.85,32.88,31.87,30.76,29.25,28,27.34,27.25,27.20,27.12,26.75,26.12,25.87,25,25,26.99,25,24.86,24.50,23.96,23.37,22.82,22.38,22.33,22.12,21.86,21.38,20.87,20.23,19.51,18.96,18.50,18.21,18.12,17.91,17.37,16.87,16.51,16.37,16.08,15.72,15.34,15.10,14.99,14.96,14.92,14.90,14.83,14.67,14.50,14.37,14.34,14.34,14.36,14.37,14.20,14.84,14.82,14.82,14.79,14.79,14.83,14.83,14.85,14.12,14.10,14,14,14,14,14,14,14,14,14,14,14,14.13,14.50,15.25,16.11,16.96,17.50,17.86,18,18.09,18.11,18.08,18,18,17.98,18.75,18.90,19,19.12,19.35,19.63,20,20.35,20.75,21.23,21.64,22,22.23,22.98,25,27.98,27.98,27.98,30,32.98,17,17,17,15.98,15.98,14,14,14,14,12.98,12,12,12,10.98,10.98,10,10,10,10,10,9,9,7.98,7.98,7.98,7.98,7.98,7.98,7.98,7.98,7.98,7.98,7.98,7.98,7.98,9,9,9,9,9.91,10.85,10.78,10.87,11.22,11.75,12.66,12.87,13.29,13.77,14.28,14.65,14.97,15.02,15.34,16,16.71,17.25,17.75,18.15,19.12,20.89,20.98,20.98,22,22,22.98,22.98,22.98,24.07,24.83,25.48,26.10,26.75,27.50,28.38,29.38,30.25,30.96,31.83,33.12,34.75,35.09,35.62,34.83,34.57,35,35.87,37.21,38.38,39.37,40.20,40.87,41.60,42.37,43.22,44.09,45,46,47.24,48.51,49.73,50.58,51.14,51.74,52.46,53.25,54.09,54.64,55.34,56.02,56.73,57.25,58.71,58.87,59.01,59,58.88,58.77,58.82,58.86,58.88,58.99,59,59,59,57.98,57.98,57.98,57.98,56.45,52.88,52.34,50.47,47.99,45.62,43.58,41.87,40.39,39.20,38.02,36.89,35.82,35.23,35,35,35,35,35,35,35,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,35,35,35,35.98,37,39,45.98,45.98,47.98,47.98,49,50.98,50.98,52,52,52,49,49,48.12,47,45.51,44.11,42.71,41.62,40.50,39.23,38.10,37.12,36.36,35.58,34.73,33.75,32.73,31.50,30.10,28.83,28.26,28.08,28.07,28,27.76,26.09,26,25.98,25.98,27,25.99,25.76,25.48,25.01,24.48,23.98,23.50,23.36,23.12,22.86,22.37,21.82,21.13,20.50,19.89,19.50,19.23,19.11,18.75,18.24,17.70,17.34,17.09,16.76,16.38,16,15.73,15.61,15.58,15.52,15.46,15.32,15.12,14.88,14.73,14.71,14.70,14.67,14.76,14.89,14.87,14.97,14.98,14.98,14.98,14.98,14.97,14.89,14.91,14.03,14,14,14,14,14,14,14,14,14,14,14,14.12,14.50,15.14,15.98,16.75,17.39,17.87,18.12,18.25,18.33,18.33,18.25,18.23,18.21,19,18.99,19,19.08,19.34,19.63,19.99,20.33,20.72,21.25,21.71,21.98,22,22.98,24,27,27,27,29,32,17.98,17.98,17,15.98,15.98,15,15,15,14,14,12,12,12,10.98,10.98,10,10,10,10,9.99,9.37,9.22,8.87,8.50,8.20,8.09,7.98,7.98,7.98,7.98,7.98,7.98,7.98,7.98,7.98,9,9,9,9,9.09,9.99,10.20,10.75,10.98,11.27,11.99,12.34,13.10,13.66,14.28,14.65,14.97,15.02,15.34,15.99,16.70,17.21,17.75,18.10,18.99,19.90,20,20.98,20.98,22,22.98,22.98,23,23.75,24.49,25.13,25.76,26.46,27.21,28,28.86,29.62,30.37,31.14,32.01,33.65,33.62,33.62,33.37,32.37,35.57,36.15,37.25,38,38.82,39.50,40.09,40.70,41.37,42.15,43.01,43.89,44.87,46,47.12,48.21,49,49.71,50.48,51.35,52.20,52.95,53.46,53.84,54.26,55.64,56.09,56.70,57.62,57.63,57.64,57.75,57.85,57.97,58,58,58,57.98,59,57.98,57.98,57.98,57.98,57.98,55.85,52.65,52.23,49.38,46.64,43.70,41.76,40.25,39,38,37.10,36.21,35.37,35,35,35,35,35,35,35,35,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,35,35,35,35.98,37.98,44,44,47,49,49,50,50,52,52.98,52.98,50,50,49.24,48.12,46.62,45.10,43.85,42.62,41.38,40.13,39.07,38.12,37.34,36.50,35.59,34.60,33.58,32.51,30.73,30.26,29.20,29.20,29.13,29.08,28.86,28.08,27.87,27.12,27.12,27.12,27.12,27.10,26.99,26.71,26.14,25.60,25,24.75,24.49,24.08,23.51,22.87,22.23,21.57,20.98,20.50,20.37,20.27,20,19.38,18.85,18.38,18.03,17.65,17.25,16.85,16.58,16.45,16.36,16.25,16.12,15.90,15.66,15.45,15.29,15.27,15.29,15.20,15,15.03,15.04,15.08,15.09,15.09,15.09,15.08,14.99,14.99,14.99,15,14,14,14,14,14,14,14,14,14,14,14,14.12,14.46,15,15.76,16.62,17.35,17.87,18.25,18.50,18.62,18.62,18.62,18.51,18.37,18.98,19,19,19,19,20,20,20,20.98,20.98,22,22,22,22.98,24,25.98,25.98,27,27.98,30.98,19,19,17.98,17,17,15.98,15.98,15.98,15,14,12.98,12.98,12,12,11.01,10.90,10.88,10.87,10.51,10.26,10,9.66,9.33,8.92,8.50,8.22,8,8.01,7.99,7.98,7.98,7.98,7.98,7.98,8.32,8.64,9,9,9.01,9.09,9.85,10.11,10.24,10.76,11.27,11.70,12.35,13,13.65,14.28,14.65,14.97,15.02,15.35,15.99,16.70,17.10,17.24,17.87,18.12,19.90,20,20,20.98,20.98,22,22,22.87,23.47,24.12,24.77,25.45,26.12,26.84,27.59,28.33,29,29.71,30.35,30.88,30.36,30.37,30.37,32.37,33.84,35.60,36.14,36.73,37.48,38.12,38.75,39.25,39.75,40.37,41.12,42,42.87,43.83,44.86,45.87,46.82,47.60,48.35,49.25,50.25,51.10,51.83,52.22,52.48,52.32,54,54.35,55.35,55.35,56.27,56.32,56.26,56.98,57.13,57.21,57.12,57.10,57.96,57.98,57.98,57.98,57.98,57,57,55.62,49.60,49.37,45,42.87,41.40,39.70,38.50,37.62,36.87,36.13,35.60,35.07,35,35,35,35,35,35,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,35,35,35.98,39,39,42,47,49,49,49,50,50.98,52,52,52,50.98,49.62,47.50,46.01,44.75,43.62,42.37,41.11,39.97,39.07,38.26,37.39,36.37,35.37,34.39,33.57,32.62,32.87,31,30.87,30.87,29.99,29.84,29.12,28.95,29.76,29.76,29.76,28.83,28.84,28.87,28.49,28.22,27.11,26.50,26.12,25.73,25.22,24.60,23.95,23.25,22.60,22,21.62,21.50,21.37,21.24,20.83,20.01,19.50,19.09,18.67,18.25,17.87,17.58,17.38,17.25,17.10,16.88,16.62,16.34,16.02,15.79,15.67,15.77,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15,15,15,15,15,15,15,15,15,14,14,14,14,14,14,14,14.10,14.35,14.87,15.62,16.47,17.25,17.89,18.38,18.72,18.85,18.87,18.87,18.76,18.85,18.97,19,19,19,19,20,20,20,20,20.98,20.98,20.98,22,22.98,24,25,25,25.98,27.98,29,19,19,18.49,17.49,17.49,16.49,16.49,15.98,15,14,12.98,12.98,12.48,11.92,11.09,11.02,11.07,11.07,10.98,10.77,10.52,10.20,9.82,9.37,8.95,8.51,8.28,8.12,8.02,8,7.98,7.98,7.98,7.98,8.32,8.64,9,9,9.01,9.25,9.86,10,10.24,10.71,11.27,11.67,12.33,12.99,13.65,14.28,14.65,14.97,15.01,15.35,16,16.70,17,17.24,17.77,18.12,19.40,19.50,20,20.49,20.98,22,22.02,22.50,23.10,23.74,24.37,25.01,25.71,26.37,27.09,27.75,28.37,28.99,29.57,29.88,30.09,30.25,30.88,32.33,33.84,35.11,35.72,36.13,36.75,37.37,38,38.46,38.86,39.40,40.14,41,41.88,42.86,43.87,44.87,45.75,46.51,47.34,48.25,49.12,49.99,50.71,51,51.32,51.82,53.62,54.11,54.37,54.85,55.34,55.75,56.10,56.26,56.47,56.63,56.85,57.12,57.46,57.49,57.49,57.49,57.49,57,56.49,54.39,47,47,43.13,40.87,39.13,36.85,36.87,36.33,35.71,35.32,35.09,35,35,35,35,35,35,34.50,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34.50,35,35.49,38,38,41,45.46,48.42,48.90,49.10,49.90,50.55,51.45,52,52,50.98,50,48.12,46.62,45.37,44.51,43.21,41.75,40.59,39.73,39.09,38.25,37.12,35.49,35.49,34.50,33.49,32.98,31.49,31.49,31.39,30.61,30.01,29.72,29.74,30.25,30.74,30.12,29.71,29.50,29.49,29.37,29.08,28.26,27.75,27.33,26.87,26.33,25.63,25,24.26,23.61,23,22.62,22.59,22.48,22.27,21.70,21.08,20.57,20.16,19.76,19.34,18.90,18.60,18.37,18.17,17.97,17.71,17.40,17.09,16.73,16.36,16.11,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.49,15.49,15,15,15,15,15,15,15,14.50,14,14,14,14,14,14,14.08,14.22,14.63,15.48,16.33,17.12,17.88,18.50,18.84,18.97,18.99,18.98,18.97,18.97,18.98,19,19,19,19,19.50,19.50,20,20,20.49,20.98,20.98,22,22.98,24,25,25,25.98,27.98,29,19,19,19,17.98,17.98,17,17,15.98,15,14,12.98,12.92,12.88,12.03,11.14,11.16,11.37,11.52,11.52,11.40,11.15,10.78,10.35,9.86,9.37,8.96,8.60,8.32,8.14,8.04,8,7.98,7.98,7.98,8.32,8.64,9,9,9.01,9.32,9.63,10,10.23,10.72,11.26,11.67,12.33,12.99,13.65,14.28,14.65,14.97,15.01,15.33,16,16.71,16.99,17.23,17.78,18.11,18.90,19,20,20,20.98,22,21.89,22.12,22.71,23.26,23.88,24.52,25.21,25.86,26.50,27.12,27.70,28.25,28.82,29.33,29.76,30.25,31.09,32.52,33.62,34.62,35.09,35.48,35.98,36.50,37,37.48,37.86,38.40,39.13,40.01,40.88,41.84,42.84,43.85,44.84,45.62,46.46,47.25,48.08,48.75,49.25,49.63,50.27,51.37,53.01,53.23,53.58,54,54.62,55.35,55.51,55.63,55.65,55.98,56.77,56.87,56.96,57,57,57,57,57,55.98,53.23,44.50,44.50,41.73,39.72,38.07,35.97,35.97,35.46,35,35,35,35,35,35,35,35,35,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,35,35,37,37,40.04,43.91,47.85,48.86,49.15,49.86,50.13,50.89,51.96,52,50.98,50,49,46.22,45.85,44.88,43.61,42.23,40.73,40.22,39.73,39,37.98,35.98,35.98,35,34,32.98,32,32,31.87,31.12,30.22,30.25,30.25,30.95,31.70,30.25,30.25,30.21,30.12,30,29.62,29.25,28.86,28.48,28,27.46,26.76,26.12,25.50,24.82,24.22,23.83,23.75,23.62,23.25,22.70,22,21.50,21.27,20.96,20.49,20,19.65,19.40,19.14,18.86,18.54,18.24,17.88,17.48,16.96,16,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15,15,15,15,15,15,15,15,14,14,14,14,14,14.33,14.35,14.46,14.75,15.37,16.12,17,17.83,18.48,18.86,18.99,19,19,19,19,19,19,19,19,19,19,19,20,20,20,20.98,20.98,22,22.98,24,25,25,25.98,27.98,29,20,20,20,20,20,17.98,17.98,15.98,15.98,15,13.01,13.09,12.83,12.20,11.91,11.99,12.23,12.27,12.40,12.28,11.98,11.52,10.99,10.39,9.85,9.36,8.95,8.62,8.35,8.16,8.04,8,7.98,7.98,8.32,8.64,9,9,9.01,9.32,9.63,10.02,10.22,10.73,11.25,11.70,12.32,12.98,13.64,14.28,14.65,14.96,15.01,15.33,15.99,16.72,16.98,17.22,17.79,18.11,18.92,19,19,20,20,20.98,21.02,21.87,22.22,22.76,23.37,24,24.62,25.23,25.84,26.37,26.96,27.50,28.07,28.65,29.58,29.90,30.71,31.62,32.74,33.63,34.12,34.37,34.77,35.36,35.87,36.25,36.61,37.22,37.99,38.85,39.63,40.49,41.47,42.50,43.61,44.47,45.26,46,46.65,47.10,47.58,48.13,48.98,50.11,51.14,51.96,52.37,52.96,53.59,54.11,54.37,54.50,54.26,55.15,55.75,56.08,56,57,57,57,57,57,54,50,40.98,40.98,39,37,35.98,35,35,35,35,35,35,35,35,35,35,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,35,35.98,35.98,38.04,41.87,45.15,49.83,49.82,49.83,50.08,50.13,50.91,50.98,50.98,50.98,50,47,47,45,44,42.98,40.98,40.98,40,40,39,35.98,35.98,35,35,34,32.98,32.87,32.83,32,31.24,31.25,31.25,31.74,31.63,31.50,31.33,31.25,31.10,30.87,30.62,30.37,30,29.71,29.25,28.71,28.12,27.50,26.98,26.34,25.83,25.46,25.21,24.87,24.49,23.97,23.32,22.87,22.71,22.34,21.75,21.12,20.74,20.52,20.20,19.74,19.37,19.12,18.77,18.37,17.75,17.08,16.99,17,17,17,17,17,17,17,17,15.98,15.98,15.98,15.98,15,15,15,15,15,15,15,15,15,15,15,14.62,14.62,14.72,14.87,15.34,15.98,16.75,17.62,18.37,18.86,19.01,19.09,19.11,19.11,19.07,19,19,19,19,19,19,19,20,20,20,20.98,20.98,22,22.98,24,25.98,25.98,27,27.98,27.98,22,22,22,22.98,22,17.98,17.98,17,15.98,14.98,14.09,13.85,13.11,12.24,12.25,13.03,13.45,13.59,13.60,13.41,13,12.39,11.71,10.99,10.33,9.75,9.29,8.91,8.62,8.35,8.15,8.03,8.10,8.20,8.53,8.76,9,9,9.12,9.40,9.75,10.02,10.34,10.75,11.24,11.77,12.32,12.87,13.66,14.20,14.65,14.95,15.01,15.32,15.87,16.74,16.76,17.10,17.83,17.98,18.02,17.98,19,19,20,20.98,20.87,21.10,21.75,22.25,22.84,23.37,23.98,24.57,25.12,25.64,26.20,26.74,27.25,27.95,28.60,29.13,29.75,30.58,31.27,32.63,32.73,32.75,33.08,33.50,34,34.58,35.08,35.86,36.63,37.49,38.21,38.88,39.85,40.89,42.09,42.99,43.75,44.40,44.98,45.46,45.87,46.47,47.36,48.48,49.49,50.32,50.98,51.50,52.07,52.58,53,53.26,53.63,54.12,54.76,55.12,55.89,55.98,57,57,57,55.98,52,45,38.13,38.17,37.22,36.17,35.15,35.08,35,35,35,35,35,35,35,35,35,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,35,35,36.90,39.02,42.17,47.78,47.78,49.80,49.83,49.86,49.98,50,50,50.98,50.98,47,47,45.98,45,42.98,42,42,40.98,40,39,37,37,35.98,35,35,34,34.08,33.12,33.22,33.25,33.25,33.14,32.97,32.87,32.75,32.70,32.58,32.39,32.25,32.01,31.75,31.46,31.12,30.63,30.12,29.62,29.12,28.61,28.09,27.57,27.11,26.65,26.25,25.84,25.35,24.87,24.52,24.26,24,23.59,23.09,22.62,22.12,21.58,21,20.52,20.21,19.87,19.48,18.90,18.10,18.01,17.99,17,17,17,17,17,17,17,15.98,15.98,15.98,15.98,15.98,15,15,15,15,15,15,15,15,15,15,15,14.95,14.87,15,15.32,15.76,16.50,17.37,18.22,18.84,19.13,19.25,19.33,19.33,19.33,19.01,19,19,19,19,19,19,20,20,20,20.98,20.98,22,22.98,24,25.98,25.98,27,29,27.98,24,24,25,25.98,22.98,19,19,17.98,15.98,15.07,14.12,13.87,13.75,13.16,13.27,14.66,14.83,15,14.99,14.70,14.11,13.32,12.41,11.57,10.78,10.15,9.63,9.23,8.87,8.54,8.27,8.10,8.23,8.41,8.76,8.87,9,9,9.22,9.52,9.88,10.10,10.41,10.92,11.75,11.99,12.28,12.83,13.32,14.09,14.62,14.92,15.02,15.33,15.75,16.15,16.20,16.87,17.12,17.89,17.98,17.98,19,19,20,20,20.08,20.86,21.27,21.77,22.27,22.83,23.36,23.87,24.45,24.97,25.49,26,26.52,27.15,27.82,28.32,28.36,29.24,29.34,30.25,30.22,31.22,31.50,32,32.46,33.08,33.62,34.58,35.40,36.15,36.76,37.37,38.32,39.38,40.58,41.46,42.15,42.88,43.47,43.88,44.37,44.97,45.87,47.01,48.09,48.98,49.63,50.12,50.62,51.12,51.75,52.25,52.82,53.37,53.87,54.12,55.01,55.98,57,57.98,57.98,52.98,47.08,41.16,37.25,37,36.29,35.29,35.12,35,35,35,35,35,35,35,35,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,35.10,36.13,37.18,41.17,41.17,45.20,48.82,49.85,49.10,49,49,49,49,47,47,45.98,45,44,42.98,42.98,42,40.98,40,37.98,37.98,37.98,37.75,37.51,35.96,35.20,34.75,34.62,35.11,34.87,34.73,34.37,34.21,34.09,33.99,33.87,33.75,33.62,33.39,33.12,32.87,32.46,32.11,31.62,31.12,30.65,30.21,29.73,29.14,28.59,28.08,27.61,27.13,26.74,26.37,26.11,25.88,25.75,25.39,24.96,24.45,23.82,23.08,22.35,21.75,21.32,20.90,20.50,20.21,19.84,19.87,19.97,20,19,19,19,17.98,17.98,17,17,17,17,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15,15,15.01,15,15,15.11,15.32,15.75,16.37,17.21,18.08,18.85,19.36,19.59,19.62,19.62,19.62,19.95,20,20,20,20,20,20,20,20,20,20.98,20.98,22,22.98,22.98,25,25,27,27.98,25.98,24.50,24.50,25,25.49,22.98,19.50,19.50,17.98,16.52,15.37,14.16,14,13.86,13.75,13.82,15.64,16.17,16.39,16.35,15.99,15.14,14.12,13.07,12.04,11.17,10.49,9.92,9.49,9.11,8.75,8.42,8.16,8.37,8.64,9,9,9,9,9.33,9.64,10,10.17,10.53,11.12,11.77,12.28,12.61,12.85,13.36,13.99,14.60,14.91,15.03,15.33,15.64,15.95,16.17,16.85,17.11,17.92,17.98,17.98,19,19,19.50,20,20.02,20.47,20.90,21.37,21.85,22.33,22.82,23.32,23.84,24.35,24.85,25.37,25.87,26.52,27.14,27.62,28,28.36,28.75,29.25,29.62,30.01,30.34,30.82,31.14,31.87,32.62,33.63,34.50,35.21,35.75,36.35,37.25,38.33,39.37,40.15,40.88,41.52,42.12,42.61,43.12,43.87,44.88,45.97,47,47.87,48.51,49,49.50,50.07,50.71,51.37,52.09,52.75,53.25,53.61,54.51,55.98,57,57.98,57.98,52.49,46.64,41.23,37.33,36.66,36,35.35,35.01,35,35,35,35,35,35,35,34.50,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34.60,35.52,36.66,40.29,40.68,43.99,47.32,49.36,49.10,49,49,49,49,47,47,45.98,45,44.50,43.49,43.49,42.49,41.49,40,38.49,38.49,38.50,38.38,37.85,37.08,36.25,35.87,35.83,35.87,36,35.87,35.64,35.48,35.35,35.25,35.20,35.12,35,34.82,34.50,34.12,33.75,33.33,32.87,32.37,31.89,31.47,31,30.40,29.86,29.32,28.84,28.37,28,27.74,27.51,27.39,27.33,27,26.51,25.86,25.22,24.37,23.51,22.83,22.25,21.75,21.33,20.72,20.15,20,20,20,19.50,19,19,18.49,17.98,17.49,17,17,17,16.49,16.49,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.49,15.49,15.12,15,15.08,15.10,15.37,15.75,16.25,17,17.87,18.71,19.33,19.64,19.83,19.85,19.87,19.89,19.99,20,20,20,20,20,20,20,20,20.98,20.98,22,22.98,22.98,25,25,26.49,27.49,25.49,25,25,25,25,22.98,20,20,17.98,17.07,15.88,14.20,14.24,14.27,14.33,14.35,16.62,17.50,17.70,17.57,17.07,15.97,14.74,13.50,12.39,11.46,10.72,10.14,9.70,9.32,8.97,8.62,8.40,8.54,8.76,9,9,9,9.11,9.42,9.87,10.23,10.48,10.75,11.25,11.88,12.73,12.85,13.07,13.37,14.08,14.60,14.90,15.03,15.33,15.62,15.92,16.16,16.86,17.07,17.96,17.98,17.98,19,19,19,20,20,20.08,20.61,21,21.46,21.87,22.35,22.82,23.27,23.76,24.25,24.75,25.34,25.98,26.75,27.08,27.71,27.74,28.12,28.85,28.97,29.34,29.75,30.37,30.82,31.48,32.14,33.14,33.97,34.50,34.98,35.60,36.50,37.50,38.46,39.12,39.74,40.32,40.87,41.50,42.13,42.90,43.87,44.89,45.97,46.77,47.37,47.83,48.25,48.87,49.59,50.37,51.14,52.13,52.82,53.07,54,55.98,57,57.98,57.98,52,46.17,41.27,37.37,36.65,35.99,35.35,35.01,35,35,35,35,35,35,35,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34.07,34.97,36.13,39.83,40.18,42.80,45.83,48.87,48.93,49,49,49,49,47,47,45.98,45,45,44,44,42.98,42,40,39,39.20,39.24,39.07,38.61,37.87,37.24,36.86,36.72,36.88,37.01,37.01,36.88,36.75,36.61,36.50,36.49,36.46,36.37,36.14,35.87,35.49,35,34.59,34.08,33.60,33.11,32.62,32.12,31.52,30.98,30.45,29.97,29.57,29.24,29,28.87,28.83,28.63,28.32,27.75,27,26.24,25.38,24.52,23.74,23.07,22.47,21.86,21.15,20.21,20.12,20.09,20,20,19,19,19,17.98,17.98,17,17,17,17,17,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15,15.33,15.36,15.37,15.50,15.83,16.24,16.88,17.73,18.59,19.32,19.75,19.89,19.97,19.97,19.98,19.99,20,20,20,20,20,20,20,20,20.98,20.98,22,22.98,22.98,25,25,25.98,27,25,25,25,25,24,22.98,20.98,20.98,19,17.97,16.85,15.22,14.74,14.85,15.23,16.35,18.61,18.71,18.79,18.63,17.82,16.45,15.08,13.75,12.59,11.61,10.86,10.27,9.85,9.50,9.20,8.89,8.74,8.77,8.87,9.11,9.22,9.33,9.42,9.76,10.22,10.53,10.75,10.88,11.32,11.95,12.72,13.07,13.32,13.70,14.16,14.62,14.90,15.04,15.33,15.65,15.92,16.17,16.83,16.98,17,17.98,17.98,19,19,19,20,20,20,20.37,20.74,21.12,21.50,21.96,22.37,22.84,23.25,23.74,24.21,24.75,25.45,26,26.12,26.83,26.96,27.12,27.88,27.98,28.74,29.10,29.75,30.32,30.98,31.64,32.63,33.37,33.83,34.22,34.87,35.83,36.75,37.59,38.23,38.57,39.08,39.65,40.35,41.07,41.86,42.75,43.75,44.74,45.50,46,46.37,46.82,47.47,48.24,49.12,50.02,51.12,52.40,53,54,55.98,57.98,57,57,50.98,46.20,41.68,37.38,36.67,36.01,35.35,35.01,35,35,35,35,35,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34.04,34.09,35.13,38.86,39.15,41.12,44.13,47.89,48.96,49,49,49,49,47,47,47,45.98,45.98,45,45,44,42,40.98,40.22,40.25,40.20,40,39.59,38.95,38.23,37.97,37.88,38.12,38.25,38.25,38.21,38.11,38,37.87,37.86,37.84,37.75,37.51,37.14,36.73,36.25,35.76,35.26,34.76,34.26,33.75,33.24,32.63,32.09,31.52,31.10,30.73,30.45,30.27,30.25,30.23,30.08,29.65,29.01,28.23,27.33,26.37,25.50,24.62,23.87,23.20,22.50,21.65,21,20.82,20.10,20,20.98,20,20,19,19,17.98,17.98,17.98,17,17,17,17,17,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.64,15.64,15.75,15.87,16.23,16.73,17.50,18.39,19.25,19.75,19.95,20,20,20,20,20,20,20,20,20,20,20,20,20.98,20.98,22,22,22.98,25,25,25,25,25,25,25,24,22.98,22.98,22,22,20,18.96,17.79,15.24,15.27,15.33,16.33,17.38,19.59,19.71,19.51,19.46,17.96,16.57,15.13,13.79,12.62,11.65,10.90,10.36,9.96,9.65,9.42,9.24,9.22,9.25,9.33,9.42,9.54,9.76,9.99,10.32,10.64,10.86,11.08,11.21,11.50,12.04,12.75,13.17,13.67,13.88,14.26,14.62,14.90,15.04,15.29,15.64,15.91,16.12,16.10,16.96,17,17.98,17.98,19,19,19,19,19,20,20.12,20.50,20.85,21.22,21.62,22,22.39,22.82,23.20,23.62,24.12,24.71,25.98,25.98,25.98,25.98,25.98,27,27,27.87,28.37,29.33,29.99,30.51,31.10,31.86,32.50,32.87,33.32,33.99,34.96,35.89,36.62,37.07,37.36,37.72,38.40,39.13,39.87,40.65,41.58,42.47,43.33,43.96,44.36,44.74,45.20,45.90,46.75,47.75,48.90,50.40,51.73,52,54,55.98,57.98,57,57,50.98,46.17,41.27,37.37,37.14,36.26,35.40,35.04,35,35,35,35,35,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34.04,35.07,37.88,38.08,40,42.91,46.96,49,49,49,49,49,47.98,47.98,47,47,45.98,45,45,44,42.98,42,42.07,41.75,41.60,41.25,40.72,40.09,39.71,39.50,39.59,39.62,39.62,39.60,39.50,39.47,39.37,39.36,39.33,39.25,39.12,38.84,38.37,37.97,37.50,37,36.50,36,35.50,34.97,34.37,33.83,33.25,32.74,32.26,31.90,31.70,31.61,31.62,31.70,31.60,31.20,30.45,29.49,28.48,27.47,26.50,25.62,24.87,24.10,23.25,22.39,21.21,21.12,20.87,20.98,20.98,20.98,20.98,20,19,19,17.98,17.98,17.98,17,17,17,17,17,17,17,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.95,15.88,15.97,16.12,16.50,17.25,18.34,19.24,19.82,20.01,20.21,20.25,20.33,20.33,20.33,20.32,20.20,20,20,20,20,20,20.98,20.98,22,22,22.98,24,24,25,24,24,24,24,25,25,24,20.98,20.98,20.98,19.88,18.83,17.74,17.70,17.64,18.62,19.61,20.57,20.28,19.64,18.88,17.73,16.37,15,13.73,12.60,11.64,10.91,10.39,10.03,9.82,9.65,9.58,9.60,9.67,9.76,9.92,10.03,10.33,10.49,10.75,10.91,11.09,11.32,11.49,11.79,12.11,12.78,13.22,13.72,13.99,14.28,14.63,14.90,15.07,15.28,15.67,15.91,16,16.09,16,17,17.98,17.98,19,19,19,19,19,20,20,20.25,20.58,20.89,21.27,21.70,22.02,22.37,22.70,23.02,23.36,24,24,24,24,24,24,25.98,25.98,27,28.10,28.90,29.52,29.99,30.49,31.09,31.75,32.10,32.60,33.21,34.12,35.10,35.71,35.90,36.12,36.49,37.25,38.01,38.75,39.58,40.37,41.20,41.87,42.37,42.73,43.11,43.62,44.40,45.37,46.59,48.12,50.09,51.88,53.08,55,57.98,60,57,57,50.98,45.15,42.64,39.48,38.42,36.58,35.54,35.09,35.01,35,35,35,35,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,35.98,35.98,37.98,40.98,44,50,50,50,50,49,49,49,49,47.98,47,45,45,45,45,44,43.39,43.25,42.95,42.50,41.95,41.35,41,41.08,41.21,41.13,41.07,40.89,40.87,40.83,40.76,40.83,40.76,40.72,40.47,40.01,39.62,39.20,38.75,38.25,37.76,37.26,36.75,36.22,35.62,35.07,34.50,33.98,33.50,33.12,32.89,32.87,32.97,33.11,33.21,32.86,31.87,30.70,29.60,28.59,27.59,26.72,25.87,25.08,24.20,23.23,22.36,21.72,21.34,21.02,20.98,22,22,22,20.98,20,19,19,17.98,17.98,17.98,17,17,17,17,17,17,17,17,17,17,17,17,15.98,15.98,16,15.98,16,16.37,17.12,18.25,19.25,19.87,20.14,20.39,20.60,20.62,20.62,20.62,20.62,20.62,20.98,20.98,20.98,20,20,20.98,20.98,22,22,22,22.98,22.98,22.98,22.98,22.98,24.50,24.50,25,26,24.99,21.49,21.49,20.98,19.98,18.99,18.22,18.16,18.62,19.37,20.10,20.26,20.02,19.29,18.33,17.22,15.99,14.75,13.60,12.53,11.64,10.95,10.42,10.12,9.96,9.89,9.87,9.92,10.12,10.33,10.49,10.49,10.64,10.82,10.98,11.13,11.32,11.64,11.83,12.01,12.08,12.84,13.15,13.76,14,14.26,14.67,14.92,15.04,15.27,15.72,15.96,15.98,15.99,16.10,16.98,17.97,17.98,19,19,19,19,19,20,20,20,20.27,20.62,21,21.47,21.76,22.02,22.20,22.50,22.98,23.49,23.49,23.49,23.49,23.49,24,25.98,25.98,27,27.98,28.83,29.33,29.63,30.12,30.62,31.32,31.62,32.13,32.62,33.49,34.33,34.83,34.83,35.12,35.63,36.33,37.12,37.88,38.63,39.37,40.10,40.62,41.01,41.32,41.75,42.37,43.32,44.39,45.87,47.87,50.25,52.25,53.75,55.49,57.98,60.49,57.49,57.49,50.98,46.16,43.12,39.59,38.24,36.93,35.82,35.28,35.07,35,35,35,35,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,35.98,35.98,37.49,39.99,43,49.50,49.50,50.49,50,49.50,49.50,49.50,49.50,48.49,47,45.49,45.49,45.49,45.49,44.50,44.38,44.37,44,43.62,42.98,42.39,42.25,42.37,42.57,42.50,42.36,42.21,42.12,42.12,42.12,42.20,42.13,42.01,41.71,41.33,40.87,40.45,40,39.50,39.10,38.61,38.09,37.51,36.97,36.37,35.83,35.25,34.74,34.26,34.02,34,34.13,34.34,34.50,33.96,32.96,31.74,30.62,29.61,28.62,27.74,26.87,26.07,25.12,24.14,23.15,22.37,21.76,21.37,21.64,22.49,22.49,22.49,21.49,20.49,19,19,18.49,17.98,17.98,17.49,17.49,17.49,17,17,17,17,17,17,17,17,17,16.49,16.49,15.98,15.98,15.98,16.35,17,18.25,19.25,19.88,20.25,20.59,20.87,20.87,20.88,20.89,20.95,20.96,20.98,20.98,20.98,20.49,20.49,20.98,20.98,21.49,22,22,22.49,22.49,22.98,22.98,22.98,25,25,25,27,25.98,22,22,20.98,20,19.12,18.22,18.25,19.01,19.65,20.59,19.73,19.59,18.57,17.63,16.61,15.54,14.50,13.49,12.53,11.67,11,10.51,10.25,10.12,10.13,10.23,10.32,10.50,10.64,10.82,10.82,10.87,10.91,11.09,11.37,11.64,11.87,11.92,12.01,12.08,12.86,13.12,13.83,14,14.22,14.75,14.99,15,15.25,15.71,15.95,15.99,16,16.12,16.98,17.89,18,19,19,19,19,19,20,20,20,20,20,20.98,20.98,22,22,22,22,22.98,22.98,22.98,22.98,22.98,22.98,24,25.98,25.98,27,27.98,29,29.21,29.38,30.01,30.40,30.98,31.32,31.83,32.32,33.01,33.62,33.90,33.90,34.25,34.88,35.62,36.48,37.24,37.90,38.58,39.13,39.57,39.86,40.12,40.72,41.50,42.62,43.89,45.71,48,50.72,52.84,54.38,55.98,57.98,60.98,57.98,57.98,50.98,47.15,44.08,39.67,38.27,36.98,35.88,35.29,35.08,35.01,35,35,35,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,35.98,35.98,37,39,42,49,49,50.98,50,50,50,50,50,49,47,45.98,45.98,45.98,45.98,45,45.20,45.10,44.87,44.37,43.88,43.46,43.34,43.37,43.60,43.60,43.50,43.37,43.34,43.36,43.37,43.49,43.45,43.25,43,42.62,42.20,41.75,41.33,40.87,40.50,40,39.50,39,38.46,37.87,37.27,36.65,36,35.39,35.08,35.09,35.23,35.37,35.25,34.70,33.73,32.61,31.50,30.50,29.59,28.71,27.84,26.95,26,24.96,23.88,23,22.32,21.75,22.13,22.72,22.98,22.98,22,20.98,19,19,19,17.98,17.98,17.98,17.98,17.98,17,17,17,17,17,17,17,17,17,17,17,15.98,16.32,16.33,16.58,17.12,18.12,19,19.71,20.22,20.62,20.87,21,20.99,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,22,22,22,22,22.98,22.98,22.98,25,25,25.98,27,25.98,22,22,20.98,20.09,19.14,18.92,18.89,19.29,19.88,19.67,18.37,18.37,17.77,16.91,16.02,15.14,14.29,13.46,12.61,11.79,11.12,10.67,10.47,10.36,10.41,10.50,10.64,10.77,10.87,11.09,11.20,11.32,11.32,11.41,11.64,11.87,12,12,12.01,12.08,12.86,13.12,13.83,14,14.21,14.75,14.99,15,15.25,15.64,15.96,16,16.12,16.12,17.09,17.87,18,18,19,19,19,19,19,20,20,20,20,20.98,20.98,20.98,22,22,22,22,22,22,22,22.98,22.98,24,25.98,25.98,27,27,27.98,30,29.88,29.74,29.87,30.49,30.98,31.51,31.99,32.51,32.98,33.21,33.07,33.50,34.35,35.11,35.89,36.62,37.23,37.75,38.21,38.50,38.75,39.14,39.99,41.09,42.46,44,46,48.58,51.46,53.62,55.48,57,59,60.98,59,59,52.98,50.07,47.51,39.63,38.27,36.95,35.78,35.27,35.07,35,35,35,35,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,35,35,35.98,37.98,40,47.98,47.98,50.98,50.98,50,50,50,50,49,47.98,45.98,45.98,45.98,45.98,45.98,46.07,46,45.75,45.35,44.87,44.50,44.35,44.37,44.51,44.60,44.51,44.48,44.47,44.50,44.59,44.72,44.72,44.61,44.37,44,43.60,43.14,42.75,42.37,42.01,41.61,41.12,40.62,40.12,39.61,39.01,38.37,37.50,36.37,36.25,36.14,36.27,36.35,36.14,35.52,34.57,33.37,32.38,31.40,30.50,29.62,28.73,27.83,26.83,25.75,24.62,23.71,23.01,22.50,22.73,23.38,23.87,24,22.98,22,20,20,19,19,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17,17,17,17,17,17,17,17,16.62,16.63,16.76,17.25,18,18.82,19.50,20.12,20.70,21,21.12,21,21,21,21,21,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,22,22,22,22,22.98,22,25,25,25,25,24,22,22,20.98,20.07,20.12,19.20,19.24,19.72,20.64,19.64,18.35,17.59,17.08,16.37,15.60,14.88,14.22,13.51,12.76,12,11.34,10.90,10.79,10.95,11.17,11.45,11.60,11.63,11.63,11.75,11.87,11.98,11.98,12.21,12.33,12.42,12.33,12.33,12.33,12.07,12.87,13.12,13.84,14,14.21,14.75,14.99,15,15.26,15.63,15.98,16.12,16.21,16.82,17.11,17.84,17.92,18.08,18.08,18.89,18.98,19,19.08,19.95,19.99,20,20,20.98,20.98,20.98,22,22,22,22,22,22,22,22,22.98,24,25,25,25.98,25.98,27.98,27.98,27.98,27.98,29,30,30.98,30.98,32,32,32,32.98,32.98,33.24,33.95,34.63,35.36,35.90,36.39,36.83,37.12,37.45,37.75,38.39,39.57,41.01,42.75,44.51,46.72,49.34,52.36,54.63,56.50,57.98,59,60.98,59,59,55.98,52.76,48.48,39.68,38.21,36.77,35.79,35.25,35.05,35,35,35,35,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,35,35,35.98,37,40,47,47,50,50.98,50,50,50,50,49,47.98,47,47,47,47,47,47.25,47.10,46.82,46.37,46,45.62,45.50,45.48,45.57,45.61,45.58,45.50,45.50,45.59,45.71,45.87,45.98,45.89,45.75,45.47,45.10,44.74,44.37,44.08,43.71,43.27,42.87,42.46,42,41.52,41,40.37,39.50,38.37,37.45,37.58,37.50,37.37,37.12,36.75,35.48,34.34,33.37,32.45,31.50,30.52,29.62,28.64,27.65,26.63,25.65,24.84,24.12,23.57,23.15,24.13,24.82,24.73,24.25,22.95,21.50,20.96,20.35,19.25,19.08,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17,17,17,17,17,17,17.10,16.97,17,17.25,17.89,18.62,19.37,20.12,20.87,21.35,21.37,21.35,21.32,21.32,21.32,21,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,22,22,22,22,22,24,24,24,22.98,22.98,22.98,22.98,24,22.92,21.88,20.16,19.87,19.90,19.70,18.84,17.35,17.16,16.67,16.03,15.37,14.79,14.26,13.71,13,12.25,11.58,11.14,11.22,11.61,12.07,12.39,12.41,12.36,12.29,12.41,12.52,12.64,12.71,12.92,12.99,12.99,12.75,12.71,12.76,12.89,12.87,13.11,13.85,14.01,14.22,14.74,14.99,15.10,15.26,15.75,16.10,16.25,16.75,16.86,17.17,17.76,17.90,18,18.13,18.86,18.97,19.01,19.12,19.87,19.90,19.99,20.01,20.98,20.98,20.98,20.98,20.98,20,20.98,20.98,22,22,22,22,22.98,24,24,25,25.98,25.98,27,27,27.98,29,30,30,30,30,30,30,32,32,33,33.63,34.25,34.76,35.22,35.52,35.86,36.12,36.50,37,37.89,39.37,41.25,43.34,45.36,47.52,50.11,53.11,55.82,57.12,59,57.98,55,50,50,50,49.05,46.48,38.66,37.54,36.49,35.66,35.22,35.04,35,35,35,35,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,35,35,35,35,35,34,34,34,34,34,34,35,35,35.98,37,39,47.98,47.98,50.98,50.98,50.98,50,50,50,49,49,49,49,49,49,49,48.58,48.21,47.87,47.50,47.20,46.87,46.64,46.59,46.60,46.61,46.59,46.50,46.50,46.61,46.75,46.98,47.13,47.26,47.12,46.95,46.62,46.37,46.09,45.75,45.38,45.01,44.64,44.32,43.95,43.59,43.12,42.50,41.90,40.82,40.58,39.22,38.70,38.50,38.08,37.37,36.49,35.48,34.51,33.60,32.60,31.50,30.50,29.52,28.59,27.62,26.72,25.87,25.22,24.64,24.62,25.02,25.62,25.86,25.37,24.12,23.08,22.14,21.39,20.75,20.57,19.77,20,19,19,19,19,19,19,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.32,17.13,17.20,17.32,17.87,18.57,19.32,20.14,21.08,21.62,21.70,21.63,21.62,21.62,21.62,21.98,22,22,22,22.98,22.98,22.98,22,20.98,20.98,20.98,20.98,20.98,20.98,20.98,23.49,23.49,23.49,22.98,22.98,23.49,23.49,24.50,23.49,22.41,20.62,20.29,19.92,19.27,18.37,17.33,16.95,16.50,15.95,15.36,14.86,14.46,13.98,13.32,12.51,11.79,11.34,11.59,12.25,13.12,13.49,13.32,13.13,12.98,12.98,12.98,12.98,13.13,13.49,13.64,13.64,13.32,13.13,12.97,12.98,12.98,13.08,13.87,14.12,14.47,14.82,15,15.20,15.50,15.96,16.32,16.61,16.75,16.97,17.24,17.72,17.88,18,18.17,18.79,18.95,19,19.16,19.50,19.86,19.97,20.08,20.50,20.98,20.98,20.49,20.49,20,20.49,20.98,21.49,21.49,22,22,22.98,24,24,25,25.98,25.98,27,27,27.98,29,29.50,30,30,30,30,30,32,32,32.87,33.38,33.87,34.25,34.58,34.75,35,35.33,35.86,36.61,37.75,39.46,41.62,43.89,46,48.11,50.51,53.50,56,57.26,58,55.99,52.50,47.50,47.50,47,45.97,44.52,38.13,36.97,36.12,35.48,35.15,35.03,35,35,35,35,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34.50,35,35,35.49,35,34,34,34,34,34,34,35,35,35.98,37,39,47.98,47.98,50.98,51.49,50.98,50,50,49.50,49,49,49.50,49.50,49.50,49.50,49.99,49.62,49.10,48.75,48.46,48.22,48,47.82,47.63,47.62,47.61,47.58,47.50,47.50,47.61,47.75,48,48.25,48.48,48.46,48.37,48.23,48,47.75,47.46,47.09,46.75,46.40,46.12,45.82,45.49,45.20,44.49,43.59,42.85,42.11,40.36,39.76,39.40,38.99,38.36,37.50,36.62,35.75,34.87,33.64,32.50,31.45,30.45,29.49,28.51,27.62,26.87,26.12,25.63,25.59,25.96,26.37,26.38,26.20,25.08,24,23.10,22.36,21.65,21.08,20.62,20.12,19.58,19.50,19,19,19,19,18.49,17.98,17.98,17.98,17.98,17.98,17.98,17.62,17.50,17.49,17.50,17.98,18.50,19.25,20.09,21.08,21.75,21.87,21.87,21.88,21.89,21.95,21.98,22,22,22,22.98,22.98,22.98,22,21.49,20.98,20.98,20.98,20.98,20.98,20.98,22.98,22.98,22.98,22.98,22.98,24,24,25,24,22.96,21.07,20.83,19.92,19.08,18.20,17.46,16.89,16.45,15.92,15.39,14.98,14.65,14.35,13.60,12.77,12,11.48,11.77,12.71,13.59,13.92,13.64,13.49,13.32,13.32,13.32,13.32,13.49,13.71,13.87,13.87,13.64,13.14,12.98,12.98,13,13.01,13.87,14.12,14.76,14.95,15.12,15.25,15.72,16.12,16.75,16.74,16.86,17,17.27,17.66,17.87,17.99,18.23,18.75,18.84,18.98,19.09,19.21,19.82,19.87,20.04,20.09,20.92,20.98,20,20,20,20,20.98,20.98,20.98,22,22,22.98,24,24,25,25.98,25.98,27,27,27.98,29,29,30,30,30,30,30,32,32,32.98,32.99,33.38,33.82,34,34.11,34.32,34.73,35.48,36.47,37.76,39.62,41.95,44.26,46.37,48.37,50.62,53.38,56.13,56.62,57,54,50,45,45,44,43.07,42.63,37.52,36.40,35.68,35.29,35.09,35.01,35,35,35,35,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,35,35,35.98,35,34,34,34,34,34,34,35,35,35.98,37,39,47.98,47.98,50.98,52,50.98,50,50,49,49,49,50,50,50,50,50.98,50,49.86,49.57,49.25,49.14,49.10,48.96,48.82,48.75,48.71,48.62,48.58,48.50,48.60,48.71,49.01,49.37,49.61,49.72,49.75,49.75,49.63,49.39,49.09,48.73,48.46,48.12,47.85,47.52,47.23,46.75,46.10,45.24,44.35,43.63,41.32,40.86,40.34,40.12,39.50,38.62,37.75,36.87,35.87,34.73,33.50,32.37,31.37,30.37,29.37,28.45,27.58,26.82,26.26,26.23,26.52,26.87,26.87,26.47,25.63,24.64,23.75,23,22.26,21.64,21.12,20.65,20.25,19.75,19,19,19,19,19,17.98,17.98,17.98,17.98,17.98,17.98,17.86,17.75,17.75,17.85,18,18.39,19,19.75,20.62,21.37,21.76,21.97,22.01,22,22,21.99,22,22,22,22.98,22.98,22.98,22,22,20.98,20.98,20.98,20.98,20.98,20.98,22.98,22.98,22.98,22.98,22.98,24,24,24,22.98,22.98,21.01,20.87,19.85,18.86,18.07,17.35,16.84,16.37,15.90,15.45,15.08,14.78,14.48,13.79,13.02,12.25,11.75,12,12.92,13.91,14.33,14.22,14.10,13.87,13.87,13.87,13.99,14.10,14.11,14.11,14,13.87,14,14,14,14,13.97,14.07,14.87,14.99,15.21,15.23,15.73,15.87,16.22,16.73,16.87,16.92,17.04,17.32,17.62,17.83,17.92,18.11,18.25,18.73,18.91,18.99,19.13,19.22,19.79,19.96,20.10,20.08,20.96,20,20,20,20,20,20.98,20.98,22,22.98,22,24,24,25,25.98,25.98,27,27,27.98,29,29,29,29,29,29,30,32,32,32,32.38,32.98,33.35,33.45,33.50,33.75,34.27,35.25,36.49,38,39.90,42.15,44.47,46.49,48.47,50.62,53.26,55.24,55.99,55,50.98,47,42,42,40.98,40,38.84,36.32,35.76,35.39,35.14,35.03,35,35,35,35,35,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,35,35,35,35,34,34,34,34,34,34,35,35,35.98,37,39,47,47,50.98,52,50.98,50,50,49,49,49,50,50,50.98,50.98,52,50.98,50.98,50.24,50.09,50.20,50.22,50.13,50.10,50,49.99,49.87,49.70,49.60,49.48,49.75,50.21,50.59,50.75,50.87,51.02,51.15,51.24,51.10,50.85,50.50,50.15,49.87,49.52,49.23,48.84,48.36,47.63,46.87,46,44.70,42.26,42.14,41.87,41.75,40.75,39.83,38.87,37.96,36.95,35.77,34.62,33.45,32.45,31.37,30.21,29.12,28.20,27.47,26.96,26.84,27.07,27.25,27.25,26.89,26.24,25.34,24.46,23.64,22.99,22.37,21.83,21.35,20.84,20.25,19.74,19,19,19,19,19,17.98,17.98,17.98,17.98,17.98,17.98,17.96,17.98,18,18.12,18.25,18.72,19.25,20.10,20.87,21.60,22,22.25,22.34,22,22,22,22,22,22.98,22.98,22.98,22,22,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,22,22.98,22.98,22.98,22.98,22,22,20,19.96,19.09,18.87,17.75,17.11,16.64,16.25,15.84,15.45,15.11,14.83,14.47,13.95,13.25,12.59,12.12,12.17,12.88,13.77,14.42,14.65,14.65,14.54,14.54,14.54,14.65,14.65,14.54,14.42,14.24,14,14,14,14,14,14,14.98,15,15.12,15.83,15.75,15.84,16,16.13,16.75,16.87,16.97,17.04,17.25,17.61,17.66,17.82,17.98,18.24,18.70,18.72,18.86,19,19.25,19.77,19.79,19.84,19.87,19.92,19,19,20,20,20,20.98,20.98,22,22,22,22.98,22.98,24,25,25,27,27,27.98,27.98,29,27.98,27.98,27.98,29,30,30.98,30.98,30.98,31.75,32.37,32.62,32.82,32.95,33.25,33.97,35.12,36.57,38.25,40.23,42.37,44.52,46.60,48.65,50.83,53.32,55.37,55.71,54,49,45,40,40,39,37.98,37,35.08,35.16,35.14,35.05,35.01,35,35,35,35,35,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,35,35,35.98,37,39.50,46.02,47.82,49.67,51.09,51.04,50.50,50,49,49,49,50,50,50.98,52,52,50.98,50.98,50.98,51.12,51.34,51.49,51.47,51.38,51.50,51.46,51.36,51,50.50,50.74,50.87,51.71,52,52,52.08,52.26,52.60,52.77,52.76,52.61,52.27,51.96,51.60,51.25,50.87,50.45,49.98,49.50,48.39,48.15,46.75,44.24,44.22,43.14,42.99,42.11,41,40,39.20,38.12,36.97,35.77,34.71,33.62,32.40,31.15,30,29,28.27,27.75,27.50,27.60,27.65,27.71,27.50,26.97,26.12,25.25,24.50,23.85,23.24,22.64,22.11,21.50,20.87,20.15,19.22,19,19,19,19,19,19,17.98,17.98,17.98,17.98,17.98,18.26,18.35,18.36,18.37,18.61,18.95,19.50,20.46,21.33,22.12,22.62,22.95,22.96,22,22,22,22.98,22.98,22.98,22.98,22,22,20.98,20.98,20.98,20.98,20.98,20.98,19,19,19,20,20.98,20.98,20.98,20.98,20,20,19,19,18,17.90,17.36,16.77,16.39,16.08,15.74,15.40,15.12,14.84,14.50,14.02,13.48,12.88,12.49,12.37,12.71,13.60,14.42,15,15,14.87,14.87,14.87,15.04,15.11,15.03,14.92,15,15,15,15,15,15,15,15,15.98,15.89,15.87,15.98,16,16,16.14,16.75,16.89,16.97,17.02,17.14,17.27,17.38,17.70,17.90,18.10,18.25,18.28,18.70,18.90,19.11,19.25,19.22,19.17,19.13,19.10,19.02,19,20,20,20,20.98,20.98,20.98,22,22,24,24,25,25.98,25.98,27,27,27.98,27.98,27.98,27,27,27.98,29,30,30.98,30.98,30.98,31.07,31.38,31.97,32.14,32.37,32.87,33.75,35.09,36.65,38.50,40.49,42.57,44.63,46.72,48.87,50.99,53.37,55.51,55.87,54,49,45,37.98,37.98,37,35.98,35,35,35,35,35,35,35,35,35,35,35,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,35,35,35.98,37.50,40.15,44.39,47.25,49.38,51.13,51.23,50.83,50.24,50,50,49,50,50,50.98,52,52.98,52.98,52.98,52,52,52.87,52.84,52.75,52.74,52.72,53.71,52.63,52.62,52.63,52.64,52.71,53.75,53.75,53.08,53.11,53.37,53.83,54.14,54.32,54.25,54,53.63,53.34,52.97,52.50,51.99,51.50,51.25,51.77,50.75,49.77,47.77,47.83,45.85,44.88,43.39,42.12,41.14,40.37,39.36,38.13,37,35.97,34.87,33.60,32.25,31,29.99,29.15,28.61,28.25,28.13,28.22,28.25,28.23,27.76,27,26.22,25.46,24.75,24.12,23.51,22.88,22.22,21.46,20.72,20.12,19.89,20,20,20,19,19,19,19,19,19,19,18.99,18.75,18.62,18.64,18.75,18.89,19.12,19.57,21.57,22.11,22.95,22.96,22.97,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22,22,20.98,20.98,20.98,20.98,20.98,20.98,18.49,18.49,18.49,19.50,20.49,20.49,20.49,20.49,19.50,19.50,18.49,18.49,17.98,17.49,16.87,16.42,16.14,15.91,15.65,15.37,15.11,14.85,14.54,14.14,13.64,13.21,12.70,12.41,12.54,13.29,14.59,15,15,15,15,15,15.15,15.33,15.49,15.49,15.49,15.49,15.49,15.49,15.49,15.49,15.49,15.49,15.98,15.98,15.98,15.98,16.09,16.37,16.15,16.74,16.88,16.96,17,17.03,17.12,17.35,17.62,17.87,17.98,18.03,18.21,18.49,18.76,18.95,18.99,18.99,19,19.02,19.12,19.45,19.50,19.50,20,20,20.98,20.98,20.98,22,22,24,24,25,25.98,26.49,27,27,27.98,27.49,27.98,27.49,27.49,28.49,29,29.50,30.49,30.49,30.98,30.98,31.13,31.37,31.71,32.02,32.72,33.75,35.20,36.85,38.65,40.63,42.72,44.75,46.75,48.88,50.99,53.21,55.25,55.49,54,49.50,45,37.98,37.98,37,35.98,35,35,35,35,35,35,35,35,35,35,35,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34.50,34.50,35,35,35.98,37.66,40.57,43.68,46.68,49.15,50.97,51.53,51.25,50.80,50.49,50.49,49.50,50,50,50.98,51.49,52.98,53.49,53.49,52.49,52.49,52.95,52.97,53,53.12,53.37,53.49,53.50,53.37,53.37,53.49,53.75,54.12,54.02,53.87,53.95,54.39,54.90,55.34,55.57,55.62,55.47,55.21,54.88,54.57,54.11,53.38,52.87,52.57,52.26,51.85,50.40,49.10,48.87,47,45.49,44.21,43.11,42.12,41.37,40.36,39.22,38.11,37.07,36.01,34.72,33.25,31.96,30.86,30.08,29.38,28.95,28.75,28.76,28.87,28.95,28.62,27.96,27.14,26.39,25.72,25.01,24.35,23.62,22.75,21.90,21.14,20.62,20.27,20,20,20,19.50,19.50,19,19,19,19,19,19,18.99,18.98,18.97,18.97,18.97,19,19,21.46,21.50,22.47,22.97,22.98,22.98,22.98,22.98,22.98,22.98,22.49,22.49,22,22,20.98,20.98,20.98,20.98,20.98,20.98,17.98,17.98,17.98,19,20,20,20,20,19,19,17.98,17.98,17.98,17,16.62,16.25,16,15.87,15.62,15.33,15.11,14.87,14.62,14.21,13.75,13.21,12.75,12.37,12.36,12.98,15,15,15.01,15.02,15.04,15.01,15.08,15.89,15.89,15.90,15.92,15.95,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.99,16,16.01,16.07,16.87,16.16,16.74,16.86,16.91,16.96,16.99,17.07,17.25,17.57,17.76,17.90,17.98,18.09,18.28,18.66,18.70,18.72,18.74,18.87,19.11,19.12,19.91,20,19,20,20,20.98,20.98,20.98,22,22,24,24,25,25.98,27,27,27,27.98,27,27.98,27.98,27.98,29,29,29,30,30,30.98,30.98,31,31.14,31.46,31.95,32.75,33.89,35.37,37,38.83,40.75,42.76,44.75,46.73,48.62,50.62,52.77,54.87,55,54,50,45,37.98,37.98,37,35.98,35,35,35,35,35,35,35,35,35,35,35,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,35,35,35,35,35.98,37.74,40.48,43.47,46.36,48.99,51.09,51.92,51.78,51.47,50.98,50.98,50,50,50,50.98,50.98,52.98,54,54,52.98,52.98,52.87,53,53.13,53.37,53.59,53.75,53.83,53.87,54,54.21,54.48,54.62,54.64,54.65,54.87,55.50,56.08,56.50,56.75,56.77,56.75,56.60,56.37,56.02,55.50,54.75,53.90,53.52,53.27,52.87,50.98,50,50,47.98,45.98,44.98,43.75,42.87,42.14,41.25,40.22,39.14,38.12,36.99,35.62,34.15,32.85,31.76,31,30.25,29.71,29.40,29.46,29.60,29.64,29.50,28.88,28.13,27.38,26.63,25.87,25.02,24.13,23.25,22.34,21.48,20.98,20.62,20,20,20,20,20,19,19,19,19,19,19,19,19,19,19,19,19,19,20.96,20.99,22,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22,22,22,21.75,21.32,20.98,21.09,21.20,21.20,20.38,17.98,17.98,17.98,17.98,19,19,19,19,17.98,17.98,17.98,17.98,17,17,16.36,16.12,16,15.87,15.62,15.33,15.11,14.87,14.62,14.13,13.64,13.14,12.64,12.37,12.37,12.98,15.97,15.95,15.90,15.88,15.10,15.11,15.12,15.86,15.96,15.97,15.97,15.97,15.97,15.98,15.98,15.98,15.98,15.98,15.98,15.98,16.98,16.95,16.88,16.07,16.15,16.73,16.67,16.78,16.91,17,17.08,17.20,17.36,17.62,17.82,17.95,18,18.12,18.23,18.28,18.26,18.24,18.75,19.09,19.86,19.09,19,19,19,20,20,20,20.98,22,22,24,24,25,25.98,27,25.98,25.98,25.98,27,27,27.98,27.98,29,29,29,30,30,30,30.98,30.75,30.97,31.39,32.01,32.96,34.12,35.57,37.12,38.88,40.82,42.75,44.64,46.50,48.25,50.12,52.23,54.87,55,54,50.98,45,37.98,37.98,37,35.98,35,35,35,35,35,35,35,35,35,35,35,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,35,35,35,35,35,35.98,37.77,40.35,43.16,46.15,48.79,51.21,52.30,52.34,52.20,52,52,50.98,50.98,50.98,50.98,52,54,54,54,52.98,52.99,53,53,53.25,53.50,53.75,53.97,54.12,54.36,54.57,54.76,55.08,55.25,55.38,55.62,56.01,56.75,57.40,57.87,58.07,58.12,58.11,58,57.88,57.62,57.11,56.21,55.33,54.75,54.48,53.74,52,52,52,50,47.98,46,44.63,43.75,43.23,42.40,41.37,40.34,39.25,38.01,36.70,35.12,33.87,32.87,32.12,31.26,30.62,30.25,30.25,30.40,30.57,30.50,29.98,29.25,28.49,27.62,26.73,25.73,24.70,23.65,22.72,21.75,21.25,20.89,20.98,20,20,20,20,20,20,19,19,19,19,19,19,19,19,19,20,19,20.98,20.98,22,22,22.98,22.98,22.98,22.98,22.98,22,22,22,21.99,21.63,21.37,21.25,21.37,21.48,21.37,20,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17,17,17,17,15.98,16.12,16,15.98,15.87,15.62,15.33,15.11,14.87,14.62,14.10,13.50,12.95,12.50,12.25,12.25,13,14.95,14.90,15.87,15.85,15.84,15.83,15.83,15.87,15.98,15.99,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,17,16.98,16,16,16.12,16.15,16.25,16.64,16.84,17.09,17.25,17.34,17.36,17.36,17.82,17.97,18.01,18.04,18.08,18.09,18.09,18.17,18.22,18.88,19.86,19.10,19,19,19,20,20,20,20.98,22,22,24,24,25,25,25.98,25.98,25.98,25.98,27,27,29,29,29,29,29,30,30,30,30,30.62,30.96,31.37,32.20,33.20,34.37,35.74,37.25,38.95,40.75,42.60,44.37,46.11,47.73,49.35,51.25,53.86,54,54,50.98,45,37.98,37.98,37,35.98,35,35,35,35,35,35,35,35,35,35,35,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,35,35,35,35,35,35.98,35.98,35.98,37.62,40,42.75,45.21,47.88,50.55,52.23,52.82,52.91,52.98,52.98,52.98,52,52,52,54,55,54,54,53.13,53.33,53.33,53.35,53.50,53.72,53.89,54.20,54.48,54.75,55.01,55.34,55.61,55.87,56.12,56.50,57.20,58.11,58.95,59.39,59.52,59.60,59.61,59.59,59.50,59.35,58.90,58.12,57.33,56.96,56.59,55.45,54.01,54,54,52,49,47.99,45.45,45.37,44.75,43.87,42.74,41.61,40.37,39.24,37.89,36.62,35.38,34.34,33.37,32.50,31.72,31.25,31.21,31.37,31.62,31.62,31.12,30.46,29.62,28.65,27.60,26.38,25.25,24.12,23.12,22.23,21.65,21.37,20.98,20.98,20.98,20,20,20,20,20,19,19,19,19,19,19,19,19,20,20,20.98,20.98,20.98,22,22.98,22,22,22,22,22,22,21.99,21.96,21.64,21.37,21.25,21.35,21.45,21.33,19.71,19,19,17.98,17.98,17.98,17.98,17.98,17.98,17,17,15.98,15.98,15.98,15.98,15.86,15.87,15.95,15.87,15.62,15.33,15.11,14.87,14.59,13.99,13.32,12.64,12.33,12.12,12.15,12.07,13.08,13.10,14.13,15.15,15.85,16.07,16.13,16.13,16.10,16.03,15.99,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.99,15.98,16,16.02,16.13,16.24,16.75,17.17,17.63,17.63,17.63,17.75,17.90,18.10,18.16,18.20,18.20,18.20,18.21,18.22,18.22,18.16,19.13,19.89,20,20,20.98,22,22,22,22.98,22.98,22.98,24,24,25,25,25.98,27,27,27,27,27.98,27.98,27.98,27.98,27.98,27.98,29,29,30,30,30.62,31.12,31.62,32.37,33.37,34.57,35.87,37.33,38.87,40.61,42.35,44.01,45.62,47.12,48.50,49.35,51.86,52,52.98,50.98,45.98,39,39,37,35.98,35,35,35,35,35,35,35,35,35,35,35,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,35,35,35,35,35,35.98,35.98,35.98,35.98,37.49,39.48,41.64,44.02,46.61,49.33,51.65,52.92,53.52,54,55,54,52.98,52.98,54,55.98,57.98,55.98,55.98,54.33,53.75,53.72,53.70,53.75,53.87,54.10,54.45,54.84,55.21,55.51,55.87,56.14,56.46,56.77,57.32,58.12,59.15,60.24,60.87,61.11,61.22,61.25,61.25,61.20,61,60.65,60,59.37,58.90,59.02,58.38,57.87,56,55.98,54,52.98,50.98,48.13,47.38,46.23,45.12,43.76,42.50,41.37,40.35,39.25,38.02,36.87,35.75,34.71,33.75,32.87,32.36,32.22,32.37,32.75,32.76,32.33,31.62,30.83,29.73,28.39,27.10,25.82,24.62,23.61,22.63,22.14,21.87,22,22,20.98,20.98,20.98,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20.98,20.98,22,22,22,22,22,21.99,21.99,21.89,21.63,21.37,21.25,21.21,21.21,21,19.47,19.50,19.50,18.49,18.49,18.49,17.98,17.98,17.98,17,17,15.98,15.98,15.49,15.49,15.60,15.72,15.86,15.84,15.61,15.26,15.09,14.86,14.50,13.87,13.12,12.47,12.12,12.09,12.03,12.10,12.85,13.12,14.15,15.28,15.97,16.29,16.47,16.47,16.33,16.15,16,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.99,16.02,16.22,16.74,17.25,17.65,17.89,17.96,18,18.14,18.32,18.46,18.48,18.48,18.49,18.49,18.49,18.51,18.66,19.13,19.90,20,20.49,21.49,22,23,23,23.49,22.98,22.98,24,24,25,25,25.49,26.49,26.49,26.49,26.49,27.49,27.49,27.49,27.49,27.98,27.98,29.50,29.50,30,30.49,30.97,31.48,32.07,32.76,33.72,34.86,36.09,37.39,38.87,40.37,41.98,43.50,45.02,46.50,47.76,49.01,51.86,52,53.49,51.49,46.49,39,39,37,35.98,35,35,35,35,35,35,35,35,35,35,35,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34.50,35,35,35,35,35.49,35.98,35.98,35.98,36.49,37.36,38.91,40.60,42.71,45.01,48.01,50.77,52.85,53.98,54.50,55,54.50,53.49,53.49,54.50,55.98,57.98,55.98,55.98,55,54.35,54.12,54,54,54,54.37,54.75,55.25,55.72,56.10,56.45,56.75,57.01,57.37,57.89,58.75,59.87,61.13,62.09,62.40,62.63,62.75,62.75,62.64,62.47,62.12,61.62,61.12,60.70,60.22,59.62,58.85,57.02,56.96,54.99,53.99,51.98,48.99,48.72,47.45,46.02,44.48,43.21,42.12,41.27,40.46,39.40,38.27,37.09,35.98,34.99,34.02,33.45,33.13,33.45,33.75,33.76,33.34,32.64,31.75,30.59,29.12,27.72,26.37,25.12,24.07,23.11,22.62,22.47,22.49,22,21.49,20.98,20.98,20.49,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20.49,20.98,22,22,22,22,22,21.99,21.98,21.87,21.62,21.35,21.11,21,20.96,20.63,18.75,20,20,19,19,19,17.98,17.98,17.98,17,17,15.98,15.98,15,15,15.01,15.58,15.62,15.62,15.49,15.22,14.99,14.73,14.37,13.75,13.12,12.62,12.25,12.12,12.02,12.11,12.84,13.14,14.04,15.75,16.16,16.75,16.79,16.79,16.75,16.22,16.12,16,15.99,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.99,15.99,16.02,16.20,16.74,17.26,17.66,18.07,18.23,18.34,18.34,18.63,18.73,18.77,18.78,18.82,18.83,18.83,18.96,19.13,19.12,20,20,20.98,22,22,24,24,24,22.98,22.98,24,24,25,25,25,25.98,25.98,25.98,25.98,27,27,27,27,27.98,27.98,30,30,30,30.98,31.36,31.87,32.50,33.25,34.11,35.11,36.24,37.48,38.82,40.22,41.63,43.12,44.59,46,47.47,48.75,51.87,52,54,52,47,39,39,37,35.98,35,35,35,35,35,35,35,35,35,35,35,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,35,35,35,35,35,35.98,35.98,35.98,35.98,37,37,38.48,40.24,42.09,43.96,46.79,50,53.50,54,55,55,55,54,54,55,55.98,57.98,55.98,55.98,55.34,54.76,54.50,54.37,54.37,54.51,54.85,55.33,55.87,56.37,56.75,57.11,57.38,57.70,58,58.46,59.25,60.32,61.40,62.37,63.09,63.62,64,64.14,64.12,63.86,63.40,62.87,62.36,61.84,61.25,60.64,59.83,58.10,57.89,55.98,55,52.98,50,50,48.14,46.49,44.87,43.62,42.50,41.97,41.25,40.33,39.26,38.14,37.20,36.20,35.23,34.34,34.24,34.51,34.75,34.63,34.15,33.40,32.47,31.24,29.76,28.32,26.87,25.62,24.59,23.51,23.07,22.86,22.98,22,22,20.98,20.98,20.98,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20.98,22,22,22,22,22,21.98,21.97,21.87,21.62,21.25,20.99,20.76,20.63,20.34,18.13,20.98,20.98,20,20,19,19,19,17.98,17.98,17,15.98,15.98,15,15,15,15.08,15.26,15.32,15.22,15,14.75,14.50,14.12,13.71,13.23,12.87,12.62,12.12,12.10,12.13,12.79,13.11,13.21,15.03,16.75,16.85,17.04,17.11,16.98,16.75,16.23,16.21,16.09,16,15.99,15.99,15.99,15.98,15.98,15.98,15.98,15.98,15.98,15.98,16.02,16.10,16.13,16.17,16.78,17.26,17.67,18.15,18.66,18.65,18.75,18.87,18.98,19,19.10,19.20,19.26,19.24,19.21,19.84,20.11,20.91,20.98,20.98,22,22,24,24,22.98,22.98,22.98,24,24,25,25.98,25.98,25.98,25.98,25.98,25.98,27,27,27,27.98,27.98,29,30,30,30.98,30.98,31.75,32.33,32.87,33.59,34.37,35.33,36.37,37.50,38.75,40.07,41.39,42.82,44.23,45.70,47.25,48.98,51.86,52,54,54,50,40,40,37,35.98,35,35,35,35,35,35,35,35,35,35,35,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,35,35,35,35.98,35.98,35.98,35.98,35.98,37,37,37,37,37.98,40.98,40.98,42.98,45,49,54,54,55.98,55.98,55,55,55,55,55.98,57,55.98,55.98,55.71,55.37,55.14,55.08,55.08,55.49,55.76,56.25,56.75,57.20,57.58,57.87,58.15,58.46,58.75,59.12,59.77,60.71,61.63,62.59,63.46,64.25,65,65.50,65.62,65.37,64.87,64.23,63.59,63,62.59,62.10,61.77,59.12,59.09,57.99,57,55,50.98,50.98,49,47.12,45.62,43.49,43.14,42.71,42.21,41.25,39.75,39.25,38.48,37.37,36.37,35.63,35.51,35.74,35.85,35.61,34.96,34.10,33,31.75,30.37,29,27.62,26.40,25.25,24.22,23.62,23.36,22.98,22.98,22,22,22,20.98,20.98,20.98,20.98,20.98,20,20,20,20,20,20,20,20,20,20,20,20,20,20.98,20.98,20.98,20.98,22,21.83,21.87,21.87,21.50,21.09,20.75,20.57,20.37,20.01,18.10,22,22,20.98,20,20,19,19,19,17.98,17,15.98,15.98,15,15,15,15,15.08,14.99,14.82,14.57,14.37,14.24,14,13.62,13.50,13.25,13.10,13.07,13,12.99,13,13.04,13.22,14.85,16.32,16.89,17.17,17.29,17.28,17.11,16.87,16.60,16.21,16.17,16.14,16.12,16.09,16.02,15.99,15.98,15.98,15.98,15.98,15.98,16,16.89,16.86,16.82,16.88,17.21,17.70,17.98,18.70,18.82,19.04,19.22,19.32,19.29,19.28,19.72,19.75,19.77,19.89,20.13,20.87,20.95,20.98,20.98,20.98,22,22.98,22.98,22.98,22.98,22.98,25,25,25,25.98,25.98,25.98,25.98,25.98,27,27,29,29,27.98,27.98,29,30,30,30.98,32,32.12,32.59,33.15,33.86,34.62,35.49,36.48,37.52,38.73,39.96,41.24,42.57,43.95,45.37,47.08,49,51.86,52.01,54,55,52,40.98,40.98,37.98,35.98,35,35,35,35,35,35,35,35,35,35,35,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,35,35,35,35,35,35.98,35.98,35.98,35.98,35.98,37,37,37,37,37.98,40,40,42,45,47.98,54,54,55.98,57,55.98,55,55,55,55.98,55.98,56,56.07,56.24,56.25,56.36,56.50,56.71,56.87,57.13,57.50,57.86,58.14,58.49,58.75,59.01,59.33,59.62,60.01,60.58,61.24,61.99,62.75,63.64,64.74,65.90,67,67.47,67.12,66.50,65.87,65.27,64.86,64.50,64.09,63.20,62.13,62.10,61,60,57.98,52.98,52.98,50.98,49,47,44.01,44.09,44.11,43.10,42.85,41.10,40.99,39.59,39.21,38.12,37.32,37,36.98,36.90,36.49,35.72,34.75,33.62,32.37,31,29.65,28.45,27.26,26.25,25.32,24.50,24,23.98,22.98,22.98,22,22,22,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20,20,20,20,20,20,20,20,20,20,20,20,20,20.98,20.98,21.25,21.25,21.25,21.01,20.75,20.48,20.25,20.12,19.83,18.08,22.98,22.98,22,20.98,20.98,20,20,20,19,17.98,17,17,15.98,15.98,15,15,14.99,14.87,14.10,14.11,14.12,14.07,14,13.98,13.95,13.87,13.89,13.87,13.87,13.83,13.16,13.14,13.54,14.76,15.95,16.79,17.27,17.50,17.53,17.49,17.33,17.10,16.88,16.78,16.79,16.85,16.87,16.91,16.99,15.98,15.98,15.98,15.98,15.98,15.98,16.92,16.96,16.96,16.99,17.11,17.25,17.26,18.20,18.76,19.21,19.70,19.71,19.72,19.75,19.90,20.08,20.14,20.15,20.86,20.90,20.98,20.98,22,22,22,22.98,22.98,22.98,22.98,24,25,25,25.98,25.98,25.98,27,27,27,27,27,27,27,27,27.98,27.98,30,30,30.98,32,32,32.75,33.36,34,34.75,35.61,36.52,37.59,38.70,39.87,41.10,42.37,43.72,45.13,46.75,49,51.85,52.09,54,55,52,40.98,40.98,39,35.98,35,35,35,35,35,35,35,35,35,35,35,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,35,35.98,35.98,35.98,35.98,35.98,35.98,35.98,35.98,37,37,37,37,37,37.98,37.98,40,40,40.98,42,44,52,52,54,55,55.98,57,57,57,57,56.89,56.87,56.84,56.86,57.12,57.50,57.99,58.39,58.59,58.72,58.85,59,59.23,59.46,59.70,59.96,60.25,60.60,60.98,61.39,61.90,62.48,63.09,63.85,65,66.50,68,68.89,68.70,68.13,67.50,67,66.70,66.36,66.37,65.75,65.76,65.86,65.96,64,62,57,57,55,52,50,47.98,47.98,47,45.98,45,44,44,42.74,41.39,39.83,38.87,38.36,38.12,37.87,37.33,36.40,35.46,34.25,32.98,31.62,30.27,29.12,28.09,27.10,26.12,25.37,24.87,24.95,24.01,23.98,22.98,22.98,22,22,22,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20,20,20,20,20,20,20,20,20,20,20,20,20,20.50,20.62,20.62,20.50,20.36,20.20,20.09,20,19.83,18.09,22.98,22.98,22,21.49,21.49,20.49,20.49,20,19.50,18.49,17,17,16.49,15.98,15.49,15,15,14.95,14.08,14,14,14,14.10,14.37,14.50,14.50,14.40,14.10,13.98,13.83,13.17,13.24,13.85,14.72,15.75,16.64,17.25,17.60,17.74,17.75,17.66,17.52,17.37,17.22,17.10,17,16.99,16.98,16.98,16.49,15.98,15.98,15.98,15.98,16.49,16.98,16.98,16.99,17,17,17.04,17.24,17.99,18.74,19.26,19.73,19.90,19.96,19.99,20.15,20.34,20.50,20.61,20.89,21,21.49,21.49,22,22,22,22.98,22.98,22.98,23.49,24,25,25,25.98,25.98,25.98,27,27,27,27.49,27,27,27,27,27.98,27.98,30,30,30.98,32,32.01,32.75,33.38,34.09,34.84,35.63,36.59,37.59,38.63,39.76,40.98,42.22,43.50,44.90,46.63,48.88,51.77,52.12,53.45,54.50,52,41.49,41.49,39,36.49,35,35,35,35,35,35,35,35,35,35,35,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34.50,35,35.98,35.98,36.49,36.49,36.49,36.49,36.49,36.49,37,37,37,37,37.49,37.98,38.49,40,40,40.98,42,43.49,51.49,51.49,54.50,55.49,55.98,57,57,57,57,57.12,57.25,57.37,57.50,57.88,58.62,59.38,60.12,60.10,60.12,60.12,60.12,60.25,60.37,60.60,60.87,61.20,61.57,61.95,62.35,62.75,63.13,63.62,64.15,65.12,66.75,68.47,69.74,69.75,69.40,68.89,68.50,68.15,67.87,67.45,67.12,66.96,66.86,65.95,64,62,57.49,57.49,55,52.49,51,48.99,48.99,48,46.49,45.49,44.50,44.50,43.49,42.37,41.11,40.01,39.34,38.95,38.50,37.83,36.88,35.87,34.74,33.40,32.08,30.76,29.63,28.62,27.71,26.75,25.95,25.37,24.97,24.49,23.96,23,22.98,22.49,22,22,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.49,20,20,20,20,20,20,20,20,20,20,20,20,20.01,20.10,20.12,20.12,20.11,20,20,20,19.83,18.12,22.98,22.98,22,22,22,20.98,20.98,20,20,19,17,17,17,15.98,15.98,15,15,14.98,14,14,14,14.07,14.01,14.95,14.97,14.98,14.95,14.11,14.11,13.83,13.39,13.50,13.90,14.62,15.50,16.37,17.09,17.57,17.84,17.95,17.92,17.84,17.66,17.47,17.25,17.08,17,16.98,16.98,17,15.98,15.98,15.98,15.98,17,17,16.99,16.99,16.99,16.99,17.01,17.21,17.87,18.75,19.20,19.75,19.98,20.03,20.14,20.17,20.82,20.86,20.98,21.01,20.98,22,22,22,22,22,22.98,22.98,22.98,24,24,25,25,25.98,25.98,25.98,27,27,27,27.98,27,27,27,27,27.98,27.98,30,30,30.98,32,32.09,32.70,33.37,34.09,34.85,35.64,36.58,37.52,38.61,39.71,40.85,42.01,43.25,44.64,46.37,48.65,51.75,52,52.87,54,52,42,42,39,37,35,35,35,35,35,35,35,35,35,35,35,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,35,35,35.98,35.98,37,37,37,37,37,37,37,37,37,37,37.98,37.98,39,40,40,40.98,42,42.98,50.98,50.98,55,55.98,55.98,57,57,57,57.12,57.20,57.74,57.82,58,58.46,59.37,60.33,61.14,61.37,61.37,61.25,61.21,61.21,61.26,61.49,61.75,62.12,62.50,62.88,63.26,63.64,64.01,64.40,64.87,65.57,67,68.47,69.72,70.12,70.15,69.87,69.51,69.20,68.84,68.33,68.15,68,67.85,66,64,62,57.98,57.98,55,52.98,52,50,50,49,47,45.98,45,45,44,42.98,41.89,40.50,40.07,39.58,38.89,38.21,37.36,36.37,35.24,33.88,32.50,31.20,30.09,29.13,28.24,27.25,26.39,25.73,25.24,24.87,23.89,23,22.96,22.98,22,22,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,19.84,18.25,22.98,22.98,22.98,22,22,22,22,20.98,20.98,20,17.98,17.98,17,17,15.98,15,15,15,14,14,14,14,15,15,15,15,14.95,14.88,14.13,14,13.76,13.71,13.92,14.41,15.14,15.98,16.75,17.37,17.82,18.04,18.13,18.09,17.91,17.70,17.38,17.14,17.01,17,16.99,17,15.98,15.98,15.98,15.98,17,17,17,16.99,16.99,17,17.02,17.15,17.79,18.15,19.09,19.79,20.09,20.16,20.15,20.84,20.86,21.04,21.01,22,22,22,22,22,22,22,22.98,22.98,22.98,24,24,25,25,25.98,25.98,25.98,25.98,25.98,27,27,27.98,27.98,27.98,27.98,27.98,27.98,30,30,30.98,32,31.99,32.52,33.34,34.02,34.82,35.62,36.51,37.50,38.50,39.58,40.65,41.84,43,44.32,45.86,47.83,50.62,51.14,52.11,54,52,42.98,42.98,40,37,35.98,35,35,35,35,35,35,35,35,35,35,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,35,35,35,35,35.98,37,37,37,37,37,37,37,37,37,37,37.98,37.98,37.98,39,40,40,40,40.98,42,42.98,50.98,50.98,55,55.98,57,57.98,57.98,58,58.01,58.12,58.25,58.25,58.33,59,59.98,61.23,62.25,62.50,62.49,62.32,62.13,62.12,62.25,62.45,62.72,63.02,63.50,63.89,64.35,64.75,65.12,65.50,65.87,66.34,67.40,68.52,69.71,70.50,70.87,70.85,70.50,70.14,69.96,69.74,69.23,69.11,68.87,66.99,65,62.98,59,59,55.98,54,52.98,50,50,49,47.98,45.98,45,45,45.98,44,42.98,41,40.75,40.12,39.35,38.50,37.75,36.87,35.83,34.50,33,31.64,30.57,29.70,28.76,27.75,26.87,26.12,25.64,24.87,24.11,23.09,23,22.98,22.98,22,22,22,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,19.85,18.45,24,24,22.98,22.98,22.98,22,22,22,20.98,20.98,19,19,17.98,17,17,15.98,15.98,15,15,14,14,14,15,15,15,15,14.99,14.89,14.86,14.16,14.04,13.88,13.91,14.23,14.77,15.51,16.32,17.04,17.65,18.08,18.26,18.27,18.15,17.92,17.64,17.15,17.12,17.09,17.01,17,17,17,15.98,15.98,17,17,17,17,17.01,17.07,17.10,17.12,17.85,18.12,18.87,19.86,20.13,20.85,20.87,21.08,21.03,21,22,22,22,22,22,22,22,22,22.98,22.98,22.98,24,24,25,25,25,25,25.98,25.98,25.98,27,27,27.98,27.98,27.98,27.98,27.98,29,30,30,30,30.98,31.09,32.50,33.34,34,34.76,35.62,36.50,37.38,38.37,39.38,40.49,41.61,42.74,43.88,45.15,46.70,49.61,50.20,51.84,52.98,52,44,44,40,37.98,37,35,35,35,35,35,35,35,35,35,35,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,35,35,35.98,35.98,37,37.98,37.98,37.98,37.98,37.98,37.98,37.98,37.98,37.98,37.98,37.98,37.98,39,39,40,40,40,40.98,42,42.98,50,50,54,55.98,57,59,59,59.10,59.20,59.24,59.12,59.13,59.36,59.37,60.72,62.34,63.50,63.62,63.50,63.25,63.10,63.09,63.23,63.47,63.75,64.12,64.57,65,65.50,65.96,66.38,66.83,67.22,67.64,68.37,69.12,70.14,71.02,71.76,72.07,71.75,71.50,71.25,71.23,71,70.13,69.87,68,65.98,65,60,60,57,55,54,50.98,50.98,50,47.98,47,45.98,45.98,45.98,45,44,42.07,41.64,40.50,39.62,38.84,38.25,37.63,36.82,35.58,33.87,32.37,31.15,30.37,29.50,28.37,27.37,26.50,25.87,25.21,24.15,23.87,23.87,23,22.98,22.98,22,22,22,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,19.86,18.64,24,24,24,24,24,24,24,24,22.98,22,20,20,20,19,17.98,17,17,15.98,15,15,15,15,15,15,15.98,15,14.99,14.98,14.87,14.83,14.28,14.02,13.95,14.08,14.48,15.10,15.87,16.66,17.40,17.98,18.33,18.41,18.36,18.16,17.92,17.83,17.86,17.89,17,17,17,17,17,17,17,17,17,17,17,17.98,17.95,17.91,17.89,18.07,18.08,19.89,20.09,20.89,21.02,21.97,22,22,22,22,22,22,22,22,22,22,22.98,22.98,22.98,22.98,22.98,24,24,25,25,25.98,27,27,27,27,27.98,27.98,27.98,29,29,29,29,29,29,30,31.11,32.75,33.34,34,34.77,35.62,36.47,37.32,38.23,39.22,40.25,41.37,42.48,43.52,44.62,45.52,47.63,48.34,50.25,51.95,52,45.98,45.98,42,40,39,37,37,35.98,35,35,35,35,35,35,35,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,35.98,35.98,37,37,37.98,40.98,40.98,40,39,39,39,39,39,39,39,39,39,39,39,40,40,40,40.98,42,42.98,49,49,50.98,54,55.98,59,59,60.85,60.75,60.71,60.01,60.09,60.60,60.87,62.12,64.37,64.46,64.87,64.37,64.08,63.95,63.99,64.20,64.48,64.75,65.22,65.72,66.20,66.70,67.22,67.72,68.14,68.59,69,69.50,70.12,70.90,71.82,72.83,74.25,73.50,73.71,73.74,73.75,73.82,71.11,70.87,69.98,67.98,67,62,62,60.98,59,57,52,52,50.98,50,49,47,47,47,45.98,45.98,42.13,41.59,40.77,39.98,39.34,38.97,38.51,37.82,36.59,34.77,33.22,31.97,31.12,30.22,29,27.87,26.90,26.25,25.57,24.87,24.14,24,23.88,23.99,22.98,22,22,22,22,22,20.98,20.98,20.98,20.98,20.98,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,19.87,18.99,24.50,24.50,24,24,24,24,24,24,22.98,22,20.49,20.49,20,19,17.98,17,17,15.98,15.49,15,15,15,15,15,15.49,15,14.99,14.99,14.97,14.84,14.50,14.15,14,14,14.26,14.75,15.47,16.25,17.09,17.78,18.27,18.50,18.50,18.37,18.20,18.04,17.97,17.91,17.48,17,17,17,17,17,17,17,17,17,17.49,17.98,17.98,17.98,17.98,17.98,17.98,19.50,19.50,20.49,20.98,22,22,22,22,22,22,22,22,22,22,22,22.98,22.98,22.98,22.98,22.98,24,24,25,25,25.98,27.49,27.49,27.49,27.49,27.98,27.98,27.98,29,29,29,29,29,29.50,30,31.09,32.75,33.24,33.99,34.83,35.63,36.46,37.22,38.01,39,40.09,41.22,42.25,43.32,44.35,45.58,47.49,48.37,49.75,51.37,52.46,46.49,46.49,43,40.49,39.50,37.49,37.49,36.49,35.49,35,35,35,35,35,35,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34.50,35.98,35.98,37,37,37.98,40.98,40.98,40.49,39.50,39,39,39,39,39,39.50,39.50,39.50,39.50,39.50,40,40.49,40.49,40.98,42,42.98,49.50,49.50,51.49,54,55.98,59,59,60.84,61.25,60.98,60.73,60.85,61.13,61.85,62.87,64.60,65.01,65.12,64.88,64.72,64.62,64.75,65,65.36,65.72,66.14,66.73,67.33,67.87,68.45,68.90,69.39,69.86,70.23,70.70,71.12,71.75,72.60,73.75,75.11,74.76,74.50,74.48,74.26,73.84,71.59,71.45,70.48,68.49,67,63,63,61.98,59.50,57.49,52.49,52.49,51.49,50.49,49,47.49,47.49,47,45.98,45.98,42.37,41.65,41.07,40.45,40.08,39.85,39.49,38.75,37.50,35.73,34.09,32.83,31.90,30.87,29.57,28.34,27.32,26.62,25.96,25.32,24.71,24.35,24.10,23.97,22.98,22.49,22.49,22,22,22,20.98,20.98,20.98,20.98,20.98,20.49,20.49,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,19.87,19.36,25,25,24,24,24,24,24,24,22.98,22,20.98,20.98,20,19,17.98,17,17,15.98,15.98,15,15,15,15,15,15,15,15,14.99,14.95,14.79,14.54,14.26,14.08,14.01,14.15,14.51,15.11,15.86,16.70,17.49,18.12,18.47,18.54,18.50,18.41,18.10,18.07,18.01,17.98,17,17,17,17,17,17,17,17,17,17.98,17.98,17.98,17.98,17.98,17.98,17.98,19,19,20,20.98,22,22,22,22,22,22,22,22,22,22,22,22.98,22.98,22.98,22.98,22.98,24,24,25,25,25.98,27.98,27.98,27.98,27.98,27.98,27.98,27.98,29,29,29,29,29,30,30,31.09,32.77,33.22,34,34.87,35.73,36.48,37.12,37.85,38.75,39.89,41.11,42.21,43.13,44.23,45.58,47.46,48.15,49.32,51.01,52.87,47,47,44,40.98,40,37.98,37.98,37,35.98,35,35,35,35,35,35,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,35,35.98,35.98,37,37,37.98,40.98,40.98,40.98,40,39,39,39,39,39,40,40,40,40,40,40,40.98,40.98,40.98,42,42.98,50,50,52,54,55.98,59,59,60.85,61.75,61.25,61.25,61.34,61.97,62.37,63.37,64.60,65,65.12,65.20,65.25,65.33,65.50,65.75,66.09,66.62,67.10,67.84,68.37,69,69.36,70.09,70.12,70.99,71.20,71.22,71.97,72.25,73.23,74.25,75.72,75.25,75.21,75.13,74.97,73.97,72.07,71.98,70.98,69,67,64.25,63.50,62.25,60.25,57.37,53.75,53.12,52.12,50.75,49,47.98,47.98,47,45.98,45.98,42.50,42.36,41.85,41.27,41,40.75,40.33,39.47,38.12,36.46,34.90,33.71,32.70,31.50,30.01,28.73,27.71,27,26.35,25.72,25.12,24.82,24.12,23.96,23,22.98,22.98,22,22,22,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,19.95,19.95,25,25,24,24,24,24,24,22.98,22.98,22.98,20.98,20.98,20.98,20,19,17,17,17,15.98,15.98,15,15,15,15,15,15,15,15.04,14.99,14.83,14.61,14.37,14.17,14.09,14.13,14.37,14.83,15.47,16.25,17.04,17.77,18.24,18.41,18.50,18.54,18.89,18.95,17.99,17.98,17.98,17,17,17,17,17,17,17,17,17,17.98,17.98,17.98,17.98,17.98,17.98,19,19,20,20,20.98,20.98,20.98,20.98,22,22,22,22,22,22,22,22.98,22.98,22.98,24,24,25,25,25,25.98,25.98,27.98,27.98,27.98,27.98,27.98,27.98,27.98,27.98,29,29,30,30,30.98,30.98,31.97,32.83,33.20,34.12,34.96,35.82,36.50,37.09,37.64,38.57,39.75,41.25,42.12,43,44.02,45.37,46.59,47.39,49.20,50.98,52.87,49,49,45.98,42.98,40.98,39,39,37.98,37,35.98,35,35,35,35,35,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,35,35,35,35,35,35.98,35.98,37,37,37.98,40,40,40,40,39,39,39,40,40,40,40,40,40,40,40,40.98,40.98,40.98,42,44,52,52,54,55,55.98,59,59,60.12,61.10,61.74,61.87,62.24,62.82,63.62,64.60,64.87,65.12,65.34,65.32,65.85,66.11,66.21,66.50,66.75,67.64,68.37,69.24,69.63,70.22,70.98,71.96,71.88,72.12,72.77,73,73.20,73.21,74.14,75.12,75.77,76.12,76.01,76,75.86,75.87,73,72.97,70.98,70,67.82,65.74,64.47,63,61.11,58.49,56.12,54.25,52.95,51.37,49.72,47.98,47.98,47,45.98,45,44.32,43.58,42.98,42.36,41.98,41.74,41.22,40.37,39,37.40,35.88,34.62,33.49,32.21,30.63,29.34,28.27,27.60,26.77,25.89,25.24,24.88,24.86,23.99,23,22.98,22.98,22.98,22,22,22,22,20.98,20.98,20.98,20.98,20.98,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,24,24,24,24,24,22.98,22.98,22.98,22.98,22.98,22,22,20.98,20,19,17.98,17.98,17,17,15.98,15.98,15.98,15.98,15.98,15.26,15.33,15.25,15.22,15.10,14.92,14.72,14.50,14.29,14.16,14.14,14.26,14.59,15.09,15.75,16.50,17.16,17.71,18.04,18.29,18.60,18.91,18.97,19,17.98,17.98,17,17,17,17,17,17,17,17,17,17.98,17.98,17.98,17.98,17.98,17.98,19,19,19,20,20,20.98,20.98,20.98,22,22,22,22,22,22,22,22.98,22.98,22.98,24,24,25,25,25,25.98,27,27.98,27.98,27.98,27.98,27.98,27.98,27.98,27.98,29,29,30.98,30.98,30.98,32,32.01,33.87,34.11,34.24,35.11,35.87,36.58,37.11,37.62,38.48,39.65,41.26,41.87,42.73,43.75,44.95,46.47,47.26,48.71,50.75,52.86,52,52,47.98,45,42.98,40.98,40.98,40,39,37,35,35,35,35,35,35,35,35,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,35,35,35,35,35,35,35,35.98,35.98,35.98,37,37,37.98,39,39,39,40,40,40,40,40,40,40.98,40.98,40.98,40.98,40.98,40.98,40.98,40.98,42,42.98,45,52.98,52.98,55.98,55.98,57,59,59,60.09,61,61.96,62.70,63.20,63.33,64.87,65.75,65.36,65.35,66.25,66.25,67.11,67.12,67.09,67,67.98,67.98,70.98,70.98,70.98,72,72,72.98,73,74.08,74.12,75.12,75.13,75.15,75.15,76.13,77.14,77.13,77.12,77.10,76.90,75.96,74,74,72.98,71.26,69.25,67.08,65.62,64.12,62.23,59.82,57.50,55.64,54,52.14,50.22,48.37,47.98,47,45,44,45.49,45.12,44.50,43.87,43.39,43.12,42.50,41.71,40.34,38.63,36.98,35.50,34.27,33,31.49,30.20,29.13,28.38,27.52,26.25,25.25,25.20,24.97,24.07,23.96,22.98,22.98,22.98,22,22,22,22,22,20.98,20.98,20.98,20.98,20.98,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,24,24,24,22.98,22.98,22.98,22.98,22.98,22,22,20.98,20.98,20.98,20,20,18.99,18.59,17.98,17.50,17.32,16.50,16.09,16,15.87,15.75,15.63,15.61,15.50,15.33,15.12,14.88,14.64,14.42,14.26,14.20,14.22,14.38,14.74,15.26,15.88,16.51,17.08,17.51,17.96,18.42,18.96,19,19,19,19,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,19,20,20.98,20.98,20.98,22,22,22.98,22.98,22.98,22.98,22.98,22.98,22.98,24,24,24,25.98,25.98,25.98,27,27,29,29,29,29,29,29,29,29,30,30,32,32,32,32.98,34,34.88,34.85,34.86,35.24,35.98,36.62,37.15,37.75,38.50,39.59,40.62,41.52,42.35,43.32,44.50,45.63,46.36,48,49.20,51.11,52.98,52.98,54,54,54,50,50,49,47,44,39,39,37,35.98,35.98,35,35,35,35,35,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35.98,35.98,35.98,36.98,37.88,38.09,39.87,40.11,40.88,40.96,40.98,42,41.75,42.21,41.70,41.73,41.82,41.76,41.76,42,42,42.98,42.98,44,45,47,55,55,57,57.98,59,60,60,60,61.11,62.20,63.75,64.01,64.95,66.63,66.89,68.63,68.64,68.72,68.75,68.76,68.87,68.96,70,70,70.98,72.98,72.98,74,75,75.98,77,77,77.96,77.89,78.88,78.87,78.87,78.87,78.87,79.87,78.87,78.89,78.96,77.96,76.99,75.98,75.98,74.75,72.75,70.87,68.50,66.62,65.08,63.22,60.87,58.72,56.83,55,53.07,50.96,48.72,48.23,47.98,47,47,46.40,46.23,45.75,45.32,44.90,44.59,43.87,42.99,41.52,39.70,37.84,36.25,35.09,33.85,32.48,31.24,30.22,29.37,28.49,27.71,26.22,25.75,25.84,25.08,24.96,24,24,22.98,22.98,22.98,22,22,22,22,22,20.98,20.98,20.98,20.98,20.98,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,24,24,23.49,22.98,22.98,22.98,22.98,22.98,22,22,20.98,20.98,20.98,20,19.63,19.33,18.62,18.32,17.97,17.48,16.98,16.32,16.21,16.12,16,16,15.88,15.82,15.59,15.35,15.09,14.83,14.59,14.38,14.25,14.17,14.25,14.46,14.83,15.33,15.86,16.37,16.89,17.50,18.17,18.99,19,19,19,19,18.49,18.49,17.98,17.98,17.98,17.98,17.98,17.98,17.98,18.49,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,19,19.50,20.49,20.49,20.98,21.49,22,22.49,22.49,22.98,22.98,22.98,22.98,22.98,24,24,24.50,25.98,25.98,26.49,27,27,28.49,28.49,28.49,29,29,29.50,29.50,29.50,30,30.49,32.49,32.49,32.49,33.49,34,34.96,34.98,35.12,35.50,36.10,36.65,37.25,37.86,38.60,39.50,40.37,41.21,41.96,42.82,43.99,45.50,46.26,47.35,48.63,50.61,52.98,52.98,54,54.50,54.99,52.50,52.50,51.50,48.99,44.99,39.50,39.50,37.49,36.49,35.98,35.49,35.49,35.49,35,35,34.50,34.50,34,34,34,34,34,34,34,34,34,34,34,34,34,35,35,35,35,35,35,35,35,35,35,35,35,35,35.49,35.98,35.98,35.98,36.96,37.85,38.62,40.83,41.12,41.85,41.88,41.49,42.47,42.73,42.83,42.85,42.75,42.73,42.65,42.59,42.49,42.49,43.49,43.49,44.50,46,48.50,55.49,55.49,57,58.49,59.50,60.25,60.50,60.87,61.62,62.82,63.87,64.86,65.84,66.76,67.75,69.23,69.75,70.25,70.11,69.98,69.97,69.99,70.49,71,71.98,73.99,73.99,74.99,76,76.98,78,78,78.99,79.48,80.49,80.97,80.97,80.50,80.50,80.97,80,79.97,79.49,78.49,77.49,76.49,76.49,75.49,73.84,71.45,69.25,67.37,65.73,63.84,61.74,59.62,57.75,55.87,53.99,51.95,50.25,49.25,48.62,48.12,47.49,47.14,46.82,46.62,46.57,46.37,46,45.23,44.13,42.57,40.40,38.48,36.88,35.87,34.70,33.37,32.22,31.21,30.36,29.50,28.63,26.72,26.33,25.97,25.57,25.45,24,24,23.49,22.98,22.98,22,22,22,22,22,20.98,20.98,20.98,20.98,20.98,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,24,24,22.98,22.98,22.98,22.98,22.98,22.98,22,22,20.98,20.98,20.98,20.33,19.62,19.26,18.70,18.26,17.95,17.57,17.12,16.72,16.48,16.36,16.34,16.32,16.25,16.12,15.87,15.62,15.26,15.01,14.75,14.51,14.32,14.20,14.16,14.25,14.48,14.84,15.25,15.70,16.20,16.85,17.98,19,19,19,19,19,19,19,17.98,17.98,17.98,17.98,17.98,17.98,17.98,19,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,19,19,20,20,20.98,20.98,22,22,22,22.98,22.98,22.98,22.98,22.98,24,24,25,25.98,25.98,27,27,27,27.98,27.98,27.98,29,29,30,30,30,30,30.98,32.98,32.98,32.98,34,34,35,35,35.11,35.83,36.10,36.70,37.27,37.88,38.62,39.50,40.37,41,41.50,42.37,43.39,45.62,46,46.87,48.12,50.11,52.98,52.98,54,55,55.98,55,55,54,50.98,45.98,40,40,37.98,37,35.98,35.98,35.98,35.98,35,35,35,35,34,34,34,34,34,34,34,34,34,34,34,34,34,35,35,35,35,35,35,35,35,35,35,35,35,35,35.98,35.96,36.02,36.38,37.09,38.09,39.63,41.12,42.40,42.83,42.95,42.72,43.13,43.61,43.84,43.90,43.96,43.87,43.75,43.62,42.98,42.98,44,44,45,47,50,55.98,55.98,57,59,59.87,60.62,61.13,61.58,62.25,63.37,64.47,65.50,66.50,67.50,68.57,69.75,70.20,71.84,71.11,71,70.98,70.98,70.98,72,72.98,75,75,75.98,77,77.98,79,79,80,80.98,82,82.98,82.98,82,82,82,80.98,80.98,80,79,77.98,77,77,76.32,74.37,71.96,69.74,67.83,66.12,64.37,62.39,60.48,58.63,56.87,55,53.20,51.62,50.62,49.97,49.25,48.25,47.48,47.35,47.37,47.50,47.45,47.08,46.20,44.98,43.25,41.10,39.22,37.72,36.75,35.61,34.26,33.12,32.11,31.25,30.37,29.62,27.25,26.88,26.10,26.02,25.90,24,24,24,22.98,22.98,22,22,22,22,22,20.98,20.98,20.98,20.98,20.98,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22,22,22,20.98,20.98,20.75,20.33,19.70,19.25,18.74,18.26,17.97,17.62,17.24,16.96,16.74,16.62,16.60,16.60,16.57,16.47,16.23,15.87,15.51,15.25,14.97,14.65,14.40,14.23,14.12,14.13,14.25,14.42,14.67,15.02,15.33,15.98,17,17.98,17.98,19,19,19,19,19,19,17.98,17.98,17.98,17.98,17.98,17.98,19,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,19,19,20,20,20,20.98,22,22,22,22,22.98,22.98,22.98,22.98,22.98,24,24,25.98,25.98,27,27,27,27.98,27.98,27.98,29,30,30,30,30,30.98,30.98,32.98,32.98,32.98,34,35,35,35,35.01,35.09,35.95,36.75,37.25,37.87,38.62,39.51,40.45,40.87,41.38,42.20,43.37,44.63,45.25,46.14,47.83,49.08,52,52,52.98,54,55.98,57.98,57.98,57,52.98,47.98,40.98,40.98,39,37.98,37,35.98,35.98,35.98,35.98,35,35,35,35,34,34,34,34,34,34,34,34,34,34,34,35,35,35,35,35,35,35,35,35,35,35,35,35,35.98,35.98,36.02,36.25,36.63,37.25,38.25,40.08,42.50,43.50,44.52,43.99,44,44.26,44.72,45.02,45.27,45.47,45.50,45.26,44.97,45,45,45.98,45.98,47,49,52,57,57,57.98,59.25,60.57,61.37,62,62.39,63,64.12,65.12,66.23,67.25,68.37,69.48,70.48,71.10,72.87,72.98,72.98,74,74,72.98,74,75,77,77,77.98,79,80,82,82,82.98,82.98,84,85,85,85.98,85,84,82.98,82.98,80.98,80,79,77.98,77.98,76.46,74.87,72.49,70.25,68.25,66.75,65.07,63.21,61.37,59.62,57.88,56.22,54.59,53.14,52.12,51.25,50.36,49.12,48.48,48.09,48.12,48.36,48.26,47.87,46.95,45.75,44.13,42.13,40.37,38.87,37.77,36.60,35.26,34.12,33.13,32.34,31.36,29.99,28.25,27.82,27.09,26.90,25.90,24,24,24,22.98,22.98,22.98,22.98,22,22,22,22,22,20.98,20.98,20.98,20.98,20.98,20,20,20,20,20,20,20,20,20,20,20,20,20,22.98,22.98,22.98,22.98,22.98,22,22,22,22,22,20.98,20.98,20.62,20.25,19.73,19.23,18.75,18.26,17.97,17.62,17.25,17.01,16.88,16.86,16.82,16.82,16.82,16.74,16.50,16.23,15.87,15.57,15.22,14.85,14.50,14.25,14.10,14,14.07,14.12,14.24,14.21,15,15,15.98,17.98,17.98,19,19,19,19,19,19,19,17.98,17.98,17.98,17.98,17.98,19,19,19,19,19,19,19,19,19,19,19,19,19,20,20.98,20.98,22,22,22,22,22,22,22,22.98,22.98,22.98,25,25,25.98,25.98,27,27.98,27.98,29,29,30,30,30,30.98,30.98,30.98,32.98,32.98,32.98,34,34,35,35,35,35,35.01,36.87,36.97,37.62,38.60,39.34,40.46,40.59,41.12,41.85,42.99,44.58,44.98,45.96,47.12,49,50.98,50.98,52.98,54,55,59,59,57.98,54,49,42,42,40,39,37.98,37,37,35.98,35.98,35.98,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35.98,35.98,35.98,35.98,36.08,36.60,36.97,37.51,38.50,40.32,42.24,43.87,44.77,44.75,45.08,45.52,46.01,46.50,46.95,47.26,47.47,47.37,47.01,45.98,45.98,47.98,47.98,50,50.98,54,57.98,57.98,59.24,60.37,61.46,62.33,62.97,63.38,64.10,64.96,66,67,68.12,69.25,70.57,71.37,72.24,74,75,75,75.98,75.98,75.98,75.98,77,79,79,80,80.98,82,84,84,85,85.98,87,87.98,87.98,87.98,87,85.98,84,84,82.98,82,80.98,77.98,77.98,77,75.46,73.20,70.87,69.20,67.50,65.87,64.12,62.37,60.72,59.10,57.50,55.99,54.62,53.60,52.87,51.70,50.34,49.45,48.89,48.82,48.90,48.83,48.46,47.62,46.61,45.33,43.64,41.99,40.26,38.97,37.64,36.38,35.32,34.46,33.58,32.52,31.13,29.57,28.86,28.07,27.07,26,25,25,24,24,22.98,22.98,22.98,22.98,22,22,22,22,22,20.98,20.98,20.98,20.98,20.98,20.98,20,20,20,20,20,20,20,20,20,20,20,22.98,22.98,22.98,22,22,22,22,22,22,22,20.98,20.98,20.62,20.25,19.75,19.21,18.75,18.26,17.97,17.62,17.26,17.10,17,16.96,16.89,16.95,16.95,16.87,16.75,16.48,16.12,15.76,15.47,15,14.62,14.25,14.07,14,14,14,14,14,14,14,15,17,17,17.98,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,20,20,20.98,20.98,20,20,20,20,20,20,20,20.98,20.98,20.98,22,22,22,22,22,22,22,22,24,24,25,25.98,27,27.98,27.98,27.98,27.98,29,30,30,30,30.98,30.98,32,32,32.98,32.98,34,35,35,35,35,35,35.98,36.07,37.14,38.12,38.98,39.62,40.14,40.50,41.50,42.50,43.64,44.37,45.25,46.87,48,50.98,50.98,52.98,54,55,57,57,57.98,55.98,52,45,45,42,40,39,37,37,37,37,35.98,35.98,35.98,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35.98,37,35.98,35.98,35.98,35.98,35.98,35.98,35.98,35.98,35.98,36.87,36.96,37.27,37.85,38.75,40.34,41.99,43.61,44.27,45.13,46,46.75,47.39,48.02,48.62,49.15,49.63,49.62,49.35,50,50,54,54,55.98,57,57.98,60,60,60.50,61.47,62.48,63.21,63.75,64.37,65.09,65.95,66.88,67.90,68.98,70.08,71.12,72.16,73.34,75,75.98,77.98,80,80,80,82,82,84,84,85,87,87.98,90,90,90,90,90,92,92,90.98,92,90,87,87,85,84,82.98,79,79,77.50,76.08,73.88,71.84,70.09,68.48,66.87,65.12,63.45,61.83,60.25,58.75,57.32,56,54.87,54,52.71,51.25,50.25,49.50,49.12,49.11,49,48.75,48.20,47.40,46.40,44.96,43.32,41.51,40.09,38.74,37.50,36.50,35.63,35.12,33.70,32.87,31.01,30.37,28.75,27.90,26.98,25,25,25,24,24,22.98,22.98,22.98,22.98,22.98,22,22,22,22,22,20.98,20.98,20.98,20.98,20.98,20,20,20,20,20,20,20,20,20,20,22.98,22.98,22.49,22,22,22,22,22,22,22.49,20.98,20.98,20.62,20.24,19.75,19.21,18.75,18.26,17.97,17.62,17.26,17.10,17,16.99,16.98,16.98,16.98,16.97,16.85,16.61,16.25,15.89,15.60,15.12,14.72,14.26,14.09,14,14,14,14,14,14,14,15,17,17,17.98,19,19,19,19,19,19,19,19,19,19,19,19,19.50,19.50,19.50,20,20,20.98,20.98,20,20,20,20,20,20,20,20.98,21.49,21.49,22,22,22.49,22.49,22.49,22.49,22.49,22.49,24,24,25,25.98,27,27.98,27.98,27.98,27.98,28.49,29.50,29.50,30,30.49,30.98,32,32,32.98,32.98,33.49,34.50,34.50,34.50,34.50,34.50,35.96,36,36.86,37.73,38.48,39.12,39.74,40.37,41.25,42.37,43.50,44.36,45.26,46.76,48.10,50.89,50.98,52.49,53.49,54.50,57,57,57.49,56.49,53.50,46,46,42.49,40.49,39,37.49,37.49,37,37,36.49,35.98,35.98,35.49,35.49,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35.98,37,36.49,36.49,36.49,35.98,35.98,35.98,35.98,35.98,36.49,36.89,37.27,37.62,38.13,39,40.33,41.76,43.12,44.11,45.38,46.75,47.90,48.75,49.52,50.25,50.87,51.46,51.62,51.47,51,51,54.50,54.50,56.98,58.50,58.99,60.49,60.50,61.47,62.38,63.23,63.98,64.62,65.26,66,66.86,67.79,68.79,69.82,70.85,71.87,72.90,73.99,75.16,76.49,78.49,80.49,80.49,81,82.49,83,85.50,85.50,86.49,88.50,89.48,90.49,90.49,90,89.50,89.50,91.49,91.49,91.98,92.49,90.49,87.49,87.49,86,84.50,83.49,79.50,79.50,78.21,76.63,74.70,72.63,70.99,69.37,67.83,66.12,64.46,62.87,61.37,59.87,58.50,57.13,55.98,55,53.63,52.01,50.76,49.86,49.33,49.09,49.07,49,48.82,48.25,47.37,45.87,44.23,42.46,41.01,39.73,38.51,37.50,36.62,35.64,34.75,33.21,31.85,30.48,29.25,28.01,27,25.49,25.49,25,24.50,24,22.98,22.98,22.98,22.98,22.98,22,22,22,22,22,20.98,20.98,20.98,20.98,20.98,20.49,20.49,20,20,20,20,20,20,20,20,22.98,22.98,22,22,22,22,22,22,22,22.98,20.98,20.98,20.62,20.23,19.75,19.21,18.75,18.26,17.97,17.62,17.26,17.10,17,16.99,16.99,16.99,16.99,16.99,16.87,16.62,16.32,15.98,15.62,15.21,14.75,14.33,14.11,14,14,14,14,14,14,14,15,17,17,17.98,19,19,19,19,19,19,19,19,19,19,19,19,20,20,20,20,20,20.98,20.98,20,20,20,20,20,20,20,20.98,22,22,22,22,22.98,22.98,22.98,22.98,22.98,22.98,24,24,25,25.98,27,27.98,27.98,27.98,27.98,27.98,29,29,30,30,30.98,32,32,32.98,32.98,32.98,34,34,34,34,34,35.89,35.98,36.86,37.25,38.12,38.85,39.48,40.20,41.12,42.48,43.59,44.37,45.25,46.75,48.12,50.87,51,52,52.98,54,57,57,57,57,55,47,47,42.98,40.98,39,37.98,37.98,37,37,37,35.98,35.98,35.98,35.98,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35.98,37,37,37,37,35.98,35.98,35.98,35.98,35.98,37,37.08,37.51,37.98,38.46,39.22,40.34,41.62,42.89,43.95,45.62,47.37,48.86,50.12,51.02,51.75,52.37,52.87,53,52.98,52,52,55,55,57.98,60,60,60.89,61.07,62.14,63.29,64.17,64.91,65.58,66.22,66.95,67.78,68.72,69.70,70.67,71.67,72.67,73.65,74.62,75.50,77.25,79,80.98,80.98,82,82.98,84,87,87,87.98,90,90.98,90.98,90.98,90,89,89,90.98,90.98,92.98,92.98,90.98,87.98,87.98,87,85,84,80,80,79.10,77.47,75.38,73.48,71.75,70.25,68.73,67,65.37,63.84,62.37,60.96,59.57,58.21,56.89,55.62,54.25,52.58,51.12,50,49.37,49.25,49.23,49.25,49.37,49.01,48.12,46.49,44.82,43.24,41.87,40.62,39.45,38.36,37.35,36.36,35.12,33.71,32.22,30.72,29.60,28.37,27.14,25.98,25.98,25,25,24,22.98,22.98,22.98,22.98,22.98,22,22,22,22,22,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20,20,20,20,20,20,20,20,22,22,22,22,22,22,22,22,22.98,22,20.98,20.98,20.62,20.22,19.75,19.21,18.75,18.26,17.97,17.62,17.26,17.10,17,16.99,16.99,16.99,16.99,16.99,16.87,16.62,16.32,15.99,15.63,15.25,14.75,14.37,14.09,14,14,14,14,14,14,14,15,15.98,15.98,17,19,19,19,19,19,19,19,19,19,19,19,19,20,20,20,20,20,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20,20.98,22,22,22,22.98,22.98,22.98,22.98,22.98,22.98,22.98,24,24,25,25.98,25.98,27,27,27.98,27.98,27.98,27.98,27.98,29,30,30.98,32,32,32,32.98,32.98,32.98,32.98,32.98,32.98,34,34.95,35.10,36.12,37.20,38.01,38.75,39.37,40.08,41.01,42.37,44.59,44.62,45.62,46.25,47.96,49.87,50.01,50.98,52,52.98,55,55,57,57,57,50,50,45,42,40,37.98,37.98,37.98,37,37,35.98,35.98,35.98,35.98,35.98,35.98,35.98,35.98,35.98,35.98,35.98,35.98,35.98,35.98,35.98,35.98,35.98,35.98,35.98,37,37,37,37,37,37,37,37,37,37,37,37.99,38.39,38.74,39.32,40.34,41.50,42.72,43.95,45.74,47.65,49.38,50.88,52,52.76,53.32,53.58,53.75,54,54,54,57,57,59,60.98,61,62,62.12,63.50,64.50,65.33,66.01,66.63,67.25,67.96,68.76,69.67,70.62,71.60,72.58,73.57,74.52,75.47,76.62,78.13,80.15,82,82,82.98,84,85.98,89,89,90.98,90.98,90.98,89,89,87.98,87.98,87.98,90,90,92,92,92.98,90,90,89,87,85.98,82,82,80.25,78.51,76.33,74.37,72.60,71.14,69.62,67.88,66.25,64.75,63.36,61.97,60.60,59.25,57.90,56.57,55,53.33,51.77,50.61,49.88,49.50,49.45,49.62,49.87,49.73,48.83,47.25,45.62,44.11,42.76,41.50,40.26,39.12,38,36.87,35.62,34.20,32.52,31.23,30.13,29.08,27.77,26.02,25.98,25.98,25,24,24,24,22.98,22.98,22.98,22.98,22.98,22,22,22,22,22,20.98,20.98,20.98,20.98,20.98,20.98,20,20,20,20,20,20,20,22,22,22,22,22,22,22,22.98,22,22,20.98,20.98,20.62,20.22,19.75,19.21,18.75,18.26,17.97,17.62,17.26,17.10,17,16.99,16.99,16.99,16.99,16.99,16.87,16.62,16.32,16,15.73,15.37,14.97,14.62,14.25,14,14,14,14,14,14,15,15,15.98,15.98,17,17.98,17.98,19,19,19,19,19,19,19,19,19,19,20,20,20,20,20,20.98,20.98,20.98,20.98,22,22,22,20.98,20.98,20.98,20.98,20.98,22,22,22.98,22.98,22.98,22.98,22.98,22.98,24,24,25,25,25.98,27,27,27,27,27,27.98,27.98,29,30,30,32,32,32,32,32,32,32,32.98,32.98,34,34.89,35.11,36.14,37.25,38.33,39.21,39.38,40.12,40.84,42,43.57,43.95,44.62,45.62,46.87,48.75,49,49.87,50.85,52.11,54.87,54.95,55.96,57,57,52,52,47,42.98,40.98,39,39,37.98,37.98,37,37,37,35.98,35.98,35.98,35.98,35.98,35.98,35.98,35.98,35.98,35.98,35.98,35.98,35.98,35.98,35.98,35.98,35.98,37,37,37,37,37,37,37,37,37,37,37.98,39,39,39,39,40,42,42.63,43.90,45.64,47.73,49.82,51.59,52.52,53.73,54,54,54,55,55,55.98,59,59,60,61.99,63.07,63.87,64.32,65.12,65.92,66.62,67.25,67.79,68.37,69.02,69.82,70.67,71.60,72.54,73.52,74.51,75.50,76.58,77.83,79.41,81.48,83.82,84,85,85.98,87,90.98,90.98,90.98,90.98,90,87.98,87.98,87,87,87,87.98,87.98,90,92,92,92,92,90,89,87.98,84,84,82,80.12,77.74,75.10,73.75,72.22,70.50,68.75,67.12,65.63,64.27,62.97,61.62,60.26,58.99,57.58,55.97,54.33,52.50,51.59,50.50,49.50,49.52,50.07,50.36,50.25,49.60,48.25,46.72,45.21,43.82,42.46,41.12,39.87,38.65,37.49,36.21,34.83,33.40,32.10,31,29.96,28.62,27.25,27,25.98,25,25,24,24,24,22.98,22.98,22.98,22.98,22.98,22,22,22,22,22,20.98,20.98,20.98,20.98,20.98,20.98,20,20,20,20,20,20,22,22,22,22,22,22,22,22,22,22,20.98,20.98,20.62,20.22,19.75,19.21,18.75,18.26,17.97,17.62,17.26,17.10,16.99,16.99,16.99,16.99,16.99,16.99,16.87,16.62,16.32,16.01,15.82,15.50,15.14,14.87,14.97,15,14,14,14,14,14,15,15.98,15.98,15.98,17,17,19,19,19,20,20,20,20,20,20,20,20,20,20,20,20.98,20.98,22,22,22,22,22.98,22.98,22.98,22,20.98,20.98,20.98,20.98,22,22,22.98,22.98,22.98,24,24,24,24,24,24,25,25,25,25,25,25,25.98,27.98,27.98,29,29,30,30.98,30.98,30.98,30.98,30.98,32,32,32.98,32.98,34,34.89,35.11,36.75,37.63,38.82,40.57,40.50,40.21,40.47,41.35,42.09,42.38,43.37,44.38,45.37,46.98,47.25,48.14,49.21,50.20,52.09,52.12,53.07,55,55.98,54,54,49,45.98,42.98,40.98,40.98,40,39,37.98,37.98,37.98,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37.98,37.98,37.98,37.98,37.98,37.98,37.98,37.98,37.98,39,39,39,40,40,40.98,42,42.62,43.75,45.37,47.33,49.25,50.87,51.98,52,52.98,54,54,55,57,59,62,62,62.98,63.95,64.87,66.78,66.39,66.83,67.41,67.97,68.49,68.97,69.49,70.10,70.84,71.65,72.57,73.50,74.50,75.50,76.52,77.62,78.95,80.62,82.75,85.58,86.01,87.98,89,90.98,92,92,90.98,89,87,85.98,85.98,85.98,85.98,85.98,85.98,85.98,85.98,87,89,92,92,90.98,90.98,90.98,87,87,84,82,79.61,76.72,75,73.25,71.39,69.62,67.97,66.50,65.22,63.95,62.62,61.34,60,58.62,56.98,55.32,53.76,52.50,51.49,50.75,50.47,50.50,50.75,51.11,50.75,49.48,47.87,46.37,44.88,43.40,42,40.62,39.37,38.12,36.87,35.59,34.25,33,31.95,30.87,29.60,28.50,27.98,27,27,25.98,25,25,24,24,24,22.98,22.98,22.98,22.98,22.98,22,22,22,22,22,20.98,20.98,20.98,20.98,20.98,20,20,20,20,20,22,22,22,22,22,22,22,22,22,22,20.98,20.98,20.71,20.25,19.75,19.21,18.75,18.26,17.97,17.62,17.26,17.10,16.99,16.99,16.99,16.99,16.99,16.99,16.95,16.62,16.32,16,15.87,15.75,15.45,15,15,15,14.50,14,14,14,14,15,15.98,15.98,15.98,16.49,17,18.49,19,19,19.50,20,20,20,20,20,20,20,20,20,20.49,20.98,20.98,22,22,22,22,22.49,22.49,22.49,22,20.98,20.98,20.98,20.98,22,22,22.49,22.98,22.98,24,24,24,24,24,24,24.50,24.50,25,25,25,25,25.98,27.98,27.98,29,29.50,30,30.49,30.49,30.49,30.98,30.98,32,32,32.98,32.98,34,34.89,35.11,36.75,37.87,39,40.09,40.21,40.12,40.25,40.70,41.24,41.85,42.57,43.71,45.09,46.21,47.12,47.73,48.61,49.84,50.87,51.86,52.62,54,55.46,54.50,54.50,49.99,46.49,43.99,41.49,41.49,40.49,39.50,38.49,38.49,38.49,37.49,37.49,37.49,37,37,37,37,37.49,37.49,37.49,37.49,37.49,37.49,37.49,37.49,37.49,37.49,37.49,37.98,37.98,37.98,37.98,37.98,37.98,37.98,38.49,38.49,39,39.50,39.50,40,40.49,40.98,42,42.59,43.52,45,46.98,48.76,50.25,51.25,52,52.98,54,54,55.49,57,59,62.49,62.49,63.49,64.87,66.12,67.59,67.88,68.23,68.71,69.15,69.58,70,70.47,71.04,71.75,72.57,73.46,74.40,75.41,76.47,77.50,78.62,79.95,81.66,83.74,85.90,86.72,88.49,89.50,90.98,91.49,91.49,89.99,88,86.49,85.49,85.49,85.49,85.49,85.49,85.49,85.49,85.98,86.49,88.49,91,91,90.49,90.49,90.49,87.49,87.49,84.99,82.49,80.49,76.74,75.98,74.24,72.20,70.26,68.62,67.25,66.08,64.87,63.60,62.26,60.99,59.59,57.99,56.26,54.74,53.46,52.46,51.63,51.12,51.01,51.22,51.37,51.37,50.36,49,47.52,46,44.38,42.84,41.37,40.09,38.87,37.62,36.37,35.11,33.88,32.83,31.62,30.37,29.25,28.24,27.49,27,26.49,25,25,24,24,24,22.98,22.98,22.98,22.98,22.98,22,22,22,22,22,20.98,20.98,20.98,20.98,20.98,20,20,20,20,20,22,22,22,22,22,22,22,22,22,22,20.98,20.98,20.89,20.12,19.72,19.21,18.75,18.26,17.97,17.62,17.26,17.10,16.99,16.99,16.99,16.99,16.99,16.99,16.99,16.62,16.32,15.98,15.98,15.88,15.98,15,15,15,15,14,14,14,14,15,15.98,15.98,15.98,15.98,17,17.98,19,19,19,20,20,20,20,20,20,20,20,20,20.98,20.98,20.98,22,22,22,22,22,22,22,22,20.98,20.98,20.98,20.98,22,22,22,22.98,22.98,24,24,24,24,24,24,24,24,25,25,25,25,25.98,27.98,27.98,29,30,30,30,30,30,30.98,30.98,32,32,32.98,32.98,34,34.95,35.10,36.75,37.83,38.75,39.60,39.70,39.72,39.87,40.23,40.62,41.20,41.99,43,44.32,45.70,46.38,47,47.87,48.89,50,51.12,52.10,53.12,54.88,54.98,55,50.98,47,45,42,42,40.98,40,39,39,39,37.98,37.98,37.98,37,37,37,37,37.98,37.98,37.98,37.98,37.98,37.98,37.98,37.98,37.98,37.98,37.98,37.98,37.98,37.98,37.98,37.98,37.98,37.98,39,39,39,40,40,40,40.98,40.98,42,42.75,43.57,44.88,46.76,48.62,50.15,51.13,52,52.98,54,54,55.98,57,59,62.98,62.98,64,65.87,66.95,68.39,68.63,69.07,69.58,70.01,70.38,70.77,71.25,71.83,72.52,73.35,74.25,75.24,76.28,77.37,78.42,79.53,80.85,82.48,84.49,86.28,87.37,89,90,90.98,90.98,90.98,89,87,85.98,85,85,85,85,85,85,85,85.98,85.98,87.98,90,90,90,90,90,87.98,87.98,85.98,82.98,80.98,77,77,74.89,72.87,70.63,69.10,67.90,66.87,65.74,64.50,63.25,62,60.60,59,57.24,55.40,54.37,53.46,52.52,51.70,51.58,51.57,51.88,52,51.20,49.95,48.47,46.88,45.25,43.62,42.12,40.83,39.60,38.37,37.12,35.88,34.71,33.58,32.34,31.01,29.86,28.84,28.15,27,27,25,25,24,24,24,22.98,22.98,22.98,22.98,22.98,22,22,22,22,22,20.98,20.98,20.98,20.98,20.98,20,20,20,20,20,22,22,22,22,22,22,22,22,22,22,20.98,20.98,20,20.01,19.71,19.24,18.75,18.26,17.97,17.62,17.26,17.10,16.99,16.99,16.99,16.99,16.99,17,17,17,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15,15,15,14,14,14,15,15.98,15.98,15.98,15.98,17,17,17.98,17.98,17.98,17.98,19,19,19,20,20,20,20,20,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,22,22,22.98,22.98,22.98,24,24,24,24,24,24,24,25,25,25,25,25.98,27,27,27.98,28.98,29.01,29.96,29.99,30.07,30.88,31,31.96,32,32.98,32.98,34,34.96,35.08,36.82,37.71,38.24,38.73,39.07,39.14,39.38,39.75,40.12,40.64,41.37,42.33,43.45,44.50,45.37,46.07,46.87,47.88,49.11,50.26,51.35,52.57,53.87,54.97,55,52.98,50,47,42.98,42.98,42,40.98,40,40,40,39,37.98,37.98,37.98,37.98,37.98,37.98,37.98,39,39,39,39,40,37.98,37.98,37.98,39,39,39,39,39,39,39,39,39,39,40,40,40.98,40.98,40.98,40.98,42,42.98,43.34,44.24,45.50,47.09,48.74,50.21,51.37,52,52.98,55,55,55.98,57.98,60,62.98,62.98,65,65.87,67.07,68.29,68.97,69.45,70,70.49,70.87,71.28,71.77,72.39,73.13,73.99,74.92,75.98,77.11,78.25,79.35,80.45,81.72,83.32,85.26,87.15,88.41,90,90.98,90.98,89,89,87,85.98,85,85,85,85,85,85,85,85,85,85.98,87,87.98,87.98,87.98,89,89,89,89,87,84,80.98,77,77,75.98,73.21,71.14,69.86,68.75,67.63,66.57,65.37,64.24,63,61.70,60.12,58.36,56.24,55.60,54.62,53.65,52.72,52.50,52.37,52.50,52.70,52.27,50.75,49.15,47.62,46.01,44.40,42.95,41.62,40.37,39.20,37.95,36.64,35.45,34.22,32.87,31.57,30.35,29.34,28.62,27.87,27,25,25,25,25,24,24,24,22.98,22.98,22.98,22.98,22.98,22,22,22,22,22,20.98,20.98,20.98,20,20,20,20,20,22,22,22,22,22,22,22,22,22,22,20.98,20.98,20,19.97,19.89,19.12,18.71,18.26,17.97,17.62,17.32,17.01,16.99,16.99,16.99,16.99,17,17,17,17,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15,15,14,14,14,15,15.98,15.98,15.98,15.98,17,17,17,17,17,17,17.98,17.98,17.98,19,20,20.98,20,20,20.98,20.98,22,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,22,22,22,22,22,22.98,22.98,24,24,24,24,24,24,24,24,25,25,25.98,25.98,25.99,26.96,27.07,28.02,29.88,29.87,30.10,30.87,31.07,32.87,32.88,33,33.99,34,34.98,35.07,36.10,36.98,37.64,38.12,38.36,38.62,38.88,39.33,39.84,40.33,40.87,41.62,42.62,43.57,44.36,45.07,45.72,46.95,48.21,49.37,50.50,51.74,53.12,54.95,55,55,54,50.98,45.98,45.98,44,42.98,40.98,40.98,40.98,40,39,39,37.98,37.98,37.98,37.98,37.98,39,39,39,39,39,39,39,39,40,40,40,40,40,40,40,40,40,40,40.98,40.98,42.98,42.98,42.98,42.98,42.98,43.24,44.25,45.01,46.14,47.58,49.09,50.51,51.86,52.98,54,55.98,55.98,57,57.98,60,64,64,65,65.09,66.12,68.22,68.84,69.50,70.12,70.61,71.04,71.51,72.10,72.78,73.61,74.50,75.50,76.61,77.83,79.07,80.23,81.34,82.53,84.12,86.09,88.13,89.22,90,90.98,90.98,87,87,85.98,85,85,85,85,85,85,85,85,85,85,85,85.98,87,87,87,87,87.98,87.98,87.98,87,84,82,77,77,75,72.98,71.97,70.70,69.50,68.45,67.36,66.24,65.20,64.09,62.85,61.36,59.72,58,57.20,56.25,54.75,54.35,53.58,53.12,53.01,53.12,53.34,51.25,49.75,48.26,46.77,45.25,43.82,42.50,41.27,40.07,38.75,37.37,36.07,34.71,33.32,31.95,30.70,29.64,28.95,27.99,27,25.98,25.98,25,25,25,24,24,24,22.98,22.98,22.98,22.98,22.98,22,22,22,22,22,20.98,20.98,20.98,20.98,20,20,20,22,22,22,22,22,22,22,22,22,22,20,20,20,20,19,19.07,18.87,18.08,17.97,17.87,17.11,17,16.99,16.99,16.99,17,17,17,17,17,15.98,15.98,15.98,17,17,15.98,15.98,15.98,15.98,15,15,15,15,15,15.98,15.98,15.98,17,17,17,17,17,17,17,17,17,17,17.98,19,19,19,19,20,20,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,22,22,22,22,22,22,22,22,22,22,22,22.98,22.98,24,24,24,22.98,22.98,24,24,24,24,25,25,25.01,25.90,26.08,27.11,28.87,29.12,30.10,30.85,31.10,32.87,33.08,33.89,33.96,34,35,35,35.87,36.12,37.20,37.75,38.10,38.24,38.33,39.08,39.62,40.12,40.62,41.20,42,42.86,43.61,44.25,45,46.32,47.58,48.73,49.82,51,52.51,53.95,54,55.98,57.98,57.98,54,54,50.98,47.98,45,42.98,42.98,42,40.98,40,40,40,40,39,39,39,39,39,39,39,40,40,40,40,40,40.98,40.98,40.98,40.98,40.98,40.98,40.98,42,42,42.98,44,44,45,45.98,45.98,45,45.01,45.72,46.75,48.10,49.57,51.01,52.50,54,55.98,59,59,60,60,60.98,62.98,62.98,64,64.87,65.12,67.27,68.57,69.27,69.89,70.45,70.98,71.54,72.24,73.03,73.92,74.89,75.92,77.09,78.38,79.74,81,82.10,83.24,84.71,86.64,89.09,89.64,90,90,89,85,85,85,85,84,85,85,85,85,85,85,85,85,85,85,85,85,85,85.98,85.98,87,87,87,84,82,77,77,75.98,74.97,72.77,71.40,70.25,69.15,68.08,66.97,65.99,65.35,63.84,62.62,61.10,59.86,59,58.11,57.24,56.35,54.45,53.62,53.32,53.09,52.48,51.48,50.13,48.84,47.50,46.09,44.72,43.45,42.22,41,39.51,38,36.48,35,33.58,32.15,30.88,29.75,28.96,28.12,27,27,27,27,27,25.98,25,25,25,24,24,22.98,22.98,22.98,22.98,22.98,22,22,22,22,20.98,20.98,20.98,20.98,20.98,20,22,22,22,22,22,22,22,22,22,21.49,20,20,20,20,19,19,18.96,18,17.97,17.87,17.07,16.99,16.99,16.99,17,17,17,17,17,17,15.98,15.98,15.98,17,17,15.98,15.98,15.98,15.98,15,15,15,15,15,15.98,15.98,15.98,17,17,17,17,17,16.49,16.49,16.49,17,17,17.49,18.49,18.49,19,19,20,20,20.49,20.98,20.98,20.98,20.98,21.49,21.49,21.49,22,22.49,22.49,22.49,22.49,22.49,22.49,22.49,22.49,22.49,22.49,22.98,22.98,24,24,23.49,22.98,22.98,23.49,23.49,23.49,24,24.49,24.96,25.08,25.50,26.10,27.12,28.85,29.12,29.98,30.83,31.12,32.84,33.10,33.87,33.99,34.01,34.99,35,35.95,36.09,36.98,37.75,37.98,38,38.25,38.99,39.59,40.08,40.50,41,41.74,42.50,43.25,44,44.84,46,47.22,48.25,49.26,50.38,52,53.89,54,55.98,57.98,57.98,55.50,55.50,52.49,49.48,46.49,43.99,43.99,42.49,41.49,40.49,40,40,40,39.50,39.50,39.50,39.50,39.50,39.50,39.50,40,40,40.49,40.49,40.49,40.98,40.98,40.98,40.98,40.98,41.49,41.49,42,42.49,42.98,44.50,44.50,45.49,46.98,47.49,46.26,45.87,46.45,47.46,48.75,50.14,51.61,53.07,54.50,56.49,59.50,59.50,60.49,61,61.49,62.98,62.98,64,64.50,65.12,67.24,68.22,68.85,69.45,70.07,70.72,71.45,72.26,73.17,74.14,75.15,76.22,77.39,78.75,80.20,81.53,82.65,83.73,85,86.97,89.09,89.86,90,90,89,85,85,85,84.50,84,85,85,85,85,85,85,85,84.50,84.50,85,85,85,85,85.49,85.98,87,87,86.49,84,82,77.49,77.49,76.47,74.97,73.38,71.86,70.90,69.77,68.62,67.51,66.60,65.62,64.62,63.47,62.25,61.12,60.08,59,57.76,56.37,54.51,53.83,53.36,52.88,52.26,51.45,50.39,49.27,48.12,46.85,45.52,44.26,43.12,41.77,40.11,38.37,36.72,35.20,33.74,32.34,31.08,29.96,29.14,28.46,27.89,27.61,27.50,27.45,27,26.49,25,25,25,24.50,24,22.98,22.98,22.98,22.98,22.98,22,22,22,22,20.98,20.98,20.98,20.98,20.98,20.49,22,22,22,22,22,22,22,22,22,20.98,20,20,20,20,19,19,19,17.98,17.98,17.98,17,17,17,17,17,17,17,17,17,17,15.98,15.98,15.98,17,17,15.98,15.98,15.98,15.98,15,15,15,15,15,15.98,15.98,15.98,17,17,17,17,17,15.98,15.98,15.98,17,17,17,17.98,17.98,19,19,20,20,20,20.98,20.98,20.98,20.98,22,22,22,22,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,24,24,22.98,22.98,22.98,22.98,22.98,22.98,24,24.01,24.89,25.01,25.12,25.84,26.98,28.83,28.99,29.82,30.77,31.12,32.82,33.12,33.87,34.11,34.08,34.96,35,35.98,36,36.97,37.84,37.97,38.11,38.14,39.09,39.62,40.20,40.62,41.08,41.72,42.45,43.20,43.99,44.87,45.95,47,47.97,48.99,50.13,51.60,53.20,54.23,55.58,57.50,57.74,57,57,54,50.98,47.98,45,45,42.98,42,40.98,40,40,40,40,40,40,40,40,40,40,40,40,40.98,40.98,40.98,40.98,40.98,40.98,40.98,40.98,42,42,42,42.98,42.98,45,45,45.98,47.98,49,47.21,46.75,47.40,48.45,49.63,50.96,52.23,53.40,55,57,60,60,60.98,62,62,62.98,62.98,64,64,65.09,67.28,67.74,68.23,68.83,69.52,70.35,71.23,72.16,73.16,74.21,75.25,76.32,77.50,78.90,80.41,81.85,83,84.08,85.17,87.10,89.13,89.87,90,90,89,85,85,85,84,84,85,85,85,85,85,85,85,84,84,85,85,85,85,85,85.98,87,87,85.98,84,82,77.98,77.97,76.89,75.12,73.96,72.38,71.50,70.37,69.08,67.99,67,66.14,65.25,64.25,63.12,61.99,60.96,59.57,58.12,56.37,54.51,53.85,53.32,52.75,52.12,51.45,50.62,49.65,48.72,47.50,46.26,45,43.64,42.09,40.27,38.50,36.86,35.34,33.87,32.50,31.32,30.23,29.50,28.88,28.48,28.20,28,27.84,27.01,27,25,25,25,25,24,22.98,22.98,22.98,22.98,22.98,22,22,22,22,20.98,20.98,20.98,20.98,20.98,20.98,22,22,22,22,22,22,22,22,22,20.98,20,20,20,20,19,19,19,17.98,17.98,17.98,17,17,17,17,17.98,17.98,17.98,17,17,17,15.98,15.98,15.98,15.98,17,15.98,15.98,15.98,15.98,15,15,15,15,15,15.98,15.98,15.98,17,17,17,15.98,15.98,15.98,15.98,15.98,17,17,17,17,17.98,20,20,20,20,20.98,20.98,20.98,20.98,22,22,22,22,22.98,22.98,22.98,24,24,24,24,24,24,24,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,23,23.99,24.87,24.87,25,25.14,26.13,27.76,28.14,29.11,30.20,31.82,32.76,33.12,33.87,34.87,34.87,34.90,35,35.98,35.98,37,37.95,37.98,38.01,38.87,39.10,39.82,40.39,40.82,41.25,41.83,42.50,43.23,44,44.87,45.85,46.75,47.71,48.75,49.87,51.12,52.39,53.72,55,56.12,56.88,57.37,57.98,57,54,50.98,45.98,45.98,45,44,42,40.98,40.98,40.98,40,40,40,40,40,40,40,40.98,40.98,40.98,40.98,40.98,42,42,42,42,42,42,42,42.98,42.98,44,45.98,45.98,47,49,50,48.12,48,48.75,49.73,50.87,52.02,53,53.84,55,57,59,59,60,60.98,62.98,62.98,62.98,62.98,64,64,66.40,66.98,67.47,68.10,68.89,69.86,70.85,71.86,72.90,74,75.08,76.14,77.39,78.87,80.47,81.98,83.22,84.37,85.59,87.04,89.17,90.01,90,90,87.98,85,85,84,84,84,85.98,85.98,85.98,85.98,85.98,84,84,84,84,84,85,85,85,85,85.98,87,87,85.98,84,82,79,78.96,77.12,76.09,74.62,73.33,72.40,70.75,69.37,68.27,67.47,66.70,65.90,65,63.85,62.62,61.35,60.07,58.57,56.75,54.51,54,53.33,52.62,52,51.45,50.75,50.02,49.24,48.12,46.76,45.35,43.77,42.12,40.36,38.62,37,35.50,34.12,32.85,31.59,30.63,29.96,29.40,29.01,28.74,28.40,28.08,27.86,27,25.98,25.98,25,25,24,24,24,22.98,22.98,22.98,22,22,22,22,22,20.98,20.98,20.98,20.98,20.98,22,22,22,22,22,22,22,22,22,20.98,20,20,20,20,19,19,19,17.98,17.98,17.98,17,17,17,17,17.98,17.98,17.98,17.98,17,17,17,17,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15,15,15,15,15,15,15.98,15.98,17,17,17,15.98,15.98,15.98,15.98,15.98,17,17,17,17,17.98,20,20,20.98,20.98,20.98,20.98,20.98,22,22,22,22,22,22.98,22.98,22.98,24,24,24,25,25,25,25,24,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,23,23.89,24.11,24.12,24.84,25.15,25.87,26.76,27.21,28,29.76,30.86,32.75,32.96,33.84,34.86,34.11,34.89,35.01,35.98,37,37,37.75,37.98,38.32,38.62,39.32,39.83,40.47,40.95,41.39,41.98,42.59,43.24,43.96,44.75,45.62,46.51,47.50,48.50,49.58,50.74,51.95,53.20,54.37,55.50,56.50,57.25,57.75,57.98,57,55,50.98,50.98,47.98,45.98,44,42,42,40.98,40.98,40.98,40,40,40,40,40,40.98,40.98,40.98,42,42,42,42,42,42,42.98,42.98,42.98,42.98,44,44,47,47,47.98,49,50,49.82,49.72,50.22,51.12,52.34,53.39,54.27,54.24,55.98,57,59,59,60,60.98,62,62.98,62.98,62.98,62.98,64,65.52,66.12,66.65,67.32,68.24,69.25,70.26,71.28,72.37,73.48,74.62,75.75,77.10,78.70,80.39,82,83.35,84.64,86.14,88,89.59,90.37,90.98,90,87,85,85,84,84,84,85.98,85.98,87,87,85.98,84,84,84,84,84,85,85,85,85,85.98,87,87,85.98,84,82,79,79.08,78.12,76.90,75.60,73.45,72.38,71.08,69.70,68.72,67.90,67.25,66.62,65.87,64.65,63,61.87,60.62,59.21,57.40,55.50,54.51,53.37,52.49,51.90,51.48,50.95,50.26,49.50,48.37,46.90,45.37,43.75,42.07,40.37,38.75,37.25,35.84,34.49,33.24,32.10,31.15,30.50,30,29.60,29.25,28.90,28.38,28.13,27,25.98,25.98,25.98,25,25,24,24,24,22.98,22.98,22.98,22.98,22,22,22,20.98,20.98,20.98,20.98,20.98,22,22,22,22,22,22,22,22,22,20.98,20,20,20,20,19,19,19,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17,17,17,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15,15,15,15,15,15.98,15.98,17,15.98,15.98,15.98,15.98,15.98,15.98,15.98,17,17,17,17,17.98,19,19,20,20.98,20.98,22,22,22,22,22,22,22,22.98,22.98,22.98,24,24,24,24,25,25.98,25.98,25,25,24,24,24,24,24,24,24,24,24,23.96,24.02,24.12,24.12,24.83,25.11,25.21,25.87,26.20,26.20,28.20,29.22,31.76,32.15,32.82,33.12,34.12,34.88,35.01,35.98,35.98,36.25,37.38,37.98,38.32,38.62,39.26,39.76,40.47,40.99,41.50,42.01,42.62,43.20,43.83,44.62,45.47,46.36,47.25,48.25,49.33,50.39,51.61,52.76,54,55.13,56.23,57.12,57.87,58.50,60,60.98,57.98,57.98,52.98,49,45.98,42.98,42.98,42.98,42.98,42,42,42,42,42,42,42,42,42,42,42,42.98,42.98,42.98,42.98,44,44,44,44,44,45,47.98,47.98,50,50,50.98,51.74,51.25,51.51,52.37,53.87,55.13,55.72,57,57,57,59,59,60,60.98,60.98,62,62,62,62,62.98,64.76,65.41,65.91,66.66,67.59,68.59,69.58,70.58,71.63,72.76,73.98,75.21,76.66,78.40,80.26,81.97,83.39,84.85,86.52,88.60,91.41,91.76,90.98,89,85.98,84,84,82.98,82.98,84,85,85,85.98,85,84,82.98,82.98,84,84,84,85,85,85.98,85.98,87,87,87,85.98,84.98,82.88,81.08,80.74,78.84,77.58,76.48,73.59,72.38,71.25,70.12,69.12,68.37,67.75,67.15,66.97,65.99,63.85,62.45,61.25,60.22,58.35,56.47,55.52,53.87,52.25,51.97,51.57,51.12,50.57,49.74,48.45,46.87,45.25,43.62,42.01,40.49,38.99,37.58,36.24,34.90,33.74,32.62,31.75,31.10,30.57,30.11,29.71,29.37,29.33,28.75,29,27,27,25.98,25,25,24,24,24,24,22.98,22.98,22.98,22.98,22.98,22,22,22,22,20.98,20.98,22,22,22,22,22,22,22,22,21.49,20.98,20,20,20,19.50,19,19,19,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17,17,17,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.49,15.49,15.49,15,15,15.98,15.98,16.49,15.98,15.98,15.98,15.98,15.98,15.98,15.98,17,17,17,17,17.98,19,19,20,20.49,20.98,21.49,21.49,22,22,22,22,22,22.49,22.98,22.98,24,24,24,24,24.50,25.49,25.49,25,25,24.50,24,24,24,24,24,24,24,24.50,24.50,24.50,24.50,24.62,24.85,25,25.15,25.36,25.64,26.20,27.34,28.71,30.76,31.20,31.85,32.62,33.87,34.87,35.07,35.49,35.82,36.59,37.26,37.98,38.32,38.62,39.25,39.75,40.45,41,41.57,42.09,42.59,43.11,43.62,44.37,45.25,46.12,47.10,48.09,49.12,50.23,51.37,52.51,53.75,54.88,56,57,57.96,58.88,60.10,61.49,58.99,58.99,53.99,49.50,46.98,43.49,43.49,43.49,43.49,42.49,42.49,42.49,42.49,42.49,42.49,42,42,42,42,42.49,42.98,42.98,42.98,43.49,43.87,44.12,44.25,44.38,44.75,45.87,47.71,47.98,49.50,50,51.49,52.49,52.49,52.49,53,54.50,56.49,56.49,57,57,57.49,59,59,60,60.98,60.98,61.49,61.49,62,62,62.98,64.46,64.84,65.37,66.12,67.02,68,68.91,69.87,70.91,72.09,73.35,74.63,76.17,78,80.02,81.79,83.35,84.76,86.50,88.72,91.09,91.45,90.49,88.49,85.98,83.49,83.49,82.98,82.98,83.49,84.50,84.50,84.99,84.50,84,82.98,82.98,84,84,84,85,85,85.98,85.98,87,87.49,87.49,86.45,84.96,83.35,81.13,80.62,79.25,77.87,76.37,73.64,72.51,71.50,70.50,69.61,68.77,68.11,67.48,66.72,65.60,64.25,62.97,61.83,60.50,58.87,56.95,56.11,54.26,52.73,52.10,51.71,51.33,50.87,49.89,48.46,46.77,45.12,43.52,42.07,40.62,39.25,37.95,36.65,35.40,34.25,33.23,32.37,31.64,31.10,30.59,30.12,29.75,29.37,28.97,28.49,27,27,25.98,25.49,25,24.50,24.50,24,24,23.49,22.98,22.98,22.98,22.98,22,22,22,22,21.49,20.98,22,22,22,22,22,22,22,22,20.98,20.98,20,20,20,19,19,19,19,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17,17,17,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15,15,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,17,17,17,17,17.98,19,19,20,20,20.98,20.98,20.98,22,22,22,22,22,22,22.98,22.98,24,24,24,24,24,25,25,25,25,25,24,24,24,24,24,24,24,25,24.90,25.01,25.12,25.12,25.14,25.12,25.09,25.12,25.22,25.87,26.75,28.20,29.76,30.21,31.08,32.12,33.87,34.87,35.07,35.21,35.71,36.62,37.26,37.98,38.32,38.62,39.37,39.95,40.62,41.12,41.61,42.08,42.50,42.95,43.37,44.14,45.07,45.97,46.87,47.87,48.95,50,51.14,52.36,53.50,54.72,55.82,56.84,57.75,58.70,59.83,62,60,60,55,50,47.98,44,44,44,44,42.98,42.98,42.98,42.98,42.98,42.98,42,42.37,42.50,42.37,43,42.98,42.98,42.98,44,44.27,44.62,44.75,45,45.37,46.39,47.36,48.23,49.23,50.13,52,52.98,52.98,54,54,54,57,57,57,57,57.98,59,59,60,60.98,60.98,60.98,60.98,62,62,62.98,64,64.17,64.87,65.62,66.51,67.48,68.36,69.25,70.25,71.42,72.70,74.02,75.58,77.41,79.53,81.46,83.01,84.21,85.88,88.10,90.78,90.98,90,87.98,85.98,82.98,82.98,82.98,82.98,82.98,84,84,84,84,84,82.98,82.98,84,84,84,85,85,85.98,85.98,87,87.98,87.89,86.87,85.15,83.75,81.23,80.52,79.50,77.75,76.36,73.74,72.71,71.76,70.87,69.97,69.09,68.33,67.50,66.60,65.46,64.27,63.22,62.15,61,59.38,57.37,56.63,54.25,53.12,52.14,51.77,51.64,51.20,50.12,48.50,46.71,45,43.50,42.12,40.84,39.57,38.34,37.12,35.95,34.83,33.77,32.95,32.23,31.61,31.02,30.50,30.02,29.52,28.89,27.98,27,27,25.98,25.98,25,25,25,24,24,24,22.98,22.98,22.98,22.98,22,22,22,22,22,20.98,22,22,22,22,22,22,22,20.98,20.98,20,20,20,19,19,19,19,19,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17,17,17,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15,15.98,15.98,15.98,15.98,17,17,17,17,17,17,17,17,17,17.98,17.98,19,19,20,20,20,20.98,20.98,20.98,22,22,22,22,22,22,22.98,22.98,22.98,24,24,24,24,24,25,25,25,24,24,24,24,24,24,24,25,25.07,25.87,25.86,25.86,25.77,25.20,25.21,25.22,25.23,25.25,26.24,27.25,28.74,29.15,30.14,31.82,33.86,34.87,35,35.33,35.87,36.86,37.50,37.98,38.32,38.62,39.50,40.12,40.87,41.23,41.61,41.95,42.33,42.73,43.12,43.97,44.87,45.75,46.73,47.72,48.75,49.85,50.99,52.12,53.32,54.46,55.50,56.49,57.33,58.12,59.11,60,60,60,57,52.98,50,45.98,45.98,45,45,44,44,44,44,44,43.25,43.83,44.13,44.25,44.13,43.87,43.62,43.75,44.10,44.87,45.62,46.25,46.20,46.37,47.37,48.24,48.87,49.52,50.37,51.50,52.89,55,55,55,55.98,55,57,57,57.98,57.98,57.98,59,59,60,60.98,60.98,60.98,60.98,62,62,62.98,64,64,64.25,65.07,65.96,67.01,67.75,68.61,69.59,70.73,71.97,73.28,74.78,76.57,78.62,80.97,81.95,83,84.57,86.78,90,90,89,87.98,85,82.98,82.98,82.98,82.98,82.98,82.98,82.98,82.98,82.98,82.98,82.98,82.98,84,84,84,85,85,85.98,85.98,87,88.96,88.87,87.76,85.74,83.72,81.25,80.50,78.87,77.39,75.71,73.73,72.96,72.02,71.10,70.12,69.22,68.36,67.49,66.36,65.13,64,63.20,62.25,61.35,60.48,57.33,56.75,54.77,53.12,52.12,51.83,51.62,51.38,50.49,48.57,46.50,44.74,43.50,42.25,41,39.85,38.75,37.62,36.50,35.38,34.38,33.51,32.82,32.12,31.52,30.97,30.37,29.75,29.08,28.07,27.01,27,25.98,25.98,25,25,25,24,24,24,22.98,22.98,22.98,22.98,22,22,22,22,22,22,22,22,22,22,22,20.98,20.98,20.98,20,20,20,20,19,19,19,19,19,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17,17,17,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,15.98,17,17,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,19,19,20,20,20,20.98,20.98,20.98,20.98,20.98,22,22,22,22,22,22.98,22.98,22.98,22.98,22.98,24,24,24,24,24,24,24,24,24,24,24,24,25,25.01,25.87,26.87,26.85,25.77,25.76,25.75,25.89,26.12,26.25,26.25,26.25,27.26,27.25,29.25,30.87,32.77,34.87,34.95,34.75,35.62,36.85,37.32,37.75,38.09,38.50,39.39,40.09,40.74,40.87,41.23,41.60,42.07,42.50,42.96,43.83,44.75,45.62,46.59,47.51,48.57,49.62,50.73,51.86,53,54.10,55.10,55.98,56.63,57.25,57.87,59,60,60,59,55.98,54,50,50,47.98,45.98,45.98,45.98,45.98,45,45,44.85,45.37,45.71,45.86,45.95,45.74,45.87,45.35,45.84,46.75,47.70,48.46,48.95,49.37,49.87,50.46,50.08,50.62,52.22,53.21,54.23,55.98,55.98,55.98,57,57.98,57.98,57.98,57.98,59,59,60,60,60,60.98,60.98,60.98,60.98,60.98,62,62,62.98,62.98,64,64.25,65.20,66.15,67.01,67.87,68.82,69.89,71.10,72.37,73.78,75.40,77.21,78.92,80.01,81.04,82.42,84.54,87.70,87.98,89,87,85,82.98,82.98,82.98,82.98,82.98,82.98,82.98,82.98,82.98,82.98,82.98,82.98,84,84,84,85,85,85.98,87,87.96,88.87,88.82,87.74,85.25,83.64,80.36,79.48,78.25,76.86,75.40,74.22,73.14,72.13,71.12,70.10,69.07,68.15,67.20,66.22,64.49,63.25,62.25,61.37,60.40,59.58,56.22,55.87,54.85,53.11,52.09,51,51.15,51.15,50.37,48.64,46.71,45,43.75,42.50,41.33,40.23,39.24,38.24,37.14,36.02,35.10,34.22,33.45,32.75,32.11,31.48,30.84,30.12,29.34,28.85,27.12,27.09,26.96,25.98,25,25,25,24,24,24,24,24,22.98,22.98,22.98,22,22,22,22,22,22,22,22,22,22,20.98,20.98,20.98,20,20,19,19,19,19,19,19,19,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17,17,17,15.98,15.98,15.98,15.98,15.98,15.98,15.98,17,17,17,17,17,17,17,17,17,17,17.98,19,19,19,19,19,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20.98,20.98,20.98,22,22,22,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,24,24,24,24,24,24,24,24,24,24,24.96,25.08,25.11,25.12,25.13,25.76,26.20,26.72,26.88,27.63,27.63,27.62,27.63,28.15,29,30.07,30.20,32.12,32.09,33.88,35.10,36.21,36.99,37.49,37.82,38.32,39.10,39.71,40.23,40.36,40.64,41.12,41.75,42.37,42.87,43.75,44.70,45.59,46.49,47.37,48.37,49.37,50.39,51.50,52.60,53.62,54.59,55.36,55.89,56.37,56.62,57,59,59,59,60,59,57,57,55.98,55.87,54.95,52.12,52.02,50.98,50.37,50.15,48.71,49.02,49.40,49.50,49.26,48.32,48.86,48.89,48.87,49.95,51.08,51.77,50.95,52.10,51.65,50.25,51.84,53.40,55,56.75,57.98,57.98,57.98,57.98,59,59,59,60,60,60,60,60,60,60,60.98,60.98,60.98,60.98,60.98,62,62,62,62.98,62.98,64.40,65.36,66.20,67.03,67.97,69,70.12,71.36,72.66,74.10,75.51,76.76,77.75,78.40,80,80.85,83.84,84.27,85.98,85.98,85,82.98,82.98,82.98,82.98,82.98,82,82,82,82,82,82,82,82.98,84,84,85.98,85.98,87,87.98,88.90,88.12,87.75,86.25,84.33,82.61,79.37,78.61,77.62,76.37,75.13,74.02,73.15,71.98,70.87,69.74,68.64,67.62,66.59,65.25,63.71,61.61,61.25,60.50,59.39,58.02,56.12,55.85,54.87,53.01,52,50.98,50.98,50.87,50.47,48.76,46.97,45.32,44.02,42.87,41.72,40.71,39.84,38.97,37.98,36.87,35.85,34.90,34.12,33.37,32.73,32.02,31.36,30.61,29.85,28.87,28.12,27.83,27.11,26.96,25.98,25,25,25,25,25,24,24,24,24,22.98,22.98,22.98,22.98,22,22,22,22,22,22,22,20.98,20.98,20.98,20,20,19,19,19,19,19,19,19,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17,17,17,16.49,16.49,15.98,15.98,15.98,15.98,16.49,17,17,17,17,17,17,17,17,17,17.49,17.98,19,19,19.50,19.50,19.50,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20.49,20.98,20.98,22,22.49,22.49,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,24,24,24,24,24,24,24,24,24,24,24.48,24.50,24.50,24.62,25.12,25.82,26.51,27.22,27.50,27.71,27.87,27.95,28.01,28.26,28.87,29.51,30.21,31.34,31.59,32.83,34,35.33,36.33,37.12,37.49,37.98,38.62,39.12,39.50,39.70,40.08,40.75,41.50,42.25,42.98,43.83,44.70,45.58,46.45,47.33,48.22,49.12,50.12,51.12,52.12,53.12,54,54.72,55.23,55.57,55.88,56.49,58.49,58.49,58.49,59.50,58.49,57.49,57.49,57.85,57.90,57.59,55.98,55,53.01,52.50,51.75,50.32,50.84,50.70,50.75,50.23,51.25,52.13,52.25,51.90,52.32,53.37,52.26,52.75,53.87,52.47,52.01,52.87,55.27,56.65,57.49,58.49,58.49,58.49,58.49,59,59.50,59.50,60.49,61,60.49,60,60,60,60,60.49,60.98,60.98,60.98,60.98,62,62,62,62.49,63,63.77,64.61,65.39,66.20,67.09,68.08,69.14,70.29,71.50,72.75,73.96,74.96,75.63,76.60,77.87,80.07,82.14,83.39,84.26,84.99,85,82.98,82.98,82.98,82.98,82.98,82,82,82,82,82,82,82,82.98,83.49,84,85.98,85.98,87.49,88.49,89.87,88.13,87.73,85.95,84.09,82.09,78.88,78,77.12,76,74.74,73.60,72.50,71.51,70.38,69.25,68.14,67.12,66.08,64.75,63,60.99,60.38,59.82,58.89,57.77,56.07,55.88,54.96,53.49,52.49,50.98,50.98,50.49,50.25,48.75,47.07,45.50,44.34,43.24,42.13,41.26,40.58,39.84,38.87,37.75,36.62,35.62,34.77,34.09,33.37,32.64,31.90,31.12,30.26,29.25,28.22,27.84,27.48,26.98,26.45,25.49,25.49,25.49,25.49,25,24,24,24,24,22.98,22.98,22.98,22.98,22.49,22,22,22,22,22,22,20.98,20.98,20.98,20,20,19,19,19,19,19,19,19,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17,17,17,17,17,15.98,15.98,15.98,15.98,17,17,17,17,17,17,17,17,17,17,17.98,17.98,19,19,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20.98,20.98,22,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,24,24,24,24,24,24,24,24,24,24,24,24.01,24.08,24.11,25,25.86,26.75,27.65,27.74,27.86,28.02,28.22,28.27,28.25,28.85,29.25,30.12,30.82,31.07,32.11,33,34.39,35.59,36.49,36.82,37.32,37.98,38.49,38.89,39.22,39.74,40.49,41.35,42.22,43,43.87,44.73,45.60,46.39,47.25,48.11,48.97,49.87,50.75,51.74,52.62,53.39,54.10,54.60,55,55.49,55.98,57.98,57.98,57.98,59,57.98,57.98,57.98,58.85,58.90,59.87,58.89,57.96,55.95,56,54.75,51.75,52.35,51.70,51.75,50.65,52.60,53.65,54,53.85,53.99,54.27,53.98,54.50,55.63,55.88,54.58,55.25,57.39,57.70,58.09,59,59,59,59,59,60,60,60.98,62,60.98,60,60,60,60,60,60.98,60.98,60.98,60.98,62,62,62,62.03,62.72,63.38,64.09,64.72,65.37,66.16,67.12,68.16,69.24,70.35,71.50,72.58,73.52,74.40,75.45,76.79,78.67,80.96,81.95,82.87,83.96,85,82.98,82.98,82.98,82.98,82.98,82,82,82,82,82,82,82,82.98,82.98,84,85.98,85.98,87.98,89,90.86,88.15,87.70,85.62,83.63,81.58,78.39,77.75,76.87,75.73,74.36,72.75,71.99,70.99,69.87,68.74,67.70,66.75,65.77,64.62,62.82,60.27,60.21,59.20,58.87,57.90,55.98,55.98,55,54,52.98,50.98,50.98,50,50,48.51,46.73,45.52,44.63,43.73,42.83,42.10,41.50,40.84,39.87,38.75,37.47,36.37,35.64,34.89,34.12,33.33,32.48,31.62,30.70,29.62,28.50,28.22,27.76,27.32,26.75,26.37,26.12,26,25.75,25.08,24,24,24,24,22.98,22.98,22.98,22.98,22.98,22,22,22,22,22,22,20.98,20.98,20.98,20,20,19,19,19,19,19,19,19,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17,17,17,17,17,17,15.98,15.98,15.98,17,17,17,17,17.98,17.98,17.98,17.98,17.98,17.98,17.98,19,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,22,22,22.98,24,24,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,24,24,24,25,24,24,24,24,24,24,24,24,24.09,24.86,25.75,26.75,27.70,27.83,27.87,28.08,28.63,28.64,28.70,28.86,29.24,29.88,30.84,30.88,31.45,32.25,33.38,34.33,35.21,35.62,36.21,36.99,37.50,38.21,38.62,39.37,40.24,41.13,42.09,42.98,43.86,44.74,45.61,46.45,47.24,48,48.82,49.62,50.49,51.33,52.12,52.87,53.50,54,54.50,55.07,55.98,57,57,57,57.98,57,57.98,57.98,57,57.87,58.75,59.87,59.87,59.52,60.26,61,57,55.99,54.38,52.46,52.22,52.86,53.90,54.58,54.82,56.50,57.38,57.22,56.36,58.24,58.36,56.75,57.87,58.02,58.23,58.96,59,59,59,59,59,60,60,62,62.98,62,60.98,60.98,60,60,60,60.98,60.98,60.98,60.98,60.98,62,62,62.14,62.42,63,63.59,64.12,64.72,65.41,66.29,67.26,68.25,69.26,70.37,71.42,72.37,73.24,74.24,75.58,77.24,78.86,80.29,81.26,82.73,84,82.98,82.98,82.98,82.98,82,82,82,82,82,82,82,82,82.98,82.98,84,87,87,89,90.98,90.84,87.22,86.72,85.25,83.25,80.87,78.45,77.60,76.64,75.45,73.98,72.71,71.52,70.50,69.25,68.12,67.24,66.37,65.59,64.63,62.82,61.25,60.75,59.85,58.97,57.97,55.98,55.98,55,54,52.98,50,50,49,47.98,47.25,45.60,45.75,45.13,44.37,43.62,43.10,42.57,42.12,41.12,39.89,38.61,37.57,36.72,35.87,35,34.10,33.09,32.02,31.12,30.11,29.34,28.70,28.26,27.85,27.37,27.12,27,26.75,26.32,25.59,24.99,25,24,24,24,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22,22,22,20.98,20.98,20,20,20,19,19,19,19,19,19,19,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17,17,17,17,17,17,15.98,15.98,15.98,15.98,17,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,19,20,20,20,20,20,20,20,20,20,20,20.98,20.98,20.98,20.98,20,20,20,20,20,20.98,22,22,22.98,24,24,24,24,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,24,24,24,24,24,24,24,24,24,24,23.99,23.97,24.85,25.21,26.13,27.71,27.65,27.63,27.85,28.12,28.70,28.72,28.74,29.09,29.83,30.08,30.12,30.87,31.49,32.21,32.62,33.32,33.87,34.62,35.62,36.39,37.32,37.87,38.86,39.83,40.87,41.83,42.75,43.75,44.72,45.62,46.39,47.20,47.95,48.70,49.46,50.22,50.98,51.72,52.37,52.95,53.39,53.87,54.62,55.12,56.63,56.48,56.08,55.83,56,56.10,56.21,56.10,56.10,55.98,56.76,56.87,58.47,61.12,63.32,62.37,60.58,57.75,54.84,53.60,54.75,56.90,57.75,57.74,60.24,61.90,60,59.88,59.82,58.83,58.60,58.38,58.60,59,59,59,59,59,59,60,60.98,60.98,62,62.98,62,60.98,60.98,60.98,60,60,60.98,60.98,60.98,60.98,60.98,62,62,62.07,62.25,62.64,63.12,63.57,64.04,64.65,65.42,66.27,67.15,68.10,69.13,70.16,71.13,72,72.95,74.13,75.51,76.91,78.10,79.23,80.57,82,82.98,82.98,82.98,82.98,82,82,82,82,82,82,82.98,82.98,82.98,84,84,87,87,90,90.98,90.84,87.23,86.71,84.96,82.90,80.57,78.45,77.49,76.49,74.97,73.50,72.25,71.25,69.98,68.61,67.13,66.37,66.46,64.62,64.72,62.73,61.15,60.82,59.87,58.98,59,55.98,55.98,55,54,52.98,50,50,47.98,47,47.07,47.37,47.32,46.76,46.21,45.62,45.09,44.50,43.75,42.61,41.25,39.98,38.86,37.87,36.98,36,35.07,34,32.75,31.84,31.25,30.13,29.75,29.24,28.73,28.40,28.33,28.20,27.75,27.09,26.21,25.47,25.10,25,24,24,24,24,22.98,22.98,22.98,24,24,24,22.98,22,20.98,20.98,20,20,20,19,19,19,19,19,19,19,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17,17,17,17,17,15.98,15.98,15.98,17,17,17,17.98,17.98,17.98,17.98,17.98,19,19,20,20,20,20,20,20,20,20,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,22,22,22.98,24,25,25,25,25,24,24,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,23,23.96,24.14,25.22,26.75,27.07,27.13,27.26,27.74,28.10,28.24,28.22,28.83,29.14,29.85,30,30.32,30.87,31.27,31.48,31.98,32.62,33.50,34.75,35.62,36.62,37.32,38.37,39.38,40.47,41.46,42.39,43.50,44.72,45.51,46.37,47.11,47.84,48.58,49.26,50,50.71,51.36,51.95,52.46,52.87,53.24,53.21,54.25,54.75,55,54.87,54.62,54.85,55,55.20,55.22,55.37,55.62,55,55,55.83,59.23,61.13,62.89,62.70,60.83,57.87,56.60,59.33,61.25,62.13,61.73,62.50,64.37,63.58,61.73,60.82,60,59,59,59,60,60.98,60.98,60.98,60.98,60.98,60.98,62,62,62.98,62.98,62,60.98,60.98,60.98,60.98,60.98,60.98,60.98,60.98,60.98,60.98,62,62,62.03,62.15,62.45,62.78,63.14,63.51,64,64.63,65.37,66.12,66.96,67.91,68.95,69.92,70.77,71.64,72.70,73.87,75.08,76.10,76.86,77.50,77.98,80,80,80.98,82,82,82,82,82.98,82.98,84,85.98,85.98,85.98,87,87,90,90,89,89,88.12,87.22,86.72,84.73,82.77,80.51,77.47,76.87,75.82,74.37,72.87,71.61,70.58,69.37,67.87,66.11,63.50,63.46,63.36,62.22,61.82,60.12,59.90,59,57.98,57,55.98,55.98,55,54,52.98,50,50,50,50,50,50.76,50.49,48.52,48,47.76,47.11,46.50,45.52,44.25,42.62,41.25,40.09,39.09,38.09,37.08,36.10,35.12,34.25,33.57,32.74,31.84,30.87,30.27,29.75,29.46,29.35,29.09,28.58,27.75,26.75,26.01,25.50,25.12,25,25,24,24,24,24,22.98,24,24,24,23.49,22.49,20.98,20.98,20.49,20,20,19,19,19,19,19,18.49,18.49,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.49,17.49,17,17,17,16.49,15.98,15.98,16.49,16.49,16.99,17.48,17.88,17.97,17.97,18,18.95,19.50,19.98,20,20.49,20.49,20.49,20.49,20.49,20.49,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,22,22,22.98,24.50,25.49,25.49,25.49,25,24.50,24,23.49,23.49,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,23,23.50,24.01,24.65,26.25,26.45,26.57,26.75,27.32,27.75,28,28.14,28.50,28.98,29.34,29.62,30,30.37,30.70,30.82,31.32,31.98,32.99,34.32,35.32,36.26,36.97,37.98,39,40,41,42.10,43.23,44.33,45.26,46.12,46.87,47.62,48.37,49.12,49.86,50.50,51.10,51.62,52.07,52.37,52.51,52.84,53.23,53.62,53.86,53.87,53.75,54,54.25,54.39,54.59,54.73,54.82,54.75,54.50,55,56.73,57.75,60.99,61,59.63,58.24,57.77,60.08,61.97,62.75,61.85,61.25,62.48,61.82,60.98,60.98,60.49,59.50,59.50,59.50,60,60.98,61.98,61.98,61.49,61.49,61.49,62.49,62.49,62.98,62.98,62,60.98,60.98,60.98,60.98,60.98,60.98,60.98,60.98,60.98,61.49,62,62,62.03,62.16,62.38,62.66,62.95,63.22,63.58,64.09,64.72,65.36,66.09,66.97,67.96,68.90,69.72,70.50,71.40,72.45,73.49,74.37,75.11,76.02,76.98,78.99,78.99,79.48,80.50,81,82.49,82.49,82.98,83.49,84.50,86.98,86.98,86.98,88,88,89.50,89.50,88.49,88,87,86.21,85.72,84.36,82.62,80.52,77.45,76.50,75.27,73.76,72.25,71,69.90,68.75,67.13,65.12,62.96,62.50,62.08,61.50,60.87,60.07,59.98,58.49,57.49,56.49,55.49,55.49,54.50,54,52.98,51,51,51,50.49,50.49,50.49,50.25,49.75,49.37,49,48.62,47.98,47.11,45.51,43.83,42.36,41.15,40.21,39.21,38.02,37.09,36.25,35.65,35.12,34.12,33.13,32.11,31.35,30.74,30.25,30.10,29.62,29.12,28.27,27.27,26.47,25.83,25.49,25.08,25,24,24,24,24,23.49,24,24,24,24,22.98,20.98,20.98,20.98,20,20,19,19,19,19,19,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17,17,17,17,15.98,15.98,15.98,16,16.89,17.08,17.87,17.85,17.98,18.12,18.89,19.86,20.12,20.09,20.89,20.96,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,22,22,22.98,25,25.98,25.98,25.98,25,25,24,24,24,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,23,23.07,23.87,24.12,25.82,25.76,25.96,26.14,26.95,27.75,27.98,28.14,28.14,28.85,29.11,29.12,29.87,29.88,30.27,30.82,31.62,32.32,33.33,34.50,35.39,36.26,36.87,37.75,38.70,39.63,40.72,41.76,42.87,44,44.96,45.75,46.51,47.34,48.24,49.07,49.75,50.36,50.96,51.47,51.83,52,52.09,52.23,52.50,52.83,53,53.11,53.21,53.37,53.60,53.75,53.97,54.12,54.25,54.37,54.62,55.20,56.01,57.37,59.75,60,60,59.08,59.10,59.08,60.75,61.83,60.86,61.12,61.12,61.12,61.10,61.07,60.95,60,60,60,60,60.98,62.98,62.98,62,62,62,62.98,62.98,62.98,62.98,62,60.98,60.98,60.98,60.98,60.98,60.98,60.98,60.98,60.98,62,62,62,62.09,62.24,62.47,62.72,62.91,63.12,63.38,63.79,64.34,64.87,65.50,66.25,67.13,68.02,68.76,69.47,70.25,71.16,72.10,72.91,73.76,74.65,75.98,77.98,77.98,77.98,79,80,82.98,82.98,82.98,84,85,87.98,87.98,87.98,89,89,89,89,87.98,87,85.87,85.08,84.75,83.70,82.62,80.58,77.39,76.52,74.82,73.20,71.50,70.22,69.51,67.99,66.58,64.62,62.33,61.95,61.12,60.89,60,59.99,60,57.98,57,55.98,55,55,54,54,52.98,52,52,52,50.98,50.98,50,50,50.15,50.12,49.85,49.37,48.82,47.86,46.40,44.76,43.25,42.15,41.32,40.37,39.21,37.71,37.45,36.90,36.33,35.25,34.24,33.14,32.37,31.62,30.88,30.37,29.85,29.36,28.62,27.52,26.60,25.90,25.60,25.25,25,24,24,24,24,24,25,25,24,22.98,22.98,22,22,20.98,20.98,20.98,20,20,20,19,19,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17,17,17,17,15.98,16,16,16.08,16.99,17.12,17.75,17.97,18.20,18.98,19.75,20.75,20.83,20.87,20.88,20.97,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,22,22,22,22.98,25.98,27.98,27,27,25.98,25,25,24,24,24,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,23.07,23.10,23.12,24.84,25.07,25.15,25.77,26.14,27.75,28.09,28.14,28.82,28.83,28.99,29.12,29.12,29.09,29.02,31.75,32.10,32.87,33.87,34.87,35.51,36.25,36.75,37.37,38.37,39.46,40.50,41.57,42.62,43.62,44.51,45.36,46.12,46.89,47.86,48.75,49.47,50.01,50.74,51.36,51.62,51.62,51.70,51.75,52,52.25,52.48,52.60,52.72,52.87,53.01,53.25,53.37,53.58,53.75,54.09,54.50,55.12,56.08,57.38,58.61,59.32,60,62,62,60.99,60.85,61.11,61.76,61.99,62.22,62.22,62.20,61.99,61.87,61,60.98,60.98,60.98,62,64,64,62.98,62.98,62.98,62.98,62.98,62.98,62,62,60.98,60.98,60.98,60.98,60.98,60.98,60.98,60.98,62,62,62,62,62.20,62.41,62.65,62.88,63.07,63.22,63.45,63.78,64.22,64.66,65.15,65.76,66.50,67.25,67.88,68.50,69.20,70,70.85,71.62,72.46,73.35,74,75.98,75.98,75.98,75.98,79,82.98,82.98,84,85,85.98,87.98,87.98,87.98,87.98,87.98,87,87,85.98,85,84.90,83.12,82.75,82.10,81.64,80.61,76.37,75.52,74.12,72.51,70.75,68.37,68.15,67.15,65.75,64.09,62.22,61.86,61.01,60,59,57.98,57.98,57.98,55.98,55.98,55.98,55.98,55,55,55,52.98,52.98,52,50.98,50.98,50.98,50.98,50.98,50.98,50.72,50.27,49.65,48.76,47.49,45.84,43.86,43.34,42.60,41.70,40.51,39.45,38.62,38.12,37.39,36.37,35.35,34.34,33.50,32.62,31.62,30.87,30.14,29.70,28.87,27.75,26.87,26.21,25.87,25.37,25,25,25,25,24,24,24,24,24,22.98,22.98,22,22,22,22,22,20.98,20.98,20,20,19,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17.98,19,19,19,19,17.98,17,17,17,17,17,16.98,16.98,17.10,17.13,17.22,17.73,17.98,18.25,18.87,19.73,20.10,20.22,20.13,20.87,21,21,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,22,22,22,22,22,22,22,24,25.98,27.98,27,27,25.98,25,25,25,25,24,24,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.90,22.87,22.87,23.11,23.85,24.14,24.82,25.20,26.14,27.75,28.14,28.77,28.83,28.83,28.87,29.12,29.87,30.08,30.01,32,32,34,35,35,35.89,36.08,36.84,37.21,38.23,39.34,40.37,41.37,42.37,43.33,44.12,44.87,45.62,46.37,47.25,48.22,48.87,49.37,50,51.10,50.97,51.10,51.26,51.59,51.86,52.09,52.23,52.32,52.37,52.50,52.64,52.76,52.88,53.10,53.37,53.75,54.25,54.97,55.98,57.25,58.51,59.60,60.87,62.98,63.89,62.12,61.98,62.10,62.25,63.10,63.71,63.97,63.75,63.22,62.20,61.99,61.89,60.98,62,62,62.98,62.98,62.98,62.98,62.98,62.98,62.98,62,62,62,60.98,60.98,60.98,60.98,60.98,60.98,60.98,62,62,62,62,62,62.47,62.66,62.91,63.14,63.32,63.47,63.70,64,64.36,64.70,65.03,65.48,66,66.58,67.11,67.62,68.22,68.95,69.71,70.48,71.21,72.11,72.98,74,74,75,75.98,77,80.98,80.98,82.98,82.98,84,85,85,85,85,85,85,85,84,84,82.96,80.97,80.76,79.75,79.72,78.64,75.36,74.62,73.15,71.74,69.96,68.36,67.62,66.27,65.22,63.75,62.15,61.87,60.98,60,59,57.98,57.98,57.98,57.98,57,57,57,55.98,55.98,55.98,52.98,52.98,52,50.98,50.98,50.98,50.98,52,52,52,50.98,50.98,50.11,48.87,47.23,45.26,44.82,44.22,43.27,42.08,40.87,39.89,39.21,38.37,37.40,36.45,35.47,34.61,33.75,32.75,31.87,31.12,30.50,29.50,28.34,27.45,26.75,26.38,25.87,25,25,25,25,25,24,22.98,22.98,22.98,22,22,20.98,20.98,20.98,20.98,22,22,22,20.98,20,20,17.98,17.98,17.98,17.98,17.98,17.98,17.98,17,17,17.98,19,19,19,17.98,17.98,19,19,19,19,19,17.98,17.98,17.98,17.98,17.89,17.87,17.87,17.82,17.75,17.72,17.83,17.99,18.25,18.75,19.26,19.88,20.25,20.75,20.87,21.07,21.95,21.98,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22.98,25,25.98,25.98,25.98,25,25,25,25,25,25,25,24,22.98,22.98,22.98,22.98,22.98,22.98,22.98,24,22.98,22.98,22,22,22.08,22.11,22.12,23,23.12,24.15,25.12,26.13,28.77,28.90,29.82,28.95,28.12,28.85,29.12,29.87,30.87,32.95,34,34,34,32.98,34,35.87,36.10,36.12,37.24,38.21,39.33,40.37,41.37,42.25,43.09,43.76,44.39,45,45.71,46.45,47.25,47.89,48.37,49,49.64,50.25,50.46,51,51.45,51.75,52,52.20,52.24,52.25,52.35,52.37,52.48,52.57,52.73,53,53.39,53.95,54.62,55.63,57.12,58.95,60,61.24,62.74,63.87,63.10,62.73,62.72,63.07,63.88,65.62,65.62,65.62,64.71,63.75,62.20,61.87,62,62.98,62.98,65,65,64,62.98,62.98,62.98,62.98,62,62,62,62,62,62,62,62,62,62,62.98,62,62,62.98,62.98,62.75,62.95,63.21,63.45,63.62,63.82,64.07,64.37,64.66,64.92,65.15,65.45,65.77,66.16,66.54,66.96,67.40,68.16,68.92,69.73,70.45,71.34,72,72.98,72.98,74,75,75,75.98,75.98,77,77,77.98,79,79,79,80,79,80,80,80,80,79,77.01,77.12,77.15,76.22,75.25,73.25,73.11,72.25,71,69.62,67.33,66.72,65.87,64.77,63.82,62.12,61.96,60.98,60,59,60.98,60.98,60,60,59,57.98,57.98,57,57,55.98,54,54,52.98,52,52,52.98,52.98,52.98,54,54,52.98,52.98,51.88,50.83,48.75,47.12,46.65,45.62,45.60,43.62,42,40.95,40.12,39.23,38.25,37.27,36.37,35.52,34.74,33.73,32.87,32,31.25,30.12,28.96,28.02,27.37,27,26.48,25.98,25.98,25.98,25,25,25,22.98,22.98,22.49,22,21.49,20.98,20.98,20.98,20.98,21.49,21.49,21.49,20.49,20,19.50,17.98,17.98,17.98,17.98,17.98,17.49,17.49,17,17,17.49,19,19,18.49,17.98,17.98,18.49,18.49,19,19,19,18.49,18.49,18.49,17.98,17.97,17.97,17.97,17.97,17.95,17.89,17.89,18,18.14,18.59,19.33,20.13,20.62,20.84,21.12,21.49,21.88,21.99,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22.98,24.50,25.49,25.49,25.49,25,25,25,25,25,25,24.50,24,22.98,22.98,22.98,22.98,22.98,22.98,22.98,23.49,22.98,22.49,22,21.99,22,22,22.11,22.85,23.12,24,25,26.13,28.82,29.15,29.83,28.97,28.12,28.87,29.11,29.99,31,32.48,33.49,33.49,33.49,32.98,34,35.87,36.12,36.50,37.23,38.25,39.38,40.51,41.48,42.25,42.96,43.50,43.96,44.37,44.89,45.50,46.21,46.82,47.26,47.96,48.75,49.62,50.35,50.87,51.37,51.82,52.10,52.24,52.25,52.23,52.25,52.25,52.26,52.37,52.50,52.75,53.11,53.51,54.13,55.12,56.97,58.75,60.23,61.34,62.50,63.83,63.22,63,63.12,63.50,64.37,65.60,65.75,65.25,64.62,63.71,62.24,62,62.09,62.98,63.49,65,65,64,63.49,62.98,62.98,62.98,62,62,62,62,62,62,62,62,62.49,62.49,62.98,62.49,62.49,62.98,62.98,63.01,63.23,63.50,63.75,63.97,64.17,64.45,64.76,65.07,65.27,65.47,65.64,65.88,66.14,66.38,66.72,67.02,67.85,68.52,69.42,69.99,70.88,72,72.98,72.98,74,74.50,75,75.49,75.49,76,76,76.49,77.49,77.49,77.49,77.99,77.49,78.50,78.50,78.50,78.50,78,76,76,75.87,75.32,74.25,72.74,72.21,71.50,70.49,69.22,66.75,66.24,65.40,64.47,63.37,62.02,62,60.98,60,59.99,60.98,60.98,60.49,60,59.50,57.98,57.98,57.49,57,55.98,54,54,53.49,52.49,52.49,52.98,52.98,53.49,54.50,54,52.98,52.98,52.45,51.36,49.49,47.73,47.21,46.52,45.62,44.15,42.84,41.74,40.85,39.89,39,38.09,37.21,36.34,35.50,34.47,33.62,32.72,31.95,30.76,29.50,28.50,27.83,27.47,26.98,26.49,25.98,25.98,25.49,25,25,22.98,22.98,22,22,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20,20,19,17.98,17.98,17.98,17.98,17.98,17,17,17,17,17,19,19,17.98,17.98,17.98,17.98,17.98,19,19,19,19,19,19,17.98,18,18.09,18.11,18.20,18.12,18,17.98,17.99,18.09,18.34,19.24,20.62,20.88,21.12,21.14,21.87,22.09,22.01,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22.98,24,25,25,25,25,25,25,25,25,25,24,24,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22,22,22,21.99,22,22.09,22.86,23.11,23.87,24.85,26.12,28.84,28.84,29.85,28.85,28.11,28.87,28.97,29.89,30.90,32,32.98,32.98,32.98,32.98,34,35.87,36.12,36.75,37.25,38.25,39.63,40.87,41.70,42.37,42.87,43.13,43.38,43.72,44.08,44.50,45,45.58,46.23,47.10,48.23,49.25,50.20,50.75,51.36,51.87,52.20,52.34,52.33,52.25,52.25,52.25,52.25,52.35,52.46,52.62,52.86,53.20,53.73,54.62,56.62,58.63,60.22,61.12,62.33,63.76,63.25,63.26,63.33,63.95,64.37,65.58,65.58,64.99,64.35,63.63,62.25,62.20,62.12,62.98,64,65,65,64,64,62.98,62.98,62.98,62,62,62,62,62,62,62,62,62.98,62.98,62.98,62.98,62.98,62.98,62.98,63.23,63.58,63.89,64.14,64.35,64.52,64.78,65.12,65.41,65.65,65.87,66.10,66.35,66.61,66.83,67.12,67.54,68.33,68.99,69.75,70.27,70.25,72,72.98,72.98,74,74,75,75,75,75,75,75,75.98,75.98,75.98,75.98,75.98,77,77,77,77,77,75,75,74.96,74.87,73.86,72.15,71.77,71.12,70.12,68.75,66.15,65.84,65.12,64.10,63,62,62,60.98,60,60.98,60.98,60.98,60.98,60,60,57.98,57.98,57.98,57,55.98,54,54,54,52.98,52.98,52.98,52.98,54,55,54,52.98,52.98,52.98,51.88,49.85,48.15,47.73,46.88,45.90,44.63,43.46,42.37,41.50,40.62,39.73,38.84,37.95,37.02,36.09,35,34,33.11,32.25,31.25,29.96,28.95,28.25,27.90,27.45,27,25.98,25.98,25.98,25,25,22,22,22,20.98,20.98,20.98,20.98,20.98,20,20,20,20,20,19,17.98,17.98,17.98,17.98,17.98,17.98,17,17,17,17,17,17.98,17.98,17.98,17,17,17.98,17.98,19,19,19,19,19,19,19,18.89,18.87,18.86,18.75,18.25,18.12,18,17.98,18,18.14,18.34,20.62,20.89,21.73,21.97,22.12,22.87,22.87,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22,22,22,22,22,22,22,22.98,24,24,25,25,25,25,25,24,24,24,25,24,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22,22,22,22,22,21.99,22,22.08,22.87,23.09,23.87,24.12,25.12,26.86,27.12,27.84,27.86,27.87,27.87,28.02,28.99,29.99,30.98,32,32,32.98,34,35,36.89,36.98,37.10,37.25,38.25,40.62,41.08,41.75,42.50,42.62,42.63,42.75,42.95,43.14,43.50,43.71,44.25,45.10,46.21,47.57,48.87,49.87,50.50,51.23,51.85,52.13,52.37,52.36,52.34,52.34,52.36,52.37,52.48,52.50,52.62,52.74,52.99,53.47,54.32,56.36,58.60,59.62,60.75,61.87,62.98,63.72,63.75,64.62,64.32,64.75,65.08,65.13,64.75,64.32,63.62,63.09,62.75,62.84,62.98,64,65,65,65,65,64,62.98,62.98,62,62,62,62.98,62.98,62.98,62.98,62.98,62.98,62.98,62.98,62.98,62.98,62.98,62.98,63.96,64.13,64.49,64.67,64.77,64.91,65.15,65.48,65.79,66.10,66.38,66.76,67.20,67.60,67.95,68.37,68.87,69.64,70.27,70.76,71.32,71.96,72,74,74,74,74,74,74,74,74,74,72.98,72.98,72.98,74,74,74,74,74,74,75,75,72.98,72.98,72.98,73,72.88,71.87,71.87,70.84,69.86,68.86,66.10,65.87,65.07,64,62.98,62,62,60.98,60.98,62,60.98,60.98,60.98,60.98,60,59,59,59,57.98,57,55,55,54,54,54,54,54,55,55,55,54,54,52.98,51.96,50.11,48.12,48,47.24,46.50,45.34,44.20,43.14,42.27,41.38,40.50,39.58,38.65,37.75,36.75,35.65,34.62,33.74,32.95,32.12,30.87,30,29.23,28.75,28.11,27,25.98,25.98,25.98,25.98,25,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20,20,20,20,20,19,19,17.98,17.98,17.98,17.98,17.98,17,17,17,17,17,17,17,17,17,17,17,17.98,17.98,17.98,19,19,19,19,19,19,19,19,19,18.83,18.73,18.25,18.12,18,17.98,18,18.34,19.62,20.32,21.72,22.75,23.08,23.08,23,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22.98,22,22,22,22,22,22,22,22,22.98,24,25,25,25,25,24,24,24,24,24,24,22.98,22.98,22.98,22.98,22.98,22,22,22,22,22,22,22,22,21.99,22.01,22.87,22.87,23.09,23.87,24.87,25.86,25.97,26.09,26.87,26.88,26.89,27.01,27.99,29,30,32,32,32.98,34,35.98,37.87,37.84,36.87,37.73,38.23,40.62,40.37,41.64,41.50,41.76,41.99,42.10,42.23,42.37,42.62,42.87,43.50,44.37,45.58,46.98,48.20,49.35,50.09,50.87,51.50,51.98,52.22,52.34,52.37,52.46,52.50,52.62,52.71,52.74,52.73,52.75,52.98,53.50,54.38,56.23,57.87,59.20,60.37,61.45,62.23,63.71,64.10,64.34,64.62,64.75,64.75,64.63,64.60,64.21,63.63,63.25,62.99,62.97,62.98,62.98,65,65,65.98,65.98,65,62.98,62.98,62.98,62.98,62.98,62.98,62.98,62.98,62.98,62.98,62.98,62.98,62.98,62.98,62.98,64,64,64,64.99,65.41,65.25,65.25,65.36,65.59,65.89,66.24,66.60,67.02,67.62,68.32,69,69.64,70.28,71.03,72,72.87,73.49,73.17,72.98,74,74,74,74,74,72.98,72.98,72.98,72.98,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,70.98,70,70,70,69,67.98,65.98,65.98,65,65,65,62.98,62.98,62.98,62,62,62,62,62,62,60.98,60.98,60.98,60,59,57.98,55.98,55.98,55,55,55,55,55,55.98,55,55,54,54,52.98,52,50.90,49.11,48.85,48.11,47.35,46.12,45.07,44.10,43.20,42.25,41.27,40.34,39.37,38.48,37.50,36.50,35.58,34.83,34.20,33.59,32.50,31.62,30.75,30.27,29.37,27.98,27,27,25.98,25.98,25.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20,20,20,20,20,19,19,17.98,17.98,17.98,17,17,17,17,17,17,17,17,17,17,17,17,17,17.98,17.97,18,18.96,19,19,19,19,19,19,19,19,18.95,18.82,18.64,18.23,18,17.97,18,18.34,19.62,20.26,21.24,22.75,23.87,24.87,24.89,25,25,25,24,24,22.98,22.98,22.98,22,22,22,22,22,22,22,22,22.98,24,24,24,25,25,24,24,24,22.98,24,24,24,24,22.98,22.98,22,22,22,22,22,22,22,22,22,22,22,22.01,22.02,22.87,23.02,24.09,24.88,24.98,24.08,25.08,25.02,26,25.99,27.98,29,30,32,32,32.98,35,35.98,36,36.10,36.12,36.21,37.25,38.25,38.82,39.87,40.45,40.87,41.25,41.50,41.62,41.87,42.25,42.62,43.36,44.23,45.37,46.75,47.95,48.38,49.64,50.60,51.25,51.75,52.07,52.25,52.39,52.59,52.75,52.87,52.98,52.96,52.87,52.87,53.11,53.75,54.75,56.36,57.86,59,60.09,61.14,62.22,63.72,64.07,64.37,64.64,64.73,64.37,64.34,64.23,64.10,63.62,63.25,62.99,62.98,62.98,62.98,64,64,64,64,64,62.98,62.98,62.98,62.98,62.98,62.98,62.98,62.98,62.98,62.98,62.98,62.98,64,64,64,64,64,65,67,65.96,65.70,65.66,65.78,66.03,66.38,66.75,67.14,67.66,68.46,69.46,70.54,71.37,72.12,73.02,74.14,76.40,76.72,77,75.98,75,72.98,72.98,72,72,72,70.98,70.98,70.98,70.98,70,70,70,70,70,70,70,70,70,70,70,70,70,70,69,69,67.98,67.98,67.98,67,67,67,67,67,65.98,65.98,65,65,65,64,64,62.98,62.98,62.98,62,62,60.98,60.98,60,59,59,57,57,57,57.98,57,55.98,55.98,55,55,55,55,55,54,52.98,52,50.01,49.88,48.87,47.86,46.85,45.84,44.97,44.12,43.20,42.12,41.01,40.01,39.12,38.23,37.37,36.62,35.96,35.45,34.95,33.96,33.12,32.14,31.62,31.75,30,27.98,27.98,27,27,25.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20,20,20,19.50,19.50,19,19,17.98,17.49,17.49,17,17,17,17,17,17,17,17,17,17,17,17,17,17.96,17.97,18,18.88,19,19,19,19,19,19,19,19,18.98,18.88,18.71,18.25,18,17.98,18,18.32,19.64,20.25,21.21,22.34,23.61,25.37,25.49,25.49,25.49,25,24,24,23.49,22.98,22.98,22,22,22,22,22,22,22,22,22.49,23.49,24,24,24.50,24.50,24,23.49,23.49,22.98,23.49,24,24,24,22.98,22.98,22,22,22,22,22,22,22,22,22,22,22,22,22,22.49,23,23.95,24.45,24.45,24.01,24.50,25,26.49,26.49,27.98,29,30,32,32,32.98,34.50,35.49,35.49,35.49,35.50,35.64,36.70,37.71,38.37,38.75,39.45,40.24,40.82,41.24,41.50,41.85,42.37,43.01,43.87,44.62,45.70,47.07,48.22,49.22,49.75,50.46,51.09,51.60,51.87,52.12,52.37,52.64,52.97,53.12,53.22,53.12,53.08,53.10,53.33,54.12,55.33,56.83,58.10,59.22,60.10,61.11,62.20,63.73,64.12,64.49,64.75,64.62,64.34,64,64,63.99,63.63,63.25,62.99,62.98,62.98,62.98,63.49,63.49,64,64,64,62.98,62.98,62.98,62.98,62.98,62.98,62.98,62.98,62.98,62.98,63.49,63.49,64,64,64,64.50,64.50,65.49,67,65.98,65.91,65.97,66.14,66.47,66.87,67.27,67.72,68.26,69.11,70.32,71.51,72.76,73.64,74.64,75.53,76.21,76.49,76.49,75.49,74.50,72.49,72.49,72,71.49,71.49,70.98,70.98,70.49,70.49,70,69.50,69.50,69.50,69.50,69.50,69.50,69.50,69.50,69.50,69.50,69.50,69.50,69.50,69,68.49,67.98,67.98,67.98,67.49,67.49,67.49,67.49,67,66.49,65.98,65,65,65,64.50,64.50,63.49,63.49,62.98,62.49,62,60.98,60.98,60,59.50,59,57.49,57.49,57.49,57.98,57.49,55.98,55.98,55,55,55.49,55.49,55.49,54.50,53.99,52.49,50.50,50.45,49.46,48.45,47.40,46.49,45.64,44.88,43.96,42.84,41.62,40.61,39.70,38.87,38.14,37.52,36.99,36.40,35.95,34.96,34.12,33.13,32.62,31.89,30.49,28.49,28.49,27.49,27,26.49,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20,20,20,19,19,19,19,17.98,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17.88,18.01,18.08,18.87,19,19,19,19,19,18.98,18.99,18.99,18.97,18.88,18.74,18.25,18,17.99,18.12,18.25,19.72,20.25,21.08,22.10,23.09,25.87,25.89,25.98,25.98,25,24,24,24,22.98,22.98,22,22,22,22,22,22,22,22,22,22.98,24,24,24,24,24,22.98,22.98,22.98,22.98,24,24,24,22.98,22.98,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22.98,24,24,24,24,24,25,27,27,27.98,29,30,32,32,32.98,34,35,35,34.96,34.87,35.12,36.12,37.75,37.87,38.38,39.12,39.88,40.62,41.21,41.73,42.23,42.87,43.59,44.50,45.23,46.23,47.62,49.49,49.63,50,50.37,51.12,51.51,51.72,51.87,52.25,52.64,53.12,53.37,53.37,53.26,53.23,53.35,53.75,54.64,55.97,57.25,58.39,59.26,60.08,61.13,62.13,63.75,64.12,64.63,64.62,64.62,64.23,64,63.99,63.97,63.71,63.22,62.99,63.07,62.98,62.98,62.98,62.98,64,64,64,62.98,62.98,62.98,62.98,62.98,62.98,62.98,62.98,62.98,62.98,64,64,64,64,64,65,65,65.98,67,65.98,65.98,66.17,66.40,66.88,67.37,67.82,68.25,68.76,69.57,70.96,72.48,73.75,74.85,75.73,76.15,75.98,75.98,75.98,75,74,72,72,72,70.98,70.98,70.98,70.98,70,70,70,69,69,69,69,69,69,69,69,69,69,69,69,69,69,67.98,67.98,67.98,67.98,67.98,67.98,67.98,67.98,67,67,65.98,65,65,65,65,65,64,64,62.98,62.98,62,60.98,60.98,60,60,59,57.98,57.98,57.98,57.98,57.98,55.98,55.98,55,55,55.98,55.98,55.98,55,54.99,52.89,51.01,50.87,50,49.08,47.87,46.96,46.26,45.50,44.52,43.37,42.12,41.08,40.20,39.50,38.87,38.26,37.74,37.07,36.38,35.45,34.64,33.84,33.13,32,30.98,29,29,27.98,27,27,22,22,20.98,20.98,20.98,20,20.01,20.12,19.95,19.63,19.11,18.73,18.62,18.27,17.76,17.14,17,17,17,17,17,17,17,17,17,17,17,17,16.99,17.01,17.87,18.08,18.87,18.87,19,18.98,18.96,18.95,18.96,18.96,18.89,18.89,18.89,18.82,18.75,18.22,18,18,18.25,18.87,19.75,20.21,20.87,21.87,23.07,24.95,25,25.98,25.98,25.98,25,25,24,24,22.98,22,22,22,22,22,22,22,22,22,22,22.98,22.98,22.98,22.98,24,22.98,22.98,22.98,22.98,22.98,24,24,22.98,22.98,22,22,22,22,22,22,22,22,22,22,22,22,22,22.09,22.25,22.87,23.22,23.51,24,24.75,26.09,27.57,28.25,29.88,30,30.98,32,32,32.98,34,35,34,34,34.01,34.11,35.12,36.99,37.20,38.26,39,39.85,40.60,41.25,42,42.74,43.50,44.12,45.10,45.75,46.74,47.87,49.75,49.74,49.96,50.70,51.71,51.50,51.35,51.39,51.87,52.57,53.23,53.61,53.47,53.33,53.32,53.59,54.20,55.14,56.37,57.87,58.62,59.47,60.25,61.22,62.85,63.76,64.10,64.23,64.33,64.24,64.12,64,63.99,63.98,63.75,63.13,62.99,63,64,62.98,62.98,62.98,62.98,64,62.98,62.98,62.98,62.98,62.98,62.98,62.98,62.98,62.98,62.98,64,64,64,64,64,64,65,65,65.98,65.98,65.98,67,67,66.99,67.25,67.85,68.49,68.72,69.14,70,71.73,73.86,74.83,76,77.21,77.36,76.35,75.75,75,74,72.98,72,72,70.98,70.98,70.98,70,70,70,70,70,69,69,69,69,67.98,67.98,67.98,67.98,67.98,67.98,67.98,67.98,67.98,67.98,67.98,67.98,67.98,67.98,67.98,67.98,67.98,67.98,67.98,67,67,65.98,65.98,65.98,65.98,65.98,65,65,64,62.98,62,60.98,60.98,60.98,60,60,59,59,59,57.98,57.98,55.98,55.98,55.98,55.98,55.98,55.98,55.98,55.97,54.95,53.85,51.36,51.12,50.42,49.53,48.58,47.62,46.75,45.86,44.88,43.85,42.77,41.76,40.89,40.12,39.40,38.74,38.08,37.38,36.62,35.78,35.10,34.75,34,32.98,30.98,30,30,29,27.98,27,22,22,20.98,20.98,20.98,20.12,20,20,19.88,19.50,18.57,18.58,18.35,18.07,17.65,17.32,17.01,16.99,17,17,17,17,17,17,17,17,17,17,16.99,17.07,18.87,18.87,18.87,18.86,18.82,18.75,18.75,18.75,18.75,18.75,18.76,18.82,18.83,18.84,18.13,18.12,18,18.12,18.25,19.26,19.96,20.25,21,21.15,22.13,23.87,24.02,25.97,27,25.98,25,25,24,24,24,22,22,22,22,22,22,22,22,20.98,20.98,22,22,22,22.98,22.98,22,22,22,22,22,22.98,22.98,22.98,22,22,22,22,22,22,22,22,22,22,22,22,22,21.99,22.11,22.45,22.75,23.45,23.87,24.46,25.35,26.75,28.25,29.50,30.51,31.76,32,32,32,32.98,34,35,32.99,33,34.09,35.12,36.15,37.73,38.12,38.23,39,39.72,40.50,41.36,42.14,43.08,43.96,44.51,45.37,46.26,46.64,47.75,48.82,49.13,49.83,49.88,50.84,50.11,50.08,50.88,51,52.01,53.62,53.64,53.36,53.20,53.25,53.72,54.37,55.37,56.86,57.62,59.12,59.37,60.12,62,62.87,63.86,63.76,64,64.12,64.12,64,64,64,63.98,63.76,63.12,62.98,62.98,64,64,62.98,62.98,62.98,62.98,62.98,62.98,63,63.01,63.08,63.87,63.87,63.87,63.87,63.88,63.97,64,64,64,64,65,65,65,65,65.98,65.98,67,67,67.98,67.98,67.98,69,69,69.36,70.25,71.99,74.98,75.09,76.87,76.87,76.98,75.74,75.34,74.62,74,72.98,72,72,70.98,70.98,70.98,70,70,70,70,69,69,69,69,67.98,67.98,67.98,67.98,67,67,67,67,67,67.98,67.98,67.98,67.98,67.98,69,69,69,67.98,67.98,67.98,67.98,67,65.98,65.98,65.98,65.98,65.98,65,65,65,64,62.98,62,62,60.98,60.98,60.98,60,60,59,59,57.98,57,57,55.98,57,57,57,57,56,55.66,53.97,52.72,51.70,50.92,50.07,49.12,48.17,47.25,46.32,45.36,44.36,43.37,42.40,41.50,40.67,39.89,39.14,38.41,37.71,36.97,36.25,35.38,35,35,32.98,32,30,30,29,27.98,27.98,20,20,20,20,20.13,20.12,20,20,19.86,19.50,19.02,18.62,18.32,17.98,17.62,17.35,17.12,17,17,17,17,17,17,17,17,17,17,17,16.99,17.08,17.87,18.11,18.12,18.12,18.10,17.25,17.25,17.25,17.25,17.25,17.98,18.12,18.12,18.11,18.11,18,18.12,18.40,18.97,19.60,20.23,20.75,21.25,21.85,22.62,23.60,24.20,25.87,26.96,27.98,25.98,25.98,25,24,24,22,22,22,22,22,20.98,20.98,20.98,20.98,20.98,20.98,20.98,20.98,22,22,20.98,20.98,20.98,20.98,20,20.98,20.98,22,22,22,22,22,22,22,22,22,22,22,22,22,21.99,22.02,22.35,22.85,23.50,24,24.47,24.88,25.65,27.26,28.98,30,30.50,31.08,31.23,32,32,32,32,32.01,33.88,33.98,34.85,35.76,36.77,38.75,38.75,38.75,38.95,39.37,40.45,41.35,42.12,43.10,43.87,44.50,45.24,45.70,46.11,46.12,47.83,48.12,48.86,48.87,48.09,49.08,49,50,50,52,54,53.64,53.12,52.74,53.12,53.72,54.38,55.26,56.12,56.72,57.89,58.25,60,60.98,62,62.98,63.11,63.87,64.76,64.22,64.13,64.12,64.01,63.99,63.87,63,62.98,62.98,62.98,62.98,62.98,62.98,62.98,62.98,62.98,63.95,63.87,63.86,63.84,63.85,63.98,64,64.11,64.12,64.11,64.01,64,65,65,65,65.98,65.98,65.98,65.98,65.98,67.98,67.98,69,69,69,69,69.34,69.64,70.38,71.75,72.99,74.08,74.63,75.01,74.98,74.71,74.23,73.64,73.07,72,70.98,70.98,70.98,70.98,70.98,70,70,70,70,69,67.98,67.98,67.98,67.98,67,67,67,65.98,65.98,65.98,67,67,67,67.98,67.98,69,69,69,69,69,69,69,69,67.98,67.98,67,67,67,67,67,65.98,65.98,65.98,65.98,65,64,64,62.98,62.98,62,60.98,60.98,60,60,59,57.98,57.98,57.98,57.98,57.98,57,56.99,56.65,55.57,54.38,53.23,52.26,51.40,50.53,49.62,48.67,47.75,46.82,45.86,44.88,43.92,42.99,42.09,41.21,40.34,39.50,38.72,37.99,37.29,36.65,36.10,35.70,35,34,32,30,30,30,29,29,19.50,19.50,19.50,19.62,19.84,19.97,20,19.99,19.87,19.61,19.15,18.74,18.32,17.95,17.61,17.34,17.12,17.07,17.02,17.01,17,17,17,17,17,17,17,17,16.99,17.09,17.87,17.97,17.99,17.97,17.73,17.25,17.08,17,17.01,17.21,17.37,17.50,17.63,17.87,17.97,18.10,18.32,18.75,19.36,20,20.62,21.15,21.72,22.27,23.12,23.96,25,25.87,26.96,27.90,25.98,25.98,25,24,24,22,22,22,22,22,20.98,20.98,20.98,20.49,20.49,20.98,20.98,20.98,22,22,20.49,20.49,20.98,20.49,20,20.98,20.98,21.49,22,22,22,22,22,22,22,22,22,22,22,21.99,22,22.14,22.64,23.46,24.26,24.75,24.96,25.25,26,27.61,28.97,30.12,30.34,30.64,31.13,31.76,32,32,32.40,32.60,33.85,34.20,34.83,35.62,36.74,38.24,38.45,38.62,38.85,39.20,40.83,41.09,41.95,42.49,43.49,44.48,44.51,45.37,45.49,45.60,47.37,47.61,47.87,47.87,47.57,48.96,49,50,50.49,52,53.49,53.49,52.63,52.37,53,53.63,54.37,55,55.70,56.37,57.75,57.98,59.50,60.98,62,62.98,63,63.58,64.37,64.50,64.50,64.36,64.12,64,63.97,62.98,62.98,62.98,62.98,62.98,62.98,62.98,62.98,62.98,63,63.87,63.96,63.97,63.98,64,64,64.14,64.34,64.47,64.48,64.48,64.51,65,65,65.49,65.98,65.98,65.98,65.98,66.50,68.46,68.50,69.45,69.39,69.45,69.45,69.60,69.87,70.45,71.25,72.12,72.76,73.12,73.50,73.62,73.61,73.37,73,72.49,71.76,70.98,70.98,70.98,70.98,70.98,70,70,70,70,69,67.98,67.98,67.98,67.98,67,66.49,66.49,65.98,65.98,65.98,66.49,66.49,67,67.49,67.98,69,69,69,69,69,69,69,69,68.49,67.98,67.49,67.49,67.49,67.49,67.49,66.49,66.49,66.49,65.98,65.49,64.50,64.50,63.49,63.49,62.49,60.98,60.98,60.49,60,59.50,58.49,58.49,58.49,58.49,57.98,57,56.88,56.46,55.70,54.62,53.62,52.72,51.86,51,50.10,49.16,48.25,47.33,46.39,45.46,44.50,43.58,42.64,41.74,40.76,39.86,39.02,38.29,37.62,37.03,36.54,35.90,35.12,34,32.49,30.49,30.49,30,29.50,29,19,19,19.01,19.25,19.70,19.87,19.96,19.97,19.87,19.62,19.25,18.83,18.37,17.95,17.59,17.32,17.12,17.11,17.12,17.11,17.08,17,17,17,17,17,17,17,16.99,17.09,17.86,17.97,17.88,17.75,17.71,17.20,16.98,16.89,16.99,17.08,17.12,17.25,17.21,17.85,18.02,18.26,18.62,19.12,19.75,20.45,21.09,21.62,22.22,22.88,23.75,24.75,25.60,26.21,26.75,27.87,26,25.98,25,24,24,22,22,22,22,22,20.98,20.98,20.98,20,20,20.98,20.98,20.98,22,22,20,20,20.98,20,20,20.98,20.98,20.98,22,22,22,22,22,22,22,22,22,22,21.99,22,22,22.25,22.88,23.64,24.37,24.75,25.01,25.37,26,27.50,28.73,29.76,30,30.46,31.14,31.86,32.09,32.01,32.87,33.12,33.76,34.20,34.73,35.49,36.50,37.37,38,38.32,38.75,39.57,40.50,41.22,41.87,42.01,42.98,44,44,44.97,45.01,45.07,46.88,46.89,47,47.01,47,49,49,50,50.98,52,52.98,52.98,52,52,52.98,54,54,55,55.98,55.98,57.98,57.98,59,60.98,62,62.98,62.98,62.98,64,65,65,65,64,64,64,62.98,62.98,62.98,62.98,62.98,62.98,62.98,62.98,63,63.09,63.84,63.97,63.99,64,64.12,64.25,64.25,64.67,64.71,64.75,64.79,64.95,65.13,65.45,65.78,66.11,66.27,66.21,66.03,67.25,68.49,69.08,69.39,69.73,69.75,69.83,69.87,70.12,70.50,71,71.51,72,72.37,72.62,72.83,72.86,72.75,72.61,72.25,71.70,70.98,70.98,70.98,70.98,70.98,70,70,70,70,69,67.98,67.98,67.98,67.98,67,65.98,65.98,65.98,65.98,65.98,65.98,65.98,67,67,67.98,69,69,69,69,69,69,69,69,69,67.98,67.98,67.98,67.98,67.98,67.98,67,67,67,65.98,65.98,65,65,64,64,62.98,60.98,60.98,60.98,60,60,59,59,59,59,57.98,57.20,56.85,56.40,55.75,54.90,54,53.17,52.36,51.51,50.62,49.72,48.79,47.89,46.98,46.04,45.12,44.17,43.25,42.29,41.35,40.32,39.47,38.74,38.07,37.42,36.82,36.14,35.33,34.20,32.98,30.98,30.98,30,30,29,19,19,19,19.25,19.61,19.76,19.87,19.95,19.87,19.70,19.36,18.95,18.47,18,17.61,17.27,17.12,17.12,17.12,17.13,17.10,17,17,17,17,17,17,17,16.99,17.09,17.87,17.85,17.75,17.73,17.20,16.87,16.63,16.74,16.87,17.12,17.25,17.25,17.75,17.85,18.12,18.49,18.90,19.50,20.23,20.95,21.60,22.12,22.70,23.37,24.38,25.57,26.37,26.40,26.36,26,25.75,25.52,24.86,24.25,23.35,22.60,22,21.97,21.75,20.98,20.98,20.98,20,20,20,20.98,20.98,20.98,20.98,20,20,20,20,19,19,20,20,20.98,20.98,20.98,22,22,22,22,22,22,22,22,21.99,22.11,22.23,22.57,23,23.64,24.25,24.72,25,25.37,26.01,27.37,28.50,29.37,29.62,30.12,31.08,32.37,32.70,32.87,32.97,33.76,33.76,34.13,34.64,35.37,36.37,37.25,37.89,38.34,38.89,39.75,40.57,41.25,41.70,42.09,42,44,44,44,45,45,45.98,45.98,45.98,47,47,50,50,50.98,50.98,50.98,52,52,52,52.98,55,55,55,55.98,57,57,57.98,57.98,59,60,60.98,62,62,62,62.98,64,65,65,65,64,64,62.98,62.98,62.98,62.98,62.98,62.98,62.98,64,63.88,63.86,63.86,63.98,64,64.07,64.25,64.63,64.75,64.88,65,65.09,65.16,65.28,65.50,65.82,66.20,66.51,66.74,66.87,67.23,67.83,68.50,69.24,69.73,69.97,70.12,70.23,70.32,70.50,70.86,71.22,71.59,71.95,72.25,72.50,72.63,72.72,72.65,72.50,72.23,71.71,70.98,70.98,70.98,70.98,70.98,70,70,70,70,69,67.98,67.98,67.98,67,67,65.98,65.98,65,65,65,65.98,65.98,65.98,67,67,69,69,69,69,69,69,69,69,68.75,68.51,68.32,68.32,68.32,68.25,68.07,67.98,67.98,67,67,67,65.98,65.98,65,65,64,62,62,62,60.98,60,60,60,60,59,58,57.37,56.97,56.61,56.02,55.33,54.53,53.76,52.97,52.12,51.23,50.33,49.41,48.52,47.62,46.67,45.75,44.82,43.87,42.92,41.98,40.98,40.10,39.37,38.66,37.92,37.21,36.52,35.75,34.78,33.96,32,32,30.98,30.98,30,19,19,18.87,19.13,19.45,19.65,19.84,19.88,19.87,19.73,19.47,19.11,18.62,18.12,17.62,17.26,17.10,17.02,17.07,16.99,16.87,16.85,16.99,17,17,17,17,17,16.99,17.08,17.11,17.12,17.21,17.09,16.75,16.25,16.26,16.26,16.64,17.23,17.64,17.96,17.77,17.87,18.13,18.61,19.20,19.87,20.63,21.38,22,22.50,23,23.60,24.39,26.27,26.49,25.75,25.25,24.74,24.34,24.20,24.12,23.50,23,22.50,21.88,21.74,21.39,20.75,20,20,20,20,20,20,20,20.98,20,20,20,20,20,20,20.98,22,22,22,22,22,22.98,22.98,22,22,22,22,22,22,22.38,22.75,22.88,23.10,23.36,23.70,24.25,24.70,25.02,25.37,25.89,26.90,27.82,28.50,28.89,29.47,30.57,32.23,32.50,32.85,32.75,33.25,33.77,34.26,34.90,35.82,36.96,37.87,38.60,39.12,39.76,40.38,40.97,41.37,41.70,41.89,42.02,44,44,44,45,45,45.98,45.98,45.98,47,47,49,49,50,50.98,50.98,52,52,52.98,54,55.98,55.98,55.98,55.98,57,57.98,57.98,57.98,59,60,60,60.98,60.98,62,62.98,64,65,65,65,64,64,62.98,62.98,62.98,62.98,62.98,64,64,64,63.98,63.97,63.98,64,64.12,64.25,64.34,64.86,65.09,65.24,65.36,65.49,65.62,65.77,66.01,66.34,66.70,67.02,67.32,67.60,67.97,68.46,69.01,69.50,70.01,70.35,70.58,70.75,70.89,71.10,71.33,71.59,71.87,72.12,72.38,72.62,72.75,72.84,72.77,72.63,72.36,71.89,70.98,70.98,70.98,70.98,70.98,70,70,70,69,69,67.98,67.98,67,67,65.98,65,65,65,65,65,65.98,65.98,65.98,65.98,67,67.98,67.98,69,68.87,69.11,69.22,69.33,69.33,69.22,69.10,68.99,68.99,68.99,68.99,68.87,68.20,67.98,67.98,67.98,67.98,67,67,65.98,65.98,65,64,64,62.98,62,62,60.98,60.98,60,59,58.24,57.62,57.46,57.08,56.54,55.91,55.22,54.48,53.66,52.79,51.89,50.99,50.10,49.21,48.27,47.35,46.39,45.47,44.52,43.59,42.64,41.74,40.86,40.15,39.41,38.60,37.76,37.08,36.37,35.52,34.25,32.98,32.98,32,30.98,30.98,17.98,17.98,18.63,18.89,19.22,19.50,19.73,19.85,19.86,19.75,19.60,19.27,18.86,18.26,17.73,17.25,17.03,16.91,16.84,16.77,16.77,16.88,17.10,17.37,17.46,17.17,17.02,16.99,16.99,16.99,16.99,16.99,16.95,16.75,16.25,16.12,16.01,16.12,16.25,17.22,18.72,18.75,17.75,17.75,18.10,18.62,19.34,20.11,20.89,21.63,22.23,22.63,23.01,23.37,23.87,24.24,24.37,24.22,23.87,23.46,22.65,22.59,22.48,22.48,22.33,22,21.70,21.25,20.83,20.07,19.32,19,19,17.98,17.98,17.98,17.98,17.98,20,20.98,22,22,22.98,22.98,22.98,24,24,24,24,24,24,24,24,24,24,25,25,25,23.73,23.60,23.58,23.61,23.70,23.87,24.37,24.83,25.15,25.49,25.87,26.60,27.23,27.75,28.20,28.75,29.85,30.75,31.37,31.12,32.35,33.09,33.84,34.62,35.52,36.62,37.75,38.75,39.50,40.11,40.64,41.14,41.37,41.52,41.62,41.75,42.11,42,42,42.98,44,45,47,47,47.98,47.98,47.98,49,49,49,50,50.98,52.98,52.98,54,54,55,55,55,55.98,57,57.98,60,60,60,60,60,60,60,60.98,62,62,64,64,64,64,64,62.98,62.98,62.98,64,64,64,64,64,63.99,63.99,64,64.10,64.26,64.62,64.87,65.13,65.38,65.58,65.74,65.91,66.12,66.33,66.59,66.90,67.27,67.63,67.96,68.27,68.64,69.10,69.59,70.07,70.50,70.87,71.22,71.37,71.58,71.75,71.95,72.14,72.38,72.62,72.86,73.01,73.14,73.22,73.13,72.98,72.62,72.15,72,72,70.98,70.98,70.98,70,70,70,69,67.98,67,67,65.98,65.98,65,64,64,64,64,64,64,64,65,65,65,67.98,67.98,68.12,68.49,69,69.33,69.63,69.72,69.75,69.75,69.72,69.63,69.63,69.63,69.60,69.51,69.74,70,70,69,67.98,67.98,67.98,67.98,67.98,65.98,65.98,65,64,63.75,62.76,62.39,61.48,60.48,59.39,58.75,58.24,57.76,57.24,56.62,55.95,55.21,54.39,53.51,52.61,51.70,50.79,49.88,48.97,48,47.04,46.11,45.16,44.24,43.34,42.46,41.64,40.97,40.21,39.34,38.46,37.72,37.04,36.27,35.58,34,34,32.98,32,30.98,17.98,17.98,18.25,18.59,18.87,19.25,19.52,19.72,19.75,19.75,19.71,19.48,19.02,18.45,17.76,17.33,17,16.79,16.70,16.65,16.72,16.90,17.21,17.51,17.50,17.27,17.10,17,16.98,16.99,16.99,16.99,16.82,16.47,16.12,15.98,15.96,16,16.25,17,17.74,17.75,17.58,17.51,17.97,18.59,19.34,20.12,20.88,21.60,22.12,22.58,22.87,23,23,22.76,22.62,22.62,22.57,22.25,21.95,21.47,21.37,21.60,21.62,21.58,21.25,20.76,20.12,19.36,18.50,18,18,17.49,17.98,18.49,18.49,18.99,20.49,21.49,22.49,22.49,22.98,23.49,23.49,24,24,24,24.50,24.50,24.50,24.50,24.50,24.50,24.50,25,25,25,24.82,24.47,24.13,24,24.01,24.22,24.62,25.10,25.40,25.62,25.87,26.37,26.71,27.21,27.50,28.20,29.15,30,30.62,31.24,31.89,32.90,33.95,35,36.12,37.48,38.75,39.71,40.47,41,41.39,41.62,41.63,41.60,41.49,41.50,41.62,41.89,42,42.98,44,45,47,47,47.98,47.98,47.98,49,49,49,50,50.98,52.98,52.98,53.49,54,54.50,55,55,55.98,57,57.98,60,60,60,60.49,60.49,60,60,60.98,61.49,62,64,64,64,64,64,62.98,62.98,62.98,63.49,64,64,64,64,64,64,64,64.21,64.50,64.84,65.14,65.42,65.67,65.89,66.11,66.34,66.58,66.82,67.10,67.45,67.85,68.24,68.60,68.95,69.34,69.76,70.23,70.67,71.08,71.45,71.82,72.10,72.32,72.50,72.71,72.88,73.12,73.33,73.50,73.62,73.73,73.75,73.63,73.39,73.01,72.57,72.12,72,71.49,70.98,70.98,70,70,70,69,67.98,67,67,65.98,65.49,65,64,64,64,64,64,64,64,64.50,64.50,65,66.98,67.12,67.49,67.83,68.63,69.33,70,70.13,70.33,70.33,70.13,70,70,70,70.13,70.33,70.49,70.33,70,69.50,68.99,68.99,68.49,68.49,68.47,67.22,66.62,65.95,65.13,64.37,63.75,63,62.25,61.37,60.49,59.73,59.12,58.53,57.95,57.29,56.62,55.87,55.08,54.21,53.29,52.39,51.50,50.59,49.62,48.64,47.66,46.72,45.77,44.87,43.99,43.13,42.36,41.66,40.87,39.97,39.04,38.28,37.61,36.86,35.60,34,34,32.98,32,31.49,17.98,17.98,18,18.12,18.47,18.87,19.24,19.47,19.62,19.72,19.73,19.58,19.15,18.52,17.86,17.33,16.95,16.71,16.60,16.61,16.74,16.98,17.27,17.49,17.49,17.29,17.11,16.99,16.95,16.92,16.99,16.88,16.85,16.12,15.83,15.72,15.71,15.75,16.10,16.74,17.09,17.20,17.34,17.37,17.87,18.50,19.23,19.97,20.65,21.35,21.87,22.33,22.61,22.62,22.25,21.77,21.50,21.38,21.37,21.25,21.02,20.85,20.64,20.85,21,21.01,20.83,20.33,19.58,18.62,17.62,17,17,17,17.98,19,19,20,20.98,22,22.98,22.98,22.98,24,24,24,24,24,25,25,25,25,25,25,25,25,25,25,25.37,25.07,24.62,24.37,24.37,24.52,24.90,25.26,25.57,25.75,25.98,26.33,26.71,27.10,27.38,27.97,28.87,29.62,30.20,30.86,31.62,32.77,33.97,35.24,36.37,37.74,39.09,40,40.71,41.07,41.26,41.37,41.37,41.23,41.02,40.97,41.26,41.74,42,42.98,44,45,47,47,47.98,47.98,47.98,49,49,49,50,50.98,52.98,52.98,52.98,54,54,55,55,55.98,57,57.98,60,60,60,60.98,60.98,60,60,60.98,60.98,62,64,64,64,64,64,62.98,62.98,62.98,62.98,64,64,64,64,64,64.12,64.24,64.25,64.74,65.08,65.39,65.70,65.96,66.22,66.48,66.74,67,67.25,67.54,67.95,68.38,68.85,69.25,69.63,70.04,70.50,70.96,71.39,71.82,72.15,72.51,72.87,73.13,73.37,73.60,73.82,74,74.21,74.34,74.39,74.47,74.46,74.34,74.07,73.62,73,72.26,72.01,72,70.98,70.98,70,70,70,69,67.98,67,67,65.98,65,65,64,64,64,64,64,64,64,64,64,65,65.87,66.12,66.37,66.72,67.62,68.63,69.40,69.83,70.21,70.33,70.13,70.11,70.22,70.33,70.49,70.62,70.82,70.62,70.09,70,70,70,69,69,69,68.39,67.63,66.87,66.12,65.32,64.58,63.85,63.08,62.23,61.39,60.63,59.95,59.27,58.62,57.92,57.23,56.50,55.71,54.87,53.99,53.09,52.20,51.26,50.29,49.28,48.28,47.33,46.38,45.49,44.61,43.76,42.98,42.25,41.41,40.49,39.57,38.77,38.03,37.16,35.89,34,34,32.98,32,32,17.98,17.98,17.60,17.50,17.86,18.33,18.75,19.02,19.34,19.57,19.65,19.60,19.24,18.49,17.85,17.27,16.87,16.63,16.58,16.63,16.83,17.10,17.37,17.53,17.50,17.29,17.09,16.92,16.84,16.76,16.70,16.95,16.09,15.83,15.20,15.22,15.24,15.24,15.75,16.21,16.82,17.11,17.37,17.60,18.01,18.50,19.01,19.62,20.24,20.84,21.39,21.85,22.25,22.24,21.60,20.86,20.38,20.27,20.35,20.27,20.15,20.02,19.98,20.12,20.35,20.46,20.25,19.75,18.98,18,17,16.23,15.98,17,19,20.98,20.98,20.98,20.98,22,22.98,22.98,24,24,22.98,24,24,24,25,25.98,25,25,25,25,25,25.98,25.98,25.98,26.09,25.75,25.36,25,25,25.12,25.37,25.60,25.75,25.89,26,26.48,26.89,27.32,27.58,27.88,28.65,29.24,29.86,30.57,31.37,32.62,33.82,35,36.02,37.25,38.65,39.70,40.40,40.62,40.75,40.82,40.75,40.62,40.50,40.40,40.85,41.60,42,42.99,43.99,45,46.96,47,47,47.97,47.98,49,49,50,50,50.98,52,52,52.98,52.98,54,55,55,55.98,55.98,57.98,60,60,60.98,60.98,60.98,60.98,60.98,60.98,60.98,62,62.98,62.98,64,64,64,62.98,62.98,62.98,62.98,64,64,64,64,64,64.12,64.75,64.75,65.04,65.37,65.65,65.97,66.25,66.58,66.87,67.15,67.41,67.67,68,68.46,68.97,69.50,69.96,70.38,70.83,71.29,71.78,72.25,72.66,73.08,73.40,73.83,74.12,74.37,74.62,74.87,75.11,75.25,75.37,75.45,75.46,75.37,75.25,74.98,74.49,73.71,73.07,72.77,72,72,70.98,70,70,69,69,67.98,65.98,65.98,65,65,64,64,64,64,64,64,64,64,64,64,64,64.75,65.10,65.33,65.63,66.62,67.51,68.51,69.10,69.75,70.21,70.33,70.40,70.51,70.75,70.98,71.21,71.32,71.21,71.10,70.98,70.98,70.98,70.95,70.60,70.24,69.61,68.82,67.98,67.12,66.26,65.49,64.70,63.87,63.07,62.24,61.46,60.72,59.99,59.26,58.53,57.82,57.08,56.29,55.50,54.64,53.77,52.88,51.97,50.98,49.97,48.95,47.96,47,46.11,45.24,44.37,43.54,42.77,41.90,40.97,40.08,39.33,38.60,37.71,36.48,35,35,34,32.98,32,17,17,16.72,16.59,16.99,17.49,18,18.50,18.98,19.37,19.61,19.58,19.07,18.42,17.77,17.22,16.79,16.60,16.59,16.73,16.98,17.26,17.52,17.63,17.57,17.32,17.03,16.83,16.62,16.41,16.22,15.89,15.88,15.10,15,14.84,14.82,15,15.14,15.99,16.85,17.12,17.75,18.11,18.27,18.50,18.75,19.13,19.61,20.11,20.62,21.10,21.37,21.35,20.62,19.82,19.25,19.14,19.25,19.25,19.21,19.12,19.12,19.33,19.60,19.75,19.62,19.12,18.37,17.50,16.37,15.62,17,19,20,20.98,20.98,20.98,22,22,22.98,22.98,22.98,22.98,22.98,24,24,25,25,25,25,25,25,25,25.98,25.98,25.98,27,26.97,26.74,26.50,26.14,26.02,25.97,25.99,26.01,26.12,26.25,26.48,26.87,27.35,27.71,28,28.25,28.75,29.24,29.62,30.37,31.24,32.39,33.50,34.50,35.48,36.50,37.82,38.97,39.76,40.10,40.20,40.15,40.11,40,39.98,40,40.83,41.62,42.12,43.12,44.12,45.12,46.84,46.86,46.87,47,47,47.98,47.98,49,50,50,52,52,52.98,52.98,54,55,55,55,55.98,57,59,59,60.98,62,60.98,60.98,60.98,60.98,60.98,62,62.98,62.98,62.98,64,62.98,62.98,62.98,62.98,62.98,64,64,64,64,64.08,64.12,64.97,65.25,65.46,65.72,66,66.32,66.63,66.99,67.34,67.64,67.90,68.17,68.52,69,69.60,70.17,70.70,71.16,71.65,72.17,72.72,73.20,73.63,74.04,74.46,74.87,75.22,75.50,75.83,76.12,76.37,76.59,76.71,76.73,76.71,76.62,76.46,76.20,75.75,74.88,73.48,73.25,72.98,72,72,70,70,69,67.98,67.98,65.98,65.98,65,64,64,64,64,64,64,64,64,64,64,64,64,64.22,64.33,64.52,64.87,65.75,66.39,67.21,67.75,68.62,69.62,70.32,70.75,70.98,71.39,71.75,71.98,71.98,71.98,72.10,72,72,72,72.33,72.21,71.75,70.87,69.96,69,68.12,67.25,66.37,65.51,64.73,63.87,63.07,62.25,61.48,60.71,59.92,59.16,58.40,57.65,56.90,56.12,55.33,54.48,53.61,52.67,51.71,50.66,49.63,48.63,47.67,46.76,45.88,45,44.12,43.33,42.45,41.53,40.72,40,39.29,38.50,37.35,35.98,35.98,35,34,32.98,15.98,15.98,15.25,15.50,16.01,16.59,17.21,17.88,18.61,19.20,19.50,19.47,18.95,18.29,17.66,17.11,16.72,16.54,16.62,16.84,17.13,17.47,17.72,17.79,17.66,17.36,17,16.66,16.37,16.07,15.73,15.38,15.03,15,14.89,14.09,14.11,14.87,15.01,15.12,16.87,17.12,18.32,18.87,18.46,18.37,18.39,18.57,18.83,19.20,19.70,20.21,20.50,20.33,19.62,18.72,18.08,18.01,18.12,18.12,18.12,18.12,18.12,18.49,18.83,19,18.87,18.50,17.87,17.14,16.72,16.76,17.98,19,20,20.98,20.98,20.98,20.98,20.98,22,22,22,22,22.98,25,25,24,24,25,25,25,25,25.98,25.98,27.98,27.98,27.98,27.62,27.50,27.37,27.11,26.87,26.63,26.60,26.60,26.62,26.77,27,27.39,27.83,28.25,28.45,28.74,29.08,29.37,29.84,30.45,31.25,32.25,33.22,34.02,34.83,35.74,37.12,38.37,39.23,39.60,39.64,39.62,39.57,39.50,39.61,39.86,40.88,42.26,43.12,43.83,44.75,45.74,45.24,45.22,46.01,46.12,47,47.96,47.98,47.98,49,50,52,52,52.98,52.98,52.98,54,54,54,55,55.98,57.98,57.98,59,60,60.98,62,62,60.98,60.98,60.98,62,62,62,62,62.98,65,65,64,64,64,64,64,64,64,64.87,65.82,65.75,65.87,66.10,66.38,66.71,67.07,67.45,67.79,68.12,68.39,68.67,69.07,69.60,70.23,70.88,71.45,71.98,72.51,73.11,73.66,74.17,74.63,75.09,75.51,75.97,76.36,76.74,77.12,77.50,77.84,78.07,78.15,78.20,78.12,77.99,77.75,77.50,77,76.25,75.12,74.62,74,72.98,72,70,70,69,67.98,67,65,65,64,62.98,62.98,62.98,62.98,62.98,62.98,64,64,64,64,64,64,63.99,63.99,64.33,64.63,65.37,65.75,66.32,66.82,67.82,69.21,70.25,70.87,71.12,71.75,72.37,72.75,72.82,72.82,72.99,74,74,73.62,73.51,73.47,72.98,72.01,71,70.01,69.12,68.21,67.25,66.37,65.52,64.70,63.90,63.10,62.27,61.47,60.64,59.84,59.04,58.28,57.53,56.77,56,55.21,54.35,53.45,52.47,51.45,50.40,49.40,48.42,47.50,46.60,45.70,44.75,43.91,43.07,42.21,41.42,40.75,40.12,39.32,38.39,37,37,35.98,35.98,35,14.99,14.99,14.64,14.57,15.12,15.65,16.47,17.40,18.35,19.09,19.48,19.24,18.76,18.12,17.48,16.92,16.60,16.50,16.62,16.91,17.27,17.63,17.91,18,17.84,17.42,16.98,16.57,16.16,15.78,15.40,15.11,15.01,15,14.50,14.01,14.08,14.50,14.87,15.10,16.87,17.09,18.02,18.40,18.26,18.09,17.97,17.88,18.01,18.37,18.88,19.57,19.88,19.62,18.83,17.71,17,16.97,17,17,17.07,17.08,17.24,17.62,18,18.25,18.24,17.87,17.37,16.97,16.86,17.25,17.98,19,19.50,20.49,20.49,20.49,20.98,20.98,22,22,22,22,22.98,24.50,24.50,24,24,24.50,25,25,25.49,25.98,25.98,27.98,27.98,27.98,27.97,27.96,27.95,27.75,27.45,27.12,26.99,27,27.10,27.25,27.59,27.89,28.25,28.61,28.86,29.12,29.48,29.82,30.08,30.59,31.32,32.12,32.96,33.65,34.37,35.27,36.62,37.88,38.95,39.23,39.27,39.25,39.21,39.22,39.35,39.71,41.07,42.71,43.74,44.45,45.20,45.25,45.12,45.20,45.50,46,46.62,47.87,47.98,47.98,49,50,52,52,52.98,52.98,52.98,53.49,53.49,54,55,55.98,57.49,57.49,58.49,59.50,59.99,61,61,60.49,60.49,60.49,61.49,61.49,61.49,62,62.49,64.50,64.50,64,64,64,64,64,64,64,64.97,65.86,66.10,66.21,66.48,66.77,67.12,67.50,67.87,68.24,68.54,68.85,69.14,69.58,70.13,70.82,71.50,72.14,72.76,73.39,74.03,74.64,75.17,75.65,76.12,76.60,77.07,77.50,77.99,78.48,78.97,79.37,79.62,79.75,79.74,79.60,79.37,79.08,78.72,78.12,77.08,76.10,75.11,74,72.98,72,70,70,69,67.49,66.49,64.50,64.50,63.49,62.49,62.49,62.49,62.49,62.49,62.49,63,63.49,63.49,63.49,64,64,63.99,63.99,64.33,64.63,65.12,65.32,65.62,66.12,67.12,68.62,69.82,70.62,71.12,71.98,72.82,73.32,73.49,73.49,73.62,74,74.32,74.39,74.47,74.34,73.62,72.75,71.86,70.87,70,69.11,68.23,67.35,66.49,65.62,64.82,63.98,63.13,62.27,61.41,60.58,59.75,58.97,58.22,57.48,56.73,55.95,55.12,54.24,53.27,52.27,51.25,50.25,49.25,48.32,47.37,46.45,45.49,44.62,43.76,42.95,42.20,41.51,40.87,40.21,39.02,37.49,37.49,36.49,36.49,35.49,14,14,13.96,13.99,14.51,15.23,16.01,17.15,18.33,19.12,19.48,19.09,18.50,17.82,17.17,16.67,16.40,16.38,16.60,16.96,17.36,17.75,18.09,18.17,18,17.53,17.01,16.51,16.08,15.65,15.32,15.07,14.86,15,14,14,14,14.01,14.89,15.07,16.89,17,17.50,17.75,17.71,17.57,17.37,17.21,17.25,17.72,18.50,19.25,19.63,19.45,18.24,17.07,16.13,15.98,15.95,15.96,15.99,16.02,16.32,16.75,17.24,17.58,17.62,17.25,16.85,16.50,16.62,17.25,17.98,19,19,20,20,20,20.98,20.98,22,22,22,22,22.98,24,24,24,24,24,25,25,25.98,25.98,25.98,27.98,27.98,27.98,28.07,28.10,27.98,27.87,27.63,27.37,27.25,27.25,27.40,27.62,27.87,28.20,28.52,28.96,29.12,29.48,29.72,29.90,30.12,30.64,31.34,32.02,32.75,33.37,34.09,34.99,36.23,37.58,38.62,38.88,38.99,38.97,38.89,38.95,39.12,39.61,40.99,43.20,43.87,44.63,45.62,44.97,44.74,44.85,45.12,45.72,46.13,47.84,48,47.98,49,50,52,52,52.98,52.98,52.98,52.98,52.98,54,55,55.98,57,57,57.98,59,59,60,59.99,59.98,59.98,60,60.96,60.96,60.99,62,62,64,64,64,64,64,64,64,64,64,65,65.88,66.09,66.47,66.85,67.21,67.58,67.92,68.28,68.62,68.91,69.25,69.62,70.10,70.73,71.45,72.16,72.87,73.58,74.28,75,75.62,76.20,76.73,77.24,77.62,78.23,78.75,79.32,79.90,80.58,81.07,81.34,81.38,81.34,81.11,80.75,80.37,79.86,79.02,77.71,76.57,75.58,74,72.98,72,70,70,69,67,65.98,64,64,62.98,62,62,62,62,62,62,62,62.98,62.98,62.98,64,64,63.87,63.99,64.33,64.63,65.01,65.11,65.36,65.87,66.77,68.11,69.20,70.13,71,72.07,73,73.58,73.76,73.83,73.99,74,74.62,74.87,74.88,74.62,74.12,73.38,72.58,71.75,70.87,70.01,69.15,68.33,67.47,66.61,65.77,64.91,64.04,63.16,62.26,61.38,60.52,59.72,58.96,58.23,57.50,56.74,55.92,55.07,54.13,53.15,52.14,51.14,50.15,49.17,48.23,47.27,46.29,45.41,44.57,43.73,42.96,42.25,41.60,40.82,39.70,37.98,37.98,37,37,35.98,12.98,12.98,12.98,13.11,14.50,15.32,16.13,17.36,18.50,19.40,19.62,18.75,18.03,17.37,16.76,16.34,16.13,16.21,16.49,16.88,17.34,17.77,18.16,18.33,18.13,17.64,17.09,16.52,16.07,15.62,15.26,14.98,14.70,14,14,14,14,14,14,15,15.98,15.98,16.73,17,16.96,16.87,16.52,16.36,16.45,17.14,18.20,19.40,19.62,19.14,17.62,16.32,15.37,15.02,14.95,14.88,14.95,15,15.34,15.75,16.25,16.64,16.83,16.60,16.21,15.97,16.14,17.08,17.98,17.98,19,19,19,20,20,20.98,20.98,20.98,20.98,22,22,22.98,22.98,24,24,24,25,25,25,25.98,25.98,27.98,27.98,29,29,28.15,27.96,27.95,27.84,27.62,27.57,27.58,27.71,27.85,28.02,28.37,28.74,29.08,29.34,29.62,29.99,30.21,30,30.82,31.36,31.98,32.62,33.20,33.76,34.59,35.72,36.89,37.98,38.25,38.59,38.57,38.57,38.57,38.75,39.35,40.59,42.15,43.32,44.62,44.62,44.25,44.22,44.35,44.75,45.25,46.22,47.76,48.08,49,50,50.98,52,52,52,52,52,52.98,52.98,52.98,54,55,57,57,57,57,57.97,58,58,58.25,59,59.50,59.99,60.37,60.75,61.25,62.10,62.75,62.98,64,64,64,64,64,64,65,65,65.98,66,66.72,67.28,67.73,68.11,68.42,68.73,69.01,69.35,69.74,70.20,70.76,71.46,72.22,72.98,73.72,74.48,75.25,75.99,76.65,77.26,77.87,78.50,79,79.74,80.37,81,81.83,82.62,83.25,83.38,83.34,83.13,82.86,82.50,81.95,81.33,80.35,78.65,76.59,75.75,75,72.98,72,70,70,67.98,65.98,65,62.98,62.98,62,60.98,60.98,60.98,60.98,60.98,60.98,60.98,62,62,62,62.98,62.98,63.63,63.99,64.22,64.52,64.87,64.99,65.13,65.62,66.37,67.40,68.46,69.48,70.59,71.85,72.97,73.62,73.89,73.99,74.22,75,75.08,75.13,75.13,74.97,74.50,73.96,73.27,72.58,71.82,71,70.20,69.37,68.50,67.63,66.82,65.96,65.07,64.13,63.22,62.28,61.39,60.57,59.77,59.04,58.34,57.60,56.82,55.97,55.04,54.10,53.11,52.11,51.11,50.12,49.13,48.16,47.20,46.28,45.40,44.57,43.75,43,42.33,41.60,40.72,39,39,37.98,37.98,37,12,12,12.98,14,15,15.77,16.58,17.59,18.85,19.82,19.25,18.16,17.38,16.74,16.22,15.87,15.76,15.90,16.25,16.67,17.15,17.67,18.15,18.39,18.20,17.65,17.04,16.49,16,15.57,15.20,14.86,14.47,14,14,14,14,14,14,14,15,15,15.87,15.96,16.23,15.75,15.58,15.39,15.39,16.40,18.12,18.71,19.11,18.20,16.75,15.46,14.47,14.14,14,13.88,13.87,13.98,14.25,14.73,15.20,15.62,15.87,15.75,15.50,15.51,15.98,16.14,17.98,17.98,17.98,19,19,19,20,20,20.98,20.98,20.98,20.98,22,22.98,22.98,22.98,22.98,22.98,24,24,25,25.98,27,29,29,30,29,27.98,27.73,27.47,27.62,27.85,27.95,27.95,27.90,27.97,28.12,28.37,28.74,29.09,29.38,29.75,30.22,30.98,30.98,30.88,31.36,31.90,32.50,33,33.49,34.01,34.87,35.75,36.49,37,37.35,37.63,37.84,37.99,38.21,38.62,39.60,41.25,41.75,42.60,42.75,43.11,43.61,43.75,44.24,45,46.25,47.75,48.11,49,50,50.98,50.98,50.98,52,52,52,52,52,52.98,52.98,54,55.98,55.98,55.98,55.97,56,56.88,57.25,57.75,58.33,58.87,59.38,59.86,60.25,60.87,61.62,62.37,63,62.98,64,64,64,64,64,65,65.98,65.98,65.98,67.12,67.82,68.34,68.72,68.99,69.22,69.50,69.87,70.37,70.91,71.60,72.35,73.14,73.95,74.70,75.48,76.25,77.02,77.74,78.39,79.12,79.91,80.77,81.75,82.50,83.25,84.27,85.50,86.33,86.60,86.26,86,85.52,85.20,84.57,83.75,82.51,80.23,77.57,76.62,75,72.98,72,67.98,67.98,67,65,62.98,62,62,60.98,60,60,60,60,60,60,60,60,60,60.98,60.98,62,63.48,63.40,63.62,64.12,64.50,64.87,65.07,65.37,66,66.75,67.65,68.62,69.89,71.34,72.61,73.45,73.83,74,74.34,75,75.25,75.47,75.50,75.32,74.96,74.50,74,73.37,72.74,72,71.25,70.48,69.62,68.76,67.91,67.07,66.15,65.22,64.25,63.29,62.37,61.50,60.71,59.98,59.25,58.52,57.76,56.92,56.03,55.09,54.11,53.10,52.10,51.09,50.10,49.12,48.13,47.22,46.32,45.42,44.60,43.82,43.10,42.47,41.96,40,40,39,37.98,37,12,12,12.98,15,15.98,16.62,16.83,17.59,18.73,19.15,18.34,17.27,16.53,15.98,15.54,15.32,15.29,15.50,15.87,16.33,16.84,17.45,18.01,18.39,18.13,17.51,16.83,16.25,15.78,15.37,15,14.64,14.33,14,14,14,14,14,14,14,14,14,15,15.13,14.50,14.72,14.51,14.48,14.58,15.52,16.70,17.70,17.62,17,15.82,14.33,13.65,13.37,13.12,12.96,12.75,12.96,13.25,13.62,14.08,14.47,14.74,14.85,14.87,15.25,16.25,17,17,17.98,17,17.98,17.98,17.98,17.98,17.98,20,20,20.98,20.98,20.98,22.98,22.98,22.97,22.98,23.09,24.87,24.86,25.13,26.07,27.12,28.87,28.90,27.99,27.98,27,25.98,26.15,27.15,27.77,28.25,28.12,27.99,27.99,28.11,28.35,28.62,28.87,29.23,29.76,30,30.98,30.98,30.95,31.34,31.87,32.39,32.84,33.20,33.60,34.01,34.52,35.11,35.62,36.14,36.62,37,37.25,37.50,37.75,37.86,39.25,39.36,40.37,41.35,41.37,42.75,43.32,43.34,44.76,46.25,47.75,48.12,49,49,49,50,50,50,50,50,50.24,50.47,51.33,51.64,52.75,53.60,53.61,54.38,54.25,55.08,56.01,56.71,57.25,57.86,58.45,58.98,59.38,59.87,60.50,61.37,62.32,62.99,63.35,64,64,65,65,65,65,65.98,67,67,67.59,68.41,69,69.33,69.53,69.74,70.03,70.50,71.12,71.77,72.50,73.28,74.11,74.92,75.71,76.50,77.28,78.09,78.82,79.51,80.33,81.36,82.71,84.27,84.87,85.73,86.87,88.25,89.75,89.75,89.74,88.75,88.09,87.85,87.89,86.08,85.12,83.32,75.50,74.72,70.98,67.98,65.98,62.98,62.98,62,60.98,60.98,60.98,60.98,60.98,60,60,60,60,60,60,60,60,60,60,60,60,61.87,62.71,63,63.62,64.14,64.72,65,65.33,65.83,66.37,67.12,67.89,69.07,70.48,71.87,73,73.62,73.99,74.32,74.82,75.36,75.62,75.70,75.52,75.33,75,74.63,74.22,73.65,73.08,72.37,71.63,70.87,70,69.12,68.26,67.37,66.41,65.41,64.41,63.45,62.54,61.74,61,60.28,59.58,58.83,58,57.11,56.14,55.14,54.13,53.11,52.10,51.09,50.09,49.12,48.17,47.25,46.35,45.48,44.63,43.87,43.17,42.98,40.98,40.98,40,39,37.98,12,12,12.49,13.99,14.99,16.49,16.72,17.24,17.96,17.64,16.88,16.13,15.54,15.11,14.83,14.70,14.75,15,15.37,15.83,16.36,17.02,17.74,18.26,17.97,17.24,16.47,15.84,15.38,15,14.64,14.36,14.14,14,14,14.50,14.50,14,14,14,14,14,14.50,15,14.15,13.73,13.60,13.62,13.87,14.77,15.82,16.50,16.64,16.02,15.01,13.88,13,12.73,12.37,11.99,11.99,12.12,12.37,12.63,13,13.37,13.71,13.96,14.25,14.87,16.25,16.49,17,17.49,17,17.49,17.49,17.98,17.98,17.98,20,20,20.49,20.49,20.98,22.49,22.51,22.87,22.98,23.14,24.25,24.74,25.33,26.12,26.90,27.77,27.84,27.45,26.97,26.49,25.99,25.99,26.59,27.48,28.07,28.12,27.97,27.98,27.98,28.12,28.33,28.62,28.99,29.50,30,30.49,30.49,30.87,31.27,31.75,32.23,32.59,32.87,33.12,33.37,33.50,33.98,34.49,35.12,35.75,36.25,36.59,36.84,37,37.37,38.21,39.22,39.88,40.63,41.58,42.36,43.07,43.57,44.63,46.25,47.75,48.12,48.49,49,49,48.99,48.99,48.99,48.99,49.32,49.70,50.12,50.59,51.25,52.07,52.71,53.22,53.59,54.13,54.84,55.58,56.25,56.89,57.51,58.12,58.71,59.13,59.62,60.35,61.35,62.37,63.21,63.87,64.25,64.50,65,65,65,65.49,65.98,67,67,67.97,68.86,69.46,69.77,70,70.24,70.62,71.15,71.87,72.60,73.35,74.13,74.97,75.83,76.63,77.48,78.29,79.12,79.89,80.63,81.39,82.58,84.24,85.75,86.86,87.85,89.12,90.57,91.46,91.88,91.61,90.97,90.15,89.62,88.95,87.87,86.23,83.87,74.37,73.82,69.48,66.98,64.99,62.49,62.49,61.49,60.98,60.98,60.98,60.98,60.98,60,60,60,60,60,60,60,60,60,60,60,60,61.21,61.77,62.26,63.11,63.83,64.48,64.88,65.25,65.72,66.21,66.82,67.47,68.38,69.71,71.12,72.38,73.23,73.76,74.20,74.71,75.33,75.59,75.63,75.62,75.52,75.45,75.25,74.97,74.60,74.12,73.58,72.88,72.14,71.36,70.48,69.58,68.73,67.76,66.75,65.66,64.64,63.73,62.91,62.17,61.47,60.75,59.99,59.16,58.26,57.28,56.26,55.22,54.15,53.12,52.09,51.09,50.12,49.15,48.23,47.28,46.37,45.49,44.63,43.75,42.75,41.87,41.22,40.50,39.50,38.49,12,12,12,12.98,14,15.98,15.98,16.75,16.62,16.33,15.37,14.87,14.52,14.23,14.04,14.01,14.13,14.39,14.77,15.26,15.86,16.59,17.36,17.96,17.66,16.86,16,15.29,14.84,14.47,14.16,14,13.96,14,14,15,15,14,14,14,14,14,14,15,14,13.15,13.20,13.22,13.40,14.33,15.27,16.13,16.11,15.58,14.45,13.38,12.60,12.25,11.85,11.51,11.45,11.50,11.62,11.87,12.12,12.46,12.75,13.07,13.38,14.32,15.98,15.98,17,17,17,17,17,17.98,17.98,17.98,20,20,20,20,20.98,21.95,22.12,22.75,22.87,23.25,23.75,24.27,25.64,25.65,26.71,26.73,26.75,26.77,26.12,25.88,25.87,26,26.45,26.99,27.49,27.62,27.65,27.75,27.87,28,27.98,27.98,29,29,29.98,29.99,30.02,30.88,31.20,31.51,31.95,32.27,32.57,32.75,32.87,33.08,33.40,33.95,34.61,35.12,35.59,35.90,36.20,36.50,37,37.87,38.82,39.62,40.48,41.48,42.37,43.12,43.86,44.84,46.13,47.75,47.85,47.98,49,49,47.98,47.98,47.98,48,48.61,49.20,49.75,50.36,50.99,51.63,52.25,52.75,53.25,53.84,54.50,55.25,55.98,56.63,57.34,57.98,58.57,59.09,59.62,60.48,61.50,62.62,63.50,64.25,64.88,65,65,65,65,65.98,65.98,67,67,68.25,69.07,69.70,70.12,70.42,70.75,71.23,71.86,72.60,73.37,74.12,74.91,75.75,76.64,77.51,78.41,79.36,80.29,81.14,81.84,82.58,83.23,85.26,87.49,88.62,89.75,91.21,92.40,93.10,93.36,93.12,92.58,91.64,90.89,89.99,88.65,86.65,84.50,73.25,72.90,67.98,65.98,64,62,62,60.98,60.98,60.98,60.98,60.98,60.98,60,60,60,60,60,60,60,60,60,60,60,60,60.87,61.37,61.87,62.64,63.46,64.12,64.62,65.01,65.50,66.01,66.60,67.12,67.90,69.01,70.33,71.62,72.51,73.25,73.95,74.47,75,75.25,75.38,75.50,75.62,75.70,75.70,75.62,75.46,75.14,74.75,74.21,73.52,72.76,71.97,71.08,70.13,69.34,68.29,67.12,66,65.07,64.29,63.54,62.79,62.07,61.28,60.46,59.51,58.50,57.42,56.34,55.24,54.13,53.11,52.11,51.12,50.16,49.23,48.27,47.35,46.40,45.37,44.50,43.59,42.74,42.14,41.37,40.21,39,10.98,10.98,10.98,12,12.98,15,15,15,15.09,14.86,13.40,13.83,13.62,13.41,13.34,13.37,13.50,13.75,14.15,14.73,15.41,16.16,16.92,17.53,17.23,16.42,15.52,14.77,14.25,13.86,13.65,13.64,13.78,14,14,15,15,15,14,14,14,14,14,15,15,12.98,12.87,12.71,12.90,13.50,15.38,16,16.40,15.12,13.87,12.57,12.15,11.99,11.57,11.25,11.12,11.01,11.09,11.21,11.37,11.62,11.89,12.23,12.35,12.98,15,15,15.98,15.98,15.98,17,17,17,17,17,17.98,17.98,19,20,20.97,21.87,22.07,22.25,22.64,23,23.62,23.87,24.32,24.87,25.20,25.33,25.27,25.25,25.32,25.35,25.50,25.75,26.12,26.64,27.12,27.35,27.46,27.63,27.90,28,28.08,28.37,28.73,29.14,29.50,29.87,30.36,30.75,31.12,31.35,31.75,32.12,32.33,32.48,32.62,32.85,33.25,33.71,34.25,34.71,35,35.25,35.50,35.99,36.62,37.62,38.58,39.50,40.47,41.49,42.47,43.24,43.89,44.75,45.86,46.76,47.11,47.98,47.98,47,47,47,46.87,47.25,47.98,48.76,49.48,50.12,50.75,51.37,52,52.45,52.97,53.50,54.25,54.99,55.74,56.47,57.14,57.87,58.50,59.12,59.83,60.73,61.83,62.95,63.86,64.50,65.36,65.98,65,65,65.98,65.98,67,67.98,67.98,68.65,69.42,70.02,70.51,70.92,71.37,71.90,72.59,73.35,74.12,74.89,75.74,76.62,77.57,78.48,79.46,80.52,81.76,82.85,83.76,84.48,85.08,87.12,89.62,90.50,92.01,93.57,94.65,95.25,95.38,95.25,94.62,93.39,92.27,91.24,89.36,86.49,83.62,71.12,70.98,67,65,62.98,60.98,60.98,60.98,60.98,60.98,60.98,60.98,60.98,60,60,60,60,60,60,60,60,60,60,60,60,60.98,60.83,61.24,61.97,62.74,63.48,64,64.52,65.09,65.63,66.23,66.75,67.46,68.38,69.50,70.71,71.62,72.50,73.34,73.90,74.37,74.76,75,75.26,75.51,75.75,75.98,76.12,76.20,76.12,75.88,75.50,74.99,74.33,73.58,72.75,71.97,71.11,70.16,68.87,67.71,66.67,65.95,65.15,64.36,63.54,62.75,61.87,60.89,59.82,58.65,57.49,56.32,55.22,54.14,53.13,52.15,51.21,50.26,49.35,48.40,47.39,46.62,45.76,44.90,44.25,43.62,42.72,41.37,39.75,10,10,10.98,12,12.98,15,15,15,15,14,12.98,13.37,13.46,13.03,12.82,12.84,12.91,13.13,13.58,14.29,15.14,15.92,16.58,16.90,16.66,16,15.17,14.37,13.75,13.32,13.13,13.38,13.70,14,15,15,15,15,15,14,14,14,14,14,14,12,12,12,12,12.98,15.98,15.98,15.98,15,12.99,12.10,11.62,11.50,11.32,11,10.86,10.73,10.63,10.73,10.85,11,11.23,11.50,11.99,12.95,15,15,15,15,15,15.98,15.98,15.98,15.98,15.98,17.98,17.98,19,19.99,20.87,21.77,21.75,21.82,22.11,22.60,22.87,23.13,23.38,23.87,24.15,24.35,24.36,24.51,24.60,24.86,25.12,25.49,25.88,26.45,27,27.48,27.77,28,28.09,28.11,28.15,28.45,28.85,29.27,29.74,30.12,30.61,30.99,31.25,31.37,31.75,32,32.25,32.12,32.46,32.97,33.39,33.70,34.10,34.37,34.50,34.50,34.85,35.32,36.37,37.46,38.39,39.38,40.39,41.50,42.47,43.23,43.85,44.50,45.36,46.62,46.88,47,45.98,45.98,45,45,46.25,46.85,47.75,48.61,49.26,49.95,50.58,51.20,51.75,52.21,52.72,53.25,54,54.75,55.50,56.25,57.08,57.83,58.50,59.24,60,61,62.12,63.21,63.96,64.49,64.88,65,65,65,65.98,67,67.98,68.21,68.59,69.32,69.87,70.51,71.09,71.59,72.10,72.70,73.39,74.15,74.95,75.75,76.63,77.61,78.59,79.52,80.59,81.87,83.66,85.28,86.62,87.32,88.10,90.09,92.75,93.33,95.32,96.59,97.74,98.21,98.24,97.85,97.20,95.23,92.61,92.37,89.50,84.85,80.82,70,70,65.98,65,62.98,60.98,60.98,60.98,60.98,60.98,60.98,60.98,60.98,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60.64,61.23,61.89,62.64,63.25,63.87,64.47,65.08,65.64,66.25,66.96,67.87,68.87,69.97,70.85,71.51,72.50,73.25,73.75,74.20,74.60,74.98,75.36,75.73,76.11,76.46,76.75,76.97,77,76.82,76.40,75.87,75.25,74.60,73.98,73.37,72.47,71.14,69.46,68.71,67.87,67,66.10,65.17,64.36,63.47,62.42,61.20,59.90,58.64,57.45,56.29,55.22,54.17,53.21,52.26,51.37,50.46,49.62,48.90,48.25,47.62,46.70,45.87,44.89,43.99,42.65,40.47,7.98,7.98,9,10.98,12.98,15.98,15.98,15.98,15.98,15.98,15,14.74,13.78,13.11,12.65,12.50,12.49,12.63,13.08,13.98,14.98,15.77,16.26,16.39,16.24,15.72,15,14.21,13.45,12.92,12.78,13.13,13.74,14,15,12.98,12.98,14,14,14,14,14,14,12.98,12.98,12,12,10.98,10.98,12,15,15,14,12.98,12.37,11.62,11.32,11.20,11.01,10.85,10.62,10.46,10.35,10.35,10.37,10.50,10.62,10.95,11.46,12.34,13,12.98,12.98,14,15,15.98,15.98,15.98,15.98,15.98,17,17,17.98,19.07,20.82,20.89,21.12,21.25,21.37,21.89,22.27,22.46,22.99,23.36,23.39,23.87,24.08,24.20,24.37,24.62,24.89,25.27,25.62,26.27,27.10,27.84,28.24,28.37,28.35,28.25,28.26,28.51,29,29.52,30.11,30.52,30.99,31.26,31.49,31.58,31.62,31.77,31.71,31.50,32.37,33.37,33.65,33.87,34.09,34.12,34.12,34.12,34.39,35.13,36.25,37.37,38.35,39.32,40.32,41.36,42.25,42.99,43.60,44.20,44.82,45.25,45,44,44,44,45,45,45.89,46.87,47.71,48.50,49.12,49.75,50.37,51,51.61,52,52.49,53,53.75,54.51,55.36,56.13,57,57.76,58.51,59.26,60.12,61.13,62.25,63.20,63.76,64.23,64.60,65,65.98,65.98,67,67.98,68.75,68.62,69,69.62,70.37,71.11,71.75,72.32,72.88,73.51,74.23,75,75.79,76.64,77.60,78.61,79.62,80.61,81.72,83.14,85.38,89.17,89.49,91.75,92.75,93.84,97.87,97.76,98.71,100.57,100.48,101.40,101.37,100.36,98.37,95.38,89.50,89,86.25,82.12,79,70.98,70.98,69,65.98,64,60.98,60.98,60.98,60.98,60.98,60.98,60.98,60.98,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60.11,60.60,61.24,61.97,62.58,63.15,63.75,64.46,65.12,65.75,66.49,67.40,68.48,69.50,70.32,71,71.88,72.70,73.25,73.64,74.25,74.72,75.14,75.62,76.12,76.63,77.15,77.62,77.90,78,77.85,77.48,76.99,76.47,75.99,75.70,75.73,73.75,71.89,70.97,70,69,68.10,66.76,65.87,65.58,64.12,62.61,61.14,59.84,58.59,57.37,56.25,55.23,54.25,53.34,52.48,51.71,51.07,50.45,49.77,49.12,48.27,46.83,45.63,44.86,43.75,42.22,6.98,6.98,8.49,10.49,11.98,15.49,15.49,15.49,16.49,16.98,15.49,15.45,14.50,13.62,12.88,12.42,12.22,12.25,12.67,13.73,14.85,15.72,16.08,16.15,16.07,15.72,15.11,14.26,13.37,12.67,12.45,12.84,13.45,14,13.99,12.98,12.98,13.49,13.49,14,14,14,13.49,12.98,12.49,11.49,11.49,10.98,10.98,11.49,13.99,13.99,13.49,12.49,11.82,11.32,10.98,11,10.87,10.70,10.48,10.25,10.13,10.12,10.12,10.22,10.26,10.50,10.96,11.60,12.12,12.49,12.49,13.49,14.50,15.98,15.98,15.49,15.98,15.49,16.49,16.49,17.49,18.60,19.76,20.24,20.50,20.70,21.01,21.47,21.87,22.37,22.87,23.34,23.63,23.85,23.99,24.11,24.26,24.51,24.85,25.15,25.51,26.21,27.25,28.10,28.62,28.73,28.50,28.34,28.34,28.59,29.09,29.75,30.46,30.99,31.35,31.57,31.63,31.60,31.48,31.36,31.27,31.35,32.34,33.40,33.66,33.78,33.91,34.03,34.12,34.25,34.60,35.15,36.24,37.34,38.25,39.22,40.12,41.12,42,42.70,43.25,43.75,44.21,44.38,44.50,43.49,43.49,44,45,45,45.88,46.75,47.64,48.37,48.99,49.59,50.22,50.87,51.49,51.87,52.25,52.75,53.51,54.37,55.23,56.09,56.95,57.75,58.50,59.25,60.12,61.11,62.12,62.98,63.50,63.89,64.37,65,65.98,65.98,67,67.98,68.62,68.99,69.33,69.98,70.84,71.87,72.42,73.03,73.63,74.29,75.02,75.83,76.64,77.51,78.48,79.48,80.50,81.50,82.64,84.16,86.38,89.84,90.83,92.33,93.77,95.20,98.33,98.59,99.59,100.77,101.21,101.12,100.62,99.59,97.25,94.12,88.25,87.83,85.45,82,79,71.98,71.98,69.50,66.49,64.50,61.49,61.49,60.98,60.98,60.98,60.98,60.98,60.98,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60.13,60.88,61.62,62.21,62.75,63.37,64.09,64.75,65.46,66.24,67.22,68.27,69.36,70.27,70.89,71.72,72.38,73,73.47,74.09,74.60,75.10,75.61,76.14,76.77,77.48,78.12,78.72,79.09,79.21,79.07,78.72,78.25,77.86,77.45,76.77,75.26,73.82,72.60,71.65,70.63,69.50,68.36,67.33,66.36,65.25,63.75,62.25,60.88,59.62,58.46,57.34,56.26,55.33,54.40,53.62,52.87,52.25,51.63,50.95,50.10,48.52,47.20,45.89,45.34,44.60,43,5.98,5.98,7.98,10,10.98,15,15,15,17,17.98,15.98,15.98,15.20,14.53,13.40,12.57,12.02,11.95,12.29,13.47,14.65,15.65,15.95,16.12,16.20,16.01,15.47,14.50,13.41,12.54,12.20,12.20,12.98,14,12.98,12.98,12.98,12.98,12.98,14,14,14,12.98,12.98,12,10.98,10.98,10.98,10.98,10.98,12.98,12.98,12.98,12,11.60,11.20,10.98,10.88,10.75,10.62,10.37,10.24,10.12,10.08,10.07,10.08,10.12,10.25,10.57,11,11.46,11.75,12,12.98,14,15.98,15.98,15,15.98,15,15.98,15.98,17,17.85,18.76,19.71,19.82,20.10,20.50,21.08,21.63,22.35,23.08,23.70,24,24,23.99,24.09,24.25,24.51,24.84,25.12,25.40,26.10,27.26,28.12,28.70,28.75,28.49,28.26,28.27,28.58,29.09,29.75,30.50,31.10,31.46,31.57,31.60,31.38,31.12,30.87,30.87,31.23,32,33.07,33.42,33.62,33.83,34,34.21,34.41,34.82,35.47,36.33,37.33,38.24,39.12,40,40.87,41.73,42.37,42.88,43.32,43.50,43.50,44,42.98,42.98,44,45,45,45.58,46.47,47.35,48.12,48.74,49.36,50,50.64,51.22,51.51,51.87,52.49,53.32,54.20,55.10,55.99,56.86,57.63,58.38,59.12,59.89,60.84,61.75,62.58,63.12,63.63,64.25,65,65.98,65.98,67,67.98,68.62,68.99,69.34,70,71.08,72.13,73.12,73.65,74.27,74.97,75.74,76.57,77.40,78.28,79.23,80.20,81.17,82.20,83.34,84.75,86.75,90.37,91.11,92.49,94.59,95.95,98.65,98.75,99.86,100.96,102,100,100,99,95.98,92.98,87,87,85,82,79,72.98,72.98,70,67,65,62,62,60.98,60.98,60.98,60.98,60.98,60.98,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60.11,60.37,61.01,61.61,62.13,62.50,63.15,63.99,64.65,65.35,66.02,67.01,68.32,69.37,70.27,70.90,71.74,72.47,73.02,73.52,74.12,74.65,75.20,75.73,76.32,76.99,77.75,78.57,79.37,80.07,80.57,80.73,80.50,80.11,79.62,79.12,78.22,76.85,74.88,74.21,73.32,72.24,70.90,69.62,68.40,67.36,66.07,64.60,63.12,61.87,60.62,59.50,58.37,57.34,56.37,55.50,54.74,54,53.25,52.50,51.62,50.46,49,47.61,46.59,46.11,45.46,43.82,4,4,5.98,7.98,10,12,12,14,15.98,17.98,17.98,17.98,17.98,15.82,14.23,12.86,11.87,11.66,11.92,13.07,14.45,15.41,15.67,16.12,16.51,16.65,16.10,14.85,13.42,12.34,11.83,12,12,12,12,12,12,12,12.98,12.98,14,14,12,12,10.98,10.98,10.98,10,10,10.98,11.98,12.01,11.99,11.87,11.37,11.12,10.96,10.84,10.74,10.61,10.46,10.32,10.23,10.12,10.12,10.08,10.08,10.12,10.26,10.51,10.85,11.10,10.98,12,12.98,14,14,14,15,14,15,15,15.98,16.86,17.74,18.70,19,19.37,19.87,20.49,21.49,22.25,23.12,24.48,24.48,23.97,23.88,24,24.25,24.52,24.83,25.07,25.25,25.82,26.85,27.75,28.26,28.37,28.21,28.11,28.22,28.51,29,29.62,30.33,30.82,31.11,31.12,31.07,30.75,30.37,30.32,30.41,30.78,31.60,32.35,32.96,33.37,33.71,34.01,34.33,34.64,35.09,35.66,36.41,37.25,38.13,39,39.83,40.64,41.45,42,42.50,42.83,42.75,42.48,42,42,42,42.98,44,44,45,45.87,46.85,47.62,48.36,48.96,49.58,50.23,50.62,50.99,51.37,52.11,53,54,54.95,55.85,56.71,57.50,58.23,58.87,59.62,60.45,61.33,62.21,62.87,63.39,64.12,65,65.98,65.98,67,67.98,68.62,68.99,69.34,70.09,71.25,72.46,73.39,74.12,74.75,75.50,76.35,77.22,78.09,78.95,79.85,80.76,81.73,82.70,83.75,85,86.73,89.25,90.62,92.33,93.84,95.48,97.52,98.34,99.25,100.84,100.90,97.98,97.98,95.98,94,90.98,87,87,84,82,80,74,74,70,67,65,62.98,62.98,62,60.98,60.98,60.98,60.98,60.98,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60.40,60.75,61.39,62,62.45,62.77,63.37,64.23,64.88,65.59,66.21,67.10,68.36,69.37,70.35,71.10,72,72.74,73.34,73.85,74.40,74.99,75.50,76.02,76.62,77.32,78.10,78.98,79.89,80.90,81.95,82.62,82.62,81.86,81.75,81.15,80.24,78.72,76.77,75.99,75.23,74.08,72.46,70.51,69.61,68.35,67.27,65.50,63.87,62.70,61.75,60.62,59.47,58.38,57.47,56.62,55.87,55.10,54.27,53.45,52.45,51.24,49.83,48.50,47.64,47.11,46.37,44.62,0.98,0.98,2,5,7,9,9,10.98,14,15.98,17,17,17.98,17.98,15.70,12.53,11.98,11.58,11.49,12.48,13.72,14.33,15.11,16.10,16.96,17.39,17.01,15,13.16,11.82,10.98,10.98,10.98,10.98,10.98,10.98,10.98,12,12,12,12,12,12,10.98,10.98,10,10,10,10,10,10.87,11.11,11.85,11.12,11.11,10.96,10.83,10.75,10.71,10.62,10.58,10.50,10.46,10.37,10.25,10.12,10.09,10.07,10.12,10.23,10.32,10.59,10.98,12,12,12.98,12.98,12.98,12.98,12.98,13.98,14,14.89,15.23,16.25,17.60,17.95,18.50,19.14,20.07,21.48,21.63,22.57,24.48,23.63,23.57,23.62,23.85,24.13,24.50,24.76,25,25.13,25.49,26.35,27.11,27.58,27.75,27.75,27.87,28.12,28.51,29,29.49,29.85,30.02,30.12,30,29.83,29.61,29.58,29.71,30,30.50,31.22,31.92,32.57,33.10,33.58,34.02,34.46,34.86,35.28,35.83,36.47,37.20,37.98,38.82,39.59,40.37,41.08,41.48,41.60,41.64,41.25,40.95,40.98,40.98,40.98,42,44,44,44.12,45.09,46.12,47.10,47.75,48.37,48.95,49.49,49.89,50.34,50.84,51.71,52.75,53.75,54.75,55.62,56.49,57.25,57.99,58.62,59.25,60.10,61,62,62.87,63.50,64.24,65,65.98,65.98,67,67.98,68.62,69,69.34,70.12,71.32,72.50,73.51,74.32,75.01,75.89,76.90,77.87,78.72,79.51,80.37,81.26,82.24,83.11,83.96,85.02,86.51,88.12,89.84,91.40,93.22,95.25,97.46,98.38,99.34,100.11,100.09,99.01,99,97,94,92,87,87,84,82,80.98,74,74,70.98,67.98,65.98,62.98,62.98,62,62,60.98,60.98,60.98,60.98,60,60,60,60,60,60,60,60,60,60,60,60,60.98,60.98,61.21,61.50,62.20,62.63,63.21,63.52,64.11,64.86,65.51,66.21,66.82,67.65,68.97,69.99,70.95,71.75,72.51,73.24,73.83,74.35,74.87,75.49,76.01,76.59,77.14,77.82,78.51,79.37,80.38,81.62,83.12,85.01,85.32,84.74,84.37,83.75,82.75,81.73,78.62,78.59,77.57,76.50,74.63,71.37,71.25,70.21,69.12,67.25,64.50,64.23,63.21,62.08,60.75,59.60,58.58,57.75,56.98,56.20,55.35,54.39,53.37,52.21,50.98,49.86,48.97,48.24,47.50,45.50,0,0,0,0,0.98,4,4,5.98,7.98,10,12.98,12.98,15,14,14,13.08,12.53,11.59,11.23,11.74,12.37,12.99,13.97,15.87,18.12,17.65,17.35,14.82,12.20,10.98,10,10,10,10,10,10.98,10.98,10.98,10.98,10.98,10.98,10.98,10,10,10,10,10,10,10,10.09,10.12,10.14,10.22,10.75,10.75,10.75,10.63,10.63,10.71,10.74,10.75,10.76,10.75,10.62,10.47,10.25,10.12,10,10,10.01,10.10,10.34,10.98,10.98,12,12,12,12,12,12,12.98,13.07,13.08,14.25,14.37,16.08,16.50,17.63,18.49,19.38,20.15,20.50,21.50,22.33,22.50,22.95,23.24,23.58,23.98,24.37,24.71,24.88,25.02,25.13,25.86,26.39,26.85,27.12,27.38,27.74,28.13,28.62,29.10,29.37,29.39,29.24,29,28.72,28.57,28.59,28.76,29.13,29.64,30.28,31,31.70,32.32,32.88,33.46,34.01,34.52,34.98,35.40,35.87,36.42,37.07,37.75,38.50,39.25,40.01,40.59,40.72,40.50,40.20,39.88,39.58,39,39,40,40.98,42,42,43.45,44.37,45.50,46.49,47.12,47.71,48.22,48.74,49.24,49.75,50.39,51.37,52.50,53.60,54.50,55.38,56.25,57.08,57.76,58.39,59.08,59.83,61,62.21,63.24,63.99,65,65.98,67,67,67,67.98,68.75,69.12,69.45,70.12,71.25,72.47,73.49,74.32,75.15,76.12,77.13,78.08,78.89,79.72,80.50,81.38,82.25,83.10,83.96,84.96,85.99,87.59,88.88,90.72,92.63,94.71,97.37,98.38,99.57,99.90,100.82,100.87,100.90,99,95.98,92.98,87.98,87.98,85.98,85,82.98,75,75,72,70,67.98,64,64,62.98,62.98,62,60.98,60.98,60.98,60.98,60.98,60.98,60.98,60.98,60.98,60.98,60.98,60.98,60.98,60.98,62,62,62,61.98,62.32,62.97,63.50,64,64.37,64.90,65.64,66.36,67,67.62,68.50,69.77,70.84,71.74,72.50,73.25,73.87,74.47,75,75.51,76.13,76.73,77.26,77.86,78.45,79.10,79.87,80.76,82.02,83.75,86.49,87.45,87.38,87.37,87.36,87.36,86.39,83.50,83.50,81.52,79.62,77.64,75.23,74.86,73.87,71.89,69.88,67.08,66.88,64.89,63.48,61.98,60.64,59.61,58.84,58.10,57.25,56.37,55.45,54.38,53.26,52.12,51.10,50.20,49.37,48.59,47.37,0,0,0,0,0.49,2.49,2.49,4.48,6.49,7.99,11.98,11.98,13.99,13.49,13,12.49,12.45,11.52,10.88,10.90,11.26,11.95,13.12,15.50,17.97,17.32,16.72,14.02,12,10.98,10,10,10,9.50,9.50,10.40,10.47,10.47,10.47,10.48,10.49,10.37,10.09,9.95,9.50,10,10,10,9.99,9.99,9.98,10,10.12,10.36,10.50,10.58,10.50,10.62,10.75,10.87,11,11.12,11.10,10.89,10.62,10.37,10.12,10,10,10,10.07,10.22,10.49,10.98,11.49,12,12,12,12,12.07,12.87,12.98,13.12,13.75,14.40,15.46,16.25,16.90,17.76,18.74,19.50,20.15,20.75,21.37,21.97,22.37,22.76,23.23,23.71,24.15,24.52,24.82,24.95,25.02,25.50,25.98,26.37,26.75,27.22,27.72,28.25,28.83,29.25,29.40,29.13,28.62,28.07,27.62,27.64,27.76,28.12,28.64,29.32,30.07,30.84,31.52,32.14,32.73,33.34,33.96,34.51,34.98,35.38,35.79,36.27,36.83,37.45,38.13,38.95,39.62,40.12,39.87,39.45,38.75,38.73,38.87,39,39,40,40.98,42,42,43,44.01,45.07,45.87,46.52,47.12,47.72,48.27,48.90,49.60,50.37,51.33,52.46,53.48,54.37,55.12,56.14,57.01,57.82,58.45,59,59.85,61.25,62.85,63.86,64.99,66,66.98,67.49,67.49,68,68.49,68.99,69.34,69.63,70.25,71.25,72.37,73.39,74.35,75.24,76.15,77.08,77.96,78.77,79.60,80.40,81.25,82.12,83,83.89,84.86,86,87.25,88.71,90.23,92.15,94.65,97.34,98.26,99.08,99.82,100.37,100.82,100.87,98.48,95.98,92.98,88.49,88.49,86.98,86,83.49,75.49,75.49,72.49,70,67.98,64.50,64.50,63.49,62.98,62.49,61.49,61.49,61.49,61.49,61.49,61.49,61.49,61.49,61.49,61.49,61.49,61.49,61.49,61.49,62.49,62.49,62.49,62.62,62.98,63.62,64.13,64.76,65.13,65.77,66.46,67.12,67.77,68.50,69.50,70.75,71.65,72.57,73.36,74.02,74.64,75.24,75.75,76.34,76.95,77.50,78.11,78.62,79.15,79.72,80.37,81.13,82,83.85,85.58,87.10,88.02,88.37,88.71,89.08,88.13,85.76,85.22,83.02,81.09,79.27,76.62,76.40,74.99,73,71,67.49,67.49,66,64.75,63.01,61.62,60.58,59.98,59.25,58.38,57.50,56.50,55.50,54.39,53.33,52.26,51.37,50.51,49.59,47.86,0,0,0,0,0,0.98,0.98,2.98,5,5.98,10.98,10.98,12.98,12.98,12,12,12,12,10,10,10.98,10.98,12,15,17.98,15.98,15.98,12.98,12,10.98,10,10,10,9.01,9.09,9.87,9.85,9.83,9.87,9.90,9.97,9.90,9.82,9.62,9.59,9.62,9.74,9.82,9.87,9.85,9.75,9.74,9.72,9.87,10.47,10.26,10.46,10.62,10.86,11.07,11.25,11.37,11.36,11.12,10.75,10.45,10.14,10.01,10,10,10,10.08,10,10.98,10.98,12,12,12,12.07,12.10,12.86,13,13.20,13.75,14.46,15.40,15.85,16.39,17.14,18.12,19.37,19.63,20.15,20.76,21.50,21.87,22.26,22.75,23.33,23.85,24.25,24.51,24.75,24.90,25.34,25.74,26.13,26.61,27.12,27.73,28.37,28.97,29.38,29.50,29.09,28.32,27.50,27.12,27,27.17,27.61,28.17,28.90,29.74,30.57,31.29,31.92,32.51,33.13,33.77,34.35,34.79,35.15,35.52,35.95,36.42,36.99,37.62,38.39,39.23,39.37,38.98,38.50,38.13,38.34,38.75,39,39,40,40.98,42,42,42.98,43.87,44.71,45.37,46.01,46.62,47.25,47.95,48.65,49.48,50.36,51.36,52.48,53.59,54,55.12,56.32,57.37,58.12,58.75,59.37,60.26,61.39,63.75,64,65.98,67,67.98,67.98,67.98,69,69,69.37,70,70.22,70.63,71.50,72.59,73.50,74.49,75.37,76.23,77.07,77.87,78.66,79.47,80.27,81.12,82,82.91,83.88,84.91,86.10,87.34,88.62,90,91.87,94.37,97.27,97.85,98.57,99.59,99.87,100.75,100.85,98,95.98,92.98,89,89,87.98,87,84,75.98,75.98,72.98,70,67.98,65,65,64,62.98,62.98,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62.98,62.98,62.98,63.07,63.38,64.08,64.72,65.37,65.75,66.39,67.12,67.84,68.50,69.25,70.27,71.50,72.61,73.50,74.33,75,75.59,76.12,76.63,77.21,77.75,78.40,79,79.52,80.01,80.50,80.76,81.75,82.49,83.37,85.25,86.88,88.70,89,89.75,90.74,89.75,87.21,86.77,84.13,82.12,80.87,78,77.98,75.98,74,72,67.98,67.98,67,65.87,64.22,62.37,61.89,61.27,60.51,59.62,58.70,57.74,56.74,55.64,54.58,53.50,52.61,51.72,50.62,48.35,0,0,0,0,0,0,0,0,0.98,2,7.98,7.98,10,10,10,10.98,10.98,10.98,10,9,10,10,12,15,17,15,15,12,10.98,10,9,9,8.96,8.08,8.85,8.87,9.09,9.12,9.25,9.37,9.50,9.57,9.50,9.40,9.37,9.37,9.48,9.61,9.62,9.51,9.13,8.98,8.99,9.24,9.35,10.13,10.50,10.70,10.95,11.13,11.35,11.45,11.37,11.12,10.75,10.38,10.13,10,10,10,10,10,10,10.98,10.98,12,12,12,12.09,12.86,12.86,13.11,13.24,13.84,14.37,14.96,15.47,15.89,16.52,17.40,18.34,18.87,19.40,19.97,20.60,21.14,21.62,22.14,22.75,23.37,23.87,24.21,24.50,24.83,25.21,25.62,26.01,26.50,27,27.58,28.12,28.71,29.01,29.12,28.58,27.75,26.87,26.59,26.53,26.73,27.10,27.65,28.37,29.23,30.09,30.87,31.53,32.16,32.79,33.45,34,34.40,34.74,35.04,35.42,35.87,36.37,36.90,37.51,38.20,38.32,38.10,37.85,37.72,38.12,37.98,37.98,39,40,40.98,42,42,42.89,43.87,44.32,44.96,45.52,46.13,46.87,47.64,48.50,49.37,50.32,51.26,52.48,53.87,54.02,55,57,57.92,58.74,59.37,60.12,61.12,62.51,64.37,65.03,65.98,67.11,68.09,68.96,69,70,70,70.75,70.75,71,71.37,72.12,73.12,73.95,74.76,75.54,76.32,77.08,77.83,78.57,79.34,80.13,81,81.91,82.87,83.91,85.08,86.34,87.62,88.87,90.07,91.83,93.86,96.27,97.14,97.87,98.38,99.14,99.75,99.84,98.07,95.98,94,90.98,90.98,90,87.98,85,75.98,75.98,72.98,70,67.98,65,65,64,64,62.98,62,62,62,62,62,62,62,62,62,62,62,62,62.98,62.98,62.98,64,64,64,64.10,64.50,65.45,66.12,66.50,67.15,68.02,68.74,69.38,70.20,71.25,72.61,73.74,74.70,75.50,76.12,76.71,77.20,77.73,78.22,78.82,79.40,80.09,80.62,81,81.50,82.12,82.75,83.40,84.25,85.25,86.12,88.84,89.08,90.12,92.87,92.87,89.10,88.88,86.90,85,82.98,80,80,79,75.98,75,70,70,69,67.38,65.85,64.72,63.70,63,62.12,61.12,60.12,59.14,58.15,57.11,56,54.89,53.97,53.07,51.84,50.37,-0.04,-0.04,-0.04,-0.03,0,0,0,0,0,0,4,4,5,5.98,5.98,7.98,7.98,7.98,7.98,7.98,10,10,12,15,15.98,12,12,10,9,9,7.98,7.90,7.87,6.85,7.75,7.74,8.08,8.37,8.62,8.87,9.09,9.22,9.25,9.22,9.14,9.15,9.23,9.23,9.12,8.75,8.40,8.10,8.21,8.33,9.25,10.62,10.46,10.64,10.96,11.20,11.32,11.33,11.20,10.89,10.62,10.34,10.12,10,10,10,10,10,10,10.98,10.98,12,12,12.07,12.87,12.87,13,13.22,13.71,13.87,14.32,14.75,15.13,15.50,15.96,16.59,17.33,17.71,18.12,18.62,19.52,20.13,20.76,21.39,22.11,22.76,23.37,23.84,24.13,24.61,25.08,25.50,25.88,26.27,26.72,27.12,27.49,27.71,27.71,27.59,27.20,26.72,26.15,26.07,26.09,26.25,26.58,27.08,27.74,28.54,29.41,30.25,30.98,31.62,32.27,32.91,33.48,33.87,34.15,34.47,34.83,35.23,35.65,36.10,36.52,36.98,37.23,37.25,37.25,37.34,37.98,39,39,39,40,40.98,42,42,42.87,43.12,43.87,44.50,45,45.63,46.50,47.49,48.39,49.35,50.21,51.14,52.21,53.85,54.11,55.95,56.88,58.14,59.37,59.87,60.58,61.63,63,64.36,65.51,66.34,67.26,68.37,69.57,69.84,70,70.98,70.98,71.75,72.10,72.50,73.22,73.87,74.50,75.12,75.77,76.46,77.12,77.78,78.49,79.22,80.02,80.90,81.87,82.87,84,85.25,86.64,88,89.28,90.51,91.97,93.76,95.35,96.48,97.12,97.75,98.25,99,99.09,98.09,97,95,92.98,92.98,90.98,89,85,75.98,75.98,72.98,70.98,69,65.98,65.98,65,64,64,62.98,62.98,62.98,62.98,62.98,62.98,62.98,62.98,62.98,62.98,62.98,62.98,62.98,64,64,65,65,65,65,65.25,66.62,67.33,67.70,68.35,69.39,70.22,70.99,71.76,72.87,74.07,75.12,76.07,76.87,77.58,78,78.61,78.98,79.52,79.88,80.77,81.40,81.62,82.48,82.52,83.50,84.45,84.37,85.33,85.24,86.07,87.90,87.98,90,92.98,95,90.98,90.98,89,87.98,85.98,84,84,80.98,80,77.98,72.98,72.98,72,69.25,68.82,67.24,66.14,65.07,63.98,62.88,61.87,60.87,59.87,58.75,57.61,56.48,55.50,54.59,53.52,51.50,-0.40,-0.40,-0.40,-0.38,-0.27,-0.13,-0.13,-0.04,0,0,0,0,0,0,0,0.98,0.98,0.98,2,2.98,7.98,7.98,10,10.98,10,5.98,5.98,4,2.98,2,2,2.09,3.12,4.20,4.24,6.48,7.09,7.52,7.98,8.37,8.70,8.87,9,9,9,9,8.95,8.77,8.50,8.12,7.72,7.50,7.34,8.12,8.97,9.63,10.22,10.50,10.87,11.12,11.12,11.09,10.87,10.62,10.37,10.21,10.08,10,10,10,10,10,10,10.98,12,12.98,12.98,12.87,12.88,13,13.09,13.25,13.70,13.88,14.25,14.64,15,15.32,15.57,15.62,16.25,16.51,16.47,17.46,17.37,19.01,19.86,20.60,21.37,22.23,22.95,23.50,23.89,24.45,24.88,25.34,25.65,25.99,26.24,26.40,26.50,26.37,26.11,25.87,25.74,25.63,25.50,25.61,25.65,25.79,26.07,26.48,27.04,27.83,28.70,29.54,30.32,31,31.66,32.34,32.91,33.33,33.62,33.90,34.25,34.62,35,35.35,35.63,35.62,36.48,36.87,36.96,37,37.98,39,39,39,40,40.98,42.97,42.87,42.83,43.01,43.23,43.98,44.32,45.25,46.22,47.32,48.62,49.20,50,51.02,52.25,54.76,55.09,55.87,56.99,58.14,59.13,59.98,60.72,61.83,63.23,64.67,65.78,66.58,67.41,68.40,69.37,70.12,70.70,72,72,72.98,72.87,73.45,74.12,74.61,75,75.50,76.03,76.61,77.21,77.82,78.46,79.15,79.97,80.87,81.86,82.90,84.10,85.45,86.92,88.65,89.66,90.87,92.23,93.73,95.25,95.95,96.50,97.37,98.13,98.75,99,99.87,97.98,97,92.98,92.98,90,87,84,77,77,74,72,70,67.98,67.98,67,65.98,65.98,65,65,64,64,64,64,64,64,64,64,64,64,65,65,65.98,67,67,67,67,67,68.74,68.49,68.84,69.50,70.71,71.87,72.39,73.33,74.39,75.72,76.62,77.50,78.34,79.07,79.89,80.12,80.62,81.09,81.65,82.37,83.14,83.62,84.36,84.72,85.59,87.62,87.71,87.75,86.99,87,87.98,87.98,89,92,94,95,95,95.98,95,92.98,90,90,87.98,85,82,79,79,77,75.87,73.35,70.23,68.52,67.14,66,64.87,63.82,62.75,61.62,60.47,59.25,58.11,57.07,56.11,55.20,54.63,-0.63,-0.63,-0.63,-0.62,-0.50,-0.25,-0.25,-0.13,-0.02,0,0,0,0,0,0,0.49,0.49,0.49,1.49,1.98,5.99,5.99,7.50,8.48,7.50,3.99,3.99,2.49,1.98,1.49,1.49,1.62,2.13,2.85,3.85,5.13,6.10,6.72,7.25,7.76,8.25,8.57,8.75,8.84,8.87,8.84,8.70,8.38,8,7.50,7.12,7,7.27,7.87,8.60,9.20,9.75,10.33,10.71,10.89,10.97,10.75,10.59,10.37,10.20,10.10,10,10,10,10,10,10,10,10.98,12,12.98,12.98,12.98,13.09,13.35,13.20,13.23,13.48,13.85,14.25,14.64,15.02,15.27,15.39,15.50,15.62,15.85,16.14,16.60,17.34,18.13,19,19.71,20.77,21.77,22.64,23.25,23.70,24.25,24.75,25.12,25.37,25.58,25.63,25.63,25.50,25.15,24.82,24.52,24.63,24.87,25.09,25.24,25.33,25.45,25.62,25.96,26.46,27.17,28.02,28.87,29.64,30.36,31.08,31.82,32.48,32.91,33.24,33.52,33.85,34.16,34.48,34.76,35,35,36.49,36.49,37,37,37.98,39,39,39,40,40.49,42.40,42.48,42.62,42.85,43.25,43.72,44.35,45.11,46.11,47.21,48.12,48.86,49.85,51,52.25,54.75,55.20,55.91,56.88,57.95,58.91,59.75,60.61,61.77,63.33,64.87,66.07,66.72,67.50,68.40,69.35,70.20,70.84,71.45,72,72.98,72.98,73.87,74.62,75.04,75.37,75.78,76.26,76.77,77.32,77.88,78.50,79.20,80,80.89,81.90,82.98,84.17,85.54,87.10,88.62,89.87,90.99,92.25,93.62,94.82,95.52,96.25,97.21,98.14,98.75,99.10,99.37,97.98,96.49,92.49,92.49,89.50,87,84,77,77,74,72,70.49,68.49,68.49,67.49,66.49,66.49,65,65,64.50,64,64,64,64,64,64,64,64.50,64.50,65,65.49,65.98,67,67,67.49,67.49,68,69.47,69.49,69.83,70.50,71.75,72.74,73.64,74.50,75.71,76.98,78,78.89,79.73,80.51,81.22,81.75,82.24,82.74,83.35,84.02,84.75,85.38,85.86,86.38,87.32,88.62,89.09,89.25,88.12,87.49,88.99,88.99,89.99,92,93.49,95.49,95.49,96.49,96,94.99,92,92,88.99,86,84.99,80.99,80.99,79.99,78.48,75.58,71.87,70.35,69.15,67.97,66.83,65.71,64.60,63.37,62.12,60.84,59.61,58.50,57.57,56.72,55.76,-0.80,-0.80,-0.80,-0.77,-0.65,-0.28,-0.28,-0.14,-0.04,0,0,0,0,0,0,0,0,0,0.98,0.98,4,4,5,5.98,5,2,2,0.98,0.98,0.98,0.87,0.87,1.20,1.97,3.32,4.37,5.21,5.73,6.36,7.01,7.63,8.11,8.37,8.59,8.65,8.62,8.46,8.09,7.61,7.12,6.75,6.84,7.20,7.75,8.33,8.87,9.34,10,10.70,10.61,10.62,10.50,10.33,10.12,10.07,10,10,10,10,10,10,10,10,10.98,12,12.98,12.98,12.98,13.09,13.86,13.20,13.12,13.25,13.62,14.14,14.72,15.12,15.50,15.50,15.47,15.40,15.45,15.75,16.14,16.85,17.75,18.24,19.02,20.25,21.65,22.61,23.13,23.59,24.12,24.58,24.87,25.02,25.04,25,24.89,24.74,24.50,24.32,24.26,24.40,24.64,24.87,24.99,25.09,25.17,25.34,25.60,26.02,26.72,27.51,28.34,29.08,29.76,30.53,31.36,32.10,32.61,32.96,33.25,33.54,33.84,34.10,34.37,34.65,35,35.89,36.07,36.87,37.12,37.97,38.87,38.98,39.09,39.95,40,41.89,41.97,42.22,42.74,43.26,43.88,44.37,45.36,46.25,47.25,48.07,48.37,49.86,51,52.32,54.51,54.97,55.74,56.70,57.71,58.67,59.53,60.48,61.75,63.29,64.85,66,66.73,67.51,68.40,69.34,70.08,70.72,71.33,72.09,72.98,72.98,74,74.87,75.15,75.57,75.99,76.46,76.95,77.47,78.01,78.62,79.29,80.11,81,82,83.08,84.25,85.61,87.08,88.62,89.75,90.86,91.98,93.21,94.36,95.01,95.82,96.85,98.65,98.75,98.77,98.87,97.98,95.98,92,92,89,87,84,77,77,74,72,70.98,69,69,67.98,67,67,65,65,65,64,64,64,64,64,64,64,65,65,65,65.98,65.98,67,67,67.98,67.98,69,69.99,70.02,70.09,71.09,72.12,73.75,74.33,75.40,76.75,78.08,79.22,80.13,81,81.83,82.62,83.32,83.87,84.39,85,85.75,86.50,87.12,87.60,87.60,88.37,89.88,90.25,90.75,89.11,87.98,90,90,90.98,92,92.98,95.98,95.98,97,97,97,94,94,90,87,87.98,82.98,82.98,82.98,80.98,77.77,72.52,72.21,71.10,69.87,68.64,67.50,66.35,65.09,63.72,62.27,61,59.87,58.87,58,57,-1.14,-1.14,-1.14,-1.13,-1,-0.64,-0.64,-0.38,-0.13,-0.03,0,0,0,0,0,0,0,0,0,0,0.98,0.98,2,2,0.98,0,0,0,0,0,0.10,0.14,0.23,1.12,2.35,3.73,3.97,4.48,5.12,5.97,6.77,7.40,7.87,8.21,8.37,8.37,8.14,7.75,7.27,6.98,6.75,6.90,7.25,7.75,8.25,8.64,9.14,9.72,10.07,10.22,10.25,10.23,10.12,10.01,10,10,10,10,10,10,10,10,10,10.98,12,12.98,12.98,12.98,13.08,13.09,13.10,13,13.12,13.32,14.09,14.70,15.25,15.61,15.65,15.57,15.35,15.25,15.25,15.75,16.12,17,17.11,18.41,19.62,20.92,21.97,22.70,23.28,23.78,24.23,24.48,24.51,24.50,24.41,24.26,24.12,24,23.98,24.08,24.27,24.57,24.75,24.82,24.91,25.02,25.16,25.40,25.82,26.45,27.20,27.92,28.60,29.25,30.01,30.85,31.65,32.24,32.59,32.91,33.25,33.52,33.76,34.07,34.45,34.87,35.12,35.13,36.12,36.87,37.75,38.77,38.82,39,39.12,40.10,41.12,41.12,42.24,42.72,43.27,44.62,44.98,45.64,46.58,47.39,48.58,49.15,50.01,51.22,52.37,53.72,54.65,55.49,56.47,57.59,58.61,59.50,60.47,61.78,63.29,64.74,65.84,66.67,67.50,68.41,69.33,70.01,70.62,71.24,72.02,72.92,72.98,74,74.84,75.16,75.65,76.12,76.60,77.10,77.62,78.20,78.79,79.48,80.26,81.16,82.16,83.22,84.37,85.64,87.01,88.35,89.53,90.60,91.54,92.62,93.62,94.49,95.38,96.32,97.26,97.84,97.76,97.11,95.98,95,90.98,90.98,89,87,84,77.98,77.98,75,72.98,72.98,70,70,69,67.98,67.98,65.98,65.98,65,65,65,65,65,65,65,65,65.98,65.98,65.98,65.98,67,67.98,67.98,68.07,68.99,69.75,70.47,70.75,71.24,72.01,73.26,74.35,75.25,76.34,77.63,79.07,80.25,81.25,82.12,83.07,84.10,85,85.73,86.25,86.87,87.62,88.47,89.09,89.51,89.87,90.39,92.62,92.74,92.82,91.07,90,92,92,92.98,92.98,92.98,94,94,95,95.98,97,94,94,90.98,90,90.98,87.98,87.98,85.98,82.98,78.87,75.25,74.36,73.11,71.62,70.37,69.15,67.97,66.62,65.15,63.63,62.25,61.09,60.08,59.07,58.27,-2.05,-2.05,-2.05,-1.88,-1.49,-0.91,-0.91,-0.65,-0.38,-0.13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.27,1.38,2.10,2.60,3.01,3.62,4.60,5.61,6.49,7.15,7.64,7.98,8,7.75,7.36,7,6.89,7,7.13,7.36,7.74,8.07,8.72,8.86,9.23,9.75,9.87,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10.98,12.98,12.98,12.89,12.87,12.86,12.86,12.98,13.01,13.25,14,14.62,15.12,15.62,15.63,15.70,15.23,15,15.11,15.09,15.98,16.82,16.97,17.53,18.96,20.25,21.38,22.25,22.89,23.40,23.82,23.97,23.98,23.92,23.87,23.74,23.63,23.59,23.63,23.82,24.07,24.36,24.52,24.66,24.83,24.98,25.14,25.38,25.78,26.36,27.02,27.67,28.24,28.79,29.48,30.25,31,31.58,32.04,32.47,32.86,33.17,33.48,33.78,34.25,34.85,35,35.22,35.75,36.23,37.25,38.21,38.23,38.99,39.20,40.12,41.75,42.12,42.25,43.12,43.33,44.73,45.37,45.95,46.62,47.60,48.58,49.39,50.58,51.35,52.64,53.83,54.72,55.42,56.59,57.74,58.78,59.73,60.74,61.98,63.37,64.73,65.77,66.64,67.52,68.48,69.37,70.08,70.66,71.26,72.03,72.70,73,73,74.21,75.26,75.82,76.28,76.75,77.28,77.86,78.42,79.02,79.70,80.48,81.38,82.37,83.39,84.50,85.72,86.98,88.22,89.35,90.35,91.27,91.61,93.51,94.39,95.36,96.25,96.89,97.23,97.12,96.07,95,94,90.98,90.98,89,87,85,77.98,77.98,75.98,75.98,75,70.98,70.98,70,69,69,67,67,65.98,65.98,65.98,65,65,65,65,65.98,65.98,65.98,67,67,67,67.98,68.15,68.98,69.62,70.38,70.96,71.50,72,72.77,73.90,75,75.87,77.02,78.38,79.89,81.25,82.22,83.09,84.15,85.58,86.89,87.63,88.36,88.96,89.90,90.62,91.27,91.65,92.37,92.37,94.65,95.21,95.12,94.02,92.98,94,94,95,94,92.98,92.98,92.98,92,92.98,92.98,92.98,92.98,90.98,92,92,87.98,87.98,85.98,82,79.88,77.75,77.57,74.62,73.14,71.83,70.52,69.40,68,66.58,64.97,63.40,62.22,61.23,60.10,58.32,-6.39,-6.39,-6.41,-6.29,-5.89,-4.01,-4,-2.75,-1.64,-0.88,-0.18,-0.13,-0.11,-0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.62,0.99,1.24,1.62,2.15,3.25,4.37,5.45,6.36,7,7.39,7.50,7.22,6.87,6.70,6.87,7.24,7.37,7.34,7.23,7.74,8.12,8.21,8.87,9.14,9.87,9.98,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10.98,10.98,12,12.07,12.10,12.83,12.96,13.09,13.25,13.97,14.64,14.87,15.11,15.25,15.22,15.12,15,15,15.08,15.75,16.22,16.59,17.22,18.27,19.57,20.76,21.70,22.37,22.88,23.24,23.37,23.38,23.38,23.37,23.37,23.28,23.27,23.37,23.58,23.86,24.11,24.28,24.52,24.76,25,25.23,25.50,25.89,26.41,27,27.57,28.01,28.46,29,29.64,30.34,30.90,31.45,31.97,32.46,32.88,33.26,33.66,34.16,34.75,35,35.25,35.64,36.25,37.25,38.70,38.75,39.12,39.76,40.90,42.70,42.72,43.12,43.70,44.62,45.60,45.73,46.02,46.37,47.39,48.58,49.39,50.37,51.36,53.08,54.34,55.34,56.17,57.12,58.22,59.25,60.20,61.17,62.35,63.64,64.90,65.90,66.77,67.65,68.62,69.54,70.28,70.90,71.52,72.24,72.84,73.01,73.97,74.78,75.59,76.16,76.50,77.08,77.61,78.17,78.75,79.34,79.97,80.74,81.63,82.62,83.63,84.71,85.85,87.02,88.17,89.25,90.24,91.20,92.51,94.59,95.12,95.87,96.71,97.01,97.15,97.09,96.95,95.98,95,92.98,92.98,90.98,90,85.98,80.98,80.98,80.98,80.98,79,75.98,75.98,72.98,70.98,70.98,69,69,67.98,67,67,67,67,65.98,65.98,65.98,67,67,67,67.98,67.98,68.75,68.98,69.47,70.12,70.75,71.35,71.95,72.50,73.25,74.32,75.25,76.27,77.50,78.90,80.50,82.33,82.87,83.77,85.02,86.70,89,89.22,90.07,92,92.07,93.12,93.23,94.33,95.39,95.62,98.73,98.84,98.87,98.99,97.98,97,97,97.98,97,94,94,94,92,90,87.98,87.98,87.98,89,90.98,90.98,85,85,82.98,82,79.95,77.13,76.62,75.50,74.32,73.21,71.26,70,69,67.98,65.99,64.24,63.08,62.12,61.23,59.37,-7.63,-7.63,-7.66,-7.63,-7.16,-5.40,-5.25,-4,-2.75,-1.52,-0.43,-0.27,-0.16,-0.11,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.23,0.35,0.46,0.75,1.22,2.13,3.33,4.47,5.50,6.27,6.75,6.87,6.62,6.27,6.37,6.84,7.37,7.45,7.12,6.62,7.33,7.82,8.12,8.85,9.12,9.88,9.99,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10.98,10.98,12,12,12.07,12.86,12.98,13.20,13.50,13.97,14.26,14.50,14.70,14.87,15,15,15,15,15.26,15.61,15.96,16.27,16.82,17.71,18.88,20.07,20.97,21.67,22.21,22.57,22.75,22.83,22.88,22.98,23.08,23.12,23.10,23.16,23.41,23.73,24,24.12,24.41,24.75,25.11,25.38,25.67,26.08,26.57,27.11,27.59,27.96,28.27,28.70,29.26,29.88,30.46,30.99,31.61,32.21,32.73,33.20,33.65,34.14,34.75,35,35.15,35.51,36.23,37.36,38.62,38.99,39.32,40.01,41.23,42.62,43.12,43.62,44.27,45.09,45.62,45.98,46.21,46.62,47.39,49.08,49.86,50.62,51.86,53.70,55.20,56.25,57.12,58,58.91,59.87,60.78,61.75,62.85,64.07,65.23,66.17,67.04,67.98,68.98,69.95,70.72,71.36,71.98,72.64,73.28,73.89,74.61,75.50,76.22,76.75,77.17,77.60,78.11,78.64,79.21,79.73,80.29,81.03,81.96,82.92,83.91,84.92,86.01,87.15,88.25,89.25,90.24,91.38,92.89,95.12,95.77,96.50,97.24,97.49,97.50,97.50,97.48,96.49,96,93.99,93.99,91.98,90,85.98,81.98,81.98,81.98,81.98,79.99,75.98,75.98,73.49,71.98,71.49,69.50,69.50,68.49,67.49,67.49,67,67,66.49,66.49,66.49,67.49,67.49,67.49,67.98,68.49,68.84,69.33,69.84,70.46,71.12,71.65,72.25,72.85,73.51,74.49,75.49,76.59,77.84,79.27,80.87,82.20,83.25,84.25,85.61,87.35,89.10,90.14,91.22,92.33,93.25,93.75,94.14,94.62,95.25,96.25,98.75,99.11,99.47,99.50,98.49,97,97,97.98,96.49,94.50,94.50,94.50,92.49,90,87.98,88.49,88.49,89.50,90.98,90.98,85.49,85.49,83.49,81.49,79.99,77.20,76.52,75.50,74.39,73.11,71.33,69.82,68.64,67.33,65.86,64.50,63.37,62.49,61.37,59.89,-8.80,-8.80,-8.90,-8.91,-8.41,-6.77,-6.65,-5.42,-3.76,-2.27,-0.65,-0.62,-0.36,-0.17,-0.12,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.11,0.21,0.38,0.84,1.50,2.46,3.51,4.61,5.49,6.01,6.12,5.96,5.85,6.13,6.76,7.40,7.38,6.97,6.09,7.09,7.86,8.09,8.87,9.01,9.99,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10.98,10.98,12,12,12,12.87,13.10,13.12,13.76,13.97,14.11,14.20,14.21,14.82,14.87,14.99,15,15.01,15.23,15.49,15.75,16.04,16.49,17.27,18.26,19.35,20.20,20.88,21.42,21.87,22.15,22.35,22.50,22.70,22.89,23.04,23.12,23.08,23.15,23.85,24.11,24.07,24.04,24.90,25.28,25.61,25.88,26.26,26.75,27.29,27.75,28.07,28.32,28.66,29.23,29.84,30.38,30.95,31.57,32.24,32.79,33.28,33.74,34.22,34.72,34.99,35.11,35.37,36.12,37.36,38.62,39.12,39.36,40.34,41.25,42.65,43.35,44.09,44.75,45.33,46,46.36,46.37,47.15,47.39,49.61,50.37,51.37,52.37,54.82,56.33,57.40,58.14,58.90,59.72,60.58,61.40,62.34,63.38,64.53,65.62,66.57,67.46,68.42,69.50,70.50,71.29,71.96,72.57,73.24,73.96,74.70,75.47,76.25,76.95,77.50,77.90,78.29,78.75,79.25,79.75,80.23,80.74,81.40,82.29,83.25,84.24,85.21,86.25,87.34,88.35,89.33,90.37,91.35,93.33,95.65,96.25,97.25,98.02,98.12,98.09,98,97.98,97,97,95,95,92.98,90,85.98,82.98,82.98,82.98,82.98,80.98,75.98,75.98,74,72.98,72,70,70,69,67.98,67.98,67,67,67,67,67,67.98,67.98,67.98,68.07,68.82,69.14,69.58,70.08,70.74,71.40,72,72.52,73.09,73.75,74.76,75.82,76.90,78.12,79.62,81.20,82.50,83.61,84.63,85.98,87.71,89.25,90.72,91.73,92.75,94.21,94.25,94.34,94.45,94.88,96.21,98.86,98.95,100,100,99,97,97,97.98,95.98,95,95,95,92.98,90,87.98,89,89,90,90.98,90.98,85.98,85.98,84,80.98,80,77.25,76.50,75.48,74.22,73.12,70.71,69.12,68,66.64,65.21,64,63.23,62.26,61.39,60.49,-11,-11,-11,-11,-10,-9.63,-9.18,-7.75,-6.13,-4.03,-1.50,-1.28,-0.75,-0.39,-0.24,-0.12,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.24,0.50,1,1.74,2.62,3.59,4.52,5.12,5.25,5.12,5.26,5.87,6.74,7.50,7.38,6.87,5.98,7,7.98,7.98,9,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10.98,10.98,12,12,12.98,13,13,13.87,13.87,13.99,14,14,14.12,14.12,14.87,14.99,14.99,15.02,15.13,15.32,15.52,15.78,16.20,16.87,17.74,18.67,19.46,20.12,20.72,21.26,21.72,22.01,22.25,22.52,22.82,23.07,23.17,23.16,23.20,23.87,24.86,24.89,24.99,25.16,25.64,25.89,26.11,26.48,27.07,27.63,28.11,28.41,28.63,29.01,29.60,30.24,30.78,31.37,31.99,32.62,33.12,33.60,33.91,34.25,34.70,35,35.20,35.37,36.23,37.38,38.60,39.37,40.23,41.22,42.32,43.62,44.22,44.37,45.36,46.12,46.74,47.20,47.37,48.35,49.37,51.60,52.37,53.35,54.75,56.15,57.73,58.39,59.09,59.75,60.49,61.25,62.02,62.90,63.92,65.03,66.10,67.02,67.96,68.99,70.11,71.14,71.96,72.59,73.16,73.85,74.60,75.48,76.25,76.98,77.78,78.25,78.64,79.01,79.45,79.90,80.37,80.79,81.26,81.90,82.71,83.75,84.71,85.71,86.67,87.63,88.59,89.48,90.36,92.28,94.28,96.75,97.23,98.14,99.84,99.87,99.96,100,99,99,97.98,95.98,95.98,94,90,87,85,85,85.98,84,82,77,77,75,74,72.98,72,72,70,69,69,67.98,67.98,67,67,67,67.98,67.98,67.98,68.73,69.12,69.46,69.88,70.35,71,71.75,72.37,72.89,73.49,74.12,75.27,76.34,77.48,78.60,80.11,81.60,82.88,84.09,85.24,86.47,87.65,90.25,91.12,92.12,93.02,93.26,93.37,93.46,93.52,93.65,94.85,96.95,97,97.98,99,97.98,97.98,97.98,97.98,97,95.98,95,95,92.90,90.87,89.23,89.21,89.23,90.13,90.90,92,87,87,84,82,80,77.26,76.50,75.33,73.82,71.76,68.83,68.50,67.37,66.07,64.50,62.63,62.38,61.52,60.75,59.52,-12,-12,-13,-13,-13,-12,-11,-10,-9,-6.76,-2.90,-2.89,-1.64,-0.88,-0.50,-0.15,-0.12,-0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.32,0.62,1.10,1.72,2.46,3.15,3.71,3.95,4.12,4.50,5.26,6.47,6.97,7.07,6.52,5.98,7,7.98,7.98,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10.98,10.98,12,12,12.98,14,14,14,13.98,13.97,13.95,14,14,14.01,14.95,15,14.96,14.95,15,15.10,15.25,15.49,15.87,16.52,17.35,18.21,18.91,19.58,20.23,20.88,21.47,21.86,22.14,22.46,22.79,23.10,23.23,23.24,23.21,23.99,24.84,25.12,25.90,25.97,26.09,26.35,26.52,26.88,27.48,28.10,28.62,28.98,29.29,29.77,30.39,31.07,31.66,32.25,32.86,33.38,33.85,34.23,34.25,34.27,35.34,35.37,35.37,36.35,36.37,37.40,39.58,40.39,41.37,42.37,44.34,45.36,45.37,45.37,46.34,47.25,48.22,48.33,49.24,50.01,51.36,53.62,54.37,55.62,56.64,57.45,58.40,59.22,59.76,60.41,61.13,61.87,62.62,63.48,64.47,65.54,66.61,67.54,68.49,69.54,70.70,71.74,72.52,73.13,73.73,74.38,75.13,76,76.82,77.59,78.49,78.92,79.26,79.64,80.08,80.52,80.98,81.41,81.89,82.58,83.53,84.63,85.50,86.47,87.65,88.45,89.41,89.36,91.25,93.24,95.24,97.76,98.12,100,100.98,101,100.98,100.98,100.98,100,100,97,97,94,90.98,89,87,87,87,85,82,77,77,75.98,75,74,72,72,70.98,70,69,67.98,67.98,67.98,67.98,67.98,67.98,67.98,69,69.12,69.62,70,70.50,70.88,71.52,72.25,72.89,73.50,74.12,74.82,76.01,77.11,78.14,79.34,80.64,82.12,83.49,84.75,86.01,87.26,88.50,90.37,91.50,92.35,93.37,93.39,90.47,90.52,91.70,90.77,89.95,90.98,90.98,94,97,97.98,97.98,97.98,99,97,97,95,95,93.10,91.25,89.87,89.62,89.64,90.71,90.82,90.98,87,87,84,82,80,77.32,76.50,75.24,73.52,71.38,68.76,68.25,67.22,65.62,64.32,62.61,62.13,61.49,60.38,58.61,-16,-16,-17,-17,-17,-14,-14,-14,-12,-10,-7.68,-7.68,-6.11,-4.50,-2.89,-1.25,-0.79,-0.29,-0.16,-0.11,-0.03,-0.01,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.12,0.33,0.59,0.95,1.37,1.87,2.27,2.60,2.90,3.50,4.33,5.24,5.75,5.87,5.87,5.98,5.98,7,7,7.98,7.98,9,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10.98,10.98,12,12,12.98,12.98,12.98,12.98,12.98,12.98,14,14,14,14,15,15,14.78,14.76,14.79,14.87,15.01,15.25,15.64,16.27,17.07,17.87,18.57,19.25,19.99,20.74,21.37,21.79,22.11,22.42,22.78,23.11,23.25,23.25,23.22,23.99,24.83,25.12,25.88,25.99,27,26.82,27.04,27.40,27.99,28.60,29.16,29.59,30,30.59,31.32,32,32.65,33.15,33.75,34.50,34.62,35.01,35.73,35.87,36.62,37.50,37.48,37.49,38,39.24,41.39,42.13,44.50,46.52,47.61,49.65,49.62,47.70,47.73,48.71,50.48,50.27,50.48,51.35,52.75,55.03,55.27,56.21,56.96,57.85,58.85,59.58,60.21,60.87,61.64,62.45,63.22,64.07,65.07,66.13,67.21,68.13,69.08,70.10,71.17,72.17,72.96,73.58,74.15,74.82,75.54,76.37,77.12,77.92,78.66,79.25,79.71,80.12,80.60,81.03,81.50,81.98,82.50,83.25,84.47,86.47,86.75,87.60,88.76,90.59,91.67,91.75,92.77,94.79,97.10,100.87,100.87,101.95,102.97,104,104,104,104,102.98,102,97.98,97.98,95.98,95,92.98,90.98,90.98,89,85,84,82,82,80.98,80,79,75,75,72.98,72,70.98,70,70,69,69,69,69,69,69,69.57,70.08,70.50,71.02,71.48,72.08,72.75,73.48,74.12,74.75,75.49,76.71,77.86,79,80,81.32,82.72,84.10,85.40,86.83,88.50,89.62,91.50,91.50,91.50,90.51,87.37,80.34,80.25,80.12,80.02,79,80.98,80.98,84,85.98,90.98,97.98,97.98,97.98,97.98,97,95,95,92.99,91.64,89.62,87.37,87.37,86.27,86.21,85.98,80.98,80.98,79,79,79,77.26,76.52,75.39,73.60,71.59,69.72,68.50,67.50,66.15,64.62,63.50,62.51,61.76,60.59,58.62,-17,-17,-17,-17,-17,-15,-15,-14,-13,-11,-9.38,-8.67,-7.49,-5.88,-4.13,-2.13,-1.63,-0.80,-0.39,-0.25,-0.13,-0.02,-0.01,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.12,0.25,0.39,0.62,0.87,1.13,1.36,1.76,2.37,3.07,3.70,4.12,4.37,4.57,5.49,5.49,7,7,7.49,7.49,8.49,9.50,9.50,10,10,10,10,10,10,10,10,10,10,10,10,10,11.49,11.49,12.49,12,12.49,12.98,12.98,12.98,12.98,12.98,14,14,14,14,14.50,14.50,14.49,14.49,14.53,14.65,14.85,15.11,15.51,16.14,16.91,17.70,18.37,19.09,19.87,20.66,21.35,21.78,22.11,22.41,22.78,23.11,23.26,23.32,23.24,24.01,24.82,25.13,25.87,26,27,27.49,27.62,27.91,28.40,29.04,29.59,30.09,30.61,31.25,32.14,32.86,33.51,33.89,34.40,34.89,35.36,35.65,36.25,36.96,37.57,38.12,38.50,38.76,39.23,40.14,41.84,43.12,44.75,46.52,48.22,49.62,49.71,48.76,48.75,49.42,50.14,50.84,51.26,52.07,53.28,54.42,55.47,56.15,57.07,58,58.89,59.67,60.40,61.13,62.01,62.95,63.82,64.71,65.70,66.77,67.85,68.77,69.66,70.62,71.62,72.53,73.28,73.90,74.51,75.20,75.90,76.62,77.32,78.12,78.85,79.48,80,80.50,81,81.50,81.98,82.46,83.02,83.82,84.96,87.02,87.73,88.50,89.76,91.25,92.83,93.10,93.57,95.47,97.50,101.98,101.98,103,103.49,104.50,104.50,104.50,104.50,103.99,102.49,98.99,98.99,96.98,96,93.99,91.49,91.49,89.50,87,85.50,83,83,81.98,81.49,79.99,76,76,73.99,72.49,71.49,70.49,70.49,69.50,69.50,69.50,69.50,69.50,69.50,70,70.62,71.12,71.61,71.98,72.50,73.25,73.95,74.75,75.26,76.01,77.25,78.48,79.74,80.62,81.97,83.37,84.76,86.12,87.50,88.87,90.12,91.07,91.08,90.11,88.11,84.63,77.75,77.37,77.08,76.98,75.99,78.99,78.99,82,84.48,88.99,96.98,96.98,97.98,97.98,97,94.50,94.50,92.63,90.75,88.59,85.88,85.23,84.83,84.34,83.99,79.48,79.48,78,77,77,76.59,76.12,75.49,73.77,71.89,70.07,69.08,68.10,66.75,65.21,63.87,63.12,62.37,61.12,59.14,-18,-18,-17,-17,-17,-16,-16,-15,-14,-12,-10,-10,-8.88,-7.42,-5.74,-3.61,-2.91,-1.88,-1,-0.63,-0.26,-0.13,-0.11,-0.02,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.09,0.12,0.24,0.36,0.49,0.62,0.87,1.26,1.82,2.25,2.59,2.87,2.98,5,5,7,7,7,7,7.98,9,9,10,10,10,10,10,10,10,10,10,10,10,10,10,12,12,12.98,12,12,12.98,12.98,12.98,12.98,12.98,14,14,14,14,14,14,14.21,14.25,14.32,14.52,14.78,15.12,15.65,16.24,16.88,17.59,18.28,19,19.75,20.48,21.12,21.65,22.08,22.41,22.77,23.10,23.27,23.37,23.50,24.07,24.74,25.37,25.78,26.34,26.88,27.98,27.98,28.01,28.85,29.36,30.04,30.52,31,31.67,32.53,33.53,33.84,34.22,34.96,35,35.87,36.14,36.96,37.62,38.25,38.75,39.25,39.64,40.12,40.74,42.25,43.52,44.98,46.62,48.36,49.58,49.85,49.50,49.47,49.83,50.37,50.97,51.51,52.23,53.12,54.09,55.01,55.97,56.95,57.96,58.90,59.73,60.48,61.26,62.29,63.39,64.38,65.36,66.38,67.50,68.57,69.49,70.33,71.16,72.08,72.92,73.64,74.27,74.89,75.60,76.29,76.96,77.62,78.33,79.10,79.74,80.28,80.83,81.37,81.92,82.42,82.92,83.39,84.40,85.40,87.58,88.32,89.28,90.25,92.14,93.87,94.09,94.07,96,97.98,102.98,102.98,104,104,105,105,105,105,105,102.98,100,100,97.98,97,95,92,92,90,89,87,84,84,82.98,82.98,80.98,77,77,75,72.98,72,70.98,70.98,70,70,70,70,70,70,70.40,71,71.50,71.98,72.37,72.87,73.59,74.35,75.09,75.71,76.47,77.71,79,80.21,81.12,82.62,84.22,85.64,86.83,88.12,89.25,90.62,90.62,90.62,88.70,85.71,82.75,75.13,74.87,73.99,74,72.98,77,77,80,82.98,87,95.98,95.98,97.98,97.98,97,94,94,92.12,90.14,87.60,84.37,83.75,83.12,82.75,82,77.98,77.98,77,75,75,75.87,75.70,75.59,73.51,72.49,70.47,69.72,68.75,67.37,65.86,64.37,63.84,63.09,61.75,59.65,-18,-18,-18,-18,-18,-17,-17,-16,-15,-14,-12,-11,-10,-9.28,-7.75,-6.25,-4.90,-4.01,-2.90,-1.88,-1,-0.88,-0.61,-0.36,-0.16,-0.12,-0.03,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.08,0.12,0.14,0.24,0.35,0.50,0.76,1.07,1.24,0.98,2,2.98,2.98,5,5,5,5,5.98,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,12,12,12,12,12,12,12,12.98,12.98,12.98,14,14,14,14,14,14,14.08,14.23,14.37,14.60,14.97,15.33,15.75,16.27,16.87,17.52,18.21,18.90,19.62,20.34,20.99,21.52,21.98,22.36,22.75,23.07,23.26,23.40,23.58,24.10,24.75,25.34,25.86,26.36,27,27.62,27.98,29,29,30,30.98,30.98,30.98,32,32.98,34,34,34,35,35.98,36.87,36.95,37.61,38.13,38.76,39.35,39.87,40.36,40.87,41.74,42.71,43.74,45.25,46.82,48.38,50.48,50.35,50.11,50.03,50.22,50.51,50.90,51.39,52.01,52.78,53.67,54.61,55.62,56.72,57.82,58.78,59.65,60.50,61.42,62.50,63.76,64.88,65.98,67.09,68.25,69.36,70.26,71.07,71.85,72.66,73.48,74.15,74.76,75.38,76.10,76.83,77.49,78.12,78.75,79.48,80.12,80.67,81.20,81.82,82.48,83.01,83.37,84.28,85.21,86.28,88.70,89.26,90.73,91.12,93.10,95.88,96.03,97.92,97.99,97.98,102,102,105,105.98,105.98,107,107,105.98,105.98,105,102,102,100.98,99,97,95,95,92.98,90.98,90,85.98,85.98,85,84,82,77.98,77.98,75.98,74,72.98,70.98,70.98,70.98,70.98,70.98,70.98,70.98,70.98,71,71.52,72,72.46,72.82,73.25,73.99,74.62,75.32,75.97,76.84,78.13,79.46,80.71,81.71,83.25,85.09,86.96,87.89,88.76,89.75,89.75,87.25,86.75,84.22,81.90,79.87,71,70.98,69,70,70,75.98,75.98,79,82,85.98,95,95,97,97,95.98,92.98,92.98,92.13,90.25,87.33,83.33,83,81.25,80.13,79,75.98,75.98,75,72.98,72,72.90,72.85,72.75,72.74,71.72,70.62,70.62,69.60,68.10,66.75,65.62,64.62,63.76,62.65,60.70,-18,-18,-18,-18,-18,-17,-17,-17,-16,-15,-14,-13,-12,-11,-10,-8.75,-7.63,-6.52,-5.49,-4.24,-2.91,-2.28,-1.75,-1.25,-0.88,-0.65,-0.50,-0.43,-0.39,-0.28,0,0,0,0,-0.01,0,0,0,0,0,0,0,0,0,0.01,0.07,0.10,0.12,0.21,0.25,0,0,0.98,0.98,2,2.98,2.98,2.98,4,5,9,9,10,10,10,10,10,10,10,10,10,10,10,10,10.98,12,12,12,12,12,12,12,12.98,12.98,12.98,14,14,14,14,14,14,14.36,14.45,14.62,14.87,15.15,15.49,15.87,16.34,16.87,17.49,18.13,18.83,19.52,20.22,20.86,21.40,21.87,22.26,22.62,22.92,23.17,23.39,23.61,24.10,24.72,25.29,25.84,26.36,26.98,27.61,28.26,29,29,30,30.98,30.98,32,32.98,34,34,34,35,35,35.98,36.87,37.25,37.83,38.50,39.15,39.75,40.32,40.85,41.50,42.36,43.33,44.45,45.70,47.09,48.62,49.74,50.45,50.62,50.53,50.50,50.57,50.75,51.11,51.66,52.41,53.34,54.28,55.37,56.50,57.62,58.65,59.58,60.49,61.49,62.65,64.02,65.27,66.50,67.72,69,70.16,71.09,71.85,72.59,73.37,74.13,74.77,75.37,75.99,76.72,77.47,78.13,78.76,79.37,80.01,80.64,81.23,81.82,82.48,83.21,83.87,84.37,85.38,86.35,87.34,89.72,90.15,91.10,93.08,94.09,97.90,98.01,99.98,100.98,100.98,102,102,104,105.98,107,107,107,107.98,107.98,105.98,104,104,102,100,97.98,97,97,95.98,94,92,87.98,87.98,85.98,85,82.98,80,80,77,75,74,72,72,72,70.98,70.98,70.98,70.98,70.98,71.87,72.25,72.62,73.01,73.38,73.87,74.45,75,75.62,76.37,77.37,78.70,79.86,81.01,82.14,83.82,85.95,88.11,88.75,89.87,88.87,86.87,83.10,82.87,79.88,77.89,75.97,67.98,67.98,65.98,67,67,74,74,77.98,82,85.98,92.98,92.98,94,95,95.98,95,95,93.96,92.12,89.75,84.25,83.75,81.12,79,77,74,74,72.98,72,70.98,67.99,68.08,68.39,67.83,67.47,68.25,68.37,68.57,68.09,68.32,65.87,65.32,64.64,63.87,62.73,-18,-18,-18,-18,-18,-18,-18,-18,-18,-16,-15,-15,-14,-13,-12,-11,-10,-9.01,-7.75,-6.50,-5.38,-4.29,-3.50,-2.75,-2.14,-1.75,-1.41,-1.26,-1.18,-1.03,-0.88,-0.74,-0.38,-0.05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.98,2,5,5,7,9,10,10,10,10,10,10,10,10,10.98,10.98,10.98,12,12,12,12,12.98,12.98,12.98,12.98,12.98,12.98,14,14,14,14,14,15,14.67,14.75,14.89,15.11,15.36,15.63,15.98,16.38,16.88,17.46,18.09,18.75,19.42,20.11,20.73,21.28,21.75,22.15,22.51,22.83,23.12,23.37,23.61,24.09,24.65,25.24,25.78,26.34,26.98,27.62,28.25,28.75,29,30,30.98,30.98,32,32.98,34,34,34,35,35,35.98,36.87,37.25,37.96,38.70,39.37,40,40.59,41.14,41.88,42.86,43.95,45.07,46.22,47.45,48.72,49.85,50.49,50.87,50.85,50.71,50.54,50.57,50.83,51.34,52.21,53.21,54.21,55.26,56.37,57.50,58.54,59.50,60.47,61.52,62.78,64.17,65.57,66.88,68.23,69.63,70.90,71.86,72.57,73.28,74.07,74.82,75.40,75.97,76.61,77.37,78.25,78.97,79.47,80,80.64,81.32,81.87,82.50,83.20,83.96,85.08,85.64,86.66,87.64,88.86,90.74,91.16,92.83,94.91,96.92,99.96,100.01,102,104,105,104,104,104,105,107,110,110,110,110,107.98,105,105,102.98,102,100.98,97,97,95,92.98,90.98,87.98,87.98,87,85.98,84,80.98,80.98,79,77,75,72.98,72.98,72.98,72.98,72.98,72.98,72.98,72.98,72.51,72.95,73.25,73.62,73.89,74.36,74.87,75.37,75.99,76.73,77.74,79.01,80.14,81.25,82.38,84.01,86.26,88.25,89.10,89,87,84,77,77,74,72,70,64,64,62.98,62,62,69,69,72.98,77,79,84,84,85,85.98,90.98,97,97,97,95,92,85,85,82,77.98,74,69,69,67.98,67.98,67.98,65.98,66,65.02,64.59,63.08,63.22,63.12,64.08,64.52,65.20,65.25,65.25,65.37,65.50,64.76,-18,-18,-18,-18,-18,-18,-18,-18,-18,-17,-17,-16,-15,-14,-13,-12,-12,-10,-9.75,-8.63,-7.50,-6.41,-5.50,-4.74,-4,-3.38,-2.91,-2.63,-2.62,-2.27,-1.92,-1.51,-1.11,-0.63,-0.28,-0.13,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.49,1,3.50,3.50,5.50,7.49,8.99,10,10,10,10,10,10.49,10.49,10.98,10.98,11.49,12,12,12,12.49,12.98,12.98,12.98,12.98,12.98,12.98,14,14,14,14,14,15,14.92,14.97,15.11,15.28,15.50,15.75,16.07,16.42,16.89,17.42,18.03,18.67,19.35,20,20.62,21.16,21.65,22.08,22.42,22.75,23.07,23.36,23.70,24.08,24.61,25.17,25.74,26.33,26.98,27.62,28.25,28.63,29,30,31.49,31.49,32,32.98,33.49,34,34,35,35,35.98,36.87,37.25,38.02,38.82,39.50,40.13,40.75,41.37,42.21,43.25,44.47,45.62,46.71,47.82,48.88,49.82,50.57,51,51.03,50.86,50.62,50.47,50.72,51.25,52.24,53.29,54.32,55.35,56.40,57.52,58.61,59.58,60.50,61.62,62.99,64.45,65.90,67.24,68.66,70.13,71.48,72.46,73.11,73.79,74.62,75.34,75.95,76.41,77.10,78.09,78.87,79.51,79.98,80.50,81.21,81.88,82.57,83.21,83.88,84.64,85.38,86.17,87.03,88.21,89.62,91.20,91.71,93.35,95.09,97.02,100.99,101,102.49,104,105,105.50,105.50,104.99,106,107.49,111,111,111.49,110.49,108.99,105.49,105.49,103.49,103,101.98,97.49,97.49,95,92.98,90.98,87.98,87.98,87,85.98,84.50,81.49,81.49,79,77,75,73.49,73.49,73.49,72.98,72.98,72.98,72.98,72.98,73,73.26,73.62,73.97,74.25,74.71,75.24,75.74,76.35,77.09,78.10,79.25,80.34,81.37,82.40,84.08,86.33,88.37,88.99,89,87,83.49,74.99,74.99,72,69.99,67.99,63,63,61.98,61.49,61.49,68.49,68.49,72.49,74.99,77,81.50,81.50,81.49,82.99,88.99,96,96,96,93.99,91,83.99,83.99,81,77.49,74,68.49,68.49,66.98,66.98,66.98,65.49,65.49,64.01,62.64,61.62,60.90,60.82,61.33,62.21,63.02,63.77,64.25,64.49,64.51,64.35,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-17,-17,-16,-15,-15,-14,-13,-12,-11,-10,-9.38,-8.42,-7.55,-6.75,-6,-5.38,-4.88,-4.80,-4.49,-4.01,-3.51,-2.91,-2.26,-1.53,-0.88,-0.38,-0.13,-0.05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,4,5.98,7.98,10,10,10,10,10,10.98,10.98,10.98,10.98,12,12,12,12,12.98,12.98,12.98,12.98,12.98,12.98,12.98,14,14,14,14,14,15,15.01,15.11,15.24,15.40,15.62,15.85,16.12,16.47,16.89,17.41,18,18.62,19.26,19.89,20.50,21.07,21.57,21.99,22.36,22.70,23,23.34,23.67,24.10,24.57,25.12,25.70,26.25,26.96,27.62,28.24,28.76,29,30,32,32,32,32.98,32.98,34,34,35,35,35.98,36.87,37.40,38.24,38.90,39.60,40.21,40.82,41.49,42.39,43.62,44.89,46.10,47.12,48.12,49.07,49.92,50.63,51.11,51.25,51.14,50.92,50.77,50.96,51.52,52.50,53.59,54.60,55.59,56.62,57.75,58.86,59.85,60.78,61.91,63.29,64.82,66.29,67.66,69.12,70.59,71.89,72.85,73.51,74.16,74.87,75.52,76.13,76.71,77.37,78.34,79.12,79.87,80.37,80.95,81.75,82.50,83.20,83.85,84.51,85.25,85.92,86.32,87.36,88.29,90.13,91.71,92.25,93.83,95.12,97.01,102,102,102.98,104,105,107,107,105.98,107,107.98,112,112,112.98,110.98,110,105.98,105.98,104,104,102.98,97.98,97.98,95,92.98,90.98,87.98,87.98,87,85.98,85,82,82,79,77,75,74,74,74,72.98,72.98,72.98,72.98,72.98,73.11,73.46,73.82,74.13,74.50,74.96,75.52,76.09,76.74,77.46,78.40,79.50,80.49,81.47,82.62,84.25,86.52,88.51,89.09,89,87,82.98,72.98,72.98,70,67.98,65.98,62,62,60.98,60.98,60.98,67.98,67.98,72,72.98,75,79,79,77.98,80,87,95,95,95,92.98,90,82.98,82.98,80,77,74,67.98,67.98,65.98,65.98,65.98,65,65,63.12,61.86,60.77,60,59.57,59.74,60.12,60.86,62.36,62.37,63.50,63.62,63.87,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-17,-17,-16,-16,-15,-14,-13,-12,-12,-11,-10,-9.63,-9,-8.37,-7.88,-7.63,-7.29,-6.91,-6.39,-5.87,-5.13,-4.29,-3.26,-2.13,-1.28,-0.75,-0.51,-0.29,-0.14,-0.12,-0.03,-0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.98,0.98,2,2.98,5.98,10,10,10,9,9,10.98,10.98,10.98,10.98,12,12,12,12.98,12.98,12.98,12.98,12.98,12.98,12.98,12.98,14,14,14,14,15,15,15.09,15.20,15.34,15.49,15.65,15.87,16.13,16.48,16.89,17.39,17.97,18.58,19.20,19.82,20.40,20.97,21.47,21.89,22.27,22.62,22.96,23.28,23.63,24.04,24.52,25.04,25.62,26.24,26.89,27.62,28.25,28.95,30,30,32,32,32,32.98,32.98,34,34,35,35.98,35.98,37.75,37.98,38.51,39.12,39.64,40.22,40.76,41.50,42.52,43.87,45.26,46.50,47.49,48.37,49.27,50.13,50.85,51.37,51.63,51.66,51.57,51.48,51.59,52.09,53.02,54.10,55.09,56.04,57.09,58.23,59.36,60.36,61.35,62.41,63.77,65.27,66.82,68.20,69.61,71.04,72.32,73.32,73.84,74.45,75.07,75.63,76.17,76.87,77.50,78.50,79.33,80.13,80.72,81.47,82.32,83.11,83.82,84.47,85.12,85.88,86.62,87.27,88,89.12,90.32,92.65,93.21,94.22,95.87,98.08,102.97,102.98,104,105,105.98,107.98,107.98,107.98,107.98,110,114,114,114,112.98,110.98,107,107,105.98,105.98,105,99,99,95.98,94,92,87.98,87.98,87,85.98,85,80.98,80.98,79,77,75.98,74,74,74,74,74,72.98,72.98,73,73.01,73.82,74.15,74.51,74.87,75.33,76.01,76.62,77.38,78.12,78.99,80,80.83,81.77,82.98,84.62,86.52,89.75,90,90,87,82.98,70.98,70.98,65.98,64,62,60.98,60.98,60,60,60,65.98,65.98,69,69,70,72.98,72.98,72.98,75.98,82,90.98,90.98,92,90,87.98,82,82,79,75.98,72.98,67,67,65.98,64,64,62.98,62.98,61.89,60.87,59.75,58.87,58.25,58.12,58.14,58.45,58.95,59.35,59.35,59.21,58.99,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-17,-17,-17,-16,-15,-14,-14,-13,-12,-12,-11,-11,-10,-10,-10,-10,-9.62,-9.12,-8.51,-7.88,-7.03,-5.93,-4.63,-3,-2.50,-1.88,-1.03,-0.49,-0.25,-0.17,-0.13,-0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.98,2,4,7.98,7.98,7.98,7.98,9,10.98,10.98,10.98,10.98,12,12,12,12.98,12.98,12.98,12.98,12.98,12.98,12.98,12.98,14,14,14,14,15,15,15.13,15.27,15.39,15.52,15.66,15.87,16.14,16.49,16.90,17.39,17.95,18.51,19.12,19.73,20.32,20.87,21.37,21.82,22.21,22.57,22.89,23.24,23.59,24,24.48,24.99,25.50,26.21,26.87,27.61,28.32,29.10,29.87,30.87,31.60,32.11,32.98,32.98,32.98,34,34,35,35.98,37,37.74,38.52,38.96,39.35,39.75,40.15,40.71,41.45,42.50,44,45.57,46.87,47.75,48.62,49.53,50.40,51.15,51.77,52.20,52.39,52.41,52.38,52.49,52.91,53.74,54.76,55.74,56.71,57.72,58.85,59.98,60.98,61.97,63.04,64.37,65.87,67.37,68.75,70.07,71.40,72.88,73.37,74.37,74.54,75.23,75.92,75.98,77,77.74,78.50,79.33,80.39,81.12,82,82.87,83.71,84.38,85.12,85.75,86.35,87.60,87.95,88.64,89.65,91.21,92.62,93.25,95,96.14,98.11,101.95,102,104,105,107,109,109,110,110,110.98,115,115,115.98,114,112.98,110,110,109,109,107,100,100,97,94,92,89,89,87,85.98,84,80,80,79,77,75.98,75,75,74,74,74,74,74,74.01,74.09,74.11,75.12,75.46,75.77,76.25,77.01,77.75,78.48,79.08,79.87,80.85,81.75,82.74,83.84,85.45,87.34,90.90,90.98,90,87.98,82.98,67.98,67.98,64,62,60.98,60,60,59,59,59,62.98,62.98,64,65.98,67,69,69,70,72,77,85.98,85.98,87.98,87.98,87,82,82,79,75.98,72.98,67.98,67.98,65,64,62,60.98,60.98,60.08,59.20,58.37,57.51,56.87,56.48,56.25,56.09,56.01,56,55.90,55.01,55,-12,-12,-15,-17,-17,-18,-18,-18,-18,-18,-18,-18,-18,-18,-17,-17,-16,-15,-15,-14,-14,-14,-13,-13,-13,-13,-12,-12,-12,-11,-11,-10,-9.75,-8.63,-6.93,-5.62,-4.50,-3.54,-2.74,-2,-1.43,-1.13,-0.87,-0.63,-0.38,-0.13,-0.13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.98,2.98,2.98,5,7,7.98,10.98,10.98,10.98,10.98,10.98,12,12,12,12,12,12.98,12.98,12.98,12.98,12.98,14,14,14,15,15,15,15.17,15.36,15.46,15.53,15.65,15.87,16.15,16.51,16.95,17.41,17.95,18.50,19.08,19.64,20.23,20.76,21.27,21.74,22.13,22.50,22.85,23.17,23.51,23.95,24.41,24.95,25.50,26.12,26.87,27.61,28.33,29.12,30,30.99,31.62,32.11,32.32,32.98,32.98,34,34,35,35.98,37,38.49,38.89,39.27,39.62,39.86,40.12,40.52,41.24,42.35,44.01,45.75,47.15,48,48.87,49.79,50.71,51.50,52.21,52.76,53.16,53.37,53.39,53.45,53.79,54.51,55.51,56.50,57.46,58.46,59.52,60.61,61.58,62.53,63.61,64.88,66.39,68.25,69.25,70.50,71.64,72.61,73.33,73.12,74.13,75.12,76.87,76.96,77.83,77.86,78.32,79.50,80.50,81.45,82.49,83.39,84.22,84.88,85.62,86.62,87,87.57,88.25,89,90.09,91.36,93.62,94.32,95.74,97.75,100.13,103.88,104,105.98,107,107.98,109,109,110,110.98,112,114,114,115,115.98,115,114,114,112.98,110.98,107.98,100,100,97,95,92.98,90,90,89,87.98,85.98,82.98,82.98,80,79,77.98,77,77,75.98,75.98,75.98,75.98,75.98,75.90,75.87,75.87,76.85,76.62,76.82,77.21,78,78.97,79.38,79.87,80.60,81.62,83.08,83.46,84.50,86.65,88.07,90.90,90.98,90.98,87.98,82.98,67,67,62,60,59,57.98,57.98,57,57,57,57.98,57.98,59,60,60.98,64,64,65,67,70,75,75,79,84,85,80,80,77,74,71.02,67.12,66.87,65.12,63.89,62.96,59,59,57.26,57.60,56.84,56,55.37,54.87,54.26,54,52.98,52.98,52.98,52.98,52.98,-11,-11,-13,-16,-16,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-17,-17,-16,-16,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-13,-13,-12,-11,-10,-9.05,-7.75,-6.54,-5.50,-4.53,-3.63,-2.88,-2.26,-1.77,-1.37,-0.87,-0.50,-0.25,-0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.49,2.49,2.49,3.99,5.50,6.98,9.48,9.48,10.49,10.49,10.98,12,12,12,12,12,12.49,12.49,12.98,12.98,12.98,14,14,14,15,15,15,15.24,15.35,15.42,15.51,15.65,15.89,16.22,16.58,17,17.46,17.96,18.48,19.02,19.59,20.14,20.70,21.20,21.65,22.09,22.46,22.79,23.13,23.48,23.88,24.37,24.90,25.48,26.12,26.87,27.61,28.34,29.12,30,30.99,31.62,32,32.33,32.62,32.98,34,34,35,35.98,37,38.38,39.24,39.52,39.83,39.90,40.07,40.34,40.89,42,44.09,45.99,47.50,48.15,49.08,50,50.92,51.77,52.53,53.24,53.79,54.21,54.27,54.28,54.53,55.14,56.08,57.08,58.03,59.02,60.07,61.07,61.99,62.90,63.97,65.22,66.67,68.50,69.37,70.46,71.25,72.08,72.74,73.38,74.14,75.26,76.73,77.23,77.75,77.98,78.14,79.83,80.12,81.82,82.76,83.75,84.71,85.22,85.89,86.60,87.23,87.62,88.25,89.01,90.23,91.87,94.12,94.84,96.51,98.50,100.64,104.37,104.50,105.98,107.49,107.98,108.49,108.49,109.50,110.49,111,113,113,113.99,114.48,113.99,114,114,112.49,109.99,106.98,100,100,97.49,95.49,93.49,90.49,90.49,89.50,88.49,86.98,83.49,83.49,81,79.50,78.49,77.49,77.49,76.49,76.49,76.49,76.49,76.49,76.47,76.48,76.60,77.34,77.40,77.62,78,78.75,79.27,79.95,80.37,81.07,82,82.87,83.76,84.74,86.37,87.58,90.39,90.49,90.98,88.49,82.98,66.49,66.49,61.49,59.50,58.49,57.98,57.98,56.49,56.49,56.49,57.49,57.49,58.49,59.50,60.49,63,63,64.50,66.49,68.99,74.50,74.50,78.49,83,83.99,79.50,79.50,76.49,73.49,70.35,66.62,66.27,64.97,63.62,62.86,59.12,58.84,57.15,56.52,55.62,54.11,54,53.49,53,53,52.49,52.49,52.49,52.49,52.49,-9.68,-9.68,-12,-15,-16,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-17,-17,-16,-16,-16,-16,-16,-17,-17,-16,-16,-16,-16,-15,-15,-14,-13,-12,-10,-9.78,-8.63,-7.54,-6.50,-5.41,-4.43,-3.64,-2.99,-2.28,-1.51,-0.92,-0.50,-0.28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2.98,4,5.98,7.98,7.98,10,10,10.98,12,12,12,12,12,12,12,12.98,12.98,12.98,14,14,14,15,15,15,15.12,15.22,15.35,15.50,15.70,15.98,16.32,16.66,17.09,17.51,18,18.49,19,19.52,20.08,20.62,21.12,21.61,22.03,22.41,22.77,23.12,23.45,23.87,24.35,24.88,25.47,26.12,26.87,27.61,28.33,29.12,30.12,31.10,31.75,32,32.33,32.62,33.14,34,34,35,35.98,37,38.37,39.25,39.61,39.87,39.97,40.07,40.25,40.75,41.85,44,46,47.58,48.25,49.13,50.10,51.07,51.96,52.77,53.57,54.25,54.76,54.96,54.98,55.12,55.62,56.41,57.34,58.32,59.32,60.34,61.27,62.13,63.02,64.02,65.21,66.60,68.12,68.96,69.82,70.64,71.62,72.57,73.39,74.37,75.45,76.60,77.25,77.64,78.11,78.25,79.75,80.20,81.74,82.90,84.01,84.87,85.36,85.89,86.59,86.88,87.51,87.97,88.84,90.25,92.38,94.62,95.36,97.32,99.25,101.14,104.87,105,105.98,107.98,107.98,107.98,107.98,109,110,110,112,112,112.98,112.98,112.98,114,114,112,109,105.98,100,100,97.98,95.98,94,90.98,90.98,90,89,87.98,84,84,82,80,79,77.98,77.98,77,77,77,77,77,76.96,76.95,77.11,77.83,77.75,77.89,78.62,78.77,79.62,79.75,80.71,80.89,81.77,82.77,83.12,84.09,85.87,87.09,89.96,90,90.98,89,82.98,65.98,65.98,60.98,59,57.98,57.98,57.98,55.98,55.98,55.98,57,57,57.98,59,60,62,62,64,65.98,67.98,74,74,77.98,82,82.98,79,79,75.98,73.10,70.02,66.15,65.75,64.76,63.15,62.72,59.23,58.73,57.26,56.12,54.76,53.21,52.86,52.90,52,52,52,52,52,52,52,-6.61,-6.61,-10,-12,-15,-17,-17,-18,-18,-18,-18,-18,-18,-18,-18,-18,-17,-17,-17,-17,-17,-17,-17,-18,-18,-18,-18,-17,-17,-16,-16,-15,-14,-13,-12,-11,-10,-9.68,-8.63,-7.50,-6.50,-5.54,-4.68,-3.80,-2.77,-1.90,-1.18,-0.75,-0.38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.98,2,2.98,5,5,7,7.98,10.98,10.98,10.98,10.98,10.98,12,12,12,12.98,12.98,12.98,14,14,15,15,15,15,14.77,14.98,15.24,15.50,15.78,16.11,16.45,16.79,17.20,17.61,18.04,18.50,19,19.50,20.02,20.57,21.09,21.58,22.01,22.40,22.76,23.12,23.45,23.86,24.35,24.88,25.47,26.12,26.86,27.60,28.32,29.11,30.11,31.10,31.75,32,32.33,32.62,33.32,34,34,35,35.98,37,38.37,39.20,39.49,39.77,39.99,40.12,40.32,40.77,41.86,43.96,45.87,47.45,48.12,49.11,50.08,51.09,52.02,52.90,53.75,54.52,55.12,55.41,55.52,55.64,55.99,56.57,57.33,58.24,59.24,60.25,61.20,62.01,62.86,63.77,64.86,66.08,67.62,68.23,68.96,69.99,71.12,72.45,73.46,74.62,75.83,76.75,77.37,77.75,78.25,79.12,80.64,81.01,81.84,82.87,84.12,85.63,85.62,85.62,85.83,86.37,86.87,87.40,88.38,90.07,92.38,96.61,97.25,98.65,100.22,102.20,104.87,105,105.98,105.98,107,107,107,107,107,107.98,110.98,110.98,110.98,110.98,110.98,112,112,110,107.98,105,100,100,97.98,95.98,94,90.98,90.98,90,89,87.98,85,85,82.98,82,80.98,79,79,79,77.98,77.98,77,77,77.90,76.99,77.09,77.85,77.71,77.62,77.90,78.60,78.71,79.12,79.65,80.20,80.90,81.83,82.12,83.10,84.11,86.07,88.96,89,90.98,89,82,65,65,60,58,57.82,56.21,56.23,56.21,55.99,56,55.98,55.98,57,57.98,59,60.98,60.98,62.98,65,67,72,72,75.98,80.98,84,80.98,80.98,77.98,73.87,70.76,66.15,65.75,64.21,63.25,61.62,59.26,58.63,57.36,56.07,54.63,52.26,52.14,51.10,50.98,50.98,50.98,50.98,50.98,50.98,50.98,-4.03,-4.03,-7.79,-11,-13,-17,-17,-18,-18,-18,-18,-18,-18,-18,-17,-17,-17,-16,-16,-16,-17,-17,-18,-18,-19,-18,-18,-18,-18,-18,-17,-17,-16,-15,-14,-13,-12,-11,-10,-9.87,-8.87,-7.88,-6.86,-5.75,-4.55,-3.50,-2.61,-1.88,-1.17,-0.39,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.98,2.98,2.98,4,5.98,9,10.98,10.98,10.98,10.98,10.98,12,12,12.98,12.98,12.98,14,14,15,15,14,14,14.25,14.65,15.16,15.61,15.96,16.26,16.61,16.95,17.32,17.71,18.11,18.53,19,19.48,20,20.51,21.04,21.54,22,22.41,22.77,23.12,23.46,23.87,24.35,24.88,25.47,26.12,26.86,27.51,28.25,29.07,30.11,31.10,31.75,32,32.22,32.50,33.21,34,34,35,35.98,37,38.47,38.87,39.25,39.75,40.08,40.26,40.51,41.03,42.25,43.87,45.49,46.87,48,48.99,50,51,51.98,52.89,53.83,54.66,55.33,55.74,55.99,56.14,56.36,56.65,57.16,57.92,58.89,59.91,60.85,61.64,62.41,63.26,64.24,65.29,66.34,66.98,67.85,69.22,70.64,72.13,73.32,74.64,76.37,77.38,77.51,77.96,78.36,79.36,80.62,81.25,81.87,82.65,83.62,85.63,85.62,84.62,84.65,85.39,86.57,86.99,87.87,89.40,92.25,97.60,97.62,99.65,100.72,102.75,104.87,105,105,105,105,105.98,105.98,105.98,105.98,107,110,110,109,109,110,110.98,110.98,109,105.98,102.98,99,99,97,95,94,90.98,90.98,90,89,87.98,85.98,85.98,84,82.98,82,80,80,79,77.98,77.98,77.98,77.98,76.96,76.90,76.09,76.87,76.73,76.62,76.83,77.60,77.58,77.85,78.65,78.83,79.83,80.77,80.83,81.87,82.87,84.90,87.90,87.98,89,89,82,64,64,60,57.87,56.76,56.27,56.01,55.99,55.98,55.97,55.98,55.98,55.98,57,57.98,60,60,62,64,65.98,70.98,70.98,75.98,80.98,84,80.98,80.98,77.98,73.87,70.82,66.15,65.87,65.08,63.27,62.25,59.34,59.33,57.37,56.37,55.21,52.34,52.25,51.12,50,50,50,50,50,50,50.98,-3.64,-3.64,-5.54,-8.39,-11,-15,-15,-17,-18,-18,-18,-18,-18,-17,-17,-16,-16,-16,-16,-16,-17,-17,-18,-18,-19,-19,-19,-19,-19,-19,-18,-18,-17,-17,-16,-15,-14,-13,-13,-12,-11,-10,-9.02,-7.80,-6.52,-5.27,-4.15,-3.13,-2.14,-1.14,-0.13,-0.11,-0.03,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.98,4,7,7,7.98,10,10.98,12,12,12.98,12.98,12.98,12.98,12.98,12.98,10.98,7.98,12.98,13.41,14.24,15.21,15.75,16.12,16.40,16.73,17.07,17.40,17.77,18.16,18.58,19,19.48,19.98,20.50,21.03,21.54,22.01,22.42,22.79,23.14,23.49,23.88,24.37,24.88,25.47,26.12,26.85,27.54,28.29,29.12,30,30.82,31.45,31.87,32.22,32.62,33.21,33.96,34,35,35.98,37,37.87,38.52,39.07,39.65,40.14,40.48,40.83,41.45,42.49,43.87,45.32,46.65,47.84,48.90,49.95,50.98,51.97,52.91,53.79,54.62,55.41,55.95,56.34,56.57,56.66,56.72,56.96,57.52,58.41,59.38,60.28,61.08,61.82,62.61,63.50,64.40,65.25,65.95,67,68.61,70.24,71.82,73,74.35,75.75,77.37,77.50,77.96,78.60,79.37,80.62,81.22,81.73,82.33,82.87,82.26,82.34,82.37,83.37,84.38,85.51,86.38,87.27,88.37,90.37,93.62,94.34,96.25,97.24,98.13,100.11,100,100.98,99,97.98,100.98,100.98,102.98,105,105.98,107,107,107,107,107.98,110,110,107.98,107,105,100.98,100.98,100,97.98,97,94,94,92.98,92,90,87,87,85,84,82,79,79,77.98,77,75.98,75,75,75,75.07,74.09,74.11,74.25,75.25,75.37,75.37,76.25,76.32,76.25,77.14,77.14,78.12,78.11,80.11,81.07,82.07,84.98,85,85.98,85,79,62.98,62.98,57.98,56.21,56.27,56.12,56,55.97,55.97,55.97,55.98,55.98,55.98,55.98,55.98,57.98,57.98,60,62.98,65.98,72,72,77,80,79,75.01,75.13,74.23,72.25,69.62,67.33,66.75,65.82,65.62,63.60,62,61.38,59.60,58.37,56.49,55.13,54.71,52.76,50.98,49,47.98,47.98,47.98,47.98,47,-4.13,-4.13,-6.03,-8.65,-11,-15,-15,-16,-18,-18,-18,-18,-17,-17,-16,-15,-15,-15,-15,-15,-16,-17,-17,-18,-19,-19,-19,-19,-19,-19,-19,-19,-18,-18,-17,-16,-16,-15,-14,-14,-13,-12,-11,-9.88,-8.42,-7.01,-5.67,-4.42,-3.17,-1.88,-0.40,-0.25,-0.13,-0.03,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.98,3,6,6,6.98,8.99,10.98,12,12,12.49,12.98,12.98,12.49,12.49,10.99,8.99,6.98,11.49,11.88,13.84,15.26,15.87,16.16,16.48,16.77,17.12,17.47,17.84,18.22,18.61,19.02,19.49,19.99,20.50,21.03,21.57,22.02,22.46,22.84,23.20,23.52,23.95,24.40,24.92,25.38,26.13,26.85,27.57,28.29,29.10,29.90,30.67,31.32,31.78,32.20,32.63,33.16,33.71,34.17,35,35.98,37,37.62,38.33,38.96,39.65,40.25,40.53,41,41.62,42.61,43.87,45.25,46.59,47.76,48.87,49.95,50.99,51.99,52.92,53.82,54.62,55.34,56.04,56.50,56.86,56.83,56.71,56.67,57.14,57.90,58.79,59.63,60.38,61.10,61.87,62.74,63.61,64.33,65.07,66.32,68.12,69.87,71.37,72.50,73.74,75.09,76.36,76.99,77.62,78.37,79.37,80.60,81.10,81.48,81.87,82.12,82.11,82,82.24,82.76,83.87,85.08,85.87,86.75,88.11,89.87,92.62,93.32,94.71,96,97.12,99.38,99.50,98.99,97,95.99,99.99,99.99,102.98,105,105.98,107.49,107.49,108,108,108.99,110.49,110.49,109.48,108,106,101.98,101.98,100.49,98.99,97.49,94.50,94.50,92.98,92,90,87,87,85,84,82,78.49,78.49,77.49,76.49,75.49,74.50,74.50,74.50,74.46,73.52,73.50,73.64,74.24,74.59,74.83,75.23,75.51,75.72,76.34,76.62,77.36,77.60,79,80.39,81.50,83.99,83.99,84.99,83.99,77.49,61.98,61.98,57.49,56.23,56.01,56,55.98,55.97,55.97,55.97,55.98,55.98,55.98,55.98,55.98,57.49,57.49,60,63.49,66.98,73.50,73.50,77.49,79.50,78,74.12,73.72,72.34,70.62,68.86,67.37,66.72,66.10,65.23,64.20,63.25,62.33,61.25,59.77,58.12,56.49,55.71,54.12,52.49,49.99,47.98,47.98,47.49,47.49,46.49,-4.53,-4.53,-6.52,-8.90,-11,-15,-15,-16,-17,-18,-18,-18,-17,-15,-15,-14,-14,-14,-14,-14,-15,-16,-16,-17,-18,-19,-19,-19,-19,-19,-19,-19,-19,-18,-18,-17,-17,-17,-16,-15,-15,-14,-13,-11,-10,-8.67,-7.18,-5.76,-4.29,-2.75,-0.88,-0.63,-0.38,-0.18,-0.12,-0.03,-0.01,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.98,2,5,5,5.98,7.98,10.98,12,12,12,12.98,12.98,12,12,9,7,5.98,10,10.25,13.37,15.02,15.63,16.04,16.36,16.70,17.04,17.45,17.84,18.23,18.62,19.04,19.50,20,20.52,21.07,21.59,22.04,22.48,22.87,23.23,23.60,24,24.48,24.98,25.52,26.15,26.86,27.57,28.27,29.03,29.83,30.59,31.25,31.75,32.17,32.63,33.14,33.71,34.33,35.03,35.98,37,37.73,38.32,38.97,39.64,40.12,40.58,41.04,41.71,42.65,43.88,45.25,46.58,47.77,48.89,49.98,51,52,52.95,53.82,54.60,55.29,55.92,56.53,56.79,56.82,56.64,56.58,56.85,57.46,58.23,58.99,59.67,60.37,61.11,61.98,63,63.84,64.70,65.96,67.75,69.51,71,72.07,73.12,74.26,75.37,76.25,77.01,78.12,79.26,80.60,80.75,81.09,81.62,81.62,81.75,81.71,81.83,82.36,83.35,84.62,85.37,86.34,87.61,89.36,91.63,92.26,93.75,94.77,96.11,98.95,99,97,95,94,99,99,102.98,105,105.98,107.98,107.98,109,109,110,110.98,110.98,110.98,109,107,102.98,102.98,100.98,100,97.98,95,95,92.98,92,90,87,87,85,84,82,77.98,77.98,77,75.98,75,74,74,74,73.98,73,73.01,73.08,73.82,73.82,74.12,74.73,74.76,75.12,75.85,76.11,76.87,77.09,78.01,79.96,81,82.98,82.98,84,82.98,75.98,60.98,60.98,57,56.21,56,55.97,55.97,55.97,55.97,55.97,55.98,55.98,55.98,55.98,55.98,57,57,60,64,67.98,75,75,77.98,79,77,73.21,72.62,70.83,69.20,67.74,66.74,66.75,65.98,64.84,64.50,63.62,63.26,62.23,61.25,59.47,57.50,56.85,55.13,54,50.98,47.98,47.98,47,47,45.98,-5.43,-5.43,-7.25,-9.50,-11,-15,-15,-15,-16,-16,-15,-15,-15,-13,-12,-12,-12,-12,-12,-13,-14,-14,-15,-16,-17,-18,-18,-19,-19,-19,-19,-19,-19,-19,-19,-18,-18,-18,-17,-17,-16,-15,-14,-13,-11,-10,-8.75,-7.18,-5.61,-3.87,-2.13,-1.17,-0.76,-0.42,-0.18,-0.12,-0.02,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.98,2.98,2.98,5,7,10,12,12,12,12,10.98,7.98,7.98,5.98,4,4,7,7.03,10.57,13.23,14.91,15.60,16.01,16.38,16.83,17.29,17.75,18.20,18.62,19.08,19.53,20.03,20.58,21.11,21.62,22.08,22.50,22.88,23.25,23.63,24.07,24.52,25.03,25.60,26.21,26.87,27.53,28.23,28.96,29.73,30.50,31.20,31.74,32.21,32.66,33.16,33.73,34.34,35.08,35.96,37,37.87,38.32,38.98,39.53,40.04,40.52,41.04,41.74,42.70,43.92,45.28,46.62,47.83,48.95,50.01,51.04,52.02,52.96,53.79,54.58,55.25,55.86,56.35,56.72,56.74,56.58,56.49,56.62,57.08,57.71,58.38,59.02,59.65,60.37,61.25,62.35,63.35,64.25,65.71,67.50,69.25,70.62,71.60,72.58,73.62,74.72,75.51,76.37,77.62,79.60,79.51,80,80.37,80.63,81.07,80.87,80.88,81.12,81.75,82.85,84.57,84.87,85.72,86.86,88.26,90.65,91.20,92.12,93.12,94.87,94.99,95,92.98,90.98,92,99,99,102.98,105.98,107.98,110,110,110.98,112,112,112.98,112.98,112,110,107.98,102.98,102.98,102.98,100.98,97.98,95,95,92.98,92,90,85.98,85.98,85,82,80.98,77,77,75.98,75,74,72.98,72.98,72.98,72.98,72,72.90,72.88,72.87,73,73.09,73.87,74.07,74.11,74.87,75.11,75.87,76.01,77.01,78.98,80,82,82,82.98,80.98,74,60,60,57,56.12,55.99,55.97,55.97,55.97,55.97,55.97,55.98,55.98,55.98,55.98,55.98,57,57,60,65.98,70.98,77,77,77.98,75.98,75,71.23,70.62,69.25,67.74,66.33,65.36,64.75,64,63.87,63.57,63.37,63.27,62.25,61.27,61.36,59.50,58.75,57.86,55.98,52.98,49,49,47.98,47,45.98,-6.05,-6.05,-8,-10,-12,-15,-15,-15,-15,-15,-13,-13,-12,-11,-9.89,-10,-10,-10,-11,-11,-12,-13,-14,-15,-16,-17,-18,-18,-19,-19,-19,-19,-19,-19,-19,-19,-18,-18,-18,-18,-17,-16,-16,-14,-13,-11,-10,-8.75,-7,-5.18,-3.52,-2.28,-1.50,-0.90,-0.40,-0.17,-0.05,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,4,5.98,7.98,9,9,9,7.98,7,5,5,4,2.98,2.98,5,5,7.77,10.42,13.14,14.49,15.26,15.75,16.37,17.01,17.61,18.12,18.61,19.08,19.58,20.09,20.62,21.14,21.64,22.11,22.51,22.89,23.27,23.65,24.10,24.58,25.09,25.63,26.23,26.87,27.50,28.15,28.86,29.62,30.42,31.15,31.75,32.24,32.71,33.20,33.74,34.35,35.04,35.86,36.83,37.98,38.13,38.83,39.41,39.96,40.46,41,41.73,42.74,44,45.36,46.66,47.86,48.97,50.03,51.09,52.07,52.97,53.78,54.53,55.21,55.76,56.23,56.60,56.66,56.52,56.39,56.45,56.75,57.26,57.88,58.49,59.03,59.50,60.64,61.75,62.88,64.07,65.62,67.36,68.87,70.12,71.12,72.12,73.23,74.39,75,75.83,77,78,78.75,79.20,79.48,79.63,79.72,79.75,79.87,80.21,80.88,82,83.21,83.97,84.77,85.75,87.08,88.75,89.12,90.82,91.87,92.90,90.98,90.98,89,90,92,100,100,102.98,105.98,107.98,110,110,110.98,112,112.98,112.98,112.98,110.98,109,107,102.98,102.98,102,100.98,97.98,95,95,92.98,92,90,85.98,85.98,84,82,80,77,77,75,74,74,72.98,72.98,72,72,71.76,71.87,72.01,72.07,72.07,72.39,72.75,73.21,73.71,73.88,74.07,74.90,74.98,75.96,77,77.98,80,80,80.98,80,74,59,59,57,56,55.98,55.97,55.97,55.97,55.97,55.97,55.98,55.98,55.98,55.98,55.98,57,57,60.98,67,72.98,77,77,75.98,74,72.98,69.23,68.63,67.58,66.11,64.70,63.32,62.76,62.98,62.01,62.02,62.47,62.37,61.35,60.73,60.39,60.52,60.84,58.96,57,55,50,50,49,47.98,47,-7.40,-7.40,-9.36,-11,-12,-15,-15,-15,-15,-15,-13,-13,-12,-12,-10,-8,-8,-8.93,-9.89,-10,-11,-11,-12,-14,-15,-16,-17,-17,-18,-19,-19,-19,-19,-19,-19,-19,-19,-19,-18,-18,-18,-17,-17,-16,-14,-13,-11,-10,-8.40,-6.50,-4.64,-3.18,-2.14,-1.40,-0.79,-0.30,-0.13,-0.02,-0.01,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.98,2.98,2.98,2.98,2.98,2.98,2,0.98,2,2,2.98,2.98,4,2.98,2.98,4,5.27,7.60,13.07,13.95,14.72,15.66,16.58,17.36,17.99,18.53,19.04,19.58,20.12,20.66,21.21,21.71,22.14,22.53,22.91,23.26,23.63,24.08,24.58,25.10,25.65,26.23,26.84,27.45,28.07,28.75,29.53,30.37,31.13,31.75,32.25,32.74,33.22,33.75,34.36,35.01,35.76,36.37,37.92,37.98,38.72,39.28,39.82,40.33,40.90,41.71,42.76,44.07,45.41,46.70,47.84,48.91,50.01,51.09,52.09,52.98,53.76,54.49,55.12,55.66,56.11,56.45,56.63,56.49,56.32,56.26,56.45,56.90,57.50,58.12,58.50,59.20,60.37,61.38,62.71,64,65.75,67.37,68.75,69.82,70.84,71.86,72.86,73.74,74.38,75.32,76.34,77.25,77.96,78.37,78.50,78.50,78.51,78.61,78.72,79.10,79.83,80.89,81.96,82.83,83.50,84.75,85.22,86.14,86.12,87.11,88,85.98,84,84,87,90.98,94,100,100,102,104,105,105.98,105.98,107,107.98,109,107.98,107.98,107,105.98,105,100,100,99,97.98,97,94,94,92,90,87.98,85,85,82.98,80.98,79,75.98,75.98,74,72.98,72,70.98,70.98,70.98,70.26,71,71.12,71.23,71.26,71.47,71.75,72.11,72.39,72.63,72.71,72.24,73,72.98,74,75,75.98,77.98,77.98,77.98,77.98,74,60,60,57,55.98,55.98,55.98,55.98,55.98,55.98,55.98,55.98,55.98,55.98,55.98,55.98,57.98,57.98,62.98,69,74,72.98,72.98,72,70,69,66.12,66.25,65.34,64.36,63.63,61.25,61.13,60.60,59.96,60.21,60.50,60.37,59.71,59.47,59.37,59.25,59.01,59,59,57.98,55,55,52.98,52,50.98,-7.66,-7.66,-9.63,-11,-12,-15,-15,-15,-15,-15,-14,-14,-13,-12,-10,-8.36,-8.36,-9.28,-9.99,-10,-11,-11,-12,-13,-14,-15,-16,-16,-17,-18,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-18,-18,-17,-16,-15,-14,-13,-11,-9.77,-7.75,-5.75,-4.12,-2.88,-1.93,-1.13,-0.54,-0.13,-0.03,-0.01,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.98,1.98,2.49,2.49,2.49,1.98,1.49,0.49,1.49,1.49,2.49,2.98,3.49,2.98,2.98,3,3.99,5.77,10.96,12.03,13.22,14.73,16.04,17.03,17.79,18.40,18.97,19.51,20.11,20.70,21.25,21.75,22.17,22.60,22.89,23.22,23.58,24,24.52,25.12,25.62,26.16,26.76,27.36,27.97,28.64,29.46,30.32,31.11,31.75,32.26,32.75,33.26,33.84,34.45,35.11,35.83,36.64,37.37,38.04,38.58,39.12,39.63,40.14,40.78,41.63,42.76,44.10,45.45,46.65,47.75,48.84,49.96,51.08,52.08,52.96,53.72,54.39,55,55.53,55.99,56.37,56.62,56.40,56.16,56.08,56.17,56.49,57.33,58,58.48,59.20,60.26,61.37,62.73,64.20,65.97,67.58,68.74,69.76,70.62,71.58,72.45,73.25,74.07,74.87,75.75,76.70,77.38,77.71,77.62,77.48,77.39,77.50,77.65,78.11,78.85,79.96,81,81.98,83,84.09,84.63,85.36,85.59,86.45,86.49,83.99,84.50,84.50,88,91.49,94.99,99.50,99.50,101.49,103,103.99,104.99,104.99,106.49,106.98,108,107.49,107.49,106.49,105.49,104.50,99.50,99.50,98.49,97.49,96.49,93.49,93.49,91.49,89.50,87.49,84.50,84.50,82.49,80.49,78.49,75.49,75.49,74,72.98,72,70.98,70.98,70.50,70.35,70.36,70.51,70.62,70.71,70.87,71.21,71.50,71.74,71.84,71.82,71.96,72.14,72.49,73.49,74.50,74.99,76.98,76.98,77.49,77.49,74,60.49,60.49,57.49,55.98,55.98,55.98,55.98,55.98,55.98,55.98,55.98,55.98,55.98,55.98,55.98,59.48,59.48,64.48,69.99,73.49,71.98,71.98,70.98,69.07,67.87,65.12,64.73,64.10,63.25,63.25,60.12,59.72,59.14,58.50,58.51,58.77,58.87,58.84,58.70,58.61,58.50,58.48,58.37,58.22,57.46,56.45,55.71,54.58,53.50,51.98,-7.93,-7.93,-9.89,-11,-12,-15,-15,-15,-15,-15,-15,-15,-13,-12,-10,-8.63,-8.63,-9.63,-10,-10,-11,-11,-12,-12,-13,-14,-15,-15,-16,-16,-17,-17,-18,-18,-19,-19,-19,-19,-19,-19,-19,-18,-18,-17,-16,-15,-14,-12,-11,-9.04,-6.88,-5.04,-3.65,-2.55,-1.52,-0.75,-0.28,-0.05,-0.02,-0.01,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.98,0.98,2,2,2,0.98,0.98,0,0.98,0.98,2,2.98,2.98,2.98,2.98,2,2.98,4,8.79,9.42,11.10,13.29,15.29,16.72,17.59,18.17,18.73,19.34,20,20.65,21.27,21.79,22.27,22.60,22.87,23.13,23.42,23.87,24.49,25.07,25.59,26.12,26.67,27.25,27.83,28.50,29.33,30.21,31.01,31.67,32.15,32.72,33.27,33.87,34.50,35.14,35.87,36.61,37.33,37.92,38.48,38.98,39.50,40.08,40.65,41.57,42.72,44.04,45.37,46.54,47.62,48.71,49.87,51.01,52.01,52.87,53.60,54.24,54.79,55.32,55.82,56.25,56.61,56.32,55.87,55.83,55.87,56.33,57.62,58,58.40,59.15,60.38,61.62,62.82,64.37,66.34,67.70,69.09,69.85,70.50,71.22,72,72.86,73.50,74.27,75.12,76.08,76.76,76.96,76.70,76.39,76.45,76.62,76.89,77.38,78.15,79.15,80.25,81.32,82.35,83.38,84,84.95,85,85.98,85,82,85,85,89,92,95.98,99,99,100.98,102,102.98,104,104,105.98,105.98,107,107,107,105.98,105,104,99,99,97.98,97,95.98,92.98,92.98,90.98,89,87,84,84,82,80,77.98,75,75,74,72.98,72,70.98,70.75,70.25,70.09,70,70.01,70.11,70.22,70.37,70.62,70.87,71.08,71.11,71.12,71.25,71.50,72.07,72.98,74,74,75.98,75.98,77,77,74,60.98,60.98,57.98,55.98,55.98,55.98,55.98,55.98,55.98,55.98,55.98,55.98,55.98,55.98,55.98,60.98,60.98,65.98,70.98,72.98,70.98,70.98,69.89,67.96,66.84,64.15,63.84,62.84,62.08,62.98,59,58.62,58.12,57.50,57.50,57.71,57.83,57.84,57.84,57.84,57.85,57.85,57.76,57.62,57.25,56.86,56.34,55.57,54.72,52.95,-8.27,-8.27,-10,-12,-13,-15,-15,-16,-16,-16,-15,-15,-15,-12,-10,-9.02,-9.02,-9.99,-10,-10,-12,-12,-12,-12,-12,-14,-14,-14,-15,-15,-15,-15,-16,-18,-18,-19,-19,-19,-19,-19,-19,-18,-18,-18,-17,-16,-15,-14,-12,-10,-8.27,-6.38,-4.77,-3.39,-2.12,-1.03,-0.43,-0.13,-0.04,-0.01,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.98,0.98,0.98,0.98,0.98,0.98,2,2.98,5.98,6.01,8.24,11.42,14.54,16.34,17.28,17.73,18.24,18.97,19.77,20.60,21.34,21.87,22.27,22.61,22.85,23.03,23.28,23.45,24.37,25.02,25.58,26.10,26.62,27.12,27.64,28.29,29.12,30,30.84,31.39,32.01,32.62,33.25,33.87,34.50,35.16,35.87,36.59,37.25,37.86,38.37,38.87,39.39,40,40.71,41.48,42.62,43.91,45.22,46.37,47.46,48.57,49.74,50.88,51.86,52.66,53.34,53.90,54.39,54.85,55.47,56.02,56.48,56,55.50,55.45,55.75,56.36,57.62,58,58.25,59.15,60.23,62.73,63.22,64.71,66,67.82,69,69.87,70.22,70.63,71.37,72.14,72.86,73.60,74.37,75.25,75.96,75.90,75.50,75.10,75.25,75.65,76.12,76.64,77.37,78.51,79.57,80.74,81.64,82.45,83.15,84,84,84,80.98,77.98,85,85,90,92.98,95.98,97.98,97.98,99,100,99,102,102,104,105,105.98,105.98,105.98,104,102.98,102,99,99,97,95.98,95,92,92,90.98,87.98,85.98,82.98,82.98,82,79,77,74,74,72.98,72,70.98,70,70.09,69.85,69.62,69.57,69.50,69.59,69.64,69.85,70.07,70.25,70.35,70.36,70.37,70.45,70.62,71.01,71.71,72,72.98,74,74,75,75.98,74,64,64,59,57,55.98,55.98,55.98,55.98,55.98,55.98,55.98,55.98,55.98,55.98,57.98,65,65,69,70.98,70.98,69,69,67.86,66.12,64.76,62.21,61.99,61.12,60.86,59.87,58.12,57.51,57,56.57,56.39,56.50,56.63,56.75,56.87,57,57.12,57.20,57.12,56.90,56.71,56.57,56.25,56.15,54.75,53.62,-8.50,-8.50,-10,-12,-12,-15,-15,-15,-16,-17,-15,-15,-15,-12,-11,-9.18,-9.18,-9.89,-10,-10,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-15,-17,-19,-18,-19,-19,-19,-19,-19,-19,-18,-18,-17,-17,-16,-15,-14,-12,-10,-8,-6.16,-4.50,-2.79,-1.49,-0.64,-0.24,-0.12,-0.02,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.33,0.49,0.52,0.54,0.59,0.83,1.32,2.35,3.29,4.28,5.88,7.98,13.65,17.25,16.92,16.72,17.54,18.17,19.50,20.59,21.27,21.83,22.27,22.63,22.87,23,22.98,23.51,24.38,25.04,25.60,26.11,26.57,26.99,27.41,28.01,28.83,29.73,30.46,31.15,31.84,32.50,33.15,33.83,34.49,35.15,35.86,36.54,37.22,37.78,38.29,38.77,39.32,39.92,40.65,41.53,42.53,43.76,45,46.14,47.24,48.37,49.51,50.62,51.53,52.28,52.89,53.38,53.75,54.07,54.48,55.82,56.47,54.84,54.63,54.98,55.58,56.37,57.62,57.74,58.11,58.87,60.63,62.64,63.10,64.11,65.57,67.12,68.60,68.97,69.33,69.86,70.57,71.36,72.08,72.75,73.40,74.08,74.50,74.13,73.64,73.37,73.87,74.57,75.20,75.75,76.37,77.37,78.37,79.37,80.10,81.15,81.11,82.98,82.98,80.98,77,75.98,87,87,90.98,92.98,94,97,97,97,95.98,95,100,100,102.98,105,105,105,105,102.98,102,100.98,97.98,97.98,97,95.98,94,92,92,90,87.98,85.98,82,82,80.98,79,77,74,74,72.98,72,70.98,70,69.48,69.25,69.10,69,69,69.01,69.12,69.25,69.37,69.50,69.50,69.50,69.49,69.50,69.62,69.84,70.08,70.87,70.98,72.98,72.98,72.98,74,74,67,67,60.98,57.98,57,55.98,55.98,55.98,55.98,55.98,55.98,55.98,57,59,62,69,69,69.75,69.37,69.10,67.62,66.50,65.50,64.26,62.75,61.15,60.75,59.87,59.12,58.77,57.24,56.52,55.96,55.35,55.35,55.37,55.48,55.62,55.87,56.14,56.48,56.61,56.50,56.24,55.87,55.49,55.15,54.75,54.22,53.36,-7.74,-7.74,-9.64,-11,-12,-15,-15,-15,-16,-16,-15,-15,-13,-12,-11,-10,-10,-10,-10,-10,-11,-11,-12,-12,-13,-15,-15,-15,-15,-13,-13,-13,-13,-15,-15,-19,-19,-19,-19,-19,-19,-19,-18,-18,-18,-18,-17,-16,-15,-13,-11,-9.55,-7.54,-5.54,-3.63,-1.92,-0.90,-0.36,-0.13,-0.03,-0.01,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.04,0.12,0.17,0.22,0.24,0.29,0.46,0.75,1.27,1.76,2.08,1.74,3.33,5.98,10.09,10.39,10.66,13.83,16.84,18.96,20.48,21.21,21.82,22.36,22.76,23.07,22.98,22.98,23.84,24.50,25.10,25.62,26.09,26.47,26.78,27.15,27.73,28.50,29.37,30.16,30.90,31.62,32.34,33.02,33.74,34.41,35.12,35.83,36.52,37.16,37.75,38.24,38.72,39.24,39.85,40.59,41.46,42.46,43.60,44.75,45.87,46.96,48.04,49.15,50.20,51.04,51.75,52.27,52.65,52.87,53,53.21,53.14,52.50,53.49,53.47,54.37,55.13,56.12,56.84,57.36,57.87,58.37,59.38,61.62,62.25,63.45,64.62,65.99,67,67.62,68.11,68.74,69.60,70.50,71.25,71.88,72.38,72.75,72.87,72.37,71.97,71.87,72.62,73.47,74.14,74.74,75.23,76.15,77.02,78,78.50,78.83,78.51,77.98,77.98,75,72.98,75.98,85,85,87.98,90,90,87,87,85,85,87.98,99,99,102,102,102.98,102.98,102.98,102,100,99,95.98,95.98,95,94,92.98,90,90,89,87,85,80.98,80.98,79,77,75,72.98,72.98,72,70.98,70,69,69,68.70,68.57,68.50,68.50,68.50,68.60,68.62,68.73,68.75,68.73,68.62,68.58,68.50,68.50,68.60,68.72,68.10,69,70,70,70,70.98,72,70.98,70.98,67,62.98,59,55.98,55.98,55.98,55.98,55.98,59,59,62,65.98,67.98,69,68.75,68.25,67.75,66.75,65.50,64.58,63.60,62.50,61.35,60.26,59.26,58.62,57.87,56.45,56.37,55.75,55.11,54.62,54.27,54.22,54.33,54.50,54.87,55.37,55.87,56.10,56,55.62,55.09,54.50,53.97,53.70,53.25,52.11,-7.39,-7.39,-9.38,-10,-11,-15,-15,-15,-16,-16,-15,-15,-13,-12,-10,-9.99,-9.99,-10,-10,-10,-11,-11,-12,-12,-14,-15,-15,-15,-15,-14,-13,-13,-13,-14,-15,-18,-18,-18,-19,-19,-19,-19,-19,-19,-18,-18,-18,-17,-16,-15,-13,-10,-8.78,-6.61,-4.38,-2.43,-1.25,-0.49,-0.16,-0.04,-0.01,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.03,0.04,0.08,0.12,0.21,0.37,0.58,0.76,0.97,1.42,2.53,4.48,7,7,7.99,10.99,14.99,20,20,21.49,22,22,23.49,23.49,23.49,23.49,24.07,24.54,25.01,25.49,25.90,26.25,26.53,26.89,27.47,28.28,29.12,29.92,30.67,31.40,32.13,32.87,33.61,34.34,35.04,35.77,36.49,37.13,37.71,38.17,38.63,39.13,39.74,40.45,41.27,42.23,43.34,44.46,45.50,46.53,47.60,48.64,49.62,50.41,51.04,51.50,51.75,51.86,51.86,51.76,51.71,51.74,52.22,52.96,53.85,54.84,55.77,56.60,57.24,57.62,58.36,59.45,61.08,61.76,62.61,63.62,64.73,65.62,66.36,66.96,67.75,68.83,69.86,70.57,71.11,71.38,71.39,71.13,70.70,70.46,70.62,71.47,72.27,73.08,73.50,73.97,74.85,75.72,76.57,76.82,77.12,76.86,75.99,75.99,73.50,72.49,75.98,83.99,83.99,85.99,87.50,87,83.99,83.99,82.99,85.49,88.99,98.49,98.49,101,101,101.98,101.98,101.98,100.50,99.50,98,95.49,95.49,93.99,93,91.98,89.50,89.50,88.49,86.49,84.50,80.49,80.49,78.49,76,74.50,72.49,72.49,71.49,70.49,70,69,68.63,68.35,68.12,68.11,68.08,68.09,68.10,68.11,68.10,68,67.89,67.75,67.62,67.58,67.50,67.50,67.50,67.64,68.12,68.62,69.12,69.62,70.49,71,70.98,70.98,68,64.99,60.99,56.98,56.98,56.98,56.49,56.98,59.99,59.99,63.50,66.98,67.98,68,67.57,66.95,66,64.98,63.87,62.87,61.95,60.98,59.98,59,58.15,57.50,56.75,56.12,55.58,55,54.34,53.75,53.36,53.20,53.25,53.52,54.02,54.72,55.32,55.71,55.63,55.25,54.62,53.77,53.02,52.85,52.37,51.39,-7.13,-7.13,-9.13,-10,-11,-15,-15,-15,-16,-16,-15,-15,-13,-12,-10,-9.89,-9.89,-10,-10,-10,-11,-11,-12,-12,-15,-16,-16,-16,-15,-15,-13,-13,-13,-13,-15,-17,-17,-19,-19,-19,-19,-19,-19,-19,-19,-18,-18,-18,-17,-15,-13,-11,-9.79,-7.50,-5.13,-3,-1.61,-0.66,-0.25,-0.04,-0.01,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.07,0.12,0.23,0.36,0.54,0.89,1.59,2.67,3.54,4,5.98,9,14,20,20,22,22,22,24,24,24,24,24.12,24.46,24.82,25.21,25.60,25.95,26.26,26.66,27.27,28.13,28.96,29.74,30.48,31.22,31.96,32.71,33.46,34.21,34.96,35.71,36.41,37.08,37.62,38.10,38.52,39,39.57,40.24,41,41.87,42.84,43.85,44.83,45.82,46.88,47.92,48.86,49.61,50.15,50.52,50.72,50.76,50.73,50.73,50.79,51,51.50,52.34,53.58,54.59,55.25,56.58,56.83,57.49,57.95,59,60.50,60.99,61.62,62.57,63.50,64.45,65.22,65.98,66.99,68.12,69.25,69.87,70.35,70.35,70,69.48,69.14,69.14,69.50,70.10,70.75,71.47,71.87,72.45,73.37,74.34,75.12,75.37,75.65,76.34,74,74,72,72,75.98,82.98,82.98,84,85,84,80.98,80.98,80.98,85.98,90,97.98,97.98,100,100,100.98,100.98,100.98,99,99,97,95,95,92.98,92,90.98,89,89,87.98,85.98,84,80,80,77.98,75,74,72,72,70.98,70,70,69,68.37,68,67.84,67.75,67.70,67.63,67.62,67.60,67.50,67.37,67.13,66.97,66.75,66.59,66.46,66.37,66.39,66.62,67.13,67.62,68.12,68.62,69.64,70,70.98,70.98,69,67,62.98,57.98,57.98,57.98,57,57.98,60.98,60.98,65,67.98,67.98,67,66.10,65.21,64.25,63.14,62.12,61.24,60.36,59.48,58.58,57.72,57.02,56.35,55.70,55.14,54.83,54.25,53.39,52.74,52.27,52.12,52.23,52.61,53.21,53.96,54.71,55.12,55.25,55.12,54.36,53.50,52.87,52.50,52.08,50.75,-6.39,-6.39,-8.28,-9.89,-11,-13,-13,-15,-15,-15,-13,-13,-12,-11,-10,-10,-10,-10,-10,-10,-11,-11,-12,-13,-15,-16,-16,-17,-16,-16,-15,-15,-13,-13,-13,-15,-15,-18,-18,-19,-19,-20,-19,-19,-19,-18,-18,-18,-17,-16,-14,-12,-10,-8.25,-5.75,-3.51,-2,-0.93,-0.38,-0.12,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.08,0.14,0.26,0.50,0.83,1.28,1.65,1.33,2.98,5,7.98,17.98,17.98,20.98,20.98,22,24,24,24,24,24.07,24.23,24.50,24.86,25.25,25.63,26.02,26.51,27.17,28.02,28.83,29.59,30.32,31.02,31.76,32.51,33.27,34.03,34.79,35.57,36.29,36.96,37.50,37.95,38.36,38.78,39.32,39.91,40.62,41.40,42.26,43.21,44.10,45,45.90,46.84,47.84,48.54,49.03,49.36,49.54,49.63,49.70,49.76,49.97,50.32,50.89,51.57,52.60,53.51,54.50,55.39,56,56.51,57.23,58.12,59.51,59.84,60.51,61.47,62.38,63.34,64.12,65,66.10,67.37,68.62,69,69.33,69.02,68.37,67.58,67.27,67.37,67.77,68.25,68.83,69.38,69.86,70.58,71.49,72.40,73.22,73.50,73.70,73.25,69.08,69.02,69,72.98,75.98,77,77,77,77,77,75.98,75.98,80.98,87.98,92,97,97,97,97.98,97.98,97.98,97.98,97,95.98,95,92,92,90.98,90,89,87,87,85,84,82,77.98,77.98,75.98,74,72.98,70.98,70.98,70,70,69,67.98,68.07,67.73,67.50,67.37,67.34,67.25,67.14,67.07,66.87,66.63,66.37,66.12,65.84,65.58,65.36,65.23,65.21,65.36,65.86,66.33,66.75,67.21,67.87,68.64,69,69,69,67.98,67,62,62,60,60,60.98,62.98,62.98,65.98,67,67,64,63.82,63.07,62.02,61.01,60.12,59.37,58.62,57.87,57.07,56.25,55.57,54.87,54.25,53.77,53.52,53.15,52.21,51.50,51.01,50.87,51,51.39,52.09,52.96,53.65,54.09,54.50,54.58,54,53,52.40,52.24,52.02,50.64,-5.65,-5.65,-7.29,-8.80,-10,-12,-12,-13,-13,-13,-12,-12,-12,-11,-10,-10,-10,-10,-10,-10,-12,-12,-12,-13,-15,-17,-17,-17,-18,-17,-15,-15,-15,-13,-13,-15,-15,-16,-18,-18,-20,-20,-19,-19,-19,-19,-18,-18,-18,-17,-15,-13,-11,-8.88,-6.37,-4,-2.37,-1.24,-0.62,-0.16,-0.03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.04,0.11,0.21,0.36,0.50,0.60,0.75,1.07,2.98,5,12.98,12.98,17.98,20,22,22.98,22.98,24,24,23.75,23.96,24.24,24.58,24.97,25.40,25.87,26.42,27.13,27.97,28.75,29.49,30.20,30.88,31.60,32.34,33.08,33.84,34.60,35.36,36.09,36.73,37.25,37.70,38.08,38.49,38.96,39.50,40.14,40.86,41.62,42.48,43.28,44.11,44.92,45.75,46.53,47.23,47.75,48.11,48.36,48.57,48.73,48.90,49.21,49.62,50.35,51.12,51.87,52.76,53.62,54.48,55.10,55.62,56.22,57,57.82,58.37,59.45,60.39,61.37,62.25,63.01,63.88,65,66.26,67.45,67.86,68,67.48,66.39,65.33,64.87,65.11,65.57,66.01,66.48,67.08,67.70,68.50,69.51,70.37,71,71.32,71.09,70.24,66.12,66.10,69.10,72.89,75,72,72,72,70.98,70.98,75.98,75.98,82,87.98,92,95,95,95,95.98,95.98,95,95,95,94,92,89,89,89,87.98,87,85,85,82.98,82,80,77,77,75,72.98,72,70,70,69,69,69,67.98,67.60,67.36,67.23,67.11,66.98,66.85,66.70,66.50,66.25,65.95,65.62,65.25,64.89,64.60,64.25,64.01,63.87,63.87,64.12,64.39,64.62,64.99,65.50,66.39,66.75,67,67,67,67,65,65,64,64,64,64,64,64,64,64,62,61,60.39,59.52,58.63,57.88,57.33,56.76,56.20,55.50,54.72,53.83,53.12,52.47,51.87,51.59,51.40,50.75,50.11,49.61,49.38,49.52,49.96,50.50,51.12,51.73,52.23,52.61,52.86,52.45,51.86,51.50,51.48,51.58,50.59,-4.88,-4.88,-6.13,-7.64,-9.25,-11,-11,-12,-12,-12,-12,-12,-11,-10,-9.66,-9.52,-9.52,-9.88,-10,-10,-12,-12,-12,-15,-15,-18,-18,-20,-20,-20,-17,-17,-16,-15,-13,-13,-13,-15,-18,-18,-18,-18,-19,-19,-19,-19,-18,-18,-18,-17,-15,-13,-11,-9.36,-6.67,-4.29,-2.55,-1.41,-0.74,-0.25,-0.05,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.07,0.11,0.16,0.24,0.35,0.45,0.98,2,5.98,5.98,9,10.98,14,20,20,22,22.98,23.20,23.71,24.08,24.40,24.83,25.27,25.78,26.38,27.12,27.91,28.70,29.41,30.11,30.76,31.46,32.14,32.87,33.59,34.33,35.07,35.76,36.39,36.90,37.33,37.70,38.07,38.50,39,39.59,40.23,40.92,41.67,42.41,43.17,43.96,44.71,45.42,46.08,46.57,46.90,47.27,47.62,47.90,48.21,48.50,48.99,49.87,50.65,51.48,52.25,53.08,53.75,54.32,54.71,55.26,55.62,56.74,57.48,58.62,59.61,60.50,61.35,62.01,62.87,63.87,65.01,66.01,66.50,66.50,65.85,64.52,63.27,62.75,63,63.51,64.11,64.63,65.27,66,66.89,67.87,68.71,69.25,69.47,69,67.70,66.20,66.14,69.85,71.87,70.88,65,65,64,65.98,70,77,77,80.98,82.98,85,87.98,87.98,90,92,92,92,92,89,87.98,85,80.98,80.98,84,85,84,80.98,80.98,79,77.98,77,74,74,72.98,72,70.98,69,69,69,67.98,67.98,67,67.20,67.12,67,66.84,66.62,66.45,66.23,65.97,65.62,65.25,64.89,64.50,64.12,63.72,63.35,63.07,62.84,62.62,62.62,62.72,62.83,63.10,63.48,63.72,63.37,62.98,64,64,64,62.98,62.98,62,62,62,60.98,60.98,60,60,59,57.98,58.62,58,57.13,56.26,55.65,55.34,54.99,54.57,54,53.25,52.32,51.62,50.77,49.87,49.84,49.75,49.32,48.63,48.10,47.84,48,48.36,48.82,49.25,49.75,50.22,50.62,50.75,50.59,50.25,50.12,50.34,50.63,49.50,-4.89,-4.89,-6.02,-7.39,-8.93,-11,-11,-12,-12,-12,-12,-12,-11,-10,-9.52,-9.38,-9.38,-9.74,-10,-10,-12,-12,-12,-15,-15,-18,-18,-20,-20,-20,-17,-17,-16,-15,-14,-14,-14,-15,-18,-18,-18,-18,-20,-19,-19,-19,-18,-18,-18,-17,-15,-13,-12,-9.62,-6.75,-4.14,-2.53,-1.55,-0.75,-0.18,-0.04,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.03,0.09,0.14,0.27,0.49,1.49,4.48,4.48,7.49,9.48,11.50,17.99,17.99,20.50,21.98,22.96,23.60,24.01,24.36,24.76,25.24,25.75,26.37,27.12,27.90,28.66,29.38,30.04,30.70,31.34,31.99,32.64,33.33,34,34.70,35.36,35.96,36.46,36.85,37.20,37.53,37.95,38.40,38.96,39.53,40.17,40.86,41.54,42.26,43,43.74,44.46,45.11,45.64,46.09,46.45,46.88,47.28,47.71,48.12,48.84,49.59,50.37,51.14,51.90,52.62,53.24,53.71,54.12,54.51,55.11,55.99,57,57.97,58.97,59.87,60.62,61.25,61.98,62.88,63.89,64.83,65.25,65.24,64.38,62.90,61.52,60.89,61.22,61.86,62.70,63.37,64.11,64.87,65.82,66.71,67.50,68,68.20,67.60,66.57,66.12,66.22,69.25,70.33,69.87,64.02,63.99,63,65.49,68.99,77,77,79.48,80.48,82.99,85.99,85.99,88.99,91,91.49,90.50,90.50,87.49,85.48,82.99,78.99,78.99,82,83.50,83,80,79.90,78.48,77.08,75.87,73.61,73.37,72.46,71.47,70.40,69,69,68.49,67.98,67.49,67,67,67,66.85,66.61,66.36,66.10,65.83,65.50,65.12,64.74,64.36,63.88,63.48,63,62.62,62.35,62.12,62.02,61.88,61.84,61.85,61.95,62.10,62.23,62.34,62.49,63,63,63,61.98,61.98,61,61,61,59.99,59.99,58.99,58.99,58,56.98,56.72,56.12,55.25,54.50,53.99,53.73,53.50,53.12,52.62,52.02,51.21,50.49,49.60,48.96,48.52,48.45,48.11,47.48,46.77,46.38,46.61,46.88,47.27,47.64,47.98,48.50,48.86,48.97,48.83,48.58,48.59,48.90,49.22,48,-4.89,-4.89,-5.91,-7.14,-8.64,-11,-11,-12,-12,-12,-12,-12,-11,-10,-9.38,-9.16,-9.16,-9.52,-10,-10,-12,-12,-12,-15,-15,-18,-18,-20,-20,-20,-17,-17,-16,-15,-15,-15,-15,-16,-18,-18,-18,-18,-20,-20,-19,-19,-18,-18,-18,-17,-15,-14,-12,-9.63,-6.89,-3.26,-2.63,-1.63,-0.75,-0.25,-0.04,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.07,0.11,0,0.98,2.98,2.98,5.98,7.98,9,15.98,15.98,19,20.98,22.98,23.82,24.08,24.37,24.77,25.24,25.75,26.37,27.12,27.90,28.66,29.37,30.02,30.63,31.24,31.84,32.42,33.03,33.64,34.26,34.87,35.41,35.87,36.25,36.60,36.92,37.32,37.75,38.25,38.82,39.40,40.02,40.67,41.38,42.12,42.87,43.61,44.29,44.92,45.46,45.96,46.39,46.89,47.37,48,48.65,49.39,50.15,50.89,51.62,52.25,52.76,53.25,53.62,54.08,54.59,55.62,56.50,57.48,58.37,59.32,60,60.62,61.25,62.09,63,63.82,64.25,64.11,62.99,61.37,59.95,59.39,59.75,60.63,61.62,62.50,63.32,64.12,65,65.87,66.71,67.25,67.27,67.13,65.37,65.84,66.25,68.74,68.75,68.83,63.10,62.89,62,65,67.98,77,77,77.98,77.98,80.98,84,84,87.98,90,90.98,89,89,85.98,82.98,80.98,77,77,80,82,81.95,79.09,78.87,77.83,76.12,74.83,73.13,72.77,71.84,70.83,69.87,69.02,68.95,67.98,67.98,67,67,67,67,66.74,66.36,66.12,65.84,65.50,65.12,64.75,64.37,63.89,63.46,62.97,62.49,62.07,61.75,61.62,61.40,61.15,60.97,60.82,60.75,60.76,60.87,61.09,61.74,62,62,62,60.98,60.98,60,60,60,59,59,57.98,57.98,56.74,55.86,55.21,54.62,54.01,53.48,53,52.62,52.27,51.97,51.40,50.87,50.75,49.74,48.83,48.12,47.83,47.74,47.13,46.48,45.75,45.32,45.32,45.57,45.90,46.25,46.61,46.96,47.24,47.32,47.10,46.89,47,47.32,47.62,46.50,-4.75,-4.75,-5.89,-7.25,-8.78,-11,-11,-12,-13,-13,-12,-12,-12,-10,-9.43,-9,-9,-9.25,-9.52,-9.90,-11,-11,-12,-13,-15,-17,-17,-20,-20,-18,-17,-17,-16,-16,-16,-15,-15,-17,-18,-18,-18,-18,-18,-20,-18,-18,-18,-18,-17,-16,-15,-14,-12,-9.50,-6.99,-3.25,-2.55,-1.53,-0.67,-0.25,-0.03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,4,5,5.98,12,12,17,20,22,24,24.14,24.42,24.84,25.25,25.75,26.36,27.11,27.90,28.67,29.38,30.02,30.62,31.15,31.70,32.23,32.75,33.26,33.82,34.34,34.82,35.23,35.59,35.90,36.25,36.62,37.07,37.53,38.07,38.62,39.21,39.86,40.57,41.33,42.12,42.90,43.66,44.37,45.01,45.59,46.15,46.64,47.25,47.88,48.60,49.26,49.99,50.62,51.25,51.87,52.37,52.83,53.25,53.64,54.52,55.37,56.25,57,57.82,58.62,59.37,59.88,60.50,61.25,62.21,63.07,63.37,62.75,61.45,59.27,57.96,57.72,58.35,59.60,60.87,61.88,62.76,63.57,64.35,65.25,66.12,66.75,67.01,65.37,63.34,66.63,66.65,67.65,67.72,65.75,61.12,61.08,61,64,67.98,75,75,75,75,77.98,82.98,82.98,87,89,89,87,87,82,77.98,75.98,72.98,72.98,75,76.90,77.86,77.12,76.82,75.95,74.90,73.75,72.24,71.98,71.20,70.21,69.15,68.12,68.10,67.88,67,67,67,67,67,65.98,66.13,65.98,65.62,65.25,64.85,64.49,64.10,63.61,63.11,62.59,62.07,61.62,61.37,61.12,60.82,60.40,60.02,59.75,59.52,59.46,59.45,59.52,59.74,60,60,59.75,59.15,58.64,58.33,58,57.71,57.38,57.02,57,55.88,55.01,54.23,53.60,53.10,52.64,52.25,51.87,51.50,51.23,50.88,50.60,49.21,49.14,48.72,47.98,47.32,46.96,46.86,46.37,45.60,44.75,44.12,43.95,44.09,44.37,44.75,45,45.37,45.62,45.50,45.23,44.96,45.01,45.49,45.64,44.57,-4.64,-4.64,-5.89,-7.41,-9.38,-12,-12,-13,-15,-15,-13,-13,-12,-12,-10,-9.25,-9.25,-9.25,-9.24,-9.29,-10,-10,-11,-12,-15,-17,-17,-17,-17,-17,-16,-16,-17,-17,-17,-17,-17,-17,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-17,-16,-15,-14,-11,-9.13,-6.40,-2.90,-2.25,-1.27,-0.54,-0.15,-0.03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.98,0.98,2,2.98,4,9,9,14,20,22.98,24,24,24.74,24.82,25.25,25.75,26.35,27.11,27.90,28.70,29.40,30.03,30.59,31.10,31.57,32.01,32.46,32.88,33.33,33.75,34.15,34.52,34.87,35.20,35.52,35.90,36.34,36.78,37.29,37.85,38.39,39.07,39.82,40.62,41.49,42.35,43.17,43.97,44.67,45.35,46,46.62,47.25,47.86,48.48,49.11,49.72,50.27,50.87,51.46,51.96,52.38,52.87,53.50,54.37,55.39,55.88,56.49,57.02,57.73,58.40,59.12,59.74,60.34,60.88,61.87,62,60.12,58.09,56.22,55.57,55.99,57.32,58.96,60.50,61.64,62.50,63.12,63.62,64.35,65.82,66.01,66.33,63.61,62.37,65.61,65.62,65.63,64.72,61.75,60.20,60.12,62.02,65.98,69,72,72,72,72.98,75,82.98,82.98,85.98,87.98,87.98,84,84,79,74,72,70,70,70.07,72.12,74.84,74.76,74.75,73.87,73.73,72.70,71.98,71.72,70.71,69.74,68.75,68,67.82,67.12,66.99,67,67,67,65.98,65.98,65.98,65.98,65.64,64.87,64.47,64.12,63.75,63.32,62.86,62.25,61.70,61.25,60.98,60.59,60.12,59.62,59.09,58.62,58.27,58.07,57.88,57.83,57.75,57.98,57.74,57.25,57,56.65,56.37,56.09,55.77,55.50,55.21,54.75,53.90,53.10,52.37,51.84,51.49,51.22,50.95,50.62,50.35,50,49.87,49.83,48.22,48,47.62,47,46.25,45.82,45.62,45.36,44.87,43.71,42.75,42.37,42.37,42.50,42.70,42.96,43.14,43.25,43.11,42.82,42.52,42.64,42.83,42.62,41.62,-5.25,-5.25,-7.16,-9.24,-11,-15,-15,-17,-17,-17,-17,-17,-16,-15,-15,-12,-12,-11,-10,-9.38,-9.25,-9.25,-9.79,-11,-12,-15,-15,-15,-15,-15,-17,-17,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-17,-15,-13,-12,-10,-7.90,-5.25,-2.14,-1.64,-1,-0.28,-0.13,-0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.98,2,4,4,7,12.98,19,24,24,24,24.82,25.21,25.73,26.35,27.10,27.91,28.73,29.45,30.04,30.58,31.01,31.42,31.83,32.17,32.50,32.85,33.16,33.50,33.82,34.12,34.45,34.78,35.16,35.59,36.03,36.52,37.07,37.62,38.32,39.12,40,40.97,41.90,42.82,43.63,44.40,45.16,45.87,46.62,47.21,47.74,48.25,48.76,49.33,49.87,50.47,51.01,51.52,52,52.61,53.33,54.15,54.87,55.50,55.90,56.36,56.37,57.75,58.50,58.99,59.46,59.38,58.62,57.86,54.45,52.23,51.21,53.90,54.64,57.07,59.07,60.62,61.75,62.50,62.87,62.90,63.07,63.50,63.62,62.38,60.38,59.38,62.59,63.35,62.15,58.26,54.25,61.75,61.85,64.89,67,65.98,67,67,69,72,75,75.98,75.98,75.98,79,80,77.98,77.98,74,69,67.98,67,67.02,66.10,69.13,71.76,72.25,72.25,71.25,71.26,71.27,71.24,70.76,70.12,69.12,68.14,67.25,66.87,66.12,66.87,66.95,67,67,65.98,65,65,65,65,64.07,64.07,63.83,63.13,63.11,62.71,62.08,61.37,60.97,60.61,60,59.37,58.74,58.09,57.50,57.01,56.70,56.39,56.15,55.95,55,54.63,55.14,55,54.77,54.58,54.32,54.09,53.75,53.37,52.62,51.98,51.33,50.62,50.12,49.87,49.75,49.62,49.40,49.21,48.88,48.10,48.13,47.24,47.25,46.87,46.25,45.36,44.36,44.36,44.48,43.77,42.71,41.47,40.82,40.62,40.57,40.57,40.71,40.87,40.88,40.75,40.47,40.20,40.25,40.36,40.10,37.75,-5.62,-5.62,-7.64,-9.63,-11,-16,-16,-17,-18,-18,-17,-17,-16,-16,-15,-13,-13,-12,-11,-10,-9.63,-9.63,-9.90,-11,-12,-14,-14,-14,-15,-15,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-17,-16,-14,-12,-10,-9.02,-6.79,-4.41,-2.18,-1.30,-0.67,-0.25,-0.04,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.98,1.49,3.49,3.49,6,10.99,16.50,23,23,24,24.50,25.03,25.75,26.34,27.03,27.92,28.76,29.49,30.07,30.50,30.87,31.23,31.57,31.86,32.11,32.35,32.60,32.85,33.11,33.38,33.70,34.02,34.40,34.83,35.26,35.75,36.28,36.86,37.60,38.47,39.46,40.51,41.57,42.51,43.37,44.14,44.96,45.64,46.40,46.89,47.37,47.76,48.24,48.74,49.32,50,50.62,51.12,51.62,52.24,53,53.89,54.62,55.11,55.38,55.75,56.27,57.74,58.10,58.38,58.50,58.99,55.99,55.99,52.49,51,50.49,54.39,54.75,57.50,59.63,61.13,62.14,62.82,62.82,62.35,61.70,61.83,61.76,61.02,59.71,58.39,62.08,62.11,60.62,56.71,52.75,60.25,60.64,64.37,66,64.48,65.50,65.50,68.49,71.49,73.36,73.37,73.12,73.08,74.87,76.34,76.50,75.87,72.58,68.83,67.12,66.50,66.37,64.62,67.76,70.75,70.96,70.84,70.65,70.51,70.50,70.47,70.12,69.47,68.50,67.57,66.75,66.36,66.15,66.50,66.88,66.99,67,65.98,65,64.50,64.50,64.50,64,63.49,63.49,62.98,62.99,62.62,61.98,61.13,60.62,60.12,59.37,58.62,57.85,57.08,56.37,55.86,55.39,55.08,54.75,54.48,54.10,53.75,53.51,53.46,53.25,53.09,52.86,52.62,52.26,51.84,51.21,50.51,49.83,49.15,48.74,48.51,48.48,48.39,48.35,48.22,48,47.87,47.62,47.36,46.89,46.50,45.87,45.01,44.36,44.01,43.77,43.10,41.86,40.57,39.47,39.13,38.75,38.70,38.60,38.82,38.87,38.75,38.50,38.22,38.33,38.33,38,36.90,-5.91,-5.91,-8.13,-10,-12,-17,-17,-17,-18,-18,-17,-17,-17,-17,-16,-15,-15,-13,-12,-11,-10,-10,-10,-11,-12,-13,-13,-13,-15,-16,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-17,-16,-15,-13,-11,-9.77,-7.87,-5.76,-3.75,-2.15,-1.12,-0.50,-0.15,-0.03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.11,0.37,0.84,1.65,2.54,3.07,5,9,14,22,22,24,24,25,25.98,25.98,27,27.97,28.86,29.53,30.04,30.37,30.64,30.91,31.20,31.41,31.62,31.79,31.99,32.20,32.40,32.64,32.95,33.27,33.64,34.04,34.49,34.96,35.49,36.09,36.87,37.82,38.90,40.08,41.22,42.23,43.07,43.79,44.60,45.23,46,46.49,46.83,47.14,47.57,48.01,48.62,49.33,50.12,50.59,51.09,51.75,52.65,53.62,54.58,54.75,55,55.27,56.20,57.82,57.96,57.98,57.98,57.98,54,54,50.98,50,50,55,55,58.87,60.76,62.15,62.87,63.13,63.62,61.83,60.39,60.49,60.46,60.45,58.62,57.51,61.48,61.50,59.51,55.11,51.25,58.75,59.33,63.52,64.50,63.52,63.76,64.63,67.27,70.10,70.98,70.37,70.11,69.96,71.51,73,73.98,74.01,71.12,68.09,66.50,66.02,65.83,63.13,66.75,69.73,69.71,69.90,70,70.02,70,69.87,69.61,68.87,68.01,67.13,66.25,66.11,66.10,66.13,66.87,66.99,67,65.98,65,64,64,64,64,62.98,62.98,62.98,62.75,62.39,61.75,60.83,60.10,59.49,58.63,57.76,56.88,56.07,55.33,54.72,54.23,53.85,53.51,53.33,53.26,52.73,52.37,52.12,51.90,51.74,51.50,51.25,50.87,50.46,49.97,49.14,48.48,47.87,47.49,47.33,47.27,47.33,47.35,47.33,47.33,47.38,47.25,47.07,46.75,46.25,45.74,45.12,44.36,44,43.62,42.83,41.37,39.88,38.52,37.96,37.47,37.10,36.90,36.95,37.01,37,36.76,36.62,36.62,36.70,36.45,36.12,-6.50,-6.50,-9.25,-12,-13,-17,-17,-18,-18,-18,-18,-18,-18,-17,-17,-16,-16,-15,-15,-13,-12,-12,-12,-12,-13,-13,-13,-15,-16,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-17,-17,-16,-15,-14,-12,-10,-8.30,-6.51,-4.64,-3,-1.66,-0.79,-0.26,-0.12,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.04,0.17,0.45,0.85,1.48,2.13,3.04,4.35,7,10,20,20,22.98,24,25,25.98,25.98,27,27.98,28.92,29.60,30,30.15,30.33,30.50,30.66,30.86,31.02,31.21,31.37,31.52,31.72,31.91,32.20,32.50,32.86,33.25,33.66,34.13,34.63,35.28,36.11,37.12,38.28,39.54,40.78,41.87,42.66,43.32,44.01,44.58,45.23,45.71,46.01,46.37,46.72,47.12,47.71,48.39,49.12,49.75,50.32,51.08,52.07,53.50,53.71,54.25,54.72,55.21,55.76,55.87,55.98,55.98,55.98,55,50,50,47.98,47.98,50,55,55,58.87,62.76,63.75,63.71,63.63,62.72,61.51,59.50,58.75,58.39,58.38,56.90,56.59,59.38,59.45,57.47,53.07,49.38,56.37,57.73,61.13,62.15,61.89,62.47,63.75,65.47,67.37,67.52,67.12,66.76,67.01,68.20,69.58,70.27,69.70,67.49,65.83,65.12,65.24,65.40,62.25,63.84,66.70,68.63,69.01,69.25,69.61,69.59,69.12,68.59,68.12,67.60,66.62,65.95,65.64,65.74,66.15,66.85,67.09,67,65.98,65,64,60.98,60.98,60.98,62,62,62,62,61.99,61.39,60.39,59.62,58.99,57.84,56.83,55.86,54.97,54.15,53.50,53,52.60,52.25,52.09,52.12,51.50,51.14,50.87,50.62,50.36,50.08,49.75,49.39,48.96,48.50,47.64,47,46.50,46.20,46.10,46.12,46.24,46.36,46.47,46.58,46.75,46.75,46.62,46.34,45.99,45.49,44.97,44.37,43.95,43.62,42.85,41.37,38.86,37.87,36.96,36.12,35.46,35.02,34.89,35.10,35.11,34.99,34.76,34.75,34.59,34.26,33.36,-7.16,-7.16,-10,-12,-15,-18,-18,-18,-18,-18,-18,-18,-18,-18,-17,-17,-17,-17,-16,-16,-15,-15,-15,-15,-16,-17,-17,-17,-18,-18,-18,-18,-18,-20,-18,-18,-18,-18,-18,-18,-18,-18,-17,-17,-16,-15,-14,-13,-12,-10,-8.29,-6.62,-5,-3.49,-2,-1.13,-0.50,-0.17,-0.04,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.10,0.24,0.49,0.84,1.28,1.78,2.38,3.25,4.62,7,15,15,20,22,24,25.98,25.98,27,27.98,29,29.72,29.70,29.82,29.92,29.99,30.09,30.22,30.38,30.57,30.73,30.87,31,31.20,31.41,31.72,32.04,32.41,32.84,33.26,33.78,34.46,35.29,36.35,37.58,38.87,40.15,41.25,42.02,42.62,43.25,43.74,44.27,44.72,45.08,45.37,45.73,46.12,46.62,47.13,48.07,48.61,49.45,50.23,51.24,52.25,52.99,53.26,54.72,54.75,54.84,52.87,52.98,52.98,52,50,47.98,47.98,47,47.98,50,55,55,58.87,61.82,63.75,63.71,63.62,62.51,60.48,58.40,56.50,55.35,55.33,54.12,54.12,56.36,56.37,53.40,50.37,47.84,54.97,57.11,59.77,60.83,60,60.62,61.50,62.96,63.86,64.01,63.72,63.25,63.37,64,66.26,64.37,64.39,63.15,62.32,62.83,63.95,64.12,60.37,59.27,62.32,67.62,67.60,68.61,68.59,68.58,67.52,67.52,66.62,66.61,65.60,64.62,64.65,64.73,65.75,66.84,67.87,67.98,67,65.98,65,59,59,57.98,59,60.98,60.98,60.98,62,60.62,59.39,58.25,58.12,56.75,55.64,54.62,53.72,52.88,52.25,51.71,51.25,50.87,50.62,50.46,50.12,49.76,49.48,49.13,48.83,48.45,48,47.51,47.02,46.38,45.77,45.25,44.97,44.75,44.75,44.87,45.09,45.27,45.50,45.73,45.96,46,46,45.75,45.37,44.95,44.12,43.50,43.46,43.64,42.70,41.64,38.50,37.23,36,34.77,33.50,32.58,32.07,32,31.87,31.83,31.87,32,31.15,31.37,30.62,-8.38,-8.38,-11,-13,-17,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-18,-18,-18,-18,-18,-18,-17,-16,-16,-15,-13,-12,-11,-9.88,-8.13,-6.26,-4.66,-3.50,-2.25,-1.24,-0.63,-0.27,-0.13,-0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.12,0.27,0.50,0.78,1.09,1.37,1.66,2.04,1.96,2.48,5,5,9,14,17.98,22.98,22.98,22.98,24,25.98,29,28.82,29.46,29.35,29.39,29.50,29.62,29.77,29.96,30.09,30.20,30.28,30.42,30.62,30.88,31.21,31.58,31.97,32.39,32.91,33.59,34.45,35.50,36.72,38,39.25,40.35,41.12,41.75,42.36,42.79,43.25,43.65,44,44.36,44.65,45.08,45.50,46,45.97,47.62,48.58,49.40,50.34,51.38,52.62,52.63,52.25,50.22,49.13,47.10,47,45.98,45,44,45,45,45.98,47,47.98,52,52,55.10,58.12,60.74,61.25,61.25,60.32,58.50,56.40,52.62,52.59,49.71,49.71,52.25,47.65,47.62,44.62,46.88,50.77,54.62,56.25,57.36,57.65,56.51,57.87,58.90,59.86,60.51,60.71,60.47,59.95,59.72,59.89,59.23,57.84,57.75,58.70,60.20,60.59,58.32,58.12,54.87,55.59,59.33,64.62,65.37,66.37,66.37,65.39,65.39,65.34,64.39,63.87,62.12,57.36,57.33,61.25,64.75,66.12,68.87,69,70,69,67,62,62,59,55.98,54,57,57,57.98,59,57.21,55.37,55.50,55.49,54.46,53.32,52.25,51.48,50.86,50.27,49.84,49.39,48.96,48.76,48.62,48.35,48,47.63,47.25,46.75,46.22,45.64,45.13,44.57,43.25,43.62,43.40,43.35,43.37,43.61,43.87,44.22,44.50,44.83,45.09,45.23,45.23,45.02,44.64,44.07,43.24,42.20,41.75,41.34,41.70,40.74,37.20,36.62,35.25,33.62,31.84,28.85,28.87,28.88,28.87,27.87,26.75,26.62,25.49,24.25,24.97,-8.25,-8.25,-11,-13,-17,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-18,-18,-18,-18,-18,-17,-16,-16,-14,-13,-12,-10,-9.51,-8,-6.18,-4.50,-3.12,-2.13,-1.24,-0.62,-0.29,-0.14,-0.04,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.03,0.12,0.28,0.50,0.72,0.89,1.03,1.13,1.20,1.47,2.32,3.63,3.99,7.49,12,15.99,21.49,21.49,20.99,22,23.48,27,27,27.78,28.38,28.73,28.95,29.14,29.28,29.40,29.49,29.50,29.53,29.62,29.76,30,30.32,30.70,31.08,31.50,32.01,32.67,33.51,34.54,35.75,37,38.21,39.25,40.11,40.78,41.39,41.87,42.26,42.65,43,43.35,43.65,44.08,44.57,45.11,45.88,46.84,47.84,48.73,49.61,50.63,51.62,51.75,51.24,49.62,47.85,45.58,45.50,44.48,43.99,43,44.50,44.50,45.49,46.49,47.49,51.49,51.49,54.07,56.83,59.25,59.72,59.57,58.73,57.26,55.37,52.14,50.76,48.72,49.22,51.25,46.21,45,43.89,46.87,50.48,54.37,55.50,55.85,55.64,55.45,55.51,56.37,57.12,57.63,57.82,57.60,57.12,56.77,56.39,56.09,55.40,55.51,56.75,58.24,58.87,56.50,54.72,54.12,56.33,59.75,63.62,64.37,65.08,64.98,64.51,64.15,63.71,63.11,62.08,59.60,56.36,56.33,60.21,64.25,66.64,69.87,69.99,70.49,69,66,62,62,59,55.49,53,55.50,55.50,56.98,57.49,56.49,54.50,54.50,54.50,53.49,51.70,50.51,49.87,49.40,49.02,48.61,48.23,47.87,47.60,47.33,47,46.63,46.25,45.83,45.27,44.62,44,43.50,43.01,42.57,42.21,42.02,42,42.12,42.36,42.72,43.12,43.57,43.96,44.25,44.48,44.50,44.38,44,43.37,42.39,41.45,40.62,40.37,40.63,39.73,37.12,36.95,34.87,32.75,31.01,28.50,27.73,27.37,26.87,26.22,25.40,24.74,24,23,23.50,-8.14,-8.14,-10,-13,-17,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-18,-18,-18,-18,-17,-16,-16,-14,-13,-12,-10,-9.26,-7.88,-6.38,-4.87,-3.42,-2.25,-1.38,-0.75,-0.36,-0.13,-0.04,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.12,0.25,0.45,0.62,0.74,0.78,0.78,0.83,1.07,1.66,2.39,3.07,5.98,10,14,20,20,19,20,20.98,25,25,25.98,26.96,27.72,28.60,28.73,28.87,28.98,28.90,28.83,28.75,28.73,28.82,29.03,29.37,29.74,30.12,30.57,31.09,31.74,32.54,33.54,34.72,35.92,37.12,38.16,39.07,39.83,40.47,40.99,41.40,41.82,42.12,42.45,42.75,43.15,43.72,44.46,45.37,46.36,47.22,47.98,48.87,49.96,50.76,51.08,50.75,48.82,46.87,44.02,44,42.98,42.98,42,44,44,45,45.98,47,50.98,50.98,52.89,55.86,57.75,58.64,58.57,57.47,56.38,54.36,51.63,50.25,47.75,48.72,50.24,44.72,43.62,43.15,46.12,49.75,54.12,54.71,54.74,54.52,54.20,54.10,54.37,54.84,55.15,55.25,55.09,54.75,54.37,54,53.82,53.87,54.37,55.27,56.50,57.25,54.60,52.97,53.26,56.37,59.50,62.62,63.37,64.59,63.77,63.58,63.09,62.52,61.59,60.57,57.59,55.36,55.33,59.20,63.75,66.84,70.86,70.98,70.98,69,65,62,62,59,55,52,54,54,55.98,55.98,55.98,54,54,54,52.98,51,49.62,48.97,48.37,47.95,47.50,47.12,46.75,46.40,46.11,45.75,45.37,44.96,44.48,43.95,43.37,42.82,42.38,42.10,41.85,41.25,40.87,40.75,40.84,41.09,41.50,42.11,42.63,43.12,43.50,43.76,43.88,43.77,43.37,42.62,41.75,40.87,40.11,39.50,39.57,38.62,37.15,36.96,35,32,30.98,27.98,27.98,25.98,25.98,25.98,24,24,22.98,22,22,-7.66,-7.75,-10,-13,-15,-17,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-19,-18,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-19,-19,-18,-18,-18,-17,-16,-15,-14,-13,-12,-10,-9.13,-7.74,-6.37,-5,-3.64,-2.50,-1.51,-0.87,-0.38,-0.13,-0.03,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.09,0.20,0.34,0.48,0.54,0.59,0.58,0.59,0.75,1.11,1.62,2.41,2.98,7,10,15,15,14,14,15.98,19,19,20,22,25,27.98,27.98,28.96,28.58,28.39,28.15,27.87,27.71,27.71,27.89,28.25,28.67,29.12,29.59,30.11,30.75,31.54,32.52,33.65,34.86,36.02,37.11,38.07,38.90,39.62,40.23,40.72,41.09,41.37,41.62,41.89,42.27,42.87,43.64,44.75,46.15,46.50,47.10,47.88,49,50.70,50.73,49.77,47.12,44.88,42,42,40.98,40.98,42,42.98,42.98,44,45,47,50,50,51,53.08,54.76,55.62,55.50,55,54.15,53.36,51.39,50.25,47.74,47.74,48.25,43.65,42.12,41.37,45.01,48.75,52.11,53.71,53.77,53.37,52.99,52.61,52.58,52.76,53,53,52.77,52.48,52.13,51.99,52,52.27,52.82,53.59,54.50,53.62,51.76,51.60,53.37,56.12,59.21,61.62,62.24,62.59,62.33,61.77,61.58,61.58,59.73,57.59,54.37,53.33,53.26,58.25,62.75,66.12,69.87,70,70,67,62,59,59,57.98,55,50.98,50.98,50.98,54,54,55,54,54,52.98,52.98,50.12,48.73,47.87,47.33,46.86,46.45,46.01,45.64,45.32,44.96,44.57,44.12,43.70,43.22,42.64,42.12,41.62,41.21,41.08,40.82,40.33,39.88,39.76,39.87,40.12,40.62,41.25,41.85,42.37,42.85,43.14,43.25,43.10,42.71,42.02,41.23,40.37,39.60,39.01,38.52,37.98,37.36,36.74,35.02,32.98,30.98,29,29,27,25,24,22,22,20.98,20.98,20,-6.75,-6.89,-9.38,-11,-14,-17,-17,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-19,-19,-19,-19,-19,-19,-20,-20,-19,-19,-19,-19,-19,-19,-19,-18,-18,-17,-16,-15,-14,-13,-11,-10,-9,-7.52,-6.15,-4.88,-3.67,-2.61,-1.63,-0.91,-0.49,-0.24,-0.11,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.03,0.12,0.22,0.32,0.37,0.40,0.41,0.46,0.54,0.73,1,1.32,2,4,7,10,10,9,9,10.98,14,14,15,15.98,19,25.98,25.98,27.98,27.77,27.38,26.99,26.58,26.33,26.29,26.53,27.01,27.57,28.10,28.60,29.13,29.76,30.57,31.51,32.63,33.83,35,36.12,37.14,38.08,38.90,39.61,40.13,40.50,40.72,40.87,41.11,41.37,41.88,42.71,43.83,45.24,45.46,45.97,46.70,47.71,48.75,48.77,47.82,44.99,42.90,40.98,40.98,40,40,40.98,42.98,42.98,44,45,45.98,47.98,47.98,50,50.89,52.75,52.63,52.57,52.46,51.76,51.36,49.76,49.26,46.71,46.27,47.25,40.72,40.74,40.48,43.71,47.25,50.87,52.07,52.49,52.23,51.64,51.07,50.75,50.82,50.87,50.84,50.61,50.33,50.11,50.08,50.25,50.62,51.12,51.63,51.85,51.50,50.86,50.71,53.25,55.75,58.11,60.62,60.62,60.60,60.59,59.59,58.77,58.59,57.59,55.60,51.34,52.62,53.25,57.72,61.76,64.98,69.88,70,67.98,65,60,55.98,55.98,55,54,50.98,47,47,50,52.98,52.98,54,54,52,50.98,49.33,47.25,46.72,46.23,45.75,45.37,44.98,44.60,44.23,43.84,43.38,42.97,42.50,42,41.48,40.95,40.45,40,39.75,39.82,39.01,38.75,38.73,38.85,39.12,39.72,40.37,41.07,41.64,42.15,42.50,42.63,42.59,42.24,41.61,40.75,39.87,39.02,38.39,37.95,37.51,37.12,36.49,35.63,34.02,32,29,29,27.98,25,22.98,20.98,20.98,20,20,19,-4,-4.13,-7.26,-10,-13,-15,-16,-17,-17,-17,-17,-17,-18,-18,-18,-18,-18,-18,-18,-18,-18,-19,-19,-19,-19,-19,-20,-19,-19,-19,-19,-19,-19,-19,-18,-18,-17,-16,-15,-14,-13,-11,-10,-8.80,-7.38,-5.92,-4.65,-3.54,-2.54,-1.64,-0.92,-0.50,-0.25,-0.13,-0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.04,0.11,0.16,0.23,0.27,0.35,0.42,0.50,0.57,0.60,0.62,0,0.98,0.98,2,2,2,2.98,4,5.98,5.98,7,7.98,10,17,17,20.98,24,25.70,25.34,24.89,24.70,24.72,25.12,25.78,26.49,27.12,27.65,28.23,28.87,29.64,30.60,31.70,32.88,34.08,35.23,36.28,37.36,38.35,39.22,39.75,40,40.12,40.23,40.34,40.51,40.77,41.72,42.73,43.62,44.26,44.40,45.36,46.20,46.14,46.12,45,42.07,40,37,37,37,39,40,40.98,40.98,42,42.98,44,45,45,47,49,48.12,48.25,48.37,48.47,49.51,49.37,46.62,45.87,42.70,45.08,45.25,40.64,39.52,38.52,42.50,45.95,48.90,50.71,51.22,51,50.34,49.49,49.01,48.89,48.87,48.75,48.57,48.34,48.14,48.27,48.63,49.10,49.50,49.74,49.86,49.95,50.25,51.37,52.87,54.62,56.07,56.25,56.32,57.36,58.62,57.59,54.37,54.37,54.74,52.62,48.32,49.27,49.25,55.12,59.15,63.10,66.95,67,67,62.98,59,50.98,50.98,49,50,50.98,44,44,45,49,50,50,50,50,48,47.62,46.47,45.70,45.14,44.71,44.25,43.87,43.50,43.12,42.75,42.27,41.84,41.35,40.85,40.34,39.83,39.36,38.96,38.48,38.12,37.63,37.60,37.62,37.82,38.21,38.83,39.60,40.33,40.99,41.52,41.97,42.22,42.22,41.89,41.33,40.49,39.50,38.62,37.95,37.47,37.12,36.85,36.49,36.10,36.62,34.96,30,30,27.98,25.98,24,20,20,19,17.98,17.98,-3.13,-3.37,-5.88,-8.51,-11,-13,-15,-15,-16,-16,-17,-17,-17,-17,-17,-17,-18,-18,-18,-18,-18,-18,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-18,-18,-18,-17,-16,-15,-14,-12,-11,-10,-8.63,-7.18,-5.78,-4.50,-3.38,-2.42,-1.64,-1,-0.52,-0.26,-0.13,-0.04,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.03,0.08,0.12,0.21,0.35,0.50,0.60,0.58,0.42,0.23,0,0.49,0.49,1.49,1.49,1.49,2.49,3.49,4.99,4.99,6,6.98,8.50,13.99,13.99,17.99,21.50,23.99,23.26,22.90,22.87,23.12,23.84,24.75,25.57,26.24,26.83,27.41,28.08,28.85,29.75,30.86,32.04,33.26,34.38,35.58,36.77,38,38.98,39.49,39.60,39.57,39.52,39.59,39.73,40.11,40.75,41.65,42.50,43.14,43.77,44.51,45.27,45.12,44.87,43.89,41.49,38.99,36,36,37,39,40,40.49,40.49,41.49,42.49,43.49,44.50,44.50,46,48,47.09,47.07,47.25,47.77,48.37,48.90,45.60,44.35,42.62,44.35,45.33,40.12,38.85,38.07,41.49,44.83,47.63,49.38,49.97,49.75,49.08,48.09,47.45,47.20,47.07,46.89,46.74,46.60,46.59,46.86,47.26,47.74,48.01,48.11,47.87,48.65,49.75,51.25,52.26,53.57,54.22,54.52,54.75,56.13,57.62,56.62,53.36,53.35,53.62,51.12,47.25,47.72,48.25,53.75,57.99,62.07,66.48,66.49,66.49,63.49,59.99,51.49,51.49,49,48.50,49.48,44,44,43.99,48,50,48.50,48.50,48.97,47.63,46.50,45.62,44.84,44.20,43.62,43.15,42.75,42.40,42.08,41.65,41.23,40.74,40.25,39.75,39.25,38.75,38.35,37.97,37.62,37.32,36.87,36.58,36.64,36.87,37.35,38,38.87,39.62,40.37,41.02,41.58,41.89,42,41.76,41.24,40.37,39.37,38.37,37.62,37.10,36.75,36.50,36.25,36.15,35.75,34.73,30.49,30.49,27.98,25.98,24.50,20,20,18.49,17.98,17.49,-2.15,-2.53,-4.52,-7,-9.68,-11,-13,-14,-14,-15,-15,-15,-16,-16,-16,-16,-17,-17,-17,-18,-18,-18,-18,-19,-19,-19,-19,-19,-19,-19,-19,-18,-18,-18,-18,-16,-15,-14,-12,-11,-9.80,-8.40,-7,-5.63,-4.42,-3.29,-2.38,-1.63,-1.04,-0.63,-0.36,-0.14,-0.05,-0.02,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.08,0.17,0.37,0.61,0.74,0.66,0.42,0.17,0,0,0,0.98,0.98,0.98,2,2.98,4,4,5,5.98,7,10.98,10.98,15,19,22,20.98,20.77,20.50,21.51,22.83,23.95,24.78,25.47,26.07,26.67,27.36,28.12,29.01,30.09,31.35,32.53,33.77,34.92,36.25,37.74,39.12,39.21,39.12,38.99,38.87,38.86,38.96,39.27,39.95,40.75,41.52,42.22,42.83,43.74,44.87,43.88,43.96,42.98,40.98,37.98,35,35,37,39,40,40,40,40.98,42,42.98,44,44,45,47,45.98,45.87,46.25,46.87,47.62,48.49,44.51,43.38,42.60,44.37,45.37,39.57,38,37.50,40.82,44,46.85,48.50,48.89,48.65,47.87,46.87,46.02,45.59,45.37,45.24,45.12,45.12,45.25,45.62,46.12,46.58,46.83,46.75,46.37,47.25,49.12,50.27,51.14,52.21,53.12,52.73,53.24,54.70,56.65,55.62,52.33,51.64,52.63,49.70,46.25,46.75,47.21,52.82,56.87,61,65.98,65.98,65.98,64,60.98,52,52,49,47,47.98,44,44,42.98,47,50,47,47,47.89,46.62,45.61,44.72,43.90,43.23,42.59,42.02,41.62,41.27,40.98,40.60,40.12,39.62,39.13,38.70,38.23,37.75,37.35,37,36.76,36.62,36.26,36,35.89,36.12,36.62,37.36,38.24,39.08,39.90,40.70,41.35,41.77,42,41.87,41.37,40.52,39.50,38.45,37.50,36.76,36.32,36.01,35.84,35.64,35.23,34.48,31.10,30.98,27.98,25.98,25,20,20,17.98,17.98,17,-0.92,-1.01,-3.11,-5.13,-7.49,-9.41,-10,-11,-12,-12,-13,-13,-13,-14,-14,-15,-15,-15,-16,-16,-17,-17,-18,-18,-19,-19,-19,-19,-19,-18,-18,-18,-18,-17,-16,-15,-13,-12,-10,-9.42,-8.04,-6.75,-5.50,-4.27,-3.15,-2.37,-1.63,-1.04,-0.64,-0.38,-0.18,-0.12,-0.03,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.04,0.16,0.37,0.64,0.79,0.73,0.45,0.17,0,0,0,0,0,0.98,0.98,2,2.98,2.98,2.98,4,4,5.98,5.98,9,12,15,15.98,15.98,17.03,19.90,22.21,23.36,24.20,24.71,25.23,25.98,26.65,27.39,28.23,29.28,30.65,32.37,33.14,34.15,35.62,37.60,38.60,38.62,38.58,38.37,38.15,38.10,38.12,38.40,39.08,39.86,40.60,41.12,41.74,42.14,42.89,42,42,40.98,37.98,35.98,35,35,37,39,39,39,39,40,40.98,42,42.98,42.98,42.98,44,44.11,44.83,45.09,45.87,46.87,47.52,43.45,42.46,40.50,43.47,44.49,36.47,36.62,37.39,40.21,43.38,45.87,47.33,47.75,47.73,46.82,45.63,44.62,44,43.75,43.65,43.70,43.77,44.08,44.50,45.08,45.59,45.75,45.51,44.89,44.90,47.23,48.61,49.50,50.74,51.25,50.21,50.24,52.72,53.73,52.70,49.26,49.25,48.73,46.74,43.22,45.75,46.12,51.10,56.01,60,64,64,64,64,62.98,52,52,49,47,45,44,44,40.98,44,47.98,47,47,46.02,45.48,44.40,43.62,42.88,42.12,41.40,40.84,40.38,40.11,39.83,39.48,39,38.50,38.02,37.61,37.14,36.71,36.25,35.98,35.85,35.87,35.75,35.50,35.33,35.50,36,36.76,37.72,38.61,39.59,40.49,41.26,41.88,42.25,42.25,41.85,41,39.87,38.65,37.48,36.45,35.65,35.23,34.90,34.75,34.37,33.26,30.34,30,27.98,25.98,24,19,19,17.98,17,17,-0.15,-0.25,-1.63,-2.91,-4.66,-6.25,-7.30,-8.25,-9.14,-9.99,-10,-10,-10,-11,-11,-12,-12,-13,-14,-14,-15,-16,-16,-17,-17,-17,-18,-17,-18,-17,-16,-16,-15,-14,-14,-12,-11,-9.92,-8.68,-7.38,-6.17,-5.11,-4,-3.02,-2.16,-1.49,-0.90,-0.53,-0.29,-0.14,-0.05,-0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.03,0.13,0.33,0.54,0.67,0.62,0.38,0.14,0,0,0,0,0,0,0.98,0.98,2,2,2,2,2,2.98,2.98,4,7,9,12,12,15,19,20.92,23.79,23.66,23.58,24.50,24.87,26.48,26.50,27.02,28.57,29.95,31.73,32.25,33.25,34.63,36,37.60,37.58,37.58,37.58,37.58,37.21,37.21,37.62,37.88,38.71,39.74,39.76,39.85,40.87,40.98,40,40,37.98,35.98,32.98,35,35,35.98,37,37.98,39,39,39,40,40.98,40.98,40.98,42,42,42.10,42.83,43.20,44.99,46.02,46.62,40.37,39.61,39.37,42.57,42.57,34.38,34.71,36.60,39.39,42.48,44.65,46,46.50,46.47,45.50,44.27,43.09,42.40,42.21,42.22,42.35,42.57,42.87,43.38,43.99,44.57,44.64,44.26,43.20,43.50,44.50,46,47.37,49.09,50.37,48.12,48.13,49.76,49.75,49.75,47.24,46.75,45.75,43.15,41.13,46.85,47.12,51.90,55.97,59,60.98,60.98,62,62.98,62.98,55,55,52,47,44,42.98,42.98,40,42,45.98,47,47,44.87,43.60,42.87,42.26,41.63,40.95,40.21,39.57,39.12,38.86,38.62,38.27,37.86,37.37,36.88,36.50,36.08,35.59,35.12,34.82,34.82,34.99,35.98,34.62,34.50,34.85,35.50,36.37,37.27,38.24,39.36,40.39,41.38,42.23,42.75,42.89,42.62,41.74,40.47,38.99,37.51,36.14,34.87,34,33.48,33.37,33.14,32.12,30.48,30,27.98,25,22.98,17.98,17.98,17,17,15.98,-0.03,-0.14,-0.63,-1.24,-1.88,-3.25,-3.92,-4.80,-5.75,-6.63,-7.24,-7.63,-7.87,-8.13,-8.75,-9.38,-10,-10,-11,-12,-13,-13,-14,-14,-15,-15,-15,-15,-14,-14,-13,-12,-11,-10,-10,-8.63,-8.37,-7.38,-6.30,-5.28,-4.36,-3.50,-2.63,-2,-1.38,-0.88,-0.52,-0.29,-0.16,-0.12,-0.03,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.09,0.21,0.36,0.45,0.39,0.25,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.98,2,2.98,5,5,9,12,15,17.98,17.98,20,22,22.98,24,24,25,27.02,29.08,30.76,31.22,32.13,33.25,34.34,35.62,36.25,36.33,36.36,36.34,36.27,36.33,36.32,36.26,37.25,37.97,38.12,37.12,37.02,37,35.98,35.98,35,32,30,34,34,35,35,35.98,37,37,37,37,37,37.98,37.98,37.98,37.98,39.09,41.86,42.20,44.74,45.70,44.64,36.34,36.35,36.37,38.64,38.60,31.37,31.85,35.22,38.37,41.37,43.50,44.82,45.23,45.12,44.02,42.75,41.50,40.87,40.75,40.87,41.10,41.35,41.72,42.23,42.77,43.34,43.39,43,41.88,40.75,42.37,43.34,45.13,46.25,46.37,46.07,46.10,46.85,45.13,44.14,43.13,43.12,42.82,39.12,40.12,49.88,49.95,50.98,52.98,55,57,57,57.98,59,59,59,59,57,54,49,39,39,37.98,40,44,44,44,42.11,41.62,41.33,40.77,40.25,39.62,38.95,38.26,37.85,37.60,37.38,37.12,36.71,36.23,35.76,35.37,34.98,34.49,34.01,33.74,33.83,34.12,34,32.98,33.33,34.37,35.22,36.08,37,37.96,39.15,40.47,41.71,42.73,43.39,43.64,43.37,42.36,40.87,39.25,37.65,36.01,34.25,32.90,32.12,32.02,31.98,31.02,29.59,29,25,22,20,17,17,17,15.98,15,-0.01,-0.02,-0.16,-0.38,-0.75,-1.24,-1.75,-2.25,-2.88,-3.92,-4.43,-4.78,-5.01,-5.27,-5.75,-6.26,-7.26,-8.03,-8.93,-9.88,-10,-11,-11,-12,-12,-12,-12,-12,-12,-11,-10,-10,-9.61,-8.79,-7.88,-7,-6,-5.24,-4.15,-3.16,-2.78,-2.18,-1.63,-1.17,-0.79,-0.50,-0.28,-0.15,-0.12,-0.04,-0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.10,0.15,0.20,0.16,0.12,0.03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.59,1.37,2.09,3.88,4.08,6.49,8.99,11.50,15.48,15.48,17.50,19.50,20.99,23,23,23.99,26,27.97,29.84,30.20,31,32,33.27,34.62,34.90,35.02,35.20,35.36,35.48,35.50,35.50,35.72,36.20,36.75,36.83,36.49,36,36,35.49,35.49,35,32,29.50,33.49,33.49,34.50,35,35.98,36.49,36.49,36.49,36.49,36.49,36.98,36.98,36.98,37.49,38.02,41.87,42.15,43.75,44.72,43.20,35.32,35.01,35.36,37.12,36.62,30.36,30.65,34,37.37,40.22,42.37,43.75,43.90,43.62,42.45,41.14,40,39.51,39.51,39.71,39.90,40.14,40.50,40.98,41.50,42,42.13,41.86,40.88,40.60,40.87,42,43.12,43.90,44.12,44.98,45.01,45.88,44.37,42.61,42.86,42.86,42.37,38.09,39.52,49.49,49.50,49.99,51.98,53.50,56,56,56.98,58,57,57.49,57.49,56.49,54.50,49.99,39.99,39.99,37.49,39.50,43,42.49,42.49,41.48,40.58,39.82,39.25,38.76,38.25,37.62,37,36.57,36.34,36.15,35.96,35.52,35.09,34.64,34.27,33.87,33.46,33.10,32.89,33.11,33.32,33.49,32.98,32.98,34,35,35.97,36.77,37.63,38.99,40.50,42.10,43.27,44.12,44.37,44,42.75,41.12,39.40,37.89,36.13,34,32.32,31.22,30.97,30.85,30,28.12,27.49,23.99,21.49,19.50,17,17,16.49,15.98,15,0,-0.01,-0.11,-0.18,-0.38,-0.63,-0.88,-1.17,-1.52,-2.12,-2.43,-2.75,-2.91,-3.24,-3.62,-4.03,-4.77,-5.50,-6.40,-7.30,-8.14,-8.87,-9.38,-9.75,-10,-10,-10,-9.88,-9.49,-9,-8.62,-8.50,-7.50,-6.76,-6.04,-5,-4.17,-3.51,-2.88,-2.26,-1.74,-1.38,-0.93,-0.67,-0.43,-0.25,-0.14,-0.12,-0.04,-0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.03,0.07,0.07,0.03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.04,0.16,0.79,1.14,2.79,3.13,4.12,5.99,8.04,12.95,12.98,15,17,19,22,22,22.98,25,26.96,28.87,29.13,29.76,30.73,31.96,33.71,33.65,33.87,34.12,34.64,34.65,34.75,34.76,34.87,35.14,35.82,35.87,35.90,35,35,35,35,35,32,29,32.98,32.98,34,35,35.98,35.98,35.98,35.98,35.98,35.98,35.98,35.98,35.98,37,37,41.88,41.85,42.75,43.75,41.73,34.27,33.88,34.35,35.62,34.62,29.35,29.49,33.62,36.87,39.37,41.34,42.12,42.21,41.83,40.62,39.39,38.58,38.34,38.46,38.62,38.84,39,39.25,39.63,40.10,40.58,40.90,40.87,40.25,39.64,39.75,40,41.34,42.64,42,44,44,45,44,40.98,42.98,42.98,42,37,39,49,49,49,50.98,52,55,55,55.98,57,55,55.98,55.98,55.98,55,50.98,40.98,40.98,37,39,42,40.98,40.98,40.87,39.36,38.23,37.57,37.12,36.75,36.13,35.61,35.15,34.98,34.87,34.64,34.32,33.87,33.46,33.11,32.75,32.45,32.24,32.24,32.38,32.65,32.98,32.98,32.98,34,35,35.98,36.88,37.12,38.85,40.70,42.45,43.75,44.62,44.86,44.47,43.12,41.48,39.75,38.23,36.48,34.24,32.34,30.90,30.25,29.82,28.99,26.62,25.98,22.98,20.98,19,17,17,15.98,15.98,15,0,-0.01,-0.02,-0.13,-0.17,-0.28,-0.41,-0.54,-0.75,-1.05,-1.26,-1.43,-1.62,-1.75,-1.99,-2.15,-2.76,-3.29,-4.04,-4.88,-5.55,-6.13,-6.53,-6.88,-7.11,-7.18,-7.18,-7.03,-6.75,-6.39,-6.12,-5.68,-5.25,-4.65,-3.92,-3.02,-2.64,-2.25,-1.87,-1.42,-1.12,-0.75,-0.50,-0.30,-0.16,-0.12,-0.03,-0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.04,0.03,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.22,0.23,1.20,1.77,2.10,2.20,3.14,4.12,7.88,8.01,10,12,14,19,19,20.98,22.98,25,27.88,27.86,28.12,28.96,30.24,31.74,32.13,32.70,32.99,33.25,33.73,33.87,33.89,33.98,34.12,34.12,34.07,34,34,34,34,34,32.98,30,27,30.98,30.98,32.98,34,35,35,35,35,35,34,34,34,34,34,35.98,38.95,39.11,39.97,39.77,37.74,32.25,32.25,33.70,32.74,30.32,30.32,30.27,34.02,37.01,38.82,39.52,40.02,40.08,39.71,38.59,37.50,36.90,37.08,37.37,37.58,37.71,37.83,38,38.25,38.57,38.99,39.51,39.65,39.62,38.58,36.90,36.65,38.61,39,39,40.98,40.98,42,40.98,39,42.98,42.98,39,35,37.98,45.98,45.98,45.98,47.98,50,52.98,52.98,55,52.98,52,52.98,52.98,52,52,47.98,40.98,40.98,37,35,39,39,39,38.87,37.36,36.25,35.58,35.09,34.84,34.37,33.87,33.51,33.37,33.26,33.13,32.83,32.37,31.98,31.62,31.37,31.25,31.25,31.39,31.64,31.87,32,32.98,32.98,34,35,35.98,37.90,37.99,39.25,40.89,42.74,44.02,44.97,45.27,45,43.65,41.95,40.10,38.58,36.74,34.37,32.33,30.73,29.86,29,27.07,24.62,24,20.98,19,17.98,17,17,15.98,15,15,0,0,-0.01,-0.02,-0.12,-0.13,-0.16,-0.25,-0.27,-0.38,-0.55,-0.65,-0.75,-0.78,-0.87,-0.88,-1.27,-1.62,-2.05,-2.63,-3.15,-3.50,-3.75,-3.92,-4.11,-4.16,-4.15,-4.11,-4,-3.77,-3.50,-3.18,-2.88,-2.52,-2.04,-1.54,-1.30,-1.14,-1,-0.78,-0.61,-0.38,-0.25,-0.15,-0.13,-0.04,-0.02,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.03,0.17,0.27,0,0,0,0,0,0,0,0.98,0,0,0,0,0,0,0,0,0.11,0.71,0.71,0.87,1,1.22,1.77,2.17,3.87,4.10,6.01,7.98,10,15.98,15.98,17.98,20,24,25.98,25.88,25.87,26.85,27.76,29.76,30.23,31.11,31.75,32.20,32.75,32.75,32.87,33.11,33.09,33.01,32.98,32.98,32.98,32.98,32,32,30.98,27.98,24,30,30,32,32.98,34,32.98,32.98,32.98,32.98,32.98,32,32,32,32.98,34,37,36.90,37.87,36.85,34.77,32.23,31.75,33.73,30.71,28.25,31.73,32.25,35.65,37.36,37.09,37.61,37.87,37.86,37.40,36.50,35.50,35.23,35.73,36.13,36.39,36.51,36.62,36.71,36.77,36.89,37.12,37.38,37.72,37.95,38.12,34.63,34.37,35.88,37,35.98,39,39,40,37.98,37,40,40,35.98,32.98,35.98,44,44,44,45.98,47,50.98,50.98,50.98,50.98,49,50,50,47.98,47,45.98,39,39,35.98,34,35.98,37,37,35.87,34.59,34.13,33.20,32.75,32.50,32.25,31.95,31.73,31.62,31.58,31.46,31.21,30.75,30.35,30,29.84,29.98,30.25,30.51,30.83,31.08,30.98,32.98,32.98,34,35.98,37,37.97,38.07,39.47,41,42.75,44.12,45.12,45.62,45.62,44.39,42.64,40.60,38.95,36.96,34.45,32.33,30.62,29.60,28.32,26.10,22.52,22,20,17.98,17.98,15.98,15.98,15.98,15,14,0,0,0,-0.01,-0.01,-0.04,-0.05,-0.12,-0.13,-0.13,-0.16,-0.25,-0.25,-0.26,-0.25,-0.25,-0.42,-0.54,-0.76,-1.02,-1.27,-1.42,-1.52,-1.63,-1.74,-1.75,-1.75,-1.64,-1.41,-1.25,-1.01,-0.80,-0.78,-0.66,-0.61,-0.38,-0.24,-0.25,-0.38,-0.28,-0.16,-0.13,-0.12,-0.04,-0.02,-0.01,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.98,0.98,0.98,0.98,0.98,0.98,0.98,2,0.98,0.98,0.98,0.98,0.98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.03,0.23,0.98,0.98,0,0,0,0,0,0,0,0.02,0,0,0,0,0,0,0,0.11,0.22,0.33,0.32,0.29,0.27,0.25,1.21,2.03,2.14,2.09,3,2.98,7,7,9,14,17.98,22.98,22.98,21,20.09,21.11,27.83,28.12,30.02,30.87,31.12,31.12,31.12,31.98,32.09,32.90,32,32,30.98,30,27.98,22.98,22.98,20.98,19,17.98,22,22,25,27.98,30,32,32,30.98,30,30,30,30,30,30.98,32,32.98,32.99,34.07,33.09,31.12,30.15,30.20,29.87,27.23,27.23,33.75,33.75,34.12,34.25,35.50,35.75,35.95,36,35.65,34.99,34.01,33.82,34.37,34.87,35.22,35.37,35.48,35.49,35.37,35.25,35,34.96,35.85,36.32,35.40,32.27,32,30.98,34,32.98,34,34,34,32,34,35.98,35.98,32,32.98,37,40.98,40.98,39,37.98,40.98,44,44,45,45,45,42,42,40.98,40.98,40,32.98,32.98,30,29,32,32.98,32.98,32.02,31.34,30.72,30.99,30.63,30.45,30.24,30.10,29.99,29.89,29.87,29.82,29.62,29.20,28.73,28.36,28.26,28.71,29.14,29.62,30.01,30.24,30.98,32.98,32.98,34,35,35.98,37.98,38,39.50,40.99,42.74,44.12,45.26,45.96,46.23,45.02,43.27,41.08,39.35,37.12,34.50,32.37,30.73,29.62,28.07,25.52,22.38,22,20.98,20,19,15.98,15.98,15,14,14,0,0,0,0,0,0,0,0,0,0,0,0,-0.05,-0.05,-0.05,-0.05,-0.04,-0.13,-0.25,-0.28,-0.37,-0.37,-0.38,-0.38,-0.39,-0.39,-0.38,-0.37,-0.29,-0.28,-0.25,-0.29,-0.30,-0.26,-0.24,-0.13,-0.11,-0.11,-0.03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.49,0.49,0.49,0.98,0.98,0.98,0.98,1.49,0.98,0.98,0.98,0.98,0.98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.01,0,0,0,0,0,0,0,0,0,0.01,0,0.49,0.49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.16,0.65,1.25,1.49,1.62,2.40,2.50,5.50,5.50,7,12,16.98,20.48,20.48,18.99,18.50,20.51,27.87,28.08,29.87,30.37,30.60,30.87,31.07,31.40,31.50,32.49,30.50,30.50,29.48,27.50,25.99,20.99,20.99,19.48,17.49,16.49,19.99,19.99,22.50,25.48,27.99,31,31,29.99,29.50,29.50,29.50,29.50,29.50,30.49,31.49,31.98,31.98,32.49,31.89,30.08,29.62,29.49,29.35,26.14,26.63,32.83,32.99,33.12,33.57,34.09,34.40,34.59,34.73,34.50,33.85,32.98,32.65,33.22,33.75,34.12,34.38,34.57,34.45,34.11,33.75,33.75,33.95,34.38,35,35.35,31,31,30.98,34,32.98,32.49,32.49,32.49,31.49,33.49,34.99,34.99,32,32.98,36.49,39.99,39.99,38,36.49,39.99,43,43,43.50,43.50,42.99,40.50,40.50,38.99,39.48,37.99,32.49,32.49,28.50,29,31,31.98,31.98,31,30.15,29.62,29.27,29,28.77,28.63,28.62,28.58,28.50,28.50,28.45,28.26,27.87,27.40,27.10,27.12,27.65,28.25,28.84,29.37,29.98,30.49,32.49,32.49,34,35,35.98,38.49,38.49,39.64,40.90,42.62,44.10,45.46,46.23,46.74,45.62,43.96,41.62,39.86,37.58,34.87,32.72,30.98,29.71,27.89,25.48,22.74,22.49,21.49,20,19,16.49,16.49,15,14,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.05,-0.12,-0.13,-0.13,-0.13,-0.13,-0.13,-0.13,-0.13,-0.13,-0.13,-0.04,-0.05,-0.05,-0.05,-0.04,-0.03,-0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.03,0.09,0.12,0.11,0.07,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.04,0.29,0.72,0.91,1.14,1.88,2.03,4,4,5,10,15.98,17.98,17.98,17,17,20,27.98,27.98,30,30,30,30.98,30.98,30.98,30.98,32,29,29,27.98,25,24,19,19,17.98,15.98,15,17.98,17.98,20,22.98,25.98,30,30,29,29,29,29,29,29,30,30.98,30.98,30.98,30.98,30.98,29,28.95,28.88,28.87,25.11,26.09,31.87,31.87,32.09,32.89,32.99,34,33.86,33.84,33.75,33.39,31.62,31.35,32.34,32.70,33.20,33.64,33.86,34,32.98,32.98,32.98,32.98,34,34,35,30,30,30.98,34,32.98,30.98,30.98,30.98,30.98,32.98,34,34,32,32.98,35.98,39,39,37,35,39,42,42,42,42,40.98,39,39,37,37.98,35.98,32,32,27,29,30,30.98,30.98,30,29.01,28.63,28.08,27.75,27.51,27.38,27.35,27.33,27.26,27.26,27.23,27.09,26.75,26.37,26.14,26.36,26.84,27.47,28.09,28.82,30,30,32,32,34,35,35.98,39,39,39.89,41.11,42.84,44.38,45.87,46.75,47.40,46.34,44.63,42.33,40.58,38.25,35.39,33.14,31.23,29.97,28.15,25.88,23.02,22.98,22,20,19,17,17,15,14,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-0.01,-0.01,-0.01,0,0,0.01,0.08,0.09,0.10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.40,0.46,0.33,0.16,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.23,0.24,0.87,1.11,1.03,2,2,2.98,7,12,14,14,14,15.98,20,27,27,27.98,29,29,30,30,30,30,27.98,24,24,22,20,19,17,17,15,14,14,15.98,15.98,17.98,19,22,25.98,25.98,25.98,27.98,27.98,27,27,27.98,29,29,30,30,30,29,25.98,27.98,27.98,27,24,25.98,30,30,30.98,32,32,32.98,32.98,32.98,32.98,32.98,29,29,30.98,32,32,32.98,32.98,32,32,32,32,32,32,32.98,32.98,29,29,32,32.98,30.98,27.98,27.98,29,30.98,32.98,32,32,30,30.98,34,37,37,34,32.98,35.98,39,39,39,39,37.98,35.98,35.98,34,35,32.98,29,29,25.98,25.98,27.98,27.98,27.98,27.98,27.98,27.09,26.75,26.38,26.25,26,25.98,25.96,26,25.97,26,25.76,25.50,25.07,24.99,25.25,26,26.76,27.26,28,29,30,32,32,34,35,37,39,39,40,41.13,43.27,45.12,46.59,47.62,48.48,47.45,45.60,43.37,41.58,39.13,36.09,33.21,31.62,30.50,28.75,26.82,24,24,22,20,19,17,17,15,14,12.98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.12,0.20,0.25,0.25,0.25,0.25,0.25,0.25,0.25,0.20,0.12,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0,0,0,0,0,0,0,0,0,0,0,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.15,0.21,0.25,0.29,0.33,0.33,0.33,0.33,0.33,0.33,0.33,0.33,0.33,0.33,0.33,0.34,0.29,0.25,0.76,0.98,1.07,2,2,2.98,5,9,10.98,10.98,14,17,19,24,24,25,25.98,27.98,30,30,27.98,25,22,19,19,17,17,15.98,15,15,14,12.98,14,15,15,15.98,17,17.98,20.98,20.98,22.98,25,25.98,25,25,27.98,29,29,29,29,27.98,25.98,22.98,27.98,27.98,25,22.98,25.98,29,29,30,30.98,30.98,32,32,32,32,30.98,27.98,27.98,30,30,30.98,30.98,30.98,30.98,30.98,30.98,30,30,30.98,32,30,29,29,30.98,30,27.98,27.98,27.98,30,32,34,29,29,27,27.98,30.98,35,35,32,30.98,32.98,37,37,35.98,35,34,34,34,32,32,30.98,27.98,27.98,24,24,25.98,25.98,25.98,25.98,25.98,25.98,24.87,24.60,24.37,24.14,23,23.88,23.84,23.76,23.75,23.76,22.86,22.96,23.10,23.25,24.45,26.71,26.95,27,27.98,29,32,32,34,35,37,40,40,40.98,42,42.75,46.49,46.25,48.07,49.88,48.83,44.74,44.73,41.74,38.83,36.88,32.01,32.24,30.47,29.75,27.98,24,24,22,20,19,15.98,15.98,15,14,12.98,];
}

function getTileMap()
{
	return [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,5,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,5,5,5,5,5,5,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,5,5,5,5,5,5,1,1,1,5,5,5,5,5,5,1,1,1,1,1,3,3,3,3,3,1,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,6,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,1,1,6,6,1,1,1,5,5,5,5,5,5,1,1,1,5,5,5,5,5,5,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,1,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,6,6,6,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,6,6,6,6,1,1,5,5,5,5,5,5,5,5,1,5,5,5,5,5,5,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,6,6,6,6,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,6,6,6,6,6,1,1,5,6,5,5,5,5,5,5,1,5,5,5,5,5,5,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,1,5,1,5,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,6,6,6,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,6,6,6,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,5,6,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,6,6,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,6,6,3,3,3,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,6,6,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,5,5,5,5,5,5,5,1,5,5,5,5,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,6,6,6,3,1,3,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,5,5,5,5,5,5,5,1,1,5,5,1,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,5,5,5,5,5,5,5,5,1,1,1,1,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,6,6,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,5,5,5,5,5,5,5,1,5,5,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,6,1,6,1,1,6,6,6,6,6,6,6,6,7,7,6,6,6,6,6,7,7,7,7,7,7,7,6,6,6,1,1,1,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,5,5,5,5,5,5,5,1,5,5,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,6,1,1,6,1,6,6,6,6,6,6,6,7,7,7,7,6,6,6,6,7,6,6,7,7,7,6,6,6,6,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,5,5,5,5,5,5,5,1,5,5,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,6,6,1,1,1,1,6,6,6,6,6,6,6,7,7,7,7,7,7,7,6,6,6,6,6,6,7,6,6,6,6,6,6,1,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,5,5,5,5,5,5,5,1,5,5,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,5,5,5,5,5,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,6,1,1,6,1,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,6,6,1,6,6,6,7,6,6,6,6,6,6,6,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,6,6,1,1,1,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,7,7,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,3,3,3,3,3,3,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,6,1,1,1,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,6,6,7,6,7,6,7,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,1,3,3,3,3,3,3,3,3,3,3,3,3,3,5,5,5,5,5,5,5,5,5,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,6,6,6,7,7,7,6,6,6,6,6,6,6,6,6,5,1,1,5,5,1,5,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,1,1,1,1,4,3,3,4,4,3,3,3,3,3,3,3,3,3,3,3,3,1,3,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,5,5,5,5,5,5,5,5,5,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,6,6,6,6,7,6,6,7,7,7,7,7,7,7,7,7,7,7,6,6,6,7,7,7,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,1,1,1,1,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,5,5,5,5,5,5,5,5,5,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,5,5,5,5,5,5,1,1,1,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,7,7,7,7,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,1,3,3,3,3,3,3,3,3,3,3,3,3,3,1,5,5,5,5,5,5,5,5,5,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,3,3,3,3,3,1,1,1,1,1,1,1,6,1,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,3,3,3,3,3,3,3,3,3,1,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,3,3,3,1,1,1,1,1,1,1,1,1,6,1,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,3,3,3,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,8,7,8,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,7,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,5,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,3,3,3,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,7,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,2,2,2,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,1,7,7,6,1,1,1,1,1,7,7,7,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,1,1,5,5,5,5,5,5,5,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,2,2,2,1,1,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,7,7,7,9,9,7,7,7,7,7,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,7,7,7,1,1,7,7,7,7,7,7,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,3,3,3,3,3,3,3,3,3,3,3,3,3,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,1,1,5,5,5,5,5,5,5,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,5,5,5,5,5,5,5,5,5,1,1,1,6,1,1,1,1,1,1,1,6,6,6,6,6,6,6,7,7,7,9,7,7,9,7,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,6,6,1,1,1,7,7,7,7,7,7,7,7,7,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,1,1,1,1,5,5,5,5,5,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,2,2,2,5,5,5,5,5,5,5,5,5,5,1,1,1,6,6,6,6,6,6,1,1,6,6,6,6,6,6,7,7,7,9,7,7,9,9,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,6,1,1,7,7,7,7,7,7,7,7,7,7,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,3,3,3,3,3,3,3,3,3,1,3,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,1,1,1,1,5,5,5,5,5,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,2,1,1,5,5,5,5,5,5,5,5,5,5,1,1,1,6,6,1,6,1,6,6,1,6,6,6,6,6,7,7,7,7,7,7,9,9,9,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,6,1,1,6,7,6,6,6,6,7,7,7,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,1,1,1,1,5,5,5,5,5,5,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,1,1,1,1,6,6,6,6,6,6,6,1,6,6,6,6,6,7,7,7,9,7,9,9,9,9,8,8,8,7,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,1,6,7,7,6,6,6,6,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,5,5,5,5,5,5,5,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,6,6,6,6,1,1,1,6,6,6,6,6,7,7,7,9,7,9,9,9,9,9,8,8,7,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,5,5,5,5,5,5,5,5,5,5,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,6,6,1,6,6,6,6,6,6,6,6,6,7,7,7,7,7,9,9,9,9,9,8,7,8,8,8,8,8,8,8,8,7,8,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,7,7,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,5,5,5,5,5,5,5,5,5,5,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,9,9,9,9,9,8,7,8,8,8,8,8,8,8,8,7,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,1,3,3,3,3,3,1,5,5,5,5,5,5,5,5,5,5,1,3,1,1,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,9,9,9,9,7,7,7,8,8,7,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,7,7,7,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,1,3,3,3,3,3,3,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,7,9,9,9,9,9,7,7,8,8,8,8,7,7,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,9,9,9,9,7,7,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,1,3,3,3,3,3,3,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,7,7,9,9,9,9,9,7,7,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,9,9,9,9,9,9,9,9,9,9,9,7,7,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,1,1,3,3,3,3,3,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,7,6,6,6,6,7,7,7,9,9,9,9,9,7,7,8,8,8,8,8,8,8,8,7,8,8,7,7,7,7,7,9,9,9,9,9,9,9,9,9,9,9,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,3,3,3,3,3,1,1,1,1,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,7,7,6,6,6,7,7,7,9,9,9,9,9,9,7,7,8,8,8,8,8,8,8,8,6,6,8,7,7,7,7,7,9,9,9,9,9,9,9,9,9,9,9,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,3,3,3,3,3,1,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,4,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,6,6,7,7,6,6,6,7,7,7,9,9,9,9,9,7,7,7,8,8,8,8,8,8,8,8,6,6,8,7,7,7,7,7,9,9,9,9,9,9,9,9,9,9,9,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,3,3,3,3,3,1,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,2,2,2,1,2,2,2,2,1,1,1,1,1,1,6,6,6,7,7,6,7,7,6,7,9,9,9,9,9,7,7,7,7,8,8,8,8,8,8,8,6,8,8,7,7,7,7,7,9,9,9,9,9,9,9,9,7,7,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,6,6,6,6,7,7,7,9,9,9,9,9,9,9,9,7,7,7,7,7,8,8,8,8,8,6,6,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,6,6,6,6,7,7,6,9,9,9,9,9,9,9,9,7,7,7,7,6,6,6,6,6,6,6,6,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,1,1,1,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,4,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,9,9,9,9,9,9,9,7,7,7,7,7,7,7,8,6,6,6,6,6,6,8,7,7,7,7,7,7,7,7,7,7,7,7,7,1,2,1,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,3,3,3,3,3,3,3,3,3,1,1,1,1,5,5,5,5,5,5,1,5,5,1,1,1,4,4,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,9,9,9,9,9,7,7,7,7,7,7,7,7,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,2,2,2,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,3,3,3,3,3,3,3,3,3,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,9,9,9,9,9,7,7,7,7,7,7,7,7,7,6,8,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,2,1,6,6,6,6,6,6,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,6,6,6,6,6,6,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,1,1,6,6,6,6,6,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,6,6,6,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,2,2,2,2,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,4,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,6,6,6,9,9,9,9,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,2,2,2,2,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,6,6,6,9,9,9,9,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,2,2,2,2,2,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,6,6,9,9,9,9,6,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,5,5,5,5,5,1,5,5,5,5,5,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,6,9,9,9,9,6,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,2,2,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,4,4,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,6,9,9,9,9,9,6,7,7,7,7,7,7,7,7,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,2,2,2,2,2,2,2,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,4,4,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,6,6,9,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,2,2,2,2,2,2,2,1,1,1,1,1,1,1,2,2,2,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,4,4,1,4,1,4,1,1,4,1,1,1,1,1,1,1,1,1,1,3,3,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,4,4,1,1,1,1,1,1,1,1,1,1,1,6,1,6,6,6,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,6,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,2,2,2,2,2,2,2,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,6,6,6,6,6,1,7,7,7,7,7,7,7,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,5,5,5,5,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,1,1,1,1,1,2,2,2,2,1,1,1,1,1,6,6,6,6,6,6,6,6,6,7,7,7,7,8,8,8,8,8,8,7,7,7,7,7,7,7,10,10,10,10,10,7,7,7,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,1,5,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,6,1,1,1,1,2,2,2,2,1,1,1,1,1,1,6,6,6,6,6,6,6,1,6,7,7,7,7,8,8,8,8,8,8,8,7,7,7,7,7,7,10,10,10,10,10,7,7,7,7,2,2,2,2,2,2,2,2,1,1,1,1,1,2,2,2,2,2,1,1,1,2,2,2,2,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,5,1,1,1,6,1,6,1,6,6,1,1,1,1,6,6,1,1,6,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,1,7,7,7,7,8,8,8,8,8,8,7,7,7,7,7,7,7,10,10,10,7,7,7,7,7,2,2,2,2,2,2,2,2,2,1,2,2,2,2,2,2,1,1,1,1,1,1,2,2,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,5,5,1,5,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,5,1,1,1,1,1,1,1,6,1,6,6,6,1,1,1,1,7,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,6,6,6,6,6,6,6,1,6,1,1,1,7,7,7,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,2,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,7,7,7,7,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,6,6,6,6,6,6,6,6,6,6,7,6,1,1,1,7,7,7,8,8,8,8,8,7,7,7,7,6,7,7,7,7,7,7,7,7,7,7,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,1,1,6,7,7,7,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,2,6,6,6,6,6,6,6,6,6,6,7,7,7,7,1,7,1,1,1,1,1,7,7,7,7,7,7,9,9,9,9,9,6,6,7,7,7,7,7,7,7,7,7,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,7,7,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,1,1,1,7,7,7,7,7,7,9,9,9,9,9,9,9,6,6,6,7,7,7,7,7,7,7,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,3,3,3,3,3,3,3,3,1,1,1,1,1,3,3,3,3,3,3,3,1,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,1,1,3,3,3,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,1,7,7,7,7,7,7,7,7,9,9,9,9,9,9,9,7,6,6,7,7,7,7,7,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,3,3,3,3,3,3,3,3,3,1,1,1,1,3,3,3,3,3,3,3,1,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,1,1,3,3,3,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,9,9,9,9,9,9,9,9,9,7,7,6,6,6,7,7,7,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,9,9,9,9,9,9,9,7,6,6,6,6,6,7,7,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,2,2,2,2,2,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,4,4,4,4,4,4,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,1,1,1,3,3,3,3,3,3,6,1,1,1,1,6,6,6,6,6,7,7,7,7,7,7,7,6,6,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,10,10,7,7,7,7,7,7,7,7,7,7,7,9,9,9,9,9,9,9,7,7,7,6,6,6,7,7,7,7,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,2,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,3,3,3,3,3,3,3,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,3,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,7,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,10,10,10,10,10,10,7,7,7,7,7,7,7,7,9,9,9,9,9,9,9,7,7,7,7,6,6,6,11,11,11,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,3,3,3,3,3,3,3,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,3,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,7,6,6,7,6,6,7,7,7,7,7,7,7,7,7,10,10,10,10,10,10,10,7,7,7,7,7,7,7,9,9,9,9,9,7,7,7,7,7,7,7,7,7,11,11,11,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,3,3,3,3,3,3,3,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,3,3,3,3,3,3,3,6,1,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,7,7,7,7,6,6,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,10,7,7,7,7,7,9,9,9,9,9,9,9,7,7,7,7,7,7,7,7,11,11,11,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,3,3,3,3,3,3,3,3,3,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,7,7,7,7,7,9,9,9,9,9,7,7,7,7,7,7,7,7,11,11,11,11,11,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,3,3,3,3,3,3,3,3,3,3,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,7,11,11,11,11,11,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,3,3,3,3,3,3,3,3,3,3,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,7,8,8,8,8,8,8,8,7,7,11,11,11,11,11,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,3,3,3,3,3,3,3,3,3,3,3,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,7,8,8,8,8,8,8,8,7,7,7,12,11,11,11,6,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,5,3,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,1,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,10,10,10,12,12,6,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,1,1,1,1,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,1,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,10,10,10,6,12,6,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,1,1,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,3,3,3,3,3,3,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,1,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,10,10,10,10,10,12,12,1,6,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,2,2,2,2,2,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,6,3,3,3,3,3,3,3,3,3,3,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,12,12,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,6,11,7,7,10,10,10,10,10,10,10,6,6,6,6,6,2,2,2,2,2,2,2,2,2,2,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,3,3,3,3,3,3,1,1,3,3,3,3,6,6,6,6,3,3,3,3,3,3,3,3,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,12,12,7,12,7,7,7,7,12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,6,7,7,7,10,10,10,10,10,10,10,11,11,11,11,6,2,2,2,2,2,2,2,2,2,2,1,1,2,2,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,5,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,3,3,3,3,3,3,1,1,1,3,6,6,6,6,6,6,6,3,3,3,3,3,3,6,6,7,7,7,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,12,12,12,12,12,7,7,12,10,12,12,12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,7,6,7,7,7,10,10,10,10,10,10,10,12,11,11,11,11,2,2,2,2,2,2,2,2,2,2,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,1,3,6,6,6,3,3,3,3,3,3,3,3,3,6,6,6,7,7,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,1,12,7,7,12,12,12,7,7,10,10,10,10,10,12,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,7,6,6,7,7,7,10,10,10,10,10,10,10,10,11,11,12,12,6,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,5,5,5,5,5,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,3,3,3,3,3,3,3,3,6,6,6,7,7,7,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,12,12,12,2,10,7,7,10,10,10,10,10,12,12,12,7,7,7,7,7,7,7,7,7,7,8,8,8,8,7,7,7,7,7,7,7,7,7,10,10,10,10,10,10,10,10,12,12,12,12,12,11,11,11,1,1,1,11,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,4,4,4,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,1,3,3,3,3,3,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,3,3,3,3,3,3,3,6,6,6,6,6,6,7,7,7,6,7,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,12,7,7,7,7,7,7,10,10,10,10,10,10,10,10,10,7,10,10,10,10,10,10,12,12,12,7,7,7,7,7,7,7,7,8,8,8,8,8,7,7,7,7,7,1,7,7,7,10,10,10,10,10,10,10,10,10,10,11,11,12,12,11,6,6,6,6,11,11,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,6,6,6,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,5,5,5,5,5,1,5,5,5,5,5,4,4,4,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,1,3,3,3,3,3,3,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,1,3,6,3,6,6,6,6,6,6,6,7,7,7,7,7,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,12,7,7,12,7,10,10,10,10,10,10,10,10,10,10,10,10,7,7,7,10,10,10,10,10,12,12,7,7,7,7,7,7,7,7,7,7,8,8,8,8,7,7,7,12,7,7,7,6,10,10,10,10,10,10,10,10,10,10,11,12,12,12,12,12,12,12,12,11,1,1,1,2,2,2,1,1,1,1,1,1,1,7,7,1,6,1,1,1,1,1,1,1,1,1,1,6,1,6,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,5,5,1,1,1,4,4,5,5,5,4,4,4,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,5,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,12,12,12,7,7,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,12,10,10,10,10,7,10,7,7,7,7,7,7,8,8,8,7,12,12,12,7,7,7,10,10,10,10,10,10,10,10,10,10,10,6,12,12,12,12,12,12,12,12,11,11,11,1,1,1,2,1,1,1,1,1,1,1,7,7,6,7,7,7,7,7,7,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,1,12,7,7,12,12,10,7,7,10,10,10,10,10,10,10,10,10,7,10,10,10,10,10,10,10,10,10,10,12,10,10,10,10,10,10,7,7,7,7,7,7,7,8,8,8,7,7,12,12,7,7,1,10,10,10,10,10,10,10,10,10,10,10,10,10,12,12,12,12,12,12,12,6,6,11,11,1,1,1,1,1,1,1,1,1,7,7,7,7,7,7,7,7,7,7,7,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,1,12,12,6,10,10,10,10,10,7,7,10,10,10,10,10,10,10,7,7,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,7,7,7,7,10,7,7,8,8,8,7,7,12,11,11,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,12,12,12,12,12,12,12,6,6,6,6,6,6,6,1,1,1,1,6,7,7,7,7,7,7,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,3,3,3,3,3,3,3,1,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,1,1,12,6,6,10,10,10,10,10,10,10,7,10,10,10,10,10,10,10,7,12,10,10,10,10,10,12,10,10,10,10,10,10,10,10,10,10,7,7,7,7,7,7,7,8,8,8,8,1,11,12,6,11,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,12,12,12,12,12,12,12,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,12,1,12,6,10,10,10,10,10,10,10,7,7,7,10,10,10,10,10,10,10,12,10,10,10,10,10,12,10,10,10,10,10,10,10,10,10,10,10,7,7,7,7,7,8,8,8,8,11,6,11,12,6,6,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,7,12,12,12,12,12,12,12,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,1,1,1,5,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,1,1,7,7,7,7,7,7,7,7,7,7,12,12,10,10,10,10,10,10,10,10,10,10,7,7,7,10,10,10,10,10,10,12,10,10,10,10,7,12,7,7,10,10,10,10,10,10,10,10,10,7,7,7,7,7,8,8,8,8,11,11,11,12,7,7,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,1,7,7,7,7,12,12,12,12,12,12,6,7,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,7,7,7,1,1,7,7,7,7,7,7,7,7,7,12,7,7,7,10,10,10,10,10,10,10,10,7,13,13,11,11,10,10,10,10,10,12,12,10,10,10,10,12,10,7,10,10,10,10,10,10,10,7,7,10,7,7,7,7,8,8,8,8,6,6,12,11,7,7,10,10,10,10,10,10,10,10,10,10,10,7,7,7,7,7,7,7,7,7,12,12,12,12,12,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,6,6,6,6,6,6,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,2,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,7,6,7,1,1,7,7,7,7,7,7,7,7,7,12,10,10,7,10,10,10,10,10,10,10,10,7,12,13,13,11,10,10,10,10,10,10,10,10,10,10,10,10,10,7,10,10,10,10,10,10,7,7,7,7,10,7,7,7,7,7,7,7,6,11,12,11,7,7,7,10,10,10,10,10,10,10,10,10,7,7,7,7,7,7,7,7,6,12,12,12,12,12,11,11,11,11,11,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,6,6,6,6,6,6,6,1,1,1,1,6,1,1,1,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,2,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,7,7,7,1,1,1,1,7,7,7,7,7,7,7,10,10,10,7,10,10,10,10,10,10,10,7,7,12,13,10,11,11,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,11,1,11,7,7,7,10,10,10,10,10,10,7,7,7,7,7,7,7,7,7,7,7,7,11,6,6,12,12,11,11,11,11,11,6,6,6,6,6,6,6,6,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5,5,5,5,5,1,1,6,6,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,2,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,2,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,7,7,7,7,7,7,1,1,7,7,7,7,7,7,10,10,10,10,10,10,10,10,10,10,10,10,7,7,11,11,13,13,11,7,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,11,7,11,7,7,7,7,7,7,10,10,10,7,7,7,7,7,7,7,7,7,7,11,11,7,11,11,12,12,11,11,11,11,11,11,11,11,11,11,7,7,7,7,7,7,7,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,5,5,5,1,1,6,6,6,6,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,3,4,3,4,4,3,1,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,10,10,10,10,10,10,10,7,7,7,10,10,10,13,7,7,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,7,7,7,7,7,7,7,7,7,7,7,7,11,7,11,7,7,7,7,11,11,11,11,11,11,11,11,11,7,7,7,7,7,1,1,1,1,1,6,1,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,10,10,10,10,10,10,10,10,7,7,10,10,13,13,13,7,10,10,10,10,10,10,10,10,10,10,10,10,10,10,7,7,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,12,7,7,7,7,7,7,7,7,7,7,7,7,11,11,11,11,11,11,7,7,7,7,7,7,7,7,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,2,10,10,10,10,10,10,10,10,10,10,10,7,10,13,10,10,2,11,11,7,10,10,10,7,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,12,12,11,7,7,7,7,7,7,7,7,7,7,7,7,7,11,11,7,7,7,7,7,7,7,7,7,7,7,7,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,6,1,6,6,6,1,1,1,1,1,1,1,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,2,2,7,7,7,7,7,7,7,10,10,10,10,10,10,10,10,10,10,7,7,11,10,10,10,10,10,11,13,11,11,13,13,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,12,12,11,11,7,7,7,7,7,7,7,7,7,8,8,7,7,8,7,7,7,7,7,7,7,7,7,7,7,7,1,1,1,1,7,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,2,2,7,7,7,7,7,7,7,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,11,7,7,7,7,7,7,7,7,7,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,1,7,7,6,7,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,3,1,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,5,5,5,5,5,5,5,5,1,1,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,2,2,2,7,7,7,7,7,7,7,10,10,10,10,7,10,10,10,10,10,10,10,10,10,10,10,13,13,11,7,12,7,13,11,11,7,10,10,10,10,10,10,10,10,10,10,10,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,12,12,7,7,7,7,7,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,1,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,3,3,3,6,6,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,3,3,3,3,3,3,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,1,1,7,7,7,7,7,7,7,7,7,7,10,10,7,10,10,10,10,10,10,10,10,10,10,10,13,12,12,12,12,10,10,7,11,13,10,10,10,10,10,10,10,10,10,10,10,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,12,7,7,7,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,2,2,2,2,2,2,2,2,2,2,2,7,7,7,7,7,7,7,7,7,7,7,7,6,7,7,10,10,10,10,10,10,10,10,10,12,12,13,10,12,12,10,10,10,10,10,7,10,10,10,10,10,10,10,10,10,10,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,12,12,12,7,7,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,1,3,3,3,3,3,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,2,2,2,2,7,7,7,7,7,7,7,7,7,7,6,7,7,7,7,10,10,10,10,10,10,10,10,10,10,12,11,11,11,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,7,7,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,7,7,7,7,7,7,7,6,6,6,6,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,3,3,3,3,3,3,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,2,2,2,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,10,10,10,10,10,10,2,11,11,13,11,11,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,6,6,7,6,6,6,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,4,1,4,1,4,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,10,10,10,10,10,10,10,10,10,10,10,10,11,13,13,11,13,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,7,7,7,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,10,10,10,10,10,10,10,7,7,10,11,13,13,10,10,10,10,10,10,10,10,10,10,10,10,10,10,7,10,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,1,6,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,10,10,10,10,10,10,7,10,10,10,12,12,7,7,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,7,7,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,7,7,6,7,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,6,7,7,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,6,6,5,5,6,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,7,7,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,7,7,7,6,6,6,6,6,6,7,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,7,7,7,7,7,7,6,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,6,6,5,5,5,6,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,7,7,8,8,7,7,9,7,9,7,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,7,7,7,7,7,6,6,6,6,1,1,1,1,1,1,1,1,5,5,6,6,6,6,5,5,5,6,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,7,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,7,7,7,7,7,9,9,9,9,9,9,7,7,9,7,7,7,9,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,7,7,7,7,7,6,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,7,7,7,7,7,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,7,7,7,7,7,7,7,7,1,1,1,1,1,1,1,1,1,6,5,5,5,6,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,3,3,3,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,6,6,6,6,6,6,6,6,6,6,6,6,7,6,7,7,7,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,7,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,7,7,7,7,7,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,7,7,7,7,7,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,7,7,7,6,7,7,7,7,7,1,6,6,1,1,1,1,1,1,6,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,5,5,5,5,5,5,1,1,1,6,6,6,6,6,6,6,6,6,6,6,7,6,7,7,7,8,8,8,8,8,7,6,6,7,7,7,7,7,7,7,7,7,7,10,10,7,7,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,7,7,7,7,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,9,7,9,9,9,9,9,9,7,7,7,7,7,7,7,8,8,8,8,8,7,7,7,7,7,7,6,6,6,6,1,1,6,6,6,6,1,1,1,7,7,7,1,1,6,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,5,5,5,5,5,5,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,7,7,8,8,8,8,8,8,7,6,6,6,7,7,6,6,7,7,7,7,7,6,7,7,7,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,7,10,10,7,7,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,7,7,7,7,7,9,9,9,9,9,9,9,9,9,9,7,7,7,7,7,7,7,8,8,8,8,8,7,7,7,7,7,7,6,6,6,6,1,1,1,6,1,1,1,1,1,1,7,7,7,1,1,6,1,6,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,5,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,5,5,5,5,5,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,7,7,8,8,8,8,8,8,8,7,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,10,10,10,10,10,10,10,10,10,10,10,10,10,10,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,7,7,9,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,7,7,7,7,7,7,7,6,6,6,1,1,1,1,1,6,6,6,6,6,6,6,6,6,1,1,1,6,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,5,5,5,5,5,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,7,7,8,8,8,8,8,8,8,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,7,10,10,10,10,10,10,10,10,10,10,7,7,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,10,10,10,10,10,2,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,7,7,7,7,7,6,6,6,6,7,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,7,7,7,8,8,8,8,8,8,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,7,7,10,10,10,10,10,10,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,10,7,7,7,7,7,2,10,10,10,10,10,10,7,7,7,7,7,7,7,7,10,10,10,10,10,10,10,10,10,10,10,10,10,10,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,7,7,7,7,6,6,6,6,6,7,7,1,1,1,1,7,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,6,6,6,6,6,6,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,7,1,1,8,8,8,8,8,8,6,6,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,6,6,6,6,7,7,1,1,1,1,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,6,6,6,6,6,6,6,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,1,1,1,1,8,7,8,8,8,8,6,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,12,10,12,12,10,10,10,10,10,10,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,6,6,6,7,7,7,7,1,1,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,5,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,1,1,1,1,1,1,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,2,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,12,12,12,12,12,12,12,10,10,10,10,10,10,7,7,7,7,7,7,7,7,8,7,8,8,8,8,8,8,8,8,8,6,8,6,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,3,3,3,3,6,3,3,1,1,1,6,6,6,6,6,6,6,1,1,1,7,1,1,1,7,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,12,12,12,12,12,12,10,10,10,10,10,10,10,10,10,10,10,12,12,12,14,14,14,14,14,14,12,12,10,10,10,10,10,10,10,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,6,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,3,3,3,6,6,3,3,3,3,3,3,3,6,6,6,6,1,1,6,7,7,7,1,7,1,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,12,14,14,14,14,14,14,14,14,14,10,10,10,10,10,10,10,10,12,14,14,14,14,14,14,14,14,14,14,12,12,10,10,10,10,10,10,10,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,6,6,1,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,3,3,3,6,6,6,3,3,3,3,3,3,3,3,3,1,1,6,6,7,7,7,7,1,1,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,12,12,12,14,14,14,14,14,14,14,14,14,14,12,12,12,12,11,11,11,14,14,14,14,14,14,14,14,14,14,14,14,12,12,12,10,10,10,10,10,10,10,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,6,1,1,1,6,1,6,6,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,3,3,3,3,3,6,6,3,3,3,3,3,3,3,3,3,1,6,6,6,7,7,7,7,7,1,1,8,8,8,8,8,8,8,8,8,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,7,7,7,7,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,12,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,12,12,12,10,10,10,10,10,10,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,5,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,6,6,6,3,3,3,3,3,3,3,3,3,6,6,6,6,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,7,7,7,7,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,15,14,14,12,12,10,10,10,10,10,10,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,9,7,7,7,7,7,7,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,6,3,3,3,3,3,3,3,3,3,3,3,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,7,7,9,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,14,14,14,14,14,14,14,14,15,15,14,14,14,16,16,16,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,14,14,14,14,14,10,10,10,10,10,10,10,10,7,7,8,8,8,8,8,8,8,8,8,8,8,8,7,7,9,9,9,9,9,9,9,9,9,9,7,7,7,7,7,7,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,6,3,3,3,3,3,3,3,3,3,3,3,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,9,9,9,9,9,9,9,9,9,8,8,8,8,8,7,7,8,8,8,8,8,8,8,8,7,7,9,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,14,14,14,14,14,14,14,15,15,15,15,14,14,14,16,16,16,16,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,14,14,14,14,14,14,2,10,10,10,10,10,10,7,7,7,7,8,8,8,8,8,8,7,7,7,7,7,7,6,9,9,9,9,9,9,9,9,9,7,7,7,7,7,7,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,6,6,6,6,6,7,6,7,7,7,7,7,7,7,7,7,9,9,9,9,9,9,9,9,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,14,14,14,14,14,14,15,15,15,15,15,14,14,14,14,16,16,16,16,16,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,15,14,14,14,14,14,14,14,14,12,2,10,10,10,10,7,7,7,7,8,8,8,8,8,8,7,7,7,7,7,6,6,6,6,6,9,9,9,9,9,9,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,1,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,6,6,6,6,6,7,6,7,7,7,7,7,7,7,7,7,9,9,9,9,9,9,9,9,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,14,14,15,15,14,14,14,15,15,15,15,15,15,15,15,14,14,14,16,16,16,16,16,16,16,16,16,16,16,16,14,14,14,14,14,15,15,14,14,14,14,14,14,14,14,14,12,12,10,10,10,10,7,7,7,8,8,8,8,8,8,8,7,7,6,6,6,6,6,6,6,8,9,9,9,9,9,9,9,9,9,7,7,7,6,6,6,6,6,6,6,6,6,6,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,9,9,9,9,9,9,9,9,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,14,14,14,15,15,14,14,14,14,14,14,15,15,15,15,15,15,15,14,16,16,16,16,16,16,16,16,16,16,16,16,16,16,14,14,15,15,15,14,14,14,14,14,14,14,14,14,12,12,10,10,10,10,7,7,8,8,8,8,8,8,8,8,7,7,6,6,6,6,6,6,8,8,9,9,9,9,9,9,9,9,9,7,7,7,6,6,6,6,6,6,6,6,6,6,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,6,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,9,9,9,9,9,9,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,12,14,14,15,15,15,14,14,14,14,14,14,14,14,14,14,15,15,15,16,16,16,14,16,16,16,16,16,16,16,16,16,16,15,15,15,15,15,15,15,15,15,15,14,14,14,14,14,12,12,10,10,10,7,7,7,8,8,8,8,8,8,8,7,7,7,7,6,6,6,7,8,8,8,9,9,9,9,9,9,9,9,9,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,6,6,3,3,3,3,6,6,6,6,7,7,6,6,6,6,6,6,7,7,7,9,9,9,9,9,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,12,14,14,15,15,14,14,14,14,14,14,14,14,14,14,14,14,14,15,16,16,16,14,16,16,16,16,16,16,16,16,15,15,15,15,15,15,15,15,15,15,15,15,15,14,14,14,14,12,12,2,10,10,10,7,7,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,8,8,8,8,7,9,9,9,9,9,9,9,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,6,3,6,6,3,3,3,3,3,6,6,6,7,7,7,7,7,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,12,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,16,16,16,16,16,16,16,16,16,16,16,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14,14,14,14,14,12,12,10,10,10,10,7,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,9,9,9,9,9,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,6,6,6,3,3,3,3,3,3,6,6,6,7,7,7,7,7,6,6,7,6,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,9,9,9,9,9,7,7,7,7,7,7,7,7,7,2,10,10,10,10,10,12,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,16,16,16,16,16,16,16,16,16,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14,14,14,14,14,14,12,10,10,10,10,10,8,7,8,8,8,7,8,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,9,9,9,9,9,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,1,1,6,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,6,6,6,3,3,3,3,3,6,6,6,6,6,7,7,7,7,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,10,10,10,10,2,14,14,14,14,14,14,14,15,15,15,14,14,14,14,14,14,14,14,14,14,14,16,16,16,16,16,16,16,16,16,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14,14,14,14,14,14,14,12,12,10,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,9,9,9,9,9,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,6,6,3,3,3,3,3,3,3,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,7,7,7,7,7,7,7,7,2,10,10,10,10,2,14,14,14,14,14,14,14,15,15,15,15,15,15,15,14,14,14,14,14,14,14,14,16,16,16,16,16,16,16,16,16,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14,14,14,14,14,14,14,14,12,2,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,9,9,9,9,9,7,6,7,7,7,7,7,7,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,6,3,6,3,3,3,3,3,3,3,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,9,9,9,8,8,8,8,9,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,2,12,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,14,14,14,14,14,16,16,16,16,16,16,16,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14,14,14,14,14,14,14,14,14,12,12,10,10,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,6,6,6,6,6,6,7,7,7,7,7,7,1,1,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,6,6,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,5,6,6,6,5,3,3,3,3,3,3,3,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,9,9,9,9,7,7,7,9,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,12,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14,14,14,14,16,16,16,16,16,16,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14,14,14,14,14,14,14,14,14,12,12,12,12,10,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,1,1,1,1,7,7,7,7,7,7,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,1,5,5,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,5,6,6,6,5,3,3,3,3,3,3,3,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,9,9,9,9,7,7,9,9,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14,14,14,16,16,16,16,16,16,15,15,15,15,15,15,15,15,15,15,15,14,15,15,15,15,15,14,14,14,14,14,14,14,14,14,14,14,12,12,10,10,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,1,1,1,1,1,7,7,7,7,7,7,1,1,1,1,1,1,6,6,6,7,7,7,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,5,5,6,6,5,3,3,3,3,3,3,3,3,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,9,9,9,9,7,7,9,9,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14,14,14,16,16,16,15,15,15,15,15,15,15,15,15,15,16,16,14,14,14,15,15,15,14,14,14,14,14,14,14,14,14,14,14,14,14,14,10,10,10,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,7,7,6,6,6,6,6,1,1,7,1,1,1,1,1,1,7,7,7,7,7,7,7,7,7,1,1,1,6,6,6,6,7,7,7,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,5,5,6,5,5,3,3,3,3,3,3,3,3,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,14,14,14,14,14,14,15,15,14,15,15,15,15,15,15,15,15,15,15,15,15,15,14,14,14,14,16,15,15,15,15,15,15,15,15,15,16,16,16,16,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,2,10,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,7,1,1,1,1,1,1,1,1,1,7,7,7,7,7,7,7,7,7,1,1,6,6,6,7,6,6,7,7,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,3,3,3,3,6,6,6,3,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,9,9,9,9,9,9,9,9,9,9,9,9,7,7,7,7,7,7,7,10,10,7,7,7,10,10,10,10,10,14,14,14,14,14,14,14,14,15,15,15,15,15,15,16,16,16,15,15,15,15,15,14,14,14,14,15,15,15,15,15,15,15,15,15,16,16,16,16,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,7,10,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,1,1,1,1,1,1,1,1,1,7,7,7,7,6,6,6,6,7,1,1,6,6,6,6,7,7,6,7,7,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,3,3,3,3,3,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,9,9,9,9,9,9,9,9,7,7,7,7,7,7,10,10,10,10,10,7,7,10,10,10,10,10,14,14,14,14,14,14,14,15,15,15,15,15,15,16,16,16,16,16,15,15,15,15,14,14,14,15,15,15,15,15,15,15,15,15,15,16,16,16,16,16,16,14,14,14,14,14,14,14,14,14,14,14,16,16,14,14,14,14,14,14,14,14,12,10,10,10,10,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,7,7,7,7,6,7,7,1,7,7,7,7,1,1,1,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,5,5,1,1,3,3,3,3,5,3,3,3,1,3,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,9,9,9,9,9,9,9,7,7,7,7,7,7,7,10,10,10,10,7,7,7,10,10,10,10,10,14,14,14,14,14,14,14,15,15,15,15,15,15,16,16,16,16,16,15,15,15,14,14,14,14,15,15,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,14,14,14,14,14,14,14,16,16,16,16,16,14,14,16,16,16,14,14,14,12,10,10,10,10,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,7,7,7,8,7,7,8,7,7,7,7,1,1,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,1,3,3,3,3,1,3,3,1,1,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,3,3,3,3,3,1,1,1,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,9,9,9,9,9,9,7,7,7,7,7,7,7,7,10,10,10,10,7,7,7,10,10,10,10,10,14,14,14,14,14,14,14,15,15,15,15,15,15,15,16,16,16,16,15,14,14,14,14,14,14,15,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,16,16,14,14,14,16,16,16,16,16,16,16,14,14,16,16,16,16,14,14,14,12,10,10,10,10,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,3,3,3,3,3,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,9,9,9,9,9,7,7,7,7,7,7,10,10,10,10,10,7,7,7,7,7,10,10,10,10,10,14,14,14,14,14,14,14,15,15,15,15,15,15,15,16,16,16,16,14,14,14,14,14,14,14,14,15,15,15,15,15,15,16,16,16,16,16,16,16,16,16,16,16,16,14,14,16,16,16,16,14,14,14,16,16,16,16,16,14,14,14,14,12,12,10,10,10,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,6,6,6,6,6,6,6,6,7,7,7,7,7,6,6,6,6,6,7,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,9,9,9,9,9,9,7,7,7,7,7,7,7,10,10,10,10,10,7,7,7,7,7,10,10,10,10,10,14,15,14,14,14,14,14,15,15,15,15,15,15,15,16,16,16,16,16,14,14,16,14,14,14,14,14,14,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,14,14,16,16,16,14,14,14,14,16,16,16,14,14,14,14,14,14,12,12,10,10,10,10,7,7,7,7,7,7,7,7,7,7,7,8,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,7,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,2,10,10,14,15,15,15,14,14,14,14,15,15,15,14,15,15,16,16,16,16,16,16,16,16,14,14,14,14,14,14,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,14,14,14,16,16,16,14,14,16,16,14,14,14,14,14,14,14,14,12,12,10,10,10,10,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,6,6,1,1,6,1,1,1,1,1,4,4,4,4,4,4,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,4,4,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,10,10,14,14,14,15,15,14,14,14,14,14,14,14,15,15,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,14,14,14,14,14,16,16,16,16,16,16,14,14,14,14,14,14,14,14,12,12,10,10,10,10,7,7,7,7,7,7,7,7,7,7,7,7,8,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,7,7,7,7,7,6,6,6,6,6,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,3,3,1,1,3,1,1,1,1,1,1,5,5,5,1,5,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,7,7,7,7,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,10,10,14,14,14,14,15,14,14,14,14,14,14,15,15,15,14,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,14,14,14,14,14,14,14,14,14,14,16,16,16,16,16,14,14,14,14,14,14,14,14,14,14,12,10,10,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,6,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,6,6,6,6,6,6,6,6,7,7,7,7,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,10,10,2,14,14,14,14,15,14,14,14,14,14,14,15,15,15,14,14,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,14,14,14,14,14,14,14,14,14,14,16,16,16,16,14,14,14,14,14,14,14,14,14,14,14,12,12,10,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,6,6,6,1,1,1,6,6,6,6,6,6,6,7,7,7,7,7,7,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,10,10,14,14,14,14,14,15,15,14,14,14,14,14,16,16,16,14,14,14,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,12,12,10,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,6,1,6,6,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,1,1,1,1,6,6,6,6,6,6,7,7,7,7,7,7,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,12,14,14,14,14,14,14,15,15,15,14,14,14,16,16,16,16,16,14,14,14,14,14,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,14,14,14,14,14,14,14,16,16,16,14,12,12,10,10,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,1,6,6,6,6,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,5,5,1,5,5,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,5,1,5,1,1,6,6,6,6,6,6,6,7,7,7,7,7,7,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,14,14,14,14,14,14,14,14,15,15,14,14,14,16,16,16,16,16,16,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,14,14,14,14,16,16,16,16,14,12,10,10,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,5,5,5,1,1,1,1,6,6,6,6,6,6,7,7,7,7,7,7,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,12,14,14,14,14,14,14,14,15,15,15,14,16,16,16,16,16,16,16,16,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,14,14,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14,14,14,14,16,16,16,16,14,10,10,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,7,7,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,5,5,5,6,5,6,6,6,6,6,5,5,5,1,1,1,1,6,6,6,6,6,6,6,7,7,7,7,7,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,12,14,14,14,14,14,14,14,14,15,15,16,16,16,16,16,16,16,16,16,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14,14,14,14,14,16,16,16,14,14,10,10,10,7,7,7,7,7,7,7,7,7,10,7,7,7,7,7,8,8,8,8,8,7,7,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,6,6,5,5,5,1,1,1,1,1,6,6,6,6,6,6,6,7,7,7,7,7,6,7,7,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,12,14,14,14,14,14,14,14,14,14,14,16,16,16,16,16,16,16,16,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14,14,14,14,14,14,16,16,14,14,10,10,10,7,7,7,7,7,7,7,7,10,10,10,7,7,7,7,7,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,5,5,5,1,1,1,1,1,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,14,14,14,14,14,14,14,14,16,16,16,16,16,16,16,16,16,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14,14,14,14,14,14,14,16,16,16,14,7,10,10,10,7,7,7,7,7,7,7,7,10,7,7,7,7,7,7,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,12,14,14,14,14,14,14,15,15,16,16,16,16,16,16,16,16,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14,14,14,14,14,14,14,14,14,16,16,16,14,10,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,7,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,10,10,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,4,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,6,6,6,6,6,6,6,7,6,7,7,7,7,7,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,12,14,14,14,14,14,14,15,15,16,16,16,16,16,16,16,16,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14,14,14,14,14,14,14,14,14,14,16,16,16,14,2,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,10,10,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,6,6,6,6,7,7,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,2,10,10,10,10,12,14,14,14,14,14,14,15,15,15,16,16,16,16,16,16,16,16,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14,14,14,14,14,14,14,14,14,14,14,14,14,14,16,16,14,14,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,10,10,10,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,12,14,14,14,14,14,14,15,15,15,15,15,15,15,16,16,16,16,14,14,14,14,14,15,15,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,10,10,10,10,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,4,4,4,4,4,4,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,12,14,14,14,14,14,16,15,15,15,15,15,15,15,16,16,16,16,14,14,14,14,15,15,14,15,15,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,12,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,7,7,7,7,7,7,10,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,4,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,3,3,3,3,3,3,3,3,1,3,1,1,1,1,1,1,7,7,7,6,8,8,8,8,8,8,8,8,8,8,8,8,7,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,12,14,14,14,14,14,14,16,15,15,15,15,15,15,15,16,16,16,16,14,14,15,15,15,15,15,15,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,12,10,7,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,7,7,7,7,7,7,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,1,3,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,1,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,7,7,7,6,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,2,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,16,16,16,16,16,15,15,15,15,15,15,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,12,10,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,7,7,7,7,7,7,7,7,7,7,10,10,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,5,5,5,5,5,5,5,5,5,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,7,7,6,6,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,10,12,14,14,14,14,14,14,15,15,15,15,15,15,15,15,16,16,16,16,16,16,14,15,15,15,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,15,14,14,14,14,14,14,14,14,14,14,14,14,14,14,11,10,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,7,7,7,7,7,7,7,7,7,7,10,10,10,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,5,5,5,5,5,5,5,5,5,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,7,1,6,6,6,6,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,2,12,14,14,14,14,14,15,15,15,15,15,15,15,15,15,16,16,16,16,16,16,14,15,15,15,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14,14,14,14,14,14,14,14,14,14,14,14,14,14,11,7,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,7,7,7,7,7,7,7,7,7,7,10,10,10,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,3,3,3,3,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,5,5,5,5,5,5,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,6,6,6,6,6,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,12,12,14,14,14,14,16,15,15,15,15,15,15,15,15,15,16,16,16,16,16,16,16,15,15,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14,14,14,14,14,14,14,14,14,14,14,14,14,14,11,10,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,1,6,1,1,1,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,3,3,3,3,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,6,6,6,6,6,8,6,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,12,12,14,14,14,14,14,16,16,16,15,15,15,15,15,15,15,16,16,16,16,16,16,15,15,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,11,10,10,10,7,7,7,7,7,7,7,7,7,7,7,8,7,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,6,6,1,1,1,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,1,1,3,3,3,3,3,3,3,1,1,3,1,1,3,3,3,3,3,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,7,7,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,12,12,12,14,14,14,14,14,14,16,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,15,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,11,10,10,10,10,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,1,1,3,3,3,3,3,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,5,5,5,5,5,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,10,10,10,12,14,14,14,14,14,16,16,15,15,15,15,15,15,16,16,16,16,16,16,16,16,16,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,12,10,10,10,10,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,7,7,7,7,7,7,7,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,7,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,10,10,12,14,14,14,14,14,16,16,15,15,15,15,15,16,16,16,16,16,16,16,16,16,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,12,10,10,10,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,7,7,7,7,7,7,10,10,10,10,1,1,1,1,7,1,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,10,14,14,14,14,14,16,16,15,15,15,15,15,16,16,16,16,16,16,16,16,16,16,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,12,10,10,10,10,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,7,7,7,7,7,10,10,10,1,1,1,1,1,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,10,12,14,14,14,14,16,16,15,15,15,15,15,16,16,16,16,16,16,16,16,16,16,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,12,10,10,10,10,10,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,7,10,7,7,7,10,10,10,10,1,1,1,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,3,1,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,12,14,14,14,14,14,16,16,15,15,15,15,15,16,16,16,16,16,16,16,16,16,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,12,12,12,10,10,10,10,10,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,7,7,7,7,7,10,10,10,10,10,1,6,6,6,6,7,6,6,6,6,6,6,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,12,12,14,14,14,14,16,16,15,15,15,15,15,15,16,16,16,16,16,16,16,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,12,12,12,10,10,10,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,7,6,6,6,6,7,7,7,7,7,6,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,3,3,3,3,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,3,3,3,3,3,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,7,7,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,10,10,12,14,14,14,14,16,15,15,15,15,15,15,15,16,16,16,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,12,10,10,10,10,10,7,7,7,7,7,7,7,7,8,8,8,8,8,8,7,7,7,7,7,7,10,7,10,10,10,10,10,7,10,10,7,10,10,7,7,10,10,7,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,7,7,7,7,7,7,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,1,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,3,3,3,3,3,3,3,3,3,3,3,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,7,7,7,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,10,10,10,14,14,14,14,14,14,15,15,15,15,15,15,14,14,14,14,14,13,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,12,12,10,10,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,7,10,7,10,10,10,10,10,7,7,7,7,7,7,7,7,7,7,10,10,7,10,10,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,7,7,7,7,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,3,3,3,3,3,3,3,3,3,3,3,5,5,5,5,5,3,3,1,1,5,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,7,7,6,6,6,7,7,7,7,7,1,7,7,7,7,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,10,7,10,10,10,10,10,10,12,14,14,14,14,14,15,15,15,15,15,15,15,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,14,14,14,15,15,15,15,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,12,12,12,10,10,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,7,7,7,7,7,7,7,12,12,12,12,7,7,7,7,10,10,7,10,10,7,7,7,7,7,7,7,7,6,6,7,7,6,7,6,6,6,6,6,6,6,7,7,7,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,3,1,1,1,1,5,5,5,5,5,5,5,5,3,3,3,3,3,3,3,3,3,3,3,5,5,5,5,5,3,3,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,7,7,7,7,7,1,1,1,7,7,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,12,14,14,14,14,14,14,15,15,15,15,15,15,15,14,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,14,15,15,15,15,15,15,14,14,14,14,14,14,14,14,14,14,14,14,14,14,12,12,12,12,10,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,7,7,7,12,12,12,12,12,7,7,7,7,7,7,7,7,10,10,10,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,5,5,5,5,5,5,5,5,3,3,3,3,3,3,3,3,3,3,3,5,5,5,5,5,3,3,3,3,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,7,7,7,1,1,1,7,9,9,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,1,10,10,10,10,10,12,14,14,14,14,14,14,15,15,15,15,15,15,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14,14,14,14,14,14,14,14,14,14,14,14,14,12,12,12,12,7,10,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,7,7,12,12,7,7,7,7,7,10,10,7,7,7,7,7,7,7,10,10,7,7,7,7,7,7,7,7,6,6,6,6,6,7,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,5,5,5,5,5,5,1,1,3,3,3,3,3,3,3,3,3,3,1,1,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,7,7,7,1,1,1,7,9,9,9,9,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,2,10,10,10,10,10,14,14,14,14,14,14,14,15,15,15,15,15,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14,14,14,14,14,14,14,14,14,14,14,14,12,12,12,12,7,7,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,7,7,7,12,12,12,7,7,7,7,7,7,10,10,7,7,7,7,7,7,7,10,7,7,7,7,7,7,7,7,7,7,6,6,6,7,7,7,7,7,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,1,1,1,1,1,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,7,7,1,1,1,7,9,9,9,9,9,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,12,14,14,14,14,14,14,14,15,15,15,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14,14,14,14,14,14,14,14,14,14,14,14,12,12,12,12,12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,7,7,12,12,7,12,12,12,12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,7,7,7,7,7,7,6,6,7,7,7,7,7,7,7,6,6,6,6,6,6,6,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,1,1,3,1,1,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,1,1,1,1,7,9,9,9,9,9,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,12,12,14,14,14,14,14,14,14,14,14,14,14,15,15,14,14,14,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14,14,14,14,14,14,14,14,14,14,14,14,14,14,12,12,12,12,12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,12,7,7,7,11,11,11,7,7,12,12,12,12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,7,7,7,7,7,6,6,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,1,1,1,1,7,9,9,9,9,9,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,12,12,12,14,14,14,14,14,14,14,14,14,14,15,15,15,15,14,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,12,12,12,12,12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,12,12,11,11,11,7,7,12,12,12,12,7,12,12,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,7,7,7,7,7,6,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,1,1,1,1,1,6,6,5,5,5,5,5,5,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,4,4,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,1,1,1,1,7,7,7,7,7,7,7,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,2,2,12,14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,12,12,12,12,12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,7,7,7,7,7,7,7,12,12,7,7,12,12,7,7,11,7,7,7,7,7,7,7,7,7,7,7,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,1,1,1,6,6,6,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,7,7,7,7,7,7,7,7,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,2,12,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,15,14,14,14,15,15,15,15,15,15,15,15,15,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,12,12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,7,7,7,7,7,7,7,7,7,7,12,7,7,7,11,11,11,11,7,7,7,7,7,7,7,7,7,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,1,1,1,6,6,6,1,6,5,5,5,5,5,5,5,5,5,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,17,1,1,7,7,7,7,7,7,7,7,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,10,12,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,14,14,14,14,15,15,15,15,15,15,15,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,12,12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,7,7,10,10,7,7,7,7,12,7,12,11,11,11,11,11,7,11,11,11,11,7,7,7,7,7,7,7,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,1,1,1,1,1,6,6,6,6,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,6,6,7,1,7,7,7,7,7,7,7,7,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,12,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,15,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,12,12,12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,7,7,7,10,10,7,7,7,7,12,7,12,11,11,11,11,7,7,11,12,12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,6,6,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,3,1,3,3,3,3,3,3,3,3,1,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,12,12,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,12,12,12,12,12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,7,7,7,7,10,10,7,7,7,7,12,7,12,7,11,11,7,7,7,7,7,12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,9,9,9,9,9,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,2,10,10,10,10,10,12,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,12,12,12,12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,7,7,7,7,10,10,7,7,7,7,12,7,7,12,12,12,7,7,7,7,7,12,12,12,12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,5,5,5,6,6,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,6,6,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,12,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,15,14,14,14,14,14,14,14,14,12,12,12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,7,7,7,10,10,7,7,7,7,7,12,12,12,12,7,7,12,12,12,7,7,7,7,12,12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,1,6,6,1,6,6,6,1,1,6,6,6,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,6,6,6,6,6,6,7,7,7,7,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,2,10,10,10,10,2,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,14,14,14,14,14,14,15,7,12,12,12,12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,12,12,12,7,12,12,12,12,12,7,7,7,12,12,12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,1,1,1,1,1,1,1,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,1,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,7,6,6,6,6,6,6,7,7,7,8,8,8,8,8,8,8,8,8,8,8,7,8,7,7,8,7,7,7,7,7,7,7,7,7,7,7,2,10,10,10,10,2,12,10,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,15,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,12,12,12,12,7,7,11,12,12,12,7,12,7,7,7,12,12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,7,7,7,7,6,1,1,1,1,1,1,6,6,6,6,6,6,1,1,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,6,7,7,7,6,6,6,6,6,6,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,12,12,14,14,14,14,14,15,15,15,15,15,14,14,14,14,14,15,15,15,15,15,15,12,12,12,12,12,11,11,11,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,7,7,7,7,7,7,7,12,12,12,12,12,11,11,7,12,7,12,7,7,7,7,7,11,11,11,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,7,6,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,6,7,6,6,6,6,6,6,6,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,2,10,10,10,10,10,10,12,14,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,2,10,10,12,12,12,11,11,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,7,7,7,7,10,7,7,7,7,12,12,7,11,11,11,11,12,12,7,7,7,7,7,11,7,7,11,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,7,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,1,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,8,8,8,7,7,7,7,7,7,7,7,7,2,10,10,10,10,10,10,1,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,10,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,7,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,7,10,7,7,7,7,12,12,7,11,11,7,7,7,7,7,7,7,7,7,11,11,11,7,12,12,12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,2,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,7,7,7,7,7,12,12,12,12,7,7,7,7,7,7,7,7,7,7,11,11,12,12,12,12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,1,1,6,6,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,1,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,2,2,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,7,8,7,7,7,7,7,7,7,7,7,7,10,10,10,7,7,7,7,7,7,12,12,7,7,7,7,12,12,12,12,7,7,7,11,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,1,6,1,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,1,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,6,6,6,6,6,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,10,7,7,7,7,7,7,7,7,12,12,7,7,7,12,12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,7,7,7,7,7,7,7,8,8,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,10,10,10,10,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,10,10,7,7,7,7,7,7,7,7,12,12,12,12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,7,7,7,7,7,7,7,8,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,7,7,7,7,7,7,7,7,7,12,7,7,7,10,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,7,7,7,7,7,7,7,12,12,12,12,7,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,1,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,12,12,12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,7,7,7,7,7,10,10,10,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,10,10,7,7,7,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,7,7,7,7,7,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,7,7,7,7,7,7,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,7,6,6,6,6,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,7,7,7,8,7,7,7,8,9,9,8,8,7,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,7,7,7,9,9,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,7,7,9,9,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,7,7,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,7,7,7,7,9,9,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,10,10,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,7,7,7,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,7,7,7,9,9,9,9,9,9,9,9,9,9,9,7,7,7,7,7,7,7,10,10,10,10,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,9,9,9,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,7,7,7,7,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,1,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,4,4,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,7,8,7,7,9,7,9,9,9,9,9,9,9,9,9,9,7,7,7,7,7,7,7,7,10,10,10,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,9,9,9,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,7,7,7,7,6,6,6,6,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,9,9,9,9,9,9,9,9,9,9,7,7,7,7,7,7,7,10,10,10,10,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,9,9,9,9,9,9,9,9,9,9,7,7,7,7,7,7,7,1,1,7,7,7,7,7,7,7,7,6,7,7,6,6,6,6,6,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,9,9,9,9,9,9,9,9,7,7,7,7,7,7,7,7,10,10,10,10,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,7,7,7,7,7,7,7,7,9,9,9,9,9,9,9,9,9,9,9,9,9,7,7,7,7,7,1,1,1,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,6,6,6,6,1,6,6,6,6,6,6,6,6,6,6,6,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,9,9,9,9,9,9,9,9,9,9,9,9,7,7,7,7,7,1,6,1,1,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,6,6,1,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,8,7,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,9,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,9,9,9,9,9,9,9,9,9,9,9,9,7,6,6,6,6,6,6,7,1,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,6,6,6,6,6,6,6,6,7,6,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,8,7,7,8,7,7,8,7,7,7,8,8,8,7,8,8,7,8,8,7,7,7,8,7,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,9,7,7,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,9,9,9,9,9,9,9,9,9,9,9,7,7,6,6,6,6,7,7,1,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,7,7,7,7,7,1,7,7,6,6,6,6,6,6,6,6,6,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,6,8,8,8,8,8,8,7,7,7,7,7,7,9,9,9,9,9,9,9,9,7,7,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,1,1,1,1,1,1,6,6,6,6,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,8,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,6,6,6,8,8,8,8,8,7,7,7,7,7,7,9,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,7,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,1,1,1,1,1,1,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,6,7,7,7,7,7,7,7,7,8,7,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,8,8,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,9,9,9,9,9,7,7,7,7,7,7,7,8,8,8,8,8,7,7,7,7,7,7,7,7,7,6,6,6,7,7,7,7,7,7,6,1,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,1,1,6,6,7,7,7,7,7,7,7,7,8,8,7,8,8,8,8,8,8,8,7,7,7,7,9,9,9,9,9,8,8,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,12,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,1,1,1,3,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,1,1,1,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,7,7,7,7,9,9,9,9,9,8,8,8,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,7,7,7,7,7,7,7,12,12,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,7,6,6,6,6,6,6,6,6,6,6,6,6,7,6,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,1,1,1,6,6,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,7,7,7,7,9,9,9,9,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,7,7,7,7,7,7,7,7,7,12,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,6,7,7,6,7,7,7,7,7,7,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,7,7,7,1,1,6,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,7,7,7,9,9,9,9,9,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,9,9,7,7,7,7,7,7,7,7,12,7,7,7,7,8,8,8,7,8,8,8,8,8,8,8,8,8,8,8,7,7,7,6,6,6,6,6,7,7,7,7,7,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,1,1,1,1,1,7,7,7,6,6,1,6,6,6,6,6,6,6,7,7,7,7,7,8,8,8,8,8,8,8,8,8,7,7,7,9,9,9,9,9,9,9,9,8,8,8,8,8,8,8,8,8,8,8,8,8,7,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,9,9,7,7,7,7,7,7,7,12,12,12,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,6,6,6,6,6,6,7,7,7,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,7,7,7,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,8,8,8,8,8,8,8,8,7,7,9,9,9,9,9,9,9,9,9,9,8,8,8,8,8,8,8,8,8,7,8,7,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,9,9,1,7,7,7,7,7,7,7,12,12,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,7,7,7,7,7,7,6,6,6,6,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,8,8,7,7,7,7,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,8,8,8,8,8,8,8,7,7,9,9,9,9,9,9,9,9,9,9,8,8,8,8,8,8,8,8,8,7,8,7,8,8,7,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,9,7,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,18,18,18,9,9,9,7,7,7,7,7,7,7,12,12,7,7,7,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,8,7,7,7,7,8,8,8,8,8,8,8,8,8,7,8,7,8,8,8,8,7,7,7,7,7,7,7,7,7,6,7,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,7,7,1,1,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,7,7,9,9,9,9,9,9,9,9,9,9,9,9,7,8,8,8,8,8,8,7,7,7,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,18,7,7,7,7,18,18,18,9,9,9,9,9,7,7,7,7,7,7,7,12,7,7,7,7,7,7,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,7,7,8,8,8,8,8,8,7,7,7,7,8,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,2,2,2,2,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,7,7,1,6,1,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,7,9,9,9,9,9,9,9,9,9,9,7,7,7,7,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,9,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,18,18,7,7,7,18,18,7,9,9,9,9,9,9,9,7,7,7,6,6,6,6,7,7,7,7,7,7,7,7,7,7,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,7,7,7,8,8,8,8,8,8,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,7,6,1,1,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,7,7,9,9,9,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,9,9,9,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,18,18,18,7,7,12,12,10,10,9,9,9,9,9,1,7,1,1,6,6,2,2,7,7,7,1,7,7,7,7,7,7,9,9,9,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,7,7,7,6,6,7,7,7,7,7,8,8,8,8,8,7,7,9,9,9,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,9,9,9,9,9,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,18,7,10,10,10,10,10,10,9,9,9,9,1,7,7,1,2,2,2,2,2,1,7,7,7,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,7,7,7,7,7,8,8,8,8,8,8,8,6,6,6,7,7,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,3,1,3,3,3,3,3,3,1,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,6,6,6,7,6,6,6,7,7,7,7,7,8,8,8,8,8,7,7,9,9,9,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,9,9,9,9,9,9,9,9,9,9,8,8,8,7,8,7,7,7,7,7,7,7,7,7,7,7,12,10,10,10,10,10,10,9,9,9,9,1,7,7,6,2,2,2,2,2,2,2,7,7,7,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,9,9,7,7,9,9,7,7,7,7,8,8,8,8,8,8,8,8,8,7,7,7,7,7,8,8,8,8,8,8,8,6,6,6,7,7,8,8,7,7,7,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,7,7,7,7,7,8,8,8,8,8,7,7,7,9,9,9,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,9,9,9,9,9,9,9,9,9,9,9,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,12,10,10,10,10,10,10,9,9,9,9,7,6,6,6,2,2,2,2,2,2,1,7,7,7,8,8,8,8,8,8,7,7,9,9,9,9,9,9,9,9,9,9,9,9,9,7,7,7,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,8,8,8,8,8,6,7,7,7,6,7,7,7,7,7,7,7,7,8,8,8,8,8,7,7,7,7,7,6,6,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,7,7,7,7,7,7,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,9,9,9,7,7,7,7,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,2,10,10,10,10,10,10,10,10,7,9,9,1,7,7,7,6,6,2,2,2,2,2,1,7,7,7,7,8,8,8,8,8,8,9,7,9,9,9,9,9,9,9,9,9,9,9,9,9,7,7,7,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,7,7,7,6,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,6,1,6,6,1,1,1,1,1,1,1,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,9,9,9,7,7,7,7,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,10,10,10,10,10,10,10,10,7,7,9,9,1,2,1,2,2,2,2,2,2,2,2,1,7,7,7,7,7,8,8,8,8,8,8,7,8,7,9,9,9,9,9,9,9,9,9,9,9,7,7,7,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,7,7,7,7,7,7,7,7,6,6,7,7,6,6,9,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,6,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,9,9,9,7,7,7,7,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,10,10,10,10,10,7,7,7,7,7,1,7,2,2,2,2,2,2,1,2,2,2,2,7,7,7,7,7,7,8,8,8,8,8,8,8,7,7,7,7,9,9,9,9,9,9,9,9,9,9,7,7,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,1,1,7,7,7,7,7,7,6,6,7,7,6,9,9,12,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,6,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,6,6,7,7,7,7,7,7,7,7,7,7,7,7,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,10,12,10,7,7,7,7,7,7,7,2,2,2,2,2,7,7,2,2,2,2,7,7,7,7,7,7,8,8,8,8,8,8,8,8,7,7,7,7,7,9,9,9,9,9,9,9,9,7,7,7,7,7,7,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,12,12,12,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,6,6,7,7,7,7,7,7,7,7,7,7,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,12,7,7,7,7,7,7,7,2,2,2,2,2,7,7,18,2,2,2,2,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,7,7,7,7,7,9,9,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,7,12,12,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,6,6,6,6,1,1,6,1,1,1,1,1,1,1,1,1,1,1,6,6,6,7,7,7,7,7,7,7,7,7,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,12,12,7,7,7,18,18,7,7,2,2,2,1,1,7,18,1,2,2,2,2,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,7,7,7,7,7,9,9,9,9,9,9,7,9,9,9,9,9,9,9,9,7,7,7,7,7,7,7,7,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,7,12,12,7,7,7,7,7,7,7,6,6,6,6,6,6,6,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,6,6,6,6,7,6,6,6,7,7,7,7,9,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,18,7,2,7,2,6,2,2,7,7,18,1,2,2,2,2,6,7,18,7,7,18,7,1,1,8,8,8,8,8,8,8,7,7,7,7,7,7,9,9,9,9,9,9,9,9,9,9,9,9,9,9,7,7,7,7,7,7,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,12,12,7,7,7,7,7,7,6,6,6,6,6,6,6,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,6,6,6,6,6,6,6,6,7,7,7,7,7,7,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,8,8,8,8,8,8,7,7,7,7,7,7,7,7,6,6,2,7,7,18,1,2,2,2,2,6,7,18,18,18,18,7,7,7,7,8,8,8,8,8,8,7,7,7,7,7,7,9,9,9,9,9,9,9,9,9,9,9,9,9,9,7,7,7,7,7,7,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,7,7,7,7,7,7,7,7,7,7,7,7,11,11,7,7,7,7,7,7,6,6,6,6,6,6,1,0,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,1,3,1,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,1,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,8,8,8,8,8,8,8,7,7,7,7,7,7,1,7,7,6,2,7,18,18,2,2,2,2,2,6,6,18,18,18,7,7,7,7,7,7,8,8,8,8,8,7,7,8,7,8,7,8,8,8,8,9,9,9,9,9,9,9,9,9,9,7,7,7,7,7,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,10,10,10,7,7,7,7,7,7,7,7,12,7,11,7,7,7,7,7,7,6,6,6,6,6,6,0,0,0,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,6,6,1,1,7,7,7,7,7,7,7,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,6,6,7,18,18,2,2,2,2,2,6,6,11,18,18,7,7,7,7,7,7,8,8,8,8,8,7,7,7,7,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,9,7,7,7,7,7,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,10,10,10,10,1,7,7,7,7,7,7,12,11,7,7,7,7,7,7,7,6,6,6,6,6,0,0,0,0,0,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,6,1,1,1,1,6,6,6,7,7,7,7,7,7,7,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,7,8,8,8,7,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,6,7,7,2,2,1,1,2,6,6,11,11,18,7,7,7,7,7,7,7,8,8,8,8,8,8,7,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,7,7,7,7,7,7,6,6,6,6,6,6,6,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,10,10,10,10,10,7,7,7,7,7,7,7,11,12,12,7,7,7,7,7,7,7,6,6,6,0,0,0,0,0,0,0,0,1,1,2,2,2,1,1,2,2,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,7,7,7,7,7,7,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,7,7,7,7,7,7,7,7,7,8,8,7,7,8,8,8,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,11,7,7,1,2,2,1,1,2,7,11,11,11,18,11,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,10,10,10,10,10,10,10,10,7,7,7,7,7,11,7,12,7,7,7,7,7,7,7,7,7,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,1,1,1,1,7,7,7,7,1,1,1,1,6,6,6,6,7,7,7,7,7,7,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,7,7,8,7,7,7,7,7,7,7,7,7,7,7,7,11,11,7,1,2,2,2,2,2,7,11,11,11,11,11,7,7,7,7,7,7,7,1,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,1,10,10,10,10,10,10,10,10,10,10,10,10,10,7,7,7,11,12,7,7,7,7,7,7,7,7,7,7,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,1,2,2,2,2,2,2,2,1,1,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,1,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,1,1,1,1,7,7,7,7,7,1,1,1,6,6,6,6,7,7,7,7,7,1,7,7,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,9,9,9,7,7,7,7,7,11,11,11,1,2,2,2,2,2,11,11,7,7,11,7,7,7,7,7,7,7,1,8,8,8,8,8,8,8,8,8,8,8,8,6,6,8,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,7,7,7,7,7,7,7,10,10,1,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,10,10,10,10,10,10,7,7,7,11,11,7,7,7,7,7,7,7,7,7,7,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,1,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,1,1,1,6,1,7,7,7,7,7,1,1,6,6,6,6,6,7,7,7,1,1,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,9,9,7,9,7,7,7,11,7,11,1,2,2,2,2,2,1,11,11,11,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,7,7,6,6,6,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,7,7,7,7,7,7,7,7,10,10,10,1,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,10,10,10,10,7,7,7,7,11,11,11,7,7,7,7,7,7,7,7,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,1,1,1,3,3,3,3,3,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,6,1,1,7,7,7,7,7,7,1,1,6,6,7,7,7,7,1,1,1,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,9,9,9,9,9,9,7,11,7,11,6,2,2,2,2,2,2,2,6,6,7,7,7,7,7,7,18,7,7,7,8,8,8,8,8,8,8,8,7,7,7,7,7,7,6,7,7,7,7,7,7,7,7,7,7,7,7,6,6,7,7,7,7,7,7,7,7,7,10,10,10,10,10,10,10,7,7,7,7,9,9,7,7,7,7,1,10,10,10,10,10,1,7,7,7,7,9,7,11,11,7,7,7,7,7,7,7,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,3,3,3,3,3,1,1,1,1,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,6,6,1,6,6,1,6,7,7,7,7,7,7,7,7,7,1,1,1,1,1,1,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,9,9,9,9,9,9,9,9,7,11,11,11,6,2,2,2,1,2,2,2,6,6,7,7,7,7,7,7,18,7,7,7,1,8,8,8,8,8,8,8,7,7,7,7,7,7,6,6,7,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,10,10,7,7,7,7,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,7,11,11,7,7,7,7,7,7,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,6,6,6,6,6,6,6,6,1,1,1,1,1,7,7,7,1,6,1,1,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,9,9,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,9,9,9,9,9,9,7,7,11,11,6,2,2,2,2,2,2,2,2,2,6,6,7,7,7,7,18,7,7,7,7,8,8,8,8,8,8,8,7,7,7,7,7,7,6,6,7,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,1,7,7,7,7,9,7,9,9,7,7,7,7,7,7,7,7,7,7,7,9,9,7,7,7,7,7,7,7,7,7,7,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,7,6,7,7,7,7,10,10,7,7,10,10,7,7,7,7,7,7,7,8,8,8,9,9,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,9,7,9,9,9,9,9,7,18,7,6,2,2,1,2,1,2,2,1,2,6,6,7,7,7,18,18,7,7,7,7,8,8,8,8,8,8,8,7,8,7,7,7,7,7,6,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,7,6,6,7,7,7,7,10,10,10,10,10,10,7,7,7,7,7,7,7,8,8,8,9,9,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,1,9,9,9,9,9,9,9,9,9,18,7,6,6,2,1,2,2,2,2,2,2,7,6,6,18,18,18,18,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,7,7,7,6,8,6,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,1,6,6,1,1,10,10,7,7,7,6,6,7,7,7,10,10,10,10,10,10,10,7,7,7,7,7,7,7,7,8,8,9,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,9,9,18,18,2,6,2,2,1,2,2,2,1,2,2,6,6,18,7,18,18,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,7,7,7,7,6,6,8,6,6,6,6,7,7,7,7,7,7,7,7,1,10,10,10,10,10,10,10,10,10,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,1,12,12,12,12,12,12,12,1,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,7,10,10,10,7,7,7,6,6,6,6,7,6,6,10,10,10,10,10,7,7,7,7,7,8,8,7,8,8,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,18,7,7,7,7,7,7,9,7,7,7,6,2,2,2,2,2,2,2,2,2,2,2,1,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,7,7,7,7,6,6,6,6,6,6,6,6,6,7,7,7,7,7,1,10,10,10,10,10,10,10,10,10,10,10,2,7,7,7,9,9,9,7,7,7,9,9,9,7,7,7,7,10,12,10,12,12,12,12,12,12,12,12,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,7,7,10,10,7,7,7,7,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,8,8,7,7,8,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,18,18,7,7,7,7,7,7,7,7,7,7,6,2,2,2,2,2,2,2,2,2,2,2,2,2,1,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,7,7,7,7,6,6,6,6,8,6,6,6,7,7,7,7,7,1,10,10,10,10,10,10,10,10,10,10,10,10,10,7,7,7,7,9,7,7,7,7,9,9,9,7,7,7,10,10,10,10,10,1,12,12,12,12,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,7,10,7,7,7,7,7,7,6,6,6,6,6,6,6,6,9,7,7,7,7,7,7,7,8,8,7,7,7,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,18,7,7,7,18,18,7,7,7,7,7,7,7,7,1,9,7,2,2,2,2,2,2,2,1,2,2,2,2,2,2,2,7,6,7,7,7,7,7,8,8,8,8,8,8,8,8,8,7,7,7,7,6,6,6,8,8,6,6,6,7,7,7,1,2,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,7,7,7,7,7,7,7,7,7,9,9,9,10,10,10,10,10,10,10,10,2,1,1,12,12,12,12,12,7,7,7,7,7,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,1,6,6,6,7,7,7,7,7,6,6,6,6,6,6,9,9,9,9,9,7,7,7,7,7,7,7,8,8,7,7,8,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,18,18,6,7,7,7,18,18,18,7,7,7,7,7,7,7,7,7,1,7,2,2,2,2,2,2,2,1,2,2,2,2,2,2,2,6,7,12,7,7,7,8,8,8,8,8,8,8,8,7,7,7,7,7,7,6,8,8,8,6,6,6,12,12,12,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,7,7,7,7,7,7,7,7,7,10,9,9,9,10,10,10,10,10,10,10,10,10,10,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,1,6,1,6,6,6,7,7,7,7,7,6,6,7,6,6,6,9,9,9,9,9,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,2,10,10,6,7,7,7,18,7,7,7,7,7,7,7,7,7,7,7,7,2,2,2,2,2,2,6,6,2,2,2,2,2,2,6,7,12,7,8,8,8,8,8,8,8,8,8,8,7,7,7,6,6,6,12,12,12,8,6,6,1,12,12,12,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,7,9,9,7,7,7,7,7,7,9,9,10,10,10,10,10,10,10,10,10,10,10,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,3,3,3,3,3,3,3,1,1,1,1,1,1,1,6,6,6,6,6,6,1,1,1,6,6,7,7,7,7,6,6,6,7,6,7,7,9,9,9,9,9,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,12,7,7,7,7,7,7,7,10,10,10,10,10,7,7,7,18,7,7,7,7,7,7,7,7,7,7,7,7,7,1,1,2,2,2,2,6,6,6,6,2,2,2,2,6,12,12,7,8,8,8,8,8,8,8,8,8,8,7,7,8,8,8,6,12,12,12,12,6,6,12,12,12,10,10,10,10,10,10,10,10,10,2,12,10,10,10,10,10,10,10,10,10,7,7,9,9,7,7,7,7,7,9,9,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,1,7,7,7,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,6,6,6,7,7,7,6,6,6,6,6,7,7,9,9,9,9,9,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,12,12,7,7,7,7,6,6,6,10,10,10,10,6,7,7,7,7,7,7,2,10,2,7,7,2,2,2,7,7,7,7,7,7,2,2,1,7,11,7,6,6,2,2,6,6,12,7,7,8,8,8,8,8,8,8,8,8,7,7,7,8,8,8,8,12,12,12,12,6,12,12,12,12,10,10,10,10,10,10,10,10,12,12,12,12,10,10,10,10,10,10,10,10,10,10,9,9,7,7,10,7,7,10,10,10,10,10,10,1,7,7,7,7,7,7,10,10,10,10,10,10,7,7,7,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,1,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,6,6,6,7,7,7,6,6,6,6,6,7,7,7,7,9,9,9,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,12,12,6,6,6,12,12,12,10,10,10,10,10,10,6,7,6,7,7,10,10,10,7,7,2,2,2,2,2,2,7,7,7,7,7,7,11,11,11,11,11,6,6,6,12,7,7,7,8,8,8,8,8,8,8,8,8,7,7,7,8,8,8,8,8,12,12,12,6,12,12,12,10,10,10,10,10,10,10,10,12,12,12,12,12,12,10,10,10,10,10,10,10,10,10,9,9,10,10,10,10,10,10,10,10,10,10,1,7,7,7,7,7,7,7,7,2,10,10,10,1,1,7,7,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,1,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,12,12,12,12,12,1,12,11,2,10,10,10,10,10,10,10,7,7,10,10,10,10,10,2,2,2,2,2,2,2,7,7,7,7,7,7,11,11,12,12,11,6,6,6,7,7,7,7,8,8,8,8,8,8,8,8,8,8,7,7,8,8,8,8,8,12,12,12,12,12,12,12,10,10,10,10,10,10,10,10,12,12,12,12,12,12,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,7,7,7,7,7,7,7,7,7,7,6,1,1,1,1,7,7,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,12,12,12,12,12,12,12,11,11,2,10,18,10,10,6,7,7,7,7,7,10,10,10,10,7,2,2,2,2,2,2,2,2,7,7,7,7,7,12,12,11,11,7,6,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,6,6,12,12,12,12,12,10,10,10,10,10,10,10,11,11,11,12,12,12,12,12,12,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,2,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,12,12,6,12,12,12,12,12,11,18,18,18,18,6,7,7,6,6,7,7,10,10,7,7,7,7,7,7,2,2,2,2,2,7,7,12,12,12,12,12,11,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,7,7,7,7,7,6,6,6,12,12,12,12,12,10,10,10,10,10,10,11,11,11,11,11,12,12,12,12,12,12,12,12,12,12,10,10,10,10,10,10,10,10,10,10,10,10,10,10,12,12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,11,11,11,11,12,12,11,12,12,11,18,18,18,18,7,7,2,6,6,7,7,7,10,7,7,7,7,7,7,7,7,7,7,7,7,7,12,12,12,7,12,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,7,7,7,7,7,6,6,6,6,12,12,12,12,10,10,10,10,10,11,11,11,11,11,11,12,12,12,12,12,12,12,12,12,12,12,12,1,10,10,10,10,10,10,10,10,10,12,12,12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,12,12,12,1,11,11,11,11,11,11,18,18,7,7,7,1,7,2,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,12,12,12,12,12,12,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,7,7,7,7,7,6,6,6,6,12,12,12,12,10,10,10,10,10,11,11,11,11,11,11,12,12,12,12,12,12,12,12,12,11,11,11,12,10,10,10,2,10,10,10,10,1,12,12,12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,11,11,1,11,11,11,18,18,18,6,7,7,7,7,7,1,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,7,7,7,7,7,7,6,6,6,6,6,12,12,12,10,10,10,10,10,10,11,11,11,11,11,10,10,12,12,12,12,12,10,11,11,11,11,11,10,10,10,2,10,10,10,2,1,12,7,12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,7,7,7,1,11,11,11,11,1,1,11,11,7,7,7,7,7,1,1,1,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,6,7,7,7,7,7,7,7,7,6,6,6,6,6,12,12,12,10,10,10,10,10,10,11,11,11,11,10,10,10,12,12,12,12,10,10,11,11,11,11,12,10,10,10,10,10,10,1,6,6,6,12,12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,6,6,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,7,7,7,7,18,18,6,1,1,1,7,11,7,7,7,1,1,2,1,1,2,2,2,2,6,7,7,7,7,7,7,7,2,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,6,6,7,7,7,7,7,7,7,8,8,8,8,8,6,12,12,12,12,10,10,10,10,10,10,10,10,10,11,10,12,12,12,12,12,10,12,11,11,11,11,1,10,10,10,1,10,6,6,6,6,7,12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,2,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,7,18,18,18,18,6,7,1,7,7,7,7,7,1,1,2,2,2,2,2,2,2,1,6,6,6,7,7,2,2,2,2,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,6,6,6,7,7,7,7,7,8,8,8,8,8,8,8,6,12,12,12,12,10,10,10,10,10,10,12,10,10,10,10,12,12,12,12,12,12,12,12,11,11,12,10,10,10,10,1,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,10,10,10,7,7,7,7,7,7,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,2,2,2,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,7,6,7,6,7,7,7,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,6,1,6,6,6,7,7,6,7,7,7,7,7,7,7,11,7,1,2,1,2,2,2,2,2,2,1,1,1,6,1,7,6,2,2,2,6,6,6,6,6,6,6,7,6,7,7,7,7,7,7,7,7,7,7,7,8,8,8,7,6,6,6,7,7,7,7,7,8,8,8,8,8,8,8,6,12,12,12,12,10,10,10,10,10,12,12,12,10,12,12,12,12,12,12,12,12,12,12,12,12,12,10,10,10,10,10,6,6,6,6,6,7,7,7,7,7,7,7,7,7,10,10,10,10,10,10,7,7,7,7,7,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,6,1,6,6,7,7,6,1,1,7,1,6,7,7,7,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,6,6,2,2,2,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,7,7,7,7,7,8,8,8,8,8,8,8,8,6,6,6,12,12,10,10,10,10,10,12,12,12,12,10,12,12,10,12,12,12,12,12,12,12,12,10,10,10,10,10,10,6,6,6,6,7,7,7,7,7,7,7,7,7,10,10,10,10,10,10,10,10,7,7,7,7,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,6,6,6,1,6,6,7,7,6,6,6,6,6,6,1,7,7,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,2,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,11,11,7,7,7,7,7,6,6,7,7,7,7,7,8,8,8,8,8,8,8,8,6,6,6,12,12,12,10,10,10,10,10,12,12,12,10,10,12,12,11,10,10,12,12,12,12,2,10,10,10,10,10,10,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,10,10,10,7,7,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,2,2,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,7,6,6,6,6,6,6,6,6,6,6,6,7,7,7,6,6,6,1,1,7,6,6,1,1,6,6,6,6,1,7,7,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,2,2,2,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,11,11,11,11,7,7,7,7,7,6,6,6,7,7,7,8,8,8,8,8,8,7,7,7,6,6,6,12,12,12,10,10,10,10,10,12,12,12,12,12,12,11,11,10,10,12,12,12,1,10,10,10,10,10,10,12,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,10,10,10,7,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,6,6,6,6,6,6,6,6,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,6,6,6,6,6,6,6,6,1,1,7,1,1,2,1,1,1,2,2,2,2,2,2,2,2,2,2,2,1,1,2,2,2,2,6,6,6,6,6,7,7,7,7,7,7,7,7,11,11,11,11,11,11,11,11,7,7,7,6,6,7,7,7,8,8,8,8,8,7,7,7,7,7,6,6,6,12,12,10,10,10,10,10,10,12,12,12,12,12,11,10,10,10,12,12,10,10,10,10,10,10,10,12,12,12,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,3,1,1,1,1,1,1,1,1,6,6,6,6,6,6,1,6,6,6,6,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,6,6,6,6,1,1,1,6,6,6,6,1,1,1,2,1,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,2,2,2,2,6,6,6,6,6,7,7,7,7,7,7,7,7,11,11,11,11,11,11,11,11,7,7,7,7,7,7,7,7,6,8,8,8,7,7,12,12,7,7,7,6,6,10,10,10,10,10,10,10,10,10,10,10,12,11,11,11,10,10,12,10,10,10,10,10,10,10,12,12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,7,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,1,1,6,6,6,6,6,1,1,1,6,6,6,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,6,1,1,1,1,1,6,6,6,1,1,1,1,1,2,1,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,2,2,2,2,2,6,6,6,6,7,7,7,7,7,7,7,7,11,11,11,12,11,11,11,11,7,7,7,7,7,7,7,7,6,6,6,6,7,7,12,12,7,7,7,7,6,6,2,10,10,10,10,10,10,10,10,10,11,11,11,11,12,10,10,10,10,10,10,10,10,12,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,7,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,1,1,1,6,6,1,1,1,1,1,1,1,1,7,7,7,7,7,7,6,6,7,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,2,1,1,2,2,2,2,1,2,2,2,2,2,2,2,2,1,1,2,2,2,1,2,2,2,6,6,6,6,6,6,7,7,7,7,7,7,7,12,12,11,11,11,7,7,7,7,7,7,7,7,8,6,6,6,7,12,12,12,7,7,7,7,7,6,6,10,10,10,10,10,10,10,10,10,11,11,11,12,12,10,10,10,10,10,10,1,12,12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,10,10,7,7,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,7,7,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,2,2,2,2,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,7,7,7,7,7,12,11,11,11,7,7,7,7,7,7,7,7,8,7,7,7,12,12,12,12,7,7,7,7,7,6,6,6,10,10,10,10,10,10,10,10,11,11,10,10,10,10,10,10,10,12,12,12,12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,7,7,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,2,2,1,1,1,2,2,2,2,1,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,6,6,6,6,6,6,7,7,7,7,7,7,7,11,11,11,11,7,7,7,7,7,7,7,7,7,7,12,12,12,12,12,7,7,7,7,7,6,6,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,12,12,6,12,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,2,2,2,2,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,2,6,6,6,6,6,7,7,7,7,7,7,7,12,11,11,11,7,7,7,7,7,7,7,12,12,12,12,12,12,12,12,7,7,7,7,7,6,6,6,10,10,10,10,10,10,10,10,10,10,10,10,10,10,12,12,12,12,6,6,7,7,7,7,7,7,7,7,7,12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,2,2,2,2,6,6,6,6,6,6,6,7,12,12,11,11,11,7,7,7,7,7,7,12,12,12,12,12,12,12,12,12,7,7,7,7,7,6,6,6,2,10,10,10,10,10,10,10,10,10,10,10,10,2,12,12,12,6,6,12,12,7,7,7,7,7,7,7,7,12,12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,2,2,2,2,2,1,1,1,6,6,6,6,7,12,12,12,12,12,7,7,7,7,7,7,12,12,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,10,10,10,10,10,10,10,10,10,10,12,12,12,12,6,6,6,6,12,7,7,7,7,7,7,7,7,7,12,7,7,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,7,7,7,7,7,7,7,7,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,12,12,1,12,12,2,10,12,2,12,12,12,12,12,6,6,6,6,12,12,7,7,7,7,7,7,7,7,7,7,7,7,7,9,9,9,9,8,8,8,8,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,3,3,3,3,3,2,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,2,1,1,1,1,2,2,2,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,6,6,6,7,7,7,7,7,7,7,7,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,12,12,12,12,12,12,7,7,7,12,12,12,12,6,6,6,6,6,12,7,7,7,7,7,7,7,7,7,7,9,7,7,9,9,9,9,9,8,8,8,8,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,3,3,3,3,3,1,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,4,1,1,1,1,1,1,3,1,1,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,2,1,1,1,1,2,2,2,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,6,6,6,6,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,12,7,7,7,7,7,12,6,6,12,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,9,7,7,9,9,9,9,9,8,8,8,8,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,2,1,1,1,2,2,2,2,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,6,6,6,6,6,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,7,7,7,7,12,12,12,12,12,12,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,9,9,9,9,9,9,9,9,9,8,8,8,8,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,2,2,1,1,2,2,2,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,6,6,6,6,6,7,7,7,7,6,6,12,12,12,12,12,6,6,6,6,6,6,7,7,7,7,7,7,7,6,9,9,9,9,9,9,9,9,9,9,9,8,8,8,8,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,2,1,2,2,2,2,2,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,11,11,11,7,7,7,7,7,7,7,7,6,6,7,7,7,7,7,6,6,6,6,12,12,12,12,6,6,6,7,6,6,7,7,7,7,7,6,6,9,9,9,9,9,9,9,9,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,2,2,2,2,2,2,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,11,11,11,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,7,12,12,12,7,7,7,7,7,7,7,7,7,7,6,6,6,9,9,9,9,9,9,9,9,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,5,1,3,3,3,3,3,3,3,3,3,3,3,1,3,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,2,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,2,2,2,2,2,2,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,11,11,11,11,11,11,11,11,11,7,7,7,7,7,7,7,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,6,6,7,7,9,9,9,9,9,9,9,9,9,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,5,5,5,5,5,5,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,2,2,2,2,2,2,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,11,11,11,11,11,11,11,11,11,7,7,7,7,7,7,7,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,6,6,6,7,9,9,9,9,9,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,5,5,5,5,5,5,5,3,3,3,3,3,3,3,3,3,3,3,3,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,2,2,2,2,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,7,7,7,11,11,11,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,9,9,9,9,9,9,9,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,10,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,5,5,5,5,5,5,5,5,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,2,2,2,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,7,7,7,10,10,10,10,10,10,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,5,5,5,5,5,5,5,5,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,2,2,2,2,2,1,1,2,2,2,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,2,2,2,1,1,1,1,1,1,1,1,2,2,1,1,2,2,1,1,1,1,1,1,1,1,2,2,2,2,2,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,6,7,7,7,7,7,7,7,7,7,9,7,7,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,7,7,7,10,10,10,10,10,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,5,5,5,5,5,5,5,5,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,2,2,1,1,1,2,2,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,2,2,2,2,2,1,1,2,2,2,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,2,2,2,1,1,1,1,1,1,1,1,2,2,1,1,2,2,1,1,1,1,1,2,1,1,2,1,2,2,2,6,6,7,7,7,7,7,7,7,6,6,6,6,6,7,6,6,6,7,9,7,9,7,7,7,7,7,7,9,9,9,9,9,9,9,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,7,7,7,7,7,7,10,10,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,5,5,5,5,5,5,5,5,5,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,2,2,2,2,2,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,2,2,1,1,1,1,2,2,2,1,6,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,6,6,9,9,9,7,7,7,9,9,9,9,9,9,9,7,9,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,5,5,5,5,5,5,5,5,5,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,2,2,2,2,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,2,2,1,1,1,1,1,2,2,2,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,9,9,9,9,7,9,9,9,9,9,9,7,7,7,7,7,8,7,7,7,7,7,7,7,7,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,5,5,5,5,5,5,5,5,5,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,2,2,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,2,1,1,1,1,1,1,2,2,2,2,1,6,6,6,6,6,6,6,6,6,6,6,7,6,6,6,9,9,6,9,9,9,9,9,9,9,9,9,7,7,7,7,7,8,8,7,7,7,7,7,7,7,7,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,1,1,1,1,1,3,3,3,3,3,3,3,3,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,6,6,6,6,6,6,6,6,6,7,7,6,6,6,6,6,6,6,9,9,9,9,9,9,9,7,7,7,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,5,1,5,5,5,5,5,5,5,5,5,5,5,5,1,1,3,3,3,3,3,1,1,1,1,3,3,3,1,1,3,3,3,3,3,3,1,3,3,3,1,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,2,1,1,1,1,1,2,2,2,2,2,6,6,6,6,6,6,6,6,6,6,7,7,7,6,6,6,6,6,6,7,7,9,8,8,8,7,7,7,7,7,7,7,8,8,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,2,1,1,1,1,1,2,2,2,2,2,1,1,6,6,6,6,6,6,6,6,7,7,7,7,7,6,6,6,6,6,7,7,8,8,8,8,8,7,7,8,8,8,8,8,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,7,7,7,7,10,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,2,2,2,2,2,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,2,2,2,1,1,6,6,6,6,6,6,6,6,7,7,7,7,7,6,6,7,7,6,6,7,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,7,7,7,10,10,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,2,2,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,2,1,1,1,1,1,1,2,2,2,2,2,2,1,1,2,2,2,1,1,1,1,6,6,6,6,6,6,6,6,6,7,7,7,7,6,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,7,7,10,10,10,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,2,1,1,1,2,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,2,2,2,1,1,1,1,1,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,6,6,7,7,7,7,7,8,8,8,8,8,8,10,10,10,10,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,4,4,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,2,2,2,2,2,1,1,5,1,1,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,2,1,1,1,2,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,2,1,2,2,2,2,2,1,1,1,1,2,1,1,1,1,1,1,1,1,2,2,1,2,2,2,2,1,1,1,1,1,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,7,7,7,7,6,6,6,6,7,7,7,7,7,8,8,7,8,10,10,10,10,10,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,2,2,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,2,2,2,2,2,2,2,2,2,2,1,1,2,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,7,7,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,10,10,10,10,10,7,7,7,7,7,7,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4,4,4,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,2,2,2,2,2,2,2,2,2,2,1,1,1,2,2,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,7,7,7,7,7,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,10,10,10,10,7,7,7,7,7,7,7,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,7,7,6,7,7,7,7,7,7,7,7,7,7,10,10,7,7,7,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,7,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,5,5,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,4,4,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,2,1,1,2,1,1,1,2,2,1,1,1,1,1,1,1,1,1,2,2,2,2,1,2,2,1,2,1,1,1,1,1,1,1,2,2,1,2,2,2,1,1,1,1,1,1,2,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,2,2,1,1,1,2,2,2,2,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,2,2,2,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,1,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,7,7,7,7,7,7,7,7,7,7,6,7,7,7,7,7,7,7,7,7,7,7,1,];
}

function getTilePallet()
{
	return ["dirta","savanna_dirt_rocks_c","savanna_wash_a","savanna_dirt_b","savanna_dirt_rocks_b","savanna_riparian_bank","savanna_grass_b","grass b soft dirt 50","grass1_spring","grass_field","grass1_spring","savanna_grass_a_wetseason","savanna_grass_b_wetseason","savanna_grass_a","new_savanna_grass_a","new_savanna_grass_b","new_savanna_grass_c","steppe_grass_dirt_66","peat_temp"];
	}
