// Location: 49.337248, 1.106107
// Map Width: 80km

RMS.LoadLibrary("rmgen");
RMS.LoadLibrary("rmgen2");

InitMap();

log("Initializing tile classes...");
setBiome(4);
initMapSettings();
initTileClasses(["shallowWater"]);

log("Initializing environment...");

setSunColor(0.733, 0.746, 0.574);

setWaterTint(0.224, 0.271, 0.270);
setWaterColor(0.224, 0.271, 0.270);
setWaterWaviness(8);
setWaterMurkiness(0.87);
setWaterType("lake");

setTerrainAmbientColor(0.521, 0.475, 0.322);

setSunRotation(-1 * PI);
setSunElevation(PI / 6.25);

setFogFactor(0);
setFogThickness(0);
setFogColor(0.69, 0.616, 0.541);

setPPEffect("hdr");
setPPContrast(0.67);
setPPSaturation(0.42);
setPPBloom(0.23);

log("Initializing biome...");
g_Terrains.mainTerrain = "new_alpine_grass_d";
g_Terrains.forestFloor1 = "alpine_grass_d";
g_Terrains.forestFloor2 = "alpine_grass_c";
g_Terrains.tier1Terrain = "new_alpine_grass_c";
g_Terrains.tier2Terrain = "new_alpine_grass_b";
g_Terrains.tier3Terrain = "alpine_grass_a";
g_Terrains.tier4Terrain = "new_alpine_grass_e";
g_Terrains.roadWild = "new_alpine_citytile";
g_Terrains.road = "new_alpine_citytile";
g_Gaia.mainHuntableAnimal = "gaia/fauna_deer";
g_Gaia.secondaryHuntableAnimal = "gaia/fauna_pig";
g_Gaia.metalLarge = "gaia/geology_metal_alpine_slabs";
g_Gaia.metalSmall = "gaia/geology_metal_alpine";
g_Gaia.fish = "gaia/fauna_fish_tilapia";
g_Gaia.tree1 = "gaia/flora_tree_poplar";
g_Gaia.tree2 = "gaia/flora_tree_toona";
g_Gaia.tree3 = "gaia/flora_tree_apple";
g_Gaia.tree4 = "gaia/flora_tree_acacia";
g_Gaia.tree5 = "gaia/flora_tree_carob";
g_Decoratives.grass = "actor|props/flora/grass_soft_large.xml";
g_Decoratives.grassShort = "actor|props/flora/grass_tufts_a.xml";
g_Decoratives.rockLarge = "actor|geology/stone_granite_med.xml";
g_Decoratives.rockMedium = "actor|geology/stone_granite_small.xml";
g_Decoratives.bushMedium = "actor|props/flora/bush_tempe_a.xml";
g_Decoratives.bushSmall = "actor|props/flora/bush_tempe_b.xml";
g_Decoratives.reeds = "actor|props/flora/reeds_pond_lush_a.xml";
g_Decoratives.lillies = "actor|props/flora/water_lillies.xml";

initBiome();
RMS.SetProgress(5);

log("Resetting terrain...");
resetTerrain(g_Terrains.mainTerrain, g_TileClasses.land, 1);
RMS.SetProgress(10);

log("Copying heightmap...");
var scale = paintHeightmap(getHeightMap(), getTileMap(), getTilePallet(), (tile, x, y) => {
	if (tile.indexOf("mud_temp") >= 0)
		addToClass(x, y, g_TileClasses.mountain);
});
RMS.SetProgress(30);

log("Paint tile classes...");
paintTileClassBasedOnHeight(-3, -1, 3, g_TileClasses.shallowWater);
paintTileClassBasedOnHeight(-100, -3, 3, g_TileClasses.water);
RMS.SetProgress(40);

log("Placing players...");

//Coordinate system of the heightmap
var singleBases = [
	[100, 265],
	[180, 260],
	[245, 220],
	[275, 145],
	[40, 165],
	[70, 95],
	[130, 50],
	[205, 45]
];

var strongholdBases = [
	[65, 140],
	[180, 60],
	[260, 190],
	[120, 270]
];
randomPlayerPlacementAt(singleBases, strongholdBases, scale, 0.06);
RMS.SetProgress(50);

log("Render gaia...");
addElements([
	{
		"func": addLayeredPatches,
		"avoid": [
			g_TileClasses.dirt, 5,
			g_TileClasses.forest, 2,
			g_TileClasses.mountain, 2,
			g_TileClasses.player, 12,
			g_TileClasses.water, 3,
			g_TileClasses.shallowWater, 3
		],
		"sizes": ["normal"],
		"mixes": ["normal"],
		"amounts": ["many"]
	},
	{
		"func": addDecoration,
		"avoid": [
			g_TileClasses.forest, 2,
			g_TileClasses.mountain, 2,
			g_TileClasses.player, 12,
			g_TileClasses.water, 3,
			g_TileClasses.shallowWater, 3
		],
		"sizes": ["normal"],
		"mixes": ["normal"],
		"amounts": ["many"]
	}
]);

addElements(shuffleArray([
	{
		"func": addSmallMetal,
		"avoid": [
			g_TileClasses.berries, 5,
			g_TileClasses.forest, 3,
			g_TileClasses.mountain, 6,
			g_TileClasses.player, 30,
			g_TileClasses.rock, 20,
			g_TileClasses.metal, 30,
			g_TileClasses.water, 3,
			g_TileClasses.shallowWater, 3
		],
		"sizes": ["normal"],
		"mixes": ["same"],
		"amounts": ["few"]
	},
	{
		"func": addMetal,
		"avoid": [
			g_TileClasses.berries, 5,
			g_TileClasses.forest, 3,
			g_TileClasses.mountain, 6,
			g_TileClasses.player, 30,
			g_TileClasses.rock, 30,
			g_TileClasses.metal, 20,
			g_TileClasses.water, 3,
			g_TileClasses.shallowWater, 3
		],
		"sizes": ["normal"],
		"mixes": ["same"],
		"amounts": ["normal"]
	},
	{
		"func": addStone,
		"avoid": [
			g_TileClasses.berries, 5,
			g_TileClasses.forest, 3,
			g_TileClasses.mountain, 6,
			g_TileClasses.player, 30,
			g_TileClasses.rock, 30,
			g_TileClasses.metal, 20,
			g_TileClasses.water, 3,
			g_TileClasses.shallowWater, 3
		],
		"sizes": ["normal"],
		"mixes": ["same"],
		"amounts": ["normal"]
	},
	{
		"func": addForests,
		"avoid": [
			g_TileClasses.berries, 5,
			g_TileClasses.forest, 8,
			g_TileClasses.metal, 3,
			g_TileClasses.mountain, 6,
			g_TileClasses.player, 20,
			g_TileClasses.rock, 3,
			g_TileClasses.water, 2,
			g_TileClasses.shallowWater, 2
		],
		"sizes": ["normal"],
		"mixes": ["same"],
		"amounts": ["many"]
	}
]));

addElements(shuffleArray([
	{
		"func": addAnimals,
		"avoid": [
			g_TileClasses.animals, 20,
			g_TileClasses.forest, 2,
			g_TileClasses.metal, 2,
			g_TileClasses.mountain, 6,
			g_TileClasses.player, 20,
			g_TileClasses.rock, 2,
			g_TileClasses.water, 3,
			g_TileClasses.shallowWater, 3
		],
		"sizes": ["huge"],
		"mixes": ["similar"],
		"amounts": ["tons"]
	},
	{
		"func": addAnimals,
		"avoid": [
			g_TileClasses.animals, 20,
			g_TileClasses.forest, 2,
			g_TileClasses.metal, 2,
			g_TileClasses.mountain, 6,
			g_TileClasses.player, 20,
			g_TileClasses.rock, 2,
			g_TileClasses.water, 3,
			g_TileClasses.shallowWater, 3
		],
		"sizes": ["huge"],
		"mixes": ["similar"],
		"amounts": ["tons"]
	},
	{
		"func": addBerries,
		"avoid": [
			g_TileClasses.berries, 30,
			g_TileClasses.forest, 5,
			g_TileClasses.metal, 10,
			g_TileClasses.mountain, 2,
			g_TileClasses.player, 20,
			g_TileClasses.rock, 10,
			g_TileClasses.water, 3,
			g_TileClasses.shallowWater, 3
		],
		"sizes": ["normal"],
		"mixes": ["same"],
		"amounts": ["many"]
	},
	{
		"func": addStragglerTrees,
		"avoid": [
			g_TileClasses.berries, 5,
			g_TileClasses.forest, 4,
			g_TileClasses.metal, 2,
			g_TileClasses.mountain, 6,
			g_TileClasses.player, 12,
			g_TileClasses.rock, 2,
			g_TileClasses.water, 5,
			g_TileClasses.shallowWater, 3
		],
		"sizes": ["normal"],
		"mixes": ["same"],
		"amounts": ["tons"]
	}
]));
RMS.SetProgress(80);

log("Adding lillies...");
createDecoration(
	[
		[new SimpleObject(g_Decoratives.reeds, 1,3, 0,1)],
		[new SimpleObject(g_Decoratives.lillies, 1,2, 0,1)]
	],
	[
		200 * Math.pow(scaleByMapSize(3, 12), 2),
		100 * Math.pow(scaleByMapSize(3, 12), 2)
	],
	stayClasses(g_TileClasses.shallowWater, 0)
);
RMS.SetProgress(90);

ExportMap();

// MapTiles - Do Not Edit Below This Line
function getHeightMap()
{
	return [22,22,22,22,22,22,22,21,21,21,21,21,21,20,19,19,18,17,16,17,18,19,19,19,19,19,19,18,18,18,17.99,17.99,17.99,17.98,17.98,17.97,17.91,17.87,17.74,17.50,17.20,16.75,16.40,16.26,16.25,16.28,16.28,16,15.87,15.86,15.88,16,16.15,16.35,16.50,16.66,16.83,16.97,17.10,17.22,17.33,17.37,17.39,17.37,17.32,17.25,17.23,17.25,17.35,17.50,17.66,17.96,18,18,18,18,18,19,19,19,19,19,19,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,17.87,17.74,17.24,17,16.98,16.96,16.87,16.64,16.45,16.35,16.89,17.86,18.89,19.12,18.62,17.91,17.37,16.97,16.64,16.40,16.25,16.12,16.02,16,15.97,15.88,15.76,15.45,14.91,14.46,14.15,14.03,14,13.99,13.97,13.91,13.86,13.75,13.59,13.37,13.22,13.07,12.95,12.84,12.72,12.58,12.37,12.14,11.87,11.50,11.01,10.39,9.70,8.82,7.85,6.83,5.83,4.95,4.23,3.76,3.73,4.08,4.83,5.86,6.98,8.08,9.03,9.87,10.51,11,11.39,11.71,11.95,12.13,12.36,12.61,13,13,13,13,13,13,12,12,13,13,13,12,12,13,13,13,13,13,13,13,12,12,12,12,12,12,11,9,5,3,-0.63,-1.18,-1.63,-1.98,-2.13,-2.24,-2.16,-2,-1.75,-1.40,-1.23,-0.92,-0.61,-0.17,-0.12,0,0,0,0,1.62,3.25,4.86,6.38,7.84,9.09,10.07,10.78,11.32,11.64,11.88,12.03,12.15,12.25,12.35,12.38,12.45,12.46,12.46,12.46,12.48,12.51,12.62,12.77,13,13.25,13.53,13.86,14.14,14.45,14.71,14.91,15.12,15.28,15.45,15.53,15.63,15.72,15.75,15.78,15.84,15.86,15.87,15.87,15.88,15.89,15.91,15.96,15.99,16,16,16,16,16,16,16,16,16,16,16,16,16,15,15,15,15,15,15,14,14,14,14,14,14,14,14,13,13,13,13,13,13,12,12,12,12,12,12,12,12,12,22,22,22,22,22,22,22,21,21,21,21,21,21,20,19,19,18,17,17,16,17,18,19,19,19,19,18.12,18.09,17.97,17.98,17.99,17.98,17.96,17.95,17.90,17.89,17.87,17.78,17.62,17.38,17.09,16.74,16.41,16.25,16.15,16.11,16,15.89,15.83,15.82,15.87,16,16.13,16.34,16.50,16.65,16.83,16.96,17.08,17.20,17.27,17.36,17.37,17.34,17.25,17.22,17.20,17.23,17.32,17.46,17.62,17.76,17.88,18,18,18,18,18,19,19,19,19,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,17.87,17.66,17.36,17.13,17,16.98,16.95,16.85,16.62,16.38,16.36,16.87,17.74,18.62,18.85,18.37,17.76,17.25,16.87,16.59,16.37,16.22,16.11,16.03,16,15.97,15.88,15.74,15.39,14.91,14.48,14.22,14.08,14,13.98,13.96,13.89,13.82,13.66,13.50,13.33,13.13,13,12.87,12.75,12.63,12.49,12.27,12.03,11.75,11.36,10.85,10.24,9.50,8.63,7.72,6.73,5.75,4.95,4.27,3.88,3.87,4.25,5,5.99,7.02,8.09,9.02,9.83,10.50,11,11.37,11.64,11.87,12.08,12.25,12.45,12.62,13,13,13,13,12,12,12,12,13,12,12,12,12,13,13,13,13,13,13,12,12,12,12,12,11,10,7,3,0.47,-1.25,-1.85,-2.25,-2.55,-2.75,-2.80,-2.75,-2.63,-2.37,-1.99,-1.48,-1.18,-0.87,-0.41,-0.13,-0.02,0,0,0,1.83,3.36,4.87,6.38,7.82,9.01,10.01,10.76,11.32,11.66,11.90,12.10,12.23,12.33,12.39,12.47,12.50,12.51,12.51,12.51,12.53,12.60,12.70,12.85,13.03,13.28,13.59,13.87,14.15,14.46,14.72,14.95,15.12,15.28,15.45,15.53,15.62,15.72,15.75,15.78,15.84,15.86,15.87,15.87,15.88,15.89,15.91,15.96,15.98,15.99,16,16,16,16,16,16,16,16,16,16,16,16,15,15,15,15,15,14,14,14,14,14,14,14,14,13,13,13,13,13,13,13,12,12,12,12,12,12,12,12,12,22,22,22,22,22,22,22,21,21,21,21,21,21,20,20,19,19,18,18,17,16,16,17,18,17.98,17.78,17.62,17.62,17.83,17.91,17.91,17.87,17.84,17.76,17.75,17.75,17.73,17.63,17.50,17.26,16.99,16.70,16.39,16.23,16.09,15.96,15.85,15.75,15.73,15.74,15.83,15.96,16.12,16.32,16.50,16.64,16.78,16.91,17.02,17.13,17.24,17.26,17.27,17.25,17.22,17.14,17.12,17.15,17.25,17.37,17.51,17.66,17.82,17.88,17.97,18,18,18,18,19,19,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,19,18,18,17.98,17.97,17.87,17.64,17.37,17.14,17.02,16.99,16.96,16.89,16.75,16.52,16.28,16.25,16.74,17.50,18.33,18.50,18.07,17.50,17.03,16.70,16.46,16.27,16.15,16.11,16.07,16.01,15.98,15.87,15.71,15.37,14.91,14.52,14.25,14.10,14,13.98,13.91,13.86,13.74,13.58,13.37,13.22,13.03,12.89,12.77,12.64,12.50,12.35,12.12,11.87,11.50,11.10,10.57,9.90,9.20,8.37,7.48,6.53,5.66,4.91,4.37,4.09,4.13,4.53,5.25,6.14,7.12,8.12,9,9.76,10.38,10.91,11.27,11.57,11.75,11.90,12.07,12.16,12.25,12,12,12,12,12,12,12,12,12,12,12,12,12,13,13,13,13,13,13,12,12,12,12,12,10,7,4,0.70,-1.11,-1.76,-2.43,-2.92,-3.25,-3.39,-3.38,-3.25,-3.11,-2.86,-2.48,-1.98,-1.38,-1.05,-0.64,-0.14,-0.04,0,0,1,2.09,3.50,4.97,6.39,7.75,8.97,9.97,10.74,11.28,11.71,11.98,12.15,12.32,12.41,12.50,12.60,12.62,12.64,12.65,12.65,12.66,12.74,12.82,12.96,13.12,13.37,13.62,13.89,14.20,14.47,14.72,14.95,15.12,15.28,15.41,15.52,15.62,15.71,15.75,15.77,15.83,15.85,15.87,15.87,15.88,15.89,15.91,15.96,15.98,15.98,15.99,16,16,16,16,16,16,16,16,16,16,15,15,15,15,15,14,14,14,14,14,14,14,14,13,13,13,13,13,13,13,13,13,12,12,12,12,12,12,12,12,22,22,22,22,22,22,22,21,21,21,21,21,21,20,20,20,19,19,19,18,17,15,15,16.01,16.24,16.36,16.57,16.95,17.20,17.36,17.45,17.49,17.39,17.37,17.40,17.47,17.49,17.41,17.33,17.12,16.88,16.62,16.37,16.15,15.99,15.84,15.72,15.62,15.61,15.62,15.74,15.87,16.09,16.26,16.47,16.62,16.75,16.88,17,17.10,17.14,17.21,17.21,17.16,17.12,17.11,17.09,17.12,17.20,17.28,17.45,17.60,17.73,17.84,17.89,17.97,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,17.98,17.91,17.84,17.63,17.39,17.21,17.07,17,16.96,16.89,16.83,16.64,16.37,16.12,16.01,16.45,17.21,17.97,18.11,17.66,17.22,16.82,16.50,16.34,16.22,16.12,16.11,16.08,16.02,15.99,15.88,15.71,15.37,14.97,14.60,14.32,14.12,14.01,13.97,13.87,13.76,13.62,13.41,13.25,13.08,12.90,12.76,12.63,12.50,12.35,12.13,11.89,11.61,11.23,10.75,10.20,9.52,8.82,8,7.15,6.34,5.53,4.89,4.48,4.32,4.41,4.87,5.52,6.37,7.26,8.14,9,9.72,10.27,10.75,11.13,11.38,11.58,11.71,11.78,11.87,11.95,12,12,12,12,12,12,12,12,12,12,12,12,12,13,13,13,13,13,13,12,12,12,11,9,6,3,0.77,-0.68,-1.65,-2.52,-3.24,-3.68,-4.01,-4.14,-4.15,-3.99,-3.63,-3.17,-2.87,-2.36,-1.74,-1.17,-0.77,-0.27,-0.04,0,1,1,2.47,3.73,5.08,6.41,7.73,8.88,9.87,10.66,11.26,11.72,12.01,12.25,12.40,12.57,12.65,12.75,12.82,12.85,12.87,12.87,12.87,12.90,12.99,13.11,13.25,13.47,13.71,13.97,14.23,14.49,14.73,14.95,15.12,15.27,15.40,15.51,15.62,15.70,15.75,15.76,15.82,15.84,15.86,15.87,15.87,15.89,15.91,15.96,15.98,15.98,15.99,16,16,16,16,16,16,16,16,16,15,15,15,15,15,14,14,14,14,14,14,14,14,13,13,13,13,13,13,13,13,13,13,13,12,12,12,12,12,12,12,22,22,22,22,22,22,22,21,21,21,21,21,21,21,20,20,20,20,19,18,18,16,15.98,15.24,15.40,15.60,15.75,16.50,16.62,16.51,16.41,16.41,16.52,16.66,16.87,17.01,17.12,17.15,17.12,16.99,16.83,16.57,16.33,16.11,15.89,15.73,15.59,15.50,15.48,15.50,15.62,15.78,16,16.22,16.39,16.59,16.73,16.86,16.96,17.01,17.09,17.12,17.12,17.11,17.08,17.03,17.02,17.07,17.12,17.23,17.37,17.50,17.64,17.75,17.86,17.90,17.97,18,18,18,18,18,18,18,18,18,19,18,18,18,18,18,18,18,18,18,18,18,17.98,17.90,17.77,17.61,17.40,17.24,17.09,17,16.97,16.89,16.84,16.70,16.49,16.20,15.89,15.82,16.13,16.78,17.49,17.62,17.25,16.88,16.59,16.37,16.25,16.14,16.12,16.11,16.09,16.03,16,15.88,15.72,15.37,15,14.64,14.37,14.13,14,13.90,13.82,13.64,13.48,13.26,13.10,12.91,12.76,12.62,12.50,12.34,12.12,11.90,11.62,11.28,10.87,10.37,9.75,9.11,8.37,7.62,6.85,6.10,5.40,4.88,4.59,4.51,4.74,5.16,5.84,6.60,7.40,8.23,8.96,9.61,10.12,10.53,10.87,11.12,11.28,11.40,11.50,11.58,11.62,12,12,12,12,12,12,12,12,12,12,12,12,12,13,13,13,13,13,13,12,12,11,8,6,2,0,-0.40,-1.28,-2.41,-3.37,-4.02,-4.49,-4.67,-4.74,-4.74,-4.54,-4.25,-3.75,-3.10,-2.62,-2,-1.26,-0.88,-0.38,-0.04,1,1,1.85,2.75,3.97,5.21,6.48,7.72,8.85,9.83,10.62,11.25,11.72,12.07,12.33,12.51,12.70,12.83,12.91,13,13.07,13.09,13.10,13.11,13.12,13.20,13.26,13.40,13.60,13.78,14.01,14.25,14.50,14.74,14.95,15.12,15.26,15.39,15.50,15.61,15.65,15.73,15.75,15.78,15.84,15.86,15.87,15.87,15.88,15.90,15.95,15.98,15.98,15.99,16,16,16,16,16,16,16,16,15,15,15,15,15,14,14,14,14,14,14,14,14,13,13,13,13,13,13,13,13,13,13,13,13,12,12,12,12,12,12,12,22,22,22,22,22,22,22,21,21,21,21,21,21,21,21,20,20,20,19,18,18,18,16.20,16.36,16.45,16.62,16.76,16.75,16.40,15.87,15.26,15.45,15.61,15.95,16.23,16.50,16.73,16.86,16.87,16.84,16.63,16.45,16.24,16.02,15.84,15.62,15.48,15.37,15.34,15.37,15.50,15.65,15.87,16.12,16.33,16.50,16.65,16.78,16.88,16.97,17,17.02,17.03,17.02,17,17,17,17.01,17.08,17.15,17.27,17.41,17.58,17.71,17.78,17.87,17.90,17.97,18,18,18,19,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,17.98,17.89,17.76,17.60,17.39,17.24,17.11,17,16.97,16.90,16.84,16.72,16.51,16.26,15.97,15.66,15.59,15.83,16.34,16.83,16.90,16.83,16.61,16.37,16.25,16.16,16.12,16.12,16.11,16.10,16.07,16,15.88,15.73,15.39,15.02,14.70,14.37,14.14,13.99,13.85,13.70,13.50,13.33,13.12,12.95,12.77,12.62,12.49,12.32,12.12,11.89,11.63,11.34,10.96,10.49,9.91,9.32,8.62,7.95,7.22,6.50,5.86,5.27,4.88,4.72,4.75,5.01,5.50,6.12,6.84,7.58,8.26,8.89,9.46,9.90,10.26,10.57,10.78,10.97,11.09,11.20,11.25,11.28,11,12,12,13,12,12,12,12,12,12,12,12,12,13,13,13,13,13,13,11,10,9,6,2,0,-0.13,-1.11,-2.15,-3.26,-4.17,-4.86,-5.26,-5.50,-5.51,-5.29,-4.93,-4.66,-4.16,-3.53,-2.75,-2.14,-0.38,0.12,0.62,0.98,1,2,2.07,3.12,4.22,5.37,6.58,7.74,8.82,9.75,10.57,11.20,11.70,12.08,12.37,12.62,12.82,12.98,13.11,13.21,13.25,13.32,13.34,13.36,13.37,13.39,13.48,13.59,13.73,13.88,14.11,14.33,14.52,14.75,14.95,15.12,15.25,15.37,15.50,15.59,15.63,15.71,15.75,15.77,15.83,15.85,15.87,15.87,15.88,15.90,15.95,15.98,15.98,15.99,15.99,15.99,16,16,16,16,16,15,15,15,15,15,14,14,14,14,14,14,14,14,14,13,13,13,13,13,13,13,13,13,13,13,13,12,12,12,12,13,13,12,22,22,22,22,21,21,22,21,21,21,21,21,21,21,21,21,20,20,19,18,18,17.88,17.36,17.20,17.37,17.66,17.76,17.53,16.89,16.23,15.50,15.21,15.14,15.38,15.70,15.98,16.25,16.48,16.60,16.61,16.45,16.28,16.12,15.96,15.75,15.53,15.37,15.25,15.20,15.22,15.33,15.50,15.73,15.98,16.22,16.40,16.60,16.74,16.84,16.89,16.97,16.99,17,17,16.99,16.98,16.98,17,17.02,17.12,17.22,17.35,17.49,17.62,17.73,17.83,17.87,17.91,17.98,18,18,19,18,18,18,18,18,18,18,18,18,18,18,18,18,18,17.99,17.89,17.75,17.59,17.38,17.24,17.11,17.01,16.97,16.89,16.84,16.72,16.57,16.35,16.09,15.75,15.47,15.32,15.46,15.84,16.23,16.39,16.41,16.36,16.25,16.20,16.14,16.12,16.12,16.12,16.11,16.08,16,15.89,15.72,15.39,15.07,14.72,14.38,14.12,13.89,13.73,13.52,13.35,13.13,12.97,12.78,12.62,12.48,12.28,12.12,11.88,11.63,11.35,10.99,10.53,10.02,9.47,8.83,8.14,7.49,6.83,6.20,5.62,5.21,4.91,4.86,5,5.33,5.83,6.40,7.08,7.73,8.33,8.87,9.33,9.70,10,10.25,10.47,10.62,10.76,10.88,11,11.01,11,12,12,13,12,12,12,12,12,12,12,12,12,13,13,13,13,13,13,11,8,6,3,1,0,-0.75,-1.77,-2.80,-3.88,-4.75,-5.29,-5.63,-5.80,-5.79,-5.63,-5.27,-4.80,-4.22,-3.42,-2.51,-1.49,-0.50,0.36,0.99,1.75,1.87,2,2.32,3.45,4.51,5.62,6.74,7.83,8.85,9.75,10.51,11.14,11.65,12.08,12.38,12.65,12.88,13.10,13.25,13.37,13.48,13.51,13.58,13.60,13.61,13.62,13.66,13.75,13.87,14,14.16,14.37,14.57,14.75,14.95,15.11,15.25,15.37,15.47,15.53,15.62,15.66,15.74,15.75,15.82,15.84,15.87,15.87,15.88,15.90,15.95,15.98,15.98,15.98,15.98,15.98,16,16,16,16,15,15,15,15,15,14,14,14,14,14,14,14,14,14,14,13,13,13,13,13,13,13,13,13,13,13,13,12,12,12,13,13,13,13,22,22,22,21,21,21,21,21,21,21,21,21,21,21,21,21,20,20,19,19,19,18.74,18.09,17.84,17.84,18,18.11,17.99,17.51,16.90,16.36,15.88,15.57,15.39,15.40,15.60,15.82,16.03,16.24,16.25,16.23,16.13,16.01,15.87,15.66,15.48,15.26,15.12,15.01,15.01,15.12,15.28,15.51,15.78,16.07,16.27,16.50,16.64,16.76,16.86,16.89,16.95,16.96,16.97,16.97,16.96,16.97,16.98,17,17.07,17.13,17.25,17.37,17.51,17.63,17.75,17.85,17.89,17.96,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,17.98,17.88,17.76,17.58,17.38,17.24,17.11,17.01,16.97,16.89,16.84,16.72,16.57,16.37,16.15,15.90,15.60,15.25,15.08,15.12,15.38,15.75,15.99,16.11,16.14,16.14,16.14,16.14,16.14,16.14,16.13,16.12,16.10,16.01,15.90,15.71,15.40,15.08,14.72,14.37,14.07,13.77,13.53,13.34,13.12,12.96,12.76,12.62,12.47,12.27,12.11,11.87,11.62,11.36,11,10.60,10.12,9.57,8.96,8.32,7.64,7.01,6.45,5.89,5.47,5.14,5,5.03,5.25,5.63,6.13,6.73,7.32,7.87,8.38,8.85,9.22,9.51,9.82,10.02,10.25,10.39,10.59,10.73,10.85,10.91,11,12,12,12,12,12,13,13,13,13,13,13,13,13,13,13,13,13,13,10,7,3,1,0,-0.35,-1.26,-2.27,-3.18,-4.13,-4.93,-4.90,-5.13,-5.22,-5.15,-4.99,-4.63,-4.17,-3.60,-2.88,-2.05,-1.18,-0.35,0.46,1.15,1.73,2.13,2.35,2.76,3.87,4.88,5.91,6.97,7.99,8.91,9.77,10.51,11.12,11.63,12.07,12.40,12.72,12.97,13.20,13.37,13.51,13.63,13.73,13.76,13.82,13.84,13.85,13.87,13.90,14,14.12,14.25,14.40,14.60,14.75,14.91,15.09,15.22,15.34,15.41,15.50,15.60,15.64,15.72,15.75,15.77,15.83,15.86,15.87,15.87,15.89,15.95,15.98,15.98,15.98,15.97,15.96,15.98,16,16,15,15,15,15,15,14,14,14,14,14,14,14,14,14,14,14,13,13,13,13,13,13,13,13,13,13,13,13,12,12,13,13,13,13,13,22,22,21,21,21,21,21,22,21,21,21,21,21,21,21,20,20,20,19,19,18.99,18.85,18.50,18.15,18.03,18.03,18.11,18.09,17.87,17.50,17.07,16.61,16.20,15.84,15.59,15.46,15.48,15.65,15.87,15.99,16,15.99,15.88,15.75,15.59,15.37,15.14,14.98,14.87,14.84,14.88,15.08,15.28,15.59,15.87,16.13,16.37,16.57,16.71,16.78,16.87,16.89,16.91,16.91,16.95,16.95,16.95,16.96,16.98,17,17.09,17.16,17.28,17.45,17.58,17.71,17.82,17.87,17.91,17.98,18,18,18,18,18,18,18,18,18,18,18,18,18,17.99,17.98,17.95,17.74,17.58,17.37,17.24,17.12,17.01,16.98,16.89,16.84,16.72,16.57,16.37,16.22,16.01,15.77,15.48,15.12,14.87,14.87,15.09,15.37,15.64,15.87,16,16.12,16.16,16.21,16.22,16.22,16.21,16.16,16.12,16.07,15.90,15.70,15.38,15.07,14.70,14.33,13.98,13.63,13.36,13.11,12.88,12.73,12.58,12.40,12.25,12.08,11.86,11.62,11.34,11,10.62,10.14,9.62,9.02,8.40,7.77,7.15,6.61,6.10,5.66,5.37,5.16,5.13,5.27,5.59,6,6.50,7.03,7.59,8.08,8.50,8.87,9.20,9.48,9.73,9.99,10.23,10.38,10.59,10.74,10.87,10.96,11,12,12,12,13,13,13,13,13,13,13,13,13,13,13,13,13,13,12,10,5,1,0,-0.24,-0.68,-1.63,-2.60,-3.12,-3.75,-4.25,-4.54,-4.67,-4.74,-4.64,-4.43,-4.12,-3.64,-3.10,-2.40,-1.65,-0.88,-0.10,0.65,1.37,1.99,2.50,3,3.52,4.39,5.35,6.28,7.25,8.21,9.10,9.87,10.58,11.14,11.63,12.08,12.41,12.74,13,13.25,13.48,13.63,13.77,13.88,13.97,14,14.01,14.01,14.03,14.08,14.12,14.22,14.34,14.47,14.62,14.75,14.90,15.07,15.16,15.27,15.37,15.49,15.57,15.62,15.66,15.74,15.76,15.83,15.85,15.87,15.87,15.89,15.95,15.98,15.98,15.97,15.96,15.90,15.83,16,15,15,15,15,15,14,14,14,14,14,14,14,14,14,14,14,14,13,13,14,14,14,14,13,13,13,13,13,13,13,13,13,14,14,14,14,22,21,21,21,21,21,21,21,21,21,21,21,21,21,20,20,20,20,19,19,18.98,18.96,18.62,18.28,18.10,18.01,18.03,18.02,17.97,17.78,17.52,17.20,16.77,16.36,15.95,15.58,15.33,15.37,15.64,15.76,15.84,15.84,15.75,15.63,15.48,15.25,15.02,14.84,14.70,14.62,14.65,14.83,15.07,15.36,15.65,15.98,16.25,16.47,16.62,16.75,16.83,16.87,16.88,16.89,16.89,16.89,16.89,16.90,16.95,16.99,17.02,17.12,17.24,17.37,17.50,17.64,17.76,17.87,17.90,17.96,17.99,18,18,18,18,18,18,18,18,18,18,18,17.87,17.75,17.66,17.61,17.49,17.36,17.23,17.12,17.01,16.98,16.89,16.84,16.72,16.57,16.37,16.23,16.09,15.90,15.70,15.37,15,14.75,14.64,14.85,15.09,15.37,15.65,15.90,16.11,16.23,16.26,16.28,16.28,16.26,16.25,16.16,16.08,15.87,15.64,15.37,15.01,14.64,14.25,13.87,13.50,13.15,12.87,12.64,12.49,12.34,12.16,12,11.82,11.58,11.28,10.98,10.61,10.15,9.64,9.10,8.49,7.87,7.25,6.71,6.22,5.82,5.50,5.34,5.26,5.37,5.60,5.95,6.38,6.88,7.38,7.87,8.32,8.66,9,9.27,9.57,9.84,10.12,10.40,10.64,10.82,10.91,11.03,11.16,11,12,12,13,13,13,14,13,13,13,13,13,13,13,13,13,13,13,12,9,4,0,0,-0.41,-1.13,-1.72,-2.38,-2.99,-3.49,-3.88,-4.16,-4.30,-4.35,-4.25,-4,-3.66,-3.23,-2.64,-2,-1.29,-0.54,0.22,0.96,1.64,2.33,2.95,3.57,4.21,4.98,5.82,6.71,7.61,8.49,9.28,10.02,10.66,11.23,11.70,12.10,12.46,12.75,13.03,13.32,13.53,13.75,13.89,14.02,14.12,14.15,14.20,14.20,14.20,14.21,14.25,14.28,14.37,14.50,14.62,14.75,14.88,15.01,15.12,15.25,15.36,15.45,15.51,15.61,15.64,15.73,15.75,15.82,15.85,15.87,15.87,15.89,15.91,15.98,15.97,15.96,15.90,15.86,15.65,15,15,15,15,15,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,13,13,13,13,13,13,13,13,13,13,14,14,14,22,21,21,21,21,21,21,21,21,21,21,21,21,20,20,20,20,20,19,19,19,18.96,18.64,18.33,18.10,18,18,18,17.98,17.90,17.75,17.51,17.21,16.82,16.35,15.86,15.39,15.51,15.61,15.66,15.72,15.72,15.63,15.52,15.37,15.13,14.90,14.71,14.52,14.45,14.47,14.60,14.82,15.12,15.46,15.76,16.10,16.35,16.52,16.66,16.75,16.83,16.86,16.87,16.87,16.87,16.87,16.87,16.89,16.95,17,17.09,17.20,17.33,17.48,17.62,17.75,17.86,17.89,17.96,17.98,18,18,18,18,18,18,18,18,18,18,17.87,17.62,17.46,17.37,17.32,17.25,17.16,17.10,17.01,16.98,16.89,16.84,16.72,16.57,16.37,16.24,16.10,15.97,15.82,15.60,15.26,14.90,14.62,14.49,14.59,14.78,15.12,15.49,15.84,16.12,16.27,16.37,16.39,16.38,16.37,16.32,16.22,16.09,15.87,15.62,15.34,15,14.62,14.22,13.77,13.37,13,12.70,12.45,12.25,12.09,11.90,11.74,11.50,11.25,10.91,10.57,10.12,9.64,9.11,8.50,7.88,7.28,6.75,6.25,5.87,5.61,5.41,5.37,5.46,5.63,5.96,6.36,6.83,7.32,7.77,8.23,8.62,8.95,9.25,9.51,9.83,10.12,10.48,10.77,11.03,11.22,11.28,11.37,11.50,12,12,13,13,13,13,14,14,13,13,13,13,13,13,13,13,13,13,12,7,2,0,-0.15,-0.75,-1.15,-1.74,-2.27,-2.79,-3.26,-3.63,-3.88,-4,-4,-3.89,-3.65,-3.29,-2.86,-2.29,-1.65,-0.99,-0.25,0.50,1.25,1.99,2.70,3.37,4.08,4.75,5.49,6.25,7.11,7.96,8.75,9.51,10.22,10.82,11.33,11.75,12.13,12.50,12.82,13.11,13.37,13.62,13.83,14,14.12,14.24,14.28,14.33,14.33,14.32,14.32,14.33,14.36,14.40,14.50,14.62,14.74,14.87,14.99,15.10,15.21,15.32,15.39,15.50,15.58,15.62,15.71,15.75,15.78,15.84,15.87,15.87,15.88,15.91,15.97,15.97,15.95,15.87,15.75,15.50,15.12,15,15,15,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,13,13,13,13,13,13,13,13,13,13,14,14,14,21,21,21,21,21,21,21,21,21,21,21,21,20,20,20,20,20,20,19,19,19,18.95,18.64,18.33,18.10,18,18,18,18,17.97,17.87,17.72,17.45,17.11,16.70,16.21,15.75,15.71,15.66,15.66,15.65,15.62,15.58,15.46,15.26,15.08,14.84,14.61,14.40,14.28,14.27,14.37,14.60,14.87,15.24,15.60,15.91,16.22,16.45,16.61,16.71,16.75,16.77,16.78,16.78,16.78,16.82,16.84,16.87,16.90,16.99,17.07,17.15,17.32,17.47,17.62,17.75,17.85,17.89,17.95,17.97,17.99,18,18,18,18,18,18,18,17.87,17.75,17.60,17.36,17.13,17.12,17.12,17.10,17.07,17,16.98,16.89,16.84,16.72,16.57,16.37,16.24,16.10,15.98,15.86,15.70,15.47,15.14,14.82,14.49,14.34,14.33,14.50,14.86,15.26,15.73,16.10,16.34,16.45,16.49,16.49,16.45,16.36,16.24,16.08,15.85,15.59,15.28,14.97,14.60,14.16,13.75,13.33,12.90,12.59,12.28,12.09,11.87,11.70,11.48,11.21,10.87,10.50,10.10,9.62,9.09,8.50,7.89,7.32,6.75,6.26,5.88,5.62,5.48,5.45,5.51,5.72,6,6.37,6.83,7.28,7.76,8.23,8.62,8.99,9.32,9.60,9.88,10.22,10.57,10.90,11.25,11.50,11.70,11.74,11.82,11.99,12,13,13,14,14,14,14,14,14,13,13,13,13,13,13,13,13,13,11,5,1,0.07,-0.24,-0.63,-1.13,-1.64,-2.17,-2.66,-3.10,-3.41,-3.64,-3.75,-3.75,-3.63,-3.38,-3,-2.54,-2,-1.38,-0.67,0.03,0.78,1.57,2.32,3.03,3.76,4.50,5.25,5.91,6.66,7.48,8.25,9.02,9.75,10.39,10.97,11.46,11.87,12.24,12.58,12.87,13.14,13.41,13.66,13.88,14.09,14.23,14.34,14.37,14.39,14.39,14.37,14.37,14.37,14.37,14.41,14.50,14.60,14.71,14.83,14.95,15.03,15.14,15.25,15.37,15.47,15.53,15.62,15.70,15.75,15.77,15.83,15.86,15.87,15.88,15.90,15.97,15.96,15.89,15.82,15.62,15.38,15.15,15,15,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,13,13,13,13,13,13,13,13,13,14,14,21,21,21,21,21,21,21,21,21,21,21,20,20,20,20,20,20,20,19,19,18.98,18.95,18.62,18.28,18.09,18,18,18,18,17.98,17.90,17.77,17.57,17.25,16.90,16.50,16.15,15.95,15.84,15.75,15.71,15.62,15.52,15.39,15.24,15.01,14.78,14.58,14.37,14.24,14.20,14.25,14.40,14.70,15.02,15.39,15.75,16.09,16.34,16.50,16.62,16.70,16.72,16.72,16.72,16.72,16.73,16.75,16.83,16.87,16.98,17.08,17.16,17.33,17.48,17.62,17.75,17.85,17.89,17.95,17.97,17.98,18,18,18,18,18,18,17.87,17.74,17.37,17.25,17.13,17.02,17.02,17.01,17,17,16.97,16.89,16.84,16.72,16.57,16.37,16.24,16.10,15.99,15.87,15.73,15.52,15.32,15,14.66,14.34,14.12,14.07,14.21,14.58,15.07,15.57,16,16.27,16.45,16.51,16.52,16.49,16.37,16.25,16.08,15.84,15.58,15.26,14.96,14.59,14.16,13.75,13.34,12.91,12.58,12.25,12,11.75,11.50,11.24,10.89,10.50,10.09,9.60,9.03,8.49,7.87,7.27,6.74,6.25,5.87,5.61,5.47,5.46,5.53,5.75,6.03,6.40,6.86,7.33,7.78,8.25,8.71,9.09,9.41,9.74,10.02,10.35,10.66,11.02,11.38,11.74,11.96,12.12,12.14,12.25,12.37,13,13,14,14,14,14,14,14,14,13,13,13,13,13,13,13,14,13,9,4,0.08,0.37,-0.02,-0.50,-1,-1.54,-2.04,-2.52,-2.92,-3.25,-3.47,-3.55,-3.53,-3.39,-3.13,-2.77,-2.29,-1.75,-1.13,-0.41,0.32,1.08,1.85,2.62,3.37,4.12,4.87,5.64,6.33,7.02,7.77,8.53,9.26,9.97,10.58,11.11,11.58,11.99,12.34,12.64,12.97,13.24,13.50,13.75,13.97,14.13,14.27,14.38,14.46,14.48,14.46,14.41,14.38,14.37,14.37,14.39,14.47,14.53,14.63,14.75,14.87,15,15.12,15.23,15.34,15.41,15.51,15.61,15.66,15.74,15.76,15.83,15.85,15.87,15.88,15.90,15.96,15.91,15.87,15.75,15.53,15.34,15.12,15,15,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,13,13,13,14,14,13,13,13,13,14,21,21,21,21,20,20,20,20,20,20,20,20,20,20,20,20,20,19,19,19,18.97,18.83,18.50,18.24,18.07,18,18,18,18,17.99,17.95,17.83,17.61,17.34,17.03,16.75,16.39,16.16,16,15.88,15.78,15.71,15.59,15.45,15.25,15.03,14.84,14.61,14.38,14.25,14.14,14.15,14.28,14.52,14.87,15.24,15.61,15.95,16.22,16.39,16.51,16.60,16.62,16.62,16.61,16.61,16.62,16.66,16.75,16.86,16.97,17.08,17.21,17.35,17.50,17.62,17.75,17.86,17.89,17.95,17.96,17.97,18,18,18,18,18,17.90,17.22,17.24,17.12,17.01,17.09,17.07,17.02,17,16.99,16.96,16.89,16.84,16.72,16.57,16.37,16.24,16.10,15.99,15.87,15.74,15.58,15.37,15.13,14.87,14.51,14.14,13.88,13.78,13.91,14.32,14.84,15.35,15.83,16.14,16.37,16.49,16.51,16.50,16.38,16.25,16.08,15.83,15.53,15.25,14.95,14.59,14.21,13.82,13.38,13,12.64,12.34,12.02,11.75,11.40,11.07,10.62,10.14,9.62,9.08,8.49,7.87,7.26,6.72,6.23,5.83,5.53,5.39,5.39,5.51,5.75,6.08,6.46,6.87,7.37,7.86,8.34,8.77,9.21,9.58,9.89,10.22,10.50,10.84,11.15,11.50,11.86,12.13,12.34,12.48,12.50,12.60,13,13,13,14,14,14,14,14,14,14,13,13,13,13,13,13,13,13,11,7,2.07,1.26,0.77,0.34,-0.25,-0.80,-1.38,-1.90,-2.38,-2.77,-3.10,-3.28,-3.38,-3.37,-3.23,-2.97,-2.60,-2.13,-1.54,-0.90,-0.23,0.51,1.28,2.09,2.87,3.64,4.41,5.22,5.98,6.63,7.35,8.03,8.75,9.47,10.12,10.71,11.23,11.66,12.09,12.45,12.75,13.03,13.33,13.58,13.82,14,14.21,14.35,14.45,14.49,14.50,14.47,14.41,14.37,14.35,14.34,14.36,14.38,14.48,14.59,14.70,14.82,14.91,15.07,15.16,15.27,15.38,15.50,15.59,15.64,15.73,15.75,15.78,15.84,15.87,15.87,15.90,15.95,15.89,15.82,15.65,15.47,15.25,15.10,15,15,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,13,13,13,13,21,21,21,20,20,20,20,20,20,20,20,20,20,20,19,19,20,19,19,19,18.85,18.61,18.35,18.12,18.01,18,18,18,18,17.99,17.96,17.84,17.62,17.37,17.12,16.86,16.61,16.37,16.23,16.09,15.96,15.83,15.66,15.51,15.35,15.13,14.95,14.73,14.50,14.33,14.20,14.14,14.23,14.40,14.72,15.08,15.46,15.77,16.08,16.26,16.39,16.48,16.50,16.49,16.48,16.48,16.50,16.59,16.70,16.82,16.95,17.08,17.22,17.36,17.50,17.64,17.76,17.87,17.89,17.95,17.96,17.96,17.98,18,18,18,17.98,17.14,17.23,17.12,17.12,17.03,17.08,17.07,17.01,17,16.97,16.89,16.84,16.72,16.57,16.37,16.24,16.10,15.99,15.87,15.74,15.59,15.39,15.22,15,14.73,14.37,13.98,13.70,13.58,13.72,14.10,14.62,15.14,15.62,16,16.25,16.37,16.46,16.45,16.37,16.24,16.07,15.78,15.52,15.25,14.95,14.61,14.25,13.87,13.50,13.13,12.82,12.49,12.13,11.78,11.38,10.91,10.39,9.84,9.22,8.58,7.91,7.32,6.73,6.22,5.77,5.50,5.35,5.35,5.49,5.74,6.07,6.48,6.90,7.39,7.89,8.39,8.87,9.33,9.72,10.08,10.38,10.71,11,11.32,11.62,11.96,12.25,12.49,12.62,12.73,12.75,12.84,13,13,13,13,13,13,14,14,14,13,13,13,13,13,13,13,13,12,9,5,3.22,2.25,1.47,0.75,0.11,-0.54,-1.15,-1.73,-2.23,-2.63,-2.92,-3.13,-3.25,-3.23,-3.09,-2.80,-2.43,-1.98,-1.39,-0.75,-0.05,0.70,1.48,2.25,3.08,3.87,4.65,5.46,6.24,7,7.59,8.25,8.90,9.60,10.22,10.77,11.32,11.75,12.15,12.51,12.85,13.12,13.39,13.63,13.87,14.09,14.25,14.37,14.46,14.50,14.49,14.45,14.37,14.34,14.26,14.25,14.25,14.32,14.37,14.49,14.61,14.74,14.87,15,15.12,15.25,15.36,15.47,15.53,15.62,15.70,15.75,15.77,15.83,15.86,15.87,15.96,15.91,15.87,15.75,15.58,15.37,15.20,15.08,15,15,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,13,13,13,13,21,21,20,20,20,20,20,20,20,20,20,20,20,19,19,19,19,19,19,19,18.64,18.37,18.15,18.03,18,18,18,18,18,17.99,17.96,17.86,17.64,17.40,17.16,16.98,16.75,16.59,16.40,16.25,16.12,15.99,15.84,15.65,15.49,15.28,15.11,14.87,14.65,14.46,14.27,14.16,14.20,14.34,14.59,14.90,15.27,15.63,15.95,16.13,16.27,16.35,16.37,16.36,16.34,16.35,16.37,16.48,16.61,16.75,16.88,17.03,17.21,17.36,17.50,17.64,17.76,17.86,17.88,17.90,17.91,17.91,17.96,18,18,18,17.12,17.12,17.12,17.45,17.11,17.03,17.02,17.02,17,16.98,16.90,16.84,16.72,16.57,16.37,16.24,16.10,15.99,15.87,15.74,15.59,15.39,15.25,15.08,14.87,14.59,14.20,13.75,13.50,13.38,13.57,13.97,14.50,15.01,15.50,15.85,16.11,16.25,16.34,16.36,16.28,16.20,16.01,15.76,15.50,15.25,14.95,14.62,14.27,13.96,13.62,13.27,12.97,12.62,12.27,11.87,11.39,10.86,10.23,9.52,8.83,8.12,7.41,6.82,6.25,5.78,5.48,5.28,5.26,5.39,5.66,6.02,6.47,6.95,7.45,7.97,8.48,8.97,9.41,9.85,10.23,10.53,10.87,11.14,11.45,11.74,12.02,12.33,12.58,12.75,12.85,12.89,12.89,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,12,8,5.57,4.28,3.10,2.12,1.25,0.49,-0.25,-0.89,-1.50,-2.01,-2.43,-2.76,-3,-3.11,-3.10,-2.97,-2.68,-2.34,-1.87,-1.29,-0.65,0.03,0.78,1.59,2.38,3.22,4.01,4.84,5.62,6.38,7.15,7.75,8.37,9.01,9.65,10.25,10.84,11.36,11.82,12.23,12.59,12.90,13.22,13.48,13.73,13.95,14.12,14.26,14.38,14.47,14.48,14.46,14.37,14.32,14.24,14.16,14.12,14.13,14.20,14.25,14.37,14.50,14.62,14.76,14.90,15.07,15.20,15.32,15.40,15.50,15.60,15.64,15.72,15.75,15.78,15.84,15.87,15.88,15.86,15.75,15.63,15.49,15.26,15.12,15.02,15,15,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,14,14,14,14,14,14,14,14,14,14,14,14,14,13,13,13,13,21,20,20,20,20,20,20,20,20,20,19,19,19,19,19,19,19,19,19,19,18.36,18.14,18.03,18,18,18,18,18,18,17.99,17.97,17.87,17.72,17.50,17.26,17.11,16.90,16.75,16.60,16.46,16.28,16.14,16,15.83,15.64,15.48,15.27,15.08,14.85,14.62,14.38,14.24,14.16,14.25,14.47,14.76,15.12,15.50,15.77,16,16.13,16.22,16.23,16.22,16.20,16.21,16.25,16.36,16.50,16.64,16.84,17,17.14,17.34,17.50,17.62,17.75,17.84,17.87,17.87,17.87,17.87,17.88,17.99,17.99,17.01,17.11,17,17.12,17.13,17.11,17.02,17,17,16.98,16.90,16.84,16.72,16.57,16.37,16.24,16.10,15.99,15.87,15.74,15.58,15.39,15.24,15.10,14.95,14.73,14.40,14,13.58,13.35,13.27,13.50,13.95,14.47,14.98,15.39,15.75,15.98,16.12,16.21,16.24,16.21,16.12,15.98,15.74,15.49,15.23,14.91,14.62,14.32,14,13.71,13.38,13.10,12.75,12.39,11.97,11.41,10.77,10.07,9.26,8.49,7.72,7,6.37,5.87,5.50,5.27,5.24,5.36,5.62,5.99,6.45,6.95,7.48,8,8.51,9.02,9.51,9.97,10.36,10.71,11,11.28,11.58,11.84,12.11,12.37,12.62,12.87,13,13.02,13.02,13,13,13,13,13,13,13,13,13,13,13,14,13,13,13,13,13,13,13,12,8.13,6.58,5.02,3.78,2.72,1.75,0.87,0.11,-0.62,-1.25,-1.78,-2.25,-2.62,-2.86,-2.98,-2.98,-2.86,-2.62,-2.25,-1.78,-1.25,-0.62,0.11,0.86,1.63,2.47,3.26,4.11,4.90,5.72,6.50,7.25,7.87,8.48,9.09,9.70,10.26,10.84,11.36,11.83,12.24,12.62,12.96,13.25,13.51,13.76,13.99,14.15,14.32,14.38,14.45,14.41,14.37,14.28,14.21,14.12,14.02,14,14,14.02,14.12,14.25,14.37,14.51,14.66,14.84,14.99,15.12,15.25,15.36,15.46,15.52,15.62,15.65,15.73,15.75,15.82,15.86,15.87,15.82,15.73,15.59,15.40,15.25,15.12,15.02,15,15,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,13,13,13,13,20,20,20,20,20,20,20,20,20,19,19,19,19,19,19,19,19,19,19,18,18.12,18.02,18,18,18,18,18,18,18,17.99,17.98,17.90,17.78,17.62,17.40,17.23,17.03,16.87,16.74,16.60,16.46,16.32,16.13,15.99,15.83,15.63,15.47,15.25,15,14.75,14.50,14.26,14.14,14.16,14.35,14.62,14.99,15.35,15.63,15.87,16,16.08,16.09,16.08,16.03,16.07,16.12,16.23,16.37,16.52,16.73,16.89,17.10,17.26,17.45,17.60,17.71,17.76,17.83,17.83,17.76,17.74,17.70,17.98,17,17.12,17,17.01,17.09,17.12,17.09,17.01,16.99,16.97,16.89,16.84,16.72,16.57,16.38,16.24,16.10,15.98,15.87,15.73,15.58,15.38,15.23,15.08,14.91,14.76,14.53,14.23,13.82,13.38,13.22,13.23,13.50,13.98,14.49,14.98,15.37,15.66,15.87,16,16.08,16.10,16.08,16,15.87,15.65,15.45,15.20,14.89,14.62,14.33,14.01,13.75,13.47,13.14,12.85,12.47,12,11.40,10.72,9.89,9.03,8.20,7.37,6.64,6.08,5.62,5.35,5.25,5.33,5.57,5.91,6.39,6.91,7.49,8.02,8.60,9.12,9.62,10.07,10.48,10.84,11.12,11.40,11.66,11.91,12.16,12.41,12.66,12.91,13.12,13.27,13.25,13.10,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,12,13,10.96,8.91,7.09,5.63,4.37,3.25,2.24,1.32,0.48,-0.27,-0.97,-1.53,-2.02,-2.40,-2.67,-2.85,-2.87,-2.75,-2.53,-2.22,-1.75,-1.23,-0.61,0.11,0.86,1.62,2.46,3.26,4.11,4.91,5.73,6.50,7.25,8,8.50,9.10,9.65,10.25,10.77,11.28,11.76,12.22,12.61,12.97,13.26,13.57,13.82,14,14.20,14.32,14.37,14.39,14.37,14.28,14.20,14.08,13.97,13.87,13.84,13.84,13.87,13.98,14.10,14.25,14.38,14.58,14.73,14.87,15.01,15.14,15.26,15.37,15.48,15.53,15.62,15.65,15.73,15.77,15.87,15.86,15.77,15.66,15.52,15.37,15.24,15.12,15.02,14.99,14.98,14,14,14,14,14,14,14,15,15,14,14,14,14,14,14,14,14,14,15,15,14,14,14,14,14,14,14,14,14,14,13,13,14,13,20,20,19,19,20,20,20,20,19,19,19,19,19,19,19,19,19,19,18,18,18,18,18,18,18,18,18,18,18,18,17.99,17.96,17.87,17.75,17.58,17.36,17.14,17,16.86,16.72,16.58,16.41,16.26,16.12,15.96,15.77,15.61,15.38,15.13,14.87,14.57,14.28,14.12,14.10,14.23,14.49,14.85,15.21,15.50,15.75,15.87,15.95,15.96,15.91,15.90,15.91,15.99,16.10,16.25,16.40,16.62,16.82,17,17.20,17.37,17.50,17.62,17.70,17.72,17.66,17.62,17.53,17.48,17.12,17.12,17,17,17.02,17.10,17.12,17.10,17.01,16.98,16.89,16.83,16.71,16.57,16.38,16.24,16.10,15.98,15.86,15.73,15.57,15.37,15.22,15.02,14.88,14.75,14.58,14.34,14,13.61,13.24,13.11,13.14,13.49,13.97,14.50,15,15.37,15.62,15.78,15.87,15.91,15.95,15.91,15.87,15.76,15.58,15.37,15.12,14.87,14.60,14.28,14,13.74,13.46,13.14,12.85,12.47,11.99,11.37,10.62,9.75,8.83,7.90,7.10,6.37,5.85,5.49,5.32,5.34,5.51,5.87,6.36,6.88,7.49,8.07,8.62,9.16,9.70,10.15,10.59,10.96,11.25,11.53,11.77,12,12.24,12.47,12.71,12.96,13.21,13.39,13.59,13.70,13,13,13,13,13,13,13,13,13,13,13,14,13,13,13,13,13,12,11,11,10.34,8.90,7.46,6.09,4.86,3.73,2.70,1.74,0.87,0.08,-0.63,-1.25,-1.78,-2.22,-2.50,-2.67,-2.75,-2.66,-2.50,-2.16,-1.75,-1.25,-0.63,0.03,0.77,1.58,2.37,3.21,4.01,4.86,5.64,6.45,7.21,7.91,8.50,9.07,9.61,10.14,10.71,11.22,11.70,12.12,12.53,12.90,13.25,13.57,13.82,14.01,14.20,14.28,14.36,14.35,14.27,14.16,14.03,13.90,13.77,13.70,13.63,13.63,13.71,13.78,13.91,14.10,14.25,14.41,14.61,14.75,14.90,15.07,15.16,15.27,15.37,15.47,15.52,15.61,15.65,15.75,15.85,15.83,15.75,15.63,15.50,15.36,15.22,15.11,15.01,14.97,14.77,14.09,14,14,14,14,14,15,15,15,15,14,14,14,14,14,14,14,14,14,15,14,14,14,14,14,14,14,14,14,14,13,13,13,13,19,19,19,19,19,19,20,19,19,19,19,19,19,19,19,19,19,18,18,18,18,18,17.98,17.96,17.90,17.88,17.90,17.96,17.98,18,17.99,17.98,17.95,17.87,17.72,17.47,17.25,17.09,16.91,16.78,16.64,16.50,16.37,16.22,16.03,15.87,15.70,15.48,15.22,14.89,14.59,14.26,14.07,13.99,14.10,14.35,14.71,15.07,15.37,15.62,15.75,15.83,15.83,15.78,15.77,15.78,15.87,15.98,16.12,16.28,16.50,16.71,16.88,17.09,17.25,17.38,17.48,17.51,17.53,17.51,17.48,17.37,17.25,17.12,17.02,17,17,17.01,17.10,17.11,17.07,17,16.91,16.84,16.71,16.53,16.38,16.24,16.10,15.98,15.86,15.73,15.57,15.37,15.22,15.02,14.87,14.72,14.52,14.34,14.08,13.75,13.38,13.09,12.99,13.08,13.39,13.87,14.46,14.97,15.35,15.58,15.71,15.75,15.77,15.77,15.75,15.73,15.62,15.47,15.26,15.08,14.83,14.52,14.25,13.97,13.66,13.37,13.09,12.75,12.37,11.87,11.25,10.46,9.53,8.60,7.66,6.86,6.20,5.74,5.48,5.40,5.58,5.87,6.35,6.87,7.46,8.02,8.64,9.23,9.75,10.25,10.70,11.08,11.38,11.65,11.89,12.12,12.32,12.50,12.72,12.96,13.22,13.47,13.64,13.83,13.75,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,12,11,10.96,10.03,8.91,7.66,6.46,5.25,4.15,3.12,2.15,1.25,0.46,-0.28,-0.97,-1.50,-1.98,-2.29,-2.52,-2.63,-2.61,-2.43,-2.15,-1.77,-1.28,-0.72,-0.04,0.65,1.41,2.24,3.03,3.87,4.71,5.50,6.27,7.03,7.76,8.48,8.98,9.50,10.02,10.57,11.08,11.57,12.01,12.46,12.86,13.22,13.51,13.78,14,14.16,14.25,14.28,14.25,14.16,14.03,13.88,13.74,13.60,13.50,13.45,13.45,13.50,13.62,13.75,13.90,14.10,14.26,14.47,14.62,14.77,14.95,15.08,15.16,15.27,15.37,15.46,15.50,15.60,15.66,15.66,15.63,15.61,15.60,15.47,15.33,15.20,15.10,15,14.91,14.62,14.25,14,14,14,14,14,14,15,15,15,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,13,13,13,13,13,20,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,18,18,18,18,18,17.98,17.96,17.85,17.74,17.71,17.74,17.85,17.91,17.98,18,17.99,17.98,17.91,17.82,17.51,17.28,17.12,16.98,16.85,16.72,16.58,16.40,16.25,16.10,15.89,15.72,15.48,15.21,14.87,14.51,14.21,13.97,13.87,13.98,14.23,14.59,14.96,15.26,15.50,15.63,15.71,15.71,15.66,15.65,15.70,15.75,15.87,16,16.21,16.38,16.60,16.77,16.98,17.12,17.24,17.34,17.37,17.38,17.37,17.35,17.25,17.13,17.03,17,16.99,16.99,17,17.01,17.02,17,16.95,16.86,16.71,16.52,16.37,16.23,16.09,15.97,15.85,15.72,15.57,15.37,15.23,15.07,14.88,14.73,14.51,14.32,14.08,13.82,13.50,13.21,12.91,12.85,12.90,13.25,13.74,14.27,14.83,15.22,15.47,15.58,15.62,15.62,15.61,15.58,15.52,15.48,15.33,15.15,14.97,14.73,14.46,14.14,13.86,13.53,13.24,12.90,12.58,12.15,11.65,11,10.20,9.25,8.28,7.40,6.62,6.03,5.65,5.51,5.61,5.87,6.28,6.83,7.38,8,8.61,9.20,9.75,10.26,10.75,11.15,11.50,11.78,12.01,12.23,12.38,12.57,12.74,12.95,13.21,13.47,13.70,13.86,13.91,13.76,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,12,12,11.14,10.12,9.01,7.88,6.75,5.63,4.59,3.58,2.61,1.70,0.86,0.09,-0.62,-1.22,-1.68,-2.10,-2.36,-2.50,-2.50,-2.38,-2.15,-1.80,-1.38,-0.80,-0.18,0.50,1.25,2.01,2.84,3.63,4.47,5.25,6.07,6.83,7.53,8.25,8.90,9.36,9.87,10.37,10.88,11.38,11.87,12.33,12.75,13.12,13.47,13.75,13.98,14.12,14.22,14.23,14.15,14.03,13.88,13.73,13.53,13.38,13.27,13.24,13.24,13.28,13.40,13.58,13.74,13.90,14.12,14.28,14.48,14.63,14.78,14.95,15.07,15.15,15.25,15.36,15.41,15.51,15.52,15.52,15.50,15.48,15.40,15.35,15.25,15.15,15.08,15,14.89,14.62,14.34,14.03,14,14,14,14,14,14.12,14.75,14.70,14.35,14.08,14,14,14,14,14,14.01,14.13,14.62,14.73,14.13,14,14,14,14,14,14,13,13,13,14,13,13,20,20,20,19,19,19,19,19,19,19,18,18,18,18,18,18,18,18,18,18,18,17.99,17.85,17.63,17.46,17.37,17.46,17.62,17.78,17.91,17.98,18,17.99,17.97,17.85,17.52,17.33,17.13,17,16.87,16.75,16.61,16.45,16.25,16.09,15.87,15.63,15.37,15.09,14.75,14.38,14.10,13.87,13.77,13.87,14.12,14.50,14.87,15.15,15.38,15.51,15.58,15.58,15.57,15.57,15.60,15.65,15.77,15.95,16.12,16.32,16.50,16.70,16.85,16.99,17.11,17.20,17.24,17.25,17.25,17.22,17.13,17.09,17,17,16.98,16.97,16.97,16.97,16.96,16.90,16.85,16.73,16.53,16.37,16.22,16.07,15.95,15.83,15.71,15.53,15.37,15.24,15.09,14.95,14.76,14.60,14.37,14.12,13.85,13.58,13.28,13.01,12.76,12.66,12.73,13,13.50,14.07,14.60,15.01,15.23,15.35,15.37,15.37,15.37,15.35,15.33,15.25,15.12,14.99,14.77,14.57,14.26,13.98,13.62,13.28,13,12.63,12.26,11.86,11.32,10.62,9.82,8.86,7.96,7.12,6.41,5.90,5.64,5.63,5.86,6.25,6.74,7.28,7.89,8.50,9.12,9.71,10.23,10.73,11.14,11.57,11.87,12.12,12.34,12.49,12.62,12.76,12.96,13.16,13.41,13.65,13.86,13.96,13.97,13.82,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,11.38,10.25,9.15,8.12,7.07,6,5,4,3.03,2.12,1.26,0.49,-0.25,-0.88,-1.39,-1.84,-2.13,-2.34,-2.39,-2.35,-2.15,-1.87,-1.47,-0.97,-0.38,0.28,1,1.75,2.53,3.36,4.14,4.97,5.75,6.50,7.25,7.96,8.62,9.22,9.65,10.15,10.66,11.20,11.70,12.15,12.62,13,13.37,13.70,13.90,14.08,14.12,14.12,14.03,13.89,13.74,13.52,13.35,13.16,13.08,13,13.01,13.10,13.22,13.37,13.53,13.74,13.91,14.12,14.32,14.49,14.63,14.78,14.91,15.03,15.13,15.25,15.34,15.39,15.40,15.40,15.38,15.37,15.32,15.25,15.15,15.10,15,15,14.87,14.62,14.37,14.20,14.12,14.10,14.01,14,14.01,14.16,14.37,14.45,14.34,14.13,14.02,14,14,14,14,14.01,14.14,14.27,14.26,14.13,14,13.97,13.95,13.96,14,13,13,13,13,13,13,14,20,20,20,20,19,19,19,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,17.78,17.36,17.14,17.03,17.20,17.37,17.60,17.75,17.87,17.90,17.95,17.89,17.75,17.49,17.27,17.12,17,16.87,16.75,16.60,16.41,16.25,16,15.76,15.50,15.22,14.87,14.52,14.23,13.96,13.75,13.73,13.86,14.12,14.45,14.77,15.09,15.27,15.38,15.45,15.45,15.45,15.47,15.50,15.62,15.74,15.87,16.03,16.23,16.39,16.58,16.73,16.87,16.98,17.07,17.11,17.12,17.12,17.12,17.08,17.01,17,16.98,16.96,16.91,16.90,16.88,16.86,16.77,16.70,16.53,16.36,16.16,16.01,15.88,15.76,15.64,15.51,15.37,15.24,15.11,14.98,14.85,14.66,14.48,14.23,13.95,13.65,13.38,13.12,12.87,12.62,12.50,12.52,12.77,13.25,13.84,14.35,14.74,15,15.12,15.12,15.12,15.12,15.10,15.08,15,14.90,14.75,14.59,14.35,14.03,13.72,13.37,12.99,12.61,12.21,11.82,11.36,10.78,10.11,9.28,8.38,7.57,6.78,6.20,5.78,5.66,5.82,6.12,6.61,7.14,7.76,8.38,9,9.59,10.12,10.62,11.09,11.49,11.86,12.12,12.37,12.53,12.66,12.82,12.98,13.16,13.39,13.62,13.83,13.91,13.99,13.97,13.86,13,13,13,13,12,12,12,12,12,13,13,13,13,13,13,13,13,13,12.87,11.46,10.35,9.33,8.34,7.36,6.37,5.38,4.41,3.50,2.60,1.74,0.90,0.16,-0.50,-1.05,-1.53,-1.89,-2.14,-2.26,-2.26,-2.13,-1.89,-1.53,-1.11,-0.55,0.07,0.74,1.46,2.22,3,3.77,4.59,5.37,6.12,6.87,7.59,8.25,8.91,9.39,9.90,10.41,10.96,11.48,11.98,12.46,12.87,13.26,13.60,13.84,13.99,14.03,14,13.89,13.75,13.53,13.34,13.12,12.98,12.86,12.82,12.83,12.87,13,13.15,13.36,13.53,13.75,13.95,14.12,14.33,14.50,14.63,14.78,14.91,15.03,15.13,15.25,15.27,15.32,15.32,15.28,15.25,15.22,15.14,15.10,15,14.96,14.87,14.86,14.62,14.37,14.25,14.41,14.12,14.03,14,14,14.09,14.21,14.26,14.25,14.13,14.03,14,14,14,14,14,14.03,14.09,14.08,14.01,13.97,13.87,13.78,13.63,13.20,13.01,13,13,13,13,13,13,20,20,20,20,20,19,19,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,17,17.12,17,17,17.02,17.15,17.35,17.50,17.62,17.73,17.76,17.75,17.59,17.37,17.23,17.11,16.99,16.87,16.75,16.60,16.40,16.22,15.98,15.70,15.37,15.01,14.65,14.33,14,13.76,13.64,13.65,13.84,14.09,14.37,14.71,14.99,15.15,15.25,15.28,15.32,15.34,15.37,15.47,15.58,15.72,15.86,16,16.14,16.33,16.48,16.62,16.75,16.87,16.95,17,17.01,17.01,17,17,16.99,16.98,16.95,16.88,16.87,16.83,16.75,16.71,16.62,16.49,16.34,16.14,15.99,15.84,15.71,15.60,15.49,15.37,15.24,15.12,15,14.88,14.75,14.60,14.37,14.10,13.82,13.51,13.25,13,12.75,12.50,12.37,12.37,12.62,13.12,13.64,14.14,14.51,14.75,14.84,14.85,14.84,14.83,14.83,14.78,14.75,14.64,14.50,14.28,14.01,13.72,13.35,12.95,12.51,12.09,11.64,11.15,10.63,10.12,9.46,8.65,7.87,7.12,6.47,5.96,5.71,5.74,6,6.41,6.98,7.59,8.22,8.84,9.40,9.96,10.46,10.88,11.32,11.71,12.03,12.32,12.51,12.66,12.78,12.97,13.13,13.37,13.62,13.78,13.90,13.98,13.99,13.98,13.87,13,13,13,12,12,12,12,12,12,12,12,12,12,12,12,13,13,13,12.07,11.28,10.37,9.46,8.53,7.62,6.72,5.77,4.87,3.96,3.07,2.20,1.37,0.61,-0.11,-0.72,-1.24,-1.63,-1.92,-2.13,-2.16,-2.12,-1.91,-1.63,-1.25,-0.76,-0.22,0.41,1.12,1.85,2.60,3.37,4.12,4.90,5.66,6.40,7.13,7.85,8.50,9.14,9.62,10.13,10.66,11.22,11.75,12.25,12.74,13.13,13.49,13.74,13.87,13.91,13.87,13.75,13.59,13.36,13.12,12.90,12.75,12.63,12.60,12.61,12.66,12.82,12.97,13.13,13.35,13.53,13.75,13.97,14.14,14.35,14.50,14.65,14.82,14.96,15.09,15.13,15.20,15.22,15.23,15.21,15.16,15.12,15.09,15,14.96,14.87,14.78,14.70,14.52,14.37,14.27,14.21,14.12,14.03,14,14,14.01,14.09,14.13,14.13,14.11,14.02,14,13.99,13.99,13.99,14,14,14,13.98,13.91,13.87,13.75,13.61,13.37,13.16,13.01,13,13,13,13,13,13,20,20,20,20,20,19,19,19,18,18,17,18,18,18,18,18,18,18,18,18,18,17,17,16.99,17,16.99,17,17.02,17.12,17.24,17.34,17.41,17.50,17.49,17.35,17.25,17.14,17.07,16.97,16.87,16.75,16.61,16.40,16.20,15.89,15.59,15.23,14.84,14.41,14.08,13.75,13.58,13.50,13.58,13.75,14.01,14.33,14.61,14.87,15,15.11,15.14,15.16,15.24,15.32,15.41,15.53,15.70,15.83,15.97,16.11,16.25,16.38,16.52,16.64,16.75,16.86,16.89,16.95,16.95,16.95,16.91,16.91,16.91,16.87,16.78,16.74,16.65,16.60,16.50,16.37,16.25,16.11,15.95,15.76,15.62,15.50,15.38,15.32,15.22,15.12,15.01,14.91,14.84,14.66,14.50,14.25,14,13.72,13.41,13.15,12.89,12.62,12.37,12.24,12.34,12.60,13.01,13.53,14,14.35,14.50,14.53,14.52,14.50,14.50,14.49,14.47,14.39,14.27,14.12,13.87,13.60,13.24,12.82,12.37,11.88,11.40,10.95,10.41,9.88,9.34,8.71,8,7.33,6.65,6.12,5.75,5.64,5.84,6.22,6.73,7.33,7.97,8.60,9.20,9.74,10.23,10.65,11.09,11.47,11.83,12.13,12.40,12.62,12.75,12.87,13.01,13.25,13.50,13.75,13.88,13.97,13.99,13.98,13.98,13.91,13,13,13,12,12,12,12,12,11,11,11,11,11,11,12,12,12,12,11.75,11.11,10.37,9.58,8.75,7.89,7.03,6.16,5.28,4.39,3.52,2.65,1.85,1.07,0.35,-0.30,-0.88,-1.35,-1.67,-1.91,-2.04,-2.04,-1.92,-1.73,-1.38,-0.98,-0.48,0.12,0.75,1.41,2.13,2.88,3.63,4.39,5.14,5.89,6.62,7.35,8.01,8.70,9.35,9.83,10.37,10.95,11.50,12.07,12.58,13,13.37,13.62,13.76,13.83,13.75,13.61,13.38,13.14,12.90,12.72,12.52,12.41,12.37,12.38,12.48,12.60,12.75,12.95,13.13,13.36,13.58,13.77,14,14.20,14.37,14.53,14.72,14.87,14.98,15.03,15.11,15.12,15.12,15.12,15.10,15.07,15,14.97,14.87,14.82,14.72,14.60,14.47,14.35,14.24,14.13,14.09,14.01,14,14,14,14,14.02,14.03,14.02,14,14,13.99,13.99,13.99,13.98,13.98,13.96,13.90,13.85,13.74,13.58,13.37,13.22,13.09,13,12.99,12.99,12.99,13,13,13,20,20,20,21,20,19,19,19,19,18,17,17,18,18,18,18,18,18,18,18,17,17,17,17,16.99,16.99,16.99,17,17,17.03,17.03,17.15,17.23,17.22,17.14,17.14,17.11,17.02,16.97,16.87,16.75,16.61,16.40,16.15,15.86,15.50,15.08,14.62,14.21,13.83,13.51,13.37,13.35,13.46,13.65,13.96,14.25,14.50,14.72,14.86,14.96,15,15.08,15.13,15.25,15.37,15.51,15.65,15.78,15.91,16.07,16.20,16.34,16.47,16.60,16.71,16.76,16.84,16.87,16.87,16.86,16.85,16.84,16.83,16.74,16.63,16.57,16.48,16.37,16.25,16.12,16,15.87,15.72,15.57,15.41,15.33,15.24,15.14,15.10,15.01,14.97,14.87,14.75,14.61,14.38,14.14,13.88,13.62,13.35,13.07,12.76,12.49,12.23,12.12,12.22,12.50,12.98,13.47,13.89,14.15,14.25,14.24,14.16,14.12,14.09,14.03,14,13.96,13.77,13.57,13.26,12.96,12.53,12.11,11.61,11.12,10.61,10.12,9.62,9.11,8.53,7.98,7.37,6.78,6.25,5.86,5.62,5.70,5.99,6.45,7,7.63,8.27,8.88,9.46,9.95,10.37,10.76,11.14,11.51,11.87,12.16,12.45,12.64,12.76,12.89,13.03,13.24,13.49,13.75,13.89,13.91,13.96,13.97,13.86,14,13,13,13,12,13,13,12,11,10,10,9,10,10,11,12,12,12,12,11.58,11,10.37,9.66,8.95,8.16,7.37,6.57,5.73,4.87,4,3.14,2.34,1.52,0.77,0.12,-0.50,-1,-1.39,-1.72,-1.88,-1.98,-1.91,-1.75,-1.50,-1.15,-0.73,-0.22,0.37,1,1.66,2.37,3.12,3.86,4.60,5.33,6.03,6.75,7.48,8.15,8.85,9.46,10.01,10.62,11.25,11.85,12.38,12.87,13.25,13.52,13.66,13.71,13.62,13.45,13.22,12.97,12.72,12.50,12.33,12.22,12.15,12.16,12.25,12.37,12.52,12.74,12.95,13.14,13.37,13.62,13.84,14.03,14.25,14.45,14.62,14.75,14.87,14.97,15,15.03,15.07,15.03,15.01,15,14.96,14.88,14.84,14.75,14.62,14.51,14.39,14.28,14.20,14.12,14.03,14,14,13.99,13.99,14,14,14,14,14,13.99,13.99,13.98,13.98,13.97,13.95,13.88,13.84,13.72,13.58,13.38,13.23,13.11,13.01,12.99,12.97,12.97,12.98,12.99,13,13,20,20,20,20,20,19,19,19,19,18,17,17,17,18,18,17,17,17,17,17,17,17,17,17,17,17,16.99,16.99,16.99,16.99,17,17,17.03,17.08,17.10,17.12,17.10,17.02,16.96,16.87,16.75,16.62,16.40,16.14,15.83,15.40,14.96,14.47,14,13.59,13.27,13.13,13.14,13.32,13.57,13.85,14.12,14.38,14.60,14.74,14.84,14.89,15,15.11,15.23,15.37,15.50,15.64,15.76,15.89,16.01,16.14,16.26,16.39,16.51,16.62,16.72,16.75,16.77,16.76,16.75,16.72,16.65,16.62,16.53,16.46,16.37,16.25,16.14,16,15.87,15.75,15.62,15.49,15.36,15.25,15.14,15.09,15.02,15,14.96,14.89,14.83,14.71,14.51,14.28,14.07,13.77,13.50,13.23,12.90,12.60,12.25,12,11.95,12.08,12.41,12.87,13.37,13.76,13.98,13.98,13.87,13.75,13.63,13.58,13.50,13.40,13.28,13.10,12.78,12.45,12.07,11.63,11.15,10.66,10.21,9.74,9.25,8.77,8.32,7.82,7.33,6.84,6.37,5.98,5.66,5.64,5.85,6.20,6.70,7.27,7.90,8.51,9.10,9.60,10.01,10.40,10.77,11.13,11.50,11.84,12.12,12.38,12.60,12.75,12.87,13.01,13.16,13.36,13.51,13.62,13.63,13.63,13.74,13.88,13,13,13,13,13,12.98,12.74,11.99,11.26,10.75,10.32,10.23,10.25,10.62,11.03,11.47,11.70,11.74,11.62,11.35,10.87,10.35,9.76,9.12,8.40,7.66,6.90,6.12,5.32,4.48,3.62,2.82,2,1.25,0.57,-0.10,-0.63,-1.10,-1.43,-1.68,-1.85,-1.88,-1.77,-1.62,-1.34,-0.97,-0.50,0,0.59,1.21,1.87,2.53,3.25,3.98,4.71,5.40,6.13,6.87,7.58,8.27,9,9.62,10.34,10.97,11.62,12.24,12.75,13.16,13.46,13.59,13.59,13.48,13.26,13.01,12.75,12.50,12.26,12.11,12,11.96,11.97,12.02,12.14,12.34,12.50,12.74,12.98,13.22,13.46,13.70,13.90,14.14,14.36,14.51,14.65,14.77,14.87,14.95,14.99,15,15,14.98,14.95,14.88,14.85,14.76,14.66,14.58,14.48,14.36,14.25,14.14,14.10,14.02,14,13.99,13.98,13.98,13.98,13.98,13.98,13.98,13.98,13.98,13.98,13.98,13.96,13.90,13.87,13.78,13.70,13.53,13.37,13.24,13.12,13.01,12.98,12.95,12.89,12.87,12.87,12.88,12.97,13,20,20,20,20,20,20,19,19,19,18,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,16.99,16.99,16.99,17,17,17.02,17.12,17.14,17.13,17.03,16.97,16.87,16.76,16.62,16.41,16.14,15.82,15.37,14.87,14.35,13.84,13.38,13.10,12.97,12.99,13.14,13.41,13.74,14.01,14.26,14.48,14.62,14.74,14.85,14.96,15.07,15.21,15.36,15.50,15.62,15.75,15.87,16,16.12,16.25,16.37,16.50,16.59,16.64,16.70,16.71,16.66,16.62,16.57,16.48,16.39,16.35,16.26,16.21,16.11,15.99,15.84,15.64,15.50,15.37,15.25,15.14,15.08,15,14.96,14.90,14.88,14.87,14.84,14.75,14.62,14.45,14.21,13.95,13.64,13.37,13.07,12.72,12.32,11.98,11.74,11.70,11.87,12.25,12.74,13.22,13.58,13.66,13.61,13.40,13.24,13.07,12.90,12.77,12.62,12.41,12.13,11.77,11.38,11,10.53,10.11,9.70,9.25,8.85,8.41,8,7.59,7.15,6.76,6.40,6.11,5.87,5.75,5.78,6.08,6.47,6.98,7.53,8.13,8.71,9.22,9.63,10.01,10.37,10.73,11.08,11.40,11.75,12.03,12.32,12.50,12.66,12.84,12.99,13.12,13.25,13.35,13.35,13.34,13.32,13.16,13,13,13,13,12.90,12.85,12.70,12.38,11.98,11.50,11.11,10.84,10.71,10.74,10.88,11.12,11.36,11.50,11.52,11.45,11.20,10.77,10.32,9.75,9.15,8.53,7.97,7.25,6.50,5.73,4.90,4.11,3.28,2.50,1.74,1,0.36,-0.25,-0.75,-1.14,-1.47,-1.65,-1.76,-1.76,-1.65,-1.47,-1.15,-0.78,-0.36,0.15,0.73,1.34,1.98,2.63,3.34,4.02,4.75,5.47,6.20,6.90,7.64,8.38,9.12,9.87,10.66,11.38,12.10,12.71,13.14,13.40,13.51,13.49,13.35,13.12,12.85,12.57,12.27,12.07,11.87,11.75,11.73,11.74,11.82,11.95,12.11,12.32,12.52,12.76,13.02,13.27,13.53,13.82,14.02,14.25,14.45,14.60,14.73,14.83,14.87,14.90,14.95,14.95,14.90,14.87,14.85,14.77,14.72,14.62,14.50,14.40,14.33,14.23,14.12,14.08,14,13.99,13.98,13.98,13.97,13.97,13.97,13.97,13.97,13.97,13.97,13.97,13.95,13.89,13.85,13.75,13.62,13.50,13.37,13.23,13.12,13.01,12.98,12.91,12.87,12.77,12.72,12.66,12.66,12.71,12.95,20,20,20,20,20,20,19,19,19,18,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17.01,17,17,17.10,17.47,17.13,17.03,16.97,16.87,16.77,16.63,16.46,16.16,15.83,15.37,14.84,14.25,13.72,13.25,12.95,12.78,12.84,13,13.27,13.62,13.90,14.16,14.37,14.52,14.65,14.77,14.89,15.02,15.16,15.34,15.48,15.62,15.75,15.87,15.99,16.12,16.24,16.36,16.46,16.51,16.59,16.61,16.60,16.57,16.49,16.38,16.28,16.22,16.15,16.12,16.08,16,15.87,15.71,15.50,15.28,15.12,15.03,14.98,14.88,14.85,14.82,14.76,14.75,14.75,14.74,14.64,14.51,14.34,14.09,13.78,13.50,13.16,12.83,12.37,11.99,11.62,11.39,11.39,11.64,12.08,12.52,12.98,13.25,13.26,13.11,12.87,12.61,12.36,12.13,11.91,11.70,11.38,11.03,10.62,10.22,9.77,9.39,9.02,8.70,8.35,8,7.64,7.33,7,6.70,6.39,6.20,6,5.95,5.97,6.12,6.38,6.78,7.27,7.83,8.36,8.85,9.26,9.64,10,10.33,10.63,11,11.36,11.66,11.99,12.24,12.45,12.62,12.78,12.96,13.11,13.24,13.26,13.16,13.02,13.01,13,13,13,12.97,12.90,12.85,12.74,12.57,12.32,12,11.65,11.37,11.20,11.09,11.08,11.12,11.25,11.36,11.41,11.41,11.32,11.08,10.73,10.26,9.76,9.24,8.65,8.08,7.47,6.85,6.11,5.35,4.53,3.75,2.98,2.21,1.48,0.77,0.16,-0.38,-0.84,-1.18,-1.47,-1.63,-1.72,-1.66,-1.53,-1.34,-1.02,-0.65,-0.24,0.25,0.82,1.39,2.01,2.66,3.36,4.02,4.75,5.48,6.22,6.98,7.75,8.52,9.37,10.24,11.13,12.03,12.75,13.20,13.48,13.52,13.41,13.24,12.98,12.65,12.37,12.08,11.84,11.63,11.51,11.48,11.49,11.58,11.71,11.87,12.10,12.34,12.60,12.87,13.13,13.40,13.70,13.95,14.14,14.37,14.51,14.65,14.75,14.84,14.87,14.87,14.87,14.87,14.85,14.78,14.73,14.63,14.57,14.47,14.37,14.26,14.20,14.12,14.03,14,13.99,13.97,13.97,13.96,13.96,13.96,13.96,13.95,13.91,13.90,13.89,13.87,13.82,13.72,13.59,13.46,13.33,13.21,13.11,13.01,12.98,12.90,12.85,12.74,12.61,12.49,12.39,12.37,12.32,11.73,20,20,20,20,20,20,19,19,19,18,18,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17.97,17.03,17,17,17.08,17.12,17.11,17.01,16.96,16.87,16.78,16.65,16.49,16.22,15.85,15.37,14.84,14.24,13.64,13.16,12.84,12.66,12.72,12.88,13.16,13.50,13.83,14.11,14.33,14.50,14.62,14.75,14.88,15.01,15.15,15.32,15.46,15.60,15.73,15.86,15.98,16.10,16.22,16.33,16.39,16.47,16.50,16.50,16.48,16.41,16.36,16.25,16.15,16.10,16.07,16.03,16,15.96,15.84,15.63,15.38,15.13,14.97,14.85,14.76,14.72,14.64,14.62,14.59,14.59,14.59,14.58,14.50,14.37,14.21,13.95,13.62,13.28,12.90,12.50,12.01,11.61,11.25,11.08,11.12,11.41,11.86,12.27,12.63,12.84,12.75,12.52,12.22,11.87,11.53,11.25,10.96,10.62,10.25,9.86,9.38,8.97,8.59,8.25,8,7.75,7.50,7.26,7.02,6.82,6.59,6.41,6.27,6.20,6.13,6.16,6.28,6.50,6.83,7.22,7.65,8.12,8.59,9,9.37,9.66,9.99,10.27,10.62,10.97,11.33,11.65,11.97,12.23,12.41,12.62,12.78,12.97,13.12,13.25,13.37,13.27,13.12,13,13,13,12.97,12.91,12.87,12.78,12.66,12.50,12.28,12.07,11.83,11.62,11.48,11.37,11.36,11.37,11.37,11.39,11.39,11.36,11.23,10.99,10.64,10.25,9.78,9.28,8.75,8.21,7.62,7.01,6.46,5.73,4.97,4.21,3.40,2.64,1.91,1.24,0.60,0.01,-0.49,-0.88,-1.23,-1.43,-1.60,-1.63,-1.59,-1.43,-1.24,-0.92,-0.59,-0.15,0.33,0.85,1.39,2,2.63,3.32,4,4.72,5.47,6.24,7.03,7.89,8.77,9.75,10.75,11.75,12.71,13.39,13.76,13.59,13.39,13.14,12.84,12.50,12.14,11.85,11.59,11.37,11.25,11.21,11.22,11.28,11.46,11.63,11.87,12.12,12.40,12.72,13,13.32,13.60,13.86,14.10,14.28,14.49,14.62,14.73,14.77,14.84,14.85,14.85,14.83,14.77,14.74,14.65,14.59,14.50,14.40,14.34,14.24,14.14,14.09,14.01,14,13.98,13.96,13.96,13.95,13.95,13.91,13.90,13.87,13.86,13.84,13.77,13.75,13.64,13.52,13.39,13.26,13.14,13.09,13.01,12.98,12.90,12.84,12.73,12.58,12.38,12.25,12.15,12.11,11.98,11.51,20,20,20,20,20,20,19,19,19,18,18,18,17,16,17,17,17,17,17,18,17,17,17,17,17,17,17,17,16.99,17.01,17.95,17.08,17,17,17,17.01,17,17,16.95,16.87,16.82,16.70,16.50,16.25,15.87,15.40,14.87,14.25,13.64,13.13,12.76,12.61,12.62,12.82,13.11,13.41,13.75,14.07,14.27,14.48,14.62,14.75,14.88,15,15.13,15.26,15.40,15.57,15.66,15.83,15.95,16.08,16.16,16.26,16.36,16.37,16.38,16.37,16.36,16.28,16.24,16.14,16.09,16.01,16,16,15.99,15.91,15.83,15.62,15.37,15.08,14.83,14.65,14.60,14.50,14.45,14.37,14.34,14.33,14.34,14.35,14.33,14.23,14.02,13.76,13.46,13.08,12.62,12.12,11.63,11.21,10.87,10.75,10.88,11.24,11.62,12.01,12.27,12.36,12.21,11.87,11.49,11.07,10.64,10.27,9.90,9.52,9.12,8.65,8.21,7.77,7.46,7.22,7.07,6.95,6.85,6.75,6.62,6.52,6.48,6.40,6.38,6.38,6.46,6.58,6.75,7,7.34,7.71,8.11,8.50,8.87,9.23,9.51,9.77,10.03,10.34,10.63,11,11.37,11.74,12.02,12.28,12.50,12.70,12.86,13,13.16,13.35,13.48,13.60,13.24,13.08,13.01,13,12.97,12.90,12.87,12.76,12.64,12.50,12.34,12.12,11.97,11.83,11.73,11.63,11.61,11.57,11.51,11.49,11.40,11.32,11.12,10.88,10.59,10.22,9.78,9.35,8.85,8.33,7.75,7.21,6.61,6,5.35,4.60,3.85,3.10,2.37,1.65,1,0.41,-0.12,-0.55,-0.92,-1.24,-1.41,-1.53,-1.55,-1.50,-1.38,-1.15,-0.88,-0.52,-0.13,0.33,0.83,1.37,1.96,2.58,3.24,3.91,4.65,5.47,6.28,7.21,8.14,9.21,10.28,11.41,12.50,13.27,13.65,13.66,13.49,13.12,12.72,12.32,11.91,11.60,11.28,11.09,10.95,10.87,10.88,11,11.15,11.38,11.65,11.97,12.26,12.61,12.91,13.24,13.52,13.82,14.03,14.25,14.46,14.60,14.70,14.75,14.78,14.82,14.78,14.76,14.75,14.66,14.61,14.51,14.46,14.37,14.26,14.21,14.12,14.07,14,13.98,13.96,13.91,13.91,13.90,13.88,13.87,13.84,13.76,13.73,13.64,13.61,13.53,13.47,13.36,13.23,13.12,13.03,13,12.97,12.89,12.84,12.72,12.53,12.37,12.22,12.10,12,11.98,11.87,11.35,20,20,20,20,20,20,19,19,19,18,18,18,18,17,16,17,17,17,17,18,17,17,17,17,17,17,17,17,17,17.03,17.90,17.10,17,16.99,16.99,16.99,16.99,16.97,16.91,16.87,16.82,16.71,16.51,16.26,15.90,15.47,14.89,14.27,13.70,13.14,12.76,12.59,12.60,12.75,13.03,13.38,13.75,14.03,14.26,14.49,14.63,14.76,14.88,15,15.12,15.25,15.37,15.50,15.62,15.75,15.88,16.01,16.12,16.22,16.25,16.27,16.26,16.25,16.23,16.15,16.12,16.08,16.01,16,16,15.99,15.98,15.95,15.84,15.63,15.36,15.01,14.73,14.50,14.39,14.28,14.21,14.12,14.03,14.01,14.03,14.09,14.10,14.01,13.87,13.62,13.26,12.86,12.35,11.82,11.27,10.86,10.59,10.52,10.75,11.08,11.46,11.75,11.89,11.86,11.61,11.21,10.73,10.23,9.75,9.33,8.89,8.49,8.03,7.61,7.14,6.77,6.50,6.37,6.36,6.37,6.45,6.48,6.51,6.57,6.60,6.63,6.72,6.77,6.89,7.08,7.28,7.59,7.88,8.25,8.61,8.96,9.25,9.53,9.77,10,10.22,10.47,10.75,11.12,11.50,11.87,12.21,12.47,12.65,12.85,12.99,13.12,13.26,13.45,13.60,13.75,13.83,13.12,13.12,13.02,12.98,12.90,12.87,12.76,12.65,12.52,12.37,12.24,12.11,12,11.91,11.87,11.82,11.75,11.64,11.57,11.41,11.25,11.07,10.82,10.50,10.14,9.76,9.36,8.88,8.39,7.88,7.35,6.75,6.16,5.53,4.96,4.23,3.50,2.76,2.10,1.45,0.84,0.26,-0.23,-0.63,-0.98,-1.24,-1.39,-1.50,-1.50,-1.43,-1.34,-1.13,-0.87,-0.52,-0.15,0.26,0.75,1.27,1.86,2.48,3.13,3.87,4.64,5.50,6.41,7.46,8.59,9.77,11.03,12.25,13.13,13.53,13.52,13.33,12.97,12.57,12.14,11.76,11.41,11.12,10.88,10.75,10.66,10.71,10.82,11,11.24,11.51,11.85,12.16,12.51,12.87,13.21,13.50,13.77,14.02,14.25,14.41,14.58,14.65,14.74,14.75,14.76,14.75,14.75,14.70,14.62,14.53,14.48,14.38,14.33,14.24,14.14,14.10,14.01,13.98,13.95,13.89,13.88,13.87,13.87,13.84,13.76,13.72,13.62,13.51,13.46,13.37,13.32,13.24,13.13,13.07,12.99,12.95,12.89,12.87,12.82,12.70,12.52,12.37,12.20,12.02,11.97,11.95,11.91,11.78,11.13,20,20,20,20,20,20,19,19,19,18,18,18,18,18,17,17,17,18,17,17,17,17,17,17,17,17,17,16.99,17,17.07,17.10,17.12,17,16.99,16.99,16.98,16.98,16.96,16.90,16.87,16.82,16.71,16.52,16.28,15.96,15.50,14.96,14.35,13.74,13.21,12.78,12.60,12.60,12.75,13.02,13.37,13.74,14,14.26,14.50,14.64,14.77,14.88,15,15.10,15.21,15.33,15.41,15.57,15.71,15.84,15.96,16.03,16.12,16.14,16.15,16.13,16.12,16.09,16.07,16.01,16,16,15.99,15.99,15.98,15.98,15.95,15.86,15.64,15.37,15,14.64,14.38,14.23,14.11,13.98,13.85,13.75,13.73,13.75,13.82,13.86,13.83,13.71,13.47,13.12,12.62,12.12,11.57,11,10.60,10.37,10.37,10.61,10.91,11.25,11.49,11.50,11.36,11,10.50,9.97,9.39,8.88,8.40,8,7.59,7.15,6.75,6.40,6.10,5.87,5.87,5.98,6.15,6.36,6.51,6.65,6.78,6.90,7.03,7.15,7.28,7.46,7.63,7.88,8.16,8.50,8.85,9.15,9.48,9.75,9.97,10.12,10.27,10.46,10.64,10.91,11.26,11.64,12.03,12.38,12.65,12.87,13.01,13.13,13.25,13.38,13.52,13.65,13.84,13.78,13.45,13.22,13.10,13,12.95,12.87,12.77,12.70,12.58,12.46,12.35,12.25,12.15,12.12,12.07,11.99,11.88,11.75,11.62,11.41,11.23,10.98,10.72,10.39,10.09,9.74,9.35,8.90,8.48,7.99,7.47,6.89,6.34,5.75,5.12,4.57,3.86,3.14,2.49,1.84,1.23,0.64,0.13,-0.29,-0.66,-0.99,-1.22,-1.38,-1.47,-1.48,-1.40,-1.28,-1.13,-0.88,-0.59,-0.23,0.20,0.64,1.15,1.75,2.37,3.07,3.84,4.66,5.62,6.66,7.87,9.20,10.60,11.95,12.96,13.39,13.37,13.16,12.82,12.40,12.01,11.63,11.27,10.99,10.74,10.58,10.50,10.51,10.63,10.85,11.11,11.40,11.75,12.12,12.49,12.85,13.20,13.50,13.77,14.03,14.25,14.41,14.57,14.63,14.72,14.75,14.75,14.74,14.70,14.62,14.57,14.50,14.40,14.35,14.25,14.20,14.12,14.03,14,13.95,13.88,13.87,13.85,13.83,13.77,13.74,13.63,13.53,13.41,13.32,13.23,13.12,13.08,13,12.91,12.87,12.82,12.77,12.75,12.72,12.62,12.49,12.34,12.14,12,11.87,11.84,11.86,11.87,11.75,10.98,20,20,20,20,20,20,19,19,19,18,18,18,18,18,17,17,17,18,17,17,17,17,17,17,17,17,17,16.99,16.99,17,17,17,16.99,16.99,16.99,16.98,16.98,16.96,16.90,16.87,16.78,16.71,16.52,16.28,15.97,15.50,14.99,14.37,13.77,13.25,12.85,12.62,12.60,12.75,13,13.37,13.71,14,14.25,14.48,14.63,14.76,14.87,14.98,15.03,15.13,15.25,15.36,15.49,15.61,15.74,15.85,15.91,16,16,16,16,15.98,15.96,15.91,15.91,15.95,15.96,15.97,15.97,15.98,15.97,15.95,15.86,15.65,15.37,15,14.62,14.34,14.12,13.96,13.75,13.59,13.48,13.41,13.47,13.53,13.62,13.62,13.52,13.33,12.99,12.49,11.91,11.37,10.84,10.41,10.24,10.25,10.47,10.75,11.01,11.16,11.11,10.84,10.38,9.86,9.25,8.65,8.13,7.65,7.25,6.88,6.53,6.25,6,5.84,5.75,5.83,6.02,6.33,6.58,6.78,7,7.22,7.37,7.57,7.72,7.87,8.03,8.25,8.50,8.82,9.12,9.46,9.75,10.03,10.25,10.45,10.53,10.62,10.73,10.87,11.11,11.41,11.83,12.23,12.59,12.87,13.09,13.23,13.33,13.40,13.50,13.62,13.71,13.73,13.63,13.49,13.28,13.14,13.07,12.98,12.88,12.82,12.73,12.62,12.51,12.45,12.37,12.33,12.25,12.22,12.12,12,11.86,11.63,11.40,11.14,10.87,10.61,10.32,10,9.65,9.32,8.90,8.50,8.02,7.53,7.01,6.48,5.88,5.33,4.74,4.15,3.50,2.85,2.21,1.61,1.02,0.50,0.03,-0.37,-0.72,-1,-1.18,-1.36,-1.41,-1.43,-1.39,-1.29,-1.13,-0.91,-0.64,-0.30,0.09,0.51,1.02,1.62,2.25,3,3.85,4.77,5.87,7.09,8.50,10.02,11.61,12.74,13.25,13.24,13.07,12.66,12.28,11.89,11.51,11.14,10.85,10.59,10.39,10.35,10.37,10.50,10.73,11,11.35,11.72,12.11,12.49,12.87,13.22,13.52,13.83,14.08,14.26,14.45,14.57,14.63,14.71,14.73,14.73,14.71,14.63,14.58,14.50,14.41,14.37,14.28,14.23,14.13,14.09,14,13.97,13.89,13.86,13.83,13.76,13.74,13.66,13.61,13.50,13.37,13.25,13.12,13,12.90,12.85,12.75,12.70,12.62,12.59,12.53,12.50,12.45,12.34,12.22,12.08,11.91,11.82,11.72,11.71,11.76,11.87,11.74,10.83,20,20,20,20,20,20,19,19,19,18,18,18,18,18,17,17,17,17,17,18,17,17,17,17,17,17,16.99,16.99,16.99,16.99,16.99,16.99,16.99,16.99,16.99,16.98,16.98,16.96,16.90,16.87,16.77,16.65,16.50,16.26,15.96,15.50,15,14.40,13.83,13.27,12.87,12.63,12.61,12.74,12.99,13.32,13.62,13.95,14.21,14.41,14.61,14.74,14.84,14.89,15,15.09,15.15,15.25,15.37,15.50,15.61,15.72,15.77,15.84,15.86,15.86,15.84,15.82,15.78,15.78,15.83,15.87,15.89,15.95,15.96,15.98,15.96,15.91,15.85,15.64,15.37,15,14.63,14.34,14.09,13.86,13.61,13.37,13.21,13.13,13.20,13.27,13.37,13.41,13.37,13.16,12.84,12.36,11.77,11.23,10.72,10.32,10.12,10.12,10.26,10.50,10.72,10.77,10.63,10.32,9.84,9.25,8.64,8.09,7.58,7.13,6.77,6.50,6.25,6.10,5.99,5.95,6.09,6.32,6.52,6.78,7.08,7.32,7.52,7.75,7.91,8.11,8.26,8.47,8.64,8.87,9.12,9.41,9.75,10.08,10.37,10.62,10.82,10.90,10.97,10.97,10.98,11.03,11.24,11.52,11.91,12.35,12.74,13.02,13.25,13.37,13.49,13.57,13.62,13.70,13.73,13.71,13.62,13.50,13.36,13.23,13.11,13,12.91,12.85,12.75,12.66,12.61,12.52,12.50,12.46,12.38,12.35,12.25,12.10,11.88,11.64,11.37,11.10,10.77,10.49,10.20,9.87,9.59,9.25,8.87,8.49,8.07,7.60,7.11,6.58,6.01,5.48,4.90,4.37,3.77,3.14,2.52,1.96,1.38,0.87,0.38,-0.02,-0.39,-0.73,-0.99,-1.17,-1.34,-1.40,-1.42,-1.40,-1.34,-1.18,-1,-0.75,-0.43,-0.05,0.37,0.88,1.50,2.20,3,3.90,4.99,6.22,7.63,9.34,11.12,12.87,13.10,13.09,12.98,12.57,12.20,11.78,11.39,11.02,10.71,10.41,10.25,10.20,10.24,10.37,10.62,10.96,11.32,11.72,12.12,12.50,12.88,13.25,13.59,13.87,14.11,14.28,14.46,14.57,14.62,14.66,14.71,14.70,14.63,14.59,14.50,14.46,14.37,14.32,14.25,14.16,14.11,14.02,13.99,13.91,13.87,13.83,13.75,13.72,13.63,13.58,13.48,13.36,13.23,13.09,12.95,12.82,12.71,12.62,12.51,12.45,12.37,12.28,12.24,12.16,12.10,12,11.88,11.78,11.71,11.61,11.52,11.57,11.70,11.86,11.85,10.70,20,20,20,20,20,20,19,19,19,18,18,18,18,18,17,17,17,17,17,17,17,17,17,17,17,17,16.99,16.99,16.99,16.99,16.99,16.99,16.99,16.99,16.99,16.99,16.98,16.97,16.90,16.86,16.75,16.62,16.47,16.23,15.89,15.50,14.99,14.40,13.85,13.33,12.88,12.63,12.59,12.66,12.89,13.21,13.50,13.83,14.10,14.34,14.50,14.63,14.75,14.83,14.89,14.99,15.07,15.13,15.25,15.36,15.46,15.52,15.61,15.63,15.64,15.64,15.63,15.62,15.62,15.64,15.71,15.75,15.85,15.89,15.96,15.96,15.95,15.88,15.82,15.63,15.37,15.03,14.71,14.38,14.12,13.83,13.50,13.20,12.98,12.87,12.95,13.02,13.14,13.23,13.16,13,12.62,12.20,11.63,11.08,10.58,10.15,9.96,9.90,10,10.16,10.32,10.32,10.12,9.76,9.28,8.75,8.21,7.66,7.25,6.88,6.62,6.45,6.32,6.27,6.39,6.50,6.65,6.88,7.14,7.40,7.66,7.89,8.12,8.28,8.49,8.64,8.85,9.01,9.25,9.49,9.75,10.03,10.36,10.63,10.90,11.15,11.32,11.37,11.35,11.25,11.15,11.14,11.26,11.57,11.96,12.37,12.78,13.12,13.37,13.50,13.62,13.66,13.74,13.75,13.75,13.71,13.62,13.50,13.38,13.26,13.14,13.03,12.96,12.87,12.82,12.75,12.66,12.62,12.60,12.53,12.50,12.41,12.33,12.13,11.90,11.63,11.34,11,10.66,10.37,10.08,9.76,9.48,9.14,8.83,8.46,8.03,7.61,7.12,6.62,6.12,5.60,5.03,4.50,4.01,3.41,2.85,2.26,1.74,1.22,0.75,0.32,-0.10,-0.42,-0.74,-0.98,-1.15,-1.29,-1.39,-1.43,-1.43,-1.38,-1.26,-1.12,-0.88,-0.60,-0.23,0.24,0.75,1.38,2.13,3,4.02,5.25,6.66,8.37,10.45,12.63,12.87,12.97,12.74,12.45,12.09,11.70,11.28,10.89,10.57,10.27,10.12,10.07,10.12,10.28,10.58,10.90,11.32,11.74,12.14,12.52,12.89,13.25,13.57,13.84,14.07,14.24,14.37,14.49,14.57,14.60,14.62,14.61,14.57,14.50,14.46,14.37,14.34,14.25,14.21,14.12,14.08,14,13.96,13.88,13.85,13.76,13.72,13.62,13.57,13.47,13.35,13.23,13.10,12.96,12.77,12.62,12.50,12.38,12.32,12.23,12.12,12.02,11.95,11.87,11.77,11.72,11.62,11.59,11.50,11.38,11.34,11.37,11.53,11.78,11.91,11.58,20,20,20,20,20,20,19,19,19,18,18,18,18,18,17,17,17,17,17,17,17,17,17,17,17,16.99,16.99,16.99,16.99,16.99,16.99,16.99,16.99,16.99,16.99,16.99,16.98,16.97,16.90,16.84,16.73,16.58,16.37,16.14,15.85,15.45,14.96,14.39,13.85,13.33,12.89,12.62,12.52,12.61,12.77,13.07,13.37,13.64,13.95,14.16,14.37,14.51,14.63,14.72,14.78,14.87,14.95,15,15.10,15.16,15.25,15.35,15.38,15.41,15.45,15.45,15.45,15.45,15.47,15.50,15.58,15.64,15.75,15.87,15.91,15.91,15.90,15.86,15.75,15.61,15.37,15.10,14.76,14.48,14.15,13.84,13.41,13.02,12.76,12.63,12.66,12.76,12.88,12.98,12.96,12.77,12.39,11.96,11.40,10.87,10.37,9.97,9.72,9.62,9.64,9.75,9.82,9.75,9.60,9.26,8.86,8.37,7.91,7.50,7.20,6.96,6.78,6.74,6.78,6.87,7,7.15,7.38,7.64,7.90,8.15,8.37,8.58,8.74,8.87,9.01,9.20,9.37,9.59,9.83,10.09,10.36,10.63,10.91,11.21,11.45,11.62,11.75,11.75,11.63,11.48,11.27,11.21,11.25,11.50,11.87,12.36,12.78,13.14,13.40,13.59,13.70,13.75,13.77,13.78,13.75,13.73,13.63,13.53,13.41,13.33,13.20,13.09,12.99,12.89,12.85,12.78,12.75,12.72,12.66,12.62,12.59,12.50,12.36,12.15,11.90,11.62,11.26,10.90,10.58,10.25,9.95,9.64,9.37,9.08,8.75,8.37,8,7.59,7.12,6.65,6.16,5.65,5.14,4.63,4.13,3.65,3.12,2.58,2.03,1.53,1.09,0.63,0.25,-0.13,-0.42,-0.73,-0.97,-1.14,-1.29,-1.40,-1.49,-1.50,-1.48,-1.38,-1.25,-1.01,-0.75,-0.38,0.10,0.63,1.33,2.12,3.07,4.16,5.51,7.22,9.26,11.91,12.65,12.90,12.62,12.33,11.98,11.59,11.15,10.75,10.39,10.12,9.97,9.91,10,10.23,10.52,10.90,11.36,11.76,12.16,12.58,12.95,13.26,13.59,13.84,14.03,14.23,14.36,14.45,14.50,14.52,14.53,14.51,14.50,14.45,14.37,14.34,14.25,14.22,14.14,14.10,14.02,13.98,13.90,13.87,13.82,13.75,13.66,13.60,13.49,13.37,13.25,13.12,12.99,12.84,12.64,12.49,12.34,12.23,12.13,12.08,11.99,11.87,11.76,11.71,11.63,11.60,11.52,11.48,11.37,11.24,11.12,11.11,11.25,11.59,11.88,11.47,20,20,20,20,20,20,19,19,19,18,18,18,18,18,17,17,18,17,17,17,17,17,17,17,17,16.99,16.98,16.98,16.99,16.99,16.99,16.99,16.99,16.99,16.99,16.99,16.98,16.96,16.87,16.77,16.64,16.50,16.28,16.07,15.75,15.37,14.89,14.37,13.85,13.34,12.90,12.62,12.50,12.50,12.64,12.88,13.15,13.46,13.73,13.98,14.20,14.37,14.50,14.59,14.65,14.74,14.77,14.86,14.90,14.99,15.03,15.12,15.14,15.16,15.20,15.21,15.22,15.24,15.25,15.34,15.41,15.53,15.70,15.83,15.88,15.88,15.87,15.77,15.65,15.51,15.35,15.11,14.85,14.52,14.21,13.82,13.37,12.89,12.59,12.39,12.39,12.48,12.59,12.64,12.62,12.39,12.03,11.62,11.09,10.52,10.03,9.63,9.37,9.24,9.22,9.24,9.25,9.23,9.09,8.84,8.50,8.16,7.87,7.61,7.40,7.32,7.34,7.37,7.45,7.58,7.75,7.99,8.25,8.50,8.75,8.96,9.12,9.23,9.32,9.39,9.50,9.65,9.87,10.11,10.37,10.62,10.95,11.23,11.50,11.73,11.90,12.03,12.09,12,11.88,11.62,11.37,11.21,11.20,11.39,11.77,12.25,12.73,13.12,13.39,13.60,13.72,13.77,13.82,13.82,13.76,13.74,13.64,13.58,13.46,13.34,13.22,13.11,13,12.95,12.87,12.85,12.82,12.76,12.75,12.71,12.62,12.51,12.37,12.15,11.88,11.58,11.22,10.84,10.48,10.12,9.84,9.53,9.25,8.99,8.64,8.33,7.95,7.52,7.11,6.64,6.20,5.72,5.24,4.75,4.25,3.78,3.34,2.84,2.34,1.86,1.39,0.98,0.58,0.22,-0.13,-0.42,-0.72,-0.93,-1.14,-1.30,-1.43,-1.52,-1.59,-1.59,-1.50,-1.38,-1.16,-0.89,-0.52,-0.05,0.50,1.23,2.03,3.03,4.23,5.66,7.73,10,12.98,12.74,12.53,12.23,11.87,11.47,11.02,10.62,10.25,9.99,9.83,9.82,9.91,10.16,10.59,10.99,11.39,11.84,12.25,12.62,13,13.33,13.62,13.87,14.07,14.23,14.35,14.40,14.48,14.50,14.50,14.47,14.41,14.37,14.33,14.26,14.23,14.15,14.12,14.07,14,13.96,13.89,13.86,13.78,13.74,13.64,13.57,13.46,13.34,13.20,13.07,12.89,12.75,12.57,12.37,12.25,12.12,12.08,12.01,11.97,11.88,11.83,11.75,11.74,11.71,11.63,11.57,11.38,11.20,10.97,10.83,10.87,11.11,11.33,11.37,20,20,20,20,20,19,19,19,19,18,18,18,18,18,17,17,17,17,17,17,17,17,17,17,17,16.88,16.86,16.97,16.98,16.99,16.98,16.98,16.96,16.90,16.88,16.87,16.87,16.86,16.76,16.64,16.50,16.37,16.15,15.91,15.62,15.25,14.84,14.36,13.87,13.37,12.97,12.64,12.49,12.46,12.58,12.74,12.96,13.22,13.48,13.74,13.97,14.13,14.32,14.38,14.50,14.57,14.62,14.64,14.71,14.75,14.78,14.85,14.87,14.87,14.88,14.89,14.95,14.99,15.03,15.14,15.26,15.45,15.62,15.75,15.85,15.86,15.75,15.65,15.53,15.41,15.26,15.09,14.85,14.53,14.16,13.73,13.22,12.72,12.33,12.12,12.08,12.12,12.21,12.24,12.15,11.88,11.57,11.12,10.62,10.12,9.62,9.24,8.96,8.76,8.72,8.72,8.73,8.72,8.63,8.50,8.36,8.16,8.02,7.96,7.90,8,8.02,8.12,8.24,8.40,8.62,8.86,9.10,9.35,9.58,9.73,9.82,9.85,9.87,9.88,9.98,10.12,10.33,10.60,10.87,11.20,11.49,11.75,12,12.21,12.35,12.40,12.38,12.25,12.02,11.75,11.41,11.20,11.13,11.33,11.70,12.14,12.62,13.01,13.35,13.53,13.70,13.75,13.78,13.78,13.76,13.75,13.65,13.59,13.47,13.35,13.24,13.12,13.02,12.98,12.91,12.88,12.87,12.84,12.77,12.74,12.64,12.52,12.37,12.13,11.87,11.51,11.14,10.75,10.38,10.07,9.75,9.48,9.20,8.88,8.59,8.24,7.87,7.47,7.03,6.62,6.16,5.74,5.26,4.83,4.37,3.91,3.51,3.07,2.60,2.13,1.72,1.28,0.89,0.52,0.20,-0.13,-0.42,-0.72,-0.93,-1.15,-1.37,-1.50,-1.63,-1.68,-1.72,-1.65,-1.53,-1.37,-1.09,-0.68,-0.24,0.37,1.07,1.87,2.78,3.87,5.09,9,11,13,12.37,12.12,11.75,11.34,10.87,10.46,10.09,9.83,9.66,9.71,9.87,10.25,10.62,11.02,11.47,11.88,12.32,12.71,13.07,13.37,13.64,13.88,14.09,14.24,14.35,14.39,14.46,14.47,14.46,14.40,14.37,14.33,14.25,14.23,14.15,14.12,14.08,14.01,13.99,13.95,13.87,13.85,13.77,13.74,13.64,13.57,13.46,13.34,13.20,13.03,12.87,12.72,12.52,12.37,12.25,12.14,12.11,12.09,12.08,12.07,12.03,12.02,12.01,11.99,11.90,11.82,11.62,11.36,11.02,10.76,10.62,10.62,10.47,9.27,20,20,20,20,20,19,19,19,19,18,18,18,18,18,18,17,17,17,17,16,17,17,16.98,16.88,16.16,16.25,16.74,16.96,16.98,16.98,16.98,16.96,16.89,16.78,16.72,16.70,16.73,16.74,16.63,16.50,16.37,16.22,16.01,15.78,15.50,15.16,14.76,14.36,13.89,13.47,13.08,12.75,12.53,12.45,12.50,12.60,12.75,12.98,13.22,13.47,13.70,13.88,14.08,14.16,14.26,14.36,14.38,14.41,14.46,14.49,14.50,14.51,14.53,14.57,14.57,14.59,14.62,14.70,14.77,14.91,15.11,15.27,15.49,15.63,15.74,15.75,15.63,15.52,15.39,15.27,15.14,15,14.76,14.48,14.03,13.50,12.95,12.38,11.98,11.73,11.63,11.64,11.71,11.70,11.59,11.26,10.95,10.51,10.07,9.60,9.13,8.75,8.48,8.28,8.23,8.23,8.25,8.33,8.36,8.41,8.45,8.46,8.50,8.60,8.65,8.75,8.87,9,9.12,9.26,9.47,9.66,9.89,10.12,10.32,10.40,10.45,10.39,10.36,10.34,10.37,10.50,10.74,11.02,11.37,11.71,12,12.25,12.47,12.61,12.71,12.73,12.63,12.47,12.20,11.86,11.51,11.23,11.12,11.26,11.62,12.07,12.51,12.95,13.25,13.49,13.63,13.74,13.76,13.77,13.76,13.75,13.66,13.60,13.49,13.37,13.25,13.14,13.08,13,12.98,12.95,12.90,12.87,12.84,12.75,12.64,12.51,12.35,12.12,11.83,11.49,11.12,10.74,10.37,10.02,9.74,9.46,9.14,8.85,8.50,8.13,7.75,7.37,6.97,6.53,6.12,5.72,5.28,4.87,4.46,4.03,3.63,3.25,2.84,2.39,2,1.61,1.23,0.87,0.50,0.20,-0.13,-0.41,-0.72,-0.98,-1.22,-1.41,-1.61,-1.75,-1.85,-1.88,-1.85,-1.75,-1.53,-1.27,-0.89,-0.42,0.12,0.73,1.37,2,2.45,6.87,10,12,12.35,12,11.62,11.15,10.71,10.25,9.88,9.63,9.53,9.64,9.98,10.28,10.70,11.11,11.52,11.97,12.37,12.76,13.12,13.45,13.72,13.95,14.12,14.25,14.34,14.38,14.40,14.41,14.39,14.37,14.34,14.25,14.23,14.16,14.12,14.09,14.02,14,13.97,13.90,13.87,13.85,13.78,13.75,13.66,13.60,13.50,13.37,13.25,13.11,12.95,12.77,12.62,12.50,12.37,12.28,12.25,12.24,12.25,12.33,12.37,12.40,12.39,12.37,12.28,12.16,12,11.74,11.38,11.07,10.77,10.53,9.98,7.24,20,20,20,20,20,19,19,19,19,18,18,18,18,18,18,18,17,18,17,17,16.98,16.87,16.82,16.25,16.23,16.41,16.73,16.91,16.95,16.95,16.91,16.87,16.75,16.62,16.50,16.50,16.50,16.50,16.46,16.36,16.22,16.07,15.87,15.64,15.38,15.10,14.75,14.37,13.99,13.61,13.25,12.95,12.71,12.52,12.50,12.50,12.61,12.75,12.95,13.15,13.38,13.61,13.77,13.88,14,14.10,14.12,14.13,14.15,14.16,14.16,14.16,14.16,14.16,14.15,14.20,14.24,14.32,14.45,14.62,14.84,15.03,15.25,15.41,15.52,15.53,15.49,15.35,15.24,15.12,15,14.85,14.62,14.25,13.75,13.12,12.49,11.89,11.48,11.22,11.12,11.12,11.09,11,10.87,10.58,10.25,9.87,9.47,9.02,8.62,8.27,8.01,7.87,7.82,7.85,7.97,8.13,8.32,8.48,8.65,8.86,9.09,9.26,9.46,9.62,9.75,9.87,9.99,10.12,10.25,10.46,10.62,10.83,10.96,11,10.98,10.87,10.76,10.71,10.72,10.86,11.11,11.45,11.82,12.14,12.47,12.70,12.86,12.96,13,12.97,12.85,12.62,12.32,11.96,11.62,11.36,11.20,11.27,11.58,11.99,12.45,12.85,13.15,13.40,13.59,13.70,13.75,13.75,13.75,13.74,13.66,13.60,13.50,13.37,13.26,13.20,13.12,13.07,13.01,13,12.97,12.90,12.86,12.76,12.64,12.50,12.32,12.08,11.77,11.47,11.12,10.75,10.39,10.09,9.76,9.49,9.15,8.83,8.47,8.08,7.65,7.25,6.87,6.47,6.08,5.66,5.27,4.88,4.50,4.12,3.76,3.41,3.02,2.63,2.25,1.88,1.52,1.16,0.85,0.50,0.20,-0.13,-0.42,-0.75,-1.01,-1.28,-1.52,-1.74,-1.89,-2,-2.05,-2.03,-1.93,-1.76,-1.50,-1.15,-0.75,-0.34,0.09,0.46,0.14,5.77,10,13,12.25,11.87,11.40,10.95,10.47,10.01,9.70,9.48,9.53,9.74,10,10.36,10.75,11.15,11.62,12.03,12.47,12.86,13.21,13.50,13.75,13.98,14.12,14.25,14.33,14.37,14.37,14.37,14.37,14.33,14.26,14.23,14.16,14.12,14.10,14.03,14,13.99,13.96,13.90,13.87,13.86,13.83,13.76,13.72,13.63,13.58,13.48,13.37,13.24,13.11,12.98,12.87,12.75,12.62,12.52,12.49,12.49,12.52,12.62,12.72,12.76,12.77,12.75,12.71,12.62,12.46,12.23,11.96,11.65,11.36,10.98,10.16,8.16,20,20,20,20,20,19,19,19,19,18,18,18,18,18,18,18,18,18,17,16.99,16.83,16.75,16.34,16.12,16.24,16.51,16.77,16.87,16.87,16.87,16.86,16.75,16.58,16.45,16.36,16.32,16.32,16.32,16.25,16.16,16.07,15.90,15.75,15.52,15.28,15.01,14.75,14.45,14.12,13.83,13.50,13.22,12.96,12.73,12.61,12.50,12.50,12.57,12.70,12.87,13.08,13.26,13.47,13.59,13.70,13.75,13.82,13.83,13.84,13.83,13.82,13.78,13.76,13.75,13.72,13.72,13.75,13.84,13.99,14.16,14.39,14.63,14.87,15.07,15.20,15.25,15.23,15.13,15,14.87,14.75,14.58,14.27,13.86,13.25,12.50,11.84,11.25,10.84,10.59,10.48,10.45,10.38,10.26,10.11,9.86,9.58,9.25,8.88,8.52,8.20,7.87,7.65,7.52,7.53,7.72,7.87,8.12,8.39,8.74,9.08,9.40,9.73,10,10.25,10.47,10.62,10.73,10.78,10.87,10.99,11.12,11.25,11.39,11.49,11.50,11.40,11.26,11.12,11,11,11.12,11.38,11.75,12.15,12.53,12.86,13.07,13.16,13.23,13.21,13.12,12.97,12.73,12.39,12.07,11.73,11.48,11.33,11.35,11.58,11.95,12.37,12.75,13.11,13.37,13.52,13.63,13.72,13.75,13.75,13.73,13.66,13.61,13.50,13.40,13.33,13.24,13.15,13.12,13.09,13.03,13,12.97,12.87,12.76,12.63,12.48,12.26,12.01,11.75,11.46,11.12,10.82,10.50,10.21,9.88,9.58,9.23,8.84,8.40,7.99,7.57,7.12,6.74,6.36,5.99,5.62,5.25,4.89,4.57,4.23,3.87,3.59,3.23,2.87,2.50,2.15,1.84,1.49,1.14,0.84,0.50,0.15,-0.15,-0.50,-0.80,-1.13,-1.40,-1.67,-1.91,-2.12,-2.25,-2.29,-2.29,-2.22,-2.04,-1.79,-1.51,-1.23,-1,-1.13,-0.05,4.75,10,13,12.11,11.61,11.12,10.62,10.15,9.75,9.47,9.47,9.53,9.75,10.07,10.39,10.83,11.25,11.70,12.12,12.53,12.90,13.25,13.53,13.78,13.99,14.12,14.25,14.32,14.35,14.36,14.35,14.32,14.25,14.23,14.16,14.12,14.10,14.03,14,13.99,13.97,13.95,13.90,13.88,13.87,13.85,13.82,13.75,13.73,13.64,13.60,13.50,13.40,13.34,13.25,13.14,13.07,12.96,12.86,12.78,12.82,12.87,12.96,13.01,13.09,13.10,13.09,13.07,13,12.88,12.72,12.47,12.21,11.87,11.40,10.52,9.12,20,20,20,20,20,19,19,19,19,18,18,18,18,18,18,18,18,17.99,17.87,16.99,16.33,16.35,16.12,16.02,16.26,16.59,16.87,16.76,16.71,16.62,16.58,16.50,16.38,16.28,16.23,16.16,16.14,16.13,16.11,16.02,15.91,15.77,15.62,15.41,15.23,15,14.77,14.58,14.34,14.10,13.84,13.57,13.26,13,12.76,12.58,12.46,12.39,12.46,12.58,12.74,12.89,13.09,13.21,13.32,13.38,13.45,13.47,13.46,13.41,13.39,13.37,13.32,13.25,13.16,13.12,13.13,13.23,13.37,13.58,13.78,14.02,14.25,14.45,14.62,14.75,14.82,14.77,14.72,14.49,14.32,14.07,13.66,13.12,12.45,11.70,11,10.48,10.11,9.87,9.76,9.72,9.63,9.50,9.37,9.20,8.99,8.74,8.46,8.14,7.87,7.62,7.47,7.48,7.52,7.71,7.97,8.28,8.71,9.13,9.60,10,10.39,10.75,11.03,11.26,11.45,11.50,11.52,11.57,11.61,11.70,11.77,11.87,11.90,11.87,11.75,11.60,11.38,11.25,11.22,11.34,11.62,12,12.47,12.86,13.14,13.36,13.45,13.45,13.37,13.25,13.03,12.78,12.50,12.15,11.86,11.60,11.47,11.41,11.60,11.90,12.33,12.73,13.08,13.35,13.50,13.62,13.66,13.73,13.74,13.72,13.66,13.62,13.52,13.47,13.37,13.27,13.24,13.20,13.14,13.12,13.08,13,12.89,12.77,12.62,12.46,12.24,12,11.74,11.47,11.20,10.90,10.63,10.37,10.08,9.72,9.32,8.86,8.37,7.87,7.40,7,6.60,6.23,5.87,5.53,5.23,4.89,4.61,4.27,4,3.70,3.38,3.08,2.75,2.41,2.11,1.76,1.47,1.12,0.78,0.48,0.12,-0.25,-0.60,-0.92,-1.27,-1.62,-1.89,-2.15,-2.38,-2.51,-2.61,-2.61,-2.51,-2.38,-2.16,-1.93,-1.76,-1.87,-1.15,2.65,9,12,11.59,11.12,10.63,10.20,9.76,9.46,9.36,9.38,9.53,9.77,10.11,10.48,10.87,11.34,11.76,12.22,12.62,12.99,13.32,13.59,13.82,14,14.12,14.23,14.26,14.28,14.28,14.27,14.25,14.22,14.16,14.12,14.10,14.03,14,14,13.98,13.96,13.95,13.90,13.89,13.88,13.87,13.87,13.84,13.78,13.75,13.73,13.65,13.62,13.58,13.51,13.47,13.37,13.26,13.20,13.14,13.16,13.25,13.28,13.34,13.35,13.35,13.35,13.36,13.35,13.25,13.08,12.77,12.46,12.02,11.48,10.52,8.11,20,20,20,20,20,19,19,19,19,18,18,18,18,18,18,18,18,17.87,17.25,17.09,16.65,16.28,16.02,15.91,16.14,16.57,16.75,16.59,16.49,16.39,16.36,16.32,16.25,16.20,16.12,16.10,16.08,16.03,16,15.95,15.85,15.72,15.53,15.37,15.22,15.03,14.88,14.75,14.61,14.41,14.23,13.98,13.65,13.34,13,12.66,12.45,12.26,12.23,12.25,12.36,12.50,12.63,12.75,12.87,12.97,13,13.01,13,12.99,12.95,12.87,12.77,12.66,12.58,12.49,12.46,12.50,12.62,12.77,12.98,13.14,13.34,13.50,13.71,13.90,14.09,14.12,14.09,13.90,13.57,13.15,12.73,12.12,11.39,10.73,10.12,9.63,9.36,9.21,9.12,9.07,8.99,8.87,8.74,8.70,8.52,8.37,8.16,7.97,7.75,7.58,7.53,7.53,7.65,7.88,8.24,8.65,9.15,9.65,10.20,10.65,11.11,11.48,11.76,12,12.12,12.15,12.14,12.12,12.12,12.13,12.21,12.25,12.25,12.20,12.02,11.83,11.60,11.39,11.36,11.48,11.75,12.20,12.64,13.09,13.37,13.57,13.62,13.60,13.50,13.35,13.12,12.87,12.58,12.25,11.98,11.73,11.58,11.53,11.62,11.90,12.32,12.73,13.09,13.36,13.50,13.61,13.64,13.70,13.71,13.71,13.65,13.62,13.58,13.50,13.45,13.37,13.32,13.25,13.24,13.20,13.12,13.03,12.95,12.77,12.62,12.40,12.21,11.98,11.74,11.50,11.25,11.03,10.84,10.58,10.25,9.87,9.38,8.86,8.28,7.75,7.25,6.82,6.40,6.08,5.75,5.47,5.16,4.88,4.62,4.36,4.10,3.83,3.57,3.25,2.98,2.65,2.37,2.07,1.75,1.40,1.10,0.75,0.38,0.01,-0.38,-0.75,-1.13,-1.51,-1.88,-2.22,-2.50,-2.72,-2.88,-2.97,-2.97,-2.89,-2.76,-2.61,-2.30,-1.88,-1.15,0.63,6,11,10.86,10.28,9.95,9.61,9.33,9.13,9.23,9.34,9.52,9.82,10.13,10.52,10.97,11.39,11.86,12.26,12.65,13.01,13.35,13.61,13.82,13.99,14.11,14.20,14.24,14.25,14.25,14.24,14.21,14.14,14.12,14.09,14.03,14,14,13.98,13.97,13.96,13.95,13.95,13.91,13.91,13.90,13.89,13.88,13.87,13.87,13.85,13.83,13.77,13.75,13.75,13.71,13.62,13.58,13.51,13.52,13.59,13.62,13.65,13.63,13.61,13.58,13.58,13.60,13.60,13.50,13.26,12.88,12.39,11.83,11.12,10.16,8.10,20,20,20,20,20,19,19,19,19,18,18,18,18,18,18,18,17.99,17.86,17.60,17.16,16.76,16.37,15.91,15.72,15.91,16.24,16.38,16.34,16.26,16.23,16.20,16.16,16.14,16.12,16.11,16.08,16.02,16,15.99,15.90,15.83,15.70,15.53,15.38,15.25,15.14,15.09,15,14.90,14.82,14.63,14.40,14.11,13.71,13.25,12.83,12.45,12.14,11.99,11.90,11.96,12.02,12.15,12.25,12.37,12.47,12.50,12.52,12.50,12.48,12.40,12.33,12.21,12.03,11.88,11.75,11.70,11.66,11.75,11.87,12,12.12,12.22,12.32,12.41,12.60,12.77,12.88,12.86,12.66,12.36,11.96,11.50,10.91,10.35,9.73,9.22,8.87,8.70,8.62,8.62,8.61,8.52,8.48,8.38,8.47,8.37,8.25,8.12,7.98,7.86,7.76,7.75,7.82,8,8.28,8.71,9.20,9.73,10.28,10.84,11.34,11.75,12.13,12.45,12.62,12.74,12.73,12.64,12.59,12.51,12.50,12.51,12.52,12.50,12.40,12.24,11.99,11.73,11.50,11.41,11.52,11.85,12.27,12.77,13.23,13.52,13.72,13.75,13.71,13.59,13.38,13.16,12.91,12.63,12.37,12.09,11.85,11.66,11.62,11.74,11.95,12.34,12.75,13.12,13.37,13.51,13.60,13.62,13.63,13.65,13.65,13.64,13.62,13.60,13.53,13.50,13.46,13.38,13.37,13.33,13.25,13.21,13.10,12.97,12.78,12.62,12.39,12.20,11.97,11.75,11.53,11.37,11.22,11.01,10.77,10.47,10,9.46,8.83,8.16,7.58,7.02,6.60,6.22,5.87,5.62,5.37,5.12,4.87,4.64,4.41,4.20,3.96,3.72,3.46,3.16,2.88,2.62,2.32,2,1.70,1.36,1,0.63,0.25,-0.15,-0.60,-1,-1.43,-1.87,-2.25,-2.60,-2.88,-3.13,-3.27,-3.38,-3.39,-3.38,-3.15,-3,-2.13,-1.10,-0.25,4,9,9.25,9.13,9.01,8.90,8.84,8.98,9.11,9.28,9.52,9.85,10.21,10.61,11.02,11.49,11.90,12.34,12.72,13.03,13.35,13.60,13.78,13.96,14.07,14.12,14.16,14.20,14.16,14.15,14.12,14.10,14.07,14.01,14,13.98,13.97,13.96,13.96,13.95,13.95,13.96,13.96,13.97,13.97,13.97,13.97,13.97,13.96,13.95,13.91,13.89,13.88,13.87,13.87,13.85,13.83,13.84,13.88,13.99,14.02,14.01,13.98,13.87,13.83,13.78,13.82,13.77,13.64,13.37,12.87,12.24,11.50,10.77,9.95,8.10,20,20,20,20,20,19,19,19,19,18,18,18,18,18,18,18,17.98,17.97,17.62,17.26,16.78,16.37,15.95,15.62,15.62,15.87,16.01,16.10,16.10,16.09,16.09,16.10,16.11,16.11,16.10,16.08,16.03,16.02,16,15.96,15.87,15.75,15.62,15.50,15.40,15.37,15.34,15.32,15.26,15.22,15.08,14.86,14.50,14.08,13.50,12.97,12.46,12.01,11.73,11.57,11.50,11.53,11.62,11.73,11.83,11.88,11.97,11.98,11.96,11.90,11.84,11.73,11.58,11.38,11.21,11.02,10.90,10.87,10.87,10.91,11,11.02,11.03,11.01,11.01,11.09,11.14,11.23,11.21,11.08,10.86,10.58,10.21,9.75,9.27,8.84,8.50,8.33,8.26,8.32,8.37,8.39,8.40,8.45,8.45,8.52,8.50,8.45,8.34,8.25,8.13,8.10,8.12,8.25,8.50,8.86,9.28,9.82,10.37,10.95,11.48,11.97,12.38,12.75,13,13.14,13.22,13.15,13.07,12.95,12.86,12.78,12.76,12.75,12.72,12.59,12.37,12.09,11.76,11.52,11.45,11.53,11.87,12.35,12.86,13.32,13.62,13.78,13.84,13.75,13.62,13.45,13.23,12.98,12.72,12.45,12.16,11.96,11.75,11.71,11.77,12,12.37,12.82,13.20,13.41,13.52,13.58,13.59,13.60,13.61,13.62,13.62,13.62,13.62,13.60,13.58,13.52,13.50,13.47,13.39,13.35,13.25,13.12,13,12.82,12.62,12.39,12.21,12,11.82,11.63,11.50,11.37,11.23,10.99,10.62,10.11,9.45,8.72,7.99,7.34,6.75,6.33,5.98,5.70,5.47,5.25,5.08,4.87,4.71,4.50,4.28,4.10,3.87,3.63,3.37,3.12,2.85,2.53,2.25,1.91,1.60,1.25,0.87,0.47,0.01,-0.42,-0.89,-1.38,-1.85,-2.27,-2.72,-3.05,-3.38,-3.62,-3.78,-3.91,-3.93,-4.01,-3.13,-2.24,-1.12,-0.25,3,8,7.51,7.76,8.02,8.25,8.57,8.78,9.01,9.26,9.57,9.88,10.25,10.66,11.11,11.52,11.97,12.37,12.73,13.03,13.34,13.57,13.75,13.88,14,14.08,14.11,14.12,14.12,14.10,14.08,14.02,14,13.98,13.96,13.95,13.91,13.91,13.95,13.95,13.96,13.98,13.99,14,14,14.01,14.02,14.02,14.02,14.01,14,14,13.98,13.97,13.98,13.99,14.01,14.12,14.23,14.33,14.37,14.37,14.26,14.15,14.10,14.03,14.01,13.97,13.76,13.38,12.83,12.10,11.32,10.62,9.96,8.11,20,20,20,20,20,19,19,19,19,18,18,18,18,18,18,18,18,17.96,17.64,17.25,16.73,16.33,15.96,15.65,15.57,15.64,15.78,15.87,15.96,15.99,16,16.02,16.08,16.09,16.10,16.10,16.11,16.12,16.11,16.07,15.99,15.87,15.76,15.71,15.63,15.62,15.62,15.62,15.62,15.58,15.45,15.22,14.87,14.37,13.72,13.09,12.46,11.89,11.49,11.22,11.09,11.03,11.09,11.14,11.24,11.28,11.36,11.37,11.36,11.32,11.24,11.12,10.96,10.75,10.57,10.37,10.24,10.12,10.11,10.12,10.12,10.12,10.02,9.87,9.66,9.53,9.59,9.63,9.65,9.58,9.40,9.24,9,8.77,8.52,8.26,8.12,8.12,8.20,8.33,8.46,8.58,8.65,8.75,8.82,8.87,8.87,8.77,8.72,8.62,8.53,8.57,8.62,8.84,9.12,9.50,9.98,10.50,11.07,11.60,12.12,12.57,12.96,13.25,13.47,13.59,13.60,13.50,13.37,13.23,13.11,13.01,12.99,12.91,12.86,12.70,12.45,12.12,11.77,11.51,11.40,11.52,11.87,12.37,12.88,13.37,13.70,13.86,13.87,13.82,13.64,13.48,13.25,13,12.75,12.50,12.25,12.01,11.85,11.75,11.85,12.09,12.41,12.87,13.23,13.45,13.50,13.50,13.50,13.51,13.52,13.57,13.59,13.61,13.62,13.62,13.62,13.62,13.60,13.53,13.50,13.41,13.33,13.20,13.01,12.85,12.62,12.45,12.24,12.07,11.89,11.76,11.66,11.59,11.41,11.15,10.74,10.12,9.37,8.52,7.73,7,6.46,6,5.72,5.49,5.28,5.14,5,4.87,4.75,4.61,4.41,4.25,4.07,3.85,3.60,3.34,3.07,2.75,2.47,2.12,1.78,1.45,1.03,0.62,0.16,-0.29,-0.80,-1.35,-1.86,-2.37,-2.85,-3.26,-3.63,-3.97,-4.18,-4.40,-4.75,-4.35,-3.38,-2.13,-1.03,-0.15,2,5,5.70,6.47,7.24,7.86,8.37,8.73,9,9.28,9.62,9.96,10.34,10.74,11.14,11.58,11.98,12.36,12.71,13,13.26,13.50,13.66,13.83,13.90,13.99,14.01,14.02,14.02,14,14,13.97,13.95,13.90,13.89,13.88,13.89,13.90,13.91,13.95,13.97,14,14,14.03,14.08,14.10,14.11,14.12,14.12,14.11,14.09,14.03,14.01,14.01,14.03,14.12,14.23,14.36,14.49,14.60,14.63,14.62,14.52,14.45,14.37,14.32,14.25,14.12,13.87,13.41,12.78,12.03,11.27,10.64,10.12,9.12,20,20,20,19,19,19,19,19,19,18,18,18,18,18,18,18,17.96,17.85,17.58,17.16,16.75,16.36,16.01,15.75,15.61,15.59,15.64,15.74,15.83,15.88,15.97,16,16.03,16.10,16.12,16.13,16.20,16.23,16.24,16.22,16.13,16.08,16,15.95,15.89,15.89,15.90,15.91,15.90,15.86,15.71,15.46,15.09,14.57,13.85,13.13,12.45,11.78,11.26,10.89,10.66,10.58,10.57,10.62,10.66,10.73,10.75,10.77,10.77,10.75,10.70,10.57,10.39,10.23,10.02,9.86,9.72,9.62,9.59,9.59,9.59,9.57,9.49,9.25,8.99,8.73,8.62,8.63,8.70,8.64,8.61,8.51,8.38,8.22,8.12,8.12,8.15,8.26,8.46,8.62,8.85,9,9.15,9.27,9.37,9.37,9.35,9.25,9.14,9.08,9.03,9.10,9.23,9.47,9.77,10.22,10.70,11.22,11.74,12.23,12.70,13.10,13.40,13.66,13.85,13.89,13.87,13.75,13.62,13.46,13.32,13.23,13.13,13.08,12.97,12.75,12.48,12.12,11.75,11.48,11.37,11.50,11.87,12.37,12.89,13.37,13.72,13.87,13.89,13.83,13.66,13.50,13.27,13.07,12.83,12.57,12.32,12.08,11.88,11.78,11.87,12.12,12.47,12.87,13.22,13.39,13.47,13.46,13.41,13.45,13.47,13.50,13.51,13.58,13.62,13.63,13.70,13.70,13.66,13.63,13.60,13.50,13.37,13.24,13.07,12.87,12.66,12.50,12.33,12.15,12.02,11.96,11.87,11.78,11.62,11.33,10.82,10.11,9.23,8.27,7.39,6.64,6.10,5.70,5.41,5.25,5.13,5.07,4.99,4.89,4.84,4.73,4.60,4.45,4.25,4.03,3.82,3.53,3.25,2.97,2.63,2.33,1.98,1.60,1.21,0.75,0.27,-0.23,-0.75,-1.34,-1.88,-2.47,-3,-3.50,-3.93,-4.34,-4.63,-4.84,-5.12,-4.39,-3.42,-2.18,-1.12,-0.17,0.99,2,3.60,5.76,6.88,7.82,8.36,8.75,9.07,9.37,9.66,10,10.37,10.75,11.15,11.57,11.96,12.32,12.62,12.91,13.20,13.38,13.58,13.72,13.83,13.87,13.91,13.95,13.96,13.95,13.90,13.88,13.87,13.87,13.86,13.87,13.87,13.88,13.90,13.96,13.99,14.01,14.07,14.11,14.12,14.15,14.20,14.21,14.20,14.16,14.13,14.11,14.08,14.09,14.12,14.25,14.39,14.58,14.71,14.78,14.83,14.78,14.74,14.65,14.62,14.57,14.48,14.28,13.99,13.50,12.85,12.11,11.38,10.86,10.39,9.16,20,20,19,19,19,19,19,19,19,18,18,18,18,17.99,17.99,17.96,17.87,17.72,17.46,17.11,16.73,16.37,16.09,15.85,15.66,15.60,15.58,15.62,15.72,15.83,15.90,16,16.09,16.12,16.20,16.25,16.32,16.37,16.38,16.38,16.36,16.27,16.24,16.21,16.16,16.16,16.15,16.14,16.12,16,15.84,15.53,15.13,14.62,13.87,13.12,12.38,11.71,11.12,10.64,10.37,10.20,10.12,10.16,10.23,10.25,10.32,10.34,10.35,10.33,10.25,10.14,10.01,9.87,9.75,9.61,9.50,9.46,9.46,9.50,9.53,9.60,9.58,9.46,9.23,8.98,8.83,8.75,8.75,8.74,8.70,8.62,8.51,8.39,8.34,8.37,8.57,8.74,8.95,9.20,9.40,9.62,9.78,9.95,10,9.95,9.86,9.73,9.62,9.57,9.57,9.63,9.85,10.12,10.50,10.95,11.40,11.88,12.37,12.82,13.22,13.53,13.83,14,14.12,14.13,14.10,13.97,13.78,13.62,13.49,13.37,13.27,13.20,13.02,12.78,12.48,12.09,11.71,11.41,11.35,11.50,11.87,12.37,12.91,13.37,13.71,13.87,13.88,13.84,13.71,13.51,13.33,13.11,12.87,12.61,12.35,12.12,11.95,11.85,11.89,12.12,12.46,12.85,13.13,13.32,13.36,13.36,13.35,13.36,13.37,13.39,13.47,13.51,13.60,13.64,13.73,13.75,13.75,13.74,13.66,13.59,13.45,13.27,13.11,12.91,12.75,12.58,12.41,12.32,12.23,12.14,12.12,12.01,11.84,11.47,10.87,10.02,9.03,8,7.07,6.27,5.73,5.37,5.14,5.03,5,4.99,4.98,4.97,4.91,4.87,4.77,4.64,4.50,4.27,4.03,3.76,3.48,3.14,2.83,2.47,2.11,1.72,1.32,0.87,0.37,-0.16,-0.75,-1.36,-1.99,-2.61,-3.18,-3.76,-4.28,-4.76,-5.09,-5.40,-4.91,-4.18,-3.26,-2.38,-1.25,-0.29,0.99,2,4.25,6,7.28,8.02,8.51,8.87,9.15,9.46,9.75,10.07,10.39,10.75,11.12,11.50,11.87,12.22,12.51,12.82,13.07,13.25,13.46,13.60,13.71,13.76,13.83,13.85,13.86,13.86,13.85,13.83,13.82,13.78,13.82,13.83,13.85,13.87,13.89,13.96,14,14.03,14.11,14.14,14.21,14.24,14.25,14.26,14.26,14.25,14.22,14.14,14.12,14.13,14.25,14.39,14.61,14.76,14.87,14.95,14.95,14.89,14.87,14.84,14.78,14.75,14.62,14.40,14.07,13.57,12.91,12.25,11.62,11.12,10.74,9.24,20,20,19,19,19,19,19,19,19,18,18,18,18,17.99,17.96,17.87,17.75,17.53,17.28,17,16.66,16.37,16.12,15.89,15.73,15.60,15.50,15.50,15.61,15.75,15.88,16.02,16.13,16.24,16.28,16.37,16.45,16.50,16.53,16.57,16.51,16.50,16.46,16.40,16.38,16.37,16.34,16.26,16.15,16,15.78,15.48,15.02,14.50,13.75,13,12.26,11.58,10.97,10.49,10.13,9.96,9.87,9.87,9.98,10,10.08,10.11,10.12,10.12,10.10,10.01,9.91,9.86,9.75,9.71,9.65,9.70,9.75,9.87,10,10.14,10.25,10.27,10.25,10.12,9.97,9.83,9.72,9.62,9.50,9.36,9.21,9.08,9,9.03,9.15,9.37,9.61,9.85,10.08,10.27,10.49,10.62,10.63,10.50,10.32,10.15,10.08,10.01,10.08,10.22,10.47,10.78,11.22,11.64,12.12,12.51,12.95,13.32,13.62,13.90,14.12,14.25,14.34,14.33,14.25,14.12,13.96,13.77,13.63,13.51,13.40,13.28,13.11,12.83,12.46,12.02,11.63,11.37,11.34,11.50,11.89,12.41,12.96,13.37,13.70,13.86,13.87,13.84,13.71,13.52,13.36,13.12,12.88,12.62,12.37,12.12,11.97,11.87,11.91,12.12,12.41,12.75,13.01,13.16,13.24,13.25,13.25,13.25,13.28,13.35,13.39,13.49,13.58,13.64,13.75,13.78,13.84,13.82,13.75,13.64,13.50,13.36,13.16,13,12.84,12.70,12.57,12.48,12.40,12.37,12.36,12.25,12.03,11.61,10.89,9.97,8.87,7.74,6.73,5.91,5.37,5.07,4.88,4.86,4.87,4.91,4.99,5.02,5.08,5.08,5.01,4.91,4.76,4.58,4.32,4,3.70,3.34,2.97,2.59,2.21,1.78,1.37,0.90,0.40,-0.13,-0.75,-1.40,-2.11,-2.76,-3.42,-4.05,-4.68,-5.22,-5.88,-5.41,-4.75,-4,-3.26,-2.38,-1.28,-0.38,0.98,3,5.63,7.27,8.08,8.52,8.85,9.09,9.28,9.52,9.77,10.08,10.37,10.72,11.03,11.38,11.74,12.07,12.37,12.63,12.87,13.12,13.27,13.45,13.57,13.63,13.71,13.75,13.75,13.75,13.75,13.75,13.75,13.75,13.75,13.76,13.82,13.86,13.88,13.96,14,14.10,14.14,14.23,14.26,14.33,14.36,14.37,14.37,14.35,14.27,14.23,14.16,14.23,14.37,14.60,14.83,15,15.07,15.03,15,14.98,14.95,14.91,14.89,14.86,14.74,14.50,14.12,13.62,13.08,12.48,11.91,11.47,10.98,10.27,20,20,19,19,19,19,19,19,19,18,18,18,17.99,17.97,17.88,17.76,17.61,17.38,17.14,16.89,16.62,16.37,16.12,15.91,15.75,15.58,15.45,15.39,15.48,15.63,15.87,16.10,16.25,16.37,16.45,16.49,16.52,16.59,16.62,16.63,16.63,16.62,16.62,16.60,16.53,16.49,16.37,16.25,16.09,15.87,15.59,15.22,14.75,14.21,13.47,12.75,12.07,11.39,10.85,10.38,10.09,9.88,9.84,9.84,9.98,10.08,10.13,10.22,10.25,10.26,10.26,10.24,10.21,10.15,10.14,10.14,10.21,10.26,10.40,10.59,10.76,10.99,11.16,11.34,11.41,11.41,11.28,11.12,10.91,10.73,10.50,10.27,10.09,9.91,9.85,9.87,9.97,10.12,10.34,10.53,10.74,10.95,11.10,11.15,11.13,10.90,10.72,10.53,10.48,10.48,10.57,10.75,11.07,11.45,11.87,12.33,12.71,13.09,13.41,13.73,14,14.22,14.37,14.47,14.49,14.46,14.36,14.23,14.08,13.90,13.76,13.64,13.52,13.37,13.14,12.85,12.41,11.99,11.60,11.36,11.34,11.53,11.97,12.48,12.98,13.38,13.66,13.84,13.87,13.83,13.72,13.57,13.37,13.14,12.90,12.65,12.39,12.15,12,11.90,11.98,12.12,12.37,12.64,12.89,13.03,13.12,13.13,13.15,13.20,13.24,13.27,13.37,13.47,13.57,13.64,13.75,13.85,13.87,13.87,13.84,13.73,13.59,13.41,13.25,13.10,12.96,12.83,12.73,12.64,12.62,12.62,12.61,12.50,12.25,11.75,10.97,9.90,8.72,7.50,6.45,5.62,5.09,4.77,4.66,4.70,4.76,4.88,5.01,5.14,5.25,5.33,5.33,5.25,5.12,4.89,4.62,4.27,3.89,3.50,3.09,2.64,2.25,1.85,1.39,0.97,0.47,-0.13,-0.77,-1.50,-2.25,-3,-3.73,-4.36,-5.01,-6,-5.88,-5.51,-4.93,-4.14,-3.11,-2.15,-1.40,-0.50,0.98,5,8.53,9.12,9.16,9.12,9.20,9.26,9.39,9.59,9.77,10.01,10.28,10.60,10.88,11.23,11.52,11.86,12.14,12.41,12.70,12.90,13.12,13.26,13.39,13.50,13.59,13.62,13.64,13.65,13.65,13.65,13.65,13.66,13.71,13.74,13.76,13.83,13.87,13.97,14.02,14.12,14.21,14.26,14.36,14.39,14.46,14.48,14.48,14.45,14.37,14.28,14.25,14.33,14.50,14.76,15.02,15.20,15.23,15.14,15.08,15,14.99,14.97,14.96,14.88,14.75,14.51,14.15,13.74,13.25,12.75,12.26,11.82,11.22,9.37,20,20,19,19,19,19,19,19,18.99,18.11,18,17.99,17.98,17.96,17.87,17.66,17.48,17.25,17.01,16.77,16.53,16.32,16.10,15.88,15.72,15.50,15.35,15.25,15.34,15.52,15.84,16.12,16.36,16.49,16.52,16.52,16.53,16.57,16.59,16.62,16.64,16.66,16.66,16.64,16.59,16.48,16.28,16.09,15.83,15.50,15.15,14.75,14.26,13.73,13.02,12.37,11.75,11.21,10.75,10.38,10.15,10.07,10.03,10.12,10.25,10.40,10.52,10.62,10.72,10.75,10.78,10.82,10.82,10.83,10.86,10.88,10.98,11.09,11.23,11.39,11.62,11.87,12.12,12.39,12.62,12.71,12.60,12.37,12.12,11.86,11.53,11.25,11,10.83,10.73,10.71,10.75,10.87,11,11.16,11.35,11.50,11.62,11.62,11.51,11.16,10.99,10.87,10.84,10.87,11.01,11.26,11.62,12.02,12.48,12.88,13.23,13.53,13.83,14.08,14.26,14.41,14.52,14.60,14.60,14.52,14.46,14.33,14.16,14.02,13.89,13.77,13.64,13.48,13.22,12.86,12.39,11.96,11.57,11.34,11.36,11.60,12,12.51,13,13.39,13.66,13.84,13.87,13.83,13.73,13.59,13.39,13.20,12.96,12.71,12.46,12.24,12.08,12,12,12.14,12.37,12.60,12.82,12.96,13.01,13.09,13.12,13.14,13.22,13.26,13.37,13.47,13.58,13.65,13.77,13.87,13.91,13.95,13.88,13.77,13.64,13.50,13.37,13.23,13.10,12.98,12.88,12.85,12.84,12.85,12.85,12.75,12.48,11.90,11.03,9.89,8.62,7.34,6.23,5.37,4.86,4.59,4.50,4.57,4.70,4.87,5.09,5.28,5.49,5.62,5.65,5.63,5.52,5.33,5,4.62,4.14,3.64,3.15,2.70,2.25,1.84,1.40,0.99,0.49,-0.11,-0.78,-1.60,-2.41,-3.26,-4.03,-4.86,-5,-5.99,-5.80,-5.50,-4.90,-4.13,-3.13,-2.16,-1.39,-0.49,1.97,8,11,11.45,10,9.62,9.45,9.37,9.41,9.52,9.70,9.88,10.12,10.38,10.70,10.99,11.27,11.61,11.88,12.16,12.46,12.71,12.90,13.11,13.25,13.37,13.47,13.50,13.53,13.58,13.59,13.60,13.60,13.62,13.62,13.66,13.74,13.78,13.87,13.98,14.08,14.15,14.25,14.36,14.41,14.50,14.53,14.59,14.59,14.53,14.49,14.40,14.37,14.46,14.64,14.95,15.21,15.35,15.35,15.24,15.12,15.01,15,14.98,14.96,14.88,14.75,14.52,14.22,13.86,13.48,13.09,12.66,12.21,11.48,9.47,20,20,19,19,19,19,19,19,18.86,18.25,18,17.99,17.97,17.89,17.77,17.59,17.36,17.12,16.90,16.66,16.46,16.23,16,15.84,15.62,15.40,15.23,15.11,15.14,15.38,15.75,16.11,16.37,16.50,16.50,16.47,16.38,16.37,16.37,16.45,16.50,16.59,16.62,16.61,16.50,16.34,16.09,15.75,15.39,15,14.59,14.12,13.62,13.10,12.49,11.91,11.40,11,10.71,10.50,10.41,10.41,10.50,10.62,10.82,11,11.15,11.33,11.41,11.50,11.59,11.62,11.63,11.64,11.70,11.75,11.82,11.90,12.03,12.23,12.40,12.64,12.91,13.20,13.38,13.49,13.39,13.24,13,12.73,12.40,12.12,11.86,11.64,11.52,11.49,11.49,11.52,11.62,11.70,11.75,11.84,11.83,11.75,11.52,11.33,11.15,11.12,11.12,11.25,11.46,11.75,12.12,12.57,12.99,13.37,13.63,13.89,14.12,14.34,14.49,14.60,14.65,14.70,14.66,14.62,14.51,14.39,14.26,14.13,14.01,13.89,13.75,13.57,13.25,12.87,12.39,11.91,11.52,11.34,11.37,11.63,12.08,12.59,13.03,13.41,13.70,13.83,13.87,13.84,13.75,13.62,13.45,13.24,13,12.75,12.51,12.33,12.15,12.10,12.12,12.21,12.37,12.58,12.75,12.87,12.99,13.03,13.10,13.13,13.22,13.28,13.38,13.50,13.61,13.73,13.84,13.90,13.99,14,13.96,13.87,13.75,13.62,13.49,13.37,13.25,13.13,13.08,13.01,13,13.02,13.03,12.97,12.65,12.09,11.15,9.96,8.59,7.25,6.10,5.24,4.70,4.41,4.37,4.45,4.62,4.87,5.13,5.45,5.72,5.95,6.10,6.13,6.08,5.84,5.48,5,4.41,3.82,3.21,2.63,2.15,1.75,1.38,1,0.57,-0.02,-0.77,-1.63,-2.63,-3.60,-4.55,-5,-5.16,-6.11,-5.74,-5.16,-4.63,-4.03,-3.26,-2.26,-1.27,-0.38,2.98,8,12,10.96,10.41,9.78,9.48,9.35,9.33,9.37,9.50,9.70,9.88,10.13,10.39,10.71,11,11.32,11.62,11.89,12.21,12.47,12.71,12.90,13.09,13.23,13.34,13.38,13.46,13.48,13.50,13.50,13.50,13.53,13.59,13.62,13.70,13.76,13.87,13.99,14.10,14.22,14.33,14.41,14.50,14.60,14.64,14.70,14.71,14.65,14.62,14.57,14.52,14.62,14.78,15.07,15.28,15.40,15.37,15.25,15.12,15.02,15,14.98,14.95,14.87,14.74,14.51,14.25,13.99,13.71,13.39,13.07,12.62,11.87,10.58,20,20,19,19,19,19,19,19,18.74,18.36,18,17.97,17.90,17.85,17.66,17.48,17.25,17.02,16.83,16.60,16.36,16.12,15.96,15.75,15.57,15.34,15.11,14.97,15,15.23,15.58,15.95,16.23,16.34,16.28,16.20,16.08,16,16,16.09,16.21,16.33,16.39,16.39,16.28,16.07,15.73,15.32,14.85,14.36,13.87,13.37,12.87,12.37,11.89,11.48,11.11,10.87,10.75,10.75,10.84,10.96,11.12,11.33,11.52,11.75,11.97,12.12,12.26,12.37,12.47,12.50,12.50,12.51,12.53,12.59,12.62,12.71,12.78,12.90,13.08,13.25,13.45,13.62,13.76,13.85,13.78,13.66,13.50,13.27,13.01,12.76,12.53,12.37,12.24,12.14,12.11,12.10,12.09,12.08,12.01,11.98,11.86,11.66,11.49,11.36,11.27,11.28,11.38,11.58,11.85,12.20,12.59,13,13.38,13.75,13.97,14.16,14.37,14.50,14.62,14.71,14.75,14.75,14.75,14.70,14.61,14.50,14.37,14.25,14.13,14,13.86,13.62,13.32,12.88,12.39,11.91,11.52,11.36,11.39,11.70,12.12,12.62,13.10,13.47,13.71,13.84,13.87,13.86,13.76,13.64,13.49,13.26,13.03,12.83,12.62,12.41,12.27,12.22,12.23,12.27,12.39,12.58,12.75,12.87,12.99,13.03,13.12,13.16,13.25,13.37,13.47,13.59,13.70,13.78,13.88,13.98,14.01,14.02,14,13.95,13.85,13.74,13.62,13.50,13.40,13.33,13.25,13.21,13.20,13.22,13.23,13.12,12.85,12.25,11.32,10.07,8.62,7.25,6.03,5.14,4.61,4.34,4.25,4.35,4.52,4.82,5.14,5.53,5.91,6.26,6.58,6.75,6.75,6.49,6.08,5.49,4.75,3.96,3.15,2.49,2,1.62,1.35,1.02,0.75,0.20,-0.63,-1.75,-2.60,-4.35,-4.87,-5.16,-5.27,-6.15,-5.88,-5.38,-4.62,-4,-3.25,-2.25,-1.02,-0.29,2.98,9,11,11.15,10.14,9.59,9.24,9.10,9.08,9.12,9.25,9.40,9.62,9.85,10.11,10.37,10.66,11,11.32,11.62,11.95,12.23,12.50,12.73,12.90,13.09,13.21,13.27,13.35,13.37,13.38,13.40,13.45,13.48,13.50,13.59,13.64,13.75,13.87,14,14.12,14.25,14.37,14.50,14.62,14.71,14.75,14.82,14.83,14.82,14.76,14.74,14.73,14.76,14.90,15.12,15.28,15.37,15.36,15.24,15.12,15.01,14.98,14.95,14.88,14.82,14.65,14.49,14.27,14.10,13.89,13.66,13.37,12.90,12.23,10.70,20,19,19,19,19,19,19,18.98,18.64,18.34,18.02,17.91,17.86,17.72,17.52,17.35,17.14,16.98,16.76,16.57,16.33,16.12,15.91,15.75,15.53,15.32,15.08,14.87,14.87,15.03,15.35,15.64,15.87,15.97,15.88,15.75,15.59,15.49,15.48,15.58,15.73,15.89,16.01,16.03,15.90,15.62,15.23,14.73,14.16,13.62,13.09,12.59,12.12,11.70,11.33,11.12,10.95,10.88,10.99,11.14,11.37,11.61,11.85,12.10,12.35,12.58,12.75,12.97,13.12,13.24,13.32,13.35,13.36,13.35,13.35,13.34,13.35,13.36,13.38,13.46,13.51,13.62,13.74,13.85,13.90,13.96,13.95,13.87,13.75,13.61,13.41,13.25,13.08,12.90,12.78,12.70,12.61,12.50,12.40,12.28,12.14,11.97,11.75,11.53,11.39,11.35,11.37,11.47,11.63,11.87,12.21,12.57,12.97,13.36,13.72,14,14.16,14.37,14.51,14.63,14.74,14.77,14.82,14.83,14.78,14.75,14.66,14.60,14.49,14.37,14.25,14.12,13.91,13.66,13.34,12.89,12.40,11.95,11.57,11.37,11.46,11.75,12.22,12.71,13.14,13.50,13.74,13.86,13.88,13.87,13.82,13.70,13.50,13.32,13.10,12.87,12.71,12.53,12.41,12.36,12.34,12.37,12.50,12.62,12.75,12.89,13,13.10,13.16,13.25,13.36,13.46,13.57,13.70,13.78,13.88,13.98,14.01,14.07,14.08,14.07,14,13.95,13.87,13.76,13.66,13.60,13.50,13.40,13.37,13.36,13.37,13.37,13.26,13,12.39,11.48,10.23,8.77,7.37,6.12,5.20,4.60,4.26,4.16,4.25,4.40,4.72,5.11,5.57,6.03,6.57,7.09,7.48,7.62,7.34,6.82,6.14,5.16,4.12,2.97,2.12,1.62,1.46,1.32,1.01,0.76,1.37,-0.65,-1.76,-3.63,-4.38,-4.92,-5.25,-5.38,-6.26,-6,-5.49,-4.75,-3.79,-3.01,-2.01,-0.85,0.77,3.99,8,10,10.16,9.37,8.90,8.73,8.64,8.71,8.78,8.91,9.11,9.28,9.50,9.76,10.03,10.36,10.66,11,11.35,11.66,12,12.27,12.53,12.75,12.95,13.08,13.15,13.24,13.26,13.32,13.34,13.37,13.38,13.46,13.51,13.62,13.74,13.87,14,14.14,14.32,14.46,14.60,14.72,14.82,14.87,14.91,14.96,14.95,14.91,14.88,14.87,14.90,15,15.12,15.24,15.27,15.25,15.15,15.08,15,14.95,14.87,14.82,14.71,14.53,14.39,14.26,14.14,14,13.82,13.49,13.02,12.33,10.83,19,19,19,19,19,19,18.99,18.86,18.57,18.25,18,17.86,17.73,17.57,17.37,17.23,17.09,16.96,16.78,16.62,16.39,16.22,16.02,15.86,15.63,15.39,15.14,14.96,14.87,14.95,15.12,15.33,15.47,15.50,15.38,15.22,15,14.87,14.86,14.96,15.12,15.34,15.49,15.50,15.37,15.07,14.61,14.02,13.46,12.87,12.34,11.87,11.49,11.21,11,10.96,11.01,11.15,11.40,11.73,12.01,12.33,12.61,12.87,13.12,13.36,13.51,13.66,13.84,13.91,14,14,14,13.99,13.95,13.89,13.87,13.85,13.84,13.83,13.85,13.87,13.89,13.96,13.99,14,14,13.97,13.88,13.78,13.70,13.58,13.45,13.34,13.22,13.11,12.98,12.84,12.64,12.40,12.13,11.86,11.58,11.37,11.26,11.32,11.41,11.62,11.87,12.16,12.50,12.87,13.25,13.62,13.95,14.20,14.35,14.50,14.62,14.74,14.78,14.85,14.86,14.87,14.85,14.82,14.75,14.70,14.60,14.50,14.36,14.20,13.98,13.71,13.34,12.88,12.39,11.95,11.59,11.41,11.51,11.85,12.32,12.78,13.24,13.58,13.76,13.88,13.95,13.90,13.86,13.73,13.53,13.34,13.12,12.95,12.78,12.65,12.57,12.49,12.46,12.50,12.60,12.72,12.84,12.96,13.08,13.15,13.25,13.37,13.47,13.58,13.66,13.78,13.89,13.99,14.02,14.08,14.10,14.11,14.10,14.08,14.02,14,13.91,13.86,13.75,13.65,13.59,13.51,13.50,13.50,13.50,13.38,13.12,12.57,11.64,10.45,9.01,7.60,6.34,5.35,4.66,4.27,4.12,4.12,4.26,4.53,4.95,5.41,6,6.62,7.25,8.37,9,8,8,7,6,4,3,0.87,0.82,1.51,1.36,1.07,0.48,-0.29,-1.28,-3.04,-3.89,-4.43,-4.77,-5.12,-5.25,-6.14,-5.88,-5.37,-4.63,-3.63,-2.63,-1.61,-0.75,0.96,4,7,9,8.21,8.07,7.99,8,8.12,8.25,8.41,8.61,8.77,8.99,9.22,9.47,9.74,10.02,10.37,10.73,11.09,11.41,11.76,12.10,12.37,12.61,12.78,12.96,13.07,13.12,13.16,13.22,13.24,13.26,13.33,13.37,13.49,13.60,13.72,13.87,14.01,14.20,14.37,14.51,14.65,14.82,14.90,15,15.03,15.08,15.08,15.08,15.03,15.01,15,15.02,15.09,15.12,15.15,15.13,15.09,15,14.91,14.87,14.76,14.65,14.52,14.37,14.25,14.20,14.12,14,13.75,13.39,12.97,12.28,10.98,19,19,19,19,19,18.99,18.86,18.62,18.35,18.11,17.88,17.74,17.58,17.38,17.24,17.12,17.03,16.99,16.88,16.75,16.61,16.41,16.25,16.08,15.87,15.62,15.37,15.12,14.98,14.90,14.97,15.02,15.11,15.09,14.96,14.74,14.50,14.33,14.25,14.33,14.49,14.65,14.78,14.83,14.65,14.35,13.87,13.33,12.75,12.20,11.73,11.37,11.12,11,11,11.12,11.45,11.72,12.07,12.41,12.75,13.08,13.34,13.58,13.77,13.99,14.14,14.25,14.35,14.41,14.47,14.48,14.46,14.40,14.37,14.28,14.25,14.21,14.12,14.10,14.07,14.01,14,14,14,14,14,14,13.97,13.89,13.85,13.75,13.70,13.61,13.50,13.37,13.25,13.03,12.75,12.40,12.01,11.63,11.34,11.16,11.15,11.35,11.53,11.83,12.12,12.46,12.77,13.12,13.47,13.76,14.03,14.25,14.45,14.59,14.71,14.76,14.85,14.87,14.88,14.88,14.87,14.87,14.84,14.76,14.71,14.59,14.41,14.24,13.99,13.66,13.27,12.85,12.37,11.91,11.62,11.50,11.62,11.98,12.46,12.95,13.36,13.64,13.86,13.97,14,13.98,13.88,13.75,13.58,13.36,13.13,13,12.87,12.77,12.70,12.61,12.58,12.61,12.71,12.82,12.89,13,13.14,13.27,13.38,13.50,13.59,13.66,13.78,13.88,13.99,14.02,14.09,14.10,14.11,14.12,14.12,14.12,14.12,14.11,14.08,14,13.91,13.84,13.75,13.65,13.62,13.62,13.60,13.50,13.24,12.71,11.87,10.72,9.36,7.95,6.62,5.60,4.84,4.36,4.11,4,4.10,4.32,4.64,5.12,5.70,6.34,6.99,7.57,8,8,8,7,6,5.82,2.62,1.50,0.01,-0.25,-0.48,-0.92,-1.50,-2.11,-2.65,-3.40,-3.93,-4.48,-4.75,-4.74,-5.87,-5.77,-5.50,-5,-4.25,-3.25,-2.05,-1.38,-0.53,0.98,2,4,6,6.12,6.57,6.97,7.33,7.62,7.87,8.12,8.33,8.51,8.74,8.96,9.21,9.48,9.76,10.12,10.48,10.85,11.22,11.58,11.89,12.22,12.47,12.65,12.83,12.95,13,13.08,13.12,13.13,13.20,13.25,13.33,13.41,13.53,13.71,13.87,14.02,14.23,14.40,14.60,14.75,14.88,15,15.11,15.14,15.16,15.20,15.20,15.15,15.12,15.10,15.07,15.03,15.07,15.08,15.03,15,14.95,14.86,14.75,14.62,14.50,14.35,14.21,14.10,14,13.96,13.83,13.59,13.23,12.83,12.37,11.13,19,19,19,18.91,18.76,18.64,18.52,18.34,18.12,17.89,17.74,17.57,17.38,17.24,17.12,17.07,17.07,17.07,17.02,16.97,16.84,16.66,16.51,16.36,16.13,15.90,15.64,15.38,15.16,15.01,14.96,14.91,14.89,14.85,14.70,14.47,14.20,13.96,13.83,13.82,13.88,14,14.07,14.01,13.86,13.53,13.12,12.62,12.12,11.70,11.37,11.20,11.14,11.25,11.45,11.72,12.12,12.47,12.85,13.21,13.50,13.75,13.98,14.13,14.32,14.45,14.57,14.64,14.65,14.73,14.75,14.75,14.73,14.66,14.62,14.59,14.51,14.46,14.37,14.32,14.23,14.13,14.08,14.02,14,14.01,14.01,14,14,13.97,13.91,13.87,13.84,13.76,13.70,13.59,13.39,13.14,12.78,12.33,11.83,11.37,11.03,11.01,11.12,11.37,11.66,12,12.37,12.72,13.02,13.36,13.63,13.90,14.14,14.35,14.50,14.62,14.74,14.83,14.87,14.89,14.91,14.95,14.95,14.90,14.88,14.86,14.76,14.64,14.49,14.25,13.97,13.62,13.21,12.75,12.28,11.88,11.62,11.58,11.75,12.12,12.62,13.10,13.49,13.76,13.97,14.03,14.08,14.02,13.96,13.78,13.60,13.37,13.14,13,12.95,12.87,12.78,12.73,12.66,12.73,12.82,12.89,12.98,13.12,13.33,13.50,13.57,13.62,13.71,13.77,13.88,13.97,14.01,14.08,14.10,14.10,14.11,14.11,14.12,14.13,14.16,14.20,14.16,14.13,14.08,13.99,13.87,13.82,13.75,13.73,13.66,13.58,13.33,12.84,12.07,11,9.71,8.34,7.01,5.90,5.07,4.48,4.12,3.91,3.89,4.01,4.27,4.63,5.09,5.59,6.08,6.76,7,7,6.86,5.75,5.39,4.22,3.12,0.75,-0.63,-0.93,-1.24,-1.75,-2.25,-2.80,-3.13,-3.53,-4.10,-4.38,-4.50,-5.49,-5.25,-5.15,-4.88,-4.38,-3.64,-2.88,-1.88,-1.05,-0.25,1,1,2,2,4.09,5.35,6.20,6.83,7.27,7.62,7.89,8.12,8.35,8.53,8.75,9,9.26,9.59,9.90,10.26,10.64,11.02,11.39,11.75,12.07,12.33,12.52,12.71,12.83,12.89,12.97,13,13.03,13.10,13.14,13.25,13.37,13.50,13.66,13.87,14.07,14.25,14.47,14.64,14.84,15,15.12,15.21,15.25,15.27,15.27,15.26,15.25,15.20,15.12,15.07,15.01,15,15,15,14.97,14.87,14.75,14.62,14.46,14.28,14.13,14,13.87,13.75,13.66,13.53,13.35,13.08,12.84,12.70,12.35,19,19,18,18.13,18.27,18.32,18.23,18.08,17.87,17.71,17.51,17.37,17.24,17.12,17.03,17.02,17.09,17.12,17.16,17.15,17.08,16.91,16.76,16.62,16.41,16.22,15.97,15.70,15.45,15.25,15.12,15.01,14.97,14.87,14.71,14.46,14.13,13.87,13.62,13.50,13.46,13.40,13.37,13.25,13.03,12.75,12.39,12.02,11.70,11.46,11.35,11.37,11.58,11.85,12.15,12.52,12.91,13.28,13.64,13.97,14.21,14.37,14.50,14.61,14.66,14.75,14.78,14.86,14.87,14.87,14.87,14.87,14.86,14.84,14.78,14.75,14.73,14.66,14.62,14.50,14.38,14.25,14.13,14.08,14.01,14.01,14.01,14,14,13.99,13.97,13.95,13.89,13.87,13.82,13.72,13.50,13.21,12.74,12.14,11.57,11.08,10.83,10.84,11.08,11.40,11.82,12.21,12.58,12.90,13.23,13.50,13.75,14,14.20,14.37,14.50,14.62,14.75,14.84,14.88,14.96,14.98,15,15,14.99,14.97,14.90,14.84,14.70,14.50,14.25,13.89,13.50,13.08,12.62,12.20,11.85,11.64,11.66,11.91,12.35,12.82,13.25,13.63,13.90,14.09,14.15,14.16,14.12,14,13.85,13.62,13.37,13.15,13.03,13,12.96,12.88,12.86,12.83,12.85,12.89,12.99,13.12,13.11,13.87,13.71,13.72,13.75,13.82,13.87,13.96,14,14.03,14.08,14.09,14.08,14.08,14.09,14.12,14.13,14.21,14.24,14.25,14.24,14.16,14.11,14,13.90,13.86,13.78,13.75,13.62,13.37,12.91,12.23,11.25,10.07,8.75,7.46,6.28,5.36,4.64,4.16,3.88,3.76,3.76,3.88,4.10,4.28,4.50,4.66,5,4.75,3.50,3.36,2.98,2.62,1.40,1.11,-0.25,-1.43,-1.49,-1.86,-2.36,-2.77,-3.38,-3.66,-3.75,-4,-4.30,-5.43,-5.28,-4.93,-4.62,-4.36,-3.91,-3.35,-2.54,-1.54,-0.63,0.87,3,2,2,1,3.12,5,6.07,6.75,7.24,7.60,7.87,8.10,8.27,8.49,8.70,8.90,9.15,9.47,9.76,10.12,10.50,10.88,11.26,11.62,11.95,12.21,12.40,12.59,12.72,12.77,12.86,12.88,12.96,13,13.09,13.20,13.33,13.49,13.65,13.87,14.09,14.28,14.50,14.72,14.89,15.08,15.21,15.28,15.36,15.37,15.37,15.35,15.27,15.22,15.12,15.07,15,15,15,14.98,14.95,14.85,14.66,14.49,14.28,14.12,13.98,13.82,13.63,13.50,13.38,13.27,13.14,13.01,13,13.13,13.51,19,18,18.10,18,18,17.99,17.96,17.85,17.64,17.48,17.33,17.21,17.11,17.02,17,17.01,17.10,17.16,17.25,17.27,17.23,17.12,16.98,16.84,16.64,16.47,16.23,15.98,15.75,15.53,15.39,15.32,15.24,15.12,14.96,14.70,14.37,14.01,13.72,13.45,13.22,13,12.82,12.59,12.35,12.09,11.83,11.62,11.49,11.49,11.62,11.87,12.25,12.62,13.03,13.46,13.84,14.12,14.37,14.61,14.75,14.87,14.90,14.96,14.96,14.96,14.95,14.96,14.96,14.95,14.95,14.95,14.90,14.89,14.88,14.89,14.89,14.89,14.85,14.75,14.58,14.38,14.23,14.11,14.03,14,14,14,14,14,13.98,13.97,13.96,13.91,13.87,13.75,13.58,13.21,12.64,11.95,11.25,10.75,10.52,10.64,11.01,11.47,11.90,12.37,12.75,13.10,13.37,13.62,13.85,14.03,14.24,14.38,14.52,14.64,14.75,14.87,14.95,15,15.03,15.08,15.09,15.09,15.07,15,14.89,14.75,14.50,14.21,13.84,13.39,12.91,12.48,12.08,11.78,11.71,11.83,12.12,12.53,13,13.46,13.82,14.08,14.24,14.32,14.32,14.24,14.10,13.88,13.63,13.38,13.21,13.10,13.07,13.07,13.02,12.99,12.95,12.95,12.99,13.02,13.11,13.89,13.89,13.87,13.85,13.86,13.89,13.96,13.99,14,14.03,14.07,14.03,14.03,14.02,14.03,14.09,14.12,14.20,14.25,14.27,14.27,14.25,14.16,14.09,14,13.90,13.86,13.75,13.62,13.38,12.99,12.35,11.48,10.37,9.13,7.87,6.71,5.71,4.89,4.34,3.96,3.74,3.62,3.60,3.60,3.52,3.35,3.07,2.50,2.12,0.87,0.58,0.22,0,-0.18,-0.75,-1.13,-2.25,-2.25,-2.26,-2.77,-3.10,-3.63,-4,-4.05,-3.90,-5,-5.13,-5.02,-4.67,-4.13,-3.88,-3.42,-2.86,-2.03,-1.10,0.58,3,5,4,3,2,4.20,5.62,6.51,7.09,7.46,7.75,7.98,8.16,8.37,8.52,8.73,8.90,9.13,9.40,9.73,10.07,10.41,10.78,11.15,11.50,11.83,12.10,12.32,12.48,12.60,12.65,12.74,12.77,12.85,12.89,13,13.12,13.25,13.46,13.64,13.87,14.10,14.33,14.53,14.75,14.97,15.12,15.25,15.37,15.41,15.46,15.45,15.38,15.33,15.22,15.12,15.02,15,15,14.99,14.98,14.91,14.83,14.62,14.39,14.20,14,13.86,13.65,13.48,13.33,13.22,13.12,13.09,13.09,13.25,13.50,13.73,18,18,18,17.87,17.75,17.66,17.62,17.52,17.39,17.25,17.13,17.09,17.01,17,16.99,17,17.10,17.16,17.26,17.33,17.27,17.21,17.10,16.98,16.83,16.63,16.45,16.24,16.01,15.87,15.75,15.71,15.62,15.51,15.36,15.10,14.75,14.37,13.96,13.53,13.14,12.77,12.41,12.11,11.82,11.59,11.45,11.40,11.51,11.75,12.12,12.57,13.01,13.50,13.90,14.28,14.62,14.87,14.98,15.12,15.21,15.25,15.25,15.23,15.15,15.10,15.01,15,14.99,14.98,14.97,14.97,14.96,14.96,14.96,15,15.02,15.09,15.03,14.97,14.75,14.50,14.28,14.13,14.03,14,14,14,14,13.99,13.98,13.98,13.97,13.96,13.88,13.77,13.57,13.15,12.49,11.75,11.01,10.45,10.26,10.50,10.99,11.50,12,12.50,12.89,13.22,13.49,13.73,13.91,14.12,14.25,14.40,14.57,14.66,14.78,14.88,15,15.08,15.12,15.15,15.21,15.21,15.15,15.11,15,14.83,14.53,14.20,13.75,13.26,12.77,12.32,11.97,11.75,11.76,11.99,12.35,12.76,13.23,13.62,13.98,14.23,14.37,14.46,14.41,14.34,14.16,13.98,13.73,13.49,13.26,13.15,13.16,13.22,13.21,13.12,13.02,13,13.03,13.13,13.09,13.89,13.96,13.95,13.90,13.91,13.96,13.99,14,14.01,14.02,14.02,14.01,14,14,14,14.03,14.10,14.13,14.23,14.26,14.28,14.26,14.22,14.12,14.02,13.95,13.87,13.75,13.62,13.37,13,12.40,11.63,10.64,9.50,8.32,7.13,6.11,5.25,4.59,4.12,3.82,3.61,3.46,3.26,3,2.45,1.28,0.73,0.36,-0.88,-1.38,-1.75,-1.88,-2.02,-2.38,-2.75,-2.90,-2.89,-2.90,-3.04,-3.37,-3.73,-4.04,-4.18,-5.04,-4.74,-4.63,-4.50,-4.16,-3.63,-3.17,-2.75,-2.15,-1.60,0.20,2.75,6,6,5,4,4,5.89,6.85,7.28,7.60,7.84,8.02,8.23,8.37,8.53,8.70,8.85,9,9.22,9.46,9.73,10.02,10.37,10.74,11.10,11.40,11.73,11.99,12.20,12.36,12.47,12.53,12.62,12.65,12.74,12.83,12.91,13.07,13.23,13.40,13.62,13.87,14.11,14.35,14.59,14.78,15,15.16,15.33,15.41,15.50,15.51,15.50,15.47,15.37,15.24,15.12,15.02,15,15,14.99,14.98,14.90,14.82,14.61,14.37,14.13,13.98,13.82,13.62,13.46,13.28,13.20,13.12,13.12,13.24,13.50,13.75,13.95,18,17.89,17.75,17.61,17.45,17.37,17.32,17.25,17.16,17.10,17,16.99,16.97,16.96,16.96,16.99,17.02,17.12,17.23,17.27,17.27,17.25,17.15,17.08,16.95,16.77,16.62,16.46,16.28,16.20,16.12,16.11,16.07,15.98,15.82,15.57,15.21,14.75,14.25,13.75,13.22,12.71,12.23,11.82,11.50,11.33,11.32,11.48,11.77,12.24,12.75,13.25,13.77,14.25,14.62,14.96,15.20,15.37,15.47,15.48,15.50,15.50,15.50,15.48,15.34,15.20,15.03,15,14.99,14.99,14.99,14.98,14.97,14.98,14.99,15.01,15.10,15.15,15.14,15.09,14.87,14.62,14.36,14.14,14.07,14,14,13.99,13.98,13.97,13.97,13.96,13.95,13.95,13.87,13.75,13.49,12.98,12.34,11.58,10.82,10.24,10.11,10.40,10.95,11.50,12.09,12.60,12.98,13.33,13.60,13.82,14,14.15,14.33,14.47,14.60,14.73,14.84,14.96,15.07,15.13,15.24,15.27,15.34,15.34,15.28,15.23,15.10,14.87,14.58,14.16,13.70,13.15,12.65,12.24,11.87,11.76,11.87,12.15,12.57,13,13.40,13.82,14.12,14.37,14.50,14.59,14.52,14.40,14.25,14.03,13.84,13.62,13.40,13.28,13.27,13.36,13.36,13.24,13.12,13.09,13.15,13.27,13.91,13.96,13.98,13.98,13.97,13.97,13.99,14,14,14.02,14.02,14.01,14,14,13.99,13.99,14,14.02,14.11,14.16,14.24,14.26,14.25,14.22,14.12,14.02,13.95,13.85,13.73,13.57,13.33,12.98,12.47,11.76,10.88,9.87,8.75,7.62,6.57,5.63,4.91,4.38,4,3.75,3.50,3.24,2.84,2.08,0.57,-0.91,-1.25,-1.60,-2.13,-2.49,-2.63,-1.88,-3.16,-3.18,-3.38,-3.38,-4.30,-3.39,-3.49,-3.63,-4.92,-5.05,-5,-4.63,-4.41,-4.16,-3.75,-3.13,-2.65,-2.29,-1.87,-0.25,2.51,7,7,8,8,6,6,7.87,7.78,8,8.10,8.25,8.37,8.51,8.66,8.82,8.91,9.03,9.20,9.35,9.52,9.76,10.03,10.37,10.71,11.01,11.35,11.62,11.87,12.08,12.23,12.34,12.40,12.49,12.53,12.62,12.73,12.85,13,13.16,13.37,13.62,13.87,14.11,14.36,14.60,14.83,15.01,15.21,15.35,15.46,15.51,15.58,15.59,15.51,15.40,15.25,15.12,15.01,15,15,14.99,14.98,14.91,14.82,14.61,14.37,14.13,13.98,13.86,13.75,13.62,13.50,13.35,13.24,13.25,13.50,13.90,14.07,14,17,17.13,17.28,17.24,17.12,17.01,17.03,17.07,17,16.97,16.89,16.87,16.86,16.86,16.87,16.88,16.96,17.02,17.13,17.24,17.25,17.26,17.24,17.14,17.03,16.90,16.76,16.62,16.52,16.48,16.46,16.46,16.41,16.37,16.23,15.97,15.59,15.11,14.52,13.90,13.27,12.66,12.12,11.70,11.38,11.32,11.41,11.75,12.24,12.78,13.37,13.90,14.39,14.83,15.13,15.37,15.53,15.65,15.73,15.72,15.72,15.72,15.72,15.70,15.49,15.25,15.02,15,15,14.99,14.99,14.99,14.99,14.99,14.99,15,15.07,15.12,15.12,15.08,14.88,14.63,14.37,14.14,14.03,14,13.99,13.97,13.96,13.95,13.91,13.90,13.89,13.87,13.78,13.61,13.25,12.78,12.13,11.38,10.64,10.12,10,10.37,10.91,11.52,12.12,12.62,13.07,13.38,13.65,13.87,14.09,14.24,14.37,14.50,14.63,14.75,14.87,15,15.12,15.25,15.35,15.40,15.47,15.49,15.46,15.36,15.20,14.95,14.61,14.14,13.62,13.10,12.58,12.14,11.91,11.85,12.01,12.37,12.76,13.21,13.62,13.98,14.26,14.50,14.62,14.66,14.62,14.49,14.28,14.11,13.95,13.76,13.60,13.45,13.37,13.37,13.41,13.26,13.16,13.21,13.37,13.75,13.96,13.99,13.99,14,13.99,13.99,13.99,14,14.01,14.02,14.02,14,14,13.98,13.96,13.95,13.96,13.99,14.03,14.12,14.20,14.24,14.24,14.20,14.12,14,13.89,13.78,13.64,13.49,13.25,12.91,12.49,11.87,11.12,10.22,9.20,8.11,7.03,6.11,5.34,4.75,4.33,4,3.74,3.46,2.97,2.53,1.07,-0.38,-0.74,-1.13,-1.66,-2,-2.17,-2.49,-2.75,-3.86,-3.65,-4.67,-4.50,-4.61,-4.40,-4.61,-4.55,-4.75,-4.66,-4.36,-4.04,-3.80,-3.38,-2.76,-2.25,-1.89,-0.38,1.24,6,8,10,11,9,9,8.22,8.12,8.36,8.38,8.48,8.59,8.72,8.86,9,9.12,9.23,9.32,9.39,9.51,9.65,9.87,10.11,10.37,10.66,10.99,11.26,11.52,11.75,11.96,12.10,12.21,12.26,12.35,12.40,12.50,12.62,12.75,12.91,13.12,13.36,13.60,13.86,14.12,14.36,14.60,14.83,15.01,15.21,15.35,15.46,15.52,15.60,15.62,15.58,15.46,15.27,15.12,15.01,15,15,14.99,14.98,14.91,14.83,14.62,14.37,14.15,14.01,13.97,13.97,13.98,13.87,13.72,13.51,13.47,13.90,14.95,15,14,16.95,16.87,16.98,17,17,16.98,16.97,16.95,16.88,16.84,16.75,16.66,16.63,16.64,16.70,16.75,16.82,16.91,17.07,17.20,17.25,17.32,17.28,17.25,17.13,17.02,16.90,16.82,16.74,16.70,16.70,16.71,16.71,16.62,16.49,16.23,15.83,15.27,14.64,13.99,13.32,12.65,12.12,11.72,11.50,11.50,11.75,12.20,12.75,13.37,13.96,14.45,14.86,15.20,15.46,15.62,15.75,15.83,15.86,15.87,15.85,15.85,15.86,15.85,15.66,15.39,15.12,15,15,15,15,15,15,15,14.99,15,15.01,15.03,15.03,15,14.87,14.62,14.37,14.15,14.03,14,13.98,13.96,13.91,13.89,13.87,13.87,13.84,13.75,13.61,13.37,13.03,12.59,11.95,11.25,10.57,10.08,10,10.38,10.96,11.59,12.14,12.70,13.12,13.48,13.75,13.99,14.15,14.34,14.47,14.60,14.71,14.83,14.95,15.08,15.21,15.34,15.46,15.52,15.60,15.62,15.59,15.48,15.26,15,14.62,14.12,13.60,13.01,12.50,12.12,11.95,11.99,12.22,12.57,12.99,13.38,13.77,14.12,14.40,14.62,14.74,14.75,14.70,14.50,14.33,14.12,14,13.88,13.74,13.53,13.37,13.32,13.25,13.24,13.22,13.28,13.62,13.87,13.99,14,14,14,14,13.99,13.99,14,14,14.01,14.01,14,13.98,13.95,13.89,13.87,13.88,13.91,13.99,14.07,14.12,14.20,14.21,14.15,14.10,14,13.87,13.74,13.59,13.38,13.15,12.87,12.48,11.98,11.33,10.51,9.61,8.58,7.50,6.53,5.74,5.11,4.64,4.33,4.02,3.73,3.65,2.25,1.70,1.25,-0.10,-0.51,-1.03,-1.38,-1.55,-1.79,-2.13,-3.23,-4.01,-4.80,-4.65,-4.51,-4.38,-4.39,-4.40,-4.25,-4.13,-3.79,-3.50,-3.25,-2.86,-2.23,-1.75,-0.36,2.15,5.76,8,10,11,12,10.96,9.50,8.96,8.59,8.50,8.59,8.70,8.84,9,9.14,9.32,9.41,9.51,9.60,9.64,9.73,9.84,9.98,10.15,10.39,10.65,10.95,11.22,11.46,11.64,11.84,11.97,12.03,12.12,12.21,12.27,12.37,12.50,12.66,12.87,13.08,13.32,13.57,13.84,14.11,14.37,14.59,14.78,15,15.15,15.32,15.40,15.50,15.57,15.60,15.57,15.45,15.26,15.12,15.01,15,15,14.99,14.98,14.95,14.86,14.66,14.45,14.23,14.09,14.07,14.16,14.32,14.35,14.12,13.88,13.82,14,15,15,15,16.10,16.74,16.74,16.84,16.89,16.88,16.88,16.87,16.76,16.62,16.49,16.35,16.26,16.28,16.37,16.50,16.62,16.78,16.98,17.13,17.25,17.35,17.36,17.33,17.24,17.12,17.01,16.95,16.87,16.84,16.83,16.84,16.82,16.74,16.58,16.26,15.85,15.26,14.62,13.90,13.25,12.62,12.14,11.86,11.75,11.87,12.22,12.73,13.33,13.88,14.39,14.84,15.14,15.41,15.62,15.75,15.86,15.89,15.91,15.91,15.91,15.90,15.91,15.91,15.85,15.62,15.41,15.22,15.11,15,15,15,15,15,15,15,15,15,15,14.96,14.83,14.62,14.37,14.15,14.02,13.99,13.96,13.90,13.87,13.85,13.82,13.75,13.71,13.59,13.38,13.13,12.82,12.36,11.77,11.15,10.52,10.12,10.11,10.48,11.08,11.66,12.25,12.75,13.21,13.58,13.86,14.10,14.26,14.41,14.57,14.66,14.76,14.87,15,15.12,15.25,15.40,15.52,15.63,15.71,15.73,15.66,15.57,15.36,15.02,14.62,14.12,13.53,12.99,12.48,12.12,11.98,12.08,12.36,12.74,13.15,13.59,13.96,14.27,14.53,14.73,14.83,14.83,14.73,14.52,14.33,14.13,14.01,13.97,13.83,13.62,13.35,13.13,13.12,13.12,13.14,13.36,13.70,13.98,14,14,14,14,14,14,13.97,13.97,13.99,14,14,14,13.96,13.88,13.86,13.84,13.83,13.86,13.91,14,14.11,14.15,14.20,14.15,14.10,13.98,13.84,13.65,13.49,13.26,13.03,12.75,12.41,11.99,11.45,10.75,9.91,8.91,7.88,6.88,6.03,5.37,4.90,4.61,4.35,4.12,3.37,3,2.40,1,-0.29,-0.74,-1.25,-1.62,-1.77,-1.93,-3.27,-4.38,-5.17,-4.79,-4.64,-4.36,-4.13,-4.10,-4.10,-3.91,-3.61,-3.03,-2.75,-2.50,-2.11,-1.48,-0.03,3.35,5.63,9,11,11,11,11.12,10.73,9.91,9.02,8.72,8.61,8.63,8.78,9,9.23,9.41,9.61,9.74,9.83,9.87,9.88,9.91,10,10.10,10.25,10.45,10.64,10.89,11.13,11.37,11.53,11.71,11.83,11.89,11.99,12.07,12.13,12.25,12.39,12.59,12.77,13,13.25,13.50,13.76,14.03,14.33,14.59,14.78,14.97,15.12,15.25,15.36,15.41,15.49,15.50,15.48,15.37,15.23,15.10,15,15,15,14.99,14.98,14.96,14.87,14.75,14.50,14.25,14.12,14.12,14.32,14.57,14.71,14.70,14.12,14,14,15,15,16,15.12,16,16.27,16.50,16.66,16.75,16.82,16.73,16.61,16.37,16.07,15.85,15.75,15.78,15.98,16.21,16.40,16.64,16.87,17.11,17.25,17.36,17.37,17.36,17.27,17.21,17.10,17,16.90,16.87,16.84,16.78,16.75,16.62,16.41,16.11,15.62,15.03,14.38,13.74,13.12,12.62,12.25,12.10,12.12,12.35,12.75,13.25,13.82,14.34,14.75,15.11,15.37,15.58,15.74,15.85,15.89,15.95,15.97,15.97,15.97,15.97,15.97,15.97,15.97,15.86,15.75,15.53,15.33,15.11,15,15,15,15,15,15,15,15,15,14.95,14.78,14.60,14.37,14.15,14.02,13.98,13.90,13.87,13.82,13.75,13.70,13.62,13.52,13.37,13.22,12.97,12.62,12.23,11.73,11.20,10.64,10.32,10.33,10.73,11.27,11.87,12.39,12.89,13.34,13.70,13.98,14.21,14.37,14.53,14.66,14.76,14.87,14.97,15.08,15.21,15.35,15.50,15.62,15.74,15.77,15.78,15.75,15.62,15.37,15.03,14.60,14.07,13.49,12.91,12.46,12.12,12.01,12.14,12.49,12.87,13.28,13.74,14.10,14.40,14.64,14.82,14.87,14.87,14.75,14.53,14.33,14.12,14.01,13.98,13.86,13.62,13.33,13.12,13.01,13.02,13.07,13.25,13.75,13.95,14,14,14,14,14,14,13.96,13.85,13.98,14,14,13.98,13.89,13.85,13.77,13.75,13.74,13.76,13.87,13.99,14.11,14.20,14.22,14.20,14.10,13.97,13.77,13.59,13.36,13.12,12.87,12.59,12.25,11.87,11.38,10.83,10.08,9.12,8.09,7.01,6.14,5.49,5,4.66,4.71,4.15,3.98,2.62,2.26,0.87,-0.48,-0.78,-1.35,-2.65,-3.87,-3.88,-4.24,-5.35,-5.15,-4.75,-4.50,-4.15,-3.64,-3.60,-3.61,-3.41,-3.11,-2.54,-2.18,-1.88,-1.38,0.22,2.37,6.63,10,11,12,12,11.87,11.15,10.62,9.86,8.95,8.62,8.51,8.64,8.87,9.12,9.38,9.63,9.85,10,10.09,10.12,10.12,10.12,10.14,10.22,10.33,10.48,10.65,10.87,11.09,11.26,11.45,11.58,11.66,11.75,11.84,11.89,12,12.13,12.32,12.50,12.73,12.96,13.21,13.47,13.73,14,14.25,14.50,14.75,14.95,15.07,15.16,15.25,15.34,15.37,15.37,15.34,15.25,15.13,15.07,15,15,15,14.99,14.99,14.97,14.91,14.78,14.59,14.28,14.12,14.10,14.35,14.63,14.88,14.97,15,14,14,15,15,15,15.87,15.33,15.77,15.91,16.10,16.20,16.24,16.15,16.11,15.84,15.52,15.24,15.10,15.25,15.51,15.87,16.21,16.50,16.77,17.01,17.21,17.28,17.36,17.34,17.26,17.20,17.08,16.97,16.85,16.75,16.64,16.58,16.48,16.32,16.08,15.72,15.25,14.66,14.08,13.50,13,12.63,12.47,12.46,12.61,12.88,13.27,13.75,14.25,14.65,15.01,15.28,15.50,15.70,15.82,15.87,15.95,15.97,15.98,15.98,15.98,15.98,15.99,15.99,15.98,15.98,15.98,15.87,15.62,15.22,15,15,15,15,15,15,15,15,14.99,14.95,14.82,14.60,14.35,14.12,14.01,13.97,13.88,13.82,13.72,13.62,13.57,13.48,13.37,13.24,13.07,12.84,12.53,12.21,11.78,11.36,10.96,10.65,10.72,11.12,11.60,12.12,12.62,13.11,13.50,13.84,14.11,14.34,14.50,14.65,14.77,14.87,14.98,15.03,15.13,15.25,15.40,15.58,15.71,15.82,15.87,15.87,15.77,15.62,15.37,15,14.52,13.99,13.39,12.87,12.41,12.13,12.10,12.25,12.61,13,13.41,13.84,14.21,14.50,14.74,14.87,14.91,14.88,14.76,14.57,14.32,14.12,14,13.99,13.87,13.63,13.33,13.10,13,13,13.01,13.12,13.15,13,14,14,14,14,13,13,13,13.87,14,14.03,14.01,13.97,13.86,13.75,13.70,13.62,13.62,13.71,13.82,13.97,14.12,14.23,14.25,14.23,14.12,13.95,13.72,13.46,13.14,12.86,12.52,12.23,11.88,11.52,11.08,10.50,9.78,8.91,7.89,6.87,5.96,5.28,4.86,4.62,3.91,2.96,1.73,1.37,0.25,-1.17,-2.50,-2.73,-3.25,-4.61,-4.76,-4.85,-4.92,-5.03,-4.90,-4.52,-4.15,-3.87,-3.36,-2.93,-2.89,-2.75,-2.42,-1.89,-1.66,-0.29,1.15,2.58,6.76,10,12,12,12,12.08,11.73,11.25,10.59,9.73,8.75,8.25,8.39,8.62,8.90,9.24,9.52,9.83,10.03,10.22,10.32,10.35,10.35,10.33,10.33,10.35,10.40,10.51,10.66,10.86,11.01,11.20,11.34,11.46,11.52,11.61,11.66,11.75,11.87,12.01,12.22,12.41,12.64,12.88,13.14,13.40,13.66,13.95,14.20,14.41,14.63,14.84,15,15.12,15.15,15.23,15.25,15.24,15.20,15.12,15.08,15.01,15,15,15,14.99,14.99,14.98,14.96,14.87,14.62,14.32,14.09,14.02,14.15,14.96,15,15,15,15,14,15,15,15,16.77,16.12,15.52,15.52,15.57,15.70,15.70,15.52,15.41,15.25,15,14.73,14.60,14.75,15.12,15.57,15.98,16.35,16.63,16.88,17.07,17.15,17.22,17.22,17.14,17.07,16.91,16.76,16.62,16.46,16.27,16.12,15.98,15.75,15.50,15.13,14.72,14.24,13.74,13.28,12.98,12.78,12.76,12.89,13.12,13.46,13.83,14.22,14.61,14.95,15.24,15.46,15.62,15.75,15.87,15.90,15.96,15.98,15.99,15.99,15.99,15.99,15.99,15.99,15.99,15.99,15.99,15.99,15.75,15.26,15,15,15,15,15,15,14.99,14.99,14.96,14.87,14.75,14.52,14.33,14.12,14.01,13.95,13.85,13.71,13.57,13.46,13.36,13.27,13.22,13.11,12.98,12.78,12.60,12.34,12,11.65,11.35,11.14,11.25,11.52,11.98,12.41,12.89,13.34,13.71,14,14.25,14.47,14.62,14.77,14.89,15,15.08,15.13,15.24,15.36,15.50,15.63,15.76,15.87,15.90,15.88,15.78,15.62,15.35,14.95,14.46,13.87,13.32,12.78,12.39,12.20,12.21,12.39,12.74,13.12,13.51,13.88,14.25,14.57,14.76,14.89,14.96,14.90,14.77,14.57,14.28,14.11,14,13.99,13.87,13.63,13.33,13.09,13,13,13,13,13,13,13,13,13,13,13,13,13,14,14.12,14.14,14.12,13.91,13.77,13.65,13.58,13.51,13.52,13.62,13.76,13.96,14.12,14.25,14.32,14.25,14.12,13.87,13.58,13.22,12.82,12.37,12,11.62,11.24,10.77,10.25,9.62,8.88,8.10,7.12,6.12,5.23,4.53,4.37,4,1.87,-0.24,-1.35,-1.67,-1.79,-2.13,-3.42,-3.63,-4,-4.38,-4.55,-4.62,-4.50,-4.55,-4.43,-4.05,-3.66,-3.38,-2.85,-2.52,-2.28,-1.90,-1.51,-1.18,-0.98,1.39,4.87,6,9,12,13,13,12.96,12.13,11.75,11.23,10.50,9.62,8.66,7.98,8.40,8.71,9,9.35,9.65,9.97,10.21,10.37,10.49,10.51,10.51,10.50,10.49,10.50,10.51,10.62,10.73,10.87,11,11.12,11.25,11.34,11.39,11.48,11.53,11.63,11.76,11.95,12.13,12.37,12.62,12.87,13.12,13.37,13.63,13.88,14.12,14.37,14.57,14.73,14.87,14.99,15.08,15.12,15.13,15.12,15.09,15.03,15,15,15,15,15,14.99,14.99,14.99,14.98,14.91,14.73,14.20,14.02,14,14,15,15,15,15,15,15,15,16,15,17.21,16.87,16.36,15.75,15.75,15.64,15.38,15.03,14.87,14.75,14.66,14.50,14.39,14.50,14.85,15.26,15.74,16.12,16.46,16.66,16.83,16.90,16.96,16.96,16.88,16.77,16.62,16.41,16.21,15.97,15.73,15.50,15.27,15.07,14.78,14.50,14.14,13.82,13.49,13.23,13.09,13.09,13.21,13.40,13.70,14,14.28,14.62,14.89,15.16,15.39,15.60,15.74,15.85,15.89,15.96,15.98,15.98,15.99,15.99,15.99,15.99,15.99,16,16,16,16,16,15.89,15.13,15,15,15,15,15,14.99,14.98,14.96,14.88,14.78,14.63,14.46,14.25,14.12,14,13.90,13.76,13.60,13.37,13.23,13.14,13.12,13.10,13.03,12.99,12.87,12.75,12.58,12.35,12.03,11.77,11.66,11.74,11.99,12.35,12.75,13.20,13.59,13.90,14.20,14.39,14.61,14.75,14.89,15,15.11,15.15,15.24,15.33,15.45,15.58,15.73,15.85,15.90,15.96,15.90,15.78,15.60,15.26,14.86,14.35,13.75,13.22,12.74,12.39,12.25,12.34,12.52,12.85,13.21,13.60,13.96,14.27,14.61,14.78,14.90,14.97,14.91,14.78,14.57,14.27,14.10,14,13.99,13.87,13.66,13.36,13.09,13,13,13,13,13,13,13,13,13,13,13,13,13,14,14,14.87,14.10,13.87,13.71,13.53,13.46,13.40,13.46,13.58,13.75,13.97,14.14,14.28,14.35,14.25,14.03,13.73,13.28,12.77,12.24,11.65,11.11,10.53,10,9.39,8.72,7.89,7.12,6.25,5.75,4.50,3.41,3.52,2.63,1.10,-1.14,-2.25,-2.25,-2.55,-2.74,-2.98,-3.26,-3.50,-3.63,-3.99,-4.17,-4.25,-4.13,-3.85,-3.75,-3.38,-3,-2.66,-2.15,-2.01,-1.75,-1.38,-0.88,0.36,0.62,3,7,8,10,12,13,13,12.59,12.20,11.72,11.13,10.40,9.62,8.98,8.50,8.60,8.84,9.12,9.47,9.76,10.09,10.34,10.50,10.62,10.71,10.71,10.70,10.65,10.64,10.65,10.73,10.78,10.88,11,11.10,11.16,11.25,11.32,11.37,11.46,11.57,11.71,11.87,12.11,12.35,12.61,12.87,13.12,13.38,13.63,13.88,14.12,14.34,14.50,14.63,14.75,14.85,14.90,14.99,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14,14,14,15,15,15,16,15,15,15,16,16,16,17.75,17.61,17.38,16.83,16.53,16.26,15.87,15.27,14.83,14.62,14.59,14.52,14.47,14.47,14.63,15,15.47,15.86,16.14,16.36,16.48,16.51,16.53,16.53,16.48,16.36,16.14,15.90,15.62,15.33,15.01,14.75,14.50,14.32,14.11,13.88,13.71,13.51,13.38,13.33,13.35,13.47,13.65,13.91,14.21,14.47,14.73,14.97,15.16,15.37,15.57,15.72,15.83,15.88,15.95,15.97,15.98,15.99,15.99,15.99,16,16,16,16,16,16,16,16,16,15,15,15,15,15,14.99,14.99,14.97,14.90,14.84,14.71,14.51,14.36,14.20,14.08,13.99,13.87,13.75,13.50,13.14,12.99,12.96,13,13.03,13.09,13.10,13.08,13,12.88,12.71,12.46,12.22,12.11,12.14,12.36,12.66,13.08,13.48,13.85,14.13,14.38,14.60,14.75,14.88,15,15.12,15.20,15.25,15.33,15.39,15.50,15.64,15.77,15.87,15.97,15.98,15.90,15.77,15.53,15.22,14.75,14.24,13.64,13.12,12.70,12.41,12.35,12.41,12.63,12.95,13.26,13.62,14,14.33,14.61,14.82,14.91,14.97,14.95,14.82,14.58,14.27,14.10,14,14,13.89,13.74,13.46,13.16,13.03,13,13,13,13,13,13,13,13,13,13,13,14,14,14,14,14.02,13.83,13.60,13.38,13.33,13.33,13.37,13.52,13.75,13.98,14.16,14.32,14.34,14.21,13.88,13.40,12.78,12.03,11.23,10.37,9.53,8.74,7.90,7.07,6.25,5.28,4.25,3.45,2,1.10,0.41,-1.16,-0.38,-1,-2.11,-2.24,-2.18,-2.29,-2.48,-2.67,-3.01,-3.25,-3.37,-3.38,-3.63,-3.67,-3.60,-3.28,-2.85,-2.39,-2.13,-1.79,-1.50,-1.38,-1.10,-0.65,0.51,1.75,5,7,8,10,11,12,13,12.71,12.39,12.03,11.51,10.91,10.33,9.71,9.15,8.83,8.84,9,9.27,9.59,9.88,10.16,10.41,10.62,10.75,10.85,10.87,10.87,10.86,10.85,10.85,10.87,10.90,10.98,11.02,11.11,11.14,11.21,11.25,11.32,11.38,11.50,11.65,11.87,12.11,12.37,12.62,12.89,13.16,13.45,13.70,13.95,14.14,14.35,14.50,14.62,14.70,14.75,14.78,14.87,14.91,14.98,15,15,15,15,15,15,15,15,15,15,15,15,15,14,14,14,15,15,16,16,16,15,15,16,16,16,17.99,17.96,17.82,17.62,17.37,17.12,16.61,15.99,15.37,14.99,14.86,14.76,14.62,14.50,14.50,14.75,15.15,15.50,15.75,15.90,16,16,16,15.97,15.87,15.75,15.57,15.28,14.99,14.63,14.34,14.08,13.87,13.71,13.60,13.50,13.49,13.48,13.50,13.60,13.73,13.89,14.13,14.38,14.62,14.87,15.08,15.25,15.40,15.58,15.71,15.82,15.87,15.91,15.97,15.98,15.99,15.99,15.99,16,16,16,16,16,16,16,16,16,16,15,15,15,15,15,15,14.99,14.97,14.88,14.76,14.61,14.39,14.24,14.10,14,13.96,13.87,13.72,13.38,12.99,12.61,12.77,12.95,13.10,13.23,13.28,13.35,13.33,13.24,13.03,12.82,12.53,12.41,12.47,12.63,12.96,13.34,13.73,14.08,14.37,14.60,14.76,14.90,15.02,15.12,15.20,15.25,15.28,15.37,15.48,15.60,15.72,15.84,15.90,15.98,15.98,15.89,15.75,15.50,15.13,14.66,14.12,13.58,13.03,12.64,12.45,12.39,12.50,12.74,13,13.34,13.66,14.01,14.35,14.61,14.83,14.91,14.97,14.96,14.82,14.59,14.27,14.09,14,14,13.96,13.85,13.62,13.36,13.12,13.01,13,13,13,13,13,13,13,13,13,14,14,14,14,14,14,14,13.28,13.22,13.21,13.24,13.35,13.51,13.75,14,14.20,14.28,14.25,14.03,13.57,12.83,11.83,10.63,9.37,8.14,7.01,5.96,4.87,3.77,2.75,2.13,0.60,-1,-2.18,-3.25,-3.05,-2.40,-2.54,-1.89,-1.92,-2.04,-2.04,-1.89,-2.03,-2.28,-2.63,-2.88,-3,-3,-2.93,-2.99,-2.88,-2.60,-2.12,-1.42,-1.05,-0.75,-0.73,-0.52,-0.27,0.86,4,6,9,10,10,11,12,12,12.89,12.46,12.11,11.74,11.28,10.82,10.26,9.76,9.35,9.08,9,9.21,9.45,9.72,10,10.25,10.50,10.73,10.87,10.98,11.01,11.03,11.03,11.03,11.03,11.07,11.09,11.11,11.12,11.15,11.20,11.23,11.25,11.32,11.38,11.51,11.71,11.89,12.14,12.40,12.71,12.99,13.25,13.51,13.77,14.01,14.24,14.40,14.53,14.62,14.66,14.71,14.74,14.76,14.87,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14,14,15,15,16,16,16,16,16,16,16,17,16,18.23,18.12,17.96,17.87,17.75,17.60,17.24,16.72,16.14,15.71,15.45,15.22,14.97,14.71,14.49,14.57,14.90,15.15,15.36,15.45,15.46,15.41,15.37,15.32,15.22,15.10,14.89,14.64,14.37,14.08,13.76,13.59,13.47,13.38,13.39,13.48,13.57,13.66,13.83,13.98,14.14,14.37,14.59,14.78,15,15.20,15.35,15.49,15.62,15.73,15.83,15.87,15.91,15.97,15.98,15.99,15.99,15.99,15.99,16,16.01,16.03,16.02,16,16,16,16,16,16,15,15,15,15,15,15,14.99,14.96,14.87,14.72,14.50,14.33,14.13,14,13.91,13.86,13.76,13.61,13.28,12.90,12.52,12.63,13,13.25,13.47,13.60,13.64,13.64,13.57,13.36,13.07,12.78,12.65,12.71,12.87,13.13,13.50,13.87,14.21,14.50,14.75,14.90,15.07,15.13,15.21,15.25,15.26,15.34,15.39,15.50,15.63,15.75,15.87,15.95,15.98,15.97,15.87,15.74,15.48,15.11,14.62,14.07,13.50,13,12.62,12.45,12.41,12.53,12.76,13.07,13.37,13.73,14.07,14.37,14.62,14.78,14.91,14.97,14.96,14.83,14.60,14.27,14.09,14,14,13.98,13.89,13.78,13.49,13.21,13.01,12.98,13,13,13,13,13,13,13,13,14,14,14,14,14,14,13,13,13.07,13.10,13.15,13.33,13.53,13.78,14.01,14.16,14.23,14.09,13.72,12.89,11.66,10.09,8.21,6.41,4.91,3.62,2.40,1.25,0.16,-1.16,-2.51,-3.68,-3.67,-4.85,-4.62,-4.13,-3.48,-2.62,-1.88,-1.65,-1.79,-1.78,-1.64,-1.39,-1.77,-2.13,-2.38,-2.50,-2.51,-2.42,-2.25,-1.99,-1.64,-1.13,-0.67,-0.25,-0.17,0.96,0.98,2,4,7,10,12,12,12,12,12,12,12.16,12.11,11.84,11.50,11.13,10.73,10.26,9.86,9.50,9.26,9.22,9.37,9.58,9.83,10.09,10.36,10.60,10.78,10.97,11.10,11.15,11.23,11.25,11.25,11.25,11.25,11.26,11.26,11.27,11.27,11.27,11.28,11.33,11.37,11.47,11.61,11.76,12,12.25,12.51,12.82,13.11,13.37,13.64,13.90,14.14,14.36,14.50,14.62,14.71,14.73,14.73,14.74,14.72,14.89,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14,14,15,16,16,16,16,16,16,16,16,16,16,18.75,18.24,18,17.95,17.87,17.84,17.64,17.33,16.85,16.41,16.08,15.75,15.39,15.03,14.73,14.62,14.77,14.97,15.02,15.02,14.98,14.86,14.75,14.63,14.58,14.48,14.35,14.14,13.90,13.71,13.58,13.50,13.52,13.60,13.65,13.77,13.91,14.10,14.25,14.41,14.61,14.76,14.96,15.12,15.28,15.45,15.57,15.65,15.75,15.85,15.88,15.95,15.98,15.99,15.99,15.99,15.99,15.99,16,16.03,16.14,16.25,16.25,16.10,16.01,16,16,16,16,15,15,15,15,15,15,14.99,14.95,14.86,14.71,14.50,14.32,14.12,13.98,13.85,13.73,13.61,13.45,13.20,12.89,12.75,12.96,13.25,13.53,13.77,13.91,14,13.98,13.84,13.58,13.23,12.98,12.84,12.84,13,13.26,13.62,14,14.36,14.64,14.88,15.09,15.21,15.26,15.28,15.32,15.33,15.36,15.40,15.51,15.63,15.77,15.87,15.95,15.97,15.95,15.87,15.71,15.41,15.03,14.57,14,13.46,12.97,12.61,12.41,12.40,12.53,12.77,13.11,13.46,13.78,14.12,14.39,14.63,14.82,14.91,14.97,14.97,14.85,14.62,14.28,14.10,14,14,14,13.95,13.78,13.58,13.20,12.88,12.99,13,12,12,12,12,13,13,13,14,15,14,14,14,14,13,13,13,13,13.07,13.33,13.60,13.87,14.10,14.15,14.09,13.65,12.96,12.25,9.95,7.23,4.87,2.90,1.07,0.13,-1.17,-2.63,-3.38,-3.99,-5.38,-5.54,-5.35,-4.87,-4.50,-4,-3.37,-2.50,-1.74,-1.35,-1.40,-1.40,-1.28,-1.05,-1.17,-1.50,-1.75,-1.89,-1.90,-1.85,-1.63,-1.27,-0.80,-0.27,-0.02,0.98,0.99,2,4,6,8,11,12,13,12,12,12,13,12.09,11.89,11.77,11.60,11.35,11.02,10.70,10.33,9.97,9.64,9.47,9.38,9.48,9.70,9.90,10.15,10.40,10.64,10.87,11.03,11.21,11.32,11.37,11.45,11.48,11.50,11.50,11.50,11.50,11.49,11.47,11.46,11.46,11.47,11.50,11.61,11.75,11.90,12.13,12.38,12.66,12.97,13.25,13.51,13.78,14.07,14.27,14.49,14.62,14.74,14.77,14.78,14.78,14.78,14.85,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,16,16,17,17,16,16,16,16,16,16,16,18.75,18.35,18,17.98,17.96,17.89,17.84,17.65,17.39,17.02,16.65,16.28,15.88,15.49,15.12,14.91,14.87,14.91,14.89,14.83,14.63,14.41,14.23,14.09,14,14,13.97,13.87,13.77,13.73,13.75,13.86,13.96,14.07,14.16,14.32,14.46,14.61,14.75,14.87,15,15.12,15.25,15.38,15.50,15.62,15.73,15.82,15.87,15.90,15.96,16,16.01,16.02,16,16,16,16.01,16.09,16.20,16.37,16.63,16.78,16.97,16.98,16.99,17,16,16,15,15,15,15,15,15,14.99,14.96,14.87,14.75,14.59,14.38,14.21,13.99,13.75,13.57,13.38,13.24,13.09,12.96,13.08,13.32,13.62,13.91,14.14,14.26,14.32,14.21,13.96,13.65,13.35,13.09,12.90,12.91,13.10,13.37,13.75,14.12,14.49,14.78,15.03,15.24,15.35,15.38,15.38,15.37,15.36,15.37,15.40,15.50,15.62,15.75,15.86,15.91,15.96,15.91,15.85,15.65,15.38,15,14.50,13.97,13.39,12.91,12.59,12.39,12.38,12.53,12.82,13.14,13.51,13.87,14.22,14.49,14.71,14.84,14.95,14.98,14.98,14.86,14.62,14.32,14.10,14,14,14,13.90,13.71,13.32,13,12.98,12,12,12,12,12,12,13,13,14,14,15,14,14,14,14,13,13,13,13,13,13,14,13.97,14.10,14.37,13.63,13.12,12.01,9.76,6.40,3.75,0.91,-1.13,-2,-2.73,-4.13,-4.47,-5.02,-5.62,-5.73,-5.64,-5.37,-4.79,-4.25,-3.75,-3.12,-2.24,-1.48,-1.13,-0.88,-0.89,-0.79,-0.77,-0.90,-1,-1,-1.13,-1.15,-1.05,-0.87,-0.50,0,1,2,3,4,6,8,10,11,12,12,13,13,12,12,12,11.90,11.71,11.57,11.38,11.21,10.97,10.66,10.37,10.09,9.83,9.63,9.59,9.62,9.76,10,10.25,10.48,10.72,10.91,11.12,11.27,11.41,11.52,11.62,11.65,11.71,11.73,11.74,11.73,11.71,11.66,11.64,11.63,11.64,11.72,11.78,11.91,12.12,12.34,12.59,12.86,13.12,13.40,13.71,13.97,14.22,14.41,14.61,14.75,14.84,14.87,14.87,14.87,14.88,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,16,16,17,17,17,16,16,16,16,16,16,16,18.77,18.34,18,17.99,17.98,17.96,17.89,17.84,17.66,17.46,17.14,16.76,16.35,15.89,15.52,15.27,15.14,15.10,14.99,14.82,14.53,14.25,13.99,13.83,13.78,13.87,13.90,13.96,14,14.09,14.21,14.36,14.50,14.63,14.76,14.87,15,15.10,15.20,15.25,15.35,15.41,15.50,15.61,15.70,15.75,15.84,15.87,15.91,15.97,15.99,16.03,16.11,16.12,16.09,16.02,16.03,16.12,16.25,16.40,16.61,16.83,16.95,16.98,16.99,17,17,17,16,15,15,15,15,15,15,14.99,14.97,14.89,14.84,14.71,14.52,14.27,14.02,13.75,13.50,13.27,13.12,13.10,13.20,13.39,13.71,14,14.28,14.48,14.53,14.48,14.33,14.07,13.73,13.39,13.12,13,13,13.16,13.48,13.85,14.24,14.60,14.89,15.15,15.36,15.47,15.50,15.49,15.41,15.37,15.37,15.40,15.50,15.62,15.74,15.85,15.90,15.96,15.90,15.84,15.64,15.37,14.97,14.47,13.90,13.37,12.89,12.58,12.39,12.39,12.58,12.86,13.23,13.62,14,14.32,14.58,14.75,14.87,14.91,14.98,14.98,14.87,14.62,14.32,14.10,14,14,14,13.91,13.65,13.20,12.95,12,12,12,12,12,13,13,13,14,14,14,14,14,14,14,14,13,13,13,13,14,13,14,14,14,14,14,11,10,5.62,2,-0.63,-1.50,-3.50,-4.28,-4.86,-5.14,-5.27,-5.24,-5.36,-5.50,-5.39,-5.13,-4.63,-3.88,-3.35,-2.65,-1.77,-1.13,-0.89,-0.63,-0.35,-0.24,-0.40,-0.54,-0.52,-0.46,-0.16,0.04,0.21,0.23,1.20,2,3,4,6,8,10,11,11,11,13,12,12,12,12,11.87,11.64,11.57,11.47,11.36,11.24,11.10,10.90,10.71,10.46,10.22,9.99,9.84,9.75,9.76,9.87,10.10,10.32,10.51,10.75,10.98,11.16,11.36,11.50,11.63,11.75,11.85,11.88,11.95,11.96,11.96,11.95,11.90,11.88,11.87,11.88,11.96,12.02,12.15,12.35,12.57,12.78,13.07,13.35,13.61,13.87,14.12,14.36,14.53,14.72,14.83,14.88,14.95,14.95,14.96,14.97,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,16,17,17,17,17,16,16,16,16,16,16,16,18.83,18.23,18,17.98,17.97,17.96,17.91,17.88,17.82,17.66,17.50,17.12,16.66,16.24,15.87,15.62,15.49,15.35,15.20,14.98,14.70,14.37,14.11,13.96,13.98,14.08,14.20,14.28,14.39,14.52,14.72,14.88,15.07,15.20,15.28,15.37,15.46,15.50,15.57,15.60,15.62,15.64,15.71,15.75,15.82,15.86,15.88,15.95,15.97,15.98,16,16.09,16.14,16.21,16.12,16.09,16.12,16.33,16.50,16.71,16.72,16.77,16.95,16.98,17,16,16,16,16,15,15,15.10,15.12,15.09,15,14.99,14.98,14.96,14.87,14.76,14.62,14.37,14.10,13.77,13.50,13.25,13.12,13.20,13.40,13.74,14.08,14.39,14.65,14.78,14.74,14.62,14.39,14.10,13.75,13.45,13.20,13.07,13.10,13.26,13.60,13.97,14.35,14.71,15,15.25,15.45,15.53,15.59,15.52,15.48,15.38,15.37,15.39,15.49,15.61,15.73,15.84,15.89,15.95,15.91,15.85,15.63,15.35,14.91,14.40,13.87,13.35,12.88,12.59,12.40,12.45,12.62,12.90,13.28,13.71,14.09,14.38,14.62,14.78,14.88,14.95,14.98,14.98,14.87,14.63,14.33,14.10,14,14,14,13.95,13.77,13.07,12.99,12,12,12,12,12,13,13,14,14,14,14,14,14,14,15,14,13,13,13,13,14,13,14,14,14,14,13,9,3.87,1.12,-0.50,-2.13,-3.02,-3.90,-4.64,-5.14,-5.37,-5.50,-5.40,-5.17,-5,-4.98,-4.66,-4.15,-3.40,-2.75,-2.03,-1.15,0.21,0.39,0.65,1,0,0,-0.13,0.10,0.50,1.22,1.86,2.66,3.10,3.82,4.75,6.58,7,8.63,10.78,11,11,11,11,12,12,12,12,11.12,11.40,11.35,11.25,11.21,11.14,11.10,11,10.87,10.74,10.53,10.35,10.14,10,9.90,9.90,10,10.14,10.37,10.59,10.78,11,11.22,11.39,11.59,11.74,11.87,11.98,12.07,12.12,12.14,12.15,12.15,12.14,12.13,12.13,12.15,12.22,12.28,12.41,12.61,12.82,13.03,13.28,13.57,13.82,14.07,14.27,14.49,14.64,14.77,14.87,14.95,14.98,14.99,14.99,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,16,16,17,17,17,17,17,17,17,16,16,16,16,18.12,18.10,17.96,17.91,17.89,17.87,17.87,17.87,17.84,17.75,17.61,17.25,16.82,16.39,16.09,15.87,15.74,15.62,15.45,15.25,14.99,14.72,14.50,14.37,14.39,14.50,14.62,14.75,14.87,15.01,15.16,15.35,15.49,15.60,15.66,15.75,15.78,15.85,15.86,15.85,15.84,15.84,15.85,15.87,15.87,15.90,15.95,15.97,15.98,15.99,16,16.08,16.13,16.20,16.12,16.09,16.21,16.48,16.82,16.83,16.73,16.12,16,16,16,16,16,16,16,15,15,15.12,15.49,15.12,15.01,14.99,14.98,14.97,14.89,14.84,14.66,14.46,14.14,13.85,13.53,13.33,13.25,13.38,13.70,14.03,14.40,14.75,14.97,14.99,14.90,14.74,14.45,14.12,13.76,13.48,13.25,13.14,13.23,13.41,13.75,14.11,14.47,14.77,15.09,15.32,15.49,15.60,15.62,15.58,15.50,15.40,15.37,15.38,15.48,15.60,15.73,15.85,15.91,15.98,15.97,15.86,15.65,15.34,14.88,14.37,13.84,13.33,12.88,12.61,12.47,12.50,12.66,12.99,13.37,13.75,14.12,14.41,14.64,14.82,14.89,14.95,14.98,14.96,14.87,14.61,14.27,14.09,14,14,13.99,13.97,13.91,13,13,12,12,12,12,13,13,13,14,14,14,14,14,14,14,14,14,13,13,13,13,13,13,14,14,14,14,11,7,1.47,-0.50,-2.28,-2.92,-3.63,-4.28,-5.03,-5.51,-5.76,-5.68,-5.40,-5.15,-4.68,-4.27,-3,-2.50,-1.75,-1,-0.25,1.39,1.59,2.76,3,3,2,0.98,0.96,1.15,1.63,2.32,3.22,4.32,5.38,6.87,7,7,7.50,8.47,9.47,10.15,10.50,10.74,11,12,12,12,11.96,11.37,11.12,11.03,11,10.99,10.98,10.97,10.91,10.87,10.75,10.62,10.49,10.33,10.20,10.11,10.08,10.12,10.25,10.40,10.62,10.84,11.02,11.25,11.45,11.62,11.77,11.95,12.08,12.16,12.25,12.33,12.36,12.37,12.37,12.37,12.38,12.41,12.49,12.59,12.72,12.87,13.09,13.32,13.53,13.78,14.02,14.25,14.46,14.62,14.75,14.87,14.91,14.97,14.99,15,15,15,15,15,15,15,15,15,15,16,15,15,15,15,15,15,15,15,16,16,17,17,17,17,17,17,17,17,16,16,16,18,17.87,17.75,17.63,17.62,17.63,17.66,17.74,17.77,17.66,17.50,17.16,16.82,16.46,16.15,16,15.87,15.82,15.71,15.50,15.34,15.13,15,14.91,14.95,15,15.10,15.21,15.32,15.40,15.52,15.64,15.75,15.85,15.90,16,16.03,16.09,16.08,16.02,15.99,15.96,15.91,15.91,15.95,15.96,15.97,15.98,15.99,15.99,16,16.02,16.09,16.11,16.08,16.09,16.20,16.40,16.61,16.65,16.16,16.01,16,16,16,16,16,16,16,15,15,15.09,15.12,15.09,15,15,14.98,14.97,14.91,14.87,14.73,14.50,14.23,13.90,13.63,13.47,13.46,13.63,13.97,14.35,14.73,15,15.12,15.12,15,14.75,14.45,14.11,13.76,13.50,13.33,13.26,13.37,13.61,13.89,14.25,14.57,14.86,15.12,15.33,15.49,15.58,15.60,15.57,15.49,15.40,15.37,15.38,15.48,15.61,15.75,15.87,15.99,16.02,16,15.89,15.70,15.36,14.87,14.36,13.78,13.28,12.88,12.62,12.51,12.58,12.75,13.03,13.39,13.77,14.12,14.40,14.62,14.78,14.87,14.91,14.96,14.88,14.75,14.50,14.24,14.07,13.99,13.99,13.99,13.96,13.99,13,12,12,12,12,13,13,13,13,14,14,14,14,14,14,14,14,14,14,13,13,14,13,13,14,14,14,13,8,2.75,-0.16,-2.15,-2.98,-3.54,-4,-4.63,-5.13,-5.63,-5.87,-5.87,-5.53,-4.93,-3.50,-2.78,-1.12,-0.60,1.20,2,2.75,2.87,3,3,3,3,2,2,1.91,2.13,2.61,3.28,4.22,5.77,6.73,7,7,7,7.45,8.07,8.79,9.40,9.89,10.36,11,12,12,12,11.52,11.21,10.95,10.82,10.77,10.78,10.84,10.87,10.87,10.87,10.82,10.74,10.62,10.49,10.37,10.26,10.24,10.25,10.35,10.49,10.65,10.87,11.07,11.25,11.46,11.62,11.83,11.99,12.12,12.25,12.36,12.45,12.50,12.52,12.58,12.60,12.62,12.66,12.75,12.86,13,13.15,13.37,13.60,13.83,14.03,14.25,14.48,14.63,14.77,14.87,14.95,14.97,14.98,14.99,15,15,15,15,15,15,15,15,15,15,16,16,15,15,15,15,15,15,16,16,16,17,17,17,17,17,17,17,17,17,16,16,17.95,17.76,17.36,17.35,17.34,17.37,17.41,17.50,17.52,17.48,17.32,17.03,16.74,16.41,16.16,16.02,15.97,15.89,15.86,15.75,15.63,15.57,15.48,15.40,15.40,15.46,15.50,15.57,15.62,15.70,15.75,15.85,15.89,15.99,16.08,16.14,16.23,16.25,16.23,16.14,16.09,16.01,15.99,15.97,15.97,15.97,15.98,15.98,15.99,15.99,16,16,16,16.01,16,16.02,16.11,16.22,16.26,16.23,16.09,16,16,16,16,16,16,16,16,15,15,15,15.01,15.01,15,15,14.99,14.98,14.95,14.87,14.75,14.53,14.27,14,13.74,13.62,13.64,13.87,14.21,14.58,14.87,15.10,15.21,15.15,15,14.73,14.38,14.07,13.75,13.52,13.40,13.41,13.53,13.76,14.07,14.36,14.62,14.87,15.11,15.27,15.41,15.50,15.52,15.50,15.47,15.39,15.37,15.40,15.50,15.63,15.78,15.96,16.08,16.12,16.12,15.99,15.75,15.37,14.88,14.34,13.77,13.28,12.90,12.66,12.60,12.64,12.84,13.12,13.45,13.77,14.12,14.38,14.62,14.75,14.87,14.90,14.90,14.82,14.60,14.35,14.12,14,13.98,13.99,13.97,13.99,13,13,13,12,13,13,13,13,13,13,13,13,13,13,14,14,14,14,14,14,13,12,13,13,14,14,14,14,11,6,1.24,-0.65,-2.63,-3.38,-4,-4.53,-4.91,-5.43,-5.65,-5.79,-5.66,-5.39,-3.86,-3.02,-1.38,0.58,1.25,3.12,3.90,4,3,3,3.23,3.36,3.25,3.12,2.97,2.99,3.10,3.48,4.07,4.83,5.63,6.33,6.71,6.87,6.96,7.25,7.64,8.16,8.66,9.16,9.73,10.75,12,12,11.71,11.22,10.89,10.72,10.62,10.62,10.65,10.74,10.78,10.86,10.87,10.87,10.83,10.75,10.63,10.53,10.47,10.39,10.39,10.47,10.57,10.72,10.88,11.09,11.25,11.46,11.62,11.82,11.99,12.13,12.27,12.39,12.50,12.60,12.65,12.73,12.76,12.84,12.88,12.99,13.12,13.25,13.45,13.63,13.87,14.10,14.32,14.50,14.71,14.86,14.99,15.07,15.03,15,14.99,15,15,15,15,15,15,15,15,15,15,15,16,16,15,15,15,15,15,16,16,16,17,17,17,17,17,17,17,17,17,17,16,16,18,17.13,17.12,17.01,17.07,17.10,17.21,17.25,17.27,17.25,17.12,16.91,16.65,16.38,16.15,16.02,15.99,15.96,15.95,15.91,15.87,15.86,15.83,15.76,15.75,15.75,15.75,15.77,15.83,15.86,15.87,15.91,15.99,16.07,16.14,16.25,16.33,16.35,16.28,16.23,16.12,16.03,16,15.99,15.98,15.98,15.98,15.99,15.99,15.99,16,16,16,16,16,16,16.01,16.02,16.01,16,16,16,16,16,16,16,16,16,16,15,15,15,15,15,15,15,14.99,14.98,14.96,14.88,14.76,14.59,14.33,14.02,13.82,13.72,13.77,14.01,14.36,14.70,14.95,15.12,15.20,15.12,14.90,14.62,14.33,14,13.75,13.60,13.52,13.59,13.72,13.90,14.14,14.39,14.62,14.86,15.03,15.22,15.35,15.41,15.47,15.47,15.41,15.40,15.40,15.48,15.59,15.72,15.87,16.03,16.16,16.25,16.25,16.11,15.84,15.40,14.90,14.35,13.76,13.28,12.96,12.74,12.65,12.75,12.90,13.15,13.47,13.76,14.09,14.37,14.59,14.75,14.86,14.89,14.88,14.72,14.45,14.16,14.02,13.87,13.95,13.98,13.99,13,13,13,13,12,13,14,13,13,13,13,13,13,13,13,13,14,14,14,14,13,13,13,13,14,14,14,14,14,9,3.62,-0.17,-2,-2.89,-3.89,-4.67,-5.25,-5.62,-5.76,-5.99,-5.93,-5.63,-4.15,-3.39,-1.60,0.37,1.27,3.12,4.76,3.99,4,4,3,3.65,3.87,3.92,3.91,3.88,3.89,4,4.25,4.66,5.20,5.75,6.25,6.60,6.82,6.91,7.09,7.32,7.62,7.99,8.38,8.87,9.40,11,11.90,11.11,10.76,10.58,10.48,10.47,10.50,10.60,10.70,10.76,10.86,10.88,10.90,10.89,10.87,10.78,10.72,10.62,10.59,10.57,10.59,10.64,10.76,10.90,11.10,11.26,11.45,11.62,11.77,11.97,12.12,12.26,12.40,12.52,12.63,12.75,12.84,12.89,13,13.09,13.21,13.35,13.50,13.71,13.90,14.12,14.37,14.59,14.76,14.96,15.10,15.22,15.34,15.28,15,15,15,15,15,15,15,15,15,15,15,15,15,16,16,15,15,15,15,15,16,16,17,17,17,17,17,17,17,17,17,17,17,16,16,17,17.09,17,16.98,16.97,17,17.02,17.09,17.11,17.09,17,16.87,16.62,16.37,16.14,16.02,15.99,15.98,15.98,16,16.01,16,16,15.98,15.91,15.89,15.89,15.89,15.90,15.91,15.95,15.98,16,16.10,16.20,16.27,16.36,16.37,16.32,16.23,16.12,16.03,16,15.99,15.99,15.98,15.99,15.99,15.99,15.99,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,15,15,15,15,15,15,15,14.99,14.98,14.96,14.88,14.77,14.61,14.35,14.07,13.84,13.75,13.86,14.10,14.40,14.70,14.91,15.08,15.11,15,14.83,14.52,14.24,13.97,13.76,13.65,13.64,13.73,13.85,14,14.21,14.38,14.61,14.77,14.98,15.12,15.25,15.36,15.38,15.40,15.41,15.45,15.49,15.57,15.66,15.83,16,16.15,16.33,16.39,16.37,16.24,15.91,15.50,14.95,14.36,13.77,13.32,12.98,12.77,12.75,12.83,13,13.24,13.50,13.78,14.09,14.35,14.58,14.74,14.85,14.89,14.88,14.63,14.25,14.07,13.88,13.96,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,14,14,13,12,12,13,14,14,14,14,14,14,10,2.35,-0.50,-2.13,-3.37,-4.38,-5.18,-5.75,-6.10,-6.25,-6.18,-5.99,-4.67,-4.13,-2.25,-0.05,1.07,2.89,3.50,3.97,4,4,4,4,4.34,4.58,4.67,4.72,4.72,4.73,4.83,4.89,5.14,5.48,5.87,6.25,6.58,6.77,6.90,7,7.11,7.25,7.47,7.72,7.97,8.16,10.78,10.53,10.38,10.25,10.21,10.25,10.35,10.46,10.59,10.70,10.77,10.87,10.95,10.99,11,10.99,10.95,10.87,10.82,10.75,10.73,10.73,10.75,10.86,10.97,11.10,11.25,11.40,11.59,11.75,11.89,12.09,12.25,12.37,12.51,12.64,12.76,12.88,13,13.12,13.24,13.37,13.52,13.73,13.95,14.15,14.39,14.62,14.86,15.02,15.22,15.36,15.48,15.61,16,16,16,15,15,15,15,15,15,15,15,15,15,15,16,16,15,15,15,15,16,16,17,17,17,17,17,17,17,17,17,17,17,17,16,16,17,16.99,16.99,16.87,16.86,16.84,16.95,16.99,17,16.99,16.91,16.82,16.60,16.34,16.12,16.01,15.99,15.99,15.99,16,16.03,16.03,16.03,16.01,16,15.98,15.97,15.96,15.97,15.96,15.97,15.99,16,16.09,16.15,16.25,16.32,16.32,16.25,16.16,16.11,16.02,16,15.99,15.99,15.99,15.99,15.99,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,15,15,15,15,15,15,15,14.99,14.99,14.96,14.88,14.77,14.59,14.33,14.02,13.84,13.75,13.87,14.12,14.39,14.64,14.87,15,15,14.90,14.72,14.46,14.16,13.96,13.83,13.76,13.77,13.86,13.97,14.09,14.22,14.37,14.51,14.72,14.89,15.09,15.24,15.34,15.38,15.45,15.48,15.50,15.58,15.65,15.77,15.96,16.12,16.32,16.48,16.57,16.51,16.37,16.01,15.53,14.98,14.37,13.77,13.32,13,12.84,12.82,12.89,13.10,13.33,13.59,13.86,14.12,14.37,14.59,14.75,14.86,14.90,14.90,14.82,14.11,13.89,13.95,13.01,13,13,13,13,13,13,13,13,13,13,14,14,14,13,13,13,13,13,13,13,13,13,13,11,12,13,13,14,14,14,14,14,8.87,2.14,-0.63,-2.63,-3.64,-4.66,-5.42,-6,-6.48,-6.67,-6.66,-6.40,-4.89,-3.15,-1.26,-0.13,2.25,3.12,3.75,3.98,4,5,5,5,5.17,5.35,5.45,5.47,5.42,5.40,5.49,5.38,5.49,5.66,5.96,6.27,6.57,6.76,6.89,6.97,7.01,7.08,7.15,7.26,7.35,7.01,8.57,9.45,9.58,9.70,9.85,10.03,10.25,10.46,10.61,10.74,10.85,10.91,11,11.03,11.09,11.09,11.07,11.01,10.98,10.90,10.87,10.87,10.87,10.91,11,11.11,11.24,11.37,11.51,11.71,11.85,12,12.16,12.35,12.50,12.62,12.77,12.90,13.07,13.21,13.35,13.50,13.71,13.90,14.14,14.39,14.65,14.89,15.12,15.32,15.48,15.61,15.75,15.86,16,16,16,16,16,16,15,15,15,15,15,15,15,15,16,16,16,15,15,15,16,16,17,17,17,17,17,17,17,17,17,17,17,17,16,16,17,17,16.88,16.75,16.37,16.64,16.84,16.95,16.98,16.95,16.87,16.74,16.50,16.25,16.11,16,15.99,15.99,16,16,16.01,16.03,16.02,16.01,16,16,15.98,15.98,15.98,15.98,15.98,15.99,16,16.07,16.12,16.20,16.23,16.23,16.16,16.12,16.07,16,16,16,15.99,15.99,15.99,15.99,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,15,15.12,15.02,15,15,15,15,14.99,14.98,14.96,14.87,14.75,14.51,14.25,14,13.83,13.78,13.91,14.16,14.40,14.62,14.83,14.90,14.91,14.84,14.63,14.39,14.15,14,13.90,13.88,13.95,14,14.07,14.12,14.21,14.32,14.47,14.64,14.87,15.09,15.25,15.37,15.47,15.50,15.57,15.62,15.66,15.76,15.89,16.08,16.25,16.46,16.62,16.71,16.65,16.48,16.12,15.61,15,14.38,13.82,13.33,13,12.87,12.87,12.99,13.16,13.40,13.66,13.95,14.21,14.41,14.62,14.76,14.87,14.90,14.96,14.87,14.09,13.90,13.03,13,13,13,13,13,13,13,13,13,13,13,13,14,14,14,13,13,13,13,13,14,13,13,12,11,12,13,13,14,14,14,14,13,7.75,2.11,-0.90,-2.92,-3.75,-4.67,-5.66,-6.41,-6.92,-7.14,-7.16,-6.01,-4.62,-2.86,-1.75,0.70,3.23,4.39,4.97,5,5,5,5,6,6.01,6.09,6.12,6.09,6,5.90,5.96,5.71,5.66,5.70,5.92,6.25,6.57,6.77,6.90,7,7,7,7,7,7,7,7.59,8.47,8.84,9.16,9.52,9.88,10.22,10.48,10.65,10.82,10.90,11,11.08,11.12,11.15,11.16,11.16,11.14,11.11,11.07,11,10.99,10.99,11,11.03,11.12,11.22,11.33,11.46,11.60,11.75,11.91,12.12,12.25,12.41,12.60,12.75,12.91,13.10,13.25,13.45,13.62,13.85,14.09,14.35,14.63,14.91,15.16,15.37,15.63,15.75,15.84,15.87,15.91,16,16,16,16,16,16,16,15,15,15,15,15,15,15,16,16,16,15,15,15,16,17,16,17,17,17,17,17,17,17,17,17,17,17,17,16,17,17,16.98,16.13,16.23,16.40,16.74,16.95,16.96,16.89,16.75,16.57,16.36,16.15,16.07,16,15.99,15.99,16,16,16,16,16,16,16,15.99,15.99,15.98,15.98,15.98,15.99,15.99,16,16.01,16.08,16.12,16.12,16.12,16.10,16.07,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,15.87,15.25,15.16,15.07,15,15,15,14.99,14.98,14.95,14.86,14.66,14.41,14.14,13.96,13.87,13.90,14.07,14.27,14.48,14.63,14.76,14.87,14.87,14.77,14.62,14.40,14.24,14.10,14.02,14.03,14.10,14.12,14.14,14.16,14.22,14.27,14.41,14.63,14.87,15.12,15.35,15.50,15.59,15.62,15.66,15.73,15.78,15.88,16.01,16.20,16.38,16.60,16.75,16.84,16.76,16.57,16.14,15.62,15,14.37,13.83,13.33,13.01,12.89,12.91,13.08,13.26,13.50,13.77,14.07,14.32,14.51,14.71,14.83,14.87,14.89,14.87,14.89,14.08,13.95,13.02,13,13,13,12,13,13,13,13,13,13,13,13,13,14,14,13,13,13,13,13,13,13,13,12,11,12,12,13,14,14,14,14,13,8.74,2.14,-1.05,-3.11,-3.88,-4.86,-5.88,-6.63,-7.12,-7.54,-7.75,-6.63,-5.18,-3.48,-1.38,1.08,2.87,5.46,4.75,4.77,4.87,6,6,6.87,6.75,6.75,6.64,6.57,6.46,6.25,6.07,5.63,5.51,5.50,5.75,6.21,6.60,6.86,6.95,7,7,7,7,7,7,7,7.12,7.88,8.33,8.82,9.28,9.77,10.21,10.51,10.75,10.89,11,11.10,11.13,11.21,11.25,11.26,11.26,11.25,11.23,11.16,11.12,11.10,11.08,11.08,11.10,11.12,11.20,11.26,11.37,11.50,11.62,11.77,11.97,12.14,12.36,12.53,12.75,12.91,13.12,13.32,13.50,13.73,13.97,14.23,14.50,14.84,15.27,15.49,15.62,15.75,15.83,15.87,15.90,15.96,16,16,16,16,16,16,16,16,15,15,15,15,15,15,16,16,16,15,15,16,16,16,16,16,17,17,17,17,17,17,17,17,17,17,17,17,17,17,16,16.07,16,16.34,16.65,16.96,16.96,16.82,16.59,16.37,16.20,16.09,16,16,16,16,16,16,16,16,16,16,16,16,15.99,15.99,15.99,15.99,15.99,15.99,16,16,16.01,16.03,16.03,16.03,16.02,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,15.87,15.62,15.27,15.12,15,15,15,14.99,14.98,14.91,14.82,14.61,14.34,14.09,13.98,14,14.12,14.28,14.41,14.57,14.66,14.76,14.84,14.85,14.76,14.63,14.49,14.34,14.23,14.20,14.21,14.24,14.25,14.25,14.24,14.25,14.32,14.46,14.66,14.95,15.23,15.46,15.62,15.71,15.75,15.77,15.84,15.88,15.99,16.12,16.28,16.50,16.73,16.87,16.96,16.87,16.61,16.15,15.61,14.99,14.37,13.82,13.35,13.07,12.97,13,13.13,13.37,13.62,13.90,14.21,14.46,14.63,14.76,14.86,14.87,14.78,14.87,14.08,14.07,13.95,13.02,13,13,12,12,13,13,13,12,13,13,13,13,13,13,13,13,13,12,13,13,13,13,12,12,11,11,12,13,14,14,14,14,13,8.75,2.20,-1.02,-3.04,-4.16,-5.13,-5.86,-6.50,-7.30,-7.78,-7,-5.88,-4.48,-2.74,-1.85,0.47,2.13,3.71,4.07,4.38,5.49,5.39,6.38,7.48,7.37,7.37,7.37,6.48,7,7,5.50,5.04,4.95,5.04,5.38,6.04,7,7,7,7,7,7,7,7,7,7,7.15,7.64,8.07,8.60,9.14,9.73,10.22,10.60,10.86,11,11.12,11.16,11.24,11.26,11.33,11.35,11.36,11.35,11.32,11.25,11.22,11.14,11.12,11.11,11.11,11.12,11.15,11.23,11.28,11.38,11.50,11.63,11.82,11.99,12.16,12.37,12.60,12.78,13,13.25,13.48,13.72,13.98,14.25,14.52,14.87,15.21,15.59,15.73,15.78,15.85,15.87,15.89,15.96,16,16,16,16,16,16,16,16,16,15,15,15,15,15,16,16,16,16,16,16,16,16,16,17,17,17,17,17,17,17,17,17,18,17,17,18,17,16,16,16,16.11,16.25,16.75,16.97,16.85,16.62,16.37,16.15,16.07,16,16,16,16,16,16,16,16,16,16,16,16.01,16,16,16,15.99,15.99,15.99,15.99,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,15.99,15.98,15.70,15.37,15.12,15,15,14.99,14.99,14.97,14.89,14.76,14.52,14.25,14.08,14.03,14.21,14.39,14.50,14.61,14.66,14.75,14.78,14.85,14.85,14.78,14.72,14.59,14.46,14.37,14.34,14.34,14.35,14.35,14.33,14.28,14.28,14.37,14.50,14.75,15.01,15.32,15.53,15.72,15.82,15.86,15.87,15.89,15.97,16.07,16.21,16.37,16.62,16.84,16.99,17.01,16.90,16.62,16.13,15.57,14.91,14.34,13.78,13.39,13.12,13.03,13.10,13.25,13.47,13.74,14.02,14.34,14.58,14.75,14.85,14.87,14.87,14.71,14.12,14.08,14,13.95,13.02,13,13,12,12,13,13,13,13,13,14,13,13,13,13,13,13,12,12,13,13,13,13,12,11,11,10,11,13,14,14,14,14,13,8.87,2.21,-0.85,-3.10,-4.25,-5.18,-5.88,-6.67,-7.25,-7.75,-6.89,-5.78,-4.38,-2.90,-2.10,0,1.50,2.77,4.45,4.75,4.87,4.75,5.72,5.82,6,5,5.01,4.11,4.33,4.97,4.02,3.82,3.92,4.12,4.48,5.16,7,7,7,7,7,7,7,7,7,7,7.46,7.63,8,8.50,9.09,9.66,10.23,10.63,10.91,11.12,11.22,11.26,11.33,11.36,11.37,11.38,11.38,11.37,11.36,11.28,11.25,11.21,11.14,11.12,11.11,11.11,11.12,11.15,11.23,11.28,11.38,11.50,11.64,11.83,12,12.22,12.41,12.63,12.87,13.12,13.38,13.64,13.91,14.23,14.50,14.83,15.13,15.51,15.73,15.82,15.85,15.85,15.85,15.87,16,16,16,16,16,16,16,16,16,16,15,15,15,15,16,16,16,16,16,16,16,16,17,17,17,17,18,17,17,17,17,17,17,17,17,17,16,16,16,16,16,16.86,16.87,16.86,16.62,16.36,16.12,16.02,16,16,16,16,16,16,16,16,16,16,16,16.02,16.07,16.02,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,15.98,15.66,15.37,15.10,15,15,14.99,14.98,14.96,14.87,14.73,14.49,14.25,14.11,14.16,14.38,14.63,14.73,14.75,14.78,14.83,14.85,14.87,14.87,14.85,14.76,14.65,14.58,14.49,14.45,14.41,14.40,14.39,14.37,14.36,14.37,14.46,14.61,14.84,15.12,15.37,15.62,15.76,15.87,15.90,15.95,15.98,16.01,16.12,16.25,16.48,16.71,16.91,17.09,17.10,16.95,16.60,16.10,15.50,14.87,14.27,13.78,13.46,13.22,13.14,13.23,13.37,13.58,13.85,14.12,14.41,14.64,14.82,14.87,14.87,14.76,14.64,14.12,14,14,13.95,13.01,13,14,13,12,12,13,13,13,13,14,13,13,13,13,13,12,12,12,13,14,14,13,12,11,10,11,13,13,14,14,14,14,14,10,2.32,-0.50,-2.90,-4.12,-5.01,-5.93,-6.77,-7.38,-7.68,-7.77,-6.63,-5.50,-3.12,-2.38,-2.26,0.13,1.02,1.89,2.95,3.10,3.20,2.13,1.25,1.40,0.71,-0.50,-0.64,-0.67,0.73,1.37,2.02,2.65,3.20,3,3.61,4.76,7,7,7,7,7,7,7,7.23,7.37,7.62,7.75,8.02,8.49,9.02,9.63,10.22,10.65,10.99,11.20,11.28,11.36,11.37,11.39,11.40,11.40,11.40,11.38,11.36,11.32,11.25,11.20,11.13,11.11,11.09,11.08,11.09,11.11,11.12,11.21,11.27,11.38,11.51,11.66,11.86,12.03,12.25,12.50,12.75,13,13.25,13.57,13.86,14.13,14.46,14.75,15.07,15.37,15.53,15.66,15.75,15.75,15.73,15.70,15.98,15,15,15,15,15,16,16,16,15,15,15,15,15,16,16,16,16,16,16,16,16,17,17,17,18,17,17,17,17,17,17,17,17,17,17,16,16,16,16,16,16.97,16.85,16.73,16.35,16.12,16.01,16,16,16,16,16,16,16,16,16,16,16,16.01,16.08,16.12,16.11,16.03,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,15.98,15.97,15.62,15.33,15.08,15,15,14.99,14.98,14.91,14.84,14.64,14.45,14.25,14.20,14.32,14.57,14.75,14.85,14.87,14.87,14.87,14.88,14.88,14.89,14.87,14.84,14.75,14.65,14.59,14.51,14.50,14.48,14.46,14.41,14.41,14.47,14.53,14.72,14.95,15.20,15.46,15.65,15.83,15.90,15.97,16,16,16.08,16.15,16.34,16.53,16.77,17,17.14,17.12,16.95,16.57,16.01,15.39,14.77,14.25,13.78,13.50,13.36,13.32,13.37,13.50,13.72,13.97,14.25,14.50,14.73,14.85,14.87,14.86,14.65,14.28,14.12,14,13.95,13.96,13.01,13,13,12,12,12,13,13,13,13,14,14,13,13,13,12,12,12,13,13,14,14,13,11,10,10,12,13,14,14,14,14,14,14,10,2.57,-1.38,-2.50,-3.73,-4.64,-5.75,-6.61,-7.18,-7.50,-7.62,-6.62,-6.50,-5.12,-4.36,-3.18,-3.35,-2.43,-1.76,-1.67,-1.55,-1.28,-1.28,-2.24,-2.02,-2.10,-2.14,-2.26,-2.30,-2.25,-0.78,-0.25,-0.62,-0.13,0.50,1.25,2.89,2.87,5.64,7,7,7,7.88,7.23,7.63,7.82,7.75,7.84,8.09,8.49,9,9.61,10.16,10.64,11,11.23,11.35,11.39,11.41,11.41,11.41,11.40,11.38,11.37,11.33,11.25,11.21,11.13,11.10,11.03,11,11,11,11.01,11.07,11.12,11.20,11.27,11.39,11.53,11.72,11.88,12.12,12.35,12.60,12.87,13.12,13.41,13.73,14.02,14.35,14.63,14.96,15.25,15.40,15.50,15.58,15.62,15.53,15.47,15.02,15,15,15,15,16,16,16,15,15,15,15,15,16,16,16,16,16,16,16,16,16,17,17,17,18,18,18,18,17,17,17,17,17,17,17,16,16,16,16,17,16,16.01,16.13,16.12,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16.08,16.14,16.15,16.12,16.03,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,15.99,15.98,15.85,15.50,15.24,15.07,15,15,14.99,14.97,14.87,14.75,14.59,14.37,14.25,14.26,14.41,14.64,14.82,14.89,14.95,14.95,14.95,14.91,14.91,14.91,14.90,14.87,14.83,14.75,14.65,14.60,14.53,14.51,14.50,14.50,14.50,14.58,14.66,14.85,15.03,15.27,15.50,15.73,15.87,15.97,16,16.02,16.08,16.12,16.23,16.38,16.62,16.87,17.11,17.23,17.15,16.91,16.50,15.96,15.34,14.73,14.21,13.82,13.57,13.48,13.47,13.57,13.71,13.87,14.11,14.36,14.59,14.75,14.87,14.87,14.75,14.52,14.24,14,13.91,13.95,13.02,13,12.99,13,12,12,12,12,13,13,13,14,14,14,13,13,12,12,13,13,13,13,14,13,12,10,11,13,13,14,14,14,14,14,14,11,3.87,-1.13,-2.25,-3.13,-4.14,-5.28,-6.14,-6.75,-7.05,-7.13,-7.28,-7.17,-6.75,-6,-5.25,-4.63,-3.75,-3.37,-3.15,-3.05,-2.75,-2.63,-2.54,-2.74,-2.77,-2.63,-2.76,-2.79,-2.89,-2.88,-2.68,-2.14,-1.55,-1.38,-0.87,-0.15,0.50,2.97,7,7,7.16,7.40,7.75,8,7.77,7.72,7.84,8.08,8.47,8.98,9.53,10.12,10.62,10.99,11.23,11.36,11.40,11.45,11.41,11.39,11.37,11.35,11.28,11.25,11.20,11.12,11.07,11,10.98,10.95,10.91,10.95,10.96,10.99,11.02,11.11,11.20,11.28,11.41,11.59,11.75,11.98,12.21,12.46,12.72,13,13.27,13.60,13.88,14.21,14.50,14.82,15.12,15.25,15.36,15.38,15.37,15.36,15.25,15.08,15,15,15,15,15,16,15,15,15,15,15,16,16,16,16,16,16,16,16,16,17,17,17,18,18,18,18,18,18,17,17,17,17,17,17,16,16,16,17,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16.02,16.22,16.32,16.26,16.12,16.01,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,15.99,15.98,15.85,15.62,15.35,15.12,15.01,15,15,14.99,14.95,14.86,14.70,14.50,14.34,14.27,14.37,14.52,14.74,14.86,14.91,14.97,14.98,14.97,14.96,14.96,14.96,14.95,14.90,14.87,14.83,14.75,14.66,14.62,14.61,14.59,14.60,14.62,14.70,14.82,14.98,15.15,15.37,15.60,15.76,15.90,16,16.08,16.11,16.12,16.20,16.28,16.48,16.72,16.99,17.21,17.27,17.21,16.91,16.47,15.87,15.25,14.64,14.15,13.83,13.62,13.58,13.62,13.75,13.90,14.09,14.26,14.49,14.66,14.84,14.88,14.86,14.65,14.38,14.12,13.87,13.91,13.03,13.01,13,13,12,12,12,12,13,13,13,13,13,14,13,12,12,13,13,13,13,13,13,13,13,12,11,11,13,13,14,14,14,14,14,14,11,5,0.34,-1.80,-2.74,-3.63,-4.55,-5.39,-6,-6.36,-6.50,-6.65,-6.52,-6.25,-5.75,-5.30,-4.66,-3.91,-3.68,-3.50,-3.38,-3.11,-2.88,-3,-3.25,-3.28,-3.14,-3.13,-3.48,-3.61,-3.54,-3.61,-3.40,-3,-2.73,-2.40,-1.92,-1.05,0.65,3.16,5.35,6.20,7,7,8,7.40,7.50,7.63,7.96,8.37,8.87,9.47,10.02,10.52,10.91,11.20,11.34,11.38,11.39,11.37,11.36,11.32,11.25,11.21,11.13,11.09,11,10.97,10.89,10.87,10.87,10.86,10.87,10.87,10.90,10.98,11.01,11.12,11.21,11.33,11.48,11.62,11.85,12.07,12.32,12.58,12.87,13.14,13.46,13.75,14.07,14.36,14.63,14.96,15.12,15.20,15.23,15.22,15.15,15.11,15.03,15,14.97,15,15,15,15,15,15,15,15,15,16,16,16,16,16,16,17,17,17,17,17,18,18,18,18,18,18,18,17,17,17,17,17,17,16,16,17,17,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16.02,16.26,16.50,16.50,16.21,16.02,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,15.99,15.86,15.62,15.37,15.14,15.03,15,15,15,14.99,14.95,14.84,14.63,14.45,14.28,14.32,14.46,14.62,14.78,14.87,14.95,14.98,14.98,14.98,14.97,14.97,14.97,14.97,14.96,14.91,14.87,14.85,14.77,14.75,14.72,14.71,14.72,14.75,14.85,14.97,15.12,15.28,15.50,15.71,15.87,16,16.11,16.14,16.20,16.23,16.25,16.37,16.57,16.83,17.09,17.27,17.37,17.25,16.90,16.40,15.82,15.15,14.60,14.12,13.83,13.65,13.64,13.75,13.95,14.12,14.32,14.49,14.63,14.78,14.90,14.96,14.87,14.61,14.26,13.87,13.87,13.03,13.02,13,13,13,12,12,12,13,13,13,13,13,13,13,12,12,13,13,13,13,13,13,13,14,13,13,12,11,12,13,14,14,14,14,14,14,12,7,1.58,-0.25,-2.13,-3.11,-4.01,-4.75,-5.25,-5.54,-5.85,-6.04,-6.03,-5.85,-5.63,-5.16,-4.51,-4.04,-3.86,-3.65,-3.54,-3.26,-3,-3.38,-3.63,-3.65,-3.50,-3.73,-4,-4.13,-4.39,-4.43,-4.25,-3.88,-3.50,-3.23,-2.75,-2.13,-1.29,0.12,1.70,3,4,5,6,6.98,6.87,7.24,7.65,8.15,8.74,9.35,9.95,10.47,10.87,11.12,11.26,11.34,11.34,11.32,11.25,11.21,11.13,11.08,11,10.95,10.87,10.85,10.82,10.77,10.76,10.76,10.78,10.83,10.87,10.89,10.98,11.03,11.12,11.25,11.37,11.52,11.73,11.95,12.16,12.45,12.73,13,13.32,13.61,13.88,14.20,14.49,14.75,14.88,15,15.03,15.02,15,14.96,14.88,14.87,14.96,14,14,15,15,15,15,15,15,16,16,16,16,16,16,17,17,17,17,17,17,18,18,18,18,18,18,17,17,17,17,17,17,17,16,16,17,17,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16.01,16.21,16.38,16.38,16.16,16.01,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,15.86,15.62,15.37,15.14,15.03,15,15,15,15,14.99,14.95,14.83,14.62,14.39,14.27,14.35,14.51,14.73,14.87,14.89,14.96,14.98,14.98,14.98,14.98,14.98,14.98,14.98,14.98,14.98,14.96,14.91,14.88,14.87,14.85,14.85,14.87,14.90,15,15.12,15.25,15.46,15.62,15.83,15.99,16.12,16.22,16.25,16.28,16.32,16.37,16.47,16.64,16.90,17.16,17.37,17.41,17.26,16.90,16.37,15.75,15.11,14.51,14.09,13.78,13.70,13.73,13.87,14.11,14.35,14.52,14.70,14.83,14.91,15.02,15.03,14.89,14.52,14.09,13.87,13.10,13.02,13,13,13,13,12,12,12,13,14,14,14,14,13,11,11,11,12,12,13,13,13,13,14,14,14,13,12,11,10,12,13,14,14,14,14,14,12,8,3.87,0.11,-0.55,-2.29,-3.25,-4,-4.51,-4.78,-5.11,-5.37,-5.53,-5.53,-5.28,-4.86,-4.25,-4,-3.75,-3.68,-3.61,-3.27,-3.18,-3.62,-3.80,-3.86,-3.88,-4.10,-4.38,-4.78,-5.02,-5.10,-4.89,-4.50,-4.11,-3.92,-3.60,-3,-2.14,-1.50,0.21,0.65,1,2,3,4.83,5.89,6.58,7.22,7.86,8.50,9.16,9.83,10.37,10.76,11.03,11.20,11.25,11.23,11.16,11.12,11.07,10.99,10.90,10.86,10.77,10.75,10.72,10.70,10.70,10.70,10.72,10.74,10.76,10.83,10.87,10.91,11,11.10,11.20,11.33,11.47,11.62,11.85,12.08,12.33,12.60,12.87,13.15,13.46,13.75,14.01,14.32,14.52,14.71,14.77,14.85,14.87,14.85,14.78,14.74,14.63,14.08,14.01,14,15,15,15,15,15,16,16,16,16,16,16,17,17,17,17,17,17,17,17,18,18,18,18,18,17,17,17,17,17,17,17,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16.11,16.20,16.20,16.11,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,15.87,15.64,15.36,15.13,15.03,15,15,15,15,15,14.99,14.96,14.84,14.62,14.39,14.27,14.37,14.57,14.75,14.89,14.91,14.97,14.98,14.98,14.98,14.98,14.98,14.98,14.99,14.99,15,15,15,15,15,15,15,15.01,15.09,15.15,15.27,15.45,15.62,15.78,15.97,16.12,16.25,16.34,16.37,16.39,16.39,16.46,16.53,16.75,17,17.26,17.47,17.50,17.33,16.90,16.35,15.70,15.01,14.46,14.01,13.75,13.70,13.75,13.91,14.23,14.50,14.75,14.89,14.99,15.03,15.10,15.25,14.82,14.37,13.87,13.12,13.08,13,13,13,13,12,12,12,13,14,14,15,14,14,13,11,10,11,11,12,13,13,13,13,14,14,14,13,13,11,9,11,13,14,14,14,14,13,12,11,7,3.59,-0.13,-1.77,-2.63,-3.29,-3.78,-4.13,-4.50,-4.88,-5.04,-5.01,-4.75,-4.28,-4,-3.75,-3.53,-3.60,-3.49,-3.15,-3.25,-3.64,-3.88,-3.88,-4.11,-4.28,-4.76,-5.25,-5.49,-5.50,-5.30,-5.12,-4.91,-4.78,-4.48,-3.89,-3.04,-2.35,-1.64,-0.79,0.75,1,1,3.57,4.84,5.76,6.61,7.38,8.20,8.97,9.65,10.25,10.70,10.96,11.09,11.11,11.08,11,10.96,10.87,10.82,10.74,10.65,10.62,10.61,10.59,10.59,10.60,10.62,10.63,10.70,10.74,10.77,10.85,10.89,10.99,11.08,11.15,11.26,11.40,11.59,11.75,11.99,12.23,12.49,12.75,13.02,13.32,13.60,13.87,14.12,14.35,14.50,14.61,14.65,14.70,14.70,14.64,14.61,14.48,14.24,14.02,14.98,15,15,15,15,16,16,16,16,16,16,17,17,17,17,17,17,18,18,17,17,18,18,18,17,17,17,17,17,17,17,17,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,17,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,15.78,15.35,15.12,15.02,15,15,15,15,15,15,14.99,14.97,14.86,14.62,14.38,14.25,14.34,14.53,14.75,14.89,14.95,14.97,14.98,14.99,14.99,14.99,14.99,14.99,14.99,15,15,15.02,15.08,15.10,15.12,15.12,15.14,15.21,15.25,15.35,15.47,15.62,15.76,15.96,16.12,16.25,16.37,16.46,16.50,16.50,16.50,16.52,16.62,16.83,17.09,17.35,17.51,17.52,17.34,16.88,16.28,15.62,14.96,14.37,13.97,13.73,13.65,13.75,13.98,14.34,14.66,14.97,15.12,15.13,15.12,15.09,14.90,14.62,14.23,13.87,13.10,13,13,13,13,13,12,12,13,13,14,15,15,15,14,13,12,10,10,11,12,13,13,13,13,13,14,14,13,13,11,9,10,12,13,13,13,13,13,13,12,10,4.76,2.39,-0.13,-1.93,-2.63,-3.13,-3.50,-3.75,-4.13,-4.35,-4.27,-4.12,-3.93,-3.63,-3.26,-3.25,-3.35,-3.18,-2.89,-3.15,-3.53,-3.75,-3.88,-4.10,-4.38,-5.03,-5.49,-5.67,-5.74,-5.85,-5.67,-5.61,-5.43,-5.10,-4.51,-3.74,-3,-2.35,-1.49,0.25,0.97,2,2.89,4.02,5,5.90,6.84,7.75,8.63,9.47,10.12,10.57,10.83,10.90,10.90,10.87,10.82,10.74,10.65,10.60,10.52,10.50,10.48,10.47,10.47,10.49,10.50,10.57,10.61,10.64,10.72,10.76,10.84,10.89,10.99,11.07,11.14,11.25,11.38,11.53,11.73,11.91,12.13,12.38,12.63,12.90,13.20,13.46,13.72,13.96,14.14,14.33,14.41,14.50,14.52,14.57,14.53,14.51,14.50,14.50,14.87,14.98,15,15,15,15,16,16,16,16,17,17,17,17,17,17,17,18,18,18,18,17,17,17,17,17,17,17,17,17,17,17,17,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,15.23,15.12,15.01,15,15,15,15,15,15,15,14.99,14.98,14.87,14.64,14.37,14.22,14.25,14.49,14.74,14.88,14.95,14.97,14.99,14.99,14.99,14.99,14.99,14.99,14.99,15,15,15.03,15.11,15.14,15.22,15.25,15.32,15.37,15.41,15.50,15.62,15.76,15.95,16.11,16.25,16.38,16.50,16.57,16.60,16.60,16.59,16.62,16.72,16.87,17.12,17.37,17.53,17.52,17.28,16.85,16.23,15.52,14.87,14.32,13.88,13.66,13.62,13.75,14,14.39,14.83,15.14,15.33,15.34,15.23,15.02,14.75,14.34,14.11,13.87,13.08,13,13,13,13,13,12,12,13,14,14,15,15,15,15,12,11,10,10,10,12,13,13,13,13,13,13,14,13,12,11,10,9,12,13,13,13,13,13,12,12,10,7,3.64,0.36,-0.12,-1.77,-2.29,-2.64,-2.86,-3.23,-3.39,-3.55,-3.61,-3.41,-3.13,-2.66,-2.87,-2.89,-2.76,-2.67,-2.88,-3.28,-3.50,-3.67,-3.89,-4.42,-5.11,-5.51,-5.75,-6.05,-6.15,-6,-6.01,-5.88,-5.51,-4.99,-4.15,-3.48,-2.80,-2,-0.23,1.50,1.97,2.89,3.61,4.35,5.26,6.22,7.22,8.22,9.12,9.87,10.36,10.61,10.70,10.66,10.62,10.52,10.48,10.40,10.36,10.33,10.32,10.32,10.34,10.36,10.38,10.46,10.50,10.58,10.63,10.72,10.76,10.85,10.90,11,11.09,11.16,11.27,11.39,11.53,11.72,11.88,12.11,12.34,12.58,12.83,13.09,13.34,13.58,13.78,14,14.13,14.25,14.36,14.40,14.47,14.50,14.50,14.59,14.71,14.86,14.98,15,15,15,16,16,16,16,17,17,17,17,17,18,18,18,18,18,18,18,18,17,17,17,17,17,17,17,17,17,17,17,16,16,16,16,16,16,16,16,16,17,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,15,15.12,15,15,15,15,15,15,15,15,15,14.99,14.98,14.87,14.62,14.33,14.12,14.15,14.38,14.70,14.87,14.95,14.98,14.99,14.99,15,14.99,14.99,14.99,14.99,15,15,15.07,15.12,15.21,15.28,15.37,15.47,15.51,15.61,15.70,15.78,15.91,16.09,16.24,16.37,16.50,16.60,16.63,16.65,16.65,16.64,16.66,16.75,16.95,17.14,17.37,17.50,17.48,17.22,16.75,16.12,15.41,14.76,14.23,13.85,13.62,13.62,13.75,14.01,14.48,14.95,15.34,15.57,15.50,15.35,15.08,14.66,14.23,14,13.89,13.03,13,13,13,13,13,13,13,13,14,14,14,15,15,14,12,10,10,10,11,13,13,13,13,13,13,13,13,14,12,11,8,9,12,13,13,13,12,11,11,10,10,9,6,2.64,1.38,-0.13,-1.55,-1.88,-2.13,-2.40,-2.75,-2.88,-2.89,-2.75,-2.39,-2.27,-2.25,-2.30,-2.25,-2.36,-2.50,-2.88,-3.10,-3.29,-3.67,-4.29,-4.98,-5.38,-5.78,-6.14,-6.25,-6.25,-6.25,-6.12,-5.75,-5.16,-4.38,-3.76,-3.14,-2.35,-0.52,1.13,2.75,3.53,3.57,4.02,4.65,5.61,6.61,7.63,8.63,9.50,10,10.25,10.36,10.34,10.26,10.23,10.15,10.12,10.12,10.11,10.12,10.14,10.21,10.25,10.33,10.38,10.48,10.57,10.63,10.73,10.78,10.87,10.96,11.02,11.12,11.22,11.33,11.41,11.58,11.73,11.88,12.09,12.27,12.50,12.75,13,13.24,13.46,13.65,13.86,14,14.12,14.25,14.34,14.39,14.49,14.58,14.64,14.78,14.98,15.12,15,15,16,16,16,16,17,17,17,17,17,18,18,18,18,18,18,18,18,18,17,17,17,17,17,17,17,17,17,17,17,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,15,15,16,15,15,15,15,15,15,15,15,15,15,15,15,14.98,14.91,14.75,14.50,14.25,14.09,14.12,14.35,14.65,14.87,14.96,15,15,15,15,15,15,15,15,15,15,15.03,15.12,15.24,15.37,15.49,15.60,15.66,15.75,15.84,15.95,16.07,16.21,16.35,16.49,16.60,16.65,16.73,16.74,16.74,16.74,16.75,16.84,16.99,17.15,17.36,17.45,17.36,17.08,16.60,15.98,15.28,14.65,14.13,13.76,13.60,13.61,13.75,14.03,14.51,15.01,15.47,15.74,15.73,15.49,15.15,14.74,14.11,14,13.95,13,13,13,13,13,13,13,13,14,14,14,14,14,15,13,11,10,10,10,12,13,13,13,13,13,13,13,14,13,12,10,8,9,11,12,12,12,11,10,10,10,9,9,8,6,2.76,1.59,0.10,-1.25,-1.50,-1.62,-1.88,-2.04,-2.03,-1.90,-1.89,-1.78,-1.60,-1.53,-1.76,-1.88,-1.88,-2.27,-2.50,-2.74,-2.30,-2.93,-3.63,-5.03,-5.63,-6,-6.10,-6.26,-6.28,-6.13,-5.75,-5.28,-4.62,-4.15,-3.51,-2.63,-1.76,0.90,4.51,5.20,4.61,4.09,4.50,5.11,6,7,8,8.86,9.45,9.74,9.86,9.87,9.86,9.84,9.83,9.83,9.85,9.88,9.95,10,10.10,10.16,10.25,10.37,10.47,10.57,10.64,10.75,10.84,10.90,11,11.10,11.16,11.25,11.37,11.49,11.61,11.75,11.89,12.10,12.27,12.50,12.72,12.95,13.14,13.37,13.58,13.75,13.89,14.03,14.16,14.27,14.38,14.50,14.62,14.75,14.91,15.12,15.35,15.96,16,16,16,16,17,17,17,17,17,17,18,18,18,18,18,18,18,18,18,17,17,17,17,17,17,17,17,17,17,17,16,16,15,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14.96,14.84,14.62,14.36,14.12,14.02,14.12,14.36,14.66,14.88,15,15.08,15.09,15.07,15.01,15,15,15,15,15,15,15.03,15.12,15.25,15.39,15.58,15.71,15.78,15.87,15.97,16.07,16.16,16.32,16.45,16.57,16.64,16.73,16.75,16.77,16.77,16.77,16.83,16.88,17.01,17.16,17.28,17.35,17.22,16.89,16.40,15.83,15.15,14.58,14.08,13.73,13.57,13.59,13.75,14.07,14.53,15.09,15.57,15.84,15.86,15.60,15.25,14.87,14.08,14,13.98,13,13,13,13,13,13,14,14,14,14,14,14,14,14,12,11,10,9,10,12,13,13,13,13,13,13,14,14,13,13,11,9,9,9,10,10,11,10,9,9,9,9,9,9,8,5,3,1.87,0.57,0.33,0.21,-0.79,-1,-1.24,-1.29,-1.28,-1.15,-1,-0.92,-1.15,-1.30,-1.38,-1.50,-1.68,-1.13,-1.75,-2.39,-3.04,-3.63,-5.17,-5.50,-5.89,-6.13,-6.13,-6.14,-5.99,-5.50,-5.03,-4.62,-3.98,-3.04,-2.25,0.62,5.37,6.22,5.72,5.26,4.95,5.10,5.62,6.48,7.33,8.09,8.64,9,9.21,9.26,9.33,9.37,9.40,9.50,9.59,9.66,9.77,9.87,10,10.12,10.24,10.35,10.47,10.58,10.66,10.76,10.87,10.97,11.07,11.13,11.25,11.35,11.45,11.53,11.65,11.78,11.96,12.12,12.28,12.50,12.71,12.89,13.12,13.33,13.50,13.70,13.86,14,14.14,14.28,14.45,14.59,14.74,14.88,15.08,15.26,15.53,15.77,16,16,16,17,17,17,17,17,17,18,18,18,18,18,18,18,18,18,17,17,17,17,17,17,17,17,17,17,17,17,16,15,15,16,17,17,17,17,17,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,17,16,16,17,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14.89,14.74,14.46,14.22,14.07,14.07,14.22,14.46,14.75,14.98,15.12,15.21,15.22,15.15,15.11,15.02,15,15,15,15,15,15.07,15.13,15.27,15.47,15.62,15.77,15.88,15.99,16.08,16.15,16.26,16.38,16.50,16.62,16.72,16.75,16.82,16.83,16.84,16.85,16.87,16.97,17.08,17.20,17.25,17.25,17.09,16.75,16.25,15.65,15.03,14.48,14,13.70,13.52,13.58,13.75,14.08,14.57,15.11,15.60,15.87,15.89,15.73,15.12,14.91,14.03,14,14,14,13,13,14,14,14,14,14,14,14,15,15,14,13,12,11,9,10,10,11,13,13,14,14,14,14,14,14,13,13,13,12,12,10,9,8,9,9,9,9,9,9,9,9,9,7,5,4,3,1.98,1.85,0.75,0.71,0.52,-0.53,-0.54,-0.63,-0.63,-0.62,-0.51,-0.63,-0.64,-0.62,-0.02,-0.42,-0.02,-0.62,-1.25,-2.88,-3.53,-4.14,-4.54,-5.77,-6.10,-6.15,-5.93,-5.53,-5.27,-4.87,-4.14,-3.29,-2.63,0.25,4,7.27,6.86,6.26,5.95,5.75,5.82,6.23,6.78,7.37,7.84,8.16,8.40,8.59,8.72,8.86,9,9.14,9.33,9.49,9.62,9.77,9.91,10.08,10.22,10.35,10.48,10.60,10.72,10.83,10.90,11,11.12,11.22,11.33,11.40,11.50,11.62,11.74,11.87,12,12.14,12.33,12.50,12.72,12.90,13.12,13.33,13.50,13.70,13.87,14.02,14.21,14.37,14.51,14.70,14.86,15.01,15.23,15.41,15.64,15.86,16,16,17,17,17,17,17,18,18,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,18,18,18,17,18,17,15,15,16,17,17,17,17,17,17,17,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,17,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14.87,14.66,14.36,14.12,14.07,14.15,14.37,14.62,14.88,15.12,15.32,15.38,15.38,15.34,15.23,15.12,15.03,15,15,15,15.02,15.09,15.16,15.34,15.50,15.71,15.87,15.99,16.08,16.15,16.25,16.37,16.49,16.60,16.66,16.75,16.78,16.84,16.86,16.87,16.88,16.96,17.01,17.12,17.23,17.25,17.20,16.98,16.62,16.12,15.53,14.97,14.40,13.98,13.66,13.53,13.59,13.76,14.09,14.57,15.11,15.62,15.89,15.95,15.87,15.07,14.96,14,14,14,14,14,14,14,15,16,15,14,14,14,15,14.82,14.63,12.61,11.63,10.82,10,11,12,13,13,13,14,14,14,14,14,14,14,13,13,14,13,12,9,7,8,8,8,8,9,9,9,10,9,9,8,6,5,4,3,1.99,1.98,0.98,0.98,0.87,0.82,0.75,0.77,0.87,1,0.99,0.85,0.75,0.36,0.88,1.45,0.75,-1.11,-2.92,-3.61,-4,-4.52,-5.87,-5.89,-5.65,-5.60,-5.36,-4.88,-4.18,-3.50,-2.79,0.07,3.63,6.16,7.22,7.25,7.08,6.85,6.61,6.48,6.58,6.83,7.09,7.35,7.59,7.83,8.08,8.34,8.59,8.84,9.08,9.27,9.50,9.71,9.87,10.03,10.22,10.37,10.50,10.62,10.75,10.87,10.98,11.09,11.20,11.27,11.37,11.50,11.60,11.71,11.82,11.91,12.08,12.22,12.37,12.53,12.74,12.95,13.13,13.37,13.57,13.75,13.95,14.12,14.32,14.49,14.64,14.84,15,15.20,15.37,15.59,15.77,16,16.02,17,17,17,17,17,17,18,18,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,18,18,18,17,17,17,15,15,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,17,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14.87,14.64,14.34,14.12,14.15,14.37,14.62,14.87,15.11,15.36,15.52,15.62,15.62,15.50,15.37,15.23,15.11,15.02,15.01,15.02,15.08,15.12,15.24,15.37,15.59,15.76,15.91,16.03,16.14,16.25,16.37,16.48,16.58,16.64,16.73,16.77,16.83,16.86,16.87,16.88,16.91,17,17.09,17.20,17.25,17.26,17.16,16.91,16.53,16.03,15.49,14.90,14.38,13.99,13.72,13.59,13.62,13.78,14.10,14.57,15.12,15.62,15.91,15.97,15.95,15.02,14.98,14,14,14,14,14,14,14,15,16,16,14,14,13.75,14.39,14.16,13.02,11.99,12.02,10.16,10.39,12.75,13,13,13,14,14,14,14,14,14,14,14,14,14,14,13,12,9,7,8,8,7.87,7.75,7.75,8.75,8.87,10,9,9,9,8,7,6,5,4,3,2,2,2,2,2,2,2,2,2,2,0.99,1.99,1.75,2.23,1.59,-0.26,-2.13,-2.80,-3.48,-4.03,-5.29,-5.38,-5.50,-5.61,-5.40,-4.93,-4.25,-3.63,-2.85,0.85,4.45,7.13,7.64,8.16,8.25,8,7.60,7.20,6.77,6.53,6.50,6.62,6.82,7.11,7.48,7.84,8.16,8.50,8.84,9.12,9.37,9.62,9.85,10.02,10.23,10.37,10.52,10.66,10.82,10.91,11.03,11.14,11.25,11.37,11.47,11.58,11.65,11.76,11.87,12,12.12,12.25,12.40,12.60,12.76,13,13.22,13.41,13.64,13.87,14.08,14.26,14.47,14.63,14.84,15,15.20,15.37,15.53,15.75,15.95,16.15,16.70,17,17,17,17,17,17,18,18,17,17,17,17,17,17,17,17,17,17,17,17,17,17,18,17,17,17,17,17,17,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14.87,14.70,14.40,14.23,14.37,14.62,14.87,15.11,15.36,15.61,15.73,15.82,15.77,15.66,15.51,15.35,15.20,15.09,15.02,15.03,15.10,15.16,15.28,15.47,15.64,15.85,15.99,16.12,16.24,16.35,16.47,16.57,16.63,16.73,16.75,16.82,16.84,16.86,16.87,16.88,16.96,17.01,17.12,17.25,17.33,17.33,17.21,16.95,16.51,16,15.46,14.88,14.39,14.01,13.76,13.65,13.70,13.86,14.11,14.53,15.12,15.78,15.98,16,15.97,15,15,14,14,14,14,14,14,14,15,16,15,15,13.63,14.22,13.89,13.70,12.58,11.51,10.58,10,10,12.22,12.63,13,13,14,14,14,14,14,14,14,14,13,14,14,13,11,10,8,5.75,6.58,8.39,7.35,7.27,8.35,8.37,8.51,8.73,8.97,8.98,9,8,8,8,7,5,4,3,3,3,3,3,3,3,2,2,2,2,2,2,1.52,0.82,-0.12,-1.77,-2.63,-3.25,-4.75,-5.29,-5.63,-5.66,-5.50,-5,-4.63,-4,-2.16,0.50,5.34,7.02,8.49,9.02,9.25,9.12,8.64,8,7.36,6.64,6.22,6.07,6.22,6.60,6.98,7.39,7.84,8.24,8.61,8.96,9.25,9.57,9.82,10.02,10.25,10.41,10.60,10.75,10.87,11,11.12,11.23,11.34,11.45,11.52,11.63,11.75,11.86,11.96,12.08,12.20,12.33,12.48,12.62,12.84,13.03,13.27,13.52,13.77,14.02,14.25,14.48,14.65,14.86,15.02,15.22,15.37,15.57,15.74,15.89,16.11,16.34,16.53,17,17,17,17,17,18,18,18,18,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,17,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14.90,14.75,14.59,14.51,14.62,14.87,15.11,15.36,15.61,15.78,15.87,15.89,15.88,15.82,15.64,15.47,15.25,15.12,15.03,15.03,15.12,15.22,15.37,15.53,15.74,15.88,16.02,16.15,16.28,16.40,16.52,16.62,16.72,16.75,16.78,16.83,16.84,16.85,16.86,16.87,16.95,17.02,17.15,17.27,17.37,17.37,17.25,16.98,16.52,16,15.46,14.89,14.45,14.10,13.87,13.75,13.77,13.88,14.09,14.49,15.12,15.96,16,16,16,15,15,14,14,14,14,14,14,14,15,16,16,14.75,14.22,12.83,12.51,12.33,11.20,10.14,10,10,10,10.83,12.20,12.75,13.87,13.84,13.95,13.96,13.96,13.89,13.98,14,13,11,12.02,10.91,9.83,8.75,8.76,7.51,5.37,5.20,6.07,6.98,6.89,6.87,7.96,8.02,8.25,8.50,8.87,8.88,8.97,8,8,7.87,6.62,4.51,4.50,4.63,4.87,4,4,4,4,3,3,2,2,2,2,2,1.77,0.88,0.01,-1.91,-2.68,-3.55,-5.16,-5.48,-5.50,-5.29,-5.13,-4.73,-4.11,-3.60,1.10,5.99,9.01,9.37,9.78,10.07,10.02,9.64,8.95,8.08,7.15,6.36,5.89,5.91,6.25,6.62,7.09,7.53,8,8.39,8.78,9.14,9.49,9.76,10.02,10.25,10.47,10.62,10.78,10.95,11.07,11.16,11.28,11.38,11.50,11.61,11.72,11.82,11.89,12,12.12,12.24,12.37,12.50,12.66,12.87,13.12,13.37,13.65,13.97,14.24,14.50,14.72,14.90,15.11,15.26,15.45,15.61,15.75,15.91,16.09,16.25,16.41,16.65,17,17,17,17,18,18,18,18,18,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14.96,14.87,14.77,14.76,14.87,15.08,15.34,15.60,15.78,15.91,15.98,15.97,15.95,15.87,15.74,15.52,15.33,15.13,15.03,15.03,15.12,15.24,15.40,15.62,15.78,15.96,16.09,16.22,16.35,16.49,16.62,16.71,16.75,16.82,16.83,16.83,16.83,16.82,16.82,16.85,16.89,17,17.14,17.32,17.40,17.45,17.32,17,16.57,16,15.46,14.90,14.49,14.14,13.96,13.87,13.87,13.95,14.07,14.15,15,16,16,16,16,15,15,14,14,14,14,14,14,14,15,14.96,15.91,14.34,12.98,12.58,12.23,11.02,10,10,10,10,10,10.58,11.76,12.53,13.12,13.75,13.82,13.77,13.75,13.82,12.87,10.98,9.09,7.89,5.75,5.62,4.51,4.49,4.11,3.82,2.65,1.70,2.75,2.62,4.52,5.50,6.59,6.65,7.87,8.12,8.46,8.84,8.87,7.71,7.35,7,5.75,4.64,4.64,4.75,5,4.36,4.63,4.75,4.75,3.75,2.87,3,3,3,3,3,3,1.77,0.87,-0.13,-2.25,-3.12,-3.67,-5,-5.18,-5.15,-5,-4.61,-4.27,-2.76,2.87,7.75,8.62,10.36,10.35,10.63,10.72,10.47,9.83,8.88,7.91,6.97,6.32,6.12,6.16,6.48,6.88,7.36,7.78,8.24,8.63,9.02,9.39,9.74,10,10.25,10.49,10.66,10.85,10.99,11.12,11.24,11.36,11.46,11.57,11.64,11.75,11.86,11.96,12.03,12.13,12.25,12.37,12.52,12.72,12.91,13.16,13.48,13.78,14.12,14.46,14.74,14.98,15.16,15.37,15.51,15.70,15.85,16,16.12,16.26,16.41,16.59,16.75,17,17,18,18,18,18,18,18,18,18,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14.98,14.96,14.91,14.91,15.01,15.23,15.50,15.75,15.91,15.98,16,15.99,15.97,15.89,15.76,15.58,15.35,15.14,15.03,15.02,15.11,15.25,15.46,15.64,15.85,15.99,16.12,16.25,16.37,16.51,16.63,16.75,16.78,16.83,16.83,16.82,16.77,16.75,16.75,16.76,16.85,16.97,17.12,17.27,17.40,17.46,17.33,17,16.53,16,15.41,14.90,14.50,14.21,14,13.95,13.95,13.99,14.12,14,15,16,16,16,16,15,15,14,14,14,14,14,14,13.96,13.89,13.89,13.89,13.37,12.87,11.48,11.13,10.02,10,10,10,10,10,10.46,11.50,12.25,12.77,13.21,13.66,13.66,12.71,10.75,8.85,6.25,2.87,1.50,1.25,0.12,0.08,-0.13,-0.39,-0.66,-0.88,-0.89,-0.86,-0.66,0.25,2.25,3.26,4.37,3.57,4.77,4.12,4.51,5.47,4.89,4.51,3.25,3.07,3.97,4.97,5.08,5.08,4.20,4.50,5,5.32,4.35,3.39,2.58,2.75,3,3,3,3,3,1.45,0.47,-1.68,-2.68,-3.40,-4.88,-5.01,-4.93,-4.79,-4.63,-4.29,-1.79,3.86,7.64,10.32,10.09,10.83,11.16,11.24,11.03,10.57,9.75,8.76,7.87,7.12,6.62,6.46,6.57,6.87,7.25,7.64,8.09,8.50,8.90,9.32,9.64,9.98,10.25,10.49,10.70,10.87,11,11.14,11.26,11.37,11.50,11.60,11.66,11.76,11.87,11.97,12.07,12.14,12.25,12.38,12.53,12.74,12.97,13.24,13.57,13.91,14.32,14.64,14.98,15.23,15.45,15.62,15.77,15.95,16.09,16.22,16.35,16.48,16.62,16.75,16.87,17,18,18,18,18,18,18,18,18,18,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,15,15,15,16,16,16,16,16,16,17,16,16,16,16,16,16,16,16,16,16,16,16,16,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15.09,15.28,15.62,15.87,15.98,16,16,16,15.99,15.90,15.77,15.60,15.36,15.15,15.03,15.02,15.12,15.25,15.49,15.71,15.87,16,16.12,16.25,16.39,16.53,16.65,16.75,16.82,16.83,16.83,16.77,16.75,16.72,16.70,16.70,16.75,16.87,17,17.21,17.35,17.37,17.25,16.97,16.50,15.96,15.38,14.88,14.50,14.23,14.07,13.99,13.99,14,14.03,14.99,15,16,16,16,15,15,15,14,14,14,14,14,13.07,13.12,13.21,13.89,13.89,12.32,11.85,11.45,10.21,10.12,10.07,10,10,10,10.09,10.37,11.33,12.02,12.51,12.64,12.62,11.62,9.64,6.87,4.36,1.86,-0.73,-1.13,-1.38,-1.51,-1.60,-1.98,-2.24,-2.27,-2.25,-2.38,-2.38,-2.18,-1.99,-1,-0.92,0.14,0.35,0.58,0.87,0.95,0.75,0.25,-0.13,-0.37,-0.50,0.37,2.38,3.13,3.11,3.22,4.50,5,4.62,3.99,3.07,3.20,2.37,2.63,3,3.87,3.75,2.74,1.57,0.25,-1.86,-2.77,-4.50,-4.90,-5.17,-5.25,-5.05,-4.68,-4.16,-1.64,3,7.50,10.12,10.87,11.75,11.71,11.61,11.46,11.11,10.50,9.61,8.75,7.97,7.34,6.97,6.87,7,7.25,7.60,7.99,8.37,8.78,9.21,9.58,9.88,10.20,10.46,10.65,10.86,11,11.14,11.27,11.38,11.50,11.60,11.66,11.75,11.86,11.95,12.01,12.12,12.24,12.37,12.51,12.73,12.98,13.26,13.62,14.02,14.47,14.86,15.20,15.47,15.70,15.87,16.02,16.16,16.32,16.41,16.53,16.65,16.78,16.97,17.12,17,18,18,18,18,18,18,18,18,18,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,15,15,15,15,15,16,16,17,17,16,16,16,16,16,16,16,16,16,16,16,16,16,16,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15.01,15,15.11,15.33,15.64,15.87,16,16,16,16,15.99,15.91,15.77,15.60,15.37,15.15,15.03,15.02,15.12,15.27,15.50,15.74,15.89,16.01,16.13,16.25,16.39,16.52,16.64,16.75,16.78,16.82,16.78,16.75,16.71,16.63,16.61,16.60,16.62,16.74,16.87,17.03,17.20,17.24,17.12,16.84,16.37,15.86,15.33,14.85,14.48,14.23,14.08,14,14,14.07,14,15,15,15,16,15,15,15,15,14,14,14,14,13.96,13.12,13.22,13.25,13.28,12.91,12.33,10.86,10.47,10.25,10.22,10.12,10.02,10,10,10.12,10.37,11.24,11.75,12.23,12.60,10.60,7.99,5.37,2.39,0.99,-0.62,-1.12,-1.53,-1.76,-1.92,-2.13,-2.63,-2.88,-2.92,-2.85,-2.72,-2.76,-2.63,-2.36,-2.13,-2.12,-2,-1.85,-1.62,-1.51,-1.75,-1.92,-2.27,-2.63,-2.87,-1.99,-2.04,-1.38,0.37,1.34,1.48,2.75,3.22,3.87,4.50,2.75,2.88,2.09,2.12,2.22,3.38,3.32,2.26,0.72,-1.36,-3.36,-4.02,-4.50,-4.99,-5.25,-5.25,-5.13,-4.75,-3.15,-1.38,1.99,6.46,10.01,10.82,11.72,12,11.85,11.73,11.48,10.96,10.28,9.53,8.75,8.11,7.62,7.37,7.33,7.45,7.65,7.98,8.33,8.71,9.08,9.41,9.75,10.08,10.34,10.58,10.82,10.98,11.12,11.25,11.37,11.47,11.53,11.62,11.72,11.77,11.87,11.97,12.07,12.16,12.33,12.50,12.72,12.99,13.33,13.72,14.13,14.62,15.01,15.37,15.66,15.89,16.11,16.25,16.38,16.50,16.62,16.74,16.85,16.99,17.14,17.37,18,18,18,18,18,18,18,18,18,18,17,17,17,17,17,17,17,17,17,17,17,17,17,17,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,15,15,15,15,15,15,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15.01,15.08,15.12,15.12,15.11,15.37,15.66,15.87,16,16,16,16,16,15.95,15.78,15.60,15.37,15.15,15.07,15.03,15.12,15.33,15.53,15.75,15.90,16.02,16.13,16.25,16.38,16.51,16.62,16.73,16.75,16.76,16.75,16.72,16.63,16.58,16.50,16.48,16.50,16.58,16.71,16.85,16.97,17,16.87,16.62,16.22,15.73,15.23,14.76,14.45,14.21,14.07,14,14,14,15,15,15,15,15,15,15,15,14,14,14,14,14,13.89,13.21,13.25,13.33,13.36,13.01,11.62,11.25,10.36,10.33,10.25,10.21,10.11,10,10.07,10.25,10.59,10.89,11.21,11.34,9.78,7.61,4.13,2.21,1.37,0.12,-0.74,-1.35,-1.73,-1.99,-2.25,-2.55,-3,-3.37,-3.47,-3.39,-3.25,-3.01,-2.89,-2.63,-2.25,-2.17,-2.11,-1.91,-1.73,-1.87,-2.25,-2.41,-2.66,-3,-3.24,-3.30,-3.61,-2.99,-3.18,-2.25,-2.13,-0.85,0.62,1.25,2.08,1.57,1.65,1.50,1.47,1.58,1.82,1.96,0.61,-0.90,-2.99,-3.75,-4.25,-4.63,-4.75,-5.01,-5.04,-4.90,-4.54,-2.17,0.36,2,5.50,9.09,10.85,11.75,12,12.02,11.87,11.63,11.26,10.72,10.07,9.37,8.72,8.20,7.84,7.65,7.65,7.82,8.02,8.34,8.63,8.98,9.28,9.62,9.91,10.21,10.46,10.65,10.86,11,11.15,11.27,11.37,11.47,11.52,11.61,11.66,11.75,11.86,11.96,12.09,12.25,12.45,12.70,13,13.37,13.82,14.26,14.74,15.20,15.57,15.87,16.11,16.28,16.46,16.59,16.71,16.78,16.88,17,17.13,17.34,17.62,18,18,18,18,17,17,17,17,18,18,17,17,17,17,17,16,16,17,17,17,17,17,17,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,17,16,16,16,16,16,16,16,16,16,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15.03,15.12,15.23,15.23,15.26,15.46,15.73,15.90,16,16,16,16,16,15.96,15.83,15.61,15.37,15.16,15.07,15.03,15.13,15.34,15.57,15.75,15.91,16.02,16.12,16.25,16.37,16.49,16.60,16.66,16.73,16.74,16.72,16.64,16.59,16.50,16.40,16.37,16.37,16.39,16.50,16.61,16.70,16.71,16.61,16.37,16,15.58,15.12,14.73,14.38,14.16,14.02,14,14,14,14,15,15,15,15,15,15,14,14,14,14,14,13.96,13.89,13.89,13.28,13.36,13.61,13.75,12.35,11.98,10.62,11.25,10.88,11.50,10.13,10.12,10.22,10.35,10.46,10.50,10.15,9.07,7.47,5.27,3.01,1.38,0.35,-0.47,-1.12,-1.54,-1.90,-2.13,-2.43,-2.85,-3.28,-3.62,-3.77,-3.75,-3.64,-3.38,-3.10,-2.78,-2.38,-2.25,-2.13,-1.98,-1.88,-2.14,-2.61,-2.75,-2.98,-3.27,-3.50,-3.53,-4.03,-4.40,-4.63,-4.63,-3.53,-3.26,-2.80,-2.18,-1.38,-0.75,-0.87,-1,-1.02,-0.93,-0.68,-0.53,-1.92,-2.48,-3.28,-4.13,-4.63,-4.91,-4.99,-4.87,-4.90,-4.87,-3.63,-0.27,2.25,2.98,5.62,7.25,11,11.73,13,12,12.07,11.76,11.48,11.01,10.47,9.82,9.16,8.65,8.27,8.03,7.97,8.01,8.16,8.37,8.62,8.89,9.21,9.49,9.75,10.01,10.25,10.50,10.70,10.87,11,11.12,11.25,11.34,11.38,11.47,11.51,11.61,11.71,11.83,11.98,12.14,12.38,12.70,13.03,13.48,13.95,14.40,14.88,15.34,15.72,16,16.25,16.46,16.61,16.74,16.84,16.91,17,17.12,17.25,17.45,17.70,18,18,18,17,17,17,17,17,18,18,18,18,17,17,16,16,16,17,17,17,17,17,16,16,15,15,16,16,15,16,16,16,16,16,16,16,16,17,17,17,16,16,16,16,16,16,16,15,15,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,16,16,16,16,16,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15.03,15.13,15.25,15.26,15.36,15.52,15.76,15.95,16,16,16,16,16,16,15.85,15.63,15.40,15.23,15.11,15.08,15.14,15.34,15.53,15.75,15.89,16,16.12,16.22,16.34,16.45,16.53,16.62,16.65,16.66,16.64,16.61,16.50,16.40,16.33,16.25,16.23,16.24,16.27,16.37,16.39,16.38,16.28,16.09,15.76,15.39,15.01,14.65,14.37,14.14,14,14,14,14,14,14,15,15,15,15,14,14,14,14,14,14,13.91,13.89,13.89,13.33,13.70,13.89,13.89,13.89,13.50,12.45,11.98,11.57,12.20,10.37,10.40,10.37,10.27,10.16,9.73,8.65,7.26,5.53,3.71,1.99,0.64,-0.28,-0.98,-1.43,-1.77,-2.04,-2.16,-2.36,-2.79,-3.42,-2.75,-2.91,-3,-2.88,-2.62,-2.13,-1.88,-1.49,-1.23,-2.12,-1.92,-1.93,-2.29,-2.73,-2.88,-3.12,-3.40,-3.63,-3.86,-4.35,-4.67,-4.88,-4.89,-4.78,-4.51,-4.11,-3.50,-2.65,-2.15,-2.25,-2.38,-2.39,-2.30,-2.10,-2.12,-2.36,-2.85,-3.48,-4.25,-4.75,-5.11,-5.14,-4.99,-4.86,-3.76,-1.55,2.82,3.34,3,5.89,8.50,10.25,11.75,13,12.90,12.25,12,11.64,11.25,10.73,10.12,9.53,9.03,8.65,8.41,8.32,8.28,8.37,8.50,8.66,8.87,9.12,9.36,9.61,9.85,10.08,10.27,10.50,10.66,10.84,10.97,11.07,11.14,11.23,11.26,11.35,11.40,11.50,11.64,11.85,12.08,12.37,12.72,13.12,13.61,14.10,14.59,15.03,15.48,15.86,16.13,16.37,16.57,16.72,16.84,16.91,17,17.11,17.21,17.33,17.47,17.71,18,18,17,17,17,17,17,17,18,18,18,18,18,17,16,16,16,17,17,17,17,16,16,15,15,15,16,15,15,16,16,16,16,16,16,16,17,17,17,17,17,16,16,16,16,16,15,15,15,15,15,15,15,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15.01,15.09,15.13,15.20,15.27,15.50,15.76,15.89,15.98,16,16,16,16,16,15.89,15.72,15.50,15.33,15.20,15.12,15.16,15.33,15.50,15.72,15.87,15.99,16.08,16.15,16.26,16.37,16.49,16.57,16.61,16.62,16.60,16.52,16.46,16.35,16.25,16.13,16.10,16.09,16.10,16.12,16.12,16.12,16,15.85,15.59,15.26,14.95,14.62,14.36,14.12,14,14,14,14,14,14,14,15,15,14,14,14,14,14,14,14,13.90,13.89,13.89,13.72,13.89,13.89,13.89,13.89,13.78,13.37,13.08,12.52,11.97,11.40,10.78,10.49,10.11,9.63,8.62,7.28,5.74,4.08,2.50,1.12,0.02,-0.75,-1.34,-1.72,-1.92,-2.11,-2.03,-2.02,-2.14,-2.47,-1.77,-1.97,-2.05,-1.99,-1.73,-1.18,-0.80,-0.41,-0.13,-1.02,-0.88,-1.88,-2.26,-2.66,-2.80,-3.13,-3.48,-3.65,-3.98,-4.42,-4.78,-5,-5.01,-4.89,-4.63,-4.23,-3.61,-2.77,-2.50,-2.50,-2.64,-2.66,-2.55,-2.42,-2.50,-2.63,-3.01,-3.63,-4.12,-4.66,-5,-5.12,-4.98,-4.61,-2.52,1.65,5,3.57,3.25,7.20,9.95,11.37,11.87,12.87,12.85,12.58,12.20,11.85,11.41,10.95,10.37,9.85,9.37,9,8.78,8.65,8.62,8.62,8.70,8.76,8.89,9.07,9.24,9.41,9.63,9.87,10.08,10.26,10.47,10.62,10.75,10.87,10.96,11,11.07,11.12,11.21,11.33,11.49,11.72,12,12.37,12.77,13.25,13.75,14.26,14.75,15.23,15.62,15.97,16.25,16.47,16.63,16.76,16.88,16.99,17.07,17.13,17.24,17.33,17.40,17.53,18,17,17,17,17,17,17,17,17,18,18,18,17,17,16,16,16,17,17,17,17,16,15,15,15,15,15,15,15,16,16,16,16,16,16,16,17,17,17,17,16,16,16,16,16,15,15,15,15,15,15,15,14,14,15,15,15,15,15,15,16,16,16,16,16,16,16,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15.01,15.03,15.09,15.15,15.36,15.60,15.78,15.91,15.98,16,16,16,16,15.96,15.82,15.62,15.48,15.34,15.24,15.24,15.33,15.49,15.64,15.83,15.91,16.01,16.12,16.23,16.33,16.39,16.49,16.51,16.53,16.51,16.48,16.37,16.26,16.14,16.07,15.98,15.91,15.89,15.89,15.88,15.87,15.76,15.62,15.39,15.13,14.87,14.60,14.35,14.12,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,13.91,13.89,14.02,13.89,13.89,13.89,13.89,13.89,13.89,13.76,13.45,13.15,13,11.96,11.21,10.58,9.87,8.91,7.53,6.01,4.45,2.91,1.60,0.49,-0.38,-1.03,-1.51,-1.87,-2.03,-2.01,-1.78,-1.53,-1.38,-1.36,-0.72,-0.89,-1,-0.90,0.35,0.87,1.36,1.75,1,1.11,0.25,0.25,-1.05,-1.48,-1.63,-3.10,-3.38,-3.60,-3.92,-4.42,-4.78,-4.99,-5,-4.88,-4.63,-4.17,-3.54,-2.88,-2.63,-2.67,-2.79,-2.80,-2.74,-2.66,-2.75,-2.86,-3.05,-3.65,-4.12,-4.38,-4.68,-4.79,-4.67,-4.35,-1.14,5.08,6.45,5.99,4.70,7.59,11.12,11.49,12.13,12.74,12.89,12.71,12.38,12.02,11.62,11.12,10.60,10.07,9.62,9.35,9.14,9.07,9,8.96,8.95,8.96,8.99,9.03,9.13,9.27,9.46,9.63,9.86,10.07,10.25,10.40,10.57,10.65,10.75,10.82,10.86,10.88,10.99,11.12,11.33,11.60,11.97,12.38,12.87,13.40,13.96,14.48,14.95,15.37,15.75,16.07,16.34,16.51,16.66,16.82,16.89,17,17.08,17.13,17.22,17.26,17.33,17.36,17,17,17,17,17,17,17,17,17,17,17,17,17,16,16,16,16,17,17,17,17,16,15,15,14,14,14,14,14,16,16,16,16,16,16,16,16,17,17,16,16,16,16,16,15,15,15,15,15,15,15,14,14,14,14,15,15,15,16,16,16,16,16,16,16,16,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15.03,15.15,15.37,15.61,15.78,15.91,15.98,16,16,16,15.98,15.91,15.82,15.64,15.50,15.37,15.28,15.33,15.45,15.60,15.75,15.87,15.98,16.08,16.14,16.25,16.34,16.38,16.46,16.48,16.47,16.39,16.34,16.22,16.10,15.97,15.86,15.76,15.74,15.71,15.66,15.63,15.58,15.45,15.25,15.03,14.78,14.57,14.34,14.13,14.01,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,13.98,14.22,14.27,13.89,13.89,13.89,13.89,13.89,13.89,13.89,13.89,13.62,13.45,12.45,11.50,10.59,9.53,8.13,6.52,4.87,3.37,2.01,0.96,0.03,-0.64,-1.15,-1.50,-1.66,-1.72,-1.60,-1.28,-1,-0.53,-0.15,0.50,0.32,0.24,1.26,1.58,3.12,2.62,4.02,3.21,2.27,2.48,2.59,2.34,0.95,-0.43,-0.89,-2.25,-3.42,-3.75,-4.26,-4.63,-4.80,-4.86,-4.75,-4.48,-4,-3.38,-2.77,-2.63,-2.75,-2.88,-2.88,-2.75,-2.75,-2.78,-2.91,-3.15,-3.52,-4,-4.25,-4.38,-4.28,-3.18,-1.80,2.40,6.64,9,8.57,7.10,7.75,10.27,11.59,12.12,12.62,12.89,12.76,12.53,12.24,11.83,11.33,10.76,10.25,9.87,9.63,9.51,9.47,9.38,9.34,9.25,9.16,9.12,9.09,9.11,9.15,9.27,9.46,9.62,9.85,10.03,10.24,10.37,10.50,10.58,10.62,10.66,10.74,10.78,10.96,11.20,11.51,11.96,12.46,13,13.57,14.11,14.62,15.10,15.50,15.84,16.12,16.37,16.53,16.70,16.78,16.87,16.98,17.02,17.11,17.14,17.22,17.22,17.13,17,17,17,17,17,17,17,17,17,17,17,17,17,16,16,16,16,17,17,17,17,16,15,14,14,14,13,13,13,16,16,16,16,16,16,16,16,16,16,16,16,16,16,15,15,15,15,15,15,15,14,14,14,14,14,15,15,16,16,16,16,16,16,16,16,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15.03,15.15,15.37,15.61,15.78,15.91,15.98,16,16,16,15.98,15.96,15.87,15.66,15.50,15.37,15.33,15.37,15.51,15.66,15.82,15.90,16,16.11,16.16,16.25,16.33,16.37,16.38,16.38,16.36,16.25,16.14,16,15.87,15.75,15.63,15.58,15.50,15.49,15.46,15.37,15.27,15.12,14.96,14.75,14.51,14.33,14.14,14.03,14,14,14,14,14,13,13,13,13,14,14,14,14,14,14,14.32,14.61,13.95,13.89,13.89,13.89,13.89,13.89,13.89,13.89,13.89,13.89,13.89,12.74,11.63,10.49,9.12,7.46,5.62,3.77,2.49,1.38,0.48,-0.25,-0.80,-1.18,-1.39,-1.47,-1.38,-1.11,-0.68,-0.22,0.32,0.97,1.85,1.62,2.52,3.62,4,4.52,4,4.38,4.48,5.58,5.75,5,4.87,4.49,2.88,0.45,-0.87,-2.05,-3.37,-3.90,-4.27,-4.50,-4.52,-4.40,-4.13,-3.65,-3.03,-2.50,-2.43,-2.68,-2.80,-2.85,-2.73,-2.66,-2.73,-2.90,-3.15,-3.29,-3.73,-4,-3.12,-3.01,-0.78,2.62,5.97,9.14,9.46,9.87,8.37,8.12,10.46,11.20,12.02,12.61,12.89,12.85,12.65,12.37,12,11.50,10.98,10.49,10.13,9.98,9.89,9.87,9.85,9.75,9.62,9.48,9.32,9.20,9.11,9.10,9.14,9.27,9.47,9.65,9.87,10.08,10.24,10.37,10.46,10.51,10.58,10.62,10.73,10.87,11.13,11.50,11.99,12.50,13.10,13.64,14.21,14.71,15.13,15.52,15.87,16.12,16.34,16.50,16.63,16.75,16.84,16.89,16.98,17.02,17.09,17.12,17.12,17.09,17,17,17,17,17,17,17,17,17,17,17,17,17,16,16,16,16,16,17,17,16,15,14,13,13,13,13,12,12,16,16,16,16,16,16,16,16,16,16,16,16,16,15,15,15,15,15,14,14,14,14,14,14,14,15,15,16,15,16,16,16,16,16,16,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15.03,15.15,15.37,15.61,15.78,15.91,15.98,16,16,16,16,15.98,15.88,15.61,15.39,15.32,15.36,15.48,15.62,15.75,15.87,15.98,16.03,16.12,16.20,16.25,16.28,16.34,16.34,16.27,16.22,16.11,15.96,15.78,15.63,15.50,15.40,15.35,15.28,15.25,15.23,15.13,15.02,14.87,14.71,14.50,14.32,14.14,14.07,14,14,14,14,13,13,13,13,13,13,14,14,14,14,14.14,14.57,13.96,14,13.91,13.89,13.89,13.89,13.89,13.89,13.89,13.89,13.91,14,12.87,11.65,10.27,8.65,6.77,4.75,2.87,1.84,0.87,0.10,-0.51,-0.92,-1.24,-1.38,-1.26,-1.01,-0.63,-0.05,0.57,1.24,1.87,3.35,3.10,3.98,4.21,5.60,5.12,5.57,6.75,7.77,8.88,8.11,7.37,7.51,7,4.38,2.96,1.62,0.40,-1.79,-2.36,-3.75,-4,-4.04,-3.92,-3.64,-3.16,-2.51,-2.13,-2.29,-2.53,-2.65,-2.65,-2.54,-2.39,-2.50,-2.85,-3.10,-3.23,-3.25,-2.53,-1.66,0.38,4.62,7.08,8.37,9.52,9.85,10.25,10.76,9.64,10.26,11.20,12.02,12.57,12.87,12.87,12.75,12.50,12.12,11.65,11.20,10.75,10.48,10.34,10.32,10.32,10.27,10.20,10.01,9.78,9.57,9.35,9.15,9.09,9.09,9.15,9.34,9.52,9.75,9.98,10.13,10.27,10.38,10.49,10.53,10.62,10.75,10.90,11.21,11.61,12.08,12.61,13.14,13.72,14.24,14.72,15.12,15.50,15.77,16.02,16.25,16.41,16.53,16.64,16.75,16.83,16.87,16.95,16.98,17,17,17,17,17,17,17,17,16,16,17,17,17,17,17,17,16,16,16,16,16,16,16,15,15,14,13,13,14,12,12,13,16,16,16,16,16,16,16,16,16,16,16,16,15,15,15,15,15,14,14,14,14,14,14,14,15,15,15,15,15,15,16,16,16,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15.03,15.15,15.37,15.61,15.78,15.91,15.98,16,16,16,16,15.90,15.71,15.46,15.34,15.35,15.47,15.60,15.73,15.85,15.91,16,16.08,16.12,16.20,16.24,16.25,16.25,16.24,16.14,16.02,15.87,15.72,15.53,15.37,15.25,15.16,15.12,15.10,15.07,15.01,14.97,14.84,14.64,14.48,14.28,14.14,14.07,14,14,14,13,13,13,13,13,13,13,13,14,14,14,14.37,13.76,14.27,14.34,14,13.95,13.89,13.89,13.89,13.89,13.89,13.95,14,14.09,12.95,11.62,10.08,8.25,6.21,4.10,2.14,1.24,0.36,-0.38,-0.79,-1.11,-1.25,-1.25,-1.09,-0.65,-0.13,0.58,1.34,2.12,2.90,4.38,4.62,5.62,5.95,6.37,6.97,7.15,8.15,10.23,10.36,9.52,9.82,10.87,8.53,6.07,5.75,5.57,2.32,1.03,-0.42,-1,-2.27,-2.38,-2.26,-3,-2.50,-1.88,-1.64,-2.02,-2.28,-2.40,-2.40,-2.26,-2,-2.25,-2.63,-1.88,-2,-1.04,1,2.90,5.98,8.23,9.63,9.87,10.07,11.37,11.77,11.25,10.74,10.38,11.48,11.95,12.41,12.74,12.83,12.75,12.53,12.23,11.84,11.45,11.10,10.85,10.73,10.71,10.74,10.72,10.62,10.41,10.14,9.86,9.53,9.27,9.12,9.08,9.12,9.26,9.48,9.71,9.91,10.12,10.27,10.40,10.51,10.62,10.75,10.88,11.12,11.37,11.75,12.22,12.72,13.23,13.73,14.20,14.62,15,15.35,15.62,15.87,16.09,16.26,16.39,16.50,16.62,16.72,16.75,16.82,16.84,16.85,16.88,16.96,17,17,17,17,16,16,16,16,17,17,17,17,17,16,16,16,16,16,16,15,15,15,13,13,14,14,13,13,14,16,16,16,16,16,16,16,16,16,15,15,15,15,15,15,15,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15.03,15.15,15.37,15.61,15.82,15.91,15.98,16,16,16,15.91,15.75,15.52,15.37,15.41,15.50,15.62,15.73,15.84,15.90,15.99,16.02,16.10,16.12,16.16,16.22,16.22,16.16,16.11,15.99,15.83,15.62,15.45,15.25,15.12,15,14.95,14.90,14.89,14.89,14.86,14.75,14.62,14.46,14.27,14.14,14.07,14,14,14,13,13,13,13,12,12,12,13,13,14,14.07,13.50,14,14.51,14.75,14.47,14.39,14.12,13.97,13.97,13.97,14,14.02,14.11,14.13,13,11.62,9.91,7.91,5.75,3.60,1.70,0.85,0.08,-0.53,-0.98,-1.13,-1.13,-1.01,-0.75,-0.29,0.34,1.13,2.01,2.95,4.12,5.62,7,6.36,6.86,7.35,8.75,8.72,9.65,11.75,11.86,10.87,10.91,11.77,11.16,10.16,9.84,7.49,4.50,2.25,3,2.38,0.83,0.50,0.59,-0.13,-0.63,-0.35,-0.29,-0.66,-1.91,-2.04,-2.02,-1.88,-0.66,-0.93,-0.35,0.39,1.25,3.24,6.26,8.47,9.75,11,11.39,11.50,11.71,12,12.37,11.75,11.22,10.50,11.37,11.95,12.34,12.62,12.75,12.72,12.57,12.28,12,11.70,11.40,11.21,11.10,11.08,11.10,11.09,11,10.77,10.50,10.13,9.76,9.47,9.25,9.13,9.14,9.27,9.49,9.72,9.96,10.15,10.36,10.50,10.63,10.76,10.95,11.12,11.37,11.64,12,12.39,12.84,13.26,13.71,14.12,14.50,14.84,15.12,15.37,15.62,15.84,16.02,16.20,16.34,16.46,16.57,16.62,16.64,16.64,16.63,16.63,17,17,17,16,16,16,16,16,16,17,17,17,17,17,16,16,16,16,16,15,15,15,15,13,13,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,15,16,16,15,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15.03,15.14,15.37,15.61,15.82,15.91,15.98,16,16,15.96,15.87,15.73,15.61,15.53,15.60,15.66,15.75,15.85,15.89,15.97,16,16.07,16.10,16.12,16.14,16.14,16.12,16.03,15.91,15.75,15.53,15.35,15.12,14.96,14.83,14.75,14.74,14.75,14.75,14.75,14.66,14.57,14.40,14.25,14.13,14.07,14,14,14,13,14,13,12,12,11,12,13,13,13,13.14,13.62,14.15,14.65,15.07,14.87,14.77,14.39,14.12,14.08,14.09,14.11,14.13,14.13,14.20,13.25,11.84,9.96,7.78,5.50,3.23,1.37,0.53,-0.17,-0.75,-1.13,-1.26,-1.16,-0.90,-0.50,0.11,0.84,1.71,2.73,3.83,4.59,6.07,6.57,6.96,7.48,9,9,10,11,11.98,11.97,11.88,11.87,11.77,11.77,11.77,11.77,8.64,6.71,4.41,6.21,5.97,4.38,3.87,4.62,3.89,2.99,1.96,0.99,0.85,-0.42,-0.53,-0.51,-0.38,0.50,1.40,2.09,3.83,4.64,7.62,9.70,10.87,12.13,11.59,11.87,11.99,12.13,12.38,12.50,12.12,11.71,11.52,11.62,12,12.28,12.51,12.64,12.64,12.53,12.37,12.12,11.89,11.70,11.50,11.39,11.37,11.37,11.36,11.25,11.08,10.76,10.39,10.01,9.66,9.40,9.26,9.25,9.37,9.53,9.76,10,10.25,10.45,10.62,10.78,10.98,11.15,11.37,11.63,11.95,12.25,12.62,12.99,13.35,13.70,14.01,14.35,14.62,14.87,15.12,15.33,15.51,15.75,15.91,16.10,16.25,16.36,16.41,16.48,16.47,16.41,16.37,16,16,16,16,16,16,16,16,17,17,17,17,17,17,17,16,16,16,16,15,15,14,14,14,14,14,14,14,14,14,15,14,15,15,15,15,15,15,15,15,15,15,16,16,15,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15.02,15.13,15.37,15.65,15.87,15.97,16,16,15.98,15.96,15.87,15.77,15.73,15.72,15.75,15.83,15.87,15.91,15.97,16,16.01,16.07,16.10,16.12,16.12,16.10,16,15.87,15.71,15.48,15.24,15,14.75,14.62,14.52,14.52,14.59,14.62,14.62,14.60,14.50,14.37,14.25,14.12,14.07,14,14,14,14,13,13,12,11,10,12,12,13,13,13.24,13.71,14.25,14.74,15.14,15.41,15.10,14.72,14.46,14.26,14.14,14.13,14.14,14.26,14.32,13.77,12,10.11,8,5.77,3.62,1.60,0.40,-0.48,-1,-1.34,-1.48,-1.36,-0.97,-0.38,0.36,1.24,2.22,3.35,4.60,6.20,6.76,7.27,7.65,9,9,10,11,12,12,12.97,12.90,11.77,11.77,11.77,11.77,11.77,11.62,8.50,6.64,7.46,7.85,7.71,7.28,7.72,7.34,6.33,4.32,3.35,2.39,2.23,2.10,1.07,0.87,2.74,2.63,3.62,4.35,6.15,8.12,10.21,10.37,12.70,12.07,12.12,12.25,13.45,12.71,12.61,12.37,12.12,11.99,12,12.12,12.34,12.50,12.61,12.62,12.52,12.39,12.25,12.08,11.88,11.75,11.63,11.60,11.58,11.52,11.45,11.25,10.99,10.62,10.25,9.89,9.62,9.48,9.41,9.50,9.64,9.87,10.11,10.35,10.57,10.75,10.97,11.15,11.37,11.62,11.88,12.20,12.50,12.85,13.13,13.41,13.71,13.97,14.21,14.40,14.62,14.83,15,15.21,15.38,15.61,15.78,15.98,16.11,16.21,16.25,16.25,16.23,16.09,16,16,16,16,16,16,16,17,17,17,17,17,17,17,17,16,16,16,16,15,14,14,14,14,14,14,15,15,14,14,13,14,14,15,15,15,15,15,15,15,15,15,15,15,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15.01,15.01,15.01,15.01,15.25,15.60,15.84,15.96,16,16,16,15.98,15.96,15.88,15.86,15.84,15.86,15.88,15.91,15.98,15.98,15.99,16,16.02,16.08,16.10,16.11,16.09,16,15.87,15.66,15.41,15.12,14.86,14.61,14.40,14.34,14.34,14.37,14.47,14.50,14.50,14.45,14.34,14.22,14.12,14.03,14,13.99,14,14,13,13,12,11,11,12,12,12,13,13.24,12.73,13.24,14.74,15.13,15.77,15.48,15.10,14.77,14.60,14.49,14.46,14.49,14.50,14.34,14,12.32,10.47,8.37,6.12,3.85,1.88,0.50,-0.51,-1.27,-1.61,-1.68,-1.51,-1.11,-0.40,0.46,1.48,2.59,3.78,5.25,6.87,7.46,7.76,8,9,10,11,12,12,13,12.96,12.89,11.77,11.77,11.77,11.77,11.77,11.77,9.97,7.35,8.01,9.64,9.37,8.82,8.20,8.47,8.11,7.95,6.75,6.87,6,5.62,3.37,2.14,3,3.96,4.89,6.96,5.84,6.75,7.85,11.01,12.37,12.37,12.47,12.61,12.73,12.75,12.60,12.47,12.34,12.25,12.25,12.32,12.40,12.50,12.59,12.60,12.53,12.46,12.33,12.20,12.03,11.91,11.84,11.75,11.72,11.63,11.52,11.37,11.12,10.78,10.47,10.12,9.87,9.66,9.62,9.64,9.77,9.99,10.22,10.45,10.65,10.87,11.11,11.34,11.58,11.84,12.12,12.39,12.72,13,13.28,13.51,13.75,13.91,14.12,14.26,14.41,14.58,14.73,14.87,15.03,15.25,15.47,15.63,15.77,15.88,15.99,16.02,16.03,16,16,16,16,16,16,17,17,17,17,17,17,17,17,17,16,16,16,16,15,15,14,14,14,15,15,15,15,15,15,14,12,12,14,15,15,15,15,15,15,16,15,15,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15.12,15.24,15.35,15.35,15.41,15.66,15.87,15.97,16,16,16,15.99,15.98,15.96,15.91,15.91,15.91,15.97,15.98,15.99,15.98,15.99,16,16,16.03,16.08,16.09,16.07,15.99,15.86,15.63,15.37,15.07,14.74,14.46,14.24,14.12,14.12,14.21,14.32,14.37,14.39,14.37,14.26,14.16,14.09,14.01,14,13.99,14,14,13,13,12,11,11,12,12,12,12,12.14,12.71,13.16,14.64,15.07,15.77,15.77,15.58,15.25,15.02,14.90,14.87,14.87,14.75,14.51,13.88,12.70,10.99,8.89,6.51,4.08,1.70,0.52,-0.49,-1.37,-1.75,-1.84,-1.66,-1.15,-0.38,0.64,1.76,2.96,4.21,5.74,7.47,8,8,8,9,10,11,12,13,13,13.96,12.74,11.77,11.77,11.77,11.77,11.77,11.75,11.14,8.37,8.25,9.62,9.01,8.45,8.84,8.20,8.20,8.22,8.40,8.20,8,8,5.75,5.52,4.38,6.32,9.26,10.32,9.38,7.52,7.64,9.77,11.75,11.77,12.87,12.53,12.51,12.57,12.52,12.49,12.41,12.38,12.39,12.46,12.50,12.58,12.61,12.61,12.58,12.50,12.38,12.27,12.15,12.07,11.97,11.87,11.78,11.72,11.60,11.41,11.21,10.91,10.62,10.34,10.09,9.89,9.83,9.85,9.95,10.12,10.33,10.53,10.76,11,11.24,11.48,11.73,12,12.27,12.59,12.87,13.15,13.41,13.62,13.82,13.97,14.10,14.21,14.32,14.39,14.50,14.62,14.74,14.91,15.12,15.27,15.38,15.50,15.63,15.83,15.97,16,16,16,16,16,17,17,17,17,17,17,17,17,17,16,16,16,16,15,15,15,14,14,15,15,15,15,15,15,15,14,13,12,14,15,15,15,15,15,15,15,15,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15.11,15.14,15.78,15.75,15.75,15.75,15.87,15.99,15.99,16,16,16,15.99,16,15.99,15.99,15.99,15.99,15.99,15.99,15.99,15.99,15.99,16,16,16.02,16.07,16.08,16.03,15.99,15.86,15.62,15.36,15,14.63,14.32,14.07,13.91,13.90,14,14.12,14.25,14.28,14.26,14.22,14.12,14.03,14,13.98,13.99,14,14,13,13,12,11,10,10,11,12,12,12.07,12.59,14.07,14.50,14.90,15.12,15.77,15.77,15.77,15.61,15.48,15.41,15.16,15,14.72,14.25,13.10,11.63,9.66,7.07,4.27,2.10,0.52,-0.49,-1.25,-1.88,-1.99,-1.77,-1.28,-0.40,0.75,2.09,3.37,4.63,6.08,7.76,8,8,8,9,10,12,12,13,13,12.96,12.61,11.97,11.77,11.77,11.77,11.75,11.72,11.66,10.27,9.87,8.25,8.65,8.20,8.50,8.20,8.20,8.75,8.89,8.20,8.58,8.91,8.02,8,7.87,8.75,11.74,12.75,11.87,10,8,9,11,11.07,11.82,12.20,12.35,12.41,12.48,12.49,12.49,12.50,12.50,12.57,12.60,12.62,12.63,12.62,12.61,12.53,12.47,12.37,12.25,12.15,12.07,11.98,11.87,11.75,11.62,11.49,11.26,11.02,10.76,10.51,10.28,10.12,10.02,10.01,10.12,10.25,10.46,10.65,10.88,11.12,11.36,11.60,11.86,12.12,12.40,12.72,13,13.26,13.52,13.75,13.89,14.03,14.13,14.24,14.32,14.37,14.40,14.50,14.50,14.65,14.84,14.96,15,15,15.07,15.66,16,16,16,16,16,17,17,17,17,17,17,17,17,17,17,16,16,16,15,15,15,15,15,15,15,16,15,15,16,15,15,14,13,14,14,14,15,15,15,15,15,15,14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,16,15,15,14,14,14,14,15,15,15,15,15,16,16,15,16,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,15.99,15.99,16,16.01,16.03,16.09,16.10,16.09,16,15.87,15.64,15.36,14.99,14.59,14.21,13.89,13.74,13.72,13.82,13.97,14.11,14.16,14.16,14.12,14.03,13.98,13.91,13.91,13.97,14,14,13,13,13,11,10,10,10,11,12,12,13.39,13.88,14.32,14.70,14.85,15.75,15.77,15.77,15.77,15.77,15.77,15.39,15.15,14.87,14.37,13.51,12.26,10.82,7.65,4.52,2.09,0.58,-0.42,-1.24,-1.92,-2.03,-1.91,-1.51,-0.66,0.57,2.11,3.63,5.02,6.36,7.90,8,8,9,10,11,12,12,13,13,12.97,12.57,11.95,11.77,11.77,11.77,11.73,11.66,11.63,11.37,10.48,8.89,8.36,8.20,8.20,8.20,8.20,8.20,8.20,8.20,9.02,8.60,8.87,8.96,9.01,10.07,11.96,14,13,12,11,9,9.16,10.84,11.52,11.98,12.22,12.35,12.41,12.50,12.52,12.58,12.62,12.63,12.66,12.70,12.71,12.70,12.64,12.61,12.51,12.45,12.36,12.25,12.13,12.03,11.95,11.84,11.70,11.52,11.36,11.14,10.91,10.72,10.50,10.37,10.25,10.25,10.32,10.45,10.62,10.83,11.02,11.25,11.49,11.73,11.99,12.25,12.52,12.84,13.12,13.37,13.62,13.86,14.01,14.16,14.27,14.37,14.41,14.49,14.50,14.52,14.50,14.60,14.72,14.76,14.63,14.40,14.36,14,15,16,16,17,17,17,17,17,17,17,18,17,17,17,17,16,16,16,15,15,15,15,15,16,16,15,15,15,14,14,14,14,13,14,14,14,14,14,14,14,14,14,14,13,14,14,14,14,14,14,14,14,15,15,16,15,15,15,15,15,14,14,14,14,15,15,15,15,15,16,16,16,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,15.99,16,16,16.03,16.09,16.12,16.13,16.12,16.08,15.95,15.72,15.38,15,14.53,14.12,13.75,13.53,13.50,13.60,13.75,13.91,14.02,14.08,14.01,13.96,13.87,13.84,13.85,13.90,14,13,12,12,13,11,8,9,10,11,12,13,13.14,13.65,14.09,14.39,14.28,15.11,15.77,15.77,15.77,15.77,15.75,15.48,15.25,14.97,14.53,13.89,12.90,11.08,8.40,5.26,2.12,0.82,-0.37,-1.22,-1.88,-2.05,-2.11,-1.88,-1.23,0.11,1.78,3.74,5.25,6.72,7.89,8,8,9,10,11,12,12,13,13,13,12.62,12.01,11.77,11.77,11.75,11.72,11.64,11.62,11.01,10.50,9.60,8.20,8.20,8.20,8.20,8.20,8.20,8.20,8.20,8.24,8.28,8.89,8.98,10.01,11.11,11.85,13.87,13.96,13,13,11.78,10.76,11.12,11.61,11.91,12.14,12.32,12.41,12.50,12.59,12.62,12.66,12.73,12.75,12.75,12.75,12.74,12.71,12.63,12.59,12.50,12.39,12.33,12.22,12.12,12,11.87,11.75,11.61,11.46,11.26,11.10,10.89,10.74,10.61,10.50,10.50,10.53,10.64,10.83,11,11.22,11.41,11.63,11.87,12.12,12.38,12.65,12.96,13.24,13.50,13.75,13.99,14.20,14.36,14.50,14.60,14.65,14.73,14.75,14.76,14.73,14.75,14.84,14.89,14.73,13.63,13.07,14,15,16,17,17,17,17,17,17,17,18,18,17,17,17,17,16,16,16,15,15,15,15,16,16,16,16,15,14,14,14,14,14,13,13,14,14,14,14,14,13,13,13,13,13,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,14,14,14,14,15,15,15,16,15,15,16,16,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16.03,16.10,16.12,16.16,16.22,16.21,16.13,16,15.76,15.46,15.01,14.53,14.07,13.63,13.37,13.26,13.35,13.51,13.73,13.87,13.91,13.89,13.84,13.74,13.65,13.65,13.82,14,13,11,11,12,10,7,7,9,11,13,13,13,13.36,13.82,13.13,13.72,13.16,14.62,15.77,15.77,15.73,15.63,15.40,15.20,14.96,14.62,14.15,13.46,12.25,9.20,6.07,3.13,1.10,-0.26,-1.17,-1.88,-2.10,-2.23,-2.16,-1.78,-0.80,0.87,3.32,6.09,6.50,6.97,8.09,8,9,10,11,12,12,13,13,13,12.77,12.16,11.77,11.77,11.75,11.70,11.63,11.40,10.76,10.26,9.90,8.74,8.20,8.20,8.20,8.20,8.20,8.20,8.25,8.34,8.37,8.74,9,10.02,11.11,12.72,13.78,13.86,12.91,12.82,12.20,11.75,11.64,11.82,12,12.15,12.33,12.45,12.52,12.62,12.66,12.74,12.76,12.78,12.78,12.78,12.76,12.75,12.70,12.62,12.52,12.46,12.37,12.25,12.14,12.07,11.95,11.83,11.66,11.52,11.38,11.25,11.11,10.97,10.86,10.77,10.76,10.83,10.90,11.07,11.25,11.45,11.63,11.86,12.09,12.32,12.58,12.84,13.11,13.37,13.64,13.89,14.13,14.37,14.59,14.75,14.88,15,15.09,15.13,15.20,15.16,15.25,15.37,15.50,15.26,14.86,14,15,16,17,17,17,18,18,17,17,17,17,17,17,17,17,17,16,16,16,15,15,15,16,16,15,15,15,14,14,14,13,14,14,11,13,14,15,15,14,13,13,13,13,13,14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,14,14,14,14,15,15,15,15,16,16,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16.03,16.10,16.13,16.21,16.25,16.27,16.27,16.23,16.09,15.86,15.50,15.09,14.58,14.02,13.57,13.22,13.03,13.09,13.25,13.49,13.65,13.76,13.76,13.71,13.58,13.46,13.38,13.49,14,14,13,11,10,9,7,6,8,10,11,9.99,9.98,9,9.39,10.78,11.09,12.25,11.58,13.08,14.87,15.51,15.58,15.24,14.97,14.75,14.53,14.22,13.63,12.58,10,7.01,3.97,1.25,-0.35,-1.13,-1.79,-2.16,-2.49,-2.63,-2.61,-2.42,-1.14,2.12,4.53,5.12,6.87,8.12,8,9,10,11,12,12,13,13,13,13,12.41,11.91,11.77,11.75,11.70,11.63,11.26,10.62,10.12,9.78,9.22,8.20,8.20,8.20,8.20,8.20,8.24,8.34,8.39,8.46,8.61,8.99,10.07,11.65,12.60,13.74,13.76,13.77,12.91,12.47,12.13,12,12,12.11,12.23,12.35,12.46,12.53,12.62,12.72,12.75,12.82,12.84,12.84,12.83,12.78,12.75,12.71,12.62,12.53,12.48,12.37,12.27,12.20,12.10,11.99,11.87,11.75,11.62,11.50,11.38,11.27,11.20,11.11,11.07,11.07,11.11,11.21,11.35,11.50,11.70,11.88,12.11,12.32,12.52,12.77,13.02,13.28,13.58,13.85,14.11,14.36,14.61,14.84,15.03,15.23,15.37,15.50,15.62,15.71,15.75,15.85,16,16.26,16.84,15,15,15,17,17,17,17,18,17,17,17,17,17,17,17,17,17,17,16,16,16,15,15,15,15,15,15,15,14,14,14,14,14,15,15,12,12,14,14,14,14,13,13,13,14,14,14,15,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16.01,16.08,16.12,16.21,16.26,16.35,16.37,16.37,16.27,16.12,15.87,15.53,15.11,14.58,14,13.48,13.03,12.83,12.78,12.97,13.21,13.45,13.61,13.63,13.59,13.41,13.23,13.01,12.91,13,13,13,12,10,7,6,5,6,6.87,5.75,4.61,3.50,3.60,3.75,4.16,6.62,8.25,9.33,9.46,11.40,13.26,15.50,14.82,14.39,14.37,14.25,14.02,13.64,13.03,10.82,8.16,5.23,2,0.37,-1.17,-2.22,-2.51,-2.74,-2.84,-2.86,-2.75,-1.67,-0.50,0.87,4.51,6.37,7.12,8.01,8,9,10,11,12,12,13,13,13,12.77,12.25,11.87,11.75,11.70,11.63,11.24,10.61,10.12,9.75,9.47,8.57,8.20,8.20,8.20,8.20,8.28,8.37,8.46,8.50,8.58,9,10.08,11.12,12.50,12.62,13.74,13.27,12.95,12.58,12.33,12.20,12.14,12.16,12.25,12.35,12.46,12.53,12.62,12.72,12.76,12.82,12.84,12.84,12.82,12.77,12.75,12.70,12.62,12.52,12.46,12.37,12.26,12.20,12.11,12,11.90,11.83,11.73,11.62,11.52,11.47,11.38,11.36,11.34,11.36,11.39,11.50,11.62,11.78,11.99,12.16,12.37,12.60,12.82,13.02,13.27,13.52,13.82,14.08,14.35,14.60,14.87,15.12,15.36,15.58,15.76,15.96,16.12,16.25,16.38,16.48,16.59,16.85,16.99,16,16,16,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,16,16,16,16,15,15,15,15,15,14,14,14,14,14,15,16,15,12,12,13,14,13,13,13,13,13,14,14,15,15,14,14,14,14,14,14,14,15,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15.11,15.15,15.77,15.75,15.87,15.99,15.99,15.98,15.96,15.90,15.89,15.89,15.89,15.95,16,16,16,16,16,16,16,16,16,16.02,16.10,16.15,16.25,16.35,16.39,16.45,16.39,16.33,16.13,15.87,15.51,15.08,14.52,13.96,13.37,12.87,12.59,12.50,12.62,12.88,13.16,13.39,13.51,13.50,13.37,13.12,12.64,12.16,12,12,12,12,10,7,4,3.77,4.59,2.23,0.95,-0.25,-0.28,-0.38,-0.29,-0.05,1.48,2.01,4.11,7,8.63,11.71,12.62,13.03,13.64,13.82,13.70,13.70,13.53,13,11.87,9.58,6.78,3.74,1.11,-0.75,-2.63,-2.88,-3.04,-3.17,-3.37,-3.49,-3.49,-2.25,-1.78,0.77,3.62,5.27,4.70,6.75,8.75,9.77,10.87,10.99,12,12,12,12,12,11.77,12.28,11.96,11.72,11.64,11.27,10.64,10.13,9.82,9.39,8.20,8.20,8.20,8.20,8.24,8.35,8.41,8.49,8.52,8.62,10.01,11.08,11.65,12.45,12.59,13,13.12,12.82,12.57,12.37,12.25,12.22,12.21,12.25,12.33,12.39,12.50,12.60,12.66,12.75,12.77,12.78,12.77,12.76,12.75,12.70,12.62,12.57,12.49,12.39,12.34,12.25,12.15,12.10,12,11.95,11.87,11.77,11.73,11.65,11.62,11.60,11.59,11.60,11.62,11.71,11.78,11.95,12.11,12.26,12.48,12.66,12.88,13.12,13.35,13.59,13.84,14.09,14.35,14.61,14.87,15.13,15.39,15.65,15.89,16.13,16.37,16.61,16.82,17.02,17.14,17.08,17,17,17,17,17,17,18,18,18,18,18,17,17,17,17,17,18,18,17,17,16,16,16,16,16,15,15,15,15,15,14,14,14,15,15,16,16,12,12,13,13,13,13,13,13,13,14,15,15,15,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15.12,15.25,15.37,15.74,15.95,15.96,15.88,15.83,15.75,15.71,15.70,15.70,15.70,15.71,15.75,15.86,15.99,16,16,16,16,16,16.02,16.11,16.20,16.28,16.38,16.47,16.48,16.41,16.28,16.10,15.82,15.45,14.98,14.41,13.83,13.22,12.70,12.34,12.21,12.27,12.53,12.87,13.16,13.38,13.47,13.38,13.21,12.75,11.12,11,10,10,11,10,7,3.70,1.40,0.87,0.50,-0.75,-1.13,-1.38,-1.49,-1.40,-1.15,-0.77,-0.18,1.26,5.36,8.37,10.83,11,11.12,11.74,12.58,12.96,13.23,13.39,13.27,13.11,11.12,8.85,5.97,2.58,-0.38,-1.88,-3.13,-3.29,-3.68,-3.92,-4.05,-4,-3.75,-3.34,-1.72,-1.27,0.25,1.72,4.01,6.33,7.37,9.48,10.50,10.61,10.75,9.83,10.87,12,11,11.77,11.77,11.65,11.66,11.46,10.78,10.28,9.95,9.34,8.98,8.20,8.20,8.20,8.25,8.37,8.46,8.50,8.57,9.77,10.01,11.10,12.32,12.38,12.62,12.91,12.78,12.64,12.49,12.34,12.23,12.16,12.13,12.16,12.25,12.34,12.40,12.50,12.60,12.65,12.72,12.73,12.72,12.70,12.64,12.61,12.53,12.48,12.38,12.33,12.25,12.16,12.11,12.02,11.99,11.91,11.87,11.85,11.78,11.76,11.75,11.75,11.76,11.83,11.87,11.99,12.11,12.25,12.39,12.60,12.78,13,13.23,13.45,13.65,13.89,14.12,14.37,14.62,14.88,15.14,15.41,15.71,15.97,16.23,16.49,16.75,17.03,17.33,17.63,17.97,17.98,17,17,17,17,17,17,18,18,18,18,18,18,17,17,17,17,18,18,17,17,16,16,16,16,16,15,15,15,15,15,15,15,15,15,15,16,17,11,11,13,13,13,13.87,13.12,13.07,13.36,14.60,14.84,14.95,14.63,14.33,14.01,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14.99,14.98,14.98,14.98,14.98,14.99,14.99,15,15.01,15.08,15.35,15.61,15.86,15.87,15.75,15.62,15.50,15.39,15.37,15.37,15.37,15.40,15.53,15.74,15.89,15.99,16,16,16,16,16.01,16.11,16.21,16.33,16.41,16.50,16.50,16.40,16.25,16,15.66,15.27,14.82,14.25,13.62,13,12.45,12.02,11.87,11.90,12.14,12.51,12.89,13.24,13.41,13.49,13.45,13.38,13,12,10,8,8,8,4.70,2.37,0.71,-0.88,-1.25,-1.79,-2.13,-2.25,-2.36,-2.27,-2.10,-1.67,-1.13,-0.48,1.12,4.84,9.58,9.87,10,11.20,11.61,11.88,13,13.36,13.50,13.41,13.37,10.97,8.97,5,1.27,-1,-2.30,-3.78,-4.13,-4.38,-4.41,-4.29,-4.04,-3.63,-3.36,-3.13,-1.63,-1.12,0.39,2.64,4.86,5.75,5.76,5.87,6.11,6.39,7.37,9.47,8.62,9.85,10.89,11.23,9.37,10.47,10.71,10.59,10.37,10.08,9.14,8.90,8.20,8.20,8.25,8.37,8.46,8.50,9.37,9.99,11.03,11.65,12.32,12.40,12.75,12.74,12.62,12.50,12.35,12.21,12.11,12.07,12,12.02,12.11,12.20,12.26,12.37,12.47,12.51,12.59,12.61,12.60,12.57,12.51,12.48,12.40,12.35,12.25,12.16,12.12,12.07,12,11.95,11.89,11.87,11.86,11.85,11.84,11.85,11.87,11.89,11.97,12.01,12.12,12.25,12.37,12.52,12.73,12.90,13.12,13.35,13.58,13.78,14,14.25,14.48,14.72,14.96,15.21,15.47,15.73,15.99,16.24,16.50,16.76,17.10,17.40,17.87,17.97,17.99,18,18,17,17,17,17,18,18,18,18,18,18,18,18,17,17,17,17,17,17,17,16,16,16,16,16,16,15,15,15,15,16,16,15,15,15,16,16,11,11,12,12.12,12.74,12.97,13.14,13.23,13.77,14.35,14.86,14.86,14.61,14.32,14.08,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14.98,14.98,14.86,14.85,14.85,14.96,14.96,14.97,14.98,15,15.11,15.27,15.51,15.73,15.72,15.58,15.40,15.25,15.15,15.13,15.13,15.12,15.22,15.38,15.65,15.87,15.98,16,16,16,16,16.03,16.12,16.22,16.35,16.47,16.51,16.50,16.37,16.15,15.87,15.50,15.09,14.59,14,13.35,12.71,12.12,11.71,11.49,11.50,11.72,12.10,12.57,13,13.37,13.57,13.59,13.75,13,13,10,7,6,4.77,2.25,0.57,-1.15,-1.74,-2.39,-2.92,-3.25,-3.35,-3.25,-3,-2.77,-2.41,-1.88,-1.17,-0.43,1.28,4.91,8.34,10.37,11.59,12.40,12.66,13,13.41,13.58,13.63,13.85,13.72,11.40,7.84,4.35,0.97,-1.50,-2.99,-3.35,-4.52,-4.60,-4.48,-4.17,-4.01,-4.03,-3.78,-3.25,-2.75,-1.23,-1.13,0.01,0.14,0.22,0.32,0.32,2.40,3.74,4.86,5,5.26,7.62,7.73,6.88,8.10,9.87,11.11,10.66,10.38,10.14,9.95,9.83,8.20,8.25,8.37,8.65,9.12,9.73,11,11.08,11.65,12.34,12.57,12.91,12.65,12.49,12.32,12.13,12,11.89,11.86,11.82,11.84,11.87,11.98,12.08,12.15,12.25,12.35,12.38,12.41,12.40,12.38,12.36,12.26,12.23,12.14,12.09,12,11.97,11.89,11.87,11.84,11.82,11.82,11.82,11.84,11.86,11.88,11.96,12.01,12.11,12.22,12.35,12.49,12.63,12.84,13.01,13.25,13.47,13.71,13.91,14.14,14.37,14.61,14.83,15.02,15.25,15.50,15.75,16,16.25,16.50,16.75,17.07,17.37,17.87,17.98,17.99,18,18,18,18,17,17,18,18,18,18,18,18,18,18,18,18,17,17,17,17,17,17,17,17,17,16,16,16,16,15,15,16,16,16,15,15,15,16,16,11,10.98,10.98,11.35,11.98,12.50,12.90,13.33,13.87,14.37,14.73,14.72,14.50,14.25,14.12,14.03,14.07,14.07,14.03,14,14,14,14,14,14,14,15,15,15,15,15,15,16,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14.97,14.85,14.66,14.50,14.63,14.77,14.87,14.87,14.90,14.98,15.09,15.24,15.38,15.50,15.50,15.37,15.25,15.13,15.10,15.07,15.03,15.08,15.15,15.37,15.63,15.87,15.98,16,16,16,16,16.03,16.12,16.25,16.39,16.51,16.58,16.50,16.36,16.10,15.75,15.35,14.87,14.34,13.72,13.01,12.35,11.75,11.28,11.02,10.99,11.15,11.58,12.12,12.73,13.25,13.60,13.60,13,13,12,10,8,5,2.33,0.74,-1.14,-1.88,-2.63,-3.35,-3.86,-4.13,-4.23,-4.13,-3.79,-3.29,-3.10,-2.66,-2.01,-1.12,-0.28,1.63,7.09,10.36,11.61,13.59,12.58,13.59,13.61,13.62,13.70,13.62,13.25,12.84,9.07,5.47,3.12,0.50,-1,-2.37,-3.50,-3.53,-3.43,-4.39,-4.60,-4.52,-4.17,-3.65,-3.23,-2.92,-2.76,-2.63,-2.29,-2.26,-2.43,-2.48,-1.25,-0.97,0.34,0.50,0.74,2.09,2.47,2.62,5.84,9.11,10.74,10.34,10.83,10.60,10.37,11.26,10.25,9.39,9.73,10.11,10.57,10.98,11.65,11.65,12.34,12.38,12.96,12.88,12.60,12.33,12.10,11.88,11.74,11.62,11.57,11.51,11.53,11.61,11.70,11.77,11.88,12,12.10,12.14,12.21,12.21,12.14,12.12,12.08,12,11.96,11.87,11.84,11.77,11.75,11.73,11.71,11.71,11.73,11.75,11.78,11.86,11.91,12,12.12,12.25,12.37,12.51,12.71,12.88,13.11,13.33,13.57,13.82,14.03,14.27,14.50,14.75,14.96,15.14,15.37,15.59,15.78,16.03,16.27,16.51,16.75,17.03,17.36,17.76,17.96,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,17,17,17,17,17,17,17,17,17,16,16,16,16,16,16,16,17,16,16,15,15,15,16,10.02,10.24,10.45,10.85,11.37,12,12.65,13.32,13.95,14.37,14.60,14.57,14.37,14.22,14.12,14.10,14.12,14.12,14.11,14.07,14.01,14,14,14,14,15,15,15,15,15,15,16,16,15,15,16,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14.96,14.75,14.50,14.28,14.40,14.60,14.71,14.76,14.86,14.95,15.02,15.13,15.25,15.33,15.28,15.25,15.16,15.13,15.12,15.12,15.11,15.12,15.22,15.38,15.62,15.86,15.97,15.99,16,16,16.02,16.07,16.20,16.37,16.51,16.62,16.64,16.57,16.36,16.01,15.62,15.15,14.66,14.11,13.45,12.72,12,11.37,10.87,10.50,10.37,10.48,10.88,11.58,12.35,13.10,13.61,13.86,13,12,11,9,6,2.60,0.87,-0.80,-1.68,-2.38,-3.30,-4.01,-4.50,-4.78,-4.88,-4.78,-4.73,-4.38,-3.89,-3.50,-2.88,-1.99,-1.12,-0.13,3.62,10.32,11.62,12.62,12.62,12.62,13.62,13.66,13.73,13.77,13.46,11.98,9.32,6.78,5.26,3.62,2.15,-0.15,-1.36,-2.40,-2.49,-3.75,-4.89,-4.76,-4.47,-3.88,-3.66,-3.50,-3.25,-3.13,-2.75,-2.93,-3.11,-3,-2.87,-2.53,-2.10,-1.88,-0.67,-0.37,0.08,0.37,2.57,4.78,7.02,8.78,9.47,11.13,10.99,10.86,10.84,10.90,10.23,10.62,11.65,11.65,11.65,12.37,12.38,13.48,13.35,12.87,12.47,12.11,11.82,11.59,11.38,11.25,11.21,11.15,11.20,11.25,11.35,11.47,11.58,11.70,11.77,11.87,11.90,11.89,11.88,11.87,11.83,11.76,11.73,11.66,11.62,11.60,11.57,11.53,11.53,11.58,11.62,11.65,11.75,11.84,11.95,12.07,12.21,12.36,12.50,12.71,12.89,13.12,13.36,13.61,13.87,14.13,14.39,14.64,14.87,15.11,15.28,15.50,15.70,15.87,16.10,16.33,16.53,16.77,17.03,17.34,17.73,17.87,18,18,18,18,18,18,18,18,18,18,18,18,18,18,19,18,18,18,18,17,17,17,17,17,17,17,17,17,17,17,16,16,16,16,16,17,16,16,16,15,15,15,11.24,11.02,10.65,10.62,11.01,11.64,12.46,13.25,13.91,14.33,14.45,14.37,14.25,14.12,14.11,14.12,14.15,14.16,14.12,14.10,14.07,14.07,14.07,14,15,15,15,16,16,15,16,16,16,15,15,16,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14.99,14.95,14.72,14.48,14.25,14.37,14.50,14.59,14.66,14.77,14.89,15,15.08,15.12,15.14,15.14,15.14,15.16,15.24,15.25,15.25,15.22,15.21,15.25,15.38,15.60,15.82,15.95,15.99,16,16.01,16.10,16.22,16.37,16.53,16.70,16.74,16.73,16.62,16.37,16,15.53,15.03,14.51,13.95,13.25,12.50,11.74,11.02,10.46,10,9.66,9.62,10,10.89,11.87,12.86,13.75,14,14,12,9,6,3.82,2.25,0.59,-1.23,-2.10,-2.88,-3.79,-4.50,-5,-5.26,-5.38,-5.60,-5.54,-5.25,-4.68,-4.12,-3.49,-2.63,-1.73,-0.75,2.09,6.82,11.70,12.64,12.64,12.64,12.70,12.73,12.76,12.86,12.72,12.20,11.50,9.97,9.34,7.64,6.23,3.85,1.62,-0.55,-1.64,-2.88,-3.98,-3.86,-3.41,-3,-3,-2.77,-3.63,-3.42,-3.35,-3.41,-3.51,-3.43,-3.26,-2.97,-2.51,-2.23,-2,-1.67,-1.27,-0.78,-0.75,0.37,1.61,2.75,5.86,8.77,10.64,11.53,11.50,11.61,11.72,11.65,11.65,11.65,12.47,12.49,13.50,13.57,13.75,12.82,12.25,11.83,11.47,11.20,11,10.86,10.75,10.75,10.76,10.85,10.96,11.08,11.21,11.34,11.45,11.51,11.59,11.61,11.61,11.60,11.57,11.51,11.50,11.46,11.40,11.37,11.37,11.37,11.38,11.41,11.50,11.58,11.66,11.78,11.91,12.09,12.25,12.45,12.62,12.86,13.09,13.34,13.60,13.87,14.14,14.47,14.75,15,15.25,15.46,15.62,15.83,16,16.15,16.37,16.60,16.78,17.02,17.28,17.65,17.84,17.99,18,18,18,18,18,18,18,18,18,18,18,18,18,18,19,18,18,18,18,17,17,17,17,17,17,17,17,17,17,17,17,16,16,16,17,17,16,16,16,15,15,15,13.57,12.13,11.23,10.72,10.87,11.51,12.45,13.32,13.95,14.23,14.25,14.16,14.10,14.08,14.10,14.12,14.15,14.15,14.12,14.10,14.11,14.14,14.34,14.98,15,15,15,15,15,15,16,16,16,15,15,16,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14.99,14.90,14.74,14.53,14.48,14.50,14.53,14.60,14.65,14.77,14.88,14.98,15,15.02,15.07,15.10,15.13,15.25,15.37,15.46,15.45,15.37,15.32,15.28,15.38,15.58,15.75,15.89,15.99,16.01,16.10,16.22,16.37,16.57,16.75,16.85,16.85,16.82,16.71,16.47,16.01,15.50,14.98,14.45,13.87,13.23,12.49,11.66,10.87,10.14,9.60,9.13,8.87,9.23,10.09,11.35,12.74,13,14,14,11,7,5,2.61,1.01,-0.63,-1.41,-2.28,-3.16,-4.11,-4.78,-5.25,-5.52,-6,-6.16,-6.14,-5.86,-5.27,-4.50,-3.88,-3,-2.13,-1.23,-0.38,4.34,9.87,12.74,12.73,12.74,12.75,12.78,12.86,12.91,12.98,12.50,12.83,12.25,10.61,9.87,9.35,6.91,4.66,1.59,0.39,-0.84,-1.86,-2.63,-2.25,-2.13,-2.13,-1.88,-2.79,-2.63,-2.68,-2.75,-3.78,-3.74,-3.59,-3.26,-2.79,-2.48,-2.25,-1.90,-1.75,-1.47,-1.37,-1.25,-1.02,-0.72,1.37,4.50,7.75,9.99,11.96,11.87,11.85,11.75,11.65,11.65,12.61,12.62,13.70,14.08,13.23,12.59,11.96,11.46,11.07,10.75,10.51,10.37,10.28,10.27,10.33,10.38,10.50,10.63,10.78,10.95,11.03,11.14,11.24,11.27,11.32,11.32,11.28,11.26,11.25,11.23,11.21,11.20,11.16,11.21,11.24,11.27,11.37,11.48,11.60,11.74,11.88,12.09,12.26,12.50,12.74,12.98,13.24,13.50,13.82,14.12,14.41,14.75,15.07,15.33,15.58,15.76,15.96,16.12,16.26,16.46,16.62,16.84,17.02,17.25,17.50,17.75,17.91,18,18,18,18,18,18,18,18,18,18,18,19,18,18,18,18,18,18,18,18,17,17,17,17,17,17,17,17,17,17,17,16,16,16,17,17,17,17,16,16,16,15,15,14.25,13.02,11.75,10.95,10.87,11.50,12.46,13.33,13.86,14.02,14.01,13.98,13.97,13.99,14.03,14.11,14.12,14.12,14.10,14.09,14.12,14.26,14.51,14.76,15,15,15,15,15,15,15,16,16,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14.99,14.99,14.99,14.99,14.99,14.99,14.99,14.89,14.78,14.66,14.65,14.65,14.71,14.72,14.75,14.85,14.90,14.97,15,15,15.01,15.09,15.20,15.36,15.50,15.62,15.62,15.57,15.46,15.39,15.45,15.59,15.75,15.87,16,16.09,16.21,16.37,16.58,16.75,16.89,16.90,16.89,16.87,16.75,16.50,16.10,15.53,14.97,14.39,13.88,13.37,12.72,11.95,11.01,10.12,9.48,9.20,9.20,9.02,8.52,10.75,12.97,13,13,13,10,6,2.87,1.47,0.89,-0.75,-1.50,-2.38,-3.25,-4.17,-4.88,-5.38,-5.87,-6.30,-6.52,-6.50,-6.16,-5.63,-4.77,-4.02,-3.16,-2.36,-1.50,-0.74,1.98,7.53,11.59,12.82,12.82,12.85,12.87,12.96,13,13,12.97,12.25,11.63,11,10.32,9.75,8.34,7.02,4.90,2.75,0.58,-0.41,-0.18,-1.12,-1.10,-1.05,-0.88,-1.87,-1.79,-1.89,-1.93,-3,-3.90,-3.74,-3.42,-3,-2.62,-2.38,-2.41,-2.29,-2.04,-1.86,-1.75,-1.38,-0.90,0.16,1.15,3.23,5.37,8.86,11,11.96,11.91,11.87,11.83,12.78,12.83,13.82,13.89,12.99,12.16,11.50,11,10.59,10.25,10.02,9.87,9.82,9.83,9.87,9.95,10.08,10.22,10.37,10.51,10.66,10.78,10.88,10.98,11,11.02,11.03,11.02,11.01,11,11,11,11,11.02,11.09,11.14,11.25,11.37,11.50,11.66,11.87,12.08,12.27,12.52,12.78,13.08,13.37,13.65,14,14.34,14.65,15.01,15.35,15.62,15.87,16.09,16.25,16.38,16.52,16.71,16.87,17.03,17.24,17.40,17.62,17.76,17.95,17.99,18,18,18,18,18,18,18,18,18,18,19,18,18,18,18,18,18,18,18,17,17,17,17,17,17,17,17,17,17,17,16,16,16,17,18,18,17,16,16,16,16,15,14.37,13.50,12.24,11.23,10.98,11.41,12.26,13.03,13.51,13.70,13.73,13.75,13.83,13.89,14,14.02,14.07,14.07,14.07,14.12,14.21,14.37,14.57,14.75,14.89,14.98,14.99,15,15,15,15.02,15,16,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14.99,14.99,14.99,14.99,14.99,14.99,14.99,14.98,14.90,14.86,14.77,14.77,14.82,14.84,14.85,14.87,14.89,14.96,14.98,14.99,15,15.02,15.12,15.25,15.47,15.63,15.75,15.77,15.73,15.62,15.57,15.58,15.64,15.77,15.89,16.02,16.16,16.36,16.57,16.75,16.87,16.91,16.98,16.96,16.89,16.78,16.51,16.16,15.53,14.95,14.37,13.95,13.58,13.14,12.50,11.66,10.65,10,9.84,10.37,9.62,8.21,9,11,13,13,12,8,5,2.77,1.37,0.90,-0.75,-1.39,-2.25,-3.15,-4.11,-4.78,-5.25,-6,-6.40,-5.63,-6.55,-6.26,-5.74,-4.88,-4.03,-3.13,-2.39,-1.55,-0.93,0.71,6.23,10.62,12.90,12.91,12.97,13,13,13,14,14,12.75,12.23,11.62,10.87,10.33,8.87,7.61,6.50,4.36,3.15,2.12,1.11,0.12,0.14,0.20,-0.77,-0.76,-0.79,-0.88,-1,-2,-2.99,-2.80,-2.50,-3.03,-2.68,-2.79,-2.86,-2.75,-2.43,-2.05,-1.63,-1.38,-1.14,-1,-0.03,0,1.11,4.20,6.52,9.75,11,12,12,12.96,12.91,13.90,13.72,12.57,11.65,10.98,10.46,10.03,9.75,9.52,9.38,9.33,9.36,9.39,9.50,9.62,9.77,9.98,10.13,10.32,10.47,10.59,10.66,10.75,10.77,10.82,10.84,10.84,10.84,10.84,10.85,10.87,10.88,10.96,11.02,11.12,11.25,11.41,11.62,11.82,12.02,12.27,12.57,12.85,13.12,13.46,13.77,14.13,14.50,14.87,15.25,15.61,15.88,16.12,16.33,16.50,16.63,16.76,16.90,17.08,17.25,17.39,17.57,17.71,17.83,17.95,17.99,18,18.07,18.07,18,18,18,18,18,18,19,18,18,18,18,18,18,18,18,18,18,18,18,18,17,17,17,17,17,17,16,16,16,17,17,17,17,17,16,16,16,16,15,14.50,13.78,12.66,11.64,11.15,11.32,11.87,12.50,12.95,13.20,13.37,13.52,13.70,13.83,13.90,13.97,14,14,14.03,14.12,14.25,14.39,14.60,14.76,14.88,14.97,14.99,14.99,15,15,15,15.11,15.09,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14.99,14.99,14.99,14.98,14.97,14.95,14.90,14.89,14.89,14.87,14.83,14.76,14.76,14.82,14.86,14.88,14.91,14.96,14.98,14.99,15,15,15.08,15.20,15.37,15.58,15.75,15.87,15.87,15.86,15.77,15.74,15.74,15.76,15.86,15.96,16.09,16.25,16.47,16.71,16.87,16.95,16.97,16.97,16.97,16.90,16.75,16.49,15.96,15.50,14.86,14.26,13.87,13.73,13.65,13.35,12.57,11.84,11.48,11.62,11.74,9.87,8,8,10,12,12,10,6,3,1.75,1.35,1,-0.64,-1.28,-2.23,-3.02,-4,-4.60,-5.13,-5.86,-6.28,-6.49,-6.42,-6.13,-5.53,-4.67,-3.80,-2.98,-2.35,-2.64,-2.24,-0.63,4.84,10.25,11.85,12.98,13,13,13,13,14,14,13,12.65,12.37,11.62,11.10,9.62,8.37,8.25,7.14,4.77,3.58,2.50,1.57,1.62,0.58,0.40,-0.54,-0.63,0.33,-0.93,-0.99,-1.89,-1.74,-2.41,-1.99,-2.88,-3.09,-3.13,-3,-2.41,-1.85,-1.75,-1.61,-1.38,-1.24,-1.25,-1.22,-1.12,0,2.13,5.36,7.62,12,13,13,13,14,13.16,11.91,10.98,10.32,9.85,9.49,9.24,9.03,8.91,8.87,8.90,8.99,9.11,9.24,9.40,9.62,9.82,10,10.14,10.32,10.40,10.50,10.59,10.62,10.64,10.66,10.70,10.71,10.73,10.75,10.78,10.87,10.95,11.07,11.20,11.36,11.53,11.75,12,12.26,12.57,12.87,13.16,13.50,13.87,14.25,14.64,15.07,15.47,15.83,16.12,16.37,16.57,16.73,16.87,17,17.12,17.25,17.39,17.52,17.64,17.76,17.87,17.96,18,18.03,18.12,18.25,18.75,19,19,19,19,19,18,18,18,18,18,18,18,18,18,18,18,18,18,18,17,17,17,17,17,17,16,16,17,17,17,17,17,17,16,16,16,16,16,14.84,14.25,13.32,12.32,11.60,11.34,11.49,11.85,12.25,12.62,12.99,13.27,13.52,13.73,13.85,13.89,13.95,13.99,14.02,14.12,14.25,14.39,14.58,14.73,14.84,14.89,14.96,14.98,14.98,14.99,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14.99,14.99,14.98,14.96,14.91,14.87,14.82,14.75,14.75,14.75,14.73,14.65,14.62,14.62,14.66,14.75,14.86,14.91,14.97,14.99,14.99,15,15.01,15.12,15.26,15.49,15.66,15.84,15.90,15.96,15.95,15.90,15.88,15.88,15.90,15.96,16,16.12,16.26,16.50,16.75,16.88,16.96,16.98,16.97,16.90,16.82,16.58,16.12,15.70,15.25,14.75,14.12,13.39,13.62,13.84,13.62,13.36,13.70,12.75,12.87,12,10,7,7,10,12,11,7,4,3,1.76,1.36,0.86,-0.78,-1.48,-2.17,-2.92,-3.86,-4.50,-5.11,-5.63,-5.90,-6.13,-6.03,-5.75,-5.14,-4.25,-3.40,-2.92,-2.50,-3.01,-2.62,-1,3.27,8.75,12.32,12.75,12.97,13,14,13,13,14,13,13,12.71,12.25,10.74,10.35,9,8.82,7.72,6.37,5.11,4.01,3.11,2.25,1.90,1.75,0.77,0.75,0.51,0.25,0.21,-0.75,-0.59,-1.25,-0.77,-2.02,-2.25,-2.25,-2.93,-2.13,-1.89,-1.67,-1.54,-1.50,-1.40,-1.37,-1.30,-1.13,-1.17,-0.11,2.15,5.26,8.62,12,13,13,13,12.53,10.86,10.07,9.52,9.20,8.91,8.75,8.61,8.51,8.50,8.50,8.62,8.75,8.89,9.12,9.34,9.51,9.74,9.90,10.09,10.23,10.34,10.40,10.49,10.52,10.59,10.61,10.62,10.64,10.71,10.75,10.82,10.88,11,11.13,11.32,11.50,11.74,11.99,12.25,12.53,12.87,13.21,13.57,13.91,14.34,14.75,15.16,15.61,16,16.28,16.53,16.74,16.88,17.03,17.16,17.28,17.41,17.53,17.64,17.75,17.86,17.89,17.98,18,18.08,18.15,18.34,18.50,18.66,18.97,19,19,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,17,17,17,17,17,17,16,16,17,17,17,17,17,17,16,16,16,16,16,15.21,14.75,14,13.07,12.20,11.58,11.28,11.36,11.65,12.13,12.60,13,13.37,13.61,13.75,13.78,13.87,13.90,14,14.11,14.24,14.37,14.53,14.66,14.77,14.87,14.90,14.96,14.97,14.98,14.99,15,15,15,14.99,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14.99,14.99,14.99,14.97,14.90,14.87,14.77,14.66,14.58,14.49,14.48,14.50,14.48,14.38,14.33,14.34,14.46,14.62,14.76,14.88,14.97,14.99,15,15,15.07,15.16,15.37,15.58,15.75,15.87,15.96,15.99,16,16,16,16.02,16.03,16.07,16.08,16.12,16.25,16.46,16.70,16.87,16.95,16.97,16.91,16.84,16.71,16.25,15.78,15.28,15.10,14.98,14,13,13,14,14,14,14,13,13,12,11,8,7,9,10,9,6,4,2,1.87,1.14,0.61,-0.87,-1.50,-2.01,-2.73,-3.48,-4.13,-4.79,-5.37,-5.60,-5.48,-4.38,-4.11,-4.48,-3.62,-3.13,-2.88,-2.50,-3.23,-2.75,-2.38,1.95,7.37,11.90,12.37,12.62,12.97,13,13,13,13,13,13,13,11.82,11.33,9.89,9.60,8.37,8.25,7.08,6.84,6.75,4.76,3.75,3.45,3.27,2.27,3.36,1.87,1.60,0.47,0.52,0.74,0.10,0.22,-1.04,-1.24,-2.25,-1.61,-1.77,-1.63,-1.54,-1.59,-1.61,-1.42,-1.28,-1.23,-1.14,-1.03,-0.76,-0.11,0.84,4.34,7.75,10,11,12,9.97,9.35,8.91,8.71,8.52,8.40,8.33,8.25,8.22,8.21,8.24,8.37,8.50,8.72,8.89,9.12,9.34,9.53,9.75,9.91,10.10,10.23,10.34,10.40,10.50,10.52,10.59,10.62,10.64,10.71,10.75,10.82,10.88,11,11.12,11.27,11.49,11.71,11.96,12.24,12.51,12.86,13.20,13.57,13.96,14.37,14.82,15.25,15.71,16.11,16.41,16.66,16.87,17.01,17.16,17.33,17.45,17.58,17.64,17.75,17.86,17.88,17.95,17.98,18,18.08,18.14,18.25,18.35,18.40,18.40,18.10,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,17,17,17,17,17,17,16,17,17,17,17,17,17,17,17,17,17,16,16,15.41,15.10,14.48,13.62,12.75,11.90,11.34,11.12,11.35,11.73,12.21,12.71,13.12,13.39,13.53,13.65,13.75,13.85,13.95,14.03,14.20,14.35,14.49,14.62,14.73,14.78,14.86,14.87,14.90,14.91,14.96,14.97,14.97,14.98,14.99,14.99,14.99,14.99,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14.99,14.99,14.98,14.97,14.91,14.89,14.78,14.66,14.58,14.46,14.36,14.25,14.24,14.23,14.13,14.01,13.95,14,14.16,14.41,14.66,14.85,14.95,14.98,14.99,15,15.09,15.24,15.45,15.64,15.83,15.91,15.98,16,16,16.03,16.10,16.13,16.16,16.16,16.14,16.14,16.23,16.37,16.58,16.77,16.89,16.91,16.87,16.72,16.46,16,15.48,15.12,15,14.87,14,13,12,13,13,13,13,13,13,13,12,9,7,7,7,7,4,3,2,1.72,1,0.47,-1,-1.38,-1.89,-2.27,-2.80,-3.49,-4.13,-4.75,-5,-3.88,-2.50,-3.13,-3.53,-2.98,-2.89,-2.63,-2.50,-3.23,-2.91,-2.80,0.46,6.88,10.52,12.07,12.32,12.62,12.98,13,13,13,13,13,12,12,11,10.59,9.25,9.02,8.90,7.89,7.72,7.45,6.25,5.24,5.12,3.97,4,4.86,3.37,2.02,1.87,2,1.15,1.48,0.37,0.08,-1.11,-0.98,-1.12,-1.12,-1.25,-1.38,-1.38,-1.16,-1.01,-0.97,-0.90,-0.88,-0.77,-0.72,-0.68,-0.30,0.85,3.50,5.98,7,8,7.25,7.51,7.75,7.87,7.96,8,8,8,8,8.01,8.09,8.21,8.37,8.59,8.77,9,9.23,9.46,9.65,9.87,10.03,10.21,10.34,10.41,10.50,10.59,10.62,10.66,10.73,10.75,10.82,10.87,10.95,11.02,11.14,11.32,11.49,11.71,11.95,12.22,12.50,12.84,13.15,13.52,13.95,14.37,14.82,15.26,15.73,16.13,16.49,16.75,16.96,17.12,17.27,17.40,17.53,17.65,17.75,17.85,17.88,17.91,17.97,18,18,18.07,18.12,18.15,18.21,18.20,18.12,18.01,17.98,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,16,16,15.38,15.11,14.57,13.84,13,12.15,11.50,11.15,11.12,11.36,11.83,12.34,12.75,13.12,13.36,13.50,13.62,13.74,13.85,13.97,14.11,14.25,14.37,14.50,14.60,14.65,14.74,14.76,14.82,14.84,14.86,14.87,14.90,14.96,14.97,14.98,14.98,14.99,14.99,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14.99,15,14.99,14.99,14.97,14.91,14.88,14.85,14.75,14.62,14.45,14.35,14.25,14.22,14.12,14.09,14,13.86,13.66,13.59,13.66,13.95,14.27,14.60,14.82,14.90,14.97,14.98,15,15.11,15.26,15.50,15.72,15.87,15.96,15.99,16,16,16.03,16.12,16.22,16.25,16.26,16.23,16.15,16.16,16.28,16.49,16.70,16.87,16.87,16.77,16.58,16.25,15.83,15.37,15.02,15,14.87,14.98,13,12,12,12,12,12,12,13,13,12,10,8,5,6,5,4,3,1.83,1.50,1,0.39,-1.05,-1.39,-1.63,-2,-2.24,-2.51,-3.11,-3.75,-4,-2.90,-1.50,-1.90,-1.51,-2.50,-2.49,-2.50,-2.53,-3.43,-3.50,-3.38,-1.13,5.34,8.99,11.39,10.86,12.37,12.75,13,13,13,12,12,12,11,11,10,9.77,9.62,9.48,8.37,8.34,8.09,6.89,6.86,5.90,5.75,5.50,5.35,4.01,3.70,2.50,2.52,2.75,1.76,1.61,0.33,0.14,-0.53,-0.36,-0.63,-0.88,-0.92,-0.79,-0.75,-0.74,-0.73,-0.73,-0.68,-0.65,-0.63,-0.68,-1.01,-0.43,1.07,2.84,4,4,4.51,5.86,6.66,7.20,7.50,7.71,7.83,7.88,7.95,8,8.07,8.13,8.37,8.58,8.76,9,9.24,9.47,9.70,9.88,10.09,10.25,10.38,10.50,10.62,10.70,10.75,10.82,10.85,10.87,10.91,10.98,11.02,11.12,11.23,11.37,11.51,11.73,11.95,12.21,12.49,12.78,13.12,13.50,13.87,14.32,14.75,15.23,15.66,16.12,16.48,16.75,16.98,17.15,17.35,17.50,17.65,17.75,17.85,17.89,17.95,17.98,17.99,18,18.01,18.03,18.09,18.10,18.09,18.02,17.98,17.89,17.87,17.90,18,18,18,17,17,17,18,18,18,18,18,18,18,18,18,17,17,17,17,17,17,17,17,17,17,18,17,17,17,17,16,16,16,15.03,14.75,14.26,13.65,13,12.27,11.64,11.16,10.96,11.07,11.46,11.98,12.41,12.84,13.12,13.34,13.49,13.61,13.73,13.85,13.98,14.11,14.23,14.34,14.40,14.50,14.57,14.62,14.62,14.64,14.70,14.75,14.84,14.89,14.96,14.97,14.98,14.98,14.99,14.99,14.99,14.99,15,15,15,15,15,15,15,15,15,15,15,15,14.99,14.99,14.99,14.98,14.97,14.89,14.78,14.72,14.62,14.53,14.40,14.25,14.15,14.14,14.14,14.10,14,13.85,13.62,13.37,13.25,13.40,13.75,14.15,14.50,14.75,14.86,14.88,14.89,14.97,15.09,15.26,15.50,15.74,15.87,15.96,15.98,15.99,16,16.02,16.12,16.22,16.28,16.33,16.25,16.15,16.13,16.23,16.40,16.62,16.83,16.84,16.71,16.41,16.11,15.72,15.34,15.03,15.10,15.09,14.89,14,13,12,11,11,10,11,12,11,11,10,8,6,5,4,3,3,1.62,1.34,1,0.48,-1,-1.36,-1.61,-1.75,-1.78,-1.88,-1.85,-2.38,-2.65,-2.61,-0.23,0.37,-0.67,-2,-2.17,-2.50,-2.65,-3.88,-3.88,-3.75,-2.50,1.98,7.58,9.87,11.27,10.84,11.50,11.99,12,12,12,11,11,11,10,10,10,10,8.87,8.77,8.75,7.75,7.70,7.61,6.49,6.39,6.11,5.88,4.82,4.50,4.32,3.25,3.12,2.14,2,1.74,0.60,0.91,0.25,-0.17,-0.43,-0.36,-0.37,-0.41,-0.51,-0.60,-0.63,-0.63,-0.62,-0.63,-0.75,-1.18,-1.24,-0.29,0.50,0.99,1,2.50,4.71,5.97,6.75,7.25,7.61,7.82,7.95,8.01,8.11,8.16,8.28,8.49,8.66,8.88,9.11,9.35,9.58,9.78,10,10.23,10.38,10.57,10.70,10.78,10.87,10.96,11,11.02,11.08,11.11,11.12,11.20,11.25,11.35,11.46,11.60,11.75,11.97,12.21,12.47,12.75,13.09,13.41,13.82,14.22,14.64,15.12,15.58,16,16.37,16.65,16.91,17.13,17.37,17.57,17.73,17.83,17.87,17.96,17.99,18,18,18.01,18.02,18.03,18.03,18.02,18,17.91,17.85,17.75,17.71,17.71,17.97,17,17,17,17,17,18,18,18,18,18,18,18,18,18,17,17,17,17,17,17,17,17,17,18,17,17,17,17,16,16,16,16,14.50,14.25,13.85,13.37,12.91,12.37,11.78,11.25,10.87,10.86,11.22,11.65,12.13,12.59,12.90,13.14,13.33,13.46,13.57,13.66,13.78,13.90,14.01,14.12,14.23,14.32,14.37,14.41,14.46,14.48,14.50,14.62,14.75,14.86,14.91,14.97,14.98,14.98,14.98,14.98,14.98,14.98,14.99,14.99,15,15,15,15,15,15,15,15,15,14.99,14.99,14.99,14.98,14.95,14.88,14.77,14.62,14.48,14.38,14.36,14.27,14.24,14.16,14.12,14.08,13.99,13.87,13.66,13.39,13.12,13.02,13.24,13.62,14.07,14.39,14.62,14.72,14.75,14.76,14.86,15,15.24,15.50,15.71,15.84,15.88,15.90,15.91,15.95,15.99,16.08,16.15,16.25,16.25,16.22,16.12,16.12,16.20,16.37,16.60,16.76,16.76,16.61,16.33,16,15.65,15.33,15.03,15.08,15.65,14.84,14,13,12,11,10,9,9,9,9,8,7,6,5,4,4,3,2.87,1.51,1.21,0.90,0.65,-0.79,-1.16,-1.41,-1.61,-1.63,-1.63,-1.50,-1.50,-1.50,-1.50,-0.25,2.12,0.77,-0.53,-2.03,-2.54,-2.89,-4.10,-4.13,-4,-2.67,-0.25,5.20,8.47,9.87,10.37,10.07,10.84,12,11,11,11,10,10,10,10,10,9,9,9,9,8,8,8,6.87,6.82,6.75,6.62,6.50,5.50,5.12,4.87,3.71,2.62,2.59,2.28,1.12,1.13,0.65,0.13,0.13,0.12,-0.01,-0.18,-0.38,-0.50,-0.54,-0.60,-0.61,-0.64,-0.84,-1.26,-1.37,-1.50,-0.74,-0.03,0,2.16,4.26,5.70,6.62,7.26,7.71,7.98,8.14,8.26,8.37,8.45,8.59,8.74,8.89,9.12,9.35,9.57,9.77,10,10.24,10.45,10.62,10.77,10.91,11.02,11.12,11.21,11.25,11.27,11.32,11.34,11.36,11.37,11.41,11.50,11.59,11.70,11.84,12,12.22,12.46,12.73,13,13.35,13.71,14.10,14.50,14.96,15.38,15.82,16.20,16.50,16.77,17.08,17.34,17.52,17.71,17.84,17.89,17.99,18.01,18.03,18.08,18.08,18.08,18.07,18.01,17.99,17.91,17.84,17.71,17.59,17.49,17.41,17.25,17,17,17,17,17,18,18,18,18,18,18,18,18,18,17,17,17,17,17,17,17,17,17,17,17,17,16,16,16,16,16,16,13.95,13.76,13.51,13.26,13,12.57,12,11.37,10.89,10.84,11,11.45,11.91,12.37,12.75,13,13.16,13.28,13.38,13.50,13.61,13.73,13.84,13.91,14.02,14.12,14.23,14.26,14.32,14.35,14.38,14.51,14.66,14.83,14.89,14.95,14.96,14.97,14.97,14.97,14.98,14.98,14.98,14.99,14.99,15,15,15,15,14.99,14.99,14.99,14.99,14.99,14.99,14.97,14.91,14.88,14.76,14.61,14.39,14.25,14.22,14.24,14.25,14.25,14.21,14.11,13.98,13.78,13.62,13.46,13.16,12.89,12.84,13.03,13.47,13.87,14.20,14.37,14.45,14.49,14.53,14.66,14.87,15.12,15.38,15.60,15.72,15.76,15.77,15.82,15.84,15.87,15.98,16.08,16.13,16.15,16.12,16.09,16.10,16.20,16.37,16.59,16.75,16.73,16.50,16.25,15.96,15.62,15.32,15.07,14.96,14.62,13.98,13.03,13,12,11,10,10,10.01,9.08,8.09,8.08,7.01,6,5,5,4,3,2.83,1.46,1.12,0.86,0.62,-0.54,-0.88,-1.15,-1.30,-1.38,-1.37,-1.25,-1,-1,-0.87,-0.55,1.48,1.12,-0.50,-2.13,-2.65,-3,-4.14,-4.16,-4.01,-3.74,-1.40,2.71,5.95,8.37,8.96,8.72,9.50,10.99,11,10,10,10,10,10,10,9,9,9,9,8,8,8,8,7,7,7,7,7,6.87,5.83,5.59,4.38,4.36,3.37,2.89,1.51,1.39,1,0.62,0.59,0.40,0.16,-0.09,-0.29,-0.49,-0.55,-0.63,-0.63,-0.68,-0.88,-1.29,-1.28,-1.25,-0.68,0.12,1.37,2.88,4.57,5.87,6.84,7.51,8,8.33,8.51,8.64,8.75,8.84,8.97,9.10,9.25,9.46,9.65,9.87,10.11,10.33,10.51,10.74,10.90,11.09,11.23,11.35,11.45,11.50,11.57,11.60,11.62,11.62,11.62,11.62,11.64,11.70,11.75,11.84,11.95,12.09,12.25,12.47,12.70,12.97,13.25,13.59,13.91,14.33,14.74,15.13,15.53,15.90,16.25,16.59,16.90,17.21,17.46,17.62,17.78,17.89,18,18.08,18.11,18.12,18.12,18.12,18.09,18.02,17.98,17.87,17.74,17.58,17.38,17.25,17.12,17.03,16.99,17,17,17,17,18,18,18,18,18,18,18,18,18,18,17,17,17,17,17,17,17,17,17,17,16,16,16,16,16,16,15,13.59,13.53,13.50,13.49,13.25,12.86,12.24,11.59,11.03,10.77,10.88,11.27,11.76,12.25,12.62,12.87,13.03,13.14,13.24,13.33,13.40,13.51,13.62,13.75,13.87,14,14.12,14.21,14.25,14.28,14.37,14.50,14.66,14.82,14.88,14.91,14.91,14.95,14.95,14.95,14.96,14.97,14.98,14.98,14.99,15,15,15,14.99,14.99,14.99,14.99,14.99,14.98,14.97,14.91,14.87,14.75,14.62,14.41,14.28,14.22,14.21,14.23,14.26,14.32,14.25,14.11,13.86,13.58,13.34,13.12,12.87,12.63,12.61,12.84,13.24,13.62,13.87,14,14.09,14.16,14.32,14.50,14.75,15.01,15.25,15.40,15.51,15.58,15.60,15.62,15.65,15.75,15.87,15.97,16.02,16.07,16.03,16.03,16.09,16.21,16.38,16.60,16.74,16.66,16.46,16.16,15.89,15.61,15.27,14.95,14.61,14.10,13.25,12.11,12,12,12,12.08,12.12,12.20,11.22,11.23,10.22,9.20,7.12,6.08,6,5,4,2.76,1.39,1.10,0.83,0.62,-0.53,-0.67,-0.76,-1.03,-1.17,-1.23,-1.01,-0.75,-0.27,-0.37,-0.25,0.70,1.37,-0.41,-2.11,-2.61,-2.88,-4.04,-4.04,-4.10,-3.98,-3,-0.88,3.36,4.75,6.35,7.12,8.11,9.97,10,10,10,10,10,10,9,9,9,9,8,8,8,8,8,7,7,7,7,7,7,6,6,5,4.87,3.75,3.51,2.14,1.88,1.32,1,0.86,0.60,0.25,-0.05,-0.35,-0.51,-0.64,-0.67,-0.75,-0.79,-1,-1.36,-1.17,-1.09,-0.52,0.60,2.03,3.62,5.15,6.37,7.27,7.99,8.49,8.82,9.01,9.15,9.25,9.37,9.48,9.58,9.73,9.88,10.09,10.27,10.49,10.70,10.88,11.10,11.25,11.45,11.59,11.70,11.77,11.87,11.89,11.95,11.96,11.95,11.95,11.91,11.90,11.91,11.96,12,12.08,12.16,12.33,12.49,12.66,12.89,13.14,13.46,13.75,14.11,14.48,14.85,15.23,15.60,15.95,16.28,16.63,17,17.26,17.49,17.66,17.87,17.99,18.10,18.12,18.16,18.21,18.16,18.12,18.08,17.98,17.83,17.62,17.41,17.22,17.03,16.95,16.88,16.91,16.97,17,17,18,18,18,18,18,18,18,18,18,18,18,17,17,17,17,17,17,17,17,17,16,16,16,16,16,16,15,15,13.60,13.66,13.86,13.84,13.65,13.24,12.51,11.75,11.13,10.82,10.86,11.24,11.71,12.14,12.52,12.78,12.96,13.02,13.11,13.15,13.25,13.37,13.50,13.62,13.77,13.91,14.07,14.14,14.24,14.33,14.40,14.57,14.71,14.82,14.87,14.87,14.87,14.87,14.88,14.89,14.91,14.96,14.97,14.98,14.98,14.99,14.99,14.99,14.99,14.99,14.99,14.98,14.97,14.96,14.90,14.87,14.76,14.62,14.47,14.34,14.25,14.24,14.24,14.25,14.32,14.35,14.26,14.07,13.75,13.37,13,12.73,12.49,12.35,12.37,12.62,12.97,13.25,13.46,13.61,13.75,13.96,14.14,14.40,14.70,14.91,15.12,15.25,15.32,15.35,15.37,15.38,15.47,15.59,15.74,15.87,15.97,16,16,16.01,16.10,16.24,16.45,16.62,16.74,16.62,16.39,16.12,15.86,15.57,15.25,14.87,14.37,13.77,13,12.12,12,13,13.11,13.21,13.25,13.32,13.34,12.35,11.34,9.32,8.25,7.21,6.11,5,4,2.83,2.45,1.11,0.85,0.62,0.48,-0.86,-1.12,-1.26,-1.37,-1.35,-1.18,-0.93,-0.63,-0.15,0.12,0.12,0.72,-0.03,-0.75,-2.30,-2.63,-3.77,-4.05,-4.23,-4.38,-4.40,-3.30,-0.05,3.36,4.90,4.64,6.62,8.50,8.99,9,9,9,9,9,9,9,9,8,8,8,8,8,8,7,7,7,7,7,7,6,6,6,5,4,4,2.63,2.33,1.50,1.16,0.91,0.53,0.13,-0.15,-0.47,-0.65,-0.79,-0.87,-0.88,-0.99,-1.25,-1.26,-1.09,-0.91,-0.29,1,2.62,4.35,5.86,6.98,7.91,8.61,9.10,9.40,9.62,9.76,9.87,9.97,10.03,10.14,10.25,10.39,10.59,10.75,10.95,11.12,11.33,11.50,11.65,11.83,11.97,12.08,12.15,12.24,12.26,12.32,12.32,12.28,12.26,12.25,12.23,12.21,12.20,12.22,12.25,12.32,12.39,12.51,12.70,12.87,13.09,13.33,13.59,13.87,14.16,14.50,14.86,15.21,15.57,15.91,16.28,16.66,17,17.26,17.51,17.75,17.95,18.09,18.14,18.23,18.25,18.25,18.20,18.11,18,17.78,17.57,17.32,17.09,16.87,16.78,16.84,16.96,17.12,17,18,18,18,18,18,18,18,18,18,18,18,18,17,17,17,17,17,17,17,17,16,16,16,16,16,16,15,15,15,13.98,14.12,14.32,14.33,14.12,13.62,12.75,11.96,11.25,10.86,10.87,11.22,11.65,12.12,12.50,12.75,12.88,12.97,13,13.03,13.12,13.25,13.39,13.58,13.75,13.88,14.02,14.13,14.25,14.36,14.48,14.62,14.73,14.77,14.82,14.82,14.78,14.78,14.83,14.86,14.88,14.91,14.96,14.97,14.98,14.98,14.99,14.99,14.99,14.99,14.98,14.97,14.95,14.89,14.86,14.75,14.62,14.49,14.35,14.26,14.25,14.25,14.25,14.26,14.32,14.32,14.22,13.99,13.62,13.16,12.72,12.37,12.15,12.12,12.25,12.50,12.76,12.99,13.13,13.37,13.62,13.91,14.21,14.47,14.71,14.88,15,15.10,15.12,15.14,15.15,15.21,15.27,15.45,15.62,15.77,15.89,15.98,16,16.01,16.12,16.27,16.50,16.66,16.75,16.62,16.37,16.08,15.76,15.48,15.15,14.78,14.37,13.50,13.12,12.84,13,13.11,13.22,13.27,13.37,13.38,13.40,12.45,10.40,9.38,9.37,8.27,7.22,6.11,5,3.87,2.50,2.15,0.88,0.70,0.24,-0.14,-1.39,-1.60,-1.63,-1.62,-1.48,-1.25,-0.89,-0.49,0.12,0.87,0.37,0.57,-1.13,-1.75,-2.18,-3.64,-4.13,-4.50,-4.64,-4.66,-3.55,-2.30,0.09,1.62,3.37,5.34,7.12,7.65,9,9,9,9,9,9,9,8,8,8,8,8,8,7,7,8,7,7,7,7,6,6,6,5,4,4,3,2.63,1.84,1.09,0.72,0.33,0,-0.28,-0.55,-0.79,-1,-1.10,-1.15,-1.30,-1.36,-1.16,-1,-0.78,-0.03,1.37,3.12,4.91,6.50,7.71,8.70,9.33,9.76,10.10,10.28,10.45,10.52,10.61,10.70,10.75,10.87,10.99,11.12,11.26,11.45,11.62,11.76,11.95,12.10,12.24,12.36,12.47,12.57,12.62,12.65,12.70,12.70,12.65,12.62,12.60,12.53,12.50,12.48,12.46,12.46,12.48,12.51,12.62,12.73,12.86,13.01,13.22,13.40,13.63,13.87,14.14,14.46,14.77,15.12,15.50,15.88,16.27,16.64,17,17.27,17.60,17.83,18.01,18.13,18.24,18.32,18.28,18.25,18.12,18,17.75,17.49,17.21,16.97,16.78,16.75,16.85,17.03,17.28,17.91,18,18,18,18,18,18,18,18,18,18,18,17,17,17,17,17,17,17,17,16,16,16,16,16,16,15,15,15,14,14.60,14.74,14.83,14.78,14.51,13.85,12.96,12.10,11.34,10.87,10.87,11.22,11.64,12.12,12.50,12.75,12.87,12.91,12.97,13,13.09,13.21,13.37,13.57,13.75,13.88,14.02,14.13,14.25,14.37,14.50,14.62,14.70,14.73,14.72,14.66,14.65,14.66,14.72,14.76,14.85,14.88,14.95,14.97,14.97,14.98,14.99,14.99,14.98,14.98,14.97,14.95,14.89,14.85,14.75,14.62,14.50,14.37,14.26,14.25,14.25,14.25,14.25,14.25,14.25,14.22,14.10,13.85,13.47,13,12.58,12.13,12,12.10,12.35,12.62,12.85,12.98,13.10,13.38,13.75,14.12,14.38,14.62,14.77,14.89,14.99,15,15.02,15.02,15.03,15.09,15.15,15.33,15.51,15.73,15.87,15.96,15.99,16.02,16.12,16.33,16.52,16.73,16.75,16.62,16.35,15.99,15.64,15.35,15.03,14.73,14.25,13.78,13.36,13.13,13.08,13.21,13.27,13.37,13.45,12.49,12.50,11.50,10.50,11.49,11.45,10.37,8.27,6.21,5.08,4,3.62,2.26,2,0.50,0,-0.37,-0.63,-1.75,-1.85,-1.77,-1.65,-1.41,-1.13,-0.64,0,0.87,0.73,-0.01,0.34,-1.30,-2.10,-3.79,-4.26,-4.61,-4.75,-4.77,-4.73,-3.50,-2.13,0.45,2.15,5.11,5.75,7.34,7.62,7.65,7.58,7.58,7.65,7.87,8,8,8,8,8,8,7,7,7,8,7,7,7,6,6,6,5,5,4,4,3,3,2.38,0.64,0.23,0.09,-0.17,-0.41,-0.65,-0.90,-1.11,-1.30,-1.55,-1.53,-1.28,-1.12,-0.89,-0.65,0.25,1.77,3.74,5.64,7.27,8.52,9.50,10.09,10.49,10.76,10.98,11.12,11.22,11.26,11.34,11.39,11.50,11.60,11.72,11.84,11.98,12.12,12.25,12.38,12.51,12.63,12.75,12.87,12.96,13,13.03,13.08,13.08,13.03,13,12.96,12.87,12.83,12.75,12.73,12.70,12.66,12.70,12.73,12.77,12.87,13,13.12,13.26,13.41,13.61,13.82,14.07,14.37,14.72,15.09,15.47,15.86,16.24,16.62,16.97,17.34,17.61,17.87,18.07,18.16,18.28,18.28,18.24,18.11,17.98,17.70,17.38,17.11,16.87,16.75,16.76,16.90,17.15,17.50,17.76,18,18,18,18,18,18,18,18,18,18,18,17,17,17,17,17,17,17,16,16,16,16,16,16,15,15,15,14,14,15.25,15.32,15.33,15.21,14.84,14.01,13.12,12.20,11.37,10.90,10.89,11.22,11.64,12.12,12.50,12.75,12.87,12.91,12.96,12.99,13.07,13.20,13.37,13.58,13.75,13.90,14.02,14.13,14.25,14.37,14.48,14.57,14.61,14.60,14.57,14.51,14.50,14.51,14.60,14.70,14.77,14.87,14.90,14.96,14.97,14.98,14.98,14.98,14.98,14.97,14.95,14.89,14.85,14.75,14.62,14.50,14.37,14.28,14.25,14.24,14.24,14.24,14.23,14.21,14.13,14.07,13.90,13.64,13.26,12.84,12.39,12.08,12,12.22,12.59,12.95,13.15,13.27,13.45,13.73,14.09,14.40,14.63,14.78,14.87,14.96,14.99,15,15,15,15,15.01,15.11,15.25,15.46,15.65,15.85,15.95,15.99,16.02,16.13,16.34,16.53,16.74,16.75,16.59,16.25,15.87,15.50,15.22,14.96,14.66,14.27,13.91,13.62,13.24,13.12,13.25,13.37,13.45,12.50,12.51,11.57,10.58,10.57,12.51,13.50,11.45,9.37,7.25,6.12,5,3.83,3.47,1.99,0.37,-0.11,-0.43,-0.67,-1.86,-1.88,-1.88,-1.75,-1.50,-1.15,-0.75,0,0.65,0.78,0.25,0.63,-0.97,-1.92,-3.77,-4.26,-4.60,-4.75,-4.79,-4.75,-4.53,-3.13,-0.60,1.20,3.87,5.34,5.50,5.57,5.82,5.75,5.75,6.87,7.10,7.38,6.77,7,7,7,7,7,7,7,7,7,6,6,6,6,5,5,5,4,4,3,3,1.25,0.59,0.12,-0.30,-0.60,-0.80,-1.03,-1.23,-1.42,-1.55,-1.51,-1.47,-1.34,-1.04,-0.84,-0.40,0.77,2.49,4.57,6.60,8.27,9.50,10.35,10.78,11.13,11.40,11.62,11.75,11.87,11.90,12,12.07,12.12,12.22,12.28,12.38,12.50,12.62,12.74,12.86,12.97,13.08,13.15,13.25,13.34,13.38,13.41,13.46,13.46,13.41,13.37,13.33,13.25,13.15,13.09,13,12.96,12.88,12.87,12.87,12.87,12.91,12.99,13.08,13.14,13.25,13.36,13.50,13.71,14,14.33,14.65,15.01,15.38,15.76,16.14,16.51,16.95,17.25,17.62,17.84,18.02,18.15,18.20,18.12,18,17.87,17.59,17.27,17,16.82,16.75,16.84,17,17.26,17.57,17.78,18,18,18,18,18,18,18,18,18,18,18,17,17,17,17,17,17,16,16,16,16,16,16,15,15,15,15,14,14,15.83,15.77,15.73,15.50,14.96,14.20,13.23,12.25,11.40,10.90,10.88,11.21,11.64,12.12,12.50,12.75,12.88,12.96,12.98,13,13.08,13.21,13.37,13.58,13.75,13.90,14.02,14.12,14.23,14.33,14.38,14.46,14.48,14.45,14.38,14.37,14.36,14.38,14.48,14.60,14.72,14.83,14.88,14.91,14.96,14.97,14.97,14.96,14.97,14.96,14.89,14.85,14.74,14.61,14.48,14.36,14.26,14.24,14.22,14.22,14.22,14.21,14.14,14.11,14,13.87,13.71,13.40,13.02,12.62,12.25,12.07,12.01,12.36,12.84,13.26,13.59,13.75,13.90,14.14,14.45,14.66,14.85,14.91,14.99,15,15.01,15,15,15,15,15,15.08,15.21,15.39,15.62,15.83,15.91,15.99,16.01,16.12,16.32,16.50,16.70,16.70,16.49,16.12,15.71,15.36,15.11,14.89,14.64,14.32,14.02,13.86,13.76,13.20,13.32,13.38,13.49,12.51,12.59,12.61,11.62,11.61,13.59,14.51,12.49,10.38,8.32,7.20,6.01,5,3.71,2,1.37,-0.10,-0.41,-0.66,-1.80,-1.88,-1.98,-1.92,-1.75,-1.38,-0.80,-0.04,0.48,0.86,0.73,0.12,0.40,-1.64,-3.48,-4.10,-4.38,-4.63,-4.68,-4.63,-4.39,-3,-1.39,0.26,1.49,2.59,3.62,3.72,3.99,5.09,5.13,5.25,5.45,5.62,5.97,6.48,6.71,6.70,6.75,5.77,5.87,5.87,5.75,5.75,5.76,4.87,5,5,4.87,4.76,3.75,3.76,2.87,2.77,1.34,0.86,0.59,-0.12,-0.42,-0.75,-1,-1.27,-1.42,-1.50,-1.48,-1.39,-1.38,-1.29,-1.02,-0.74,0.12,1.50,3.35,5.50,7.78,9.50,10.48,11.07,11.38,11.72,11.99,12.20,12.37,12.49,12.52,12.62,12.65,12.74,12.82,12.87,12.97,13.02,13.12,13.22,13.28,13.37,13.48,13.57,13.62,13.72,13.75,13.78,13.83,13.83,13.77,13.75,13.70,13.61,13.50,13.40,13.33,13.24,13.13,13.09,13.02,13,13,13.01,13.03,13.10,13.12,13.15,13.25,13.41,13.73,14.01,14.34,14.62,14.97,15.32,15.65,16.02,16.45,16.77,17.15,17.45,17.75,17.87,17.91,17.88,17.77,17.65,17.38,17.12,16.89,16.75,16.75,16.87,17.09,17.35,17.59,17.77,17.91,18,18,18,18,18,18,18,18,18,18,17,17,17,17,17,16,16,16,16,16,16,15,15,15,15,15,14,14,16.25,16.16,16.01,15.73,15.12,14.28,13.27,12.28,11.39,10.88,10.87,11.16,11.62,12.12,12.50,12.75,12.89,12.98,12.99,13,13.08,13.20,13.36,13.53,13.75,13.88,14,14.10,14.15,14.24,14.27,14.33,14.33,14.27,14.25,14.23,14.24,14.27,14.37,14.50,14.63,14.75,14.87,14.89,14.95,14.96,14.96,14.95,14.91,14.90,14.86,14.75,14.61,14.45,14.28,14.21,14.15,14.14,14.15,14.15,14.15,14.12,14.09,13.99,13.86,13.70,13.45,13.12,12.75,12.37,12.09,11.98,12.03,12.40,12.97,13.49,13.87,14.12,14.34,14.50,14.72,14.87,14.98,15.02,15.10,15.12,15.12,15.11,15.07,15.01,15,15,15.03,15.16,15.37,15.61,15.78,15.90,15.98,16,16.11,16.25,16.39,16.52,16.51,16.27,15.91,15.51,15.23,15.02,14.89,14.64,14.33,14.03,13.99,13.96,14.22,13.34,13.40,13.50,12.57,12.61,13.62,12.62,12.62,13.61,13.57,14.50,12.40,10.34,8.22,7.08,6,4.87,3.12,1.50,0.08,-0.28,-0.53,-1.91,-2.18,-2.30,-2.25,-2.04,-1.67,-1.13,-0.68,0,0.82,1.07,0.59,0.75,-1.26,-3.02,-3.65,-4.11,-4.36,-4.40,-4.30,-4.10,-3.65,-2.12,-1.03,-0.11,1.01,1.98,2.08,2.35,2.50,3.61,3.52,3.51,3.64,3.77,4.12,4.61,4.87,5,5,5.07,5.02,5.12,4.33,4.36,4.45,4.37,4.37,4.39,3.35,3.32,2.37,2.15,1.07,0.86,0.66,0.41,-0.50,-0.87,-1.12,-1.27,-1.40,-1.54,-1.63,-1.50,-1.43,-1.36,-1.25,-1.09,-0.43,0.71,2.20,4.10,6.34,8.64,10.61,11.03,11.50,11.82,12.12,12.45,12.70,12.87,13.02,13.11,13.20,13.25,13.32,13.37,13.41,13.49,13.53,13.61,13.65,13.74,13.78,13.87,13.95,14,14.07,14.12,14.14,14.15,14.15,14.14,14.12,14.03,13.97,13.87,13.75,13.62,13.51,13.41,13.34,13.25,13.20,13.12,13.11,13.09,13.08,13.08,13.12,13.21,13.37,13.61,13.87,14.09,14.33,14.59,14.87,15.20,15.51,15.87,16.25,16.59,16.87,17.21,17.37,17.50,17.50,17.45,17.36,17.12,16.91,16.76,16.72,16.75,16.90,17.12,17.37,17.60,17.75,17.87,18,18,18,18,18,18,18,18,18,18,17,17,17,17,16,16,16,16,16,16,15,15,15,15,15,15,14,14,16.59,16.48,16.25,15.83,15.22,14.37,13.33,12.28,11.39,10.87,10.84,11.12,11.59,12.08,12.49,12.75,12.89,12.97,12.98,13,13.02,13.12,13.28,13.49,13.66,13.84,13.96,14.01,14.10,14.13,14.16,14.21,14.20,14.15,14.13,14.13,14.15,14.24,14.34,14.47,14.61,14.74,14.84,14.88,14.91,14.95,14.95,14.90,14.88,14.87,14.75,14.62,14.41,14.25,14.11,14.02,14.02,14.07,14.10,14.12,14.10,14.03,13.98,13.85,13.64,13.45,13.12,12.78,12.45,12.11,11.87,11.85,12.01,12.38,12.97,13.50,13.98,14.32,14.52,14.72,14.86,14.98,15.08,15.14,15.24,15.26,15.26,15.24,15.14,15.09,15.01,15,15.03,15.15,15.37,15.60,15.77,15.89,15.98,16,16.07,16.14,16.25,16.33,16.25,16,15.70,15.36,15.12,14.98,14.89,14.62,14.28,14.03,14,14.10,14.23,14.35,13.45,13.50,13.58,13.62,12.62,12.62,13.62,13.62,13.58,14.50,14.45,11.35,10.23,8.09,7,5.76,3.36,1.77,1.32,-0.03,-0.65,-2.12,-2.37,-2.48,-2.50,-2.38,-2.04,-1.75,-1.25,-0.64,0.21,1.01,0.91,0.12,0.25,-1.49,-3.13,-3.63,-3.88,-3.98,-3.87,-3.62,-3.25,-2.17,-2.35,-1.40,-0.43,-0.50,0.60,0.87,1.08,1.86,1.76,1.82,1.63,1.72,2,3.51,3.02,3,2.97,4.09,3.37,3.48,3.70,3,2.75,2.62,2.62,2.75,3,2,1.75,0.70,0.49,0.32,-0.75,-0.63,-0.85,-1.28,-1.50,-1.63,-1.63,-1.63,-1.68,-1.61,-1.50,-1.42,-1.35,-0.91,0,1.23,2.74,4.57,6.61,8.63,10.14,11,11.62,12,12.41,12.77,13.10,13.34,13.50,13.61,13.71,13.76,13.84,13.87,13.91,13.98,14,14.03,14.10,14.12,14.16,14.24,14.27,14.35,14.38,14.45,14.49,14.50,14.50,14.50,14.47,14.38,14.28,14.21,14.10,13.97,13.85,13.72,13.59,13.48,13.37,13.27,13.22,13.13,13.10,13.08,13.10,13.20,13.37,13.58,13.77,13.98,14.13,14.32,14.50,14.75,15.01,15.28,15.62,15.90,16.23,16.50,16.75,16.89,16.99,16.98,16.95,16.78,16.65,16.61,16.62,16.75,16.96,17.16,17.37,17.58,17.75,17.87,18,18,18,18,18,18,18,18,18,18,17,17,17,17,16,16,16,16,16,15,15,15,15,15,15,14,14,14,16.78,16.64,16.40,15.90,15.25,14.37,13.34,12.27,11.37,10.83,10.75,11.02,11.50,11.99,12.39,12.70,12.86,12.89,12.90,12.91,12.97,13.02,13.16,13.37,13.58,13.75,13.87,13.97,14.01,14.08,14.11,14.12,14.12,14.11,14.11,14.12,14.14,14.24,14.34,14.47,14.60,14.72,14.82,14.87,14.89,14.90,14.89,14.87,14.84,14.77,14.63,14.46,14.23,14,13.87,13.84,13.86,13.89,13.98,14,14,13.91,13.82,13.62,13.39,13.12,12.77,12.40,12.09,11.78,11.64,11.70,11.91,12.32,12.87,13.41,13.90,14.28,14.58,14.75,14.90,15.02,15.14,15.26,15.37,15.47,15.47,15.38,15.26,15.14,15.08,15.01,15.03,15.15,15.36,15.58,15.75,15.87,15.95,15.98,16,16.03,16.09,16.07,15.95,15.73,15.45,15.21,15.03,14.90,14.77,14.50,14.16,14,13.99,14.08,14.22,14.34,13.40,13.50,13.57,13.61,13.62,13.62,13.62,13.61,13.57,14.50,14.40,13.34,11.22,10.08,8,6.75,4.33,2.98,1.64,0.97,-0.63,-2.05,-2.50,-2.76,-2.88,-3,-2.93,-2.73,-2.25,-1.52,-0.51,0.62,1.07,1.60,1.87,0.12,-2.51,-3.02,-3.25,-3.37,-3.25,-3.18,-3.02,-3.13,-2.42,-2.52,-1.75,-1.86,-0.74,-0.43,-0.55,0.23,0.20,-0.10,-0.23,-0.13,0.14,0.62,1,1.15,2.12,1.25,1.50,1.90,2.12,2.11,1.13,1.01,1.01,1.14,1.40,1.59,0.35,0.23,0,-1.03,-1.11,-1.18,-1.27,-1.49,-1.68,-1.90,-2.01,-1.92,-1.90,-1.78,-1.72,-1.54,-1.12,-0.50,0.40,1.62,3.09,4.73,6.40,7.96,9.33,10.38,11.41,12.09,12.62,13.08,13.41,13.72,13.90,14.02,14.14,14.24,14.27,14.35,14.37,14.39,14.41,14.46,14.48,14.50,14.51,14.57,14.61,14.64,14.71,14.75,14.78,14.83,14.84,14.84,14.76,14.73,14.63,14.53,14.41,14.27,14.13,14,13.86,13.72,13.59,13.47,13.35,13.25,13.15,13.12,13.14,13.25,13.45,13.62,13.83,13.97,14.09,14.20,14.32,14.41,14.61,14.75,15,15.28,15.53,15.82,16.01,16.23,16.36,16.39,16.45,16.37,16.36,16.38,16.51,16.73,16.96,17.16,17.38,17.58,17.74,17.87,18,18,18,18,18,18,18,18,18,18,17,17,17,17,16,16,16,15,15,15,15,15,15,15,14,14,14,13,16.90,16.77,16.48,15.97,15.26,14.37,13.28,12.25,11.37,10.77,10.70,10.90,11.36,11.85,12.25,12.57,12.74,12.78,12.82,12.78,12.83,12.87,13.02,13.24,13.45,13.62,13.77,13.88,13.97,14,14.02,14.07,14.09,14.10,14.12,14.14,14.22,14.27,14.37,14.50,14.62,14.73,14.82,14.87,14.87,14.87,14.87,14.82,14.74,14.62,14.49,14.25,13.98,13.75,13.59,13.51,13.57,13.64,13.75,13.78,13.82,13.74,13.58,13.36,13.07,12.72,12.36,12,11.70,11.48,11.39,11.50,11.77,12.22,12.74,13.27,13.76,14.20,14.50,14.75,14.95,15.10,15.25,15.38,15.51,15.62,15.62,15.52,15.38,15.24,15.12,15.03,15.07,15.14,15.33,15.50,15.71,15.83,15.87,15.89,15.91,15.90,15.88,15.82,15.64,15.47,15.24,15.10,15,14.87,14.70,14.33,13.95,13.83,13.86,13.91,14.20,13.32,13.38,14.49,13.51,13.59,13.61,13.62,13.61,13.59,13.51,13.49,13.38,12.32,11.20,10.01,9,7.75,5.35,4,2.48,0.85,-0.66,-1.38,-1.88,-2.39,-3.78,-3.99,-3.91,-3.68,-3.25,-2.54,-1.63,-0.25,1,1.87,3.14,1.51,-1.10,-2.48,-2.74,-2.88,-2.91,-2.88,-2.79,-3,-3.28,-2.68,-2.92,-3,-1.88,-1.77,-2.02,-1.25,-1.43,-0.75,-0.87,-1.75,-1.50,-1.25,-0.88,-0.54,-0.50,-0.39,-0.13,0.33,0.49,0.37,0.50,0.59,0.60,-0.29,0.01,0,0,-1.13,-1.25,-1.25,-1.51,-2.02,-1.63,-1.61,-1.73,-1.85,-1.93,-2,-1.90,-1.74,-1.51,-1.16,-0.68,-0.11,0.77,1.98,3.33,4.78,6.25,7.59,8.24,9.91,11.27,12.14,12.82,13.33,13.73,14.02,14.26,14.39,14.53,14.62,14.70,14.74,14.75,14.77,14.77,14.78,14.82,14.83,14.84,14.87,14.88,14.95,14.99,15.02,15.09,15.12,15.12,15.12,15.10,15.03,14.98,14.87,14.75,14.62,14.48,14.32,14.12,13.98,13.82,13.63,13.50,13.37,13.25,13.23,13.25,13.38,13.59,13.76,13.95,14.07,14.12,14.20,14.25,14.32,14.37,14.36,14.57,14.74,14.91,15.14,15.36,15.52,15.70,15.78,15.87,15.91,16,16.16,16.39,16.65,16.95,17.16,17.38,17.57,17.72,17.87,18,18,18,18,18,18,18,18,18,18,17,17,17,17,16,16,16,15,15,15,15,15,15,14,14,14,14,13,16.97,16.87,16.48,15.95,15.22,14.27,13.25,12.23,11.33,10.72,10.58,10.75,11.12,11.62,12.02,12.36,12.52,12.61,12.62,12.60,12.61,12.66,12.85,13.07,13.28,13.51,13.71,13.83,13.89,13.98,14,14.03,14.09,14.12,14.15,14.23,14.28,14.37,14.49,14.59,14.65,14.75,14.82,14.86,14.86,14.85,14.78,14.73,14.62,14.47,14.26,13.99,13.65,13.37,13.20,13.11,13.12,13.23,13.36,13.46,13.50,13.40,13.23,12.91,12.61,12.23,11.85,11.50,11.25,11.11,11.12,11.27,11.62,12.03,12.59,13.12,13.62,14.07,14.40,14.72,14.95,15.12,15.32,15.48,15.62,15.71,15.72,15.62,15.48,15.27,15.13,15.07,15.07,15.12,15.25,15.45,15.60,15.71,15.75,15.77,15.77,15.75,15.66,15.58,15.40,15.24,15.10,15.01,14.97,14.86,14.62,14.14,13.62,13.48,13.62,13.76,13.12,13.25,13.37,14.45,14.50,13.51,13.57,13.58,13.57,13.51,13.50,13.45,12.37,12.25,12.12,11,11,8.86,7.40,5.07,3.33,1.71,-0.11,-1.75,-2.55,-3.14,-3.52,-4.66,-4.63,-4.38,-3.91,-3.25,-2.38,-1.24,-0.04,1.12,2.49,2.87,0.37,-1,-2.27,-2.40,-2.50,-2.38,-2.39,-2.74,-3.29,-3.74,-2.98,-3,-2.88,-3,-2.36,-2.51,-2.90,-3.16,-2.28,-2.23,-2.99,-1.89,-1.53,-1.13,-1,-1.88,-1.63,-1.24,-1.05,-1.13,-1.03,-0.75,-0.75,-0.63,-1.47,-1.47,-1.25,-1.49,-1.75,-1.79,-2.13,-2.12,-1.80,-1.68,-1.65,-1.68,-1.72,-1.68,-1.63,-1.50,-1.14,-0.77,-0.35,0.26,1.15,2.32,3.61,4.99,6.37,7.57,8.76,9.99,11.39,12.36,13.07,13.60,14,14.34,14.60,14.74,14.87,14.98,15.01,15.08,15.10,15.11,15.12,15.11,15.11,15.10,15.11,15.12,15.13,15.20,15.24,15.27,15.35,15.37,15.38,15.39,15.38,15.36,15.27,15.20,15.09,14.95,14.77,14.62,14.41,14.25,14.07,13.87,13.66,13.50,13.38,13.36,13.39,13.57,13.75,13.97,14.12,14.25,14.32,14.35,14.35,14.35,14.34,14.36,14.33,14.37,14.50,14.62,14.75,14.88,15.03,15.20,15.33,15.48,15.66,15.96,16.26,16.61,16.89,17.14,17.37,17.51,17.64,17.84,18,18,18,18,17,17,18,18,18,17,17,17,17,17,16,16,16,15,15,15,15,15,15,14,13,13,13,12,16.98,16.82,16.35,15.82,15.10,14.20,13.20,12.15,11.26,10.62,10.38,10.50,10.87,11.32,11.73,12.02,12.23,12.28,12.32,12.28,12.33,12.40,12.61,12.86,13.12,13.39,13.61,13.75,13.86,13.91,14,14.07,14.12,14.16,14.25,14.33,14.39,14.50,14.59,14.64,14.73,14.76,14.82,14.83,14.78,14.75,14.70,14.60,14.46,14.25,14.01,13.65,13.27,12.95,12.65,12.51,12.50,12.58,12.73,12.87,12.97,12.90,12.72,12.37,12,11.62,11.26,10.98,10.76,10.72,10.78,11.01,11.37,11.86,12.38,12.95,13.46,13.90,14.33,14.63,14.89,15.12,15.34,15.50,15.62,15.72,15.73,15.63,15.50,15.32,15.14,15.07,15.02,15.10,15.20,15.33,15.45,15.52,15.59,15.61,15.60,15.53,15.48,15.36,15.24,15.11,15.01,15,14.97,14.85,14.66,14.09,13.37,13.02,13.12,13.14,13.08,13.21,13.27,14.37,13.45,13.49,13.50,13.50,13.50,13.49,13.45,13.37,13.27,13.21,13.08,13,12,10.99,9.57,7.02,4.26,2.48,0.62,-1.37,-2.13,-3.68,-4.01,-4.13,-5.02,-4.76,-4.34,-3.64,-2.78,-1.67,-0.84,0.32,1.77,3.45,3,0.61,-0.67,-1.86,-1.88,-1.79,-2.02,-2.62,-3.23,-3.61,-3.80,-3.88,-2.85,-3.15,-3.50,-3.77,-4.18,-3.43,-3.55,-3.49,-3.37,-3.27,-2.92,-2.50,-2.35,-2.25,-2,-1.68,-1.54,-1.50,-1.40,-2.13,-2,-1.86,-1.75,-1.76,-1.63,-2.25,-2.35,-2.28,-2.26,-2.25,-1.88,-1.73,-1.62,-1.52,-1.50,-1.41,-1.24,-1.02,-0.84,-0.38,0.07,0.65,1.59,2.71,3.99,5.37,6.75,8.09,9.33,10.58,11.75,12.78,13.37,13.87,14.26,14.59,14.83,15,15.12,15.21,15.25,15.28,15.33,15.34,15.34,15.34,15.33,15.33,15.35,15.35,15.37,15.39,15.47,15.50,15.57,15.61,15.63,15.65,15.65,15.62,15.59,15.50,15.37,15.25,15.10,14.90,14.74,14.51,14.32,14.10,13.87,13.70,13.53,13.50,13.57,13.72,13.90,14.13,14.35,14.49,14.57,14.59,14.58,14.52,14.49,14.45,14.38,14.37,14.35,14.35,14.36,14.38,14.50,14.62,14.78,15.07,15.37,15.75,16.14,16.52,16.86,17.12,17.32,17.46,17.57,17.63,18,18,17,17,17,17,17,18,17,17,17,17,17,16,16,16,16,15,15,15,15,15,15,14,13,13,13,13,16.87,16.62,16.09,15.53,14.88,14.08,13.12,12.12,11.22,10.51,10.24,10.26,10.57,10.95,11.32,11.61,11.76,11.86,11.87,11.88,11.96,12.09,12.32,12.62,12.95,13.25,13.49,13.64,13.77,13.88,13.99,14.08,14.13,14.23,14.32,14.38,14.50,14.58,14.63,14.72,14.75,14.76,14.76,14.75,14.73,14.64,14.57,14.40,14.25,14,13.72,13.26,12.83,12.37,12.01,11.78,11.73,11.76,11.88,12.08,12.21,12.20,12,11.71,11.36,11,10.70,10.40,10.27,10.27,10.41,10.72,11.11,11.59,12.12,12.70,13.24,13.74,14.15,14.53,14.86,15.12,15.33,15.49,15.61,15.66,15.66,15.61,15.47,15.27,15.13,15.03,15,15.02,15.11,15.20,15.26,15.35,15.37,15.37,15.37,15.33,15.25,15.16,15.11,15.02,15,15,14.96,14.83,14.66,14.25,13.25,12.47,12.74,12.87,13,13.11,13.22,13.27,13.37,13.38,13.40,13.45,13.40,13.38,13.37,13.27,13.22,13.11,14,14,13,13,11.75,9.12,6.37,3.37,1.34,-0.68,-2.48,-3.99,-4.24,-4.29,-5.24,-4.92,-4.50,-3.87,-2.97,-2.09,-1.25,-0.23,0.75,2.70,3.37,1.01,-0.24,-0.39,-1.50,-1.61,-1.78,-2.36,-2.92,-3.30,-3.52,-3.54,-3.64,-4.16,-3.50,-3.88,-4.26,-4.52,-4.63,-4.54,-4.50,-4.48,-4.10,-3.66,-3.50,-3.40,-3.15,-2.99,-2.87,-2.74,-2.63,-2.37,-2.14,-1.98,-2.88,-2.75,-2.43,-2.48,-2.60,-2.60,-2.40,-2.25,-1.89,-1.63,-1.50,-1.36,-1.15,-0.99,-0.72,-0.41,-0.22,0.03,0.45,1.02,1.96,3.02,4.41,5.89,7.37,8.78,10.12,11.28,12.33,13.15,13.78,14.25,14.61,14.87,15.10,15.25,15.36,15.45,15.49,15.51,15.52,15.53,15.52,15.51,15.50,15.50,15.50,15.51,15.57,15.61,15.64,15.71,15.75,15.83,15.87,15.89,15.89,15.88,15.86,15.76,15.66,15.53,15.39,15.23,15.01,14.83,14.59,14.35,14.10,13.87,13.71,13.62,13.66,13.84,14.07,14.32,14.53,14.73,14.85,14.88,14.88,14.86,14.77,14.71,14.62,14.50,14.40,14.25,14.13,14.10,14.11,14.21,14.37,14.73,15.14,15.62,16.09,16.49,16.82,17.03,17.23,17.36,17.39,17.37,17,17,17,17,17,17,17,17,17,17,17,17,16,16,16,16,16,16,15,15,14,15,14,14,13,13,13,13,16.62,16.20,15.75,15.26,14.72,13.96,13.03,12.08,11.15,10.46,10.10,10.10,10.25,10.53,10.84,11.07,11.21,11.27,11.34,11.37,11.50,11.66,11.98,12.34,12.71,13.02,13.32,13.51,13.70,13.84,13.96,14.08,14.15,14.25,14.37,14.47,14.53,14.62,14.66,14.73,14.74,14.74,14.72,14.66,14.62,14.50,14.37,14.22,14,13.66,13.35,12.83,12.25,11.74,11.27,11,10.87,10.87,11,11.20,11.32,11.33,11.22,10.99,10.71,10.37,10.10,9.87,9.82,9.87,10.03,10.36,10.75,11.25,11.82,12.37,12.96,13.49,13.98,14.39,14.75,15.02,15.25,15.45,15.53,15.61,15.60,15.50,15.37,15.24,15.10,15,14.97,14.98,15,15.08,15.12,15.15,15.20,15.20,15.15,15.12,15.11,15.07,15.01,15,15,15,14.97,14.76,14.48,13.73,12.91,12.37,12.25,12.87,13,13,13.11,13.21,13.25,13.32,13.34,13.35,13.34,13.32,13.25,13.21,13.11,13,13,13,13,13,12.98,11.37,7.47,4.39,3.20,0.20,-2.59,-3,-4.25,-4.30,-5.24,-4.98,-4.42,-3.75,-2.88,-2.25,-1.48,-0.50,0.47,3,2.70,2.36,1.10,-0.12,-1.25,-1.28,-1.41,-1.88,-2.50,-2.88,-3.10,-3.11,-3.51,-4.03,-4.38,-4.75,-5.15,-5.48,-5.54,-5.49,-5.42,-4.38,-4,-3.63,-3.61,-3.50,-3.25,-3.05,-2.93,-2.78,-2.68,-3.41,-3.18,-3,-2.78,-2.80,-2.67,-2.61,-2.55,-2.59,-2.43,-2.16,-2,-1.63,-1.30,-1.13,-0.84,-0.40,0.11,0.52,0.75,0.85,1.08,1.65,2.47,3.74,5.14,6.65,8.20,9.62,10.87,12,12.96,13.70,14.25,14.65,14.97,15.20,15.37,15.49,15.58,15.62,15.66,15.72,15.73,15.72,15.72,15.70,15.66,15.66,15.66,15.70,15.72,15.75,15.82,15.87,15.96,16,16.08,16.12,16.12,16.12,16.11,16.03,15.97,15.85,15.71,15.52,15.35,15.12,14.87,14.61,14.33,14.03,13.85,13.75,13.75,13.89,14.13,14.41,14.72,14.96,15.12,15.23,15.25,15.24,15.16,15.08,14.91,14.75,14.59,14.37,14.13,13.97,13.89,13.95,14.11,14.50,15,15.53,16.02,16.46,16.75,17,17.12,17.23,17.25,17.14,17,17,17,17,17,17,17,17,17,17,17,16,16,16,16,16,16,15,15,14,14,14,14,13,14,14,14,14,16.10,15.75,15.41,15.03,14.53,13.87,12.97,12,11.12,10.47,10.10,10.01,10.10,10.24,10.37,10.50,10.59,10.63,10.73,10.83,11,11.25,11.60,12,12.39,12.77,13.11,13.37,13.58,13.75,13.89,14.03,14.15,14.27,14.38,14.49,14.57,14.62,14.65,14.66,14.66,14.64,14.62,14.57,14.47,14.35,14.16,13.97,13.70,13.32,12.87,12.26,11.63,11.02,10.50,10.12,9.98,9.99,10.13,10.35,10.50,10.53,10.50,10.34,10.11,9.83,9.59,9.41,9.37,9.47,9.64,9.97,10.37,10.85,11.38,11.99,12.59,13.15,13.72,14.20,14.61,14.91,15.15,15.35,15.46,15.50,15.48,15.38,15.25,15.12,15,14.90,14.87,14.89,14.95,14.99,15,15.02,15.03,15.02,15.01,15,14.99,14.98,14.98,15,15.01,15.02,14.96,14.78,14.22,13.38,12.49,12.01,12,12.03,13,13,13,13.08,13.12,13.20,13.22,13.23,13.22,13.20,13.12,13.08,13,13,13,13,13,13,13,12.73,8.73,5.52,3.25,0.26,-1.38,-2.79,-4.10,-4.15,-4,-4.61,-4.01,-3.30,-2.75,-2.13,-1.38,-0.40,0.37,2.87,4,3.75,2.48,1.25,0.13,-0.91,-0.91,-1.25,-1.88,-2.25,-2.50,-2.85,-3.25,-3.75,-4.12,-4.48,-4.90,-5.18,-5.27,-5.18,-5.13,-5.04,-4.65,-4.50,-4.50,-4.40,-4.15,-3.99,-3.87,-3.74,-3.63,-3.37,-3.13,-2.99,-2.80,-2.74,-2.64,-2.54,-2.50,-2.43,-2.39,-2.15,-1.87,-1.63,-1.13,-0.77,-0.38,0.37,1.45,2.08,2.12,1.85,1.88,2.24,3.21,4.46,5.90,7.49,9,10.39,11.65,12.72,13.53,14.21,14.72,15.07,15.32,15.49,15.62,15.71,15.75,15.82,15.84,15.86,15.86,15.86,15.85,15.83,15.82,15.78,15.82,15.83,15.86,15.88,15.96,16.01,16.12,16.20,16.25,16.32,16.36,16.37,16.35,16.28,16.23,16.12,16,15.85,15.64,15.41,15.15,14.87,14.51,14.22,13.97,13.82,13.82,13.91,14.15,14.48,14.82,15.12,15.37,15.51,15.62,15.62,15.58,15.47,15.27,15.08,14.82,14.53,14.25,14,13.87,13.77,14.08,14.50,15,15.53,16.02,16.45,16.74,16.95,17.07,17.12,17.12,17.08,17,17,17,17,17,17,17,17,17,17,16,16,16,16,16,16,16,15,14,14,14,13,13,14,14,14,14,14,15.62,15.35,15.16,14.87,14.46,13.75,12.85,11.91,11.12,10.58,10.27,10.16,10.13,10.12,10.10,10.07,10.03,10.08,10.12,10.25,10.49,10.77,11.16,11.62,12.08,12.50,12.86,13.15,13.41,13.64,13.85,14,14.14,14.26,14.37,14.48,14.52,14.59,14.61,14.62,14.60,14.53,14.50,14.39,14.27,14.12,13.91,13.64,13.33,12.87,12.37,11.70,11,10.34,9.75,9.34,9.15,9.22,9.38,9.62,9.84,9.91,9.90,9.82,9.62,9.39,9.22,9.09,9.02,9.12,9.27,9.59,9.96,10.39,10.91,11.50,12.13,12.75,13.37,13.90,14.37,14.75,15.01,15.22,15.33,15.37,15.34,15.24,15.12,14.98,14.87,14.78,14.77,14.82,14.86,14.88,14.91,14.95,14.95,14.91,14.89,14.87,14.87,14.87,14.89,14.96,15,15,14.95,14.65,14,13.11,12.27,11.33,11.86,12,12,13,13,12,12,12.01,12.08,12.09,12.08,12.01,13,13,13,13,14,13,13,13,13,11.86,9.12,5.87,3.62,0.62,-1.02,-2.49,-3.74,-3.72,-3.40,-4.03,-3.53,-3.13,-2.63,-1.93,-1.14,-0.24,0.50,2.87,5,5,4.90,4.74,2.61,0.50,0.50,-0.63,-1.03,-1.65,-2.13,-2.49,-2.79,-3.36,-3.65,-3.99,-4.49,-4.75,-4.87,-4.75,-4.61,-4.50,-4.28,-4.27,-4.35,-4.25,-4,-3.68,-3.54,-3.50,-3.40,-3.13,-2.92,-2.79,-2.63,-2.50,-2.48,-2.38,-2.28,-2.25,-2.13,-2.03,-1.76,-1.29,-0.88,-0.50,-0.05,0.96,3.10,5.32,3.73,2.89,2.70,3.02,3.89,5.16,6.70,8.23,9.74,11.12,12.32,13.25,14.01,14.60,15.01,15.36,15.59,15.73,15.83,15.87,15.91,15.96,15.97,15.97,15.97,15.96,15.95,15.90,15.89,15.89,15.89,15.91,15.97,16,16.09,16.14,16.25,16.35,16.41,16.50,16.53,16.58,16.58,16.53,16.49,16.39,16.27,16.14,15.98,15.75,15.46,15.11,14.72,14.35,14.02,13.85,13.77,13.88,14.12,14.47,14.84,15.22,15.51,15.75,15.89,15.97,15.91,15.82,15.62,15.37,15.08,14.75,14.48,14.16,14,13.87,14.12,14.58,15.09,15.60,16.09,16.46,16.73,16.88,17,17.03,17.03,17.01,17,17,17,17,17,17,17,17,17,16,16,16,16,16,15,16,15,14,14,14,14,13,14,14,15,15,15,15,15.23,15.12,15,14.75,14.32,13.52,12.71,11.84,11.16,10.84,10.66,10.59,10.48,10.32,10.12,9.90,9.75,9.66,9.70,9.78,10.01,10.36,10.75,11.24,11.72,12.16,12.60,12.97,13.26,13.53,13.76,13.97,14.12,14.25,14.35,14.40,14.48,14.50,14.51,14.50,14.49,14.41,14.35,14.24,14.10,13.88,13.62,13.28,12.87,12.37,11.78,11.11,10.37,9.66,9.09,8.70,8.57,8.64,8.87,9.14,9.38,9.52,9.57,9.50,9.37,9.16,9,8.87,8.83,8.87,9,9.23,9.53,9.96,10.41,11,11.63,12.32,12.97,13.58,14.10,14.50,14.84,15.02,15.13,15.16,15.12,15.03,14.90,14.77,14.70,14.63,14.64,14.71,14.75,14.82,14.84,14.85,14.83,14.78,14.75,14.74,14.73,14.75,14.77,14.84,14.87,14.87,14.87,14.52,13.87,13.10,12.36,11.96,11.84,11.91,12.12,12.27,12.23,12.12,12,12,12,12,12,12,12,13,13,13,14,13,13,12,12,11,8.34,6.25,4.14,2.20,-0.43,-1.88,-2.10,-3.02,-1.80,-3.63,-3.30,-2.93,-2.40,-1.76,-0.92,0.02,0.63,3.10,6.12,6.97,6.99,6,5.87,3.83,1.77,0.75,-0.54,-1.13,-1.63,-2,-2.25,-2.74,-3.05,-3.36,-3.80,-4.13,-4.24,-4.12,-3.79,-3.73,-3.75,-3.93,-4,-3.88,-3.63,-3.24,-3.05,-3.13,-3.03,-2.78,-2.63,-2.50,-2.29,-2.12,-2.04,-2.05,-1.89,-1.73,-1.50,-1.25,-0.84,-0.13,0.83,1.83,2.75,4.13,5.98,7.45,5.34,4.11,3.58,3.75,4.58,5.87,7.35,8.87,10.35,11.65,12.77,13.64,14.34,14.84,15.23,15.51,15.75,15.87,15.98,16.01,16.03,16.03,16.03,16.02,16.02,16.01,16,16,15.99,15.99,16,16,16.07,16.12,16.21,16.27,16.37,16.49,16.59,16.66,16.75,16.77,16.78,16.77,16.75,16.66,16.59,16.46,16.26,16.01,15.70,15.27,14.86,14.41,14.08,13.83,13.74,13.82,14.03,14.38,14.82,15.24,15.62,15.90,16.11,16.20,16.20,16.09,15.87,15.62,15.33,15,14.71,14.45,14.23,14.12,14.36,14.75,15.23,15.71,16.12,16.49,16.73,16.87,16.98,17,17,17,17,17,17,17,17,17,17,17,16,16,16,16,16,15,15,15,14,14,14,14,14,14,14,15,15,15,15,15,15,14.98,14.84,14.60,14.11,13.39,12.61,11.87,11.46,11.34,11.26,11.22,11.07,10.83,10.50,10.13,9.84,9.60,9.48,9.50,9.64,9.97,10.37,10.87,11.37,11.87,12.36,12.76,13.13,13.47,13.72,13.90,14.08,14.21,14.27,14.36,14.38,14.40,14.40,14.38,14.36,14.27,14.16,14.03,13.87,13.62,13.28,12.88,12.41,11.86,11.25,10.51,9.82,9.12,8.60,8.26,8.23,8.37,8.64,8.98,9.23,9.38,9.46,9.40,9.32,9.14,9,8.86,8.75,8.74,8.77,8.96,9.20,9.52,9.95,10.50,11.12,11.82,12.50,13.14,13.74,14.22,14.57,14.78,14.91,14.97,14.90,14.83,14.70,14.58,14.49,14.47,14.50,14.57,14.62,14.66,14.71,14.70,14.63,14.59,14.51,14.50,14.50,14.50,14.57,14.62,14.63,14.62,14.57,14.21,13.63,13.01,12.48,12.11,11.95,11.96,12.02,12.11,12.11,12.01,11.90,11.77,11.50,11.25,11,12,12,13,13,13,13,13,13,12,12,10,8.62,6.61,4.50,2.64,1.07,-0.38,-1.50,-1.54,-2.50,-3.40,-3.25,-2.88,-2.29,-1.53,-0.61,0.22,0.96,3.46,6.46,6.97,7.87,7.87,7.02,6.09,3.88,2.86,0.86,-0.49,-1,-1.38,-1.63,-1.93,-2.39,-2.65,-3,-2.26,-2.38,-3.24,-2.88,-2.88,-3.25,-3.43,-3.50,-3.39,-3.13,-2.67,-2.51,-2.63,-2.41,-2.13,-1.98,-1.76,-1.61,-1.40,-1.29,-1.34,-1.13,-0.61,0.11,0.75,1.88,3.14,4.60,5.75,6.84,8.11,9.12,8.33,6.45,5,4.27,4.37,5.22,6.50,7.87,9.35,10.75,12,13.02,13.86,14.47,14.95,15.32,15.60,15.78,15.96,16.02,16.10,16.12,16.12,16.11,16.10,16.09,16.08,16.03,16.02,16.02,16.02,16.07,16.10,16.12,16.22,16.28,16.38,16.50,16.62,16.74,16.85,16.95,17,17.01,17.01,17,16.95,16.86,16.73,16.51,16.25,15.87,15.40,14.95,14.48,14.07,13.76,13.63,13.71,13.91,14.27,14.74,15.21,15.62,15.98,16.21,16.34,16.35,16.25,16.08,15.83,15.51,15.22,14.91,14.70,14.50,14.49,14.62,14.99,15.38,15.83,16.21,16.50,16.75,16.87,16.97,17,17,17,17,17,17,17,17,17,17,16,16,16,16,16,15,15,15,14,15,15,15,15,14,14,15,16,16,16,16,16,14.87,14.75,14.60,14.35,13.91,13.38,12.75,12.26,12.08,12.03,12.02,11.99,11.84,11.53,11.15,10.72,10.23,9.78,9.49,9.36,9.40,9.64,10.03,10.52,11.09,11.62,12.14,12.62,13.03,13.37,13.64,13.87,14.01,14.12,14.23,14.26,14.32,14.33,14.32,14.26,14.23,14.12,14,13.84,13.60,13.28,12.90,12.48,11.95,11.34,10.70,10,9.34,8.73,8.28,8.11,8.14,8.37,8.72,9.03,9.32,9.49,9.57,9.53,9.47,9.32,9.12,8.98,8.83,8.74,8.71,8.75,8.90,9.16,9.50,10,10.62,11.28,12,12.71,13.33,13.85,14.24,14.50,14.64,14.71,14.64,14.57,14.45,14.34,14.25,14.25,14.28,14.37,14.46,14.50,14.50,14.45,14.35,14.25,14.15,14.12,14.11,14.13,14.21,14.25,14.32,14.34,14.21,13.86,13.37,12.87,12.40,12.11,11.91,11.89,11.97,12,12.01,11.97,11.86,11.72,11.61,11.61,11.78,12.07,12,13,13,13,13,13,13,13,13,12,9,7.12,4.98,3.12,1.52,0.09,-1.09,-1.35,-2.47,-3.42,-3.23,-2.84,-2.25,-1.50,-0.49,0.38,1.37,3.85,6.75,7.87,7.87,7.87,7.87,7.14,7.12,6.02,2.95,1.96,0.75,-0.62,-0.91,-1.13,-1.52,-1.80,-1.93,-1.17,-0.26,-1.14,-2.13,-2.26,-2.63,-2.85,-1.88,-1.75,-1.50,-1.10,-0.88,-0.88,-0.85,-0.80,-0.75,-0.61,-0.52,-0.38,-0.10,0.37,0.65,1.75,3.14,4.27,5.74,7.28,8.82,10.14,11.03,11.84,11.60,9.03,7.15,5.65,4.88,5,5.90,7.01,8.28,9.64,10.99,12.14,13.12,13.87,14.47,14.90,15.26,15.53,15.75,15.89,16,16.09,16.11,16.12,16.12,16.11,16.10,16.09,16.08,16.07,16.07,16.08,16.10,16.12,16.21,16.27,16.37,16.50,16.62,16.75,16.87,17,17.12,17.22,17.25,17.25,17.24,17.16,17.09,16.91,16.71,16.37,15.97,15.49,14.98,14.48,14.01,13.71,13.51,13.57,13.77,14.15,14.62,15.12,15.60,15.97,16.23,16.37,16.40,16.36,16.20,15.97,15.70,15.39,15.13,14.95,14.83,14.78,14.90,15.23,15.59,15.95,16.26,16.53,16.75,16.88,16.98,17,17,17,17,17,17,17,17,17,16,16,16,16,15,15,15,15,15,16,15,15,15,15,14,15,16,16,16,16,16,16,14.66,14.46,14.38,14.22,13.97,13.61,13.32,13.07,12.91,12.87,12.87,12.82,12.63,12.37,11.96,11.40,10.78,10.20,9.66,9.37,9.27,9.46,9.82,10.32,10.87,11.48,12.02,12.53,12.99,13.35,13.62,13.83,13.98,14.08,14.13,14.20,14.22,14.22,14.20,14.13,14.08,13.97,13.78,13.59,13.28,12.96,12.50,12,11.45,10.84,10.15,9.51,8.91,8.46,8.15,8.12,8.27,8.61,8.97,9.32,9.59,9.75,9.85,9.84,9.74,9.60,9.39,9.22,9,8.86,8.74,8.71,8.75,8.90,9.12,9.58,10.13,10.78,11.50,12.22,12.87,13.40,13.86,14.15,14.35,14.39,14.37,14.28,14.16,14.10,14.02,14.02,14.10,14.14,14.22,14.23,14.15,14.07,13.88,13.74,13.62,13.53,13.53,13.61,13.70,13.78,13.86,13.90,13.75,13.41,13,12.60,12.24,11.98,11.83,11.82,11.87,11.95,11.97,11.89,11.82,11.74,11.75,11.88,12.14,12.47,12.75,12.96,13,13,13,13,13,13,13,12,9,7.77,5.62,3.74,2.08,0.62,0.15,-1.13,-2.26,-2.25,-3,-2.63,-2,-1.13,-0.38,0.52,1.40,4.22,6.96,7.28,7.87,7.87,7.87,7.87,7.87,7.22,6.10,5,2,1,0.87,-0.35,-0.42,-0.75,-0.88,0.15,-0.13,-0.43,-1.63,-1.75,-0.75,0,-0.03,0.09,0.37,0.48,0.70,1.12,1.08,1.12,1.27,1.53,1.87,1.02,2.16,3.50,5.09,6.34,7.33,8.33,9.64,11.23,12.64,13.41,13.87,13.66,12.10,9.75,7.72,6.23,5.52,5.84,6.48,7.47,8.61,9.83,11.02,12.12,13,13.75,14.34,14.77,15.12,15.39,15.62,15.77,15.89,15.99,16.01,16.07,16.08,16.08,16.08,16.07,16.07,16.07,16.08,16.10,16.12,16.16,16.25,16.36,16.48,16.62,16.75,16.89,17.03,17.16,17.28,17.39,17.48,17.49,17.46,17.37,17.25,17.07,16.78,16.46,16,15.50,14.99,14.46,13.98,13.62,13.39,13.41,13.64,14.07,14.52,15.07,15.51,15.90,16.22,16.37,16.41,16.37,16.25,16.07,15.83,15.59,15.36,15.16,15.09,15.09,15.16,15.45,15.75,16.03,16.34,16.59,16.76,16.89,16.99,17,17,17,17,17,17,17,17,16,16,16,16,15,15,15,16,16,16,16,16,15,15,15,14,15,16,16,16,16,16,16,14.23,14.24,14.37,14.32,14.21,14.03,13.89,13.83,13.75,13.74,13.71,13.60,13.38,13.10,12.64,12.09,11.37,10.62,9.95,9.47,9.25,9.33,9.63,10.13,10.75,11.37,11.98,12.50,12.97,13.33,13.60,13.77,13.90,14,14.07,14.10,14.11,14.10,14.07,14,13.89,13.75,13.58,13.32,12.97,12.57,12.09,11.52,10.97,10.35,9.71,9.12,8.62,8.27,8.16,8.26,8.58,8.95,9.34,9.71,9.99,10.15,10.25,10.23,10.12,9.96,9.75,9.51,9.27,9.08,8.87,8.75,8.71,8.75,8.87,9.24,9.74,10.36,11.01,11.73,12.37,12.98,13.45,13.77,14,14.10,14.10,14,13.91,13.85,13.78,13.82,13.85,13.87,13.88,13.84,13.71,13.49,13.24,13,12.84,12.75,12.78,12.89,13.07,13.22,13.37,13.37,13.22,12.91,12.60,12.25,11.96,11.74,11.62,11.64,11.75,11.85,11.87,11.85,11.75,11.74,11.83,12.08,12.40,12.78,13.07,13.20,13.07,13,13,13,13,13,13,11,10,8,6.48,4.52,2.77,2.03,0.57,-0.78,-1.97,-1.91,-1.68,-2.25,-1.68,-1.10,-0.22,-0.24,1.50,3,6.37,7.87,7.87,8.50,7.87,8.41,7.51,7.49,6.87,6.85,6,5,2,1,1,1,0.82,0.62,0.48,0.22,0,-0.12,1.87,4,5,7.07,6.02,6.12,5.37,6.12,5.86,6.77,6.11,6.50,5.23,4.36,4.61,7.03,10.12,11.23,11.48,11.98,12.78,13.76,14.62,15.03,14.99,14.02,12.10,10.10,8.15,6.85,6.37,6.40,6.95,7.78,8.82,9.89,10.98,11.97,12.82,13.50,14.10,14.53,14.89,15.20,15.40,15.60,15.73,15.83,15.87,15.95,15.98,16,16,16,16.01,16.02,16.07,16.10,16.12,16.21,16.28,16.40,16.53,16.72,16.87,17.03,17.22,17.36,17.48,17.59,17.66,17.66,17.62,17.50,17.37,17.13,16.85,16.48,16.01,15.50,14.97,14.40,13.90,13.51,13.33,13.33,13.57,13.98,14.48,15,15.48,15.87,16.15,16.35,16.39,16.37,16.26,16.12,15.90,15.73,15.51,15.37,15.32,15.32,15.38,15.62,15.87,16.12,16.37,16.61,16.77,16.89,17,17,17,17,17,17,17,17,17,16,16,16,15,15,15,16,16,17,16,16,16,16,15,14,14,15,16,16,17,16,16,16,14,14.35,14.62,14.66,14.58,14.50,14.48,14.46,14.45,14.45,14.37,14.25,13.99,13.62,13.16,12.57,11.78,10.98,10.20,9.59,9.25,9.25,9.52,10.02,10.65,11.33,11.95,12.50,12.95,13.28,13.57,13.74,13.86,13.90,13.98,13.99,13.99,13.97,13.90,13.85,13.73,13.52,13.27,12.98,12.59,12.12,11.62,11.07,10.49,9.89,9.28,8.78,8.45,8.25,8.33,8.57,8.95,9.36,9.76,10.14,10.46,10.62,10.71,10.64,10.52,10.36,10.12,9.87,9.61,9.35,9.09,8.87,8.75,8.73,8.75,9,9.39,9.96,10.59,11.25,11.89,12.50,13,13.38,13.63,13.76,13.78,13.75,13.66,13.62,13.59,13.58,13.58,13.57,13.48,13.32,13.07,12.73,12.37,12.08,11.87,11.83,11.88,12.08,12.28,12.57,12.73,12.73,12.61,12.37,12.12,11.85,11.61,11.45,11.37,11.46,11.58,11.70,11.75,11.73,11.65,11.65,11.82,12.12,12.50,12.96,13.27,13.47,13.59,13.96,14,14,14,13,13,12,10,9,7,5.33,4.48,2.62,1.10,0.76,-0.41,-1.38,-2.15,-1.92,-1.59,-0.88,-0.98,-0.02,1.82,3.12,5.96,7.87,7.87,7.62,7.28,7.73,6.90,6.87,6.90,7.09,7.40,6.75,5,3,3,3,3,3,3.87,3.82,3.75,4.71,3.70,5.75,9.77,10.87,11.87,10.75,10.62,9.11,11.37,11.34,11.16,10.89,8.70,7.33,7.99,10,12.53,13.84,14.26,14.41,14.75,15.11,15.46,15.60,15,13.87,12.11,10.25,8.62,7.50,6.99,6.91,7.36,8.08,8.96,9.89,10.87,11.75,12.52,13.23,13.77,14.25,14.62,14.90,15.14,15.35,15.50,15.61,15.71,15.75,15.83,15.87,15.89,15.95,15.97,16,16.02,16.09,16.13,16.24,16.35,16.48,16.62,16.82,17,17.16,17.37,17.50,17.63,17.75,17.82,17.84,17.75,17.62,17.40,17.16,16.87,16.48,16,15.50,14.95,14.37,13.87,13.49,13.25,13.26,13.50,13.91,14.41,14.95,15.41,15.84,16.12,16.28,16.37,16.36,16.26,16.13,16,15.85,15.70,15.57,15.50,15.50,15.58,15.74,15.96,16.20,16.40,16.62,16.77,16.90,17,17.03,17.02,17,17,17,17,17,17,16,16,15,15,16,16,16,16,17,16,16,16,15,15,14,14,16,16,16,17,17,17,16,14.12,14.35,15.36,15.03,14.90,14.84,14.83,14.86,14.88,14.91,14.89,14.71,14.38,13.99,13.49,12.86,12.09,11.22,10.37,9.71,9.27,9.22,9.46,9.91,10.58,11.25,11.87,12.45,12.88,13.25,13.50,13.64,13.75,13.82,13.85,13.86,13.85,13.82,13.75,13.62,13.49,13.25,12.96,12.59,12.13,11.63,11.12,10.59,10.03,9.51,9,8.62,8.40,8.40,8.61,8.96,9.37,9.84,10.25,10.62,10.90,11.09,11.13,11.10,10.97,10.75,10.50,10.25,9.95,9.62,9.34,9.07,8.87,8.75,8.71,8.86,9.15,9.62,10.20,10.82,11.46,12.07,12.60,13,13.27,13.46,13.50,13.50,13.45,13.37,13.35,13.32,13.25,13.14,12.98,12.65,12.25,11.77,11.35,10.99,10.75,10.73,10.87,11.12,11.46,11.76,11.98,12.01,11.98,11.83,11.62,11.37,11.20,11.09,11.09,11.20,11.35,11.49,11.53,11.52,11.50,11.50,11.66,12,12.49,12.95,13.35,13.62,13.87,14.20,15,15,14,14,14,13,11,9,7,5.96,4.87,3,1.58,1.25,0,-1.04,-2,-1.74,-1.27,-1.38,-0.40,0.57,1.21,3.15,5.32,7.50,7.36,7.10,6.77,6.59,6.46,6.38,6.46,6.40,6.57,6.87,6.37,5.15,4,5,6,6,7,9,9,8,8,7,9,12,13,13,12.77,12.74,13.40,14.25,14.10,12.97,10.85,9.84,10.38,12.16,14.14,15.14,15.52,15.58,15.61,15.62,15.72,15.59,14.60,13.39,11.88,10.32,8.95,8,7.48,7.38,7.74,8.33,9.07,9.87,10.73,11.50,12.25,12.88,13.46,13.89,14.27,14.61,14.86,15.03,15.23,15.36,15.47,15.57,15.63,15.72,15.76,15.84,15.87,15.95,16,16.08,16.13,16.25,16.37,16.52,16.72,16.89,17.11,17.32,17.50,17.65,17.78,17.87,17.95,17.91,17.84,17.65,17.45,17.16,16.85,16.46,15.99,15.47,14.89,14.36,13.85,13.47,13.25,13.26,13.50,13.89,14.38,14.89,15.37,15.76,16.07,16.23,16.28,16.32,16.25,16.15,16.07,15.95,15.83,15.73,15.65,15.64,15.72,15.83,16,16.21,16.40,16.62,16.77,16.90,17,17.03,17.03,17,17,17,17,17,17,16,16,15,16,16,16,16,17,16,16,16,15,15,14,14,15,15,16,16,17,17,17,17,14.12,14.75,15,15.12,15.03,15,15,15.07,15.12,15.22,15.20,14.97,14.62,14.16,13.63,13,12.25,11.37,10.51,9.78,9.32,9.14,9.34,9.77,10.39,11.09,11.74,12.28,12.75,13.12,13.36,13.50,13.60,13.63,13.64,13.64,13.62,13.59,13.50,13.37,13.16,12.88,12.53,12.12,11.64,11.14,10.62,10.13,9.65,9.25,8.85,8.63,8.61,8.75,9.02,9.41,9.87,10.33,10.75,11.10,11.35,11.50,11.53,11.50,11.36,11.14,10.88,10.61,10.25,9.91,9.60,9.26,9,8.84,8.72,8.76,9,9.36,9.85,10.38,11,11.61,12.13,12.60,12.90,13.12,13.23,13.24,13.21,13.13,13.10,13.01,12.88,12.71,12.37,11.90,11.36,10.76,10.22,9.75,9.52,9.57,9.77,10.12,10.53,10.90,11.15,11.27,11.27,11.20,11.02,10.87,10.73,10.65,10.73,10.87,11.07,11.22,11.28,11.27,11.25,11.28,11.49,11.85,12.33,12.82,13.24,13.57,13.87,14.26,14.75,15,15,14,14,13,11,9,8,5.83,4.23,3.50,1.95,1.52,0.33,-0.75,-1.67,-1.41,-0.76,-0.88,0.03,0.87,1.51,3.12,4.78,7.24,7.10,6.37,6.38,6.37,6.37,6.37,6.37,6.37,6.37,6.37,6.37,6.37,5.50,6.21,6,7,9,11,12,12,11,9,8,9,12,12.90,13.72,14.51,14.50,14.70,14.37,13.26,12.22,11.74,12.62,13.87,15.22,15.84,16,15.95,15.87,15.83,15.75,15.13,14.13,12.96,11.62,10.32,9.23,8.37,7.89,7.84,8.09,8.52,9.14,9.87,10.60,11.32,11.98,12.59,13.12,13.58,13.96,14.25,14.51,14.75,14.91,15.09,15.22,15.34,15.45,15.51,15.62,15.71,15.76,15.86,15.95,16.02,16.13,16.26,16.41,16.60,16.77,17,17.22,17.41,17.62,17.78,17.90,18,18.01,17.98,17.87,17.70,17.45,17.13,16.78,16.38,15.91,15.39,14.87,14.33,13.84,13.47,13.25,13.27,13.50,13.88,14.37,14.87,15.34,15.72,15.99,16.13,16.23,16.25,16.24,16.20,16.12,16.01,15.95,15.87,15.82,15.77,15.82,15.87,16,16.20,16.38,16.61,16.75,16.89,17,17.03,17.07,17,17,17,17,17,16,16,16,16,16,16,16,17,17,16,16,16,15,15,15,15,15,16,16,16,16,17,17,17,14.89,14.87,15,15.08,15.11,15.11,15.11,15.13,15.24,15.27,15.25,15.02,14.71,14.25,13.75,13.12,12.37,11.51,10.64,9.88,9.35,9.11,9.20,9.58,10.13,10.82,11.47,12.02,12.50,12.87,13.11,13.25,13.35,13.37,13.37,13.37,13.35,13.27,13.16,13,12.76,12.47,12.08,11.62,11.13,10.63,10.16,9.75,9.37,9.09,8.87,8.87,8.98,9.23,9.57,9.98,10.39,10.84,11.22,11.50,11.75,11.87,11.89,11.85,11.73,11.50,11.24,10.91,10.58,10.22,9.84,9.48,9.14,8.90,8.75,8.73,8.86,9.12,9.50,10,10.57,11.12,11.66,12.14,12.52,12.77,12.91,12.98,12.96,12.87,12.82,12.66,12.49,12.15,11.71,11.10,10.40,9.72,9.03,8.57,8.36,8.40,8.70,9.12,9.59,10,10.32,10.49,10.53,10.51,10.41,10.27,10.20,10.20,10.28,10.50,10.72,10.88,10.99,11,10.98,11,11.23,11.60,12.08,12.58,13,13.36,13.70,14.02,14.41,15,15,15,14,13,11,10,8,5.73,4.12,3.57,2.11,1.76,0.50,-0.53,-1.49,-1.13,-0.36,-0.68,0.21,1,1.73,2.99,3.37,6.37,6.77,6.38,6.37,6.37,6.37,6.37,6.37,6.37,6.37,6.37,6.37,6.37,6.37,6.37,6.70,7,9,11,13,13,13,11,10,8,9,11.12,13.64,14.48,14.73,14.83,14.50,13.95,13.26,13.51,14.24,15.16,15.90,16.21,16.12,16,15.85,15.74,15.59,14.52,13.61,12.50,11.37,10.28,9.38,8.70,8.28,8.22,8.37,8.75,9.25,9.87,10.50,11.12,11.74,12.28,12.78,13.25,13.62,13.95,14.22,14.45,14.62,14.78,14.96,15.10,15.22,15.34,15.46,15.57,15.64,15.76,15.87,16,16.13,16.28,16.48,16.64,16.87,17.09,17.32,17.51,17.73,17.88,18,18.08,18.09,18,17.87,17.65,17.39,17.10,16.74,16.34,15.87,15.37,14.84,14.32,13.84,13.48,13.26,13.28,13.50,13.87,14.32,14.78,15.25,15.62,15.87,16.03,16.13,16.20,16.22,16.20,16.14,16.12,16.03,16,15.95,15.89,15.89,15.91,16.01,16.16,16.37,16.58,16.75,16.87,16.98,17,17.01,17,17,17,17,16,16,16,16,16,16,16,17,17,17,16,16,16,15,15,15,15,15,16,16,16,16,16,17,17,15,15,15,15.09,15.12,15.12,15.12,15.15,15.23,15.25,15.21,15,14.71,14.28,13.82,13.22,12.50,11.65,10.82,10,9.38,9.03,9.01,9.28,9.78,10.40,11.03,11.62,12.10,12.46,12.71,12.86,12.91,12.98,12.99,12.98,12.95,12.87,12.75,12.57,12.27,11.96,11.52,11.09,10.62,10.14,9.75,9.41,9.22,9.03,9.11,9.25,9.48,9.76,10.12,10.52,10.95,11.33,11.64,11.90,12.12,12.22,12.23,12.14,12,11.78,11.51,11.21,10.84,10.45,10.01,9.62,9.26,8.98,8.75,8.64,8.71,8.87,9.20,9.62,10.11,10.63,11.20,11.70,12.12,12.40,12.61,12.66,12.64,12.59,12.46,12.25,11.99,11.57,10.98,10.25,9.49,8.66,7.98,7.49,7.23,7.25,7.62,8.12,8.62,9.07,9.39,9.62,9.75,9.76,9.70,9.62,9.59,9.63,9.82,10.03,10.32,10.50,10.62,10.62,10.62,10.72,10.91,11.28,11.75,12.25,12.66,13.02,13.37,13.72,14.07,14.25,15,15,14,14,12,10,8,5.70,4.07,3.45,2.87,2.51,1.49,-0.53,-1.48,-0.91,-0.35,-0.65,0.24,1.01,1.75,2.75,3,5.52,6.37,6.37,6.37,6.37,6.41,6.50,6.59,6.65,6.75,6.77,6.75,6.66,6.53,6.37,6.37,7.77,9,11,13,13,13,13,12,12,10,10.16,12.62,13.57,14.32,14.84,14.89,14.70,14.60,14.77,15.37,15.95,16.32,16.28,16.12,15.86,15.62,15.37,14.73,14,13.10,12.13,11.20,10.32,9.53,8.99,8.63,8.53,8.65,8.97,9.37,9.87,10.45,11,11.53,12.07,12.52,12.97,13.33,13.63,13.90,14.13,14.36,14.51,14.70,14.85,15,15.12,15.25,15.39,15.52,15.66,15.83,15.98,16.13,16.33,16.50,16.73,16.95,17.14,17.38,17.62,17.78,17.97,18.08,18.12,18.10,18,17.84,17.62,17.36,17.01,16.64,16.25,15.82,15.33,14.83,14.32,13.86,13.50,13.28,13.27,13.48,13.82,14.24,14.70,15.12,15.49,15.75,15.95,16.07,16.13,16.20,16.22,16.21,16.20,16.14,16.11,16.07,16,15.99,15.99,16.03,16.15,16.36,16.52,16.73,16.86,16.95,16.99,17,17,17,17,17,16,16,16,16,16,16,17,17,17,17,16,16,15,15,16,16,16,16,16,17,17,17,16,16,16,15,15,15,15.12,15.21,15.13,15.12,15.12,15.14,15.15,15.12,14.96,14.70,14.35,13.88,13.34,12.62,11.85,11,10.16,9.50,9.03,8.88,9.02,9.41,9.97,10.53,11.09,11.52,11.87,12.12,12.26,12.36,12.38,12.40,12.39,12.37,12.33,12.20,12,11.72,11.36,10.96,10.50,10.10,9.73,9.38,9.23,9.20,9.25,9.47,9.73,10.01,10.37,10.74,11.11,11.47,11.78,12.08,12.27,12.46,12.50,12.50,12.40,12.25,12.01,11.75,11.39,11,10.62,10.16,9.75,9.36,9,8.73,8.57,8.51,8.62,8.86,9.21,9.62,10.12,10.64,11.15,11.62,12,12.25,12.34,12.32,12.21,12,11.75,11.37,10.86,10.16,9.37,8.59,7.75,7.08,6.50,6.25,6.37,6.73,7.21,7.65,8.12,8.47,8.75,8.87,8.89,8.87,8.86,8.87,9,9.24,9.50,9.78,10,10.13,10.21,10.25,10.36,10.60,10.97,11.40,11.87,12.28,12.65,13,13.37,13.70,14,14,15,15,14,13,11,8,6.73,5.01,4.37,3.83,2.47,1.37,-0.61,-1.39,-0.77,-0.25,-0.60,0.14,0.90,1.58,2.51,3.07,4.46,6.37,6.37,6.37,6.47,6.58,6.73,6.87,7.03,7.16,7.24,7.23,7.12,7,6.86,7,8.48,10,12,13,14,14,15,15,14,13,12.23,11.40,12.61,13.99,14.74,15.23,15.40,15.41,15.62,15.96,16.26,16.45,16.28,15.99,15.61,15.25,14.87,14.21,13.47,12.66,11.85,11.01,10.33,9.71,9.25,8.97,8.87,8.96,9.20,9.52,9.97,10.45,10.91,11.41,11.88,12.35,12.74,13.09,13.37,13.64,13.87,14.10,14.26,14.46,14.62,14.76,14.91,15.10,15.25,15.39,15.59,15.75,15.95,16.12,16.34,16.53,16.75,17,17.24,17.46,17.65,17.86,18,18.10,18.12,18.09,17.97,17.77,17.57,17.26,16.96,16.60,16.22,15.76,15.33,14.84,14.35,13.88,13.51,13.32,13.26,13.40,13.73,14.12,14.57,14.99,15.35,15.62,15.84,15.99,16.10,16.15,16.23,16.25,16.25,16.25,16.23,16.15,16.12,16.08,16.02,16.09,16.20,16.35,16.51,16.71,16.85,16.90,16.97,16.99,16.99,17,17,17,16,16,16,16,16,17,17,17,17,17,16,16,15,16,16,16,16,16,16,17,17,17,17,16,16,15,15,15,15.09,15.12,15.11,15.09,15.09,15.09,15.08,15.01,14.88,14.71,14.38,14,13.48,12.83,12.07,11.25,10.40,9.71,9.14,8.87,8.87,9.12,9.52,10,10.50,10.89,11.23,11.41,11.57,11.62,11.66,11.70,11.71,11.70,11.62,11.50,11.33,11.03,10.73,10.36,9.98,9.62,9.34,9.15,9.15,9.26,9.57,9.88,10.25,10.62,10.98,11.33,11.63,11.96,12.23,12.45,12.62,12.73,12.75,12.72,12.61,12.40,12.16,11.87,11.51,11.12,10.72,10.25,9.78,9.37,8.98,8.63,8.41,8.33,8.35,8.50,8.75,9.12,9.59,10.07,10.58,11.03,11.50,11.78,11.91,11.88,11.75,11.49,11.12,10.63,10.02,9.33,8.52,7.73,6.97,6.24,5.75,5.58,5.62,5.95,6.35,6.76,7.16,7.52,7.76,7.89,7.96,7.98,8,8.10,8.26,8.53,8.87,9.15,9.40,9.59,9.66,9.76,9.95,10.22,10.60,11.02,11.49,11.89,12.28,12.66,13.07,13.41,13.75,14,14,14,14,13,11,9,6.77,5.11,4.46,2.95,1.61,0.46,-0.66,-1.35,-0.79,-0.25,-0.64,0.03,0.75,1.50,2.27,3,4.38,6.13,6.37,6.45,6.59,6.78,7.03,7.28,7.50,7.63,7.74,7.76,7.76,7.75,7.91,8.33,9.25,11.83,13,14,14,15,15,15,14,14,13.75,13.51,13.28,13.82,14.62,15.38,15.75,15.85,16.02,16.26,16.48,16.48,16.25,15.83,15.37,14.90,14.38,13.75,13.03,12.34,11.62,10.97,10.37,9.87,9.49,9.25,9.15,9.25,9.45,9.74,10.11,10.50,10.96,11.37,11.82,12.22,12.59,12.89,13.21,13.46,13.66,13.87,14.08,14.25,14.39,14.59,14.75,14.90,15.10,15.26,15.48,15.65,15.87,16.11,16.34,16.58,16.82,17.03,17.26,17.50,17.71,17.87,18,18.10,18.11,18.03,17.89,17.72,17.49,17.22,16.87,16.53,16.16,15.77,15.36,14.87,14.40,13.98,13.60,13.35,13.25,13.37,13.62,14,14.40,14.84,15.21,15.50,15.74,15.89,16.03,16.14,16.25,16.28,16.35,16.35,16.33,16.26,16.22,16.14,16.12,16.12,16.23,16.37,16.52,16.71,16.85,16.90,16.96,16.98,16.99,17,17,17,16,16,16,16,17,17,17,17,17,17,16,16,16,16,16,16,16,16,16,16,17,17,17,16,16,15,15,15,15,15.02,15.02,15.02,15.01,15.01,15,14.98,14.87,14.74,14.49,14.12,13.64,13.07,12.35,11.57,10.75,10.01,9.40,9,8.87,8.97,9.23,9.59,9.96,10.27,10.52,10.70,10.77,10.84,10.86,10.87,10.87,10.87,10.85,10.75,10.60,10.37,10.09,9.76,9.49,9.23,9.08,9.09,9.25,9.53,9.97,10.38,10.82,11.21,11.53,11.87,12.12,12.37,12.60,12.75,12.87,12.91,12.90,12.86,12.72,12.50,12.25,11.90,11.53,11.13,10.72,10.25,9.75,9.32,8.87,8.50,8.24,8.07,8,8.10,8.28,8.61,8.99,9.40,9.87,10.37,10.85,11.21,11.37,11.37,11.13,10.82,10.34,9.76,9.12,8.40,7.65,6.91,6.20,5.62,5.21,5.01,5.02,5.23,5.53,5.90,6.26,6.57,6.75,6.88,6.97,7,7.10,7.23,7.46,7.75,8.09,8.40,8.70,8.87,9.03,9.22,9.45,9.75,10.13,10.60,11.03,11.50,11.91,12.37,12.83,13.25,13.63,14,14,14,13,12,11,9,6.91,5.28,4.64,3.12,1.82,0.62,-0.61,-1.39,-0.88,-0.37,-0.91,-0.28,0.37,1.16,1.98,3.09,5.32,5.96,6.37,6.51,6.75,7.08,7.37,7.64,7.87,8.09,8.24,8.37,8.50,8.70,9.08,9.78,11.13,12.87,14,14,15,15,15,15,15,15,14.91,14.59,14.03,13.84,14.58,15.33,15.72,15.99,16.21,16.40,16.53,16.50,16.16,15.70,15.16,14.61,13.99,13.36,12.73,12.08,11.47,10.91,10.45,10.01,9.73,9.53,9.50,9.57,9.73,9.99,10.28,10.64,11.02,11.41,11.82,12.15,12.50,12.82,13.09,13.33,13.52,13.73,13.89,14.09,14.25,14.39,14.59,14.75,14.97,15.14,15.37,15.60,15.84,16.08,16.33,16.59,16.84,17.08,17.32,17.50,17.72,17.87,17.99,18.03,18.03,17.99,17.85,17.63,17.39,17.13,16.85,16.51,16.20,15.83,15.40,14.99,14.51,14.09,13.70,13.38,13.25,13.32,13.52,13.87,14.26,14.66,15.07,15.37,15.62,15.85,16,16.13,16.25,16.36,16.39,16.41,16.40,16.37,16.32,16.25,16.16,16.20,16.25,16.38,16.57,16.72,16.85,16.90,16.96,16.98,16.99,17,17,17,16,16,16,17,17,17,17,17,17,17,16,16,16,16,16,16,16,16,16,16,17,17,17,16,16,15,15,15,15,15,15,15,15,15,14.99,14.96,14.88,14.77,14.60,14.28,13.87,13.34,12.66,11.97,11.21,10.49,9.87,9.38,9.11,9.01,9.13,9.36,9.60,9.78,9.96,10.01,10.03,10.02,10.01,10.01,10.02,10.03,10.02,9.99,9.87,9.71,9.50,9.27,9.09,8.96,8.97,9.14,9.46,9.91,10.41,10.90,11.36,11.74,12.07,12.35,12.58,12.75,12.89,13,13.08,13.08,13.01,12.89,12.74,12.50,12.22,11.87,11.49,11.07,10.61,10.12,9.64,9.20,8.73,8.33,8,7.75,7.63,7.64,7.77,8.01,8.35,8.73,9.12,9.58,10,10.38,10.62,10.60,10.34,9.90,9.37,8.75,8.12,7.47,6.77,6.12,5.52,5.07,4.73,4.51,4.50,4.59,4.75,5.12,5.38,5.62,5.78,5.89,6,6.07,6.14,6.33,6.57,6.87,7.21,7.51,7.83,8.08,8.28,8.52,8.84,9.20,9.61,10.08,10.53,11.02,11.52,12.08,12.62,13.12,13.59,14,14,14,13,12,10,9,6.91,5.51,4.99,3.45,1.86,0.50,-0.76,-1.55,-1.27,-0.91,-1.50,-0.80,-0.05,0.74,1.22,3.37,5.76,6.37,6.37,6.63,6.99,7.36,7.72,8,8.25,8.50,8.75,9,9.27,9.64,10.20,11,12.09,13.64,13.89,14.75,15,15,15,16,16,16,15.71,15.50,14.65,13.85,14.62,15.21,15.64,15.98,16.22,16.40,16.53,16.47,16.03,15.57,14.97,14.32,13.64,13.02,12.46,11.88,11.37,10.90,10.52,10.22,10,9.87,9.85,9.89,10.07,10.27,10.57,10.87,11.22,11.57,11.88,12.23,12.51,12.78,13.02,13.25,13.47,13.62,13.82,13.97,14.12,14.27,14.47,14.63,14.85,15.03,15.25,15.50,15.75,16.01,16.28,16.58,16.84,17.09,17.32,17.50,17.71,17.85,17.96,18,17.99,17.90,17.76,17.59,17.36,17.11,16.83,16.51,16.24,15.89,15.52,15.12,14.66,14.23,13.78,13.48,13.28,13.28,13.48,13.76,14.13,14.53,14.91,15.25,15.53,15.77,15.99,16.14,16.27,16.38,16.48,16.50,16.50,16.47,16.38,16.33,16.25,16.25,16.28,16.41,16.59,16.75,16.86,16.95,16.97,16.98,16.99,17,17,17,16,16,17,17,18,17,17,17,17,17,16,16,16,16,16,17,17,17,16,16,17,17,17,16,16,15,15,15,15,15,15,14.99,14.99,14.99,14.98,14.96,14.90,14.85,14.71,14.47,14.12,13.63,13.08,12.40,11.74,11.07,10.47,9.97,9.62,9.40,9.37,9.40,9.50,9.58,9.60,9.53,9.47,9.37,9.27,9.25,9.25,9.25,9.27,9.26,9.24,9.13,9.02,8.89,8.84,8.87,9.08,9.38,9.85,10.37,10.91,11.41,11.87,12.23,12.50,12.75,12.90,13.07,13.13,13.20,13.20,13.13,13.03,12.88,12.66,12.40,12.10,11.73,11.32,10.87,10.38,9.89,9.46,8.96,8.49,8.07,7.70,7.40,7.24,7.16,7.25,7.39,7.64,7.98,8.33,8.70,9.10,9.47,9.78,9.75,9.39,8.89,8.27,7.64,7.01,6.45,5.87,5.37,4.89,4.52,4.25,4.02,3.99,4,4.11,4.38,4.62,4.78,4.91,5.01,5.11,5.16,5.27,5.45,5.65,5.96,6.25,6.59,6.87,7.14,7.41,7.74,8.09,8.49,8.91,9.39,9.90,10.47,11.07,11.71,12.37,12.99,13.51,14,14,14,13,11,10,9,7.98,6.87,5.32,3.50,1.87,0.46,-0.78,-1.87,-1.38,-0.90,-1.42,-0.88,-0.13,0.63,1.07,3.76,6.37,6.37,6.37,6.89,7.34,7.73,8.08,8.37,8.64,8.97,9.26,9.62,10,10.48,11.03,11.76,12.62,13.39,14.08,14.25,14.64,15,16,16,16,16,15.91,15.66,15.13,14.86,14.84,15.25,15.62,15.91,16.13,16.34,16.46,16.25,15.95,15.38,14.74,14.01,13.37,12.76,12.25,11.75,11.32,10.98,10.65,10.45,10.27,10.22,10.23,10.32,10.46,10.64,10.88,11.15,11.48,11.75,12.08,12.36,12.62,12.87,13.10,13.27,13.47,13.62,13.75,13.90,14.07,14.22,14.37,14.57,14.75,14.97,15.20,15.41,15.71,15.98,16.25,16.51,16.78,17.07,17.27,17.50,17.64,17.78,17.87,17.91,17.90,17.84,17.71,17.50,17.28,17.08,16.83,16.58,16.32,16.01,15.70,15.28,14.87,14.38,13.97,13.62,13.39,13.37,13.49,13.74,14.08,14.45,14.83,15.14,15.47,15.74,15.97,16.14,16.33,16.46,16.52,16.59,16.59,16.52,16.48,16.37,16.32,16.26,16.34,16.45,16.61,16.75,16.87,16.91,16.97,16.98,16.99,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,16,16,15,15,15,15,15,15,14.99,14.99,14.98,14.98,14.97,14.95,14.87,14.77,14.62,14.35,13.96,13.47,12.88,12.28,11.71,11.13,10.65,10.28,10.02,9.87,9.78,9.75,9.64,9.51,9.36,9.12,8.91,8.75,8.63,8.62,8.62,8.66,8.74,8.75,8.75,8.73,8.74,8.83,9.01,9.37,9.75,10.34,10.88,11.41,11.90,12.33,12.63,12.88,13.09,13.21,13.26,13.32,13.28,13.25,13.14,13,12.82,12.57,12.25,11.87,11.50,11.03,10.59,10.10,9.62,9.12,8.62,8.14,7.73,7.35,7.01,6.78,6.66,6.65,6.75,6.96,7.20,7.47,7.75,8,8.25,8.37,8.45,8.10,7.59,6.98,6.37,5.85,5.37,4.97,4.59,4.25,4,3.76,3.62,3.57,3.52,3.53,3.78,3.99,4.12,4.23,4.28,4.37,4.45,4.52,4.66,4.87,5.10,5.36,5.62,5.89,6.16,6.49,6.83,7.22,7.62,8.11,8.60,9.12,9.74,10.40,11.20,12,12.82,13.48,14,14,13,13,11,10,9,8,6.98,5.46,4.64,2.02,0.58,-0.59,-1.76,-1.40,-1.02,-1.51,-0.91,-0.25,0.62,1.25,4.87,6.57,6.37,6.62,7.47,7.87,8.20,8.49,8.75,9.09,9.41,9.78,10.21,10.63,11.13,11.72,12.36,13,13.60,14.10,14.73,15.23,15.75,16,16,16,16,15.95,15.82,15.53,15.28,15.24,15.39,15.66,15.89,16.08,16.21,16.24,16.11,15.75,15.16,14.47,13.73,13.12,12.57,12.10,11.65,11.32,11.08,10.86,10.71,10.62,10.60,10.62,10.74,10.87,11.08,11.27,11.52,11.78,12.07,12.33,12.58,12.82,13.01,13.22,13.37,13.52,13.66,13.82,13.91,14.07,14.21,14.36,14.50,14.70,14.88,15.12,15.37,15.62,15.89,16.20,16.48,16.75,17,17.25,17.45,17.61,17.74,17.83,17.86,17.85,17.75,17.62,17.47,17.26,17.07,16.86,16.62,16.41,16.16,15.87,15.49,15.03,14.60,14.15,13.82,13.59,13.50,13.58,13.75,14.03,14.37,14.73,15.08,15.38,15.70,15.95,16.15,16.36,16.50,16.60,16.63,16.64,16.62,16.52,16.45,16.36,16.32,16.35,16.46,16.61,16.75,16.87,16.95,16.98,16.98,16.99,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,18,17,17,17,17,17,16,16,15,15,15,15,15,15,15,14.99,14.99,14.98,14.98,14.97,14.91,14.87,14.74,14.51,14.22,13.83,13.35,12.85,12.34,11.86,11.40,11.07,10.77,10.59,10.40,10.25,10.03,9.76,9.47,9.12,8.76,8.50,8.27,8.21,8.22,8.27,8.37,8.49,8.58,8.65,8.83,9.07,9.38,9.78,10.33,10.87,11.40,11.91,12.37,12.73,13,13.22,13.34,13.38,13.40,13.38,13.35,13.25,13.10,12.88,12.64,12.36,12,11.62,11.16,10.72,10.23,9.74,9.24,8.74,8.25,7.75,7.34,6.95,6.62,6.36,6.20,6.12,6.13,6.25,6.39,6.59,6.75,6.88,6.98,6.96,6.75,6.40,5.99,5.50,5.03,4.66,4.37,4.12,3.87,3.70,3.50,3.37,3.25,3.20,3.13,3.12,3.37,3.51,3.63,3.74,3.82,3.87,3.95,4,4.11,4.24,4.37,4.58,4.75,5,5.24,5.51,5.86,6.25,6.65,7.12,7.62,8.16,8.82,9.59,10.50,11.52,12.58,13.38,14,14,13,12,11,10,9,8.07,6.87,6.35,4.91,2.33,1.03,-0.49,-1.92,-1.88,-1.38,-1.59,-1.13,-0.37,0.37,1.51,4.08,7.23,7.83,7.95,8.36,8.58,8.75,8.96,9.21,9.50,9.87,10.27,10.74,11.22,11.71,12.23,12.75,13.26,13.73,14.14,14.57,14.98,15.40,16,16,16,16,15.96,15.89,15.76,15.61,15.52,15.62,15.76,15.90,16.01,16.10,16.10,15.90,15.50,14.87,14.13,13.48,12.87,12.37,11.98,11.63,11.37,11.22,11.09,11,10.98,11,11.09,11.20,11.35,11.51,11.73,11.96,12.16,12.40,12.63,12.87,13.08,13.25,13.40,13.57,13.70,13.82,13.90,14.01,14.12,14.25,14.37,14.50,14.70,14.87,15.09,15.33,15.58,15.85,16.12,16.38,16.66,16.91,17.15,17.37,17.52,17.64,17.75,17.76,17.75,17.70,17.59,17.41,17.25,17.09,16.89,16.74,16.58,16.35,16.02,15.65,15.25,14.78,14.38,14.08,13.85,13.74,13.75,13.87,14.08,14.35,14.64,15,15.34,15.63,15.91,16.15,16.37,16.52,16.63,16.72,16.73,16.66,16.61,16.50,16.38,16.33,16.35,16.47,16.62,16.75,16.87,16.96,16.98,16.98,16.99,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,18,17,17,17,17,17,17,17,17,17,16,16,15,15,15,15,15,15,15,15,14.99,14.99,14.98,14.97,14.95,14.88,14.82,14.63,14.38,14.08,13.71,13.28,12.87,12.49,12.12,11.78,11.52,11.34,11.12,10.90,10.62,10.25,9.83,9.37,8.91,8.53,8.25,8.12,8.10,8.16,8.34,8.50,8.70,8.89,9.20,9.52,9.95,10.39,10.91,11.45,11.95,12.38,12.76,13.08,13.28,13.45,13.50,13.51,13.50,13.41,13.32,13.14,12.97,12.74,12.45,12.10,11.71,11.25,10.77,10.27,9.77,9.27,8.76,8.26,7.78,7.34,6.89,6.50,6.16,5.89,5.72,5.60,5.57,5.59,5.64,5.75,5.84,5.86,5.78,5.65,5.38,4.89,4.50,4.21,3.90,3.72,3.53,3.40,3.28,3.21,3.11,3,2.95,2.89,2.87,2.87,3.12,3.28,3.41,3.51,3.61,3.65,3.73,3.75,3.83,3.87,3.91,4,4.11,4.23,4.38,4.62,4.88,5.25,5.62,6.08,6.52,7.08,7.73,8.53,9.61,10.88,12.20,13.25,14,14,13,12,12,10,9,8.02,6.74,6.26,4.87,2.57,1.25,-0.38,-1.78,-1.65,-1.37,-1.14,-1,-0.75,-0.22,1.75,2.12,7.78,9.72,9.75,9.10,9.15,9.25,9.39,9.62,9.91,10.32,10.75,11.21,11.66,12.13,12.62,13.07,13.47,13.82,14.12,14.39,14.75,15.16,15.78,16,16,16,15.97,15.91,15.87,15.82,15.76,15.82,15.87,15.91,15.99,16,15.96,15.71,15.23,14.53,13.85,13.22,12.65,12.24,11.89,11.64,11.48,11.38,11.34,11.33,11.36,11.41,11.52,11.65,11.84,12,12.21,12.38,12.61,12.82,13,13.21,13.37,13.52,13.66,13.78,13.89,14,14.10,14.16,14.25,14.36,14.47,14.59,14.73,14.87,15.09,15.27,15.51,15.76,16.02,16.32,16.59,16.85,17.08,17.26,17.45,17.57,17.63,17.71,17.70,17.62,17.52,17.39,17.25,17.12,16.99,16.86,16.73,16.50,16.21,15.83,15.38,14.98,14.62,14.34,14.12,14,13.98,14,14.13,14.35,14.62,14.90,15.25,15.61,15.89,16.16,16.38,16.58,16.71,16.75,16.77,16.75,16.65,16.58,16.46,16.37,16.37,16.49,16.62,16.76,16.87,16.96,16.98,16.99,16.99,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,16,16,15,15,15,15,15,15,15,15,15,14.99,14.98,14.97,14.95,14.88,14.83,14.66,14.48,14.22,13.91,13.62,13.32,13,12.70,12.41,12.21,12,11.82,11.59,11.25,10.83,10.33,9.78,9.28,8.87,8.52,8.37,8.33,8.39,8.60,8.84,9.10,9.38,9.75,10.13,10.59,11.07,11.52,12,12.40,12.78,13.11,13.35,13.50,13.59,13.61,13.60,13.50,13.37,13.24,13.01,12.78,12.50,12.14,11.76,11.34,10.86,10.36,9.83,9.32,8.77,8.26,7.77,7.33,6.87,6.48,6.11,5.77,5.50,5.28,5.13,5.07,5,5,5,5,4.96,4.77,4.60,4.32,3.91,3.38,3.24,3.12,3.07,3,2.97,2.89,2.87,2.82,2.75,2.73,2.74,2.75,2.77,3.10,3.32,3.48,3.61,3.72,3.77,3.85,3.87,3.87,3.85,3.78,3.75,3.71,3.70,3.74,3.85,4.01,4.27,4.62,4.99,5.38,5.87,6.50,7.33,8.45,9.87,11.75,12.66,14,14,13,13,12,11,9,7.88,6.60,6.25,4.85,2.28,1.03,-0.48,-1.65,-1.36,-1.09,-0.88,-0.74,-0.63,-0.72,0.47,1.76,5.97,9.91,9.50,9.51,9.59,9.65,9.76,9.98,10.26,10.65,11.12,11.60,12.03,12.49,12.88,13.25,13.58,13.83,14.02,14.25,14.48,15.02,15.64,15,15,16,15.86,15.95,15.95,15.90,15.89,15.90,15.91,15.96,15.97,15.95,15.78,15.47,14.89,14.23,13.53,12.99,12.50,12.12,11.87,11.73,11.62,11.62,11.62,11.66,11.75,11.87,12,12.14,12.34,12.50,12.66,12.87,13.03,13.24,13.40,13.59,13.74,13.87,14,14.10,14.16,14.25,14.33,14.37,14.46,14.50,14.61,14.70,14.82,14.95,15.11,15.27,15.50,15.73,15.97,16.23,16.48,16.73,16.96,17.14,17.33,17.46,17.53,17.62,17.62,17.59,17.50,17.37,17.26,17.15,17.08,16.99,16.87,16.64,16.35,15.95,15.50,15.12,14.82,14.59,14.40,14.32,14.25,14.23,14.25,14.37,14.59,14.87,15.22,15.57,15.88,16.20,16.41,16.62,16.75,16.84,16.86,16.83,16.75,16.63,16.52,16.47,16.45,16.52,16.65,16.78,16.88,16.96,16.98,16.99,16.99,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,16,16,16,16,15,15,15,15,15,15,15,15,15,14.99,14.98,14.97,14.91,14.87,14.76,14.62,14.46,14.25,14.01,13.82,13.59,13.36,13.11,12.87,12.66,12.50,12.36,12.12,11.82,11.37,10.87,10.34,9.84,9.38,9.07,8.87,8.85,8.91,9.13,9.39,9.73,10.07,10.41,10.85,11.25,11.71,12.12,12.50,12.84,13.12,13.36,13.51,13.62,13.65,13.63,13.59,13.47,13.28,13.10,12.87,12.58,12.24,11.86,11.39,10.90,10.39,9.87,9.34,8.77,8.25,7.75,7.28,6.86,6.46,6.09,5.75,5.47,5.21,5,4.84,4.71,4.61,4.51,4.47,4.37,4.25,4,3.83,3.62,3.37,2.91,2.88,2.89,2.88,2.87,2.83,2.75,2.73,2.70,2.66,2.64,2.74,2.83,2.91,3.32,3.60,3.82,3.99,4.12,4.24,4.27,4.32,4.25,4.15,4,3.82,3.60,3.40,3.27,3.25,3.32,3.47,3.66,3.97,4.28,4.72,5.25,5.99,7,8.33,9.91,11.50,13,12,12,12,12,11,9,7.77,6.47,6.22,4.63,3.22,1.88,-0.51,-1.43,-1.13,-0.86,-0.64,-0.50,-0.49,-0.59,-0.74,0.86,4.95,9.37,9.23,9.51,9.75,9.87,10,10.24,10.52,10.95,11.38,11.87,12.32,12.73,13.09,13.33,13.57,13.75,13.89,14.03,14.22,14.41,14.59,14.85,15,15,15.77,15.95,15.98,15.98,15.98,15.98,15.96,15.97,15.95,15.87,15.63,15.23,14.60,13.91,13.27,12.76,12.37,12.09,11.90,11.84,11.82,11.87,11.95,12.03,12.15,12.33,12.49,12.63,12.83,13,13.14,13.34,13.50,13.65,13.83,13.98,14.11,14.23,14.33,14.39,14.48,14.52,14.59,14.62,14.66,14.73,14.77,14.86,14.95,15.02,15.15,15.32,15.49,15.66,15.88,16.12,16.37,16.61,16.83,17.01,17.20,17.34,17.45,17.50,17.53,17.50,17.47,17.37,17.28,17.23,17.15,17.12,17,16.77,16.46,16.01,15.61,15.25,14.99,14.82,14.71,14.62,14.51,14.46,14.39,14.45,14.59,14.85,15.16,15.52,15.88,16.21,16.47,16.64,16.78,16.87,16.89,16.87,16.83,16.75,16.63,16.59,16.59,16.62,16.73,16.84,16.89,16.97,16.98,16.99,16.99,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,16,16,16,16,16,15,15,15,15,15,15,15,15,15,15,14.99,14.96,14.88,14.82,14.66,14.51,14.37,14.21,14.03,13.89,13.75,13.58,13.37,13.15,13,12.86,12.71,12.50,12.22,11.82,11.37,10.88,10.46,10.08,9.75,9.62,9.60,9.70,9.87,10.14,10.47,10.77,11.14,11.53,11.95,12.28,12.62,12.89,13.15,13.37,13.52,13.63,13.70,13.66,13.62,13.50,13.36,13.15,12.91,12.63,12.32,11.91,11.50,11,10.49,9.95,9.37,8.83,8.25,7.75,7.26,6.84,6.45,6.09,5.75,5.50,5.25,5.03,4.87,4.72,4.57,4.41,4.28,4.16,4.03,3.90,3.61,3.50,3.41,3.37,3.23,3.21,3.32,3.25,3.14,3.02,2.95,2.86,2.78,2.82,2.78,2.91,3.12,3.34,3.76,4.12,4.40,4.63,4.83,4.97,5.03,5.07,5,4.84,4.57,4.21,3.78,3.40,3.10,2.87,2.75,2.77,2.88,3.09,3.33,3.62,4.02,4.62,5.40,6.50,7.63,8.97,10,11,11,12,13,11,10,7.75,6.37,6.07,4.37,4.12,1.95,-0.43,-1.29,-0.92,-0.67,-0.51,-0.41,-0.38,-0.52,-0.75,-1.17,3.14,6.50,8.77,9.84,9.74,9.96,10.12,10.37,10.64,11.08,11.52,12,12.46,12.85,13.10,13.35,13.50,13.64,13.75,13.86,13.95,13.98,14.15,14.51,14.84,15,15.83,15.97,15.99,15.99,15.99,15.98,15.97,15.95,15.88,15.77,15.50,14.98,14.33,13.65,13.07,12.62,12.26,12.08,11.99,11.98,12.01,12.13,12.25,12.40,12.59,12.75,12.95,13.12,13.27,13.47,13.62,13.77,13.95,14.10,14.23,14.36,14.48,14.58,14.64,14.74,14.77,14.84,14.87,14.89,14.95,14.98,15,15.03,15.11,15.15,15.25,15.37,15.50,15.65,15.86,16.03,16.25,16.49,16.70,16.87,17.07,17.22,17.34,17.40,17.47,17.47,17.41,17.37,17.33,17.27,17.25,17.25,17.13,16.89,16.52,16.11,15.70,15.36,15.12,15.01,14.98,14.90,14.83,14.70,14.59,14.52,14.62,14.85,15.15,15.53,15.90,16.25,16.50,16.72,16.86,16.91,16.96,16.95,16.88,16.84,16.76,16.73,16.72,16.75,16.78,16.87,16.91,16.97,16.98,16.99,16.99,17,17,18,18,17,17,18,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,16,16,16,16,16,15,15,15,15,15,15,15,15,15,15,15,14.98,14.86,14.72,14.53,14.37,14.25,14.12,14.01,13.95,13.84,13.70,13.50,13.34,13.15,13.02,12.89,12.74,12.50,12.16,11.82,11.46,11.11,10.83,10.61,10.48,10.49,10.58,10.74,10.97,11.24,11.52,11.87,12.20,12.50,12.76,13,13.23,13.38,13.51,13.62,13.66,13.66,13.62,13.51,13.38,13.23,12.99,12.72,12.38,12,11.59,11.11,10.59,10.02,9.47,8.87,8.32,7.75,7.25,6.83,6.41,6.11,5.83,5.59,5.37,5.22,5.09,4.97,4.86,4.72,4.58,4.41,4.26,4.12,4.01,3.75,3.75,3.84,3.98,4.10,4.10,4.24,4.13,3.89,3.65,3.46,3.26,3.16,3.16,3.16,3.38,3.70,4.01,4.37,4.90,5.25,5.51,5.75,5.90,6.02,6.08,6,5.75,5.38,4.87,4.25,3.63,3.11,2.66,2.39,2.27,2.26,2.37,2.50,2.72,3,3.37,3.91,4.61,5.39,6,8,9,10,12,12,11,10,8.77,7.36,5.86,5.15,3.88,2.95,-0.67,-1.25,-0.91,-0.63,-0.50,-0.37,-0.38,-0.51,-0.86,-1.54,0.37,3.83,6.10,8.87,9.76,9.76,10.07,10.33,10.62,11.03,11.51,12,12.48,12.78,13.09,13.27,13.41,13.51,13.60,13.64,13.71,13.82,14,14.35,14.75,15.13,15.88,15.97,15.99,15.99,15.99,15.97,15.95,15.89,15.84,15.65,15.33,14.73,14.08,13.45,12.87,12.50,12.23,12.11,12.10,12.14,12.25,12.41,12.61,12.77,12.99,13.16,13.37,13.57,13.74,13.88,14.07,14.22,14.36,14.49,14.61,14.73,14.83,14.89,14.99,15.03,15.10,15.12,15.15,15.20,15.22,15.23,15.25,15.25,15.27,15.33,15.37,15.46,15.53,15.66,15.84,16,16.16,16.37,16.58,16.75,16.91,17.09,17.22,17.32,17.37,17.38,17.38,17.37,17.36,17.35,17.35,17.36,17.25,16.99,16.61,16.15,15.75,15.47,15.28,15.25,15.24,15.21,15.12,14.96,14.76,14.64,14.70,14.87,15.20,15.59,15.97,16.28,16.59,16.76,16.89,16.99,17,17,16.97,16.90,16.87,16.86,16.84,16.85,16.87,16.91,16.97,17,17,16.99,16.99,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,16,16,16,16,15,15,15,15,15,15,15,15,15,15,14.98,14.91,14.78,14.59,14.37,14.24,14.12,14.07,14,13.96,13.87,13.75,13.60,13.40,13.25,13.14,13.07,12.91,12.74,12.50,12.24,11.99,11.75,11.59,11.46,11.37,11.38,11.48,11.60,11.76,12,12.25,12.50,12.74,12.95,13.12,13.27,13.40,13.50,13.60,13.62,13.62,13.61,13.50,13.38,13.23,13,12.75,12.47,12.10,11.66,11.22,10.71,10.14,9.58,8.98,8.37,7.83,7.32,6.85,6.46,6.12,5.87,5.70,5.53,5.46,5.37,5.35,5.28,5.25,5.16,5.08,4.96,4.84,4.73,4.65,4.50,4.62,4.86,5.11,5.37,5.59,5.65,5.48,5.12,4.66,4.25,3.97,3.82,3.76,3.83,4.12,4.52,5,5.46,5.95,6.28,6.59,6.82,7,7.14,7.22,7.13,6.87,6.39,5.73,4.89,4.07,3.27,2.64,2.23,1.97,1.85,1.84,1.88,2,2.15,2.40,2.76,3.25,3.25,4,5,6,8,10,11,11,10,8.87,7.39,6.75,5.01,4.62,1.70,-0.98,-1.39,-1.02,-0.74,-1.75,-1.73,-1.50,-1.22,-1.29,-1.88,-0.75,1.84,4.59,8.27,8.83,9.66,9.86,10.14,10.41,10.86,11.37,11.87,12.37,12.71,12.99,13.15,13.25,13.32,13.36,13.37,13.47,13.61,13.87,14.25,14.75,15.34,15.95,15.98,15.99,15.99,15.98,15.96,15.89,15.86,15.74,15.50,15.10,14.48,13.86,13.25,12.74,12.40,12.23,12.15,12.24,12.36,12.51,12.73,12.91,13.13,13.37,13.58,13.76,13.97,14.12,14.28,14.46,14.60,14.73,14.85,14.96,15.03,15.13,15.23,15.27,15.35,15.37,15.41,15.46,15.48,15.49,15.49,15.49,15.49,15.50,15.50,15.51,15.58,15.62,15.72,15.83,15.96,16.11,16.26,16.46,16.62,16.78,16.96,17.10,17.22,17.28,17.35,17.37,17.37,17.37,17.39,17.40,17.45,17.33,17.03,16.64,16.24,15.86,15.59,15.47,15.46,15.49,15.49,15.37,15.21,14.99,14.82,14.76,14.91,15.25,15.62,16.02,16.37,16.64,16.86,16.98,17.02,17.07,17.03,17.01,17,16.99,16.96,16.95,16.91,16.96,16.99,17.02,17.09,17.10,17.01,17,17,17,17,17,17,17,17,17,17.12,17.70,17.15,17.03,17,16.99,16.99,16.99,16.99,16.99,17,17.01,17.07,17.09,17.10,16.98,17,17,17,16,15,15,15,15,15,15,15,15,15,14.98,14.91,14.78,14.61,14.37,14.15,14.08,14.02,14,14,13.97,13.90,13.82,13.64,13.49,13.35,13.26,13.22,13.12,12.99,12.82,12.63,12.50,12.38,12.33,12.25,12.25,12.27,12.37,12.45,12.51,12.64,12.83,13,13.13,13.26,13.37,13.47,13.51,13.58,13.59,13.58,13.51,13.46,13.35,13.20,13,12.76,12.50,12.14,11.75,11.33,10.85,10.27,9.70,9.10,8.50,7.90,7.37,6.89,6.50,6.20,5.96,5.82,5.74,5.72,5.74,5.75,5.83,5.87,5.90,5.91,5.90,5.87,5.82,5.77,5.82,5.78,6,6.27,6.60,6.87,7.14,7.37,7.11,6.60,6,5.37,4.91,4.72,4.57,4.75,5.14,5.71,6.25,6.74,7.12,7.46,7.72,7.95,8.13,8.32,8.37,8.33,8.03,7.49,6.62,5.61,4.52,3.57,2.75,2.14,1.76,1.58,1.49,1.48,1.50,1.61,1.73,2,2.36,3,3,4,4,5,6,8,9,9,9,7.53,6.87,5.10,2.48,0.20,-2.22,-1.76,-1.88,-1.99,-2.97,-2.80,-2.62,-2.48,-2.61,-2.18,-1.60,-0.13,2.75,5.86,8.15,8.86,9.74,9.75,9.98,10.46,11.02,11.62,12.16,12.52,12.84,12.97,13.08,13.10,13.11,13.12,13.15,13.34,13.64,14.14,14.75,15.37,16,15.99,15.99,15.99,15.97,15.91,15.87,15.75,15.61,15.33,14.87,14.25,13.64,13.09,12.62,12.37,12.25,12.25,12.37,12.57,12.76,13,13.25,13.49,13.72,13.91,14.12,14.33,14.50,14.63,14.77,14.90,15.03,15.13,15.25,15.35,15.40,15.50,15.57,15.62,15.64,15.70,15.72,15.74,15.75,15.75,15.74,15.73,15.72,15.71,15.70,15.71,15.74,15.76,15.85,15.95,16.07,16.21,16.36,16.50,16.66,16.85,17,17.12,17.24,17.32,17.37,17.38,17.41,17.48,17.50,17.50,17.37,17.08,16.70,16.27,15.96,15.74,15.63,15.65,15.74,15.75,15.64,15.46,15.21,14.99,14.88,15,15.32,15.72,16.12,16.48,16.75,16.95,17.03,17.11,17.12,17.10,17.08,17.07,17.03,17.02,17,17,17,17.08,17.14,17.25,17.28,17.33,17.21,17,17,18,17,17,17.07,17.26,17.52,17.45,17.35,17.24,17.08,17,16.98,16.98,16.98,16.98,16.99,17,17.08,17.12,17.21,17.24,17.25,17.24,17.15,16.97,17,15,15,15,15,15,15,15,15,14.98,14.91,14.78,14.61,14.37,14.15,14.03,14,14,14,14,13.98,13.96,13.87,13.74,13.60,13.48,13.45,13.40,13.37,13.25,13.14,13.07,13,12.98,12.99,13.01,13.01,13.03,13.12,13.12,13.16,13.24,13.34,13.37,13.41,13.49,13.50,13.52,13.52,13.51,13.50,13.41,13.35,13.25,13.12,12.95,12.74,12.49,12.15,11.85,11.40,10.91,10.38,9.83,9.23,8.62,8.01,7.49,7,6.59,6.25,6.02,5.90,5.88,5.96,6.07,6.21,6.37,6.50,6.65,6.78,6.89,7,7.03,7.11,7.14,7.25,7.37,7.60,7.85,8.12,8.40,8.75,9.08,8.87,8.21,7.41,6.72,6.16,5.83,5.75,5.99,6.47,7.12,7.71,8.12,8.45,8.65,8.87,9.07,9.25,9.37,9.48,9.45,9.13,8.50,7.47,6.23,4.99,3.86,2.89,2.20,1.71,1.39,1.25,1.21,1.21,1.25,1.32,1.48,1.96,2,2,3,3,3,4,5,6,7,7,6.74,6.09,4.28,0.53,-2.38,-2.77,-3.01,-3.04,-3.02,-3.92,-3.84,-3.63,-3.63,-3.77,-2.75,-3.27,-0.79,1.15,4.03,6.86,7.97,9.01,8.95,9.21,9.87,10.62,11.35,11.98,12.37,12.62,12.82,12.87,12.87,12.86,12.82,12.84,13,13.45,14.02,14.75,15.40,15.85,16,16,15.99,15.97,15.89,15.83,15.66,15.47,15.12,14.62,14.08,13.50,12.98,12.58,12.37,12.33,12.37,12.53,12.75,13.01,13.25,13.51,13.77,14,14.25,14.46,14.62,14.78,14.96,15.09,15.21,15.32,15.39,15.50,15.59,15.64,15.73,15.77,15.84,15.87,15.90,15.95,15.97,15.98,15.98,15.97,15.95,15.90,15.88,15.87,15.86,15.86,15.87,15.88,15.96,16.02,16.13,16.25,16.40,16.58,16.75,16.89,17.07,17.20,17.27,17.37,17.41,17.49,17.51,17.53,17.51,17.37,17.08,16.72,16.37,16.08,15.88,15.86,15.88,15.98,16,15.89,15.71,15.40,15.14,15.02,15.12,15.37,15.77,16.21,16.57,16.85,17.01,17.13,17.20,17.16,17.13,17.12,17.12,17.12,17.11,17.09,17.03,17.09,17.16,17.33,17.48,17.60,17.64,17.84,18,18,17,17.02,17.70,17.62,17.65,17.62,17.50,17.36,17.21,17.09,17,16.98,16.97,16.96,16.96,16.98,17,17.10,17.20,17.28,17.38,17.45,17.45,17.36,17.11,16.70,15,15,15,15,15,15,15,14.98,14.91,14.78,14.61,14.37,14.15,14.03,14,14,14,14,14,14,13.99,13.95,13.86,13.74,13.64,13.64,13.70,13.65,13.60,13.50,13.45,13.45,13.48,13.50,13.50,13.52,13.59,13.62,13.60,13.62,13.62,13.63,13.65,13.65,13.63,13.62,13.59,13.51,13.47,13.37,13.26,13.14,13,12.86,12.65,12.45,12.15,11.85,11.46,11,10.49,9.91,9.35,8.75,8.14,7.61,7.10,6.65,6.35,6.12,6,6.01,6.13,6.35,6.59,6.86,7.12,7.37,7.62,7.84,8.01,8.21,8.36,8.50,8.63,8.78,9,9.16,9.37,9.60,9.77,9.90,10.14,9.97,9.48,8.86,8.26,7.72,7.24,7.32,7.53,8.09,8.75,9.32,9.62,9.72,9.87,10,10.12,10.25,10.35,10.37,10.27,9.91,9.16,8.01,6.62,5.28,4.09,3.07,2.25,1.70,1.33,1.12,1.01,1,1.02,1.08,1.07,1,1,1,2,2,2,3,3,4,4,4,3.98,3.33,1.39,-1.51,-2.84,-3.62,-4.02,-4.23,-4.13,-5,-4.80,-4.60,-4.64,-4.87,-3.88,-3.72,-1.23,0.62,3.45,5.46,7.90,8.01,7.20,8.12,9.25,10.25,11.25,11.88,12.28,12.52,12.65,12.74,12.75,12.75,12.75,12.82,12.98,13.40,14.02,14.75,15.41,15.84,16,16,15.99,15.96,15.88,15.77,15.62,15.37,14.99,14.50,13.96,13.38,12.88,12.53,12.40,12.38,12.50,12.72,12.98,13.25,13.50,13.77,14.03,14.27,14.50,14.72,14.87,15.03,15.20,15.33,15.41,15.51,15.62,15.71,15.76,15.85,15.89,15.97,16,16.07,16.11,16.12,16.15,16.16,16.16,16.15,16.13,16.12,16.09,16.03,16,15.99,15.97,15.98,16,16.02,16.12,16.22,16.35,16.50,16.64,16.84,17,17.15,17.28,17.39,17.48,17.51,17.59,17.59,17.51,17.35,17.07,16.74,16.45,16.22,16.09,16.08,16.12,16.20,16.22,16.12,15.90,15.62,15.34,15.15,15.21,15.46,15.85,16.25,16.62,16.91,17.12,17.24,17.25,17.24,17.20,17.14,17.16,17.22,17.22,17.20,17.12,17.15,17.33,17.50,17.70,17.83,17.97,17.98,18,18,17.77,17.74,17.87,18.02,17.87,17.71,17.51,17.35,17.16,17.07,17,16.97,16.95,16.91,16.90,16.90,16.97,17.03,17.15,17.32,17.41,17.50,17.50,17.41,17.20,16.25,15,15,15,15,15,15,14.98,14.91,14.78,14.61,14.37,14.15,14.03,14,14,14,14,14,14,14,13.99,13.98,13.95,13.87,13.87,13.86,13.87,13.85,13.78,13.75,13.73,13.73,13.75,13.75,13.82,13.86,13.89,13.97,13.88,13.87,13.87,13.85,13.82,13.75,13.70,13.62,13.51,13.41,13.32,13.16,13.03,12.87,12.73,12.52,12.33,12.08,11.76,11.40,11,10.50,10,9.41,8.85,8.25,7.72,7.21,6.75,6.41,6.20,6.10,6.12,6.26,6.51,6.87,7.24,7.62,8,8.35,8.64,8.96,9.22,9.47,9.70,9.91,10.12,10.33,10.52,10.63,10.76,10.87,10.89,10.85,10.75,10.39,10.23,10.46,9.96,9.33,9.14,9.10,9.36,9.96,10.52,11.07,10.83,10.75,10.82,11.02,11.15,11.14,11.13,11.07,10.86,10.37,9.50,8.25,6.76,5.40,4.21,3.15,2.34,1.66,1.25,0.99,0.87,0.86,0.87,0.96,1,1,0.87,0.75,0.75,0.75,0.87,1,2,1.87,1.83,1.49,1.25,0.88,-0.98,-2,-3.14,-4.42,-4.91,-5.13,-5.13,-6.03,-5.84,-5.54,-5.49,-5.75,-5.12,-4,-2.41,0.37,3.12,4.16,5.98,6.09,6.26,7.71,9.74,10.87,11.58,12.03,12.35,12.51,12.62,12.72,12.75,12.77,12.82,12.85,13.12,13.47,14.11,14.75,15.45,15.85,16,16,15.99,15.97,15.88,15.77,15.61,15.35,14.97,14.48,13.90,13.37,12.88,12.58,12.49,12.50,12.64,12.87,13.14,13.47,13.75,14,14.25,14.50,14.74,14.90,15.10,15.25,15.37,15.50,15.60,15.70,15.76,15.86,15.90,15.99,16.02,16.11,16.14,16.22,16.25,16.28,16.34,16.36,16.37,16.37,16.35,16.32,16.25,16.23,16.15,16.12,16.09,16.07,16.03,16.07,16.11,16.16,16.27,16.41,16.60,16.76,16.98,17.15,17.33,17.45,17.51,17.59,17.62,17.60,17.49,17.27,17.02,16.75,16.51,16.37,16.26,16.26,16.35,16.39,16.40,16.34,16.12,15.82,15.50,15.26,15.25,15.50,15.87,16.32,16.71,17,17.21,17.28,17.32,17.25,17.24,17.22,17.25,17.35,17.37,17.36,17.32,17.35,17.49,17.64,17.84,17.95,17.99,17.98,17.98,17.95,17.90,17.95,18,18,17.87,17.71,17.50,17.33,17.14,17.03,16.98,16.95,16.89,16.87,16.85,16.84,16.86,16.91,17.03,17.16,17.32,17.37,17.39,17.34,17.02,16.86,15,15,15,15,15,14.98,14.91,14.78,14.61,14.37,14.15,14.03,14,14,14,14,14,14,14,14,13.99,13.99,13.99,13.98,13.97,13.96,13.96,13.91,13.89,13.87,13.87,13.87,13.87,13.89,13.96,14,14.07,14.12,14.07,14.01,13.99,13.95,13.87,13.77,13.66,13.58,13.45,13.28,13.13,12.99,12.78,12.61,12.39,12.20,11.95,11.65,11.34,10.96,10.50,10,9.48,8.90,8.35,7.78,7.28,6.86,6.50,6.25,6.14,6.16,6.35,6.62,7.01,7.49,7.97,8.46,8.89,9.34,9.72,10.07,10.37,10.65,10.97,11.25,11.50,11.72,11.87,11.90,11.91,11.90,11.82,11.61,11.25,10.52,10.76,11.20,11.97,12,11,11,11,12,13,12,11.87,11.23,11.62,11.87,12.08,12,11.77,11.57,11.24,10.60,9.50,8.12,6.62,5.27,4.14,3.16,2.33,1.60,1.09,0.78,0.66,0.63,0.75,0.77,0.63,0.58,0.40,0.36,0.32,0.36,0.40,0.37,0.38,0.26,-0.27,-0.88,-1.36,-1.63,-2,-2.84,-3.92,-5.09,-5.62,-5.93,-5.79,-6.62,-6.50,-6.25,-6.04,-6.26,-5.22,-3.90,-2.36,-0.66,1.09,3.12,3.98,5.22,8.40,10.63,11.47,11.76,12.08,12.32,12.48,12.60,12.66,12.75,12.83,12.88,13,13.12,13.28,13.73,14.25,14.86,15.39,15.86,16,16,15.99,15.98,15.91,15.84,15.65,15.40,15.03,14.53,13.99,13.40,12.95,12.62,12.58,12.61,12.77,13.01,13.33,13.62,13.96,14.21,14.46,14.66,14.88,15.09,15.25,15.37,15.50,15.62,15.73,15.78,15.87,15.96,16,16.09,16.12,16.21,16.25,16.33,16.37,16.40,16.47,16.50,16.50,16.50,16.50,16.49,16.45,16.37,16.33,16.25,16.21,16.13,16.12,16.11,16.12,16.15,16.25,16.37,16.52,16.74,16.96,17.14,17.35,17.48,17.58,17.62,17.61,17.52,17.41,17.24,17,16.82,16.62,16.50,16.48,16.50,16.52,16.60,16.61,16.50,16.28,15.98,15.62,15.37,15.34,15.52,15.90,16.36,16.75,17.02,17.23,17.32,17.33,17.27,17.25,17.28,17.38,17.50,17.57,17.53,17.52,17.57,17.63,17.77,17.88,17.97,17.98,17.98,17.95,17.89,17.88,17.87,17.87,17.85,17.75,17.62,17.45,17.25,17.12,17.01,16.96,16.88,16.85,16.76,16.73,16.65,16.64,16.71,16.78,16.91,17.03,17.13,17.15,17.09,16.77,15.49,15,15,15,15,14.98,14.95,14.82,14.61,14.37,14.15,14.03,14,14,14,14,14,14,14,14,14,14,14,13.99,13.99,13.99,13.98,13.98,13.97,13.96,13.95,13.95,13.95,13.96,13.98,14,14.03,14.11,14.13,14.11,14.08,14.01,13.97,13.87,13.76,13.63,13.50,13.35,13.15,12.99,12.76,12.57,12.34,12.10,11.84,11.53,11.24,10.87,10.46,9.99,9.49,8.95,8.38,7.87,7.37,6.91,6.59,6.34,6.21,6.23,6.37,6.65,7.09,7.60,8.13,8.73,9.27,9.83,10.27,10.72,11.10,11.45,11.76,12.10,12.39,12.63,12.88,12.98,12.91,12.87,12.76,12.59,12.32,11.89,11.34,11.16,12,13,14,13,12,13,13,13,13,13,12,12,13,13,13,12,12,11.75,10.65,9.33,7.65,6.10,4.88,3.97,3.10,2.21,1.32,0.74,0.48,0.47,0.37,0.36,0.01,-0.13,-0.17,-0.13,0,-0.02,-0.02,-0.25,-0.35,-0.65,-1.15,-1.74,-2.38,-2.87,-3,-3,-3.53,-4.53,-5.38,-5.93,-6,-6.02,-6.63,-6.34,-6.23,-5.98,-5.93,-4.88,-3.60,-2,-0.49,0.27,2.27,3.10,7.41,10.58,12.65,12.41,12.48,12.49,12.51,12.61,12.70,12.75,12.87,12.96,13.08,13.24,13.41,13.66,14.01,14.49,15,15.49,15.87,16,16,16,16,16,15.95,15.82,15.60,15.24,14.71,14.12,13.51,13.02,12.74,12.65,12.72,12.88,13.14,13.47,13.76,14.10,14.35,14.60,14.82,15,15.20,15.36,15.49,15.61,15.71,15.77,15.87,15.95,16,16.08,16.12,16.20,16.25,16.33,16.37,16.46,16.50,16.57,16.62,16.62,16.64,16.63,16.62,16.60,16.52,16.48,16.38,16.33,16.25,16.21,16.14,16.13,16.15,16.23,16.34,16.49,16.66,16.89,17.12,17.33,17.49,17.57,17.61,17.57,17.47,17.34,17.15,17,16.87,16.75,16.66,16.64,16.66,16.74,16.76,16.75,16.65,16.46,16.12,15.75,15.48,15.38,15.59,15.97,16.38,16.75,17.01,17.16,17.25,17.25,17.26,17.28,17.38,17.52,17.70,17.75,17.75,17.74,17.75,17.78,17.87,17.91,17.97,17.97,17.96,17.89,17.86,17.78,17.75,17.72,17.64,17.59,17.47,17.34,17.20,17.09,17,16.90,16.86,16.75,16.64,16.53,16.47,16.39,16.39,16.48,16.59,16.72,16.82,16.87,16.76,16.37,15.10,15,15,15,14.98,14.97,14.83,14.61,14.37,14.16,14.08,14.02,14,14,14,14,14,14,14,14,14,14,14,14,13.99,13.99,13.99,13.99,13.98,13.98,13.97,13.97,13.97,13.97,13.99,14,14.02,14.09,14.09,14.11,14.03,14,13.95,13.86,13.74,13.60,13.45,13.25,13.03,12.84,12.60,12.35,12.08,11.77,11.49,11.14,10.78,10.38,9.96,9.47,8.95,8.40,7.88,7.39,6.99,6.62,6.37,6.25,6.25,6.37,6.65,7.09,7.61,8.20,8.84,9.48,10.10,10.64,11.14,11.61,12,12.37,12.74,13.02,13.33,13.52,13.77,13.77,13.73,13.62,13.49,13.25,12.95,12.75,12.11,12,13,13,13,13,13,13,14,14,13,13,13,13,13,13,13,13,12,12,11,9,7,5,4,4,3,1.87,0.48,0.15,0,-0.03,0,-0.38,-0.63,-0.87,-0.89,-0.80,-0.63,-0.49,-0.80,-1.02,-1.63,-2.25,-3,-3.50,-3.87,-4.25,-4.43,-4.37,-4.23,-5.11,-5.88,-6.10,-6.23,-6,-6.75,-6.23,-5.91,-5.67,-5.48,-4.34,-2.91,-1.63,-1.13,0.62,2.65,5.28,8.63,10.83,12.65,12.73,12.64,12.62,12.62,12.72,12.83,12.91,13.03,13.16,13.34,13.51,13.75,14.03,14.37,14.77,15.23,15.62,15.95,16,16,16.01,16.10,16.11,16.07,15.97,15.77,15.49,14.87,14.25,13.64,13.15,12.85,12.77,12.84,13,13.27,13.59,13.88,14.21,14.47,14.66,14.88,15.10,15.25,15.39,15.52,15.63,15.75,15.83,15.88,15.97,16.01,16.10,16.14,16.23,16.27,16.37,16.45,16.50,16.59,16.62,16.71,16.74,16.75,16.75,16.75,16.73,16.65,16.61,16.51,16.46,16.37,16.27,16.24,16.20,16.16,16.22,16.27,16.40,16.61,16.83,17.03,17.25,17.40,17.50,17.51,17.46,17.36,17.24,17.12,17,16.90,16.86,16.83,16.84,16.86,16.88,16.91,16.90,16.82,16.60,16.25,15.87,15.59,15.48,15.62,16,16.40,16.75,16.98,17.10,17.14,17.21,17.25,17.34,17.49,17.64,17.83,17.87,17.87,17.87,17.87,17.89,17.91,17.96,17.96,17.95,17.89,17.86,17.75,17.64,17.58,17.50,17.45,17.37,17.28,17.21,17.11,17,16.95,16.87,16.76,16.64,16.50,16.36,16.22,16.12,16.09,16.11,16.21,16.33,16.45,16.50,16.46,16.02,14.60,15,15,15,14.99,14.85,14.62,14.37,14.15,14.08,14.03,14.07,14.02,14,14,14,14,14,14,14,14,14,14,14,13.99,13.99,13.99,13.99,13.98,13.98,13.97,13.97,13.97,13.97,13.98,14,14,14.02,14.02,14.01,14,13.97,13.88,13.82,13.70,13.53,13.37,13.16,12.97,12.72,12.45,12.14,11.86,11.50,11.15,10.77,10.37,9.91,9.46,8.96,8.45,7.91,7.46,7.01,6.66,6.41,6.28,6.27,6.39,6.65,7.07,7.57,8.14,8.82,9.50,10.16,10.83,11.38,11.89,12.37,12.75,13.13,13.50,13.77,14.02,14.24,14.41,14.38,14.33,14.21,14.03,13.85,13.58,13,13,14,14,13,13,13,13,14,14,14,14,13,13,13,13,13,13,12,11.87,10.63,7.50,6.50,4.62,3.86,3.86,2.51,2.27,0.87,-0.42,-0.60,-0.75,-0.77,-0.99,-1.23,-1.28,-1.49,-1.51,-1.66,-1.64,-1.65,-1.67,-2.38,-3.05,-4,-4.74,-5.13,-5.24,-5.38,-5.50,-5.48,-5.25,-5.48,-6,-6.25,-6.14,-5.93,-6.51,-6.03,-5.41,-5.18,-4.77,-3.41,-2.37,-1.11,-0.54,1.22,3.03,5.62,7.96,11.12,11.87,12.37,12.40,12.52,12.66,12.85,13,13.14,13.32,13.48,13.64,13.87,14.13,14.45,14.76,15.13,15.50,15.77,16.09,16,16.22,16.13,16.20,16.15,16.12,16.07,15.96,15.70,15,14.37,13.77,13.27,12.99,12.90,12.96,13.12,13.38,13.70,13.99,14.26,14.53,14.75,14.96,15.12,15.28,15.41,15.53,15.64,15.75,15.84,15.88,15.97,16.01,16.09,16.13,16.23,16.28,16.37,16.46,16.52,16.62,16.70,16.75,16.82,16.85,16.87,16.87,16.84,16.77,16.74,16.63,16.57,16.48,16.37,16.32,16.25,16.22,16.22,16.25,16.36,16.50,16.73,16.95,17.14,17.32,17.39,17.37,17.34,17.25,17.14,17.08,17,16.98,16.96,16.96,16.98,17,17.03,17.09,17.07,16.95,16.72,16.37,16,15.66,15.53,15.64,16,16.37,16.71,16.88,17,17.09,17.12,17.23,17.37,17.58,17.75,17.87,17.95,17.96,17.96,17.95,17.96,17.96,17.97,17.95,17.91,17.87,17.77,17.64,17.51,17.39,17.33,17.25,17.22,17.13,17.09,17,16.96,16.87,16.83,16.71,16.57,16.37,16.16,16,15.87,15.77,15.77,15.86,15.97,16.08,16.13,16.10,15.70,14.13,15,15,15,14.87,14.62,14.36,14.13,14.03,14.02,14.07,14.11,14.07,14.01,14,14,14,14,14,14,14,14,14,14,14,14,13.99,13.99,13.99,13.98,13.98,13.97,13.97,13.97,13.97,13.98,13.98,13.98,13.99,13.98,13.96,13.89,13.86,13.75,13.64,13.50,13.35,13.12,12.88,12.62,12.35,12,11.65,11.27,10.87,10.46,9.99,9.50,9,8.49,7.99,7.50,7.09,6.74,6.49,6.36,6.34,6.45,6.66,7.03,7.51,8.10,8.75,9.41,10.12,10.83,11.46,12.01,12.52,12.99,13.38,13.75,14.11,14.37,14.60,14.76,14.88,14.86,14.76,14.64,14.50,14.34,14.14,14,14,15,14,13,13,13,13,13,14,14,14,14,13,13,13,12,9.77,8.37,7.99,6.74,4.62,2.50,1.26,1.24,0.12,0.33,0.25,-1.25,-1.52,-1.63,-1.54,-1.40,-1.86,-2.05,-2.13,-1.92,-2.28,-2.49,-2.50,-2.64,-2.88,-3.55,-4.25,-5.38,-6.11,-6.50,-6.54,-6.25,-6.38,-6.25,-6,-5.90,-6.24,-6.05,-5.88,-5.63,-6.01,-5.60,-4.79,-4.48,-4.23,-2.86,-1.54,-1.28,0.24,0.99,3.61,6.12,8.37,10.57,11.15,11.60,12.07,12.46,12.76,13.03,13.26,13.48,13.63,13.84,14.01,14.25,14.51,14.85,15.16,15.52,15.78,15.99,16.11,17,16.24,16.59,16.20,16.12,16.12,16.07,15.96,15.65,15.02,14.45,13.87,13.40,13.12,13.07,13.10,13.25,13.50,13.76,14.07,14.34,14.59,14.77,14.99,15.13,15.28,15.41,15.53,15.63,15.74,15.82,15.87,15.95,16,16.07,16.12,16.22,16.27,16.37,16.47,16.53,16.63,16.73,16.78,16.87,16.89,16.95,16.96,16.91,16.88,16.84,16.75,16.66,16.59,16.49,16.38,16.32,16.25,16.22,16.24,16.28,16.41,16.62,16.84,17.01,17.16,17.25,17.25,17.22,17.13,17.11,17.08,17.03,17.03,17.03,17.07,17.10,17.13,17.20,17.23,17.20,17.07,16.82,16.48,16.09,15.75,15.60,15.64,15.95,16.27,16.59,16.76,16.89,17,17.11,17.25,17.41,17.62,17.82,17.90,17.97,17.98,17.98,17.98,17.97,17.97,17.96,17.91,17.89,17.85,17.73,17.58,17.40,17.27,17.20,17.12,17.08,17,16.98,16.90,16.87,16.84,16.75,16.63,16.49,16.26,16.07,15.87,15.73,15.62,15.60,15.62,15.70,15.75,15.77,15.65,15.26,13.73,15,15,15,14.75,14.40,14.12,14.02,14,14,14.02,14.07,14.02,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,13.99,13.98,13.97,13.96,13.96,13.95,13.91,13.90,13.89,13.89,13.88,13.87,13.82,13.74,13.62,13.50,13.33,13.11,12.87,12.59,12.25,11.89,11.51,11.11,10.63,10.14,9.63,9.12,8.60,8.08,7.60,7.15,6.83,6.57,6.40,6.38,6.50,6.73,7.07,7.50,8.07,8.65,9.35,10.02,10.73,11.37,12,12.57,13.03,13.49,13.87,14.24,14.53,14.82,15,15.15,15.25,15.21,15.12,15,14.85,14.72,14.63,15,15,15,14,14,13,13,13,13,13,14,14,14,13,12,10,8.70,6.08,4.59,3.25,2.83,0.50,-1.01,-1.28,-1.64,-2.76,-2.54,-2.41,-2.30,-2.38,-2.50,-2.50,-2.43,-2.50,-2.75,-2.77,-2.93,-2.92,-3.13,-3.25,-3.63,-4,-4.50,-5.30,-6.38,-7.12,-7.50,-7.61,-7.25,-7,-6.90,-6.55,-6.25,-6.16,-6.11,-5.64,-5.26,-5.64,-5.13,-4.40,-4,-3.76,-2.38,-1.89,-0.30,0.28,1.75,3.27,5.75,6.87,8,9.70,11.24,11.87,12.50,12.98,13.34,13.61,13.83,14,14.21,14.39,14.63,14.89,15.23,15.58,15.90,16.12,16.27,16.13,16,16.24,16.12,16.12,16.08,16.02,15.99,15.82,15.49,15,14.48,13.99,13.58,13.27,13.15,13.25,13.37,13.61,13.86,14.12,14.37,14.61,14.83,15,15.13,15.27,15.40,15.50,15.62,15.71,15.75,15.85,15.89,15.97,16.02,16.11,16.20,16.25,16.37,16.47,16.57,16.64,16.75,16.84,16.88,16.97,17,17,17,16.98,16.90,16.86,16.76,16.66,16.59,16.49,16.37,16.28,16.25,16.23,16.25,16.37,16.53,16.75,16.91,17.08,17.12,17.12,17.11,17.10,17.10,17.11,17.12,17.12,17.14,17.16,17.23,17.26,17.35,17.37,17.28,17.12,16.87,16.50,16.12,15.78,15.62,15.62,15.86,16.13,16.40,16.63,16.84,16.99,17.12,17.32,17.50,17.71,17.85,17.91,17.98,17.98,17.98,17.98,17.97,17.97,17.96,17.91,17.88,17.78,17.65,17.50,17.35,17.21,17.11,17.01,16.98,16.91,16.87,16.86,16.84,16.77,16.74,16.62,16.47,16.25,16.08,15.87,15.74,15.62,15.59,15.58,15.58,15.57,15.47,15.14,14.57,13.33,15,15,15,14.75,14.33,14,14,14,14,14.02,14.07,14.02,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14.01,14,14,13.99,13.97,13.95,13.90,13.87,13.87,13.86,13.85,13.85,13.84,13.82,13.76,13.72,13.62,13.49,13.32,13.11,12.86,12.57,12.23,11.85,11.40,10.95,10.45,9.88,9.35,8.77,8.25,7.74,7.27,6.91,6.65,6.50,6.49,6.58,6.77,7.12,7.53,8.07,8.63,9.26,9.95,10.62,11.25,11.88,12.48,12.99,13.46,13.87,14.25,14.60,14.88,15.12,15.35,15.41,15.50,15.46,15.36,15.23,15.09,14.97,14.91,15,15,15,15,15,14,14,14,13,13,13,13,13,11,9,5.70,4,1.45,-0.02,-0.67,-2.13,-2.80,-3.39,-4,-4.38,-4.49,-4.29,-4.12,-3.74,-3.38,-3.23,-3.25,-3.28,-3.38,-3.25,-3.48,-3.65,-3.63,-3.54,-3.75,-4.30,-4.79,-5.25,-6.10,-7.04,-7.75,-8.13,-8.18,-7.91,-7.54,-7.25,-6.92,-6.39,-6.13,-5.75,-5.16,-4.77,-5.18,-4.60,-3.88,-3.38,-3.12,-2.75,-1.24,-0.68,0.82,2.37,3.76,5,6,9,10.33,11.07,11.87,12.61,13.15,13.61,13.89,14.13,14.35,14.53,14.75,14.99,15.25,15.53,15.89,16.25,16.47,16.59,17,16,16,16.01,16,16,15.97,15.87,15.65,15.33,14.95,14.50,14.10,13.74,13.49,13.37,13.39,13.50,13.73,13.96,14.16,14.40,14.62,14.83,15,15.12,15.25,15.37,15.50,15.59,15.64,15.74,15.78,15.87,15.91,16,16.09,16.14,16.25,16.35,16.46,16.53,16.64,16.75,16.85,16.91,17,17.01,17.07,17.07,17.02,17,16.91,16.87,16.76,16.66,16.59,16.48,16.37,16.28,16.25,16.26,16.37,16.52,16.74,16.88,17,17.03,17.07,17.03,17.09,17.12,17.16,17.24,17.26,17.28,17.34,17.37,17.41,17.49,17.48,17.37,17.14,16.86,16.50,16.12,15.83,15.63,15.62,15.76,16,16.25,16.50,16.75,16.97,17.20,17.39,17.61,17.75,17.87,17.95,17.98,17.98,17.98,17.98,17.97,17.97,17.96,17.91,17.87,17.76,17.62,17.48,17.32,17.15,17.07,16.99,16.91,16.87,16.85,16.82,16.78,16.76,16.73,16.62,16.50,16.35,16.20,16.02,15.89,15.83,15.75,15.71,15.62,15.50,15.24,14.64,13.59,10.97,15,15,15,14.78,14.33,14,14,14,14,14.03,14.07,14.02,14,14,14,14,14,14,14,14,14,14,14.02,14.08,14.09,14.08,14.08,14.07,14.03,14,13.99,13.96,13.90,13.87,13.84,13.78,13.76,13.75,13.75,13.75,13.75,13.75,13.70,13.61,13.49,13.33,13.12,12.86,12.53,12.20,11.77,11.33,10.82,10.25,9.66,9.10,8.50,7.98,7.49,7.09,6.77,6.62,6.59,6.65,6.87,7.20,7.62,8.12,8.66,9.27,9.90,10.53,11.16,11.76,12.36,12.87,13.36,13.76,14.15,14.52,14.87,15.12,15.35,15.52,15.61,15.64,15.61,15.50,15.37,15.22,15.09,15,15,15,15,15,15,14,14,14,14,13,13,13,12,9,4.77,2.21,-0.51,-1.10,-1.80,-2.48,-3.38,-4.25,-4.88,-5.60,-6,-6.03,-6,-5.87,-5.25,-4.39,-4.04,-3.75,-3.88,-4,-3.78,-3.98,-4.16,-4.13,-3.87,-4.17,-4.75,-5.26,-5.73,-6.42,-7.42,-8.10,-8.41,-8.54,-8.25,-7.87,-7.41,-7.10,-6.55,-5.77,-5.38,-4.61,-3.92,-4.38,-3.75,-3.10,-2.53,-2.34,-1.90,-1.63,-0.18,1.36,1.65,3,4,6.01,8.77,10.09,11.11,11.87,12.63,13.26,13.75,14.12,14.37,14.62,14.84,15.02,15.25,15.50,15.78,16.12,16.40,16.61,16.72,16.77,16.02,16.08,16.01,16,15.98,15.90,15.77,15.53,15.25,14.91,14.59,14.25,13.95,13.72,13.59,13.60,13.70,13.85,14.03,14.25,14.48,14.64,14.84,15,15.12,15.25,15.37,15.47,15.53,15.62,15.71,15.75,15.84,15.88,15.98,16.03,16.12,16.23,16.34,16.45,16.53,16.64,16.75,16.86,16.95,17,17.07,17.10,17.10,17.09,17.03,17,16.95,16.86,16.75,16.66,16.59,16.49,16.38,16.36,16.37,16.48,16.62,16.76,16.89,16.99,17,17,17.03,17.11,17.20,17.27,17.37,17.45,17.48,17.50,17.52,17.59,17.61,17.57,17.39,17.13,16.82,16.47,16.13,15.88,15.75,15.72,15.78,15.87,16.12,16.37,16.63,16.95,17.23,17.49,17.70,17.84,17.90,17.97,17.98,17.98,17.98,17.98,17.98,17.97,17.96,17.91,17.87,17.76,17.62,17.48,17.33,17.16,17.08,17,16.91,16.87,16.85,16.83,16.82,16.78,16.75,16.70,16.61,16.50,16.37,16.27,16.20,16.12,16.02,15.96,15.83,15.59,15.12,14.27,12.62,9.15,15,15,15,14.86,14.26,14,14,14,14.01,14.07,14.10,14.07,14,13.99,13.99,13.99,13.99,14,14,14,14,14.03,14.12,14.15,14.20,14.15,14.12,14.10,14.07,14.01,13.98,13.90,13.87,13.82,13.75,13.71,13.65,13.64,13.64,13.66,13.71,13.73,13.66,13.61,13.49,13.33,13.12,12.86,12.52,12.15,11.74,11.24,10.66,10.10,9.49,8.87,8.27,7.75,7.33,6.98,6.75,6.70,6.75,6.97,7.26,7.71,8.20,8.75,9.34,9.96,10.57,11.14,11.73,12.25,12.76,13.24,13.64,14.03,14.39,14.74,15.02,15.28,15.51,15.62,15.65,15.72,15.64,15.53,15.39,15.25,15.12,15.02,15,15,15,15,15,14,14,15,14,13,13,12,9,7,2.61,-0.24,-0.90,-1.65,-2.42,-3.38,-4.50,-5.38,-6.04,-6.80,-7.23,-7.27,-7.25,-7.13,-6.53,-5.54,-4.67,-4.36,-4.24,-4.36,-4.26,-4.25,-4.42,-4.41,-4.13,-4.38,-4.93,-5.40,-5.88,-6.49,-7.49,-8.12,-8.41,-8.50,-8.25,-7.90,-7.42,-7.01,-6.48,-5.74,-4.66,-3.88,-3.15,-3.50,-2.87,-2.14,-1.77,-1.61,-1.28,-1,0.38,0.65,2,2.02,3.23,5.39,7.58,9.38,10.73,11.71,12.53,13.24,13.76,14.20,14.50,14.77,15.01,15.25,15.47,15.70,15.96,16.24,16.46,16.60,16.62,16.51,16.38,16.14,16.08,16,15.98,15.88,15.74,15.49,15.24,14.99,14.72,14.41,14.14,13.95,13.82,13.77,13.87,14,14.20,14.37,14.53,14.72,14.87,15,15.12,15.25,15.36,15.45,15.51,15.61,15.65,15.74,15.78,15.87,15.95,16.01,16.12,16.22,16.32,16.41,16.52,16.63,16.75,16.86,16.95,17,17.08,17.11,17.12,17.12,17.10,17.03,17,16.91,16.86,16.75,16.66,16.61,16.51,16.50,16.53,16.66,16.75,16.87,16.96,17,17.02,17.03,17.10,17.15,17.27,17.40,17.51,17.62,17.63,17.66,17.71,17.73,17.72,17.62,17.41,17.12,16.78,16.49,16.24,16.07,15.97,15.89,15.88,15.95,16.03,16.25,16.58,16.89,17.25,17.52,17.75,17.87,17.95,17.97,17.99,17.99,17.99,17.99,17.99,17.99,17.97,17.95,17.87,17.77,17.65,17.51,17.37,17.25,17.12,17.07,17,16.95,16.89,16.87,16.87,16.87,16.84,16.77,16.74,16.65,16.62,16.53,16.50,16.41,16.36,16.24,16.03,15.72,15.12,14.12,12.12,8.83,15,15,15,14.89,14.22,14,14,13.99,13.98,14.08,14.07,14.02,13.96,13.97,13.98,13.99,13.99,14,14,14,14,14.09,14.16,14.26,14.32,14.25,14.15,14.10,14.03,14,13.95,13.87,13.82,13.74,13.64,13.59,13.52,13.51,13.52,13.59,13.62,13.64,13.64,13.59,13.48,13.32,13.11,12.84,12.50,12.12,11.63,11.12,10.52,9.91,9.28,8.70,8.12,7.62,7.23,6.97,6.84,6.87,7.02,7.36,7.75,8.25,8.83,9.40,10.01,10.62,11.21,11.75,12.25,12.74,13.15,13.58,13.96,14.27,14.61,14.88,15.15,15.40,15.58,15.63,15.64,15.65,15.61,15.50,15.37,15.23,15.12,15.02,15,15,15,15,15,14,14,14,14,13,12,10,7,2.87,0.33,-0.51,-1.16,-2.13,-3.23,-4.25,-5.38,-6.23,-7,-7.67,-8.13,-8.14,-8.14,-8,-7.43,-6.53,-5.51,-4.75,-4.35,-4.48,-4.50,-4.43,-4.53,-4.50,-4.23,-4.29,-4.88,-5.26,-5.75,-6.13,-7.17,-7.79,-8.13,-8.15,-7.89,-7.64,-7.18,-6.67,-6.17,-5.38,-4.38,-3.01,-2.13,-2.41,-1.88,-1.16,0,0.22,-0.55,-0.40,0.76,1,1.14,2.24,3.34,4.74,6.91,8.85,10.27,11.45,12.37,13.12,13.73,14.21,14.58,14.87,15.12,15.37,15.59,15.78,16.01,16.25,16.38,16.50,16.51,16.48,16.37,16.24,16.12,16.07,15.99,15.87,15.71,15.47,15.25,15.10,14.87,14.62,14.37,14.15,14.02,14,14.08,14.20,14.34,14.50,14.63,14.77,14.90,15.03,15.14,15.25,15.36,15.45,15.50,15.60,15.63,15.72,15.76,15.86,15.91,16,16.11,16.21,16.32,16.40,16.51,16.63,16.75,16.86,16.95,17,17.08,17.12,17.12,17.12,17.12,17.09,17.02,16.99,16.90,16.86,16.77,16.74,16.70,16.70,16.74,16.84,16.91,16.96,17,17.02,17.09,17.10,17.12,17.24,17.37,17.52,17.65,17.75,17.78,17.84,17.85,17.85,17.82,17.66,17.47,17.16,16.87,16.61,16.40,16.33,16.25,16.25,16.22,16.14,16.12,16.25,16.53,16.88,17.24,17.53,17.75,17.87,17.96,17.98,17.99,17.99,18,18,18,18,18,17.98,17.90,17.85,17.74,17.61,17.49,17.37,17.25,17.16,17.12,17.07,17.02,17,17,16.98,16.95,16.88,16.87,16.84,16.78,16.75,16.74,16.66,16.60,16.46,16.22,15.78,15.12,14,11.91,8.75,15,15,15,14,14.11,14,14,14,13.87,13.77,13.70,13.75,13.83,13.87,13.96,13.98,13.99,14,14,14,14,14.10,14.22,14.33,14.36,14.26,14.15,14.09,14,13.96,13.87,13.77,13.71,13.61,13.50,13.41,13.37,13.37,13.39,13.46,13.50,13.57,13.60,13.52,13.45,13.26,13.07,12.76,12.41,12,11.50,10.98,10.37,9.75,9.12,8.50,7.98,7.51,7.21,7,7,7.12,7.39,7.83,8.33,8.87,9.50,10.11,10.73,11.28,11.85,12.35,12.77,13.20,13.57,13.88,14.22,14.50,14.76,15.02,15.25,15.47,15.57,15.60,15.57,15.51,15.41,15.34,15.23,15.12,15.03,15,15,15,15,15,15,14,14,14,14,12,9,7,5,0.77,0.13,-0.65,-1.48,-2.63,-3.73,-4.80,-5.91,-6.75,-7.53,-8.26,-8.63,-8.87,-8.88,-8.76,-8.25,-7.23,-6,-5.13,-4.38,-4.38,-4.43,-4.39,-4.38,-4.36,-4.05,-4,-4.54,-4.86,-5.25,-5.65,-6.50,-7.16,-7.50,-7.51,-7.25,-7.13,-6.66,-6.17,-5.63,-4.85,-3.77,-2.43,-1.41,-0.49,0.12,1.62,1.71,1.76,0.87,1,0.98,1.07,1.45,2.16,3.37,5.20,6.91,8.62,10.07,11.25,12.23,13,13.64,14.15,14.59,14.90,15.20,15.41,15.63,15.87,16.09,16.23,16.36,16.46,16.48,16.46,16.37,16.25,16.15,16.10,16,15.87,15.71,15.50,15.37,15.25,15.07,14.84,14.59,14.37,14.24,14.22,14.25,14.37,14.50,14.63,14.76,14.88,15,15.12,15.22,15.28,15.37,15.47,15.51,15.60,15.64,15.72,15.76,15.86,15.91,16,16.11,16.21,16.32,16.40,16.51,16.62,16.75,16.85,16.91,17,17.08,17.11,17.12,17.12,17.12,17.11,17.07,17,16.98,16.90,16.87,16.84,16.83,16.86,16.91,16.97,16.97,16.99,17,17.12,17.13,17.12,17.15,17.27,17.48,17.63,17.76,17.87,17.89,17.95,17.97,17.97,17.89,17.76,17.57,17.27,17,16.75,16.63,16.63,16.65,16.65,16.60,16.48,16.37,16.39,16.62,16.90,17.24,17.51,17.75,17.87,17.95,17.98,17.99,18,18,18,18.02,18.03,18.03,18.01,17.99,17.90,17.84,17.73,17.62,17.50,17.41,17.36,17.27,17.25,17.22,17.20,17.14,17.12,17.07,17,16.98,16.95,16.90,16.89,16.87,16.82,16.71,16.51,16.24,15.74,15,13.75,11.63,8.65,15,15,15,14,14,14,14,14,13.75,13.52,13.36,13.47,13.62,13.78,13.90,13.98,13.99,14,14,14,14,14.09,14.16,14.26,14.28,14.24,14.12,14.02,13.97,13.87,13.78,13.70,13.57,13.45,13.34,13.25,13.22,13.22,13.25,13.33,13.38,13.48,13.50,13.50,13.37,13.22,12.99,12.65,12.28,11.85,11.34,10.75,10.14,9.51,8.89,8.35,7.86,7.48,7.24,7.14,7.24,7.48,7.86,8.35,8.89,9.51,10.15,10.78,11.38,11.96,12.47,12.89,13.27,13.62,13.95,14.23,14.48,14.73,14.95,15.14,15.35,15.48,15.50,15.49,15.37,15.28,15.16,15.09,15,14.95,14.95,15,15,15,15,15,15,14,14,13,11,10,7,4,2,0.75,0.10,-0.75,-1.61,-2.98,-4.04,-5.14,-6.27,-7.03,-7.78,-8.75,-8.38,-9.63,-9.50,-9.38,-9,-8.16,-7,-5.80,-4.50,-4.03,-4.13,-4.10,-4.02,-4,-3.75,-3.61,-4,-4.25,-4.50,-5.03,-5.52,-6.16,-6.53,-6.53,-6.42,-6.28,-5.88,-5.38,-4.79,-4.01,-2.91,-1.75,-0.77,0,1.63,3.90,7,8,4,1.07,1.21,1.14,1.41,2.23,3.87,5.40,7.02,8.60,10.01,11.15,12.14,12.98,13.62,14.15,14.61,14.95,15.23,15.47,15.70,15.89,16.07,16.21,16.28,16.37,16.39,16.38,16.36,16.26,16.21,16.12,16.01,15.88,15.75,15.61,15.50,15.40,15.25,15,14.75,14.51,14.39,14.38,14.47,14.58,14.70,14.82,14.91,15.01,15.12,15.22,15.27,15.37,15.45,15.50,15.58,15.62,15.66,15.74,15.78,15.87,15.95,16.01,16.12,16.22,16.32,16.40,16.51,16.62,16.74,16.84,16.90,17,17.03,17.10,17.12,17.12,17.12,17.11,17.08,17.01,17,16.96,16.90,16.88,16.89,16.95,16.97,16.97,16.98,16.98,17,17.09,17.11,17.09,17.12,17.33,17.57,17.75,17.87,17.95,18,18.02,18.09,18.10,18.03,17.90,17.71,17.45,17.21,17.02,16.99,17,17.07,17.09,16.99,16.83,16.71,16.63,16.75,17,17.25,17.50,17.73,17.87,17.95,17.98,18,18,18.02,18.07,18.11,18.12,18.12,18.12,18.09,18.01,17.96,17.87,17.77,17.71,17.62,17.57,17.50,17.47,17.40,17.37,17.34,17.25,17.20,17.12,17.07,17.01,17,16.96,16.89,16.83,16.66,16.46,16.09,15.50,14.62,13.27,11.12,8.46,15,15,14,14,14,14,13.87,13.75,13.50,13.22,13,13.16,13.45,13.73,13.87,13.97,13.99,14,14,14,14,14.03,14.12,14.15,14.20,14.13,14.08,14,13.89,13.78,13.66,13.53,13.38,13.25,13.12,13.07,13.01,13.02,13.11,13.20,13.26,13.37,13.40,13.39,13.35,13.12,12.86,12.50,12.11,11.62,11.09,10.50,9.88,9.26,8.70,8.15,7.75,7.46,7.33,7.35,7.51,7.87,8.34,8.88,9.51,10.16,10.84,11.47,12.03,12.58,13.02,13.45,13.76,14.07,14.32,14.52,14.75,14.91,15.12,15.26,15.38,15.47,15.41,15.34,15.20,15.01,14.87,14.76,14.71,14.62,14.74,15,15,15,15,15,15,14,14,12,9,6,5,2,1,0.77,0.13,-0.65,-1.68,-3.04,-4.13,-5.23,-6.30,-6.13,-7.13,-8.13,-8.74,-8.99,-10,-10,-9.88,-9.05,-8,-6.88,-5.43,-4.13,-3.77,-3.49,-3.48,-3.48,-3.13,-3.01,-3.17,-3.38,-3.62,-4.15,-4.50,-4.78,-5.17,-5.26,-5.38,-5.23,-4.75,-4.27,-3.75,-2.88,-1.88,-0.80,0,1.60,2.95,7,11,12,7.91,2.35,1.62,1.26,1.61,2.91,4.21,5.64,7.15,8.64,10.02,11.24,12.23,13.03,13.72,14.25,14.65,15,15.26,15.50,15.70,15.87,16,16.13,16.25,16.33,16.37,16.37,16.35,16.25,16.21,16.12,16.03,15.95,15.83,15.74,15.70,15.59,15.39,15.13,14.87,14.65,14.57,14.57,14.63,14.75,14.87,14.99,15.10,15.16,15.25,15.33,15.37,15.46,15.50,15.58,15.62,15.65,15.73,15.75,15.84,15.88,15.97,16.02,16.12,16.23,16.33,16.41,16.51,16.62,16.73,16.83,16.88,16.98,17.01,17.08,17.10,17.11,17.11,17.09,17.07,17.01,16.99,16.96,16.91,16.91,16.95,16.91,16.91,16.91,16.96,16.98,16.89,16.90,16.91,16.99,17.11,17.32,17.58,17.77,17.89,17.98,18.02,18.12,18.16,18.23,18.20,18.08,17.87,17.64,17.47,17.35,17.32,17.35,17.38,17.39,17.32,17.14,17.02,16.99,17.01,17.15,17.36,17.57,17.74,17.87,17.95,17.99,18,18.02,18.09,18.12,18.20,18.24,18.25,18.25,18.22,18.14,18.10,18,17.96,17.88,17.84,17.76,17.74,17.70,17.63,17.60,17.50,17.41,17.34,17.24,17.13,17.08,17,16.96,16.87,16.74,16.51,16.23,15.77,15.16,14.25,12.86,10.76,8.25,15,14,14,14,14,13.91,13.78,13.32,13.22,13.11,13.01,13.14,13.41,13.72,13.87,13.97,13.99,14,14,14,14,14,14.02,14.08,14.09,14.08,14.01,13.95,13.84,13.71,13.52,13.37,13.20,13.02,12.89,12.84,12.83,12.86,12.91,13.02,13.14,13.25,13.32,13.28,13.22,13,12.73,12.32,11.86,11.34,10.75,10.16,9.59,9,8.47,8,7.64,7.47,7.41,7.58,7.87,8.28,8.85,9.47,10.12,10.82,11.47,12.09,12.63,13.12,13.58,13.91,14.23,14.47,14.65,14.86,15,15.14,15.27,15.37,15.46,15.45,15.35,15.16,14.98,14.75,14.59,14.48,14.38,14.34,14.07,15,15,15,15,15,15,14,14,13,9,6,3,1,1,0.87,0.33,-0.51,-1.61,-2.99,-4.03,-5.01,-5.14,-6.25,-7.15,-8.13,-7.76,-8.38,-9.78,-10,-10,-9.73,-8.68,-7.65,-6.27,-4.90,-3.60,-3,-2.65,-2.63,-2.38,-2.38,-2.30,-2.29,-2.75,-2.93,-3.29,-3.36,-3.50,-3.88,-4,-3.79,-3.35,-2.98,-2.38,-1.50,-0.64,0.25,1.63,2.99,6,10,14,13.91,10.63,5.62,1.95,1.98,2.62,3.45,4.57,5.87,7.32,8.72,10,11.22,12.22,13.02,13.72,14.23,14.62,14.98,15.24,15.46,15.62,15.78,15.96,16.08,16.16,16.25,16.32,16.33,16.32,16.25,16.20,16.12,16.03,15.98,15.87,15.85,15.83,15.75,15.51,15.25,15,14.77,14.71,14.73,14.82,14.95,15.07,15.14,15.25,15.33,15.37,15.41,15.49,15.52,15.60,15.62,15.66,15.73,15.75,15.82,15.87,15.91,16,16.07,16.13,16.24,16.34,16.41,16.51,16.62,16.72,16.78,16.87,16.95,17,17.02,17.07,17.08,17.08,17.03,17.01,17,16.97,16.91,16.90,16.90,16.89,16.88,16.87,16.78,16.75,16.73,16.74,16.72,16.75,16.85,17.01,17.25,17.52,17.75,17.89,18,18.09,18.20,18.27,18.37,18.37,18.25,18.10,17.88,17.74,17.62,17.60,17.61,17.63,17.63,17.58,17.46,17.36,17.28,17.32,17.37,17.50,17.63,17.76,17.87,17.97,18,18.03,18.11,18.20,18.25,18.33,18.37,18.38,18.37,18.36,18.32,18.25,18.15,18.12,18.07,18,17.98,17.95,17.88,17.85,17.76,17.70,17.60,17.48,17.35,17.24,17.12,17,16.89,16.75,16.53,16.25,15.87,15.39,14.82,14,12.75,10.87,8.39,15,14,14,14,14,14,13.11,13.11,13,13,13.11,13.32,13.61,13.78,13.91,13.98,13.99,14,14,14,14,14,14,14,14.01,14,13.96,13.86,13.72,13.51,13.33,13.12,12.91,12.76,12.65,12.61,12.62,12.65,12.75,12.88,13.01,13.12,13.15,13.13,13.02,12.84,12.50,12.09,11.53,11,10.38,9.82,9.24,8.70,8.22,7.84,7.58,7.48,7.58,7.83,8.23,8.75,9.37,10.01,10.73,11.39,12.07,12.64,13.20,13.63,14.07,14.37,14.63,14.85,15,15.13,15.26,15.37,15.46,15.50,15.50,15.41,15.25,15.02,14.76,14.50,14.28,14.16,14.12,14.08,14,15,15,15,15,15,15,14,14,13,10,6,2,1,1,1,0.61,-0.24,-1.25,-2.63,-3.74,-3.60,-4.88,-6.13,-7,-6.75,-7.77,-8.75,-9.17,-11,-10,-9.67,-8.79,-7.98,-6.55,-5.27,-3.98,-2.60,-2,-1.60,-1.50,-1.49,-1.26,-1.50,-1.66,-1.87,-1.88,-1.98,-2.14,-2.36,-2.28,-2.11,-1.75,-1.38,-0.78,-0.14,0.61,0.77,3,7,10,14,14.98,15.65,12.37,7.76,4.50,3.51,3.60,4.03,4.91,6.12,7.46,8.76,10.07,11.23,12.23,13.02,13.71,14.21,14.61,14.91,15.16,15.37,15.57,15.73,15.87,15.99,16.10,16.16,16.24,16.25,16.25,16.23,16.15,16.12,16.03,15.99,15.91,15.88,15.87,15.82,15.60,15.35,15.10,14.89,14.84,14.87,14.98,15.11,15.23,15.33,15.37,15.46,15.50,15.57,15.59,15.62,15.64,15.71,15.74,15.76,15.82,15.86,15.89,15.97,16.01,16.10,16.15,16.25,16.35,16.45,16.51,16.62,16.70,16.76,16.85,16.88,16.96,16.99,17,17,17,17,16.98,16.95,16.90,16.88,16.87,16.87,16.85,16.85,16.74,16.62,16.50,16.45,16.41,16.46,16.50,16.65,16.90,17.20,17.49,17.72,17.87,17.99,18.11,18.25,18.38,18.50,18.52,18.46,18.27,18.12,17.97,17.87,17.82,17.78,17.78,17.77,17.75,17.66,17.62,17.59,17.60,17.62,17.70,17.75,17.86,17.95,18,18.11,18.15,18.26,18.37,18.45,18.50,18.51,18.53,18.52,18.50,18.46,18.37,18.28,18.24,18.20,18.14,18.12,18.10,18.03,18,17.91,17.85,17.74,17.60,17.46,17.32,17.15,17,16.83,16.60,16.27,15.89,15.48,15,14.51,13.96,13.03,11.50,9.12,15,14,14,14,14,14,13,13,13,13.11,13.32,13.60,13.78,13.90,13.97,13.99,13.99,14,14,14,13.99,13.99,13.99,13.98,13.97,13.91,13.87,13.74,13.52,13.28,13.03,12.84,12.62,12.50,12.38,12.37,12.38,12.49,12.61,12.75,12.87,12.98,13,12.98,12.84,12.58,12.21,11.74,11.21,10.61,10,9.38,8.86,8.37,7.96,7.64,7.50,7.50,7.74,8.10,8.60,9.20,9.87,10.58,11.26,11.97,12.62,13.16,13.65,14.11,14.47,14.75,15,15.16,15.34,15.45,15.50,15.57,15.60,15.61,15.53,15.40,15.22,14.91,14.62,14.32,14.07,13.87,13.86,13.91,14,15,15,16,15,15,14,14,14,13,9,4,1,1,1,1,0.77,0.21,-0.75,-2.13,-2.18,-3.10,-4.39,-5.63,-5.53,-6.35,-7.74,-8.63,-9.01,-8.89,-10,-9.29,-8.53,-7.86,-6.62,-5.50,-4.13,-2.53,-1.60,-0.55,-0.41,-0.48,-0.54,-0.54,-0.73,-0.73,-0.75,-0.88,-0.88,-0.85,-0.61,-0.27,-0.13,0.12,0.50,0.87,2,3,6,11,14,15,15.74,15.40,13.10,9.48,6.60,5.14,4.57,4.64,5.33,6.40,7.62,8.86,10.09,11.23,12.21,13,13.63,14.14,14.53,14.86,15.10,15.27,15.47,15.62,15.75,15.87,15.99,16.08,16.13,16.16,16.20,16.16,16.12,16.09,16.01,15.99,15.91,15.88,15.87,15.82,15.63,15.38,15.16,15.01,14.98,15.01,15.12,15.25,15.37,15.47,15.51,15.58,15.62,15.64,15.66,15.71,15.74,15.75,15.77,15.83,15.86,15.88,15.95,16,16.07,16.12,16.21,16.26,16.36,16.45,16.50,16.61,16.66,16.75,16.82,16.86,16.88,16.95,16.97,16.97,16.97,16.96,16.91,16.88,16.86,16.83,16.78,16.75,16.75,16.71,16.57,16.39,16.25,16.20,16.15,16.15,16.25,16.50,16.77,17.11,17.39,17.64,17.84,17.99,18.12,18.26,18.48,18.62,18.65,18.61,18.46,18.28,18.14,18.03,17.98,17.91,17.89,17.88,17.87,17.86,17.84,17.84,17.84,17.85,17.87,17.87,17.95,18,18.10,18.22,18.37,18.50,18.62,18.63,18.65,18.70,18.70,18.65,18.62,18.52,18.48,18.37,18.32,18.25,18.22,18.20,18.14,18.12,18.09,18,17.95,17.84,17.71,17.53,17.37,17.21,16.98,16.71,16.37,15.97,15.50,15.08,14.70,14.40,14.16,13.72,12.73,9.99,15,14,14,14,14,13,13,12.97,13.11,13.25,13.63,13.77,13.87,13.87,13.89,13.97,14,14,14,13.99,13.98,13.97,13.96,13.91,13.88,13.84,13.73,13.53,13.32,13.01,12.75,12.50,12.32,12.16,12.12,12.12,12.20,12.28,12.45,12.59,12.71,12.76,12.78,12.75,12.57,12.25,11.85,11.33,10.75,10.12,9.51,8.96,8.45,8,7.70,7.50,7.47,7.60,7.88,8.37,8.97,9.62,10.35,11.08,11.77,12.48,13.09,13.62,14.08,14.48,14.78,15.09,15.32,15.49,15.59,15.63,15.71,15.73,15.73,15.70,15.60,15.40,15.14,14.85,14.50,14.14,13.86,13.59,13.23,14,14,15,15,15,15,14,14,14,14,12,8,4,1,1,1,1,1,0.70,-0.12,-0.29,-1.49,-2.50,-3.63,-4.79,-4.67,-6,-7.11,-8,-8.35,-8.15,-8.52,-9.03,-8.50,-7.52,-6.42,-5.42,-4.13,-2.79,-1.40,-0.50,0.25,0.12,0.02,0,0.01,-0.05,-0.15,-0.16,-0.10,0.12,0.45,0.50,0.62,0.83,1,3,5,7,10,13,15,15,15.13,14.83,13.70,10.34,7.95,6.28,5.41,5.27,5.84,6.66,7.75,8.90,10.09,11.20,12.14,12.97,13.60,14.09,14.47,14.75,14.99,15.15,15.34,15.49,15.62,15.75,15.87,15.96,16.01,16.09,16.11,16.11,16.09,16.02,16,15.96,15.89,15.87,15.83,15.75,15.62,15.40,15.25,15.12,15.12,15.16,15.26,15.38,15.50,15.59,15.62,15.66,15.72,15.74,15.75,15.76,15.76,15.78,15.84,15.86,15.87,15.91,15.98,16,16.09,16.13,16.23,16.28,16.37,16.46,16.51,16.61,16.65,16.73,16.76,16.83,16.87,16.88,16.89,16.90,16.89,16.87,16.86,16.82,16.75,16.73,16.65,16.62,16.58,16.48,16.36,16.22,16.10,16,15.97,16,16.12,16.38,16.71,17.02,17.35,17.61,17.82,17.97,18.11,18.25,18.46,18.61,18.66,18.63,18.57,18.45,18.28,18.20,18.10,18.02,18,17.98,17.97,17.98,18,18.02,18.02,18,18,17.98,18,18.07,18.15,18.37,18.61,18.83,18.87,18.85,18.85,18.84,18.82,18.75,18.70,18.61,18.50,18.40,18.33,18.25,18.21,18.15,18.12,18.12,18.09,18.01,17.97,17.87,17.75,17.60,17.39,17.16,16.88,16.51,16.10,15.62,15.14,14.77,14.58,14.57,14.66,14.62,14.25,11.87,15,14,14,14,14,13,12,13,13.01,13.86,13.83,13.85,13.75,13.74,13.82,13.90,13.98,14,14,13.98,13.96,13.91,13.88,13.87,13.78,13.70,13.52,13.32,13.01,12.72,12.39,12.13,11.97,11.86,11.84,11.87,11.99,12.12,12.25,12.40,12.50,12.57,12.51,12.37,12.23,11.87,11.37,10.85,10.23,9.62,9,8.48,8,7.62,7.41,7.36,7.45,7.70,8.10,8.63,9.33,10.02,10.77,11.52,12.25,12.87,13.47,13.97,14.37,14.75,15.09,15.36,15.52,15.65,15.75,15.82,15.84,15.85,15.83,15.75,15.62,15.40,15.12,14.76,14.39,14.01,13.65,13.36,13,14,14,15,15,15,15,14,14,14,14,11,7,3,1,1,1,1,1,1,0.70,0.64,-0.50,-1.63,-2.75,-2.62,-3.65,-4.23,-5.25,-5.80,-7.12,-6.88,-6.88,-7.76,-8.23,-7.23,-6.27,-5.38,-4.48,-3.16,-2.03,-0.88,0.20,0.50,0.45,0.38,0.39,0.45,0.50,0.50,0.62,0.76,0.83,0.87,1,2,3,7,10,11,12,15,14.96,14.99,14.88,14.53,12.75,10.62,8.63,7.11,6.14,5.96,6.23,6.90,7.87,8.96,10.08,11.12,12.07,12.86,13.49,13.98,14.35,14.62,14.85,15.01,15.20,15.35,15.49,15.61,15.73,15.83,15.89,15.97,16,16,16,15.98,15.95,15.89,15.87,15.84,15.76,15.71,15.60,15.45,15.33,15.25,15.25,15.34,15.45,15.52,15.62,15.70,15.74,15.75,15.77,15.78,15.78,15.82,15.84,15.85,15.86,15.87,15.89,15.96,16,16.02,16.11,16.14,16.24,16.28,16.37,16.45,16.50,16.58,16.62,16.66,16.73,16.75,16.78,16.83,16.85,16.85,16.85,16.82,16.76,16.73,16.62,16.58,16.48,16.37,16.33,16.25,16.14,16.02,15.95,15.86,15.84,15.88,16.07,16.34,16.64,17,17.32,17.60,17.77,17.95,18.08,18.21,18.34,18.47,18.52,18.57,18.52,18.49,18.38,18.28,18.22,18.12,18.08,18.02,18.01,18.08,18.13,18.22,18.24,18.13,18.08,18,18,18.11,18.25,18.50,18.86,18.99,19,19,19,18.96,18.88,18.83,18.74,18.62,18.50,18.38,18.26,18.20,18.12,18.09,18.02,18,17.99,17.96,17.87,17.78,17.66,17.51,17.34,17.09,16.75,16.32,15.83,15.35,14.91,14.71,14.73,15,15.39,15.70,15.49,13.76,15,14,14,14,14,13,13,12,13,13.97,13.87,13.60,13.52,13.58,13.74,13.87,13.95,13.97,13.96,13.90,13.87,13.86,13.82,13.75,13.64,13.50,13.32,13.02,12.72,12.37,12.01,11.75,11.60,11.50,11.52,11.62,11.76,11.95,12.10,12.22,12.28,12.27,12.21,12,11.71,11.37,10.87,10.25,9.64,9.03,8.48,7.98,7.53,7.26,7.13,7.15,7.37,7.75,8.25,8.89,9.64,10.46,11.24,11.99,12.65,13.26,13.83,14.25,14.64,14.97,15.22,15.41,15.63,15.75,15.86,15.89,15.91,15.91,15.88,15.82,15.65,15.40,15.12,14.74,14.34,13.88,13.52,13.01,13,13,14,15,15,15,15,14,14,14,13,10,6,2,1,1,1,1,1,1,1,1.60,0.82,-0.42,-1.63,-1.43,-2.41,-2.89,-2.93,-4.49,-4.53,-5.85,-6.13,-6,-5.61,-6.13,-5.51,-6.01,-5.30,-3.25,-2.04,0.22,1.64,1.62,1.87,1.83,1.76,1.83,1.87,2,2,3,3,4,5,7,9,9,12,13,14,15,15.10,14.88,14.62,13.72,12.23,10.59,8.99,7.64,6.82,6.41,6.57,7.12,7.98,8.97,10,11,11.91,12.71,13.34,13.83,14.20,14.48,14.70,14.87,15.02,15.16,15.33,15.46,15.58,15.66,15.75,15.84,15.87,15.89,15.90,15.89,15.87,15.86,15.83,15.76,15.74,15.65,15.58,15.46,15.38,15.37,15.39,15.49,15.59,15.66,15.75,15.77,15.83,15.84,15.84,15.85,15.85,15.85,15.86,15.87,15.87,15.89,15.91,15.97,16,16.03,16.12,16.15,16.24,16.28,16.37,16.41,16.49,16.52,16.59,16.62,16.64,16.71,16.73,16.75,16.75,16.75,16.75,16.73,16.66,16.59,16.50,16.37,16.25,16.12,16.09,16.01,15.97,15.87,15.77,15.72,15.73,15.84,16.02,16.33,16.62,16.98,17.27,17.58,17.77,17.91,18.01,18.12,18.22,18.27,18.36,18.38,18.40,18.46,18.45,18.37,18.32,18.23,18.13,18.11,18.10,18.14,18.27,18.38,18.38,18.25,18.12,18.07,18.12,18.21,18.36,18.66,18.88,19.07,19.12,19.14,19.12,19.02,18.96,18.86,18.74,18.62,18.49,18.35,18.23,18.11,18,17.96,17.87,17.85,17.82,17.75,17.71,17.62,17.50,17.35,17.13,16.87,16.50,16.08,15.59,15.14,14.87,14.87,15.12,15.62,16.24,16.72,16.50,13.74,15,14,14,14,14,14,13,13,13,13,13,13.36,13.48,13.62,13.74,13.83,13.87,13.87,13.84,13.77,13.75,13.72,13.64,13.59,13.47,13.27,13.03,12.75,12.37,12,11.63,11.37,11.23,11.20,11.25,11.39,11.59,11.75,11.87,11.97,11.99,11.90,11.75,11.50,11.14,10.72,10.21,9.63,9.03,8.47,7.91,7.48,7.13,6.96,6.95,7.11,7.40,7.88,8.50,9.20,9.98,10.76,11.57,12.26,12.91,13.50,13.99,14.37,14.74,15.01,15.25,15.48,15.66,15.82,15.88,15.96,15.99,15.98,15.95,15.85,15.66,15.41,15.10,14.71,14.27,13.77,13.10,13,13,13,14,14,14,14,13,13,13,13,13,10,6,2,1,1,1,1,1,1,1,2,1.65,1.01,-0.10,0,-0.04,-1.35,-1.25,-2.04,-3.80,-4.36,-5.50,-5.62,-4.75,-4.79,-5.77,-6.30,-4.61,-2.38,-0.10,2.13,4.75,6,5.75,5,5,4,6,6,5,5,9,10,11,12,13,12,14,15,15,15.96,15.15,14.74,14.13,13.03,11.83,10.48,9.12,8,7.20,6.77,6.85,7.27,8,8.90,9.88,10.86,11.75,12.50,13.12,13.62,13.99,14.26,14.50,14.70,14.87,15,15.14,15.27,15.40,15.51,15.62,15.71,15.75,15.78,15.83,15.83,15.82,15.77,15.75,15.75,15.71,15.62,15.58,15.50,15.47,15.49,15.52,15.62,15.73,15.78,15.86,15.87,15.87,15.87,15.87,15.87,15.87,15.87,15.87,15.87,15.87,15.89,15.95,15.98,16,16.07,16.12,16.15,16.24,16.28,16.36,16.39,16.47,16.50,16.52,16.58,16.61,16.62,16.64,16.65,16.66,16.66,16.63,16.60,16.50,16.41,16.26,16.12,15.97,15.86,15.82,15.76,15.72,15.62,15.58,15.57,15.62,15.77,16.01,16.33,16.62,16.97,17.27,17.57,17.76,17.90,18,18.07,18.11,18.13,18.20,18.24,18.27,18.36,18.40,18.45,18.38,18.32,18.22,18.15,18.16,18.26,18.45,18.57,18.53,18.37,18.21,18.21,18.25,18.41,18.62,18.87,19.09,19.24,19.33,19.28,19.22,19.10,18.99,18.86,18.73,18.60,18.46,18.32,18.14,18.01,17.89,17.82,17.72,17.62,17.57,17.50,17.39,17.32,17.20,17.02,16.86,16.60,16.25,15.85,15.41,15.12,15.01,15.22,15.65,16.35,17.01,17.52,17.12,14.71,15,14,14,14,14,14,13,13,13,13,13,13.25,13.59,13.66,13.75,13.75,13.75,13.70,13.64,13.62,13.58,13.51,13.49,13.38,13.25,13.08,12.78,12.47,12.08,11.65,11.26,11,10.87,10.87,10.98,11.14,11.36,11.50,11.62,11.62,11.58,11.41,11.21,10.88,10.50,10.02,9.50,8.98,8.39,7.87,7.38,7,6.75,6.71,6.77,7.08,7.50,8.03,8.72,9.46,10.25,11.02,11.77,12.49,13.09,13.60,14.02,14.39,14.72,15,15.24,15.41,15.62,15.76,15.87,15.97,16,16,15.97,15.87,15.66,15.41,15.09,14.65,14.25,13.88,13,13,12,13,14,15,14,13,12,12,13,13,13,11,7,3,1,1,1,1,1,1,1,2,2,1.52,0.86,1.25,1,-0.61,-0.89,-1.85,-2.88,-4.60,-5.23,-5.90,-6.18,-6.38,-6.30,-6.85,-4.88,-2.50,-0.27,2.12,5.90,7.22,8.22,10,9,9,10,10,9,9,9,12,14,15,15,14,15,16,16,15.77,15.12,14.37,13.50,12.60,11.50,10.36,9.23,8.23,7.48,7.07,7.03,7.38,8,8.83,9.73,10.62,11.50,12.24,12.86,13.36,13.75,14.03,14.27,14.50,14.66,14.85,15,15.12,15.25,15.37,15.48,15.57,15.62,15.66,15.72,15.74,15.74,15.73,15.72,15.71,15.65,15.62,15.60,15.57,15.53,15.60,15.64,15.75,15.83,15.87,15.90,15.91,15.90,15.89,15.88,15.87,15.87,15.87,15.87,15.87,15.87,15.89,15.91,15.97,16,16.07,16.12,16.16,16.24,16.28,16.35,16.38,16.41,16.47,16.49,16.50,16.51,16.52,16.58,16.59,16.59,16.57,16.50,16.40,16.32,16.13,16,15.77,15.61,15.47,15.37,15.35,15.35,15.32,15.33,15.38,15.57,15.75,16.01,16.33,16.62,16.96,17.25,17.57,17.82,17.90,17.98,18,18.01,18.02,18.07,18.11,18.15,18.25,18.33,18.37,18.37,18.33,18.25,18.25,18.28,18.40,18.60,18.71,18.70,18.53,18.37,18.41,18.57,18.74,18.87,19.08,19.28,19.50,19.52,19.41,19.28,19.13,19,18.87,18.73,18.59,18.41,18.27,18.12,17.99,17.84,17.66,17.52,17.38,17.26,17.14,17.03,16.91,16.82,16.66,16.50,16.32,16.02,15.72,15.40,15.25,15.33,15.64,16.25,17,17.65,18.10,17.41,14.65,15,14,14,14,14,14,14,12.03,12.88,13.12,13.82,13.53,13.53,13.61,13.62,13.60,13.57,13.50,13.48,13.41,13.38,13.36,13.32,13.23,13.09,12.87,12.60,12.22,11.77,11.36,10.96,10.65,10.51,10.52,10.65,10.87,11.08,11.22,11.25,11.21,11.01,10.78,10.50,10.15,9.75,9.32,8.82,8.32,7.82,7.32,6.88,6.61,6.48,6.50,6.73,7.10,7.62,8.23,8.95,9.66,10.47,11.24,11.96,12.59,13.12,13.60,13.99,14.33,14.62,14.87,15.12,15.33,15.51,15.71,15.84,15.91,16,16,15.97,15.85,15.63,15.38,15.10,14.65,14.10,14,14,13,12,12,13,14,15,13,12,12,12,13,13,12,8,3,1,1,1,1,1,1,1,1,2,2,1.22,1.22,0.86,0.11,-1.13,-1.37,-2.63,-4.61,-5.89,-7.61,-7.90,-6.75,-7.37,-6.86,-6.88,-4.50,-2.13,1.26,6.12,8.51,10.49,11.62,12,13,13,13,13,12,11,12,15,15,15,15,15,16,16,15.63,14.62,13.87,13.10,12.24,11.26,10.25,9.25,8.37,7.65,7.25,7.20,7.46,7.97,8.65,9.50,10.36,11.15,11.89,12.51,13.02,13.46,13.77,14.03,14.27,14.49,14.64,14.83,14.98,15.12,15.23,15.34,15.40,15.50,15.57,15.61,15.62,15.64,15.64,15.64,15.64,15.63,15.62,15.62,15.61,15.62,15.70,15.75,15.82,15.87,15.95,15.97,15.97,15.95,15.90,15.88,15.87,15.87,15.86,15.86,15.86,15.87,15.87,15.90,15.96,16,16.03,16.12,16.15,16.24,16.27,16.34,16.37,16.38,16.39,16.40,16.41,16.45,16.46,16.47,16.48,16.46,16.39,16.34,16.16,16.02,15.77,15.51,15.27,15.07,14.87,14.82,14.78,14.86,14.91,15.09,15.26,15.50,15.75,16.02,16.33,16.62,16.95,17.25,17.52,17.75,17.91,17.98,17.99,17.98,17.99,18,18.01,18.08,18.13,18.22,18.25,18.27,18.26,18.27,18.34,18.41,18.59,18.74,18.82,18.87,18.75,18.71,18.73,18.84,18.96,19.01,19.23,19.50,19.75,19.73,19.51,19.37,19.21,19.02,18.87,18.74,18.60,18.45,18.28,18.12,17.98,17.77,17.59,17.37,17.15,17,16.85,16.71,16.58,16.46,16.36,16.25,16.12,15.96,15.75,15.60,15.57,15.74,16.14,16.78,17.51,18.13,18.41,17.58,13.59,15,14,14,14,14,13.89,13.14,12.87,12.74,13.03,13.60,13.36,13.28,13.36,13.38,13.39,13.37,13.35,13.32,13.25,13.24,13.21,13.13,13.07,12.89,12.70,12.37,12,11.51,11.03,10.62,10.33,10.14,10.15,10.27,10.50,10.66,10.77,10.75,10.61,10.36,10.03,9.72,9.35,8.97,8.53,8.11,7.65,7.25,6.84,6.50,6.28,6.26,6.39,6.74,7.21,7.76,8.46,9.15,9.88,10.63,11.37,12.02,12.62,13.11,13.50,13.86,14.14,14.41,14.66,14.90,15.12,15.37,15.57,15.74,15.87,15.99,16,15.98,15.84,15.62,15.35,15.10,14.97,14,14,14,13,13,12,12,13,15,14,13,12,12,12,13,13,9,4,2,1,1,1,1,1,1,1,0.75,1.50,0.84,0.62,0.45,-0.25,-0.85,-2.13,-2.13,-4.61,-7.11,-9,-8.35,-8.04,-7.24,-7.38,-6.41,-6.25,-2.90,-0.23,3.57,6.73,10,11.12,13,13,14,14,14,14,13,13,15,15,16,16,16,15,15.11,14.70,14.02,13.40,12.75,11.98,11.11,10.21,9.28,8.50,7.85,7.40,7.28,7.47,7.87,8.49,9.23,10,10.78,11.50,12.13,12.66,13.12,13.49,13.77,14.03,14.26,14.49,14.64,14.83,14.97,15.09,15.20,15.27,15.37,15.45,15.50,15.52,15.58,15.60,15.61,15.62,15.62,15.62,15.62,15.62,15.64,15.73,15.78,15.85,15.89,15.95,15.97,15.96,15.91,15.89,15.87,15.86,15.84,15.83,15.82,15.83,15.84,15.87,15.87,15.91,15.98,16.01,16.10,16.13,16.22,16.25,16.28,16.33,16.34,16.34,16.34,16.34,16.34,16.34,16.35,16.34,16.32,16.25,16.12,15.97,15.64,15.32,14.98,14.64,14.38,14.23,14.15,14.22,14.37,14.60,14.87,15.16,15.48,15.75,16,16.28,16.61,16.90,17.21,17.48,17.71,17.84,17.91,17.95,17.95,17.95,17.96,17.98,18,18.08,18.12,18.13,18.14,18.21,18.27,18.41,18.60,18.75,18.88,18.95,18.95,18.96,18.96,18.99,19.02,19.02,19.01,19.36,19.62,19.87,19.75,19.60,19.40,19.25,19.08,18.90,18.75,18.62,18.49,18.34,18.14,17.99,17.75,17.50,17.24,16.99,16.75,16.59,16.41,16.32,16.24,16.16,16.13,16.12,16.09,16,15.98,16,16.24,16.65,17.25,17.95,18.47,18.63,17.63,14.50,15,14,14,14,13.99,13.75,13.23,12.37,12.52,12.46,12.62,12.83,12.91,13.07,13.14,13.21,13.22,13.20,13.15,13.12,13.12,13.09,13.01,12.91,12.75,12.50,12.16,11.75,11.25,10.75,10.27,9.95,9.75,9.73,9.83,9.99,10.12,10.16,10.09,9.87,9.58,9.24,8.87,8.51,8.15,7.82,7.41,7.09,6.75,6.50,6.24,6.13,6.23,6.48,6.87,7.38,8.01,8.73,9.40,10.12,10.83,11.48,12.08,12.59,13,13.36,13.64,13.91,14.15,14.41,14.66,14.89,15.15,15.37,15.61,15.78,15.96,16,15.97,15.86,15.61,15.27,15,15,14,14,14,14,14,12,11,12,14,15,14,11,11,12,12,13,10,5,2,1,1,1,1,1,1,0.62,0.21,-0.35,-0.27,-0.38,-0.16,-0.54,-2.14,-2.52,-3.99,-5.78,-7.88,-8.75,-9.11,-7.85,-8.01,-6.67,-6.55,-5.63,-3.27,-0.50,2.12,5.12,8.40,10.75,12.87,14,14,15,15,15,14,14,15,16,16,16,16,15,14.75,14,13.45,13.10,12.50,11.78,11.01,10.21,9.37,8.62,8,7.57,7.37,7.46,7.75,8.25,8.89,9.62,10.37,11.08,11.71,12.25,12.75,13.13,13.50,13.78,14.07,14.27,14.49,14.64,14.83,14.96,15.07,15.14,15.25,15.33,15.37,15.41,15.49,15.51,15.53,15.57,15.58,15.59,15.60,15.62,15.64,15.72,15.77,15.87,15.87,15.89,15.89,15.89,15.87,15.87,15.84,15.78,15.76,15.75,15.75,15.75,15.77,15.82,15.85,15.87,15.95,16,16.07,16.12,16.16,16.23,16.25,16.25,16.25,16.25,16.24,16.23,16.22,16.22,16.22,16.21,16.15,16.08,15.95,15.63,15.25,14.84,14.39,14,13.74,13.50,13.50,13.64,13.90,14.25,14.63,15.01,15.36,15.63,15.95,16.25,16.58,16.87,17.13,17.37,17.59,17.71,17.77,17.83,17.84,17.85,17.87,17.95,18,18.08,18.12,18.14,18.20,18.25,18.40,18.60,18.75,18.89,19,19,19,19.01,19.11,19.21,19.26,19.34,19.40,19.53,19.71,19.77,19.75,19.62,19.46,19.26,19.12,18.96,18.78,18.63,18.50,18.37,18.16,18,17.74,17.41,17.12,16.85,16.61,16.41,16.28,16.23,16.21,16.22,16.26,16.36,16.40,16.47,16.50,16.60,16.78,17.15,17.70,18.25,18.72,18.82,17.83,14.41,15,14.07,14,14,13.98,13.74,13.50,12.60,11.76,11.90,12.01,12.26,12.51,12.75,12.89,13,13.03,13.07,13.03,13.02,13,12.99,12.90,12.82,12.62,12.37,11.99,11.50,10.97,10.39,9.90,9.51,9.26,9.20,9.23,9.33,9.39,9.38,9.25,9,8.71,8.37,8.02,7.73,7.40,7.12,6.85,6.60,6.38,6.25,6.20,6.14,6.34,6.65,7.12,7.72,8.37,9.03,9.73,10.37,11,11.58,12.10,12.50,12.87,13.14,13.39,13.63,13.87,14.12,14.37,14.62,14.90,15.15,15.39,15.63,15.78,15.89,15.91,15.89,15.84,15,15,15,14,14,14,14,13,12,11,11,13,15,14,11,11,11,12,13,11,6,2,1,1,1,1,1,0.37,-0.18,-0.63,-1.61,-1.61,-1.28,-1.11,-1.16,-2.50,-3.63,-5.50,-7.37,-8.43,-9,-9.26,-8.04,-7.25,-5.86,-5.53,-4.63,-3.27,-1.60,0.77,3.76,7.07,11.60,12.63,14,15,15,15,15,15,15,15,16,16,16,16,15,14.33,13.72,13.37,12.89,12.37,11.74,11.01,10.25,9.50,8.76,8.15,7.71,7.46,7.41,7.62,8.02,8.59,9.24,9.89,10.59,11.23,11.82,12.34,12.77,13.16,13.51,13.84,14.10,14.32,14.50,14.65,14.82,14.91,15.01,15.12,15.20,15.25,15.33,15.37,15.41,15.48,15.50,15.50,15.51,15.53,15.58,15.62,15.64,15.74,15.78,15.86,15.86,15.82,15.78,15.77,15.76,15.75,15.72,15.70,15.65,15.65,15.70,15.72,15.75,15.77,15.84,15.88,15.97,16.01,16.10,16.13,16.16,16.21,16.21,16.20,16.15,16.12,16.12,16.10,16.09,16.08,16.08,16.03,15.96,15.73,15.36,14.88,14.39,13.88,13.50,13.24,13.08,13.02,13.24,13.53,13.89,14.26,14.73,15.09,15.41,15.77,16.14,16.50,16.82,17.07,17.25,17.38,17.50,17.57,17.61,17.62,17.66,17.75,17.87,18.01,18.13,18.25,18.34,18.38,18.50,18.62,18.75,18.90,19.02,19.11,19.12,19.12,19.14,19.26,19.40,19.52,19.61,19.64,19.74,19.78,19.82,19.75,19.62,19.49,19.32,19.13,18.99,18.83,18.65,18.50,18.34,18.13,17.96,17.66,17.37,17.02,16.75,16.53,16.39,16.35,16.35,16.37,16.48,16.61,16.75,16.90,17.02,17.12,17.23,17.37,17.65,18.09,18.57,18.90,18.96,18,14.37,14.87,14.22,14,13.99,13.96,13.65,13.16,12.57,11.95,11.62,11.63,11.87,12.15,12.46,12.65,12.83,12.89,12.96,12.97,12.96,12.95,12.88,12.84,12.72,12.50,12.21,11.76,11.25,10.63,10.03,9.50,9.07,8.75,8.60,8.53,8.57,8.58,8.50,8.37,8.12,7.83,7.50,7.24,6.98,6.75,6.57,6.37,6.25,6.15,6.14,6.24,6.36,6.62,7,7.53,8.12,8.77,9.45,10.08,10.65,11.21,11.70,12.11,12.45,12.72,12.95,13.12,13.34,13.53,13.78,14.08,14.36,14.62,14.89,15.16,15.37,15.49,15.57,15.71,15.87,15.99,15,15,14,14,13.16,13.53,13.24,12.73,12.11,11.66,11.76,12.33,12.70,12.34,11.25,10,11,12,12,11,7,3,1,1,1,1,0.37,-0.30,-0.88,-1.38,-2.63,-3.55,-3.26,-2.85,-2.66,-1.51,-3.65,-5.38,-7.25,-8.38,-8.80,-7.88,-7.63,-5.88,-5.86,-4.26,-4.24,-2.88,-1.63,-0.43,2.62,6.87,11.47,13.57,14,15,15,15,15,15,15,16,16,16,16,16,15,14.33,13.70,13.34,12.87,12.36,11.75,11.11,10.38,9.66,8.99,8.37,7.87,7.57,7.46,7.53,7.84,8.26,8.84,9.46,10.10,10.73,11.34,11.87,12.37,12.84,13.24,13.58,13.87,14.12,14.34,14.50,14.64,14.76,14.87,14.99,15.07,15.12,15.22,15.25,15.34,15.37,15.39,15.41,15.46,15.48,15.50,15.51,15.58,15.62,15.70,15.72,15.66,15.65,15.63,15.63,15.62,15.62,15.60,15.57,15.57,15.57,15.59,15.62,15.64,15.72,15.75,15.85,15.89,15.99,16.03,16.11,16.12,16.13,16.12,16.11,16.08,16.01,16,15.97,15.96,15.96,15.97,15.90,15.77,15.50,15.10,14.60,14.08,13.59,13.25,13.08,13.01,13.02,13.09,13.32,13.60,13.88,14.25,14.65,15.12,15.59,16.01,16.40,16.74,16.96,17.11,17.22,17.26,17.34,17.37,17.39,17.50,17.64,17.86,18.08,18.25,18.46,18.57,18.62,18.71,18.77,18.89,19.03,19.20,19.25,19.27,19.28,19.35,19.48,19.62,19.75,19.78,19.85,19.87,19.87,19.87,19.77,19.65,19.50,19.34,19.14,19,18.83,18.64,18.49,18.27,18.10,17.86,17.59,17.28,17,16.75,16.60,16.51,16.52,16.62,16.73,16.87,17.08,17.27,17.50,17.64,17.75,17.85,17.96,18.13,18.47,18.85,19.12,19.07,18,15.37,14.75,14.35,14.01,13.98,13.86,13.60,13.12,12.53,12,11.60,11.47,11.61,11.90,12.22,12.48,12.65,12.77,12.86,12.87,12.87,12.87,12.83,12.74,12.60,12.36,12,11.51,10.96,10.32,9.64,9.07,8.58,8.21,7.97,7.85,7.76,7.73,7.62,7.47,7.24,6.99,6.74,6.51,6.36,6.23,6.12,6.08,6.08,6.11,6.23,6.41,6.72,7.02,7.50,8.08,8.66,9.28,9.90,10.49,11,11.47,11.86,12.14,12.39,12.61,12.75,12.88,13.02,13.23,13.48,13.75,14.07,14.36,14.62,14.89,15.12,15.22,15.24,15.12,15,15,16,14,13,13,13.08,12.99,12.83,12.50,12.15,11.87,11.78,11.84,11.75,11.37,10.75,10.40,10.96,12,12,12,9,5,1,1,1,0.62,-0.17,-0.88,-1.38,-2.25,-3.55,-4.53,-4.16,-3.75,-3.25,-2.60,-3.25,-4.90,-6.41,-7.63,-7.04,-6.93,-6.88,-6.39,-5.38,-3.76,-2.50,-2.54,-1.64,-1.50,1.72,5.98,10.50,13.57,15,15,15,15,15,15,15,15,16,16,16,16,15,14.57,13.85,13.39,12.95,12.41,11.87,11.25,10.60,9.89,9.24,8.62,8.10,7.72,7.50,7.50,7.65,8,8.46,9,9.61,10.23,10.84,11.40,11.97,12.47,12.88,13.27,13.62,13.88,14.12,14.33,14.49,14.62,14.74,14.84,14.91,15,15.09,15.13,15.22,15.25,15.28,15.35,15.36,15.37,15.38,15.40,15.45,15.49,15.50,15.49,15.39,15.37,15.39,15.46,15.48,15.46,15.45,15.40,15.40,15.45,15.48,15.50,15.57,15.62,15.71,15.76,15.87,15.95,16,16.07,16.09,16.09,16.07,16,15.97,15.89,15.87,15.84,15.82,15.84,15.84,15.75,15.61,15.27,14.86,14.37,13.87,13.52,13.35,13.27,13.26,13.27,13.32,13.25,13.37,13.52,13.84,14.23,14.75,15.34,15.86,16.27,16.61,16.82,16.91,17,17.07,17.12,17.16,17.24,17.37,17.61,17.86,18.12,18.37,18.62,18.75,18.83,18.87,18.91,19.01,19.16,19.34,19.45,19.49,19.50,19.53,19.63,19.75,19.87,19.90,19.95,19.95,19.91,19.87,19.82,19.66,19.50,19.34,19.13,18.97,18.77,18.61,18.40,18.23,18,17.75,17.50,17.25,17,16.82,16.74,16.75,16.85,16.99,17.14,17.37,17.60,17.84,18.03,18.23,18.35,18.38,18.48,18.61,18.85,19.12,19.32,19.14,18,14.25,14.62,14.34,14.09,13.97,13.77,13.50,13.08,12.51,12.01,11.62,11.45,11.50,11.75,12.07,12.35,12.53,12.71,12.76,12.83,12.82,12.77,12.73,12.62,12.45,12.14,11.75,11.25,10.62,9.95,9.25,8.61,8.07,7.62,7.34,7.13,7.01,6.91,6.78,6.63,6.47,6.25,6.10,5.98,5.88,5.87,5.88,5.96,6.03,6.22,6.45,6.75,7.12,7.59,8.10,8.66,9.27,9.87,10.46,10.97,11.38,11.75,12.07,12.27,12.45,12.57,12.64,12.74,12.82,12.91,13.15,13.49,13.84,14.12,14.35,14.62,14.87,15,15,15,15,15,15,13,12.16,12.26,12.49,12.59,12.52,12.38,12.16,11.97,11.75,11.59,11.32,10.87,10.34,9.91,10.16,10.98,11,11,9,6,2,1,0.75,0.21,-0.63,-1.48,-2.14,-3.16,-4.50,-5.48,-5.13,-4.67,-4.13,-4.26,-3.38,-4.25,-5.50,-6.43,-6.05,-5.05,-5.90,-5.38,-4.38,-3.10,-1.98,-1.30,-1.41,-1.25,2,5.25,9.60,13.70,15,15,15,15,15,15,15,15,16,16,16,16,16,14.77,14.03,13.53,13.09,12.59,12.02,11.47,10.84,10.16,9.51,8.89,8.36,7.90,7.62,7.50,7.58,7.76,8.12,8.61,9.13,9.74,10.35,10.95,11.50,12.03,12.52,12.98,13.35,13.63,13.89,14.12,14.28,14.45,14.57,14.66,14.75,14.87,14.95,15,15.08,15.12,15.16,15.22,15.25,15.25,15.26,15.26,15.28,15.33,15.32,15.25,15.15,15.03,15.15,15.25,15.27,15.25,15.25,15.25,15.26,15.32,15.35,15.38,15.46,15.51,15.62,15.73,15.82,15.88,15.97,16,16,16,15.98,15.91,15.86,15.78,15.73,15.70,15.65,15.65,15.63,15.58,15.37,15.02,14.61,14.15,13.85,13.66,13.64,13.71,13.74,13.73,13.63,13.52,13.37,13.38,13.59,13.95,14.46,15.07,15.62,16.10,16.39,16.60,16.70,16.75,16.85,16.91,17.02,17.15,17.37,17.62,17.87,18.12,18.38,18.64,18.84,18.89,18.96,19,19.12,19.27,19.47,19.60,19.64,19.70,19.74,19.78,19.87,19.91,19.97,19.98,19.97,19.95,19.88,19.82,19.65,19.50,19.27,19.10,18.88,18.71,18.50,18.34,18.12,17.90,17.70,17.47,17.25,17.10,16.99,16.95,17.01,17.21,17.38,17.62,17.86,18.10,18.34,18.53,18.73,18.84,18.88,18.95,19.01,19.21,19.40,19.51,19.27,18.02,14.23,14.62,14.33,14.09,13.87,13.62,13.34,12.88,12.40,11.99,11.64,11.48,11.50,11.75,12,12.25,12.48,12.62,12.72,12.75,12.74,12.66,12.60,12.46,12.25,11.91,11.49,10.90,10.25,9.52,8.82,8.13,7.57,7.11,6.75,6.50,6.36,6.24,6.10,5.98,5.86,5.74,5.63,5.62,5.63,5.73,5.85,6,6.23,6.49,6.78,7.21,7.65,8.16,8.74,9.35,9.95,10.50,11.01,11.48,11.85,12.12,12.34,12.49,12.58,12.62,12.70,12.74,12.75,12.78,13,13.33,13.72,13.98,14.12,14.27,14.76,14.87,14.98,15,15,15,15,13,11.50,11.52,11.97,12.20,12.32,12.33,12.22,12.02,11.83,11.53,11.15,10.64,10.03,9.27,9.27,9.89,10,10,9,6,3,2,0.50,-0.13,-1.23,-2.13,-2.77,-3.79,-5.13,-6.05,-5.73,-5.26,-5.75,-4.89,-3.88,-3.88,-4.88,-4.48,-4,-4,-4.75,-4.38,-3.54,-2.39,-1.50,-0.88,-1,0.25,2.48,5.74,9.86,13.87,15,15,15,15,15,15,15,15,16,16,16,16,16,14.84,14.16,13.72,13.25,12.75,12.25,11.73,11.12,10.50,9.87,9.25,8.66,8.20,7.84,7.62,7.53,7.63,7.88,8.25,8.75,9.27,9.87,10.48,11.07,11.62,12.13,12.62,13.01,13.37,13.63,13.87,14.09,14.25,14.37,14.50,14.61,14.71,14.77,14.87,14.91,14.99,15.01,15.08,15.11,15.12,15.12,15.12,15.13,15.13,15.12,15.10,15.01,15,15,15.03,15.08,15.10,15.10,15.12,15.13,15.20,15.24,15.27,15.36,15.46,15.53,15.65,15.76,15.87,15.91,15.97,15.96,15.91,15.87,15.82,15.75,15.64,15.57,15.49,15.46,15.41,15.38,15.27,15.07,14.72,14.33,14,13.86,13.87,14,14.14,14.25,14.22,14.12,13.98,13.73,13.62,13.74,13.95,14.33,14.84,15.34,15.74,16.02,16.25,16.37,16.50,16.62,16.76,16.95,17.16,17.45,17.71,17.90,18.12,18.35,18.58,18.75,18.88,18.98,19.07,19.21,19.37,19.57,19.72,19.78,19.85,19.87,19.88,19.95,19.97,19.98,19.98,19.97,19.95,19.87,19.76,19.62,19.41,19.23,19,18.78,18.61,18.40,18.23,18.01,17.84,17.62,17.46,17.28,17.21,17.15,17.22,17.35,17.53,17.78,18.03,18.28,18.52,18.75,18.99,19.13,19.25,19.32,19.36,19.41,19.57,19.73,19.76,19.50,18.26,15.20,14.58,14.27,13.99,13.71,13.39,13.02,12.62,12.23,11.87,11.63,11.58,11.62,11.82,12.01,12.25,12.41,12.57,12.63,12.65,12.62,12.58,12.45,12.25,12,11.63,11.14,10.57,9.87,9.12,8.37,7.71,7.11,6.62,6.25,5.98,5.78,5.66,5.59,5.49,5.41,5.40,5.41,5.49,5.62,5.76,6,6.25,6.53,6.87,7.26,7.74,8.25,8.82,9.39,10.01,10.62,11.13,11.62,12,12.28,12.50,12.62,12.74,12.77,12.83,12.86,12.88,12.95,12.97,13.12,13.37,13.73,13.97,14,14.12,14.10,14,14,14,14,14,14,12,10.74,11,11.51,11.87,12.12,12.25,12.25,12.13,11.91,11.62,11.25,10.76,10.15,9.50,8.97,8.23,8.98,8,7,6,4,1.86,1.37,-0.62,-1.73,-2.55,-3.25,-4.13,-5.41,-6.39,-6.03,-6.52,-6.02,-5.17,-4.13,-4,-4.13,-3.63,-3.98,-2.98,-3.76,-3.48,-2.75,-1.62,-0.80,-0.14,-0.24,1,3.22,6.12,10.26,14,15,14,14,14,15,15,15,15,15,16,16,16,15,14.66,14.25,13.87,13.45,12.99,12.50,12,11.46,10.87,10.25,9.62,9.03,8.51,8.10,7.77,7.62,7.62,7.75,8,8.39,8.87,9.41,10,10.62,11.20,11.74,12.24,12.65,13.02,13.36,13.62,13.84,14,14.15,14.28,14.40,14.50,14.62,14.70,14.75,14.83,14.87,14.89,14.95,14.97,14.98,14.98,14.99,14.99,14.99,14.98,14.96,14.91,14.90,14.89,14.89,14.91,14.96,15,15.02,15.10,15.12,15.16,15.25,15.37,15.50,15.62,15.75,15.87,15.90,15.91,15.88,15.84,15.75,15.65,15.57,15.41,15.32,15.22,15.13,15.11,15.02,14.89,14.65,14.36,14.07,13.87,13.89,14.11,14.37,14.62,14.75,14.72,14.62,14.50,14.37,14.25,14.24,14.34,14.50,14.74,15.08,15.37,15.62,15.83,16,16.22,16.40,16.63,16.89,17.20,17.50,17.75,17.95,18.10,18.25,18.48,18.70,18.87,18.97,19.09,19.24,19.40,19.61,19.75,19.87,19.90,19.96,19.97,19.99,19.99,19.98,19.97,19.95,19.89,19.84,19.72,19.52,19.34,19.12,18.88,18.70,18.50,18.33,18.12,17.96,17.76,17.62,17.49,17.37,17.36,17.37,17.49,17.63,17.87,18.13,18.40,18.66,18.91,19.14,19.36,19.50,19.62,19.70,19.75,19.82,19.90,20.07,20.10,19.84,18.71,15.23,14.45,14.21,13.86,13.47,13.08,12.66,12.28,11.98,11.75,11.62,11.62,11.75,11.89,12.10,12.25,12.40,12.50,12.59,12.60,12.53,12.45,12.26,12.03,11.75,11.34,10.82,10.16,9.48,8.72,7.98,7.27,6.70,6.21,5.84,5.57,5.37,5.28,5.25,5.21,5.24,5.32,5.40,5.59,5.76,6.01,6.33,6.62,7,7.39,7.85,8.34,8.87,9.47,10.07,10.66,11.25,11.75,12.20,12.50,12.74,12.87,12.97,13.01,13.07,13.10,13.12,13.15,13.24,13.28,13.40,13.62,13.85,13.99,14,14,14,14,14,14,14,14,13,12,10.91,10.66,11.14,11.59,11.95,12.16,12.26,12.20,11.98,11.75,11.45,11,10.41,9.75,8.99,8.34,7.87,7.02,6,5,4,2.75,1.10,0.09,-2,-2.88,-3.51,-4.15,-5.60,-6.63,-7.30,-6.65,-6.11,-4.17,-3.99,-3.89,-3.51,-3.50,-2.73,-2.73,-2.61,-2.25,-1.54,-0.38,0.13,-0.13,0.82,2,3.75,6.72,10.83,14,15,14,14,14,15,15,15,15,15,16,16,16,15,14.62,14.37,14.01,13.63,13.23,12.76,12.32,11.77,11.24,10.63,10.03,9.46,8.89,8.41,8.07,7.78,7.66,7.72,7.87,8.15,8.58,9.03,9.60,10.15,10.75,11.28,11.82,12.26,12.66,13.01,13.33,13.58,13.76,13.96,14.10,14.23,14.34,14.41,14.50,14.60,14.63,14.70,14.74,14.75,14.76,14.78,14.82,14.83,14.85,14.87,14.88,14.87,14.87,14.83,14.76,14.75,14.76,14.84,14.88,14.97,15,15.07,15.12,15.21,15.33,15.47,15.62,15.75,15.84,15.85,15.77,15.73,15.62,15.51,15.39,15.25,15.12,14.96,14.82,14.73,14.64,14.59,14.46,14.25,14.01,13.87,13.85,14.02,14.37,14.72,15,15.15,15.16,15.12,15.03,14.99,14.96,14.91,14.89,14.87,14.87,14.98,15.11,15.25,15.46,15.70,15.98,16.26,16.59,16.88,17.24,17.58,17.82,17.96,18.03,18.20,18.38,18.62,18.78,18.91,19.07,19.23,19.39,19.61,19.75,19.87,19.96,20,20,20,20,19.99,19.97,19.90,19.87,19.75,19.61,19.39,19.21,18.99,18.77,18.61,18.41,18.25,18.10,17.95,17.77,17.65,17.59,17.52,17.52,17.61,17.74,17.90,18.14,18.41,18.75,19,19.25,19.50,19.70,19.85,19.97,20.02,20.11,20.16,20.26,20.38,20.40,20.20,19.16,16.28,14.35,14.08,13.62,13.14,12.72,12.27,11.91,11.70,11.59,11.60,11.71,11.86,12,12.14,12.27,12.38,12.49,12.51,12.51,12.46,12.33,12.12,11.85,11.48,11,10.46,9.78,9.08,8.33,7.59,6.90,6.34,5.87,5.50,5.26,5.12,5.08,5.09,5.16,5.25,5.41,5.62,5.87,6.12,6.45,6.76,7.13,7.53,7.99,8.47,8.97,9.50,10.09,10.64,11.26,11.84,12.27,12.64,12.90,13.10,13.21,13.25,13.28,13.35,13.37,13.39,13.48,13.52,13.62,13.72,13.86,14.07,14.09,14,14,14,14,15,15,14,13,12,11,10.32,10.25,10.75,11.25,11.73,12.03,12.16,12.09,11.90,11.75,11.58,11.25,10.75,10.02,9.13,8.24,7.21,6.12,5.98,5,4,3.73,1.85,-0.03,-1.13,-3,-3.85,-4.50,-5.73,-6.77,-7.50,-6.88,-6.13,-4.18,-3.86,-3.38,-2.87,-2.24,-2.23,-2,-0.92,-0.63,0.12,1,1.46,1.12,1.90,2.72,5.50,8.50,12,14,15,14,14,14,15,15,15,15,15,16,16,16,15,14.76,14.52,14.22,13.87,13.47,13.07,12.62,12.12,11.62,11.07,10.48,9.88,9.34,8.83,8.37,8.07,7.85,7.75,7.83,8,8.33,8.74,9.22,9.75,10.28,10.86,11.37,11.87,12.28,12.66,13,13.26,13.50,13.71,13.87,14,14.12,14.24,14.34,14.39,14.47,14.50,14.53,14.59,14.60,14.62,14.62,14.64,14.70,14.74,14.77,14.82,14.78,14.72,14.62,14.61,14.62,14.72,14.82,14.88,14.97,15,15.03,15.12,15.26,15.41,15.59,15.70,15.73,15.70,15.62,15.50,15.36,15.22,15.07,14.87,14.65,14.47,14.28,14.16,14.12,14.08,14,13.98,13.91,13.96,14.09,14.34,14.62,14.97,15.24,15.40,15.50,15.50,15.50,15.58,15.58,15.61,15.50,15.37,15.25,15.12,15.07,15.03,15.20,15.48,15.83,16.20,16.53,16.89,17.25,17.61,17.83,17.95,18,18.12,18.33,18.53,18.73,18.87,19,19.16,19.36,19.53,19.74,19.87,19.98,20.01,20.03,20.03,20.01,20,19.98,19.89,19.82,19.65,19.49,19.26,19.08,18.87,18.72,18.53,18.38,18.25,18.12,17.99,17.87,17.77,17.74,17.74,17.75,17.86,17.99,18.15,18.39,18.66,19,19.28,19.58,19.78,20,20.13,20.25,20.37,20.45,20.51,20.62,20.74,20.74,20.50,19.62,17.39,14.15,13.87,13.37,12.82,12.32,11.87,11.53,11.37,11.45,11.60,11.76,11.97,12.12,12.23,12.33,12.38,12.46,12.49,12.46,12.37,12.21,11.97,11.62,11.22,10.71,10.11,9.41,8.71,7.97,7.25,6.60,6.02,5.61,5.28,5.11,5,5,5.11,5.25,5.50,5.72,6,6.33,6.64,7,7.37,7.75,8.15,8.62,9.10,9.59,10.12,10.63,11.20,11.76,12.26,12.66,13,13.22,13.37,13.46,13.50,13.52,13.60,13.62,13.64,13.72,13.76,13.85,13.89,13.98,14.12,15,14,14,14,14,15,14,14,12,11,9,9.35,9.51,10.24,10.87,11.45,11.82,11.87,11.75,11.62,11.52,11.49,11.38,11.14,10.32,9.26,8.14,7.09,6.13,5.10,4,4,3.62,1.74,0.99,-1.05,-3.25,-4.13,-4.78,-5.52,-6.62,-7.29,-6.73,-5.75,-3.86,-3.50,-2.78,-1.93,-1,-0.53,-0.36,-0.26,1.12,1.87,2.26,2.62,2.23,3,4.62,7.37,10,13,14,14,14,14,14,15,15,15,15,15,16,16,15,15,15.07,14.76,14.41,14.09,13.72,13.33,12.90,12.48,11.99,11.47,10.89,10.35,9.77,9.25,8.76,8.37,8.10,7.90,7.87,7.96,8.14,8.48,8.87,9.37,9.87,10.40,10.95,11.45,11.88,12.28,12.64,12.97,13.23,13.45,13.62,13.77,13.90,14.02,14.12,14.22,14.25,14.33,14.37,14.37,14.40,14.45,14.47,14.49,14.50,14.57,14.62,14.63,14.61,14.50,14.40,14.38,14.45,14.52,14.64,14.75,14.84,14.88,14.97,15.08,15.21,15.36,15.48,15.57,15.58,15.50,15.37,15.21,15,14.82,14.61,14.37,14.12,13.90,13.76,13.72,13.71,13.73,13.76,13.85,13.91,14.09,14.32,14.61,14.89,15.23,15.49,15.65,15.77,15.86,15.89,15.97,16,16.03,16,15.88,15.73,15.50,15.34,15.20,15.22,15.45,15.76,16.12,16.50,16.87,17.21,17.57,17.76,17.87,17.98,18.08,18.24,18.41,18.62,18.78,18.96,19.11,19.27,19.49,19.66,19.86,19.98,20.03,20.10,20.11,20.10,20.07,20,19.90,19.76,19.60,19.37,19.15,18.98,18.83,18.66,18.57,18.45,18.33,18.21,18.10,18,17.97,17.95,17.97,18,18.11,18.24,18.39,18.62,18.89,19.21,19.53,19.84,20.08,20.26,20.45,20.58,20.66,20.76,20.87,20.98,21.07,21,20.75,19.75,17.50,13.90,13.53,12.98,12.38,11.88,11.49,11.25,11.25,11.39,11.62,11.87,12.07,12.21,12.27,12.35,12.38,12.41,12.45,12.38,12.27,12.10,11.82,11.45,10.98,10.39,9.76,9.09,8.36,7.62,6.95,6.34,5.83,5.41,5.16,5.02,5,5.10,5.25,5.50,5.84,6.16,6.52,6.89,7.26,7.62,8,8.40,8.84,9.25,9.73,10.20,10.65,11.12,11.61,12.12,12.57,12.89,13.20,13.37,13.51,13.62,13.66,13.72,13.75,13.77,13.84,13.87,13.89,13.95,13.97,13.99,14.03,14,14,14,15,14,14,14,13,12,10,8,8.33,8.52,9.60,10.45,11.12,11.46,11.33,11.10,10.90,10.87,10.98,11.22,11.25,10.45,9.25,8.07,7,6,5.12,4,4,3.62,2.73,0.99,-1.13,-2.29,-4.23,-4.88,-5.30,-6.13,-6.99,-7.43,-5.50,-3.13,-1.75,-1.04,0.10,1.37,2.12,2.37,2.62,3.12,3.47,3.62,3.99,4.61,5.02,6.49,9,12,14,14,14,14,14,15,15,15,15,15,15,16,16,16,16,15.36,15,14.63,14.28,13.95,13.59,13.21,12.77,12.35,11.87,11.35,10.78,10.25,9.72,9.22,8.75,8.39,8.13,8,7.99,8.09,8.28,8.62,9.01,9.50,10,10.50,11,11.49,11.90,12.28,12.62,12.91,13.15,13.37,13.53,13.71,13.83,13.90,14,14.08,14.12,14.15,14.21,14.24,14.25,14.26,14.28,14.33,14.36,14.37,14.37,14.33,14.23,14.15,14.14,14.23,14.34,14.46,14.57,14.63,14.74,14.84,14.96,15.10,15.23,15.34,15.37,15.37,15.23,15.03,14.84,14.59,14.32,14.03,13.78,13.59,13.40,13.35,13.36,13.46,13.58,13.73,13.88,14.10,14.32,14.58,14.86,15.13,15.45,15.66,15.87,16,16.12,16.21,16.26,16.35,16.37,16.36,16.27,16.13,15.98,15.75,15.58,15.50,15.60,15.78,16.09,16.39,16.74,17.07,17.38,17.63,17.77,17.87,17.96,18.12,18.28,18.50,18.70,18.87,19.02,19.23,19.41,19.63,19.84,19.99,20.10,20.14,20.20,20.20,20.14,20.10,19.97,19.77,19.58,19.36,19.12,18.98,18.85,18.75,18.63,18.53,18.45,18.35,18.25,18.20,18.15,18.16,18.22,18.26,18.36,18.48,18.62,18.85,19.11,19.39,19.74,20.07,20.34,20.53,20.73,20.87,21,21.11,21.22,21.28,21.36,21.25,20.87,19.71,16.59,13.50,13.10,12.49,11.95,11.49,11.23,11.15,11.28,11.52,11.77,12,12.21,12.32,12.37,12.38,12.40,12.40,12.39,12.35,12.21,11.98,11.64,11.25,10.74,10.12,9.48,8.75,8.03,7.36,6.71,6.12,5.65,5.35,5.13,5.09,5.12,5.28,5.53,5.88,6.27,6.72,7.12,7.53,7.96,8.34,8.71,9.10,9.50,9.89,10.34,10.75,11.15,11.53,11.89,12.28,12.64,12.98,13.24,13.41,13.59,13.70,13.76,13.83,13.87,13.89,13.90,13.95,13.97,13.98,13.99,14,14,14,14,14,14,14,13,12,12,11,11,9,6.50,7.71,8.72,9.61,10.16,10.37,10.12,9.87,9.62,9.64,9.87,10.25,10.50,10.25,8.84,7.75,6.78,6.03,5.14,5,5,4.75,2.86,1.89,-0.01,-2.13,-3.03,-4.90,-5.60,-5.99,-6.54,-7,-7.05,-4.75,-2.02,-0.11,1.26,2.95,4.75,4.97,5.37,5.71,5.75,5.95,6.25,6.47,6.75,9,11,13,14,13,14,14,14,14,15,15,15,15,16,16,16,16,16,15.62,15.23,14.84,14.50,14.13,13.83,13.47,13.10,12.66,12.24,11.75,11.24,10.72,10.16,9.65,9.20,8.76,8.45,8.22,8.10,8.09,8.21,8.41,8.75,9.13,9.62,10.11,10.61,11.09,11.51,11.95,12.28,12.62,12.87,13.12,13.32,13.47,13.59,13.70,13.77,13.86,13.90,13.98,14,14.02,14.08,14.09,14.10,14.11,14.12,14.11,14.08,13.99,13.90,13.87,13.88,13.97,14.09,14.21,14.33,14.45,14.57,14.66,14.82,14.96,15.08,15.12,15.12,15.09,14.91,14.72,14.41,14.12,13.82,13.51,13.27,13.12,13.02,13.09,13.21,13.37,13.61,13.84,14.03,14.27,14.52,14.78,15.09,15.36,15.62,15.85,16.02,16.20,16.33,16.41,16.50,16.61,16.62,16.63,16.60,16.49,16.37,16.15,16,15.85,15.82,15.87,16.02,16.26,16.53,16.85,17.12,17.38,17.59,17.71,17.82,17.98,18.16,18.37,18.60,18.77,18.99,19.20,19.39,19.62,19.85,20,20.14,20.25,20.33,20.35,20.32,20.22,20.07,19.86,19.62,19.37,19.21,19.07,18.97,18.87,18.82,18.73,18.62,18.50,18.45,18.39,18.38,18.41,18.48,18.52,18.62,18.72,18.85,19.02,19.27,19.60,19.90,20.25,20.57,20.78,21,21.14,21.28,21.40,21.51,21.62,21.62,21.48,21,19.62,16.72,12.85,12.46,11.88,11.41,11.14,11.12,11.28,11.50,11.76,12.01,12.24,12.37,12.46,12.48,12.47,12.46,12.41,12.37,12.25,12.10,11.85,11.49,11.01,10.49,9.86,9.16,8.48,7.75,7.11,6.50,6,5.60,5.34,5.22,5.23,5.37,5.61,5.96,6.37,6.84,7.32,7.77,8.25,8.62,9,9.37,9.75,10.12,10.51,10.89,11.26,11.62,11.87,12.12,12.37,12.62,12.88,13.13,13.37,13.53,13.70,13.82,13.87,13.95,13.97,13.98,13.98,13.99,13.99,14,14,14,14,14,14,14,14,13,11,10,11,10,8,6.16,6.50,7.74,7.85,8.12,8.20,7.96,7.75,7.75,7.87,8.12,8.50,9.27,8.97,7.91,6.90,6.50,5.82,5.78,6,6,5.75,4.10,1.96,1,-0.75,-2.98,-3.89,-4.60,-6,-6.13,-6.28,-6.17,-5.88,-4.13,-2.01,2.62,6.38,7.25,8.49,8.65,8.64,8.75,7.75,7.87,8,8,11,12,12,13,12,13,14,14,14,14,15,15,15,16,16,16,16,16,15.66,15.36,15,14.65,14.35,14.01,13.72,13.37,12.99,12.58,12.12,11.63,11.13,10.62,10.12,9.62,9.16,8.77,8.49,8.25,8.14,8.15,8.28,8.51,8.87,9.25,9.73,10.21,10.70,11.13,11.59,11.97,12.32,12.61,12.85,13.03,13.21,13.36,13.48,13.57,13.62,13.72,13.75,13.82,13.85,13.87,13.87,13.87,13.87,13.86,13.77,13.72,13.62,13.58,13.57,13.60,13.66,13.78,13.95,14.09,14.23,14.37,14.50,14.64,14.76,14.87,14.90,14.87,14.77,14.62,14.34,14,13.65,13.36,13.07,12.86,12.76,12.83,12.98,13.22,13.48,13.74,14,14.25,14.50,14.75,15,15.25,15.50,15.75,15.97,16.13,16.32,16.46,16.58,16.66,16.75,16.83,16.87,16.84,16.75,16.63,16.50,16.35,16.21,16.08,16,16,16.14,16.37,16.62,16.87,17.14,17.37,17.51,17.73,17.88,18.10,18.28,18.51,18.75,18.98,19.21,19.45,19.65,19.87,20.09,20.25,20.37,20.48,20.50,20.48,20.36,20.15,19.95,19.71,19.50,19.34,19.24,19.15,19.11,19.01,18.91,18.83,18.73,18.63,18.62,18.62,18.66,18.74,18.78,18.86,18.95,19.03,19.23,19.47,19.75,20.09,20.41,20.76,21.02,21.25,21.45,21.60,21.73,21.85,21.89,21.88,21.71,21.12,19.72,16.85,12.01,11.65,11.25,10.91,10.90,11.14,11.47,11.77,12.08,12.32,12.48,12.58,12.61,12.60,12.53,12.49,12.39,12.32,12.15,11.96,11.64,11.26,10.77,10.23,9.58,8.87,8.20,7.50,6.88,6.36,5.90,5.61,5.40,5.37,5.47,5.70,6,6.41,6.89,7.41,7.96,8.46,8.91,9.33,9.65,10,10.35,10.72,11.09,11.45,11.75,12,12.15,12.27,12.38,12.58,12.77,13.01,13.25,13.45,13.62,13.77,13.87,13.98,13.99,13.99,13.99,13.99,14,14,14,14,14,14,14,14,13,12,11,9,8,8,6,5,4.72,4.86,4.89,5.07,5.16,5.24,5.34,5.46,5.62,5.87,6.26,6.70,7.85,6.21,5.50,5.10,5.16,5.47,5.96,6,5.86,4.32,3.15,1.25,0.15,-1.68,-2.61,-4.25,-4.67,-5.79,-5.80,-5.51,-5.10,-4.25,-1.99,0.62,6.83,9.86,11,11,11,10,10,9,9,9,10,11,11,11,11,12,12,13,13,14,15,15,16,16,16,16,16,16,15.73,15.45,15.12,14.82,14.50,14.22,13.90,13.61,13.25,12.87,12.48,12.01,11.57,11.08,10.57,10.08,9.60,9.15,8.78,8.50,8.28,8.22,8.24,8.37,8.62,8.98,9.37,9.85,10.32,10.76,11.23,11.62,12,12.28,12.58,12.75,12.96,13.11,13.23,13.33,13.40,13.49,13.53,13.61,13.62,13.65,13.66,13.65,13.62,13.58,13.47,13.36,13.25,13.22,13.22,13.25,13.37,13.50,13.65,13.85,14,14.20,14.37,14.50,14.61,14.64,14.66,14.62,14.48,14.25,13.90,13.59,13.25,12.91,12.70,12.58,12.61,12.76,13.01,13.33,13.62,13.90,14.21,14.47,14.71,14.91,15.14,15.37,15.61,15.83,16.01,16.22,16.37,16.51,16.64,16.75,16.87,16.95,16.99,17,16.97,16.87,16.75,16.60,16.47,16.35,16.25,16.22,16.26,16.40,16.61,16.82,17.02,17.26,17.50,17.72,17.88,18.10,18.28,18.51,18.75,19,19.25,19.50,19.75,19.98,20.20,20.37,20.51,20.62,20.65,20.62,20.49,20.27,20.07,19.84,19.62,19.50,19.46,19.40,19.37,19.26,19.14,19.01,18.90,18.85,18.84,18.87,18.90,18.99,19.03,19.11,19.14,19.25,19.39,19.62,19.90,20.25,20.60,20.95,21.25,21.50,21.72,21.87,22,22.12,22.20,22.13,21.91,21.28,19.85,17.08,11.13,10.90,10.62,10.51,10.76,11.22,11.64,12.03,12.36,12.58,12.71,12.75,12.75,12.70,12.60,12.48,12.36,12.21,12,11.75,11.41,11,10.50,9.90,9.26,8.61,7.91,7.28,6.74,6.26,5.90,5.70,5.60,5.62,5.82,6.12,6.50,6.99,7.50,8.07,8.60,9.10,9.58,9.91,10.25,10.53,10.87,11.22,11.58,11.89,12.21,12.37,12.46,12.48,12.46,12.50,12.72,12.91,13.12,13.33,13.50,13.66,13.83,13.95,13.98,13.99,14,14,14,14,14,14,14,13,13,14,13,13,11,8,6,6,5,2.77,2.27,1.03,1.09,1.95,2.08,2.46,2.74,2.98,3.20,3.40,3.71,4.08,4.12,3.87,3.50,3.21,3.65,5.50,5.07,5.62,5.97,5.37,3.61,2.45,0.33,-0.60,-2.25,-3.66,-5.25,-5.53,-5.55,-5.25,-4.63,-3.67,-2.61,-0.63,3.60,9.57,11.98,13,13,12,12,11,10,9,9,10,9,10,10,10,11,12,13,14,15,15,16,16,16,16,16,16,15.75,15.50,15.22,14.91,14.63,14.37,14.11,13.82,13.50,13.13,12.76,12.37,11.91,11.47,10.99,10.50,10,9.57,9.12,8.76,8.50,8.32,8.25,8.27,8.47,8.74,9.10,9.50,9.98,10.45,10.87,11.28,11.65,12,12.25,12.49,12.66,12.84,12.97,13.08,13.15,13.25,13.32,13.37,13.39,13.45,13.46,13.45,13.38,13.32,13.13,13,12.89,12.85,12.86,12.90,13.03,13.23,13.41,13.62,13.85,14.01,14.21,14.33,14.38,14.45,14.38,14.32,14.12,13.84,13.51,13.21,12.87,12.62,12.46,12.46,12.60,12.86,13.15,13.50,13.84,14.12,14.39,14.64,14.87,15.08,15.25,15.47,15.64,15.86,16.02,16.23,16.38,16.57,16.70,16.82,16.89,17,17.03,17.09,17.08,17,16.90,16.78,16.66,16.58,16.49,16.45,16.45,16.52,16.65,16.85,17.07,17.32,17.58,17.77,17.99,18.16,18.37,18.61,18.86,19.11,19.37,19.62,19.86,20.10,20.32,20.50,20.64,20.75,20.77,20.73,20.60,20.37,20.15,19.97,19.82,19.74,19.70,19.65,19.62,19.51,19.37,19.23,19.10,19.01,19.01,19.09,19.14,19.24,19.28,19.35,19.37,19.47,19.59,19.77,20.07,20.37,20.74,21.10,21.46,21.73,21.96,22.12,22.27,22.38,22.46,22.38,22.14,21.50,20,17.37,10.40,10.26,10.14,10.28,10.75,11.27,11.83,12.25,12.57,12.75,12.86,12.87,12.83,12.72,12.57,12.38,12.22,12,11.75,11.48,11.12,10.66,10.15,9.59,8.97,8.32,7.70,7.12,6.62,6.25,6,5.87,5.87,6,6.25,6.62,7.08,7.60,8.13,8.71,9.23,9.70,10.10,10.47,10.73,11,11.28,11.62,12,12.33,12.59,12.73,12.74,12.70,12.61,12.62,12.75,12.90,13.08,13.22,13.36,13.50,13.63,13.82,13.95,13.96,13.98,14,14,14,14,14,13,12,13,13,13,12,10,7,5,4,2.58,1.01,0.49,0.11,-0.25,-0.64,-0.75,-0.29,0.25,0.62,0.89,1.01,1.24,1.50,1.59,1.50,0.66,0.65,1.47,3.62,5.10,4.63,5.25,5.32,3.75,2.75,0.65,-0.24,-1.88,-3.62,-4.10,-5.25,-5.37,-5.13,-4.63,-3.87,-3.04,-1.93,1.02,5,10.96,13,14,14,14,13,12,11,11,10,11,11,11,11,11,13,14,14,15,15,16,16,16,16,16,16,15.85,15.58,15.27,15.01,14.75,14.50,14.25,13.99,13.70,13.37,13.02,12.64,12.25,11.84,11.37,10.88,10.40,9.96,9.50,9.09,8.73,8.47,8.28,8.25,8.35,8.53,8.86,9.23,9.64,10.12,10.53,10.98,11.36,11.70,11.96,12.20,12.37,12.52,12.66,12.78,12.88,12.99,13.03,13.11,13.12,13.14,13.16,13.16,13.12,13,12.85,12.66,12.58,12.50,12.51,12.62,12.76,12.99,13.22,13.46,13.66,13.87,14.01,14.12,14.15,14.14,14.09,13.95,13.71,13.45,13.14,12.86,12.61,12.40,12.37,12.48,12.71,13.01,13.37,13.73,14.07,14.36,14.61,14.82,15,15.15,15.34,15.50,15.65,15.85,16.01,16.22,16.37,16.53,16.70,16.82,16.90,17,17.08,17.12,17.12,17.11,17.02,16.95,16.85,16.75,16.70,16.64,16.66,16.74,16.84,16.99,17.16,17.45,17.71,17.95,18.14,18.37,18.58,18.77,19.01,19.25,19.50,19.75,20,20.24,20.46,20.63,20.77,20.87,20.87,20.78,20.65,20.49,20.27,20.12,20,19.96,19.95,19.91,19.87,19.75,19.60,19.39,19.25,19.20,19.22,19.27,19.37,19.48,19.52,19.58,19.61,19.64,19.75,19.95,20.20,20.50,20.86,21.23,21.62,21.89,22.14,22.37,22.51,22.63,22.71,22.62,22.38,21.74,20.25,17.70,9.87,9.86,9.95,10.25,10.78,11.37,11.90,12.36,12.64,12.84,12.89,12.87,12.78,12.62,12.45,12.22,11.98,11.72,11.45,11.12,10.74,10.27,9.76,9.22,8.62,8,7.47,6.98,6.59,6.28,6.13,6.12,6.24,6.46,6.77,7.22,7.71,8.25,8.78,9.34,9.83,10.25,10.59,10.88,11.12,11.37,11.66,12,12.36,12.65,12.90,13.02,13,12.91,12.84,12.83,12.88,13,13.12,13.16,13.24,13.33,13.40,13.57,13.73,13.85,13.98,13.99,14,14,14,13,12,12,12,12,12,11,9,6,3.76,2.25,0.86,0.14,-0.29,-0.61,-1.15,-1.38,-1.37,-0.91,-0.62,-0.38,-0.27,-0.23,-0.12,-0.11,-0.16,-0.37,-0.48,-0.67,-1.09,1.07,3.40,3.91,4.61,4.98,3.62,2.87,2.01,0.37,-1.55,-3.27,-3.90,-5.30,-5.39,-5.38,-5.14,-4.64,-3.78,-2.64,-1.53,1.62,6.50,11.99,14,14,14,14,14,13,12,11,12,13,13,12,13,14,14,14,15,15,16,16,16,16,16,16,15.86,15.62,15.37,15.12,14.87,14.62,14.37,14.12,13.86,13.57,13.25,12.89,12.53,12.13,11.73,11.26,10.82,10.34,9.86,9.38,8.99,8.63,8.39,8.27,8.27,8.39,8.63,8.99,9.37,9.78,10.24,10.63,11.01,11.35,11.62,11.87,12.07,12.24,12.37,12.50,12.60,12.63,12.71,12.75,12.77,12.84,12.87,12.87,12.83,12.70,12.50,12.37,12.25,12.20,12.24,12.35,12.52,12.76,13.01,13.26,13.50,13.66,13.83,13.88,13.87,13.82,13.70,13.50,13.27,13.07,12.83,12.61,12.45,12.37,12.45,12.63,12.91,13.25,13.62,13.97,14.26,14.52,14.75,14.91,15.09,15.22,15.36,15.50,15.64,15.83,16,16.15,16.35,16.50,16.64,16.77,16.88,17,17.08,17.12,17.12,17.12,17.10,17.01,16.96,16.88,16.87,16.86,16.87,16.96,17.02,17.15,17.36,17.62,17.87,18.12,18.37,18.62,18.84,19.03,19.26,19.50,19.73,19.96,20.15,20.38,20.61,20.76,20.89,20.97,20.96,20.87,20.75,20.60,20.41,20.28,20.22,20.16,20.16,20.15,20.11,19.98,19.77,19.60,19.41,19.37,19.37,19.49,19.61,19.72,19.76,19.82,19.84,19.86,19.91,20.08,20.28,20.60,20.91,21.28,21.66,22.02,22.32,22.52,22.73,22.86,22.90,22.87,22.63,22.02,20.74,18.11,9.59,9.64,9.88,10.34,10.87,11.47,11.99,12.38,12.65,12.82,12.86,12.78,12.64,12.46,12.21,11.90,11.62,11.34,11,10.65,10.26,9.84,9.35,8.82,8.25,7.74,7.25,6.87,6.59,6.40,6.37,6.48,6.66,6.99,7.37,7.86,8.37,8.89,9.45,9.95,10.37,10.74,11,11.25,11.50,11.74,12,12.35,12.70,12.99,13.23,13.33,13.26,13.15,13.07,13.01,13.09,13.16,13.25,13.25,13.23,13.21,13.22,13.25,13.39,13.60,13.75,13.87,14,14,13,13,12,11,11,11,10,10,7,3.65,2.24,0.65,0.20,-0.43,-0.88,-1.26,-1.85,-2.01,-1.72,-1.42,-1.15,-1.01,-0.97,-0.91,-0.91,-0.97,-1.03,-1.16,-1.36,-1.63,-2.14,-1.54,-0.01,2.37,3.77,4.35,4.14,2.50,1.99,0.22,-1.61,-2.41,-3.92,-4.62,-6,-6.10,-5.88,-5.35,-4.50,-3.65,-2.60,-1.15,4.15,10.75,14,14,14,14,14,14,13,12,13,14,14,14,13,14,14,14,14,15,16,16,16,16,16,16,15.87,15.63,15.45,15.20,14.96,14.72,14.49,14.25,14,13.73,13.41,13.12,12.77,12.41,12.02,11.62,11.15,10.70,10.21,9.73,9.25,8.87,8.53,8.36,8.25,8.33,8.50,8.75,9.12,9.50,9.91,10.33,10.66,11,11.28,11.51,11.73,11.87,12,12.12,12.20,12.25,12.32,12.35,12.37,12.41,12.48,12.49,12.45,12.33,12.15,12,11.89,11.87,11.95,12.10,12.32,12.58,12.84,13.10,13.28,13.47,13.52,13.52,13.50,13.39,13.25,13.07,12.87,12.71,12.57,12.46,12.40,12.48,12.63,12.88,13.21,13.52,13.87,14.21,14.48,14.71,14.87,15,15.12,15.24,15.36,15.49,15.62,15.77,15.97,16.12,16.28,16.47,16.62,16.75,16.87,16.97,17.02,17.10,17.12,17.12,17.11,17.08,17.01,17,17,17.01,17.09,17.13,17.25,17.37,17.52,17.77,18.03,18.34,18.62,18.87,19.12,19.36,19.58,19.76,19.98,20.15,20.37,20.59,20.75,20.91,21.02,21.08,21.03,20.97,20.86,20.74,20.61,20.50,20.46,20.45,20.45,20.40,20.35,20.20,20,19.76,19.62,19.53,19.60,19.71,19.84,19.96,20.01,20.07,20.07,20.07,20.10,20.21,20.38,20.64,20.99,21.36,21.73,22.12,22.39,22.64,22.87,23,23.12,23.12,22.96,22.40,21.37,18.52,9.39,9.59,9.90,10.39,10.99,11.57,12.02,12.38,12.62,12.73,12.72,12.62,12.40,12.14,11.86,11.51,11.21,10.87,10.50,10.14,9.75,9.34,8.87,8.38,7.90,7.48,7.10,6.82,6.63,6.61,6.66,6.87,7.20,7.59,8.01,8.51,9.03,9.58,10.08,10.50,10.87,11.15,11.38,11.61,11.82,12.03,12.34,12.65,13,13.27,13.50,13.58,13.50,13.37,13.25,13.21,13.25,13.37,13.47,13.41,13.33,13.16,13.11,13.02,13.12,13.24,13.13,13.99,14,14,13,12,11,10,9,9,8,8,4.65,2.37,0.75,0.12,-0.50,-1.12,-1.50,-1.88,-2.34,-2.50,-2.04,-1.74,-1.51,-1.42,-1.38,-1.38,-1.40,-1.50,-1.60,-1.73,-1.90,-2.22,-2.59,-2.93,-2.98,-0.79,1.60,2.01,2.75,2.50,2.07,0.41,-1.28,-2.89,-4.76,-5.25,-6.38,-6.48,-6.18,-5.73,-5.16,-4.38,-3.30,-1.98,1.27,8.59,12.99,14,14,14,14,14,14,14,14,14,14,14,13,13,14,14,14,15,16,16,16,16,16,16,15.88,15.71,15.49,15.25,15,14.77,14.58,14.35,14.11,13.86,13.59,13.28,13,12.66,12.33,11.91,11.50,11.02,10.52,10.02,9.53,9.11,8.73,8.46,8.28,8.26,8.37,8.60,8.87,9.25,9.62,10,10.34,10.64,10.90,11.12,11.32,11.48,11.60,11.66,11.75,11.83,11.86,11.88,11.91,11.97,12,12,11.98,11.87,11.75,11.62,11.52,11.52,11.62,11.82,12.07,12.35,12.62,12.87,13.07,13.15,13.20,13.13,13.02,12.88,12.75,12.62,12.50,12.40,12.37,12.40,12.50,12.66,12.89,13.16,13.50,13.83,14.12,14.39,14.62,14.82,14.95,15.02,15.12,15.23,15.33,15.45,15.60,15.75,15.90,16.09,16.25,16.40,16.58,16.71,16.83,16.90,17,17.07,17.10,17.11,17.11,17.09,17.08,17.08,17.11,17.14,17.25,17.34,17.45,17.57,17.72,17.95,18.22,18.50,18.83,19.12,19.39,19.65,19.88,20.09,20.25,20.40,20.60,20.75,20.96,21.10,21.20,21.22,21.16,21.10,21,20.88,20.82,20.75,20.72,20.71,20.71,20.65,20.59,20.40,20.22,20,19.84,19.75,19.82,19.90,20.08,20.21,20.27,20.33,20.32,20.26,20.25,20.34,20.48,20.72,21,21.37,21.75,22.13,22.47,22.74,22.97,23.13,23.26,23.36,23.25,23,22.12,19.88,9.25,9.50,9.95,10.50,11.12,11.64,12.10,12.37,12.53,12.59,12.50,12.36,12.11,11.77,11.45,11.07,10.70,10.34,9.98,9.61,9.23,8.83,8.38,7.99,7.60,7.25,6.99,6.83,6.76,6.86,7.07,7.37,7.75,8.21,8.71,9.22,9.73,10.22,10.64,11.01,11.34,11.53,11.74,11.89,12.12,12.36,12.63,12.99,13.28,13.58,13.74,13.76,13.70,13.52,13.37,13.28,13.32,13.40,13.59,13.60,13.46,13.25,13.02,13.01,13.12,13.15,13.01,14,14,14,13,12,11,10,8,7,7,5.76,3.40,0.77,-0.03,-0.62,-1.18,-1.80,-2.18,-2.63,-3.09,-2.88,-2.37,-1.98,-1.75,-1.67,-1.64,-1.63,-1.75,-1.87,-1.98,-2.09,-2.27,-2.54,-3.02,-3.73,-3.89,-2.75,-1.68,0.65,1.71,1.48,0.21,-0.28,-2.10,-3.74,-5.23,-5.66,-6.75,-6.49,-6.39,-6.13,-5.60,-4.85,-3.75,-2.62,-0.38,3.87,10.86,14,14,14,14,14,14,14,14,15,14,14,14,13,14,14,15,15,16,16,16,16,16,16,15.89,15.75,15.51,15.32,15.10,14.87,14.62,14.40,14.20,13.96,13.72,13.46,13.16,12.87,12.57,12.21,11.78,11.35,10.86,10.35,9.84,9.35,8.90,8.59,8.36,8.25,8.28,8.45,8.66,8.99,9.33,9.64,9.98,10.25,10.50,10.72,10.87,11.02,11.13,11.24,11.28,11.36,11.37,11.38,11.39,11.41,11.45,11.45,11.40,11.36,11.25,11.15,11.12,11.15,11.28,11.50,11.76,12.08,12.35,12.59,12.73,12.76,12.75,12.64,12.51,12.38,12.27,12.21,12.15,12.21,12.33,12.48,12.66,12.90,13.20,13.50,13.78,14.10,14.36,14.58,14.75,14.87,14.97,15.01,15.11,15.16,15.26,15.38,15.52,15.71,15.87,16.02,16.22,16.37,16.51,16.64,16.76,16.87,16.96,17,17.03,17.08,17.08,17.09,17.10,17.12,17.20,17.26,17.37,17.49,17.61,17.73,17.87,18.10,18.36,18.64,19,19.34,19.63,19.95,20.16,20.37,20.50,20.63,20.78,20.97,21.12,21.25,21.36,21.37,21.34,21.25,21.16,21.11,21.03,21,21,20.99,20.98,20.91,20.84,20.65,20.47,20.25,20.09,20,20.03,20.14,20.32,20.46,20.53,20.59,20.58,20.50,20.47,20.48,20.58,20.75,21.02,21.37,21.75,22.13,22.49,22.76,23.02,23.25,23.45,23.57,23.71,23.48,22.51,19.98,9.09,9.39,9.97,10.62,11.25,11.75,12.12,12.36,12.41,12.38,12.25,12.01,11.73,11.36,10.96,10.52,10.13,9.75,9.37,9.01,8.65,8.32,7.96,7.62,7.33,7.09,6.91,6.88,6.98,7.16,7.49,7.87,8.35,8.86,9.37,9.87,10.37,10.82,11.20,11.50,11.72,11.87,12.01,12.16,12.37,12.62,12.95,13.25,13.58,13.78,13.89,13.89,13.77,13.62,13.46,13.32,13.26,13.37,13.52,13.61,13.50,13.26,13.01,13.12,13.15,13.96,14,14,14,13,13,12,11,10,9,8,7,4.60,1.88,0.13,-0.63,-1.13,-1.72,-2.28,-2.68,-3.12,-3.55,-3.26,-2.61,-2.16,-1.90,-1.74,-1.63,-1.63,-1.78,-1.88,-2,-2.23,-2.49,-2.87,-3.47,-4.38,-4.63,-4.76,-3.72,-1.28,1.01,-0.22,-0.48,-1.13,-2.99,-4.68,-5.85,-5.99,-6.13,-6.99,-6.55,-6.28,-5.75,-5,-3.98,-3.01,-1.79,2.32,8.50,13,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,16,16,16,16,16,16,16,15.95,15.76,15.59,15.37,15.14,14.91,14.71,14.49,14.25,14.03,13.83,13.59,13.34,13.07,12.75,12.41,12.03,11.62,11.13,10.62,10.11,9.59,9.12,8.74,8.45,8.27,8.25,8.33,8.50,8.75,9.01,9.33,9.61,9.87,10.11,10.27,10.46,10.60,10.71,10.77,10.84,10.86,10.87,10.86,10.85,10.84,10.83,10.82,10.76,10.74,10.65,10.62,10.62,10.73,10.87,11.12,11.40,11.71,11.98,12.15,12.26,12.26,12.20,12.09,11.98,11.87,11.84,11.87,11.96,12.11,12.34,12.61,12.87,13.16,13.49,13.77,14.07,14.32,14.50,14.65,14.77,14.87,14.91,14.99,15.02,15.12,15.22,15.34,15.49,15.63,15.83,16,16.15,16.34,16.48,16.62,16.73,16.83,16.88,16.96,17,17,17.02,17.07,17.10,17.14,17.25,17.35,17.48,17.62,17.73,17.86,18,18.21,18.47,18.75,19.11,19.47,19.82,20.12,20.37,20.59,20.73,20.85,20.98,21.12,21.27,21.40,21.50,21.51,21.50,21.41,21.37,21.33,21.27,21.26,21.26,21.25,21.25,21.20,21.09,20.91,20.73,20.50,20.36,20.26,20.28,20.39,20.57,20.71,20.83,20.87,20.85,20.76,20.71,20.65,20.72,20.86,21.11,21.39,21.75,22.12,22.50,22.83,23.12,23.37,23.60,23.75,23.78,23.60,22.62,21.07,8.96,9.37,10.02,10.75,11.38,11.88,12.15,12.27,12.26,12.14,11.95,11.63,11.27,10.87,10.41,10,9.58,9.16,8.82,8.48,8.13,7.85,7.53,7.28,7.11,6.99,6.97,7.03,7.25,7.57,7.98,8.45,8.97,9.50,10,10.50,10.97,11.36,11.64,11.88,12.07,12.16,12.27,12.45,12.62,12.88,13.21,13.50,13.75,13.95,14,13.95,13.78,13.61,13.40,13.25,13.15,13.24,13.37,13.50,13.48,13.28,13,13.12,13.97,14,14,14,14,13,13,13,12,11,10,10,7.87,4.12,1.48,-0.29,-1.05,-1.53,-2,-2.61,-3.01,-3.38,-3.80,-3.52,-2.80,-2.27,-1.90,-1.63,-1.49,-1.39,-1.52,-1.65,-1.88,-2.16,-2.51,-3.03,-3.78,-4.80,-5.30,-5.50,-5.38,-3.99,-0.61,-0.47,-0.88,-2.59,-3.63,-5.37,-5.50,-6.38,-6.35,-7.23,-6.74,-6.24,-5.67,-4.88,-4.13,-3.24,-2.03,-0.03,5.12,11.99,14,14,14,14,14,14,14,14,14,15,14,14,14,14,15,16,16,16,16,16,16,16,16,15.85,15.63,15.45,15.22,14.99,14.75,14.53,14.34,14.12,13.89,13.70,13.47,13.22,12.95,12.62,12.26,11.87,11.38,10.87,10.36,9.83,9.34,8.88,8.57,8.34,8.23,8.23,8.34,8.52,8.75,9,9.25,9.49,9.70,9.87,10.02,10.15,10.25,10.34,10.36,10.36,10.34,10.28,10.25,10.21,10.14,10.12,10.10,10.03,10,10.01,10.09,10.22,10.39,10.65,10.97,11.24,11.48,11.62,11.70,11.64,11.59,11.49,11.40,11.38,11.45,11.58,11.78,12.09,12.39,12.75,13.11,13.45,13.75,14,14.25,14.45,14.59,14.66,14.75,14.78,14.85,14.87,14.95,15,15.12,15.25,15.39,15.59,15.75,15.95,16.12,16.25,16.40,16.53,16.64,16.75,16.83,16.87,16.90,16.96,16.99,17.01,17.09,17.16,17.27,17.39,17.53,17.66,17.83,17.95,18.10,18.27,18.51,18.84,19.15,19.51,19.87,20.23,20.50,20.71,20.86,20.98,21.12,21.25,21.40,21.57,21.63,21.65,21.64,21.62,21.58,21.53,21.52,21.53,21.53,21.53,21.50,21.46,21.35,21.20,21,20.78,20.62,20.57,20.58,20.65,20.82,20.97,21.10,21.13,21.13,21.10,21,20.95,20.96,21.02,21.23,21.50,21.82,22.12,22.46,22.77,23.10,23.37,23.62,23.78,23.87,23.65,22.78,20.20,8.95,9.39,10.16,10.89,11.59,12,12.14,12.14,12.03,11.86,11.57,11.22,10.78,10.35,9.87,9.41,9,8.62,8.25,7.97,7.66,7.45,7.24,7.09,7,6.99,7.09,7.26,7.60,8,8.49,9,9.57,10.11,10.62,11.10,11.50,11.83,12.07,12.24,12.35,12.41,12.51,12.65,12.87,13.12,13.41,13.70,13.88,13.99,13.98,13.87,13.71,13.49,13.27,13.12,13.01,13.07,13.15,13.32,13.57,13.24,13.12,13,13,13,13,13,13,14,13,13,13,12,11,11,7.59,2.76,1.12,-0.54,-1.29,-1.79,-2.13,-2.75,-3.13,-3.38,-3.85,-3.87,-3,-2.30,-1.77,-1.39,-1.15,-1.01,-1.13,-1.28,-1.60,-1.99,-2.48,-3.16,-4.05,-5.13,-5.76,-5.91,-5.86,-4.40,-3.13,-0.75,-1.90,-2.77,-3.85,-5.61,-5.77,-6.50,-6.24,-7.10,-6.63,-5.88,-5.38,-4.88,-4.13,-3.18,-2.24,-1.25,3.89,9.84,14,14,14,14,14,13,14,15,14,14,14,15,15,14,15,16,16,16,16,16,16,16,16,15.88,15.72,15.50,15.26,15.03,14.83,14.61,14.38,14.20,13.99,13.77,13.58,13.35,13.10,12.78,12.47,12.08,11.62,11.12,10.60,10.07,9.52,9.08,8.66,8.38,8.23,8.15,8.23,8.35,8.50,8.71,8.90,9.12,9.33,9.49,9.62,9.75,9.85,9.88,9.89,9.87,9.84,9.75,9.66,9.59,9.50,9.45,9.37,9.36,9.36,9.38,9.50,9.65,9.88,10.14,10.45,10.70,10.87,11,11.02,11,10.90,10.87,10.87,10.95,11.10,11.35,11.66,12.08,12.49,12.90,13.28,13.63,13.95,14.15,14.35,14.48,14.57,14.62,14.63,14.65,14.71,14.75,14.82,14.88,15,15.13,15.32,15.49,15.65,15.86,16,16.16,16.33,16.46,16.53,16.62,16.72,16.75,16.82,16.86,16.88,16.97,17.07,17.15,17.32,17.46,17.60,17.73,17.87,17.99,18.12,18.32,18.57,18.85,19.15,19.50,19.87,20.23,20.50,20.74,20.89,21.07,21.22,21.37,21.51,21.65,21.75,21.82,21.83,21.78,21.76,21.76,21.77,21.78,21.82,21.82,21.76,21.72,21.61,21.46,21.25,21.08,20.89,20.84,20.85,20.91,21.09,21.24,21.37,21.45,21.47,21.41,21.37,21.28,21.27,21.35,21.49,21.70,21.96,22.22,22.50,22.85,23.13,23.41,23.66,23.87,23.98,23.75,22.98,20.28,9.11,9.61,10.36,11.09,11.66,12,12.07,11.96,11.75,11.48,11.12,10.73,10.26,9.82,9.34,8.87,8.47,8.11,7.77,7.50,7.28,7.12,7,6.97,6.99,7.10,7.28,7.60,8,8.48,9,9.59,10.13,10.66,11.15,11.60,11.95,12.22,12.38,12.51,12.61,12.66,12.75,12.88,13.10,13.34,13.61,13.82,13.95,13.97,13.87,13.73,13.50,13.32,13.08,12.87,12.78,12.85,12.97,13.12,13.21,13.89,13,13,13,13,13,13,13,13,14,14,13,13,13,10,6.36,2.59,0.96,-0.66,-1.42,-2.03,-2.49,-2.89,-3.30,-3.47,-4.05,-4.10,-3.13,-2.26,-1.54,-0.99,-0.65,-0.48,-0.52,-0.76,-1.13,-1.63,-2.34,-3.18,-4.27,-5.50,-5.97,-6.13,-6,-5.60,-4.38,-1.77,-1.91,-2.73,-3.62,-5.38,-5.62,-6.29,-5.90,-6.63,-6.23,-5.63,-5.15,-4.64,-3.91,-3,-2.25,-1.28,2.87,9.74,13,14,14,13,13,13,12,13,13,13,14,15,15,14,15,15,16,16,16,16,16,16,16,15.98,15.78,15.59,15.36,15.11,14.87,14.64,14.46,14.25,14.07,13.87,13.66,13.47,13.23,12.95,12.62,12.25,11.83,11.34,10.82,10.26,9.75,9.25,8.83,8.49,8.26,8.13,8.12,8.16,8.27,8.45,8.62,8.82,8.98,9.12,9.25,9.37,9.47,9.50,9.50,9.48,9.38,9.28,9.16,9.07,8.91,8.84,8.75,8.75,8.75,8.84,8.97,9.14,9.38,9.65,9.90,10.12,10.26,10.36,10.37,10.32,10.25,10.25,10.36,10.51,10.82,11.15,11.60,12.07,12.52,13.01,13.46,13.76,14.01,14.22,14.34,14.39,14.46,14.48,14.49,14.50,14.50,14.58,14.62,14.74,14.86,15,15.16,15.36,15.52,15.72,15.87,16.02,16.15,16.27,16.37,16.48,16.52,16.60,16.63,16.71,16.75,16.87,16.99,17.12,17.28,17.46,17.61,17.73,17.86,17.98,18.12,18.27,18.51,18.82,19.12,19.47,19.83,20.14,20.47,20.73,20.91,21.12,21.27,21.48,21.62,21.77,21.88,21.97,22,22,22,22,22,22.02,22.07,22.03,22,21.96,21.84,21.70,21.50,21.33,21.15,21.11,21.12,21.22,21.37,21.50,21.63,21.75,21.77,21.76,21.75,21.72,21.70,21.73,21.84,22,22.22,22.45,22.74,23,23.26,23.52,23.76,23.98,24.08,23.96,23.28,21.32,9.41,9.88,10.57,11.20,11.65,11.87,11.84,11.63,11.37,11.02,10.62,10.21,9.74,9.25,8.78,8.37,7.99,7.63,7.37,7.16,7.01,6.95,6.90,6.98,7.10,7.28,7.61,7.99,8.46,8.99,9.53,10.12,10.66,11.20,11.62,12,12.32,12.51,12.65,12.75,12.84,12.89,13,13.12,13.33,13.51,13.75,13.87,13.96,13.89,13.75,13.50,13.24,13,12.76,12.53,12.40,12.46,12.70,12.87,13.01,13,13,13,13,13,13,13,13,13,14,15,14,14,13,10.87,7.23,2.48,0.85,-0.88,-1.84,-2.49,-2.90,-3.14,-3.50,-4.67,-4.25,-4.05,-3.26,-2.14,-1.18,-0.43,0.07,0.25,0.20,-0.05,-0.51,-1.17,-2.03,-3.14,-4.48,-5.41,-5.89,-6.01,-5.87,-5.72,-4.38,-3.84,-2.64,-2.43,-4.41,-5.10,-6.25,-5.99,-5.50,-6.25,-5.90,-5.29,-4.76,-4.25,-3.50,-2.88,-2.13,-1.15,3,9.72,13,14,13,12,11,11,11,11,11,12,14,15,16,15,15,15,15,16,16,16,16,16,16,16,15.86,15.65,15.41,15.14,14.90,14.71,14.50,14.33,14.12,13.97,13.75,13.57,13.33,13.07,12.75,12.38,11.99,11.50,11,10.48,9.95,9.41,8.98,8.62,8.34,8.13,8.03,8.03,8.11,8.22,8.37,8.52,8.70,8.84,8.97,9.08,9.14,9.21,9.21,9.15,9.10,8.99,8.86,8.71,8.53,8.41,8.35,8.34,8.37,8.46,8.60,8.77,9,9.25,9.48,9.62,9.74,9.75,9.75,9.71,9.66,9.75,9.89,10.16,10.52,10.99,11.48,12,12.51,13,13.49,13.77,13.99,14.12,14.22,14.25,14.25,14.25,14.25,14.26,14.32,14.37,14.45,14.53,14.66,14.84,15,15.15,15.35,15.50,15.65,15.83,15.96,16.07,16.14,16.24,16.28,16.36,16.40,16.49,16.59,16.72,16.87,17.07,17.24,17.39,17.53,17.64,17.75,17.88,18.02,18.23,18.47,18.75,19.07,19.38,19.75,20.10,20.39,20.71,20.95,21.15,21.37,21.59,21.75,21.91,22.07,22.13,22.20,22.22,22.23,22.24,22.25,22.26,22.27,22.26,22.25,22.15,22.07,21.89,21.73,21.53,21.40,21.37,21.39,21.50,21.64,21.82,21.95,22.02,22.11,22.12,22.12,22.12,22.12,22.15,22.25,22.37,22.57,22.75,23,23.25,23.49,23.71,23.88,24.09,24.21,24.20,23.49,21.16,9.88,10.26,10.75,11.25,11.57,11.62,11.50,11.26,10.95,10.53,10.12,9.64,9.21,8.75,8.32,7.89,7.58,7.27,7.09,6.95,6.87,6.87,6.96,7.10,7.33,7.62,8,8.46,8.97,9.50,10.09,10.62,11.15,11.62,12.01,12.36,12.61,12.76,12.88,12.99,13.03,13.12,13.25,13.37,13.57,13.74,13.87,13.91,13.91,13.82,13.58,13.25,12.88,12.60,12.28,12,11.85,11.84,12.01,13,13,13,13,13,13,13,13,13,13,13,14,14,15,14,13,9.76,6.25,3.49,0.51,-1.25,-2,-2.68,-3.13,-3.39,-4.42,-4.63,-4.26,-3.88,-3.11,-2,-0.75,0.25,0.91,1.20,1.11,0.75,0.22,-0.63,-1.67,-3.01,-4.25,-5.10,-5.53,-5.63,-5.60,-5.51,-5.15,-3.85,-3.55,-2.80,-3.88,-5.61,-5.74,-5.43,-6,-5.67,-5.37,-4.75,-4.15,-3.66,-3.23,-2.63,-1.87,-0.88,3.12,9.75,13,13,12,11,9,10,12,12,11,13,14,15,16,16,15,15,15,15,15,16,16,16,16,16,15.98,15.75,15.50,15.23,14.96,14.75,14.57,14.37,14.23,14.02,13.86,13.63,13.39,13.14,12.86,12.50,12.11,11.64,11.15,10.63,10.12,9.61,9.13,8.74,8.40,8.16,8.01,7.97,7.98,8.09,8.21,8.34,8.48,8.62,8.75,8.87,8.96,9,9.02,9.01,8.97,8.87,8.75,8.61,8.46,8.33,8.24,8.23,8.26,8.37,8.49,8.64,8.86,9.02,9.20,9.27,9.33,9.32,9.25,9.22,9.23,9.34,9.57,9.88,10.33,10.78,11.34,11.87,12.39,12.87,13.26,13.62,13.78,13.90,13.99,14.01,14.01,14.01,14.02,14.03,14.09,14.12,14.23,14.34,14.47,14.62,14.76,14.95,15.11,15.25,15.39,15.52,15.64,15.75,15.87,15.96,16,16.09,16.13,16.24,16.36,16.51,16.73,16.95,17.13,17.33,17.46,17.57,17.65,17.75,17.89,18.12,18.37,18.64,18.98,19.33,19.66,20.02,20.37,20.66,20.97,21.23,21.48,21.71,21.90,22.12,22.25,22.37,22.41,22.46,22.48,22.49,22.50,22.50,22.50,22.50,22.47,22.37,22.25,22.12,21.91,21.75,21.64,21.62,21.70,21.82,21.97,22.11,22.24,22.35,22.40,22.49,22.50,22.53,22.58,22.61,22.65,22.77,22.95,23.12,23.34,23.53,23.73,23.87,24.07,24.15,24.22,24.07,23.34,21.08,10.45,10.66,10.98,11.25,11.38,11.37,11.14,10.86,10.47,10.02,9.60,9.12,8.70,8.25,7.87,7.52,7.25,7.02,6.88,6.84,6.85,6.91,7.11,7.35,7.63,8.01,8.48,8.97,9.50,10.03,10.60,11.12,11.60,12,12.35,12.62,12.83,12.98,13.08,13.14,13.25,13.37,13.50,13.65,13.84,13.97,14,13.99,13.87,13.66,13.37,12.96,12.48,12.07,11.74,11.38,11.11,10.97,11,11,11,12,12,13,13,13,13,13,13,13,14,14,15,13,12,9.75,6.34,3.25,0.33,-1.48,-2.01,-2.74,-3.16,-4.43,-4.51,-4.40,-4.10,-3.62,-2.63,-1.60,-0.30,1,1.86,2.20,2.11,1.65,1,0,-1.23,-2.42,-3.55,-4.49,-4.91,-5.09,-5.23,-5.13,-4.79,-4.62,-4.25,-3.40,-4.23,-4.68,-5.78,-5.53,-5.13,-4.88,-4.50,-3.91,-3.53,-3.25,-2.79,-2.24,-1.41,-0.50,3.34,8.86,12,13,12,10,9,12,13,13,12,14,15,15,15,16,15,15,15,15,15,15,16,16,16,16,16,15.87,15.60,15.27,15,14.76,14.62,14.47,14.28,14.12,13.91,13.73,13.49,13.23,12.91,12.59,12.21,11.75,11.28,10.77,10.26,9.75,9.27,8.87,8.51,8.25,8.03,7.95,7.91,8,8.10,8.22,8.36,8.50,8.65,8.82,8.91,9.01,9.11,9.12,9.12,9.11,9.02,8.95,8.85,8.75,8.73,8.72,8.72,8.74,8.75,8.87,8.99,9.10,9.14,9.15,9.13,9.09,9,8.95,8.97,9.11,9.37,9.72,10.13,10.62,11.13,11.64,12.14,12.62,12.97,13.26,13.48,13.61,13.66,13.73,13.75,13.75,13.77,13.82,13.86,13.90,14,14.11,14.24,14.37,14.51,14.66,14.84,14.98,15.11,15.24,15.36,15.47,15.58,15.65,15.75,15.84,15.90,16,16.14,16.36,16.59,16.83,17.03,17.24,17.37,17.48,17.53,17.62,17.76,18,18.26,18.58,18.89,19.26,19.62,20,20.37,20.71,21,21.32,21.59,21.86,22.11,22.34,22.50,22.62,22.71,22.73,22.74,22.74,22.75,22.75,22.75,22.74,22.70,22.61,22.49,22.33,22.13,22,21.88,21.88,21.98,22.11,22.25,22.39,22.51,22.62,22.73,22.78,22.87,22.90,22.98,23,23.08,23.14,23.27,23.48,23.62,23.83,23.91,24.02,24.11,24.10,23.98,23.62,22.71,21,10.89,11,11.14,11.25,11.22,11.03,10.75,10.38,9.98,9.51,9.08,8.62,8.23,7.85,7.50,7.25,7.02,6.88,6.84,6.86,6.95,7.12,7.37,7.70,8.08,8.50,9,9.50,10.03,10.59,11.09,11.53,11.97,12.32,12.60,12.82,12.99,13.12,13.22,13.33,13.45,13.60,13.76,13.97,14.12,14.24,14.20,14.02,13.82,13.50,13.11,12.65,12.14,11.49,11.37,11.23,10.13,10.01,10,10,10,11,12,13,13,13,13,13,13,13,13,14,14,13,11,8.76,6.13,3.23,0.26,-1.50,-2.16,-2.66,-4.25,-4.51,-4.50,-4.28,-3.88,-3.28,-2.17,-0.78,0.60,1.82,2.77,3.20,3.09,2.62,1.90,1,0.10,-1.01,-1.97,-2.63,-3.17,-4.42,-4.62,-4.49,-4.47,-4.25,-3.91,-3.93,-4.41,-4.88,-4.90,-4.52,-4.14,-4,-3.76,-3.29,-3,-2.73,-2.25,-1.63,-0.79,0.87,3.50,7,9,10,10,9,10,13,14,13,13,13,14,15,15,15,16,16,15,15,15,15,15,16,16,16,16,16,15.66,15.37,15.07,14.84,14.71,14.57,14.39,14.23,14,13.78,13.53,13.26,12.98,12.62,12.25,11.85,11.38,10.89,10.40,9.89,9.41,9,8.62,8.35,8.12,7.98,7.98,8,8.09,8.22,8.37,8.53,8.71,8.87,9.01,9.15,9.27,9.37,9.47,9.50,9.50,9.48,9.46,9.41,9.40,9.41,9.47,9.48,9.50,9.50,9.47,9.45,9.38,9.34,9.25,9.12,9.02,8.97,8.99,9.12,9.36,9.64,10.03,10.49,10.95,11.37,11.83,12.23,12.57,12.82,13.07,13.21,13.32,13.38,13.46,13.50,13.53,13.60,13.63,13.72,13.77,13.88,14,14.13,14.27,14.41,14.57,14.70,14.83,14.95,15.08,15.20,15.34,15.46,15.59,15.70,15.77,15.89,16.03,16.25,16.50,16.76,17,17.21,17.35,17.41,17.50,17.53,17.66,17.95,18.23,18.52,18.87,19.25,19.62,20,20.37,20.75,21.09,21.39,21.72,22,22.28,22.58,22.76,22.90,22.99,23,23,23,22.99,23,22.99,22.97,22.89,22.83,22.70,22.52,22.37,22.24,22.14,22.15,22.25,22.38,22.53,22.70,22.82,22.89,23,23.11,23.20,23.25,23.33,23.36,23.38,23.46,23.53,23.73,23.85,24,24.08,24.10,24.01,23.85,23.48,22.78,21.45,18.98,11.26,11.26,11.25,11.14,10.99,10.70,10.34,9.90,9.48,9,8.60,8.20,7.83,7.50,7.25,7.07,6.91,6.87,6.87,6.99,7.14,7.39,7.74,8.12,8.58,9.07,9.58,10.10,10.61,11.10,11.53,11.96,12.28,12.58,12.77,12.97,13.11,13.22,13.34,13.47,13.62,13.82,14.01,14.26,14.49,14.53,14.45,14.12,13.75,13.27,12.85,12.36,12.12,12,12,11.85,11.01,11,11,11,10,10,11,12,12,13,13,13,14,13,13,13,13,13,11,8.87,6,3.32,0.21,-1.75,-2.50,-3,-4.28,-4.59,-4.60,-4.38,-3.73,-3,-1.78,-0.02,1.66,3.13,4.10,4.37,4.21,3.87,3.37,2.74,1.90,0.91,0.11,-0.79,-2.01,-2.61,-3.73,-3.92,-3.90,-3.72,-3.63,-3.48,-3.63,-3.75,-3.75,-3.41,-3.18,-3.16,-2.91,-2.50,-2.29,-2,-1.51,-0.89,-0.37,1.33,4.75,6,6,7,8,9,10,13,14,13,13,14,14,15,15,15,16,16,16,15,15,15,15,16,16,16,16,16,15.89,15.39,15.09,14.89,14.77,14.65,14.51,14.34,14.12,13.87,13.60,13.32,13,12.64,12.27,11.88,11.41,10.98,10.49,10,9.57,9.12,8.75,8.46,8.22,8.10,8.07,8.12,8.22,8.34,8.49,8.65,8.85,9.02,9.24,9.41,9.62,9.78,9.96,10.08,10.15,10.24,10.27,10.34,10.37,10.39,10.45,10.41,10.38,10.33,10.23,10.12,9.96,9.77,9.63,9.50,9.37,9.32,9.32,9.37,9.53,9.75,10.07,10.38,10.75,11.12,11.47,11.76,12.08,12.34,12.53,12.75,12.89,13.02,13.14,13.25,13.34,13.38,13.47,13.52,13.62,13.73,13.84,13.97,14.10,14.24,14.37,14.49,14.62,14.75,14.87,15.01,15.21,15.37,15.52,15.70,15.84,15.98,16.12,16.35,16.60,16.87,17.12,17.28,17.41,17.50,17.60,17.61,17.73,17.99,18.25,18.59,18.91,19.32,19.70,20.09,20.47,20.83,21.15,21.50,21.86,22.16,22.50,22.78,23.02,23.20,23.25,23.26,23.25,23.25,23.24,23.23,23.22,23.20,23.12,23.02,22.90,22.76,22.62,22.50,22.46,22.48,22.57,22.70,22.84,22.97,23.08,23.16,23.26,23.37,23.48,23.53,23.61,23.62,23.62,23.64,23.70,23.83,23.88,24.03,24.08,24,23.82,23.39,22.75,21.66,19.75,15.98,11.45,11.37,11.22,11,10.65,10.27,9.87,9.41,8.98,8.53,8.13,7.78,7.50,7.25,7.10,6.99,6.91,6.96,7.03,7.23,7.48,7.78,8.20,8.62,9.12,9.62,10.14,10.65,11.14,11.60,11.99,12.32,12.59,12.77,12.96,13.09,13.20,13.28,13.40,13.58,13.75,13.99,14.25,14.51,14.75,14.78,14.62,14.21,13.72,13.12,12.47,12.23,12.33,12.75,12.87,12.97,12,13,13,12,10,10,10,11,12,12,13,13,14,13,13,13,13,12,11,8.87,6,2.97,1.12,-0.80,-2.54,-3.10,-4.38,-4.50,-4.38,-4.22,-3.53,-2.64,-1.23,0.74,2.72,4.27,5.25,5.58,5.51,5.37,5.11,4.70,4.12,3.37,2.27,1.50,0.23,-0.63,-1.91,-2.16,-2.23,-3.28,-3.25,-3,-2.60,-2.63,-2.40,-2.13,-2.12,-2.12,-1.86,-1.63,-1.41,-1.13,-0.77,-0.36,0.25,1.62,5,7,7,9,10,11,12,14,14,14,14,14,14,14,15,15,16,16,16,15,15,15,15,16,16,16,16,16,16,15.14,15.03,14.96,14.87,14.82,14.66,14.47,14.22,13.91,13.62,13.34,13,12.63,12.26,11.87,11.47,11,10.53,10.10,9.64,9.25,8.87,8.59,8.36,8.25,8.25,8.28,8.37,8.51,8.70,8.87,9.10,9.33,9.53,9.78,10.07,10.32,10.52,10.75,10.95,11.09,11.22,11.33,11.39,11.48,11.50,11.50,11.40,11.28,11.13,10.95,10.74,10.53,10.28,10.13,10,9.91,9.87,9.88,9.96,10.07,10.22,10.39,10.62,10.87,11.12,11.37,11.62,11.85,12.08,12.27,12.50,12.70,12.87,13.01,13.13,13.25,13.35,13.41,13.51,13.62,13.74,13.87,14,14.12,14.25,14.38,14.52,14.66,14.85,15.01,15.23,15.45,15.64,15.87,16.03,16.23,16.40,16.63,16.87,17.13,17.37,17.53,17.66,17.75,17.83,17.86,17.96,18.15,18.40,18.74,19.09,19.46,19.83,20.21,20.58,20.95,21.27,21.63,22,22.35,22.70,23,23.25,23.45,23.50,23.50,23.50,23.48,23.47,23.46,23.45,23.39,23.35,23.25,23.13,23,22.88,22.78,22.75,22.76,22.86,22.97,23.10,23.22,23.33,23.40,23.51,23.62,23.73,23.77,23.83,23.82,23.75,23.73,23.70,23.74,23.75,23.87,23.87,23.74,23.37,22.75,21.78,20.39,18.10,13.99,11.37,11.25,11,10.66,10.26,9.85,9.37,8.91,8.50,8.12,7.76,7.50,7.26,7.12,7.02,7,7.02,7.13,7.32,7.53,7.87,8.25,8.70,9.20,9.72,10.24,10.75,11.25,11.66,12.07,12.37,12.62,12.83,12.97,13.09,13.15,13.25,13.36,13.49,13.64,13.87,14.12,14.38,14.70,14.88,14.89,14.70,14.24,13.73,13.12,12.37,12.27,12.87,13.87,13,13,13,13,13,13,11,10,10,10,10,11,11,12,13,14,13,13,14,13,11,8.75,5.77,2.75,0.96,-0.80,-2.62,-3.17,-4.43,-4.50,-4.25,-3.93,-3.34,-2.28,-0.63,1.38,3.71,5.41,6.47,6.75,6.98,7.01,6.98,6.84,6.61,6.16,5.48,4.37,3.28,1.62,1.12,0.64,-0.64,-1.74,-2.63,-2.30,-1.88,-1.25,-1.01,-1,-1.05,-0.99,-0.75,-0.75,-0.64,-0.42,-0.11,0.33,0.62,3,8,10,11,13,14,13,13,13,14,14,14,14,14,14,15,15,15,16,15,15,15,15,15,16,16,16,16,16,16,15,15,14.99,14.95,14.87,14.77,14.60,14.28,13.99,13.64,13.33,12.98,12.62,12.25,11.87,11.48,11.01,10.60,10.13,9.74,9.35,9,8.71,8.51,8.48,8.46,8.50,8.62,8.77,8.99,9.20,9.41,9.66,9.96,10.25,10.57,10.87,11.16,11.48,11.74,11.97,12.14,12.33,12.47,12.57,12.61,12.59,12.49,12.33,12.11,11.87,11.62,11.39,11.21,11,10.87,10.75,10.66,10.62,10.57,10.50,10.50,10.53,10.62,10.75,10.87,11.03,11.22,11.40,11.62,11.86,12.12,12.37,12.62,12.84,13,13.15,13.28,13.39,13.50,13.62,13.75,13.87,14,14.14,14.32,14.47,14.62,14.76,14.97,15.16,15.40,15.65,15.90,16.14,16.37,16.60,16.83,17.07,17.28,17.53,17.75,17.90,18.02,18.12,18.20,18.24,18.35,18.51,18.75,19.02,19.37,19.70,20.02,20.38,20.75,21.10,21.45,21.77,22.13,22.50,22.87,23.21,23.47,23.62,23.72,23.73,23.72,23.70,23.66,23.65,23.63,23.62,23.57,23.48,23.37,23.25,23.15,23.10,23.07,23.08,23.12,23.23,23.34,23.41,23.51,23.62,23.74,23.84,23.90,23.98,23.97,23.88,23.76,23.62,23.47,23.39,23.35,23.41,23.37,23.12,22.63,21.86,20.74,19.14,16.71,12.82,11.10,10.91,10.62,10.25,9.78,9.34,8.87,8.46,8.07,7.74,7.48,7.26,7.13,7.09,7.09,7.12,7.25,7.41,7.64,7.97,8.33,8.75,9.24,9.75,10.27,10.83,11.33,11.76,12.15,12.49,12.74,12.89,13.01,13.12,13.16,13.24,13.32,13.39,13.53,13.74,13.97,14.24,14.52,14.76,14.90,14.87,14.64,14.25,13.82,13.28,12.87,12.87,13.91,13,13,13,13,13,13,13,11,10,9,9,9,9,10,11,12,13,13,13,13,13,11,7.51,5.75,2.50,0.48,-1.37,-1.90,-3.26,-4.52,-4.53,-4.35,-3.80,-3.05,-2.04,-0.35,1.82,4.10,6.12,7.40,8.11,8.52,8.76,8.90,9,9.12,9.12,8.89,7.75,6.20,6.25,5.83,4.50,3.20,1.13,0.25,-0.48,0.01,-0.29,0.20,0.12,0.09,0.15,0.02,0.02,0.13,0.37,0.50,0.75,2,6,10,13,15,15,15,14,14,13,14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,16,16,16,16,16,16,15,15,15,15,14.97,14.84,14.62,14.37,14,13.63,13.28,12.95,12.59,12.22,11.84,11.40,11,10.61,10.15,9.75,9.39,9.09,8.87,8.73,8.65,8.71,8.77,8.91,9.12,9.35,9.59,9.84,10.11,10.39,10.73,11.08,11.45,11.82,12.14,12.49,12.76,13.01,13.25,13.40,13.57,13.62,13.62,13.50,13.33,13.09,12.83,12.58,12.35,12.13,11.99,11.86,11.74,11.62,11.48,11.28,11.12,10.98,10.86,10.76,10.75,10.75,10.82,10.90,11.08,11.25,11.52,11.78,12.12,12.40,12.71,12.96,13.14,13.34,13.49,13.62,13.75,13.87,14,14.15,14.33,14.50,14.64,14.85,15.02,15.25,15.48,15.73,16,16.25,16.51,16.76,17,17.25,17.50,17.76,18,18.22,18.36,18.47,18.52,18.62,18.70,18.82,19,19.23,19.49,19.75,20.02,20.35,20.63,20.97,21.27,21.62,21.96,22.32,22.66,23.03,23.37,23.62,23.78,23.87,23.88,23.88,23.87,23.87,23.87,23.85,23.82,23.75,23.66,23.60,23.50,23.41,23.37,23.35,23.36,23.38,23.47,23.52,23.62,23.71,23.78,23.87,23.99,24.02,24.07,24,23.87,23.62,23.34,23.02,22.82,22.62,22.62,22.49,22.21,21.63,20.78,19.63,18.01,15.52,11.75,10.60,10.40,10.12,9.71,9.25,8.78,8.37,8,7.65,7.40,7.25,7.13,7.12,7.13,7.24,7.37,7.53,7.76,8.08,8.39,8.83,9.26,9.77,10.33,10.87,11.37,11.86,12.25,12.61,12.86,13.02,13.13,13.21,13.24,13.25,13.26,13.35,13.45,13.59,13.77,14.01,14.28,14.59,14.83,14.96,14.87,14.62,14.27,13.87,13.84,13.10,13,13,13,14,13,13,14,13,13,12,10,9,8,8,8,8,9,10,12,12,12,12,12,10,7.37,4.23,2.26,0.12,-1.77,-3.38,-3.74,-4.78,-4.63,-4.37,-3.88,-3.17,-2.25,-0.28,1.90,4.28,6.66,8.72,9.59,10.25,10.53,10.72,11.03,11.22,12.08,12.12,11.02,10.26,10.60,11.50,10.32,9.25,6.22,5.35,3.63,2.11,1.38,1.57,0.75,1,0.86,0.75,0.73,0.75,0.86,1,1,5,10,13,15,15,15,15,14,14,13,14,14,14,14,14,14,14,15,15,15,15,15,15,16,16,16,16,16,16,16,16,15,15,15.01,15.07,15,14.87,14.62,14.35,13.99,13.62,13.25,12.87,12.51,12.13,11.75,11.37,10.97,10.53,10.13,9.75,9.41,9.14,8.99,8.88,8.88,8.98,9.12,9.28,9.50,9.75,10,10.26,10.57,10.87,11.21,11.58,11.97,12.37,12.75,13.12,13.47,13.75,14,14.24,14.38,14.50,14.50,14.41,14.24,14,13.74,13.49,13.26,13.11,12.97,12.87,12.75,12.62,12.39,12.13,11.86,11.57,11.28,11.09,10.90,10.78,10.75,10.75,10.87,11.02,11.27,11.57,11.90,12.26,12.62,12.96,13.23,13.46,13.63,13.83,13.98,14.12,14.25,14.41,14.62,14.78,14.99,15.20,15.38,15.62,15.87,16.12,16.37,16.63,16.89,17.15,17.41,17.71,17.98,18.24,18.48,18.65,18.78,18.88,18.99,19.08,19.16,19.34,19.51,19.75,19.99,20.23,20.47,20.72,20.96,21.23,21.50,21.78,22.12,22.49,22.87,23.23,23.52,23.76,23.95,24,24.03,24.07,24.07,24.07,24.03,24.01,24,23.95,23.87,23.78,23.74,23.65,23.62,23.60,23.60,23.62,23.63,23.71,23.75,23.83,23.88,23.98,24.02,24.07,24.02,23.90,23.63,23.25,22.82,22.38,21.98,21.65,21.50,21.32,21,20.49,19.71,18.62,17.10,14.66,10.70,9.95,9.76,9.48,9.08,8.65,8.25,7.88,7.59,7.36,7.21,7.12,7.12,7.20,7.32,7.48,7.66,7.90,8.21,8.51,8.89,9.34,9.82,10.33,10.86,11.37,11.87,12.34,12.71,12.99,13.16,13.27,13.35,13.35,13.33,13.32,13.32,13.36,13.46,13.61,13.82,14.03,14.33,14.62,14.87,14.98,14.90,14.75,14.13,14.09,14,14,13,13,13,14,13,13,13,13,13,12,11,10,9,7,8,8,7,8,10,12,11,12,11,9.87,5.98,3.62,1.51,-0.36,-2.16,-3.76,-4.13,-5.18,-5.02,-4.62,-3.92,-3.25,-2.28,-0.24,1.47,4.38,7.62,9.62,11.37,12.23,12.11,12.09,12.25,12.58,13.02,13.10,12.85,13.33,13.40,14.33,14.37,13.52,11.50,11.62,9.75,6.75,4.87,3,2,2,1,1,1,1,1,1,2,6,11,14,15,15,15,15,14,14,13,14,14,14,14,14,14,14,14,15,15,15,15,15,16,16,16,16,16,16,16,16,15,15,15,15.11,15.09,14.87,14.61,14.28,13.95,13.58,13.20,12.83,12.46,12.08,11.66,11.25,10.87,10.45,10.03,9.70,9.38,9.21,9.09,9.08,9.12,9.26,9.47,9.71,9.96,10.22,10.48,10.75,11.01,11.34,11.64,12.01,12.41,12.85,13.25,13.64,14,14.36,14.62,14.87,15.09,15.21,15.24,15.16,15,14.82,14.59,14.36,14.15,14.01,13.90,13.85,13.75,13.61,13.37,13,12.62,12.23,11.86,11.50,11.25,11.02,10.87,10.78,10.83,10.96,11.15,11.41,11.82,12.23,12.62,13,13.37,13.64,13.88,14.12,14.27,14.47,14.62,14.78,14.99,15.20,15.38,15.62,15.84,16.07,16.28,16.53,16.77,17.02,17.27,17.53,17.83,18.11,18.37,18.63,18.87,19.08,19.22,19.33,19.40,19.52,19.65,19.85,20.08,20.27,20.50,20.73,20.90,21.11,21.27,21.50,21.74,22,22.33,22.65,23.02,23.37,23.70,23.89,24.07,24.13,24.16,24.21,24.22,24.23,24.22,24.21,24.15,24.12,24.08,24,23.95,23.87,23.84,23.78,23.76,23.76,23.76,23.78,23.84,23.87,23.90,23.97,23.99,23.96,23.85,23.61,23.21,22.66,22.09,21.50,20.97,20.53,20.25,20.01,19.74,19.26,18.62,17.72,16.35,14.10,10.70,9.20,9.03,8.77,8.45,8.10,7.75,7.47,7.25,7.12,7.08,7.11,7.22,7.37,7.57,7.78,8.07,8.35,8.65,9,9.39,9.85,10.33,10.84,11.36,11.87,12.34,12.75,13.08,13.28,13.41,13.50,13.50,13.46,13.38,13.36,13.34,13.35,13.41,13.59,13.77,14.01,14.35,14.63,14.91,14.99,14.99,14.95,14,14,15,14,13,13,13,13,13,13,13,13,13,12,12,11,10,9,9,9,8,7,9,10,10,10,10,7.46,5.25,1.75,-0.41,-2.18,-2.65,-4,-5.18,-5.27,-5.13,-4.73,-4.02,-3.05,-2.30,-0.39,2.50,5.25,6.22,8.37,10.65,12.24,12.62,13.03,13,13.23,13.47,13.62,13.82,14.03,14.57,14.64,14.89,16,15,15,13,11,10,7,4,3,3,3,4,4,3,2,2,5,9,13,14,14,15,15,14,13,13,13,14,14,14,14,15,14,14,15,15,15,15,16,16,16,16,16,16,16,16,16,15,15,15,15,15,14.88,14.61,14.25,13.87,13.50,13.12,12.74,12.36,11.96,11.51,11.12,10.66,10.25,9.87,9.57,9.34,9.21,9.15,9.25,9.37,9.61,9.86,10.12,10.39,10.66,10.96,11.22,11.48,11.75,12.09,12.45,12.84,13.25,13.65,14.08,14.47,14.82,15.12,15.38,15.62,15.75,15.84,15.78,15.70,15.50,15.34,15.12,14.99,14.87,14.78,14.75,14.65,14.49,14.25,13.86,13.37,12.90,12.47,12.03,11.70,11.38,11.16,11,10.96,11,11.15,11.39,11.77,12.24,12.71,13.13,13.57,13.89,14.22,14.47,14.66,14.87,15.03,15.24,15.40,15.62,15.85,16.08,16.27,16.50,16.75,16.98,17.21,17.45,17.66,17.90,18.20,18.48,18.75,19,19.25,19.41,19.59,19.72,19.85,19.99,20.13,20.35,20.59,20.83,21.01,21.22,21.37,21.50,21.62,21.78,21.99,22.23,22.50,22.85,23.20,23.51,23.82,24,24.15,24.25,24.28,24.34,24.36,24.37,24.37,24.36,24.34,24.28,24.25,24.16,24.12,24.07,24,23.95,23.88,23.86,23.83,23.82,23.82,23.83,23.84,23.84,23.75,23.65,23.41,23.02,22.50,21.87,21.21,20.50,19.87,19.38,19,18.75,18.50,18.14,17.63,16.90,15.74,13.85,10.75,8.45,8.33,8.11,7.83,7.53,7.28,7.11,7,6.98,7.02,7.16,7.37,7.62,7.88,8.20,8.50,8.83,9.14,9.51,9.90,10.36,10.83,11.32,11.82,12.27,12.73,13.10,13.37,13.53,13.62,13.64,13.62,13.52,13.47,13.38,13.35,13.34,13.37,13.50,13.73,13.99,14.23,14.85,14.90,15,15,15,14,14,14,14,13,13,13,13,13,14,14,14,13,13,13,12,12,11,11,10,8,7,7,8,8,7.76,7.60,5.26,2.88,0.61,-1.54,-3.37,-4.77,-5.91,-5.76,-5.60,-5.18,-4.85,-4.25,-3.41,-2.39,0.50,4.62,7.36,7.97,8.36,10.25,12.25,12.65,13.11,13.40,13.60,13.75,13.96,14.20,14.49,14.75,14.90,15.12,16,15,15,15,14,13,12,9,7,7,9,10,8,6,3,2,4,9,11,13,13,14,15,14,13,13,13,13,14,14,14,14,15,15,15,15,15,16,16,16,16,16,16,16,16,16,15.99,15,15,14.99,14.99,14.97,14.85,14.59,14.21,13.78,13.39,13,12.62,12.24,11.83,11.37,10.89,10.46,10,9.64,9.37,9.23,9.16,9.25,9.40,9.64,9.91,10.24,10.53,10.86,11.12,11.38,11.62,11.87,12.14,12.47,12.82,13.21,13.61,14.01,14.45,14.84,15.20,15.51,15.82,16.03,16.23,16.32,16.33,16.25,16.12,15.98,15.83,15.71,15.62,15.58,15.52,15.46,15.25,14.95,14.60,14.09,13.58,13.09,12.62,12.23,11.87,11.58,11.36,11.21,11.15,11.26,11.48,11.86,12.32,12.82,13.32,13.77,14.21,14.53,14.85,15.10,15.28,15.50,15.70,15.87,16.10,16.32,16.51,16.75,16.97,17.16,17.38,17.62,17.84,18.03,18.28,18.53,18.83,19.10,19.35,19.58,19.75,19.95,20.11,20.25,20.45,20.62,20.84,21.07,21.32,21.50,21.65,21.77,21.88,22,22.11,22.25,22.47,22.72,23,23.35,23.63,23.89,24.12,24.25,24.35,24.39,24.46,24.48,24.49,24.50,24.50,24.49,24.46,24.38,24.35,24.25,24.20,24.11,24,23.90,23.84,23.75,23.71,23.64,23.62,23.61,23.51,23.38,23.15,22.78,22.26,21.63,20.96,20.23,19.49,18.84,18.34,17.87,17.63,17.40,17.13,16.75,16.20,15.14,13.50,10.84,7.75,7.65,7.50,7.32,7.11,6.97,6.87,6.87,6.96,7.12,7.37,7.62,7.96,8.27,8.62,8.98,9.33,9.65,10.02,10.40,10.85,11.26,11.75,12.22,12.64,13.03,13.37,13.62,13.75,13.78,13.76,13.72,13.62,13.51,13.46,13.38,13.33,13.28,13.37,13.64,13.87,14.10,14,15,15,15,14,14,14,14,14,14,13,13,13,13,14,14,14,14,14,14,13,13,13,13,11,10,9,8,7,6.65,5.38,3.59,3.20,0.84,-1.25,-3.36,-5.13,-6.61,-6.74,-6.51,-6.04,-5.63,-4.91,-4.37,-3.54,-1.51,1.62,6.75,10.62,9.78,8.33,10,11.48,12.62,13.28,13.65,13.87,13.98,14.14,14.39,14.65,14.87,15.11,15.10,15,15,15,15,15,15,14,13,11,12,14,14,13,9,4,2,4,7,8,10,12,13,14,13,12,12,13,13,13,14,14,14,14,15,15,15,15,15,15.98,16,16,16,16,16,16,15.99,15.96,15.01,15,15,14.98,14.90,14.75,14.47,14.09,13.65,13.26,12.87,12.50,12.11,11.65,11.15,10.65,10.15,9.73,9.38,9.16,9.10,9.14,9.34,9.61,9.90,10.25,10.61,10.96,11.25,11.52,11.77,12.01,12.25,12.51,12.83,13.14,13.52,13.95,14.36,14.75,15.14,15.51,15.87,16.14,16.39,16.61,16.73,16.75,16.74,16.62,16.51,16.39,16.32,16.25,16.21,16.15,16.08,15.87,15.53,15.12,14.66,14.15,13.65,13.21,12.76,12.37,12.02,11.75,11.53,11.46,11.48,11.62,11.97,12.41,12.96,13.50,14,14.49,14.87,15.23,15.50,15.74,15.95,16.13,16.35,16.53,16.75,16.98,17.20,17.38,17.61,17.82,18,18.23,18.45,18.65,18.90,19.15,19.40,19.65,19.87,20.10,20.27,20.49,20.66,20.88,21.12,21.33,21.51,21.75,21.95,22.10,22.21,22.26,22.36,22.45,22.53,22.72,22.91,23.20,23.48,23.75,23.99,24.16,24.33,24.41,24.50,24.52,24.58,24.60,24.62,24.62,24.61,24.58,24.51,24.47,24.37,24.25,24.12,23.98,23.83,23.66,23.53,23.45,23.37,23.27,23.21,23.07,22.84,22.48,22,21.37,20.71,19.99,19.23,18.51,17.89,17.39,16.97,16.72,16.50,16.25,15.98,15.49,14.64,13.21,9.95,7.23,7.14,7.03,6.91,6.83,6.75,6.76,6.87,7.03,7.33,7.62,7.98,8.35,8.73,9.11,9.48,9.83,10.16,10.51,10.88,11.27,11.71,12.12,12.57,12.97,13.33,13.61,13.78,13.89,13.90,13.87,13.77,13.70,13.61,13.52,13.50,13.50,13.48,13.25,13.09,13.98,14,14,14,15,14,14,14,14,14,14,14,14,13,13,13,14,14,14,15,15,15,14,14,14,14,13,12,11,11,9.65,8.36,5.76,2.73,0.40,-0.90,-2.98,-4.74,-6.51,-7,-7.13,-7,-6.51,-5.79,-5.13,-4.25,-3.43,-1.39,2.87,9.11,11.75,10.07,8.25,9.39,11.58,12.84,13.52,14.20,14,14.08,14.26,14.52,14.77,15.07,15.15,15.97,16,15,15,15,15,15,15,15,14,14,16,15.75,14.48,10.28,6.66,4.02,4.12,5.16,7.22,8.84,10.22,11.26,11.90,12.03,11.59,11.57,12.12,12.96,12.96,13.02,13.02,13.01,13.98,14,14.99,15,15,15.01,15.96,15.99,16,16,16,16,16,15.99,15.95,15.02,15.02,15.02,15.02,14.82,14.58,14.24,13.86,13.48,13.11,12.74,12.36,11.95,11.49,10.95,10.39,9.87,9.45,9.12,8.96,8.98,9.14,9.41,9.77,10.15,10.57,10.95,11.27,11.61,11.87,12.12,12.36,12.59,12.85,13.12,13.49,13.87,14.25,14.66,15.10,15.49,15.85,16.16,16.48,16.73,16.91,17.07,17.12,17.12,17.08,16.99,16.87,16.82,16.75,16.70,16.62,16.51,16.33,16,15.59,15.12,14.65,14.21,13.75,13.34,12.91,12.53,12.23,11.97,11.76,11.73,11.78,12.11,12.53,13.10,13.65,14.24,14.75,15.20,15.58,15.87,16.12,16.37,16.58,16.76,16.99,17.20,17.38,17.61,17.82,18,18.22,18.39,18.62,18.84,19.07,19.27,19.51,19.75,20,20.22,20.41,20.63,20.87,21.11,21.35,21.60,21.82,22,22.21,22.37,22.50,22.60,22.64,22.72,22.75,22.85,22.98,23.13,23.36,23.60,23.84,24.03,24.24,24.37,24.49,24.53,24.61,24.63,24.65,24.70,24.70,24.70,24.65,24.62,24.52,24.40,24.25,24.02,23.82,23.59,23.37,23.15,23,22.87,22.75,22.61,22.39,22.10,21.64,21.11,20.47,19.75,18.99,18.27,17.64,17.11,16.62,16.22,15.95,15.73,15.50,15.25,14.82,14.12,12.70,10,6.87,6.86,6.78,6.75,6.73,6.75,6.85,7.01,7.27,7.61,7.99,8.37,8.77,9.20,9.60,9.97,10.33,10.65,11,11.35,11.71,12.08,12.47,12.85,13.22,13.51,13.76,13.96,14,14,13.96,13.87,13.76,13.72,13.70,13.71,13.74,13.78,13.99,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,15,14,14,14,14,14,14,12.76,12.37,10.87,8.12,5.01,1.89,-2.38,-4.38,-6.13,-6.63,-7.12,-7.27,-7.13,-6.73,-5.91,-5.05,-4.13,-3.12,-0.03,5.24,10.25,12.95,10.87,8.20,10.72,12.60,12.88,14.37,13.90,13.90,13.99,14.25,14.58,14.87,15.09,15.95,16,15,15,15,15,15,15,16,16,15.87,15.51,15.25,14.91,13.66,10.70,7.87,5.83,4.91,5.75,7.01,8.25,9.07,10,10.48,10.62,10.66,10.88,11.39,12.14,12.45,12.78,12.90,13.02,13.08,14.07,14.91,14.98,15,15.02,15.91,15.98,15.98,15.98,15.99,16,16,15.99,15.90,15.91,15.07,15.87,15,14.62,14.28,13.96,13.60,13.24,12.87,12.52,12.15,11.75,11.25,10.71,10.12,9.61,9.23,8.90,8.82,8.90,9.22,9.57,9.98,10.38,10.82,11.20,11.53,11.86,12.12,12.37,12.61,12.85,13.12,13.41,13.77,14.16,14.60,15,15.40,15.78,16.14,16.49,16.75,17,17.23,17.37,17.45,17.47,17.40,17.35,17.25,17.20,17.12,17.03,16.98,16.84,16.62,16.27,15.90,15.49,15.09,14.63,14.25,13.86,13.46,13.08,12.70,12.37,12.12,12,12,12.25,12.66,13.22,13.82,14.39,14.97,15.46,15.87,16.22,16.50,16.75,16.98,17.16,17.37,17.60,17.78,18,18.21,18.38,18.60,18.78,19,19.22,19.45,19.64,19.87,20.12,20.34,20.53,20.76,21,21.25,21.50,21.77,22.07,22.27,22.48,22.63,22.78,22.95,22.99,23,23.02,23.08,23.12,23.22,23.35,23.50,23.71,23.88,24.10,24.25,24.38,24.50,24.58,24.62,24.65,24.70,24.72,24.73,24.72,24.70,24.62,24.51,24.37,24.12,23.84,23.50,23.20,22.88,22.62,22.41,22.25,22.08,21.87,21.60,21.25,20.76,20.23,19.58,18.84,18.12,17.48,16.88,16.39,16,15.59,15.33,15.09,14.87,14.62,14.25,13.61,12.25,9.02,6.75,6.77,6.76,6.76,6.82,6.89,7.08,7.28,7.62,7.98,8.38,8.83,9.25,9.66,10.09,10.46,10.78,11.12,11.45,11.75,12.08,12.38,12.74,13.08,13.38,13.66,13.88,14.01,14.08,14.07,14,13.91,13.87,13.85,13.85,14,14.13,14.01,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,16,15,15,15,14,14,14,13.87,13.75,12.25,11.87,10.25,8.59,4.52,1.40,-2.65,-4.64,-6.38,-6.79,-7.03,-7.04,-6.91,-6.50,-5.75,-4.66,-3.75,-1.53,1.33,7.38,12.48,13.98,11.96,9.12,10.10,11.75,12.63,13.57,13.52,13.50,13.60,13.90,14.73,14.85,14.98,15,15,15,15,15,15,15,16,15.91,15.91,15.82,15.59,15.12,14.35,12.91,10.70,8.46,6.70,5.66,6.38,7.37,8.25,8.97,9.33,9.50,9.52,9.70,10.02,10.60,11.12,11.62,12,12.46,12.82,13.12,14,14.87,14.96,15,15.10,15.88,15.90,15.90,15.89,15.98,15.99,16,15.98,15.97,15.89,15.88,15.21,14.88,14.47,14.08,13.71,13.35,13,12.65,12.33,11.96,11.52,11.01,10.47,9.89,9.41,9.10,8.87,8.84,9,9.35,9.74,10.14,10.59,11,11.37,11.72,12,12.27,12.52,12.77,13.03,13.36,13.70,14.08,14.49,14.90,15.35,15.75,16.12,16.47,16.75,17.02,17.26,17.48,17.62,17.71,17.73,17.70,17.62,17.53,17.47,17.37,17.28,17.16,17,16.77,16.49,16.12,15.75,15.37,15.02,14.66,14.34,13.97,13.58,13.15,12.78,12.49,12.26,12.22,12.39,12.77,13.32,13.90,14.52,15.12,15.65,16.12,16.50,16.82,17.09,17.33,17.52,17.75,17.97,18.15,18.37,18.58,18.75,18.98,19.15,19.37,19.60,19.82,20.01,20.25,20.47,20.66,20.88,21.12,21.37,21.62,21.89,22.21,22.50,22.74,22.95,23.08,23.25,23.27,23.36,23.34,23.33,23.33,23.35,23.38,23.49,23.62,23.75,23.91,24.11,24.25,24.37,24.48,24.52,24.59,24.62,24.63,24.65,24.66,24.65,24.62,24.53,24.39,24.16,23.87,23.49,23.07,22.63,22.26,21.97,21.71,21.48,21.25,21,20.73,20.37,19.90,19.37,18.75,18.07,17.38,16.82,16.26,15.83,15.39,15.10,14.78,14.58,14.35,14.12,13.78,13.15,11.90,9.12,6.88,6.91,6.99,7.01,7.11,7.24,7.45,7.71,8.02,8.45,8.87,9.28,9.74,10.14,10.57,10.91,11.25,11.58,11.86,12.12,12.38,12.65,12.96,13.25,13.50,13.76,13.97,14.08,14.11,14.08,14.01,13.98,13.91,13.95,14.09,14.13,14.97,15,14,14,14,14,14,14,14,14,14,14,14,14,14,15,14,14,15,15,14,14,15,15,15,15,15,15,13.87,13.59,13.32,13.15,11.99,10.58,9.07,7.37,4.75,2.01,-0.87,-3.73,-5.64,-6.38,-6.80,-7,-7,-6.75,-6.25,-5.50,-4.39,-3.43,-1.35,2.62,9.73,13.76,13.99,12,10,9.08,9.12,11.16,12.76,12.87,12.88,12.91,13.09,13.96,14,15,15,15,15,15,15,15,15,15.64,15.87,15.87,15.76,15.48,14.87,13.90,12.40,10.59,8.75,7.26,6.74,7.12,7.85,8.57,9.09,9.32,9.21,9.07,9.10,9.37,9.82,10.37,10.91,11.48,12,12.57,13.20,13.96,14.83,14.89,14.99,15.12,15.12,15.12,15.10,15.88,15.88,15.97,15.99,15.98,15.88,15.88,15.20,15.02,14.66,14.27,13.87,13.49,13.12,12.82,12.49,12.12,11.74,11.28,10.78,10.25,9.82,9.46,9.23,9.12,9.14,9.34,9.62,9.97,10.34,10.71,11.08,11.40,11.75,12.03,12.34,12.62,12.88,13.21,13.52,13.90,14.34,14.76,15.23,15.64,16.07,16.41,16.75,17.02,17.27,17.50,17.70,17.83,17.88,17.90,17.87,17.83,17.75,17.63,17.53,17.45,17.28,17.12,16.87,16.59,16.25,15.96,15.62,15.35,15.07,14.75,14.41,14.03,13.62,13.22,12.85,12.57,12.39,12.52,12.87,13.37,14,14.62,15.25,15.83,16.32,16.73,17.07,17.36,17.62,17.85,18.07,18.26,18.50,18.71,18.89,19.12,19.33,19.51,19.74,19.96,20.15,20.37,20.60,20.82,21,21.24,21.47,21.72,21.99,22.26,22.61,22.87,23.12,23.28,23.41,23.51,23.57,23.61,23.58,23.50,23.48,23.47,23.49,23.53,23.64,23.76,23.89,24.03,24.16,24.26,24.37,24.40,24.46,24.49,24.50,24.50,24.51,24.50,24.45,24.34,24.12,23.85,23.45,22.98,22.48,21.99,21.57,21.20,20.87,20.62,20.37,20.12,19.85,19.50,19.10,18.61,18.03,17.45,16.84,16.26,15.75,15.35,14.96,14.65,14.37,14.12,13.91,13.75,13.51,13.09,11.91,9.12,7.34,7.34,7.37,7.47,7.57,7.72,7.91,8.22,8.53,8.95,9.37,9.78,10.24,10.63,11.01,11.37,11.70,11.98,12.23,12.46,12.66,12.88,13.12,13.36,13.59,13.77,13.98,14.07,14.09,14.07,14.01,14,13.98,14,14.11,14.97,15,15,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,15,14,14,15,15,15,15,14.77,13.61,12.12,11.75,11.50,10.33,8.01,6.62,4.25,2.77,0.15,-1.43,-3.25,-3.75,-5.38,-6.13,-6.60,-6.76,-6.74,-6.43,-5.99,-5.18,-4.13,-2.05,0.02,4.12,10.25,13.95,14,13,10,10,10,10,12,12,12,12,12,13,14,14,15,15,15,15,15,15.03,15.34,15.59,15.77,15.83,15.66,15.32,14.62,13.53,12.09,10.50,8.90,7.73,7.33,7.71,8.35,9.07,9.50,9.62,9.50,9.24,9.07,9.12,9.39,9.85,10.46,11.07,11.65,12.32,13,13.75,14.73,14.76,14.89,14.98,15,15.03,15.14,15.12,15.87,15.87,15.98,15.97,15.87,15.12,15.12,14.85,14.53,14.14,13.75,13.35,13,12.66,12.36,11.99,11.58,11.11,10.62,10.12,9.75,9.50,9.38,9.37,9.48,9.65,9.90,10.22,10.51,10.85,11.14,11.47,11.75,12.03,12.35,12.62,12.96,13.27,13.66,14.11,14.57,15.02,15.50,15.96,16.36,16.72,17,17.26,17.50,17.71,17.87,17.98,18.02,18.03,18,17.96,17.86,17.75,17.62,17.50,17.36,17.13,16.89,16.62,16.35,16.08,15.83,15.61,15.37,15.13,14.87,14.50,14.07,13.62,13.20,12.84,12.60,12.64,12.97,13.41,14.02,14.70,15.35,15.95,16.47,16.88,17.25,17.58,17.85,18.10,18.33,18.53,18.75,19,19.22,19.41,19.63,19.86,20.08,20.27,20.50,20.72,20.90,21.12,21.34,21.53,21.76,22.01,22.27,22.59,22.88,23.15,23.38,23.58,23.72,23.74,23.75,23.71,23.65,23.53,23.49,23.46,23.46,23.50,23.60,23.70,23.78,23.89,24,24.09,24.12,24.14,24.16,24.21,24.23,24.24,24.24,24.16,24.10,23.91,23.66,23.33,22.87,22.33,21.75,21.25,20.75,20.37,20.03,19.76,19.50,19.26,19,18.71,18.35,17.90,17.45,16.90,16.37,15.85,15.37,14.91,14.59,14.32,14.08,13.83,13.64,13.52,13.38,13.21,12.08,9.12,7.98,7.98,7.99,8.01,8.13,8.27,8.50,8.76,9.12,9.50,9.88,10.33,10.74,11.12,11.49,11.83,12.11,12.35,12.57,12.75,12.90,13.09,13.25,13.40,13.60,13.75,13.90,14.01,14.03,14.03,14.01,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,15,14,14,14,14,15,14,14,14,15,15,14,13.65,12.45,9.89,8.45,8.10,6.84,4.62,3.32,0.87,-0.53,-1.93,-2.16,-2.77,-3.39,-4.90,-5.23,-5.63,-6.01,-6.25,-6.23,-5.91,-5.42,-4.64,-2.55,-0.49,2.65,6.75,11.58,13.98,14,12,11,12,12,12,12,11,10,11,12,13,13,14,14,15,15,15,15.12,15.25,15.46,15.62,15.75,15.74,15.53,15.12,14.37,13.25,11.87,10.47,9.03,7.98,7.65,8.10,8.75,9.52,10.10,10.12,10,9.78,9.59,9.45,9.49,9.75,10.24,10.83,11.40,12.07,12.74,13.46,14.09,14.62,14.75,14.87,14.96,15,15.03,15.15,15.13,15.87,15.97,15.97,15.87,15.22,14.99,14.75,14.46,14.09,13.65,13.26,12.95,12.62,12.26,11.87,11.45,10.97,10.47,10.01,9.75,9.62,9.63,9.74,9.87,10.07,10.26,10.50,10.75,11,11.25,11.50,11.77,12.08,12.36,12.65,13,13.37,13.76,14.24,14.75,15.25,15.75,16.21,16.61,16.96,17.24,17.49,17.70,17.86,17.99,18.08,18.12,18.12,18.09,18,17.89,17.77,17.64,17.50,17.35,17.12,16.88,16.63,16.38,16.15,15.98,15.78,15.65,15.50,15.25,14.88,14.47,13.99,13.51,13.12,12.78,12.76,13.01,13.48,14.07,14.72,15.37,16,16.53,17,17.39,17.74,18.01,18.26,18.50,18.75,19,19.24,19.47,19.71,19.91,20.14,20.37,20.60,20.78,21,21.22,21.40,21.62,21.83,22.02,22.27,22.53,22.83,23.11,23.36,23.59,23.72,23.82,23.84,23.82,23.64,23.53,23.41,23.33,23.26,23.28,23.35,23.39,23.49,23.57,23.62,23.70,23.73,23.74,23.75,23.75,23.75,23.77,23.77,23.75,23.66,23.53,23.34,23.02,22.62,22.12,21.59,21,20.46,19.98,19.58,19.24,18.96,18.72,18.48,18.24,17.97,17.64,17.32,16.90,16.47,15.99,15.50,15.03,14.62,14.32,14.08,13.85,13.63,13.49,13.40,13.40,13.24,12.25,9.12,8.78,8.76,8.75,8.75,8.78,8.95,9.12,9.37,9.70,10.03,10.41,10.84,11.22,11.60,11.91,12.24,12.50,12.72,12.87,13.01,13.13,13.25,13.34,13.41,13.57,13.71,13.86,13.98,14,14.02,14.03,14.01,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,14,14,14,14,14,14,14,13,13,10.57,9.14,7.71,6.12,4.76,3.52,2.25,1.09,-0.24,-1.63,-2.03,-3.49,-3.63,-3.91,-4.29,-4.78,-5.11,-5.26,-5.50,-5.50,-5.41,-5.12,-4.63,-3.85,-1.74,2.37,6.27,11.20,13.90,14,14,12,11,13,14,14,14,13,12,11,12,13,14,14,14,15,15,15.12,15.25,15.38,15.53,15.65,15.73,15.63,15.38,14.91,14.12,13.07,11.77,10.47,9.20,8.16,7.87,8.36,9.02,9.82,10.50,10.73,10.62,10.46,10.25,10.09,10.02,10.12,10.37,10.82,11.28,11.87,12.49,13.12,13.74,14.23,14.58,14.75,14.87,14.97,15,15.10,15.21,15.83,15.96,15.96,15.85,15.28,14.99,14.73,14.40,14.02,13.63,13.25,12.91,12.61,12.25,11.84,11.36,10.85,10.34,9.97,9.78,9.82,9.90,10.10,10.28,10.50,10.66,10.86,11.01,11.21,11.38,11.62,11.86,12.12,12.39,12.72,13.03,13.41,13.86,14.34,14.86,15.39,15.90,16.37,16.77,17.12,17.39,17.62,17.82,17.97,18.07,18.12,18.13,18.12,18.09,18,17.87,17.75,17.62,17.48,17.27,17.10,16.87,16.62,16.40,16.25,16.10,15.99,15.89,15.77,15.59,15.25,14.84,14.35,13.86,13.37,13,12.91,13.11,13.50,14.08,14.72,15.37,16.01,16.61,17.10,17.50,17.85,18.12,18.38,18.63,18.88,19.13,19.39,19.65,19.90,20.15,20.39,20.63,20.87,21.08,21.26,21.47,21.63,21.85,22.02,22.25,22.48,22.72,23,23.24,23.47,23.64,23.82,23.86,23.84,23.74,23.50,23.25,23.09,22.98,22.96,22.96,23,23.08,23.12,23.15,23.22,23.22,23.16,23.14,23.13,23.12,23.13,23.14,23.13,23.11,23,22.83,22.58,22.25,21.84,21.34,20.76,20.22,19.66,19.21,18.82,18.49,18.21,17.97,17.75,17.50,17.28,17.07,16.76,16.45,16.03,15.62,15.20,14.76,14.39,14.12,13.88,13.70,13.50,13.36,13.33,13.36,13.16,12.34,9.14,9.74,9.66,9.60,9.51,9.51,9.60,9.75,9.98,10.25,10.59,10.95,11.32,11.66,12,12.34,12.62,12.86,13.03,13.21,13.28,13.36,13.37,13.37,13.39,13.48,13.62,13.77,13.90,14,14.07,14.16,14.15,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,15,15,15,15,14,13,13,13,13,13,10.87,9.60,8.13,6.71,5.39,2.86,2.27,0.95,-0.25,-0.38,-1.38,-1.53,-2.98,-3.29,-3.75,-3.91,-4,-4.25,-4.40,-4.67,-4.67,-4.88,-4.90,-4.74,-4.29,-3.75,-2,0.07,3.96,8.89,12.74,13.99,14,14,13,12,13,14,14,14,13,13,12,12,14,14,14,14,15,15.10,15.25,15.37,15.50,15.62,15.71,15.70,15.58,15.27,14.75,13.97,12.90,11.74,10.50,9.35,8.37,8.08,8.50,9.23,10.02,10.78,11.21,11.25,11.12,10.97,10.77,10.65,10.64,10.75,11,11.35,11.78,12.34,12.88,13.47,13.97,14.36,14.63,14.83,14.95,15,15.11,15.24,15.76,15.91,15.91,15.77,15.37,15.01,14.73,14.38,14.02,13.63,13.27,12.95,12.61,12.23,11.77,11.26,10.75,10.25,9.91,9.87,9.98,10.20,10.47,10.74,10.97,11.12,11.25,11.37,11.50,11.62,11.78,12,12.25,12.51,12.82,13.13,13.50,13.91,14.37,14.88,15.45,16,16.50,16.89,17.25,17.50,17.73,17.87,18,18.09,18.12,18.12,18.10,18.01,17.95,17.84,17.71,17.57,17.39,17.23,17.01,16.83,16.62,16.46,16.32,16.23,16.14,16.12,16.03,15.87,15.59,15.15,14.65,14.14,13.64,13.24,13.09,13.21,13.53,14.08,14.70,15.36,16,16.60,17.11,17.51,17.87,18.16,18.46,18.72,18.98,19.25,19.50,19.78,20.09,20.36,20.62,20.87,21.10,21.28,21.49,21.64,21.84,22,22.20,22.37,22.60,22.82,23.03,23.25,23.50,23.63,23.77,23.82,23.74,23.52,23.16,22.84,22.59,22.46,22.40,22.50,22.50,22.58,22.60,22.60,22.58,22.51,22.48,22.40,22.37,22.37,22.37,22.37,22.36,22.26,22.13,21.96,21.70,21.37,20.98,20.50,19.99,19.47,18.96,18.50,18.11,17.76,17.50,17.28,17.09,16.89,16.73,16.50,16.26,16,15.65,15.28,14.91,14.53,14.25,14,13.77,13.61,13.45,13.26,13.25,13.21,12.99,12.15,9.21,10.73,10.61,10.45,10.32,10.25,10.25,10.36,10.52,10.76,11.09,11.40,11.75,12.11,12.40,12.73,12.98,13.21,13.37,13.49,13.52,13.52,13.49,13.39,13.35,13.37,13.50,13.73,13.88,14,14.14,14.15,14.97,15,15,14,14,14,14,15,14,14,14,14,14,14,14,14,15,15,15,15,14,12,12,11,11.77,10.62,8.13,5.83,4.22,2.75,1.37,0.83,-0.52,-1.68,-1.90,-3.02,-2.99,-2.75,-3.13,-3.37,-3.78,-4,-3.91,-3.91,-4.13,-4.05,-4,-4.11,-4.12,-2.92,-2.50,-1.90,-0.13,1.88,5.73,10.62,12.98,14,14,14,14,13,12,14,14,14,14,14,13,13,14,14,14,15,15.02,15.27,15.39,15.50,15.62,15.66,15.72,15.64,15.50,15.14,14.62,13.85,12.86,11.74,10.57,9.48,8.58,8.25,8.62,9.34,10.16,10.96,11.52,11.75,11.75,11.63,11.50,11.35,11.25,11.25,11.36,11.57,11.87,12.32,12.82,13.33,13.82,14.23,14.53,14.76,14.95,15.07,15.21,15.26,15.74,15.87,15.87,15.73,15.40,15.08,14.75,14.40,14.03,13.66,13.32,12.96,12.60,12.20,11.74,11.22,10.70,10.22,9.90,9.95,10.14,10.47,10.84,11.15,11.41,11.62,11.75,11.84,11.90,12,12.14,12.34,12.53,12.76,13.01,13.32,13.62,14,14.41,14.89,15.41,15.97,16.48,16.91,17.26,17.52,17.75,17.87,17.99,18.03,18.08,18.07,18,17.95,17.86,17.74,17.62,17.48,17.34,17.14,16.99,16.78,16.62,16.50,16.38,16.35,16.33,16.34,16.27,16.13,15.87,15.48,14.98,14.46,13.91,13.49,13.25,13.28,13.59,14.03,14.62,15.27,15.91,16.51,17.03,17.48,17.85,18.13,18.41,18.71,18.98,19.25,19.58,19.87,20.20,20.49,20.76,21.01,21.25,21.47,21.62,21.76,21.95,22.10,22.25,22.41,22.61,22.83,23,23.22,23.39,23.62,23.66,23.65,23.51,23.16,22.73,22.26,21.95,21.75,21.74,21.82,21.88,21.95,21.87,21.85,21.76,21.70,21.61,21.52,21.50,21.48,21.48,21.48,21.45,21.36,21.23,21.01,20.77,20.50,20.12,19.73,19.25,18.76,18.27,17.85,17.49,17.16,16.90,16.72,16.52,16.37,16.22,16.02,15.84,15.60,15.32,15,14.66,14.37,14.12,13.91,13.75,13.59,13.40,13.27,13.16,13.03,12.74,11.98,9.25,11.73,11.50,11.24,11.02,10.89,10.87,10.89,11.02,11.25,11.51,11.86,12.14,12.49,12.77,13.07,13.32,13.50,13.64,13.75,13.75,13.72,13.60,13.46,13.35,13.27,13.49,13.71,13.96,14,14.15,14.96,15,15,15,15,14,14,14,14,15,14,14,14,14,14,15,15,15,15,15,15,13,12,10,8.59,8.25,6.73,4.27,2.97,1.46,0,-0.49,-2.02,-2.38,-3.49,-3.39,-3.50,-3.43,-3.24,-3.13,-3.38,-3.62,-3.86,-3.78,-3.50,-3.62,-3.62,-2.28,-2.05,-2.02,-0.88,-0.41,1.21,2,3.86,5.47,8.98,13,14,14,14,14,13,13,14,14,14,14,14,13,13,14,14,15,15,15.40,15.47,15.53,15.62,15.66,15.72,15.71,15.62,15.38,15.03,14.50,13.75,12.84,11.75,10.62,9.60,8.75,8.39,8.75,9.39,10.25,11.09,11.73,12.12,12.25,12.24,12.12,11.98,11.86,11.77,11.78,11.89,12.12,12.46,12.87,13.33,13.75,14.15,14.50,14.76,14.99,15.16,15.33,15.70,15.75,15.87,15.86,15.71,15.46,15.12,14.78,14.46,14.09,13.71,13.33,12.96,12.58,12.13,11.65,11.13,10.62,10.15,9.90,10,10.32,10.71,11.13,11.59,11.89,12.12,12.26,12.37,12.47,12.57,12.70,12.86,13.01,13.22,13.37,13.59,13.82,14.10,14.46,14.87,15.35,15.87,16.36,16.83,17.22,17.49,17.66,17.83,17.89,17.96,17.97,17.95,17.88,17.83,17.74,17.62,17.50,17.37,17.25,17.11,16.96,16.78,16.65,16.58,16.50,16.50,16.50,16.52,16.50,16.37,16.12,15.75,15.25,14.73,14.21,13.73,13.46,13.39,13.62,14.01,14.57,15.16,15.78,16.38,16.89,17.36,17.72,18.01,18.33,18.62,18.90,19.24,19.57,19.88,20.24,20.58,20.87,21.12,21.37,21.57,21.71,21.85,21.97,22.10,22.23,22.37,22.57,22.72,22.87,23.03,23.22,23.39,23.39,23.36,23.13,22.65,22.12,21.53,21.13,20.98,20.95,21,21.10,21.12,21.11,20.98,20.87,20.75,20.65,20.60,20.53,20.51,20.51,20.50,20.49,20.39,20.27,20.12,19.90,19.66,19.37,19.02,18.62,18.16,17.73,17.32,16.90,16.62,16.39,16.24,16.09,15.91,15.77,15.62,15.45,15.23,15,14.75,14.50,14.26,14.10,13.90,13.75,13.62,13.49,13.35,13.20,12.97,12.52,11.72,9.36,12.48,12.23,11.89,11.65,11.50,11.37,11.37,11.45,11.62,11.87,12.16,12.50,12.85,13.12,13.38,13.62,13.84,13.98,14.03,14.02,13.89,13.71,13.50,13.37,13.38,13.47,13.75,13.98,14,14.01,15,15,15,15,15,14,14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,12,9.82,8.34,5.87,4.37,2.83,1.40,-0.01,-0.50,-1.75,-2.10,-2.63,-3.99,-4.10,-4,-3.80,-3.76,-3.54,-2.16,-2.14,-2.25,-2.42,-2.42,-2.14,-1.89,-1.80,-0.54,-0.28,0.86,2.14,3.62,4.25,5.97,5.47,5.99,8,12,14,14,14,14,13,13,14,14,14,14,14,14,14,14,15,15,15.64,15.58,15.62,15.66,15.72,15.73,15.72,15.65,15.53,15.28,14.95,14.39,13.71,12.84,11.82,10.74,9.74,8.95,8.58,8.85,9.47,10.27,11.13,11.86,12.34,12.59,12.64,12.61,12.50,12.37,12.32,12.26,12.34,12.49,12.73,13.07,13.45,13.84,14.21,14.52,14.83,15.10,15.34,15.62,15.75,15.87,15.87,15.84,15.71,15.50,15.21,14.86,14.50,14.11,13.72,13.34,12.95,12.51,12.10,11.61,11.09,10.60,10.12,9.96,10.10,10.48,10.90,11.46,11.96,12.36,12.63,12.85,12.99,13.11,13.23,13.37,13.50,13.64,13.77,13.87,13.98,14.08,14.24,14.48,14.82,15.23,15.66,16.15,16.62,17,17.34,17.52,17.66,17.75,17.78,17.82,17.77,17.75,17.66,17.60,17.50,17.39,17.28,17.20,17.08,16.96,16.85,16.75,16.70,16.65,16.66,16.71,16.75,16.74,16.62,16.37,16,15.50,14.99,14.45,13.99,13.63,13.52,13.65,14,14.48,15.01,15.62,16.20,16.71,17.12,17.50,17.84,18.13,18.47,18.77,19.12,19.50,19.87,20.25,20.60,20.89,21.20,21.40,21.58,21.71,21.77,21.87,21.98,22.10,22.25,22.37,22.50,22.62,22.75,22.91,22.97,22.95,22.84,22.51,22,21.38,20.75,20.27,20.09,20.07,20.12,20.21,20.24,20.15,20.07,19.90,19.77,19.70,19.62,19.60,19.60,19.60,19.59,19.53,19.50,19.38,19.26,19.12,18.98,18.75,18.47,18.11,17.70,17.23,16.83,16.48,16.21,16,15.83,15.66,15.53,15.40,15.26,15.11,14.91,14.75,14.57,14.38,14.25,14.11,13.98,13.86,13.73,13.61,13.49,13.34,13.01,12.47,11.62,8.38,12.86,12.66,12.41,12.20,11.99,11.83,11.72,11.72,11.85,12.10,12.41,12.76,13.12,13.39,13.65,13.88,14.11,14.25,14.32,14.25,14.09,13.85,13.58,13.60,13.71,13.78,13.87,13.99,14,14,14,15,15,15,14,14,14,15,14,14,14,14,14,15,15,15,15,15,15,15,14,10.72,8.27,5.70,4.24,2.50,0.99,-0.36,-1.75,-2.25,-2.49,-2.75,-4,-4.38,-4.50,-4.39,-4.13,-3.92,-2.73,-1.35,-0.85,-0.91,-0.79,-0.85,-0.61,-0.30,-0.04,1.39,2.65,3.84,5.12,6.62,9.25,10.65,10,7,7,10,12,14,14,14,14,14,14,14,14,14,14,14,14,15,15,15.91,15.65,15.74,15.75,15.75,15.75,15.74,15.70,15.61,15.45,15.16,14.84,14.34,13.66,12.86,11.87,10.85,9.87,9.12,8.71,8.89,9.48,10.26,11.12,11.87,12.40,12.75,12.89,12.95,12.87,12.83,12.75,12.74,12.75,12.87,13.08,13.34,13.63,13.98,14.28,14.62,14.90,15.21,15.50,15.70,15.84,15.88,15.88,15.85,15.72,15.52,15.25,14.90,14.52,14.12,13.74,13.33,12.90,12.50,12.02,11.53,11.07,10.60,10.25,10.12,10.26,10.62,11.10,11.62,12.15,12.63,13.01,13.33,13.53,13.75,13.95,14.12,14.27,14.40,14.50,14.50,14.47,14.40,14.41,14.50,14.74,15.07,15.47,15.89,16.36,16.75,17.10,17.33,17.47,17.57,17.61,17.62,17.61,17.58,17.50,17.46,17.37,17.32,17.24,17.13,17.07,16.99,16.89,16.86,16.84,16.85,16.87,16.90,16.97,16.95,16.82,16.59,16.21,15.75,15.24,14.72,14.24,13.87,13.71,13.74,13.99,14.37,14.87,15.37,15.89,16.38,16.84,17.22,17.57,17.88,18.25,18.62,19,19.38,19.82,20.21,20.58,20.89,21.16,21.37,21.50,21.60,21.62,21.66,21.75,21.85,21.98,22.08,22.16,22.25,22.35,22.37,22.27,22.23,22.07,21.66,21.16,20.52,19.87,19.38,19.12,19.13,19.24,19.32,19.33,19.25,19.13,18.99,18.84,18.74,18.65,18.64,18.64,18.66,18.66,18.65,18.62,18.57,18.50,18.45,18.37,18.25,18,17.71,17.33,16.88,16.50,16.12,15.87,15.63,15.50,15.37,15.25,15.12,14.99,14.86,14.72,14.57,14.46,14.36,14.25,14.16,14.09,13.99,13.87,13.75,13.65,13.52,13.21,12.62,11.52,8.35,12.98,12.89,12.76,12.61,12.37,12.13,11.91,11.82,11.89,12.21,12.62,13,13.37,13.63,13.89,14.14,14.37,14.50,14.60,14.45,14.21,13.95,13.86,13.98,14.20,14.15,14.08,14,14,14,14,14,14,14,14,14,14,14,15,14,14,14,15,15,15,15,15,16,15,15,12.72,9.34,6.61,4,2.40,0.72,-0.78,-2.13,-2.48,-2.85,-2.99,-4.15,-4.48,-4.53,-4.66,-4.61,-4.38,-2.92,-1.75,-1.38,-0.79,-0.48,0.72,0.99,1.32,1.50,2.75,4.24,5.50,6.75,9.12,10.57,12.76,14,13,10,8,8,10,13,14,14,14,14,14,14,14,14,14,14,15,15,16,15.75,15.83,15.78,15.78,15.76,15.75,15.71,15.62,15.49,15.28,15.03,14.72,14.25,13.63,12.87,11.96,10.96,10,9.25,8.85,8.96,9.45,10.20,11.01,11.77,12.37,12.76,13,13.11,13.12,13.12,13.12,13.12,13.16,13.27,13.45,13.63,13.88,14.15,14.46,14.74,15,15.28,15.53,15.74,15.85,15.88,15.87,15.84,15.73,15.58,15.32,14.99,14.60,14.15,13.75,13.33,12.88,12.47,12,11.51,11.07,10.62,10.33,10.21,10.37,10.75,11.24,11.76,12.37,12.90,13.37,13.75,14.08,14.36,14.61,14.85,15.03,15.15,15.24,15.16,15.01,14.84,14.65,14.61,14.65,14.87,15.22,15.62,16.01,16.40,16.75,17.02,17.21,17.32,17.37,17.38,17.39,17.38,17.37,17.34,17.26,17.23,17.16,17.12,17.08,17.02,17,17,17,17.02,17.09,17.12,17.16,17.12,17,16.75,16.39,15.97,15.50,15,14.51,14.13,13.89,13.86,14,14.27,14.65,15.12,15.58,16.01,16.45,16.84,17.21,17.58,17.97,18.37,18.82,19.25,19.70,20.12,20.50,20.84,21.10,21.26,21.37,21.38,21.37,21.37,21.37,21.48,21.57,21.62,21.70,21.75,21.73,21.62,21.45,21.27,21.02,20.64,20.21,19.59,18.97,18.50,18.25,18.24,18.37,18.46,18.48,18.40,18.28,18.13,18,17.91,17.88,17.88,17.89,17.91,17.96,17.96,17.96,17.97,17.99,18,18,17.89,17.74,17.45,17.09,16.65,16.25,15.87,15.61,15.39,15.25,15.12,15,14.88,14.76,14.64,14.51,14.46,14.38,14.37,14.35,14.28,14.25,14.14,14.07,13.96,13.87,13.84,13.50,12.83,11.62,8.34,13,12.99,12.95,12.87,12.73,12.41,12.01,11.73,11.76,12.21,12.75,13.25,13.62,13.87,14.12,14.38,14.62,14.75,14.85,14.57,14.26,14.01,13.99,14.12,14.87,14.98,14,14,14,14,14,14,15,14,14,14,14,14,15,14.25,14.12,14.34,14.59,14.77,14.84,14.82,14.82,14.63,13.85,12.58,10.38,7.82,4.85,3.02,1.10,-0.88,-2.39,-2.68,-2.98,-3.36,-4.49,-4.36,-4.64,-4.73,-4.64,-3.62,-3.35,-1.88,-1.55,-0.23,0.35,0.85,2.15,2.64,3.21,4.57,5.83,8.25,9.39,11.62,12.83,14,15,15,14,13,11,8,9,12,14,14,14,15,14,14,15,15,15,15,15,16,15.87,15.87,15.85,15.84,15.82,15.75,15.71,15.62,15.50,15.35,15.12,14.88,14.59,14.14,13.60,12.87,12,11.03,10.12,9.37,8.97,8.98,9.37,10.03,10.85,11.61,12.23,12.65,12.97,13.12,13.25,13.33,13.37,13.45,13.51,13.62,13.77,13.97,14.15,14.37,14.62,14.86,15.11,15.35,15.53,15.73,15.83,15.86,15.84,15.76,15.70,15.58,15.36,15.02,14.62,14.20,13.75,13.32,12.87,12.45,12,11.52,11.11,10.73,10.41,10.35,10.51,10.87,11.36,11.87,12.48,13.07,13.60,14.07,14.48,14.85,15.21,15.50,15.75,15.88,15.88,15.76,15.58,15.25,14.96,14.74,14.62,14.73,14.98,15.28,15.66,16.03,16.38,16.65,16.87,17,17.12,17.16,17.22,17.24,17.23,17.22,17.16,17.14,17.12,17.12,17.11,17.11,17.12,17.12,17.16,17.24,17.27,17.35,17.37,17.32,17.14,16.90,16.60,16.20,15.75,15.27,14.86,14.48,14.16,14.02,14.03,14.23,14.49,14.82,15.20,15.60,15.99,16.37,16.76,17.16,17.62,18.08,18.53,19.02,19.50,19.97,20.37,20.71,20.95,21.09,21.12,21.10,21,20.95,20.90,20.90,20.99,21.01,21.11,21.02,20.87,20.70,20.41,20.21,19.88,19.57,19.12,18.59,18.03,17.65,17.45,17.40,17.52,17.63,17.70,17.64,17.57,17.47,17.37,17.28,17.26,17.26,17.28,17.33,17.37,17.38,17.46,17.51,17.62,17.72,17.75,17.70,17.53,17.25,16.88,16.50,16.09,15.73,15.46,15.25,15.10,14.97,14.85,14.73,14.62,14.50,14.40,14.37,14.37,14.40,14.46,14.48,14.45,14.37,14.26,14.14,14.03,13.98,13.62,12.97,11.73,8.34,13,13,13,12.99,12.91,12.75,12.12,11.34,11.37,12.22,12.87,13.57,13.84,14.12,14.37,14.63,14.85,14.89,14.95,14.72,14.24,14,14,14,14,14,14,14,14,14,14,14,15,15,14,14,13.87,13.95,14,14.12,14.15,14.34,14.50,14.63,14.64,14.50,14.15,13.49,12.36,10.70,8.61,6.25,3.98,1.90,0.20,-1.43,-2.35,-3.05,-3.25,-4.63,-4.75,-4.66,-4.55,-4.63,-4.48,-3.38,-1.13,-0.63,-0.25,0.12,1.63,2.15,3.57,5.09,5.74,7.08,9.50,11.76,12.87,13.95,15,15,16,16,15,15,13,10,9,11,14,14,14,14,14,15,15,15,15,15,16,16,15.95,15.88,15.87,15.83,15.76,15.71,15.62,15.50,15.34,15.14,14.96,14.72,14.40,14.01,13.50,12.85,12.02,11.12,10.25,9.50,9.03,8.98,9.26,9.87,10.61,11.34,11.97,12.47,12.83,13.08,13.25,13.40,13.53,13.66,13.78,13.95,14.09,14.25,14.39,14.60,14.76,14.98,15.16,15.37,15.53,15.66,15.75,15.76,15.75,15.70,15.61,15.48,15.35,15.01,14.62,14.16,13.74,13.28,12.87,12.46,12.01,11.60,11.20,10.86,10.61,10.51,10.66,11,11.46,11.98,12.51,13.12,13.71,14.24,14.74,15.21,15.62,16.01,16.33,16.50,16.50,16.36,16.03,15.65,15.25,14.88,14.64,14.61,14.74,15,15.34,15.66,16,16.28,16.53,16.74,16.87,16.97,17.01,17.08,17.11,17.11,17.11,17.11,17.12,17.12,17.13,17.16,17.24,17.27,17.36,17.41,17.49,17.52,17.53,17.47,17.28,17.07,16.75,16.38,16,15.62,15.23,14.85,14.50,14.28,14.16,14.16,14.28,14.50,14.77,15.12,15.49,15.87,16.27,16.73,17.20,17.70,18.22,18.75,19.25,19.74,20.12,20.46,20.70,20.78,20.78,20.71,20.57,20.38,20.25,20.22,20.21,20.25,20.24,20.09,19.85,19.59,19.27,19.01,18.73,18.39,18,17.60,17.14,16.87,16.70,16.70,16.82,16.90,17,17,16.96,16.87,16.84,16.82,16.77,16.78,16.82,16.85,16.88,16.98,17.09,17.23,17.37,17.50,17.59,17.58,17.40,17.13,16.76,16.37,15.98,15.62,15.36,15.12,14.99,14.85,14.73,14.60,14.48,14.37,14.35,14.35,14.39,14.50,14.60,14.65,14.66,14.62,14.52,14.39,14.25,14.02,13.74,13.12,12,8.52,13,13,13,13,13,12.95,12.11,11.87,11.87,12.23,13.09,13.74,14.09,14.25,14.74,14.86,14.98,14.99,14.99,14.87,14.03,14,14,14,14,14,14,14,14,14,14,14,15,14,13.97,13.65,13.63,13.65,13.75,13.87,14,14.13,14.27,14.36,14.25,13.89,13.24,12.24,10.78,9.03,7.09,4.90,2.84,1,-0.53,-1.75,-2.64,-3.27,-3.93,-4.54,-4.86,-4.75,-4.40,-4.36,-3.14,-1,0.26,0.76,1.24,1.61,3.13,4.62,6.02,7.61,9.07,10.39,11.83,13.87,13.95,15,15,16,17,16,16,14,13,10,9,12,14,14,14,14,15,15,15,16,16,16,16,16,15.91,15.88,15.85,15.77,15.72,15.61,15.49,15.34,15.13,14.95,14.74,14.50,14.21,13.84,13.37,12.75,12,11.20,10.35,9.61,9.12,8.97,9.14,9.63,10.32,11,11.63,12.16,12.61,12.95,13.22,13.46,13.63,13.84,14,14.15,14.34,14.49,14.62,14.76,14.91,15.10,15.25,15.38,15.51,15.62,15.70,15.66,15.62,15.57,15.47,15.35,15.16,14.89,14.53,14.12,13.70,13.26,12.87,12.49,12.09,11.70,11.33,11,10.82,10.74,10.86,11.12,11.53,12.02,12.58,13.12,13.74,14.32,14.87,15.39,15.89,16.36,16.73,16.95,16.96,16.77,16.46,16,15.52,15.10,14.74,14.52,14.57,14.74,15,15.34,15.63,15.96,16.23,16.46,16.62,16.75,16.87,16.95,16.99,17,17.02,17.07,17.10,17.12,17.20,17.25,17.35,17.41,17.51,17.62,17.65,17.72,17.72,17.61,17.40,17.21,16.91,16.62,16.32,15.98,15.62,15.26,14.91,14.62,14.37,14.21,14.13,14.23,14.38,14.64,14.98,15.35,15.75,16.22,16.70,17.23,17.76,18.35,18.87,19.36,19.76,20.10,20.32,20.39,20.37,20.25,19.99,19.71,19.49,19.34,19.25,19.22,19.09,18.87,18.62,18.37,18.09,17.83,17.53,17.25,16.97,16.62,16.32,16.12,16,16.03,16.15,16.28,16.37,16.45,16.46,16.45,16.40,16.39,16.38,16.38,16.41,16.47,16.52,16.65,16.84,17.01,17.22,17.37,17.47,17.45,17.27,17,16.63,16.26,15.88,15.58,15.32,15.11,14.91,14.77,14.62,14.50,14.37,14.28,14.25,14.32,14.40,14.57,14.73,14.86,14.91,14.91,14.87,14.74,14.51,14.22,13.99,13.51,12.52,9.37,13,13,13,13,13,13,13,12,12,13,13,14,14,15,15,15,15,15,15,15,14,14,14,14,14,15,15,15,14,14,14,14,14,13.88,13.61,13.50,13.45,13.48,13.53,13.63,13.75,13.87,13.95,13.96,13.65,13.12,12.21,10.89,9.37,7.64,5.76,3.77,1.87,0.16,-1.13,-2.15,-2.91,-3.50,-3.89,-4.15,-4.29,-4.63,-4.29,-1.75,-0.55,0.62,1.87,2.38,2.87,3.25,4.86,7.25,9.65,11.20,12.49,12.87,12.89,13.97,15,15,16,16,16,16,15,14,11,10,9,11,14,14,14,15,15,15,16,16,16,16,16,15.97,15.90,15.87,15.76,15.70,15.59,15.46,15.28,15.12,14.89,14.71,14.49,14.24,13.95,13.59,13.13,12.60,11.90,11.15,10.37,9.66,9.15,8.95,9.01,9.39,10,10.64,11.32,11.87,12.37,12.77,13.12,13.45,13.71,13.95,14.14,14.36,14.51,14.66,14.83,14.95,15.08,15.20,15.28,15.39,15.50,15.58,15.60,15.53,15.49,15.37,15.27,15.14,15,14.75,14.39,14,13.62,13.25,12.87,12.50,12.15,11.83,11.50,11.22,11.01,10.97,11.03,11.26,11.63,12.11,12.62,13.15,13.74,14.33,14.90,15.50,16.03,16.51,16.95,17.16,17.24,17.09,16.75,16.27,15.77,15.33,14.87,14.57,14.45,14.50,14.73,15,15.32,15.62,15.90,16.20,16.39,16.59,16.72,16.82,16.87,16.95,16.98,17,17.08,17.12,17.23,17.34,17.46,17.58,17.70,17.76,17.86,17.87,17.86,17.73,17.53,17.35,17.11,16.87,16.62,16.37,16.10,15.75,15.37,15,14.62,14.32,14.10,14,14.02,14.22,14.49,14.83,15.23,15.64,16.12,16.62,17.20,17.75,18.33,18.82,19.24,19.57,19.76,19.96,19.87,19.62,19.25,18.88,18.58,18.33,18.12,17.96,17.76,17.58,17.35,17.10,16.87,16.62,16.41,16.21,15.97,15.75,15.51,15.47,15.41,15.50,15.62,15.75,15.87,15.98,16.01,16.07,16.08,16.08,16.08,16.08,16.10,16.13,16.25,16.40,16.63,16.87,17.09,17.25,17.34,17.28,17.13,16.87,16.52,16.16,15.85,15.53,15.28,15.11,14.90,14.75,14.60,14.45,14.32,14.23,14.21,14.25,14.38,14.59,14.78,15,15.15,15.25,15.24,15.14,15,14.62,14.50,14.25,13.62,10.39,13,13,13,13,13,13,13,13,13,13,14,14,15,15,15,15,15,15,15,15,14,14,14,14,15,15,15,15,14,14,14,13.85,13.74,13.60,13.46,13.33,13.26,13.26,13.34,13.38,13.46,13.48,13.40,13.21,12.75,12,10.97,9.62,8.09,6.37,4.59,2.78,1.08,-0.40,-1.60,-2.51,-3.13,-3.50,-3.64,-3.63,-3.50,-3.63,-2.90,-0.39,2.21,2.50,3.75,5.25,5.64,6.10,6.72,9,12.48,13.70,13.95,14.99,14,14,15,15,16,16,16,16,14,12,10,10,9,11,13,14,15,15,15,16,16,16,16,16,16,15.91,15.87,15.78,15.71,15.60,15.46,15.27,15.11,14.87,14.64,14.41,14.20,13.91,13.62,13.27,12.87,12.37,11.75,11.09,10.37,9.72,9.20,8.89,8.89,9.21,9.71,10.35,11,11.61,12.14,12.62,13.02,13.39,13.73,14,14.25,14.49,14.65,14.84,14.98,15.09,15.20,15.26,15.35,15.40,15.47,15.49,15.48,15.39,15.32,15.21,15.09,14.91,14.75,14.50,14.22,13.87,13.51,13.20,12.87,12.58,12.25,11.97,11.66,11.45,11.26,11.22,11.26,11.49,11.78,12.22,12.70,13.21,13.75,14.33,14.90,15.51,16.10,16.61,17,17.26,17.37,17.25,16.95,16.50,16,15.50,15.02,14.63,14.39,14.37,14.48,14.72,15,15.35,15.64,15.97,16.24,16.41,16.60,16.71,16.77,16.86,16.89,16.98,17.03,17.13,17.25,17.38,17.53,17.71,17.85,17.95,18,18.01,17.99,17.86,17.65,17.49,17.27,17.12,16.99,16.84,16.62,16.27,15.88,15.45,14.97,14.50,14.12,13.89,13.83,13.87,14.09,14.37,14.71,15.10,15.51,16,16.50,17.02,17.58,18.08,18.50,18.89,19.13,19.21,19.10,18.83,18.39,17.97,17.53,17.20,16.88,16.65,16.47,16.25,16.08,15.87,15.73,15.52,15.40,15.25,15.11,14.97,14.85,14.87,14.91,15.01,15.15,15.32,15.46,15.58,15.65,15.74,15.76,15.76,15.75,15.75,15.78,15.87,16,16.23,16.48,16.74,16.98,17.12,17.16,17.12,16.96,16.71,16.38,16.10,15.78,15.51,15.33,15.12,14.96,14.75,14.60,14.40,14.25,14.14,14.12,14.20,14.34,14.53,14.78,15.08,15.33,15.50,15.62,15.65,15.60,15.50,15.37,15.26,14.97,12.47,13,13,14,14,13,14,14,13,14,14,14,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14.07,14,13.87,13.73,13.57,13.39,13.25,13.14,13.08,13.07,13.08,13.11,13.10,13.01,12.83,12.46,11.84,10.95,9.82,8.40,6.85,5.13,3.45,1.75,0.25,-1,-2,-2.68,-3.17,-3.29,-3.14,-2.75,-2.14,-1.36,0.41,3.02,3.85,5.35,6.85,8.37,9.65,10.12,10.57,9.85,12.99,14,14,15,15,15,15,15,16,16,16,15,13,12,11,10,10,10,13,14,15,15,16,16,16,16,16,16,15.97,15.89,15.82,15.72,15.60,15.45,15.25,15.09,14.87,14.62,14.37,14.12,13.87,13.61,13.28,12.96,12.53,12.09,11.52,10.91,10.28,9.70,9.20,8.87,8.83,9.01,9.48,10.08,10.73,11.37,11.97,12.49,12.96,13.37,13.73,14.02,14.33,14.58,14.76,14.96,15.10,15.20,15.26,15.34,15.37,15.39,15.39,15.37,15.34,15.25,15.12,14.99,14.85,14.70,14.50,14.25,14,13.72,13.40,13.12,12.87,12.62,12.36,12.12,11.87,11.65,11.51,11.49,11.53,11.74,12.01,12.38,12.86,13.34,13.85,14.37,14.97,15.53,16.12,16.62,17.01,17.32,17.39,17.33,17.07,16.65,16.20,15.66,15.21,14.76,14.46,14.25,14.32,14.49,14.75,15.10,15.41,15.75,16.08,16.28,16.47,16.59,16.66,16.75,16.83,16.89,17,17.13,17.28,17.48,17.63,17.84,17.99,18.10,18.15,18.15,18.12,17.98,17.82,17.62,17.50,17.39,17.34,17.25,17.12,16.88,16.50,15.90,15.37,14.82,14.34,14,13.82,13.77,13.87,14.09,14.34,14.62,14.96,15.32,15.75,16.22,16.70,17.22,17.63,17.99,18.15,18.23,18.13,17.88,17.46,16.91,16.46,16.01,15.66,15.38,15.20,15.01,14.88,14.75,14.74,14.62,14.60,14.50,14.40,14.36,14.35,14.48,14.53,14.64,14.82,14.97,15.11,15.24,15.35,15.40,15.48,15.49,15.48,15.48,15.50,15.60,15.76,16.01,16.34,16.62,16.87,17,17.02,16.96,16.76,16.52,16.25,16,15.75,15.53,15.36,15.15,15,14.82,14.62,14.41,14.25,14.12,14.09,14.12,14.24,14.45,14.72,15,15.35,15.65,15.95,16.12,16.16,16.25,16.25,16.41,16.21,14.51,14,14,14,14,14,14,14,14,14,14,15,15,16,16,16,15,15,15,15,15,15,15,15,15,15,15,14.95,14.64,14.34,14,13.82,13.62,13.45,13.25,13.10,12.97,12.88,12.85,12.78,12.76,12.71,12.53,12.25,11.73,10.97,9.97,8.74,7.26,5.66,4,2.32,0.70,-0.66,-1.64,-2.35,-2.76,-2.88,-2.75,-2.28,-1.43,-0.29,1.22,3.07,5,7.52,8.13,9.70,11.15,11.57,13,13,12,12,13,14,15,15,16,15,15,15,15,15,14,12,13,14,12,11,12,12,15,15,16,16,16,16,16,16,16,15.95,15.86,15.75,15.62,15.47,15.27,15.10,14.87,14.62,14.37,14.11,13.84,13.57,13.25,12.96,12.61,12.22,11.75,11.26,10.75,10.16,9.62,9.14,8.85,8.75,8.90,9.33,9.87,10.51,11.16,11.78,12.37,12.87,13.32,13.71,14.03,14.37,14.62,14.85,15.01,15.15,15.25,15.34,15.37,15.37,15.37,15.34,15.25,15.16,15.07,14.90,14.75,14.61,14.41,14.24,14,13.77,13.53,13.28,13.07,12.85,12.62,12.45,12.25,12.07,11.88,11.77,11.75,11.86,12.03,12.34,12.72,13.12,13.59,14.07,14.53,15.08,15.62,16.12,16.62,17.01,17.28,17.40,17.37,17.13,16.77,16.35,15.85,15.36,14.90,14.53,14.25,14.20,14.32,14.57,14.87,15.23,15.58,15.87,16.13,16.33,16.41,16.51,16.62,16.72,16.83,16.97,17.12,17.33,17.51,17.75,17.96,18.12,18.24,18.32,18.27,18.24,18.11,17.95,17.82,17.73,17.70,17.66,17.65,17.60,17.37,17,16.48,15.83,15.15,14.57,14.13,13.90,13.83,13.85,13.91,14.03,14.21,14.37,14.62,14.95,15.33,15.74,16.15,16.57,16.87,17.07,17.14,17.01,16.74,16.33,15.86,15.36,14.99,14.62,14.35,14.13,14.02,13.97,13.90,13.98,13.95,14,14,13.98,14,14.09,14.24,14.34,14.46,14.60,14.74,14.86,14.97,15.07,15.12,15.15,15.16,15.15,15.16,15.23,15.35,15.53,15.84,16.13,16.45,16.65,16.77,16.78,16.73,16.57,16.37,16.14,15.95,15.75,15.58,15.38,15.23,15.03,14.87,14.66,14.49,14.32,14.15,14.09,14.08,14.12,14.28,14.53,14.87,15.22,15.62,16.01,16.34,16.51,16.72,16.82,17,16.65,14.60,14,14,14,14,14,14,14,14,14,15,15,16,16,16,16,15,15,15,15,15,15,16,16,15,15,15.12,14.90,14.62,14.33,14.02,13.77,13.57,13.32,13.11,12.95,12.78,12.65,12.61,12.52,12.41,12.27,12.03,11.62,11,10.13,9.02,7.71,6.20,4.58,2.88,1.25,-0.30,-1.75,-2.13,-2.38,-2.55,-2.38,-1.90,-1,0.23,1.75,3.45,5.38,7.33,8.97,10.72,12.39,12.65,13,14,14,13,13,13,14,14,15,15,15,15,15,14,13,13,13,15,15,14,13,12,13,15,16,16,16,16,16,16,16,15.98,15.90,15.83,15.66,15.50,15.34,15.12,14.87,14.62,14.37,14.10,13.83,13.52,13.25,12.91,12.61,12.25,11.87,11.47,11,10.51,10.01,9.52,9.12,8.84,8.74,8.87,9.25,9.75,10.38,11.02,11.65,12.25,12.78,13.25,13.70,14.07,14.37,14.63,14.87,15.07,15.21,15.28,15.36,15.37,15.36,15.28,15.24,15.12,15,14.87,14.72,14.52,14.37,14.16,13.99,13.76,13.59,13.37,13.15,12.99,12.83,12.64,12.50,12.37,12.23,12.11,12.02,12.07,12.15,12.38,12.71,13.10,13.50,13.96,14.38,14.84,15.27,15.75,16.23,16.63,17,17.26,17.38,17.37,17.20,16.87,16.46,15.99,15.50,15.03,14.64,14.37,14.14,14.22,14.39,14.70,15,15.37,15.66,15.96,16.12,16.24,16.34,16.45,16.57,16.72,16.87,17.10,17.33,17.58,17.84,18.07,18.25,18.36,18.40,18.37,18.35,18.22,18.08,17.99,17.96,17.97,18,18,17.95,17.75,17.39,16.89,16.28,15.66,15.12,14.71,14.37,14.22,14.15,14.14,14.12,14.08,14.03,14.10,14.22,14.41,14.74,15.10,15.41,15.72,15.87,15.90,15.82,15.58,15.24,14.84,14.39,14.01,13.85,13.62,13.48,13.38,13.37,13.38,13.51,13.53,13.66,13.74,13.78,13.91,14,14.21,14.33,14.45,14.57,14.64,14.73,14.76,14.84,14.87,14.87,14.87,14.87,14.87,14.96,15.10,15.33,15.62,15.91,16.23,16.41,16.52,16.57,16.50,16.37,16.23,16.07,15.88,15.75,15.60,15.45,15.26,15.12,14.95,14.75,14.59,14.38,14.24,14.11,14.02,14.03,14.14,14.36,14.62,14.98,15.37,15.78,16.12,16.38,16.53,16.60,16.72,16.11,13.66,14,14,14,14,14,14,14,14,15,15,16,16,17,16,16,15,15,15,15,16,16,16,16,15.97,15.62,15.24,14.88,14.61,14.32,14.01,13.74,13.47,13.23,13,12.76,12.62,12.47,12.37,12.24,12.10,11.86,11.50,11,10.26,9.32,8.11,6.70,5.12,3.46,1.82,0.28,-1,-1.88,-2.05,-2.05,-2,-1.50,-0.65,0.52,1.99,3.61,5.45,7.33,9.37,10.62,11.76,13.73,14,13,13,14,13,13,14,14,14,14,14,14,14,14,14,13,12,14,16,16,15,14,13,13,14,16,16,16,16,16,16,16,15.99,15.89,15.76,15.61,15.38,15.16,14.95,14.66,14.39,14.12,13.84,13.52,13.25,12.95,12.62,12.27,11.91,11.57,11.15,10.75,10.34,9.87,9.47,9.09,8.83,8.75,8.87,9.22,9.72,10.32,10.95,11.59,12.20,12.75,13.24,13.65,14.03,14.37,14.64,14.88,15.08,15.21,15.27,15.33,15.33,15.26,15.21,15.11,14.99,14.85,14.66,14.50,14.32,14.12,13.91,13.75,13.57,13.37,13.21,13.02,12.88,12.75,12.63,12.52,12.45,12.36,12.27,12.26,12.35,12.50,12.75,13.12,13.50,13.97,14.38,14.83,15.22,15.60,15.98,16.36,16.71,17,17.25,17.37,17.35,17.20,16.90,16.53,16.11,15.63,15.21,14.78,14.49,14.26,14.16,14.28,14.52,14.84,15.12,15.41,15.70,15.85,15.97,16.10,16.23,16.37,16.58,16.76,17.01,17.28,17.60,17.87,18.12,18.35,18.46,18.49,18.50,18.39,18.27,18.21,18.14,18.15,18.24,18.28,18.35,18.28,18.12,17.78,17.34,16.75,16.21,15.73,15.38,15.21,15.10,15,14.89,14.75,14.57,14.36,14.16,14.09,14.07,14.12,14.25,14.45,14.62,14.77,14.74,14.65,14.58,14.33,14,13.74,13.48,13.28,13.25,13.16,13.15,13.16,13.24,13.37,13.47,13.62,13.75,13.90,14.03,14.16,14.37,14.50,14.62,14.71,14.74,14.73,14.71,14.66,14.64,14.62,14.62,14.62,14.62,14.71,14.86,15.10,15.37,15.70,15.98,16.16,16.28,16.34,16.28,16.22,16.12,16,15.87,15.75,15.62,15.50,15.36,15.22,15.03,14.87,14.71,14.50,14.34,14.15,14.02,13.99,14.01,14.14,14.37,14.66,15,15.35,15.62,15.75,15.83,15.71,15.51,14.75,11.76,14,14,14,15,14,14,14,15,15,16,16,16,16,16,16,15,15,15,16,16,16,16,15.96,15.87,15.64,15.23,14.88,14.60,14.28,14,13.66,13.38,13.12,12.87,12.62,12.47,12.27,12.11,11.91,11.71,11.39,10.95,10.34,9.50,8.46,7.14,5.65,4.01,2.35,0.77,-0.63,-1.36,-1.64,-1.64,-1.38,-0.93,-0.25,0.76,2.08,3.51,5.20,7,8.62,9.98,11.12,12.22,13.37,14,13,13,13,14,14,14,14,15,14,14,14,14,14,14,13,13,15,16,17,17,16,15,14,14,15,16,16,16,16.12,16.12,16.10,15.99,15.87,15.74,15.51,15.27,15.01,14.75,14.48,14.15,13.87,13.58,13.25,12.97,12.64,12.34,12,11.64,11.28,10.95,10.57,10.16,9.76,9.39,9.08,8.85,8.75,8.87,9.21,9.65,10.25,10.87,11.51,12.12,12.71,13.22,13.64,14.03,14.37,14.64,14.87,15.07,15.16,15.25,15.25,15.24,15.15,15.08,14.96,14.78,14.62,14.47,14.25,14.08,13.87,13.71,13.50,13.36,13.20,13.02,12.89,12.78,12.72,12.62,12.57,12.50,12.47,12.45,12.49,12.61,12.83,13.12,13.52,13.98,14.45,14.87,15.27,15.64,15.97,16.25,16.50,16.77,17.01,17.22,17.32,17.28,17.16,16.95,16.61,16.22,15.76,15.36,14.97,14.62,14.38,14.25,14.25,14.41,14.63,14.87,15.12,15.37,15.50,15.65,15.85,16.01,16.23,16.41,16.65,16.95,17.25,17.58,17.87,18.13,18.34,18.41,18.47,18.46,18.39,18.37,18.34,18.35,18.37,18.46,18.50,18.51,18.48,18.27,17.99,17.57,17.11,16.66,16.36,16.16,16.12,16.09,16,15.87,15.62,15.36,15.03,14.73,14.40,14.14,13.98,13.87,13.87,13.97,14.03,14,13.98,13.83,13.62,13.50,13.37,13.25,13.16,13.20,13.23,13.25,13.28,13.36,13.50,13.62,13.78,14,14.15,14.33,14.50,14.70,14.86,14.96,14.99,14.95,14.84,14.72,14.61,14.50,14.46,14.39,14.38,14.40,14.50,14.64,14.87,15.15,15.48,15.75,15.97,16.10,16.13,16.13,16.11,16.03,15.97,15.87,15.76,15.66,15.57,15.46,15.33,15.16,15.01,14.86,14.64,14.45,14.25,14.07,13.96,13.91,14,14.14,14.38,14.64,14.88,15.07,15.12,14.96,14.75,14.25,13.33,9.87,14,14,14,14,14,14,15,15,16,16,17,16,16,16,16,15,15,15,16,16,16,15.96,15.89,15.78,15.47,15.14,14.86,14.57,14.25,13.95,13.63,13.34,13.03,12.76,12.51,12.27,12.07,11.86,11.59,11.27,10.88,10.36,9.63,8.74,7.60,6.23,4.65,2.99,1.25,-0.25,-1.24,-1.55,-1.37,-1.03,-0.51,0.15,1.07,2.20,3.50,4.98,6.52,8.09,9.38,10.36,11.22,12.02,12.82,12.87,13,13,13,14,14,14,14,14,14,15,15,15,15,15,14,14,16,16,16,16,16,15,15,15,15,15.96,16.11,16.24,16.32,16.50,16.12,16,15.87,15.70,15.45,15.15,14.87,14.59,14.25,13.96,13.62,13.33,13,12.72,12.39,12.11,11.76,11.46,11.12,10.75,10.40,10.07,9.72,9.37,9.08,8.87,8.78,8.89,9.21,9.63,10.22,10.85,11.49,12.12,12.70,13.21,13.64,14.03,14.37,14.64,14.87,15.01,15.12,15.16,15.16,15.12,15.02,14.90,14.75,14.61,14.40,14.24,14.02,13.85,13.64,13.48,13.32,13.14,13,12.87,12.77,12.71,12.62,12.59,12.53,12.51,12.51,12.58,12.65,12.86,13.12,13.50,13.96,14.41,14.90,15.37,15.77,16.11,16.34,16.51,16.71,16.87,17.02,17.15,17.25,17.24,17.12,16.90,16.62,16.26,15.88,15.50,15.12,14.83,14.57,14.38,14.28,14.36,14.49,14.64,14.85,15.01,15.23,15.41,15.63,15.87,16.11,16.34,16.59,16.87,17.21,17.52,17.87,18.12,18.32,18.38,18.39,18.40,18.40,18.41,18.46,18.50,18.52,18.62,18.65,18.64,18.57,18.37,18.07,17.70,17.34,17.03,16.88,16.87,16.97,17.01,17,16.87,16.62,16.32,15.95,15.57,15.14,14.72,14.28,13.98,13.77,13.76,13.85,13.86,13.87,13.75,13.51,13.33,13.23,13.26,13.33,13.37,13.48,13.53,13.61,13.66,13.82,13.95,14.14,14.35,14.52,14.74,14.90,15.12,15.26,15.37,15.36,15.23,15.01,14.78,14.60,14.41,14.33,14.25,14.24,14.25,14.35,14.50,14.73,15,15.27,15.57,15.76,15.91,16,16.07,16.03,16,15.98,15.89,15.85,15.75,15.64,15.57,15.46,15.34,15.20,15,14.82,14.58,14.35,14.12,13.97,13.87,13.89,14,14.20,14.37,14.53,14.62,14.62,14.41,14.08,13.49,12.37,9,15,15,15,14,14,14,15,16,16,17,17,16,16,16,16,15,15,15,15,16,15.88,15.85,15.78,15.52,15.28,15.02,14.76,14.48,14.20,13.88,13.57,13.25,12.97,12.66,12.38,12.12,11.84,11.57,11.23,10.85,10.33,9.71,8.87,7.87,6.65,5.25,3.65,1.98,0.28,-1.49,-1.90,-1.48,-0.97,-0.37,0.37,1.25,2.28,3.49,4.84,6.25,7.65,8.97,9.90,10.72,11.32,11.85,12.21,12.32,12.11,12,13,14,14,15,14,14,14,15,15,15,16,16,15,15,15,16,16,16,16,16,16,16,15,15.85,16.16,16.61,16.50,16.27,16.12,15.98,15.86,15.63,15.37,15.07,14.75,14.40,14.09,13.75,13.39,13.11,12.82,12.50,12.22,11.90,11.62,11.28,10.99,10.64,10.33,9.99,9.64,9.35,9.08,8.87,8.83,8.91,9.22,9.63,10.21,10.84,11.48,12.11,12.66,13.21,13.63,14.02,14.37,14.62,14.84,14.98,15.07,15.10,15.08,15,14.87,14.74,14.58,14.37,14.21,14,13.82,13.62,13.45,13.26,13.12,12.99,12.86,12.75,12.64,12.60,12.53,12.51,12.50,12.51,12.59,12.66,12.83,13.08,13.39,13.84,14.33,14.86,15.38,15.87,16.25,16.50,16.66,16.77,16.87,16.97,17.03,17.12,17.14,17.12,17.02,16.87,16.62,16.33,16,15.63,15.32,15,14.75,14.58,14.39,14.35,14.36,14.46,14.62,14.78,15,15.27,15.58,15.85,16.09,16.32,16.53,16.85,17.20,17.52,17.87,18.12,18.27,18.36,18.37,18.37,18.41,18.49,18.53,18.62,18.65,18.71,18.74,18.71,18.59,18.36,18.07,17.74,17.49,17.35,17.35,17.46,17.62,17.75,17.83,17.75,17.58,17.26,16.95,16.52,16.10,15.61,15.07,14.50,14.13,14.03,14.12,14.24,14.34,14.21,13.90,13.62,13.48,13.48,13.59,13.74,13.86,13.91,13.99,14.09,14.21,14.36,14.53,14.75,14.96,15.14,15.37,15.61,15.75,15.85,15.76,15.53,15.24,14.89,14.62,14.38,14.25,14.15,14.12,14.14,14.25,14.38,14.62,14.87,15.15,15.45,15.65,15.84,15.96,16,16.02,16.03,16.01,15.99,15.91,15.87,15.77,15.71,15.61,15.49,15.35,15.15,14.96,14.72,14.47,14.23,14.02,13.91,13.89,13.99,14.12,14.26,14.38,14.46,14.36,14.20,13.82,13.15,12.12,9.12,15,15,15,15,15,15,16,16,17,17,17,16,16,16,15,15,15,15,15,15.01,15.53,15.63,15.52,15.33,15.12,14.89,14.63,14.37,14.11,13.77,13.49,13.16,12.87,12.57,12.25,11.91,11.60,11.23,10.77,10.33,9.73,9,8.12,7,5.73,4.26,2.72,1.11,-0.49,-1.84,-1.72,-1.15,-0.43,0.37,1.32,2.32,3.45,4.71,6.01,7.38,8.72,9.73,10.50,11.11,11.50,11.78,12,12.02,11.57,12,13,13,14,15,15,14,14,15,15,16,16,16,16,15,15,17,16,16,17,16,16,15.99,15.87,15.88,16.16,16.50,16.38,16.22,16.08,15.97,15.84,15.61,15.28,14.97,14.62,14.25,13.90,13.58,13.23,12.91,12.62,12.35,12.07,11.76,11.50,11.21,10.88,10.59,10.25,9.91,9.62,9.32,9.07,8.88,8.86,8.97,9.25,9.66,10.24,10.86,11.50,12.12,12.70,13.21,13.64,14.02,14.35,14.60,14.76,14.89,14.97,14.98,14.91,14.85,14.72,14.53,14.37,14.16,13.99,13.77,13.60,13.40,13.25,13.10,12.96,12.83,12.72,12.61,12.52,12.49,12.46,12.46,12.48,12.51,12.62,12.75,12.96,13.25,13.63,14.12,14.63,15.21,15.76,16.25,16.62,16.87,16.98,17,17,17.01,17.02,17.03,17.03,17,16.90,16.76,16.59,16.35,16.07,15.76,15.49,15.22,14.97,14.75,14.58,14.38,14.37,14.38,14.50,14.70,14.97,15.28,15.62,15.96,16.21,16.40,16.62,16.88,17.24,17.58,17.89,18.14,18.27,18.34,18.35,18.37,18.41,18.51,18.62,18.72,18.75,18.76,18.75,18.65,18.50,18.25,18,17.75,17.61,17.60,17.72,17.91,18.20,18.45,18.59,18.59,18.46,18.22,17.89,17.51,17.08,16.52,15.96,15.36,14.87,14.62,14.65,14.95,15.13,15.03,14.64,14.20,13.87,13.75,13.83,13.98,14.12,14.25,14.37,14.47,14.62,14.75,14.96,15.12,15.35,15.59,15.83,16.07,16.22,16.26,16.14,15.85,15.39,15,14.63,14.37,14.22,14.12,14.09,14.11,14.20,14.35,14.57,14.84,15.12,15.37,15.62,15.78,15.91,16.01,16.09,16.12,16.12,16.11,16.08,16,15.95,15.86,15.75,15.62,15.50,15.32,15.10,14.85,14.61,14.37,14.20,14.09,14.03,14.12,14.25,14.37,14.47,14.48,14.38,14.16,13.78,13.13,12.25,9.25,15,15,15,15,15,16,16,17,17,17,16,16,16,15,15,15,15,15,15,15.08,15.25,15.37,15.23,15.10,14.91,14.73,14.50,14.25,13.97,13.65,13.37,13.07,12.75,12.38,12.03,11.70,11.25,10.83,10.34,9.74,9.01,8.21,7.24,6.09,4.76,3.36,1.86,0.39,-0.88,-1.63,-1.35,-0.65,0.21,1.14,2.22,3.32,4.50,5.76,7.08,8.39,9.62,10.47,11.07,11.50,11.85,12.01,12.12,12.15,12.23,12.11,13,13,14,15,15,14,14,15,16,16,16,16,16,16,16,16,16,16,17,16,16,16,16,16.02,16.12,16.20,16.20,16.11,16.01,15.95,15.82,15.57,15.23,14.87,14.50,14.12,13.76,13.40,13.08,12.76,12.49,12.22,11.95,11.66,11.39,11.12,10.84,10.50,10.21,9.87,9.59,9.28,9.08,8.90,8.88,9.01,9.33,9.75,10.28,10.89,11.53,12.14,12.73,13.23,13.64,14.01,14.33,14.53,14.72,14.82,14.86,14.85,14.76,14.65,14.51,14.36,14.15,13.98,13.76,13.59,13.38,13.24,13.08,12.90,12.77,12.65,12.57,12.48,12.39,12.37,12.37,12.37,12.40,12.50,12.62,12.83,13.10,13.40,13.86,14.36,14.89,15.49,16.07,16.52,16.87,17.11,17.15,17.14,17.11,17.03,17,16.98,16.91,16.87,16.78,16.66,16.50,16.34,16.11,15.87,15.62,15.39,15.16,14.97,14.75,14.58,14.45,14.39,14.50,14.75,15.08,15.47,15.84,16.13,16.38,16.62,16.82,17.02,17.34,17.64,17.98,18.22,18.33,18.34,18.32,18.35,18.41,18.57,18.66,18.76,18.84,18.84,18.75,18.62,18.46,18.23,18,17.82,17.75,17.85,18.08,18.37,18.72,19,19.24,19.32,19.25,19.10,18.85,18.50,18.01,17.47,16.84,16.16,15.63,15.33,15.26,15.49,15.74,15.73,15.34,14.78,14.33,14.01,13.98,14.02,14.20,14.37,14.58,14.75,14.96,15.11,15.26,15.47,15.70,15.91,16.20,16.46,16.63,16.60,16.38,16,15.50,15.07,14.65,14.37,14.16,14.09,14.03,14.09,14.16,14.34,14.53,14.82,15.10,15.37,15.61,15.78,15.97,16.09,16.15,16.23,16.25,16.25,16.24,16.20,16.12,16,15.89,15.76,15.62,15.41,15.22,14.99,14.75,14.58,14.40,14.35,14.35,14.41,14.53,14.63,14.71,14.66,14.59,14.34,13.90,13.22,12.22,9.38,15,15,15,16,16,17,17,17,17,17,16,16,15,15,15,14,14,14,14.75,14.86,15,14.99,14.95,14.86,14.73,14.51,14.33,14.08,13.78,13.51,13.23,12.90,12.57,12.21,11.82,11.37,10.88,10.36,9.75,9.07,8.25,7.36,6.32,5.12,3.82,2.45,1.10,-0.12,-1,-1.22,-0.79,-0.04,0.87,1.96,3.11,4.26,5.48,6.75,8,9.22,10.33,11.09,11.62,11.99,12.25,12.41,12.50,12.59,12.71,13.08,14,14,14,15,15,14,15,15,16,16,16,16,16,16,16,16,16,16,16.07,16.87,16.16,16.21,16.22,16.13,16.12,16.10,16.08,16.01,15.98,15.87,15.72,15.45,15.12,14.75,14.37,14,13.63,13.27,12.96,12.64,12.37,12.11,11.86,11.60,11.34,11.03,10.75,10.47,10.14,9.85,9.53,9.27,9.10,8.99,8.99,9.12,9.45,9.87,10.41,11.01,11.63,12.24,12.77,13.25,13.66,14.01,14.28,14.50,14.62,14.72,14.73,14.70,14.62,14.49,14.35,14.15,13.98,13.77,13.60,13.39,13.24,13.07,12.89,12.75,12.62,12.51,12.41,12.35,12.27,12.25,12.25,12.28,12.37,12.49,12.63,12.87,13.16,13.53,14,14.52,15.10,15.66,16.24,16.71,17.02,17.23,17.26,17.24,17.12,17.02,16.96,16.87,16.82,16.75,16.65,16.58,16.46,16.28,16.12,15.96,15.75,15.59,15.37,15.16,14.98,14.75,14.61,14.52,14.62,14.89,15.27,15.66,16.08,16.37,16.62,16.86,17.02,17.24,17.48,17.75,18.03,18.25,18.35,18.34,18.28,18.33,18.41,18.58,18.72,18.83,18.87,18.85,18.75,18.62,18.41,18.23,18.01,17.89,17.91,18.11,18.40,18.82,19.22,19.58,19.84,19.98,19.99,19.87,19.62,19.35,18.90,18.36,17.63,16.89,16.25,15.78,15.64,15.82,16.07,16.13,15.77,15.16,14.60,14.24,14.07,14.09,14.23,14.45,14.70,14.97,15.21,15.36,15.51,15.71,15.88,16.13,16.45,16.73,16.91,16.85,16.50,16.07,15.51,15.03,14.63,14.36,14.14,14.07,14.02,14.09,14.20,14.36,14.58,14.85,15.12,15.37,15.62,15.86,16.01,16.15,16.27,16.37,16.41,16.46,16.45,16.37,16.32,16.20,16.03,15.88,15.73,15.52,15.34,15.12,14.96,14.83,14.74,14.72,14.75,14.84,14.91,15,15,15,14.78,14.50,14.01,13.25,11.98,9.33,15,15,16,16,17,17,17,17,17,16,16,15,15,15,14,14,14,14.07,14.37,14.61,14.70,14.72,14.66,14.62,14.49,14.33,14.11,13.87,13.61,13.34,13.01,12.66,12.33,11.88,11.46,10.98,10.38,9.77,9.10,8.33,7.41,6.40,5.27,4.07,2.76,1.50,0.37,-0.50,-0.90,-0.85,-0.28,0.59,1.62,2.75,3.96,5.13,6.37,7.58,8.75,9.87,10.85,11.61,12.12,12.47,12.71,12.86,12.96,13.02,13.24,13.58,14,15,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,16,16.12,16.25,16.37,16.39,16.37,16.24,16.12,16.03,16,15.98,15.89,15.82,15.61,15.34,14.98,14.61,14.24,13.87,13.50,13.15,12.85,12.53,12.25,12,11.75,11.50,11.25,10.98,10.70,10.38,10.10,9.82,9.52,9.32,9.13,9.09,9.12,9.33,9.63,10.10,10.62,11.22,11.78,12.37,12.87,13.34,13.73,14.01,14.26,14.46,14.53,14.61,14.60,14.51,14.41,14.32,14.13,13.99,13.78,13.62,13.41,13.25,13.08,12.90,12.75,12.62,12.50,12.37,12.27,12.22,12.15,12.13,12.15,12.23,12.33,12.47,12.64,12.90,13.25,13.63,14.12,14.64,15.22,15.76,16.32,16.75,17.10,17.25,17.27,17.24,17.12,17,16.87,16.76,16.71,16.62,16.53,16.48,16.37,16.25,16.13,16,15.87,15.74,15.57,15.38,15.22,15,14.85,14.75,14.85,15.12,15.48,15.87,16.25,16.60,16.87,17.09,17.25,17.41,17.62,17.85,18.08,18.25,18.33,18.28,18.25,18.28,18.39,18.58,18.74,18.86,18.88,18.87,18.78,18.62,18.45,18.25,18.12,18.07,18.14,18.40,18.78,19.25,19.71,20.11,20.40,20.60,20.62,20.57,20.38,20.12,19.72,19.12,18.35,17.50,16.70,16.11,15.78,15.83,16,16.03,15.73,15.15,14.65,14.28,14.10,14.09,14.24,14.48,14.75,15.07,15.26,15.49,15.64,15.82,16,16.25,16.52,16.86,17.03,16.99,16.50,16,15.48,15,14.61,14.33,14.13,14.07,14.03,14.11,14.22,14.38,14.62,14.88,15.15,15.46,15.71,15.91,16.12,16.26,16.41,16.53,16.62,16.65,16.65,16.61,16.50,16.37,16.20,16,15.84,15.63,15.47,15.32,15.20,15.12,15.11,15.12,15.21,15.27,15.37,15.37,15.37,15.23,14.95,14.58,14.08,13.32,11.96,10.25,16,16,16,17,18,17,17,17,16,16,15,15,15,14,14,14,14,14.10,14.23,14.37,14.46,14.48,14.46,14.37,14.25,14.10,13.87,13.62,13.37,13.08,12.73,12.37,11.96,11.50,11,10.41,9.78,9.12,8.35,7.46,6.49,5.39,4.25,3,1.74,0.59,-0.30,-0.86,-0.90,-0.53,0.21,1.21,2.34,3.52,4.75,5.99,7.15,8.35,9.41,10.40,11.32,12,12.51,12.87,13.10,13.25,13.39,13.50,13.65,13.91,14.25,15,16,16,15,15,15,15,15,15,16,16,16,16,16,16,16,16,16.07,16.20,16.34,16.49,16.45,16.25,16.12,16.01,15.98,15.90,15.84,15.66,15.46,15.14,14.82,14.46,14.09,13.74,13.37,13.03,12.74,12.45,12.15,11.90,11.66,11.40,11.14,10.87,10.61,10.33,10.02,9.76,9.52,9.37,9.25,9.25,9.35,9.58,9.90,10.37,10.87,11.46,12,12.51,13,13.41,13.75,14.03,14.25,14.37,14.47,14.49,14.45,14.37,14.25,14.12,13.97,13.78,13.62,13.46,13.26,13.11,12.95,12.76,12.62,12.50,12.37,12.25,12.14,12.10,12.03,12.02,12.08,12.13,12.25,12.45,12.64,12.96,13.28,13.73,14.21,14.73,15.25,15.82,16.32,16.74,17.02,17.20,17.23,17.15,17.07,16.91,16.78,16.70,16.60,16.50,16.46,16.37,16.33,16.25,16.14,16.08,15.98,15.86,15.74,15.61,15.46,15.26,15.12,15.02,15.09,15.28,15.61,15.98,16.36,16.71,17,17.25,17.47,17.62,17.75,17.87,18.03,18.16,18.25,18.24,18.24,18.26,18.38,18.58,18.74,18.87,18.95,18.91,18.83,18.66,18.50,18.34,18.24,18.25,18.41,18.75,19.20,19.66,20.16,20.62,20.90,21.12,21.24,21.21,21.03,20.75,20.34,19.71,18.86,17.89,16.98,16.24,15.75,15.60,15.59,15.53,15.37,15,14.62,14.28,14.11,14.10,14.24,14.48,14.76,15.09,15.32,15.50,15.64,15.78,15.98,16.21,16.49,16.76,16.99,16.88,16.41,15.87,15.36,14.88,14.51,14.26,14.12,14.08,14.08,14.13,14.26,14.47,14.71,14.98,15.25,15.52,15.78,16.01,16.24,16.40,16.59,16.73,16.84,16.88,16.88,16.83,16.71,16.51,16.34,16.12,15.96,15.76,15.62,15.51,15.48,15.47,15.50,15.59,15.65,15.75,15.75,15.72,15.60,15.33,15,14.62,14.13,13.47,12.41,10.12,17,17,17,17,18,17,17,16,16,15,15,15,14,14,14,14,14,14.03,14.12,14.23,14.25,14.25,14.25,14.13,14,13.82,13.59,13.35,13.03,12.73,12.36,11.97,11.49,11,10.40,9.77,9.10,8.32,7.46,6.51,5.50,4.37,3.14,1.86,0.61,-0.47,-1.13,-1.29,-1,-0.26,0.66,1.78,3.02,4.26,5.51,6.75,7.90,9,10.02,10.91,11.73,12.37,12.86,13.20,13.46,13.62,13.82,13.90,14.03,14.25,14.59,15,16,15,15,15,15,15,15,15,16,16,16,16,16,16,16,16,16.03,16.14,16.28,16.39,16.37,16.25,16.11,16,15.91,15.84,15.71,15.50,15.25,14.97,14.62,14.26,13.90,13.58,13.24,12.90,12.62,12.34,12.07,11.82,11.58,11.32,11.03,10.77,10.50,10.25,10,9.75,9.59,9.46,9.39,9.47,9.62,9.87,10.25,10.71,11.22,11.74,12.25,12.74,13.15,13.52,13.84,14.08,14.24,14.34,14.37,14.36,14.27,14.20,14.08,13.91,13.76,13.62,13.48,13.28,13.12,12.97,12.78,12.63,12.50,12.36,12.24,12.12,12.01,11.97,11.91,11.95,11.99,12.08,12.21,12.38,12.62,12.96,13.33,13.75,14.25,14.75,15.25,15.75,16.25,16.62,16.89,17.07,17.11,17.07,16.97,16.84,16.72,16.60,16.50,16.41,16.37,16.33,16.26,16.24,16.15,16.12,16.03,15.98,15.87,15.77,15.65,15.53,15.40,15.35,15.33,15.46,15.65,15.99,16.35,16.72,17.07,17.37,17.60,17.75,17.84,17.90,18,18.10,18.13,18.15,18.20,18.25,18.38,18.59,18.75,18.90,19,18.99,18.89,18.75,18.60,18.46,18.39,18.49,18.73,19.10,19.58,20.11,20.62,21.03,21.40,21.65,21.75,21.74,21.57,21.25,20.75,20.03,19.13,18.12,17.11,16.23,15.61,15.34,15.21,15.11,14.97,14.75,14.50,14.26,14.12,14.12,14.25,14.49,14.76,15.08,15.27,15.46,15.59,15.72,15.87,16.07,16.28,16.53,16.72,16.62,16.22,15.65,15.16,14.75,14.47,14.25,14.12,14.11,14.12,14.23,14.37,14.58,14.83,15.10,15.37,15.63,15.89,16.12,16.36,16.53,16.74,16.88,17.01,17.11,17.11,17.01,16.87,16.71,16.50,16.26,16.10,15.95,15.85,15.77,15.78,15.86,15.95,16.02,16.12,16.15,16.09,15.95,15.63,15.32,15,14.66,14.33,13.76,12.90,12.02,17,17,17,17,17,17,16,15,15,15,15,14,14,14,14,14,14,14,14.03,14.10,14.12,14.10,14.02,13.89,13.75,13.53,13.27,12.99,12.65,12.27,11.87,11.39,10.89,10.33,9.70,9,8.24,7.38,6.50,5.50,4.45,3.32,2.10,0.78,-0.49,-1.52,-2.04,-1.78,-1.02,-0.03,1.12,2.38,3.72,5,6.25,7.47,8.61,9.62,10.57,11.38,12.11,12.71,13.12,13.50,13.75,13.97,14.14,14.27,14.37,14.52,14.75,15,15,15,15,15,15,15,15,15,15.98,15.98,16,16,16,16,16,16,16.09,16.15,16.25,16.32,16.26,16.16,16.07,15.96,15.85,15.72,15.51,15.32,15.03,14.75,14.40,14.09,13.74,13.38,13.08,12.75,12.48,12.21,11.95,11.70,11.45,11.20,10.91,10.65,10.40,10.16,9.96,9.76,9.63,9.60,9.62,9.74,9.96,10.25,10.62,11.09,11.58,12.07,12.51,12.97,13.35,13.64,13.88,14.09,14.21,14.25,14.25,14.22,14.12,14,13.87,13.74,13.60,13.46,13.32,13.14,13,12.84,12.65,12.50,12.37,12.23,12.10,11.99,11.88,11.84,11.82,11.83,11.87,11.99,12.12,12.35,12.62,12.95,13.33,13.75,14.24,14.73,15.22,15.70,16.12,16.50,16.74,16.87,16.91,16.89,16.84,16.73,16.61,16.50,16.40,16.36,16.32,16.26,16.25,16.23,16.21,16.15,16.12,16.08,16.01,15.97,15.87,15.78,15.71,15.62,15.58,15.59,15.71,15.95,16.26,16.63,17.02,17.37,17.64,17.83,17.88,17.95,17.99,18.02,18.10,18.12,18.15,18.25,18.40,18.61,18.82,18.98,19.07,19.09,19,18.87,18.74,18.62,18.61,18.74,19,19.41,19.95,20.47,21,21.48,21.86,22.11,22.21,22.12,21.88,21.50,20.96,20.20,19.25,18.15,17.12,16.16,15.50,15.08,14.85,14.75,14.64,14.52,14.38,14.25,14.16,14.20,14.33,14.51,14.78,15.07,15.25,15.37,15.50,15.60,15.71,15.86,16.02,16.21,16.28,16.20,15.86,15.39,15,14.62,14.37,14.24,14.14,14.14,14.22,14.34,14.50,14.72,14.97,15.24,15.50,15.77,16.02,16.25,16.48,16.66,16.87,17.03,17.20,17.26,17.27,17.22,17.08,16.87,16.65,16.47,16.27,16.15,16.11,16.12,16.15,16.25,16.37,16.50,16.57,16.50,16.35,16,15.62,15.26,15,14.78,14.59,14.21,13.50,12,17,17,18,17,18,16,15,15,15,15,14,14,14,14,14,14,14,14,14,14,13.99,13.95,13.84,13.70,13.48,13.22,12.91,12.58,12.16,11.75,11.25,10.75,10.14,9.51,8.85,8.09,7.26,6.40,5.47,4.47,3.38,2.27,1.12,-0.11,-1.28,-2.66,-3.04,-2.02,-0.93,0.27,1.62,2.99,4.37,5.71,6.97,8.12,9.20,10.16,11.02,11.76,12.45,12.97,13.38,13.74,14,14.24,14.39,14.57,14.66,14.75,14.87,15,15,15,15,15,15,15,15,15.96,15.86,15.98,16,16,16,16,16,16.02,16.12,16.23,16.26,16.25,16.20,16.10,16,15.87,15.73,15.53,15.33,15.09,14.82,14.50,14.20,13.87,13.51,13.22,12.88,12.61,12.34,12.08,11.82,11.57,11.32,11.07,10.82,10.57,10.34,10.12,9.95,9.83,9.75,9.76,9.87,10.03,10.32,10.63,11.03,11.49,11.95,12.38,12.82,13.20,13.50,13.75,13.97,14.10,14.15,14.16,14.12,14.07,13.96,13.83,13.66,13.52,13.39,13.26,13.13,13,12.85,12.70,12.51,12.37,12.23,12.09,11.97,11.86,11.75,11.72,11.70,11.72,11.76,11.87,12.03,12.26,12.57,12.88,13.27,13.73,14.20,14.64,15.12,15.58,15.97,16.28,16.51,16.66,16.74,16.74,16.65,16.59,16.50,16.39,16.34,16.27,16.25,16.25,16.24,16.24,16.24,16.22,16.21,16.16,16.13,16.12,16.08,16,15.97,15.87,15.78,15.75,15.75,15.89,16.20,16.57,16.98,17.36,17.64,17.86,17.95,17.99,18,18.03,18.10,18.12,18.16,18.27,18.45,18.62,18.85,19.01,19.14,19.21,19.14,19.03,18.91,18.85,18.87,19,19.33,19.75,20.25,20.78,21.34,21.82,22.20,22.45,22.50,22.38,22.10,21.62,20.98,20.14,19.16,18.11,17.08,16.12,15.38,14.87,14.61,14.49,14.41,14.37,14.35,14.32,14.27,14.34,14.45,14.62,14.87,15.10,15.25,15.37,15.45,15.50,15.57,15.62,15.74,15.82,15.84,15.72,15.46,15.11,14.75,14.50,14.32,14.23,14.22,14.25,14.35,14.49,14.65,14.87,15.12,15.39,15.66,15.91,16.15,16.37,16.59,16.76,16.98,17.14,17.33,17.39,17.41,17.37,17.25,17.07,16.87,16.66,16.52,16.46,16.45,16.49,16.60,16.72,16.85,16.96,16.91,16.82,16.50,16.03,15.62,15.26,15.09,15,14.90,14.70,13.99,11.99,17,17,17,18,17,16,15,15,15,14,14,14,14,14,14,14,14,14,13.99,13.91,13.87,13.78,13.62,13.46,13.16,12.87,12.50,12.12,11.62,11.12,10.57,9.98,9.33,8.62,7.87,7.09,6.25,5.35,4.37,3.39,2.37,1.36,0.27,-0.76,-1.75,-2.50,-2.59,-1.80,-0.62,0.75,2.16,3.62,5,6.36,7.61,8.75,9.75,10.64,11.47,12.12,12.75,13.24,13.63,13.96,14.24,14.45,14.62,14.83,14.89,14.91,14.97,15,15,15,15,15,15,15,15.95,15.86,15.97,15.98,16,16,16,16,16,16.08,16.16,16.26,16.28,16.24,16.12,16,15.89,15.75,15.59,15.36,15.12,14.85,14.57,14.25,13.95,13.62,13.32,13,12.72,12.45,12.16,11.90,11.65,11.40,11.15,10.91,10.70,10.47,10.25,10.10,9.97,9.89,9.90,10,10.15,10.38,10.71,11.03,11.46,11.87,12.32,12.72,13.09,13.39,13.65,13.87,14,14.10,14.11,14.09,14,13.88,13.75,13.62,13.48,13.34,13.21,13.09,12.96,12.83,12.66,12.51,12.37,12.22,12.08,11.95,11.83,11.73,11.62,11.59,11.57,11.60,11.64,11.77,11.97,12.21,12.50,12.85,13.24,13.65,14.12,14.58,15,15.41,15.78,16.10,16.32,16.46,16.50,16.51,16.50,16.41,16.37,16.27,16.25,16.22,16.21,16.22,16.23,16.25,16.25,16.26,16.26,16.26,16.25,16.25,16.24,16.22,16.21,16.13,16.07,15.97,15.88,15.95,16.16,16.50,16.89,17.27,17.61,17.83,17.96,18,18.07,18.09,18.12,18.15,18.23,18.34,18.49,18.70,18.89,19.11,19.25,19.33,19.33,19.25,19.14,19.12,19.15,19.35,19.63,20.10,20.58,21.09,21.61,22.08,22.45,22.64,22.70,22.51,22.14,21.60,20.87,20,19.01,18,17.01,16.12,15.38,14.85,14.50,14.37,14.34,14.35,14.37,14.40,14.47,14.51,14.62,14.78,15,15.20,15.32,15.37,15.39,15.40,15.40,15.40,15.39,15.38,15.35,15.24,15.02,14.77,14.52,14.37,14.27,14.25,14.27,14.37,14.50,14.65,14.87,15.10,15.35,15.61,15.86,16.09,16.27,16.49,16.65,16.86,17.02,17.23,17.37,17.50,17.52,17.50,17.38,17.25,17.09,16.95,16.84,16.77,16.83,16.89,17.02,17.15,17.28,17.37,17.37,17.10,16.62,16.12,15.64,15.36,15.23,15.25,15.25,15.15,14.41,12.87,17,17,17,17,16,15,15,15,14,14,14,14,14,14,14,14.01,14.01,14,13.97,13.87,13.76,13.63,13.45,13.16,12.87,12.49,12.03,11.52,11,10.38,9.76,9.09,8.37,7.62,6.84,6.01,5.14,4.25,3.33,2.37,1.45,0.50,-0.39,-1.24,-1.88,-2.22,-2,-1.25,-0.13,1.25,2.75,4.23,5.64,6.98,8.20,9.27,10.25,11.09,11.84,12.47,12.98,13.45,13.78,14.12,14.37,14.62,14.84,15,15.03,15.03,15,15,15,15,15,15,15,15.96,15.85,15.97,15.98,16,16,16,16,16,16,16.08,16.15,16.25,16.25,16.13,16.01,15.90,15.77,15.62,15.40,15.16,14.89,14.62,14.34,14,13.70,13.37,13.09,12.78,12.51,12.25,12,11.76,11.51,11.27,11.03,10.82,10.60,10.37,10.22,10.10,10.01,10.02,10.12,10.25,10.48,10.75,11.08,11.45,11.85,12.25,12.62,13,13.34,13.60,13.78,13.96,14.02,14.07,14.01,13.97,13.86,13.72,13.57,13.39,13.25,13.12,12.99,12.87,12.75,12.62,12.50,12.35,12.21,12.03,11.90,11.77,11.66,11.59,11.50,11.46,11.45,11.48,11.53,11.66,11.87,12.12,12.41,12.76,13.15,13.60,14.02,14.48,14.87,15.25,15.61,15.87,16.08,16.22,16.27,16.33,16.28,16.25,16.22,16.15,16.12,16.12,16.12,16.15,16.22,16.25,16.32,16.35,16.37,16.37,16.37,16.37,16.37,16.38,16.39,16.38,16.34,16.23,16.12,16.13,16.27,16.57,16.87,17.22,17.50,17.75,17.90,18.01,18.09,18.12,18.14,18.21,18.26,18.37,18.53,18.75,18.97,19.15,19.35,19.46,19.50,19.49,19.46,19.46,19.51,19.72,20,20.41,20.87,21.36,21.84,22.25,22.61,22.77,22.77,22.57,22.12,21.49,20.71,19.84,18.89,18,17.10,16.25,15.50,14.96,14.59,14.39,14.37,14.39,14.50,14.61,14.70,14.76,14.87,15,15.15,15.33,15.37,15.38,15.37,15.33,15.25,15.14,15.03,14.96,14.86,14.75,14.62,14.50,14.37,14.26,14.27,14.34,14.40,14.53,14.71,14.87,15.10,15.32,15.53,15.77,16,16.22,16.38,16.57,16.73,16.87,17.07,17.25,17.39,17.52,17.60,17.60,17.52,17.45,17.34,17.24,17.20,17.20,17.25,17.37,17.50,17.63,17.74,17.76,17.72,17.34,16.77,16.23,15.75,15.47,15.37,15.48,15.58,15.57,14.89,12.75,17,17,17,16,16,15,15,14,14,14,14,14,14,14,14,14.20,14.09,14,13.95,13.82,13.66,13.50,13.25,12.89,12.50,12.08,11.51,10.95,10.32,9.61,8.87,8.12,7.37,6.58,5.75,4.91,4.08,3.21,2.33,1.45,0.61,-0.24,-0.93,-1.51,-1.88,-1.91,-1.51,-0.72,0.47,1.86,3.34,4.84,6.25,7.53,8.72,9.75,10.66,11.48,12.12,12.72,13.21,13.62,13.97,14.26,14.51,14.75,14.97,15.13,15.14,15.12,15.08,15,15,15,15,15.03,15.87,15.78,15.91,15.96,15.98,15.98,15.97,15.96,15.95,15.91,15.95,15.99,16,16.02,16,15.99,15.87,15.75,15.62,15.48,15.25,15,14.75,14.45,14.12,13.76,13.46,13.12,12.86,12.60,12.35,12.11,11.87,11.62,11.38,11.15,10.95,10.73,10.51,10.35,10.22,10.12,10.12,10.20,10.34,10.51,10.77,11.10,11.41,11.78,12.16,12.57,12.90,13.25,13.51,13.75,13.88,13.99,14,14,13.91,13.83,13.66,13.50,13.36,13.16,13.01,12.87,12.75,12.63,12.51,12.40,12.27,12.14,12,11.87,11.75,11.62,11.52,11.46,11.38,11.35,11.34,11.37,11.46,11.60,11.77,12.02,12.36,12.72,13.12,13.51,13.96,14.37,14.75,15.12,15.39,15.63,15.84,15.97,16.03,16.09,16.10,16.08,16.03,16,16,16.01,16.07,16.12,16.20,16.25,16.35,16.39,16.47,16.50,16.50,16.50,16.51,16.53,16.59,16.61,16.58,16.50,16.41,16.39,16.49,16.65,16.89,17.15,17.40,17.63,17.85,17.99,18.08,18.12,18.20,18.25,18.35,18.47,18.62,18.83,19.02,19.25,19.45,19.60,19.66,19.73,19.75,19.83,19.91,20.12,20.45,20.77,21.16,21.62,22.03,22.41,22.73,22.87,22.84,22.57,22.07,21.37,20.59,19.73,18.95,18.12,17.28,16.51,15.78,15.22,14.77,14.58,14.50,14.57,14.66,14.84,14.97,15.08,15.15,15.25,15.37,15.46,15.40,15.37,15.26,15.14,15,14.84,14.63,14.49,14.37,14.32,14.26,14.25,14.25,14.25,14.33,14.45,14.59,14.75,14.91,15.12,15.32,15.51,15.75,15.96,16.13,16.32,16.47,16.61,16.74,16.87,17.03,17.23,17.38,17.52,17.62,17.66,17.65,17.62,17.61,17.58,17.59,17.62,17.73,17.85,17.98,18.11,18.22,18.13,17.99,17.52,16.95,16.35,15.87,15.59,15.50,15.62,15.75,15.82,15.21,13.63,17,17,16,16,15,15,14,14,14,14,14,14,14,15,15,14.35,14.12,14.01,13.91,13.75,13.58,13.33,13,12.61,12.13,11.59,10.98,10.26,9.50,8.75,7.95,7.12,6.34,5.50,4.71,3.86,3.02,2.22,1.38,0.62,-0.15,-0.80,-1.38,-1.75,-1.87,-1.65,-1.12,-0.22,1,2.40,3.89,5.37,6.78,8.08,9.21,10.20,11.01,11.76,12.37,12.91,13.37,13.75,14.10,14.37,14.62,14.86,15,15.23,15.24,15.22,15.12,15,15.01,15.20,15.62,15.62,15.74,15.87,15.88,15.90,15.90,15.89,15.87,15.85,15.82,15.76,15.78,15.82,15.83,15.78,15.75,15.70,15.62,15.51,15.46,15.28,15.12,14.87,14.61,14.25,13.88,13.52,13.21,12.89,12.62,12.39,12.16,11.97,11.75,11.51,11.28,11.08,10.87,10.65,10.49,10.35,10.25,10.23,10.25,10.37,10.58,10.82,11.10,11.39,11.75,12.12,12.48,12.83,13.13,13.41,13.65,13.84,13.95,13.99,13.98,13.88,13.77,13.63,13.49,13.32,13.12,12.96,12.78,12.64,12.51,12.40,12.32,12.21,12.09,11.97,11.85,11.72,11.61,11.50,11.39,11.35,11.27,11.25,11.24,11.26,11.37,11.50,11.72,11.99,12.28,12.64,13.07,13.48,13.87,14.25,14.62,14.96,15.22,15.41,15.61,15.73,15.82,15.86,15.87,15.87,15.87,15.86,15.87,15.89,15.97,16.03,16.14,16.25,16.37,16.48,16.52,16.60,16.62,16.62,16.63,16.66,16.73,16.75,16.75,16.74,16.66,16.64,16.71,16.82,16.97,17.14,17.36,17.57,17.75,17.90,18.02,18.12,18.23,18.34,18.45,18.58,18.73,18.89,19.12,19.34,19.53,19.73,19.87,19.99,20.10,20.22,20.37,20.60,20.87,21.16,21.51,21.89,22.26,22.61,22.86,22.98,22.88,22.61,22.08,21.37,20.59,19.87,19.12,18.45,17.72,16.97,16.24,15.60,15.11,14.82,14.71,14.75,14.88,15.08,15.25,15.37,15.49,15.52,15.53,15.50,15.37,15.24,15.07,14.87,14.64,14.41,14.22,14.01,13.95,13.95,14,14.11,14.21,14.32,14.46,14.62,14.78,14.99,15.15,15.35,15.51,15.72,15.88,16.09,16.24,16.37,16.50,16.61,16.73,16.86,17,17.20,17.37,17.52,17.65,17.75,17.83,17.86,17.88,17.95,18,18.11,18.23,18.35,18.47,18.58,18.59,18.41,18.20,17.70,17.08,16.47,15.97,15.65,15.59,15.70,15.83,15.87,15.35,13.61,17,17,16,15,15,14,14,14,14,14,14,13,14,14,15,14.35,14.12,14.01,13.88,13.66,13.46,13.13,12.75,12.28,11.75,11.09,10.36,9.57,8.73,7.87,6.98,6.12,5.25,4.46,3.63,2.87,2.09,1.34,0.60,-0.13,-0.75,-1.28,-1.67,-1.88,-1.84,-1.48,-0.76,0.24,1.50,2.95,4.41,5.89,7.26,8.51,9.62,10.52,11.35,12.02,12.61,13.09,13.50,13.86,14.14,14.40,14.65,14.87,15.08,15.25,15.26,15.25,15.16,15.12,15.13,15.25,15.38,15.50,15.62,15.66,15.74,15.75,15.75,15.74,15.72,15.66,15.62,15.53,15.50,15.50,15.49,15.49,15.45,15.37,15.34,15.26,15.21,15.12,14.98,14.75,14.46,14.09,13.66,13.28,12.97,12.66,12.45,12.24,12.03,11.86,11.64,11.45,11.24,11,10.82,10.63,10.50,10.37,10.34,10.35,10.41,10.59,10.82,11.08,11.37,11.70,12.01,12.37,12.71,13,13.32,13.53,13.75,13.87,13.95,13.91,13.87,13.76,13.62,13.47,13.25,13.09,12.87,12.72,12.57,12.40,12.28,12.20,12.10,12,11.87,11.76,11.64,11.53,11.46,11.37,11.27,11.24,11.20,11.14,11.13,11.21,11.28,11.46,11.65,11.95,12.25,12.62,13.01,13.41,13.83,14.16,14.51,14.78,15.02,15.24,15.37,15.50,15.58,15.62,15.62,15.63,15.64,15.66,15.72,15.75,15.86,15.98,16.11,16.24,16.37,16.50,16.61,16.65,16.72,16.72,16.74,16.75,16.83,16.87,16.87,16.87,16.86,16.85,16.87,16.95,17.03,17.21,17.36,17.51,17.71,17.87,18.01,18.15,18.28,18.40,18.53,18.70,18.85,19,19.22,19.41,19.64,19.87,20.08,20.24,20.39,20.60,20.77,21.02,21.32,21.61,21.90,22.25,22.57,22.83,23.01,23.12,23.02,22.75,22.24,21.58,20.85,20.22,19.59,18.98,18.25,17.50,16.74,16,15.45,15.09,14.91,14.97,15.11,15.32,15.50,15.70,15.77,15.78,15.72,15.51,15.25,15,14.75,14.50,14.25,14.01,13.78,13.62,13.60,13.66,13.85,14.01,14.24,14.41,14.62,14.85,15.03,15.25,15.40,15.58,15.73,15.87,16.01,16.15,16.27,16.38,16.49,16.59,16.70,16.84,17,17.16,17.37,17.58,17.74,17.87,18,18.11,18.22,18.33,18.46,18.61,18.75,18.87,18.97,18.98,18.87,18.63,18.34,17.77,17.14,16.52,16.02,15.72,15.61,15.65,15.76,15.76,15.26,13.57,17,16,15,15,14,14,14,14,14,14,13,13,13,14,14,14.20,14.09,14,13.86,13.59,13.28,12.95,12.49,11.97,11.28,10.57,9.73,8.85,7.88,6.97,6,5.12,4.24,3.45,2.66,1.96,1.25,0.57,-0.11,-0.68,-1.24,-1.63,-1.89,-1.98,-1.77,-1.28,-0.50,0.62,1.91,3.38,4.89,6.37,7.72,8.89,9.98,10.85,11.60,12.24,12.75,13.21,13.61,13.89,14.21,14.45,14.70,14.87,15.09,15.25,15.25,15.25,15.23,15.22,15.20,15.24,15.32,15.38,15.49,15.52,15.58,15.58,15.53,15.50,15.46,15.37,15.32,15.25,15.20,15.13,15.12,15.12,15.09,15.07,15.02,15,14.97,14.88,14.75,14.59,14.25,13.85,13.41,13.02,12.73,12.47,12.25,12.11,11.96,11.77,11.60,11.37,11.20,10.99,10.77,10.63,10.51,10.47,10.45,10.50,10.62,10.82,11.03,11.33,11.62,11.95,12.25,12.59,12.87,13.14,13.39,13.62,13.75,13.86,13.87,13.85,13.75,13.62,13.45,13.25,13.02,12.84,12.62,12.47,12.32,12.16,12.08,11.98,11.87,11.77,11.70,11.60,11.50,11.38,11.33,11.25,11.16,11.12,11.10,11.09,11.09,11.13,11.25,11.40,11.63,11.91,12.25,12.62,13,13.39,13.76,14.12,14.40,14.64,14.87,15.01,15.15,15.25,15.34,15.37,15.38,15.40,15.46,15.49,15.53,15.62,15.75,15.87,16.01,16.20,16.35,16.50,16.61,16.70,16.74,16.75,16.77,16.83,16.87,16.89,16.91,16.95,16.91,16.95,16.97,17.02,17.13,17.27,17.45,17.59,17.75,17.89,18.09,18.25,18.39,18.52,18.66,18.83,18.98,19.13,19.35,19.57,19.78,20.01,20.25,20.48,20.71,20.95,21.20,21.47,21.75,22.03,22.34,22.62,22.87,23.10,23.25,23.34,23.25,23,22.52,21.96,21.35,20.75,20.22,19.61,18.90,18.12,17.25,16.46,15.77,15.36,15.13,15.12,15.26,15.50,15.74,15.95,16.07,16.01,15.84,15.50,15.11,14.75,14.41,14.13,13.87,13.64,13.48,13.37,13.39,13.58,13.78,14.08,14.35,14.61,14.87,15.11,15.33,15.50,15.63,15.76,15.87,16,16.11,16.22,16.32,16.37,16.48,16.57,16.66,16.83,17,17.21,17.40,17.62,17.85,18.01,18.21,18.37,18.53,18.73,18.90,19.11,19.27,19.38,19.40,19.34,19.13,18.83,18.40,17.85,17.22,16.60,16.10,15.75,15.62,15.62,15.70,15.60,15.03,13.59,16,16,15,15,14,14,13,13,13,13,13,12,13,14,14,14.03,14.03,13.99,13.76,13.47,13.12,12.71,12.21,11.59,10.86,10.01,9.09,8.11,7.08,6.03,5.02,4.12,3.25,2.50,1.75,1.12,0.50,-0.09,-0.63,-1.13,-1.55,-1.88,-2.03,-2,-1.73,-1.13,-0.24,0.95,2.33,3.82,5.34,6.76,8.09,9.25,10.25,11.09,11.77,12.37,12.87,13.25,13.62,13.91,14.22,14.41,14.65,14.85,15.02,15.23,15.21,15.23,15.23,15.24,15.16,15.16,15.22,15.26,15.34,15.37,15.37,15.37,15.34,15.26,15.20,15.10,15,14.90,14.85,14.77,14.75,14.74,14.73,14.72,14.73,14.72,14.71,14.62,14.48,14.23,13.95,13.52,13.12,12.77,12.50,12.33,12.16,12.07,11.91,11.76,11.59,11.37,11.15,10.98,10.78,10.64,10.59,10.57,10.59,10.65,10.83,11.01,11.26,11.53,11.86,12.13,12.46,12.74,13,13.25,13.46,13.62,13.74,13.76,13.75,13.71,13.59,13.40,13.24,13,12.78,12.59,12.37,12.22,12.07,11.95,11.85,11.75,11.65,11.60,11.50,11.40,11.35,11.25,11.20,11.12,11.09,11.02,11,11,11.01,11.10,11.22,11.38,11.62,11.95,12.26,12.63,13.02,13.39,13.76,14.08,14.33,14.51,14.71,14.85,14.96,15.02,15.10,15.12,15.14,15.20,15.24,15.27,15.37,15.49,15.62,15.76,15.95,16.12,16.27,16.45,16.58,16.65,16.72,16.75,16.77,16.83,16.87,16.88,16.90,16.91,16.95,16.97,17,17.11,17.25,17.39,17.59,17.75,17.88,18.03,18.23,18.37,18.51,18.64,18.78,18.95,19.11,19.26,19.49,19.71,19.96,20.21,20.46,20.71,20.97,21.24,21.52,21.87,22.20,22.50,22.75,23,23.24,23.39,23.53,23.62,23.59,23.37,22.98,22.46,21.90,21.38,20.87,20.33,19.61,18.72,17.75,16.85,16.10,15.59,15.33,15.26,15.38,15.62,15.87,16.09,16.22,16.14,15.87,15.40,14.88,14.47,14.11,13.82,13.58,13.37,13.27,13.26,13.37,13.61,13.87,14.22,14.52,14.85,15.12,15.37,15.58,15.73,15.84,15.90,16,16.10,16.15,16.24,16.28,16.37,16.46,16.53,16.66,16.85,17.03,17.26,17.51,17.76,18,18.24,18.46,18.65,18.88,19.12,19.37,19.62,19.77,19.87,19.86,19.66,19.37,18.96,18.48,17.87,17.24,16.62,16.14,15.83,15.63,15.62,15.62,15.47,14.85,12.60,16,16,15,15,14,13,13,12,12,11,12,12,12,14,14,14.03,14,13.91,13.66,13.32,12.91,12.47,11.87,11.20,10.38,9.49,8.46,7.37,6.25,5.12,4.11,3.14,2.32,1.60,0.95,0.37,-0.13,-0.62,-1.09,-1.50,-1.80,-2.03,-2.13,-2,-1.63,-0.98,0,1.25,2.65,4.16,5.66,7.11,8.37,9.50,10.48,11.25,11.90,12.47,12.90,13.28,13.62,13.90,14.14,14.38,14.62,14.76,14.96,15.12,15.12,15.14,15.15,15.20,15.12,15.10,15.11,15.12,15.15,15.16,15.16,15.14,15.10,15,14.89,14.78,14.70,14.60,14.50,14.45,14.38,14.37,14.37,14.37,14.37,14.37,14.37,14.26,14.11,13.85,13.52,13.21,12.86,12.60,12.39,12.28,12.23,12.12,12,11.83,11.62,11.37,11.16,11,10.84,10.73,10.63,10.65,10.73,10.85,11,11.24,11.49,11.75,12.02,12.33,12.60,12.85,13.09,13.27,13.46,13.59,13.63,13.65,13.62,13.51,13.37,13.21,13,12.76,12.53,12.34,12.12,11.96,11.82,11.71,11.62,11.53,11.48,11.39,11.34,11.25,11.21,11.12,11.09,11.02,11,10.97,10.96,10.96,10.98,11.07,11.20,11.37,11.63,11.97,12.33,12.70,13.08,13.41,13.75,14,14.24,14.39,14.53,14.64,14.75,14.82,14.87,14.88,14.91,14.97,15.01,15.11,15.22,15.35,15.50,15.65,15.86,16.01,16.21,16.36,16.49,16.59,16.62,16.70,16.73,16.75,16.78,16.84,16.86,16.87,16.90,16.97,17.01,17.14,17.34,17.53,17.75,17.97,18.12,18.26,18.40,18.52,18.65,18.76,18.89,19.07,19.24,19.40,19.62,19.87,20.12,20.37,20.62,20.89,21.20,21.50,21.86,22.23,22.59,22.88,23.20,23.41,23.62,23.75,23.87,23.97,23.91,23.77,23.48,23,22.50,22,21.50,20.90,20.13,19.13,18.09,17.11,16.28,15.75,15.45,15.37,15.46,15.62,15.86,16.03,16.14,16.12,15.76,15.24,14.63,14.16,13.82,13.53,13.37,13.25,13.25,13.35,13.50,13.77,14.12,14.47,14.83,15.13,15.40,15.63,15.82,15.89,15.98,16.01,16.08,16.12,16.15,16.23,16.26,16.36,16.41,16.52,16.70,16.88,17.12,17.39,17.70,17.98,18.24,18.50,18.74,18.99,19.25,19.52,19.82,20.07,20.25,20.33,20.24,19.99,19.59,19.09,18.50,17.87,17.25,16.71,16.25,15.96,15.76,15.72,15.66,15.47,14.87,12.63,16,15,15,15,14,13,12,12,12,11,12,14,14,14,14,14.14,13.98,13.84,13.51,13.12,12.71,12.20,11.57,10.82,9.96,8.96,7.85,6.70,5.50,4.27,3.22,2.24,1.39,0.75,0.20,-0.26,-0.67,-1.04,-1.41,-1.73,-1.97,-2.12,-2.13,-1.98,-1.53,-0.79,0.25,1.52,3,4.50,5.99,7.37,8.62,9.70,10.62,11.37,12,12.50,12.91,13.27,13.60,13.87,14.10,14.32,14.51,14.66,14.86,15.01,15,15.03,15.08,15.10,15,14.98,14.97,14.98,14.98,14.98,14.96,14.89,14.84,14.74,14.62,14.50,14.37,14.25,14.20,14.12,14.08,14.02,14,14,14,13.98,13.91,13.85,13.64,13.41,13.16,12.91,12.70,12.52,12.50,12.49,12.45,12.35,12.15,11.91,11.65,11.39,11.20,11,10.87,10.77,10.75,10.75,10.87,11,11.21,11.41,11.66,11.95,12.21,12.46,12.70,12.90,13.12,13.26,13.39,13.50,13.52,13.50,13.46,13.34,13.15,12.98,12.75,12.51,12.28,12.09,11.87,11.72,11.58,11.48,11.39,11.35,11.27,11.24,11.16,11.12,11.08,11.01,10.99,10.96,10.90,10.88,10.87,10.88,10.91,11.01,11.16,11.38,11.65,12,12.37,12.75,13.12,13.46,13.75,13.98,14.13,14.27,14.38,14.49,14.53,14.61,14.62,14.65,14.72,14.75,14.84,14.91,15.07,15.22,15.37,15.58,15.75,15.91,16.11,16.25,16.37,16.48,16.52,16.59,16.62,16.64,16.70,16.73,16.75,16.82,16.87,16.95,17.02,17.20,17.39,17.65,17.95,18.16,18.37,18.50,18.62,18.70,18.77,18.87,19,19.14,19.35,19.57,19.78,20.07,20.33,20.60,20.86,21.12,21.41,21.75,22.12,22.51,22.90,23.25,23.58,23.83,24,24.12,24.24,24.28,24.32,24.21,23.96,23.48,22.99,22.47,21.89,21.24,20.37,19.32,18.22,17.23,16.39,15.83,15.50,15.37,15.40,15.53,15.71,15.84,15.87,15.75,15.40,14.89,14.36,13.89,13.59,13.37,13.26,13.25,13.37,13.51,13.76,14.09,14.45,14.83,15.15,15.49,15.74,15.89,16,16.08,16.09,16.10,16.11,16.12,16.14,16.21,16.25,16.36,16.47,16.62,16.82,17.03,17.34,17.62,17.95,18.25,18.52,18.82,19.08,19.34,19.61,19.88,20.16,20.45,20.62,20.65,20.51,20.22,19.74,19.13,18.52,17.87,17.28,16.84,16.47,16.22,16.03,15.95,15.85,15.61,15.08,13.77,15,15,15,15,14,13,12,12,13,12,12,14,15,14,14,13.99,13.86,13.64,13.33,12.88,12.48,11.89,11.25,10.45,9.50,8.45,7.25,6.03,4.76,3.50,2.37,1.37,0.57,-0.02,-0.50,-0.86,-1.14,-1.41,-1.64,-1.86,-2,-2.09,-2.04,-1.87,-1.38,-0.62,0.50,1.84,3.28,4.77,6.25,7.60,8.76,9.82,10.70,11.39,12,12.48,12.88,13.23,13.51,13.75,13.99,14.21,14.38,14.53,14.73,14.87,14.87,14.90,14.90,14.95,14.87,14.83,14.78,14.76,14.75,14.75,14.72,14.63,14.53,14.45,14.32,14.16,14.03,13.96,13.87,13.82,13.75,13.72,13.66,13.63,13.61,13.57,13.49,13.37,13.22,13.02,12.87,12.75,12.72,12.73,12.77,12.85,12.78,12.62,12.36,12.02,11.72,11.40,11.22,11.02,10.90,10.86,10.85,10.88,11,11.16,11.37,11.62,11.86,12.11,12.35,12.57,12.75,12.97,13.12,13.25,13.35,13.37,13.38,13.35,13.25,13.12,12.95,12.74,12.50,12.26,12.03,11.84,11.62,11.49,11.36,11.25,11.21,11.14,11.12,11.08,11.01,11,10.97,10.91,10.88,10.87,10.85,10.83,10.83,10.85,10.87,11,11.15,11.39,11.72,12.07,12.45,12.83,13.15,13.49,13.75,13.95,14.09,14.20,14.25,14.34,14.37,14.40,14.45,14.48,14.50,14.58,14.64,14.75,14.90,15.09,15.26,15.48,15.64,15.84,16,16.13,16.25,16.35,16.40,16.47,16.50,16.52,16.58,16.62,16.65,16.74,16.82,16.89,17.02,17.23,17.47,17.75,18.08,18.36,18.57,18.71,18.76,18.83,18.87,18.97,19.09,19.25,19.47,19.72,19.99,20.25,20.57,20.85,21.12,21.37,21.70,22,22.37,22.77,23.20,23.58,23.88,24.14,24.35,24.48,24.57,24.62,24.63,24.57,24.26,23.83,23.26,22.66,21.99,21.21,20.25,19.20,18.13,17.20,16.37,15.83,15.49,15.35,15.33,15.37,15.45,15.47,15.40,15.25,14.89,14.47,14,13.64,13.39,13.27,13.27,13.37,13.57,13.83,14.12,14.50,14.87,15.25,15.60,15.87,16.07,16.15,16.22,16.21,16.15,16.12,16.12,16.12,16.13,16.21,16.26,16.37,16.52,16.73,16.98,17.25,17.58,17.89,18.25,18.58,18.87,19.13,19.39,19.64,19.90,20.21,20.47,20.72,20.87,20.87,20.70,20.32,19.76,19.14,18.50,17.89,17.39,17.03,16.82,16.63,16.50,16.36,16.15,15.83,15.27,13.72,15,15,15,15,14,13,12,13,14,14,13,12,14,14,14,13.83,13.62,13.37,13.02,12.62,12.16,11.61,10.89,10.08,9.10,7.98,6.74,5.47,4.12,2.85,1.62,0.61,-0.17,-0.68,-1.09,-1.30,-1.52,-1.67,-1.77,-1.86,-1.88,-1.88,-1.84,-1.62,-1.13,-0.30,0.82,2.13,3.60,5.02,6.45,7.73,8.86,9.85,10.71,11.37,11.95,12.37,12.77,13.11,13.38,13.62,13.84,14.02,14.25,14.37,14.58,14.72,14.71,14.74,14.74,14.75,14.66,14.62,14.60,14.57,14.52,14.50,14.45,14.37,14.25,14.12,14,13.86,13.74,13.62,13.58,13.50,13.46,13.39,13.36,13.27,13.23,13.12,13.02,12.90,12.82,12.70,12.62,12.66,12.82,12.98,13.20,13.26,13.14,12.87,12.50,12.10,11.74,11.41,11.23,11.07,10.97,10.90,10.91,11,11.13,11.34,11.53,11.77,12,12.25,12.47,12.64,12.83,12.98,13.11,13.20,13.25,13.25,13.24,13.14,13.02,12.87,12.70,12.49,12.25,12.01,11.82,11.61,11.40,11.26,11.15,11.09,11.01,10.99,10.95,10.90,10.88,10.87,10.86,10.84,10.82,10.77,10.75,10.75,10.75,10.76,10.84,10.97,11.15,11.41,11.76,12.13,12.51,12.89,13.25,13.50,13.75,13.90,14.01,14.11,14.14,14.21,14.24,14.25,14.26,14.28,14.35,14.39,14.50,14.62,14.77,14.98,15.15,15.37,15.57,15.75,15.89,16.02,16.14,16.24,16.28,16.36,16.37,16.41,16.48,16.51,16.60,16.65,16.75,16.87,17.03,17.25,17.50,17.83,18.14,18.46,18.66,18.83,18.88,18.90,18.97,19.03,19.15,19.36,19.60,19.87,20.20,20.50,20.85,21.12,21.40,21.66,21.97,22.25,22.62,23,23.39,23.78,24.13,24.40,24.62,24.75,24.83,24.88,24.90,24.84,24.48,23.98,23.35,22.60,21.75,20.86,19.88,18.89,17.91,17.02,16.28,15.75,15.39,15.24,15.15,15.12,15.11,15,14.87,14.64,14.36,14,13.71,13.46,13.33,13.28,13.37,13.59,13.87,14.21,14.58,14.96,15.35,15.72,16.01,16.25,16.38,16.41,16.38,16.33,16.25,16.16,16.12,16.12,16.14,16.23,16.34,16.47,16.63,16.87,17.15,17.50,17.85,18.21,18.57,18.88,19.22,19.49,19.74,19.97,20.21,20.41,20.64,20.87,20.98,20.91,20.71,20.26,19.71,19.10,18.48,17.96,17.61,17.41,17.37,17.34,17.23,17,16.64,16.12,15.27,13.65,15,15,15,15,14,13,13,14,15,15,14,13,12,14,14,13.49,13.25,13.02,12.70,12.27,11.87,11.32,10.60,9.73,8.74,7.53,6.27,4.97,3.62,2.28,1.07,0.01,-0.73,-1.16,-1.49,-1.64,-1.75,-1.76,-1.75,-1.64,-1.55,-1.50,-1.38,-1.14,-0.65,0.13,1.24,2.50,3.87,5.25,6.58,7.77,8.87,9.77,10.62,11.25,11.78,12.25,12.62,12.91,13.22,13.45,13.64,13.86,14.03,14.22,14.37,14.50,14.50,14.50,14.50,14.50,14.45,14.37,14.36,14.33,14.26,14.24,14.15,14.08,13.96,13.82,13.64,13.51,13.40,13.34,13.25,13.22,13.14,13.11,13.01,12.96,12.86,12.74,12.62,12.50,12.46,12.40,12.50,12.66,12.89,13.20,13.45,13.62,13.37,12.99,12.50,12.10,11.73,11.41,11.23,11.09,10.99,10.97,11,11.11,11.25,11.48,11.72,11.97,12.16,12.37,12.58,12.74,12.87,12.99,13.08,13.12,13.13,13.12,13.07,12.97,12.82,12.62,12.45,12.23,12,11.76,11.58,11.37,11.23,11.10,11,10.89,10.86,10.82,10.77,10.75,10.75,10.75,10.74,10.73,10.72,10.70,10.66,10.65,10.66,10.73,10.77,10.96,11.16,11.50,11.87,12.25,12.62,13,13.33,13.58,13.76,13.88,13.99,14.02,14.08,14.10,14.11,14.12,14.12,14.14,14.20,14.25,14.37,14.50,14.65,14.87,15.08,15.26,15.48,15.64,15.83,15.96,16.07,16.12,16.22,16.25,16.32,16.36,16.39,16.48,16.53,16.63,16.75,16.88,17.08,17.28,17.59,17.88,18.24,18.52,18.75,18.89,18.99,19,19.07,19.13,19.27,19.50,19.76,20.12,20.47,20.83,21.15,21.49,21.75,22,22.25,22.51,22.84,23.20,23.57,23.96,24.27,24.58,24.76,24.89,25,25.07,25.08,24.98,24.50,23.95,23.15,22.25,21.32,20.37,19.45,18.51,17.64,16.87,16.20,15.65,15.32,15.10,14.96,14.86,14.73,14.57,14.37,14.12,13.87,13.62,13.38,13.33,13.28,13.37,13.60,13.87,14.24,14.62,15.02,15.45,15.85,16.20,16.48,16.64,16.74,16.71,16.60,16.46,16.33,16.23,16.15,16.14,16.21,16.27,16.39,16.59,16.78,17.08,17.37,17.75,18.12,18.50,18.87,19.23,19.51,19.77,20.01,20.23,20.40,20.61,20.75,20.87,20.91,20.82,20.51,20.09,19.51,18.96,18.40,18.07,17.91,18,18.15,18.27,18.22,17.88,17.37,16.52,15.34,12.63,15,15,14,14,14,13,13,15,16,15,14,13,11,13,13,12.66,12.87,12.46,12.22,11.88,11.53,11.01,10.28,9.45,8.38,7.21,5.89,4.57,3.16,1.87,0.65,-0.34,-1.02,-1.43,-1.63,-1.76,-1.75,-1.63,-1.42,-1.22,-1.02,-0.88,-0.75,-0.48,0,0.75,1.75,2.91,4.20,5.45,6.64,7.76,8.77,9.66,10.46,11.09,11.59,12.01,12.37,12.65,12.97,13.20,13.41,13.62,13.83,14,14.13,14.25,14.26,14.25,14.28,14.23,14.14,14.12,14.08,14.02,14,13.96,13.87,13.75,13.62,13.48,13.33,13.20,13.10,13,12.97,12.90,12.87,12.82,12.73,12.62,12.51,12.38,12.25,12.16,12.20,12.26,12.41,12.70,13,13.32,13.50,13.60,13.36,12.90,12.46,12.03,11.71,11.39,11.23,11.10,11,11,11.08,11.20,11.37,11.61,11.87,12.12,12.35,12.50,12.65,12.78,12.89,12.99,13.01,13.03,13.02,12.99,12.87,12.75,12.59,12.38,12.16,11.97,11.75,11.53,11.36,11.20,11.02,10.90,10.83,10.75,10.66,10.62,10.61,10.60,10.61,10.61,10.62,10.62,10.61,10.60,10.59,10.59,10.61,10.65,10.75,10.96,11.23,11.60,11.99,12.37,12.76,13.12,13.39,13.63,13.78,13.87,13.96,13.98,14,14,14,14,14,14.01,14.08,14.12,14.25,14.37,14.53,14.75,14.98,15.21,15.38,15.60,15.75,15.87,15.99,16.08,16.13,16.21,16.25,16.34,16.38,16.48,16.57,16.64,16.76,16.91,17.12,17.37,17.65,18,18.35,18.62,18.87,19,19.09,19.11,19.16,19.27,19.47,19.73,20.03,20.40,20.78,21.15,21.51,21.85,22.12,22.35,22.52,22.75,23.01,23.34,23.65,24.01,24.36,24.62,24.83,24.96,25.01,25.08,25.07,24.90,24.36,23.66,22.76,21.75,20.75,19.83,18.96,18.13,17.39,16.74,16.12,15.62,15.21,14.90,14.72,14.51,14.35,14.12,13.90,13.71,13.50,13.35,13.25,13.26,13.37,13.57,13.87,14.22,14.62,15.03,15.50,15.90,16.33,16.64,16.89,17.03,17.07,16.97,16.76,16.59,16.39,16.27,16.23,16.22,16.25,16.37,16.51,16.74,16.99,17.26,17.62,18,18.38,18.78,19.16,19.51,19.83,20.09,20.27,20.47,20.62,20.74,20.83,20.85,20.76,20.60,20.25,19.77,19.26,18.75,18.38,18.25,18.39,18.75,19.21,19.49,19.46,19.02,18.26,17.14,15.50,12.62,15,15,14,14,14,14,14,16,16,15,14,14,12,11,11,11.64,11.62,11.65,11.62,11.52,11.25,10.77,10.11,9.21,8.12,6.89,5.59,4.23,2.86,1.58,0.37,-0.51,-1.16,-1.52,-1.66,-1.66,-1.49,-1.16,-0.84,-0.51,-0.26,-0.11,0.11,0.37,0.83,1.48,2.35,3.37,4.46,5.59,6.65,7.71,8.63,9.50,10.21,10.78,11.28,11.74,12.08,12.36,12.63,12.87,13.12,13.34,13.53,13.73,13.95,13.99,14,14,14,13.90,13.85,13.77,13.75,13.73,13.70,13.63,13.57,13.45,13.27,13.12,12.97,12.84,12.75,12.71,12.65,12.63,12.61,12.52,12.46,12.36,12.25,12.12,12,11.91,12,12.20,12.41,12.72,13,13.26,13.40,13.35,13.12,12.74,12.36,12,11.65,11.37,11.23,11.11,11.02,11.03,11.12,11.25,11.48,11.74,12,12.25,12.50,12.65,12.78,12.87,12.95,12.99,13,12.99,12.91,12.84,12.72,12.53,12.36,12.13,11.91,11.72,11.50,11.33,11.13,11,10.87,10.75,10.63,10.58,10.50,10.45,10.40,10.41,10.45,10.47,10.48,10.49,10.49,10.48,10.48,10.49,10.52,10.62,10.74,10.99,11.33,11.72,12.12,12.53,12.95,13.25,13.50,13.71,13.82,13.87,13.89,13.90,13.90,13.89,13.89,13.88,13.88,13.89,13.96,14,14.12,14.25,14.46,14.64,14.87,15.12,15.34,15.51,15.70,15.83,15.91,16,16.11,16.16,16.25,16.35,16.41,16.50,16.62,16.72,16.84,16.99,17.20,17.47,17.76,18.12,18.49,18.76,19,19.12,19.21,19.24,19.34,19.49,19.73,20.02,20.39,20.82,21.20,21.57,21.88,22.21,22.47,22.64,22.82,22.99,23.20,23.46,23.74,24.03,24.36,24.60,24.76,24.87,24.89,24.88,24.83,24.61,23.89,23.12,22.15,21.12,20.13,19.25,18.49,17.83,17.24,16.66,16.12,15.61,15.12,14.74,14.45,14.21,13.99,13.75,13.58,13.38,13.25,13.20,13.15,13.26,13.49,13.75,14.12,14.52,14.99,15.46,15.89,16.36,16.75,17.10,17.34,17.41,17.37,17.22,16.98,16.72,16.50,16.36,16.27,16.27,16.37,16.50,16.66,16.89,17.20,17.50,17.87,18.25,18.66,19.09,19.47,19.78,20.11,20.35,20.52,20.70,20.78,20.86,20.87,20.78,20.62,20.35,19.97,19.50,19,18.61,18.45,18.57,19,19.63,20.35,20.86,20.87,20.28,19.36,18,16.12,12.62,15,15,15,15,15,15,15,15,15,15,15,14,13,12,11,10.34,10.58,10.78,11.01,11.11,11,10.60,9.95,9,7.90,6.65,5.36,3.97,2.60,1.33,0.22,-0.65,-1.25,-1.54,-1.61,-1.40,-1.03,-0.52,-0.04,0.35,0.60,0.77,0.99,1.25,1.62,2.16,2.89,3.75,4.70,5.64,6.62,7.53,8.45,9.21,9.87,10.45,10.91,11.35,11.70,12,12.25,12.50,12.75,12.99,13.23,13.50,13.62,13.64,13.71,13.71,13.65,13.57,13.48,13.40,13.37,13.36,13.34,13.27,13.22,13.09,12.90,12.75,12.59,12.48,12.39,12.37,12.38,12.38,12.37,12.32,12.24,12.13,12.03,11.96,11.87,11.87,11.96,12.16,12.47,12.74,13,13.16,13.23,13.11,12.87,12.59,12.25,11.91,11.62,11.37,11.23,11.12,11.08,11.10,11.20,11.36,11.59,11.87,12.13,12.39,12.62,12.78,12.89,12.98,13,13,12.98,12.90,12.83,12.70,12.51,12.35,12.12,11.89,11.70,11.49,11.27,11.11,10.96,10.82,10.70,10.59,10.48,10.37,10.32,10.25,10.25,10.25,10.27,10.33,10.35,10.36,10.36,10.36,10.37,10.38,10.47,10.60,10.75,11.02,11.45,11.87,12.32,12.75,13.11,13.37,13.61,13.75,13.83,13.87,13.87,13.87,13.85,13.83,13.78,13.77,13.77,13.77,13.84,13.88,14,14.14,14.35,14.58,14.82,15.03,15.25,15.48,15.62,15.76,15.88,15.99,16.09,16.15,16.25,16.37,16.49,16.59,16.66,16.76,16.88,17.07,17.26,17.58,17.90,18.27,18.63,18.96,19.14,19.27,19.35,19.38,19.50,19.74,20.02,20.40,20.84,21.25,21.62,21.96,22.25,22.52,22.75,22.95,23.02,23.15,23.34,23.52,23.76,24.03,24.28,24.50,24.62,24.65,24.62,24.50,24.27,23.91,23.13,22.33,21.34,20.37,19.50,18.73,18.10,17.59,17.12,16.70,16.15,15.61,15.02,14.52,14.14,13.87,13.64,13.48,13.32,13.21,13.12,13.11,13.14,13.33,13.61,13.97,14.37,14.84,15.28,15.76,16.25,16.72,17.12,17.48,17.72,17.78,17.66,17.45,17.12,16.84,16.59,16.40,16.36,16.37,16.48,16.62,16.86,17.12,17.40,17.75,18.12,18.52,18.95,19.36,19.73,20.08,20.37,20.62,20.78,20.91,21,21,20.95,20.76,20.50,20.14,19.73,19.25,18.75,18.50,18.57,18.91,19.62,20.51,21.46,22.16,22.25,21.59,20.50,19.10,17.15,13.65,15,15,16,15,15,16,16,16,15,15,15,14,14,12,10,9.14,9.65,9.99,10.34,10.62,10.72,10.51,9.82,8.87,7.75,6.52,5.16,3.77,2.45,1.13,0.03,-0.80,-1.37,-1.61,-1.50,-1.14,-0.59,0.11,0.73,1.16,1.47,1.62,1.82,2.03,2.37,2.82,3.37,4.08,4.86,5.66,6.51,7.37,8.12,8.87,9.48,10.01,10.50,10.87,11.22,11.51,11.78,12.09,12.33,12.60,12.86,13.11,13.25,13.32,13.37,13.40,13.26,13.13,13.02,12.98,12.95,12.90,12.89,12.87,12.78,12.66,12.50,12.35,12.21,12.12,12.10,12.12,12.16,12.22,12.22,12.15,12.10,12,11.95,11.87,11.87,11.87,12.02,12.25,12.51,12.76,12.99,13.08,13.03,12.90,12.72,12.45,12.14,11.87,11.62,11.37,11.24,11.12,11.11,11.12,11.25,11.46,11.71,12,12.26,12.53,12.75,12.90,13,13.07,13.07,13.01,12.96,12.86,12.73,12.57,12.37,12.13,11.89,11.66,11.46,11.25,11.08,10.89,10.75,10.62,10.50,10.38,10.28,10.23,10.15,10.12,10.12,10.12,10.14,10.20,10.22,10.23,10.23,10.24,10.25,10.32,10.39,10.58,10.76,11.12,11.57,12.01,12.50,12.91,13.25,13.50,13.71,13.77,13.83,13.83,13.82,13.77,13.75,13.73,13.70,13.65,13.65,13.65,13.71,13.75,13.87,14.02,14.25,14.48,14.73,14.99,15.22,15.40,15.60,15.75,15.87,15.97,16.07,16.15,16.27,16.39,16.51,16.62,16.74,16.85,16.97,17.12,17.37,17.66,18.03,18.45,18.78,19.11,19.32,19.40,19.49,19.57,19.74,20,20.37,20.82,21.25,21.65,22,22.32,22.58,22.82,23,23.13,23.21,23.28,23.41,23.60,23.78,24,24.23,24.37,24.41,24.36,24.16,23.87,23.48,22.95,22.12,21.27,20.40,19.61,18.87,18.25,17.78,17.45,17.11,16.72,16.21,15.58,14.89,14.34,13.88,13.61,13.38,13.25,13.13,13.08,13.02,13.07,13.14,13.37,13.71,14.11,14.57,15.02,15.51,16,16.50,16.99,17.40,17.77,18.01,18.09,17.91,17.61,17.25,16.89,16.62,16.49,16.41,16.48,16.61,16.77,17.02,17.33,17.63,18,18.37,18.78,19.21,19.61,19.99,20.34,20.62,20.87,21.08,21.20,21.24,21.20,21.07,20.83,20.49,20.07,19.58,19.03,18.65,18.52,18.75,19.32,20.21,21.27,22.37,23.14,23.24,22.62,21.59,20.33,18.59,15.70,16,16,16,16,15,16,16,16,16,15,14,13,12,11,10,9,9.50,9.02,9.77,10.12,10.37,10.26,9.75,8.78,7.64,6.39,5.07,3.65,2.32,1,-0.11,-0.97,-1.50,-1.72,-1.54,-1.03,-0.27,0.53,1.32,1.84,2.12,2.35,2.50,2.72,2.97,3.32,3.75,4.28,4.91,5.62,6.37,7.09,7.77,8.41,9,9.51,9.98,10.36,10.71,11,11.25,11.53,11.82,12.11,12.37,12.70,12.84,12.91,13,12.98,12.78,12.63,12.50,12.41,12.38,12.38,12.39,12.37,12.34,12.22,12.08,11.91,11.84,11.82,11.87,11.97,12.09,12.14,12.16,12.13,12.09,12,11.96,11.90,11.96,12,12.16,12.38,12.62,12.84,12.97,13,12.96,12.82,12.61,12.36,12.10,11.85,11.61,11.37,11.25,11.15,11.13,11.22,11.37,11.58,11.85,12.12,12.39,12.64,12.87,13.01,13.12,13.14,13.12,13.01,12.88,12.75,12.58,12.37,12.13,11.90,11.66,11.46,11.25,11.07,10.88,10.74,10.59,10.45,10.33,10.24,10.14,10.11,10.08,10.03,10.02,10.03,10.08,10.09,10.10,10.11,10.11,10.12,10.13,10.23,10.36,10.57,10.83,11.24,11.71,12.21,12.70,13.10,13.38,13.62,13.75,13.78,13.78,13.76,13.74,13.70,13.63,13.61,13.58,13.53,13.52,13.52,13.58,13.63,13.75,13.91,14.12,14.37,14.63,14.90,15.13,15.37,15.53,15.72,15.84,15.95,16.03,16.14,16.26,16.39,16.51,16.63,16.75,16.87,17,17.16,17.41,17.75,18.12,18.52,18.89,19.21,19.38,19.50,19.59,19.70,19.90,20.25,20.66,21.15,21.62,22.02,22.36,22.61,22.83,23,23.15,23.26,23.28,23.37,23.49,23.62,23.78,23.98,24.12,24.20,24.13,23.91,23.58,23.08,22.46,21.74,20.98,20.23,19.50,18.85,18.32,17.87,17.60,17.36,17.09,16.70,16.12,15.41,14.73,14.12,13.65,13.37,13.22,13.11,13.01,12.99,12.97,13,13.12,13.37,13.75,14.20,14.66,15.20,15.70,16.15,16.64,17.12,17.59,17.97,18.21,18.25,18.02,17.65,17.26,16.91,16.65,16.51,16.50,16.58,16.74,16.96,17.23,17.51,17.87,18.25,18.62,19.02,19.46,19.86,20.24,20.60,20.89,21.15,21.36,21.48,21.50,21.39,21.23,20.89,20.50,20.01,19.50,19,18.66,18.63,18.98,19.65,20.70,21.85,22.97,23.73,23.84,23.36,22.52,21.50,20,17.75,15,16,16,16,15,16,16,16,15,14,13,12,12,11,11,11,10.28,9.76,9.33,9.73,9.89,9.88,9.57,8.63,7.58,6.36,5.01,3.64,2.25,0.99,-0.16,-1.05,-1.65,-1.88,-1.73,-1.12,-0.22,0.75,1.59,2.16,2.58,2.84,3.02,3.22,3.41,3.70,4.02,4.48,4.99,5.52,6.12,6.76,7.37,7.96,8.50,8.97,9.37,9.75,10.10,10.37,10.70,10.97,11.25,11.53,11.87,12.13,12.32,12.46,12.60,12.39,12.22,12.01,11.87,11.77,11.75,11.76,11.82,11.83,11.77,11.72,11.61,11.51,11.50,11.59,11.74,11.95,12.12,12.25,12.32,12.27,12.23,12.13,12.10,12.08,12.11,12.20,12.34,12.51,12.75,12.87,12.97,12.98,12.89,12.75,12.53,12.32,12.07,11.84,11.60,11.37,11.25,11.21,11.23,11.33,11.50,11.73,12,12.25,12.51,12.75,12.97,13.12,13.21,13.22,13.12,12.99,12.82,12.61,12.38,12.14,11.90,11.66,11.45,11.24,11.03,10.87,10.73,10.57,10.40,10.27,10.16,10.12,10.07,10.01,10,10,10,10,10,10,10,10,10,10,10.03,10.13,10.32,10.57,10.87,11.34,11.84,12.36,12.84,13.23,13.50,13.72,13.77,13.77,13.75,13.71,13.63,13.59,13.51,13.49,13.45,13.39,13.38,13.38,13.41,13.50,13.62,13.82,14.02,14.27,14.58,14.85,15.10,15.32,15.50,15.66,15.82,15.89,16,16.12,16.24,16.37,16.50,16.62,16.73,16.85,17,17.16,17.45,17.76,18.14,18.53,18.90,19.22,19.39,19.51,19.62,19.76,20.03,20.41,20.89,21.41,21.89,22.28,22.60,22.78,22.97,23.12,23.23,23.28,23.33,23.37,23.50,23.62,23.76,23.90,24,23.99,23.78,23.40,22.87,22.14,21.37,20.57,19.84,19.15,18.61,18.13,17.77,17.53,17.37,17.23,16.98,16.52,15.90,15.20,14.47,13.87,13.48,13.23,13.09,13,12.95,12.88,12.87,12.90,13.07,13.33,13.73,14.23,14.75,15.26,15.76,16.25,16.72,17.14,17.61,17.96,18.16,18.20,17.99,17.60,17.22,16.87,16.64,16.53,16.58,16.66,16.87,17.12,17.39,17.73,18.09,18.46,18.85,19.25,19.65,20.08,20.48,20.85,21.16,21.46,21.64,21.75,21.76,21.65,21.40,21.03,20.58,20.07,19.50,19.03,18.78,18.84,19.25,20,21.09,22.24,23.25,23.99,24.15,23.87,23.33,22.49,21.08,18.83,14,15,16,16,15,15,16,16,15,14,13,13,12,12,12,13,11.91,10.25,9.53,9.36,9.59,9.58,9.23,8.50,7.50,6.36,5.07,3.70,2.28,0.98,-0.23,-1.13,-1.84,-2.15,-2.01,-1.28,-0.34,0.73,1.62,2.25,2.75,3.07,3.28,3.50,3.70,3.90,4.20,4.51,4.90,5.38,5.87,6.39,6.95,7.46,7.91,8.37,8.75,9.12,9.41,9.72,10,10.32,10.61,10.89,11.25,11.50,11.70,12,11.88,11.72,11.50,11.27,11.12,11.03,11.02,11.09,11.13,11.21,11.22,11.20,11.14,11.15,11.25,11.47,11.75,12.07,12.34,12.50,12.59,12.58,12.50,12.39,12.34,12.28,12.28,12.36,12.47,12.62,12.82,12.89,12.95,12.96,12.88,12.75,12.53,12.32,12.08,11.83,11.61,11.38,11.27,11.25,11.34,11.47,11.64,11.89,12.14,12.39,12.62,12.85,13,13.12,13.21,13.20,13.08,12.87,12.64,12.40,12.16,11.90,11.65,11.41,11.21,11,10.85,10.70,10.53,10.38,10.25,10.15,10.10,10.02,10,10,9.99,9.98,9.98,9.97,9.96,9.95,9.90,9.88,9.87,9.88,9.96,10.08,10.25,10.53,10.91,11.41,11.96,12.50,12.96,13.32,13.61,13.73,13.75,13.75,13.70,13.62,13.52,13.47,13.38,13.35,13.28,13.25,13.25,13.25,13.27,13.37,13.50,13.71,13.91,14.21,14.49,14.75,15,15.25,15.47,15.62,15.76,15.87,15.99,16.08,16.16,16.27,16.39,16.51,16.64,16.77,16.96,17.13,17.39,17.73,18.10,18.47,18.83,19.12,19.33,19.47,19.61,19.78,20.12,20.52,21.03,21.59,22.08,22.45,22.71,22.87,23,23.10,23.15,23.23,23.25,23.37,23.49,23.62,23.75,23.86,23.87,23.75,23.40,22.86,22.11,21.25,20.35,19.48,18.84,18.25,17.84,17.51,17.28,17.15,17.10,17,16.74,16.22,15.57,14.85,14.15,13.63,13.32,13.12,13,12.90,12.86,12.78,12.75,12.78,12.91,13.22,13.63,14.21,14.77,15.33,15.83,16.25,16.66,17.09,17.47,17.76,17.96,17.96,17.74,17.39,17.08,16.77,16.62,16.58,16.62,16.77,17,17.26,17.59,17.89,18.25,18.62,19.01,19.41,19.86,20.25,20.66,21.09,21.41,21.73,21.96,22.07,22.07,21.88,21.60,21.15,20.63,20.12,19.59,19.20,19,19.12,19.61,20.39,21.46,22.52,23.49,24.12,24.37,24.25,23.87,23.20,21.83,18.90,14,14,15,16,15,15,15,15,14,14,14,14,14,14,13,13,12,10.64,9.62,9.28,9.32,9.41,9.14,8.50,7.60,6.48,5.20,3.82,2.39,1.03,-0.14,-1.15,-1.89,-2.38,-2.23,-1.49,-0.52,0.50,1.39,2.12,2.64,3.08,3.37,3.62,3.83,4,4.25,4.50,4.84,5.20,5.61,6.02,6.50,6.90,7.35,7.73,8.10,8.41,8.73,9.02,9.33,9.62,9.90,10.25,10.50,10.75,11.10,11.14,11.07,10.88,10.71,10.50,10.37,10.32,10.34,10.40,10.50,10.62,10.65,10.71,10.75,10.87,11.12,11.46,11.87,12.27,12.62,12.87,12.97,12.96,12.87,12.75,12.62,12.53,12.50,12.49,12.53,12.64,12.77,12.84,12.87,12.90,12.88,12.76,12.59,12.34,12.10,11.85,11.62,11.41,11.33,11.36,11.48,11.62,11.87,12.11,12.34,12.53,12.73,12.87,13,13.09,13.12,13.08,12.91,12.72,12.47,12.21,11.91,11.65,11.39,11.15,10.96,10.76,10.62,10.50,10.37,10.25,10.13,10.08,10.01,10,9.98,9.98,9.97,9.96,9.95,9.91,9.89,9.87,9.85,9.78,9.76,9.76,9.85,10,10.22,10.51,11,11.52,12.10,12.61,13.02,13.38,13.61,13.70,13.71,13.64,13.59,13.50,13.40,13.34,13.25,13.21,13.14,13.12,13.10,13.11,13.13,13.24,13.37,13.60,13.84,14.12,14.39,14.70,14.96,15.20,15.39,15.61,15.75,15.86,15.95,16.01,16.11,16.20,16.28,16.40,16.53,16.71,16.87,17.09,17.34,17.62,17.96,18.28,18.62,18.91,19.14,19.35,19.51,19.76,20.12,20.58,21.09,21.62,22.10,22.46,22.70,22.84,22.90,22.99,23.02,23.10,23.20,23.33,23.47,23.61,23.73,23.77,23.73,23.49,23,22.25,21.34,20.37,19.39,18.58,18,17.50,17.16,16.91,16.76,16.70,16.62,16.52,16.24,15.73,15.10,14.45,13.87,13.46,13.16,13,12.90,12.85,12.75,12.70,12.62,12.63,12.76,13.08,13.53,14.13,14.78,15.36,15.82,16.22,16.58,16.90,17.24,17.49,17.62,17.59,17.38,17.13,16.87,16.65,16.58,16.60,16.73,16.91,17.16,17.47,17.75,18.10,18.41,18.77,19.16,19.59,20,20.45,20.87,21.27,21.65,21.99,22.22,22.33,22.25,22.07,21.72,21.24,20.72,20.15,19.72,19.41,19.37,19.60,20.12,20.90,21.87,22.87,23.71,24.26,24.53,24.51,24.26,23.65,22.26,20,14,14,14,15,14,14,14,14,14,14,14,14,14,14,13,12,11,10.07,9.52,9.63,9.61,9.52,9.32,8.71,7.83,6.72,5.40,4.01,2.57,1.20,-0.10,-1.13,-1.90,-2.35,-2.35,-1.63,-0.77,0.14,1.02,1.82,2.40,2.89,3.26,3.53,3.76,4,4.21,4.41,4.71,5,5.35,5.70,6.03,6.38,6.75,7.10,7.40,7.72,8.01,8.33,8.62,8.88,9.22,9.50,9.75,9.97,10.15,10.24,10.20,10.08,9.90,9.76,9.71,9.71,9.76,9.88,10.01,10.14,10.25,10.35,10.48,10.71,11.03,11.50,12.02,12.53,12.98,13.25,13.37,13.36,13.25,13.11,12.91,12.76,12.63,12.58,12.53,12.58,12.62,12.71,12.77,12.87,12.87,12.82,12.62,12.37,12.12,11.87,11.63,11.48,11.38,11.49,11.62,11.84,12.07,12.26,12.48,12.62,12.75,12.87,12.95,12.98,12.96,12.87,12.70,12.48,12.22,11.95,11.65,11.38,11.13,10.89,10.71,10.52,10.39,10.27,10.21,10.12,10.03,10,9.99,9.98,9.97,9.96,9.91,9.89,9.87,9.86,9.84,9.77,9.74,9.70,9.64,9.64,9.75,9.88,10.20,10.53,11.11,11.65,12.23,12.72,13.12,13.40,13.58,13.62,13.61,13.53,13.47,13.37,13.27,13.22,13.12,13.08,13,12.98,12.96,12.96,13,13.12,13.25,13.49,13.75,14.01,14.33,14.62,14.87,15.12,15.37,15.57,15.72,15.83,15.89,15.98,16.01,16.10,16.20,16.32,16.46,16.62,16.84,17.02,17.25,17.50,17.77,18.10,18.39,18.71,18.97,19.20,19.40,19.73,20.10,20.52,21.03,21.53,22,22.36,22.59,22.73,22.78,22.85,22.88,22.99,23.12,23.27,23.47,23.60,23.70,23.66,23.51,23.14,22.50,21.62,20.59,19.52,18.60,17.83,17.33,16.88,16.59,16.35,16.20,16.10,16,15.86,15.57,15.12,14.59,14.02,13.60,13.26,13.08,12.95,12.85,12.75,12.64,12.58,12.50,12.50,12.62,12.96,13.46,14.09,14.75,15.36,15.76,16.12,16.45,16.73,16.99,17.15,17.25,17.22,17.08,16.87,16.65,16.53,16.52,16.63,16.84,17.09,17.37,17.64,17.97,18.26,18.60,18.95,19.32,19.72,20.12,20.60,21.03,21.49,21.87,22.23,22.45,22.50,22.40,22.15,21.75,21.26,20.75,20.25,19.89,19.75,19.86,20.20,20.75,21.53,22.40,23.25,23.97,24.47,24.72,24.75,24.52,23.97,22.62,20.02,13,13,14,14,14,14,14,14,14,14,14,14,14,14,13,12,11,10,10.24,10.50,10.36,10.08,9.66,9.12,8.25,7.12,5.75,4.27,2.78,1.34,0,-1.10,-1.87,-2.25,-2.17,-1.76,-1.09,-0.26,0.58,1.32,1.98,2.52,3,3.36,3.62,3.87,4.12,4.35,4.58,4.82,5.08,5.35,5.62,5.90,6.20,6.46,6.72,7,7.28,7.58,7.87,8.20,8.49,8.76,9,9.15,9.36,9.45,9.45,9.38,9.34,9.26,9.27,9.37,9.50,9.64,9.82,9.95,10.03,10.15,10.35,10.62,11.03,11.60,12.20,12.75,13.24,13.52,13.66,13.66,13.58,13.37,13.14,12.91,12.73,12.57,12.47,12.41,12.46,12.52,12.64,12.78,12.87,12.85,12.64,12.39,12.14,11.88,11.66,11.51,11.50,11.61,11.77,12,12.22,12.39,12.58,12.66,12.75,12.82,12.84,12.82,12.74,12.61,12.40,12.20,11.91,11.65,11.38,11.12,10.87,10.64,10.48,10.32,10.20,10.11,10.02,10,9.97,9.96,9.95,9.91,9.90,9.89,9.87,9.84,9.77,9.75,9.72,9.64,9.62,9.57,9.52,9.57,9.63,9.86,10.13,10.63,11.25,11.85,12.37,12.84,13.21,13.39,13.50,13.51,13.50,13.40,13.35,13.25,13.16,13.10,13,12.96,12.87,12.85,12.82,12.83,12.87,13,13.15,13.39,13.65,13.97,14.25,14.52,14.82,15.08,15.32,15.50,15.66,15.78,15.87,15.90,15.97,16,16.10,16.22,16.38,16.61,16.83,17.02,17.24,17.41,17.64,17.89,18.16,18.48,18.75,19.01,19.32,19.62,20.01,20.48,20.96,21.41,21.86,22.20,22.40,22.58,22.65,22.75,22.83,22.95,23.12,23.28,23.48,23.60,23.62,23.50,23.24,22.73,21.96,20.91,19.87,18.78,17.87,17.20,16.74,16.34,16,15.75,15.53,15.39,15.27,15.12,14.86,14.50,14.09,13.70,13.37,13.12,12.98,12.86,12.75,12.63,12.53,12.46,12.38,12.39,12.57,12.87,13.37,14,14.63,15.23,15.65,15.98,16.25,16.51,16.75,16.88,16.96,16.88,16.75,16.62,16.49,16.46,16.52,16.73,16.99,17.26,17.60,17.88,18.20,18.49,18.77,19.12,19.47,19.87,20.27,20.75,21.23,21.66,22.09,22.40,22.62,22.64,22.50,22.23,21.78,21.28,20.78,20.38,20.20,20.21,20.46,20.89,21.51,22.25,23,23.70,24.25,24.64,24.87,24.90,24.75,24.21,22.76,20.12,12,13,13,13,13,13,13,13,14,14,14,14,14,14,13,13,12,11,12,11.62,11.14,10.74,10.21,9.63,8.89,7.73,6.12,4.60,3.01,1.51,0.12,-1.10,-1.74,-2.13,-2.18,-1.90,-1.42,-0.75,0,0.74,1.45,2.02,2.58,3,3.37,3.66,3.96,4.21,4.40,4.62,4.84,5.07,5.25,5.41,5.62,5.83,6.07,6.28,6.53,6.87,7.16,7.49,7.87,8.12,8.37,8.66,8.87,9,9.03,9.08,9.11,9.14,9.25,9.39,9.60,9.75,9.89,10.01,10.12,10.23,10.38,10.70,11.12,11.64,12.25,12.87,13.35,13.70,13.86,13.87,13.75,13.53,13.25,12.98,12.70,12.47,12.33,12.25,12.25,12.37,12.53,12.75,12.87,12.85,12.66,12.45,12.16,11.91,11.73,11.60,11.60,11.72,11.89,12.12,12.33,12.48,12.59,12.63,12.66,12.70,12.65,12.61,12.50,12.35,12.12,11.89,11.63,11.37,11.12,10.87,10.62,10.40,10.25,10.11,10,9.90,9.87,9.86,9.86,9.87,9.87,9.87,9.86,9.84,9.76,9.73,9.64,9.61,9.53,9.50,9.47,9.41,9.45,9.50,9.62,9.90,10.26,10.87,11.49,12.08,12.58,13,13.25,13.37,13.41,13.40,13.37,13.28,13.23,13.13,13.08,13,12.89,12.85,12.75,12.72,12.66,12.71,12.75,12.88,13.10,13.34,13.61,13.88,14.21,14.49,14.75,15.01,15.26,15.49,15.64,15.76,15.85,15.87,15.88,15.91,16,16.15,16.37,16.62,16.87,17.11,17.26,17.45,17.61,17.77,18.01,18.28,18.59,18.87,19.21,19.53,19.96,20.37,20.84,21.26,21.66,22,22.25,22.45,22.59,22.71,22.83,22.98,23.15,23.35,23.49,23.53,23.48,23.24,22.78,22.12,21.25,20.21,19.13,18.13,17.33,16.66,16.25,15.83,15.48,15.14,14.90,14.74,14.59,14.40,14.22,13.96,13.65,13.38,13.15,13,12.87,12.75,12.63,12.52,12.41,12.35,12.28,12.36,12.51,12.86,13.33,13.88,14.50,15.01,15.47,15.82,16.10,16.36,16.58,16.71,16.72,16.63,16.51,16.38,16.34,16.38,16.58,16.85,17.14,17.50,17.84,18.13,18.46,18.74,19.01,19.34,19.66,20.07,20.50,20.96,21.40,21.87,22.26,22.59,22.75,22.74,22.59,22.26,21.85,21.37,20.91,20.63,20.57,20.72,21.09,21.62,22.25,22.91,23.57,24.11,24.52,24.86,25.02,25.09,24.91,24.41,23.12,20.22,10,12,13,12,12,12,13,12,13,14,14,14,14,14,13,13,13,12,12,11.97,11.11,10.72,10.35,9.91,9.16,8.03,6.53,4.85,3.27,1.76,0.33,-0.86,-1.65,-2.13,-2.26,-2.14,-1.79,-1.26,-0.63,0.09,0.77,1.47,2.07,2.58,3,3.40,3.75,4.08,4.33,4.50,4.70,4.82,4.90,5,5.12,5.24,5.37,5.61,5.85,6.13,6.48,6.98,7.37,7.87,8.36,8.70,8.89,9.03,9.12,9.23,9.33,9.45,9.62,9.78,10,10.16,10.28,10.37,10.40,10.49,10.61,10.85,11.22,11.72,12.26,12.84,13.33,13.66,13.87,13.89,13.78,13.57,13.25,12.87,12.53,12.28,12.12,12.03,12.09,12.24,12.49,12.74,12.87,12.86,12.66,12.46,12.21,11.97,11.75,11.65,11.66,11.82,12,12.21,12.36,12.46,12.50,12.51,12.51,12.50,12.48,12.37,12.25,12.08,11.86,11.62,11.37,11.12,10.87,10.62,10.37,10.20,10.02,9.88,9.78,9.74,9.71,9.71,9.73,9.75,9.75,9.75,9.75,9.71,9.62,9.58,9.50,9.45,9.37,9.36,9.35,9.35,9.37,9.50,9.75,10.07,10.60,11.22,11.84,12.37,12.83,13.12,13.26,13.33,13.34,13.28,13.24,13.15,13.11,13.02,12.97,12.87,12.82,12.74,12.64,12.60,12.58,12.60,12.65,12.82,13,13.26,13.58,13.87,14.15,14.46,14.74,15,15.25,15.47,15.62,15.75,15.82,15.82,15.84,15.87,15.97,16.13,16.39,16.72,17,17.23,17.38,17.51,17.62,17.76,17.96,18.20,18.47,18.75,19.11,19.47,19.86,20.27,20.74,21.14,21.57,21.88,22.15,22.38,22.58,22.74,22.87,23.07,23.24,23.37,23.47,23.41,23.21,22.78,22.16,21.37,20.45,19.47,18.50,17.62,16.89,16.32,15.85,15.37,14.98,14.62,14.36,14.13,14,13.86,13.72,13.52,13.35,13.15,13,12.87,12.75,12.64,12.52,12.41,12.33,12.25,12.24,12.33,12.50,12.86,13.28,13.83,14.35,14.84,15.25,15.62,15.96,16.24,16.41,16.52,16.53,16.47,16.36,16.25,16.26,16.39,16.64,17,17.37,17.75,18.11,18.41,18.75,19.02,19.33,19.62,19.97,20.34,20.75,21.21,21.64,22.09,22.47,22.74,22.87,22.83,22.66,22.36,21.96,21.52,21.21,21,21,21.25,21.70,22.25,22.88,23.50,24,24.45,24.76,25.01,25.16,25.23,25.12,24.71,23.57,21.35,10,10,12,12,11,12,11,11,12,14,13,13,13,13,13,13,12,12,12,11,10.88,9.70,10.07,9.66,8.75,7.76,6.59,5.02,3.53,2.03,0.60,-0.74,-1.68,-2.28,-2.50,-2.41,-2.18,-1.76,-1.24,-0.59,0.10,0.76,1.41,2.02,2.60,3.10,3.52,3.90,4.24,4.47,4.61,4.63,4.70,4.64,4.64,4.65,4.75,4.87,5.09,5.39,5.99,6.59,7.35,8.08,8.63,9.07,9.36,9.53,9.66,9.76,9.88,10.02,10.23,10.40,10.62,10.75,10.87,10.89,10.88,10.88,10.95,11.09,11.36,11.75,12.23,12.74,13.20,13.57,13.76,13.83,13.72,13.46,13.10,12.70,12.34,12.08,11.89,11.85,11.96,12.21,12.50,12.76,12.90,12.87,12.70,12.46,12.22,11.99,11.83,11.74,11.75,11.87,12.03,12.16,12.26,12.34,12.36,12.36,12.34,12.28,12.25,12.13,12,11.82,11.60,11.37,11.12,10.87,10.61,10.37,10.13,9.97,9.83,9.71,9.61,9.53,9.50,9.51,9.57,9.60,9.62,9.62,9.60,9.52,9.48,9.38,9.34,9.26,9.25,9.24,9.25,9.33,9.41,9.65,10,10.47,11.10,11.72,12.27,12.77,13.12,13.25,13.25,13.25,13.23,13.15,13.12,13.07,13,12.95,12.87,12.78,12.72,12.62,12.53,12.50,12.48,12.50,12.59,12.75,12.97,13.25,13.53,13.87,14.15,14.47,14.74,15,15.25,15.45,15.60,15.70,15.74,15.74,15.75,15.78,15.90,16.13,16.46,16.82,17.12,17.37,17.57,17.65,17.75,17.86,17.99,18.15,18.39,18.70,19.01,19.37,19.78,20.24,20.66,21.12,21.50,21.87,22.16,22.45,22.63,22.84,23,23.16,23.32,23.39,23.37,23.20,22.76,22.16,21.38,20.50,19.60,18.72,17.90,17.25,16.63,16.08,15.52,15,14.57,14.15,13.87,13.70,13.57,13.46,13.36,13.25,13.12,13,12.87,12.75,12.65,12.57,12.46,12.35,12.25,12.16,12.20,12.28,12.51,12.87,13.32,13.76,14.25,14.66,15.09,15.48,15.85,16.13,16.37,16.45,16.38,16.33,16.25,16.24,16.33,16.51,16.83,17.21,17.61,18,18.37,18.73,19.03,19.37,19.65,19.99,20.33,20.70,21.09,21.50,21.90,22.33,22.64,22.87,22.99,22.96,22.76,22.50,22.20,21.87,21.61,21.48,21.50,21.75,22.22,22.75,23.36,23.87,24.33,24.66,24.96,25.15,25.32,25.37,25.28,25,24.14,22.49,9,10,10,11,11,9,9,9,11,13,13,12,12,12,12,12,12,12,11,10,8,7.88,7.48,8.09,7.47,7,6.26,5.22,3.84,2.37,0.82,-0.75,-2,-2.66,-2.79,-2.67,-2.50,-2.16,-1.76,-1.25,-0.63,0.03,0.75,1.47,2.11,2.74,3.32,3.83,4.25,4.52,4.64,4.62,4.50,4.36,4.23,4.12,4.11,4.14,4.37,4.87,5.59,6.47,7.37,8.23,8.97,9.53,10,10.26,10.46,10.57,10.63,10.75,10.88,11.07,11.25,11.37,11.48,11.50,11.46,11.37,11.35,11.37,11.51,11.78,12.15,12.61,13.02,13.37,13.62,13.64,13.51,13.25,12.86,12.41,12.07,11.82,11.71,11.71,11.90,12.25,12.60,12.87,12.98,12.88,12.70,12.46,12.22,12,11.87,11.82,11.83,11.88,12,12.12,12.13,12.14,12.13,12.12,12.11,12.08,12,11.89,11.75,11.58,11.36,11.11,10.86,10.61,10.36,10.12,9.89,9.74,9.61,9.50,9.40,9.37,9.35,9.36,9.37,9.40,9.45,9.45,9.39,9.37,9.28,9.25,9.21,9.15,9.13,9.15,9.24,9.37,9.60,9.96,10.37,11,11.66,12.36,12.78,13.12,13.26,13.32,13.25,13.20,13.12,13.03,13,12.96,12.89,12.85,12.76,12.71,12.62,12.51,12.46,12.38,12.37,12.39,12.50,12.65,12.88,13.22,13.57,13.88,14.22,14.50,14.75,15.01,15.25,15.40,15.53,15.62,15.62,15.62,15.63,15.73,15.88,16.15,16.51,16.90,17.26,17.57,17.75,17.87,17.95,18,18.11,18.24,18.41,18.66,19,19.36,19.76,20.24,20.70,21.13,21.59,21.98,22.28,22.58,22.78,22.98,23.13,23.28,23.40,23.36,23.16,22.78,22.20,21.37,20.49,19.59,18.74,18,17.41,16.90,16.39,15.87,15.27,14.73,14.22,13.83,13.52,13.37,13.25,13.20,13.12,13.03,12.97,12.86,12.75,12.64,12.57,12.48,12.37,12.27,12.22,12.14,12.15,12.28,12.53,12.90,13.37,13.82,14.23,14.62,15,15.37,15.75,16.08,16.25,16.33,16.26,16.22,16.23,16.28,16.49,16.75,17.09,17.47,17.87,18.26,18.64,19,19.37,19.71,20.02,20.37,20.72,21.07,21.45,21.84,22.22,22.57,22.86,23.03,23.12,23.08,22.96,22.75,22.57,22.34,22.13,22.01,22.07,22.25,22.62,23.12,23.63,24.12,24.51,24.85,25.10,25.27,25.41,25.50,25.49,25.27,24.75,22.70,10,9,9,10,9,8,7,8,10,12,12,12,10,10,10,10,10,9,8,5,4,3,4.10,5.09,5.53,5.90,5.88,5.27,4.15,2.87,1.09,-0.78,-2.88,-3.60,-3.10,-2.78,-2.63,-2.47,-2.23,-1.88,-1.38,-0.75,0,0.82,1.60,2.36,3.11,3.78,4.37,4.75,4.87,4.74,4.48,4.12,3.78,3.53,3.40,3.40,3.82,4.46,5.25,6.20,7.15,8.12,9.07,9.87,10.50,10.91,11.14,11.25,11.28,11.36,11.45,11.59,11.75,11.89,12,12.02,11.99,11.87,11.75,11.72,11.75,11.88,12.15,12.51,12.89,13.25,13.46,13.48,13.32,13,12.58,12.13,11.78,11.58,11.52,11.62,11.95,12.34,12.71,12.97,13.03,12.89,12.66,12.45,12.23,12.02,11.91,11.87,11.87,11.90,11.97,12,11.99,11.96,11.90,11.87,11.86,11.83,11.75,11.65,11.50,11.34,11.11,10.87,10.61,10.36,10.11,9.87,9.65,9.50,9.38,9.33,9.25,9.22,9.21,9.21,9.23,9.25,9.25,9.25,9.24,9.21,9.14,9.12,9.11,9.10,9.11,9.14,9.26,9.49,9.83,10.26,10.87,11.62,12.35,12.91,13.26,13.35,13.33,13.25,13.13,13.07,12.99,12.91,12.87,12.86,12.82,12.76,12.71,12.62,12.51,12.41,12.36,12.27,12.25,12.28,12.39,12.61,12.88,13.24,13.60,13.95,14.25,14.53,14.82,15.03,15.25,15.37,15.48,15.50,15.50,15.49,15.51,15.63,15.87,16.23,16.62,17.03,17.41,17.73,17.91,18.08,18.14,18.24,18.32,18.39,18.52,18.75,19,19.37,19.77,20.26,20.76,21.25,21.74,22.14,22.50,22.77,23,23.14,23.28,23.39,23.45,23.25,22.85,22.23,21.38,20.45,19.50,18.62,17.89,17.37,16.98,16.62,16.23,15.72,15.09,14.46,13.90,13.50,13.26,13.12,13.08,13.01,12.99,12.91,12.85,12.75,12.62,12.52,12.47,12.38,12.35,12.26,12.22,12.15,12.16,12.32,12.60,13,13.47,13.88,14.27,14.62,14.99,15.36,15.71,16,16.12,16.13,16.10,16.09,16.20,16.40,16.75,17.08,17.45,17.82,18.21,18.59,18.96,19.33,19.66,20.03,20.39,20.75,21.11,21.45,21.77,22.12,22.50,22.78,23.01,23.16,23.25,23.25,23.21,23.12,23,22.87,22.75,22.62,22.62,22.74,23,23.38,23.85,24.27,24.65,24.98,25.22,25.38,25.52,25.62,25.62,25.51,25.23,23.89,11,11,10,8,8,8,9,9,9,9,10,9,8,7,7,7,7,5,3,2,2,2,2,2.01,3.37,4.49,5.97,5.12,4.50,3.35,1.65,-0.73,-2.79,-3.61,-3,-2.67,-2.60,-2.59,-2.63,-2.51,-2.18,-1.54,-0.75,0.14,1.03,1.95,2.87,3.84,4.75,5.28,5.37,5,4.50,3.95,3.32,2.86,2.96,3.20,3.53,4.12,4.83,5.66,6.64,7.72,8.78,9.84,10.72,11.27,11.57,11.62,11.64,11.66,11.75,11.88,12.10,12.26,12.40,12.49,12.45,12.34,12.16,12.03,12,12.07,12.25,12.51,12.86,13.12,13.28,13.27,13.09,12.73,12.27,11.87,11.57,11.38,11.46,11.62,12,12.40,12.76,12.99,12.99,12.85,12.62,12.40,12.23,12.08,11.99,11.95,11.91,11.90,11.89,11.87,11.82,11.74,11.66,11.62,11.61,11.58,11.51,11.41,11.27,11.10,10.87,10.62,10.37,10.12,9.88,9.64,9.47,9.34,9.25,9.21,9.15,9.12,9.12,9.11,9.11,9.12,9.12,9.12,9.11,9.09,9.07,9.03,9.03,9.03,9.10,9.20,9.37,9.63,10.08,10.64,11.35,12.07,12.66,13.12,13.34,13.35,13.25,13.12,13,12.90,12.85,12.77,12.75,12.74,12.71,12.65,12.59,12.50,12.40,12.34,12.25,12.22,12.20,12.25,12.38,12.62,12.95,13.27,13.63,14,14.33,14.61,14.86,15.08,15.25,15.37,15.37,15.37,15.36,15.35,15.39,15.62,15.91,16.36,16.78,17.25,17.62,17.90,18.12,18.28,18.40,18.50,18.58,18.62,18.74,18.87,19.12,19.47,19.87,20.37,20.89,21.41,21.91,22.37,22.75,23.01,23.23,23.37,23.46,23.49,23.38,23.10,22.35,21.49,20.47,19.40,18.49,17.71,17.12,16.74,16.50,16.26,15.98,15.47,14.82,14.13,13.62,13.24,13.03,12.96,12.91,12.90,12.88,12.85,12.75,12.62,12.51,12.45,12.37,12.36,12.34,12.28,12.25,12.21,12.23,12.37,12.65,13.11,13.59,14.02,14.39,14.72,15,15.34,15.62,15.87,15.97,15.95,15.89,15.99,16.25,16.62,17.07,17.49,17.87,18.23,18.58,18.89,19.25,19.62,19.98,20.37,20.75,21.12,21.48,21.77,22.10,22.38,22.66,22.95,23.14,23.32,23.39,23.47,23.50,23.50,23.50,23.46,23.36,23.25,23.16,23.21,23.37,23.65,24.03,24.46,24.82,25.12,25.35,25.51,25.64,25.74,25.75,25.71,25.62,23.97,12,11,10,9,8,9,11,11,10,8,7,6,5,5,5,4,3,2,2,2,2,2,2,2,2,3.16,3.52,5.01,4.88,3.71,2.49,0.50,-1.54,-2.25,-2.23,-2.24,-2.36,-2.61,-2.87,-3.27,-3.13,-2.40,-1.52,-0.53,0.45,1.41,2.49,3.71,5.37,6.62,6.03,5.59,4.65,3.66,3.32,3.21,3.14,3.23,3.47,3.77,4.34,5.03,5.96,7.01,8.20,9.33,10.36,11.07,11.41,11.57,11.62,11.70,11.82,12,12.25,12.50,12.71,12.83,12.83,12.72,12.53,12.37,12.25,12.25,12.37,12.60,12.86,13.09,13.16,13.10,12.85,12.46,12.01,11.62,11.37,11.28,11.41,11.66,12.08,12.49,12.78,12.91,12.87,12.73,12.57,12.37,12.24,12.12,12.03,12.01,12,11.96,11.87,11.75,11.62,11.50,11.46,11.39,11.37,11.36,11.28,11.22,11.07,10.87,10.62,10.39,10.20,9.99,9.75,9.50,9.33,9.23,9.20,9.20,9.16,9.13,9.11,9.08,9.02,9.01,9.01,9.01,9.01,9,9,9,9,9.02,9.11,9.23,9.48,9.84,10.37,11,11.70,12.33,12.76,13.03,13.12,13.12,13.01,12.91,12.84,12.74,12.65,12.62,12.60,12.59,12.53,12.51,12.45,12.37,12.28,12.24,12.16,12.14,12.16,12.25,12.45,12.70,13,13.37,13.73,14.08,14.37,14.64,14.87,15.07,15.21,15.27,15.28,15.25,15.21,15.22,15.35,15.63,16.08,16.59,17.07,17.50,17.87,18.13,18.37,18.52,18.66,18.77,18.87,18.90,19,19.12,19.33,19.62,20.03,20.51,21.08,21.62,22.12,22.61,22.99,23.25,23.45,23.52,23.59,23.50,23.25,22.75,21.73,20.62,19.47,18.37,17.50,16.85,16.37,16.12,16,15.87,15.62,15.12,14.46,13.78,13.28,12.97,12.83,12.77,12.78,12.84,12.84,12.76,12.65,12.53,12.41,12.35,12.32,12.33,12.35,12.36,12.33,12.27,12.32,12.47,12.76,13.24,13.75,14.21,14.57,14.84,15.08,15.32,15.52,15.71,15.75,15.73,15.74,15.90,16.32,16.85,17.38,17.89,18.35,18.71,19,19.27,19.59,19.88,20.25,20.62,21,21.37,21.70,21.97,22.24,22.50,22.77,23.02,23.25,23.41,23.58,23.70,23.78,23.87,23.96,23.96,23.88,23.78,23.71,23.66,23.75,24,24.33,24.66,25,25.28,25.50,25.65,25.75,25.84,25.86,25.84,25.71,23.98,12,11,10,9,9,10,12,11,9,7,5,4,4,4,3,3,2,2,2,2,2,2,2,2,2,2,2.07,3.34,4.75,3.75,2.75,1.83,0.40,-0.65,-1.24,-1.50,-2.02,-2.47,-2.93,-3.39,-3.88,-3.50,-2.24,-1.14,-0.14,0.86,1.97,3.33,5.10,7.12,7,6.48,5.58,4.85,4.36,4.03,3.83,3.62,3.53,3.62,3.90,4.41,5.20,6.15,7.32,8.48,9.50,10.26,10.75,11.03,11.25,11.40,11.63,11.95,12.26,12.62,12.87,13.03,13.09,13,12.84,12.64,12.50,12.48,12.53,12.71,12.87,13,13.01,12.87,12.58,12.16,11.76,11.46,11.27,11.27,11.48,11.75,12.14,12.52,12.77,12.85,12.74,12.60,12.47,12.35,12.25,12.21,12.16,12.15,12.13,12.03,11.87,11.65,11.48,11.33,11.24,11.22,11.20,11.15,11.12,11.01,10.87,10.64,10.41,10.24,10.08,9.87,9.64,9.41,9.25,9.22,9.25,9.27,9.27,9.25,9.15,9.10,9.01,9,8.99,8.99,8.99,8.99,9,9,9,9.01,9.11,9.27,9.60,10.08,10.64,11.27,11.89,12.37,12.71,12.84,12.87,12.83,12.75,12.64,12.59,12.50,12.46,12.38,12.37,12.37,12.35,12.34,12.27,12.24,12.16,12.12,12.12,12.12,12.20,12.33,12.51,12.78,13.12,13.48,13.83,14.14,14.46,14.71,14.88,15.02,15.13,15.21,15.20,15.12,15.09,15.12,15.37,15.77,16.35,16.90,17.40,17.85,18.15,18.40,18.62,18.77,18.96,19.08,19.14,19.23,19.26,19.37,19.59,19.87,20.25,20.74,21.25,21.83,22.34,22.82,23.16,23.45,23.62,23.70,23.64,23.48,23.03,22.23,21,19.73,18.50,17.46,16.63,16.10,15.74,15.58,15.49,15.40,15.15,14.70,14.02,13.40,12.91,12.70,12.61,12.62,12.66,12.75,12.75,12.72,12.61,12.48,12.36,12.26,12.25,12.28,12.37,12.40,12.45,12.45,12.49,12.64,12.99,13.45,13.97,14.40,14.75,15,15.16,15.34,15.47,15.52,15.53,15.51,15.62,15.87,16.37,17,17.64,18.25,18.75,19.12,19.40,19.63,19.87,20.14,20.50,20.85,21.10,21.39,21.70,21.97,22.24,22.52,22.83,23.10,23.33,23.51,23.72,23.87,24.02,24.16,24.28,24.36,24.35,24.25,24.20,24.14,24.23,24.39,24.70,25,25.32,25.53,25.73,25.83,25.87,25.90,25.96,25.88,25.70,24,12,12,12,11,11,12,11,10,7,5,4,4,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3.60,3.58,2.96,2.16,1.34,0.53,-0.18,-1,-1.72,-2.29,-2.75,-3.60,-4.42,-4,-2.85,-1.67,-0.73,0.15,1.15,2.48,4.16,7.66,8.16,7.72,7.13,6.59,6.07,5.57,5,4.45,3.99,3.73,3.70,3.91,4.48,5.27,6.28,7.37,8.37,9.16,9.77,10.24,10.62,10.99,11.37,11.82,12.25,12.64,12.99,13.16,13.24,13.14,13,12.84,12.72,12.64,12.70,12.76,12.87,12.87,12.78,12.59,12.25,11.87,11.53,11.33,11.25,11.35,11.57,11.87,12.25,12.62,12.77,12.74,12.59,12.45,12.36,12.34,12.35,12.37,12.37,12.39,12.37,12.25,11.99,11.65,11.37,11.21,11.11,11.07,11.03,11.07,11,10.89,10.73,10.50,10.26,10.12,10,9.85,9.62,9.40,9.28,9.28,9.37,9.45,9.46,9.37,9.25,9.12,9.02,8.99,8.98,8.98,8.98,8.99,8.99,8.99,9,9.01,9.12,9.32,9.75,10.33,10.91,11.50,12,12.35,12.50,12.58,12.58,12.51,12.46,12.37,12.34,12.26,12.24,12.20,12.14,12.13,12.15,12.14,12.12,12.11,12.08,12.07,12.08,12.12,12.24,12.39,12.62,12.90,13.25,13.60,13.91,14.25,14.50,14.73,14.87,15,15.07,15.09,15.02,14.98,14.98,15.13,15.50,16.03,16.72,17.35,17.87,18.25,18.50,18.74,18.89,19.07,19.22,19.34,19.41,19.50,19.58,19.66,19.87,20.13,20.51,20.98,21.49,22,22.50,22.98,23.34,23.59,23.73,23.75,23.66,23.39,22.75,21.62,20.24,18.87,17.64,16.70,15.98,15.48,15.15,15.01,14.97,14.87,14.63,14.20,13.62,13.02,12.61,12.47,12.39,12.48,12.57,12.62,12.66,12.62,12.53,12.40,12.28,12.24,12.24,12.32,12.40,12.52,12.62,12.71,12.78,13,13.33,13.75,14.25,14.72,15.03,15.25,15.37,15.46,15.47,15.45,15.39,15.40,15.57,15.89,16.46,17.12,17.82,18.47,19,19.37,19.64,19.86,20.09,20.34,20.53,20.83,21.11,21.25,21.50,21.78,22.12,22.48,22.78,23.10,23.37,23.60,23.82,24,24.22,24.38,24.52,24.62,24.65,24.64,24.62,24.62,24.71,24.87,25.12,25.38,25.64,25.85,25.96,26,26,26,25.99,25.88,25.70,24.07,13,13,12,12,12,12,10,8,6,5,4,3,3,2,2,1,2,2,3,3,2,2,2,2,2,2,2,2,2,3.25,3.50,2.46,1.72,0.95,0.16,-0.66,-1.48,-2.25,-2.75,-3.65,-4.29,-4.13,-3.38,-2.13,-1.09,-0.79,-0.01,1.58,2.90,6.86,8.25,8.83,8.86,8.50,8,7.32,6.46,5.50,4.65,4.02,3.65,3.61,3.87,4.47,5.26,6.21,7.11,7.90,8.62,9.25,9.86,10.46,11.03,11.62,12.16,12.63,13,13.21,13.25,13.15,13.01,12.87,12.76,12.74,12.75,12.75,12.75,12.64,12.49,12.22,11.88,11.60,11.36,11.24,11.25,11.39,11.63,11.98,12.36,12.72,12.75,12.62,12.39,12.25,12.24,12.34,12.48,12.59,12.63,12.71,12.72,12.58,12.24,11.77,11.37,11.13,11.02,11,11,11,10.98,10.86,10.63,10.39,10.20,10.07,9.97,9.84,9.64,9.48,9.37,9.41,9.52,9.62,9.62,9.51,9.36,9.15,9.01,8.97,8.95,8.96,8.97,8.98,8.99,8.99,9,9,9.08,9.37,9.91,10.57,11.15,11.66,12.01,12.21,12.27,12.32,12.27,12.23,12.15,12.12,12.12,12.10,12.09,12.07,12.02,12.02,12.01,12.02,12,11.99,11.98,11.99,12.02,12.12,12.27,12.50,12.75,13.03,13.37,13.71,14.01,14.32,14.53,14.75,14.87,14.91,14.96,14.91,14.87,14.84,14.88,15.14,15.74,16.38,17.13,17.84,18.36,18.70,18.88,19.07,19.21,19.34,19.47,19.58,19.64,19.75,19.84,19.97,20.14,20.45,20.78,21.23,21.71,22.21,22.65,23.10,23.41,23.65,23.76,23.76,23.64,23.26,22.39,21,19.49,17.97,16.88,16.12,15.49,15,14.70,14.51,14.40,14.33,14.09,13.65,13.16,12.72,12.37,12.22,12.25,12.34,12.41,12.50,12.58,12.57,12.48,12.37,12.25,12.23,12.25,12.36,12.51,12.74,12.91,13.10,13.25,13.50,13.83,14.25,14.72,15.13,15.48,15.66,15.75,15.75,15.63,15.50,15.39,15.38,15.57,15.91,16.49,17.12,17.78,18.41,18.96,19.32,19.53,19.75,19.99,20.13,20.32,20.50,20.70,20.89,21.15,21.50,21.95,22.37,22.75,23.09,23.37,23.62,23.87,24.10,24.32,24.50,24.66,24.83,24.89,24.97,25,25.03,25.14,25.35,25.58,25.83,26.03,26.16,26.23,26.20,26.11,26.01,25.99,25.89,25.71,24.12,14,14,13,13,12,11,9,7,5,4,4,3,3,2,2,1,2,2,3,3,3,2,2,2,2,2,2,2,2,2.76,2.88,2.87,2.11,1.27,0.49,-0.12,-1.75,-2.23,-3.39,-3.75,-4.34,-3.99,-3.24,-1.60,-1.40,-1.68,-0.73,0.12,2.63,4.40,7.71,10,10.38,10.45,10.03,9.22,7.96,6.62,5.46,4.50,3.85,3.49,3.49,3.78,4.36,5.07,5.84,6.62,7.39,8.23,9.02,9.87,10.65,11.39,12.07,12.58,12.89,13.08,13.08,12.98,12.85,12.74,12.66,12.64,12.62,12.59,12.48,12.28,12.03,11.76,11.50,11.33,11.21,11.20,11.27,11.46,11.70,12,12.36,12.70,12.65,12.45,12.15,12.02,12.09,12.32,12.61,12.82,12.88,12.95,12.99,13,12.60,12.01,11.49,11.14,11.03,11,11,11,11,10.88,10.62,10.36,10.13,10.02,9.96,9.87,9.73,9.60,9.53,9.60,9.70,9.75,9.75,9.62,9.39,9.16,9,8.89,8.88,8.91,8.96,8.97,8.98,8.99,9,9,9.08,9.38,10.03,10.72,11.32,11.75,11.97,12.03,12.08,12.07,12,11.96,11.89,11.89,11.95,11.99,12,12,12,12,11.99,11.97,11.90,11.87,11.87,11.90,12,12.14,12.35,12.59,12.87,13.14,13.48,13.77,14.09,14.35,14.57,14.73,14.82,14.84,14.78,14.74,14.66,14.71,14.88,15.32,15.99,16.76,17.57,18.25,18.77,19.11,19.25,19.37,19.49,19.59,19.66,19.76,19.87,19.96,20.07,20.23,20.45,20.74,21.09,21.49,21.89,22.37,22.83,23.21,23.50,23.71,23.76,23.74,23.57,23.09,22.01,20.40,18.76,17.34,16.34,15.73,15.12,14.64,14.27,14.03,13.89,13.73,13.50,13.15,12.77,12.45,12.22,12.11,12.12,12.21,12.28,12.38,12.46,12.47,12.39,12.34,12.25,12.25,12.33,12.49,12.74,13.02,13.36,13.62,13.87,14.13,14.47,14.86,15.27,15.71,16.02,16.25,16.32,16.23,16,15.75,15.50,15.45,15.59,15.91,16.45,17.02,17.62,18.15,18.61,18.89,19.12,19.28,19.47,19.62,19.82,19.96,20.11,20.33,20.64,21.13,21.75,22.25,22.71,23.07,23.37,23.62,23.87,24.12,24.35,24.57,24.75,24.95,25.09,25.21,25.32,25.40,25.58,25.75,26,26.25,26.41,26.60,26.52,26.37,26.21,26.08,26,25.89,25.71,24.20,14,14,14,13,13,11,8,6,4,4,4,3,3,2,2,1,2,2,3,3,3,3,2,2,2,2,2,2,2,2,2.40,3.48,3.63,2.62,0.82,0.01,-1.66,-2.11,-2.25,-3.14,-2.26,-2.27,-2.42,-1.30,-1.77,-2.05,-1.14,-0.26,1.45,2.91,7.65,10.16,11.64,11.66,11.34,10.45,9.07,7.50,6.15,5.08,4.24,3.63,3.36,3.37,3.62,4.09,4.65,5.38,6.24,7.15,8.15,9.20,10.15,11.03,11.76,12.32,12.62,12.72,12.64,12.51,12.39,12.35,12.34,12.34,12.28,12.21,12,11.76,11.51,11.28,11.13,11.08,11.09,11.13,11.25,11.40,11.62,11.88,12.16,12.40,12.35,12.11,11.83,11.74,11.86,12.22,12.71,13.08,13,12.99,13.01,13.14,13.24,12.38,11.50,11.37,11.14,11.02,11,11,10.98,10.89,10.63,10.33,10.12,10,9.97,9.89,9.83,9.75,9.73,9.75,9.83,9.86,9.84,9.70,9.40,9.12,8.89,8.83,8.83,8.87,8.91,8.95,8.97,8.99,8.99,9.01,9.16,9.50,10.12,10.77,11.34,11.64,11.82,11.86,11.86,11.82,11.75,11.70,11.66,11.74,11.83,11.89,11.97,11.99,11.99,11.99,11.97,11.89,11.84,11.76,11.76,11.85,11.98,12.14,12.38,12.64,12.96,13.25,13.52,13.84,14.10,14.34,14.50,14.63,14.71,14.65,14.60,14.50,14.47,14.59,14.91,15.50,16.28,17.15,17.91,18.60,19.11,19.40,19.58,19.63,19.74,19.78,19.87,19.95,20.01,20.12,20.25,20.46,20.71,21,21.35,21.72,22.11,22.50,22.91,23.32,23.58,23.72,23.73,23.62,23.34,22.64,21.45,19.77,18.23,16.95,16.08,15.46,14.87,14.37,13.97,13.63,13.39,13.22,12.99,12.73,12.47,12.25,12.11,12.03,12.02,12.11,12.20,12.26,12.34,12.37,12.35,12.32,12.28,12.35,12.47,12.71,13.03,13.46,13.87,14.26,14.61,14.88,15.21,15.53,15.95,16.34,16.66,16.88,16.97,16.82,16.49,16.07,15.66,15.50,15.53,15.85,16.27,16.77,17.26,17.72,18.03,18.28,18.50,18.64,18.85,19.02,19.23,19.37,19.52,19.77,20.25,20.89,21.62,22.25,22.72,23.03,23.36,23.62,23.87,24.11,24.34,24.57,24.77,25,25.23,25.39,25.59,25.75,25.90,26.12,26.36,26.65,26.84,26.87,26.75,26.50,26.26,26.12,26.01,25.90,25.71,24.25,14,13,13,13,13,10,7,5,4,4,4,3,2,2,2,1,2,2,3,3,3,3,2,2,2,2,2,2,2,2,2.75,3,4.25,3.20,1.37,0.39,-0.25,-1.66,-1.85,-1.90,-1.78,-1.49,-1.91,-1.55,-2.02,-2.35,-1.40,-0.62,0.12,2.72,6.61,10.21,11.72,12.12,11.73,10.77,9.48,8,6.75,5.73,4.87,4.14,3.62,3.27,3.21,3.35,3.73,4.34,5.12,6.12,7.22,8.36,9.46,10.45,11.25,11.77,12.02,12.01,11.89,11.75,11.64,11.62,11.65,11.72,11.66,11.52,11.33,11.09,10.87,10.76,10.75,10.85,10.96,11.08,11.20,11.28,11.41,11.62,11.76,11.87,11.75,11.52,11.36,11.34,11.57,11.98,12.52,12.98,12.86,12.70,12.73,12.90,13.36,12.84,12.37,11.87,11.37,11.20,11.02,11,10.96,10.83,10.61,10.25,10.03,10,9.99,9.96,9.90,9.87,9.87,9.87,9.89,9.90,9.87,9.72,9.39,9.03,8.75,8.64,8.70,8.82,8.88,8.89,8.88,8.95,8.99,9.08,9.27,9.62,10.14,10.73,11.22,11.40,11.53,11.59,11.59,11.53,11.50,11.46,11.48,11.61,11.75,11.87,11.96,11.99,11.99,11.98,11.95,11.87,11.73,11.64,11.64,11.75,11.90,12.13,12.40,12.71,13,13.26,13.53,13.82,14.03,14.25,14.39,14.50,14.50,14.45,14.32,14.23,14.25,14.49,14.99,15.71,16.57,17.41,18.23,18.87,19.26,19.57,19.75,19.85,19.89,19.96,20,20.03,20.12,20.24,20.38,20.62,20.89,21.24,21.59,21.91,22.26,22.62,23,23.34,23.61,23.74,23.61,23.28,22.86,21.87,20.58,19.09,17.74,16.65,15.88,15.25,14.65,14.12,13.66,13.28,13,12.75,12.57,12.37,12.23,12.11,12.02,12,12,12.01,12.10,12.15,12.24,12.27,12.32,12.34,12.37,12.48,12.66,13,13.41,13.96,14.49,14.97,15.37,15.66,15.97,16.25,16.61,16.97,17.26,17.53,17.62,17.41,16.90,16.27,15.75,15.46,15.40,15.62,15.99,16.38,16.76,17.12,17.39,17.66,17.86,18.03,18.33,18.61,18.85,19,19.13,19.49,20.12,20.86,21.60,22.23,22.66,23.07,23.37,23.63,23.87,24.09,24.28,24.52,24.82,25.10,25.37,25.62,25.85,26.02,26.25,26.45,26.62,26.76,26.90,26.97,26.84,26.58,26.33,26.12,26.03,25.97,25.75,24.37,13,13,12,12,11,9,6,5,4,4,4,3,2,2,2,1,2,3,3,3,3,3,3,2,2,2,2,2,2,2,1.87,2.38,3.60,3.62,1.82,0.86,0.13,-0.37,-1.63,-1.67,-1.53,-1.25,-2.02,-1.65,-2.13,-1.40,-1.50,-0.77,-0.05,1.51,6.13,10.35,11.75,12.01,11.48,10.52,9.37,8.25,7.25,6.48,5.74,4.97,4.20,3.50,3.02,2.87,3,3.46,4.14,5.09,6.14,7.32,8.41,9.46,10.25,10.76,10.98,10.90,10.75,10.62,10.53,10.58,10.64,10.73,10.72,10.57,10.37,10.16,10.10,10.14,10.33,10.52,10.75,10.89,10.95,10.97,11.03,11.13,11.14,11.11,11,10.82,10.76,10.88,11.24,11.62,12,12.16,12.14,12.07,12.08,12.36,12.85,13.60,13.12,12.64,12.12,11.37,11.21,11.02,10.95,10.74,10.37,10.14,10.01,10,10,10,10,10,10,10,9.99,9.97,9.90,9.75,9.38,8.88,8.50,8.45,8.50,8.60,8.62,8.66,8.75,8.87,8.99,9.14,9.39,9.75,10.13,10.53,10.90,11.11,11.15,11.22,11.23,11.25,11.25,11.25,11.35,11.52,11.74,11.87,11.97,11.99,11.99,11.97,11.88,11.76,11.59,11.47,11.48,11.60,11.78,12.07,12.36,12.64,12.95,13.23,13.48,13.72,13.89,14.08,14.21,14.25,14.23,14.08,13.90,13.87,14,14.37,15,15.78,16.66,17.52,18.25,18.85,19.33,19.65,19.73,19.83,19.89,19.97,20,20.03,20.11,20.23,20.40,20.71,21.02,21.38,21.75,22.08,22.37,22.70,23,23.34,23.60,23.71,23.51,22.89,21.82,20.66,19.41,18.25,17.22,16.37,15.70,15.08,14.47,13.87,13.37,12.97,12.62,12.38,12.23,12.11,12,11.97,11.95,11.91,11.91,11.96,12,12.08,12.14,12.24,12.28,12.37,12.47,12.62,12.88,13.27,13.82,14.40,15.03,15.62,16.08,16.37,16.64,16.89,17.16,17.47,17.75,18,18.01,17.73,17.10,16.26,15.59,15.20,15.10,15.24,15.50,15.85,16.13,16.45,16.75,17.08,17.37,17.75,18.21,18.61,18.87,19.02,19.22,19.58,20.21,20.91,21.62,22.23,22.71,23.09,23.45,23.72,23.89,24.02,24.21,24.40,24.70,25,25.33,25.61,25.86,26.10,26.32,26.49,26.62,26.73,26.83,26.85,26.74,26.50,26.25,26.12,26.08,26.07,25.97,24.48,13,12,12,11,10,8,6,5,4,4,4,3,2,2,2,2,2,3,4,3,3,3,3,3,2,2,2,2,2,2,2,2.57,2.88,3.14,2.24,1.26,0.58,0.10,-1.14,-1.25,-1.27,-1.24,-2,-1.63,-2.05,-1.37,-0.48,-0.88,-0.18,1.37,5.76,10.50,12.03,11.75,11.10,10.08,9.01,8.20,7.63,7.25,6.74,5.89,4.85,3.84,3.03,2.61,2.50,2.76,3.33,4.12,5.08,6.11,7.13,8.07,8.76,9.24,9.39,9.37,9.25,9.13,9.12,9.16,9.28,9.37,9.37,9.26,9.12,9.02,9.10,9.33,9.73,10.12,10.34,10.36,10.26,10.25,10.34,10.35,10.28,10.13,10.03,9.95,10.02,10.46,10.96,11.32,11.41,11.39,11.35,11.25,11.23,11.48,12.37,13.62,13.75,13.62,12.98,12.26,11.37,11.21,10.98,10.65,10.34,10.08,10,10,10,10,10,10,10,10,9.98,9.96,9.87,9.65,9.23,8.73,8.34,8.24,8.25,8.27,8.33,8.37,8.51,8.75,8.99,9.25,9.52,9.85,10.10,10.34,10.52,10.70,10.73,10.76,10.86,10.95,11,11.09,11.24,11.50,11.75,11.89,11.96,11.95,11.91,11.89,11.84,11.63,11.32,11.13,11.13,11.32,11.58,11.87,12.20,12.49,12.75,13,13.25,13.48,13.62,13.75,13.85,13.87,13.75,13.50,13.26,13.26,13.57,14.12,14.85,15.71,16.60,17.40,18.08,18.58,18.99,19.37,19.60,19.64,19.66,19.75,19.78,19.77,19.76,19.87,20.13,20.50,20.95,21.37,21.76,22.12,22.37,22.63,22.95,23.26,23.62,23.66,23.01,21.78,20.49,19.22,18.14,17.26,16.53,15.97,15.41,14.77,14.12,13.50,13,12.57,12.24,12,11.87,11.78,11.76,11.76,11.76,11.77,11.78,11.83,11.87,11.97,12.10,12.22,12.32,12.37,12.50,12.66,13,13.46,14.07,14.76,15.50,16.13,16.62,16.97,17.16,17.37,17.59,17.75,17.89,17.98,17.87,17.40,16.64,15.75,15,14.58,14.50,14.62,14.86,15.07,15.34,15.71,16.08,16.50,17.01,17.63,18.28,18.87,19.22,19.36,19.49,19.75,20.25,20.96,21.61,22.12,22.63,23.11,23.51,23.75,23.78,23.88,24,24.20,24.47,24.75,25.02,25.33,25.61,25.87,26.11,26.25,26.37,26.45,26.50,26.50,26.40,26.25,26.09,25.98,26,26.14,26.32,25.61,13,12,11,11,10,7,6,5,4,4,4,3,2,2,2,2,2,3,4,3,3,3,3,2,2,2,2,2,2,2,2,1.75,2.14,3.37,2.57,1.65,1,-0.51,-0.88,-1.04,-1.13,-1.01,-1.77,-1.39,-1.86,-1.13,-0.41,-0.88,-0.16,1.37,4.87,9.62,11.24,11.52,10.64,9.41,8.20,7.63,7.75,8.02,7.82,6.76,5.35,4,3.02,2.45,2.21,2.28,2.65,3.26,4.02,4.88,5.75,6.52,7.12,7.50,7.65,7.64,7.59,7.50,7.50,7.62,7.75,7.87,7.87,7.84,7.75,7.74,7.87,8.22,8.75,9.21,9.34,9.12,8.96,8.98,9.13,9.03,8.89,8.91,8.99,8.75,9,9.75,11.02,11.21,10.71,10.51,10.49,10.46,10.41,10.35,12.10,13.63,14.62,13.97,13.65,13.62,12.23,11.37,11.02,10.61,10.25,9.98,9.91,9.91,9.91,9.91,9.91,9.95,9.95,9.95,9.90,9.87,9.82,9.51,8.99,8.39,8.03,7.97,7.95,7.95,7.95,7.95,8.25,8.59,8.90,9.25,9.60,9.90,9.91,10.02,10.13,10.25,10.25,10.25,10.37,10.50,10.62,10.57,10.78,11.12,11.51,11.63,11.65,11.53,11.57,11.59,11.52,11.33,10.84,10.41,10.50,10.70,10.91,11.22,11.50,11.76,11.90,12.12,12.37,12.60,12.65,12.73,12.75,12.73,12.49,12.03,11.75,11.87,12.59,13.35,14.07,14.74,15.64,16.51,17.16,17.50,17.75,18.15,18.49,18.63,18.77,18.90,19,18.90,18.88,19.08,19.48,20.07,20.60,21.21,21.66,22.08,22.28,22.50,22.71,23.13,23.51,23.37,22.13,20.25,18.59,17.48,16.75,16.12,15.72,15.40,14.90,14.21,13.32,12.82,12.39,12.07,11.64,11.33,11.25,11.25,11.27,11.35,11.38,11.47,11.51,11.59,11.62,11.73,11.97,12.16,12.27,12.24,12.21,12.40,12.73,13.25,13.88,14.73,15.46,16.12,16.58,16.89,17.03,17.14,17.37,17.41,17.28,17,16.75,16.24,15.28,14.32,13.57,13.25,13.27,13.62,13.87,14.10,14.14,14.37,14.87,15.58,16.36,17.28,18.27,19.21,19.61,19.71,19.51,19.59,19.95,20.50,21.21,21.82,22.38,22.87,23.21,23.37,23.37,23.37,23.32,23.46,23.59,23.85,24,24.12,24.46,24.78,25.12,25.26,25.38,25.50,25.61,25.65,25.70,25.64,25.62,25.61,25.71,25.99,26.37,26.75,14,12,11,10,9,7,6,5,4,4,4,3,2,2,2,2,2,3,4,3,3,3,3,2,2,2,2,2,2,2,2,2,2.51,2.75,2.89,2.01,1.34,-0.17,-0.51,-0.75,-0.77,-0.67,-1.42,-1.03,-1.49,-0.76,-0.29,-0.75,-0.05,1.37,4.75,8.76,11.47,11,10.36,7.62,5.97,5.83,6.63,8.21,7.87,6.45,4.96,3.87,2.95,2.32,2,1.99,2.22,2.63,3.24,3.88,4.59,5.21,5.66,5.98,6.12,6.11,6.02,6,6.03,6.15,6.34,6.48,6.50,6.47,6.39,6.41,6.62,6.95,7.28,7.89,7.37,7,6.71,7.02,7.50,6.89,6.16,7.41,7.62,6.76,6.91,9.11,10.28,10.35,9.38,9.47,9.53,9.62,9.66,9.66,11.64,13.63,13.63,14.62,13.62,13.62,12.62,11.62,10.62,10.62,9.62,9.62,9.62,9.62,9.62,9.62,9.62,9.64,9.65,9.66,9.66,9.61,9.48,9.37,8.25,7.16,7.10,7.01,6.97,6.89,6.86,6.78,6.75,7.72,7.66,7.63,8.62,8.61,8.59,8.57,8.52,8.52,8.51,8.51,8.52,9.47,9.39,9.34,9.27,10.25,10.24,11.23,10.23,10.24,10.25,10.32,10.37,10.45,9.40,9.14,8.96,9.62,9.38,9.15,10,9.82,9.58,9.37,10.15,10,9.87,9.78,9.72,9.62,9.51,8.85,8.73,8.87,9.37,11.13,11.12,11.12,12.13,14.15,14.22,14.26,14.37,14.47,15.58,15.58,15.59,16.62,16.72,16.82,15.96,16.11,17.32,17.51,18.75,19.01,20.20,20.37,20.59,20.83,21.08,21.37,22.41,22.38,19.37,17.35,15.34,15.33,14.33,14.32,14.32,14.25,13.22,12.20,12.16,11.16,11.20,11.23,10.25,10.28,10.28,10.28,10.33,10.37,10.47,10.57,10.66,10.84,10.87,10.86,10.86,11.85,11.73,11.60,11.39,11.25,12.12,12,12.87,13.84,14.76,14.75,15.74,15.73,15.75,15.72,15.70,16.64,15.51,14.37,14.25,14.14,13.10,11.02,11,11,11.01,11.08,12,11.85,11.64,11.50,12.36,13.25,14.14,15.08,17,18,18.99,17.97,18,17.03,17.12,18.22,18.33,19.46,20.50,20.51,20.50,20.52,20.53,20.50,21.47,20.40,21.41,21.45,21.48,21.50,21.60,22.66,22.78,22.89,23.07,23.25,23.45,23.65,23.87,23.99,24.11,24.24,24.37,24.52,25.73,25.90,];
}

function getTileMap()
{
	return [0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,0,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,3,3,3,3,3,3,3,0,3,3,3,3,3,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,3,3,3,3,3,3,3,3,0,3,3,3,3,3,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,2,2,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,2,2,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,2,2,2,2,2,2,2,2,1,2,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,2,2,2,2,2,2,2,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,2,1,2,2,2,2,2,2,1,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,2,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,2,2,2,2,2,2,1,1,1,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,2,2,2,2,1,1,1,1,5,7,7,7,7,7,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,2,2,2,1,1,1,2,1,1,1,1,1,1,1,1,1,1,6,6,6,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,7,5,5,5,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,2,2,2,2,1,1,1,5,5,5,7,7,7,7,7,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,4,4,1,1,4,2,2,4,2,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,7,7,7,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,2,2,2,1,1,1,1,5,5,5,5,5,7,5,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,4,4,4,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,5,5,5,7,7,7,7,7,7,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,5,5,5,1,7,7,7,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,1,2,4,2,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,7,7,7,7,7,7,7,1,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,5,5,5,1,7,7,7,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,4,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,7,7,7,7,7,7,7,7,5,5,1,1,7,7,7,1,1,1,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,5,1,1,7,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,7,7,7,7,1,1,5,1,1,1,1,7,1,1,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,7,4,4,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,4,1,4,4,4,4,4,1,4,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,7,7,7,7,7,1,1,1,1,1,1,1,1,1,7,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,1,1,1,1,1,1,1,6,1,1,1,1,1,6,6,1,1,1,1,1,1,1,2,1,2,2,2,2,1,1,1,1,1,1,1,1,4,4,4,4,7,7,1,1,1,1,1,1,1,1,1,1,1,1,2,1,2,2,2,2,2,1,1,1,1,2,2,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,2,1,1,1,1,1,1,1,4,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,5,1,5,5,7,7,7,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,3,3,3,3,3,3,3,3,3,0,3,3,3,0,1,1,1,1,1,1,1,6,6,6,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,4,4,4,4,7,7,7,7,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,2,1,1,1,1,1,2,1,4,4,4,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,5,1,7,7,7,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,0,1,1,1,1,1,1,1,6,6,6,6,4,6,6,6,6,6,6,1,6,6,6,6,1,1,1,2,1,1,1,1,1,1,1,1,4,4,4,4,4,7,7,7,7,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,2,2,2,1,2,2,2,2,2,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,2,1,7,7,7,7,7,7,7,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,0,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,4,1,4,4,4,4,4,7,7,4,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,2,1,1,2,2,2,2,2,2,2,2,2,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,1,4,1,2,2,7,1,7,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,3,3,3,3,3,3,3,3,3,3,0,1,1,1,1,1,1,1,1,4,4,6,4,6,6,4,4,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,2,2,2,2,2,2,2,2,2,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,4,1,1,1,4,1,1,1,1,1,1,2,2,1,1,2,1,1,1,2,2,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,4,4,4,4,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,3,3,3,3,3,3,3,3,3,3,0,1,1,1,1,1,1,1,1,4,4,4,4,1,4,4,4,4,6,6,6,1,6,6,6,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,2,2,2,2,2,2,1,1,2,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,2,1,2,2,2,2,1,2,2,2,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,2,1,2,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,3,3,3,3,3,3,3,3,3,0,0,0,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,6,1,6,6,6,6,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,2,1,2,2,4,4,4,1,4,4,4,4,4,4,4,4,4,4,4,1,4,1,4,1,1,1,1,1,2,1,2,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,3,3,3,3,3,3,3,3,0,0,0,0,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,1,6,6,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,6,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,2,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,4,4,4,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,4,4,4,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,2,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,3,3,3,3,3,3,3,0,0,0,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,5,5,5,5,5,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,2,2,2,2,2,2,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,4,1,1,1,1,1,4,1,1,4,1,4,1,4,4,4,4,4,4,4,4,4,4,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,3,3,3,3,3,3,0,0,0,0,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,6,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,1,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,4,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,3,3,3,3,3,3,3,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,6,2,2,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,1,1,5,1,1,1,5,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,4,4,4,1,1,1,1,1,1,2,1,1,2,2,2,2,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,2,2,2,2,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,4,2,2,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,3,3,3,3,3,3,3,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,6,6,6,1,6,6,6,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,4,1,1,1,4,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,3,3,3,3,3,3,3,3,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,6,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,5,5,5,5,7,5,1,5,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,2,2,2,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,3,3,3,3,3,3,3,3,3,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,6,6,6,6,6,1,1,1,1,1,2,2,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,7,5,5,5,7,7,7,1,1,1,1,1,1,1,2,1,2,2,2,2,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,2,2,2,5,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,2,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,3,3,3,3,3,3,3,3,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,5,5,5,7,7,7,1,1,2,2,1,2,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,2,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,3,3,3,3,3,3,3,3,3,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,1,1,7,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,6,1,1,1,2,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,5,5,7,5,7,1,1,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,3,3,3,3,3,3,3,3,3,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,7,7,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,7,7,7,7,5,5,7,7,7,1,1,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,2,2,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,3,3,3,3,3,3,3,3,3,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,7,7,1,1,2,7,7,5,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,6,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,7,7,7,7,7,7,7,7,5,5,1,1,2,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,7,7,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,7,7,7,7,7,7,7,7,7,5,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,1,1,1,1,7,7,7,7,7,7,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,7,7,7,7,1,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,2,2,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,7,1,1,1,1,1,1,1,1,7,7,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,7,7,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,5,7,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,2,1,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,1,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,7,7,7,1,1,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,2,2,2,2,1,1,1,1,1,1,7,7,1,1,1,1,1,1,1,2,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,7,7,7,7,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,4,4,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,2,2,2,2,1,5,5,1,1,7,7,7,7,7,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,5,1,1,7,1,7,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,7,7,7,7,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,2,2,2,2,1,2,2,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,2,2,2,2,5,5,5,5,7,7,7,7,7,7,7,1,1,1,1,2,5,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,1,5,7,7,7,7,7,7,7,5,7,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,7,7,7,1,1,1,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,2,2,1,2,1,1,4,4,4,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,5,5,7,7,7,7,5,7,7,1,5,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,1,5,7,7,7,5,7,7,7,7,7,7,7,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,2,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,2,2,2,4,4,4,4,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,7,1,2,2,2,2,2,1,1,1,1,7,7,7,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,1,1,7,7,7,5,5,5,5,7,7,5,7,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,7,7,7,7,2,2,2,2,1,1,1,1,7,7,7,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,1,7,7,7,7,5,5,5,5,5,5,5,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,2,1,2,2,2,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,7,7,7,7,7,2,2,2,1,1,1,1,1,7,7,7,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,7,7,7,7,1,1,5,5,5,5,5,5,1,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,2,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,4,4,4,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,7,2,2,1,1,1,1,7,7,7,7,7,7,2,2,1,1,1,1,1,1,7,7,7,5,5,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,7,7,7,1,7,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,2,2,5,1,1,1,1,1,1,4,4,4,4,4,4,4,1,4,4,4,4,4,4,4,4,4,4,1,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,7,7,7,7,7,1,1,7,7,7,7,7,7,7,2,2,7,1,1,1,1,1,1,7,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,2,1,1,1,1,1,7,7,7,7,7,7,7,7,7,7,1,1,1,1,1,1,2,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,5,5,5,1,1,1,1,1,1,4,4,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,4,4,4,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,2,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,7,7,7,7,7,7,7,7,7,7,1,7,2,2,7,7,7,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,1,1,4,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,2,2,1,2,2,2,1,1,1,1,7,7,7,7,7,7,7,7,7,1,1,2,2,1,1,2,2,5,5,5,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,5,1,2,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,4,4,1,4,4,4,4,4,4,4,4,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,3,3,3,3,0,3,3,3,3,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,7,7,7,7,7,7,7,7,1,1,1,1,2,1,7,1,1,1,1,1,1,1,1,5,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,4,1,4,4,4,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,4,1,4,4,4,4,1,4,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,7,1,1,1,7,7,7,7,1,2,2,2,2,2,2,2,5,5,5,5,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,5,5,5,5,5,5,2,1,5,5,5,5,1,5,1,1,1,1,1,1,1,4,4,4,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,7,1,7,7,7,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,5,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,1,4,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,7,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,2,2,1,1,1,7,7,7,1,1,1,2,2,2,2,2,2,1,5,5,5,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,5,5,5,5,7,5,1,1,5,5,5,5,1,5,5,5,1,1,1,1,1,1,1,4,1,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,3,3,3,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,4,4,1,1,1,5,5,5,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,4,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,7,7,7,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,2,2,2,2,2,2,1,1,1,7,1,1,1,1,1,2,2,2,2,2,5,5,5,5,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,5,5,7,7,7,5,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,3,3,3,0,0,0,3,3,3,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,4,4,4,4,1,4,4,5,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,7,7,7,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,4,1,1,4,4,4,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,5,5,7,7,7,7,5,1,1,5,1,1,5,1,1,1,1,1,1,1,1,1,4,4,4,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,3,3,3,3,3,0,0,3,3,3,3,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,4,4,4,4,4,4,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,5,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,2,2,2,1,2,1,1,2,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,5,5,5,5,5,5,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,4,4,4,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,4,4,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,3,3,3,3,3,3,3,0,0,3,3,3,3,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,4,4,4,4,4,4,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,7,7,7,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,2,2,2,2,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,2,2,2,2,5,5,5,5,5,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,4,4,4,1,1,1,1,1,1,1,5,5,5,1,6,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,3,3,3,3,3,3,3,3,0,3,3,3,3,3,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,5,7,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,2,2,2,2,5,5,5,5,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,4,4,4,4,4,1,1,1,1,1,5,5,5,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,2,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,3,3,3,3,3,3,3,3,0,0,3,3,3,3,3,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,7,5,5,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,1,1,5,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,1,5,5,1,1,1,5,5,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,3,3,3,3,3,3,3,3,0,3,3,3,3,3,3,3,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,2,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,2,2,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,5,5,5,5,1,5,5,5,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,2,2,2,2,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,5,7,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,6,6,6,1,1,1,1,1,1,1,1,2,1,2,1,2,1,1,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,7,7,7,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,1,1,4,4,1,1,1,1,1,1,1,5,5,5,1,5,5,5,5,1,1,1,6,6,6,1,1,1,1,1,1,1,2,2,2,2,2,1,2,1,1,1,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,4,1,4,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,2,2,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,5,5,7,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,4,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,5,1,1,1,5,5,5,1,1,6,6,6,6,1,1,1,1,1,1,1,1,2,1,2,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,5,5,5,5,1,1,1,1,1,1,1,1,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,5,5,1,1,1,5,5,5,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,5,5,5,7,7,7,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,4,5,1,1,1,1,5,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,5,5,5,5,1,1,1,1,1,1,6,1,7,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,5,5,5,5,5,5,5,1,1,5,5,5,5,5,5,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,5,5,5,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,3,3,3,3,3,0,0,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,5,1,5,5,5,1,1,1,1,1,6,6,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,5,5,5,5,5,5,7,5,5,5,5,5,5,1,5,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,2,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,4,4,4,4,5,1,1,1,5,1,6,6,6,6,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,5,1,1,5,5,5,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,0,0,0,0,3,3,3,3,0,0,0,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,5,5,5,5,5,5,1,1,1,1,1,7,6,6,7,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,5,5,5,1,7,7,7,5,5,5,5,5,1,1,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,1,1,4,1,1,1,1,5,5,5,1,6,6,1,1,1,1,1,1,1,2,2,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,3,3,3,0,3,3,3,0,0,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,5,1,5,5,5,7,7,1,7,7,7,7,6,6,1,1,1,1,1,1,7,7,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,7,7,7,7,7,5,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,1,1,1,1,5,1,1,5,5,5,5,1,1,1,1,1,1,1,2,2,2,2,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,5,5,1,5,1,5,5,5,5,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,4,5,5,1,1,1,1,5,7,7,7,7,7,7,7,7,1,6,1,1,1,1,1,7,7,7,7,7,1,7,1,1,1,1,2,2,2,2,1,2,1,1,1,1,1,1,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,2,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,1,1,7,5,5,5,5,1,5,5,5,1,1,1,1,1,1,2,2,2,2,2,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,2,2,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,5,5,5,5,1,1,5,7,7,7,7,7,1,7,1,1,6,6,6,1,1,1,7,7,7,7,7,1,7,7,7,1,1,1,2,2,2,2,2,2,2,1,7,1,1,1,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,1,7,7,7,7,5,5,5,5,5,1,1,1,1,1,1,2,2,2,2,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,5,5,1,1,5,5,5,7,6,1,1,1,6,6,1,6,6,6,1,1,7,7,7,7,1,1,1,1,7,1,1,1,7,2,2,2,2,2,2,2,7,7,7,1,1,1,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,7,7,7,7,7,7,7,7,5,5,1,1,1,1,1,1,2,2,2,2,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,1,7,5,6,6,6,6,1,6,6,6,6,6,6,1,1,7,1,7,1,1,1,1,1,1,1,1,1,7,7,7,2,2,2,2,2,2,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,7,5,7,7,7,7,7,1,1,1,1,1,1,1,2,2,2,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,1,7,7,6,6,6,6,6,1,6,1,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,7,1,1,2,7,1,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,1,6,6,1,7,7,5,1,1,1,1,1,1,2,2,2,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,7,7,7,7,6,7,6,7,6,1,7,7,7,7,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,2,2,2,1,1,1,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,1,1,1,1,1,1,1,5,1,1,1,1,1,1,2,2,2,2,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,1,7,7,7,7,7,6,7,7,7,7,7,7,7,7,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,2,2,2,2,2,1,1,1,1,1,7,7,7,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,2,2,2,2,2,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,1,0,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,7,7,1,1,1,6,7,6,7,6,1,7,1,6,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,7,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,6,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,4,4,4,4,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,2,1,1,1,2,2,2,1,2,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,7,1,1,1,1,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,1,1,1,1,7,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,4,4,4,4,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,2,1,1,1,1,1,4,4,4,1,1,1,1,1,4,4,1,1,1,1,1,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,2,2,1,2,2,2,2,2,2,2,1,1,1,7,7,7,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,2,2,2,2,2,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,2,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,2,7,2,1,1,1,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,1,6,5,5,5,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,4,4,1,1,4,4,4,4,4,4,4,1,2,2,2,2,2,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,2,2,2,1,1,1,1,1,1,1,4,4,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,5,5,5,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,4,1,4,1,4,4,4,4,4,4,4,4,4,4,1,4,4,4,4,1,1,2,2,2,2,2,2,2,1,2,1,1,1,1,1,1,1,1,6,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,2,1,1,2,1,1,1,1,1,1,1,4,4,4,1,1,1,1,4,4,4,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,2,5,7,7,5,5,5,5,5,5,5,1,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,2,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,2,7,2,1,1,1,1,1,1,1,1,1,5,5,5,1,5,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,1,1,5,1,1,5,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,4,1,1,4,4,4,4,4,1,4,4,4,4,4,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,6,6,6,1,6,1,1,1,1,1,1,1,1,1,2,1,2,2,2,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,4,4,4,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,3,3,3,3,3,3,3,3,3,3,0,0,1,1,1,1,1,1,1,1,1,1,2,2,1,1,5,5,5,5,7,7,7,7,7,7,5,5,5,5,5,5,5,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,5,1,5,5,5,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,6,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,4,4,1,4,1,4,1,4,1,4,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,4,4,4,4,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,3,3,3,3,0,3,3,3,3,0,0,0,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,5,5,2,5,7,7,7,7,7,7,5,5,5,5,5,5,5,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,5,1,1,1,5,5,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,7,1,1,1,1,1,1,1,1,1,1,5,5,5,7,5,5,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,4,4,4,1,1,4,4,4,4,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,0,3,3,3,3,0,3,3,3,3,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,7,7,7,7,1,1,1,5,5,5,5,5,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,2,5,5,5,5,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,4,4,1,5,5,5,5,7,7,7,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,1,5,5,5,5,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,4,1,4,4,4,1,2,2,4,4,4,5,5,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,0,3,3,3,3,0,3,3,3,3,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,1,1,1,1,2,2,5,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,7,5,5,5,5,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,7,1,1,4,1,4,4,4,5,5,5,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,2,2,2,1,2,1,2,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,2,2,2,2,4,5,5,5,5,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,0,3,3,3,3,0,0,3,3,3,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,5,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,7,7,1,7,7,7,5,5,5,5,2,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,7,7,7,4,4,4,4,4,4,5,7,7,7,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,4,1,4,1,1,1,2,2,2,5,4,5,5,5,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,0,3,3,3,3,3,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,7,5,5,5,5,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,5,7,7,7,7,1,7,5,5,5,5,5,5,5,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,4,7,7,7,4,4,1,4,1,5,7,7,7,7,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,2,2,1,2,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,5,5,5,4,5,4,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,0,3,3,3,3,3,0,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,7,7,7,7,5,7,7,7,5,5,5,7,7,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,4,1,4,7,4,4,4,1,1,1,5,7,7,7,7,1,5,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,5,2,5,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,0,3,3,3,3,3,0,0,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,7,7,7,7,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,5,7,5,5,7,5,7,7,7,7,7,7,7,7,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,4,4,1,1,1,1,5,7,7,7,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,2,2,2,2,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,0,3,3,3,3,3,3,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,5,5,5,5,1,5,1,1,1,5,5,1,1,1,7,7,7,5,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,1,5,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,1,1,7,7,7,5,5,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,5,1,5,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,3,3,3,3,3,3,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,7,1,5,5,5,1,5,5,5,5,5,5,5,5,5,7,7,7,5,5,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,5,5,7,7,7,7,7,7,7,7,7,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,1,1,1,1,1,1,7,5,5,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,3,3,3,3,3,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,2,2,1,7,7,7,1,5,5,5,1,5,5,5,5,5,5,5,5,5,7,7,7,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,7,7,7,5,5,7,7,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,4,4,1,4,4,4,4,1,1,1,1,1,1,7,1,1,2,2,2,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,4,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,2,2,2,1,7,7,1,7,5,1,1,1,5,5,5,5,5,5,5,7,7,7,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,7,1,7,7,1,1,5,1,1,1,7,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,1,1,1,1,1,7,7,7,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,2,1,1,7,7,7,7,7,7,1,5,5,5,5,5,5,1,5,7,7,7,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,7,7,7,7,7,1,1,1,1,1,7,7,7,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,4,1,1,1,1,1,1,1,7,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,2,2,2,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,7,7,7,7,5,5,5,5,1,1,1,7,7,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,7,7,7,7,1,7,1,1,1,1,1,1,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,7,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,2,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,4,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,7,5,5,7,7,1,7,7,7,7,7,1,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,4,4,4,4,4,1,1,1,1,1,4,4,4,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,7,7,7,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,6,5,5,7,7,7,7,7,7,7,7,6,1,6,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,1,1,4,4,4,4,4,1,4,4,4,4,1,1,1,1,1,1,1,1,1,7,7,7,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,4,4,4,4,4,4,4,4,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,6,5,5,7,7,7,7,7,6,6,6,6,6,6,1,1,1,1,1,1,1,2,1,1,1,2,2,1,1,1,1,1,1,1,4,4,7,4,4,1,1,1,1,1,1,1,1,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,4,4,4,1,1,1,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,7,7,7,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,4,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,6,6,6,6,1,7,7,6,7,7,6,6,1,6,1,1,1,1,1,1,1,2,2,2,1,2,2,2,2,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,4,4,4,1,1,1,4,4,4,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,2,7,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,4,6,7,7,7,7,1,1,1,1,1,1,1,1,1,2,2,2,1,2,2,2,2,2,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,7,1,1,7,1,1,1,1,1,1,1,1,1,1,4,4,4,1,4,4,4,4,4,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,4,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,5,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,0,0,0,0,0,1,1,1,0,1,1,0,0,0,0,0,0,0,3,3,3,3,3,3,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,1,1,7,7,7,7,7,7,7,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,7,7,7,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,4,4,4,1,4,1,4,4,4,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,2,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,3,3,3,3,3,3,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,7,7,7,4,7,7,7,1,1,2,2,1,1,1,2,7,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,7,7,7,7,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,4,1,1,1,1,1,1,1,4,4,4,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,4,4,4,1,4,4,4,1,4,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,2,2,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,1,4,4,4,7,1,1,2,2,2,2,2,2,7,7,7,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,4,1,1,1,1,4,1,1,1,4,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,1,1,1,1,1,1,1,1,1,2,2,2,2,2,7,7,7,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,1,1,1,1,1,1,1,4,4,4,4,4,1,4,4,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,5,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,3,3,3,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,7,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,4,5,5,5,5,5,5,5,5,1,1,5,5,5,5,5,5,1,5,5,1,5,1,5,5,5,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,3,3,3,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,4,4,5,5,5,1,5,1,5,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,3,3,3,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,4,4,4,1,5,1,1,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,4,4,4,1,1,1,4,1,4,1,1,1,4,1,4,4,4,4,4,2,2,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,4,4,4,4,4,4,4,4,4,4,4,4,4,2,4,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,2,1,1,2,2,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,4,4,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,4,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,4,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,4,4,4,4,4,1,4,4,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,2,2,1,1,2,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,3,3,3,3,3,3,3,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,7,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,2,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,2,2,2,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,3,3,3,3,3,3,3,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,7,7,7,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,2,1,1,2,1,1,1,1,1,2,2,2,1,1,5,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,3,3,3,3,3,3,3,3,0,1,1,1,1,1,1,1,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,7,7,7,7,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,4,4,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,2,2,5,1,5,5,7,7,5,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,3,3,3,3,3,3,3,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,7,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,4,4,4,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,5,5,2,5,5,5,5,7,7,7,7,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,3,3,3,3,3,3,3,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,7,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,7,7,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,4,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,5,5,5,5,5,5,5,7,7,7,7,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,0,0,0,3,3,3,3,3,3,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,7,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,5,5,7,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,2,2,2,5,5,5,5,5,5,7,5,7,7,7,7,5,5,5,5,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,2,2,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,3,3,3,3,3,0,0,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,5,7,5,5,7,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,5,5,7,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,2,2,2,7,7,5,5,5,7,7,7,7,1,5,7,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,6,6,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,3,3,3,3,3,0,0,1,1,1,1,1,2,1,2,2,2,5,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,7,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,5,5,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,7,5,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,2,2,2,2,2,2,1,2,1,2,2,2,7,7,7,7,7,7,7,7,7,2,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,1,1,2,2,2,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,3,3,3,3,3,0,0,1,1,1,1,1,2,2,1,2,5,5,5,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,0,0,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,7,7,7,5,5,5,5,5,5,5,5,1,1,1,1,1,5,5,5,5,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,1,7,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,5,2,5,7,7,7,7,7,7,7,5,2,2,5,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,3,3,3,3,3,0,0,1,1,1,1,1,1,1,1,2,5,5,5,2,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,7,4,4,7,1,1,5,5,5,5,5,5,1,1,1,1,1,1,5,5,5,1,1,1,5,5,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,5,2,1,5,5,5,1,5,7,7,7,7,5,5,2,2,2,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,3,3,3,3,3,0,0,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,7,7,7,4,4,1,1,1,5,5,5,5,5,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,5,5,2,5,5,5,5,5,5,1,1,7,7,7,1,5,1,1,1,2,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,3,3,3,3,3,0,0,0,0,0,1,1,1,1,1,1,1,5,5,5,5,1,5,1,1,5,5,5,7,7,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,7,7,4,4,4,1,1,1,5,5,5,5,5,5,1,1,1,5,5,5,1,1,1,1,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,5,5,5,5,5,5,1,1,5,1,1,1,1,7,1,1,1,1,1,1,1,2,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,0,0,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,3,3,3,3,3,3,0,0,0,0,0,1,1,1,1,1,1,1,5,5,5,5,5,7,5,7,7,7,7,7,7,7,5,7,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,4,4,4,4,1,1,5,5,5,7,5,7,7,5,5,5,5,5,5,1,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,7,1,1,1,1,1,1,2,2,2,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,3,3,3,3,3,3,0,0,0,0,0,0,1,1,1,1,1,1,1,5,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,1,4,4,4,4,1,1,5,7,7,7,7,7,7,5,5,5,5,5,1,7,1,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,1,1,1,1,1,5,1,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,7,7,7,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,3,3,3,3,3,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,7,1,7,7,7,1,7,1,7,1,7,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,1,1,1,4,4,1,1,1,7,7,7,7,7,7,5,7,5,5,7,5,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,1,1,1,5,5,5,1,1,1,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,7,1,1,1,1,1,2,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,7,7,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,1,1,1,1,1,1,1,7,1,1,7,7,7,7,7,7,7,7,7,7,7,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,1,1,1,5,5,5,5,5,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,1,1,1,1,1,2,2,2,1,1,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,4,4,1,1,1,1,5,5,5,5,7,7,7,7,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,1,1,1,1,1,1,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,1,1,1,1,1,1,2,2,2,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,1,1,5,5,5,5,5,5,7,7,7,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,7,7,1,1,7,1,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,1,1,1,1,1,2,1,2,1,1,1,7,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,5,5,5,5,5,7,7,7,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,7,1,5,5,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,7,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,7,1,1,1,1,1,1,1,2,1,2,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,7,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,4,1,4,1,1,1,7,7,7,1,1,1,1,1,2,2,2,1,1,1,1,1,1,6,6,6,6,6,6,6,6,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,5,1,5,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,7,7,7,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,4,4,4,1,1,1,1,1,1,1,1,7,1,1,1,2,1,1,1,2,2,2,1,1,1,1,1,6,6,6,6,6,6,1,6,6,6,6,6,1,1,1,1,1,1,1,4,1,1,1,5,5,5,5,5,5,5,5,5,5,5,7,5,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,2,2,2,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,4,1,1,1,1,1,7,1,1,1,1,1,1,2,2,2,1,1,2,2,2,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,7,4,4,4,1,1,5,5,5,5,5,5,5,5,7,5,7,7,7,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,7,7,7,7,1,1,1,1,1,1,1,1,1,2,2,2,2,1,2,2,2,2,1,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,7,7,7,1,2,1,1,1,1,2,1,1,2,2,2,2,1,1,1,1,6,6,6,6,6,1,6,1,6,6,6,6,1,1,1,1,1,7,7,7,4,4,1,1,1,5,1,5,5,5,7,7,7,7,1,7,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,7,7,4,4,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,1,1,7,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,7,2,2,2,2,1,1,1,2,1,2,2,2,2,1,1,1,1,1,6,6,6,6,1,1,1,1,1,6,6,6,6,1,1,1,6,6,7,4,4,4,1,1,1,1,1,5,7,7,7,7,7,5,5,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,2,2,2,1,1,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,7,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,6,6,6,6,1,6,1,6,7,6,6,6,6,6,6,6,6,6,6,4,4,4,1,1,1,1,1,7,7,7,7,5,5,5,5,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,1,2,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,2,2,2,2,1,1,1,1,1,1,1,1,2,2,1,2,2,2,2,7,7,7,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,7,1,1,1,1,1,1,2,2,1,2,2,2,2,2,2,1,2,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,7,7,7,6,6,6,6,6,6,6,6,4,4,4,4,4,4,1,1,7,7,7,5,1,5,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,3,3,3,3,3,3,3,3,3,3,0,0,3,3,3,3,3,0,0,0,0,1,1,1,1,1,1,1,1,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,2,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,2,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,7,1,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,7,7,7,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,2,1,1,1,1,1,1,1,1,7,6,1,6,1,6,7,1,1,1,6,1,6,6,6,1,1,4,4,4,4,4,4,1,4,7,1,4,1,4,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,3,3,3,3,3,3,3,3,3,0,0,0,3,3,3,3,3,0,0,0,0,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,2,2,2,2,1,2,1,2,1,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,7,1,1,7,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,1,1,1,1,1,1,1,2,2,2,1,1,1,2,1,1,2,2,2,2,2,1,1,7,1,7,7,7,1,1,1,6,6,6,6,6,6,6,1,4,4,1,4,4,4,4,4,4,4,7,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,3,3,3,3,3,3,3,3,0,0,0,0,3,3,3,3,3,3,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,2,2,2,1,2,1,1,2,2,2,2,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,6,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,7,7,7,7,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,2,2,2,2,2,7,7,7,6,7,6,6,6,6,6,6,6,6,6,6,1,4,4,4,4,4,4,4,4,4,4,7,7,7,1,1,4,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,3,3,3,3,3,3,3,3,3,0,0,0,0,0,3,3,3,3,3,3,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,5,2,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,2,2,2,2,1,4,4,1,2,2,2,2,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,2,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,7,7,7,7,1,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,5,5,5,2,1,1,1,1,7,7,1,7,1,1,7,2,1,6,7,7,6,6,6,6,6,6,6,6,6,6,6,1,1,4,4,4,4,4,4,4,4,1,4,4,7,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,3,3,3,3,3,3,3,3,3,0,0,0,0,0,3,3,3,3,3,3,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,1,1,1,2,2,2,4,4,4,4,4,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,6,6,6,6,6,6,1,6,6,2,2,6,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,2,2,2,2,2,1,2,2,2,7,7,7,2,1,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,7,7,7,7,7,7,7,7,7,5,6,7,7,7,1,6,6,6,6,1,1,6,1,1,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,3,3,3,3,3,3,3,3,0,0,1,0,0,0,3,3,3,3,3,3,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,5,5,5,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,3,3,3,3,3,3,3,3,3,3,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,1,1,2,4,4,4,4,4,4,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,7,2,2,2,7,7,7,1,1,1,1,1,1,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,5,7,7,5,7,5,7,7,7,7,1,7,7,7,7,5,5,5,1,7,1,1,1,1,1,1,6,6,6,4,4,4,4,4,1,1,4,4,4,4,4,1,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,3,3,3,3,3,3,3,3,0,0,1,0,0,0,3,3,3,3,3,3,0,0,0,0,1,1,1,1,1,1,1,1,5,5,5,7,7,7,7,7,7,5,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,3,3,3,3,3,3,3,3,3,3,3,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,4,1,1,4,4,4,4,2,2,2,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,1,6,6,6,6,6,1,6,6,1,6,6,6,2,2,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,7,1,1,1,1,1,1,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,7,7,7,7,7,5,7,1,1,5,1,7,5,5,5,5,5,5,1,1,1,1,1,1,6,6,6,6,6,4,4,4,1,1,1,1,1,4,4,4,4,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,3,3,3,3,3,3,3,3,0,0,1,1,0,0,0,3,3,3,3,3,0,0,0,0,1,1,1,1,1,1,1,5,5,5,5,5,7,7,7,7,7,7,5,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,3,3,3,3,3,3,3,3,3,3,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,6,2,2,2,6,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,2,2,2,2,2,2,1,2,2,2,2,1,1,1,1,1,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,7,7,7,7,7,5,5,5,1,5,5,5,1,5,5,5,2,5,6,1,1,1,1,1,6,6,6,6,6,4,4,4,1,1,1,1,1,1,1,4,4,4,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,3,3,3,3,3,3,3,3,3,0,1,1,0,0,0,0,3,3,3,3,3,0,0,0,1,1,1,1,1,1,1,1,5,5,5,5,1,5,7,5,7,5,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,3,3,3,3,3,3,3,3,3,3,3,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,4,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,6,6,6,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,2,2,2,2,2,2,2,2,2,2,2,1,2,2,2,1,1,7,1,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,5,7,7,7,7,7,5,5,5,5,1,1,5,5,5,5,5,5,1,1,6,6,6,6,1,6,6,6,6,4,4,4,4,4,4,1,1,1,1,1,1,1,1,4,1,1,1,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,3,3,3,3,3,3,3,3,0,1,1,0,0,0,0,3,3,3,3,3,3,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,3,3,3,3,3,3,3,3,3,3,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,6,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,2,1,1,7,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,5,7,7,7,5,5,1,7,1,1,1,1,1,5,5,5,5,1,1,1,6,6,6,6,6,6,6,6,4,4,4,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,5,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,3,3,3,3,3,3,3,3,0,0,1,1,0,0,0,0,0,3,3,3,3,3,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,3,3,3,3,3,3,3,3,3,3,3,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,2,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,2,1,1,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,5,1,7,5,5,5,7,7,7,1,5,1,1,1,5,5,5,5,1,1,1,6,6,6,6,6,6,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,5,5,5,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,0,0,0,3,3,3,3,3,3,3,3,0,0,0,1,0,0,0,0,0,3,3,3,3,3,3,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,3,3,3,3,3,3,3,3,3,3,3,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,2,2,2,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,5,1,1,7,1,5,5,5,1,5,5,5,5,5,1,1,1,1,6,6,6,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,1,1,0,0,0,3,3,3,3,3,3,3,3,3,0,0,1,1,0,0,0,0,0,3,3,3,3,3,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,2,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,1,1,7,1,1,1,1,1,1,1,5,1,1,1,5,1,5,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,0,0,0,3,3,3,3,3,3,3,3,0,0,0,1,0,0,0,0,0,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,1,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,2,1,1,1,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,7,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,7,7,7,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,3,3,3,3,3,3,3,3,0,0,0,1,1,0,0,0,0,0,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,1,1,7,1,1,1,1,1,1,1,7,7,7,1,1,1,1,1,1,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,7,5,5,5,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,3,3,3,3,3,3,3,3,3,0,0,0,1,1,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,1,1,1,1,7,7,7,7,7,7,1,1,1,1,1,1,1,7,1,1,1,1,1,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,3,3,3,3,3,3,3,3,3,0,0,0,1,1,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,7,1,1,1,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,7,7,5,5,5,5,5,5,5,5,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,0,0,0,1,1,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,3,3,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,7,7,7,1,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,7,7,7,7,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,3,3,3,3,3,3,3,3,3,0,0,0,1,1,1,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,6,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,1,1,1,1,1,1,1,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,7,7,7,7,5,5,5,5,5,5,5,1,1,5,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,3,3,3,3,3,3,3,0,0,0,0,1,1,1,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,7,7,5,5,5,5,5,5,5,1,1,1,1,1,1,5,5,5,5,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,3,3,3,3,3,3,3,0,0,0,0,1,1,1,1,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,6,6,6,6,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,5,5,5,6,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,3,3,3,3,3,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,6,6,6,1,6,1,1,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,5,5,6,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,3,3,3,3,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,0,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,5,1,5,5,5,1,1,1,1,1,1,6,1,1,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,7,7,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,3,3,3,3,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,5,1,5,5,5,5,5,5,1,1,1,6,1,1,1,1,1,1,1,6,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,7,7,7,7,1,7,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,3,3,3,3,3,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,7,7,7,7,7,1,5,1,5,5,1,1,1,6,6,6,1,1,6,1,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,7,7,1,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,3,3,3,3,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,7,7,7,7,7,7,7,1,1,1,1,1,6,6,1,6,6,1,6,6,6,6,6,6,6,6,6,6,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,4,1,1,1,4,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,3,3,3,3,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,7,2,2,2,5,5,5,7,7,7,7,7,1,7,1,1,1,6,6,6,6,6,6,6,1,6,1,6,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,3,3,3,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,7,7,7,7,5,5,5,5,5,5,7,1,1,7,7,7,1,1,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,5,1,5,5,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,4,4,4,1,4,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,3,3,3,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,7,7,7,7,7,5,5,5,5,7,7,7,1,1,7,7,1,1,1,6,1,6,6,2,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,5,5,1,5,5,5,5,5,5,5,7,5,1,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,4,1,1,1,1,1,4,1,1,1,1,1,1,1,7,7,7,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,3,3,3,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,7,7,7,7,7,7,5,5,7,7,7,7,1,1,1,7,7,7,1,1,1,2,2,2,2,2,2,2,2,1,2,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,5,5,5,5,5,5,5,5,5,1,7,7,7,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,4,4,1,1,4,4,1,4,1,1,4,4,4,7,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,4,1,4,1,1,1,1,2,2,1,2,7,7,7,7,7,2,2,2,1,1,1,1,1,1,1,1,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,3,3,3,0,0,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,7,1,1,7,7,7,7,7,7,7,1,1,1,1,1,7,7,7,1,2,2,2,2,2,2,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,5,5,5,5,5,5,5,1,1,1,7,1,5,5,5,5,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,4,7,7,7,5,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,4,4,4,4,4,4,4,4,4,1,1,2,2,2,2,5,5,7,7,7,7,7,2,2,1,1,1,1,1,1,1,1,7,7,7,1,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,3,3,3,0,0,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,7,7,7,1,1,7,1,7,7,7,1,1,1,1,1,1,7,7,7,1,2,2,2,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,1,5,1,1,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,5,7,7,7,5,5,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,4,4,4,4,4,1,4,1,4,1,1,2,2,2,2,5,5,7,7,7,1,7,2,2,2,2,2,2,1,1,1,1,1,1,7,1,1,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,3,3,3,0,0,0,1,1,1,1,1,1,1,1,2,2,2,2,2,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,7,7,1,1,7,7,7,7,7,1,1,1,1,1,1,1,7,1,1,2,2,2,2,1,1,2,2,2,2,2,1,1,7,1,1,5,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,5,5,5,5,5,5,5,1,5,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,4,4,4,4,4,1,1,1,1,1,1,1,5,7,7,7,5,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,2,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,4,1,1,4,4,4,1,1,1,1,1,1,1,2,2,2,1,2,2,5,5,7,1,2,5,7,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,3,3,3,3,0,0,1,1,1,1,1,1,1,1,1,5,2,2,2,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,7,7,7,7,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,2,2,2,2,2,2,5,7,7,7,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,7,7,7,1,5,5,5,5,5,1,1,1,1,1,5,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,4,4,4,4,1,1,1,1,1,1,1,1,7,7,7,7,5,5,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,2,2,2,1,2,2,2,2,1,1,1,1,1,1,1,4,1,1,1,4,4,4,1,1,1,1,1,1,1,2,2,2,1,1,1,2,2,2,2,2,5,7,7,7,1,1,5,2,2,1,1,7,1,1,1,1,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,3,3,3,3,0,0,1,1,1,1,1,1,1,1,5,5,5,2,2,2,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,7,1,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,2,5,5,5,7,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,2,2,2,1,2,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,7,5,5,7,1,1,1,5,5,5,5,1,1,1,1,1,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,4,4,4,4,1,1,1,1,1,1,1,1,7,7,7,7,5,5,1,5,1,5,1,5,5,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,4,4,4,1,4,4,4,1,1,1,1,1,1,1,1,1,2,1,1,1,2,2,2,2,2,1,2,5,7,1,5,5,5,5,1,1,7,7,7,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,0,0,3,3,3,3,0,0,0,1,1,1,1,1,1,1,1,5,5,2,2,5,5,5,5,5,5,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,2,1,5,5,7,7,7,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,2,2,2,1,1,1,1,1,1,1,1,1,5,5,7,7,7,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,7,7,7,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,4,4,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,7,1,2,1,5,5,5,5,5,1,7,1,7,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,3,3,3,0,0,0,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,2,2,5,5,5,5,7,5,7,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,2,2,2,2,2,2,1,2,2,2,2,1,1,1,7,5,7,5,7,5,5,1,1,1,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,5,7,7,7,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,4,4,4,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,7,7,7,2,2,1,5,1,5,5,7,7,7,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,3,3,3,3,0,0,0,1,1,1,1,1,1,1,1,5,2,5,7,7,7,7,5,5,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,2,1,5,5,1,1,7,7,7,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,1,7,7,7,7,7,5,5,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,4,4,4,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,7,1,2,1,1,1,1,1,7,7,7,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,3,3,3,3,0,0,0,0,1,1,1,1,1,1,1,1,5,7,7,7,7,7,7,5,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,7,7,7,7,7,5,5,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,5,7,7,7,7,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,5,7,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,2,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,3,3,3,0,0,0,0,0,1,1,1,1,1,1,1,1,5,7,7,7,7,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,2,1,1,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,5,5,7,7,7,7,7,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,1,1,7,7,7,1,5,5,5,5,5,5,5,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,2,1,1,1,1,1,1,1,1,1,1,0,0,3,3,3,3,3,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,5,5,7,7,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,1,7,7,1,1,1,7,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,3,3,3,3,3,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,7,7,7,5,7,7,7,1,1,1,1,1,1,1,1,1,5,1,1,1,1,5,7,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,2,2,2,2,2,1,1,1,1,1,1,7,7,7,1,2,2,2,2,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,5,5,7,7,7,1,1,1,1,1,1,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,7,7,7,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,3,3,3,3,3,3,0,0,0,0,0,1,1,1,1,1,1,1,1,1,7,7,7,5,5,5,5,5,1,1,1,1,1,1,1,5,5,5,1,1,5,7,7,7,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,2,2,2,2,2,2,1,1,1,1,1,7,7,7,2,2,2,2,2,2,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,6,6,6,1,6,1,6,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,7,5,7,7,7,7,7,1,1,5,5,7,5,7,1,1,1,1,1,1,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,1,7,7,1,1,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,0,1,0,1,1,1,1,1,1,1,1,0,0,0,3,3,3,3,3,3,0,0,0,0,0,0,1,1,1,1,1,1,1,1,7,7,7,1,5,5,5,5,5,1,1,1,1,1,1,5,5,5,5,7,7,7,7,7,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,2,2,2,2,2,1,1,1,1,1,1,7,7,7,2,2,2,2,1,1,1,1,1,1,1,1,1,6,6,1,1,1,6,1,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,7,7,7,5,7,5,2,2,1,1,1,5,5,7,7,7,1,1,1,1,1,1,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,7,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,2,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,3,3,3,3,3,3,0,0,0,0,0,0,1,1,1,1,1,1,1,7,7,7,6,6,6,5,5,5,5,1,1,1,1,1,1,5,5,7,7,7,7,7,5,5,5,1,5,5,5,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,2,1,1,2,1,2,2,2,2,2,2,2,2,2,1,2,2,2,2,1,1,1,1,1,2,1,2,7,2,2,2,2,2,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,1,6,1,6,1,1,6,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,7,5,5,5,5,2,2,2,1,1,1,1,5,7,1,1,7,1,1,1,7,1,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,1,1,7,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,3,3,3,3,3,3,3,0,0,0,0,0,1,1,1,1,1,1,1,1,7,1,6,6,6,1,1,5,1,1,1,1,1,1,1,1,1,5,7,7,5,5,7,7,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,2,1,1,2,2,2,2,2,1,2,1,2,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,6,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,7,2,5,2,5,5,5,2,2,2,1,1,1,1,1,1,7,7,7,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,7,7,7,7,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,3,3,3,3,3,3,3,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,6,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,2,1,2,2,2,2,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,7,7,7,2,5,5,5,2,2,2,2,2,1,1,1,1,1,1,7,1,7,1,7,1,1,1,1,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,7,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,0,0,0,0,0,1,1,1,1,1,1,1,1,6,6,6,1,1,5,1,1,1,1,1,1,1,1,1,1,2,1,7,7,7,7,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,2,2,2,2,2,2,1,1,2,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,2,7,2,2,2,5,2,2,2,2,2,1,1,1,1,1,1,1,1,7,7,7,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,1,7,7,7,1,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,1,1,1,1,1,1,1,6,6,6,5,5,5,1,1,1,1,1,1,2,2,2,2,7,7,7,7,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,2,1,1,2,2,2,2,1,1,1,1,1,1,2,2,1,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,2,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,2,7,2,2,2,2,2,1,2,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,1,1,1,7,5,5,5,5,5,5,5,5,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,6,6,6,5,1,1,1,1,1,1,2,2,2,7,7,7,7,7,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,2,2,2,2,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,7,7,7,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,1,7,7,7,5,5,5,5,5,5,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,2,2,7,7,7,7,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,2,2,2,1,2,1,2,2,1,2,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,1,1,7,5,5,5,5,5,5,1,1,1,1,5,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,0,0,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,2,2,2,2,1,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,2,2,2,2,2,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,1,1,2,2,2,6,2,6,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,2,2,2,2,2,2,2,2,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,1,1,5,5,5,7,7,7,1,1,1,5,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,2,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,1,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,2,2,2,2,2,2,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,2,2,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,1,1,7,7,7,7,7,7,7,5,5,5,5,1,5,5,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,4,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,2,2,2,2,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,1,6,6,6,5,7,1,1,7,7,7,7,7,7,7,5,5,5,5,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,6,1,1,1,6,1,1,1,6,1,1,1,1,1,1,1,1,1,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,4,4,4,4,4,1,1,1,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,2,2,2,2,2,1,2,2,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,6,6,6,6,5,5,5,5,5,5,7,7,7,5,1,5,1,5,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,3,3,3,3,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,2,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,5,5,5,5,1,1,5,5,7,5,5,5,5,5,5,5,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,4,4,4,4,4,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,2,1,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,1,1,5,5,1,1,1,1,5,5,5,5,5,5,5,5,5,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,1,1,1,1,1,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,5,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,7,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,1,1,1,1,1,1,6,6,6,1,1,1,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,5,5,5,5,5,5,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,7,7,7,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,7,7,7,1,1,1,1,1,1,1,1,6,6,6,6,6,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,2,2,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,2,1,2,2,2,2,2,1,1,1,1,1,5,5,5,5,5,7,5,5,5,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,5,7,7,7,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,0,0,0,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,7,7,7,7,7,7,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,2,4,1,2,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,2,1,1,1,1,1,5,5,5,5,5,7,7,7,5,5,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,7,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,0,0,0,0,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,7,7,7,7,7,1,7,7,7,1,1,1,1,1,6,6,6,6,6,6,6,6,6,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,2,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,4,4,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,7,7,7,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,1,1,7,7,7,4,4,4,4,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,7,7,7,7,7,7,7,7,7,1,1,1,6,6,6,6,6,1,6,6,6,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,4,1,4,2,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,2,2,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,7,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,7,5,7,4,4,4,4,4,4,4,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,1,1,1,1,0,0,0,0,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,7,7,7,7,7,7,7,1,1,1,6,6,6,1,1,1,1,1,6,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,7,7,7,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,7,7,7,5,5,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,1,1,1,1,0,0,0,0,0,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,7,7,7,7,1,1,1,1,1,1,1,6,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,5,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,6,6,6,1,6,6,6,6,6,1,1,1,1,1,2,2,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,7,7,7,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,7,5,5,5,5,4,4,4,4,4,1,4,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,4,4,4,4,4,4,4,1,1,1,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,5,5,5,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,4,4,4,4,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,7,7,7,7,7,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,5,5,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,4,4,4,4,4,1,1,1,6,6,6,6,6,6,6,1,6,6,6,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,7,7,7,7,7,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,7,5,5,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,4,1,4,4,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,7,7,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,6,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,5,5,7,5,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,2,2,2,1,1,5,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,2,1,1,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,4,4,4,1,4,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,5,5,5,5,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,2,2,2,2,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,4,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,7,1,1,1,1,7,7,7,1,1,5,5,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,2,1,1,1,1,5,7,5,5,5,1,5,1,5,5,1,1,1,1,1,1,1,1,7,1,1,1,1,2,2,2,7,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,2,6,1,1,1,1,6,6,6,1,1,1,6,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,5,7,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,4,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,7,7,7,1,1,7,7,7,7,1,5,5,5,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,7,7,7,5,5,5,5,5,5,5,5,1,1,1,1,7,7,7,7,7,2,2,1,2,2,7,7,7,7,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,6,6,6,6,6,1,1,1,1,6,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,7,1,1,1,1,7,7,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,2,1,1,1,1,1,1,1,0,0,0,1,1,1,1,0,0,0,3,3,3,3,0,0,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,7,7,7,1,1,5,5,5,5,5,5,1,1,1,1,7,7,7,7,7,7,2,2,2,2,2,7,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,6,6,6,6,6,2,2,1,1,2,1,1,1,1,1,1,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,2,2,2,1,1,1,1,1,1,1,0,0,1,1,1,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,7,1,5,1,5,5,5,5,1,1,1,1,1,1,7,7,7,7,7,7,2,2,1,1,2,2,7,7,7,7,7,7,1,7,5,7,1,5,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,7,7,7,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,6,6,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,1,5,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,2,2,2,1,1,1,1,1,1,1,1,0,0,1,1,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,7,5,5,5,5,5,5,1,1,1,7,7,7,7,7,7,7,7,7,7,7,1,1,1,1,1,2,2,1,7,7,7,7,7,7,7,7,7,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,7,7,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,5,5,5,5,5,5,1,7,7,7,7,7,7,7,7,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,7,5,7,5,7,7,7,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,1,7,7,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,2,2,6,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,1,1,5,5,1,1,1,1,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,5,5,5,5,5,1,1,7,7,7,7,7,7,7,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,7,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,6,6,6,2,2,1,1,1,1,2,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,7,7,1,1,2,5,5,5,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,0,0,0,3,3,3,3,3,3,0,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,7,5,5,5,1,1,1,1,7,7,7,7,7,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,6,2,2,2,2,1,2,2,2,2,1,4,4,4,4,4,4,1,4,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,2,2,2,5,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,0,0,0,3,3,3,3,3,0,3,3,3,3,3,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,2,2,1,1,7,7,7,7,7,7,7,1,1,1,1,1,1,7,7,7,1,1,1,1,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,5,1,5,1,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,6,2,2,2,2,2,2,2,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,2,2,2,2,2,2,1,2,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,7,1,7,7,7,1,1,1,1,1,1,1,1,7,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,6,6,6,1,1,2,1,2,4,1,4,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,2,2,1,2,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,3,3,3,3,3,3,3,3,0,0,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,2,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,2,2,2,2,2,1,1,6,6,6,1,1,1,1,4,4,4,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,2,1,2,2,2,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,3,3,3,3,3,3,3,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,2,1,1,1,1,1,1,6,1,1,1,1,1,4,4,4,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,2,2,2,2,1,2,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,4,2,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,0,0,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,3,3,3,3,3,3,3,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,4,4,4,4,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,4,4,4,2,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,3,3,3,3,3,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,2,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,4,4,4,4,1,1,4,4,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,0,0,0,3,3,3,3,3,3,3,3,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,2,1,2,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,3,3,3,3,3,3,3,3,3,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,2,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,2,2,2,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,3,3,3,3,3,3,3,3,3,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,2,2,2,2,2,2,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,4,4,4,4,4,4,4,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,4,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,2,2,1,4,4,4,4,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,0,0,0,0,1,1,1,1,0,0,0,3,3,3,3,3,3,3,3,3,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,2,1,1,1,1,2,1,1,1,1,2,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,7,1,1,1,1,1,1,1,1,1,1,4,4,4,1,4,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,2,2,2,1,1,2,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,1,1,0,0,0,0,3,3,3,3,3,3,3,3,3,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,2,2,2,1,1,2,2,2,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,7,7,7,7,7,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,2,2,2,2,1,1,2,2,2,2,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,2,2,1,2,2,2,2,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,7,7,7,7,7,1,1,1,1,1,4,4,4,4,4,4,4,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,2,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,2,2,1,1,2,2,2,2,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,7,7,7,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,2,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,7,7,7,1,1,1,1,1,1,1,4,4,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,3,3,3,3,3,3,3,3,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,7,1,7,1,1,1,1,1,1,1,5,5,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,3,3,3,3,3,3,3,3,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,5,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,7,7,7,7,1,1,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,2,2,2,1,1,5,5,5,2,2,2,2,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,3,3,3,3,3,3,3,3,3,0,0,0,1,1,1,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,5,5,5,5,2,2,5,2,1,5,1,1,5,5,5,5,5,1,1,1,1,1,6,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,7,5,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,3,3,3,3,3,3,3,3,3,0,0,1,1,1,1,1,1,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,7,7,6,5,6,5,5,5,5,1,5,5,1,1,1,1,1,1,4,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,2,2,2,2,2,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,7,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,3,3,3,3,3,3,3,3,0,0,0,1,1,1,1,1,1,1,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,7,7,7,7,7,5,5,5,5,5,5,5,5,5,1,1,1,1,4,4,4,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,2,2,2,2,2,5,5,5,5,2,2,5,2,1,5,1,1,5,1,1,5,1,1,1,1,1,1,6,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,7,7,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,3,3,3,3,3,3,3,3,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,7,7,5,5,7,7,7,7,7,5,5,5,5,5,5,5,5,5,1,1,1,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,5,5,5,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,7,7,7,7,7,7,7,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,3,3,3,3,3,3,3,3,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,2,2,2,2,2,2,1,1,4,4,1,1,1,1,1,1,7,7,7,7,7,7,7,7,7,7,5,1,5,5,5,5,1,5,1,1,1,1,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,5,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,5,5,7,7,7,7,7,7,7,7,5,5,5,1,1,1,1,1,1,1,2,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,3,3,3,3,3,3,3,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,2,2,2,2,2,2,1,1,4,4,4,4,1,1,1,1,7,7,7,7,7,7,7,7,7,7,7,7,7,5,5,5,5,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,7,7,7,1,1,7,7,5,5,5,5,1,1,1,1,1,1,2,2,2,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,3,3,3,3,3,3,3,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,2,2,2,2,2,1,4,4,4,1,1,4,4,7,7,7,7,7,7,7,7,7,1,7,7,7,7,5,5,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,5,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,7,7,7,1,1,1,1,1,5,5,1,1,1,1,1,1,2,1,2,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,0,1,1,0,0,0,3,3,3,3,3,3,3,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,4,4,4,4,4,4,7,7,7,4,4,1,1,1,1,1,5,7,7,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,5,5,7,7,7,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,6,7,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,0,0,0,0,0,0,3,3,3,3,3,3,3,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,2,2,1,1,4,4,4,4,4,4,4,7,4,4,4,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,6,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,4,1,1,4,4,4,4,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,1,6,1,6,1,1,1,1,6,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,2,2,2,2,1,2,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,6,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,4,4,4,1,1,1,1,1,1,1,5,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,2,1,1,1,2,2,2,2,2,2,1,2,2,2,2,1,2,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,7,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,4,1,4,4,4,1,1,1,1,1,1,1,1,1,2,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,6,6,6,6,6,1,6,1,6,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,2,2,2,1,1,2,2,2,2,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,2,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,6,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,2,2,2,2,1,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,7,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,6,6,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,4,4,1,1,1,1,1,1,1,1,1,1,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,7,7,5,5,5,5,5,5,1,1,1,1,1,1,6,6,6,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,6,1,1,6,6,6,2,2,1,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,7,7,7,1,1,1,1,1,2,2,2,2,2,2,2,2,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,7,7,7,7,5,5,5,5,5,1,1,1,1,1,6,6,6,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,6,2,1,2,1,1,2,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,7,1,1,1,1,1,1,1,2,2,2,2,2,2,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,7,7,5,5,5,5,5,1,1,1,1,1,1,1,6,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,6,1,1,1,1,6,6,2,2,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,2,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,7,7,7,1,5,5,5,5,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,0,0,3,3,3,3,3,3,3,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,5,5,7,7,7,1,1,5,5,5,5,1,1,1,1,1,1,6,1,1,1,1,1,1,1,2,2,2,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,5,7,7,4,4,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,2,2,2,1,2,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,2,1,2,1,5,5,1,1,1,1,1,5,5,7,5,1,1,1,1,1,1,2,2,2,2,2,2,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,7,7,7,7,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,5,5,5,5,1,1,1,5,5,7,7,7,5,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,5,5,5,5,5,5,1,5,1,7,7,7,7,5,1,1,1,2,2,2,1,1,2,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,4,1,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,2,2,2,2,2,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,2,2,1,1,1,1,5,5,5,5,5,5,5,5,5,5,7,7,7,7,1,1,1,2,2,2,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,5,5,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,5,5,7,1,5,1,7,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,5,5,5,7,1,1,7,7,5,5,7,7,7,7,1,1,1,2,2,2,2,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,7,7,7,7,7,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,7,1,7,7,7,5,7,7,7,7,1,5,5,5,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,5,5,7,7,7,7,7,7,7,7,7,5,7,1,1,7,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,7,7,7,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,0,1,0,0,0,0,0,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,7,1,7,7,7,1,7,1,7,7,7,7,7,7,5,5,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,5,7,7,7,7,5,5,7,7,7,7,7,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,7,7,7,7,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,0,0,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,4,4,1,1,1,1,7,7,7,7,1,7,1,1,1,1,7,7,7,7,7,5,5,5,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,5,7,7,5,5,5,1,1,7,7,1,1,1,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,0,0,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,4,1,1,7,7,7,7,1,1,1,1,1,1,1,7,7,7,7,7,5,5,5,5,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,0,0,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,4,1,2,4,4,4,1,1,7,1,1,1,1,1,1,1,1,1,1,7,7,7,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,0,0,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,4,1,2,2,2,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,0,3,3,3,3,3,3,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,4,4,4,2,2,2,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,5,5,2,2,4,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,0,0,3,3,3,3,3,3,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,4,4,4,1,1,2,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,4,4,4,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,0,3,3,3,3,3,3,0,0,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,4,1,4,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,2,2,2,2,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,6,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,0,0,3,3,3,3,3,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,2,1,2,2,2,1,1,1,1,1,1,4,4,4,4,4,4,1,4,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,4,4,2,2,2,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,0,0,3,3,3,3,3,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,4,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,2,2,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,2,1,1,1,1,1,1,1,0,3,3,3,3,3,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,2,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,2,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,6,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,2,2,2,1,1,1,1,1,0,0,3,3,3,3,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,2,2,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,2,2,2,1,1,1,1,1,1,0,3,3,3,3,3,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,2,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,2,2,2,1,1,1,1,1,1,0,3,3,3,3,3,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,2,4,2,4,4,4,4,4,4,4,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,0,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,2,1,2,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,2,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,0,0,0,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,2,2,2,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,4,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,0,0,0,3,3,3,3,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,4,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,0,0,3,3,3,3,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,2,1,2,1,2,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,3,3,3,3,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,1,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,3,3,3,3,3,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,2,2,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,3,3,3,3,3,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,5,5,5,5,5,5,5,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,4,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,3,3,3,3,3,3,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,4,4,1,4,1,1,4,1,4,4,4,4,1,5,5,5,5,5,5,5,5,5,2,5,2,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,2,2,2,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,4,1,7,4,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,1,4,4,4,4,4,4,1,4,4,4,4,4,1,4,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,3,3,3,3,3,3,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,4,1,1,5,5,5,5,5,5,5,5,5,1,7,7,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,2,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,2,1,1,2,2,2,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,5,5,4,5,1,1,1,1,1,5,5,5,5,5,7,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,5,5,1,1,1,1,1,4,4,4,4,4,4,1,1,1,4,4,4,1,4,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,3,3,3,3,3,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,4,4,4,1,4,1,1,4,1,1,1,1,1,5,5,5,1,1,5,5,5,1,7,7,7,7,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,2,2,2,1,2,2,2,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,5,5,5,5,5,5,5,1,7,5,1,5,5,5,5,7,7,7,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,4,4,4,4,4,1,4,1,1,1,1,1,4,4,4,1,4,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,3,3,3,3,3,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,2,1,2,2,2,2,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,5,5,5,5,1,7,7,7,1,1,5,5,5,1,1,1,1,1,1,1,1,1,6,6,6,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,2,2,1,1,2,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,5,5,5,5,5,1,5,1,7,7,7,5,5,5,5,1,5,7,7,7,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,1,1,1,1,4,4,4,4,4,4,4,4,1,1,1,1,1,4,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,3,3,3,3,3,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,5,5,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,4,1,4,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,2,2,2,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,4,5,1,5,1,1,1,1,1,7,5,1,7,5,1,1,5,5,7,7,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,5,5,5,5,7,1,1,1,4,4,4,4,4,4,4,1,1,1,1,4,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,2,1,2,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,3,3,3,3,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,2,1,4,2,4,2,1,4,4,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,5,5,5,2,2,2,7,7,7,1,1,1,1,1,1,1,1,1,6,1,6,6,6,6,6,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,4,4,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,1,1,5,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,5,5,7,7,7,1,1,1,4,4,4,4,4,4,1,4,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,3,3,3,3,3,0,0,0,0,1,1,1,1,1,1,1,1,1,2,2,2,4,4,1,4,1,4,4,4,4,4,4,4,4,4,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,5,5,5,7,7,7,2,7,7,7,1,1,1,6,6,1,1,6,6,6,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,4,4,1,4,1,4,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,4,4,4,4,1,1,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,7,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,1,1,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,1,1,1,5,1,7,7,7,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,2,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,3,3,3,3,3,0,0,0,0,0,1,1,1,1,1,1,1,2,1,2,2,4,4,4,4,4,4,1,4,2,4,2,2,4,4,4,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,5,5,7,7,7,7,7,7,7,7,1,1,6,6,6,6,1,1,6,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,4,4,4,4,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,1,1,1,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,1,1,1,4,4,1,4,4,4,4,4,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,3,3,3,3,3,3,3,0,0,0,0,0,1,1,1,1,1,1,2,2,2,2,4,4,4,4,1,4,1,1,2,2,2,2,2,4,4,4,1,4,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,5,5,5,7,7,7,7,7,7,1,1,1,1,6,6,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,1,1,4,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,4,4,4,4,4,1,1,1,1,1,1,1,5,5,5,5,5,5,5,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,1,1,1,1,1,1,1,1,4,4,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,3,3,3,3,3,3,0,0,0,0,0,1,1,1,1,1,1,1,2,2,2,1,2,4,2,2,1,1,1,1,2,2,2,2,4,4,4,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,5,7,7,7,4,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,2,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,5,5,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,3,3,3,3,3,3,0,0,0,0,0,0,1,1,1,1,1,1,2,2,2,1,1,2,2,2,2,2,1,1,1,2,2,2,4,4,4,1,1,1,1,1,5,5,5,1,1,7,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,7,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,5,5,5,5,5,5,5,5,1,1,5,2,5,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,3,3,3,3,3,3,0,0,0,0,0,0,1,1,1,1,1,1,2,2,2,2,2,1,1,2,2,2,1,1,1,1,1,2,1,4,4,1,1,1,1,1,1,5,5,5,5,7,7,7,5,5,1,1,1,1,1,1,1,2,2,2,2,7,7,7,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,5,1,5,5,5,5,5,5,5,5,5,5,5,4,2,2,2,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,4,4,4,1,1,1,1,1,1,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,3,3,3,3,0,0,0,0,0,0,0,0,1,1,1,1,2,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,5,5,5,7,7,7,7,5,5,5,1,1,1,1,1,1,2,2,2,7,7,7,1,1,4,4,4,4,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,5,5,5,5,7,5,5,5,1,1,5,2,5,4,4,4,2,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,4,4,4,4,4,1,4,4,4,4,1,1,1,1,1,1,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,3,3,3,3,0,0,0,0,0,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,5,5,5,5,7,7,7,5,5,5,5,1,1,1,1,1,7,7,7,7,7,7,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,5,5,5,5,7,7,7,5,5,1,1,1,1,2,2,4,2,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,2,4,4,4,4,1,4,1,4,4,4,4,1,1,1,1,1,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,3,3,3,0,0,0,1,1,1,1,1,1,1,1,1,2,2,2,2,1,2,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,4,4,4,4,1,1,1,5,5,1,7,7,7,5,1,5,5,1,1,1,1,7,7,7,7,7,7,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,5,5,5,7,7,7,5,5,1,1,1,1,2,2,2,2,2,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,5,5,7,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,4,1,1,1,1,1,1,1,1,1,7,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,3,3,3,3,0,0,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,7,7,7,1,1,5,5,5,1,1,1,1,7,7,7,7,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,2,2,1,2,2,2,2,2,5,5,2,7,7,5,5,1,1,1,1,1,2,2,2,2,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,5,5,7,7,7,5,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,3,3,3,3,0,0,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,4,4,4,1,4,1,4,1,1,4,4,4,4,1,1,1,1,1,1,1,7,7,7,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,1,2,1,1,7,7,7,7,1,1,1,1,1,1,1,1,2,4,4,4,4,2,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,5,5,7,7,7,7,5,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,3,3,3,3,0,0,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,7,7,7,1,1,5,5,5,1,5,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,7,7,7,7,1,1,1,1,1,1,1,1,1,4,4,2,2,2,2,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,5,5,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,3,3,3,0,0,0,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,4,4,4,4,4,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,7,7,7,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,5,5,7,7,7,7,7,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,3,3,3,3,0,0,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,4,4,4,4,1,1,4,4,4,4,4,4,4,1,1,1,1,1,4,4,4,7,7,7,7,7,5,1,5,5,5,5,5,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,7,7,7,7,7,7,1,7,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,7,7,7,7,7,7,7,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,6,6,6,6,1,1,6,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,3,3,3,3,0,0,0,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,2,1,1,1,2,2,1,4,4,1,1,1,4,4,4,4,4,4,1,1,1,1,1,4,4,4,4,4,7,7,7,7,7,5,5,5,5,5,5,5,1,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,7,7,7,7,7,7,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,6,6,1,1,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,4,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,3,3,3,3,3,0,0,0,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,2,2,2,2,2,2,2,2,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,4,4,4,4,4,7,7,7,7,7,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,7,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,7,7,7,5,1,5,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,1,6,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,3,3,3,3,0,0,0,0,1,1,1,1,1,1,1,1,1,2,1,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,7,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,2,1,1,1,1,1,1,1,1,1,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,6,1,6,6,1,1,1,1,6,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,3,3,3,3,3,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,2,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,1,2,1,7,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,6,6,6,6,6,6,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,4,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,3,3,3,3,3,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,2,1,1,2,1,1,2,2,2,2,2,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,4,1,1,1,1,2,2,1,1,1,1,1,6,1,6,6,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,4,1,1,4,4,4,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,3,3,3,3,3,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,2,2,2,2,2,2,2,2,2,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,4,4,4,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,6,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,3,3,3,3,3,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,2,2,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,2,1,1,2,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,4,4,4,1,1,2,2,2,2,2,2,2,1,1,1,1,1,6,6,6,6,1,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,4,1,1,4,4,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,3,3,3,3,3,3,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,2,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,4,4,4,4,4,4,4,4,1,1,2,2,2,2,2,2,2,1,2,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,3,3,3,3,3,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,6,1,6,1,6,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,4,1,4,4,4,4,1,1,1,1,1,2,2,2,1,2,2,2,2,2,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,4,4,4,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,3,3,3,3,3,3,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,2,2,2,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,6,1,1,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,2,1,2,2,2,2,2,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,3,3,3,3,3,3,3,3,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,2,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,7,7,1,7,7,7,1,1,1,1,1,7,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,1,1,6,1,6,1,6,1,6,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,2,4,4,4,4,1,1,2,1,1,2,2,2,2,2,1,2,2,2,2,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,3,3,3,3,3,3,3,3,3,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,7,7,7,7,7,7,7,7,7,1,7,7,7,7,1,1,1,1,6,6,6,6,6,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,2,2,4,4,4,2,2,2,2,2,2,2,2,2,2,2,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,4,4,4,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,0,0,0,0,3,3,3,3,3,3,3,3,3,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,7,7,5,7,7,7,7,7,7,7,7,7,1,1,1,1,1,1,6,1,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,1,1,2,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,0,0,0,0,3,3,3,3,3,3,3,3,3,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,5,5,5,5,5,5,5,7,1,7,7,7,7,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,3,3,3,3,3,3,3,3,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,1,1,7,1,1,1,1,1,1,1,1,1,1,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,0,0,0,0,3,3,3,3,3,3,3,3,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,3,3,3,3,3,3,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,1,1,1,2,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,3,3,3,3,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,];
}

function getTilePallet()
{
	return ["alpine_shore_rocks_grass_50","new_alpine_grass_d","new_alpine_grass_e","alpine_shore_rocks","new_alpine_grass_c","alpine_grass","new_alpine_grass_b","alpine_grass_a",];
}
