/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.graphics;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.emboss.jemboss.graphics.Graph2DPlot;
import org.emboss.jemboss.gui.ScrollPanel;

public class PrintPlot
extends ScrollPanel {
    private Graph2DPlot plot;

    public PrintPlot(Graph2DPlot plot) {
        this.plot = plot;
    }

    public void print() {
        String cwd = System.getProperty("user.dir");
        JFileChooser fc = new JFileChooser(cwd);
        File fselect = new File(cwd + System.getProperty("file.separator") + "jemboss.png");
        fc.setSelectedFile(fselect);
        Box YBox = Box.createVerticalBox();
        JLabel labFormat = new JLabel("Select Format:");
        Font font = labFormat.getFont();
        labFormat.setFont(font.deriveFont(1));
        YBox.add(labFormat);
        Box bacross = Box.createHorizontalBox();
        JComboBox<String> formatSelect = new JComboBox<String>(ImageIO.getWriterFormatNames());
        formatSelect.setSelectedItem("png");
        Dimension d = formatSelect.getPreferredSize();
        formatSelect.setMaximumSize(d);
        bacross.add(Box.createHorizontalGlue());
        bacross.add(formatSelect);
        YBox.add(bacross);
        fc.setAccessory(YBox);
        int n = fc.showSaveDialog(null);
        if (n == 1) {
            return;
        }
        String fsave = fc.getSelectedFile().getAbsolutePath().toLowerCase();
        if (fsave.endsWith(".png") || fsave.endsWith(".jpg") || fsave.endsWith(".jpeg")) {
            int ind = fsave.lastIndexOf(".");
            fsave = fc.getSelectedFile().getAbsolutePath();
            fsave = fsave.substring(0, ind);
        } else {
            fsave = fc.getSelectedFile().getAbsolutePath();
        }
        String ftype = (String)formatSelect.getSelectedItem();
        try {
            RenderedImage rendImage = this.createImage();
            this.writeImageToFile(rendImage, new File(fsave + "." + ftype), ftype);
        }
        catch (NoClassDefFoundError ex) {
            JOptionPane.showMessageDialog(this, "This option requires Java 1.4 or higher.");
        }
    }

    private RenderedImage createImage() {
        BufferedImage bufferedImage = new BufferedImage(this.plot.getWidth(), this.plot.getHeight(), 1);
        Graphics2D g2d = bufferedImage.createGraphics();
        this.plot.printComponent(g2d);
        return bufferedImage;
    }

    private void writeImageToFile(RenderedImage image, File file, String type) {
        try {
            ImageIO.write(image, type, file);
        }
        catch (IOException e) {
            System.out.println("Java 1.4+ is required");
            e.printStackTrace();
        }
    }
}

