#include <string.h>
#include "crypto_additions.h"
#include "sc.h"

/* l = order of base point = 2^252 + 27742317777372353535851937790883648493 */

/*
static unsigned char l[32] = {0xed, 0xd3, 0xf5, 0x5c, 0x1a, 0x63, 0x12, 0x58,
                              0xd6, 0x9c, 0xf7, 0xa2, 0xde, 0xf9, 0xde, 0x14,
                              0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                              0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0, 0x10};
*/

static unsigned char lminus1[32] = {0xec, 0xd3, 0xf5, 0x5c, 0x1a, 0x63, 0x12, 0x58,
                                    0xd6, 0x9c, 0xf7, 0xa2, 0xde, 0xf9, 0xde, 0x14,
                                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10};

/* b = -a (mod l) */
void sc_neg(unsigned char *b, const unsigned char *a)
{
  unsigned char zero[32];
  memset(zero, 0, 32);
  sc_muladd(b, lminus1, a, zero); /* b = (-1)a + 0   (mod l) */
}
