# Generates version include file.

from outpututils import rewriteIfChanged
from version import extractRevision, packageVersion, releaseFlag

import sys

def iterVersionInclude():
	revision = extractRevision()

	yield '// Automatically generated by build process.'
	yield 'const bool Version::RELEASE = %s;' % str(releaseFlag).lower()
	yield 'const std::string Version::VERSION = "%s";' % packageVersion
	yield 'const std::string Version::REVISION = "%s";' % revision

if __name__ == '__main__':
	if len(sys.argv) == 2:
		rewriteIfChanged(sys.argv[1], iterVersionInclude())
	else:
		print('Usage: python3 version2code.py VERSION_HEADER', file=sys.stderr)
		sys.exit(2)
