# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.migrationassessment.aio import MigrationAssessmentMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestMigrationAssessmentMgmtImportCollectorsOperationsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(MigrationAssessmentMgmtClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_import_collectors_operations_list_by_assessment_project(self, resource_group):
        response = self.client.import_collectors_operations.list_by_assessment_project(
            resource_group_name=resource_group.name,
            project_name="str",
            api_version="2023-03-15",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_import_collectors_operations_get(self, resource_group):
        response = await self.client.import_collectors_operations.get(
            resource_group_name=resource_group.name,
            project_name="str",
            import_collector_name="str",
            api_version="2023-03-15",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_import_collectors_operations_begin_create(self, resource_group):
        response = await (
            await self.client.import_collectors_operations.begin_create(
                resource_group_name=resource_group.name,
                project_name="str",
                import_collector_name="str",
                resource={
                    "id": "str",
                    "name": "str",
                    "properties": {
                        "createdTimestamp": "2020-02-20 00:00:00",
                        "discoverySiteId": "str",
                        "provisioningState": "str",
                        "updatedTimestamp": "2020-02-20 00:00:00",
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "type": "str",
                },
                api_version="2023-03-15",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_import_collectors_operations_delete(self, resource_group):
        response = await self.client.import_collectors_operations.delete(
            resource_group_name=resource_group.name,
            project_name="str",
            import_collector_name="str",
            api_version="2023-03-15",
        )

        # please add some check logic here by yourself
        # ...
