% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/irwsva.build.R
\name{irwsva.build}
\alias{irwsva.build}
\title{A function for estimating surrogate variables by estimating empirical control probes}
\usage{
irwsva.build(dat, mod, mod0 = NULL, n.sv, B = 5)
}
\arguments{
\item{dat}{The transformed data matrix with the variables in rows and samples in columns}

\item{mod}{The model matrix being used to fit the data}

\item{mod0}{The null model being compared when fitting the data}

\item{n.sv}{The number of surogate variables to estimate}

\item{B}{The number of iterations of the irwsva algorithm to perform}
}
\value{
sv The estimated surrogate variables, one in each column

pprob.gam: A vector of the posterior probabilities each gene is affected by heterogeneity

pprob.b A vector of the posterior probabilities each gene is affected by mod

n.sv The number of significant surrogate variables
}
\description{
This function is the implementation of the iteratively re-weighted least squares
approach for estimating surrogate variables. As a buy product, this function
produces estimates of the probability of being an empirical control. See the function
\code{\link{empirical.controls}} for a direct estimate of the empirical controls.
}
\examples{
library(bladderbatch)
data(bladderdata)
dat <- bladderEset[1:5000,]

pheno = pData(dat)
edata = exprs(dat)
mod = model.matrix(~as.factor(cancer), data=pheno)

n.sv = num.sv(edata,mod,method="leek")
res <- irwsva.build(edata, mod, mod0 = NULL,n.sv,B=5) 

}
